# write [![NPM version](https://badge.fury.io/js/write.svg)](http://badge.fury.io/js/write)  [![Build Status](https://travis-ci.org/jonschlinkert/write.svg)](https://travis-ci.org/jonschlinkert/write)

> Write files to disk, creating intermediate directories if they don't exist.

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i write --save
```

## API docs

### [writeFile](index.js#L32)

Asynchronously write a file to disk. Creates any intermediate directories if they don't already exist.

**Params**

* `dest` **{String}**: Destination file path
* `str` **{String}**: String to write to disk.
* `callback` **{Function}**

**Example**

```js
var writeFile = require('write');
writeFile('foo.txt', 'This is content to write.', function(err) {
  if (err) console.log(err);
});
```

### [.writeFile.sync](index.js#L64)

Synchronously write files to disk. Creates any intermediate directories if they don't already exist.

**Params**

* `dest` **{String}**: Destination file path
* `str` **{String}**: String to write to disk.

**Example**

```js
var writeFile = require('write');
writeFile.sync('foo.txt', 'This is content to write.');
```

### [.writeFile.stream](index.js#L87)

Uses `fs.createWriteStream`, but also creates any intermediate directories if they don't already exist.

**Params**

* `dest` **{String}**: Destination file path
* `returns` **{Stream}**: Returns a write stream.

**Example**

```js
var write = require('write');
write.stream('foo.txt');
```

## Related

* [delete](https://github.com/jonschlinkert/delete): Delete files and folders and any intermediate directories if they exist (sync and async).
* [read-yaml](https://github.com/jonschlinkert/read-yaml): Very thin wrapper around js-yaml for directly reading in YAML files.
* [read-json](https://github.com/azer/read-json): Reads and parses a JSON file.
* [read-data](https://github.com/jonschlinkert/read-data): Read JSON or YAML files.
* [write-yaml](https://github.com/jonschlinkert/write-yaml): Write YAML. Converts JSON to YAML writes it to the specified file.
* [write-json](https://github.com/jonschlinkert/write-json): Write a JSON to file disk, also creates directories in the dest path if they… [more](https://github.com/jonschlinkert/write-json)

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/write/issues/new)

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on July 29, 2015._

<!-- deps:mocha -->