/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.AppletMenu;
import WIMSchem.DialogEdit;
import WIMSchem.DraggableMolecule;
import WIMSchem.EditorPane;
import WIMSchem.FileExtFilter;
import WIMSchem.FileMolPreview;
import WIMSchem.MainApplet;
import WIMSchem.MainWindow;
import WIMSchem.MolSelectListener;
import WIMSchem.Molecule;
import WIMSchem.MoleculeStream;
import WIMSchem.SVGMolecule;
import WIMSchem.SaveListener;
import WIMSchem.TemplSelectListener;
import WIMSchem.TemplateSelector;
import WIMSchem.Templates;
import WIMSchem.ToolButton;
import WIMSchem.ds.DataSheetStream;
import WIMSchem.ds.DataWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class MainPanel
extends JPanel
implements ActionListener,
MouseListener,
WindowListener,
KeyListener,
ClipboardOwner,
TemplSelectListener,
MolSelectListener {
    public static final String LICENSE = "This program is free software; you can redistribute it and/or modify\nit under the terms of the GNU General Public License as published by\nthe Free Software Foundation; either version 2 of the License, or\n(at your option) any later version.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License\nalong with this program; if not, write to the Free Software\nFoundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA\n\nor see http://www.gnu.org for details.";
    public static final String VERSION = "SketchEl 1.21 WIMSversion 0.2 SVG export";
    private JFrame frameParent;
    public ImageIcon mainIcon = null;
    public ImageIcon mainLogo = null;
    private static final int TOOL_CURSOR = 0;
    private static final int TOOL_ROTATOR = 1;
    private static final int TOOL_ERASOR = 2;
    private static final int TOOL_DIALOG = 3;
    private static final int TOOL_EDIT = 4;
    private static final int TOOL_SETATOM = 5;
    private static final int TOOL_SINGLE = 6;
    private static final int TOOL_DOUBLE = 7;
    private static final int TOOL_TRIPLE = 8;
    private static final int TOOL_ZERO = 9;
    private static final int TOOL_INCLINED = 10;
    private static final int TOOL_DECLINED = 11;
    private static final int TOOL_UNKNOWN = 12;
    private static final int TOOL_CHARGE = 13;
    private static final int TOOL_UNDO = 14;
    private static final int TOOL_REDO = 15;
    private static final int TOOL_TEMPLATE = 16;
    private static final int TOOL_CUT = 17;
    private static final int TOOL_COPY = 18;
    private static final int TOOL_PASTE = 19;
    private static final int TOOL_SELECT = 20;
    private static final int TOOL_UNSELECT = 21;
    public static int TOOL_COUNT = 22;
    public String[] myAtoms;
    public boolean ATOM_BUTTONS = false;
    private Properties translation;
    public int MENU_COUNT = 8;
    private static final String[] IMAGE_TOOL = new String[]{"Cursor", "Rotator", "Erasor", "EDialog", "AEdit", "ASelect", "BSingle", "BDouble", "BTriple", "BZero", "BInclined", "BDeclined", "BUnknown", "ACharge", "Undo", "Redo", "Template", "ECut", "ECopy", "EPaste", "Select", "UnSelect", "BUnknown", "BUnknown"};
    public static boolean[] TOOL_SELECTION = new boolean[]{true, true, true, false, true, true, true, true, true, true, true, true, true, true, false, false, true, false, false, false, false, false};
    public static boolean[] MENU_SELECTION = new boolean[]{true, true, true, true, true, true, true, true};
    private AbstractButton[] atomlistButtons;
    private ButtonGroup atomlistGroup;
    private AbstractButton[] toolButtons;
    private ButtonGroup toolGroup;
    private ImageIcon[] toolIcons;
    public EditorPane editor;
    private Templates templ;
    private JCheckBoxMenuItem chkShowHydr;
    private JCheckBoxMenuItem chkShowSter;
    private DraggableMolecule dragMol = null;
    private boolean firstResize = true;
    private String filename = null;
    private String lastElement = null;
    private String typedElement = "";
    private Molecule lastTemplate = null;
    private int templateIdx = -1;
    public static boolean appletMode = false;
    private boolean streamMode = false;
    private boolean slaveMode = false;
    private boolean useLocalClipboard = false;
    private String appletClipboard = "";
    private SaveListener saver = null;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_STREAM = 1;
    public static final int MODE_APPLET = 2;
    public static final int MODE_SLAVE = 3;

    public MainPanel(String LoadFN, int Mode, JFrame FrameParent) {
        this.streamMode = Mode == 1;
        appletMode = Mode == 2;
        this.slaveMode = Mode == 3;
        this.frameParent = FrameParent;
        if (appletMode) {
            this.translation = this.loadProperties(MainApplet.language.toString());
            TOOL_SELECTION = MainApplet.TOOL_SELECTION;
            TOOL_COUNT = TOOL_SELECTION.length;
            MENU_SELECTION = MainApplet.MENU_SELECTION;
            this.MENU_COUNT = MENU_SELECTION.length;
            this.myAtoms = MainApplet.myAtoms;
            this.ATOM_BUTTONS = MainApplet.ATOM_BUTTONS;
            this.mainIcon = new ImageIcon(this.getClass().getResource("/images/wims_icon.gif"));
            this.mainLogo = new ImageIcon(this.getClass().getResource("/images/wims_logo.gif"));
        } else {
            for (int i = 0; i < TOOL_COUNT; ++i) {
                MainPanel.TOOL_SELECTION[i] = true;
            }
            this.mainIcon = new ImageIcon(this.getClass().getResource("/images/MainIcon.png"));
            this.mainLogo = new ImageIcon(this.getClass().getResource("/images/MainLogo.png"));
            this.translation = this.loadProperties("en");
        }
        if (this.myAtoms == null) {
            this.myAtoms = new String[]{"C", "N", "O", "H", "F", "Cl", "Br", "I", "S", "P", "Na", "K", "Mg", "Ca", "Fe", "Si"};
        }
        this.useLocalClipboard = appletMode;
        this.templ = new Templates(this.getClass());
        int num_atoms = this.myAtoms.length;
        JToolBar atomlist = new JToolBar(0);
        atomlist.setFloatable(true);
        this.atomlistButtons = new AbstractButton[num_atoms];
        this.atomlistGroup = new ButtonGroup();
        Font f = new Font("Dialog", 0, 24);
        atomlist.setFont(f);
        if (this.ATOM_BUTTONS && appletMode && TOOL_SELECTION[5]) {
            for (int n = 0; n < num_atoms; ++n) {
                this.atomlistButtons[n] = new JButton(this.myAtoms[n]);
                this.atomlistGroup.add(this.atomlistButtons[n]);
                atomlist.add(this.atomlistButtons[n]);
                this.atomlistButtons[n].addActionListener(this);
                this.atomlistButtons[n].setToolTipText("element" + this.myAtoms[n]);
                this.atomlistButtons[n].setBorderPainted(false);
            }
        }
        JToolBar tools = new JToolBar(1);
        tools.setFloatable(true);
        this.toolButtons = new AbstractButton[TOOL_COUNT];
        this.toolIcons = new ImageIcon[TOOL_COUNT];
        this.toolGroup = new ButtonGroup();
        for (int n = 0; n < TOOL_COUNT; ++n) {
            if (!TOOL_SELECTION[n]) continue;
            this.toolIcons[n] = new ImageIcon(this.getClass().getResource("/images/" + IMAGE_TOOL[n] + ".png"));
            this.toolButtons[n] = new ToolButton(this.toolIcons[n]);
            this.toolGroup.add(this.toolButtons[n]);
            tools.add(this.toolButtons[n]);
            this.toolButtons[n].addActionListener(this);
            this.toolButtons[n].setToolTipText(this.getToolTips(n));
        }
        if (TOOL_SELECTION[0]) {
            this.toolGroup.setSelected(this.toolButtons[0].getModel(), true);
        }
        if (TOOL_SELECTION[5]) {
            this.toolButtons[5].addMouseListener(this);
            this.toolButtons[5].addKeyListener(this);
            this.selectElement("C");
        }
        if (TOOL_SELECTION[16]) {
            this.toolButtons[16].addMouseListener(this);
        }
        JMenuBar menubar = appletMode ? this.menuBarApplet() : this.menuBarApplication();
        this.editor = new EditorPane();
        this.editor.setMolSelectListener(this);
        this.editor.enableDnD();
        JScrollPane scroll = new JScrollPane(this.editor);
        if (!appletMode) {
            this.setLayout(new BorderLayout());
            this.add((Component)scroll, "Center");
            this.add((Component)menubar, "North");
            this.add((Component)tools, "West");
        } else {
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add((Component)menubar, "North");
            this.setLayout(new BorderLayout());
            this.add((Component)tools, "West");
            if (this.ATOM_BUTTONS) {
                this.add((Component)atomlist, "South");
            }
            this.add((Component)scroll, "East");
            this.add((Component)p, "Center");
            p.add((Component)scroll, "Center");
        }
        this.editor.grabFocus();
        this.editor.setToolCursor();
        if (LoadFN != null) {
            try {
                FileInputStream istr = new FileInputStream(LoadFN);
                Molecule frag = MoleculeStream.readUnknown(istr);
                this.editor.addArbitraryFragment(frag);
                istr.close();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, e.toString(), "Open Failed", 0);
                return;
            }
            this.setFilename(LoadFN);
            this.editor.notifySaved();
        }
        if (this.streamMode) {
            this.readStream();
        }
        this.addKeyListener(this);
        this.editor.addKeyListener(this);
        if (this.frameParent != null) {
            this.frameParent.addWindowListener(this);
        }
        if (!appletMode) {
            this.dragMol = new DraggableMolecule(this.editor);
            menubar.add(this.dragMol);
        }
    }

    public void setSaveListener(SaveListener saver) {
        this.saver = saver;
    }

    private JMenuBar menuBarApplication() {
        JMenuBar menubar = new JMenuBar();
        JMenu menufile = new JMenu(this.translation.getProperty("File"));
        menufile.setMnemonic(70);
        menufile.add(this.menuItem(this.translation.getProperty("New"), 78, null, KeyStroke.getKeyStroke(78, 2)));
        menufile.add(this.menuItem(this.translation.getProperty("New_Window"), 87, null, KeyStroke.getKeyStroke(78, 3)));
        menufile.add(this.menuItem(this.translation.getProperty("New_DataSheet"), 68, null));
        menufile.add(this.menuItem(this.translation.getProperty("Open"), 79, null, KeyStroke.getKeyStroke(79, 2)));
        if (!this.streamMode) {
            menufile.add(this.menuItem(this.translation.getProperty("Save"), 83, null, KeyStroke.getKeyStroke(83, 2)));
        }
        menufile.add(this.menuItem(this.translation.getProperty("Save_As"), 65));
        JMenu menuexport = new JMenu(this.translation.getProperty("Export"));
        menuexport.setMnemonic(88);
        menuexport.add(this.menuItem(this.translation.getProperty("as_MDL_MOL"), 77, null, KeyStroke.getKeyStroke(77, 3)));
        menuexport.add(this.menuItem(this.translation.getProperty("as_CML_XML"), 88, null, KeyStroke.getKeyStroke(88, 3)));
        menuexport.add(this.menuItem(this.translation.getProperty("as_SVG"), 83, null, KeyStroke.getKeyStroke(83, 3)));
        menufile.add(menuexport);
        menufile.addSeparator();
        if (this.streamMode) {
            menufile.add(this.menuItem(this.translation.getProperty("Save_and_Quit"), 81, null, KeyStroke.getKeyStroke(81, 2)));
        } else if (this.slaveMode) {
            menufile.add(this.menuItem(this.translation.getProperty("Close"), 67, null, KeyStroke.getKeyStroke(87, 2)));
        } else {
            menufile.add(this.menuItem(this.translation.getProperty("Quit"), 81, null, KeyStroke.getKeyStroke(81, 2)));
        }
        JMenu menuedit = new JMenu(this.translation.getProperty("Edit"));
        menuedit.setMnemonic(69);
        menuedit.add(this.menuItem(this.translation.getProperty("Editttt"), 69, this.toolIcons[3], KeyStroke.getKeyStroke(32, 2)));
        menuedit.add(this.menuItem(this.translation.getProperty("Undo"), 85, this.toolIcons[14], KeyStroke.getKeyStroke(90, 2)));
        menuedit.add(this.menuItem(this.translation.getProperty("Redo"), 82, this.toolIcons[15], KeyStroke.getKeyStroke(90, 3)));
        menuedit.add(this.menuItem(this.translation.getProperty("Cut"), 88, this.toolIcons[17], KeyStroke.getKeyStroke(88, 2)));
        menuedit.add(this.menuItem(this.translation.getProperty("Copy"), 67, this.toolIcons[18], KeyStroke.getKeyStroke(67, 2)));
        menuedit.add(this.menuItem(this.translation.getProperty("Copy_SVG"), 86, null, KeyStroke.getKeyStroke(67, 3)));
        menuedit.add(this.menuItem(this.translation.getProperty("Paste"), 86, this.toolIcons[19], KeyStroke.getKeyStroke(86, 2)));
        menuedit.addSeparator();
        menuedit.add(this.menuItem(this.translation.getProperty("Select_All"), 83, null, KeyStroke.getKeyStroke(65, 2)));
        menuedit.add(this.menuItem(this.translation.getProperty("Next_Atom"), 78, null, KeyStroke.getKeyStroke(69, 2)));
        menuedit.add(this.menuItem(this.translation.getProperty("Previous_Atom"), 80, null, KeyStroke.getKeyStroke(69, 3)));
        menuedit.add(this.menuItem(this.translation.getProperty("Next_Group"), 71, null, KeyStroke.getKeyStroke(71, 2)));
        menuedit.add(this.menuItem(this.translation.getProperty("Previous_Group"), 82, null, KeyStroke.getKeyStroke(71, 3)));
        menuedit.addSeparator();
        menuedit.add(this.menuItem(this.translation.getProperty("Flip_Horizontal"), 72, null, null));
        menuedit.add(this.menuItem(this.translation.getProperty("Flip_Vertical"), 86, null, null));
        menuedit.add(this.menuItem(this.translation.getProperty("Rotate_P45"), 52, null, null));
        menuedit.add(this.menuItem(this.translation.getProperty("Rotate_M45"), 53, null, null));
        menuedit.add(this.menuItem(this.translation.getProperty("Rotate_P90"), 57, null, null));
        menuedit.add(this.menuItem(this.translation.getProperty("Rotate_M90"), 48, null, null));
        menuedit.addSeparator();
        menuedit.add(this.menuItem(this.translation.getProperty("Add_Temporary_Template"), 84, null, null));
        menuedit.add(this.menuItem(this.translation.getProperty("Normalise_Bond_Lengths"), 78, null, null));
        JMenu menuview = new JMenu(this.translation.getProperty("View"));
        menuview.setMnemonic(86);
        menuview.add(this.menuItem(this.translation.getProperty("Zoom_Full"), 70, null, KeyStroke.getKeyStroke(48, 2)));
        menuview.add(this.menuItem(this.translation.getProperty("Zoom_In"), 73, null, KeyStroke.getKeyStroke(61, 2)));
        menuview.add(this.menuItem(this.translation.getProperty("Zoom_Out"), 79, null, KeyStroke.getKeyStroke(45, 2)));
        menuview.addSeparator();
        ButtonGroup showBG = new ButtonGroup();
        menuview.add(this.radioMenuItem(this.translation.getProperty("Show_Elements"), 69, true, showBG));
        menuview.add(this.radioMenuItem(this.translation.getProperty("Show_All_Elements"), 65, false, showBG));
        menuview.add(this.radioMenuItem(this.translation.getProperty("Show_Indices"), 73, false, showBG));
        menuview.add(this.radioMenuItem(this.translation.getProperty("Show_Ring_ID"), 82, false, showBG));
        menuview.add(this.radioMenuItem(this.translation.getProperty("Show_CIP_Priority"), 67, false, showBG));
        menuview.add(this.radioMenuItem(this.translation.getProperty("Show_Mapping_Number"), 77, false, showBG));
        JMenu menutool = new JMenu(this.translation.getProperty("Tool"));
        menutool.setMnemonic(84);
        menutool.add(this.menuItem(this.translation.getProperty("Cursor"), 67, this.toolIcons[0], KeyStroke.getKeyStroke(27, 0)));
        menutool.add(this.menuItem(this.translation.getProperty("Rotator"), 82, this.toolIcons[1], KeyStroke.getKeyStroke(82, 2)));
        menutool.add(this.menuItem(this.translation.getProperty("Erasor"), 69, this.toolIcons[2], KeyStroke.getKeyStroke(68, 2)));
        menutool.add(this.menuItem(this.translation.getProperty("Edit_Atom"), 65, this.toolIcons[4], KeyStroke.getKeyStroke(44, 2)));
        menutool.add(this.menuItem(this.translation.getProperty("Set_Atom"), 83, new ImageIcon(this.getClass().getResource("/images/ASelMenu.png")), KeyStroke.getKeyStroke(46, 2)));
        menutool.add(this.menuItem(this.translation.getProperty("Single_Bond"), 49, this.toolIcons[6], KeyStroke.getKeyStroke(49, 2)));
        menutool.add(this.menuItem(this.translation.getProperty("Double_Bond"), 50, this.toolIcons[7], KeyStroke.getKeyStroke(50, 2)));
        menutool.add(this.menuItem(this.translation.getProperty("Triple_Bond"), 51, this.toolIcons[8], KeyStroke.getKeyStroke(51, 2)));
        menutool.add(this.menuItem(this.translation.getProperty("Zero_Bond"), 48, this.toolIcons[9], KeyStroke.getKeyStroke(48, 2)));
        menutool.add(this.menuItem(this.translation.getProperty("Inclined_Bond"), 73, this.toolIcons[10]));
        menutool.add(this.menuItem(this.translation.getProperty("Declined_Bond"), 68, this.toolIcons[11]));
        menutool.add(this.menuItem(this.translation.getProperty("Unknown_Bond"), 85, this.toolIcons[12]));
        menutool.add(this.menuItem(this.translation.getProperty("Charge"), 72, this.toolIcons[13], KeyStroke.getKeyStroke(72, 2)));
        menutool.add(this.menuItem(this.translation.getProperty("Template_Tool"), 84, this.toolIcons[16], KeyStroke.getKeyStroke(84, 2)));
        menutool.add(this.menuItem(this.translation.getProperty("Select_Template"), 84, this.toolIcons[16], KeyStroke.getKeyStroke(84, 3)));
        JMenu menuhydr = new JMenu(this.translation.getProperty("Hydrogen"));
        menuhydr.setMnemonic(89);
        this.chkShowHydr = new JCheckBoxMenuItem(this.translation.getProperty("Show_Hydrogen"));
        this.chkShowHydr.setMnemonic(89);
        this.chkShowHydr.setSelected(true);
        this.chkShowHydr.addActionListener(this);
        menuhydr.add(this.chkShowHydr);
        menuhydr.add(this.menuItem(this.translation.getProperty("Set_Explicit"), 69));
        menuhydr.add(this.menuItem(this.translation.getProperty("Clear_Explicit"), 88));
        menuhydr.add(this.menuItem(this.translation.getProperty("Zero_Explicit"), 90));
        menuhydr.add(this.menuItem(this.translation.getProperty("Create_Actual"), 67));
        menuhydr.add(this.menuItem(this.translation.getProperty("Delete_Actual"), 68));
        JMenu menuster = new JMenu(this.translation.getProperty("Stereochemistry"));
        menuster.setMnemonic(83);
        this.chkShowSter = new JCheckBoxMenuItem(this.translation.getProperty("Show_Stereolabels"));
        this.chkShowSter.setMnemonic(76);
        this.chkShowSter.setSelected(false);
        this.chkShowSter.addActionListener(this);
        menuster.add(this.chkShowSter);
        menuster.add(this.menuItem(this.translation.getProperty("Invert_Stereochemistry"), 73));
        menuster.add(this.menuItem(this.translation.getProperty("Set_R/Z"), 82));
        menuster.add(this.menuItem(this.translation.getProperty("Set_S/E"), 83));
        menuster.add(this.menuItem(this.translation.getProperty("Cycle_Wedges"), 67));
        menuster.add(this.menuItem(this.translation.getProperty("Remove_Wedges"), 87));
        JMenu menuhelp = new JMenu(this.translation.getProperty("Help"));
        menuhelp.setMnemonic(72);
        menuhelp.add(this.menuItem(this.translation.getProperty("About"), 65));
        menubar.add(menufile);
        menubar.add(menuedit);
        menubar.add(menuview);
        menubar.add(menutool);
        menubar.add(menuhydr);
        menubar.add(menuster);
        menubar.add(Box.createHorizontalGlue());
        menubar.add(menuhelp);
        return menubar;
    }

    private JMenuBar menuBarApplet() {
        JMenuBar menubar = new JMenuBar();
        AppletMenu menublock = new AppletMenu(this.translation.getProperty("Block"));
        AppletMenu menuselect = new AppletMenu(this.translation.getProperty("Select"));
        AppletMenu menutransform = new AppletMenu(this.translation.getProperty("Transform"));
        AppletMenu menuzoom = new AppletMenu(this.translation.getProperty("Zoom"));
        AppletMenu menushow = new AppletMenu(this.translation.getProperty("Show"));
        AppletMenu menuhydrogen = new AppletMenu(this.translation.getProperty("Hydrogen"));
        AppletMenu menuhelp = new AppletMenu(this.translation.getProperty("Help"));
        if (MENU_SELECTION[0]) {
            menublock.setMnemonic(66);
            menublock.add(this.menuItem(this.translation.getProperty("New"), 78, null, KeyStroke.getKeyStroke(78, 2)));
            menublock.add(this.menuItem(this.translation.getProperty("Editttt"), 69, null, KeyStroke.getKeyStroke(32, 2)));
            menublock.add(this.menuItem(this.translation.getProperty("Undo"), 85, null, KeyStroke.getKeyStroke(90, 2)));
            menublock.add(this.menuItem(this.translation.getProperty("Redo"), 82, null, KeyStroke.getKeyStroke(90, 3)));
            menublock.add(this.menuItem(this.translation.getProperty("Cut"), 88, null, KeyStroke.getKeyStroke(88, 2)));
            menublock.add(this.menuItem(this.translation.getProperty("Copy"), 67, null, KeyStroke.getKeyStroke(67, 2)));
            menublock.add(this.menuItem(this.translation.getProperty("Paste"), 86, null, KeyStroke.getKeyStroke(86, 2)));
            menubar.add(menublock);
        }
        if (MENU_SELECTION[1]) {
            menuselect.setMnemonic(83);
            menuselect.add(this.menuItem(this.translation.getProperty("Select_All"), 83, null, KeyStroke.getKeyStroke(65, 2)));
            menuselect.add(this.menuItem(this.translation.getProperty("Next_Atom"), 78, null, KeyStroke.getKeyStroke(69, 2)));
            menuselect.add(this.menuItem(this.translation.getProperty("Previous_Atom"), 80, null, KeyStroke.getKeyStroke(69, 3)));
            menuselect.add(this.menuItem(this.translation.getProperty("Next_Group"), 71, null, KeyStroke.getKeyStroke(71, 2)));
            menuselect.add(this.menuItem(this.translation.getProperty("Previous_Group"), 82, null, KeyStroke.getKeyStroke(71, 3)));
            menubar.add(menuselect);
        }
        if (MENU_SELECTION[2]) {
            menutransform.setMnemonic(84);
            menutransform.add(this.menuItem(this.translation.getProperty("Flip_Horizontal"), 72, null, null));
            menutransform.add(this.menuItem(this.translation.getProperty("Flip_Vertical"), 86, null, null));
            menutransform.add(this.menuItem(this.translation.getProperty("Rotate_P45"), 52, null, null));
            menutransform.add(this.menuItem(this.translation.getProperty("Rotate_M45"), 53, null, null));
            menutransform.add(this.menuItem(this.translation.getProperty("Rotate_P90"), 57, null, null));
            menutransform.add(this.menuItem(this.translation.getProperty("Rotate_M90"), 48, null, null));
            menutransform.addSeparator();
            menutransform.add(this.menuItem(this.translation.getProperty("Add_Temporary_Template"), 84, null, null));
            menutransform.add(this.menuItem(this.translation.getProperty("Normalise_Bond_Lengths"), 78, null, null));
            menubar.add(menutransform);
        }
        if (MENU_SELECTION[3]) {
            menuzoom.setMnemonic(90);
            menuzoom.add(this.menuItem(this.translation.getProperty("Zoom_Full"), 70, null, KeyStroke.getKeyStroke(48, 2)));
            menuzoom.add(this.menuItem(this.translation.getProperty("Zoom_In"), 73, null, KeyStroke.getKeyStroke(61, 2)));
            menuzoom.add(this.menuItem(this.translation.getProperty("Zoom_Out"), 79, null, KeyStroke.getKeyStroke(45, 2)));
            menubar.add(menuzoom);
        }
        if (MENU_SELECTION[4]) {
            menushow.setMnemonic(79);
            ButtonGroup showBG = new ButtonGroup();
            menushow.add(this.radioMenuItem(this.translation.getProperty("Show_Elements"), 69, true, showBG));
            menushow.add(this.radioMenuItem(this.translation.getProperty("Show_All_Elements"), 65, false, showBG));
            menushow.add(this.radioMenuItem(this.translation.getProperty("Show_Indices"), 73, false, showBG));
            menushow.add(this.radioMenuItem(this.translation.getProperty("Show_Ring_ID"), 82, false, showBG));
            menushow.add(this.radioMenuItem(this.translation.getProperty("Show_CIP_Priority"), 67, false, showBG));
            menushow.add(this.radioMenuItem(this.translation.getProperty("Show_Mapping_Number"), 77, false, showBG));
            menubar.add(menushow);
        }
        if (MENU_SELECTION[5]) {
            menuhydrogen.setMnemonic(72);
            this.chkShowHydr = new JCheckBoxMenuItem(this.translation.getProperty("Show_Hydrogen"));
            this.chkShowHydr.setMnemonic(89);
            this.chkShowHydr.setSelected(true);
            this.chkShowHydr.addActionListener(this);
            menuhydrogen.add(this.chkShowHydr);
            menuhydrogen.add(this.menuItem(this.translation.getProperty("Set_Explicit"), 69));
            menuhydrogen.add(this.menuItem(this.translation.getProperty("Clear_Explicit"), 88));
            menuhydrogen.add(this.menuItem(this.translation.getProperty("Zero_Explicit"), 90));
            menuhydrogen.add(this.menuItem(this.translation.getProperty("Create_Actual"), 67));
            menuhydrogen.add(this.menuItem(this.translation.getProperty("Delete_Actual"), 68));
            menubar.add(menuhydrogen);
        }
        if (MENU_SELECTION[6]) {
            AppletMenu menustereo = new AppletMenu(this.translation.getProperty("Stereo"));
            menustereo.setMnemonic(69);
            this.chkShowSter = new JCheckBoxMenuItem(this.translation.getProperty("Show_Stereolabels"));
            this.chkShowSter.setMnemonic(76);
            this.chkShowSter.setSelected(false);
            this.chkShowSter.addActionListener(this);
            menustereo.add(this.chkShowSter);
            menustereo.add(this.menuItem(this.translation.getProperty("Invert_Stereochemistry"), 73));
            menustereo.add(this.menuItem(this.translation.getProperty("Set R/Z"), 82));
            menustereo.add(this.menuItem(this.translation.getProperty("Set_S/E"), 83));
            menustereo.add(this.menuItem(this.translation.getProperty("Cycle_Wedges"), 67));
            menustereo.add(this.menuItem(this.translation.getProperty("Remove_Wedges"), 87));
            menubar.add(menustereo);
        }
        if (MENU_SELECTION[7]) {
            menuhelp.setMnemonic(80);
            menuhelp.add(this.menuItem(this.translation.getProperty("About"), 65));
            menubar.add(menuhelp);
        }
        return menubar;
    }

    public Molecule molData() {
        return this.editor.molData();
    }

    public void setMolecule(Molecule Mol) {
        this.editor.replace(Mol);
        this.editor.RotateMolecule();
        this.editor.scaleToFit();
        this.editor.notifySaved();
    }

    public void addMolecule(Molecule Mol) {
        this.editor.addArbitraryFragment(Mol);
        this.editor.scaleToFit();
        this.editor.notifySaved();
    }

    public void scaleToFit() {
        this.editor.scaleToFit();
    }

    JMenuItem menuItem(String txt, int key) {
        return this.menuItem(txt, key, null, null);
    }

    JMenuItem menuItem(String txt, int key, Icon icon) {
        return this.menuItem(txt, key, icon, null);
    }

    JMenuItem menuItem(String txt, int key, Icon icon, KeyStroke accel) {
        JMenuItem mi = new JMenuItem(txt, key);
        mi.addActionListener(this);
        if (icon != null) {
            mi.setIcon(icon);
        }
        if (accel != null) {
            mi.setAccelerator(accel);
        }
        return mi;
    }

    JRadioButtonMenuItem radioMenuItem(String txt, int key, boolean sel, ButtonGroup bg) {
        JRadioButtonMenuItem mi = new JRadioButtonMenuItem(txt, sel);
        mi.addActionListener(this);
        mi.setMnemonic(key);
        bg.add(mi);
        return mi;
    }

    void fileQuit() {
        if (!this.streamMode) {
            if (this.editor.isDirty() && JOptionPane.showConfirmDialog(null, "Current structure has been modified. Exit without saving?", "Quit", 0) != 0) {
                return;
            }
        } else {
            this.writeStream();
        }
        if (this.frameParent != null) {
            this.frameParent.dispose();
        }
    }

    void fileNew() {
        if (this.editor.molData().numAtoms() > 0 && JOptionPane.showConfirmDialog(null, "Clear current structure and start anew?", "New", 0) != 0) {
            return;
        }
        this.editor.clear();
        this.filename = null;
        if (this.frameParent != null && this.saver == null) {
            this.frameParent.setTitle("WIMSchem");
        }
        this.editor.notifySaved();
    }

    void fileNewWindow() {
        MainWindow mw = new MainWindow(null, false);
        mw.setVisible(true);
    }

    void fileNewDataSheet() {
        DataWindow dw = new DataWindow(null);
        dw.setVisible(true);
    }

    void fileOpen() {
        JFileChooser chooser = new JFileChooser(System.getenv().get("PWD"));
        chooser.setDragEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileExtFilter("Molecular Structures", ".el;.mol;.sdf;.xml"));
        chooser.setAccessory(new FileMolPreview(chooser));
        if (chooser.showOpenDialog(this.frameParent) != 0) {
            return;
        }
        boolean fresh = this.editor.isEmpty();
        String newfn = chooser.getSelectedFile().getPath();
        boolean anything = this.editor.molData().numAtoms() > 0;
        try {
            FileInputStream istr = new FileInputStream(newfn);
            if (DataSheetStream.examineIsXMLDS(istr) || DataSheetStream.examineIsMDLSDF(istr)) {
                istr.close();
                DataWindow dw = new DataWindow(newfn);
                dw.setVisible(true);
            } else {
                Molecule frag = MoleculeStream.readUnknown(istr);
                this.editor.addArbitraryFragment(frag);
                istr.close();
                if (fresh) {
                    this.setFilename(newfn);
                }
                if (!anything) {
                    this.editor.notifySaved();
                }
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Open Failed", 0);
            return;
        }
    }

    void fileSave() {
        if (this.filename == null && this.saver == null) {
            this.fileSaveAs();
            return;
        }
        this.saveCurrent();
    }

    void fileSaveAs() {
        File newf;
        JFileChooser chooser = new JFileChooser(System.getenv().get("PWD"));
        chooser.setDragEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileExtFilter("WIMSchem Files", ".el"));
        chooser.setAccessory(new FileMolPreview(chooser));
        if (chooser.showSaveDialog(this.frameParent) != 0) {
            return;
        }
        String fn = chooser.getSelectedFile().getPath();
        if (chooser.getSelectedFile().getName().indexOf(46) < 0) {
            fn = fn + ".el";
        }
        if ((newf = new File(fn)).exists() && JOptionPane.showConfirmDialog(null, "Overwrite existing file [" + newf.getName() + "]?", "Save As", 0) != 0) {
            return;
        }
        this.setFilename(fn);
        this.saveCurrent(true);
    }

    void fileExportMDLMOL() {
        File newf;
        JFileChooser chooser = new JFileChooser(System.getenv().get("PWD"));
        chooser.setDragEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileExtFilter("MDL MOL Files", ".mol"));
        chooser.setAccessory(new FileMolPreview(chooser));
        if (chooser.showSaveDialog(this.frameParent) != 0) {
            return;
        }
        String fn = chooser.getSelectedFile().getPath();
        if (chooser.getSelectedFile().getName().indexOf(46) < 0) {
            fn = fn + ".mol";
        }
        if ((newf = new File(fn)).exists() && JOptionPane.showConfirmDialog(null, "Overwrite existing file [" + newf.getName() + "]?", "Export MDL MOL", 0) != 0) {
            return;
        }
        try {
            FileOutputStream ostr = new FileOutputStream(fn);
            MoleculeStream.writeMDLMOL(ostr, this.editor.molData());
            ostr.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Export Failed", 0);
        }
    }

    void fileExportSVG() {
        File newf;
        JFileChooser chooser = new JFileChooser(System.getenv().get("PWD"));
        chooser.setDragEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileExtFilter("SVG Files", ".svg"));
        chooser.setAccessory(new FileMolPreview(chooser));
        if (chooser.showSaveDialog(this.frameParent) != 0) {
            return;
        }
        String fn = chooser.getSelectedFile().getPath();
        if (chooser.getSelectedFile().getName().indexOf(46) < 0) {
            fn = fn + ".svg";
        }
        if ((newf = new File(fn)).exists() && JOptionPane.showConfirmDialog(null, "Overwrite existing file [" + newf.getName() + "]?", "Export SVG", 0) != 0) {
            return;
        }
        try {
            FileOutputStream ostr = new FileOutputStream(fn);
            SVGMolecule svgmol = new SVGMolecule(this.editor.molData());
            svgmol.draw();
            svgmol.build(new PrintWriter(ostr));
            ostr.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Export Failed", 0);
        }
    }

    void fileExportCMLXML() {
        File newf;
        JFileChooser chooser = new JFileChooser(System.getenv().get("PWD"));
        chooser.setDragEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileExtFilter("XML Files", ".xml"));
        chooser.setAccessory(new FileMolPreview(chooser));
        if (chooser.showSaveDialog(this.frameParent) != 0) {
            return;
        }
        String fn = chooser.getSelectedFile().getPath();
        if (chooser.getSelectedFile().getName().indexOf(46) < 0) {
            fn = fn + ".xml";
        }
        if ((newf = new File(fn)).exists() && JOptionPane.showConfirmDialog(null, "Overwrite existing file [" + newf.getName() + "]?", "Export CML XML", 0) != 0) {
            return;
        }
        try {
            FileOutputStream ostr = new FileOutputStream(fn);
            MoleculeStream.writeCMLXML(ostr, this.editor.molData());
            ostr.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Export Failed", 0);
        }
    }

    void setFilename(String fn) {
        if (fn.length() == 0) {
            this.filename = null;
            return;
        }
        this.filename = fn;
        if (!this.streamMode) {
            String chopfn = fn;
            int i = chopfn.lastIndexOf("/");
            if (i >= 0) {
                chopfn = chopfn.substring(i + 1);
            }
            if (this.frameParent != null && this.saver == null) {
                this.frameParent.setTitle(chopfn + " - WIMSchem");
            }
        } else if (this.frameParent != null && this.saver == null) {
            this.frameParent.setTitle("WIMSchem");
        }
    }

    void saveCurrent() {
        this.saveCurrent(false);
    }

    void saveCurrent(boolean force) {
        if (this.saver != null && !force) {
            this.saver.saveMolecule(this.editor.molData().clone());
            this.editor.notifySaved();
            return;
        }
        try {
            String msg;
            boolean fmtNative = true;
            if (this.filename.toLowerCase().endsWith(".mol") && JOptionPane.showConfirmDialog(null, msg = "The filename to save ends with '.mol', which is the\nconventional suffix for MDL MOL-files. Exporting to\nthis format will cause some information loss. Do you wish\nto save in MDL MOL-file format?", "Format", 0) == 0) {
                fmtNative = false;
            }
            FileOutputStream ostr = new FileOutputStream(this.filename);
            if (fmtNative) {
                MoleculeStream.writeNative(ostr, this.editor.molData());
            } else {
                MoleculeStream.writeMDLMOL(ostr, this.editor.molData());
            }
            ostr.close();
            this.editor.notifySaved();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Save Failed", 0);
        }
    }

    void readStream() {
        try {
            Molecule frag = MoleculeStream.readUnknown(System.in);
            this.editor.addArbitraryFragment(frag);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "<stdin> Read Failed", 0);
            return;
        }
    }

    void writeStream() {
        Molecule mol = this.editor.molData();
        try {
            MoleculeStream.writeMDLMOL(System.out, mol);
            MoleculeStream.writeNative(System.out, mol);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "<stdout> Write Failed", 0);
        }
    }

    void testMol() {
        Molecule mol = new Molecule();
        mol.addAtom("N", 0.0, 0.0);
        mol.addAtom("C", 1.2, 0.0);
        mol.addAtom("O", 2.0, 0.8);
        mol.addAtom("H", 3.0, -0.8);
        mol.addAtom("H", 4.0, 0.0);
        mol.addBond(1, 2, 1);
        mol.addBond(2, 3, 2);
        mol.addBond(3, 4, 1);
        mol.addBond(4, 5, 0);
        this.editor.replace(mol);
    }

    void editCut() {
        Molecule frag = this.editor.selectedSubgraph();
        try {
            StringWriter sw = new StringWriter();
            BufferedWriter bw = new BufferedWriter(sw);
            MoleculeStream.writeMDLMOL(bw, frag);
            MoleculeStream.writeNative(bw, frag);
            if (this.useLocalClipboard) {
                this.appletClipboard = sw.toString();
            } else {
                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                clip.setContents(new StringSelection(sw.toString()), this);
            }
            this.editor.deleteSelected();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Cut Failed", 0);
        }
    }

    void editCopy() {
        Molecule frag = this.editor.selectedSubgraph();
        try {
            StringWriter sw = new StringWriter();
            BufferedWriter bw = new BufferedWriter(sw);
            MoleculeStream.writeMDLMOL(bw, frag);
            MoleculeStream.writeNative(bw, frag);
            if (this.useLocalClipboard) {
                this.appletClipboard = sw.toString();
            } else {
                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                clip.setContents(new StringSelection(sw.toString()), this);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Copy Failed", 0);
        }
    }

    void editCopySVG() {
        StringWriter sw = new StringWriter();
        SVGMolecule svgmol = new SVGMolecule(this.editor.molData());
        svgmol.draw();
        svgmol.build(new PrintWriter(sw));
        if (this.useLocalClipboard) {
            this.appletClipboard = sw.toString();
        } else {
            Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
            clip.setContents(new StringSelection(sw.toString()), this);
        }
    }

    void editPaste() {
        try {
            Molecule frag;
            String cliptext = null;
            if (this.useLocalClipboard) {
                cliptext = this.appletClipboard;
            } else {
                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable contents = clip.getContents(null);
                if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    cliptext = (String)contents.getTransferData(DataFlavor.stringFlavor);
                }
            }
            if (cliptext != null && (frag = MoleculeStream.readUnknown(new BufferedReader(new StringReader(cliptext)))) != null) {
                this.editor.addArbitraryFragment(frag);
            }
        }
        catch (UnsupportedFlavorException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Clipboard Read Failed", 0);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Paste Failed", 0);
        }
    }

    void selectElement(String El) {
        if (this.lastElement != null) {
            if (this.lastElement.compareTo(El) == 0) {
                return;
            }
            this.toolIcons[5] = new ImageIcon(this.getClass().getResource("/images/" + IMAGE_TOOL[5] + ".png"));
        }
        int w = this.toolIcons[5].getImage().getWidth(null);
        int h = this.toolIcons[5].getImage().getHeight(null);
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setColor(new Color(0, true));
        g.fillRect(0, 0, w, h);
        g.drawImage(this.toolIcons[5].getImage(), 0, 0, null);
        Font font = new Font("SansSerif", 0, El.length() == 1 ? 20 : 14);
        g.setFont(font);
        g.setColor(new Color(0, 192, 0));
        FontMetrics metrics = g.getFontMetrics();
        g.drawString(El, (w - metrics.stringWidth(El)) / 2 - 3, (h + metrics.getAscent()) / 2 - 2);
        this.toolButtons[5].setIcon(new ImageIcon(img));
        this.lastElement = El;
    }

    void templateTool() {
        if (this.lastTemplate == null) {
            this.templateSelect();
            return;
        }
        this.editor.setToolTemplate(this.lastTemplate, this.templateIdx);
    }

    void templateSelect() {
        int heightFudge = appletMode ? 30 : 0;
        TemplateSelector sel = new TemplateSelector(this.templ, this, heightFudge);
        Point pos = this.toolButtons[16].getLocationOnScreen();
        Dimension ssz = Toolkit.getDefaultToolkit().getScreenSize();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration gc = ge.getScreenDevices()[0].getConfigurations()[0];
        ssz.width -= Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)gc).right;
        ssz.height -= Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)gc).bottom;
        if (pos.x + sel.getWidth() > ssz.width) {
            pos.x = ssz.width - sel.getWidth();
        }
        if (pos.y + sel.getHeight() > ssz.height) {
            pos.y = ssz.height - sel.getHeight();
        }
        sel.setLocation(pos);
        sel.setVisible(true);
    }

    void templateAddTo() {
        this.templ.addTemplate(this.editor.selectedSubgraph());
    }

    void editDialog() {
        Molecule newMol = new DialogEdit((Frame)this.frameParent, this.editor.molData(), this.editor.selectedIndices()).exec();
        if (newMol != null) {
            this.editor.cacheUndo();
            this.editor.replace(newMol, false);
        }
    }

    void helpAbout() {
        String msg = "WIMSchem vSketchEl 1.21 WIMSversion 0.2 SVG export\nMolecule drawing tool\n\u00a9 2005-2008 Dr. Alex M. Clark\nReleased under the Gnu Public\nLicense (GPL), see www.gnu.org\nHome page and documentation:\nhttp://sketchel.sf.net\nModified for WIMS\njm.evers 2009";
        JOptionPane.showMessageDialog(null, msg, "About WIMSchem", 1, this.mainLogo);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        int setsel = -1;
        if (cmd.equals(this.translation.getProperty("Quit")) || cmd.equals(this.translation.getProperty("Close")) || cmd.equals(this.translation.getProperty("Save_and_Quit"))) {
            this.fileQuit();
        } else if (cmd.equals(this.translation.getProperty("New"))) {
            this.fileNew();
        } else if (cmd.equals(this.translation.getProperty("New_Window"))) {
            this.fileNewWindow();
        } else if (cmd.equals(this.translation.getProperty("New_DataSheet"))) {
            this.fileNewDataSheet();
        } else if (cmd.equals(this.translation.getProperty("Open"))) {
            this.fileOpen();
        } else if (cmd.equals(this.translation.getProperty("Save"))) {
            this.fileSave();
        } else if (cmd.equals(this.translation.getProperty("Save_As"))) {
            this.fileSaveAs();
        } else if (cmd.equals(this.translation.getProperty("as_MDL_MOL"))) {
            this.fileExportMDLMOL();
        } else if (cmd.equals(this.translation.getProperty("as_CML_XML"))) {
            this.fileExportCMLXML();
        } else if (cmd.equals(this.translation.getProperty("as_SVG"))) {
            this.fileExportSVG();
        } else if (cmd.equals(this.translation.getProperty("Cursor")) || e.getSource() == this.toolButtons[0]) {
            this.editor.setToolCursor();
            setsel = 0;
        } else if (cmd.equals(this.translation.getProperty("Rotator")) || e.getSource() == this.toolButtons[1]) {
            this.editor.setToolRotator();
            setsel = 1;
        } else if (cmd.equals(this.translation.getProperty("Erasor")) || e.getSource() == this.toolButtons[2]) {
            this.editor.setToolErasor();
            setsel = 2;
        } else if (cmd.equals(this.translation.getProperty("Editttt")) || e.getSource() == this.toolButtons[3]) {
            this.editDialog();
        } else if (cmd.equals(this.translation.getProperty("Select_All"))) {
            this.editor.selectAll();
        } else if (cmd.equals(this.translation.getProperty("Next_Atom"))) {
            this.editor.cycleSelection(true, false);
        } else if (cmd.equals(this.translation.getProperty("Previous_Atom"))) {
            this.editor.cycleSelection(false, false);
        } else if (cmd.equals(this.translation.getProperty("Next_Group"))) {
            this.editor.cycleSelection(true, true);
        } else if (cmd.equals(this.translation.getProperty("Previous_Group"))) {
            this.editor.cycleSelection(false, true);
        } else if (cmd.equals(this.translation.getProperty("Edit_Atom")) || e.getSource() == this.toolButtons[4]) {
            this.editor.setToolAtom(null);
            setsel = 4;
        } else if (cmd.equals(this.translation.getProperty("Set_Atom")) || e.getSource() == this.toolButtons[5]) {
            this.editor.setToolAtom(this.lastElement);
            setsel = 5;
        } else if (cmd.equals(this.translation.getProperty("Single_Bond")) || e.getSource() == this.toolButtons[6]) {
            this.editor.setToolBond(1);
            setsel = 6;
        } else if (cmd.equals(this.translation.getProperty("Double_Bond")) || e.getSource() == this.toolButtons[7]) {
            this.editor.setToolBond(2);
            setsel = 7;
        } else if (cmd.equals(this.translation.getProperty("Triple_Bond")) || e.getSource() == this.toolButtons[8]) {
            this.editor.setToolBond(3);
            setsel = 8;
        } else if (cmd.equals(this.translation.getProperty("Zero_Bond")) || e.getSource() == this.toolButtons[9]) {
            this.editor.setToolBond(0);
            setsel = 9;
        } else if (cmd.equals(this.translation.getProperty("Inclined_Bond")) || e.getSource() == this.toolButtons[10]) {
            this.editor.setToolBond(-1);
            setsel = 10;
        } else if (cmd.equals(this.translation.getProperty("Declined_Bond")) || e.getSource() == this.toolButtons[11]) {
            this.editor.setToolBond(-2);
            setsel = 11;
        } else if (cmd.equals(this.translation.getProperty("Unknown_Bond")) || e.getSource() == this.toolButtons[12]) {
            this.editor.setToolBond(-3);
            setsel = 12;
        } else if (cmd.equals(this.translation.getProperty("Charge")) || e.getSource() == this.toolButtons[13]) {
            this.editor.setToolCharge(1);
            setsel = 13;
        } else if (cmd.equals(this.translation.getProperty("Undo")) || e.getSource() == this.toolButtons[14]) {
            this.editor.undo();
        } else if (cmd.equals(this.translation.getProperty("Redo")) || e.getSource() == this.toolButtons[15]) {
            this.editor.redo();
        } else if (cmd.equals(this.translation.getProperty("Un_select_all")) || e.getSource() == this.toolButtons[21]) {
            this.editor.deSelectAll();
        } else if (cmd.equals(this.translation.getProperty("Select")) || e.getSource() == this.toolButtons[20]) {
            this.editor.Select();
        } else if (cmd.equals(this.translation.getProperty("Cut"))) {
            this.editCut();
        } else if (cmd.equals(this.translation.getProperty("Copy"))) {
            this.editCopy();
        } else if (cmd.equals(this.translation.getProperty("Copy_SVG"))) {
            this.editCopySVG();
        } else if (cmd.equals(this.translation.getProperty("Paste"))) {
            this.editPaste();
        } else if (cmd.equals(this.translation.getProperty("Flip_Horizontal"))) {
            this.editor.flipSelectedAtoms(false);
        } else if (cmd.equals(this.translation.getProperty("Flip_Vertical"))) {
            this.editor.flipSelectedAtoms(true);
        } else if (cmd.equals(this.translation.getProperty("Rotate_P45"))) {
            this.editor.rotateSelectedAtoms(45.0);
        } else if (cmd.equals(this.translation.getProperty("Rotate_M45"))) {
            this.editor.rotateSelectedAtoms(-45.0);
        } else if (cmd.equals(this.translation.getProperty("Rotate_P90"))) {
            this.editor.rotateSelectedAtoms(90.0);
        } else if (cmd.equals(this.translation.getProperty("Rotate_M90"))) {
            this.editor.rotateSelectedAtoms(-90.0);
        } else if (cmd.equals(this.translation.getProperty("Add_Temporary_Template"))) {
            this.templateAddTo();
        } else if (cmd.equals(this.translation.getProperty("Normalise_Bond_Lengths"))) {
            this.editor.normaliseBondLengths();
        } else if (cmd.equals(this.translation.getProperty("Template_Tool")) || e.getSource() == this.toolButtons[16]) {
            this.templateTool();
            setsel = 16;
        } else if (cmd.equals(this.translation.getProperty("Select_Template"))) {
            this.templateSelect();
            setsel = 16;
        } else if (cmd.equals(this.translation.getProperty("Zoom_Full"))) {
            this.editor.zoomFull();
        } else if (cmd.equals(this.translation.getProperty("Zoom_In"))) {
            this.editor.zoomIn(1.5);
        } else if (cmd.equals(this.translation.getProperty("Zoom_Out"))) {
            this.editor.zoomOut(1.5);
        } else if (cmd.equals(this.translation.getProperty("Show_Elements"))) {
            this.editor.setShowMode(0);
        } else if (cmd.equals(this.translation.getProperty("Show_All_Elements"))) {
            this.editor.setShowMode(1);
        } else if (cmd.equals(this.translation.getProperty("Show_Indices"))) {
            this.editor.setShowMode(2);
        } else if (cmd.equals(this.translation.getProperty("Show_Ring_ID"))) {
            this.editor.setShowMode(3);
        } else if (cmd.equals(this.translation.getProperty("Show_CIP_Priority"))) {
            this.editor.setShowMode(4);
        } else if (cmd.equals(this.translation.getProperty("Show_Mapping_Number"))) {
            this.editor.setShowMode(5);
        } else if (cmd.equals(this.translation.getProperty("Show_Hydrogen"))) {
            this.editor.setShowHydrogens(this.chkShowHydr.isSelected());
        } else if (cmd.equals(this.translation.getProperty("Set_Explicit"))) {
            this.editor.hydrogenSetExplicit(true);
        } else if (cmd.equals(this.translation.getProperty("Clear_Explicit"))) {
            this.editor.hydrogenSetExplicit(false);
        } else if (cmd.equals(this.translation.getProperty("Zero_Explicit"))) {
            this.editor.hydrogenSetExplicit(false, 0);
        } else if (cmd.equals(this.translation.getProperty("Create_Actual"))) {
            this.editor.hydrogenCreateActual();
        } else if (cmd.equals(this.translation.getProperty("Delete_Actual"))) {
            this.editor.hydrogenDeleteActual();
        } else if (cmd.equals(this.translation.getProperty("Show_Stereolabels"))) {
            this.editor.setShowStereolabels(this.chkShowSter.isSelected());
        } else if (cmd.equals(this.translation.getProperty("Invert_Stereochemistry"))) {
            this.editor.setStereo(3);
        } else if (cmd.equals(this.translation.getProperty("Set_R/Z"))) {
            this.editor.setStereo(1);
        } else if (cmd.equals(this.translation.getProperty("Set_S/E"))) {
            this.editor.setStereo(2);
        } else if (cmd.equals(this.translation.getProperty("Cycle_Wedges"))) {
            this.editor.cycleChiralWedges();
        } else if (cmd.equals(this.translation.getProperty("Remove_Wedges"))) {
            this.editor.removeChiralWedges();
        } else if (cmd.equals(this.translation.getProperty("About"))) {
            this.helpAbout();
        } else if (TOOL_SELECTION[5] && cmd.length() <= 2) {
            this.selectElement(cmd);
            this.editor.setToolAtom(this.lastElement);
        }
        if (setsel != -1) {
            this.toolGroup.setSelected(this.toolButtons[setsel].getModel(), true);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.toolButtons[5] && e.getButton() == 3) {
            this.toolButtons[5].setSelected(true);
            JPopupMenu popup = new JPopupMenu();
            int max = this.myAtoms.length;
            for (int i = 0; i < max; ++i) {
                popup.add(this.menuItem(this.myAtoms[i], 0));
            }
            popup.show(this.toolButtons[5], 0, 0);
        }
        if (e.getSource() == this.toolButtons[16] && e.getButton() == 3) {
            this.toolGroup.setSelected(this.toolButtons[16].getModel(), true);
            this.templateSelect();
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (!(e.isAltDown() || e.isShiftDown() || e.isControlDown() || e.isMetaDown())) {
            if (e.getKeyCode() == 38) {
                this.editor.nudgeSelectedAtoms(0.0, 0.05);
                return;
            }
            if (e.getKeyCode() == 40) {
                this.editor.nudgeSelectedAtoms(0.0, -0.05);
                return;
            }
            if (e.getKeyCode() == 37) {
                this.editor.nudgeSelectedAtoms(-0.05, 0.0);
                return;
            }
            if (e.getKeyCode() == 39) {
                this.editor.nudgeSelectedAtoms(0.05, 0.0);
                return;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        char ch = e.getKeyChar();
        if (ch >= 'A' && ch <= 'Z') {
            this.typedElement = "" + ch;
        } else if (this.typedElement.length() == 1 && ch >= 'a' && ch <= 'z') {
            this.typedElement = this.typedElement + ch;
        } else if (this.typedElement.compareTo("R") == 0 && ch >= '0' && ch <= '9') {
            this.typedElement = this.typedElement + ch;
        } else {
            this.typedElement = "";
            return;
        }
        String elset = null;
        if (this.typedElement.length() >= 2 && this.typedElement.charAt(0) == 'R' && this.typedElement.charAt(1) >= '0' && this.typedElement.charAt(1) <= '9') {
            elset = this.typedElement;
        } else {
            for (int n = 1; n < Molecule.ELEMENTS.length; ++n) {
                if (this.typedElement.compareTo(Molecule.ELEMENTS[n]) != 0) continue;
                elset = this.typedElement;
            }
        }
        if (elset != null) {
            this.selectElement(elset);
            this.toolGroup.setSelected(this.toolButtons[5].getModel(), true);
            this.editor.setToolAtom(elset);
        }
    }

    public void templSelected(Molecule mol, int idx) {
        this.lastTemplate = mol;
        this.templateIdx = idx;
        this.editor.setToolTemplate(mol, idx);
    }

    public void molSelected(EditorPane source, int idx, boolean dblclick) {
        if (dblclick && idx != 0) {
            ArrayList<Integer> selidx = new ArrayList<Integer>();
            if (idx > 0) {
                selidx.add(idx);
            } else {
                selidx.add(this.editor.molData().bondFrom(-idx));
                selidx.add(this.editor.molData().bondTo(-idx));
            }
            Molecule newMol = new DialogEdit((Frame)this.frameParent, this.editor.molData(), selidx).exec();
            if (newMol != null) {
                this.editor.replace(newMol);
            }
        }
    }

    public void dirtyChanged(boolean isdirty) {
        String str;
        String string = str = this.frameParent == null ? "WIMSchem" : this.frameParent.getTitle();
        if (str.charAt(0) == '*') {
            str = str.substring(1);
        }
        if (isdirty) {
            str = "*" + str;
        }
        if (this.frameParent != null && this.saver == null) {
            this.frameParent.setTitle(str);
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.fileQuit();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
        if (this.firstResize) {
            this.editor.scaleToFit();
            this.editor.repaint();
            this.firstResize = false;
        }
        this.editor.requestFocusInWindow();
    }

    public String getToolTips(int p) {
        switch (p) {
            case 0: {
                return this.translation.getProperty("CURSOR_TIP");
            }
            case 1: {
                return this.translation.getProperty("ROTATOR_TIP");
            }
            case 2: {
                return this.translation.getProperty("ERASOR_TIP");
            }
            case 3: {
                return this.translation.getProperty("EDIT_DIALOG_TIP");
            }
            case 4: {
                return this.translation.getProperty("EDIT_ELEMENT_TIP");
            }
            case 5: {
                return this.translation.getProperty("PLACE_ELEMENT_TIP");
            }
            case 6: {
                return this.translation.getProperty("SINGLE_BOND_TIP");
            }
            case 7: {
                return this.translation.getProperty("DOUBLE_BOND_TIP");
            }
            case 8: {
                return this.translation.getProperty("TRIPLE_BOND_TIP");
            }
            case 9: {
                return this.translation.getProperty("ZERO_BOND_TIP");
            }
            case 10: {
                return this.translation.getProperty("INCLINED_BOND_TIP");
            }
            case 11: {
                return this.translation.getProperty("DECLINE_BOND_TIP");
            }
            case 12: {
                return this.translation.getProperty("SQUIGGLY_BOND_TIP");
            }
            case 13: {
                return this.translation.getProperty("CHARGE_TIP");
            }
            case 14: {
                return this.translation.getProperty("UNDO_TIP");
            }
            case 15: {
                return this.translation.getProperty("REDO_TIP");
            }
            case 16: {
                return this.translation.getProperty("TEMPLATE_TIP");
            }
            case 17: {
                return this.translation.getProperty("CUT_TIP");
            }
            case 18: {
                return this.translation.getProperty("COPY_TIP");
            }
            case 19: {
                return this.translation.getProperty("PASTE");
            }
            case 20: {
                return this.translation.getProperty("SELECT");
            }
            case 21: {
                return this.translation.getProperty("UNSELECT");
            }
        }
        return "NO TIP?";
    }

    private Properties loadProperties(String lang) {
        Properties P = new Properties();
        try {
            InputStream in = this.getClass().getResourceAsStream("/lang/WIMSchemProperties_" + lang + ".properties");
            P.load(in);
            in.close();
            return P;
        }
        catch (Exception e) {
            System.out.println("error reading /lang/WIMSchemProperties_" + lang + ".properties\n" + e);
            return null;
        }
    }
}

