// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_USUBW_4S_TRACE_AARCH64_H_
#define VIXL_SIM_USUBW_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_usubw_4S[] = {
  0x00007d82, 0x00007e81, 0x007fc9cd, 0xffffaaab,
  0x00007d81, 0x00004bcd, 0x007fa7ab, 0xffff8003,
  0x00004acd, 0x000029ab, 0x007f7d03, 0xffff8002,
  0x000028ab, 0xffffff03, 0x007f7d02, 0xffff8001,
  0xfffffe03, 0xffffff02, 0x007f7d01, 0x00000000,
  0xfffffe02, 0xffffff01, 0x007ffd00, 0xffffffff,
  0xfffffe01, 0x00007f00, 0x007ffcff, 0xfffffffe,
  0x00007e00, 0x00007eff, 0x007ffcfe, 0xfffffff0,
  0x00007dff, 0x00007efe, 0x007ffcf0, 0xffffff83,
  0x00007dfe, 0x00007ef0, 0x007ffc83, 0xffffff82,
  0x00007df0, 0x00007e83, 0x007ffc82, 0xffffff81,
  0x00007d83, 0x00007e82, 0x007ffc81, 0xffffcccd,
  0x00007d82, 0x00007e81, 0x007fc9cd, 0xffffaaab,
  0x00007d81, 0x00004bcd, 0x007fa7ab, 0xffff8003,
  0x00004acd, 0x000029ab, 0x007f7d03, 0xffff8002,
  0x000028ab, 0xffffff03, 0x007f7d02, 0xffff8001,
  0xfffffe03, 0xffffff02, 0x007f7d01, 0xffff8000,
  0xfffffe02, 0xffffff01, 0x007f7d00, 0xffff7fff,
  0xfffffe01, 0xffffff00, 0x007f7cff, 0xffff5556,
  0xfffffe00, 0xfffffeff, 0x007f5256, 0xffff3334,
  0xfffffdff, 0xffffd456, 0x007f3034, 0xffff0080,
  0xffffd356, 0xffffb234, 0x007efd80, 0xffff007f,
  0xffffb134, 0xffff7f80, 0x007efd7f, 0xffff007e,
  0xffff7e80, 0xffff7f7f, 0x007efd7e, 0xffff007d,
  0xffff7f7f, 0x007efd7e, 0xffff007d, 0xffff0011,
  0xffff7f7e, 0x007efd7d, 0xffff0010, 0xffff0004,
  0xffff7f7d, 0x007efd10, 0xffff0003, 0xffff0003,
  0xffff7f10, 0x007efd03, 0xffff0002, 0xffff0002,
  0xffff7f03, 0x007efd02, 0xffff0001, 0x00000001,
  0xffff7f02, 0x007efd01, 0x00000000, 0x00000000,
  0xffff7f01, 0x007ffd00, 0xffffffff, 0xffffffff,
  0x00007f00, 0x007ffcff, 0xfffffffe, 0xfffffff1,
  0x00007eff, 0x007ffcfe, 0xfffffff0, 0xffffff84,
  0x00007efe, 0x007ffcf0, 0xffffff83, 0xffffff83,
  0x00007ef0, 0x007ffc83, 0xffffff82, 0xffffff82,
  0x00007e83, 0x007ffc82, 0xffffff81, 0xffffccce,
  0x00007e82, 0x007ffc81, 0xffffcccd, 0xffffaaac,
  0x00007e81, 0x007fc9cd, 0xffffaaab, 0xffff8004,
  0x00004bcd, 0x007fa7ab, 0xffff8003, 0xffff8003,
  0x000029ab, 0x007f7d03, 0xffff8002, 0xffff8002,
  0xffffff03, 0x007f7d02, 0xffff8001, 0xffff8001,
  0xffffff02, 0x007f7d01, 0xffff8000, 0xffff8000,
  0xffffff01, 0x007f7d00, 0xffff7fff, 0xffff5557,
  0xffffff00, 0x007f7cff, 0xffff5556, 0xffff3335,
  0xfffffeff, 0x007f5256, 0xffff3334, 0xffff0081,
  0xffffd456, 0x007f3034, 0xffff0080, 0xffff0080,
  0xffffb234, 0x007efd80, 0xffff007f, 0xffff007f,
  0xffff7f80, 0x007efd7f, 0xffff007e, 0xffff007e,
  0x007efd7f, 0xffff007e, 0xffff007e, 0xffff0012,
  0x007efd7e, 0xffff007d, 0xffff0011, 0xffff0005,
  0x007efd7d, 0xffff0010, 0xffff0004, 0xffff0004,
  0x007efd10, 0xffff0003, 0xffff0003, 0xffff0003,
  0x007efd03, 0xffff0002, 0xffff0002, 0x00000002,
  0x007efd02, 0xffff0001, 0x00000001, 0x00000001,
  0x007efd01, 0x00000000, 0x00000000, 0x00000000,
  0x007ffd00, 0xffffffff, 0xffffffff, 0xfffffff2,
  0x007ffcff, 0xfffffffe, 0xfffffff1, 0xffffff85,
  0x007ffcfe, 0xfffffff0, 0xffffff84, 0xffffff84,
  0x007ffcf0, 0xffffff83, 0xffffff83, 0xffffff83,
  0x007ffc83, 0xffffff82, 0xffffff82, 0xffffcccf,
  0x007ffc82, 0xffffff81, 0xffffccce, 0xffffaaad,
  0x007ffc81, 0xffffcccd, 0xffffaaac, 0xffff8005,
  0x007fc9cd, 0xffffaaab, 0xffff8004, 0xffff8004,
  0x007fa7ab, 0xffff8003, 0xffff8003, 0xffff8003,
  0x007f7d03, 0xffff8002, 0xffff8002, 0xffff8002,
  0x007f7d02, 0xffff8001, 0xffff8001, 0xffff8001,
  0x007f7d01, 0xffff8000, 0xffff8000, 0xffff5558,
  0x007f7d00, 0xffff7fff, 0xffff5557, 0xffff3336,
  0x007f7cff, 0xffff5556, 0xffff3335, 0xffff0082,
  0x007f5256, 0xffff3334, 0xffff0081, 0xffff0081,
  0x007f3034, 0xffff0080, 0xffff0080, 0xffff0080,
  0x007efd80, 0xffff007f, 0xffff007f, 0xffff007f,
  0xffff007f, 0xffff007f, 0xffff007f, 0xffff0030,
  0xffff007e, 0xffff007e, 0xffff0012, 0xffff0023,
  0xffff007d, 0xffff0011, 0xffff0005, 0xffff0022,
  0xffff0010, 0xffff0004, 0xffff0004, 0xffff0021,
  0xffff0003, 0xffff0003, 0xffff0003, 0x00000020,
  0xffff0002, 0xffff0002, 0x00000002, 0x0000001f,
  0xffff0001, 0x00000001, 0x00000001, 0x0000001e,
  0x00000000, 0x00000000, 0x00000000, 0x00000010,
  0xffffffff, 0xffffffff, 0xfffffff2, 0xffffffa3,
  0xfffffffe, 0xfffffff1, 0xffffff85, 0xffffffa2,
  0xfffffff0, 0xffffff84, 0xffffff84, 0xffffffa1,
  0xffffff83, 0xffffff83, 0xffffff83, 0xffffcced,
  0xffffff82, 0xffffff82, 0xffffcccf, 0xffffaacb,
  0xffffff81, 0xffffccce, 0xffffaaad, 0xffff8023,
  0xffffcccd, 0xffffaaac, 0xffff8005, 0xffff8022,
  0xffffaaab, 0xffff8004, 0xffff8004, 0xffff8021,
  0xffff8003, 0xffff8003, 0xffff8003, 0xffff8020,
  0xffff8002, 0xffff8002, 0xffff8002, 0xffff801f,
  0xffff8001, 0xffff8001, 0xffff8001, 0xffff5576,
  0xffff8000, 0xffff8000, 0xffff5558, 0xffff3354,
  0xffff7fff, 0xffff5557, 0xffff3336, 0xffff00a0,
  0xffff5556, 0xffff3335, 0xffff0082, 0xffff009f,
  0xffff3334, 0xffff0081, 0xffff0081, 0xffff009e,
  0xffff0080, 0xffff0080, 0xffff0080, 0xffff009d,
  0xffff0080, 0xffff0080, 0xffff009d, 0xffff008d,
  0xffff007f, 0xffff007f, 0xffff0030, 0xffff0080,
  0xffff007e, 0xffff0012, 0xffff0023, 0xffff007f,
  0xffff0011, 0xffff0005, 0xffff0022, 0xffff007e,
  0xffff0004, 0xffff0004, 0xffff0021, 0x0000007d,
  0xffff0003, 0xffff0003, 0x00000020, 0x0000007c,
  0xffff0002, 0x00000002, 0x0000001f, 0x0000007b,
  0x00000001, 0x00000001, 0x0000001e, 0x0000006d,
  0x00000000, 0x00000000, 0x00000010, 0x00000000,
  0xffffffff, 0xfffffff2, 0xffffffa3, 0xffffffff,
  0xfffffff1, 0xffffff85, 0xffffffa2, 0xfffffffe,
  0xffffff84, 0xffffff84, 0xffffffa1, 0xffffcd4a,
  0xffffff83, 0xffffff83, 0xffffcced, 0xffffab28,
  0xffffff82, 0xffffcccf, 0xffffaacb, 0xffff8080,
  0xffffccce, 0xffffaaad, 0xffff8023, 0xffff807f,
  0xffffaaac, 0xffff8005, 0xffff8022, 0xffff807e,
  0xffff8004, 0xffff8004, 0xffff8021, 0xffff807d,
  0xffff8003, 0xffff8003, 0xffff8020, 0xffff807c,
  0xffff8002, 0xffff8002, 0xffff801f, 0xffff55d3,
  0xffff8001, 0xffff8001, 0xffff5576, 0xffff33b1,
  0xffff8000, 0xffff5558, 0xffff3354, 0xffff00fd,
  0xffff5557, 0xffff3336, 0xffff00a0, 0xffff00fc,
  0xffff3335, 0xffff0082, 0xffff009f, 0xffff00fb,
  0xffff0081, 0xffff0081, 0xffff009e, 0xffff00fa,
  0xffff0081, 0xffff009e, 0xffff00fa, 0xffff008e,
  0xffff0080, 0xffff009d, 0xffff008d, 0xffff0081,
  0xffff007f, 0xffff0030, 0xffff0080, 0xffff0080,
  0xffff0012, 0xffff0023, 0xffff007f, 0xffff007f,
  0xffff0005, 0xffff0022, 0xffff007e, 0x0000007e,
  0xffff0004, 0xffff0021, 0x0000007d, 0x0000007d,
  0xffff0003, 0x00000020, 0x0000007c, 0x0000007c,
  0x00000002, 0x0000001f, 0x0000007b, 0x0000006e,
  0x00000001, 0x0000001e, 0x0000006d, 0x00000001,
  0x00000000, 0x00000010, 0x00000000, 0x00000000,
  0xfffffff2, 0xffffffa3, 0xffffffff, 0xffffffff,
  0xffffff85, 0xffffffa2, 0xfffffffe, 0xffffcd4b,
  0xffffff84, 0xffffffa1, 0xffffcd4a, 0xffffab29,
  0xffffff83, 0xffffcced, 0xffffab28, 0xffff8081,
  0xffffcccf, 0xffffaacb, 0xffff8080, 0xffff8080,
  0xffffaaad, 0xffff8023, 0xffff807f, 0xffff807f,
  0xffff8005, 0xffff8022, 0xffff807e, 0xffff807e,
  0xffff8004, 0xffff8021, 0xffff807d, 0xffff807d,
  0xffff8003, 0xffff8020, 0xffff807c, 0xffff55d4,
  0xffff8002, 0xffff801f, 0xffff55d3, 0xffff33b2,
  0xffff8001, 0xffff5576, 0xffff33b1, 0xffff00fe,
  0xffff5558, 0xffff3354, 0xffff00fd, 0xffff00fd,
  0xffff3336, 0xffff00a0, 0xffff00fc, 0xffff00fc,
  0xffff0082, 0xffff009f, 0xffff00fb, 0xffff00fb,
  0xffff009f, 0xffff00fb, 0xffff00fb, 0xffff008f,
  0xffff009e, 0xffff00fa, 0xffff008e, 0xffff0082,
  0xffff009d, 0xffff008d, 0xffff0081, 0xffff0081,
  0xffff0030, 0xffff0080, 0xffff0080, 0xffff0080,
  0xffff0023, 0xffff007f, 0xffff007f, 0x0000007f,
  0xffff0022, 0xffff007e, 0x0000007e, 0x0000007e,
  0xffff0021, 0x0000007d, 0x0000007d, 0x0000007d,
  0x00000020, 0x0000007c, 0x0000007c, 0x0000006f,
  0x0000001f, 0x0000007b, 0x0000006e, 0x00000002,
  0x0000001e, 0x0000006d, 0x00000001, 0x00000001,
  0x00000010, 0x00000000, 0x00000000, 0x00000000,
  0xffffffa3, 0xffffffff, 0xffffffff, 0xffffcd4c,
  0xffffffa2, 0xfffffffe, 0xffffcd4b, 0xffffab2a,
  0xffffffa1, 0xffffcd4a, 0xffffab29, 0xffff8082,
  0xffffcced, 0xffffab28, 0xffff8081, 0xffff8081,
  0xffffaacb, 0xffff8080, 0xffff8080, 0xffff8080,
  0xffff8023, 0xffff807f, 0xffff807f, 0xffff807f,
  0xffff8022, 0xffff807e, 0xffff807e, 0xffff807e,
  0xffff8021, 0xffff807d, 0xffff807d, 0xffff55d5,
  0xffff8020, 0xffff807c, 0xffff55d4, 0xffff33b3,
  0xffff801f, 0xffff55d3, 0xffff33b2, 0xffff00ff,
  0xffff5576, 0xffff33b1, 0xffff00fe, 0xffff00fe,
  0xffff3354, 0xffff00fd, 0xffff00fd, 0xffff00fd,
  0xffff00a0, 0xffff00fc, 0xffff00fc, 0xffff00fc,
  0xffff00fc, 0xffff00fc, 0xffff00fc, 0xffff800d,
  0xffff00fb, 0xffff00fb, 0xffff008f, 0xffff8000,
  0xffff00fa, 0xffff008e, 0xffff0082, 0xffff7fff,
  0xffff008d, 0xffff0081, 0xffff0081, 0xffff7ffe,
  0xffff0080, 0xffff0080, 0xffff0080, 0x00007ffd,
  0xffff007f, 0xffff007f, 0x0000007f, 0x00007ffc,
  0xffff007e, 0x0000007e, 0x0000007e, 0x00007ffb,
  0x0000007d, 0x0000007d, 0x0000007d, 0x00007fed,
  0x0000007c, 0x0000007c, 0x0000006f, 0x00007f80,
  0x0000007b, 0x0000006e, 0x00000002, 0x00007f7f,
  0x0000006d, 0x00000001, 0x00000001, 0x00007f7e,
  0x00000000, 0x00000000, 0x00000000, 0x00004cca,
  0xffffffff, 0xffffffff, 0xffffcd4c, 0x00002aa8,
  0xfffffffe, 0xffffcd4b, 0xffffab2a, 0x00000000,
  0xffffcd4a, 0xffffab29, 0xffff8082, 0xffffffff,
  0xffffab28, 0xffff8081, 0xffff8081, 0xfffffffe,
  0xffff8080, 0xffff8080, 0xffff8080, 0xfffffffd,
  0xffff807f, 0xffff807f, 0xffff807f, 0xfffffffc,
  0xffff807e, 0xffff807e, 0xffff807e, 0xffffd553,
  0xffff807d, 0xffff807d, 0xffff55d5, 0xffffb331,
  0xffff807c, 0xffff55d4, 0xffff33b3, 0xffff807d,
  0xffff55d3, 0xffff33b2, 0xffff00ff, 0xffff807c,
  0xffff33b1, 0xffff00fe, 0xffff00fe, 0xffff807b,
  0xffff00fd, 0xffff00fd, 0xffff00fd, 0xffff807a,
  0xffff00fd, 0xffff00fd, 0xffff807a, 0xffff800e,
  0xffff00fc, 0xffff00fc, 0xffff800d, 0xffff8001,
  0xffff00fb, 0xffff008f, 0xffff8000, 0xffff8000,
  0xffff008e, 0xffff0082, 0xffff7fff, 0xffff7fff,
  0xffff0081, 0xffff0081, 0xffff7ffe, 0x00007ffe,
  0xffff0080, 0xffff0080, 0x00007ffd, 0x00007ffd,
  0xffff007f, 0x0000007f, 0x00007ffc, 0x00007ffc,
  0x0000007e, 0x0000007e, 0x00007ffb, 0x00007fee,
  0x0000007d, 0x0000007d, 0x00007fed, 0x00007f81,
  0x0000007c, 0x0000006f, 0x00007f80, 0x00007f80,
  0x0000006e, 0x00000002, 0x00007f7f, 0x00007f7f,
  0x00000001, 0x00000001, 0x00007f7e, 0x00004ccb,
  0x00000000, 0x00000000, 0x00004cca, 0x00002aa9,
  0xffffffff, 0xffffcd4c, 0x00002aa8, 0x00000001,
  0xffffcd4b, 0xffffab2a, 0x00000000, 0x00000000,
  0xffffab29, 0xffff8082, 0xffffffff, 0xffffffff,
  0xffff8081, 0xffff8081, 0xfffffffe, 0xfffffffe,
  0xffff8080, 0xffff8080, 0xfffffffd, 0xfffffffd,
  0xffff807f, 0xffff807f, 0xfffffffc, 0xffffd554,
  0xffff807e, 0xffff807e, 0xffffd553, 0xffffb332,
  0xffff807d, 0xffff55d5, 0xffffb331, 0xffff807e,
  0xffff55d4, 0xffff33b3, 0xffff807d, 0xffff807d,
  0xffff33b2, 0xffff00ff, 0xffff807c, 0xffff807c,
  0xffff00fe, 0xffff00fe, 0xffff807b, 0xffff807b,
  0xffff00fe, 0xffff807b, 0xffff807b, 0xffff800f,
  0xffff00fd, 0xffff807a, 0xffff800e, 0xffff8002,
  0xffff00fc, 0xffff800d, 0xffff8001, 0xffff8001,
  0xffff008f, 0xffff8000, 0xffff8000, 0xffff8000,
  0xffff0082, 0xffff7fff, 0xffff7fff, 0x00007fff,
  0xffff0081, 0xffff7ffe, 0x00007ffe, 0x00007ffe,
  0xffff0080, 0x00007ffd, 0x00007ffd, 0x00007ffd,
  0x0000007f, 0x00007ffc, 0x00007ffc, 0x00007fef,
  0x0000007e, 0x00007ffb, 0x00007fee, 0x00007f82,
  0x0000007d, 0x00007fed, 0x00007f81, 0x00007f81,
  0x0000006f, 0x00007f80, 0x00007f80, 0x00007f80,
  0x00000002, 0x00007f7f, 0x00007f7f, 0x00004ccc,
  0x00000001, 0x00007f7e, 0x00004ccb, 0x00002aaa,
  0x00000000, 0x00004cca, 0x00002aa9, 0x00000002,
  0xffffcd4c, 0x00002aa8, 0x00000001, 0x00000001,
  0xffffab2a, 0x00000000, 0x00000000, 0x00000000,
  0xffff8082, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffff8081, 0xfffffffe, 0xfffffffe, 0xfffffffe,
  0xffff8080, 0xfffffffd, 0xfffffffd, 0xffffd555,
  0xffff807f, 0xfffffffc, 0xffffd554, 0xffffb333,
  0xffff807e, 0xffffd553, 0xffffb332, 0xffff807f,
  0xffff55d5, 0xffffb331, 0xffff807e, 0xffff807e,
  0xffff33b3, 0xffff807d, 0xffff807d, 0xffff807d,
  0xffff00ff, 0xffff807c, 0xffff807c, 0xffff807c,
  0xffff807c, 0xffff807c, 0xffff807c, 0x33323343,
  0xffff807b, 0xffff807b, 0xffff800f, 0x33323336,
  0xffff807a, 0xffff800e, 0xffff8002, 0x33323335,
  0xffff800d, 0xffff8001, 0xffff8001, 0x33323334,
  0xffff8000, 0xffff8000, 0xffff8000, 0x33333333,
  0xffff7fff, 0xffff7fff, 0x00007fff, 0x33333332,
  0xffff7ffe, 0x00007ffe, 0x00007ffe, 0x33333331,
  0x00007ffd, 0x00007ffd, 0x00007ffd, 0x33333323,
  0x00007ffc, 0x00007ffc, 0x00007fef, 0x333332b6,
  0x00007ffb, 0x00007fee, 0x00007f82, 0x333332b5,
  0x00007fed, 0x00007f81, 0x00007f81, 0x333332b4,
  0x00007f80, 0x00007f80, 0x00007f80, 0x33330000,
  0x00007f7f, 0x00007f7f, 0x00004ccc, 0x3332ddde,
  0x00007f7e, 0x00004ccb, 0x00002aaa, 0x3332b336,
  0x00004cca, 0x00002aa9, 0x00000002, 0x3332b335,
  0x00002aa8, 0x00000001, 0x00000001, 0x3332b334,
  0x00000000, 0x00000000, 0x00000000, 0x3332b333,
  0xffffffff, 0xffffffff, 0xffffffff, 0x3332b332,
  0xfffffffe, 0xfffffffe, 0xfffffffe, 0x33328889,
  0xfffffffd, 0xfffffffd, 0xffffd555, 0x33326667,
  0xfffffffc, 0xffffd554, 0xffffb333, 0x333233b3,
  0xffffd553, 0xffffb332, 0xffff807f, 0x333233b2,
  0xffffb331, 0xffff807e, 0xffff807e, 0x333233b1,
  0xffff807d, 0xffff807d, 0xffff807d, 0x333233b0,
  0xffff807d, 0xffff807d, 0x333233b0, 0x55545565,
  0xffff807c, 0xffff807c, 0x33323343, 0x55545558,
  0xffff807b, 0xffff800f, 0x33323336, 0x55545557,
  0xffff800e, 0xffff8002, 0x33323335, 0x55545556,
  0xffff8001, 0xffff8001, 0x33323334, 0x55555555,
  0xffff8000, 0xffff8000, 0x33333333, 0x55555554,
  0xffff7fff, 0x00007fff, 0x33333332, 0x55555553,
  0x00007ffe, 0x00007ffe, 0x33333331, 0x55555545,
  0x00007ffd, 0x00007ffd, 0x33333323, 0x555554d8,
  0x00007ffc, 0x00007fef, 0x333332b6, 0x555554d7,
  0x00007fee, 0x00007f82, 0x333332b5, 0x555554d6,
  0x00007f81, 0x00007f81, 0x333332b4, 0x55552222,
  0x00007f80, 0x00007f80, 0x33330000, 0x55550000,
  0x00007f7f, 0x00004ccc, 0x3332ddde, 0x5554d558,
  0x00004ccb, 0x00002aaa, 0x3332b336, 0x5554d557,
  0x00002aa9, 0x00000002, 0x3332b335, 0x5554d556,
  0x00000001, 0x00000001, 0x3332b334, 0x5554d555,
  0x00000000, 0x00000000, 0x3332b333, 0x5554d554,
  0xffffffff, 0xffffffff, 0x3332b332, 0x5554aaab,
  0xfffffffe, 0xfffffffe, 0x33328889, 0x55548889,
  0xfffffffd, 0xffffd555, 0x33326667, 0x555455d5,
  0xffffd554, 0xffffb333, 0x333233b3, 0x555455d4,
  0xffffb332, 0xffff807f, 0x333233b2, 0x555455d3,
  0xffff807e, 0xffff807e, 0x333233b1, 0x555455d2,
  0xffff807e, 0x333233b1, 0x555455d2, 0x7fff000d,
  0xffff807d, 0x333233b0, 0x55545565, 0x7fff0000,
  0xffff807c, 0x33323343, 0x55545558, 0x7ffeffff,
  0xffff800f, 0x33323336, 0x55545557, 0x7ffefffe,
  0xffff8002, 0x33323335, 0x55545556, 0x7ffffffd,
  0xffff8001, 0x33323334, 0x55555555, 0x7ffffffc,
  0xffff8000, 0x33333333, 0x55555554, 0x7ffffffb,
  0x00007fff, 0x33333332, 0x55555553, 0x7fffffed,
  0x00007ffe, 0x33333331, 0x55555545, 0x7fffff80,
  0x00007ffd, 0x33333323, 0x555554d8, 0x7fffff7f,
  0x00007fef, 0x333332b6, 0x555554d7, 0x7fffff7e,
  0x00007f82, 0x333332b5, 0x555554d6, 0x7fffccca,
  0x00007f81, 0x333332b4, 0x55552222, 0x7fffaaa8,
  0x00007f80, 0x33330000, 0x55550000, 0x7fff8000,
  0x00004ccc, 0x3332ddde, 0x5554d558, 0x7fff7fff,
  0x00002aaa, 0x3332b336, 0x5554d557, 0x7fff7ffe,
  0x00000002, 0x3332b335, 0x5554d556, 0x7fff7ffd,
  0x00000001, 0x3332b334, 0x5554d555, 0x7fff7ffc,
  0x00000000, 0x3332b333, 0x5554d554, 0x7fff5553,
  0xffffffff, 0x3332b332, 0x5554aaab, 0x7fff3331,
  0xfffffffe, 0x33328889, 0x55548889, 0x7fff007d,
  0xffffd555, 0x33326667, 0x555455d5, 0x7fff007c,
  0xffffb333, 0x333233b3, 0x555455d4, 0x7fff007b,
  0xffff807f, 0x333233b2, 0x555455d3, 0x7fff007a,
  0x333233b2, 0x555455d3, 0x7fff007a, 0x7fff000e,
  0x333233b1, 0x555455d2, 0x7fff000d, 0x7fff0001,
  0x333233b0, 0x55545565, 0x7fff0000, 0x7fff0000,
  0x33323343, 0x55545558, 0x7ffeffff, 0x7ffeffff,
  0x33323336, 0x55545557, 0x7ffefffe, 0x7ffffffe,
  0x33323335, 0x55545556, 0x7ffffffd, 0x7ffffffd,
  0x33323334, 0x55555555, 0x7ffffffc, 0x7ffffffc,
  0x33333333, 0x55555554, 0x7ffffffb, 0x7fffffee,
  0x33333332, 0x55555553, 0x7fffffed, 0x7fffff81,
  0x33333331, 0x55555545, 0x7fffff80, 0x7fffff80,
  0x33333323, 0x555554d8, 0x7fffff7f, 0x7fffff7f,
  0x333332b6, 0x555554d7, 0x7fffff7e, 0x7fffcccb,
  0x333332b5, 0x555554d6, 0x7fffccca, 0x7fffaaa9,
  0x333332b4, 0x55552222, 0x7fffaaa8, 0x7fff8001,
  0x33330000, 0x55550000, 0x7fff8000, 0x7fff8000,
  0x3332ddde, 0x5554d558, 0x7fff7fff, 0x7fff7fff,
  0x3332b336, 0x5554d557, 0x7fff7ffe, 0x7fff7ffe,
  0x3332b335, 0x5554d556, 0x7fff7ffd, 0x7fff7ffd,
  0x3332b334, 0x5554d555, 0x7fff7ffc, 0x7fff5554,
  0x3332b333, 0x5554d554, 0x7fff5553, 0x7fff3332,
  0x3332b332, 0x5554aaab, 0x7fff3331, 0x7fff007e,
  0x33328889, 0x55548889, 0x7fff007d, 0x7fff007d,
  0x33326667, 0x555455d5, 0x7fff007c, 0x7fff007c,
  0x333233b3, 0x555455d4, 0x7fff007b, 0x7fff007b,
  0x555455d4, 0x7fff007b, 0x7fff007b, 0x7fff000f,
  0x555455d3, 0x7fff007a, 0x7fff000e, 0x7fff0002,
  0x555455d2, 0x7fff000d, 0x7fff0001, 0x7fff0001,
  0x55545565, 0x7fff0000, 0x7fff0000, 0x7fff0000,
  0x55545558, 0x7ffeffff, 0x7ffeffff, 0x7fffffff,
  0x55545557, 0x7ffefffe, 0x7ffffffe, 0x7ffffffe,
  0x55545556, 0x7ffffffd, 0x7ffffffd, 0x7ffffffd,
  0x55555555, 0x7ffffffc, 0x7ffffffc, 0x7fffffef,
  0x55555554, 0x7ffffffb, 0x7fffffee, 0x7fffff82,
  0x55555553, 0x7fffffed, 0x7fffff81, 0x7fffff81,
  0x55555545, 0x7fffff80, 0x7fffff80, 0x7fffff80,
  0x555554d8, 0x7fffff7f, 0x7fffff7f, 0x7fffcccc,
  0x555554d7, 0x7fffff7e, 0x7fffcccb, 0x7fffaaaa,
  0x555554d6, 0x7fffccca, 0x7fffaaa9, 0x7fff8002,
  0x55552222, 0x7fffaaa8, 0x7fff8001, 0x7fff8001,
  0x55550000, 0x7fff8000, 0x7fff8000, 0x7fff8000,
  0x5554d558, 0x7fff7fff, 0x7fff7fff, 0x7fff7fff,
  0x5554d557, 0x7fff7ffe, 0x7fff7ffe, 0x7fff7ffe,
  0x5554d556, 0x7fff7ffd, 0x7fff7ffd, 0x7fff5555,
  0x5554d555, 0x7fff7ffc, 0x7fff5554, 0x7fff3333,
  0x5554d554, 0x7fff5553, 0x7fff3332, 0x7fff007f,
  0x5554aaab, 0x7fff3331, 0x7fff007e, 0x7fff007e,
  0x55548889, 0x7fff007d, 0x7fff007d, 0x7fff007d,
  0x555455d5, 0x7fff007c, 0x7fff007c, 0x7fff007c,
  0x7fff007c, 0x7fff007c, 0x7fff007c, 0x7fff0010,
  0x7fff007b, 0x7fff007b, 0x7fff000f, 0x7fff0003,
  0x7fff007a, 0x7fff000e, 0x7fff0002, 0x7fff0002,
  0x7fff000d, 0x7fff0001, 0x7fff0001, 0x7fff0001,
  0x7fff0000, 0x7fff0000, 0x7fff0000, 0x80000000,
  0x7ffeffff, 0x7ffeffff, 0x7fffffff, 0x7fffffff,
  0x7ffefffe, 0x7ffffffe, 0x7ffffffe, 0x7ffffffe,
  0x7ffffffd, 0x7ffffffd, 0x7ffffffd, 0x7ffffff0,
  0x7ffffffc, 0x7ffffffc, 0x7fffffef, 0x7fffff83,
  0x7ffffffb, 0x7fffffee, 0x7fffff82, 0x7fffff82,
  0x7fffffed, 0x7fffff81, 0x7fffff81, 0x7fffff81,
  0x7fffff80, 0x7fffff80, 0x7fffff80, 0x7fffcccd,
  0x7fffff7f, 0x7fffff7f, 0x7fffcccc, 0x7fffaaab,
  0x7fffff7e, 0x7fffcccb, 0x7fffaaaa, 0x7fff8003,
  0x7fffccca, 0x7fffaaa9, 0x7fff8002, 0x7fff8002,
  0x7fffaaa8, 0x7fff8001, 0x7fff8001, 0x7fff8001,
  0x7fff8000, 0x7fff8000, 0x7fff8000, 0x7fff8000,
  0x7fff7fff, 0x7fff7fff, 0x7fff7fff, 0x7fff7fff,
  0x7fff7ffe, 0x7fff7ffe, 0x7fff7ffe, 0x7fff5556,
  0x7fff7ffd, 0x7fff7ffd, 0x7fff5555, 0x7fff3334,
  0x7fff7ffc, 0x7fff5554, 0x7fff3333, 0x7fff0080,
  0x7fff5553, 0x7fff3332, 0x7fff007f, 0x7fff007f,
  0x7fff3331, 0x7fff007e, 0x7fff007e, 0x7fff007e,
  0x7fff007d, 0x7fff007d, 0x7fff007d, 0x7fff007d,
  0x7fff007d, 0x7fff007d, 0x7fff007d, 0x7fff0011,
  0x7fff007c, 0x7fff007c, 0x7fff0010, 0x7fff0004,
  0x7fff007b, 0x7fff000f, 0x7fff0003, 0x7fff0003,
  0x7fff000e, 0x7fff0002, 0x7fff0002, 0x7fff0002,
  0x7fff0001, 0x7fff0001, 0x7fff0001, 0x80000001,
  0x7fff0000, 0x7fff0000, 0x80000000, 0x80000000,
  0x7ffeffff, 0x7fffffff, 0x7fffffff, 0x7fffffff,
  0x7ffffffe, 0x7ffffffe, 0x7ffffffe, 0x7ffffff1,
  0x7ffffffd, 0x7ffffffd, 0x7ffffff0, 0x7fffff84,
  0x7ffffffc, 0x7fffffef, 0x7fffff83, 0x7fffff83,
  0x7fffffee, 0x7fffff82, 0x7fffff82, 0x7fffff82,
  0x7fffff81, 0x7fffff81, 0x7fffff81, 0x7fffccce,
  0x7fffff80, 0x7fffff80, 0x7fffcccd, 0x7fffaaac,
  0x7fffff7f, 0x7fffcccc, 0x7fffaaab, 0x7fff8004,
  0x7fffcccb, 0x7fffaaaa, 0x7fff8003, 0x7fff8003,
  0x7fffaaa9, 0x7fff8002, 0x7fff8002, 0x7fff8002,
  0x7fff8001, 0x7fff8001, 0x7fff8001, 0x7fff8001,
  0x7fff8000, 0x7fff8000, 0x7fff8000, 0x7fff8000,
  0x7fff7fff, 0x7fff7fff, 0x7fff7fff, 0x7fff5557,
  0x7fff7ffe, 0x7fff7ffe, 0x7fff5556, 0x7fff3335,
  0x7fff7ffd, 0x7fff5555, 0x7fff3334, 0x7fff0081,
  0x7fff5554, 0x7fff3333, 0x7fff0080, 0x7fff0080,
  0x7fff3332, 0x7fff007f, 0x7fff007f, 0x7fff007f,
  0x7fff007e, 0x7fff007e, 0x7fff007e, 0x7fff007e,
  0x7fff007e, 0x7fff007e, 0x7fff007e, 0xaaa9aaba,
  0x7fff007d, 0x7fff007d, 0x7fff0011, 0xaaa9aaad,
  0x7fff007c, 0x7fff0010, 0x7fff0004, 0xaaa9aaac,
  0x7fff000f, 0x7fff0003, 0x7fff0003, 0xaaa9aaab,
  0x7fff0002, 0x7fff0002, 0x7fff0002, 0xaaaaaaaa,
  0x7fff0001, 0x7fff0001, 0x80000001, 0xaaaaaaa9,
  0x7fff0000, 0x80000000, 0x80000000, 0xaaaaaaa8,
  0x7fffffff, 0x7fffffff, 0x7fffffff, 0xaaaaaa9a,
  0x7ffffffe, 0x7ffffffe, 0x7ffffff1, 0xaaaaaa2d,
  0x7ffffffd, 0x7ffffff0, 0x7fffff84, 0xaaaaaa2c,
  0x7fffffef, 0x7fffff83, 0x7fffff83, 0xaaaaaa2b,
  0x7fffff82, 0x7fffff82, 0x7fffff82, 0xaaaa7777,
  0x7fffff81, 0x7fffff81, 0x7fffccce, 0xaaaa5555,
  0x7fffff80, 0x7fffcccd, 0x7fffaaac, 0xaaaa2aad,
  0x7fffcccc, 0x7fffaaab, 0x7fff8004, 0xaaaa2aac,
  0x7fffaaaa, 0x7fff8003, 0x7fff8003, 0xaaaa2aab,
  0x7fff8002, 0x7fff8002, 0x7fff8002, 0xaaaa2aaa,
  0x7fff8001, 0x7fff8001, 0x7fff8001, 0xaaaa2aa9,
  0x7fff8000, 0x7fff8000, 0x7fff8000, 0xaaaa0000,
  0x7fff7fff, 0x7fff7fff, 0x7fff5557, 0xaaa9ddde,
  0x7fff7ffe, 0x7fff5556, 0x7fff3335, 0xaaa9ab2a,
  0x7fff5555, 0x7fff3334, 0x7fff0081, 0xaaa9ab29,
  0x7fff3333, 0x7fff0080, 0x7fff0080, 0xaaa9ab28,
  0x7fff007f, 0x7fff007f, 0x7fff007f, 0xaaa9ab27,
  0x7fff007f, 0x7fff007f, 0xaaa9ab27, 0xcccbccdc,
  0x7fff007e, 0x7fff007e, 0xaaa9aaba, 0xcccbcccf,
  0x7fff007d, 0x7fff0011, 0xaaa9aaad, 0xcccbccce,
  0x7fff0010, 0x7fff0004, 0xaaa9aaac, 0xcccbcccd,
  0x7fff0003, 0x7fff0003, 0xaaa9aaab, 0xcccccccc,
  0x7fff0002, 0x7fff0002, 0xaaaaaaaa, 0xcccccccb,
  0x7fff0001, 0x80000001, 0xaaaaaaa9, 0xccccccca,
  0x80000000, 0x80000000, 0xaaaaaaa8, 0xccccccbc,
  0x7fffffff, 0x7fffffff, 0xaaaaaa9a, 0xcccccc4f,
  0x7ffffffe, 0x7ffffff1, 0xaaaaaa2d, 0xcccccc4e,
  0x7ffffff0, 0x7fffff84, 0xaaaaaa2c, 0xcccccc4d,
  0x7fffff83, 0x7fffff83, 0xaaaaaa2b, 0xcccc9999,
  0x7fffff82, 0x7fffff82, 0xaaaa7777, 0xcccc7777,
  0x7fffff81, 0x7fffccce, 0xaaaa5555, 0xcccc4ccf,
  0x7fffcccd, 0x7fffaaac, 0xaaaa2aad, 0xcccc4cce,
  0x7fffaaab, 0x7fff8004, 0xaaaa2aac, 0xcccc4ccd,
  0x7fff8003, 0x7fff8003, 0xaaaa2aab, 0xcccc4ccc,
  0x7fff8002, 0x7fff8002, 0xaaaa2aaa, 0xcccc4ccb,
  0x7fff8001, 0x7fff8001, 0xaaaa2aa9, 0xcccc2222,
  0x7fff8000, 0x7fff8000, 0xaaaa0000, 0xcccc0000,
  0x7fff7fff, 0x7fff5557, 0xaaa9ddde, 0xcccbcd4c,
  0x7fff5556, 0x7fff3335, 0xaaa9ab2a, 0xcccbcd4b,
  0x7fff3334, 0x7fff0081, 0xaaa9ab29, 0xcccbcd4a,
  0x7fff0080, 0x7fff0080, 0xaaa9ab28, 0xcccbcd49,
  0x7fff0080, 0xaaa9ab28, 0xcccbcd49, 0xfffe8010,
  0x7fff007f, 0xaaa9ab27, 0xcccbccdc, 0xfffe8003,
  0x7fff007e, 0xaaa9aaba, 0xcccbcccf, 0xfffe8002,
  0x7fff0011, 0xaaa9aaad, 0xcccbccce, 0xfffe8001,
  0x7fff0004, 0xaaa9aaac, 0xcccbcccd, 0xffff8000,
  0x7fff0003, 0xaaa9aaab, 0xcccccccc, 0xffff7fff,
  0x7fff0002, 0xaaaaaaaa, 0xcccccccb, 0xffff7ffe,
  0x80000001, 0xaaaaaaa9, 0xccccccca, 0xffff7ff0,
  0x80000000, 0xaaaaaaa8, 0xccccccbc, 0xffff7f83,
  0x7fffffff, 0xaaaaaa9a, 0xcccccc4f, 0xffff7f82,
  0x7ffffff1, 0xaaaaaa2d, 0xcccccc4e, 0xffff7f81,
  0x7fffff84, 0xaaaaaa2c, 0xcccccc4d, 0xffff4ccd,
  0x7fffff83, 0xaaaaaa2b, 0xcccc9999, 0xffff2aab,
  0x7fffff82, 0xaaaa7777, 0xcccc7777, 0xffff0003,
  0x7fffccce, 0xaaaa5555, 0xcccc4ccf, 0xffff0002,
  0x7fffaaac, 0xaaaa2aad, 0xcccc4cce, 0xffff0001,
  0x7fff8004, 0xaaaa2aac, 0xcccc4ccd, 0xffff0000,
  0x7fff8003, 0xaaaa2aab, 0xcccc4ccc, 0xfffeffff,
  0x7fff8002, 0xaaaa2aaa, 0xcccc4ccb, 0xfffed556,
  0x7fff8001, 0xaaaa2aa9, 0xcccc2222, 0xfffeb334,
  0x7fff8000, 0xaaaa0000, 0xcccc0000, 0xfffe8080,
  0x7fff5557, 0xaaa9ddde, 0xcccbcd4c, 0xfffe807f,
  0x7fff3335, 0xaaa9ab2a, 0xcccbcd4b, 0xfffe807e,
  0x7fff0081, 0xaaa9ab29, 0xcccbcd4a, 0xfffe807d,
  0xaaa9ab29, 0xcccbcd4a, 0xfffe807d, 0xfffe8011,
  0xaaa9ab28, 0xcccbcd49, 0xfffe8010, 0xfffe8004,
  0xaaa9ab27, 0xcccbccdc, 0xfffe8003, 0xfffe8003,
  0xaaa9aaba, 0xcccbcccf, 0xfffe8002, 0xfffe8002,
  0xaaa9aaad, 0xcccbccce, 0xfffe8001, 0xffff8001,
  0xaaa9aaac, 0xcccbcccd, 0xffff8000, 0xffff8000,
  0xaaa9aaab, 0xcccccccc, 0xffff7fff, 0xffff7fff,
  0xaaaaaaaa, 0xcccccccb, 0xffff7ffe, 0xffff7ff1,
  0xaaaaaaa9, 0xccccccca, 0xffff7ff0, 0xffff7f84,
  0xaaaaaaa8, 0xccccccbc, 0xffff7f83, 0xffff7f83,
  0xaaaaaa9a, 0xcccccc4f, 0xffff7f82, 0xffff7f82,
  0xaaaaaa2d, 0xcccccc4e, 0xffff7f81, 0xffff4cce,
  0xaaaaaa2c, 0xcccccc4d, 0xffff4ccd, 0xffff2aac,
  0xaaaaaa2b, 0xcccc9999, 0xffff2aab, 0xffff0004,
  0xaaaa7777, 0xcccc7777, 0xffff0003, 0xffff0003,
  0xaaaa5555, 0xcccc4ccf, 0xffff0002, 0xffff0002,
  0xaaaa2aad, 0xcccc4cce, 0xffff0001, 0xffff0001,
  0xaaaa2aac, 0xcccc4ccd, 0xffff0000, 0xffff0000,
  0xaaaa2aab, 0xcccc4ccc, 0xfffeffff, 0xfffed557,
  0xaaaa2aaa, 0xcccc4ccb, 0xfffed556, 0xfffeb335,
  0xaaaa2aa9, 0xcccc2222, 0xfffeb334, 0xfffe8081,
  0xaaaa0000, 0xcccc0000, 0xfffe8080, 0xfffe8080,
  0xaaa9ddde, 0xcccbcd4c, 0xfffe807f, 0xfffe807f,
  0xaaa9ab2a, 0xcccbcd4b, 0xfffe807e, 0xfffe807e,
  0xcccbcd4b, 0xfffe807e, 0xfffe807e, 0xfffe8012,
  0xcccbcd4a, 0xfffe807d, 0xfffe8011, 0xfffe8005,
  0xcccbcd49, 0xfffe8010, 0xfffe8004, 0xfffe8004,
  0xcccbccdc, 0xfffe8003, 0xfffe8003, 0xfffe8003,
  0xcccbcccf, 0xfffe8002, 0xfffe8002, 0xffff8002,
  0xcccbccce, 0xfffe8001, 0xffff8001, 0xffff8001,
  0xcccbcccd, 0xffff8000, 0xffff8000, 0xffff8000,
  0xcccccccc, 0xffff7fff, 0xffff7fff, 0xffff7ff2,
  0xcccccccb, 0xffff7ffe, 0xffff7ff1, 0xffff7f85,
  0xccccccca, 0xffff7ff0, 0xffff7f84, 0xffff7f84,
  0xccccccbc, 0xffff7f83, 0xffff7f83, 0xffff7f83,
  0xcccccc4f, 0xffff7f82, 0xffff7f82, 0xffff4ccf,
  0xcccccc4e, 0xffff7f81, 0xffff4cce, 0xffff2aad,
  0xcccccc4d, 0xffff4ccd, 0xffff2aac, 0xffff0005,
  0xcccc9999, 0xffff2aab, 0xffff0004, 0xffff0004,
  0xcccc7777, 0xffff0003, 0xffff0003, 0xffff0003,
  0xcccc4ccf, 0xffff0002, 0xffff0002, 0xffff0002,
  0xcccc4cce, 0xffff0001, 0xffff0001, 0xffff0001,
  0xcccc4ccd, 0xffff0000, 0xffff0000, 0xfffed558,
  0xcccc4ccc, 0xfffeffff, 0xfffed557, 0xfffeb336,
  0xcccc4ccb, 0xfffed556, 0xfffeb335, 0xfffe8082,
  0xcccc2222, 0xfffeb334, 0xfffe8081, 0xfffe8081,
  0xcccc0000, 0xfffe8080, 0xfffe8080, 0xfffe8080,
  0xcccbcd4c, 0xfffe807f, 0xfffe807f, 0xfffe807f,
  0xfffe807f, 0xfffe807f, 0xfffe807f, 0xfffe8013,
  0xfffe807e, 0xfffe807e, 0xfffe8012, 0xfffe8006,
  0xfffe807d, 0xfffe8011, 0xfffe8005, 0xfffe8005,
  0xfffe8010, 0xfffe8004, 0xfffe8004, 0xfffe8004,
  0xfffe8003, 0xfffe8003, 0xfffe8003, 0xffff8003,
  0xfffe8002, 0xfffe8002, 0xffff8002, 0xffff8002,
  0xfffe8001, 0xffff8001, 0xffff8001, 0xffff8001,
  0xffff8000, 0xffff8000, 0xffff8000, 0xffff7ff3,
  0xffff7fff, 0xffff7fff, 0xffff7ff2, 0xffff7f86,
  0xffff7ffe, 0xffff7ff1, 0xffff7f85, 0xffff7f85,
  0xffff7ff0, 0xffff7f84, 0xffff7f84, 0xffff7f84,
  0xffff7f83, 0xffff7f83, 0xffff7f83, 0xffff4cd0,
  0xffff7f82, 0xffff7f82, 0xffff4ccf, 0xffff2aae,
  0xffff7f81, 0xffff4cce, 0xffff2aad, 0xffff0006,
  0xffff4ccd, 0xffff2aac, 0xffff0005, 0xffff0005,
  0xffff2aab, 0xffff0004, 0xffff0004, 0xffff0004,
  0xffff0003, 0xffff0003, 0xffff0003, 0xffff0003,
  0xffff0002, 0xffff0002, 0xffff0002, 0xffff0002,
  0xffff0001, 0xffff0001, 0xffff0001, 0xfffed559,
  0xffff0000, 0xffff0000, 0xfffed558, 0xfffeb337,
  0xfffeffff, 0xfffed557, 0xfffeb336, 0xfffe8083,
  0xfffed556, 0xfffeb335, 0xfffe8082, 0xfffe8082,
  0xfffeb334, 0xfffe8081, 0xfffe8081, 0xfffe8081,
  0xfffe8080, 0xfffe8080, 0xfffe8080, 0xfffe8080,
  0xfffe8080, 0xfffe8080, 0xfffe8080, 0xfffeff90,
  0xfffe807f, 0xfffe807f, 0xfffe8013, 0xfffeff83,
  0xfffe807e, 0xfffe8012, 0xfffe8006, 0xfffeff82,
  0xfffe8011, 0xfffe8005, 0xfffe8005, 0xfffeff81,
  0xfffe8004, 0xfffe8004, 0xfffe8004, 0xffffff80,
  0xfffe8003, 0xfffe8003, 0xffff8003, 0xffffff7f,
  0xfffe8002, 0xffff8002, 0xffff8002, 0xffffff7e,
  0xffff8001, 0xffff8001, 0xffff8001, 0xffffff70,
  0xffff8000, 0xffff8000, 0xffff7ff3, 0xffffff03,
  0xffff7fff, 0xffff7ff2, 0xffff7f86, 0xffffff02,
  0xffff7ff1, 0xffff7f85, 0xffff7f85, 0xffffff01,
  0xffff7f84, 0xffff7f84, 0xffff7f84, 0xffffcc4d,
  0xffff7f83, 0xffff7f83, 0xffff4cd0, 0xffffaa2b,
  0xffff7f82, 0xffff4ccf, 0xffff2aae, 0xffff7f83,
  0xffff4cce, 0xffff2aad, 0xffff0006, 0xffff7f82,
  0xffff2aac, 0xffff0005, 0xffff0005, 0xffff7f81,
  0xffff0004, 0xffff0004, 0xffff0004, 0xffff7f80,
  0xffff0003, 0xffff0003, 0xffff0003, 0xffff7f7f,
  0xffff0002, 0xffff0002, 0xffff0002, 0xffff54d6,
  0xffff0001, 0xffff0001, 0xfffed559, 0xffff32b4,
  0xffff0000, 0xfffed558, 0xfffeb337, 0xffff0000,
  0xfffed557, 0xfffeb336, 0xfffe8083, 0xfffeffff,
  0xfffeb335, 0xfffe8082, 0xfffe8082, 0xfffefffe,
  0xfffe8081, 0xfffe8081, 0xfffe8081, 0xfffefffd,
  0xfffe8081, 0xfffe8081, 0xfffefffd, 0xfffeff91,
  0xfffe8080, 0xfffe8080, 0xfffeff90, 0xfffeff84,
  0xfffe807f, 0xfffe8013, 0xfffeff83, 0xfffeff83,
  0xfffe8012, 0xfffe8006, 0xfffeff82, 0xfffeff82,
  0xfffe8005, 0xfffe8005, 0xfffeff81, 0xffffff81,
  0xfffe8004, 0xfffe8004, 0xffffff80, 0xffffff80,
  0xfffe8003, 0xffff8003, 0xffffff7f, 0xffffff7f,
  0xffff8002, 0xffff8002, 0xffffff7e, 0xffffff71,
  0xffff8001, 0xffff8001, 0xffffff70, 0xffffff04,
  0xffff8000, 0xffff7ff3, 0xffffff03, 0xffffff03,
  0xffff7ff2, 0xffff7f86, 0xffffff02, 0xffffff02,
  0xffff7f85, 0xffff7f85, 0xffffff01, 0xffffcc4e,
  0xffff7f84, 0xffff7f84, 0xffffcc4d, 0xffffaa2c,
  0xffff7f83, 0xffff4cd0, 0xffffaa2b, 0xffff7f84,
  0xffff4ccf, 0xffff2aae, 0xffff7f83, 0xffff7f83,
  0xffff2aad, 0xffff0006, 0xffff7f82, 0xffff7f82,
  0xffff0005, 0xffff0005, 0xffff7f81, 0xffff7f81,
  0xffff0004, 0xffff0004, 0xffff7f80, 0xffff7f80,
  0xffff0003, 0xffff0003, 0xffff7f7f, 0xffff54d7,
  0xffff0002, 0xffff0002, 0xffff54d6, 0xffff32b5,
  0xffff0001, 0xfffed559, 0xffff32b4, 0xffff0001,
  0xfffed558, 0xfffeb337, 0xffff0000, 0xffff0000,
  0xfffeb336, 0xfffe8083, 0xfffeffff, 0xfffeffff,
  0xfffe8082, 0xfffe8082, 0xfffefffe, 0xfffefffe,
  0xfffe8082, 0xfffefffe, 0xfffefffe, 0xfffeff92,
  0xfffe8081, 0xfffefffd, 0xfffeff91, 0xfffeff85,
  0xfffe8080, 0xfffeff90, 0xfffeff84, 0xfffeff84,
  0xfffe8013, 0xfffeff83, 0xfffeff83, 0xfffeff83,
  0xfffe8006, 0xfffeff82, 0xfffeff82, 0xffffff82,
  0xfffe8005, 0xfffeff81, 0xffffff81, 0xffffff81,
  0xfffe8004, 0xffffff80, 0xffffff80, 0xffffff80,
  0xffff8003, 0xffffff7f, 0xffffff7f, 0xffffff72,
  0xffff8002, 0xffffff7e, 0xffffff71, 0xffffff05,
  0xffff8001, 0xffffff70, 0xffffff04, 0xffffff04,
  0xffff7ff3, 0xffffff03, 0xffffff03, 0xffffff03,
  0xffff7f86, 0xffffff02, 0xffffff02, 0xffffcc4f,
  0xffff7f85, 0xffffff01, 0xffffcc4e, 0xffffaa2d,
  0xffff7f84, 0xffffcc4d, 0xffffaa2c, 0xffff7f85,
  0xffff4cd0, 0xffffaa2b, 0xffff7f84, 0xffff7f84,
  0xffff2aae, 0xffff7f83, 0xffff7f83, 0xffff7f83,
  0xffff0006, 0xffff7f82, 0xffff7f82, 0xffff7f82,
  0xffff0005, 0xffff7f81, 0xffff7f81, 0xffff7f81,
  0xffff0004, 0xffff7f80, 0xffff7f80, 0xffff54d8,
  0xffff0003, 0xffff7f7f, 0xffff54d7, 0xffff32b6,
  0xffff0002, 0xffff54d6, 0xffff32b5, 0xffff0002,
  0xfffed559, 0xffff32b4, 0xffff0001, 0xffff0001,
  0xfffeb337, 0xffff0000, 0xffff0000, 0xffff0000,
  0xfffe8083, 0xfffeffff, 0xfffeffff, 0xfffeffff,
  0xfffeffff, 0xfffeffff, 0xfffeffff, 0xfffeff93,
  0xfffefffe, 0xfffefffe, 0xfffeff92, 0xfffeff86,
  0xfffefffd, 0xfffeff91, 0xfffeff85, 0xfffeff85,
  0xfffeff90, 0xfffeff84, 0xfffeff84, 0xfffeff84,
  0xfffeff83, 0xfffeff83, 0xfffeff83, 0xffffff83,
  0xfffeff82, 0xfffeff82, 0xffffff82, 0xffffff82,
  0xfffeff81, 0xffffff81, 0xffffff81, 0xffffff81,
  0xffffff80, 0xffffff80, 0xffffff80, 0xffffff73,
  0xffffff7f, 0xffffff7f, 0xffffff72, 0xffffff06,
  0xffffff7e, 0xffffff71, 0xffffff05, 0xffffff05,
  0xffffff70, 0xffffff04, 0xffffff04, 0xffffff04,
  0xffffff03, 0xffffff03, 0xffffff03, 0xffffcc50,
  0xffffff02, 0xffffff02, 0xffffcc4f, 0xffffaa2e,
  0xffffff01, 0xffffcc4e, 0xffffaa2d, 0xffff7f86,
  0xffffcc4d, 0xffffaa2c, 0xffff7f85, 0xffff7f85,
  0xffffaa2b, 0xffff7f84, 0xffff7f84, 0xffff7f84,
  0xffff7f83, 0xffff7f83, 0xffff7f83, 0xffff7f83,
  0xffff7f82, 0xffff7f82, 0xffff7f82, 0xffff7f82,
  0xffff7f81, 0xffff7f81, 0xffff7f81, 0xffff54d9,
  0xffff7f80, 0xffff7f80, 0xffff54d8, 0xffff32b7,
  0xffff7f7f, 0xffff54d7, 0xffff32b6, 0xffff0003,
  0xffff54d6, 0xffff32b5, 0xffff0002, 0xffff0002,
  0xffff32b4, 0xffff0001, 0xffff0001, 0xffff0001,
  0xffff0000, 0xffff0000, 0xffff0000, 0xffff0000,
  0xffff0000, 0xffff0000, 0xffff0000, 0xfffefff0,
  0xfffeffff, 0xfffeffff, 0xfffeff93, 0xfffeffe3,
  0xfffefffe, 0xfffeff92, 0xfffeff86, 0xfffeffe2,
  0xfffeff91, 0xfffeff85, 0xfffeff85, 0xfffeffe1,
  0xfffeff84, 0xfffeff84, 0xfffeff84, 0xffffffe0,
  0xfffeff83, 0xfffeff83, 0xffffff83, 0xffffffdf,
  0xfffeff82, 0xffffff82, 0xffffff82, 0xffffffde,
  0xffffff81, 0xffffff81, 0xffffff81, 0xffffffd0,
  0xffffff80, 0xffffff80, 0xffffff73, 0xffffff63,
  0xffffff7f, 0xffffff72, 0xffffff06, 0xffffff62,
  0xffffff71, 0xffffff05, 0xffffff05, 0xffffff61,
  0xffffff04, 0xffffff04, 0xffffff04, 0xffffccad,
  0xffffff03, 0xffffff03, 0xffffcc50, 0xffffaa8b,
  0xffffff02, 0xffffcc4f, 0xffffaa2e, 0xffff7fe3,
  0xffffcc4e, 0xffffaa2d, 0xffff7f86, 0xffff7fe2,
  0xffffaa2c, 0xffff7f85, 0xffff7f85, 0xffff7fe1,
  0xffff7f84, 0xffff7f84, 0xffff7f84, 0xffff7fe0,
  0xffff7f83, 0xffff7f83, 0xffff7f83, 0xffff7fdf,
  0xffff7f82, 0xffff7f82, 0xffff7f82, 0xffff5536,
  0xffff7f81, 0xffff7f81, 0xffff54d9, 0xffff3314,
  0xffff7f80, 0xffff54d8, 0xffff32b7, 0xffff0060,
  0xffff54d7, 0xffff32b6, 0xffff0003, 0xffff005f,
  0xffff32b5, 0xffff0002, 0xffff0002, 0xffff005e,
  0xffff0001, 0xffff0001, 0xffff0001, 0xffff005d,
  0xffff0001, 0xffff0001, 0xffff005d, 0xffff000d,
  0xffff0000, 0xffff0000, 0xfffefff0, 0xffff0000,
  0xfffeffff, 0xfffeff93, 0xfffeffe3, 0xfffeffff,
  0xfffeff92, 0xfffeff86, 0xfffeffe2, 0xfffefffe,
  0xfffeff85, 0xfffeff85, 0xfffeffe1, 0xfffffffd,
  0xfffeff84, 0xfffeff84, 0xffffffe0, 0xfffffffc,
  0xfffeff83, 0xffffff83, 0xffffffdf, 0xfffffffb,
  0xffffff82, 0xffffff82, 0xffffffde, 0xffffffed,
  0xffffff81, 0xffffff81, 0xffffffd0, 0xffffff80,
  0xffffff80, 0xffffff73, 0xffffff63, 0xffffff7f,
  0xffffff72, 0xffffff06, 0xffffff62, 0xffffff7e,
  0xffffff05, 0xffffff05, 0xffffff61, 0xffffccca,
  0xffffff04, 0xffffff04, 0xffffccad, 0xffffaaa8,
  0xffffff03, 0xffffcc50, 0xffffaa8b, 0xffff8000,
  0xffffcc4f, 0xffffaa2e, 0xffff7fe3, 0xffff7fff,
  0xffffaa2d, 0xffff7f86, 0xffff7fe2, 0xffff7ffe,
  0xffff7f85, 0xffff7f85, 0xffff7fe1, 0xffff7ffd,
  0xffff7f84, 0xffff7f84, 0xffff7fe0, 0xffff7ffc,
  0xffff7f83, 0xffff7f83, 0xffff7fdf, 0xffff5553,
  0xffff7f82, 0xffff7f82, 0xffff5536, 0xffff3331,
  0xffff7f81, 0xffff54d9, 0xffff3314, 0xffff007d,
  0xffff54d8, 0xffff32b7, 0xffff0060, 0xffff007c,
  0xffff32b6, 0xffff0003, 0xffff005f, 0xffff007b,
  0xffff0002, 0xffff0002, 0xffff005e, 0xffff007a,
  0xffff0002, 0xffff005e, 0xffff007a, 0xffff000e,
  0xffff0001, 0xffff005d, 0xffff000d, 0xffff0001,
  0xffff0000, 0xfffefff0, 0xffff0000, 0xffff0000,
  0xfffeff93, 0xfffeffe3, 0xfffeffff, 0xfffeffff,
  0xfffeff86, 0xfffeffe2, 0xfffefffe, 0xfffffffe,
  0xfffeff85, 0xfffeffe1, 0xfffffffd, 0xfffffffd,
  0xfffeff84, 0xffffffe0, 0xfffffffc, 0xfffffffc,
  0xffffff83, 0xffffffdf, 0xfffffffb, 0xffffffee,
  0xffffff82, 0xffffffde, 0xffffffed, 0xffffff81,
  0xffffff81, 0xffffffd0, 0xffffff80, 0xffffff80,
  0xffffff73, 0xffffff63, 0xffffff7f, 0xffffff7f,
  0xffffff06, 0xffffff62, 0xffffff7e, 0xffffcccb,
  0xffffff05, 0xffffff61, 0xffffccca, 0xffffaaa9,
  0xffffff04, 0xffffccad, 0xffffaaa8, 0xffff8001,
  0xffffcc50, 0xffffaa8b, 0xffff8000, 0xffff8000,
  0xffffaa2e, 0xffff7fe3, 0xffff7fff, 0xffff7fff,
  0xffff7f86, 0xffff7fe2, 0xffff7ffe, 0xffff7ffe,
  0xffff7f85, 0xffff7fe1, 0xffff7ffd, 0xffff7ffd,
  0xffff7f84, 0xffff7fe0, 0xffff7ffc, 0xffff5554,
  0xffff7f83, 0xffff7fdf, 0xffff5553, 0xffff3332,
  0xffff7f82, 0xffff5536, 0xffff3331, 0xffff007e,
  0xffff54d9, 0xffff3314, 0xffff007d, 0xffff007d,
  0xffff32b7, 0xffff0060, 0xffff007c, 0xffff007c,
  0xffff0003, 0xffff005f, 0xffff007b, 0xffff007b,
  0xffff005f, 0xffff007b, 0xffff007b, 0xffff000f,
  0xffff005e, 0xffff007a, 0xffff000e, 0xffff0002,
  0xffff005d, 0xffff000d, 0xffff0001, 0xffff0001,
  0xfffefff0, 0xffff0000, 0xffff0000, 0xffff0000,
  0xfffeffe3, 0xfffeffff, 0xfffeffff, 0xffffffff,
  0xfffeffe2, 0xfffefffe, 0xfffffffe, 0xfffffffe,
  0xfffeffe1, 0xfffffffd, 0xfffffffd, 0xfffffffd,
  0xffffffe0, 0xfffffffc, 0xfffffffc, 0xffffffef,
  0xffffffdf, 0xfffffffb, 0xffffffee, 0xffffff82,
  0xffffffde, 0xffffffed, 0xffffff81, 0xffffff81,
  0xffffffd0, 0xffffff80, 0xffffff80, 0xffffff80,
  0xffffff63, 0xffffff7f, 0xffffff7f, 0xffffcccc,
  0xffffff62, 0xffffff7e, 0xffffcccb, 0xffffaaaa,
  0xffffff61, 0xffffccca, 0xffffaaa9, 0xffff8002,
  0xffffccad, 0xffffaaa8, 0xffff8001, 0xffff8001,
  0xffffaa8b, 0xffff8000, 0xffff8000, 0xffff8000,
  0xffff7fe3, 0xffff7fff, 0xffff7fff, 0xffff7fff,
  0xffff7fe2, 0xffff7ffe, 0xffff7ffe, 0xffff7ffe,
  0xffff7fe1, 0xffff7ffd, 0xffff7ffd, 0xffff5555,
  0xffff7fe0, 0xffff7ffc, 0xffff5554, 0xffff3333,
  0xffff7fdf, 0xffff5553, 0xffff3332, 0xffff007f,
  0xffff5536, 0xffff3331, 0xffff007e, 0xffff007e,
  0xffff3314, 0xffff007d, 0xffff007d, 0xffff007d,
  0xffff0060, 0xffff007c, 0xffff007c, 0xffff007c,
};
const unsigned kExpectedCount_NEON_usubw_4S = 744;

#endif  // VIXL_SIM_USUBW_4S_TRACE_AARCH64_H_
