// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SSHLL2_2D_2OPIMM_TRACE_AARCH64_H_
#define VIXL_SIM_SSHLL2_2D_2OPIMM_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_sshll2_2D_2OPIMM[] = {
  0xffffffffffffffff, 0x0000000000000000,
  0xfffffffffffffffe, 0x0000000000000000,
  0xfffffffffffffffc, 0x0000000000000000,
  0xfffffffffffffff8, 0x0000000000000000,
  0xfffffffffffffff0, 0x0000000000000000,
  0xffffffffffffffe0, 0x0000000000000000,
  0xffffffffffffffc0, 0x0000000000000000,
  0xffffffffffffff80, 0x0000000000000000,
  0xffffffffffffff00, 0x0000000000000000,
  0xfffffffffffffe00, 0x0000000000000000,
  0xfffffffffffffc00, 0x0000000000000000,
  0xfffffffffffff800, 0x0000000000000000,
  0xfffffffffffff000, 0x0000000000000000,
  0xffffffffffffe000, 0x0000000000000000,
  0xffffffffffffc000, 0x0000000000000000,
  0xffffffffffff8000, 0x0000000000000000,
  0xffffffffffff0000, 0x0000000000000000,
  0xfffffffffffe0000, 0x0000000000000000,
  0xfffffffffffc0000, 0x0000000000000000,
  0xfffffffffff80000, 0x0000000000000000,
  0xfffffffffff00000, 0x0000000000000000,
  0xffffffffffe00000, 0x0000000000000000,
  0xffffffffffc00000, 0x0000000000000000,
  0xffffffffff800000, 0x0000000000000000,
  0xffffffffff000000, 0x0000000000000000,
  0xfffffffffe000000, 0x0000000000000000,
  0xfffffffffc000000, 0x0000000000000000,
  0xfffffffff8000000, 0x0000000000000000,
  0xfffffffff0000000, 0x0000000000000000,
  0xffffffffe0000000, 0x0000000000000000,
  0xffffffffc0000000, 0x0000000000000000,
  0xffffffff80000000, 0x0000000000000000,
  0x0000000000000000, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000000, 0x0000000000000004,
  0x0000000000000000, 0x0000000000000008,
  0x0000000000000000, 0x0000000000000010,
  0x0000000000000000, 0x0000000000000020,
  0x0000000000000000, 0x0000000000000040,
  0x0000000000000000, 0x0000000000000080,
  0x0000000000000000, 0x0000000000000100,
  0x0000000000000000, 0x0000000000000200,
  0x0000000000000000, 0x0000000000000400,
  0x0000000000000000, 0x0000000000000800,
  0x0000000000000000, 0x0000000000001000,
  0x0000000000000000, 0x0000000000002000,
  0x0000000000000000, 0x0000000000004000,
  0x0000000000000000, 0x0000000000008000,
  0x0000000000000000, 0x0000000000010000,
  0x0000000000000000, 0x0000000000020000,
  0x0000000000000000, 0x0000000000040000,
  0x0000000000000000, 0x0000000000080000,
  0x0000000000000000, 0x0000000000100000,
  0x0000000000000000, 0x0000000000200000,
  0x0000000000000000, 0x0000000000400000,
  0x0000000000000000, 0x0000000000800000,
  0x0000000000000000, 0x0000000001000000,
  0x0000000000000000, 0x0000000002000000,
  0x0000000000000000, 0x0000000004000000,
  0x0000000000000000, 0x0000000008000000,
  0x0000000000000000, 0x0000000010000000,
  0x0000000000000000, 0x0000000020000000,
  0x0000000000000000, 0x0000000040000000,
  0x0000000000000000, 0x0000000080000000,
  0x0000000000000001, 0x0000000000000002,
  0x0000000000000002, 0x0000000000000004,
  0x0000000000000004, 0x0000000000000008,
  0x0000000000000008, 0x0000000000000010,
  0x0000000000000010, 0x0000000000000020,
  0x0000000000000020, 0x0000000000000040,
  0x0000000000000040, 0x0000000000000080,
  0x0000000000000080, 0x0000000000000100,
  0x0000000000000100, 0x0000000000000200,
  0x0000000000000200, 0x0000000000000400,
  0x0000000000000400, 0x0000000000000800,
  0x0000000000000800, 0x0000000000001000,
  0x0000000000001000, 0x0000000000002000,
  0x0000000000002000, 0x0000000000004000,
  0x0000000000004000, 0x0000000000008000,
  0x0000000000008000, 0x0000000000010000,
  0x0000000000010000, 0x0000000000020000,
  0x0000000000020000, 0x0000000000040000,
  0x0000000000040000, 0x0000000000080000,
  0x0000000000080000, 0x0000000000100000,
  0x0000000000100000, 0x0000000000200000,
  0x0000000000200000, 0x0000000000400000,
  0x0000000000400000, 0x0000000000800000,
  0x0000000000800000, 0x0000000001000000,
  0x0000000001000000, 0x0000000002000000,
  0x0000000002000000, 0x0000000004000000,
  0x0000000004000000, 0x0000000008000000,
  0x0000000008000000, 0x0000000010000000,
  0x0000000010000000, 0x0000000020000000,
  0x0000000020000000, 0x0000000040000000,
  0x0000000040000000, 0x0000000080000000,
  0x0000000080000000, 0x0000000100000000,
  0x0000000000000002, 0x0000000000000020,
  0x0000000000000004, 0x0000000000000040,
  0x0000000000000008, 0x0000000000000080,
  0x0000000000000010, 0x0000000000000100,
  0x0000000000000020, 0x0000000000000200,
  0x0000000000000040, 0x0000000000000400,
  0x0000000000000080, 0x0000000000000800,
  0x0000000000000100, 0x0000000000001000,
  0x0000000000000200, 0x0000000000002000,
  0x0000000000000400, 0x0000000000004000,
  0x0000000000000800, 0x0000000000008000,
  0x0000000000001000, 0x0000000000010000,
  0x0000000000002000, 0x0000000000020000,
  0x0000000000004000, 0x0000000000040000,
  0x0000000000008000, 0x0000000000080000,
  0x0000000000010000, 0x0000000000100000,
  0x0000000000020000, 0x0000000000200000,
  0x0000000000040000, 0x0000000000400000,
  0x0000000000080000, 0x0000000000800000,
  0x0000000000100000, 0x0000000001000000,
  0x0000000000200000, 0x0000000002000000,
  0x0000000000400000, 0x0000000004000000,
  0x0000000000800000, 0x0000000008000000,
  0x0000000001000000, 0x0000000010000000,
  0x0000000002000000, 0x0000000020000000,
  0x0000000004000000, 0x0000000040000000,
  0x0000000008000000, 0x0000000080000000,
  0x0000000010000000, 0x0000000100000000,
  0x0000000020000000, 0x0000000200000000,
  0x0000000040000000, 0x0000000400000000,
  0x0000000080000000, 0x0000000800000000,
  0x0000000100000000, 0x0000001000000000,
  0x0000000000000020, 0x000000000000007d,
  0x0000000000000040, 0x00000000000000fa,
  0x0000000000000080, 0x00000000000001f4,
  0x0000000000000100, 0x00000000000003e8,
  0x0000000000000200, 0x00000000000007d0,
  0x0000000000000400, 0x0000000000000fa0,
  0x0000000000000800, 0x0000000000001f40,
  0x0000000000001000, 0x0000000000003e80,
  0x0000000000002000, 0x0000000000007d00,
  0x0000000000004000, 0x000000000000fa00,
  0x0000000000008000, 0x000000000001f400,
  0x0000000000010000, 0x000000000003e800,
  0x0000000000020000, 0x000000000007d000,
  0x0000000000040000, 0x00000000000fa000,
  0x0000000000080000, 0x00000000001f4000,
  0x0000000000100000, 0x00000000003e8000,
  0x0000000000200000, 0x00000000007d0000,
  0x0000000000400000, 0x0000000000fa0000,
  0x0000000000800000, 0x0000000001f40000,
  0x0000000001000000, 0x0000000003e80000,
  0x0000000002000000, 0x0000000007d00000,
  0x0000000004000000, 0x000000000fa00000,
  0x0000000008000000, 0x000000001f400000,
  0x0000000010000000, 0x000000003e800000,
  0x0000000020000000, 0x000000007d000000,
  0x0000000040000000, 0x00000000fa000000,
  0x0000000080000000, 0x00000001f4000000,
  0x0000000100000000, 0x00000003e8000000,
  0x0000000200000000, 0x00000007d0000000,
  0x0000000400000000, 0x0000000fa0000000,
  0x0000000800000000, 0x0000001f40000000,
  0x0000001000000000, 0x0000003e80000000,
  0x000000000000007d, 0x000000000000007e,
  0x00000000000000fa, 0x00000000000000fc,
  0x00000000000001f4, 0x00000000000001f8,
  0x00000000000003e8, 0x00000000000003f0,
  0x00000000000007d0, 0x00000000000007e0,
  0x0000000000000fa0, 0x0000000000000fc0,
  0x0000000000001f40, 0x0000000000001f80,
  0x0000000000003e80, 0x0000000000003f00,
  0x0000000000007d00, 0x0000000000007e00,
  0x000000000000fa00, 0x000000000000fc00,
  0x000000000001f400, 0x000000000001f800,
  0x000000000003e800, 0x000000000003f000,
  0x000000000007d000, 0x000000000007e000,
  0x00000000000fa000, 0x00000000000fc000,
  0x00000000001f4000, 0x00000000001f8000,
  0x00000000003e8000, 0x00000000003f0000,
  0x00000000007d0000, 0x00000000007e0000,
  0x0000000000fa0000, 0x0000000000fc0000,
  0x0000000001f40000, 0x0000000001f80000,
  0x0000000003e80000, 0x0000000003f00000,
  0x0000000007d00000, 0x0000000007e00000,
  0x000000000fa00000, 0x000000000fc00000,
  0x000000001f400000, 0x000000001f800000,
  0x000000003e800000, 0x000000003f000000,
  0x000000007d000000, 0x000000007e000000,
  0x00000000fa000000, 0x00000000fc000000,
  0x00000001f4000000, 0x00000001f8000000,
  0x00000003e8000000, 0x00000003f0000000,
  0x00000007d0000000, 0x00000007e0000000,
  0x0000000fa0000000, 0x0000000fc0000000,
  0x0000001f40000000, 0x0000001f80000000,
  0x0000003e80000000, 0x0000003f00000000,
  0x000000000000007e, 0x000000000000007f,
  0x00000000000000fc, 0x00000000000000fe,
  0x00000000000001f8, 0x00000000000001fc,
  0x00000000000003f0, 0x00000000000003f8,
  0x00000000000007e0, 0x00000000000007f0,
  0x0000000000000fc0, 0x0000000000000fe0,
  0x0000000000001f80, 0x0000000000001fc0,
  0x0000000000003f00, 0x0000000000003f80,
  0x0000000000007e00, 0x0000000000007f00,
  0x000000000000fc00, 0x000000000000fe00,
  0x000000000001f800, 0x000000000001fc00,
  0x000000000003f000, 0x000000000003f800,
  0x000000000007e000, 0x000000000007f000,
  0x00000000000fc000, 0x00000000000fe000,
  0x00000000001f8000, 0x00000000001fc000,
  0x00000000003f0000, 0x00000000003f8000,
  0x00000000007e0000, 0x00000000007f0000,
  0x0000000000fc0000, 0x0000000000fe0000,
  0x0000000001f80000, 0x0000000001fc0000,
  0x0000000003f00000, 0x0000000003f80000,
  0x0000000007e00000, 0x0000000007f00000,
  0x000000000fc00000, 0x000000000fe00000,
  0x000000001f800000, 0x000000001fc00000,
  0x000000003f000000, 0x000000003f800000,
  0x000000007e000000, 0x000000007f000000,
  0x00000000fc000000, 0x00000000fe000000,
  0x00000001f8000000, 0x00000001fc000000,
  0x00000003f0000000, 0x00000003f8000000,
  0x00000007e0000000, 0x00000007f0000000,
  0x0000000fc0000000, 0x0000000fe0000000,
  0x0000001f80000000, 0x0000001fc0000000,
  0x0000003f00000000, 0x0000003f80000000,
  0x000000000000007f, 0x0000000000007ffd,
  0x00000000000000fe, 0x000000000000fffa,
  0x00000000000001fc, 0x000000000001fff4,
  0x00000000000003f8, 0x000000000003ffe8,
  0x00000000000007f0, 0x000000000007ffd0,
  0x0000000000000fe0, 0x00000000000fffa0,
  0x0000000000001fc0, 0x00000000001fff40,
  0x0000000000003f80, 0x00000000003ffe80,
  0x0000000000007f00, 0x00000000007ffd00,
  0x000000000000fe00, 0x0000000000fffa00,
  0x000000000001fc00, 0x0000000001fff400,
  0x000000000003f800, 0x0000000003ffe800,
  0x000000000007f000, 0x0000000007ffd000,
  0x00000000000fe000, 0x000000000fffa000,
  0x00000000001fc000, 0x000000001fff4000,
  0x00000000003f8000, 0x000000003ffe8000,
  0x00000000007f0000, 0x000000007ffd0000,
  0x0000000000fe0000, 0x00000000fffa0000,
  0x0000000001fc0000, 0x00000001fff40000,
  0x0000000003f80000, 0x00000003ffe80000,
  0x0000000007f00000, 0x00000007ffd00000,
  0x000000000fe00000, 0x0000000fffa00000,
  0x000000001fc00000, 0x0000001fff400000,
  0x000000003f800000, 0x0000003ffe800000,
  0x000000007f000000, 0x0000007ffd000000,
  0x00000000fe000000, 0x000000fffa000000,
  0x00000001fc000000, 0x000001fff4000000,
  0x00000003f8000000, 0x000003ffe8000000,
  0x00000007f0000000, 0x000007ffd0000000,
  0x0000000fe0000000, 0x00000fffa0000000,
  0x0000001fc0000000, 0x00001fff40000000,
  0x0000003f80000000, 0x00003ffe80000000,
  0x0000000000007ffd, 0x0000000000007ffe,
  0x000000000000fffa, 0x000000000000fffc,
  0x000000000001fff4, 0x000000000001fff8,
  0x000000000003ffe8, 0x000000000003fff0,
  0x000000000007ffd0, 0x000000000007ffe0,
  0x00000000000fffa0, 0x00000000000fffc0,
  0x00000000001fff40, 0x00000000001fff80,
  0x00000000003ffe80, 0x00000000003fff00,
  0x00000000007ffd00, 0x00000000007ffe00,
  0x0000000000fffa00, 0x0000000000fffc00,
  0x0000000001fff400, 0x0000000001fff800,
  0x0000000003ffe800, 0x0000000003fff000,
  0x0000000007ffd000, 0x0000000007ffe000,
  0x000000000fffa000, 0x000000000fffc000,
  0x000000001fff4000, 0x000000001fff8000,
  0x000000003ffe8000, 0x000000003fff0000,
  0x000000007ffd0000, 0x000000007ffe0000,
  0x00000000fffa0000, 0x00000000fffc0000,
  0x00000001fff40000, 0x00000001fff80000,
  0x00000003ffe80000, 0x00000003fff00000,
  0x00000007ffd00000, 0x00000007ffe00000,
  0x0000000fffa00000, 0x0000000fffc00000,
  0x0000001fff400000, 0x0000001fff800000,
  0x0000003ffe800000, 0x0000003fff000000,
  0x0000007ffd000000, 0x0000007ffe000000,
  0x000000fffa000000, 0x000000fffc000000,
  0x000001fff4000000, 0x000001fff8000000,
  0x000003ffe8000000, 0x000003fff0000000,
  0x000007ffd0000000, 0x000007ffe0000000,
  0x00000fffa0000000, 0x00000fffc0000000,
  0x00001fff40000000, 0x00001fff80000000,
  0x00003ffe80000000, 0x00003fff00000000,
  0x0000000000007ffe, 0x0000000000007fff,
  0x000000000000fffc, 0x000000000000fffe,
  0x000000000001fff8, 0x000000000001fffc,
  0x000000000003fff0, 0x000000000003fff8,
  0x000000000007ffe0, 0x000000000007fff0,
  0x00000000000fffc0, 0x00000000000fffe0,
  0x00000000001fff80, 0x00000000001fffc0,
  0x00000000003fff00, 0x00000000003fff80,
  0x00000000007ffe00, 0x00000000007fff00,
  0x0000000000fffc00, 0x0000000000fffe00,
  0x0000000001fff800, 0x0000000001fffc00,
  0x0000000003fff000, 0x0000000003fff800,
  0x0000000007ffe000, 0x0000000007fff000,
  0x000000000fffc000, 0x000000000fffe000,
  0x000000001fff8000, 0x000000001fffc000,
  0x000000003fff0000, 0x000000003fff8000,
  0x000000007ffe0000, 0x000000007fff0000,
  0x00000000fffc0000, 0x00000000fffe0000,
  0x00000001fff80000, 0x00000001fffc0000,
  0x00000003fff00000, 0x00000003fff80000,
  0x00000007ffe00000, 0x00000007fff00000,
  0x0000000fffc00000, 0x0000000fffe00000,
  0x0000001fff800000, 0x0000001fffc00000,
  0x0000003fff000000, 0x0000003fff800000,
  0x0000007ffe000000, 0x0000007fff000000,
  0x000000fffc000000, 0x000000fffe000000,
  0x000001fff8000000, 0x000001fffc000000,
  0x000003fff0000000, 0x000003fff8000000,
  0x000007ffe0000000, 0x000007fff0000000,
  0x00000fffc0000000, 0x00000fffe0000000,
  0x00001fff80000000, 0x00001fffc0000000,
  0x00003fff00000000, 0x00003fff80000000,
  0x0000000000007fff, 0x0000000033333333,
  0x000000000000fffe, 0x0000000066666666,
  0x000000000001fffc, 0x00000000cccccccc,
  0x000000000003fff8, 0x0000000199999998,
  0x000000000007fff0, 0x0000000333333330,
  0x00000000000fffe0, 0x0000000666666660,
  0x00000000001fffc0, 0x0000000cccccccc0,
  0x00000000003fff80, 0x0000001999999980,
  0x00000000007fff00, 0x0000003333333300,
  0x0000000000fffe00, 0x0000006666666600,
  0x0000000001fffc00, 0x000000cccccccc00,
  0x0000000003fff800, 0x0000019999999800,
  0x0000000007fff000, 0x0000033333333000,
  0x000000000fffe000, 0x0000066666666000,
  0x000000001fffc000, 0x00000cccccccc000,
  0x000000003fff8000, 0x0000199999998000,
  0x000000007fff0000, 0x0000333333330000,
  0x00000000fffe0000, 0x0000666666660000,
  0x00000001fffc0000, 0x0000cccccccc0000,
  0x00000003fff80000, 0x0001999999980000,
  0x00000007fff00000, 0x0003333333300000,
  0x0000000fffe00000, 0x0006666666600000,
  0x0000001fffc00000, 0x000cccccccc00000,
  0x0000003fff800000, 0x0019999999800000,
  0x0000007fff000000, 0x0033333333000000,
  0x000000fffe000000, 0x0066666666000000,
  0x000001fffc000000, 0x00cccccccc000000,
  0x000003fff8000000, 0x0199999998000000,
  0x000007fff0000000, 0x0333333330000000,
  0x00000fffe0000000, 0x0666666660000000,
  0x00001fffc0000000, 0x0cccccccc0000000,
  0x00003fff80000000, 0x1999999980000000,
  0x0000000033333333, 0x0000000055555555,
  0x0000000066666666, 0x00000000aaaaaaaa,
  0x00000000cccccccc, 0x0000000155555554,
  0x0000000199999998, 0x00000002aaaaaaa8,
  0x0000000333333330, 0x0000000555555550,
  0x0000000666666660, 0x0000000aaaaaaaa0,
  0x0000000cccccccc0, 0x0000001555555540,
  0x0000001999999980, 0x0000002aaaaaaa80,
  0x0000003333333300, 0x0000005555555500,
  0x0000006666666600, 0x000000aaaaaaaa00,
  0x000000cccccccc00, 0x0000015555555400,
  0x0000019999999800, 0x000002aaaaaaa800,
  0x0000033333333000, 0x0000055555555000,
  0x0000066666666000, 0x00000aaaaaaaa000,
  0x00000cccccccc000, 0x0000155555554000,
  0x0000199999998000, 0x00002aaaaaaa8000,
  0x0000333333330000, 0x0000555555550000,
  0x0000666666660000, 0x0000aaaaaaaa0000,
  0x0000cccccccc0000, 0x0001555555540000,
  0x0001999999980000, 0x0002aaaaaaa80000,
  0x0003333333300000, 0x0005555555500000,
  0x0006666666600000, 0x000aaaaaaaa00000,
  0x000cccccccc00000, 0x0015555555400000,
  0x0019999999800000, 0x002aaaaaaa800000,
  0x0033333333000000, 0x0055555555000000,
  0x0066666666000000, 0x00aaaaaaaa000000,
  0x00cccccccc000000, 0x0155555554000000,
  0x0199999998000000, 0x02aaaaaaa8000000,
  0x0333333330000000, 0x0555555550000000,
  0x0666666660000000, 0x0aaaaaaaa0000000,
  0x0cccccccc0000000, 0x1555555540000000,
  0x1999999980000000, 0x2aaaaaaa80000000,
  0x0000000055555555, 0x000000007ffffffd,
  0x00000000aaaaaaaa, 0x00000000fffffffa,
  0x0000000155555554, 0x00000001fffffff4,
  0x00000002aaaaaaa8, 0x00000003ffffffe8,
  0x0000000555555550, 0x00000007ffffffd0,
  0x0000000aaaaaaaa0, 0x0000000fffffffa0,
  0x0000001555555540, 0x0000001fffffff40,
  0x0000002aaaaaaa80, 0x0000003ffffffe80,
  0x0000005555555500, 0x0000007ffffffd00,
  0x000000aaaaaaaa00, 0x000000fffffffa00,
  0x0000015555555400, 0x000001fffffff400,
  0x000002aaaaaaa800, 0x000003ffffffe800,
  0x0000055555555000, 0x000007ffffffd000,
  0x00000aaaaaaaa000, 0x00000fffffffa000,
  0x0000155555554000, 0x00001fffffff4000,
  0x00002aaaaaaa8000, 0x00003ffffffe8000,
  0x0000555555550000, 0x00007ffffffd0000,
  0x0000aaaaaaaa0000, 0x0000fffffffa0000,
  0x0001555555540000, 0x0001fffffff40000,
  0x0002aaaaaaa80000, 0x0003ffffffe80000,
  0x0005555555500000, 0x0007ffffffd00000,
  0x000aaaaaaaa00000, 0x000fffffffa00000,
  0x0015555555400000, 0x001fffffff400000,
  0x002aaaaaaa800000, 0x003ffffffe800000,
  0x0055555555000000, 0x007ffffffd000000,
  0x00aaaaaaaa000000, 0x00fffffffa000000,
  0x0155555554000000, 0x01fffffff4000000,
  0x02aaaaaaa8000000, 0x03ffffffe8000000,
  0x0555555550000000, 0x07ffffffd0000000,
  0x0aaaaaaaa0000000, 0x0fffffffa0000000,
  0x1555555540000000, 0x1fffffff40000000,
  0x2aaaaaaa80000000, 0x3ffffffe80000000,
  0x000000007ffffffd, 0x000000007ffffffe,
  0x00000000fffffffa, 0x00000000fffffffc,
  0x00000001fffffff4, 0x00000001fffffff8,
  0x00000003ffffffe8, 0x00000003fffffff0,
  0x00000007ffffffd0, 0x00000007ffffffe0,
  0x0000000fffffffa0, 0x0000000fffffffc0,
  0x0000001fffffff40, 0x0000001fffffff80,
  0x0000003ffffffe80, 0x0000003fffffff00,
  0x0000007ffffffd00, 0x0000007ffffffe00,
  0x000000fffffffa00, 0x000000fffffffc00,
  0x000001fffffff400, 0x000001fffffff800,
  0x000003ffffffe800, 0x000003fffffff000,
  0x000007ffffffd000, 0x000007ffffffe000,
  0x00000fffffffa000, 0x00000fffffffc000,
  0x00001fffffff4000, 0x00001fffffff8000,
  0x00003ffffffe8000, 0x00003fffffff0000,
  0x00007ffffffd0000, 0x00007ffffffe0000,
  0x0000fffffffa0000, 0x0000fffffffc0000,
  0x0001fffffff40000, 0x0001fffffff80000,
  0x0003ffffffe80000, 0x0003fffffff00000,
  0x0007ffffffd00000, 0x0007ffffffe00000,
  0x000fffffffa00000, 0x000fffffffc00000,
  0x001fffffff400000, 0x001fffffff800000,
  0x003ffffffe800000, 0x003fffffff000000,
  0x007ffffffd000000, 0x007ffffffe000000,
  0x00fffffffa000000, 0x00fffffffc000000,
  0x01fffffff4000000, 0x01fffffff8000000,
  0x03ffffffe8000000, 0x03fffffff0000000,
  0x07ffffffd0000000, 0x07ffffffe0000000,
  0x0fffffffa0000000, 0x0fffffffc0000000,
  0x1fffffff40000000, 0x1fffffff80000000,
  0x3ffffffe80000000, 0x3fffffff00000000,
  0x000000007ffffffe, 0x000000007fffffff,
  0x00000000fffffffc, 0x00000000fffffffe,
  0x00000001fffffff8, 0x00000001fffffffc,
  0x00000003fffffff0, 0x00000003fffffff8,
  0x00000007ffffffe0, 0x00000007fffffff0,
  0x0000000fffffffc0, 0x0000000fffffffe0,
  0x0000001fffffff80, 0x0000001fffffffc0,
  0x0000003fffffff00, 0x0000003fffffff80,
  0x0000007ffffffe00, 0x0000007fffffff00,
  0x000000fffffffc00, 0x000000fffffffe00,
  0x000001fffffff800, 0x000001fffffffc00,
  0x000003fffffff000, 0x000003fffffff800,
  0x000007ffffffe000, 0x000007fffffff000,
  0x00000fffffffc000, 0x00000fffffffe000,
  0x00001fffffff8000, 0x00001fffffffc000,
  0x00003fffffff0000, 0x00003fffffff8000,
  0x00007ffffffe0000, 0x00007fffffff0000,
  0x0000fffffffc0000, 0x0000fffffffe0000,
  0x0001fffffff80000, 0x0001fffffffc0000,
  0x0003fffffff00000, 0x0003fffffff80000,
  0x0007ffffffe00000, 0x0007fffffff00000,
  0x000fffffffc00000, 0x000fffffffe00000,
  0x001fffffff800000, 0x001fffffffc00000,
  0x003fffffff000000, 0x003fffffff800000,
  0x007ffffffe000000, 0x007fffffff000000,
  0x00fffffffc000000, 0x00fffffffe000000,
  0x01fffffff8000000, 0x01fffffffc000000,
  0x03fffffff0000000, 0x03fffffff8000000,
  0x07ffffffe0000000, 0x07fffffff0000000,
  0x0fffffffc0000000, 0x0fffffffe0000000,
  0x1fffffff80000000, 0x1fffffffc0000000,
  0x3fffffff00000000, 0x3fffffff80000000,
  0x000000007fffffff, 0xffffffff80000000,
  0x00000000fffffffe, 0xffffffff00000000,
  0x00000001fffffffc, 0xfffffffe00000000,
  0x00000003fffffff8, 0xfffffffc00000000,
  0x00000007fffffff0, 0xfffffff800000000,
  0x0000000fffffffe0, 0xfffffff000000000,
  0x0000001fffffffc0, 0xffffffe000000000,
  0x0000003fffffff80, 0xffffffc000000000,
  0x0000007fffffff00, 0xffffff8000000000,
  0x000000fffffffe00, 0xffffff0000000000,
  0x000001fffffffc00, 0xfffffe0000000000,
  0x000003fffffff800, 0xfffffc0000000000,
  0x000007fffffff000, 0xfffff80000000000,
  0x00000fffffffe000, 0xfffff00000000000,
  0x00001fffffffc000, 0xffffe00000000000,
  0x00003fffffff8000, 0xffffc00000000000,
  0x00007fffffff0000, 0xffff800000000000,
  0x0000fffffffe0000, 0xffff000000000000,
  0x0001fffffffc0000, 0xfffe000000000000,
  0x0003fffffff80000, 0xfffc000000000000,
  0x0007fffffff00000, 0xfff8000000000000,
  0x000fffffffe00000, 0xfff0000000000000,
  0x001fffffffc00000, 0xffe0000000000000,
  0x003fffffff800000, 0xffc0000000000000,
  0x007fffffff000000, 0xff80000000000000,
  0x00fffffffe000000, 0xff00000000000000,
  0x01fffffffc000000, 0xfe00000000000000,
  0x03fffffff8000000, 0xfc00000000000000,
  0x07fffffff0000000, 0xf800000000000000,
  0x0fffffffe0000000, 0xf000000000000000,
  0x1fffffffc0000000, 0xe000000000000000,
  0x3fffffff80000000, 0xc000000000000000,
  0xffffffff80000000, 0xffffffff80000001,
  0xffffffff00000000, 0xffffffff00000002,
  0xfffffffe00000000, 0xfffffffe00000004,
  0xfffffffc00000000, 0xfffffffc00000008,
  0xfffffff800000000, 0xfffffff800000010,
  0xfffffff000000000, 0xfffffff000000020,
  0xffffffe000000000, 0xffffffe000000040,
  0xffffffc000000000, 0xffffffc000000080,
  0xffffff8000000000, 0xffffff8000000100,
  0xffffff0000000000, 0xffffff0000000200,
  0xfffffe0000000000, 0xfffffe0000000400,
  0xfffffc0000000000, 0xfffffc0000000800,
  0xfffff80000000000, 0xfffff80000001000,
  0xfffff00000000000, 0xfffff00000002000,
  0xffffe00000000000, 0xffffe00000004000,
  0xffffc00000000000, 0xffffc00000008000,
  0xffff800000000000, 0xffff800000010000,
  0xffff000000000000, 0xffff000000020000,
  0xfffe000000000000, 0xfffe000000040000,
  0xfffc000000000000, 0xfffc000000080000,
  0xfff8000000000000, 0xfff8000000100000,
  0xfff0000000000000, 0xfff0000000200000,
  0xffe0000000000000, 0xffe0000000400000,
  0xffc0000000000000, 0xffc0000000800000,
  0xff80000000000000, 0xff80000001000000,
  0xff00000000000000, 0xff00000002000000,
  0xfe00000000000000, 0xfe00000004000000,
  0xfc00000000000000, 0xfc00000008000000,
  0xf800000000000000, 0xf800000010000000,
  0xf000000000000000, 0xf000000020000000,
  0xe000000000000000, 0xe000000040000000,
  0xc000000000000000, 0xc000000080000000,
  0xffffffff80000001, 0xffffffffaaaaaaaa,
  0xffffffff00000002, 0xffffffff55555554,
  0xfffffffe00000004, 0xfffffffeaaaaaaa8,
  0xfffffffc00000008, 0xfffffffd55555550,
  0xfffffff800000010, 0xfffffffaaaaaaaa0,
  0xfffffff000000020, 0xfffffff555555540,
  0xffffffe000000040, 0xffffffeaaaaaaa80,
  0xffffffc000000080, 0xffffffd555555500,
  0xffffff8000000100, 0xffffffaaaaaaaa00,
  0xffffff0000000200, 0xffffff5555555400,
  0xfffffe0000000400, 0xfffffeaaaaaaa800,
  0xfffffc0000000800, 0xfffffd5555555000,
  0xfffff80000001000, 0xfffffaaaaaaaa000,
  0xfffff00000002000, 0xfffff55555554000,
  0xffffe00000004000, 0xffffeaaaaaaa8000,
  0xffffc00000008000, 0xffffd55555550000,
  0xffff800000010000, 0xffffaaaaaaaa0000,
  0xffff000000020000, 0xffff555555540000,
  0xfffe000000040000, 0xfffeaaaaaaa80000,
  0xfffc000000080000, 0xfffd555555500000,
  0xfff8000000100000, 0xfffaaaaaaaa00000,
  0xfff0000000200000, 0xfff5555555400000,
  0xffe0000000400000, 0xffeaaaaaaa800000,
  0xffc0000000800000, 0xffd5555555000000,
  0xff80000001000000, 0xffaaaaaaaa000000,
  0xff00000002000000, 0xff55555554000000,
  0xfe00000004000000, 0xfeaaaaaaa8000000,
  0xfc00000008000000, 0xfd55555550000000,
  0xf800000010000000, 0xfaaaaaaaa0000000,
  0xf000000020000000, 0xf555555540000000,
  0xe000000040000000, 0xeaaaaaaa80000000,
  0xc000000080000000, 0xd555555500000000,
  0xffffffffaaaaaaaa, 0xffffffffcccccccc,
  0xffffffff55555554, 0xffffffff99999998,
  0xfffffffeaaaaaaa8, 0xffffffff33333330,
  0xfffffffd55555550, 0xfffffffe66666660,
  0xfffffffaaaaaaaa0, 0xfffffffcccccccc0,
  0xfffffff555555540, 0xfffffff999999980,
  0xffffffeaaaaaaa80, 0xfffffff333333300,
  0xffffffd555555500, 0xffffffe666666600,
  0xffffffaaaaaaaa00, 0xffffffcccccccc00,
  0xffffff5555555400, 0xffffff9999999800,
  0xfffffeaaaaaaa800, 0xffffff3333333000,
  0xfffffd5555555000, 0xfffffe6666666000,
  0xfffffaaaaaaaa000, 0xfffffcccccccc000,
  0xfffff55555554000, 0xfffff99999998000,
  0xffffeaaaaaaa8000, 0xfffff33333330000,
  0xffffd55555550000, 0xffffe66666660000,
  0xffffaaaaaaaa0000, 0xffffcccccccc0000,
  0xffff555555540000, 0xffff999999980000,
  0xfffeaaaaaaa80000, 0xffff333333300000,
  0xfffd555555500000, 0xfffe666666600000,
  0xfffaaaaaaaa00000, 0xfffcccccccc00000,
  0xfff5555555400000, 0xfff9999999800000,
  0xffeaaaaaaa800000, 0xfff3333333000000,
  0xffd5555555000000, 0xffe6666666000000,
  0xffaaaaaaaa000000, 0xffcccccccc000000,
  0xff55555554000000, 0xff99999998000000,
  0xfeaaaaaaa8000000, 0xff33333330000000,
  0xfd55555550000000, 0xfe66666660000000,
  0xfaaaaaaaa0000000, 0xfcccccccc0000000,
  0xf555555540000000, 0xf999999980000000,
  0xeaaaaaaa80000000, 0xf333333300000000,
  0xd555555500000000, 0xe666666600000000,
  0xffffffffcccccccc, 0xffffffffffff8000,
  0xffffffff99999998, 0xffffffffffff0000,
  0xffffffff33333330, 0xfffffffffffe0000,
  0xfffffffe66666660, 0xfffffffffffc0000,
  0xfffffffcccccccc0, 0xfffffffffff80000,
  0xfffffff999999980, 0xfffffffffff00000,
  0xfffffff333333300, 0xffffffffffe00000,
  0xffffffe666666600, 0xffffffffffc00000,
  0xffffffcccccccc00, 0xffffffffff800000,
  0xffffff9999999800, 0xffffffffff000000,
  0xffffff3333333000, 0xfffffffffe000000,
  0xfffffe6666666000, 0xfffffffffc000000,
  0xfffffcccccccc000, 0xfffffffff8000000,
  0xfffff99999998000, 0xfffffffff0000000,
  0xfffff33333330000, 0xffffffffe0000000,
  0xffffe66666660000, 0xffffffffc0000000,
  0xffffcccccccc0000, 0xffffffff80000000,
  0xffff999999980000, 0xffffffff00000000,
  0xffff333333300000, 0xfffffffe00000000,
  0xfffe666666600000, 0xfffffffc00000000,
  0xfffcccccccc00000, 0xfffffff800000000,
  0xfff9999999800000, 0xfffffff000000000,
  0xfff3333333000000, 0xffffffe000000000,
  0xffe6666666000000, 0xffffffc000000000,
  0xffcccccccc000000, 0xffffff8000000000,
  0xff99999998000000, 0xffffff0000000000,
  0xff33333330000000, 0xfffffe0000000000,
  0xfe66666660000000, 0xfffffc0000000000,
  0xfcccccccc0000000, 0xfffff80000000000,
  0xf999999980000000, 0xfffff00000000000,
  0xf333333300000000, 0xffffe00000000000,
  0xe666666600000000, 0xffffc00000000000,
  0xffffffffffff8000, 0xffffffffffff8001,
  0xffffffffffff0000, 0xffffffffffff0002,
  0xfffffffffffe0000, 0xfffffffffffe0004,
  0xfffffffffffc0000, 0xfffffffffffc0008,
  0xfffffffffff80000, 0xfffffffffff80010,
  0xfffffffffff00000, 0xfffffffffff00020,
  0xffffffffffe00000, 0xffffffffffe00040,
  0xffffffffffc00000, 0xffffffffffc00080,
  0xffffffffff800000, 0xffffffffff800100,
  0xffffffffff000000, 0xffffffffff000200,
  0xfffffffffe000000, 0xfffffffffe000400,
  0xfffffffffc000000, 0xfffffffffc000800,
  0xfffffffff8000000, 0xfffffffff8001000,
  0xfffffffff0000000, 0xfffffffff0002000,
  0xffffffffe0000000, 0xffffffffe0004000,
  0xffffffffc0000000, 0xffffffffc0008000,
  0xffffffff80000000, 0xffffffff80010000,
  0xffffffff00000000, 0xffffffff00020000,
  0xfffffffe00000000, 0xfffffffe00040000,
  0xfffffffc00000000, 0xfffffffc00080000,
  0xfffffff800000000, 0xfffffff800100000,
  0xfffffff000000000, 0xfffffff000200000,
  0xffffffe000000000, 0xffffffe000400000,
  0xffffffc000000000, 0xffffffc000800000,
  0xffffff8000000000, 0xffffff8001000000,
  0xffffff0000000000, 0xffffff0002000000,
  0xfffffe0000000000, 0xfffffe0004000000,
  0xfffffc0000000000, 0xfffffc0008000000,
  0xfffff80000000000, 0xfffff80010000000,
  0xfffff00000000000, 0xfffff00020000000,
  0xffffe00000000000, 0xffffe00040000000,
  0xffffc00000000000, 0xffffc00080000000,
  0xffffffffffff8001, 0xffffffffffff8002,
  0xffffffffffff0002, 0xffffffffffff0004,
  0xfffffffffffe0004, 0xfffffffffffe0008,
  0xfffffffffffc0008, 0xfffffffffffc0010,
  0xfffffffffff80010, 0xfffffffffff80020,
  0xfffffffffff00020, 0xfffffffffff00040,
  0xffffffffffe00040, 0xffffffffffe00080,
  0xffffffffffc00080, 0xffffffffffc00100,
  0xffffffffff800100, 0xffffffffff800200,
  0xffffffffff000200, 0xffffffffff000400,
  0xfffffffffe000400, 0xfffffffffe000800,
  0xfffffffffc000800, 0xfffffffffc001000,
  0xfffffffff8001000, 0xfffffffff8002000,
  0xfffffffff0002000, 0xfffffffff0004000,
  0xffffffffe0004000, 0xffffffffe0008000,
  0xffffffffc0008000, 0xffffffffc0010000,
  0xffffffff80010000, 0xffffffff80020000,
  0xffffffff00020000, 0xffffffff00040000,
  0xfffffffe00040000, 0xfffffffe00080000,
  0xfffffffc00080000, 0xfffffffc00100000,
  0xfffffff800100000, 0xfffffff800200000,
  0xfffffff000200000, 0xfffffff000400000,
  0xffffffe000400000, 0xffffffe000800000,
  0xffffffc000800000, 0xffffffc001000000,
  0xffffff8001000000, 0xffffff8002000000,
  0xffffff0002000000, 0xffffff0004000000,
  0xfffffe0004000000, 0xfffffe0008000000,
  0xfffffc0008000000, 0xfffffc0010000000,
  0xfffff80010000000, 0xfffff80020000000,
  0xfffff00020000000, 0xfffff00040000000,
  0xffffe00040000000, 0xffffe00080000000,
  0xffffc00080000000, 0xffffc00100000000,
  0xffffffffffff8002, 0xffffffffffff8003,
  0xffffffffffff0004, 0xffffffffffff0006,
  0xfffffffffffe0008, 0xfffffffffffe000c,
  0xfffffffffffc0010, 0xfffffffffffc0018,
  0xfffffffffff80020, 0xfffffffffff80030,
  0xfffffffffff00040, 0xfffffffffff00060,
  0xffffffffffe00080, 0xffffffffffe000c0,
  0xffffffffffc00100, 0xffffffffffc00180,
  0xffffffffff800200, 0xffffffffff800300,
  0xffffffffff000400, 0xffffffffff000600,
  0xfffffffffe000800, 0xfffffffffe000c00,
  0xfffffffffc001000, 0xfffffffffc001800,
  0xfffffffff8002000, 0xfffffffff8003000,
  0xfffffffff0004000, 0xfffffffff0006000,
  0xffffffffe0008000, 0xffffffffe000c000,
  0xffffffffc0010000, 0xffffffffc0018000,
  0xffffffff80020000, 0xffffffff80030000,
  0xffffffff00040000, 0xffffffff00060000,
  0xfffffffe00080000, 0xfffffffe000c0000,
  0xfffffffc00100000, 0xfffffffc00180000,
  0xfffffff800200000, 0xfffffff800300000,
  0xfffffff000400000, 0xfffffff000600000,
  0xffffffe000800000, 0xffffffe000c00000,
  0xffffffc001000000, 0xffffffc001800000,
  0xffffff8002000000, 0xffffff8003000000,
  0xffffff0004000000, 0xffffff0006000000,
  0xfffffe0008000000, 0xfffffe000c000000,
  0xfffffc0010000000, 0xfffffc0018000000,
  0xfffff80020000000, 0xfffff80030000000,
  0xfffff00040000000, 0xfffff00060000000,
  0xffffe00080000000, 0xffffe000c0000000,
  0xffffc00100000000, 0xffffc00180000000,
  0xffffffffffff8003, 0xffffffffffffff80,
  0xffffffffffff0006, 0xffffffffffffff00,
  0xfffffffffffe000c, 0xfffffffffffffe00,
  0xfffffffffffc0018, 0xfffffffffffffc00,
  0xfffffffffff80030, 0xfffffffffffff800,
  0xfffffffffff00060, 0xfffffffffffff000,
  0xffffffffffe000c0, 0xffffffffffffe000,
  0xffffffffffc00180, 0xffffffffffffc000,
  0xffffffffff800300, 0xffffffffffff8000,
  0xffffffffff000600, 0xffffffffffff0000,
  0xfffffffffe000c00, 0xfffffffffffe0000,
  0xfffffffffc001800, 0xfffffffffffc0000,
  0xfffffffff8003000, 0xfffffffffff80000,
  0xfffffffff0006000, 0xfffffffffff00000,
  0xffffffffe000c000, 0xffffffffffe00000,
  0xffffffffc0018000, 0xffffffffffc00000,
  0xffffffff80030000, 0xffffffffff800000,
  0xffffffff00060000, 0xffffffffff000000,
  0xfffffffe000c0000, 0xfffffffffe000000,
  0xfffffffc00180000, 0xfffffffffc000000,
  0xfffffff800300000, 0xfffffffff8000000,
  0xfffffff000600000, 0xfffffffff0000000,
  0xffffffe000c00000, 0xffffffffe0000000,
  0xffffffc001800000, 0xffffffffc0000000,
  0xffffff8003000000, 0xffffffff80000000,
  0xffffff0006000000, 0xffffffff00000000,
  0xfffffe000c000000, 0xfffffffe00000000,
  0xfffffc0018000000, 0xfffffffc00000000,
  0xfffff80030000000, 0xfffffff800000000,
  0xfffff00060000000, 0xfffffff000000000,
  0xffffe000c0000000, 0xffffffe000000000,
  0xffffc00180000000, 0xffffffc000000000,
  0xffffffffffffff80, 0xffffffffffffff81,
  0xffffffffffffff00, 0xffffffffffffff02,
  0xfffffffffffffe00, 0xfffffffffffffe04,
  0xfffffffffffffc00, 0xfffffffffffffc08,
  0xfffffffffffff800, 0xfffffffffffff810,
  0xfffffffffffff000, 0xfffffffffffff020,
  0xffffffffffffe000, 0xffffffffffffe040,
  0xffffffffffffc000, 0xffffffffffffc080,
  0xffffffffffff8000, 0xffffffffffff8100,
  0xffffffffffff0000, 0xffffffffffff0200,
  0xfffffffffffe0000, 0xfffffffffffe0400,
  0xfffffffffffc0000, 0xfffffffffffc0800,
  0xfffffffffff80000, 0xfffffffffff81000,
  0xfffffffffff00000, 0xfffffffffff02000,
  0xffffffffffe00000, 0xffffffffffe04000,
  0xffffffffffc00000, 0xffffffffffc08000,
  0xffffffffff800000, 0xffffffffff810000,
  0xffffffffff000000, 0xffffffffff020000,
  0xfffffffffe000000, 0xfffffffffe040000,
  0xfffffffffc000000, 0xfffffffffc080000,
  0xfffffffff8000000, 0xfffffffff8100000,
  0xfffffffff0000000, 0xfffffffff0200000,
  0xffffffffe0000000, 0xffffffffe0400000,
  0xffffffffc0000000, 0xffffffffc0800000,
  0xffffffff80000000, 0xffffffff81000000,
  0xffffffff00000000, 0xffffffff02000000,
  0xfffffffe00000000, 0xfffffffe04000000,
  0xfffffffc00000000, 0xfffffffc08000000,
  0xfffffff800000000, 0xfffffff810000000,
  0xfffffff000000000, 0xfffffff020000000,
  0xffffffe000000000, 0xffffffe040000000,
  0xffffffc000000000, 0xffffffc080000000,
  0xffffffffffffff81, 0xffffffffffffff82,
  0xffffffffffffff02, 0xffffffffffffff04,
  0xfffffffffffffe04, 0xfffffffffffffe08,
  0xfffffffffffffc08, 0xfffffffffffffc10,
  0xfffffffffffff810, 0xfffffffffffff820,
  0xfffffffffffff020, 0xfffffffffffff040,
  0xffffffffffffe040, 0xffffffffffffe080,
  0xffffffffffffc080, 0xffffffffffffc100,
  0xffffffffffff8100, 0xffffffffffff8200,
  0xffffffffffff0200, 0xffffffffffff0400,
  0xfffffffffffe0400, 0xfffffffffffe0800,
  0xfffffffffffc0800, 0xfffffffffffc1000,
  0xfffffffffff81000, 0xfffffffffff82000,
  0xfffffffffff02000, 0xfffffffffff04000,
  0xffffffffffe04000, 0xffffffffffe08000,
  0xffffffffffc08000, 0xffffffffffc10000,
  0xffffffffff810000, 0xffffffffff820000,
  0xffffffffff020000, 0xffffffffff040000,
  0xfffffffffe040000, 0xfffffffffe080000,
  0xfffffffffc080000, 0xfffffffffc100000,
  0xfffffffff8100000, 0xfffffffff8200000,
  0xfffffffff0200000, 0xfffffffff0400000,
  0xffffffffe0400000, 0xffffffffe0800000,
  0xffffffffc0800000, 0xffffffffc1000000,
  0xffffffff81000000, 0xffffffff82000000,
  0xffffffff02000000, 0xffffffff04000000,
  0xfffffffe04000000, 0xfffffffe08000000,
  0xfffffffc08000000, 0xfffffffc10000000,
  0xfffffff810000000, 0xfffffff820000000,
  0xfffffff020000000, 0xfffffff040000000,
  0xffffffe040000000, 0xffffffe080000000,
  0xffffffc080000000, 0xffffffc100000000,
  0xffffffffffffff82, 0xffffffffffffff83,
  0xffffffffffffff04, 0xffffffffffffff06,
  0xfffffffffffffe08, 0xfffffffffffffe0c,
  0xfffffffffffffc10, 0xfffffffffffffc18,
  0xfffffffffffff820, 0xfffffffffffff830,
  0xfffffffffffff040, 0xfffffffffffff060,
  0xffffffffffffe080, 0xffffffffffffe0c0,
  0xffffffffffffc100, 0xffffffffffffc180,
  0xffffffffffff8200, 0xffffffffffff8300,
  0xffffffffffff0400, 0xffffffffffff0600,
  0xfffffffffffe0800, 0xfffffffffffe0c00,
  0xfffffffffffc1000, 0xfffffffffffc1800,
  0xfffffffffff82000, 0xfffffffffff83000,
  0xfffffffffff04000, 0xfffffffffff06000,
  0xffffffffffe08000, 0xffffffffffe0c000,
  0xffffffffffc10000, 0xffffffffffc18000,
  0xffffffffff820000, 0xffffffffff830000,
  0xffffffffff040000, 0xffffffffff060000,
  0xfffffffffe080000, 0xfffffffffe0c0000,
  0xfffffffffc100000, 0xfffffffffc180000,
  0xfffffffff8200000, 0xfffffffff8300000,
  0xfffffffff0400000, 0xfffffffff0600000,
  0xffffffffe0800000, 0xffffffffe0c00000,
  0xffffffffc1000000, 0xffffffffc1800000,
  0xffffffff82000000, 0xffffffff83000000,
  0xffffffff04000000, 0xffffffff06000000,
  0xfffffffe08000000, 0xfffffffe0c000000,
  0xfffffffc10000000, 0xfffffffc18000000,
  0xfffffff820000000, 0xfffffff830000000,
  0xfffffff040000000, 0xfffffff060000000,
  0xffffffe080000000, 0xffffffe0c0000000,
  0xffffffc100000000, 0xffffffc180000000,
  0xffffffffffffff83, 0xffffffffffffffe0,
  0xffffffffffffff06, 0xffffffffffffffc0,
  0xfffffffffffffe0c, 0xffffffffffffff80,
  0xfffffffffffffc18, 0xffffffffffffff00,
  0xfffffffffffff830, 0xfffffffffffffe00,
  0xfffffffffffff060, 0xfffffffffffffc00,
  0xffffffffffffe0c0, 0xfffffffffffff800,
  0xffffffffffffc180, 0xfffffffffffff000,
  0xffffffffffff8300, 0xffffffffffffe000,
  0xffffffffffff0600, 0xffffffffffffc000,
  0xfffffffffffe0c00, 0xffffffffffff8000,
  0xfffffffffffc1800, 0xffffffffffff0000,
  0xfffffffffff83000, 0xfffffffffffe0000,
  0xfffffffffff06000, 0xfffffffffffc0000,
  0xffffffffffe0c000, 0xfffffffffff80000,
  0xffffffffffc18000, 0xfffffffffff00000,
  0xffffffffff830000, 0xffffffffffe00000,
  0xffffffffff060000, 0xffffffffffc00000,
  0xfffffffffe0c0000, 0xffffffffff800000,
  0xfffffffffc180000, 0xffffffffff000000,
  0xfffffffff8300000, 0xfffffffffe000000,
  0xfffffffff0600000, 0xfffffffffc000000,
  0xffffffffe0c00000, 0xfffffffff8000000,
  0xffffffffc1800000, 0xfffffffff0000000,
  0xffffffff83000000, 0xffffffffe0000000,
  0xffffffff06000000, 0xffffffffc0000000,
  0xfffffffe0c000000, 0xffffffff80000000,
  0xfffffffc18000000, 0xffffffff00000000,
  0xfffffff830000000, 0xfffffffe00000000,
  0xfffffff060000000, 0xfffffffc00000000,
  0xffffffe0c0000000, 0xfffffff800000000,
  0xffffffc180000000, 0xfffffff000000000,
  0xffffffffffffffe0, 0xfffffffffffffffd,
  0xffffffffffffffc0, 0xfffffffffffffffa,
  0xffffffffffffff80, 0xfffffffffffffff4,
  0xffffffffffffff00, 0xffffffffffffffe8,
  0xfffffffffffffe00, 0xffffffffffffffd0,
  0xfffffffffffffc00, 0xffffffffffffffa0,
  0xfffffffffffff800, 0xffffffffffffff40,
  0xfffffffffffff000, 0xfffffffffffffe80,
  0xffffffffffffe000, 0xfffffffffffffd00,
  0xffffffffffffc000, 0xfffffffffffffa00,
  0xffffffffffff8000, 0xfffffffffffff400,
  0xffffffffffff0000, 0xffffffffffffe800,
  0xfffffffffffe0000, 0xffffffffffffd000,
  0xfffffffffffc0000, 0xffffffffffffa000,
  0xfffffffffff80000, 0xffffffffffff4000,
  0xfffffffffff00000, 0xfffffffffffe8000,
  0xffffffffffe00000, 0xfffffffffffd0000,
  0xffffffffffc00000, 0xfffffffffffa0000,
  0xffffffffff800000, 0xfffffffffff40000,
  0xffffffffff000000, 0xffffffffffe80000,
  0xfffffffffe000000, 0xffffffffffd00000,
  0xfffffffffc000000, 0xffffffffffa00000,
  0xfffffffff8000000, 0xffffffffff400000,
  0xfffffffff0000000, 0xfffffffffe800000,
  0xffffffffe0000000, 0xfffffffffd000000,
  0xffffffffc0000000, 0xfffffffffa000000,
  0xffffffff80000000, 0xfffffffff4000000,
  0xffffffff00000000, 0xffffffffe8000000,
  0xfffffffe00000000, 0xffffffffd0000000,
  0xfffffffc00000000, 0xffffffffa0000000,
  0xfffffff800000000, 0xffffffff40000000,
  0xfffffff000000000, 0xfffffffe80000000,
  0xfffffffffffffffd, 0xfffffffffffffffe,
  0xfffffffffffffffa, 0xfffffffffffffffc,
  0xfffffffffffffff4, 0xfffffffffffffff8,
  0xffffffffffffffe8, 0xfffffffffffffff0,
  0xffffffffffffffd0, 0xffffffffffffffe0,
  0xffffffffffffffa0, 0xffffffffffffffc0,
  0xffffffffffffff40, 0xffffffffffffff80,
  0xfffffffffffffe80, 0xffffffffffffff00,
  0xfffffffffffffd00, 0xfffffffffffffe00,
  0xfffffffffffffa00, 0xfffffffffffffc00,
  0xfffffffffffff400, 0xfffffffffffff800,
  0xffffffffffffe800, 0xfffffffffffff000,
  0xffffffffffffd000, 0xffffffffffffe000,
  0xffffffffffffa000, 0xffffffffffffc000,
  0xffffffffffff4000, 0xffffffffffff8000,
  0xfffffffffffe8000, 0xffffffffffff0000,
  0xfffffffffffd0000, 0xfffffffffffe0000,
  0xfffffffffffa0000, 0xfffffffffffc0000,
  0xfffffffffff40000, 0xfffffffffff80000,
  0xffffffffffe80000, 0xfffffffffff00000,
  0xffffffffffd00000, 0xffffffffffe00000,
  0xffffffffffa00000, 0xffffffffffc00000,
  0xffffffffff400000, 0xffffffffff800000,
  0xfffffffffe800000, 0xffffffffff000000,
  0xfffffffffd000000, 0xfffffffffe000000,
  0xfffffffffa000000, 0xfffffffffc000000,
  0xfffffffff4000000, 0xfffffffff8000000,
  0xffffffffe8000000, 0xfffffffff0000000,
  0xffffffffd0000000, 0xffffffffe0000000,
  0xffffffffa0000000, 0xffffffffc0000000,
  0xffffffff40000000, 0xffffffff80000000,
  0xfffffffe80000000, 0xffffffff00000000,
  0xfffffffffffffffe, 0xffffffffffffffff,
  0xfffffffffffffffc, 0xfffffffffffffffe,
  0xfffffffffffffff8, 0xfffffffffffffffc,
  0xfffffffffffffff0, 0xfffffffffffffff8,
  0xffffffffffffffe0, 0xfffffffffffffff0,
  0xffffffffffffffc0, 0xffffffffffffffe0,
  0xffffffffffffff80, 0xffffffffffffffc0,
  0xffffffffffffff00, 0xffffffffffffff80,
  0xfffffffffffffe00, 0xffffffffffffff00,
  0xfffffffffffffc00, 0xfffffffffffffe00,
  0xfffffffffffff800, 0xfffffffffffffc00,
  0xfffffffffffff000, 0xfffffffffffff800,
  0xffffffffffffe000, 0xfffffffffffff000,
  0xffffffffffffc000, 0xffffffffffffe000,
  0xffffffffffff8000, 0xffffffffffffc000,
  0xffffffffffff0000, 0xffffffffffff8000,
  0xfffffffffffe0000, 0xffffffffffff0000,
  0xfffffffffffc0000, 0xfffffffffffe0000,
  0xfffffffffff80000, 0xfffffffffffc0000,
  0xfffffffffff00000, 0xfffffffffff80000,
  0xffffffffffe00000, 0xfffffffffff00000,
  0xffffffffffc00000, 0xffffffffffe00000,
  0xffffffffff800000, 0xffffffffffc00000,
  0xffffffffff000000, 0xffffffffff800000,
  0xfffffffffe000000, 0xffffffffff000000,
  0xfffffffffc000000, 0xfffffffffe000000,
  0xfffffffff8000000, 0xfffffffffc000000,
  0xfffffffff0000000, 0xfffffffff8000000,
  0xffffffffe0000000, 0xfffffffff0000000,
  0xffffffffc0000000, 0xffffffffe0000000,
  0xffffffff80000000, 0xffffffffc0000000,
  0xffffffff00000000, 0xffffffff80000000,
};
const unsigned kExpectedCount_NEON_sshll2_2D_2OPIMM = 992;

#endif  // VIXL_SIM_SSHLL2_2D_2OPIMM_TRACE_AARCH64_H_
