// Copyright 2016, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// -----------------------------------------------------------------------------
// This file is auto generated from the
// test/aarch32/config/template-assembler-aarch32.cc.in template file using
// tools/generate_tests.py.
//
// PLEASE DO NOT EDIT.
// -----------------------------------------------------------------------------


#include "test-runner.h"

#include "test-utils.h"
#include "test-utils-aarch32.h"

#include "aarch32/assembler-aarch32.h"
#include "aarch32/macro-assembler-aarch32.h"

#define BUF_SIZE (4096)

namespace vixl {
namespace aarch32 {

// List of instruction mnemonics.
#define FOREACH_INSTRUCTION(M) M(mov)


// The following definitions are defined again in each generated test, therefore
// we need to place them in an anonymous namespace. It expresses that they are
// local to this file only, and the compiler is not allowed to share these types
// across test files during template instantiation. Specifically, `Operands` has
// various layouts across generated tests so it absolutely cannot be shared.

#ifdef VIXL_INCLUDE_TARGET_T32
namespace {

// Values to be passed to the assembler to produce the instruction under test.
struct Operands {
  Condition cond;
  Register rd;
  Register rn;
  ShiftType shift;
  uint32_t amount;
};

// This structure contains all data needed to test one specific
// instruction.
struct TestData {
  // The `operands` field represents what to pass to the assembler to
  // produce the instruction.
  Operands operands;
  // True if we need to generate an IT instruction for this test to be valid.
  bool in_it_block;
  // The condition to give the IT instruction, this will be set to "al" by
  // default.
  Condition it_condition;
  // Description of the operands, used for error reporting.
  const char* operands_description;
  // Unique identifier, used for generating traces.
  const char* identifier;
};

struct TestResult {
  size_t size;
  const byte* encoding;
};

// Each element of this array produce one instruction encoding.
const TestData kTests[] =
    {{{hi, r2, r4, LSL, 10}, true, hi, "hi r2 r4 LSL 10", "hi_r2_r4_LSL_10"},
     {{cs, r6, r2, LSL, 8}, true, cs, "cs r6 r2 LSL 8", "cs_r6_r2_LSL_8"},
     {{lt, r5, r3, LSL, 21}, true, lt, "lt r5 r3 LSL 21", "lt_r5_r3_LSL_21"},
     {{ge, r5, r0, LSL, 3}, true, ge, "ge r5 r0 LSL 3", "ge_r5_r0_LSL_3"},
     {{mi, r4, r1, LSL, 4}, true, mi, "mi r4 r1 LSL 4", "mi_r4_r1_LSL_4"},
     {{ge, r6, r6, LSL, 28}, true, ge, "ge r6 r6 LSL 28", "ge_r6_r6_LSL_28"},
     {{lt, r4, r2, LSL, 31}, true, lt, "lt r4 r2 LSL 31", "lt_r4_r2_LSL_31"},
     {{eq, r0, r3, LSL, 17}, true, eq, "eq r0 r3 LSL 17", "eq_r0_r3_LSL_17"},
     {{vc, r2, r2, LSL, 22}, true, vc, "vc r2 r2 LSL 22", "vc_r2_r2_LSL_22"},
     {{ge, r0, r1, LSL, 6}, true, ge, "ge r0 r1 LSL 6", "ge_r0_r1_LSL_6"},
     {{vs, r6, r0, LSL, 26}, true, vs, "vs r6 r0 LSL 26", "vs_r6_r0_LSL_26"},
     {{vs, r3, r1, LSL, 26}, true, vs, "vs r3 r1 LSL 26", "vs_r3_r1_LSL_26"},
     {{cs, r7, r4, LSL, 28}, true, cs, "cs r7 r4 LSL 28", "cs_r7_r4_LSL_28"},
     {{le, r3, r0, LSL, 28}, true, le, "le r3 r0 LSL 28", "le_r3_r0_LSL_28"},
     {{le, r4, r0, LSL, 23}, true, le, "le r4 r0 LSL 23", "le_r4_r0_LSL_23"},
     {{gt, r5, r3, LSL, 1}, true, gt, "gt r5 r3 LSL 1", "gt_r5_r3_LSL_1"},
     {{hi, r7, r1, LSL, 14}, true, hi, "hi r7 r1 LSL 14", "hi_r7_r1_LSL_14"},
     {{cs, r1, r4, LSL, 27}, true, cs, "cs r1 r4 LSL 27", "cs_r1_r4_LSL_27"},
     {{cc, r1, r0, LSL, 2}, true, cc, "cc r1 r0 LSL 2", "cc_r1_r0_LSL_2"},
     {{le, r5, r2, LSL, 1}, true, le, "le r5 r2 LSL 1", "le_r5_r2_LSL_1"},
     {{gt, r6, r4, LSL, 23}, true, gt, "gt r6 r4 LSL 23", "gt_r6_r4_LSL_23"},
     {{lt, r0, r0, LSL, 27}, true, lt, "lt r0 r0 LSL 27", "lt_r0_r0_LSL_27"},
     {{le, r5, r4, LSL, 6}, true, le, "le r5 r4 LSL 6", "le_r5_r4_LSL_6"},
     {{ls, r2, r0, LSL, 14}, true, ls, "ls r2 r0 LSL 14", "ls_r2_r0_LSL_14"},
     {{mi, r3, r5, LSL, 31}, true, mi, "mi r3 r5 LSL 31", "mi_r3_r5_LSL_31"},
     {{le, r6, r6, LSL, 11}, true, le, "le r6 r6 LSL 11", "le_r6_r6_LSL_11"},
     {{le, r1, r4, LSL, 30}, true, le, "le r1 r4 LSL 30", "le_r1_r4_LSL_30"},
     {{le, r3, r1, LSL, 16}, true, le, "le r3 r1 LSL 16", "le_r3_r1_LSL_16"},
     {{eq, r3, r6, LSL, 12}, true, eq, "eq r3 r6 LSL 12", "eq_r3_r6_LSL_12"},
     {{lt, r4, r5, LSL, 25}, true, lt, "lt r4 r5 LSL 25", "lt_r4_r5_LSL_25"},
     {{ge, r1, r3, LSL, 10}, true, ge, "ge r1 r3 LSL 10", "ge_r1_r3_LSL_10"},
     {{vc, r0, r5, LSL, 20}, true, vc, "vc r0 r5 LSL 20", "vc_r0_r5_LSL_20"},
     {{cc, r0, r7, LSL, 6}, true, cc, "cc r0 r7 LSL 6", "cc_r0_r7_LSL_6"},
     {{vc, r6, r0, LSL, 13}, true, vc, "vc r6 r0 LSL 13", "vc_r6_r0_LSL_13"},
     {{ls, r7, r7, LSL, 11}, true, ls, "ls r7 r7 LSL 11", "ls_r7_r7_LSL_11"},
     {{ls, r2, r3, LSL, 28}, true, ls, "ls r2 r3 LSL 28", "ls_r2_r3_LSL_28"},
     {{le, r2, r1, LSL, 20}, true, le, "le r2 r1 LSL 20", "le_r2_r1_LSL_20"},
     {{ne, r4, r5, LSL, 8}, true, ne, "ne r4 r5 LSL 8", "ne_r4_r5_LSL_8"},
     {{vc, r5, r6, LSL, 5}, true, vc, "vc r5 r6 LSL 5", "vc_r5_r6_LSL_5"},
     {{cc, r6, r1, LSL, 14}, true, cc, "cc r6 r1 LSL 14", "cc_r6_r1_LSL_14"},
     {{cc, r1, r4, LSL, 8}, true, cc, "cc r1 r4 LSL 8", "cc_r1_r4_LSL_8"},
     {{ls, r0, r4, LSL, 24}, true, ls, "ls r0 r4 LSL 24", "ls_r0_r4_LSL_24"},
     {{ls, r4, r4, LSL, 12}, true, ls, "ls r4 r4 LSL 12", "ls_r4_r4_LSL_12"},
     {{eq, r6, r2, LSL, 19}, true, eq, "eq r6 r2 LSL 19", "eq_r6_r2_LSL_19"},
     {{cc, r7, r2, LSL, 16}, true, cc, "cc r7 r2 LSL 16", "cc_r7_r2_LSL_16"},
     {{lt, r7, r3, LSL, 28}, true, lt, "lt r7 r3 LSL 28", "lt_r7_r3_LSL_28"},
     {{hi, r2, r1, LSL, 5}, true, hi, "hi r2 r1 LSL 5", "hi_r2_r1_LSL_5"},
     {{ge, r5, r3, LSL, 26}, true, ge, "ge r5 r3 LSL 26", "ge_r5_r3_LSL_26"},
     {{mi, r0, r0, LSL, 1}, true, mi, "mi r0 r0 LSL 1", "mi_r0_r0_LSL_1"},
     {{vc, r6, r3, LSL, 17}, true, vc, "vc r6 r3 LSL 17", "vc_r6_r3_LSL_17"},
     {{mi, r1, r4, LSL, 16}, true, mi, "mi r1 r4 LSL 16", "mi_r1_r4_LSL_16"},
     {{ge, r1, r3, LSL, 20}, true, ge, "ge r1 r3 LSL 20", "ge_r1_r3_LSL_20"},
     {{eq, r1, r3, LSL, 9}, true, eq, "eq r1 r3 LSL 9", "eq_r1_r3_LSL_9"},
     {{ne, r0, r4, LSL, 27}, true, ne, "ne r0 r4 LSL 27", "ne_r0_r4_LSL_27"},
     {{le, r4, r1, LSL, 12}, true, le, "le r4 r1 LSL 12", "le_r4_r1_LSL_12"},
     {{ne, r7, r7, LSL, 26}, true, ne, "ne r7 r7 LSL 26", "ne_r7_r7_LSL_26"},
     {{hi, r5, r2, LSL, 12}, true, hi, "hi r5 r2 LSL 12", "hi_r5_r2_LSL_12"},
     {{pl, r3, r4, LSL, 9}, true, pl, "pl r3 r4 LSL 9", "pl_r3_r4_LSL_9"},
     {{cs, r5, r3, LSL, 12}, true, cs, "cs r5 r3 LSL 12", "cs_r5_r3_LSL_12"},
     {{vs, r1, r1, LSL, 28}, true, vs, "vs r1 r1 LSL 28", "vs_r1_r1_LSL_28"},
     {{lt, r4, r6, LSL, 19}, true, lt, "lt r4 r6 LSL 19", "lt_r4_r6_LSL_19"},
     {{vc, r6, r6, LSL, 31}, true, vc, "vc r6 r6 LSL 31", "vc_r6_r6_LSL_31"},
     {{cs, r4, r5, LSL, 27}, true, cs, "cs r4 r5 LSL 27", "cs_r4_r5_LSL_27"},
     {{gt, r2, r6, LSL, 2}, true, gt, "gt r2 r6 LSL 2", "gt_r2_r6_LSL_2"},
     {{vc, r6, r4, LSL, 20}, true, vc, "vc r6 r4 LSL 20", "vc_r6_r4_LSL_20"},
     {{ne, r1, r5, LSL, 13}, true, ne, "ne r1 r5 LSL 13", "ne_r1_r5_LSL_13"},
     {{vs, r6, r2, LSL, 4}, true, vs, "vs r6 r2 LSL 4", "vs_r6_r2_LSL_4"},
     {{lt, r5, r3, LSL, 20}, true, lt, "lt r5 r3 LSL 20", "lt_r5_r3_LSL_20"},
     {{le, r3, r0, LSL, 18}, true, le, "le r3 r0 LSL 18", "le_r3_r0_LSL_18"},
     {{ge, r1, r3, LSL, 25}, true, ge, "ge r1 r3 LSL 25", "ge_r1_r3_LSL_25"},
     {{cs, r4, r5, LSL, 23}, true, cs, "cs r4 r5 LSL 23", "cs_r4_r5_LSL_23"},
     {{mi, r0, r3, LSL, 30}, true, mi, "mi r0 r3 LSL 30", "mi_r0_r3_LSL_30"},
     {{ge, r4, r5, LSL, 19}, true, ge, "ge r4 r5 LSL 19", "ge_r4_r5_LSL_19"},
     {{gt, r3, r1, LSL, 20}, true, gt, "gt r3 r1 LSL 20", "gt_r3_r1_LSL_20"},
     {{le, r0, r5, LSL, 20}, true, le, "le r0 r5 LSL 20", "le_r0_r5_LSL_20"},
     {{vs, r0, r6, LSL, 24}, true, vs, "vs r0 r6 LSL 24", "vs_r0_r6_LSL_24"},
     {{le, r5, r6, LSL, 30}, true, le, "le r5 r6 LSL 30", "le_r5_r6_LSL_30"},
     {{ne, r6, r5, LSL, 2}, true, ne, "ne r6 r5 LSL 2", "ne_r6_r5_LSL_2"},
     {{gt, r6, r3, LSL, 2}, true, gt, "gt r6 r3 LSL 2", "gt_r6_r3_LSL_2"},
     {{ls, r4, r4, LSL, 8}, true, ls, "ls r4 r4 LSL 8", "ls_r4_r4_LSL_8"},
     {{cs, r5, r3, LSL, 5}, true, cs, "cs r5 r3 LSL 5", "cs_r5_r3_LSL_5"},
     {{ne, r5, r4, LSL, 23}, true, ne, "ne r5 r4 LSL 23", "ne_r5_r4_LSL_23"},
     {{lt, r0, r0, LSL, 14}, true, lt, "lt r0 r0 LSL 14", "lt_r0_r0_LSL_14"},
     {{cc, r3, r4, LSL, 12}, true, cc, "cc r3 r4 LSL 12", "cc_r3_r4_LSL_12"},
     {{vc, r3, r7, LSL, 25}, true, vc, "vc r3 r7 LSL 25", "vc_r3_r7_LSL_25"},
     {{ge, r2, r3, LSL, 21}, true, ge, "ge r2 r3 LSL 21", "ge_r2_r3_LSL_21"},
     {{gt, r3, r3, LSL, 17}, true, gt, "gt r3 r3 LSL 17", "gt_r3_r3_LSL_17"},
     {{mi, r3, r5, LSL, 21}, true, mi, "mi r3 r5 LSL 21", "mi_r3_r5_LSL_21"},
     {{hi, r2, r5, LSL, 30}, true, hi, "hi r2 r5 LSL 30", "hi_r2_r5_LSL_30"},
     {{ls, r2, r5, LSL, 12}, true, ls, "ls r2 r5 LSL 12", "ls_r2_r5_LSL_12"},
     {{cc, r4, r6, LSL, 1}, true, cc, "cc r4 r6 LSL 1", "cc_r4_r6_LSL_1"},
     {{cc, r1, r1, LSL, 24}, true, cc, "cc r1 r1 LSL 24", "cc_r1_r1_LSL_24"},
     {{vc, r3, r2, LSL, 24}, true, vc, "vc r3 r2 LSL 24", "vc_r3_r2_LSL_24"},
     {{le, r0, r5, LSL, 18}, true, le, "le r0 r5 LSL 18", "le_r0_r5_LSL_18"},
     {{eq, r7, r1, LSL, 23}, true, eq, "eq r7 r1 LSL 23", "eq_r7_r1_LSL_23"},
     {{lt, r2, r3, LSL, 3}, true, lt, "lt r2 r3 LSL 3", "lt_r2_r3_LSL_3"},
     {{pl, r2, r0, LSL, 27}, true, pl, "pl r2 r0 LSL 27", "pl_r2_r0_LSL_27"},
     {{mi, r5, r4, LSL, 19}, true, mi, "mi r5 r4 LSL 19", "mi_r5_r4_LSL_19"},
     {{gt, r3, r2, LSL, 2}, true, gt, "gt r3 r2 LSL 2", "gt_r3_r2_LSL_2"},
     {{lt, r5, r0, LSL, 14}, true, lt, "lt r5 r0 LSL 14", "lt_r5_r0_LSL_14"},
     {{cc, r4, r3, LSL, 25}, true, cc, "cc r4 r3 LSL 25", "cc_r4_r3_LSL_25"},
     {{cs, r4, r7, LSL, 15}, true, cs, "cs r4 r7 LSL 15", "cs_r4_r7_LSL_15"},
     {{ls, r2, r5, LSL, 10}, true, ls, "ls r2 r5 LSL 10", "ls_r2_r5_LSL_10"},
     {{cc, r2, r6, LSL, 17}, true, cc, "cc r2 r6 LSL 17", "cc_r2_r6_LSL_17"},
     {{hi, r6, r3, LSL, 12}, true, hi, "hi r6 r3 LSL 12", "hi_r6_r3_LSL_12"},
     {{cc, r4, r0, LSL, 26}, true, cc, "cc r4 r0 LSL 26", "cc_r4_r0_LSL_26"},
     {{ls, r4, r2, LSL, 29}, true, ls, "ls r4 r2 LSL 29", "ls_r4_r2_LSL_29"},
     {{ls, r4, r2, LSL, 8}, true, ls, "ls r4 r2 LSL 8", "ls_r4_r2_LSL_8"},
     {{vs, r7, r5, LSL, 1}, true, vs, "vs r7 r5 LSL 1", "vs_r7_r5_LSL_1"},
     {{eq, r1, r5, LSL, 11}, true, eq, "eq r1 r5 LSL 11", "eq_r1_r5_LSL_11"},
     {{vc, r4, r2, LSL, 24}, true, vc, "vc r4 r2 LSL 24", "vc_r4_r2_LSL_24"},
     {{cs, r7, r2, LSL, 15}, true, cs, "cs r7 r2 LSL 15", "cs_r7_r2_LSL_15"},
     {{vs, r7, r1, LSL, 9}, true, vs, "vs r7 r1 LSL 9", "vs_r7_r1_LSL_9"},
     {{pl, r7, r4, LSL, 11}, true, pl, "pl r7 r4 LSL 11", "pl_r7_r4_LSL_11"},
     {{ne, r3, r6, LSL, 19}, true, ne, "ne r3 r6 LSL 19", "ne_r3_r6_LSL_19"},
     {{ne, r6, r4, LSL, 9}, true, ne, "ne r6 r4 LSL 9", "ne_r6_r4_LSL_9"},
     {{le, r1, r7, LSL, 13}, true, le, "le r1 r7 LSL 13", "le_r1_r7_LSL_13"},
     {{vc, r2, r3, LSL, 19}, true, vc, "vc r2 r3 LSL 19", "vc_r2_r3_LSL_19"},
     {{mi, r2, r6, LSL, 3}, true, mi, "mi r2 r6 LSL 3", "mi_r2_r6_LSL_3"},
     {{eq, r3, r0, LSL, 30}, true, eq, "eq r3 r0 LSL 30", "eq_r3_r0_LSL_30"},
     {{le, r6, r2, LSL, 3}, true, le, "le r6 r2 LSL 3", "le_r6_r2_LSL_3"},
     {{ne, r5, r7, LSL, 22}, true, ne, "ne r5 r7 LSL 22", "ne_r5_r7_LSL_22"},
     {{vs, r7, r4, LSL, 19}, true, vs, "vs r7 r4 LSL 19", "vs_r7_r4_LSL_19"},
     {{eq, r6, r7, LSL, 20}, true, eq, "eq r6 r7 LSL 20", "eq_r6_r7_LSL_20"},
     {{cs, r2, r7, LSL, 19}, true, cs, "cs r2 r7 LSL 19", "cs_r2_r7_LSL_19"},
     {{cs, r3, r1, LSL, 17}, true, cs, "cs r3 r1 LSL 17", "cs_r3_r1_LSL_17"},
     {{vs, r5, r3, LSL, 11}, true, vs, "vs r5 r3 LSL 11", "vs_r5_r3_LSL_11"},
     {{le, r5, r6, LSL, 27}, true, le, "le r5 r6 LSL 27", "le_r5_r6_LSL_27"},
     {{vs, r7, r0, LSL, 27}, true, vs, "vs r7 r0 LSL 27", "vs_r7_r0_LSL_27"},
     {{lt, r2, r0, LSL, 29}, true, lt, "lt r2 r0 LSL 29", "lt_r2_r0_LSL_29"},
     {{vc, r0, r0, LSL, 11}, true, vc, "vc r0 r0 LSL 11", "vc_r0_r0_LSL_11"},
     {{cc, r6, r3, LSL, 16}, true, cc, "cc r6 r3 LSL 16", "cc_r6_r3_LSL_16"},
     {{cs, r0, r0, LSL, 16}, true, cs, "cs r0 r0 LSL 16", "cs_r0_r0_LSL_16"},
     {{pl, r4, r4, LSL, 24}, true, pl, "pl r4 r4 LSL 24", "pl_r4_r4_LSL_24"},
     {{mi, r6, r7, LSL, 22}, true, mi, "mi r6 r7 LSL 22", "mi_r6_r7_LSL_22"},
     {{vc, r1, r6, LSL, 15}, true, vc, "vc r1 r6 LSL 15", "vc_r1_r6_LSL_15"},
     {{ls, r6, r7, LSL, 18}, true, ls, "ls r6 r7 LSL 18", "ls_r6_r7_LSL_18"},
     {{vc, r1, r1, LSL, 22}, true, vc, "vc r1 r1 LSL 22", "vc_r1_r1_LSL_22"},
     {{lt, r3, r0, LSL, 13}, true, lt, "lt r3 r0 LSL 13", "lt_r3_r0_LSL_13"},
     {{pl, r2, r2, LSL, 25}, true, pl, "pl r2 r2 LSL 25", "pl_r2_r2_LSL_25"},
     {{hi, r3, r2, LSL, 30}, true, hi, "hi r3 r2 LSL 30", "hi_r3_r2_LSL_30"},
     {{vs, r5, r0, LSL, 1}, true, vs, "vs r5 r0 LSL 1", "vs_r5_r0_LSL_1"},
     {{gt, r5, r0, LSL, 6}, true, gt, "gt r5 r0 LSL 6", "gt_r5_r0_LSL_6"},
     {{cs, r7, r0, LSL, 3}, true, cs, "cs r7 r0 LSL 3", "cs_r7_r0_LSL_3"},
     {{ne, r4, r6, LSL, 9}, true, ne, "ne r4 r6 LSL 9", "ne_r4_r6_LSL_9"},
     {{ge, r2, r0, LSL, 4}, true, ge, "ge r2 r0 LSL 4", "ge_r2_r0_LSL_4"},
     {{pl, r6, r5, LSL, 16}, true, pl, "pl r6 r5 LSL 16", "pl_r6_r5_LSL_16"},
     {{lt, r5, r6, LSL, 8}, true, lt, "lt r5 r6 LSL 8", "lt_r5_r6_LSL_8"},
     {{hi, r2, r2, LSL, 2}, true, hi, "hi r2 r2 LSL 2", "hi_r2_r2_LSL_2"},
     {{pl, r6, r2, LSL, 16}, true, pl, "pl r6 r2 LSL 16", "pl_r6_r2_LSL_16"},
     {{cs, r2, r2, LSL, 14}, true, cs, "cs r2 r2 LSL 14", "cs_r2_r2_LSL_14"},
     {{mi, r2, r4, LSL, 25}, true, mi, "mi r2 r4 LSL 25", "mi_r2_r4_LSL_25"},
     {{mi, r0, r5, LSL, 4}, true, mi, "mi r0 r5 LSL 4", "mi_r0_r5_LSL_4"},
     {{hi, r0, r6, LSL, 6}, true, hi, "hi r0 r6 LSL 6", "hi_r0_r6_LSL_6"},
     {{cs, r1, r3, LSL, 16}, true, cs, "cs r1 r3 LSL 16", "cs_r1_r3_LSL_16"},
     {{le, r0, r6, LSL, 25}, true, le, "le r0 r6 LSL 25", "le_r0_r6_LSL_25"},
     {{gt, r6, r1, LSL, 22}, true, gt, "gt r6 r1 LSL 22", "gt_r6_r1_LSL_22"},
     {{cc, r4, r2, LSL, 6}, true, cc, "cc r4 r2 LSL 6", "cc_r4_r2_LSL_6"},
     {{eq, r6, r2, LSL, 23}, true, eq, "eq r6 r2 LSL 23", "eq_r6_r2_LSL_23"},
     {{hi, r2, r5, LSL, 11}, true, hi, "hi r2 r5 LSL 11", "hi_r2_r5_LSL_11"},
     {{eq, r0, r6, LSL, 12}, true, eq, "eq r0 r6 LSL 12", "eq_r0_r6_LSL_12"},
     {{pl, r1, r7, LSL, 16}, true, pl, "pl r1 r7 LSL 16", "pl_r1_r7_LSL_16"},
     {{ne, r4, r3, LSL, 11}, true, ne, "ne r4 r3 LSL 11", "ne_r4_r3_LSL_11"},
     {{pl, r1, r1, LSL, 25}, true, pl, "pl r1 r1 LSL 25", "pl_r1_r1_LSL_25"},
     {{gt, r3, r0, LSL, 1}, true, gt, "gt r3 r0 LSL 1", "gt_r3_r0_LSL_1"},
     {{cs, r1, r2, LSL, 25}, true, cs, "cs r1 r2 LSL 25", "cs_r1_r2_LSL_25"},
     {{pl, r4, r1, LSL, 13}, true, pl, "pl r4 r1 LSL 13", "pl_r4_r1_LSL_13"},
     {{lt, r0, r7, LSL, 30}, true, lt, "lt r0 r7 LSL 30", "lt_r0_r7_LSL_30"},
     {{vc, r3, r6, LSL, 17}, true, vc, "vc r3 r6 LSL 17", "vc_r3_r6_LSL_17"},
     {{ne, r7, r6, LSL, 14}, true, ne, "ne r7 r6 LSL 14", "ne_r7_r6_LSL_14"},
     {{hi, r0, r2, LSL, 2}, true, hi, "hi r0 r2 LSL 2", "hi_r0_r2_LSL_2"},
     {{hi, r2, r3, LSL, 19}, true, hi, "hi r2 r3 LSL 19", "hi_r2_r3_LSL_19"},
     {{cs, r1, r5, LSL, 6}, true, cs, "cs r1 r5 LSL 6", "cs_r1_r5_LSL_6"},
     {{mi, r6, r7, LSL, 9}, true, mi, "mi r6 r7 LSL 9", "mi_r6_r7_LSL_9"},
     {{ls, r5, r4, LSL, 20}, true, ls, "ls r5 r4 LSL 20", "ls_r5_r4_LSL_20"},
     {{gt, r5, r7, LSL, 14}, true, gt, "gt r5 r7 LSL 14", "gt_r5_r7_LSL_14"},
     {{pl, r0, r3, LSL, 2}, true, pl, "pl r0 r3 LSL 2", "pl_r0_r3_LSL_2"},
     {{ls, r0, r3, LSL, 16}, true, ls, "ls r0 r3 LSL 16", "ls_r0_r3_LSL_16"},
     {{gt, r7, r7, LSL, 26}, true, gt, "gt r7 r7 LSL 26", "gt_r7_r7_LSL_26"},
     {{vc, r1, r7, LSL, 6}, true, vc, "vc r1 r7 LSL 6", "vc_r1_r7_LSL_6"},
     {{cs, r6, r4, LSL, 31}, true, cs, "cs r6 r4 LSL 31", "cs_r6_r4_LSL_31"},
     {{ls, r7, r1, LSL, 8}, true, ls, "ls r7 r1 LSL 8", "ls_r7_r1_LSL_8"},
     {{eq, r6, r4, LSL, 7}, true, eq, "eq r6 r4 LSL 7", "eq_r6_r4_LSL_7"},
     {{le, r0, r3, LSL, 12}, true, le, "le r0 r3 LSL 12", "le_r0_r3_LSL_12"},
     {{eq, r7, r1, LSL, 5}, true, eq, "eq r7 r1 LSL 5", "eq_r7_r1_LSL_5"},
     {{mi, r4, r4, LSL, 23}, true, mi, "mi r4 r4 LSL 23", "mi_r4_r4_LSL_23"},
     {{vc, r6, r2, LSL, 20}, true, vc, "vc r6 r2 LSL 20", "vc_r6_r2_LSL_20"},
     {{eq, r1, r1, LSL, 1}, true, eq, "eq r1 r1 LSL 1", "eq_r1_r1_LSL_1"},
     {{cc, r0, r0, LSL, 20}, true, cc, "cc r0 r0 LSL 20", "cc_r0_r0_LSL_20"},
     {{pl, r5, r4, LSL, 26}, true, pl, "pl r5 r4 LSL 26", "pl_r5_r4_LSL_26"},
     {{vc, r2, r5, LSL, 6}, true, vc, "vc r2 r5 LSL 6", "vc_r2_r5_LSL_6"},
     {{le, r5, r5, LSL, 25}, true, le, "le r5 r5 LSL 25", "le_r5_r5_LSL_25"},
     {{le, r5, r0, LSL, 26}, true, le, "le r5 r0 LSL 26", "le_r5_r0_LSL_26"},
     {{le, r0, r3, LSL, 17}, true, le, "le r0 r3 LSL 17", "le_r0_r3_LSL_17"},
     {{mi, r5, r5, LSL, 29}, true, mi, "mi r5 r5 LSL 29", "mi_r5_r5_LSL_29"},
     {{vc, r5, r4, LSL, 8}, true, vc, "vc r5 r4 LSL 8", "vc_r5_r4_LSL_8"},
     {{ge, r0, r2, LSL, 7}, true, ge, "ge r0 r2 LSL 7", "ge_r0_r2_LSL_7"},
     {{ne, r5, r5, LSL, 29}, true, ne, "ne r5 r5 LSL 29", "ne_r5_r5_LSL_29"},
     {{ge, r1, r7, LSL, 24}, true, ge, "ge r1 r7 LSL 24", "ge_r1_r7_LSL_24"},
     {{vs, r6, r1, LSL, 24}, true, vs, "vs r6 r1 LSL 24", "vs_r6_r1_LSL_24"},
     {{vs, r5, r7, LSL, 31}, true, vs, "vs r5 r7 LSL 31", "vs_r5_r7_LSL_31"},
     {{eq, r0, r3, LSL, 9}, true, eq, "eq r0 r3 LSL 9", "eq_r0_r3_LSL_9"},
     {{mi, r0, r1, LSL, 28}, true, mi, "mi r0 r1 LSL 28", "mi_r0_r1_LSL_28"},
     {{vc, r1, r5, LSL, 2}, true, vc, "vc r1 r5 LSL 2", "vc_r1_r5_LSL_2"},
     {{lt, r5, r7, LSL, 26}, true, lt, "lt r5 r7 LSL 26", "lt_r5_r7_LSL_26"},
     {{eq, r5, r2, LSL, 18}, true, eq, "eq r5 r2 LSL 18", "eq_r5_r2_LSL_18"},
     {{lt, r4, r0, LSL, 6}, true, lt, "lt r4 r0 LSL 6", "lt_r4_r0_LSL_6"},
     {{hi, r6, r2, LSL, 9}, true, hi, "hi r6 r2 LSL 9", "hi_r6_r2_LSL_9"},
     {{vc, r6, r1, LSL, 25}, true, vc, "vc r6 r1 LSL 25", "vc_r6_r1_LSL_25"},
     {{le, r2, r7, LSL, 10}, true, le, "le r2 r7 LSL 10", "le_r2_r7_LSL_10"},
     {{vs, r4, r0, LSL, 16}, true, vs, "vs r4 r0 LSL 16", "vs_r4_r0_LSL_16"},
     {{ne, r6, r7, LSL, 10}, true, ne, "ne r6 r7 LSL 10", "ne_r6_r7_LSL_10"},
     {{ne, r4, r3, LSL, 26}, true, ne, "ne r4 r3 LSL 26", "ne_r4_r3_LSL_26"},
     {{le, r6, r5, LSL, 9}, true, le, "le r6 r5 LSL 9", "le_r6_r5_LSL_9"},
     {{vc, r2, r5, LSL, 1}, true, vc, "vc r2 r5 LSL 1", "vc_r2_r5_LSL_1"},
     {{vc, r7, r5, LSL, 28}, true, vc, "vc r7 r5 LSL 28", "vc_r7_r5_LSL_28"},
     {{ne, r0, r3, LSL, 4}, true, ne, "ne r0 r3 LSL 4", "ne_r0_r3_LSL_4"},
     {{ne, r5, r4, LSL, 22}, true, ne, "ne r5 r4 LSL 22", "ne_r5_r4_LSL_22"},
     {{vc, r1, r4, LSL, 30}, true, vc, "vc r1 r4 LSL 30", "vc_r1_r4_LSL_30"},
     {{gt, r5, r4, LSL, 7}, true, gt, "gt r5 r4 LSL 7", "gt_r5_r4_LSL_7"},
     {{vs, r4, r5, LSL, 24}, true, vs, "vs r4 r5 LSL 24", "vs_r4_r5_LSL_24"},
     {{hi, r3, r5, LSL, 13}, true, hi, "hi r3 r5 LSL 13", "hi_r3_r5_LSL_13"},
     {{ge, r6, r7, LSL, 9}, true, ge, "ge r6 r7 LSL 9", "ge_r6_r7_LSL_9"},
     {{eq, r6, r3, LSL, 24}, true, eq, "eq r6 r3 LSL 24", "eq_r6_r3_LSL_24"},
     {{le, r3, r5, LSL, 14}, true, le, "le r3 r5 LSL 14", "le_r3_r5_LSL_14"},
     {{lt, r0, r7, LSL, 1}, true, lt, "lt r0 r7 LSL 1", "lt_r0_r7_LSL_1"},
     {{cc, r0, r5, LSL, 25}, true, cc, "cc r0 r5 LSL 25", "cc_r0_r5_LSL_25"},
     {{ne, r0, r2, LSL, 21}, true, ne, "ne r0 r2 LSL 21", "ne_r0_r2_LSL_21"},
     {{eq, r4, r2, LSL, 20}, true, eq, "eq r4 r2 LSL 20", "eq_r4_r2_LSL_20"},
     {{vc, r5, r4, LSL, 12}, true, vc, "vc r5 r4 LSL 12", "vc_r5_r4_LSL_12"},
     {{ne, r3, r1, LSL, 11}, true, ne, "ne r3 r1 LSL 11", "ne_r3_r1_LSL_11"},
     {{mi, r3, r7, LSL, 27}, true, mi, "mi r3 r7 LSL 27", "mi_r3_r7_LSL_27"},
     {{ls, r1, r7, LSL, 10}, true, ls, "ls r1 r7 LSL 10", "ls_r1_r7_LSL_10"},
     {{le, r7, r1, LSL, 30}, true, le, "le r7 r1 LSL 30", "le_r7_r1_LSL_30"},
     {{pl, r5, r2, LSL, 4}, true, pl, "pl r5 r2 LSL 4", "pl_r5_r2_LSL_4"},
     {{cs, r5, r4, LSL, 7}, true, cs, "cs r5 r4 LSL 7", "cs_r5_r4_LSL_7"},
     {{mi, r4, r0, LSL, 25}, true, mi, "mi r4 r0 LSL 25", "mi_r4_r0_LSL_25"},
     {{vs, r3, r7, LSL, 12}, true, vs, "vs r3 r7 LSL 12", "vs_r3_r7_LSL_12"},
     {{gt, r4, r6, LSL, 7}, true, gt, "gt r4 r6 LSL 7", "gt_r4_r6_LSL_7"},
     {{vs, r2, r1, LSL, 4}, true, vs, "vs r2 r1 LSL 4", "vs_r2_r1_LSL_4"},
     {{ne, r0, r0, LSL, 7}, true, ne, "ne r0 r0 LSL 7", "ne_r0_r0_LSL_7"},
     {{hi, r5, r1, LSL, 8}, true, hi, "hi r5 r1 LSL 8", "hi_r5_r1_LSL_8"},
     {{eq, r0, r0, LSL, 9}, true, eq, "eq r0 r0 LSL 9", "eq_r0_r0_LSL_9"},
     {{cc, r7, r3, LSL, 31}, true, cc, "cc r7 r3 LSL 31", "cc_r7_r3_LSL_31"},
     {{ne, r0, r5, LSL, 18}, true, ne, "ne r0 r5 LSL 18", "ne_r0_r5_LSL_18"},
     {{eq, r6, r3, LSL, 23}, true, eq, "eq r6 r3 LSL 23", "eq_r6_r3_LSL_23"},
     {{cc, r5, r7, LSL, 14}, true, cc, "cc r5 r7 LSL 14", "cc_r5_r7_LSL_14"},
     {{ne, r4, r0, LSL, 27}, true, ne, "ne r4 r0 LSL 27", "ne_r4_r0_LSL_27"},
     {{mi, r7, r0, LSL, 2}, true, mi, "mi r7 r0 LSL 2", "mi_r7_r0_LSL_2"},
     {{hi, r6, r5, LSL, 24}, true, hi, "hi r6 r5 LSL 24", "hi_r6_r5_LSL_24"},
     {{hi, r5, r7, LSL, 20}, true, hi, "hi r5 r7 LSL 20", "hi_r5_r7_LSL_20"},
     {{vc, r1, r2, LSL, 23}, true, vc, "vc r1 r2 LSL 23", "vc_r1_r2_LSL_23"},
     {{mi, r2, r0, LSL, 27}, true, mi, "mi r2 r0 LSL 27", "mi_r2_r0_LSL_27"},
     {{ls, r1, r2, LSL, 17}, true, ls, "ls r1 r2 LSL 17", "ls_r1_r2_LSL_17"},
     {{pl, r0, r6, LSL, 1}, true, pl, "pl r0 r6 LSL 1", "pl_r0_r6_LSL_1"},
     {{vs, r6, r3, LSL, 16}, true, vs, "vs r6 r3 LSL 16", "vs_r6_r3_LSL_16"},
     {{mi, r6, r6, LSL, 23}, true, mi, "mi r6 r6 LSL 23", "mi_r6_r6_LSL_23"},
     {{ge, r7, r1, LSL, 27}, true, ge, "ge r7 r1 LSL 27", "ge_r7_r1_LSL_27"},
     {{gt, r0, r5, LSL, 16}, true, gt, "gt r0 r5 LSL 16", "gt_r0_r5_LSL_16"},
     {{le, r6, r4, LSL, 20}, true, le, "le r6 r4 LSL 20", "le_r6_r4_LSL_20"},
     {{gt, r6, r0, LSL, 20}, true, gt, "gt r6 r0 LSL 20", "gt_r6_r0_LSL_20"},
     {{gt, r7, r2, LSL, 28}, true, gt, "gt r7 r2 LSL 28", "gt_r7_r2_LSL_28"},
     {{le, r6, r7, LSL, 9}, true, le, "le r6 r7 LSL 9", "le_r6_r7_LSL_9"},
     {{gt, r4, r4, LSL, 2}, true, gt, "gt r4 r4 LSL 2", "gt_r4_r4_LSL_2"},
     {{mi, r6, r5, LSL, 13}, true, mi, "mi r6 r5 LSL 13", "mi_r6_r5_LSL_13"},
     {{le, r0, r0, LSL, 2}, true, le, "le r0 r0 LSL 2", "le_r0_r0_LSL_2"},
     {{ge, r2, r3, LSL, 2}, true, ge, "ge r2 r3 LSL 2", "ge_r2_r3_LSL_2"},
     {{cs, r1, r4, LSL, 28}, true, cs, "cs r1 r4 LSL 28", "cs_r1_r4_LSL_28"},
     {{vc, r1, r4, LSL, 6}, true, vc, "vc r1 r4 LSL 6", "vc_r1_r4_LSL_6"},
     {{vs, r3, r6, LSL, 26}, true, vs, "vs r3 r6 LSL 26", "vs_r3_r6_LSL_26"},
     {{cs, r2, r6, LSL, 23}, true, cs, "cs r2 r6 LSL 23", "cs_r2_r6_LSL_23"},
     {{eq, r1, r3, LSL, 13}, true, eq, "eq r1 r3 LSL 13", "eq_r1_r3_LSL_13"},
     {{ne, r7, r1, LSL, 23}, true, ne, "ne r7 r1 LSL 23", "ne_r7_r1_LSL_23"},
     {{pl, r7, r4, LSL, 14}, true, pl, "pl r7 r4 LSL 14", "pl_r7_r4_LSL_14"},
     {{vs, r3, r1, LSL, 22}, true, vs, "vs r3 r1 LSL 22", "vs_r3_r1_LSL_22"},
     {{eq, r5, r4, LSL, 24}, true, eq, "eq r5 r4 LSL 24", "eq_r5_r4_LSL_24"},
     {{cc, r4, r1, LSL, 9}, true, cc, "cc r4 r1 LSL 9", "cc_r4_r1_LSL_9"},
     {{mi, r2, r1, LSL, 23}, true, mi, "mi r2 r1 LSL 23", "mi_r2_r1_LSL_23"},
     {{gt, r1, r3, LSL, 19}, true, gt, "gt r1 r3 LSL 19", "gt_r1_r3_LSL_19"},
     {{lt, r7, r0, LSL, 3}, true, lt, "lt r7 r0 LSL 3", "lt_r7_r0_LSL_3"},
     {{le, r2, r1, LSL, 13}, true, le, "le r2 r1 LSL 13", "le_r2_r1_LSL_13"},
     {{ge, r2, r1, LSL, 2}, true, ge, "ge r2 r1 LSL 2", "ge_r2_r1_LSL_2"},
     {{hi, r5, r0, LSL, 21}, true, hi, "hi r5 r0 LSL 21", "hi_r5_r0_LSL_21"},
     {{gt, r7, r5, LSL, 19}, true, gt, "gt r7 r5 LSL 19", "gt_r7_r5_LSL_19"},
     {{eq, r2, r3, LSL, 19}, true, eq, "eq r2 r3 LSL 19", "eq_r2_r3_LSL_19"},
     {{vs, r0, r5, LSL, 4}, true, vs, "vs r0 r5 LSL 4", "vs_r0_r5_LSL_4"},
     {{pl, r7, r2, LSL, 30}, true, pl, "pl r7 r2 LSL 30", "pl_r7_r2_LSL_30"},
     {{vc, r2, r3, LSL, 28}, true, vc, "vc r2 r3 LSL 28", "vc_r2_r3_LSL_28"},
     {{pl, r2, r7, LSL, 25}, true, pl, "pl r2 r7 LSL 25", "pl_r2_r7_LSL_25"},
     {{eq, r3, r6, LSL, 23}, true, eq, "eq r3 r6 LSL 23", "eq_r3_r6_LSL_23"},
     {{eq, r3, r0, LSL, 8}, true, eq, "eq r3 r0 LSL 8", "eq_r3_r0_LSL_8"},
     {{pl, r3, r2, LSL, 22}, true, pl, "pl r3 r2 LSL 22", "pl_r3_r2_LSL_22"},
     {{cc, r4, r3, LSL, 26}, true, cc, "cc r4 r3 LSL 26", "cc_r4_r3_LSL_26"},
     {{cs, r5, r2, LSL, 1}, true, cs, "cs r5 r2 LSL 1", "cs_r5_r2_LSL_1"},
     {{cc, r1, r1, LSL, 6}, true, cc, "cc r1 r1 LSL 6", "cc_r1_r1_LSL_6"},
     {{mi, r3, r5, LSL, 22}, true, mi, "mi r3 r5 LSL 22", "mi_r3_r5_LSL_22"},
     {{cs, r0, r3, LSL, 21}, true, cs, "cs r0 r3 LSL 21", "cs_r0_r3_LSL_21"},
     {{vs, r7, r7, LSL, 13}, true, vs, "vs r7 r7 LSL 13", "vs_r7_r7_LSL_13"},
     {{pl, r5, r6, LSL, 30}, true, pl, "pl r5 r6 LSL 30", "pl_r5_r6_LSL_30"},
     {{ge, r3, r2, LSL, 9}, true, ge, "ge r3 r2 LSL 9", "ge_r3_r2_LSL_9"},
     {{pl, r1, r3, LSL, 11}, true, pl, "pl r1 r3 LSL 11", "pl_r1_r3_LSL_11"},
     {{eq, r5, r7, LSL, 25}, true, eq, "eq r5 r7 LSL 25", "eq_r5_r7_LSL_25"},
     {{mi, r6, r4, LSL, 8}, true, mi, "mi r6 r4 LSL 8", "mi_r6_r4_LSL_8"},
     {{ls, r4, r5, LSL, 2}, true, ls, "ls r4 r5 LSL 2", "ls_r4_r5_LSL_2"},
     {{ls, r3, r4, LSL, 28}, true, ls, "ls r3 r4 LSL 28", "ls_r3_r4_LSL_28"},
     {{ls, r5, r6, LSL, 31}, true, ls, "ls r5 r6 LSL 31", "ls_r5_r6_LSL_31"},
     {{pl, r6, r0, LSL, 11}, true, pl, "pl r6 r0 LSL 11", "pl_r6_r0_LSL_11"},
     {{ls, r2, r6, LSL, 13}, true, ls, "ls r2 r6 LSL 13", "ls_r2_r6_LSL_13"},
     {{gt, r1, r4, LSL, 31}, true, gt, "gt r1 r4 LSL 31", "gt_r1_r4_LSL_31"},
     {{vc, r2, r3, LSL, 20}, true, vc, "vc r2 r3 LSL 20", "vc_r2_r3_LSL_20"},
     {{eq, r0, r1, LSL, 16}, true, eq, "eq r0 r1 LSL 16", "eq_r0_r1_LSL_16"},
     {{pl, r4, r1, LSL, 25}, true, pl, "pl r4 r1 LSL 25", "pl_r4_r1_LSL_25"},
     {{vc, r0, r5, LSL, 17}, true, vc, "vc r0 r5 LSL 17", "vc_r0_r5_LSL_17"},
     {{ne, r4, r3, LSL, 8}, true, ne, "ne r4 r3 LSL 8", "ne_r4_r3_LSL_8"},
     {{le, r2, r5, LSL, 10}, true, le, "le r2 r5 LSL 10", "le_r2_r5_LSL_10"},
     {{mi, r0, r2, LSL, 4}, true, mi, "mi r0 r2 LSL 4", "mi_r0_r2_LSL_4"},
     {{cc, r3, r1, LSL, 6}, true, cc, "cc r3 r1 LSL 6", "cc_r3_r1_LSL_6"},
     {{vs, r4, r7, LSL, 30}, true, vs, "vs r4 r7 LSL 30", "vs_r4_r7_LSL_30"},
     {{ls, r0, r1, LSL, 7}, true, ls, "ls r0 r1 LSL 7", "ls_r0_r1_LSL_7"},
     {{eq, r0, r0, LSL, 30}, true, eq, "eq r0 r0 LSL 30", "eq_r0_r0_LSL_30"},
     {{ne, r2, r6, LSL, 31}, true, ne, "ne r2 r6 LSL 31", "ne_r2_r6_LSL_31"},
     {{vc, r7, r5, LSL, 15}, true, vc, "vc r7 r5 LSL 15", "vc_r7_r5_LSL_15"},
     {{gt, r0, r2, LSL, 22}, true, gt, "gt r0 r2 LSL 22", "gt_r0_r2_LSL_22"},
     {{ge, r7, r4, LSL, 13}, true, ge, "ge r7 r4 LSL 13", "ge_r7_r4_LSL_13"},
     {{lt, r4, r3, LSL, 3}, true, lt, "lt r4 r3 LSL 3", "lt_r4_r3_LSL_3"},
     {{vs, r3, r0, LSL, 8}, true, vs, "vs r3 r0 LSL 8", "vs_r3_r0_LSL_8"},
     {{gt, r2, r2, LSL, 9}, true, gt, "gt r2 r2 LSL 9", "gt_r2_r2_LSL_9"},
     {{vc, r1, r5, LSL, 1}, true, vc, "vc r1 r5 LSL 1", "vc_r1_r5_LSL_1"},
     {{pl, r2, r4, LSL, 18}, true, pl, "pl r2 r4 LSL 18", "pl_r2_r4_LSL_18"},
     {{lt, r5, r2, LSL, 27}, true, lt, "lt r5 r2 LSL 27", "lt_r5_r2_LSL_27"},
     {{ge, r2, r6, LSL, 8}, true, ge, "ge r2 r6 LSL 8", "ge_r2_r6_LSL_8"},
     {{le, r0, r3, LSL, 15}, true, le, "le r0 r3 LSL 15", "le_r0_r3_LSL_15"},
     {{mi, r4, r5, LSL, 7}, true, mi, "mi r4 r5 LSL 7", "mi_r4_r5_LSL_7"},
     {{vc, r0, r4, LSL, 12}, true, vc, "vc r0 r4 LSL 12", "vc_r0_r4_LSL_12"},
     {{eq, r7, r6, LSL, 26}, true, eq, "eq r7 r6 LSL 26", "eq_r7_r6_LSL_26"},
     {{vc, r1, r0, LSL, 24}, true, vc, "vc r1 r0 LSL 24", "vc_r1_r0_LSL_24"},
     {{gt, r3, r6, LSL, 28}, true, gt, "gt r3 r6 LSL 28", "gt_r3_r6_LSL_28"},
     {{vc, r3, r6, LSL, 6}, true, vc, "vc r3 r6 LSL 6", "vc_r3_r6_LSL_6"},
     {{ls, r1, r5, LSL, 16}, true, ls, "ls r1 r5 LSL 16", "ls_r1_r5_LSL_16"},
     {{lt, r7, r7, LSL, 30}, true, lt, "lt r7 r7 LSL 30", "lt_r7_r7_LSL_30"},
     {{eq, r7, r2, LSL, 25}, true, eq, "eq r7 r2 LSL 25", "eq_r7_r2_LSL_25"},
     {{ne, r0, r1, LSL, 24}, true, ne, "ne r0 r1 LSL 24", "ne_r0_r1_LSL_24"},
     {{ge, r1, r3, LSL, 17}, true, ge, "ge r1 r3 LSL 17", "ge_r1_r3_LSL_17"},
     {{vs, r1, r4, LSL, 6}, true, vs, "vs r1 r4 LSL 6", "vs_r1_r4_LSL_6"},
     {{vs, r7, r3, LSL, 30}, true, vs, "vs r7 r3 LSL 30", "vs_r7_r3_LSL_30"},
     {{le, r0, r4, LSL, 16}, true, le, "le r0 r4 LSL 16", "le_r0_r4_LSL_16"},
     {{hi, r6, r6, LSL, 4}, true, hi, "hi r6 r6 LSL 4", "hi_r6_r6_LSL_4"},
     {{ls, r6, r2, LSL, 12}, true, ls, "ls r6 r2 LSL 12", "ls_r6_r2_LSL_12"},
     {{le, r5, r0, LSL, 23}, true, le, "le r5 r0 LSL 23", "le_r5_r0_LSL_23"},
     {{cc, r7, r1, LSL, 5}, true, cc, "cc r7 r1 LSL 5", "cc_r7_r1_LSL_5"},
     {{vc, r4, r3, LSL, 23}, true, vc, "vc r4 r3 LSL 23", "vc_r4_r3_LSL_23"},
     {{cc, r6, r1, LSL, 30}, true, cc, "cc r6 r1 LSL 30", "cc_r6_r1_LSL_30"},
     {{lt, r7, r3, LSL, 30}, true, lt, "lt r7 r3 LSL 30", "lt_r7_r3_LSL_30"},
     {{eq, r0, r6, LSL, 18}, true, eq, "eq r0 r6 LSL 18", "eq_r0_r6_LSL_18"},
     {{le, r2, r2, LSL, 20}, true, le, "le r2 r2 LSL 20", "le_r2_r2_LSL_20"},
     {{ls, r4, r0, LSL, 11}, true, ls, "ls r4 r0 LSL 11", "ls_r4_r0_LSL_11"},
     {{hi, r2, r6, LSL, 26}, true, hi, "hi r2 r6 LSL 26", "hi_r2_r6_LSL_26"},
     {{vs, r0, r6, LSL, 22}, true, vs, "vs r0 r6 LSL 22", "vs_r0_r6_LSL_22"},
     {{cs, r0, r4, LSL, 29}, true, cs, "cs r0 r4 LSL 29", "cs_r0_r4_LSL_29"},
     {{ge, r3, r5, LSL, 17}, true, ge, "ge r3 r5 LSL 17", "ge_r3_r5_LSL_17"},
     {{lt, r5, r7, LSL, 28}, true, lt, "lt r5 r7 LSL 28", "lt_r5_r7_LSL_28"},
     {{pl, r7, r3, LSL, 13}, true, pl, "pl r7 r3 LSL 13", "pl_r7_r3_LSL_13"},
     {{mi, r5, r5, LSL, 4}, true, mi, "mi r5 r5 LSL 4", "mi_r5_r5_LSL_4"},
     {{vc, r2, r2, LSL, 18}, true, vc, "vc r2 r2 LSL 18", "vc_r2_r2_LSL_18"},
     {{ne, r6, r3, LSL, 12}, true, ne, "ne r6 r3 LSL 12", "ne_r6_r3_LSL_12"},
     {{ne, r6, r6, LSL, 31}, true, ne, "ne r6 r6 LSL 31", "ne_r6_r6_LSL_31"},
     {{mi, r4, r4, LSL, 15}, true, mi, "mi r4 r4 LSL 15", "mi_r4_r4_LSL_15"},
     {{cs, r3, r7, LSL, 18}, true, cs, "cs r3 r7 LSL 18", "cs_r3_r7_LSL_18"},
     {{vs, r4, r5, LSL, 13}, true, vs, "vs r4 r5 LSL 13", "vs_r4_r5_LSL_13"},
     {{ls, r7, r5, LSL, 25}, true, ls, "ls r7 r5 LSL 25", "ls_r7_r5_LSL_25"},
     {{cc, r6, r0, LSL, 22}, true, cc, "cc r6 r0 LSL 22", "cc_r6_r0_LSL_22"},
     {{ne, r0, r1, LSL, 17}, true, ne, "ne r0 r1 LSL 17", "ne_r0_r1_LSL_17"},
     {{mi, r7, r5, LSL, 25}, true, mi, "mi r7 r5 LSL 25", "mi_r7_r5_LSL_25"},
     {{lt, r5, r6, LSL, 24}, true, lt, "lt r5 r6 LSL 24", "lt_r5_r6_LSL_24"},
     {{le, r6, r4, LSL, 31}, true, le, "le r6 r4 LSL 31", "le_r6_r4_LSL_31"},
     {{hi, r4, r4, LSL, 16}, true, hi, "hi r4 r4 LSL 16", "hi_r4_r4_LSL_16"},
     {{pl, r5, r4, LSL, 7}, true, pl, "pl r5 r4 LSL 7", "pl_r5_r4_LSL_7"},
     {{ge, r2, r6, LSL, 30}, true, ge, "ge r2 r6 LSL 30", "ge_r2_r6_LSL_30"},
     {{vs, r2, r5, LSL, 31}, true, vs, "vs r2 r5 LSL 31", "vs_r2_r5_LSL_31"},
     {{eq, r5, r2, LSL, 21}, true, eq, "eq r5 r2 LSL 21", "eq_r5_r2_LSL_21"},
     {{mi, r7, r6, LSL, 18}, true, mi, "mi r7 r6 LSL 18", "mi_r7_r6_LSL_18"},
     {{ls, r2, r7, LSL, 4}, true, ls, "ls r2 r7 LSL 4", "ls_r2_r7_LSL_4"},
     {{ne, r6, r0, LSL, 22}, true, ne, "ne r6 r0 LSL 22", "ne_r6_r0_LSL_22"},
     {{le, r4, r4, LSL, 15}, true, le, "le r4 r4 LSL 15", "le_r4_r4_LSL_15"},
     {{ne, r1, r2, LSL, 28}, true, ne, "ne r1 r2 LSL 28", "ne_r1_r2_LSL_28"},
     {{hi, r7, r2, LSL, 28}, true, hi, "hi r7 r2 LSL 28", "hi_r7_r2_LSL_28"},
     {{lt, r2, r1, LSL, 22}, true, lt, "lt r2 r1 LSL 22", "lt_r2_r1_LSL_22"},
     {{cs, r4, r2, LSL, 30}, true, cs, "cs r4 r2 LSL 30", "cs_r4_r2_LSL_30"},
     {{ls, r7, r7, LSL, 1}, true, ls, "ls r7 r7 LSL 1", "ls_r7_r7_LSL_1"},
     {{mi, r1, r6, LSL, 16}, true, mi, "mi r1 r6 LSL 16", "mi_r1_r6_LSL_16"},
     {{cc, r4, r5, LSL, 7}, true, cc, "cc r4 r5 LSL 7", "cc_r4_r5_LSL_7"},
     {{vc, r7, r5, LSL, 7}, true, vc, "vc r7 r5 LSL 7", "vc_r7_r5_LSL_7"},
     {{eq, r0, r5, LSL, 8}, true, eq, "eq r0 r5 LSL 8", "eq_r0_r5_LSL_8"},
     {{eq, r1, r6, LSL, 30}, true, eq, "eq r1 r6 LSL 30", "eq_r1_r6_LSL_30"},
     {{vs, r3, r6, LSL, 7}, true, vs, "vs r3 r6 LSL 7", "vs_r3_r6_LSL_7"},
     {{ge, r3, r6, LSL, 17}, true, ge, "ge r3 r6 LSL 17", "ge_r3_r6_LSL_17"},
     {{vs, r4, r4, LSL, 9}, true, vs, "vs r4 r4 LSL 9", "vs_r4_r4_LSL_9"},
     {{cc, r4, r3, LSL, 4}, true, cc, "cc r4 r3 LSL 4", "cc_r4_r3_LSL_4"},
     {{mi, r7, r1, LSL, 26}, true, mi, "mi r7 r1 LSL 26", "mi_r7_r1_LSL_26"},
     {{le, r7, r6, LSL, 11}, true, le, "le r7 r6 LSL 11", "le_r7_r6_LSL_11"},
     {{mi, r7, r5, LSL, 5}, true, mi, "mi r7 r5 LSL 5", "mi_r7_r5_LSL_5"},
     {{cs, r0, r4, LSL, 9}, true, cs, "cs r0 r4 LSL 9", "cs_r0_r4_LSL_9"},
     {{ge, r1, r1, LSL, 28}, true, ge, "ge r1 r1 LSL 28", "ge_r1_r1_LSL_28"},
     {{pl, r4, r6, LSL, 30}, true, pl, "pl r4 r6 LSL 30", "pl_r4_r6_LSL_30"},
     {{eq, r5, r1, LSL, 30}, true, eq, "eq r5 r1 LSL 30", "eq_r5_r1_LSL_30"},
     {{pl, r5, r6, LSL, 31}, true, pl, "pl r5 r6 LSL 31", "pl_r5_r6_LSL_31"},
     {{hi, r3, r0, LSL, 16}, true, hi, "hi r3 r0 LSL 16", "hi_r3_r0_LSL_16"},
     {{eq, r3, r2, LSL, 24}, true, eq, "eq r3 r2 LSL 24", "eq_r3_r2_LSL_24"},
     {{mi, r3, r5, LSL, 25}, true, mi, "mi r3 r5 LSL 25", "mi_r3_r5_LSL_25"},
     {{vs, r4, r1, LSL, 25}, true, vs, "vs r4 r1 LSL 25", "vs_r4_r1_LSL_25"},
     {{cc, r5, r3, LSL, 24}, true, cc, "cc r5 r3 LSL 24", "cc_r5_r3_LSL_24"},
     {{gt, r0, r6, LSL, 1}, true, gt, "gt r0 r6 LSL 1", "gt_r0_r6_LSL_1"},
     {{cs, r0, r4, LSL, 11}, true, cs, "cs r0 r4 LSL 11", "cs_r0_r4_LSL_11"},
     {{hi, r0, r2, LSL, 19}, true, hi, "hi r0 r2 LSL 19", "hi_r0_r2_LSL_19"},
     {{ne, r1, r6, LSL, 4}, true, ne, "ne r1 r6 LSL 4", "ne_r1_r6_LSL_4"},
     {{vc, r4, r4, LSL, 5}, true, vc, "vc r4 r4 LSL 5", "vc_r4_r4_LSL_5"},
     {{hi, r4, r0, LSL, 18}, true, hi, "hi r4 r0 LSL 18", "hi_r4_r0_LSL_18"},
     {{cs, r3, r0, LSL, 11}, true, cs, "cs r3 r0 LSL 11", "cs_r3_r0_LSL_11"},
     {{ls, r6, r1, LSL, 30}, true, ls, "ls r6 r1 LSL 30", "ls_r6_r1_LSL_30"},
     {{ne, r4, r0, LSL, 3}, true, ne, "ne r4 r0 LSL 3", "ne_r4_r0_LSL_3"},
     {{ls, r6, r4, LSL, 13}, true, ls, "ls r6 r4 LSL 13", "ls_r6_r4_LSL_13"},
     {{gt, r0, r4, LSL, 31}, true, gt, "gt r0 r4 LSL 31", "gt_r0_r4_LSL_31"},
     {{eq, r6, r3, LSL, 10}, true, eq, "eq r6 r3 LSL 10", "eq_r6_r3_LSL_10"},
     {{ge, r2, r6, LSL, 11}, true, ge, "ge r2 r6 LSL 11", "ge_r2_r6_LSL_11"},
     {{vs, r2, r4, LSL, 14}, true, vs, "vs r2 r4 LSL 14", "vs_r2_r4_LSL_14"},
     {{gt, r2, r5, LSL, 27}, true, gt, "gt r2 r5 LSL 27", "gt_r2_r5_LSL_27"},
     {{gt, r0, r5, LSL, 28}, true, gt, "gt r0 r5 LSL 28", "gt_r0_r5_LSL_28"},
     {{vs, r4, r6, LSL, 1}, true, vs, "vs r4 r6 LSL 1", "vs_r4_r6_LSL_1"},
     {{ls, r0, r3, LSL, 29}, true, ls, "ls r0 r3 LSL 29", "ls_r0_r3_LSL_29"},
     {{lt, r4, r4, LSL, 16}, true, lt, "lt r4 r4 LSL 16", "lt_r4_r4_LSL_16"},
     {{cc, r6, r1, LSL, 11}, true, cc, "cc r6 r1 LSL 11", "cc_r6_r1_LSL_11"},
     {{vc, r6, r5, LSL, 3}, true, vc, "vc r6 r5 LSL 3", "vc_r6_r5_LSL_3"},
     {{eq, r6, r7, LSL, 30}, true, eq, "eq r6 r7 LSL 30", "eq_r6_r7_LSL_30"},
     {{ls, r0, r1, LSL, 29}, true, ls, "ls r0 r1 LSL 29", "ls_r0_r1_LSL_29"},
     {{ls, r2, r2, LSL, 8}, true, ls, "ls r2 r2 LSL 8", "ls_r2_r2_LSL_8"},
     {{gt, r2, r6, LSL, 12}, true, gt, "gt r2 r6 LSL 12", "gt_r2_r6_LSL_12"},
     {{ge, r5, r1, LSL, 25}, true, ge, "ge r5 r1 LSL 25", "ge_r5_r1_LSL_25"},
     {{gt, r3, r4, LSL, 23}, true, gt, "gt r3 r4 LSL 23", "gt_r3_r4_LSL_23"},
     {{eq, r6, r3, LSL, 13}, true, eq, "eq r6 r3 LSL 13", "eq_r6_r3_LSL_13"},
     {{ne, r7, r2, LSL, 2}, true, ne, "ne r7 r2 LSL 2", "ne_r7_r2_LSL_2"},
     {{pl, r6, r6, LSL, 24}, true, pl, "pl r6 r6 LSL 24", "pl_r6_r6_LSL_24"},
     {{mi, r5, r0, LSL, 21}, true, mi, "mi r5 r0 LSL 21", "mi_r5_r0_LSL_21"},
     {{le, r6, r5, LSL, 10}, true, le, "le r6 r5 LSL 10", "le_r6_r5_LSL_10"},
     {{vc, r2, r6, LSL, 5}, true, vc, "vc r2 r6 LSL 5", "vc_r2_r6_LSL_5"},
     {{vc, r6, r2, LSL, 9}, true, vc, "vc r6 r2 LSL 9", "vc_r6_r2_LSL_9"},
     {{mi, r5, r6, LSL, 8}, true, mi, "mi r5 r6 LSL 8", "mi_r5_r6_LSL_8"},
     {{cs, r2, r5, LSL, 16}, true, cs, "cs r2 r5 LSL 16", "cs_r2_r5_LSL_16"},
     {{cs, r4, r2, LSL, 6}, true, cs, "cs r4 r2 LSL 6", "cs_r4_r2_LSL_6"},
     {{lt, r7, r4, LSL, 1}, true, lt, "lt r7 r4 LSL 1", "lt_r7_r4_LSL_1"},
     {{ls, r3, r4, LSL, 14}, true, ls, "ls r3 r4 LSL 14", "ls_r3_r4_LSL_14"},
     {{cs, r6, r4, LSL, 9}, true, cs, "cs r6 r4 LSL 9", "cs_r6_r4_LSL_9"},
     {{pl, r6, r5, LSL, 3}, true, pl, "pl r6 r5 LSL 3", "pl_r6_r5_LSL_3"},
     {{hi, r3, r2, LSL, 17}, true, hi, "hi r3 r2 LSL 17", "hi_r3_r2_LSL_17"},
     {{le, r0, r5, LSL, 1}, true, le, "le r0 r5 LSL 1", "le_r0_r5_LSL_1"},
     {{pl, r0, r0, LSL, 12}, true, pl, "pl r0 r0 LSL 12", "pl_r0_r0_LSL_12"},
     {{ne, r5, r0, LSL, 9}, true, ne, "ne r5 r0 LSL 9", "ne_r5_r0_LSL_9"},
     {{ls, r1, r6, LSL, 6}, true, ls, "ls r1 r6 LSL 6", "ls_r1_r6_LSL_6"},
     {{mi, r1, r2, LSL, 15}, true, mi, "mi r1 r2 LSL 15", "mi_r1_r2_LSL_15"},
     {{hi, r6, r4, LSL, 22}, true, hi, "hi r6 r4 LSL 22", "hi_r6_r4_LSL_22"},
     {{ls, r0, r4, LSL, 29}, true, ls, "ls r0 r4 LSL 29", "ls_r0_r4_LSL_29"},
     {{vs, r1, r5, LSL, 1}, true, vs, "vs r1 r5 LSL 1", "vs_r1_r5_LSL_1"},
     {{vs, r3, r2, LSL, 24}, true, vs, "vs r3 r2 LSL 24", "vs_r3_r2_LSL_24"},
     {{cc, r6, r7, LSL, 7}, true, cc, "cc r6 r7 LSL 7", "cc_r6_r7_LSL_7"},
     {{vc, r4, r0, LSL, 27}, true, vc, "vc r4 r0 LSL 27", "vc_r4_r0_LSL_27"},
     {{vs, r0, r1, LSL, 13}, true, vs, "vs r0 r1 LSL 13", "vs_r0_r1_LSL_13"},
     {{lt, r1, r5, LSL, 16}, true, lt, "lt r1 r5 LSL 16", "lt_r1_r5_LSL_16"},
     {{cc, r1, r3, LSL, 10}, true, cc, "cc r1 r3 LSL 10", "cc_r1_r3_LSL_10"},
     {{eq, r0, r3, LSL, 13}, true, eq, "eq r0 r3 LSL 13", "eq_r0_r3_LSL_13"},
     {{ls, r0, r7, LSL, 3}, true, ls, "ls r0 r7 LSL 3", "ls_r0_r7_LSL_3"},
     {{mi, r7, r7, LSL, 16}, true, mi, "mi r7 r7 LSL 16", "mi_r7_r7_LSL_16"},
     {{le, r5, r2, LSL, 7}, true, le, "le r5 r2 LSL 7", "le_r5_r2_LSL_7"},
     {{ne, r6, r4, LSL, 22}, true, ne, "ne r6 r4 LSL 22", "ne_r6_r4_LSL_22"},
     {{eq, r0, r0, LSL, 14}, true, eq, "eq r0 r0 LSL 14", "eq_r0_r0_LSL_14"},
     {{ne, r5, r2, LSL, 3}, true, ne, "ne r5 r2 LSL 3", "ne_r5_r2_LSL_3"},
     {{eq, r0, r6, LSL, 29}, true, eq, "eq r0 r6 LSL 29", "eq_r0_r6_LSL_29"},
     {{vs, r4, r2, LSL, 23}, true, vs, "vs r4 r2 LSL 23", "vs_r4_r2_LSL_23"},
     {{ne, r1, r5, LSL, 15}, true, ne, "ne r1 r5 LSL 15", "ne_r1_r5_LSL_15"},
     {{ne, r3, r6, LSL, 30}, true, ne, "ne r3 r6 LSL 30", "ne_r3_r6_LSL_30"},
     {{hi, r7, r2, LSL, 17}, true, hi, "hi r7 r2 LSL 17", "hi_r7_r2_LSL_17"},
     {{vs, r4, r0, LSL, 7}, true, vs, "vs r4 r0 LSL 7", "vs_r4_r0_LSL_7"},
     {{vc, r5, r0, LSL, 28}, true, vc, "vc r5 r0 LSL 28", "vc_r5_r0_LSL_28"},
     {{lt, r6, r5, LSL, 20}, true, lt, "lt r6 r5 LSL 20", "lt_r6_r5_LSL_20"},
     {{cs, r3, r0, LSL, 16}, true, cs, "cs r3 r0 LSL 16", "cs_r3_r0_LSL_16"},
     {{cs, r0, r5, LSL, 19}, true, cs, "cs r0 r5 LSL 19", "cs_r0_r5_LSL_19"},
     {{ge, r1, r1, LSL, 13}, true, ge, "ge r1 r1 LSL 13", "ge_r1_r1_LSL_13"},
     {{cc, r5, r4, LSL, 14}, true, cc, "cc r5 r4 LSL 14", "cc_r5_r4_LSL_14"},
     {{hi, r3, r5, LSL, 8}, true, hi, "hi r3 r5 LSL 8", "hi_r3_r5_LSL_8"},
     {{vc, r7, r5, LSL, 1}, true, vc, "vc r7 r5 LSL 1", "vc_r7_r5_LSL_1"},
     {{cc, r4, r3, LSL, 1}, true, cc, "cc r4 r3 LSL 1", "cc_r4_r3_LSL_1"},
     {{cs, r3, r6, LSL, 8}, true, cs, "cs r3 r6 LSL 8", "cs_r3_r6_LSL_8"},
     {{pl, r3, r1, LSL, 30}, true, pl, "pl r3 r1 LSL 30", "pl_r3_r1_LSL_30"},
     {{cc, r3, r1, LSL, 31}, true, cc, "cc r3 r1 LSL 31", "cc_r3_r1_LSL_31"},
     {{ne, r3, r1, LSL, 9}, true, ne, "ne r3 r1 LSL 9", "ne_r3_r1_LSL_9"},
     {{cc, r0, r7, LSL, 9}, true, cc, "cc r0 r7 LSL 9", "cc_r0_r7_LSL_9"},
     {{mi, r6, r4, LSL, 13}, true, mi, "mi r6 r4 LSL 13", "mi_r6_r4_LSL_13"},
     {{le, r3, r0, LSL, 7}, true, le, "le r3 r0 LSL 7", "le_r3_r0_LSL_7"},
     {{hi, r6, r7, LSL, 18}, true, hi, "hi r6 r7 LSL 18", "hi_r6_r7_LSL_18"},
     {{mi, r3, r3, LSL, 22}, true, mi, "mi r3 r3 LSL 22", "mi_r3_r3_LSL_22"},
     {{gt, r4, r5, LSL, 2}, true, gt, "gt r4 r5 LSL 2", "gt_r4_r5_LSL_2"},
     {{le, r4, r0, LSL, 13}, true, le, "le r4 r0 LSL 13", "le_r4_r0_LSL_13"},
     {{lt, r4, r1, LSL, 14}, true, lt, "lt r4 r1 LSL 14", "lt_r4_r1_LSL_14"},
     {{lt, r5, r5, LSL, 4}, true, lt, "lt r5 r5 LSL 4", "lt_r5_r5_LSL_4"},
     {{gt, r7, r7, LSL, 29}, true, gt, "gt r7 r7 LSL 29", "gt_r7_r7_LSL_29"},
     {{le, r7, r3, LSL, 12}, true, le, "le r7 r3 LSL 12", "le_r7_r3_LSL_12"},
     {{vc, r0, r0, LSL, 15}, true, vc, "vc r0 r0 LSL 15", "vc_r0_r0_LSL_15"},
     {{ne, r2, r6, LSL, 11}, true, ne, "ne r2 r6 LSL 11", "ne_r2_r6_LSL_11"},
     {{hi, r2, r0, LSL, 29}, true, hi, "hi r2 r0 LSL 29", "hi_r2_r0_LSL_29"},
     {{eq, r0, r4, LSL, 22}, true, eq, "eq r0 r4 LSL 22", "eq_r0_r4_LSL_22"},
     {{cs, r3, r4, LSL, 30}, true, cs, "cs r3 r4 LSL 30", "cs_r3_r4_LSL_30"},
     {{hi, r1, r2, LSL, 19}, true, hi, "hi r1 r2 LSL 19", "hi_r1_r2_LSL_19"},
     {{ne, r7, r2, LSL, 31}, true, ne, "ne r7 r2 LSL 31", "ne_r7_r2_LSL_31"},
     {{pl, r5, r7, LSL, 9}, true, pl, "pl r5 r7 LSL 9", "pl_r5_r7_LSL_9"},
     {{mi, r2, r2, LSL, 28}, true, mi, "mi r2 r2 LSL 28", "mi_r2_r2_LSL_28"},
     {{ls, r3, r0, LSL, 16}, true, ls, "ls r3 r0 LSL 16", "ls_r3_r0_LSL_16"},
     {{ge, r5, r4, LSL, 11}, true, ge, "ge r5 r4 LSL 11", "ge_r5_r4_LSL_11"},
     {{gt, r0, r1, LSL, 15}, true, gt, "gt r0 r1 LSL 15", "gt_r0_r1_LSL_15"},
     {{ls, r7, r4, LSL, 29}, true, ls, "ls r7 r4 LSL 29", "ls_r7_r4_LSL_29"},
     {{ne, r4, r6, LSL, 21}, true, ne, "ne r4 r6 LSL 21", "ne_r4_r6_LSL_21"},
     {{eq, r2, r5, LSL, 2}, true, eq, "eq r2 r5 LSL 2", "eq_r2_r5_LSL_2"},
     {{le, r3, r2, LSL, 15}, true, le, "le r3 r2 LSL 15", "le_r3_r2_LSL_15"},
     {{cc, r2, r7, LSL, 5}, true, cc, "cc r2 r7 LSL 5", "cc_r2_r7_LSL_5"},
     {{lt, r4, r7, LSL, 4}, true, lt, "lt r4 r7 LSL 4", "lt_r4_r7_LSL_4"},
     {{cc, r6, r5, LSL, 28}, true, cc, "cc r6 r5 LSL 28", "cc_r6_r5_LSL_28"},
     {{pl, r4, r1, LSL, 27}, true, pl, "pl r4 r1 LSL 27", "pl_r4_r1_LSL_27"},
     {{vs, r2, r5, LSL, 22}, true, vs, "vs r2 r5 LSL 22", "vs_r2_r5_LSL_22"},
     {{eq, r2, r7, LSL, 25}, true, eq, "eq r2 r7 LSL 25", "eq_r2_r7_LSL_25"},
     {{pl, r1, r2, LSL, 8}, true, pl, "pl r1 r2 LSL 8", "pl_r1_r2_LSL_8"},
     {{ge, r4, r0, LSL, 15}, true, ge, "ge r4 r0 LSL 15", "ge_r4_r0_LSL_15"},
     {{vc, r7, r5, LSL, 3}, true, vc, "vc r7 r5 LSL 3", "vc_r7_r5_LSL_3"},
     {{vc, r2, r7, LSL, 19}, true, vc, "vc r2 r7 LSL 19", "vc_r2_r7_LSL_19"},
     {{pl, r4, r0, LSL, 31}, true, pl, "pl r4 r0 LSL 31", "pl_r4_r0_LSL_31"},
     {{le, r3, r1, LSL, 21}, true, le, "le r3 r1 LSL 21", "le_r3_r1_LSL_21"},
     {{cs, r3, r7, LSL, 5}, true, cs, "cs r3 r7 LSL 5", "cs_r3_r7_LSL_5"},
     {{cs, r5, r0, LSL, 24}, true, cs, "cs r5 r0 LSL 24", "cs_r5_r0_LSL_24"},
     {{vc, r5, r2, LSL, 21}, true, vc, "vc r5 r2 LSL 21", "vc_r5_r2_LSL_21"},
     {{vc, r1, r3, LSL, 8}, true, vc, "vc r1 r3 LSL 8", "vc_r1_r3_LSL_8"},
     {{ne, r1, r3, LSL, 8}, true, ne, "ne r1 r3 LSL 8", "ne_r1_r3_LSL_8"},
     {{pl, r7, r0, LSL, 28}, true, pl, "pl r7 r0 LSL 28", "pl_r7_r0_LSL_28"},
     {{ge, r1, r0, LSL, 15}, true, ge, "ge r1 r0 LSL 15", "ge_r1_r0_LSL_15"},
     {{vc, r4, r6, LSL, 13}, true, vc, "vc r4 r6 LSL 13", "vc_r4_r6_LSL_13"},
     {{le, r4, r2, LSL, 16}, true, le, "le r4 r2 LSL 16", "le_r4_r2_LSL_16"},
     {{vc, r6, r0, LSL, 5}, true, vc, "vc r6 r0 LSL 5", "vc_r6_r0_LSL_5"},
     {{cs, r0, r2, LSL, 16}, true, cs, "cs r0 r2 LSL 16", "cs_r0_r2_LSL_16"},
     {{ne, r7, r0, LSL, 11}, true, ne, "ne r7 r0 LSL 11", "ne_r7_r0_LSL_11"},
     {{lt, r3, r4, LSL, 18}, true, lt, "lt r3 r4 LSL 18", "lt_r3_r4_LSL_18"},
     {{le, r5, r4, LSL, 23}, true, le, "le r5 r4 LSL 23", "le_r5_r4_LSL_23"},
     {{hi, r4, r3, LSL, 9}, true, hi, "hi r4 r3 LSL 9", "hi_r4_r3_LSL_9"},
     {{cs, r5, r3, LSL, 20}, true, cs, "cs r5 r3 LSL 20", "cs_r5_r3_LSL_20"},
     {{le, r4, r0, LSL, 18}, true, le, "le r4 r0 LSL 18", "le_r4_r0_LSL_18"},
     {{ls, r3, r5, LSL, 1}, true, ls, "ls r3 r5 LSL 1", "ls_r3_r5_LSL_1"},
     {{ge, r2, r5, LSL, 7}, true, ge, "ge r2 r5 LSL 7", "ge_r2_r5_LSL_7"},
     {{vs, r3, r6, LSL, 12}, true, vs, "vs r3 r6 LSL 12", "vs_r3_r6_LSL_12"},
     {{gt, r5, r3, LSL, 15}, true, gt, "gt r5 r3 LSL 15", "gt_r5_r3_LSL_15"},
     {{mi, r4, r0, LSL, 5}, true, mi, "mi r4 r0 LSL 5", "mi_r4_r0_LSL_5"},
     {{vc, r4, r7, LSL, 5}, true, vc, "vc r4 r7 LSL 5", "vc_r4_r7_LSL_5"},
     {{cs, r0, r5, LSL, 24}, true, cs, "cs r0 r5 LSL 24", "cs_r0_r5_LSL_24"},
     {{vs, r7, r7, LSL, 19}, true, vs, "vs r7 r7 LSL 19", "vs_r7_r7_LSL_19"},
     {{mi, r5, r4, LSL, 27}, true, mi, "mi r5 r4 LSL 27", "mi_r5_r4_LSL_27"},
     {{ne, r3, r7, LSL, 1}, true, ne, "ne r3 r7 LSL 1", "ne_r3_r7_LSL_1"},
     {{ne, r4, r7, LSL, 8}, true, ne, "ne r4 r7 LSL 8", "ne_r4_r7_LSL_8"},
     {{vs, r5, r4, LSL, 21}, true, vs, "vs r5 r4 LSL 21", "vs_r5_r4_LSL_21"},
     {{ls, r0, r0, LSL, 20}, true, ls, "ls r0 r0 LSL 20", "ls_r0_r0_LSL_20"},
     {{gt, r5, r1, LSL, 30}, true, gt, "gt r5 r1 LSL 30", "gt_r5_r1_LSL_30"},
     {{lt, r4, r5, LSL, 4}, true, lt, "lt r4 r5 LSL 4", "lt_r4_r5_LSL_4"},
     {{ge, r7, r6, LSL, 10}, true, ge, "ge r7 r6 LSL 10", "ge_r7_r6_LSL_10"},
     {{cc, r1, r6, LSL, 10}, true, cc, "cc r1 r6 LSL 10", "cc_r1_r6_LSL_10"},
     {{ls, r0, r5, LSL, 23}, true, ls, "ls r0 r5 LSL 23", "ls_r0_r5_LSL_23"},
     {{ge, r4, r2, LSL, 19}, true, ge, "ge r4 r2 LSL 19", "ge_r4_r2_LSL_19"},
     {{cc, r0, r7, LSL, 12}, true, cc, "cc r0 r7 LSL 12", "cc_r0_r7_LSL_12"},
     {{ls, r0, r2, LSL, 27}, true, ls, "ls r0 r2 LSL 27", "ls_r0_r2_LSL_27"},
     {{eq, r2, r7, LSL, 13}, true, eq, "eq r2 r7 LSL 13", "eq_r2_r7_LSL_13"},
     {{cc, r6, r7, LSL, 18}, true, cc, "cc r6 r7 LSL 18", "cc_r6_r7_LSL_18"},
     {{cc, r6, r1, LSL, 18}, true, cc, "cc r6 r1 LSL 18", "cc_r6_r1_LSL_18"},
     {{gt, r4, r6, LSL, 3}, true, gt, "gt r4 r6 LSL 3", "gt_r4_r6_LSL_3"},
     {{cc, r2, r4, LSL, 26}, true, cc, "cc r2 r4 LSL 26", "cc_r2_r4_LSL_26"},
     {{mi, r6, r5, LSL, 31}, true, mi, "mi r6 r5 LSL 31", "mi_r6_r5_LSL_31"},
     {{cs, r5, r3, LSL, 24}, true, cs, "cs r5 r3 LSL 24", "cs_r5_r3_LSL_24"},
     {{gt, r2, r4, LSL, 7}, true, gt, "gt r2 r4 LSL 7", "gt_r2_r4_LSL_7"},
     {{mi, r5, r3, LSL, 6}, true, mi, "mi r5 r3 LSL 6", "mi_r5_r3_LSL_6"},
     {{lt, r2, r5, LSL, 23}, true, lt, "lt r2 r5 LSL 23", "lt_r2_r5_LSL_23"},
     {{ls, r6, r4, LSL, 7}, true, ls, "ls r6 r4 LSL 7", "ls_r6_r4_LSL_7"},
     {{eq, r0, r6, LSL, 24}, true, eq, "eq r0 r6 LSL 24", "eq_r0_r6_LSL_24"},
     {{hi, r2, r6, LSL, 2}, true, hi, "hi r2 r6 LSL 2", "hi_r2_r6_LSL_2"},
     {{eq, r1, r4, LSL, 29}, true, eq, "eq r1 r4 LSL 29", "eq_r1_r4_LSL_29"},
     {{cs, r2, r0, LSL, 10}, true, cs, "cs r2 r0 LSL 10", "cs_r2_r0_LSL_10"},
     {{cs, r3, r4, LSL, 1}, true, cs, "cs r3 r4 LSL 1", "cs_r3_r4_LSL_1"},
     {{vs, r3, r7, LSL, 21}, true, vs, "vs r3 r7 LSL 21", "vs_r3_r7_LSL_21"},
     {{lt, r3, r2, LSL, 3}, true, lt, "lt r3 r2 LSL 3", "lt_r3_r2_LSL_3"},
     {{le, r1, r3, LSL, 14}, true, le, "le r1 r3 LSL 14", "le_r1_r3_LSL_14"},
     {{vc, r2, r3, LSL, 23}, true, vc, "vc r2 r3 LSL 23", "vc_r2_r3_LSL_23"},
     {{pl, r2, r0, LSL, 12}, true, pl, "pl r2 r0 LSL 12", "pl_r2_r0_LSL_12"},
     {{ge, r2, r6, LSL, 27}, true, ge, "ge r2 r6 LSL 27", "ge_r2_r6_LSL_27"},
     {{ls, r6, r3, LSL, 8}, true, ls, "ls r6 r3 LSL 8", "ls_r6_r3_LSL_8"},
     {{lt, r4, r1, LSL, 31}, true, lt, "lt r4 r1 LSL 31", "lt_r4_r1_LSL_31"},
     {{le, r1, r7, LSL, 24}, true, le, "le r1 r7 LSL 24", "le_r1_r7_LSL_24"},
     {{mi, r2, r2, LSL, 11}, true, mi, "mi r2 r2 LSL 11", "mi_r2_r2_LSL_11"},
     {{cc, r4, r1, LSL, 27}, true, cc, "cc r4 r1 LSL 27", "cc_r4_r1_LSL_27"},
     {{ne, r7, r2, LSL, 15}, true, ne, "ne r7 r2 LSL 15", "ne_r7_r2_LSL_15"},
     {{cc, r2, r4, LSL, 10}, true, cc, "cc r2 r4 LSL 10", "cc_r2_r4_LSL_10"},
     {{lt, r3, r6, LSL, 28}, true, lt, "lt r3 r6 LSL 28", "lt_r3_r6_LSL_28"},
     {{vc, r5, r1, LSL, 1}, true, vc, "vc r5 r1 LSL 1", "vc_r5_r1_LSL_1"},
     {{ls, r7, r1, LSL, 21}, true, ls, "ls r7 r1 LSL 21", "ls_r7_r1_LSL_21"},
     {{eq, r0, r0, LSL, 20}, true, eq, "eq r0 r0 LSL 20", "eq_r0_r0_LSL_20"},
     {{ne, r7, r0, LSL, 16}, true, ne, "ne r7 r0 LSL 16", "ne_r7_r0_LSL_16"},
     {{hi, r6, r1, LSL, 16}, true, hi, "hi r6 r1 LSL 16", "hi_r6_r1_LSL_16"},
     {{mi, r6, r5, LSL, 15}, true, mi, "mi r6 r5 LSL 15", "mi_r6_r5_LSL_15"},
     {{ge, r5, r3, LSL, 1}, true, ge, "ge r5 r3 LSL 1", "ge_r5_r3_LSL_1"},
     {{cs, r3, r6, LSL, 10}, true, cs, "cs r3 r6 LSL 10", "cs_r3_r6_LSL_10"},
     {{vs, r1, r3, LSL, 7}, true, vs, "vs r1 r3 LSL 7", "vs_r1_r3_LSL_7"},
     {{hi, r3, r2, LSL, 31}, true, hi, "hi r3 r2 LSL 31", "hi_r3_r2_LSL_31"},
     {{vc, r3, r0, LSL, 22}, true, vc, "vc r3 r0 LSL 22", "vc_r3_r0_LSL_22"},
     {{cc, r0, r7, LSL, 13}, true, cc, "cc r0 r7 LSL 13", "cc_r0_r7_LSL_13"},
     {{mi, r0, r1, LSL, 26}, true, mi, "mi r0 r1 LSL 26", "mi_r0_r1_LSL_26"},
     {{eq, r1, r5, LSL, 2}, true, eq, "eq r1 r5 LSL 2", "eq_r1_r5_LSL_2"},
     {{eq, r2, r4, LSL, 22}, true, eq, "eq r2 r4 LSL 22", "eq_r2_r4_LSL_22"},
     {{gt, r4, r2, LSL, 7}, true, gt, "gt r4 r2 LSL 7", "gt_r4_r2_LSL_7"},
     {{eq, r4, r3, LSL, 13}, true, eq, "eq r4 r3 LSL 13", "eq_r4_r3_LSL_13"},
     {{pl, r0, r2, LSL, 6}, true, pl, "pl r0 r2 LSL 6", "pl_r0_r2_LSL_6"},
     {{eq, r1, r4, LSL, 11}, true, eq, "eq r1 r4 LSL 11", "eq_r1_r4_LSL_11"},
     {{vs, r1, r7, LSL, 15}, true, vs, "vs r1 r7 LSL 15", "vs_r1_r7_LSL_15"},
     {{eq, r3, r2, LSL, 2}, true, eq, "eq r3 r2 LSL 2", "eq_r3_r2_LSL_2"},
     {{ge, r1, r1, LSL, 8}, true, ge, "ge r1 r1 LSL 8", "ge_r1_r1_LSL_8"},
     {{vc, r2, r6, LSL, 7}, true, vc, "vc r2 r6 LSL 7", "vc_r2_r6_LSL_7"},
     {{pl, r0, r4, LSL, 28}, true, pl, "pl r0 r4 LSL 28", "pl_r0_r4_LSL_28"},
     {{le, r7, r6, LSL, 20}, true, le, "le r7 r6 LSL 20", "le_r7_r6_LSL_20"},
     {{hi, r2, r3, LSL, 14}, true, hi, "hi r2 r3 LSL 14", "hi_r2_r3_LSL_14"},
     {{mi, r1, r3, LSL, 5}, true, mi, "mi r1 r3 LSL 5", "mi_r1_r3_LSL_5"},
     {{vc, r7, r0, LSL, 13}, true, vc, "vc r7 r0 LSL 13", "vc_r7_r0_LSL_13"},
     {{cc, r6, r2, LSL, 21}, true, cc, "cc r6 r2 LSL 21", "cc_r6_r2_LSL_21"},
     {{le, r5, r3, LSL, 6}, true, le, "le r5 r3 LSL 6", "le_r5_r3_LSL_6"},
     {{eq, r3, r7, LSL, 1}, true, eq, "eq r3 r7 LSL 1", "eq_r3_r7_LSL_1"},
     {{ge, r1, r0, LSL, 28}, true, ge, "ge r1 r0 LSL 28", "ge_r1_r0_LSL_28"},
     {{mi, r3, r4, LSL, 7}, true, mi, "mi r3 r4 LSL 7", "mi_r3_r4_LSL_7"},
     {{pl, r0, r4, LSL, 13}, true, pl, "pl r0 r4 LSL 13", "pl_r0_r4_LSL_13"},
     {{lt, r0, r4, LSL, 5}, true, lt, "lt r0 r4 LSL 5", "lt_r0_r4_LSL_5"},
     {{cc, r2, r2, LSL, 1}, true, cc, "cc r2 r2 LSL 1", "cc_r2_r2_LSL_1"},
     {{pl, r6, r2, LSL, 30}, true, pl, "pl r6 r2 LSL 30", "pl_r6_r2_LSL_30"},
     {{ls, r7, r0, LSL, 24}, true, ls, "ls r7 r0 LSL 24", "ls_r7_r0_LSL_24"},
     {{cs, r4, r4, LSL, 3}, true, cs, "cs r4 r4 LSL 3", "cs_r4_r4_LSL_3"},
     {{vs, r7, r0, LSL, 19}, true, vs, "vs r7 r0 LSL 19", "vs_r7_r0_LSL_19"},
     {{cc, r2, r3, LSL, 12}, true, cc, "cc r2 r3 LSL 12", "cc_r2_r3_LSL_12"},
     {{lt, r3, r7, LSL, 7}, true, lt, "lt r3 r7 LSL 7", "lt_r3_r7_LSL_7"},
     {{mi, r5, r5, LSL, 3}, true, mi, "mi r5 r5 LSL 3", "mi_r5_r5_LSL_3"},
     {{vc, r5, r5, LSL, 18}, true, vc, "vc r5 r5 LSL 18", "vc_r5_r5_LSL_18"},
     {{vc, r5, r0, LSL, 26}, true, vc, "vc r5 r0 LSL 26", "vc_r5_r0_LSL_26"},
     {{ls, r2, r5, LSL, 6}, true, ls, "ls r2 r5 LSL 6", "ls_r2_r5_LSL_6"},
     {{ge, r1, r7, LSL, 30}, true, ge, "ge r1 r7 LSL 30", "ge_r1_r7_LSL_30"},
     {{ls, r1, r2, LSL, 23}, true, ls, "ls r1 r2 LSL 23", "ls_r1_r2_LSL_23"},
     {{hi, r3, r7, LSL, 25}, true, hi, "hi r3 r7 LSL 25", "hi_r3_r7_LSL_25"},
     {{lt, r7, r0, LSL, 26}, true, lt, "lt r7 r0 LSL 26", "lt_r7_r0_LSL_26"},
     {{vs, r4, r2, LSL, 31}, true, vs, "vs r4 r2 LSL 31", "vs_r4_r2_LSL_31"},
     {{gt, r7, r2, LSL, 9}, true, gt, "gt r7 r2 LSL 9", "gt_r7_r2_LSL_9"},
     {{le, r2, r5, LSL, 16}, true, le, "le r2 r5 LSL 16", "le_r2_r5_LSL_16"},
     {{ls, r6, r6, LSL, 23}, true, ls, "ls r6 r6 LSL 23", "ls_r6_r6_LSL_23"},
     {{pl, r5, r5, LSL, 5}, true, pl, "pl r5 r5 LSL 5", "pl_r5_r5_LSL_5"},
     {{gt, r3, r2, LSL, 16}, true, gt, "gt r3 r2 LSL 16", "gt_r3_r2_LSL_16"},
     {{vs, r2, r3, LSL, 11}, true, vs, "vs r2 r3 LSL 11", "vs_r2_r3_LSL_11"},
     {{cc, r5, r6, LSL, 15}, true, cc, "cc r5 r6 LSL 15", "cc_r5_r6_LSL_15"},
     {{vc, r0, r0, LSL, 29}, true, vc, "vc r0 r0 LSL 29", "vc_r0_r0_LSL_29"},
     {{vs, r5, r0, LSL, 20}, true, vs, "vs r5 r0 LSL 20", "vs_r5_r0_LSL_20"},
     {{ls, r6, r3, LSL, 6}, true, ls, "ls r6 r3 LSL 6", "ls_r6_r3_LSL_6"},
     {{cc, r6, r7, LSL, 2}, true, cc, "cc r6 r7 LSL 2", "cc_r6_r7_LSL_2"},
     {{eq, r2, r2, LSL, 14}, true, eq, "eq r2 r2 LSL 14", "eq_r2_r2_LSL_14"},
     {{ne, r5, r3, LSL, 12}, true, ne, "ne r5 r3 LSL 12", "ne_r5_r3_LSL_12"},
     {{cc, r7, r2, LSL, 20}, true, cc, "cc r7 r2 LSL 20", "cc_r7_r2_LSL_20"},
     {{lt, r5, r0, LSL, 24}, true, lt, "lt r5 r0 LSL 24", "lt_r5_r0_LSL_24"},
     {{ge, r6, r7, LSL, 21}, true, ge, "ge r6 r7 LSL 21", "ge_r6_r7_LSL_21"},
     {{ls, r6, r7, LSL, 3}, true, ls, "ls r6 r7 LSL 3", "ls_r6_r7_LSL_3"},
     {{cs, r3, r6, LSL, 7}, true, cs, "cs r3 r6 LSL 7", "cs_r3_r6_LSL_7"},
     {{ls, r0, r5, LSL, 26}, true, ls, "ls r0 r5 LSL 26", "ls_r0_r5_LSL_26"},
     {{ne, r3, r0, LSL, 6}, true, ne, "ne r3 r0 LSL 6", "ne_r3_r0_LSL_6"},
     {{gt, r3, r7, LSL, 29}, true, gt, "gt r3 r7 LSL 29", "gt_r3_r7_LSL_29"},
     {{ne, r7, r3, LSL, 5}, true, ne, "ne r7 r3 LSL 5", "ne_r7_r3_LSL_5"},
     {{vs, r2, r1, LSL, 31}, true, vs, "vs r2 r1 LSL 31", "vs_r2_r1_LSL_31"},
     {{ne, r1, r2, LSL, 27}, true, ne, "ne r1 r2 LSL 27", "ne_r1_r2_LSL_27"},
     {{pl, r5, r0, LSL, 25}, true, pl, "pl r5 r0 LSL 25", "pl_r5_r0_LSL_25"},
     {{hi, r5, r0, LSL, 14}, true, hi, "hi r5 r0 LSL 14", "hi_r5_r0_LSL_14"},
     {{vs, r5, r5, LSL, 19}, true, vs, "vs r5 r5 LSL 19", "vs_r5_r5_LSL_19"},
     {{le, r6, r6, LSL, 10}, true, le, "le r6 r6 LSL 10", "le_r6_r6_LSL_10"},
     {{ne, r2, r1, LSL, 3}, true, ne, "ne r2 r1 LSL 3", "ne_r2_r1_LSL_3"},
     {{gt, r2, r7, LSL, 7}, true, gt, "gt r2 r7 LSL 7", "gt_r2_r7_LSL_7"},
     {{vs, r0, r6, LSL, 31}, true, vs, "vs r0 r6 LSL 31", "vs_r0_r6_LSL_31"},
     {{ne, r4, r4, LSL, 28}, true, ne, "ne r4 r4 LSL 28", "ne_r4_r4_LSL_28"},
     {{mi, r1, r0, LSL, 14}, true, mi, "mi r1 r0 LSL 14", "mi_r1_r0_LSL_14"},
     {{lt, r0, r6, LSL, 30}, true, lt, "lt r0 r6 LSL 30", "lt_r0_r6_LSL_30"},
     {{lt, r2, r4, LSL, 10}, true, lt, "lt r2 r4 LSL 10", "lt_r2_r4_LSL_10"},
     {{lt, r0, r3, LSL, 22}, true, lt, "lt r0 r3 LSL 22", "lt_r0_r3_LSL_22"},
     {{ls, r5, r5, LSL, 28}, true, ls, "ls r5 r5 LSL 28", "ls_r5_r5_LSL_28"},
     {{pl, r4, r1, LSL, 20}, true, pl, "pl r4 r1 LSL 20", "pl_r4_r1_LSL_20"},
     {{le, r0, r1, LSL, 14}, true, le, "le r0 r1 LSL 14", "le_r0_r1_LSL_14"},
     {{le, r2, r1, LSL, 8}, true, le, "le r2 r1 LSL 8", "le_r2_r1_LSL_8"},
     {{ls, r2, r1, LSL, 20}, true, ls, "ls r2 r1 LSL 20", "ls_r2_r1_LSL_20"},
     {{le, r4, r0, LSL, 14}, true, le, "le r4 r0 LSL 14", "le_r4_r0_LSL_14"},
     {{lt, r7, r4, LSL, 17}, true, lt, "lt r7 r4 LSL 17", "lt_r7_r4_LSL_17"},
     {{cc, r6, r1, LSL, 3}, true, cc, "cc r6 r1 LSL 3", "cc_r6_r1_LSL_3"},
     {{pl, r6, r3, LSL, 1}, true, pl, "pl r6 r3 LSL 1", "pl_r6_r3_LSL_1"},
     {{cc, r2, r2, LSL, 3}, true, cc, "cc r2 r2 LSL 3", "cc_r2_r2_LSL_3"},
     {{ge, r2, r6, LSL, 22}, true, ge, "ge r2 r6 LSL 22", "ge_r2_r6_LSL_22"},
     {{gt, r6, r0, LSL, 23}, true, gt, "gt r6 r0 LSL 23", "gt_r6_r0_LSL_23"},
     {{ge, r5, r1, LSL, 18}, true, ge, "ge r5 r1 LSL 18", "ge_r5_r1_LSL_18"},
     {{eq, r7, r0, LSL, 11}, true, eq, "eq r7 r0 LSL 11", "eq_r7_r0_LSL_11"},
     {{mi, r2, r7, LSL, 8}, true, mi, "mi r2 r7 LSL 8", "mi_r2_r7_LSL_8"},
     {{pl, r2, r7, LSL, 19}, true, pl, "pl r2 r7 LSL 19", "pl_r2_r7_LSL_19"},
     {{mi, r3, r6, LSL, 1}, true, mi, "mi r3 r6 LSL 1", "mi_r3_r6_LSL_1"},
     {{lt, r6, r5, LSL, 29}, true, lt, "lt r6 r5 LSL 29", "lt_r6_r5_LSL_29"},
     {{eq, r0, r4, LSL, 9}, true, eq, "eq r0 r4 LSL 9", "eq_r0_r4_LSL_9"},
     {{hi, r3, r1, LSL, 7}, true, hi, "hi r3 r1 LSL 7", "hi_r3_r1_LSL_7"},
     {{cs, r5, r5, LSL, 12}, true, cs, "cs r5 r5 LSL 12", "cs_r5_r5_LSL_12"},
     {{lt, r1, r5, LSL, 24}, true, lt, "lt r1 r5 LSL 24", "lt_r1_r5_LSL_24"},
     {{cc, r6, r0, LSL, 4}, true, cc, "cc r6 r0 LSL 4", "cc_r6_r0_LSL_4"},
     {{hi, r3, r0, LSL, 15}, true, hi, "hi r3 r0 LSL 15", "hi_r3_r0_LSL_15"},
     {{gt, r7, r2, LSL, 17}, true, gt, "gt r7 r2 LSL 17", "gt_r7_r2_LSL_17"},
     {{hi, r4, r0, LSL, 4}, true, hi, "hi r4 r0 LSL 4", "hi_r4_r0_LSL_4"},
     {{cc, r5, r4, LSL, 22}, true, cc, "cc r5 r4 LSL 22", "cc_r5_r4_LSL_22"},
     {{lt, r3, r1, LSL, 13}, true, lt, "lt r3 r1 LSL 13", "lt_r3_r1_LSL_13"},
     {{le, r4, r7, LSL, 5}, true, le, "le r4 r7 LSL 5", "le_r4_r7_LSL_5"},
     {{cs, r0, r5, LSL, 22}, true, cs, "cs r0 r5 LSL 22", "cs_r0_r5_LSL_22"},
     {{eq, r3, r6, LSL, 1}, true, eq, "eq r3 r6 LSL 1", "eq_r3_r6_LSL_1"},
     {{vs, r3, r3, LSL, 8}, true, vs, "vs r3 r3 LSL 8", "vs_r3_r3_LSL_8"},
     {{vs, r4, r4, LSL, 17}, true, vs, "vs r4 r4 LSL 17", "vs_r4_r4_LSL_17"},
     {{ne, r0, r3, LSL, 16}, true, ne, "ne r0 r3 LSL 16", "ne_r0_r3_LSL_16"},
     {{le, r4, r7, LSL, 4}, true, le, "le r4 r7 LSL 4", "le_r4_r7_LSL_4"},
     {{vs, r4, r6, LSL, 2}, true, vs, "vs r4 r6 LSL 2", "vs_r4_r6_LSL_2"},
     {{pl, r7, r4, LSL, 8}, true, pl, "pl r7 r4 LSL 8", "pl_r7_r4_LSL_8"},
     {{ls, r6, r2, LSL, 2}, true, ls, "ls r6 r2 LSL 2", "ls_r6_r2_LSL_2"},
     {{cc, r2, r2, LSL, 13}, true, cc, "cc r2 r2 LSL 13", "cc_r2_r2_LSL_13"},
     {{pl, r7, r5, LSL, 7}, true, pl, "pl r7 r5 LSL 7", "pl_r7_r5_LSL_7"},
     {{pl, r3, r6, LSL, 6}, true, pl, "pl r3 r6 LSL 6", "pl_r3_r6_LSL_6"},
     {{ne, r4, r5, LSL, 3}, true, ne, "ne r4 r5 LSL 3", "ne_r4_r5_LSL_3"},
     {{lt, r5, r5, LSL, 16}, true, lt, "lt r5 r5 LSL 16", "lt_r5_r5_LSL_16"},
     {{gt, r1, r2, LSL, 23}, true, gt, "gt r1 r2 LSL 23", "gt_r1_r2_LSL_23"},
     {{vc, r1, r6, LSL, 27}, true, vc, "vc r1 r6 LSL 27", "vc_r1_r6_LSL_27"},
     {{vc, r6, r0, LSL, 3}, true, vc, "vc r6 r0 LSL 3", "vc_r6_r0_LSL_3"},
     {{vc, r1, r6, LSL, 10}, true, vc, "vc r1 r6 LSL 10", "vc_r1_r6_LSL_10"},
     {{vc, r3, r7, LSL, 21}, true, vc, "vc r3 r7 LSL 21", "vc_r3_r7_LSL_21"},
     {{lt, r5, r7, LSL, 31}, true, lt, "lt r5 r7 LSL 31", "lt_r5_r7_LSL_31"},
     {{vs, r6, r1, LSL, 11}, true, vs, "vs r6 r1 LSL 11", "vs_r6_r1_LSL_11"},
     {{gt, r7, r4, LSL, 19}, true, gt, "gt r7 r4 LSL 19", "gt_r7_r4_LSL_19"},
     {{hi, r0, r4, LSL, 22}, true, hi, "hi r0 r4 LSL 22", "hi_r0_r4_LSL_22"},
     {{hi, r2, r0, LSL, 18}, true, hi, "hi r2 r0 LSL 18", "hi_r2_r0_LSL_18"},
     {{ls, r1, r3, LSL, 12}, true, ls, "ls r1 r3 LSL 12", "ls_r1_r3_LSL_12"},
     {{hi, r0, r6, LSL, 23}, true, hi, "hi r0 r6 LSL 23", "hi_r0_r6_LSL_23"},
     {{ne, r3, r5, LSL, 22}, true, ne, "ne r3 r5 LSL 22", "ne_r3_r5_LSL_22"},
     {{ge, r4, r4, LSL, 4}, true, ge, "ge r4 r4 LSL 4", "ge_r4_r4_LSL_4"},
     {{cc, r1, r6, LSL, 25}, true, cc, "cc r1 r6 LSL 25", "cc_r1_r6_LSL_25"},
     {{vs, r2, r1, LSL, 13}, true, vs, "vs r2 r1 LSL 13", "vs_r2_r1_LSL_13"},
     {{lt, r6, r7, LSL, 6}, true, lt, "lt r6 r7 LSL 6", "lt_r6_r7_LSL_6"},
     {{gt, r5, r6, LSL, 7}, true, gt, "gt r5 r6 LSL 7", "gt_r5_r6_LSL_7"},
     {{ge, r5, r1, LSL, 27}, true, ge, "ge r5 r1 LSL 27", "ge_r5_r1_LSL_27"},
     {{vs, r2, r3, LSL, 8}, true, vs, "vs r2 r3 LSL 8", "vs_r2_r3_LSL_8"},
     {{gt, r0, r3, LSL, 4}, true, gt, "gt r0 r3 LSL 4", "gt_r0_r3_LSL_4"},
     {{vc, r5, r6, LSL, 17}, true, vc, "vc r5 r6 LSL 17", "vc_r5_r6_LSL_17"},
     {{mi, r5, r2, LSL, 23}, true, mi, "mi r5 r2 LSL 23", "mi_r5_r2_LSL_23"},
     {{cc, r3, r3, LSL, 10}, true, cc, "cc r3 r3 LSL 10", "cc_r3_r3_LSL_10"},
     {{le, r5, r3, LSL, 18}, true, le, "le r5 r3 LSL 18", "le_r5_r3_LSL_18"},
     {{le, r4, r0, LSL, 9}, true, le, "le r4 r0 LSL 9", "le_r4_r0_LSL_9"},
     {{pl, r0, r1, LSL, 10}, true, pl, "pl r0 r1 LSL 10", "pl_r0_r1_LSL_10"},
     {{ls, r6, r4, LSL, 2}, true, ls, "ls r6 r4 LSL 2", "ls_r6_r4_LSL_2"},
     {{cc, r6, r6, LSL, 5}, true, cc, "cc r6 r6 LSL 5", "cc_r6_r6_LSL_5"},
     {{pl, r2, r5, LSL, 2}, true, pl, "pl r2 r5 LSL 2", "pl_r2_r5_LSL_2"},
     {{vs, r7, r0, LSL, 3}, true, vs, "vs r7 r0 LSL 3", "vs_r7_r0_LSL_3"},
     {{vs, r7, r7, LSL, 8}, true, vs, "vs r7 r7 LSL 8", "vs_r7_r7_LSL_8"},
     {{ge, r0, r7, LSL, 5}, true, ge, "ge r0 r7 LSL 5", "ge_r0_r7_LSL_5"},
     {{gt, r3, r7, LSL, 16}, true, gt, "gt r3 r7 LSL 16", "gt_r3_r7_LSL_16"},
     {{mi, r4, r2, LSL, 22}, true, mi, "mi r4 r2 LSL 22", "mi_r4_r2_LSL_22"},
     {{le, r1, r2, LSL, 4}, true, le, "le r1 r2 LSL 4", "le_r1_r2_LSL_4"},
     {{mi, r5, r4, LSL, 3}, true, mi, "mi r5 r4 LSL 3", "mi_r5_r4_LSL_3"},
     {{hi, r2, r3, LSL, 26}, true, hi, "hi r2 r3 LSL 26", "hi_r2_r3_LSL_26"},
     {{ne, r6, r1, LSL, 29}, true, ne, "ne r6 r1 LSL 29", "ne_r6_r1_LSL_29"},
     {{gt, r6, r0, LSL, 29}, true, gt, "gt r6 r0 LSL 29", "gt_r6_r0_LSL_29"},
     {{pl, r3, r2, LSL, 19}, true, pl, "pl r3 r2 LSL 19", "pl_r3_r2_LSL_19"},
     {{ls, r5, r2, LSL, 5}, true, ls, "ls r5 r2 LSL 5", "ls_r5_r2_LSL_5"},
     {{ne, r4, r5, LSL, 16}, true, ne, "ne r4 r5 LSL 16", "ne_r4_r5_LSL_16"},
     {{vc, r2, r1, LSL, 2}, true, vc, "vc r2 r1 LSL 2", "vc_r2_r1_LSL_2"},
     {{ne, r0, r7, LSL, 27}, true, ne, "ne r0 r7 LSL 27", "ne_r0_r7_LSL_27"},
     {{eq, r4, r2, LSL, 30}, true, eq, "eq r4 r2 LSL 30", "eq_r4_r2_LSL_30"},
     {{hi, r7, r2, LSL, 18}, true, hi, "hi r7 r2 LSL 18", "hi_r7_r2_LSL_18"},
     {{eq, r2, r0, LSL, 21}, true, eq, "eq r2 r0 LSL 21", "eq_r2_r0_LSL_21"},
     {{hi, r1, r1, LSL, 9}, true, hi, "hi r1 r1 LSL 9", "hi_r1_r1_LSL_9"},
     {{lt, r6, r6, LSL, 10}, true, lt, "lt r6 r6 LSL 10", "lt_r6_r6_LSL_10"},
     {{vc, r4, r5, LSL, 15}, true, vc, "vc r4 r5 LSL 15", "vc_r4_r5_LSL_15"},
     {{cc, r1, r1, LSL, 12}, true, cc, "cc r1 r1 LSL 12", "cc_r1_r1_LSL_12"},
     {{le, r0, r4, LSL, 29}, true, le, "le r0 r4 LSL 29", "le_r0_r4_LSL_29"},
     {{cs, r6, r2, LSL, 12}, true, cs, "cs r6 r2 LSL 12", "cs_r6_r2_LSL_12"},
     {{pl, r6, r2, LSL, 21}, true, pl, "pl r6 r2 LSL 21", "pl_r6_r2_LSL_21"},
     {{le, r4, r4, LSL, 31}, true, le, "le r4 r4 LSL 31", "le_r4_r4_LSL_31"},
     {{cs, r3, r6, LSL, 26}, true, cs, "cs r3 r6 LSL 26", "cs_r3_r6_LSL_26"},
     {{ne, r1, r2, LSL, 2}, true, ne, "ne r1 r2 LSL 2", "ne_r1_r2_LSL_2"},
     {{vc, r0, r4, LSL, 24}, true, vc, "vc r0 r4 LSL 24", "vc_r0_r4_LSL_24"},
     {{mi, r3, r4, LSL, 9}, true, mi, "mi r3 r4 LSL 9", "mi_r3_r4_LSL_9"},
     {{pl, r5, r1, LSL, 23}, true, pl, "pl r5 r1 LSL 23", "pl_r5_r1_LSL_23"},
     {{ls, r1, r6, LSL, 31}, true, ls, "ls r1 r6 LSL 31", "ls_r1_r6_LSL_31"},
     {{mi, r6, r2, LSL, 6}, true, mi, "mi r6 r2 LSL 6", "mi_r6_r2_LSL_6"},
     {{vc, r1, r3, LSL, 27}, true, vc, "vc r1 r3 LSL 27", "vc_r1_r3_LSL_27"},
     {{vc, r6, r7, LSL, 26}, true, vc, "vc r6 r7 LSL 26", "vc_r6_r7_LSL_26"},
     {{vs, r2, r6, LSL, 10}, true, vs, "vs r2 r6 LSL 10", "vs_r2_r6_LSL_10"},
     {{ge, r5, r6, LSL, 5}, true, ge, "ge r5 r6 LSL 5", "ge_r5_r6_LSL_5"},
     {{hi, r0, r5, LSL, 19}, true, hi, "hi r0 r5 LSL 19", "hi_r0_r5_LSL_19"},
     {{eq, r4, r1, LSL, 13}, true, eq, "eq r4 r1 LSL 13", "eq_r4_r1_LSL_13"},
     {{eq, r1, r3, LSL, 24}, true, eq, "eq r1 r3 LSL 24", "eq_r1_r3_LSL_24"},
     {{hi, r1, r0, LSL, 30}, true, hi, "hi r1 r0 LSL 30", "hi_r1_r0_LSL_30"},
     {{lt, r7, r0, LSL, 11}, true, lt, "lt r7 r0 LSL 11", "lt_r7_r0_LSL_11"},
     {{le, r1, r5, LSL, 3}, true, le, "le r1 r5 LSL 3", "le_r1_r5_LSL_3"},
     {{gt, r2, r5, LSL, 1}, true, gt, "gt r2 r5 LSL 1", "gt_r2_r5_LSL_1"},
     {{mi, r1, r0, LSL, 6}, true, mi, "mi r1 r0 LSL 6", "mi_r1_r0_LSL_6"},
     {{le, r1, r6, LSL, 24}, true, le, "le r1 r6 LSL 24", "le_r1_r6_LSL_24"},
     {{vs, r4, r2, LSL, 17}, true, vs, "vs r4 r2 LSL 17", "vs_r4_r2_LSL_17"},
     {{ls, r2, r3, LSL, 20}, true, ls, "ls r2 r3 LSL 20", "ls_r2_r3_LSL_20"},
     {{pl, r0, r7, LSL, 8}, true, pl, "pl r0 r7 LSL 8", "pl_r0_r7_LSL_8"},
     {{ne, r1, r3, LSL, 19}, true, ne, "ne r1 r3 LSL 19", "ne_r1_r3_LSL_19"},
     {{gt, r4, r6, LSL, 2}, true, gt, "gt r4 r6 LSL 2", "gt_r4_r6_LSL_2"},
     {{vc, r5, r0, LSL, 1}, true, vc, "vc r5 r0 LSL 1", "vc_r5_r0_LSL_1"},
     {{le, r1, r1, LSL, 28}, true, le, "le r1 r1 LSL 28", "le_r1_r1_LSL_28"},
     {{vc, r2, r4, LSL, 17}, true, vc, "vc r2 r4 LSL 17", "vc_r2_r4_LSL_17"},
     {{le, r5, r2, LSL, 25}, true, le, "le r5 r2 LSL 25", "le_r5_r2_LSL_25"},
     {{cc, r6, r3, LSL, 22}, true, cc, "cc r6 r3 LSL 22", "cc_r6_r3_LSL_22"},
     {{cc, r3, r3, LSL, 20}, true, cc, "cc r3 r3 LSL 20", "cc_r3_r3_LSL_20"},
     {{pl, r4, r5, LSL, 20}, true, pl, "pl r4 r5 LSL 20", "pl_r4_r5_LSL_20"},
     {{cc, r2, r3, LSL, 14}, true, cc, "cc r2 r3 LSL 14", "cc_r2_r3_LSL_14"},
     {{eq, r4, r0, LSL, 8}, true, eq, "eq r4 r0 LSL 8", "eq_r4_r0_LSL_8"},
     {{lt, r5, r0, LSL, 15}, true, lt, "lt r5 r0 LSL 15", "lt_r5_r0_LSL_15"},
     {{pl, r5, r6, LSL, 25}, true, pl, "pl r5 r6 LSL 25", "pl_r5_r6_LSL_25"},
     {{ls, r5, r3, LSL, 6}, true, ls, "ls r5 r3 LSL 6", "ls_r5_r3_LSL_6"},
     {{ge, r7, r0, LSL, 7}, true, ge, "ge r7 r0 LSL 7", "ge_r7_r0_LSL_7"},
     {{le, r0, r7, LSL, 12}, true, le, "le r0 r7 LSL 12", "le_r0_r7_LSL_12"},
     {{hi, r4, r4, LSL, 31}, true, hi, "hi r4 r4 LSL 31", "hi_r4_r4_LSL_31"},
     {{pl, r5, r1, LSL, 22}, true, pl, "pl r5 r1 LSL 22", "pl_r5_r1_LSL_22"},
     {{cc, r0, r3, LSL, 11}, true, cc, "cc r0 r3 LSL 11", "cc_r0_r3_LSL_11"},
     {{le, r2, r4, LSL, 9}, true, le, "le r2 r4 LSL 9", "le_r2_r4_LSL_9"},
     {{ne, r6, r2, LSL, 17}, true, ne, "ne r6 r2 LSL 17", "ne_r6_r2_LSL_17"},
     {{vs, r1, r1, LSL, 7}, true, vs, "vs r1 r1 LSL 7", "vs_r1_r1_LSL_7"},
     {{cc, r5, r7, LSL, 2}, true, cc, "cc r5 r7 LSL 2", "cc_r5_r7_LSL_2"},
     {{le, r7, r3, LSL, 15}, true, le, "le r7 r3 LSL 15", "le_r7_r3_LSL_15"},
     {{ge, r7, r0, LSL, 20}, true, ge, "ge r7 r0 LSL 20", "ge_r7_r0_LSL_20"},
     {{vc, r3, r4, LSL, 2}, true, vc, "vc r3 r4 LSL 2", "vc_r3_r4_LSL_2"},
     {{eq, r5, r0, LSL, 10}, true, eq, "eq r5 r0 LSL 10", "eq_r5_r0_LSL_10"},
     {{cc, r5, r6, LSL, 4}, true, cc, "cc r5 r6 LSL 4", "cc_r5_r6_LSL_4"},
     {{ge, r4, r1, LSL, 23}, true, ge, "ge r4 r1 LSL 23", "ge_r4_r1_LSL_23"},
     {{cs, r2, r1, LSL, 18}, true, cs, "cs r2 r1 LSL 18", "cs_r2_r1_LSL_18"},
     {{gt, r1, r3, LSL, 22}, true, gt, "gt r1 r3 LSL 22", "gt_r1_r3_LSL_22"},
     {{cc, r0, r3, LSL, 7}, true, cc, "cc r0 r3 LSL 7", "cc_r0_r3_LSL_7"},
     {{cs, r1, r6, LSL, 3}, true, cs, "cs r1 r6 LSL 3", "cs_r1_r6_LSL_3"},
     {{ne, r0, r4, LSL, 14}, true, ne, "ne r0 r4 LSL 14", "ne_r0_r4_LSL_14"},
     {{ls, r0, r1, LSL, 31}, true, ls, "ls r0 r1 LSL 31", "ls_r0_r1_LSL_31"},
     {{ge, r1, r2, LSL, 4}, true, ge, "ge r1 r2 LSL 4", "ge_r1_r2_LSL_4"},
     {{ne, r1, r4, LSL, 6}, true, ne, "ne r1 r4 LSL 6", "ne_r1_r4_LSL_6"},
     {{eq, r2, r6, LSL, 3}, true, eq, "eq r2 r6 LSL 3", "eq_r2_r6_LSL_3"},
     {{gt, r3, r7, LSL, 7}, true, gt, "gt r3 r7 LSL 7", "gt_r3_r7_LSL_7"},
     {{ls, r3, r6, LSL, 25}, true, ls, "ls r3 r6 LSL 25", "ls_r3_r6_LSL_25"},
     {{lt, r2, r4, LSL, 4}, true, lt, "lt r2 r4 LSL 4", "lt_r2_r4_LSL_4"},
     {{cs, r5, r6, LSL, 24}, true, cs, "cs r5 r6 LSL 24", "cs_r5_r6_LSL_24"},
     {{pl, r6, r6, LSL, 19}, true, pl, "pl r6 r6 LSL 19", "pl_r6_r6_LSL_19"},
     {{vs, r1, r0, LSL, 10}, true, vs, "vs r1 r0 LSL 10", "vs_r1_r0_LSL_10"},
     {{cs, r6, r4, LSL, 17}, true, cs, "cs r6 r4 LSL 17", "cs_r6_r4_LSL_17"},
     {{lt, r4, r3, LSL, 5}, true, lt, "lt r4 r3 LSL 5", "lt_r4_r3_LSL_5"},
     {{cs, r6, r5, LSL, 30}, true, cs, "cs r6 r5 LSL 30", "cs_r6_r5_LSL_30"},
     {{cs, r7, r4, LSL, 27}, true, cs, "cs r7 r4 LSL 27", "cs_r7_r4_LSL_27"},
     {{lt, r2, r6, LSL, 4}, true, lt, "lt r2 r6 LSL 4", "lt_r2_r6_LSL_4"},
     {{gt, r7, r7, LSL, 16}, true, gt, "gt r7 r7 LSL 16", "gt_r7_r7_LSL_16"},
     {{mi, r1, r4, LSL, 11}, true, mi, "mi r1 r4 LSL 11", "mi_r1_r4_LSL_11"},
     {{ls, r5, r6, LSL, 21}, true, ls, "ls r5 r6 LSL 21", "ls_r5_r6_LSL_21"},
     {{le, r1, r4, LSL, 25}, true, le, "le r1 r4 LSL 25", "le_r1_r4_LSL_25"},
     {{hi, r7, r1, LSL, 5}, true, hi, "hi r7 r1 LSL 5", "hi_r7_r1_LSL_5"},
     {{ls, r5, r1, LSL, 15}, true, ls, "ls r5 r1 LSL 15", "ls_r5_r1_LSL_15"},
     {{ne, r7, r3, LSL, 3}, true, ne, "ne r7 r3 LSL 3", "ne_r7_r3_LSL_3"},
     {{mi, r1, r0, LSL, 1}, true, mi, "mi r1 r0 LSL 1", "mi_r1_r0_LSL_1"},
     {{ls, r5, r5, LSL, 21}, true, ls, "ls r5 r5 LSL 21", "ls_r5_r5_LSL_21"},
     {{ls, r1, r0, LSL, 11}, true, ls, "ls r1 r0 LSL 11", "ls_r1_r0_LSL_11"},
     {{cs, r1, r5, LSL, 30}, true, cs, "cs r1 r5 LSL 30", "cs_r1_r5_LSL_30"},
     {{ge, r4, r1, LSL, 19}, true, ge, "ge r4 r1 LSL 19", "ge_r4_r1_LSL_19"},
     {{pl, r0, r2, LSL, 15}, true, pl, "pl r0 r2 LSL 15", "pl_r0_r2_LSL_15"},
     {{hi, r4, r5, LSL, 10}, true, hi, "hi r4 r5 LSL 10", "hi_r4_r5_LSL_10"},
     {{pl, r3, r0, LSL, 1}, true, pl, "pl r3 r0 LSL 1", "pl_r3_r0_LSL_1"},
     {{ge, r3, r0, LSL, 20}, true, ge, "ge r3 r0 LSL 20", "ge_r3_r0_LSL_20"},
     {{pl, r6, r4, LSL, 20}, true, pl, "pl r6 r4 LSL 20", "pl_r6_r4_LSL_20"},
     {{le, r6, r0, LSL, 16}, true, le, "le r6 r0 LSL 16", "le_r6_r0_LSL_16"},
     {{vc, r6, r5, LSL, 14}, true, vc, "vc r6 r5 LSL 14", "vc_r6_r5_LSL_14"},
     {{mi, r6, r2, LSL, 20}, true, mi, "mi r6 r2 LSL 20", "mi_r6_r2_LSL_20"},
     {{lt, r1, r3, LSL, 18}, true, lt, "lt r1 r3 LSL 18", "lt_r1_r3_LSL_18"},
     {{eq, r1, r2, LSL, 5}, true, eq, "eq r1 r2 LSL 5", "eq_r1_r2_LSL_5"},
     {{ge, r1, r0, LSL, 23}, true, ge, "ge r1 r0 LSL 23", "ge_r1_r0_LSL_23"},
     {{cc, r2, r5, LSL, 7}, true, cc, "cc r2 r5 LSL 7", "cc_r2_r5_LSL_7"},
     {{cc, r1, r7, LSL, 3}, true, cc, "cc r1 r7 LSL 3", "cc_r1_r7_LSL_3"},
     {{mi, r2, r5, LSL, 29}, true, mi, "mi r2 r5 LSL 29", "mi_r2_r5_LSL_29"},
     {{cc, r5, r5, LSL, 9}, true, cc, "cc r5 r5 LSL 9", "cc_r5_r5_LSL_9"},
     {{cs, r3, r2, LSL, 1}, true, cs, "cs r3 r2 LSL 1", "cs_r3_r2_LSL_1"},
     {{ge, r5, r3, LSL, 15}, true, ge, "ge r5 r3 LSL 15", "ge_r5_r3_LSL_15"},
     {{gt, r7, r1, LSL, 10}, true, gt, "gt r7 r1 LSL 10", "gt_r7_r1_LSL_10"},
     {{ls, r4, r6, LSL, 15}, true, ls, "ls r4 r6 LSL 15", "ls_r4_r6_LSL_15"},
     {{gt, r3, r1, LSL, 15}, true, gt, "gt r3 r1 LSL 15", "gt_r3_r1_LSL_15"},
     {{cs, r5, r5, LSL, 30}, true, cs, "cs r5 r5 LSL 30", "cs_r5_r5_LSL_30"},
     {{eq, r4, r2, LSL, 19}, true, eq, "eq r4 r2 LSL 19", "eq_r4_r2_LSL_19"},
     {{vc, r0, r5, LSL, 21}, true, vc, "vc r0 r5 LSL 21", "vc_r0_r5_LSL_21"},
     {{cs, r2, r0, LSL, 3}, true, cs, "cs r2 r0 LSL 3", "cs_r2_r0_LSL_3"},
     {{ne, r1, r2, LSL, 20}, true, ne, "ne r1 r2 LSL 20", "ne_r1_r2_LSL_20"},
     {{ne, r6, r0, LSL, 28}, true, ne, "ne r6 r0 LSL 28", "ne_r6_r0_LSL_28"},
     {{ne, r7, r3, LSL, 7}, true, ne, "ne r7 r3 LSL 7", "ne_r7_r3_LSL_7"},
     {{mi, r5, r4, LSL, 29}, true, mi, "mi r5 r4 LSL 29", "mi_r5_r4_LSL_29"},
     {{vs, r3, r5, LSL, 18}, true, vs, "vs r3 r5 LSL 18", "vs_r3_r5_LSL_18"},
     {{mi, r1, r2, LSL, 1}, true, mi, "mi r1 r2 LSL 1", "mi_r1_r2_LSL_1"},
     {{hi, r4, r7, LSL, 21}, true, hi, "hi r4 r7 LSL 21", "hi_r4_r7_LSL_21"},
     {{ge, r6, r1, LSL, 21}, true, ge, "ge r6 r1 LSL 21", "ge_r6_r1_LSL_21"},
     {{lt, r4, r5, LSL, 20}, true, lt, "lt r4 r5 LSL 20", "lt_r4_r5_LSL_20"},
     {{vs, r6, r7, LSL, 2}, true, vs, "vs r6 r7 LSL 2", "vs_r6_r7_LSL_2"},
     {{hi, r1, r6, LSL, 30}, true, hi, "hi r1 r6 LSL 30", "hi_r1_r6_LSL_30"},
     {{ls, r0, r2, LSL, 7}, true, ls, "ls r0 r2 LSL 7", "ls_r0_r2_LSL_7"},
     {{cc, r7, r3, LSL, 22}, true, cc, "cc r7 r3 LSL 22", "cc_r7_r3_LSL_22"},
     {{vs, r1, r1, LSL, 5}, true, vs, "vs r1 r1 LSL 5", "vs_r1_r1_LSL_5"},
     {{ls, r5, r4, LSL, 19}, true, ls, "ls r5 r4 LSL 19", "ls_r5_r4_LSL_19"},
     {{pl, r6, r2, LSL, 14}, true, pl, "pl r6 r2 LSL 14", "pl_r6_r2_LSL_14"},
     {{cs, r1, r0, LSL, 1}, true, cs, "cs r1 r0 LSL 1", "cs_r1_r0_LSL_1"},
     {{mi, r6, r1, LSL, 2}, true, mi, "mi r6 r1 LSL 2", "mi_r6_r1_LSL_2"},
     {{mi, r5, r1, LSL, 26}, true, mi, "mi r5 r1 LSL 26", "mi_r5_r1_LSL_26"},
     {{ne, r0, r7, LSL, 15}, true, ne, "ne r0 r7 LSL 15", "ne_r0_r7_LSL_15"},
     {{cs, r2, r7, LSL, 15}, true, cs, "cs r2 r7 LSL 15", "cs_r2_r7_LSL_15"},
     {{ne, r7, r2, LSL, 24}, true, ne, "ne r7 r2 LSL 24", "ne_r7_r2_LSL_24"},
     {{le, r1, r2, LSL, 8}, true, le, "le r1 r2 LSL 8", "le_r1_r2_LSL_8"},
     {{eq, r3, r3, LSL, 3}, true, eq, "eq r3 r3 LSL 3", "eq_r3_r3_LSL_3"},
     {{mi, r1, r4, LSL, 23}, true, mi, "mi r1 r4 LSL 23", "mi_r1_r4_LSL_23"},
     {{pl, r3, r4, LSL, 26}, true, pl, "pl r3 r4 LSL 26", "pl_r3_r4_LSL_26"},
     {{lt, r3, r2, LSL, 14}, true, lt, "lt r3 r2 LSL 14", "lt_r3_r2_LSL_14"},
     {{ne, r7, r0, LSL, 6}, true, ne, "ne r7 r0 LSL 6", "ne_r7_r0_LSL_6"},
     {{pl, r2, r0, LSL, 26}, true, pl, "pl r2 r0 LSL 26", "pl_r2_r0_LSL_26"},
     {{cc, r1, r0, LSL, 22}, true, cc, "cc r1 r0 LSL 22", "cc_r1_r0_LSL_22"},
     {{mi, r7, r3, LSL, 30}, true, mi, "mi r7 r3 LSL 30", "mi_r7_r3_LSL_30"},
     {{ge, r0, r4, LSL, 30}, true, ge, "ge r0 r4 LSL 30", "ge_r0_r4_LSL_30"},
     {{gt, r0, r4, LSL, 14}, true, gt, "gt r0 r4 LSL 14", "gt_r0_r4_LSL_14"},
     {{cc, r7, r1, LSL, 21}, true, cc, "cc r7 r1 LSL 21", "cc_r7_r1_LSL_21"},
     {{lt, r7, r1, LSL, 4}, true, lt, "lt r7 r1 LSL 4", "lt_r7_r1_LSL_4"},
     {{ls, r0, r2, LSL, 23}, true, ls, "ls r0 r2 LSL 23", "ls_r0_r2_LSL_23"},
     {{vs, r6, r6, LSL, 9}, true, vs, "vs r6 r6 LSL 9", "vs_r6_r6_LSL_9"},
     {{eq, r4, r6, LSL, 14}, true, eq, "eq r4 r6 LSL 14", "eq_r4_r6_LSL_14"},
     {{gt, r2, r0, LSL, 2}, true, gt, "gt r2 r0 LSL 2", "gt_r2_r0_LSL_2"},
     {{lt, r2, r4, LSL, 27}, true, lt, "lt r2 r4 LSL 27", "lt_r2_r4_LSL_27"},
     {{cs, r7, r2, LSL, 14}, true, cs, "cs r7 r2 LSL 14", "cs_r7_r2_LSL_14"},
     {{vc, r7, r1, LSL, 29}, true, vc, "vc r7 r1 LSL 29", "vc_r7_r1_LSL_29"},
     {{cc, r1, r2, LSL, 10}, true, cc, "cc r1 r2 LSL 10", "cc_r1_r2_LSL_10"},
     {{lt, r3, r6, LSL, 11}, true, lt, "lt r3 r6 LSL 11", "lt_r3_r6_LSL_11"},
     {{le, r7, r6, LSL, 6}, true, le, "le r7 r6 LSL 6", "le_r7_r6_LSL_6"},
     {{lt, r6, r1, LSL, 16}, true, lt, "lt r6 r1 LSL 16", "lt_r6_r1_LSL_16"},
     {{pl, r5, r3, LSL, 21}, true, pl, "pl r5 r3 LSL 21", "pl_r5_r3_LSL_21"},
     {{cs, r1, r7, LSL, 20}, true, cs, "cs r1 r7 LSL 20", "cs_r1_r7_LSL_20"},
     {{le, r6, r1, LSL, 31}, true, le, "le r6 r1 LSL 31", "le_r6_r1_LSL_31"},
     {{cc, r7, r7, LSL, 2}, true, cc, "cc r7 r7 LSL 2", "cc_r7_r7_LSL_2"},
     {{pl, r5, r7, LSL, 28}, true, pl, "pl r5 r7 LSL 28", "pl_r5_r7_LSL_28"},
     {{pl, r6, r4, LSL, 5}, true, pl, "pl r6 r4 LSL 5", "pl_r6_r4_LSL_5"},
     {{eq, r1, r1, LSL, 20}, true, eq, "eq r1 r1 LSL 20", "eq_r1_r1_LSL_20"},
     {{ls, r1, r1, LSL, 11}, true, ls, "ls r1 r1 LSL 11", "ls_r1_r1_LSL_11"},
     {{eq, r2, r7, LSL, 30}, true, eq, "eq r2 r7 LSL 30", "eq_r2_r7_LSL_30"},
     {{ls, r4, r2, LSL, 25}, true, ls, "ls r4 r2 LSL 25", "ls_r4_r2_LSL_25"},
     {{hi, r5, r6, LSL, 30}, true, hi, "hi r5 r6 LSL 30", "hi_r5_r6_LSL_30"},
     {{ls, r5, r7, LSL, 9}, true, ls, "ls r5 r7 LSL 9", "ls_r5_r7_LSL_9"},
     {{lt, r7, r7, LSL, 16}, true, lt, "lt r7 r7 LSL 16", "lt_r7_r7_LSL_16"},
     {{mi, r0, r4, LSL, 6}, true, mi, "mi r0 r4 LSL 6", "mi_r0_r4_LSL_6"},
     {{vs, r3, r0, LSL, 3}, true, vs, "vs r3 r0 LSL 3", "vs_r3_r0_LSL_3"},
     {{lt, r2, r0, LSL, 14}, true, lt, "lt r2 r0 LSL 14", "lt_r2_r0_LSL_14"},
     {{ls, r6, r5, LSL, 13}, true, ls, "ls r6 r5 LSL 13", "ls_r6_r5_LSL_13"},
     {{eq, r6, r0, LSL, 7}, true, eq, "eq r6 r0 LSL 7", "eq_r6_r0_LSL_7"},
     {{ge, r2, r0, LSL, 18}, true, ge, "ge r2 r0 LSL 18", "ge_r2_r0_LSL_18"},
     {{mi, r5, r3, LSL, 30}, true, mi, "mi r5 r3 LSL 30", "mi_r5_r3_LSL_30"},
     {{mi, r1, r5, LSL, 4}, true, mi, "mi r1 r5 LSL 4", "mi_r1_r5_LSL_4"},
     {{pl, r4, r1, LSL, 15}, true, pl, "pl r4 r1 LSL 15", "pl_r4_r1_LSL_15"},
     {{ls, r7, r6, LSL, 7}, true, ls, "ls r7 r6 LSL 7", "ls_r7_r6_LSL_7"},
     {{eq, r2, r4, LSL, 16}, true, eq, "eq r2 r4 LSL 16", "eq_r2_r4_LSL_16"},
     {{eq, r5, r3, LSL, 23}, true, eq, "eq r5 r3 LSL 23", "eq_r5_r3_LSL_23"},
     {{le, r4, r6, LSL, 23}, true, le, "le r4 r6 LSL 23", "le_r4_r6_LSL_23"},
     {{ls, r3, r3, LSL, 13}, true, ls, "ls r3 r3 LSL 13", "ls_r3_r3_LSL_13"},
     {{hi, r2, r5, LSL, 28}, true, hi, "hi r2 r5 LSL 28", "hi_r2_r5_LSL_28"},
     {{gt, r1, r2, LSL, 8}, true, gt, "gt r1 r2 LSL 8", "gt_r1_r2_LSL_8"},
     {{cs, r1, r2, LSL, 11}, true, cs, "cs r1 r2 LSL 11", "cs_r1_r2_LSL_11"},
     {{vs, r3, r4, LSL, 23}, true, vs, "vs r3 r4 LSL 23", "vs_r3_r4_LSL_23"},
     {{cs, r4, r0, LSL, 12}, true, cs, "cs r4 r0 LSL 12", "cs_r4_r0_LSL_12"},
     {{hi, r5, r6, LSL, 5}, true, hi, "hi r5 r6 LSL 5", "hi_r5_r6_LSL_5"},
     {{cs, r0, r3, LSL, 10}, true, cs, "cs r0 r3 LSL 10", "cs_r0_r3_LSL_10"},
     {{lt, r2, r2, LSL, 30}, true, lt, "lt r2 r2 LSL 30", "lt_r2_r2_LSL_30"},
     {{eq, r4, r2, LSL, 21}, true, eq, "eq r4 r2 LSL 21", "eq_r4_r2_LSL_21"},
     {{mi, r0, r2, LSL, 10}, true, mi, "mi r0 r2 LSL 10", "mi_r0_r2_LSL_10"},
     {{pl, r5, r0, LSL, 11}, true, pl, "pl r5 r0 LSL 11", "pl_r5_r0_LSL_11"},
     {{hi, r1, r7, LSL, 19}, true, hi, "hi r1 r7 LSL 19", "hi_r1_r7_LSL_19"},
     {{le, r3, r5, LSL, 7}, true, le, "le r3 r5 LSL 7", "le_r3_r5_LSL_7"},
     {{hi, r3, r5, LSL, 19}, true, hi, "hi r3 r5 LSL 19", "hi_r3_r5_LSL_19"},
     {{ne, r5, r3, LSL, 14}, true, ne, "ne r5 r3 LSL 14", "ne_r5_r3_LSL_14"},
     {{ne, r3, r5, LSL, 1}, true, ne, "ne r3 r5 LSL 1", "ne_r3_r5_LSL_1"},
     {{gt, r7, r4, LSL, 23}, true, gt, "gt r7 r4 LSL 23", "gt_r7_r4_LSL_23"},
     {{cc, r2, r3, LSL, 3}, true, cc, "cc r2 r3 LSL 3", "cc_r2_r3_LSL_3"},
     {{cc, r7, r7, LSL, 22}, true, cc, "cc r7 r7 LSL 22", "cc_r7_r7_LSL_22"},
     {{cs, r7, r0, LSL, 10}, true, cs, "cs r7 r0 LSL 10", "cs_r7_r0_LSL_10"},
     {{le, r2, r7, LSL, 7}, true, le, "le r2 r7 LSL 7", "le_r2_r7_LSL_7"},
     {{cc, r5, r6, LSL, 7}, true, cc, "cc r5 r6 LSL 7", "cc_r5_r6_LSL_7"},
     {{ne, r0, r1, LSL, 1}, true, ne, "ne r0 r1 LSL 1", "ne_r0_r1_LSL_1"},
     {{mi, r3, r6, LSL, 8}, true, mi, "mi r3 r6 LSL 8", "mi_r3_r6_LSL_8"},
     {{mi, r0, r7, LSL, 14}, true, mi, "mi r0 r7 LSL 14", "mi_r0_r7_LSL_14"},
     {{hi, r0, r5, LSL, 17}, true, hi, "hi r0 r5 LSL 17", "hi_r0_r5_LSL_17"},
     {{lt, r2, r5, LSL, 7}, true, lt, "lt r2 r5 LSL 7", "lt_r2_r5_LSL_7"},
     {{mi, r1, r1, LSL, 18}, true, mi, "mi r1 r1 LSL 18", "mi_r1_r1_LSL_18"},
     {{pl, r3, r2, LSL, 13}, true, pl, "pl r3 r2 LSL 13", "pl_r3_r2_LSL_13"},
     {{gt, r6, r1, LSL, 13}, true, gt, "gt r6 r1 LSL 13", "gt_r6_r1_LSL_13"},
     {{eq, r2, r6, LSL, 11}, true, eq, "eq r2 r6 LSL 11", "eq_r2_r6_LSL_11"},
     {{vs, r2, r6, LSL, 24}, true, vs, "vs r2 r6 LSL 24", "vs_r2_r6_LSL_24"},
     {{mi, r5, r0, LSL, 15}, true, mi, "mi r5 r0 LSL 15", "mi_r5_r0_LSL_15"}};

// These headers each contain an array of `TestResult` with the reference output
// values. The reference arrays are names `kReference{mnemonic}`.
#include "aarch32/traces/assembler-cond-rd-operand-rn-shift-amount-1to31-in-it-block-mov-t32.h"


// The maximum number of errors to report in detail for each test.
const unsigned kErrorReportLimit = 8;

typedef void (MacroAssembler::*Fn)(Condition cond,
                                   Register rd,
                                   const Operand& op);

void TestHelper(Fn instruction,
                const char* mnemonic,
                const TestResult reference[]) {
  unsigned total_error_count = 0;
  MacroAssembler masm(BUF_SIZE);

  masm.UseT32();

  for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
    // Values to pass to the macro-assembler.
    Condition cond = kTests[i].operands.cond;
    Register rd = kTests[i].operands.rd;
    Register rn = kTests[i].operands.rn;
    ShiftType shift = kTests[i].operands.shift;
    uint32_t amount = kTests[i].operands.amount;
    Operand op(rn, shift, amount);

    int32_t start = masm.GetCursorOffset();
    {
      // We never generate more that 4 bytes, as IT instructions are only
      // allowed for narrow encodings.
      ExactAssemblyScope scope(&masm, 4, ExactAssemblyScope::kMaximumSize);
      if (kTests[i].in_it_block) {
        masm.it(kTests[i].it_condition);
      }
      (masm.*instruction)(cond, rd, op);
    }
    int32_t end = masm.GetCursorOffset();

    const byte* result_ptr =
        masm.GetBuffer()->GetOffsetAddress<const byte*>(start);
    VIXL_ASSERT(start < end);
    uint32_t result_size = end - start;

    if (Test::generate_test_trace()) {
      // Print the result bytes.
      printf("const byte kInstruction_%s_%s[] = {\n",
             mnemonic,
             kTests[i].identifier);
      for (uint32_t j = 0; j < result_size; j++) {
        if (j == 0) {
          printf("  0x%02" PRIx8, result_ptr[j]);
        } else {
          printf(", 0x%02" PRIx8, result_ptr[j]);
        }
      }
      // This comment is meant to be used by external tools to validate
      // the encoding. We can parse the comment to figure out what
      // instruction this corresponds to.
      if (kTests[i].in_it_block) {
        printf(" // It %s; %s %s\n};\n",
               kTests[i].it_condition.GetName(),
               mnemonic,
               kTests[i].operands_description);
      } else {
        printf(" // %s %s\n};\n", mnemonic, kTests[i].operands_description);
      }
    } else {
      // Check we've emitted the exact same encoding as present in the
      // trace file. Only print up to `kErrorReportLimit` errors.
      if (((result_size != reference[i].size) ||
           (memcmp(result_ptr, reference[i].encoding, reference[i].size) !=
            0)) &&
          (++total_error_count <= kErrorReportLimit)) {
        printf("Error when testing \"%s\" with operands \"%s\":\n",
               mnemonic,
               kTests[i].operands_description);
        printf("  Expected: ");
        for (uint32_t j = 0; j < reference[i].size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, reference[i].encoding[j]);
          } else {
            printf(", 0x%02" PRIx8, reference[i].encoding[j]);
          }
        }
        printf("\n");
        printf("  Found:    ");
        for (uint32_t j = 0; j < result_size; j++) {
          if (j == 0) {
            printf("0x%02" PRIx8, result_ptr[j]);
          } else {
            printf(", 0x%02" PRIx8, result_ptr[j]);
          }
        }
        printf("\n");
      }
    }
  }

  masm.FinalizeCode();

  if (Test::generate_test_trace()) {
    // Finalize the trace file by writing the final `TestResult` array
    // which links all generated instruction encodings.
    printf("const TestResult kReference%s[] = {\n", mnemonic);
    for (unsigned i = 0; i < ARRAY_SIZE(kTests); i++) {
      printf("  {\n");
      printf("    ARRAY_SIZE(kInstruction_%s_%s),\n",
             mnemonic,
             kTests[i].identifier);
      printf("    kInstruction_%s_%s,\n", mnemonic, kTests[i].identifier);
      printf("  },\n");
    }
    printf("};\n");
  } else {
    if (total_error_count > kErrorReportLimit) {
      printf("%u other errors follow.\n",
             total_error_count - kErrorReportLimit);
    }
    // Crash if the test failed.
    VIXL_CHECK(total_error_count == 0);
  }
}

// Instantiate tests for each instruction in the list.
#define TEST(mnemonic)                                                      \
  void Test_##mnemonic() {                                                  \
    TestHelper(&MacroAssembler::mnemonic, #mnemonic, kReference##mnemonic); \
  }                                                                         \
  Test test_##mnemonic(                                                     \
      "AARCH32_ASSEMBLER_COND_RD_OPERAND_RN_SHIFT_AMOUNT_1TO31_IN_IT_"      \
      "BLOCK_" #mnemonic "_T32",                                            \
      &Test_##mnemonic);
FOREACH_INSTRUCTION(TEST)
#undef TEST

}  // namespace
#endif

}  // namespace aarch32
}  // namespace vixl
