# Keep all the images in one place
proc load_all_images {} {
  global cvscfg
  global cvsglb
  
  # App icons
  image create photo AppIcon -format png -file [file join $cvscfg(bitmapdir) wm_TkSVN.png]
  image create photo Blame -format png -file [file join $cvscfg(bitmapdir) wm_blame.png]
  image create photo Branch -format png -file [file join $cvscfg(bitmapdir) wm_branch.png]
  image create photo Merge -format png -file [file join $cvscfg(bitmapdir) wm_merge.png]
  image create photo Help -format png -file [file join $cvscfg(bitmapdir) wm_help.png]
  image create photo Says -format png -file [file join $cvscfg(bitmapdir) wm_says.png]
  image create photo Trace -format png -file [file join $cvscfg(bitmapdir) wm_trace.png]
  
  # Buttons
  set photodict [dict create]
  dict set photodict    Add	        add.png
  dict set photodict    Annotate	annotate.png
  dict set photodict    Branches	branch.png
  dict set photodict    BranchNo	lightning.png
  dict set photodict    Branchtag	branchtag.png
  dict set photodict    Check	        check.png
  dict set photodict    Checkin	        checkin.png
  dict set photodict    Checkout	checkout.png
  dict set photodict    CheckoutOpts	checkout_opts.png
  dict set photodict    Conflict	conflict.png
  dict set photodict    Delete	        delete.png
  dict set photodict    Diff	        delta_feather.png
  dict set photodict    Difflines	difflines.png
  dict set photodict    DirBranches	dirbranch.png
  dict set photodict    Dir_new	        folder_new.png
  dict set photodict    Edit	        edit.png
  dict set photodict    Export	        export.png
  dict set photodict    Fileedit	fileedit.png
  dict set photodict    Files	        files.png
  dict set photodict    Fileview	fileview.png
  dict set photodict    Folder	        dir.png
  dict set photodict    GitCheckin	git_checkin.png
  dict set photodict    GitCheckout	git_checkout.png
  dict set photodict    Import	        import.png
  dict set photodict    Lock	        locked.png
  dict set photodict    Log	        log.png
  dict set photodict    Man	        man.png
  dict set photodict    Mergebranch	newmerge_simple.png
  dict set photodict    Mergebranch	newmerge_simple.png
  dict set photodict    Mergediff	newmerge.png
  dict set photodict    Mergediff	newmerge.png
  dict set photodict    Modules	        modbrowse.png
  dict set photodict    Modules_cvs	modbrowse_cvs.png
  dict set photodict    Modules_git	modbrowse_git.png
  dict set photodict    Modules_svn	modbrowse_svn.png
  dict set photodict    Patches	        rdiff.png
  dict set photodict    Patchfile	patchfile.png
  dict set photodict    Refresh	        refresh.png
  dict set photodict    Remove	        remove.png
  dict set photodict    Revert	        loop-ball.png
  dict set photodict    SvnRemove	delete_red.png
  dict set photodict    Tag	        tag.png
  dict set photodict    Tags	        tags.png
  dict set photodict    UnLock	        unlocked.png
  dict set photodict    Unedit	        unedit.png
  dict set photodict    Who	        who.png
  dict set photodict    Workdir	        folderopen.png
  dict set photodict    arr_dn	        arrow_dn.png
  dict set photodict    arr_up	        arrow_up.png
  dict set photodict    updir	        updir.png
  dict set photodict    adir	        adir.png
  dict set photodict    amod	        amod.png
  dict set photodict    dir	        dir.png
  dict set photodict    mdir	        mdir.png
  dict set photodict    mod	        mod.png
  dict set photodict    cvsdir	        dir_cvs.png
  dict set photodict    dir_minus	dir_minus.png
  dict set photodict    dir_mod	        dir_mod.png
  dict set photodict    dir_ok	        dir_ok.png
  dict set photodict    dir_ood	        dir_ood.png
  dict set photodict    dir_plus	dir_plus.png
  dict set photodict    dir	        dir.png
  dict set photodict    gitdir	        dir_git.png
  dict set photodict    link	        link.png
  dict set photodict    link_mod	link_mod.png
  dict set photodict    link_modml	link_modml.png
  dict set photodict    link_modol	link_modol.png
  dict set photodict    link_ok	        link_ok.png
  dict set photodict    link_okml	link_okml.png
  dict set photodict    link_okol	link_okol.png
  dict set photodict    link_plus	link_plus.png
  dict set photodict    paper	        paper.png
  dict set photodict    rcsdir	        dir_rcs.png
  dict set photodict    stat_conf	stat_conf.png
  dict set photodict    stat_cvsplus_kb	stat_plus_kb.png
  dict set photodict    stat_ex	        stat_ex.png
  dict set photodict    stat_kb	        stat_kb.png
  dict set photodict    stat_merge	stat_merge.png
  dict set photodict    stat_minus	stat_minus.png
  dict set photodict    stat_mod	stat_mod.png
  dict set photodict    stat_mod_green	stat_mod_green.png
  dict set photodict    stat_mod_red	stat_mod_red.png
  dict set photodict    stat_modml	stat_modml.png
  dict set photodict    stat_modol	stat_modol.png
  dict set photodict    stat_ok	        stat_ok.png
  dict set photodict    stat_okml	stat_okml.png
  dict set photodict    stat_okol	stat_okol.png
  dict set photodict    stat_ood	stat_ood.png
  dict set photodict    stat_oodml	stat_oodml.png
  dict set photodict    stat_plus	stat_plus.png
  dict set photodict    stat_plus_minus	stat_plus_minus.png
  dict set photodict    stat_ques	stat_ques.png
  dict set photodict    svndir	        dir_svn.png
  dict set photodict    Tclfish         TkCVS_128.png
  dict set photodict    Toothyfish      TkSVN_128.png
  dict set photodict    Squid           TkRev_128.png

  dict for {image png} $photodict {
    image create photo $image -format png -file [file join $cvscfg(bitmapdir) $png]
    if {$cvscfg(large_icons)} {
      image create photo Zoomed -format png
      # Enlarge the orignal and copy it into a temporary image
      Zoomed copy $image -zoom $cvscfg(icon_mag) $cvscfg(icon_mag)
      # empty the original. compositingrule doesn't seem to work
      $image blank 
      # copy the zoomed one back into the original
      $image copy Zoomed
      # Discard the temporary
      image delete Zoomed
    }
  }
  set cvsglb(mod_iconwidth) [image width paper]
  set cvsglb(mod_iconheight) [image height paper]
}

