// Emacs style mode select -*- C++ -*-
//---------------------------------------------------------------------------
//
// $Id: swsymbol.c,v 1.1.1.1 2003/02/14 19:03:21 fraggle Exp $
//
// Copyright(C) 1984-2000 David L. Clark
// Copyright(C) 2001-2003 Simon Howard
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version. This program is distributed in the hope that
// it will be useful, but WITHOUT ANY WARRANTY; without even the implied
// warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
// the GNU General Public License for more details. You should have
// received a copy of the GNU General Public License along with this
// program; if not, write to the Free Software Foundation, Inc., 59 Temple
// Place - Suite 330, Boston, MA 02111-1307, USA.
//
//---------------------------------------------------------------------------
//
// Sprites
//
//---------------------------------------------------------------------------

#include "sw.h"
#include "swsymbol.h"

// sdh 28/6/2002: these are from swsymbol.h
// some of this is probably kind of redundant seeing as the data is 
// all static now

#define BOMBBYTES       16              /*  Bytes in a bomb symbol          */
#define BOMBANGS        8               /*  Number of bomb angles           */
#define TARGBYTES       64              /*  Bytes in a target symbol        */
#define TARGORIENTS     4               /*  Number of target types          */
#define EXPLSYMS        8               /*  Number of explosion symbols     */
#define EXPBYTES        16              /*  Bytes in an explosion symbol    */
#define FLCKSYMS        2               /*  Number of flock symbols         */
#define FLKBYTES        64              /*  Bytes in a flock symbol         */
#define BIRDSYMS        2               /*  Number of bird symbols          */
#define BRDBYTES        2               /*  Bytes in a bird symbol          */
#define OXSYMS          2               /*  Number of ox symbols            */
#define OXBYTES         64              /*  Bytes in an ox symbol           */
#define GHSTBYTES       16              /*  Bytes in a ghost symbol         */
#define SHOTBYTES       64              /*  Bytes in a shot window symbol   */
#define SPLTBYTES       256             /*  Bytes in a splatted bird symbol */
#define MISCBYTES       16              /*  Bytes in a missile symbol       */
#define MISCANGS        16              /*  Number of missile angles        */
#define BRSTBYTES       16              /*  Bytes in a starburst symbol     */
#define BRSTSYMS        2               /*  Number of starburst symbols     */

#define HITSYMS         2               /*  Number of hit symbols per plane */
#define SYMBYTES        64              /*  Bytes in a symbol               */
#define WINSIZES        4               /*  Number of winner plane sizes    */
#define WINBYTES        64              /*  Bytes in a winner symbol        */

// sdh 28/6/2002: moved planes here

static unsigned char swplnsym[ORIENTS][ANGLES][SYMBYTES] = {

/*  airplane symbols based on the following template file:
16
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
1 1 1 . . . . . . . . . . . . .
1 1 1 1 . . . . 2 2 2 2 2 2 2 .
1 1 1 1 1 . . . . . 2 . 2 . . .
2 2 2 2 2 1 1 1 1 1 2 1 2 1 1 1
. 1 1 1 1 1 1 1 1 1 2 1 2 1 1 1
. . 1 1 1 1 1 1 2 2 2 2 2 2 1 1
. . 1 . . . . . . . . 1 . . . .
. . . . . . . . . . 1 1 1 . . .
. . . . . . . . . . . 1 . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
*/
    {
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x54, 0x0 , 0x0 , 0x0 ,
		0x55, 0x0 , 0xAA, 0xA8, 0x55, 0x40, 0x8 , 0x80, 0xAA, 0x95,
		0x59, 0x95, 0x15, 0x55, 0x59, 0x95, 0x5 , 0x55, 0xAA, 0xA5,
		0x4 , 0x0 , 0x1 , 0x0 , 0x0 , 0x0 , 0x5 , 0x40, 0x0 , 0x0 ,
		0x1 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x2 , 0xA0, 0x0 , 0x0 , 0x2A, 0x4 ,
		0x0 , 0x2 , 0xA2, 0x55, 0x10, 0x0 , 0x19, 0x95, 0x54, 0x41,
		0x59, 0xA0, 0x55, 0x95, 0x6A, 0x0 , 0x6A, 0x55, 0x60, 0x50,
		0x15, 0x54, 0x1 , 0x40, 0x1 , 0x40, 0x0 , 0x0 , 0x1 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x8 , 0x0 , 0x0 , 0x0 ,
		0x8 , 0x40, 0x0 , 0x0 , 0xA1, 0x50, 0x0 , 0x2 , 0x9 , 0x50,
		0x0 , 0x8 , 0xA6, 0x80, 0x0 , 0x0 , 0x4A, 0x0 , 0x0 , 0x1 ,
		0x58, 0x50, 0x0 , 0x5 , 0x60, 0x50, 0x11, 0x55, 0x40, 0x0 ,
		0x55, 0x95, 0x0 , 0x0 , 0x56, 0x54, 0x0 , 0x0 , 0x19, 0x50,
		0x0 , 0x0 , 0x0 , 0x10, 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x4 , 0x0 , 0x0 , 0x2 , 0x95, 0x40, 0x0 , 0x2 ,
		0x15, 0x0 , 0x0 , 0x8 , 0xA6, 0x0 , 0x0 , 0x8 , 0x5A, 0x0 ,
		0x0 , 0xA , 0xA9, 0x40, 0x0 , 0x20, 0x58, 0x50, 0x0 , 0x1 ,
		0x60, 0x0 , 0x0 , 0x1 , 0x60, 0x0 , 0x0 , 0x5 , 0x50, 0x0 ,
		0x0 , 0x15, 0x40, 0x0 , 0x5 , 0x69, 0x40, 0x0 , 0x5 , 0x65,
		0x0 , 0x0 , 0x15, 0x65, 0x0 , 0x0 , 0x5 , 0x80, 0x40, 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x1 , 0x50, 0x0 , 0x0 , 0x21, 0x50, 0x0 , 0x0 , 0x21,
		0x60, 0x0 , 0x0 , 0x2A, 0xA1, 0x0 , 0x0 , 0x21, 0x65, 0x40,
		0x0 , 0x2A, 0xA1, 0x0 , 0x0 , 0x21, 0x60, 0x0 , 0x0 , 0x21,
		0x60, 0x0 , 0x0 , 0x1 , 0x50, 0x0 , 0x0 , 0x1 , 0x50, 0x0 ,
		0x0 , 0x1 , 0x50, 0x0 , 0x0 , 0x6 , 0x50, 0x0 , 0x0 , 0x16,
		0x50, 0x0 , 0x0 , 0x56, 0x54, 0x0 , 0x0 , 0x56, 0x40, 0x0 ,
		0x0 , 0x56, 0x0 , 0x0 ,
	},
	{
		0x0 , 0x14, 0x0 , 0x0 , 0x0 , 0x54, 0x0 , 0x0 , 0x2 , 0x16,
		0x10, 0x0 , 0x2 , 0x1A, 0x14, 0x0 , 0x2 , 0xA5, 0x84, 0x0 ,
		0x0 , 0x8A, 0x80, 0x0 , 0x0 , 0xA5, 0xA0, 0x0 , 0x0 , 0x21,
		0x50, 0x0 , 0x0 , 0x21, 0x50, 0x0 , 0x0 , 0x0 , 0x54, 0x0 ,
		0x0 , 0x0 , 0x54, 0x0 , 0x0 , 0x1 , 0x95, 0x0 , 0x0 , 0x0 ,
		0x65, 0x40, 0x0 , 0x1 , 0x64, 0x0 , 0x0 , 0x5 , 0x64, 0x0 ,
		0x0 , 0x1 , 0x50, 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x1 , 0x41,
		0x40, 0x0 , 0x5 , 0x61, 0x40, 0x0 , 0x1 , 0x68, 0x0 , 0x0 ,
		0x28, 0x9A, 0x0 , 0x0 , 0x2 , 0x21, 0x80, 0x0 , 0x2 , 0x25,
		0x50, 0x0 , 0x0 , 0x81, 0x54, 0x0 , 0x0 , 0x20, 0x55, 0x0 ,
		0x0 , 0x0 , 0x15, 0x50, 0x0 , 0x0 , 0x19, 0x40, 0x0 , 0x0 ,
		0x16, 0x40, 0x0 , 0x0 , 0x5 , 0x80, 0x0 , 0x0 , 0x15, 0x40,
		0x0 , 0x0 , 0x5 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x4 ,
		0x0 , 0x0 , 0x10, 0x14, 0x0 , 0x0 , 0x16, 0x90, 0x0 , 0x0 ,
		0x55, 0xA8, 0x0 , 0x0 , 0x16, 0x66, 0x90, 0x0 , 0x22, 0x65,
		0x55, 0x4 , 0x28, 0x21, 0x55, 0x50, 0x2 , 0xA0, 0x16, 0x50,
		0x0 , 0x8 , 0x6 , 0xA0, 0x0 , 0x0 , 0x1 , 0x58, 0x0 , 0x0 ,
		0x1 , 0x54, 0x0 , 0x0 , 0x1 , 0x54, 0x0 , 0x0 , 0x0 , 0x10,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x40, 0x0 , 0x0 , 0x1 , 0x50, 0x0 , 0x0 ,
		0x0 , 0x40, 0x0 , 0x10, 0x5A, 0xAA, 0x55, 0x50, 0x56, 0x65,
		0x55, 0x54, 0x56, 0x65, 0x56, 0xAA, 0x2 , 0x20, 0x1 , 0x55,
		0x2A, 0xAA, 0x0 , 0x55, 0x0 , 0x0 , 0x0 , 0x15, 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x40, 0x0 , 0x0 , 0x1 , 0x40,
		0x1 , 0x40, 0x15, 0x54, 0x5 , 0x9 , 0x55, 0xA9, 0x0 , 0xA9,
		0x56, 0x55, 0xA , 0x65, 0x41, 0x15, 0x56, 0x64, 0x0 , 0x4 ,
		0x55, 0x8A, 0x80, 0x0 , 0x10, 0xA8, 0x0 , 0x0 , 0xA , 0x80,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x4 , 0x0 , 0x0 , 0x0 , 0x5 , 0x64, 0x0 , 0x0 , 0x15, 0x95,
		0x0 , 0x0 , 0x56, 0x55, 0x0 , 0x1 , 0x55, 0x44, 0x5 , 0x9 ,
		0x50, 0x0 , 0x5 , 0x25, 0x40, 0x0 , 0x0 , 0xA1, 0x0 , 0x0 ,
		0x2 , 0x9A, 0x20, 0x0 , 0x5 , 0x60, 0x80, 0x0 , 0x5 , 0x4A,
		0x0 , 0x0 , 0x1 , 0x20, 0x0 , 0x0 , 0x0 , 0x20, 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x1 , 0x2 , 0x50, 0x0 , 0x0 ,
		0x59, 0x54, 0x0 , 0x0 , 0x59, 0x50, 0x0 , 0x1 , 0x69, 0x50,
		0x0 , 0x1 , 0x54, 0x0 , 0x0 , 0x5 , 0x50, 0x0 , 0x0 , 0x9 ,
		0x40, 0x0 , 0x0 , 0x9 , 0x40, 0x0 , 0x5 , 0x25, 0x8 , 0x0 ,
		0x1 , 0x6A, 0xA0, 0x0 , 0x0 , 0xA5, 0x20, 0x0 , 0x0 , 0x9A,
		0x20, 0x0 , 0x0 , 0x54, 0x80, 0x0 , 0x1 , 0x56, 0x80, 0x0 ,
		0x0 , 0x10, 0x0 , 0x0 ,
	},
	{		
		0x0 , 0x0 , 0x95, 0x0 , 0x0 , 0x1 , 0x95, 0x0 , 0x0 , 0x15,
		0x95, 0x0 , 0x0 , 0x5 , 0x94, 0x0 , 0x0 , 0x5 , 0x90, 0x0 ,
		0x0 , 0x5 , 0x40, 0x0 , 0x0 , 0x5 , 0x40, 0x0 , 0x0 , 0x5 ,
		0x40, 0x0 , 0x0 , 0x9 , 0x48, 0x0 , 0x0 , 0x9 , 0x48, 0x0 ,
		0x0 , 0x4A, 0xA8, 0x0 , 0x1 , 0x59, 0x48, 0x0 , 0x0 , 0x4A,
		0xA8, 0x0 , 0x0 , 0x9 , 0x48, 0x0 , 0x0 , 0x5 , 0x48, 0x0 ,
		0x0 , 0x5 , 0x40, 0x0 ,
	},
	{
		0x0 , 0x5 , 0x40, 0x0 , 0x0 , 0x19, 0x50, 0x0 , 0x0 , 0x19,
		0x40, 0x0 , 0x1 , 0x59, 0x0 , 0x0 , 0x0 , 0x56, 0x40, 0x0 ,
		0x0 , 0x15, 0x0 , 0x0 , 0x0 , 0x15, 0x0 , 0x0 , 0x0 , 0x5 ,
		0x48, 0x0 , 0x0 , 0x5 , 0x48, 0x0 , 0x0 , 0xA , 0x5A, 0x0 ,
		0x0 , 0x2 , 0xA2, 0x0 , 0x0 , 0x12, 0x5A, 0x80, 0x0 , 0x14,
		0xA4, 0x80, 0x0 , 0x4 , 0x94, 0x80, 0x0 , 0x0 , 0x15, 0x0 ,
		0x0 , 0x0 , 0x14, 0x0 ,
	},
	{
		0x0 , 0x50, 0x0 , 0x0 , 0x1 , 0x54, 0x0 , 0x0 , 0x2 , 0x50,
		0x0 , 0x0 , 0x1 , 0x94, 0x0 , 0x0 , 0x1 , 0x64, 0x0 , 0x0 ,
		0x5 , 0x54, 0x0 , 0x0 , 0x0 , 0x55, 0x8 , 0x0 , 0x0 , 0x15,
		0x42, 0x0 , 0x0 , 0x5 , 0x58, 0x80, 0x0 , 0x2 , 0x48, 0x80,
		0x0 , 0x0 , 0xA6, 0x28, 0x0 , 0x0 , 0x29, 0x40, 0x0 , 0x1 ,
		0x49, 0x50, 0x0 , 0x1 , 0x41, 0x40, 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x4 , 0x0 , 0x0 , 0x0 , 0x15, 0x40,
		0x0 , 0x0 , 0x15, 0x40, 0x0 , 0x0 , 0x25, 0x40, 0x0 , 0x0 ,
		0xA , 0x90, 0x20, 0x0 , 0x5 , 0x94, 0xA , 0x80, 0x5 , 0x55,
		0x48, 0x28, 0x10, 0x55, 0x59, 0x88, 0x0 , 0x6 , 0x99, 0x94,
		0x0 , 0x0 , 0x2A, 0x55, 0x0 , 0x0 , 0x6 , 0x94, 0x0 , 0x0 ,
		0x14, 0x4 , 0x0 , 0x0 , 0x10, 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	}
    },
    {
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,  0x0 ,  0x0 ,  0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x1 , 0x0 , 0x0 ,  0x0 ,  0x5 ,  0x40,
		0x4 , 0x0 , 0x1 , 0x0 , 0x5 , 0x55, 0xAA,  0xA5,  0x15,  0x55,
		0x59, 0x95, 0xAA, 0x95, 0x59, 0x95, 0x55,  0x40,  0x8 ,  0x80,
		0x55, 0x0 , 0xAA, 0xA8, 0x54, 0x0 , 0x0 ,  0x0 ,  0x0 ,  0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,  0x0 ,  0x0 ,  0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,  0x0 ,  0x0 ,  0x0 ,
		0x10, 0x0 , 0x0 , 0x0 , 0x14, 0x4 , 0x0 ,  0x0 ,  0x6 ,  0x94,
		0x0 , 0x0 , 0x2A, 0x55, 0x0 , 0x6 , 0x99,  0x94,  0x10,  0x55,
		0x59, 0x88, 0x5 , 0x55, 0x48, 0x28, 0x5 ,  0x94,  0xA ,  0x80,
		0xA , 0x90, 0x20, 0x0 , 0x25, 0x40, 0x0 ,  0x0 ,  0x15,  0x40,
		0x0 , 0x0 , 0x15, 0x40, 0x0 , 0x0 , 0x4 ,  0x0 ,  0x0 ,  0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
                0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,  0x0 ,  0x0 ,  0x1 ,
		0x41, 0x40, 0x0 , 0x1 , 0x49, 0x50, 0x0 ,  0x0 ,  0x29,  0x40,
		0x0 , 0x0 , 0xA6, 0x28, 0x0 , 0x2 , 0x48,  0x80,  0x0 ,  0x5 ,
		0x58, 0x80, 0x0 , 0x15, 0x42, 0x0 , 0x0 ,  0x55,  0x8 ,  0x0 ,
		0x5 , 0x54, 0x0 , 0x0 , 0x1 , 0x64, 0x0 ,  0x0 ,  0x1 ,  0x94,
		0x0 , 0x0 , 0x2 , 0x50, 0x0 , 0x0 , 0x1 ,  0x54,  0x0 ,  0x0 ,
		0x0 , 0x50, 0x0 , 0x0 ,
	},
	{		
		0x0 , 0x0 , 0x14, 0x0 , 0x0 , 0x0 , 0x15,  0x0 ,  0x0 ,  0x4 ,
		0x94, 0x80, 0x0 , 0x14, 0xA4, 0x80, 0x0 ,  0x12,  0x5A,  0x80,
		0x0 , 0x2 , 0xA2, 0x0 , 0x0 , 0xA , 0x5A,  0x0 ,  0x0 ,  0x5 ,
		0x48, 0x0 , 0x0 , 0x5 , 0x48, 0x0 , 0x0 ,  0x15,  0x0 ,  0x0 ,
		0x0 , 0x15, 0x0 , 0x0 , 0x0 , 0x56, 0x40,  0x0 ,  0x1 ,  0x59,
		0x0 , 0x0 , 0x0 , 0x19, 0x40, 0x0 , 0x0 ,  0x19,  0x50,  0x0 ,
		0x0 , 0x5 , 0x40, 0x0 ,
	},
	{
		0x0 , 0x5 , 0x40, 0x0 , 0x0 , 0x5 , 0x48,  0x0 ,  0x0 ,  0x9 ,
		0x48, 0x0 , 0x0 , 0x4A, 0xA8, 0x0 , 0x1 ,  0x59,  0x48,  0x0 ,
		0x0 , 0x4A, 0xA8, 0x0 , 0x0 , 0x9 , 0x48,  0x0 ,  0x0 ,  0x9 ,
		0x48, 0x0 , 0x0 , 0x5 , 0x40, 0x0 , 0x0 ,  0x5 ,  0x40,  0x0 ,
		0x0 , 0x5 , 0x40, 0x0 , 0x0 , 0x5 , 0x90,  0x0 ,  0x0 ,  0x5 ,
		0x94, 0x0 , 0x0 , 0x15, 0x95, 0x0 , 0x0 ,  0x1 ,  0x95,  0x0 ,
		0x0 , 0x0 , 0x95, 0x0 ,
	},
	{
		0x0 , 0x10, 0x0 , 0x0 , 0x1 , 0x56, 0x80,  0x0 ,  0x0 ,  0x54,
		0x80, 0x0 , 0x0 , 0x9A, 0x20, 0x0 , 0x0 ,  0xA5,  0x20,  0x0 ,
		0x1 , 0x6A, 0xA0, 0x0 , 0x5 , 0x25, 0x8 ,  0x0 ,  0x0 ,  0x9 ,
		0x40, 0x0 , 0x0 , 0x9 , 0x40, 0x0 , 0x0 ,  0x5 ,  0x50,  0x0 ,
		0x0 , 0x1 , 0x54, 0x0 , 0x0 , 0x1 , 0x69,  0x50,  0x0 ,  0x0 ,
		0x59, 0x50, 0x0 , 0x0 , 0x59, 0x54, 0x0 ,  0x1 ,  0x2 ,  0x50,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x20, 0x0 ,  0x0 ,  0x1 ,  0x20,
		0x0 , 0x0 , 0x5 , 0x4A, 0x0 , 0x0 , 0x5 ,  0x60,  0x80,  0x0 ,
		0x2 , 0x9A, 0x20, 0x0 , 0x0 , 0xA1, 0x0 ,  0x0 ,  0x5 ,  0x25,
		0x40, 0x0 , 0x5 , 0x9 , 0x50, 0x0 , 0x0 ,  0x1 ,  0x55,  0x44,
		0x0 , 0x0 , 0x56, 0x55, 0x0 , 0x0 , 0x15,  0x95,  0x0 ,  0x0 ,
		0x5 , 0x64, 0x0 , 0x0 , 0x4 , 0x0 , 0x0 ,  0x0 ,  0x0 ,  0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{		
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,  0x0 ,  0x0 ,  0x0 ,
		0x0 , 0x0 , 0xA , 0x80, 0x0 , 0x0 , 0x10,  0xA8,  0x0 ,  0x0 ,
		0x55, 0x8A, 0x80, 0x0 , 0x56, 0x64, 0x0 ,  0x4 ,  0xA ,  0x65,
		0x41, 0x15, 0x0 , 0xA9, 0x56, 0x55, 0x5 ,  0x9 ,  0x55,  0xA9,
		0x1 , 0x40, 0x15, 0x54, 0x0 , 0x0 , 0x1 ,  0x40,  0x0 ,  0x0 ,
		0x0 , 0x40, 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,  0x0 ,  0x0 ,  0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,  0x0 ,  0x0 ,  0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,  0x0 ,  0x0 ,  0x15,
		0x2A, 0xAA, 0x0 , 0x55, 0x2 , 0x20, 0x1 ,  0x55,  0x56,  0x65,
		0x56, 0xAA, 0x56, 0x65, 0x55, 0x54, 0x5A,  0xAA,  0x55,  0x50,
		0x0 , 0x40, 0x0 , 0x10, 0x1 , 0x50, 0x0 ,  0x0 ,  0x0 ,  0x40,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,  0x0 ,  0x0 ,  0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,  0x10,  0x0 ,  0x0 ,
		0x1 , 0x54, 0x0 , 0x0 , 0x1 , 0x54, 0x0 ,  0x0 ,  0x1 ,  0x58,
		0x0 , 0x8 , 0x6 , 0xA0, 0x2 , 0xA0, 0x16,  0x50,  0x28,  0x21,
		0x55, 0x50, 0x22, 0x65, 0x55, 0x4 , 0x16,  0x66,  0x90,  0x0 ,
		0x55, 0xA8, 0x0 , 0x0 , 0x16, 0x90, 0x0 ,  0x0 ,  0x10,  0x14,
		0x0 , 0x0 , 0x0 , 0x4 , 0x0 , 0x0 , 0x0 ,  0x0 ,  0x0 ,  0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x5 , 0x0 , 0x0 , 0x0 , 0x15,  0x40,  0x0 ,  0x0 ,
		0x5 , 0x80, 0x0 , 0x0 , 0x16, 0x40, 0x0 ,  0x0 ,  0x19,  0x40,
		0x0 , 0x0 , 0x15, 0x50, 0x0 , 0x20, 0x55,  0x0 ,  0x0 ,  0x81,
		0x54, 0x0 , 0x2 , 0x25, 0x50, 0x0 , 0x2 ,  0x21,  0x80,  0x0 ,
		0x28, 0x9A, 0x0 , 0x0 , 0x1 , 0x68, 0x0 ,  0x0 ,  0x5 ,  0x61,
		0x40, 0x0 , 0x1 , 0x41, 0x40, 0x0 , 0x0 ,  0x0 ,  0x0 ,  0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x1 , 0x50, 0x0 , 0x0 , 0x5 , 0x64,  0x0 ,  0x0 ,  0x1 ,
		0x64, 0x0 , 0x0 , 0x0 , 0x65, 0x40, 0x0 ,  0x1 ,  0x95,  0x0 ,
		0x0 , 0x0 , 0x54, 0x0 , 0x0 , 0x0 , 0x54,  0x0 ,  0x0 ,  0x21,
		0x50, 0x0 , 0x0 , 0x21, 0x50, 0x0 , 0x0 ,  0xA5,  0xA0,  0x0 ,
		0x0 , 0x8A, 0x80, 0x0 , 0x2 , 0xA5, 0x84,  0x0 ,  0x2 ,  0x1A,
		0x14, 0x0 , 0x2 , 0x16, 0x10, 0x0 , 0x0 ,  0x54,  0x0 ,  0x0 ,
		0x0 , 0x14, 0x0 , 0x0 ,
	},
	{
		0x0 , 0x56, 0x0 , 0x0 , 0x0 , 0x56, 0x40,  0x0 ,  0x0 ,  0x56,
		0x54, 0x0 , 0x0 , 0x16, 0x50, 0x0 , 0x0 ,  0x6 ,  0x50,  0x0 ,
		0x0 , 0x1 , 0x50, 0x0 , 0x0 , 0x1 , 0x50,  0x0 ,  0x0 ,  0x1 ,
		0x50, 0x0 , 0x0 , 0x21, 0x60, 0x0 , 0x0 ,  0x21,  0x60,  0x0 ,
		0x0 , 0x2A, 0xA1, 0x0 , 0x0 , 0x21, 0x65,  0x40,  0x0 ,  0x2A,
		0xA1, 0x0 , 0x0 , 0x21, 0x60, 0x0 , 0x0 ,  0x21,  0x50,  0x0 ,
		0x0 , 0x1 , 0x50, 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x5 , 0x80, 0x40,  0x0 ,  0x15,  0x65,
		0x0 , 0x0 , 0x5 , 0x65, 0x0 , 0x0 , 0x5 ,  0x69,  0x40,  0x0 ,
		0x0 , 0x15, 0x40, 0x0 , 0x0 , 0x5 , 0x50,  0x0 ,  0x0 ,  0x1 ,
		0x60, 0x0 , 0x0 , 0x1 , 0x60, 0x0 , 0x0 ,  0x20,  0x58,  0x50,
		0x0 , 0xA , 0xA9, 0x40, 0x0 , 0x8 , 0x5A,  0x0 ,  0x0 ,  0x8 ,
		0xA6, 0x0 , 0x0 , 0x2 , 0x15, 0x0 , 0x0 ,  0x2 ,  0x95,  0x40,
		0x0 , 0x0 , 0x4 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,  0x0 ,  0x0 ,  0x10,
		0x0 , 0x0 , 0x19, 0x50, 0x0 , 0x0 , 0x56,  0x54,  0x0 ,  0x0 ,
		0x55, 0x95, 0x0 , 0x0 , 0x11, 0x55, 0x40,  0x0 ,  0x0 ,  0x5 ,
		0x60, 0x50, 0x0 , 0x1 , 0x58, 0x50, 0x0 ,  0x0 ,  0x4A,  0x0 ,
		0x0 , 0x8 , 0xA6, 0x80, 0x0 , 0x2 , 0x9 ,  0x50,  0x0 ,  0x0 ,
		0xA1, 0x50, 0x0 , 0x0 , 0x8 , 0x40, 0x0 ,  0x0 ,  0x8 ,  0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,  0x0 ,  0x0 ,  0x0 ,
		0x0 , 0x0 , 0x1 , 0x0 , 0x0 , 0x0 , 0x1 ,  0x40,  0x0 ,  0x0 ,
		0x15, 0x54, 0x1 , 0x40, 0x6A, 0x55, 0x60,  0x50,  0x55,  0x95,
		0x6A, 0x0 , 0x54, 0x41, 0x59, 0xA0, 0x10,  0x0 ,  0x19,  0x95,
		0x0 , 0x2 , 0xA2, 0x55, 0x0 , 0x0 , 0x2A,  0x4 ,  0x0 ,  0x0 ,
		0x2 , 0xA0, 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,  0x0 ,  0x0 ,  0x0 ,
		0x0 , 0x0 , 0x0 , 0x0
	}
    }
};

static unsigned char swhitsym[HITSYMS][SYMBYTES] = {  /*  Hit plane pixel array  */

/*  airplane symbols based on the following template file:
16
. . . . . . 2 2 2 2 2 2 2 2 2 2
. . . . . . . 2 2 2 1 1 2 2 2 .
. . . . . . . . 2 2 1 1 2 2 . .
. . . . . . . . . . 1 1 . . . .
. . . . . . . . . . 1 1 . . . .
. . . . . . . . . . 1 1 . . . .
. . . . . . . . . 1 1 1 1 . . .
. . . . . . . . . 1 1 1 1 . . .
. . . . . . . . . 1 1 1 1 . . .
. . . . . . . . . 1 1 1 1 . . .
. . 2 2 2 2 2 2 2 2 1 1 2 2 2 2
2 2 2 2 2 2 2 2 2 2 1 1 2 2 2 .
2 2 2 2 2 2 2 2 2 2 1 1 2 2 2 2
2 2 2 2 2 2 2 2 2 2 1 1 2 2 . 2
. . . . . . . . . 1 1 1 1 . . .
. . . . . . . . . 1 1 1 1 . . .
*/
	{
		0x0 , 0xA , 0xAA, 0xAA, 0x0 , 0x2 , 0xA5, 0xA8, 0x0 , 0x0 ,
		0xA5, 0xA0, 0x0 , 0x0 , 0x5 , 0x0 , 0x0 , 0x0 , 0x5 , 0x0 ,
		0x0 , 0x0 , 0x5 , 0x0 , 0x0 , 0x0 , 0x15, 0x40, 0x0 , 0x0 ,
		0x15, 0x40, 0x0 , 0x0 , 0x15, 0x40, 0x0 , 0x0 , 0x15, 0x40,
		0xA , 0xAA, 0xA5, 0xAA, 0xAA, 0xAA, 0xA5, 0xA8, 0xAA, 0xAA,
		0xA5, 0xAA, 0xAA, 0xAA, 0xA5, 0xA2, 0x0 , 0x0 , 0x15, 0x40,
		0x0 , 0x0 , 0x15, 0x40,
	},
	{
		0x0 , 0x0 , 0x95, 0x0 , 0x0 , 0x1 , 0x95, 0x0 , 0x0 , 0x15,
		0x95, 0x0 , 0x0 , 0x5 , 0x94, 0x0 , 0x0 , 0x5 , 0x90, 0x0 ,
		0x0 , 0x5 , 0x40, 0x0 , 0x0 , 0x5 , 0x40, 0x0 , 0x0 , 0x5 ,
		0x40, 0x0 , 0x0 , 0x9 , 0x48, 0x0 , 0x0 , 0x9 , 0x48, 0x0 ,
		0x0 , 0x4A, 0xA8, 0x0 , 0x1 , 0x59, 0x48, 0x0 , 0x0 , 0x4A,
		0xA8, 0x0 , 0x0 , 0x9 , 0x48, 0x0 , 0x0 , 0x5 , 0x48, 0x0 ,
		0x0 , 0x5 , 0x40, 0x0
	}
};


static unsigned char swwinsym[WINSIZES][WINBYTES] = {  /*  Win plane pixel array  */

/*  airplane symbols based on the following template files:
16                                 16
. . . . . . . . . . . . . . . .    . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .    . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .    . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .    . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .    . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .    . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .    . . . . . . . 1 1 . . . . . . .
. . . . . . . 1 1 . . . . . . .    . . . . . . 2 2 2 2 . . . . . .
. . . . . . . 1 1 . . . . . . .    . . . . . . 2 2 2 2 . . . . . .
. . . . . . . . . . . . . . . .    . . . . . . . 1 1 . . . . . . .
. . . . . . . . . . . . . . . .    . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .    . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .    . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .    . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .    . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .    . . . . . . . . . . . . . . . .

16                                 16
. . . . . . . . . . . . . . . .    . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .    . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .    . . . . . . . 1 1 . . . . . . .
. . . . . . . . . . . . . . . .    . . . . . . . 1 1 . . . . . . .
. . . . . . . . . . . . . . . .    . . . . . . . 1 1 . . . . . . .
. . . . . . . . . . . . . . . .    2 2 2 2 2 2 2 1 1 2 2 2 2 2 2 2
. . . . . . . 1 1 . . . . . . .    . . . . . . . 1 1 . . . . . . .
. . . . 2 2 2 1 1 2 2 2 . . . .    . . . . 2 2 2 2 2 2 2 2 . . . .
. . . . . . . 1 1 . . . . . . .    . . . . . . 1 1 1 1 . . . . . .
. . . . . 2 2 2 2 2 2 . . . . .    . . . . . . 1 1 1 1 . . . . . .
. . . . . . 1 . . 1 . . . . . .    . 2 2 2 2 2 2 2 2 2 2 2 2 2 2 .
. . . . . . . . . . . . . . . .    . . . . . 1 . . . . 1   . . . .
. . . . . . . . . . . . . . . .    . . . . 1 . . . . . . 1 . . . .
. . . . . . . . . . . . . . . .    . . . . 1 . . . . . . 1 . . . .
. . . . . . . . . . . . . . . .    . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .    . . . . . . . . . . . . . . . .
*/
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x1 ,
		0x40, 0x0 , 0x0 , 0x1 , 0x40, 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x1 , 0x40, 0x0 , 0x0 , 0xA ,
		0xA0, 0x0 , 0x0 , 0xA , 0xA0, 0x0 , 0x0 , 0x1 , 0x40, 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x1 , 0x40, 0x0 , 0x0 , 0xA9,
		0x6A, 0x0 , 0x0 , 0x1 , 0x40, 0x0 , 0x0 , 0x2A, 0xA8, 0x0 ,
		0x0 , 0x4 , 0x10, 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x1 ,
		0x40, 0x0 , 0x0 , 0x1 , 0x40, 0x0 , 0x0 , 0x1 , 0x40, 0x0 ,
		0xAA, 0xA9, 0x6A, 0xAA, 0x0 , 0x1 , 0x40, 0x0 , 0x0 , 0xAA,
		0xAA, 0x0 , 0x0 , 0x5 , 0x50, 0x0 , 0x0 , 0x5 , 0x50, 0x0 ,
		0x2A, 0xAA, 0xAA, 0xA8, 0x0 , 0x10, 0x4 , 0x0 , 0x0 , 0x40,
		0x1 , 0x0 , 0x0 , 0x40, 0x1 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0
	}
};


static unsigned char swbmbsym[BOMBANGS][BOMBBYTES] = {

/*  bomb symbols based on the following template file:
08
. . . . . . . .
. . . . . . . .
1 1 . 1 1 1 1 .
1 1 1 1 1 1 1 1
1 1 1 1 1 1 1 1
1 1 . 1 1 1 1 .
. .  .. . . . .
. . . . . . . .
*/
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x51, 0x54, 0x55, 0x55, 0x55, 0x55,
		0x51, 0x54, 0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x54, 0x1 , 0x55, 0x5 , 0x55, 0x11, 0x54,
		0x55, 0x10, 0x15, 0x40, 0x1 , 0x0 ,
	},
	{
		0x1 , 0x40, 0x5 , 0x50, 0x5 , 0x50, 0x5 , 0x50, 0x5 , 0x50,
		0x1 , 0x40, 0x5 , 0x50, 0x5 , 0x50,
	},
	{
		0x0 , 0x0 , 0x15, 0x0 , 0x55, 0x40, 0x55, 0x50, 0x15, 0x44,
		0x4 , 0x55, 0x1 , 0x54, 0x0 , 0x40,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x15, 0x45, 0x55, 0x55, 0x55, 0x55,
		0x15, 0x45, 0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x40, 0x1 , 0x54, 0x4 , 0x55, 0x15, 0x44, 0x55, 0x50,
		0x55, 0x40, 0x15, 0x0 , 0x0 , 0x0 ,
	},
	{
		0x5 , 0x50, 0x5 , 0x50, 0x1 , 0x40, 0x5 , 0x50, 0x5 , 0x50,
		0x5 , 0x50, 0x5 , 0x50, 0x1 , 0x40,
	},
	{
		0x1 , 0x0 , 0x15, 0x40, 0x55, 0x10, 0x11, 0x54, 0x5 , 0x55,
		0x1 , 0x55, 0x0 , 0x54, 0x0 , 0x0
	}
};

static unsigned char swtrgsym[TARGORIENTS][TARGBYTES] = {

/*  target symbols based on the following template files:
16                                    16
. . . . . . . . . . . 2 . . . .       . . . . . . . . . . 2 2 . . 2 2
. . . . . . . . . . . 2 1 1 1 1       . . . . . . . . . . 2 2 . . 2 2
. . . . . . . . . . . 2 1 1 1 1       . . . . . . . . . . 2 2 . . 2 2
. . . . . . . . . . . 2 . . . .       1 1 1 1 1 1 1 1 1 1 2 2 . . 2 2
. . . . . . . . . . . 2 . . . .       1 1 1 1 1 1 1 1 1 1 2 2 . . 2 2
. . . . . . . . . . . 2 . . . .       1 1 1 2 1 2 1 2 1 1 2 2 . . 2 2
. . . . . . . . . . . 2 . . . .       1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2
1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1       1 1 1 2 1 2 1 2 1 1 1 1 1 1 2 2
1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1       1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2
1 1 2 2 2 2 2 2 2 2 2 2 2 2 1 1       1 1 1 2 1 2 1 2 1 2 1 2 1 1 2 2
1 1 2 1 1 1 1 1 1 1 1 1 1 2 1 1       1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2
1 1 2 1 1 1 1 1 1 1 1 1 1 2 1 1       1 1 1 2 1 2 1 2 1 2 1 2 1 1 2 2
1 1 2 1 1 1 1 1 1 1 1 1 1 2 1 1       1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2
1 1 2 1 1 1 1 1 1 1 1 1 1 2 1 1       1 1 1 2 1 2 1 2 1 2 1 2 1 1 2 2
1 1 2 1 1 1 1 1 1 1 1 1 1 2 1 1       1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2
1 1 2 1 1 1 1 1 1 1 1 1 1 2 1 1       1 1 1 1 1 1 1 1 1 1 1 1 1 1 2 2


16                                    16
. . . . . . . . . . . . . . . .       . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .       . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .       . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .       . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .       . . . . . . . . . . . . . . . .
. . . 1 1 1 1 1 1 1 1 1 1 . . .       . . . . . . . . . . . . . . . .
. 1 1 1 1 1 1 1 1 1 1 1 1 1 1 .       . . . . . . . . . . . . . . . .
1 1 1 1 1 1 2 1 2 1 1 1 1 1 1 1       . . . . . 1 1 1 1 1 1 . . . . .
1 1 1 1 1 1 2 2 2 1 1 1 1 1 1 1       . . . . . 1 1 1 1 1 1 1 1 1 1 1
1 1 1 1 1 1 2 1 2 1 1 1 1 1 1 1       . . . . . 1 1 1 1 1 1 . . . . .
1 1 1 1 1 1 2 2 2 1 1 1 1 1 1 1       1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1
. 1 1 1 1 1 2 1 2 1 1 1 1 1 1 .       1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1
. . 1 1 1 1 2 2 2 1 1 1 1 1 . .       1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1
. . 2 2 . . 2 . 2 . . . 2 2 . .       2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2
. . 2 2 . . 2 2 2 . . . 2 2 . .       2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 2
. . 2 2 . . 2 . 2 . . . 2 2 . .       . 2 2 2 2 2 2 2 2 2 2 2 2 2 2 .
*/
	{
		0x0 , 0x0 , 0x2 , 0x0 , 0x0 , 0x0 , 0x2 , 0x55, 0x0 , 0x0 ,
		0x2 , 0x55, 0x0 , 0x0 , 0x2 , 0x0 , 0x0 , 0x0 , 0x2 , 0x0 ,
		0x0 , 0x0 , 0x2 , 0x0 , 0x0 , 0x0 , 0x2 , 0x0 , 0x55, 0x55,
		0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x5A, 0xAA, 0xAA, 0xA5,
		0x59, 0x55, 0x55, 0x65, 0x59, 0x55, 0x55, 0x65, 0x59, 0x55,
		0x55, 0x65, 0x59, 0x55, 0x55, 0x65, 0x59, 0x55, 0x55, 0x65,
		0x59, 0x55, 0x55, 0x65,
	},
	{
		0x0 , 0x0 , 0xA , 0xA , 0x0 , 0x0 , 0xA , 0xA , 0x0 , 0x0 ,
		0xA , 0xA , 0x55, 0x55, 0x5A, 0xA , 0x55, 0x55, 0x5A, 0xA ,
		0x56, 0x66, 0x5A, 0xA , 0x55, 0x55, 0x55, 0x5A, 0x56, 0x66,
		0x55, 0x5A, 0x55, 0x55, 0x55, 0x5A, 0x56, 0x66, 0x66, 0x5A,
		0x55, 0x55, 0x55, 0x5A, 0x56, 0x66, 0x66, 0x5A, 0x55, 0x55,
		0x55, 0x5A, 0x56, 0x66, 0x66, 0x5A, 0x55, 0x55, 0x55, 0x5A,
		0x55, 0x55, 0x55, 0x5A,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x1 , 0x55, 0x55, 0x40, 0x15, 0x55, 0x55, 0x54, 0x55, 0x59,
		0x95, 0x55, 0x55, 0x5A, 0x95, 0x55, 0x55, 0x59, 0x95, 0x55,
		0x55, 0x5A, 0x95, 0x55, 0x15, 0x59, 0x95, 0x54, 0x5 , 0x5A,
		0x95, 0x50, 0xA , 0x8 , 0x80, 0xA0, 0xA , 0xA , 0x80, 0xA0,
		0xA , 0x8 , 0x80, 0xA0,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x15,
		0x54, 0x0 , 0x0 , 0x15, 0x55, 0x55, 0x0 , 0x15, 0x54, 0x0 ,
		0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x6A, 0xAA,
		0xAA, 0xA9, 0x95, 0x55, 0x55, 0x56, 0x95, 0x55, 0x55, 0x56,
		0x2A, 0xAA, 0xAA, 0xA8
	},
};

static unsigned char swhtrsym[TARGBYTES] = {

/*  hit target symbols based on the following template file:
16
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . 1 .
1 . . . . . . . . . . . . . 1 1
1 1 . . . 1 . . . . . 2 . 1 1 1
1 1 . 1 1 1 . . 1 1 . 2 1 1 1 1
1 1 1 1 2 2 1 1 1 1 2 1 1 1 1 1
1 1 1 1 2 2 1 1 1 2 1 1 1 1 1 1
*/
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x0 , 0x4 , 0x40, 0x0 , 0x0 , 0x5 , 0x50, 0x10,
       0x2 , 0x15, 0x51, 0x50, 0x52, 0x55, 0x55, 0xA5, 0x59, 0x55,
       0x55, 0xA5, 0x65, 0x55
};

static unsigned char swexpsym[EXPLSYMS][EXPBYTES] = {

/*  explosion symbols based on the following template files:
08                 08                08                08
1 1 1 . 2 . . .    . . . 1 1 . . .   . . . . . 2 . .   . . . 1 1 . . .
1 1 1 . 2 . . .    . 1 1 1 1 1 1 .   . . . . 2 2 2 .   . . . 1 1 1 . .
1 1 1 2 . . . .    1 1 1 2 2 1 1 1   . . . 2 2 2 2 2   . 1 1 1 1 1 1 .
. . 2 2 2 1 1 1    1 1 2 2 2 2 1 1   . . 2 2 2 2 2 .   1 1 1 1 1 1 1 1
2 2 . 2 1 1 1 1    1 1 2 2 2 2 1 1   . 2 2 2 2 2 . .   1 1 1 1 1 1 1 1
. . . 1 1 . . .    1 1 1 2 2 1 1 1   2 2 2 2 2 . . .   . 1 1 1 1 . 1 .
. . . 1 1 . . .    . 1 1 1 1 1 1 .   . 2 2 2 . . . .   . . 1 1 1 . . .
. . . 1 1 . . .    . . . 1 1 . . .   . . 2 . . . . .   . . . 1 1 . . .

08                 08                08                08
. 1 2 2 2 . . .    1 1 . . . . . .   . . . . . . . .   . . . . . . . .
. 1 1 1 1 1 . .    1 1 . . 1 2 . .   . . . . . . 1 1   . 1 . . . 1 . .
. . 2 2 1 2 1 .    . . . . 2 1 . .   . . . . . . 1 1   . . . 1 . . . .
2 1 1 2 2 2 1 .    . . . . . . . .   . . . 1 1 . . .   . . . . . . 1 .
. . . . . . 1 1    . . . . . 2 2 .   1 2 . 1 1 . . .   1 . 1 . . . . .
. 1 2 . . . 1 2    . 2 2 . . 2 2 .   2 1 . . . . . .   . . . . 1 . . 1
. . 1 1 . . 2 1    . 2 2 . . . . .   . . . . . 2 2 .   . . 1 . . . . .
. . 1 2 . . . 1    . . . . . . . .   . . . . . 2 2 .   . . . . . . 1 .
*/

	{
		0x54, 0x80, 0x54, 0x80, 0x56, 0x0 , 0xA , 0x95, 0xA2, 0x55,
		0x1 , 0x40, 0x1 , 0x40, 0x1 , 0x40,
	},
	{
		0x1 , 0x40, 0x15, 0x54, 0x56, 0x95, 0x5A, 0xA5, 0x5A, 0xA5,
		0x56, 0x95, 0x15, 0x54, 0x1 , 0x40,
	},
	{
		0x0 , 0x20, 0x0 , 0xA8, 0x2 , 0xAA, 0xA , 0xA8, 0x2A, 0xA0,
		0xAA, 0x80, 0x2A, 0x0 , 0x8 , 0x0 ,
	},
	{
		0x1 , 0x40, 0x1 , 0x50, 0x15, 0x54, 0x55, 0x55, 0x55, 0x55,
		0x15, 0x44, 0x5 , 0x40, 0x1 , 0x40,
	},
	{
		0x1A, 0x80, 0x15, 0x50, 0xA , 0x64, 0x96, 0xA4, 0x0 , 0x5 ,
		0x18, 0x6 , 0x5 , 0x9 , 0x6 , 0x1 ,
	},
	{
		0x50, 0x0 , 0x50, 0x60, 0x0 , 0x90, 0x0 , 0x0 , 0x0 , 0x28,
		0x28, 0x28, 0x28, 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x5 , 0x0 , 0x5 , 0x1 , 0x40, 0x61, 0x40,
		0x90, 0x0 , 0x0 , 0x28, 0x0 , 0x28,
	},
	{
		0x0 , 0x0 , 0x10, 0x10, 0x1 , 0x0 , 0x0 , 0x4 , 0x44, 0x0 ,
		0x0 , 0x41, 0x4 , 0x0 , 0x0 , 0x4
	}
};

static unsigned char swflksym[FLCKSYMS][FLKBYTES] = {

/*  flock symbols based on the following template files:
16                                16
. 3 . . . . . . . . . . . . . .   3 . 3 . . . . . . . . . . . . .
3 . 3 . . . . . . . . . . . . .   . 3 . . . . . . . . . . . . . .
. . . . . . . 3 . 3 . . . . 3 .   . . . . . . . . 3 . . . . 3 . 3
. . . 3 . . . . 3 . . . . 3 . 3   . . 3 . 3 . . 3 . 3 . . . . 3 .
. . 3 . 3 . . . . . . . . . . .   . . . 3 . . . . . . . . . . . .
. . . . . . . . . . . . . . . .   . . . . . . . . . . . . . . . .
3 . 3 . . 3 . 3 . . . . 3 . . .   . 3 . . . . 3 . . . . 3 . 3 . .
. 3 . . . . 3 . . . . 3 . 3 . .   3 . 3 . . 3 . 3 . . . . 3 . . .
. . . . . . . . . . . . . . . .   . . . . . . . . . . . . . . . .
. . 3 . 3 . . 3 . . . . 3 . 3 .   . . . 3 . . 3 . 3 . . . . 3 . .
. . . 3 . . 3 . 3 . . . . 3 . .   . . 3 . 3 . . 3 . . . . 3 . 3 .
. . . . . . . . . . . . . . . .   . . . . . . . . . . . . . . . .
. . . 3 . . . . . . 3 . . . . .   . . 3 . 3 . . . . 3 . 3 . . . .
. . 3 . 3 . . . . 3 . 3 . . . .   . . . 3 . . . . . . 3 . . . . .
. . . . . . 3 . 3 . . . . . . .   . . . . . . . 3 . . . . . . . .
. . . . . . . 3 . . . . . . . .   . . . . . . 3 . 3 . . . . . . .
*/
	{
		0x30, 0x0 , 0x0 , 0x0 , 0xCC, 0x0 , 0x0 , 0x0 , 0x0 , 0x3 ,
		0x30, 0xC , 0x3 , 0x0 , 0xC0, 0x33, 0xC , 0xC0, 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0xCC, 0x33, 0x0 , 0xC0, 0x30, 0xC ,
		0x3 , 0x30, 0x0 , 0x0 , 0x0 , 0x0 , 0xC , 0xC3, 0x0 , 0xCC,
		0x3 , 0xC , 0xC0, 0x30, 0x0 , 0x0 , 0x0 , 0x0 , 0x3 , 0x0 ,
		0xC , 0x0 , 0xC , 0xC0, 0x33, 0x0 , 0x0 , 0xC , 0xC0, 0x0 ,
		0x0 , 0x3 , 0x0 , 0x0 ,
	},
	{
		0xCC, 0x0 , 0x0 , 0x0 , 0x30, 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0xC0, 0x33, 0xC , 0xC3, 0x30, 0xC , 0x3 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x30, 0xC , 0x3 , 0x30, 0xCC, 0x33,
		0x0 , 0xC0, 0x0 , 0x0 , 0x0 , 0x0 , 0x3 , 0xC , 0xC0, 0x30,
		0xC , 0xC3, 0x0 , 0xCC, 0x0 , 0x0 , 0x0 , 0x0 , 0xC , 0xC0,
		0x33, 0x0 , 0x3 , 0x0 , 0xC , 0x0 , 0x0 , 0x3 , 0x0 , 0x0 ,
		0x0 , 0xC , 0xC0, 0x0
	},
};

static unsigned char swbrdsym[BIRDSYMS][BRDBYTES] = {

/*  bird symbols based on the following template files:
4         4
. 3 . .   3 . 3 .
3 . 3 .   . 3 . .
*/
       {0x30, 0xCC},
       {0xCC, 0x30}
};

static unsigned char swoxsym[OXSYMS][OXBYTES] = {

/*  ox symbols based on the following template files:
16                                16
. . . . . . . . . . . . . . . .   . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .   . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .   . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .   . . . . . . . . . . . . . . . .
. . . . . . . . . . . . . . . .   . . . . . . . . . . . . . . . .
. . . . . . . . . . 3 . . 3 . .   . . . . . . . . . . . . . . . .
. . . . . . . . . . 3 2 2 2 . .   . . . . . . . . . . . . . . . .
. . . . . . . . . . 2 3 1 3 3 .   . . . . . . . . . . . . . . . .
. . . 2 2 2 2 2 2 3 2 2 3 3 3 .   . . . . . . . . . . . . . . . .
. 2 2 2 2 2 2 2 2 3 2 2 3 3 2 3   . . . . . . . . . . . . . . . .
3 2 2 2 2 2 2 2 2 3 2 2 2 3 3 .   . . . . . . . . . . . . . . . .
3 2 2 2 2 2 2 2 2 2 3 3 . . . .   . . . . . . . . . . . . 3 . . .
3 2 2 2 2 2 2 2 2 2 2 2 . . . .   . . 2 2 2 2 2 2 2 2 . 2 2 2 . .
3 2 2 . 2 2 . . 2 2 . 2 2 . . .   3 2 3 3 2 2 2 2 3 3 2 2 2 3 3 .
. 2 2 . 2 2 . . 2 2   2 2 . . .   3 2 2 2 2 2 2 2 2 2 2 2 2 3 3 .
. 3 3 . 3 3 . . 3 3 . 3 3 . . .   3 2 2 3 3 2 2 3 3 2 . 2 2 3 . .
*/
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0xC , 0x30, 0x0 , 0x0 , 0xE , 0xA0, 0x0 , 0x0 ,
		0xB , 0x7C, 0x2 , 0xAA, 0xBA, 0xFC, 0x2A, 0xAA, 0xBA, 0xFB,
		0xEA, 0xAA, 0xBA, 0xBC, 0xEA, 0xAA, 0xAF, 0x0 , 0xEA, 0xAA,
		0xAA, 0x0 , 0xE8, 0xA0, 0xA2, 0x80, 0x28, 0xA0, 0xA2, 0x80,
		0x3C, 0xF0, 0xF3, 0xC0,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0xC0, 0xA , 0xAA,
		0xA2, 0xA0, 0xEF, 0xAA, 0xFA, 0xBC, 0xEA, 0xAA, 0xAA, 0xBC,
		0xEB, 0xEB, 0xE2, 0xB0
	},
};

static unsigned char swghtsym[GHSTBYTES] = {

/*  ghost symbol based on the following template file:
08
0 0 1 1 1 1 0 0
0 1 1 1 1 1 1 0
1 1 2 1 1 2 1 1
1 2 2 2 2 2 2 1
1 1 2 1 1 2 1 1
1 1 1 1 1 1 1 1
1 2 2 2 2 2 2 1
1 1 1 1 1 1 1 1
*/
       0x5 , 0x50, 0x15, 0x54, 0x59, 0x65, 0x6A, 0xA9, 0x59, 0x65,
       0x55, 0x55, 0x6A, 0xA9, 0x55, 0x55
};

static unsigned char swshtsym[SHOTBYTES] = {

/*  shot window symbol based on the following template file:
16
. . . . . . . . . . . . . . 1 .
. . . 1 . . . . . . . . 1 1 . .
. . . 1 . . . . . 1 1 1 . . . .
. . . . 1 . . . 1 . . . . . . .
. . . . 1 . . 1 . . 1 1 . . . .
. . . . . 1 1 1 . 1 . . 1 . . .
1 1 1 1 . 1 1 2 1 . . . . 1 1 .
. . . . 1 1 1 2 2 1 . . . . . 1
. . . . 1 1 1 2 1 1 . . . . . .
. . . . . 1 2 2 1 . 1 1 . . . .
. . . . 1 . 1 1 . . . . 1 . . .
. . . 1 . . . 1 . . . . 1 . . .
. . 1 . . . . 1 . . . . 1 . . .
. . 1 . . 1 1 1 . . . 1 . . . .
. . 1 . 1 . . . . . . . 1 . . .
. . . . . 1 1 . . . . . . 1 . .
*/
       0x0 , 0x0 , 0x0 , 0x4 , 0x1 , 0x0 , 0x0 , 0x50, 0x1 , 0x0 ,
       0x15, 0x0 , 0x0 , 0x40, 0x40, 0x0 , 0x0 , 0x41, 0x5 , 0x0 ,
       0x0 , 0x15, 0x10, 0x40, 0x55, 0x16, 0x40, 0x14, 0x0 , 0x56,
       0x90, 0x1 , 0x0 , 0x56, 0x50, 0x0 , 0x0 , 0x1A, 0x45, 0x0 ,
       0x0 , 0x45, 0x0 , 0x40, 0x1 , 0x1 , 0x0 , 0x40, 0x4 , 0x1 ,
       0x0 , 0x40, 0x4 , 0x15, 0x1 , 0x0 , 0x4 , 0x40, 0x0 , 0x40,
       0x0 , 0x14, 0x0 , 0x10
};

static unsigned char swsplsym[SPLTBYTES] = {

/*  splatted bird symbol based on the following template file:
32
. . . . . . . . . . . . . . . . . 2 2 2 . . . . . . . . . . . .
. . . . . . . . . . . . . . . . . 2 1 1 2 2 . . . . . . . . . .
. . . 1 . . . . . . . . . . . . . . 2 1 1 1 2 . . . . . . 1 . .
. . 1 1 1 . . . . . . . . . . . . . . 2 1 1 1 2 . . . . . 1 . .
. . . 1 1 . . . . . 1 . . . . . . . . 2 1 1 1 1 2 . . . 1 1 . .
. . . 1 1 . . . . 1 1 1 . . . . . . . 2 1 1 1 1 1 2 . . . . . .
. . . . . . . . . . 1 . . . . 1 . . . 2 1 1 1 1 1 1 2 . . . . .
. . . . . . . . . . . . . . . . . . . 2 1 1 1 1 1 1 1 2 . . . .
. . . . 1 . . . . . . . . . . . . . 2 1 1 1 1 1 1 1 1 2 . . . .
. . . . . . . . . . . . . . . . . 2 1 1 1 1 1 1 1 1 1 2 . . . .
. . . . . . . . . . . . . 1 . . 2 1 1 1 1 1 1 1 1 1 1 2 . . . .
. . 1 . . . . . . . . . . . . 2 1 1 1 1 1 1 1 1 1 1 1 2 . . . .
. . . . . . . 2 2 2 2 2 2 . 2 1 1 1 1 1 1 1 1 1 1 1 2 . . . . .
. . . . . . 2 1 1 1 1 1 1 2 1 1 1 1 1 1 1 1 1 1 1 2 . . . . . .
. . . . . 2 1 2 1 1 1 2 1 1 2 1 1 1 1 1 1 1 1 1 2 . . . . 1 1 .
. . . . 2 1 2 . 2 1 2.. 2 1 1 2 1 1 1 1 1 1 1 2 . . . . . . . .
. . . . 2 1 2 . 2 1 2 . 2 1 1 2 2 2 1 1 2 2 2 . . . 1 . . . . .
. . . . 2 1 1 2 1 1 1 2 1 1 1 2 1 1 2 2 . . . . . . . . . . 1 .
. . . . 2 1 1 1 1 1 1 1 1 1 1 2 1 1 1 2 . . . . . . 1 . 1 . . .
. . . . 2 1 2 2 1 2 1 1 1 1 1 2 1 1 1 1 2 . . . . . . . . . . .
. . . . . 2 2 1 2 1 1 1 1 1 2 2 1 1 1 1 1 2 . . . . . . . 1 . .
. . . . 2 2 1 2 1 1 1 1 1 2 . 2 1 1 1 1 1 1 2 2 2 2 2 . . . . .
. . . 2 2 1 2 2 2 2 2 2 2 . . . 2 1 1 1 1 1 1 1 1 1 1 2 . . . .
. . 2 2 1 2 . . . . . . 2 2 . . . 2 1 1 1 1 1 1 1 1 1 1 2 . . .
. . 2 1 2 . . . . . . . 2 . 2 . . . 2 1 1 1 1 1 1 1 1 1 1 2 . .
. . . . . . . . . . . . 2 . . 2 . . . 2 1 1 1 1 1 1 1 1 1 1 2 .
. . . . . . . . . . . . 2 . . . 2 . . . 2 1 1 1 1 1 1 1 1 1 1 2
. . . . . . . . . . . 2 . . . . . 2 . . . 2 1 1 1 1 1 1 1 1 1 2
. . . 1 . . . . 2 2 2 2 2 . . . . 2 . . . . 2 2 2 2 2 1 1 1 1 2
. 1 1 . . . 1 . . . 2 . . . 2 2 2 2 2 2 . . . . . . . 2 1 1 1 2
1 1 1 . . 1 1 1 . . 2 . . . . . 2 . . . . 1 . . . . . . 2 1 2 .
1 1 . . . . 1 . . . . . . . . 2 . . . . . . . . 1 . . . . 2 . .
*/
       0x0 , 0x0 , 0x0 , 0x0 , 0x2A, 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x0 , 0x0 , 0x25, 0xA0, 0x0 , 0x0 , 0x1 , 0x0 , 0x0 , 0x0 ,
       0x9 , 0x58, 0x0 , 0x10, 0x5 , 0x40, 0x0 , 0x0 , 0x2 , 0x56,
       0x0 , 0x10, 0x1 , 0x40, 0x4 , 0x0 , 0x2 , 0x55, 0x80, 0x50,
       0x1 , 0x40, 0x15, 0x0 , 0x2 , 0x55, 0x60, 0x0 , 0x0 , 0x0 ,
       0x4 , 0x1 , 0x2 , 0x55, 0x58, 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
       0x2 , 0x55, 0x56, 0x0 , 0x0 , 0x40, 0x0 , 0x0 , 0x9 , 0x55,
       0x56, 0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x25, 0x55, 0x56, 0x0 ,
       0x0 , 0x0 , 0x0 , 0x10, 0x95, 0x55, 0x56, 0x0 , 0x4 , 0x0 ,
       0x0 , 0x2 , 0x55, 0x55, 0x56, 0x0 , 0x0 , 0x2 , 0xAA, 0x89,
       0x55, 0x55, 0x58, 0x0 , 0x0 , 0x9 , 0x55, 0x65, 0x55, 0x55,
       0x60, 0x0 , 0x0 , 0x26, 0x56, 0x59, 0x55, 0x55, 0x80, 0x14,
       0x0 , 0x98, 0x98, 0x96, 0x55, 0x56, 0x0 , 0x0 , 0x0 , 0x98,
       0x98, 0x96, 0xA5, 0xA8, 0x4 , 0x0 , 0x0 , 0x96, 0x56, 0x56,
       0x5A, 0x0 , 0x0 , 0x4 , 0x0 , 0x95, 0x55, 0x56, 0x56, 0x0 ,
       0x4 , 0x40, 0x0 , 0x9A, 0x65, 0x56, 0x55, 0x80, 0x0 , 0x0 ,
       0x0 , 0x29, 0x95, 0x5A, 0x55, 0x60, 0x0 , 0x10, 0x0 , 0xA6,
       0x55, 0x62, 0x55, 0x5A, 0xA8, 0x0 , 0x2 , 0x9A, 0xAA, 0x80,
       0x95, 0x55, 0x56, 0x0 , 0xA , 0x60, 0x0 , 0xA0, 0x25, 0x55,
       0x55, 0x80, 0x9 , 0x80, 0x0 , 0x88, 0x9 , 0x55, 0x55, 0x60,
       0x0 , 0x0 , 0x0 , 0x82, 0x2 , 0x55, 0x55, 0x58, 0x0 , 0x0 ,
       0x0 , 0x80, 0x80, 0x95, 0x55, 0x56, 0x0 , 0x0 , 0x2 , 0x0 ,
       0x20, 0x25, 0x55, 0x56, 0x1 , 0x0 , 0xAA, 0x80, 0x20, 0xA ,
       0xA9, 0x56, 0x14, 0x4 , 0x8 , 0xA , 0xAA, 0x0 , 0x2 , 0x56,
       0x54, 0x15, 0x8 , 0x0 , 0x80, 0x10, 0x0 , 0x98, 0x50, 0x4 ,
       0x0 , 0x2 , 0x0 , 0x0 , 0x40, 0x20
};

static unsigned char swmscsym[MISCANGS][MISCBYTES] = {

/*  bomb symbols based on the following template file:


08                08                08                08
. . . . . . . .   . . . . . . . .   . . . . . . . .   . . . . . . . .
. . . . . . . .   . . . . . . . .   . . . . . 1 1 .   . . . . 1 1 . .
. 1 1 . . . . .   . . . . . 1 1 .   . . . . 1 1 1 .   . . . . 1 1 . .
. 1 1 1 1 1 1 .   . . . 1 1 1 1 .   . . . 1 1 1 . .   . . . 1 1 . . .
. 1 1 1 1 1 1 .   1 1 1 1 1 . . .   . 1 1 1 1 . . .   . . . 1 1 . . .
. 1 1 . . . . .   . 1 1 1 . . . .   . . 1 1 . . . .   . 1 1 1 . . . .
. . . . . . . .   . . 1 1 . . . .   . . . 1 . . . .   . . 1 1 1 . . .
. . . . . . . .   . . . . . . . .   . . . . . . . .   . . . . . . . .
*/
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x14, 0x0 , 0x15, 0x54, 0x15, 0x54,
		0x14, 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x14, 0x1 , 0x54, 0x55, 0x40,
		0x15, 0x0 , 0x5 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x14, 0x0 , 0x54, 0x1 , 0x50, 0x15, 0x40,
		0x5 , 0x0 , 0x1 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x50, 0x0 , 0x50, 0x1 , 0x40, 0x1 , 0x40,
		0x15, 0x0 , 0x5 , 0x40, 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x1 , 0x40, 0x1 , 0x40, 0x1 , 0x40, 0x1 , 0x40,
		0x5 , 0x50, 0x5 , 0x50, 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x5 , 0x0 , 0x5 , 0x0 , 0x1 , 0x40, 0x1 , 0x54,
		0x0 , 0x54, 0x0 , 0x50, 0x0 , 0x40,
	},
	{
		0x0 , 0x0 , 0x14, 0x0 , 0x15, 0x0 , 0x5 , 0x40, 0x1 , 0x54,
		0x0 , 0x50, 0x0 , 0x40, 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x14, 0x0 , 0x15, 0x44, 0x1 , 0x54,
		0x0 , 0x14, 0x0 , 0x10, 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x0 , 0x0 , 0x14, 0x15, 0x54, 0x15, 0x54,
		0x0 , 0x14, 0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x50, 0x0 , 0x54, 0x1 , 0x55, 0x15, 0x40,
		0x14, 0x0 , 0x0 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x0 , 0x40, 0x0 , 0x50, 0x1 , 0x54, 0x5 , 0x40,
		0x15, 0x0 , 0x14, 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x1 , 0x50, 0x0 , 0x54, 0x1 , 0x40, 0x1 , 0x40,
		0x5 , 0x0 , 0x5 , 0x0 , 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x5 , 0x50, 0x5 , 0x50, 0x1 , 0x40, 0x1 , 0x40,
		0x1 , 0x40, 0x1 , 0x40, 0x0 , 0x0 ,
	},
	{
		0x1 , 0x0 , 0x5 , 0x0 , 0x15, 0x0 , 0x15, 0x40, 0x1 , 0x40,
		0x0 , 0x50, 0x0 , 0x50, 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x1 , 0x0 , 0x5 , 0x0 , 0x15, 0x40, 0x1 , 0x50,
		0x0 , 0x54, 0x0 , 0x14, 0x0 , 0x0 ,
	},
	{
		0x0 , 0x0 , 0x4 , 0x0 , 0x14, 0x0 , 0x15, 0x40, 0x11, 0x54,
		0x0 , 0x14, 0x0 , 0x0 , 0x0 , 0x0
	}
};

static unsigned char swbstsym[BRSTSYMS][BRSTBYTES] = {


/*  starburst symbols based on the following template file:

08                 08
. . . . 1 . . .    . . . 1 . . 1 .
. 1 . . 1 . 1 .    1 . . 1 . 1 . .
. . 1 . 1 1 . .    . 1 . 1 1 . . .
1 1 1 1 1 . . .    . . 1 1 1 1 1 1
. . . 1 1 1 1 1    1 1 1 1 1 1 . .
. . 1 1 . 1 . .    . . . 1 1 . 1 .
. 1 . 1 . . 1 .    . . 1 . 1 . . 1
. . . 1 . . . .    . 1 . . 1 . . .
*/
	{
		0x0 , 0x40, 0x10, 0x44, 0x4 , 0x50, 0x55, 0x40, 0x1 , 0x55,
		0x5 , 0x10, 0x11, 0x4 , 0x1 , 0x0 ,
	},
	{		
		0x1 , 0x4 , 0x41, 0x10, 0x11, 0x40, 0x5 , 0x55, 0x55, 0x50,
		0x1 , 0x44, 0x4 , 0x41, 0x10, 0x40
	}
};

// sdh 27/6/2002: create a sopsym_t structure from the original 
// raw sprite data.
// the data in sopsym_t's is in a simpler one-byte-per-pixel format
// rather than packing 4 pixels into one byte as in the original data.
// this simplifies various stuff such as collision detection. 

static sopsym_t *sopsym_from_data(unsigned char *data, int w, int h)
{
	sopsym_t *sym = malloc(sizeof(*sym));
	unsigned char *d, *s;
	int x, y;

	sym->w = w;
	sym->h = h;
	sym->data = malloc(w * h);

	// decode the symbol data

	for (d=data, s=sym->data, y=0; y<h; ++y) {

		// all symbols are multiples of 4 wide
		// so this should be ok

		for (x=0; x<w; x += 4, ++d) {
			*s++ = (*d & 0xc0) >> 6;
			*s++ = (*d & 0x30) >> 4;
			*s++ = (*d & 0x0c) >> 2;
			*s++ = (*d & 0x03);
		}
	}

	return sym;
}

// converted symbols:

sopsym_t *symbol_bomb[8];                 // swbmbsym
sopsym_t *symbol_targets[4];              // swtrgsym
sopsym_t *symbol_target_hit;              // swhtrsym
sopsym_t *symbol_debris[8];               // swexpsym
sopsym_t *symbol_flock[2];                // swflksym
sopsym_t *symbol_bird[2];                 // swbrdsym
sopsym_t *symbol_ox[2];                   // swoxsym
sopsym_t *symbol_ghost;                   // swghtsym
sopsym_t *symbol_shotwin;                 // swshtsym
sopsym_t *symbol_birdsplat;               // swsplsym
sopsym_t *symbol_missile[16];             // swmscsym
sopsym_t *symbol_burst[2];                // swbstsym
sopsym_t *symbol_plane[2][16];            // swplnsym
sopsym_t *symbol_plane_hit[2];            // swhitsym
sopsym_t *symbol_plane_win[4];            // swwinsym

// special symbol for single pixel (bullets etc)

sopsym_t symbol_pixel = {
	.data = NULL,
	.w = 1,
	.h = 1
};

// generate symbols from data

#define sopsyms_from_data(data, w, h, out)                              \
        { int _i;                                                       \
          for (_i=0; _i<sizeof(out)/sizeof(*(out)); ++_i)               \
             (out)[_i] = sopsym_from_data((data)[_i], (w), (h));        \
        }

void symbol_generate()
{
	sopsyms_from_data(swbmbsym, 8, 8, symbol_bomb);
	sopsyms_from_data(swtrgsym, 16, 16, symbol_targets);
	sopsyms_from_data(swexpsym, 8, 8, symbol_debris);
	sopsyms_from_data(swflksym, 16, 16, symbol_flock);
	sopsyms_from_data(swbrdsym, 4, 2, symbol_bird);
	sopsyms_from_data(swoxsym, 16, 16, symbol_ox);
	sopsyms_from_data(swmscsym, 8, 8, symbol_missile);
	sopsyms_from_data(swbstsym, 8, 8, symbol_burst);
	sopsyms_from_data(swplnsym[0], 16, 16, symbol_plane[0]);
	sopsyms_from_data(swplnsym[1], 16, 16, symbol_plane[1]);
	sopsyms_from_data(swhitsym, 16, 16, symbol_plane_hit);
	sopsyms_from_data(swwinsym, 16, 16, symbol_plane_win);

	symbol_target_hit = sopsym_from_data(swhtrsym, 16, 16);
	symbol_ghost = sopsym_from_data(swghtsym, 8, 8);
	symbol_shotwin = sopsym_from_data(swshtsym, 16, 16);
	symbol_birdsplat = sopsym_from_data(swsplsym, 32, 32);

	{
		static unsigned char p = 3;
		symbol_pixel.data = &p;
	}
}



//---------------------------------------------------------------------------
//
// $Log: swsymbol.c,v $
// Revision 1.1.1.1  2003/02/14 19:03:21  fraggle
// Initial Sourceforge CVS import
//
//
// sdh 14/2/2003: change license header to GPL
// sdh 28/06/2002: move plane sprites here, drop swplanes.c
//                 original sprite data (char sw*) made static 
// sdh 27/06/2002: add code to generate new sopsym_t objects from the 
//                 original sprite data
// sdh 21/10/2001: reformatted headers, added cvs tags
// sdh 20/10/2001: added some missing {}'s to shut up compiler
//
//---------------------------------------------------------------------------

