use indieweb::http::Client;
use indieweb::standards::webmention::{process_incoming_webmention, Request};
use serde::Serialize;
use url::Url;

#[derive(Serialize)]
pub struct ParseResult {
    pub source: String,
    pub target: String,
    pub post_type: String,
    pub has_source_item: bool,
    pub document_items: usize,
}

pub async fn run(
    client: &impl Client,
    source: &Url,
    target: &Url,
    token: Option<&str>,
) -> miette::Result<ParseResult> {
    let request = Request {
        source: source.clone(),
        target: target.clone(),
        private: None,
        vouch: vec![],
        token: token.map(ToString::to_string),
    };

    let relationship = process_incoming_webmention(client, &request).await?;

    Ok(ParseResult {
        source: source.to_string(),
        target: target.to_string(),
        post_type: relationship.r#type.to_string(),
        has_source_item: relationship.source.is_some(),
        document_items: relationship.document.items.len(),
    })
}
