// Copyright (c) 2022-2023 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_HISTOGRAM_HPP_
#define ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_HISTOGRAM_HPP_

#include "../../../type_traits.hpp"
#include "../device_config_helper.hpp"
#include <type_traits>

/* DO NOT EDIT THIS FILE
 * This file is automatically generated by `/scripts/autotune/create_optimization.py`.
 * so most likely you want to edit rocprim/device/device_(algo)_config.hpp
 */

/// \addtogroup primitivesmodule_deviceconfigs
/// @{

BEGIN_ROCPRIM_NAMESPACE

namespace detail
{

template<unsigned int arch,
         class value_type,
         unsigned int channels,
         unsigned int active_channels,
         class enable = void>
struct default_histogram_config
    : default_histogram_config_base<value_type, channels, active_channels>
{};

// Based on value_type = double, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 5>, 2048, 2048, 3>
{};

// Based on value_type = double, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = double, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 4>, 2048, 2048, 3>
{};

// Based on value_type = double, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 3>
{};

// Based on value_type = double, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 5>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<128, 3>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 5>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<64, 3>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 1) && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 8>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 2) && (active_channels == 2))>>
    : histogram_config<kernel_config<128, 2>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 3) && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 4>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 4) && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 4) && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 3>, 2048, 2048, 4>
{};

// Based on value_type = int64_t, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 3>
{};

// Based on value_type = int64_t, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 3>
{};

// Based on value_type = int64_t, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<64, 4>, 2048, 2048, 4>
{};

// Based on value_type = int64_t, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 4>
{};

// Based on value_type = int64_t, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 3>
{};

// Based on value_type = int, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 9>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<128, 2>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 2>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<64, 2>, 2048, 2048, 3>
{};

// Based on value_type = int, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 9>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<128, 4>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 2>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 2>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 3>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 1) && (active_channels == 1))>>
    : histogram_config<kernel_config<128, 15>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 2) && (active_channels == 2))>>
    : histogram_config<kernel_config<128, 8>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 3) && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 3>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 4) && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 4) && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = double, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<128, 16>, 2048, 2048, 3>
{};

// Based on value_type = double, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 2>
{};

// Based on value_type = double, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<64, 2>, 2048, 2048, 4>
{};

// Based on value_type = double, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<64, 1>, 2048, 2048, 3>
{};

// Based on value_type = double, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 3>
{};

// Based on value_type = float, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<64, 5>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 4>, 2048, 2048, 3>
{};

// Based on value_type = float, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 2>
{};

// Based on value_type = rocprim::half, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 1) && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 5>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 2) && (active_channels == 2))>>
    : histogram_config<kernel_config<128, 6>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 3) && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 5>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 4) && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 2>, 2048, 2048, 3>
{};

// Based on value_type = rocprim::half, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 4) && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = int64_t, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<64, 5>, 2048, 2048, 2>
{};

// Based on value_type = int64_t, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = int64_t, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<64, 5>, 2048, 2048, 2>
{};

// Based on value_type = int64_t, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<64, 1>, 2048, 2048, 3>
{};

// Based on value_type = int64_t, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 2>
{};

// Based on value_type = int, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 12>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<64, 3>, 2048, 2048, 2>
{};

// Based on value_type = int, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 2>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 3>
{};

// Based on value_type = int, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<128, 3>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 7>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<128, 4>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 4>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<128, 3>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 1) && (active_channels == 1))>>
    : histogram_config<kernel_config<128, 13>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 2) && (active_channels == 2))>>
    : histogram_config<kernel_config<128, 5>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 3) && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 5>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 4) && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx1102),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 4) && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = double, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<64, 10>, 2048, 2048, 2>
{};

// Based on value_type = double, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<64, 2>, 2048, 2048, 2>
{};

// Based on value_type = double, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 4>
{};

// Based on value_type = double, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 2>
{};

// Based on value_type = double, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 3>, 2048, 2048, 3>
{};

// Based on value_type = rocprim::half, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 1) && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 9>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 2) && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 7>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 3) && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 4) && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 3>, 2048, 2048, 3>
{};

// Based on value_type = rocprim::half, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 4) && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = int64_t, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<64, 10>, 2048, 2048, 3>
{};

// Based on value_type = int64_t, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 4>
{};

// Based on value_type = int64_t, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 4>
{};

// Based on value_type = int64_t, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 4>
{};

// Based on value_type = int64_t, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 3>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 7>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<64, 4>, 2048, 2048, 2>
{};

// Based on value_type = int, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<64, 4>, 2048, 2048, 2>
{};

// Based on value_type = int, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 3>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 12>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 3>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 1) && (active_channels == 1))>>
    : histogram_config<kernel_config<64, 14>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 2) && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 7>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 3) && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 5>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 4) && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx900),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 4) && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = double, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 3>
{};

// Based on value_type = double, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 6>, 2048, 2048, 3>
{};

// Based on value_type = double, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 3>
{};

// Based on value_type = double, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<64, 4>, 2048, 2048, 4>
{};

// Based on value_type = double, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 2>
{};

// Based on value_type = float, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 14>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 7>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 1) && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 15>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 2) && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 8>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 3) && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 4>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 4) && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 4>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 4) && (active_channels == 4))>>
    : histogram_config<kernel_config<128, 4>, 2048, 2048, 4>
{};

// Based on value_type = int64_t, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = int64_t, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = int64_t, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = int64_t, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 2>
{};

// Based on value_type = int64_t, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 14>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 7>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 16>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 2>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 1) && (active_channels == 1))>>
    : histogram_config<kernel_config<64, 10>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 2) && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 3) && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 5>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 4) && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx906),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 4) && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = double, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 4>
{};

// Based on value_type = double, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 6>, 2048, 2048, 3>
{};

// Based on value_type = double, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = double, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = double, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 13>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 7>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 1) && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 15>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 2) && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 8>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 3) && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 4>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 4) && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 3>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 4) && (active_channels == 4))>>
    : histogram_config<kernel_config<128, 4>, 2048, 2048, 4>
{};

// Based on value_type = int64_t, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = int64_t, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 5>, 2048, 2048, 2>
{};

// Based on value_type = int64_t, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 2>
{};

// Based on value_type = int64_t, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 2>
{};

// Based on value_type = int64_t, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 2>
{};

// Based on value_type = int, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 15>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 7>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 16>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<128, 3>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 1) && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 16>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 2) && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 8>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 3) && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 5>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 4) && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx908),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 4) && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = double, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 4>
{};

// Based on value_type = double, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 6>, 2048, 2048, 3>
{};

// Based on value_type = double, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = double, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = double, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 13>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 7>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 1) && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 15>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 2) && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 8>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 3) && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 4>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 4) && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 3>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 4) && (active_channels == 4))>>
    : histogram_config<kernel_config<128, 4>, 2048, 2048, 4>
{};

// Based on value_type = int64_t, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = int64_t, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 5>, 2048, 2048, 2>
{};

// Based on value_type = int64_t, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 2>
{};

// Based on value_type = int64_t, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 2>
{};

// Based on value_type = int64_t, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 2>
{};

// Based on value_type = int, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 15>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 7>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 16>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<128, 3>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 1) && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 16>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 2) && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 8>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 3) && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 5>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 4) && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::unknown),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 4) && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = double, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 1>, 2048, 2048, 4>
{};

// Based on value_type = double, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 6>, 2048, 2048, 3>
{};

// Based on value_type = double, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = double, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = double, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 13>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 7>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = float, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 1) && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 15>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 2) && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 8>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 3) && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 4>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 4) && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 3>, 2048, 2048, 4>
{};

// Based on value_type = rocprim::half, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (channels == 4) && (active_channels == 4))>>
    : histogram_config<kernel_config<128, 4>, 2048, 2048, 4>
{};

// Based on value_type = int64_t, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = int64_t, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 5>, 2048, 2048, 2>
{};

// Based on value_type = int64_t, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 2>
{};

// Based on value_type = int64_t, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 2>
{};

// Based on value_type = int64_t, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 2>
{};

// Based on value_type = int, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 15>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 7>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = int, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 1)
                      && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 16>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 2)
                      && (active_channels == 2))>>
    : histogram_config<kernel_config<128, 3>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 3)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 4)
                      && (active_channels == 3))>>
    : histogram_config<kernel_config<128, 1>, 2048, 2048, 4>
{};

// Based on value_type = short, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1) && (channels == 4)
                      && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 2>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 1, active_channels = 1
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 1) && (active_channels == 1))>>
    : histogram_config<kernel_config<256, 16>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 2, active_channels = 2
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 2) && (active_channels == 2))>>
    : histogram_config<kernel_config<256, 8>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 3, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 3) && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 5>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 4, active_channels = 3
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 4) && (active_channels == 3))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

// Based on value_type = int8_t, channels = 4, active_channels = 4
template<class value_type, unsigned int channels, unsigned int active_channels>
struct default_histogram_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    value_type,
    channels,
    active_channels,
    std::enable_if_t<(!bool(rocprim::is_floating_point<value_type>::value)
                      && (sizeof(value_type) <= 1) && (channels == 4) && (active_channels == 4))>>
    : histogram_config<kernel_config<256, 4>, 2048, 2048, 4>
{};

} // end namespace detail

END_ROCPRIM_NAMESPACE

/// @}
// end of group primitivesmodule_deviceconfigs

#endif // ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_HISTOGRAM_HPP_