% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{getOAuthIntegration}
\alias{getOAuthIntegration}
\title{Get a Specific OAuth Integration}
\usage{
getOAuthIntegration(guid)
}
\arguments{
\item{guid}{The globally unique identifier (GUID) of the OAuth integration to retrieve.}
}
\value{
A list containing the integration metadata:
\describe{
\item{type}{The integration type (e.g., "custom").}
\item{name}{The integration name.}
\item{display_name}{The display name (may be NULL).}
\item{client_id}{The OAuth client ID.}
\item{auth_url}{The authorization URL.}
\item{token_url}{The token URL.}
\item{scopes}{A character vector of OAuth scopes.}
\item{issuer}{The OAuth issuer URL.}
\item{authenticated}{Boolean indicating if currently authenticated.}
\item{guid}{The globally unique identifier for this integration.}
}
Returns \code{NULL} if no integration with the specified GUID is found.
}
\description{
Retrieve metadata for a specific OAuth integration by its globally unique identifier.
This is a convenience function that calls \code{findOAuthIntegration(guid = guid)}.
}
\note{
This function requires Posit Workbench version 2026.01.0 or later. It works
in any IDE running within a Posit Workbench session (not just RStudio).
}
\examples{
\dontrun{
# Get a specific integration by GUID
integration <- getOAuthIntegration("4c1cfecb-1927-4f19-bc2f-d8ac261364e0")

if (!is.null(integration)) {
  cat("Found integration:", integration$name, "\n")
  cat("Authenticated:", integration$authenticated, "\n")

  # Get credentials if authenticated
  if (integration$authenticated) {
    creds <- getOAuthCredentials(audience = integration$guid)
  }
}
}
}
