% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_info_functions.R
\name{getLRT}
\alias{getLRT}
\title{Likelihood Ratio Test Between Nested Models}
\usage{
getLRT(fit1, fit0)
}
\arguments{
\item{fit1}{A model object representing the more complex (full) model.}

\item{fit0}{A model object representing the simpler (nested) model.}
}
\value{
A named numeric vector with:
\describe{
\item{tobs}{Test statistic (twice the difference in log-likelihoods).}
\item{df}{Degrees of freedom (difference in number of parameters).}
\item{p.value}{P-value from the chi-squared distribution.}
}
}
\description{
Performs a likelihood ratio test (LRT) between two nested models. Supports
models of class \code{lm}, \code{lmerMod}, \code{glmerMod}, \code{lme}, and \code{gls}.
}
\examples{
## lm
fit1 <- lm(mpg ~ wt + hp, data = mtcars)
fit0 <- lm(mpg ~ wt, data = mtcars)
getLRT(fit1, fit0)

## lmerMod
if (requireNamespace("lme4", quietly = TRUE)) {
  library(lme4)
  fit1 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy, REML = FALSE)
  fit0 <- lmer(Reaction ~ 1 + (Days | Subject), sleepstudy, REML = FALSE)
  getLRT(fit1, fit0)
}

## glmerMod
if (requireNamespace("lme4", quietly = TRUE)) {
  library(lme4)
  data(cbpp)
  fit1 <- glmer(cbind(incidence, size - incidence) ~ period + (1 | herd),
                data = cbpp, family = binomial)
  fit0 <- glmer(cbind(incidence, size - incidence) ~ 1 + (1 | herd),
                data = cbpp, family = binomial)
  getLRT(fit1, fit0)
}

## lme
if (requireNamespace("nlme", quietly = TRUE)) {
  library(nlme)
  fit1 <- lme(distance ~ age + Sex, random = ~1 | Subject,
              data = Orthodont, method = "ML")
  fit0 <- lme(distance ~ age, random = ~1 | Subject,
              data = Orthodont, method = "ML")
  getLRT(fit1, fit0)
}

## gls
if (requireNamespace("nlme", quietly = TRUE)) {
  library(nlme)
  fit1 <- gls(mpg ~ wt + hp, data = mtcars, method = "ML")
  fit0 <- gls(mpg ~ wt, data = mtcars, method = "ML")
  getLRT(fit1, fit0)
}

}
