% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{zzz-future.batchtools.options}
\alias{zzz-future.batchtools.options}
\alias{future.batchtools.options}
\alias{future.batchtools.delete}
\alias{future.batchtools.expiration.tail}
\alias{future.batchtools.output}
\alias{future.batchtools.workers}
\alias{R_FUTURE_CACHE_PATH}
\alias{R_FUTURE_BATCHTOOLS_DELETE}
\alias{R_FUTURE_BATCHTOOLS_EXPIRATION_TAIL}
\alias{R_FUTURE_BATCHTOOLS_OUTPUT}
\alias{R_FUTURE_BATCHTOOLS_WORKERS}
\title{Options used for batchtools futures}
\description{
Below are the \R options and environment variables that are used by the
\pkg{future.batchtools} package.
See \link[future:zzz-future.options]{future::future.options} for additional ones that apply to futures
in general.\cr
\cr
\emph{WARNING: Note that the names and the default values of these options
may change in future versions of the package.  Please use with care
until further notice.}
}
\section{Settings for batchtools futures}{

\describe{
\item{\option{future.batchtools.workers}:}{(a positive numeric or \code{+Inf})
The default number of workers available on HPC schedulers with
job queues.  (Default: \code{100})}

\item{\option{future.batchtools.output}:}{(logical)
If TRUE, \pkg{batchtools} will produce extra output.
If FALSE, such output will be disabled by setting \pkg{batchtools}
options \option{batchtools.verbose} and \option{batchtools.progress}
to FALSE.
(Default: \code{getOption("future.debug", FALSE)})}

\item{\option{future.batchtools.expiration.tail}:}{(a positive numeric)
When a \pkg{batchtools} job expires, the last few lines will be
relayed by batchtools futures to help troubleshooting.
This option controls how many lines are displayed.
(Default: \code{48L})}

\item{\option{future.cache.path}:}{
(character string)
An absolute or relative path specifying the root folder in which
\pkg{batchtools} registry folders are stored.
This folder needs to be accessible from all hosts ("workers").
Specifically, it must \emph{not} be a folder that is only local to the
machine such as \verb{file.path(tempdir(), ".future"} if an job scheduler
on a HPC environment is used.
(Default: \code{.future} in the current working directory)}

\item{\option{future.batchtools.delete}:}{(character string)
Controls whether or not the future's \pkg{batchtools} registry folder
is deleted after the future result has been collected.
If \code{"always"}, it is always deleted.
If \code{"never"}, it is never deleted.
If \code{"on-success"}, it is deleted if the future resolved successfully,
whereas if it failed, it is left as-is to help with troubleshooting.
(Default: \code{"on-success"})}
}
}

\section{Environment variables that set R options}{

All of the above \R \option{future.batchtools.*} options can be set by
corresponding environment variable \env{R_FUTURE_BATCHTOOLS_*} \emph{when
the \pkg{future.batchtools} package is loaded}.  This means that those
environment variables must be set before the \pkg{future.batchtools}
package is loaded in order to have an effect.
For example, if \code{R_FUTURE_BATCHTOOLS_WORKERS="200"} is set, then option
\option{future.batchtools.workers} is set to \code{200} (numeric).
}

\examples{
# Set an R option:
options(future.cache.path = "/cluster-wide/folder/.future")

}
