# Setting up a local development environment

This guide assumes that you are comfortable working on the
command line with tools like Git.

There are instructions for building [with Docker](#with-docker) or
[without Docker](#without-docker). Building with Docker means that
not all of the related repositories need local clones, and that you
will be building with a version of PHP that is known to work.

When working with multiple translations, or working on changes that may
also require changing files in the `doc-base` or `phd` repositories, the
suggested way to organize the local environment is to clone repositories
into a single `phpdoc` directory, and for individual languages to be cloned
into directories named `{LANG}` instead of `doc-{LANG}` as they are named
on GitHub. See `doc-base/languages.php` script to automate this process.

<a name="with-docker"></a>
## Building with make and Docker

- Install Docker (https://docs.docker.com/get-docker/)
- Clone the `doc-en` Git repository
- Rebuild the documentation using `make`
- Open output/php-chunked-xhtml/ in your browser.

```sh
$ mkdir phpdoc
$ cd phpdoc
$ git clone https://github.com/php/doc-en.git en
$ cd en
$ make
$ open output/php-chunked-xhtml/index.html
```

If the `doc-base` or `phd` repositories are available in directories
adjacent the clone of the `doc-en` repository, those will be used for
building, otherwise the latest revision of those repositories from GitHub
will be built into the Docker image used.

To force the Docker image used for building to itself be rebuilt, run
`make -B build`, otherwise the `Makefile` will only build it if it does not
already exist.

The web version of the documentation with `make php` and the output will
be placed in `output/php-web`. (See the [additional local web setup
instructions](local-web-setup.md) for details on how to view those.)

<a name="without-docker"></a>
## Building without make or Docker

## Check out the PHP documentation using Git

Note that `doc-en` is cloned into the `en` directory below.

```
$ mkdir phpdoc
$ cd phpdoc
$ git clone https://github.com/php/phd.git
$ git clone https://github.com/php/doc-base.git
$ git clone https://github.com/php/doc-en.git en
```

## Validate and build `.manual.xml`

```
$ php doc-base/configure.php
```

Running `configure.php` will check and validate the XML according to the
Docbook specification. It will output either error messages explaining
any problems, or an ASCII cat.

This creates the file `doc-base/.manual.xml` which can then be used
to generate other formats of the documentation.

If you are building a translation, you'll also need to specify the
language at this step:

```sh
$ git clone https://github.com/php/doc-fr.git fr
$ php doc-base/configure.php --with-lang=fr
```

When building a language, you still need to clone both the `doc-en` repository
(again, as `en`) so it can be used as the fallback for files that are not yet
translated.

## Build other formats of the documentation

`phd` can turn the `doc-base/.manual.xml` generated by `configure.php`
into several different formats, including a single HTML file, a
multiple-file ("chunked") HTML version, and a special version of the
HTML used by the PHP.net website.

```sh
$ php phd/render.php --docbook doc-base/.manual.xml --package PHP --format xhtml
$ open output/php-chunked-xhtml/index.html
```

To build the version for the website (with a [local web setup](local-web-setup.md)):

```sh
$ php phd/render.php --docbook doc-base/.manual.xml --package PHP --format php
$ open https://localhost:8080/manual/en/
```

<a name="windows-eol"></a>
## Translating on Windows

When working on Windows, try to use text editors that preserve the end
of line mark as `U+000A LINE FEED (LF)` only. If it's not possible,
you may issue the commands below to instruct `git` in transforming
the files in your local clone to use the Windows native end of line
mark:

```
cd LANG
git config core.autocrlf true
git add --renormalize .
git status
```

If the last comment above outputs no files, then the process works,
and you can start translating.

If the last command above shows a list of files, something went wrong,
because these listed files will be changed at *repository level*
in the next commit. There should be *none*. If any files are listed,
revert the changes with commands below and open an issue on
`doc-base` repository.

```
git config --unset core.autocrlf
git reset
git status
```