
import string
import re
from VmsSymbol import VmsSymbol

class Symbol(VmsSymbol):

    def __init__(self, name, attr):
	VmsSymbol.__init__(self,name)
	self.attributes = [attr]

    def addAttribute(self, attr):
	self.attributes.append(attr)

    # Note that these tests work only for entry points that are listed in the
    # object library listing (/names).  I.e., external references that are
    # resolved in other modules may not have the correct type.  This is okay:
    # symbols are only extracted into the VmsObjectModule if they already exist.
    def isFunction(self):
	return 'GSD$C_EPM' in self.attributes

    def isData(self):
	return 'GSD$C_SYM' in self.attributes\
	    and not 'GSD$C_EPM' in self.attributes

class _Parsers:

    class HeadingLinesStripper:

	'''
	Remove heading and trailing lines: blank lines, lines that start with
	an alphabetic character, and lines that contain only a form-feed
	'''

	def __call__(self, listing):
	    input = string.split(listing, '\n')
	    result = []
	    for line in input:
		if line:
		    c=line[0]
		    if c != '\f' and c not in string.letters:
			result.append(line)
	    return result

    stripHeadingLines=HeadingLinesStripper()
    class SectionParser:

	'''
	Base class that parses text into sections by using a regular
	expression that matches the format of the section heading.

        This is used to parse the object file analysis into record sections then
        structure sections then field sections.

	The base class customizes the function call operator, making instances
	of this class a function object (functor).

        The function operator takes two arguments.  The first argument is a list
        of strings (i.e., lines from the report, or records in VMSese) to be 
        parsed.  The second argument is a list of expected strings that is used
        to identify the type of entity expected.  Other entities will be
        discarded.

	The result will be a list of tuples.  Each tuple will consist of the
	name of the entity followed by its contents.

	Derived classes supply the regular expression by implementing an regExp
	method (which takes only self).  The regular expression must contain
	exactly one parenthetical group (enclosed in '()').
	'''

	def __call__(self, text, filter):

	    results = []
	    section=None
	    exp=self.regExp()
	    for line in text:
		m = exp.match(line)
		if m:
		    if section:
			results.append(section)
		    heading=m.group(1)
		    if heading in filter:
			section = (heading, [])
		    else:
			section = None
		elif section:
		    section[1].append(line)
	    if section:
		results.append(section)
	    return results

    class RecordParser(SectionParser):
	'''
	Once heading and trailing lines are removed, the report is divided
	into sections describing object records.

	These sections are of the form:

	n.  RECORD NAME (RECORD$TYPE), m bytes

	where, n is the record number, "RECORD NAME" is the description of the
	record and RECORD$TYPE is the symbolic name.

	This functor accepts an analyze/object listing and a list of record
	names that is used as a filter.
	'''

	pattern = '''^[0-9]+\.\s+([A-Za-z ]+)\s+\(.*\)'''
	exp = re.compile(pattern)

	def regExp(self):
	    return self.exp

    parseRecords = RecordParser()

    class StructureParser(SectionParser):
	'''
	Each record section in the object analysis report is divided into a
	number of fields or structures.

	Each structure begins with the heading:

		n)  Structure name (STRUCTURE$TYPE), m bytes

	where, n is a counter, "Structure name" is a description of the
	structure and STRUCTURE$TYPE is its symbolic name.

	This functor accepts an analyze/object record section and a list of
	structure names that is used as a filter.
	'''

	pattern = '''^\s+\d+\)[^(]+\(([^)]+)\).*$'''
	exp=re.compile(pattern)

	def regExp(self):
	    return self.exp

    parseStructures=StructureParser()

class ObjectFileAnalysis:

    def __init__(self, moduleName):
	self.symbols={}
	self.__moduleName=moduleName

    def analyze(self):
	import os

	os.system(
	    'ANALYZE/OBJECT/EOM/GSD/out=%s %s.OBJ'
	    % (self.__moduleName, self.__moduleName)
	)

	f = open(self.__moduleName + '.ANL', 'r')
	listing = _Parsers.stripHeadingLines(f.read())

	recordTypes = ["GLOBAL SYMBOL DIRECTORY"]
	records = _Parsers.parseRecords(listing, recordTypes)

	structureNames = [
	    "GSD$C_EPM",	# Entry Point Symbol and Mask Definition
	    "GSD$C_SYM",	# Global Symbol Specification
	    "GSD$C_PSC"
	]

	symbolNameExp = re.compile('''^\s+symbol: "(.+)"''')
	for record in records:
	    structures = _Parsers.parseStructures(record[1], structureNames)
	    for structure in structures:
		structureName = structure[0]
		symbolName = None
		text = structure[1]
		for line in text:
		    m = symbolNameExp.match(line)
		    if m:
			symbolName = m.group(1)
		if symbolName:
		    if self.symbols.has_key(symbolName):
			self.symbols[symbolName].addAttribute(structureName)
		    else:
			self.symbols[symbolName] = Symbol(symbolName, structureName)
	os.remove(self.__moduleName + '.ANL')

