/* Autogenerated: '../fiat-crypto/src/ExtractionOCaml/word_by_word_montgomery' --static --use-value-barrier --inline-internal p384 32 '2^384 - 2^128 - 2^96 + 2^32 - 1' */
/* curve description: p384 */
/* machine_wordsize = 32 (from "32") */
/* requested operations: (all) */
/* m = 0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffeffffffff0000000000000000ffffffff (from "2^384 - 2^128 - 2^96 + 2^32 - 1") */
/*                                                                    */
/* NOTE: In addition to the bounds specified above each function, all */
/*   functions synthesized for this Montgomery arithmetic require the */
/*   input to be strictly less than the prime modulus (m), and also   */
/*   require the input to be in the unique saturated representation.  */
/*   All functions also ensure that these two properties are true of  */
/*   return values.                                                   */
/*  */
/* Computed values: */
/*   eval z = z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) + (z[8] << 256) + (z[9] << 0x120) + (z[10] << 0x140) + (z[11] << 0x160) */
/*   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178) */
/*   twos_complement_eval z = let x1 := z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) + (z[8] << 256) + (z[9] << 0x120) + (z[10] << 0x140) + (z[11] << 0x160) in */
/*                            if x1 & (2^384-1) < 2^383 then x1 & (2^384-1) else (x1 & (2^384-1)) - 2^384 */

#include <stdint.h>
typedef unsigned char fiat_p384_uint1;
typedef signed char fiat_p384_int1;
#if defined(__GNUC__) || defined(__clang__)
#  define FIAT_P384_FIAT_INLINE __inline__
#else
#  define FIAT_P384_FIAT_INLINE
#endif

/* The type fiat_p384_montgomery_domain_field_element is a field element in the Montgomery domain. */
/* Bounds: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]] */
typedef uint32_t fiat_p384_montgomery_domain_field_element[12];

/* The type fiat_p384_non_montgomery_domain_field_element is a field element NOT in the Montgomery domain. */
/* Bounds: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]] */
typedef uint32_t fiat_p384_non_montgomery_domain_field_element[12];

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif

#if !defined(FIAT_P384_NO_ASM) && (defined(__GNUC__) || defined(__clang__))
static __inline__ uint32_t fiat_p384_value_barrier_u32(uint32_t a) {
  __asm__("" : "+r"(a) : /* no inputs */);
  return a;
}
#else
#  define fiat_p384_value_barrier_u32(x) (x)
#endif


/*
 * The function fiat_p384_addcarryx_u32 is an addition with carry.
 *
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^32
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static FIAT_P384_FIAT_INLINE void fiat_p384_addcarryx_u32(uint32_t* out1, fiat_p384_uint1* out2, fiat_p384_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  uint64_t x1;
  uint32_t x2;
  fiat_p384_uint1 x3;
  x1 = ((arg1 + (uint64_t)arg2) + arg3);
  x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
  x3 = (fiat_p384_uint1)(x1 >> 32);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_p384_subborrowx_u32 is a subtraction with borrow.
 *
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^32
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static FIAT_P384_FIAT_INLINE void fiat_p384_subborrowx_u32(uint32_t* out1, fiat_p384_uint1* out2, fiat_p384_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  int64_t x1;
  fiat_p384_int1 x2;
  uint32_t x3;
  x1 = ((arg2 - (int64_t)arg1) - arg3);
  x2 = (fiat_p384_int1)(x1 >> 32);
  x3 = (uint32_t)(x1 & UINT32_C(0xffffffff));
  *out1 = x3;
  *out2 = (fiat_p384_uint1)(0x0 - x2);
}

/*
 * The function fiat_p384_mulx_u32 is a multiplication, returning the full double-width result.
 *
 * Postconditions:
 *   out1 = (arg1 * arg2) mod 2^32
 *   out2 = ⌊arg1 * arg2 / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffff]
 *   arg2: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0xffffffff]
 */
static FIAT_P384_FIAT_INLINE void fiat_p384_mulx_u32(uint32_t* out1, uint32_t* out2, uint32_t arg1, uint32_t arg2) {
  uint64_t x1;
  uint32_t x2;
  uint32_t x3;
  x1 = ((uint64_t)arg1 * arg2);
  x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
  x3 = (uint32_t)(x1 >> 32);
  *out1 = x2;
  *out2 = x3;
}

/*
 * The function fiat_p384_cmovznz_u32 is a single-word conditional move.
 *
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static FIAT_P384_FIAT_INLINE void fiat_p384_cmovznz_u32(uint32_t* out1, fiat_p384_uint1 arg1, uint32_t arg2, uint32_t arg3) {
  fiat_p384_uint1 x1;
  uint32_t x2;
  uint32_t x3;
  x1 = (!(!arg1));
  x2 = ((fiat_p384_int1)(0x0 - x1) & UINT32_C(0xffffffff));
  x3 = ((fiat_p384_value_barrier_u32(x2) & arg3) | (fiat_p384_value_barrier_u32((~x2)) & arg2));
  *out1 = x3;
}

/*
 * The function fiat_p384_mul multiplies two field elements in the Montgomery domain.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_p384_mul(fiat_p384_montgomery_domain_field_element out1, const fiat_p384_montgomery_domain_field_element arg1, const fiat_p384_montgomery_domain_field_element arg2) {
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  uint32_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint32_t x12;
  uint32_t x13;
  uint32_t x14;
  uint32_t x15;
  uint32_t x16;
  uint32_t x17;
  uint32_t x18;
  uint32_t x19;
  uint32_t x20;
  uint32_t x21;
  uint32_t x22;
  uint32_t x23;
  uint32_t x24;
  uint32_t x25;
  uint32_t x26;
  uint32_t x27;
  uint32_t x28;
  uint32_t x29;
  uint32_t x30;
  uint32_t x31;
  uint32_t x32;
  uint32_t x33;
  uint32_t x34;
  uint32_t x35;
  uint32_t x36;
  uint32_t x37;
  fiat_p384_uint1 x38;
  uint32_t x39;
  fiat_p384_uint1 x40;
  uint32_t x41;
  fiat_p384_uint1 x42;
  uint32_t x43;
  fiat_p384_uint1 x44;
  uint32_t x45;
  fiat_p384_uint1 x46;
  uint32_t x47;
  fiat_p384_uint1 x48;
  uint32_t x49;
  fiat_p384_uint1 x50;
  uint32_t x51;
  fiat_p384_uint1 x52;
  uint32_t x53;
  fiat_p384_uint1 x54;
  uint32_t x55;
  fiat_p384_uint1 x56;
  uint32_t x57;
  fiat_p384_uint1 x58;
  uint32_t x59;
  uint32_t x60;
  uint32_t x61;
  uint32_t x62;
  uint32_t x63;
  uint32_t x64;
  uint32_t x65;
  uint32_t x66;
  uint32_t x67;
  uint32_t x68;
  uint32_t x69;
  uint32_t x70;
  uint32_t x71;
  uint32_t x72;
  uint32_t x73;
  uint32_t x74;
  uint32_t x75;
  uint32_t x76;
  uint32_t x77;
  uint32_t x78;
  uint32_t x79;
  uint32_t x80;
  fiat_p384_uint1 x81;
  uint32_t x82;
  fiat_p384_uint1 x83;
  uint32_t x84;
  fiat_p384_uint1 x85;
  uint32_t x86;
  fiat_p384_uint1 x87;
  uint32_t x88;
  fiat_p384_uint1 x89;
  uint32_t x90;
  fiat_p384_uint1 x91;
  uint32_t x92;
  fiat_p384_uint1 x93;
  uint32_t x94;
  fiat_p384_uint1 x95;
  uint32_t x96;
  uint32_t x97;
  fiat_p384_uint1 x98;
  uint32_t x99;
  fiat_p384_uint1 x100;
  uint32_t x101;
  fiat_p384_uint1 x102;
  uint32_t x103;
  fiat_p384_uint1 x104;
  uint32_t x105;
  fiat_p384_uint1 x106;
  uint32_t x107;
  fiat_p384_uint1 x108;
  uint32_t x109;
  fiat_p384_uint1 x110;
  uint32_t x111;
  fiat_p384_uint1 x112;
  uint32_t x113;
  fiat_p384_uint1 x114;
  uint32_t x115;
  fiat_p384_uint1 x116;
  uint32_t x117;
  fiat_p384_uint1 x118;
  uint32_t x119;
  fiat_p384_uint1 x120;
  uint32_t x121;
  fiat_p384_uint1 x122;
  uint32_t x123;
  uint32_t x124;
  uint32_t x125;
  uint32_t x126;
  uint32_t x127;
  uint32_t x128;
  uint32_t x129;
  uint32_t x130;
  uint32_t x131;
  uint32_t x132;
  uint32_t x133;
  uint32_t x134;
  uint32_t x135;
  uint32_t x136;
  uint32_t x137;
  uint32_t x138;
  uint32_t x139;
  uint32_t x140;
  uint32_t x141;
  uint32_t x142;
  uint32_t x143;
  uint32_t x144;
  uint32_t x145;
  uint32_t x146;
  uint32_t x147;
  fiat_p384_uint1 x148;
  uint32_t x149;
  fiat_p384_uint1 x150;
  uint32_t x151;
  fiat_p384_uint1 x152;
  uint32_t x153;
  fiat_p384_uint1 x154;
  uint32_t x155;
  fiat_p384_uint1 x156;
  uint32_t x157;
  fiat_p384_uint1 x158;
  uint32_t x159;
  fiat_p384_uint1 x160;
  uint32_t x161;
  fiat_p384_uint1 x162;
  uint32_t x163;
  fiat_p384_uint1 x164;
  uint32_t x165;
  fiat_p384_uint1 x166;
  uint32_t x167;
  fiat_p384_uint1 x168;
  uint32_t x169;
  uint32_t x170;
  fiat_p384_uint1 x171;
  uint32_t x172;
  fiat_p384_uint1 x173;
  uint32_t x174;
  fiat_p384_uint1 x175;
  uint32_t x176;
  fiat_p384_uint1 x177;
  uint32_t x178;
  fiat_p384_uint1 x179;
  uint32_t x180;
  fiat_p384_uint1 x181;
  uint32_t x182;
  fiat_p384_uint1 x183;
  uint32_t x184;
  fiat_p384_uint1 x185;
  uint32_t x186;
  fiat_p384_uint1 x187;
  uint32_t x188;
  fiat_p384_uint1 x189;
  uint32_t x190;
  fiat_p384_uint1 x191;
  uint32_t x192;
  fiat_p384_uint1 x193;
  uint32_t x194;
  fiat_p384_uint1 x195;
  uint32_t x196;
  uint32_t x197;
  uint32_t x198;
  uint32_t x199;
  uint32_t x200;
  uint32_t x201;
  uint32_t x202;
  uint32_t x203;
  uint32_t x204;
  uint32_t x205;
  uint32_t x206;
  uint32_t x207;
  uint32_t x208;
  uint32_t x209;
  uint32_t x210;
  uint32_t x211;
  uint32_t x212;
  uint32_t x213;
  uint32_t x214;
  uint32_t x215;
  uint32_t x216;
  fiat_p384_uint1 x217;
  uint32_t x218;
  fiat_p384_uint1 x219;
  uint32_t x220;
  fiat_p384_uint1 x221;
  uint32_t x222;
  fiat_p384_uint1 x223;
  uint32_t x224;
  fiat_p384_uint1 x225;
  uint32_t x226;
  fiat_p384_uint1 x227;
  uint32_t x228;
  fiat_p384_uint1 x229;
  uint32_t x230;
  fiat_p384_uint1 x231;
  uint32_t x232;
  uint32_t x233;
  fiat_p384_uint1 x234;
  uint32_t x235;
  fiat_p384_uint1 x236;
  uint32_t x237;
  fiat_p384_uint1 x238;
  uint32_t x239;
  fiat_p384_uint1 x240;
  uint32_t x241;
  fiat_p384_uint1 x242;
  uint32_t x243;
  fiat_p384_uint1 x244;
  uint32_t x245;
  fiat_p384_uint1 x246;
  uint32_t x247;
  fiat_p384_uint1 x248;
  uint32_t x249;
  fiat_p384_uint1 x250;
  uint32_t x251;
  fiat_p384_uint1 x252;
  uint32_t x253;
  fiat_p384_uint1 x254;
  uint32_t x255;
  fiat_p384_uint1 x256;
  uint32_t x257;
  fiat_p384_uint1 x258;
  uint32_t x259;
  uint32_t x260;
  uint32_t x261;
  uint32_t x262;
  uint32_t x263;
  uint32_t x264;
  uint32_t x265;
  uint32_t x266;
  uint32_t x267;
  uint32_t x268;
  uint32_t x269;
  uint32_t x270;
  uint32_t x271;
  uint32_t x272;
  uint32_t x273;
  uint32_t x274;
  uint32_t x275;
  uint32_t x276;
  uint32_t x277;
  uint32_t x278;
  uint32_t x279;
  uint32_t x280;
  uint32_t x281;
  uint32_t x282;
  uint32_t x283;
  uint32_t x284;
  fiat_p384_uint1 x285;
  uint32_t x286;
  fiat_p384_uint1 x287;
  uint32_t x288;
  fiat_p384_uint1 x289;
  uint32_t x290;
  fiat_p384_uint1 x291;
  uint32_t x292;
  fiat_p384_uint1 x293;
  uint32_t x294;
  fiat_p384_uint1 x295;
  uint32_t x296;
  fiat_p384_uint1 x297;
  uint32_t x298;
  fiat_p384_uint1 x299;
  uint32_t x300;
  fiat_p384_uint1 x301;
  uint32_t x302;
  fiat_p384_uint1 x303;
  uint32_t x304;
  fiat_p384_uint1 x305;
  uint32_t x306;
  uint32_t x307;
  fiat_p384_uint1 x308;
  uint32_t x309;
  fiat_p384_uint1 x310;
  uint32_t x311;
  fiat_p384_uint1 x312;
  uint32_t x313;
  fiat_p384_uint1 x314;
  uint32_t x315;
  fiat_p384_uint1 x316;
  uint32_t x317;
  fiat_p384_uint1 x318;
  uint32_t x319;
  fiat_p384_uint1 x320;
  uint32_t x321;
  fiat_p384_uint1 x322;
  uint32_t x323;
  fiat_p384_uint1 x324;
  uint32_t x325;
  fiat_p384_uint1 x326;
  uint32_t x327;
  fiat_p384_uint1 x328;
  uint32_t x329;
  fiat_p384_uint1 x330;
  uint32_t x331;
  fiat_p384_uint1 x332;
  uint32_t x333;
  uint32_t x334;
  uint32_t x335;
  uint32_t x336;
  uint32_t x337;
  uint32_t x338;
  uint32_t x339;
  uint32_t x340;
  uint32_t x341;
  uint32_t x342;
  uint32_t x343;
  uint32_t x344;
  uint32_t x345;
  uint32_t x346;
  uint32_t x347;
  uint32_t x348;
  uint32_t x349;
  uint32_t x350;
  uint32_t x351;
  uint32_t x352;
  uint32_t x353;
  fiat_p384_uint1 x354;
  uint32_t x355;
  fiat_p384_uint1 x356;
  uint32_t x357;
  fiat_p384_uint1 x358;
  uint32_t x359;
  fiat_p384_uint1 x360;
  uint32_t x361;
  fiat_p384_uint1 x362;
  uint32_t x363;
  fiat_p384_uint1 x364;
  uint32_t x365;
  fiat_p384_uint1 x366;
  uint32_t x367;
  fiat_p384_uint1 x368;
  uint32_t x369;
  uint32_t x370;
  fiat_p384_uint1 x371;
  uint32_t x372;
  fiat_p384_uint1 x373;
  uint32_t x374;
  fiat_p384_uint1 x375;
  uint32_t x376;
  fiat_p384_uint1 x377;
  uint32_t x378;
  fiat_p384_uint1 x379;
  uint32_t x380;
  fiat_p384_uint1 x381;
  uint32_t x382;
  fiat_p384_uint1 x383;
  uint32_t x384;
  fiat_p384_uint1 x385;
  uint32_t x386;
  fiat_p384_uint1 x387;
  uint32_t x388;
  fiat_p384_uint1 x389;
  uint32_t x390;
  fiat_p384_uint1 x391;
  uint32_t x392;
  fiat_p384_uint1 x393;
  uint32_t x394;
  fiat_p384_uint1 x395;
  uint32_t x396;
  uint32_t x397;
  uint32_t x398;
  uint32_t x399;
  uint32_t x400;
  uint32_t x401;
  uint32_t x402;
  uint32_t x403;
  uint32_t x404;
  uint32_t x405;
  uint32_t x406;
  uint32_t x407;
  uint32_t x408;
  uint32_t x409;
  uint32_t x410;
  uint32_t x411;
  uint32_t x412;
  uint32_t x413;
  uint32_t x414;
  uint32_t x415;
  uint32_t x416;
  uint32_t x417;
  uint32_t x418;
  uint32_t x419;
  uint32_t x420;
  uint32_t x421;
  fiat_p384_uint1 x422;
  uint32_t x423;
  fiat_p384_uint1 x424;
  uint32_t x425;
  fiat_p384_uint1 x426;
  uint32_t x427;
  fiat_p384_uint1 x428;
  uint32_t x429;
  fiat_p384_uint1 x430;
  uint32_t x431;
  fiat_p384_uint1 x432;
  uint32_t x433;
  fiat_p384_uint1 x434;
  uint32_t x435;
  fiat_p384_uint1 x436;
  uint32_t x437;
  fiat_p384_uint1 x438;
  uint32_t x439;
  fiat_p384_uint1 x440;
  uint32_t x441;
  fiat_p384_uint1 x442;
  uint32_t x443;
  uint32_t x444;
  fiat_p384_uint1 x445;
  uint32_t x446;
  fiat_p384_uint1 x447;
  uint32_t x448;
  fiat_p384_uint1 x449;
  uint32_t x450;
  fiat_p384_uint1 x451;
  uint32_t x452;
  fiat_p384_uint1 x453;
  uint32_t x454;
  fiat_p384_uint1 x455;
  uint32_t x456;
  fiat_p384_uint1 x457;
  uint32_t x458;
  fiat_p384_uint1 x459;
  uint32_t x460;
  fiat_p384_uint1 x461;
  uint32_t x462;
  fiat_p384_uint1 x463;
  uint32_t x464;
  fiat_p384_uint1 x465;
  uint32_t x466;
  fiat_p384_uint1 x467;
  uint32_t x468;
  fiat_p384_uint1 x469;
  uint32_t x470;
  uint32_t x471;
  uint32_t x472;
  uint32_t x473;
  uint32_t x474;
  uint32_t x475;
  uint32_t x476;
  uint32_t x477;
  uint32_t x478;
  uint32_t x479;
  uint32_t x480;
  uint32_t x481;
  uint32_t x482;
  uint32_t x483;
  uint32_t x484;
  uint32_t x485;
  uint32_t x486;
  uint32_t x487;
  uint32_t x488;
  uint32_t x489;
  uint32_t x490;
  fiat_p384_uint1 x491;
  uint32_t x492;
  fiat_p384_uint1 x493;
  uint32_t x494;
  fiat_p384_uint1 x495;
  uint32_t x496;
  fiat_p384_uint1 x497;
  uint32_t x498;
  fiat_p384_uint1 x499;
  uint32_t x500;
  fiat_p384_uint1 x501;
  uint32_t x502;
  fiat_p384_uint1 x503;
  uint32_t x504;
  fiat_p384_uint1 x505;
  uint32_t x506;
  uint32_t x507;
  fiat_p384_uint1 x508;
  uint32_t x509;
  fiat_p384_uint1 x510;
  uint32_t x511;
  fiat_p384_uint1 x512;
  uint32_t x513;
  fiat_p384_uint1 x514;
  uint32_t x515;
  fiat_p384_uint1 x516;
  uint32_t x517;
  fiat_p384_uint1 x518;
  uint32_t x519;
  fiat_p384_uint1 x520;
  uint32_t x521;
  fiat_p384_uint1 x522;
  uint32_t x523;
  fiat_p384_uint1 x524;
  uint32_t x525;
  fiat_p384_uint1 x526;
  uint32_t x527;
  fiat_p384_uint1 x528;
  uint32_t x529;
  fiat_p384_uint1 x530;
  uint32_t x531;
  fiat_p384_uint1 x532;
  uint32_t x533;
  uint32_t x534;
  uint32_t x535;
  uint32_t x536;
  uint32_t x537;
  uint32_t x538;
  uint32_t x539;
  uint32_t x540;
  uint32_t x541;
  uint32_t x542;
  uint32_t x543;
  uint32_t x544;
  uint32_t x545;
  uint32_t x546;
  uint32_t x547;
  uint32_t x548;
  uint32_t x549;
  uint32_t x550;
  uint32_t x551;
  uint32_t x552;
  uint32_t x553;
  uint32_t x554;
  uint32_t x555;
  uint32_t x556;
  uint32_t x557;
  uint32_t x558;
  fiat_p384_uint1 x559;
  uint32_t x560;
  fiat_p384_uint1 x561;
  uint32_t x562;
  fiat_p384_uint1 x563;
  uint32_t x564;
  fiat_p384_uint1 x565;
  uint32_t x566;
  fiat_p384_uint1 x567;
  uint32_t x568;
  fiat_p384_uint1 x569;
  uint32_t x570;
  fiat_p384_uint1 x571;
  uint32_t x572;
  fiat_p384_uint1 x573;
  uint32_t x574;
  fiat_p384_uint1 x575;
  uint32_t x576;
  fiat_p384_uint1 x577;
  uint32_t x578;
  fiat_p384_uint1 x579;
  uint32_t x580;
  uint32_t x581;
  fiat_p384_uint1 x582;
  uint32_t x583;
  fiat_p384_uint1 x584;
  uint32_t x585;
  fiat_p384_uint1 x586;
  uint32_t x587;
  fiat_p384_uint1 x588;
  uint32_t x589;
  fiat_p384_uint1 x590;
  uint32_t x591;
  fiat_p384_uint1 x592;
  uint32_t x593;
  fiat_p384_uint1 x594;
  uint32_t x595;
  fiat_p384_uint1 x596;
  uint32_t x597;
  fiat_p384_uint1 x598;
  uint32_t x599;
  fiat_p384_uint1 x600;
  uint32_t x601;
  fiat_p384_uint1 x602;
  uint32_t x603;
  fiat_p384_uint1 x604;
  uint32_t x605;
  fiat_p384_uint1 x606;
  uint32_t x607;
  uint32_t x608;
  uint32_t x609;
  uint32_t x610;
  uint32_t x611;
  uint32_t x612;
  uint32_t x613;
  uint32_t x614;
  uint32_t x615;
  uint32_t x616;
  uint32_t x617;
  uint32_t x618;
  uint32_t x619;
  uint32_t x620;
  uint32_t x621;
  uint32_t x622;
  uint32_t x623;
  uint32_t x624;
  uint32_t x625;
  uint32_t x626;
  uint32_t x627;
  fiat_p384_uint1 x628;
  uint32_t x629;
  fiat_p384_uint1 x630;
  uint32_t x631;
  fiat_p384_uint1 x632;
  uint32_t x633;
  fiat_p384_uint1 x634;
  uint32_t x635;
  fiat_p384_uint1 x636;
  uint32_t x637;
  fiat_p384_uint1 x638;
  uint32_t x639;
  fiat_p384_uint1 x640;
  uint32_t x641;
  fiat_p384_uint1 x642;
  uint32_t x643;
  uint32_t x644;
  fiat_p384_uint1 x645;
  uint32_t x646;
  fiat_p384_uint1 x647;
  uint32_t x648;
  fiat_p384_uint1 x649;
  uint32_t x650;
  fiat_p384_uint1 x651;
  uint32_t x652;
  fiat_p384_uint1 x653;
  uint32_t x654;
  fiat_p384_uint1 x655;
  uint32_t x656;
  fiat_p384_uint1 x657;
  uint32_t x658;
  fiat_p384_uint1 x659;
  uint32_t x660;
  fiat_p384_uint1 x661;
  uint32_t x662;
  fiat_p384_uint1 x663;
  uint32_t x664;
  fiat_p384_uint1 x665;
  uint32_t x666;
  fiat_p384_uint1 x667;
  uint32_t x668;
  fiat_p384_uint1 x669;
  uint32_t x670;
  uint32_t x671;
  uint32_t x672;
  uint32_t x673;
  uint32_t x674;
  uint32_t x675;
  uint32_t x676;
  uint32_t x677;
  uint32_t x678;
  uint32_t x679;
  uint32_t x680;
  uint32_t x681;
  uint32_t x682;
  uint32_t x683;
  uint32_t x684;
  uint32_t x685;
  uint32_t x686;
  uint32_t x687;
  uint32_t x688;
  uint32_t x689;
  uint32_t x690;
  uint32_t x691;
  uint32_t x692;
  uint32_t x693;
  uint32_t x694;
  uint32_t x695;
  fiat_p384_uint1 x696;
  uint32_t x697;
  fiat_p384_uint1 x698;
  uint32_t x699;
  fiat_p384_uint1 x700;
  uint32_t x701;
  fiat_p384_uint1 x702;
  uint32_t x703;
  fiat_p384_uint1 x704;
  uint32_t x705;
  fiat_p384_uint1 x706;
  uint32_t x707;
  fiat_p384_uint1 x708;
  uint32_t x709;
  fiat_p384_uint1 x710;
  uint32_t x711;
  fiat_p384_uint1 x712;
  uint32_t x713;
  fiat_p384_uint1 x714;
  uint32_t x715;
  fiat_p384_uint1 x716;
  uint32_t x717;
  uint32_t x718;
  fiat_p384_uint1 x719;
  uint32_t x720;
  fiat_p384_uint1 x721;
  uint32_t x722;
  fiat_p384_uint1 x723;
  uint32_t x724;
  fiat_p384_uint1 x725;
  uint32_t x726;
  fiat_p384_uint1 x727;
  uint32_t x728;
  fiat_p384_uint1 x729;
  uint32_t x730;
  fiat_p384_uint1 x731;
  uint32_t x732;
  fiat_p384_uint1 x733;
  uint32_t x734;
  fiat_p384_uint1 x735;
  uint32_t x736;
  fiat_p384_uint1 x737;
  uint32_t x738;
  fiat_p384_uint1 x739;
  uint32_t x740;
  fiat_p384_uint1 x741;
  uint32_t x742;
  fiat_p384_uint1 x743;
  uint32_t x744;
  uint32_t x745;
  uint32_t x746;
  uint32_t x747;
  uint32_t x748;
  uint32_t x749;
  uint32_t x750;
  uint32_t x751;
  uint32_t x752;
  uint32_t x753;
  uint32_t x754;
  uint32_t x755;
  uint32_t x756;
  uint32_t x757;
  uint32_t x758;
  uint32_t x759;
  uint32_t x760;
  uint32_t x761;
  uint32_t x762;
  uint32_t x763;
  uint32_t x764;
  fiat_p384_uint1 x765;
  uint32_t x766;
  fiat_p384_uint1 x767;
  uint32_t x768;
  fiat_p384_uint1 x769;
  uint32_t x770;
  fiat_p384_uint1 x771;
  uint32_t x772;
  fiat_p384_uint1 x773;
  uint32_t x774;
  fiat_p384_uint1 x775;
  uint32_t x776;
  fiat_p384_uint1 x777;
  uint32_t x778;
  fiat_p384_uint1 x779;
  uint32_t x780;
  uint32_t x781;
  fiat_p384_uint1 x782;
  uint32_t x783;
  fiat_p384_uint1 x784;
  uint32_t x785;
  fiat_p384_uint1 x786;
  uint32_t x787;
  fiat_p384_uint1 x788;
  uint32_t x789;
  fiat_p384_uint1 x790;
  uint32_t x791;
  fiat_p384_uint1 x792;
  uint32_t x793;
  fiat_p384_uint1 x794;
  uint32_t x795;
  fiat_p384_uint1 x796;
  uint32_t x797;
  fiat_p384_uint1 x798;
  uint32_t x799;
  fiat_p384_uint1 x800;
  uint32_t x801;
  fiat_p384_uint1 x802;
  uint32_t x803;
  fiat_p384_uint1 x804;
  uint32_t x805;
  fiat_p384_uint1 x806;
  uint32_t x807;
  uint32_t x808;
  uint32_t x809;
  uint32_t x810;
  uint32_t x811;
  uint32_t x812;
  uint32_t x813;
  uint32_t x814;
  uint32_t x815;
  uint32_t x816;
  uint32_t x817;
  uint32_t x818;
  uint32_t x819;
  uint32_t x820;
  uint32_t x821;
  uint32_t x822;
  uint32_t x823;
  uint32_t x824;
  uint32_t x825;
  uint32_t x826;
  uint32_t x827;
  uint32_t x828;
  uint32_t x829;
  uint32_t x830;
  uint32_t x831;
  uint32_t x832;
  fiat_p384_uint1 x833;
  uint32_t x834;
  fiat_p384_uint1 x835;
  uint32_t x836;
  fiat_p384_uint1 x837;
  uint32_t x838;
  fiat_p384_uint1 x839;
  uint32_t x840;
  fiat_p384_uint1 x841;
  uint32_t x842;
  fiat_p384_uint1 x843;
  uint32_t x844;
  fiat_p384_uint1 x845;
  uint32_t x846;
  fiat_p384_uint1 x847;
  uint32_t x848;
  fiat_p384_uint1 x849;
  uint32_t x850;
  fiat_p384_uint1 x851;
  uint32_t x852;
  fiat_p384_uint1 x853;
  uint32_t x854;
  uint32_t x855;
  fiat_p384_uint1 x856;
  uint32_t x857;
  fiat_p384_uint1 x858;
  uint32_t x859;
  fiat_p384_uint1 x860;
  uint32_t x861;
  fiat_p384_uint1 x862;
  uint32_t x863;
  fiat_p384_uint1 x864;
  uint32_t x865;
  fiat_p384_uint1 x866;
  uint32_t x867;
  fiat_p384_uint1 x868;
  uint32_t x869;
  fiat_p384_uint1 x870;
  uint32_t x871;
  fiat_p384_uint1 x872;
  uint32_t x873;
  fiat_p384_uint1 x874;
  uint32_t x875;
  fiat_p384_uint1 x876;
  uint32_t x877;
  fiat_p384_uint1 x878;
  uint32_t x879;
  fiat_p384_uint1 x880;
  uint32_t x881;
  uint32_t x882;
  uint32_t x883;
  uint32_t x884;
  uint32_t x885;
  uint32_t x886;
  uint32_t x887;
  uint32_t x888;
  uint32_t x889;
  uint32_t x890;
  uint32_t x891;
  uint32_t x892;
  uint32_t x893;
  uint32_t x894;
  uint32_t x895;
  uint32_t x896;
  uint32_t x897;
  uint32_t x898;
  uint32_t x899;
  uint32_t x900;
  uint32_t x901;
  fiat_p384_uint1 x902;
  uint32_t x903;
  fiat_p384_uint1 x904;
  uint32_t x905;
  fiat_p384_uint1 x906;
  uint32_t x907;
  fiat_p384_uint1 x908;
  uint32_t x909;
  fiat_p384_uint1 x910;
  uint32_t x911;
  fiat_p384_uint1 x912;
  uint32_t x913;
  fiat_p384_uint1 x914;
  uint32_t x915;
  fiat_p384_uint1 x916;
  uint32_t x917;
  uint32_t x918;
  fiat_p384_uint1 x919;
  uint32_t x920;
  fiat_p384_uint1 x921;
  uint32_t x922;
  fiat_p384_uint1 x923;
  uint32_t x924;
  fiat_p384_uint1 x925;
  uint32_t x926;
  fiat_p384_uint1 x927;
  uint32_t x928;
  fiat_p384_uint1 x929;
  uint32_t x930;
  fiat_p384_uint1 x931;
  uint32_t x932;
  fiat_p384_uint1 x933;
  uint32_t x934;
  fiat_p384_uint1 x935;
  uint32_t x936;
  fiat_p384_uint1 x937;
  uint32_t x938;
  fiat_p384_uint1 x939;
  uint32_t x940;
  fiat_p384_uint1 x941;
  uint32_t x942;
  fiat_p384_uint1 x943;
  uint32_t x944;
  uint32_t x945;
  uint32_t x946;
  uint32_t x947;
  uint32_t x948;
  uint32_t x949;
  uint32_t x950;
  uint32_t x951;
  uint32_t x952;
  uint32_t x953;
  uint32_t x954;
  uint32_t x955;
  uint32_t x956;
  uint32_t x957;
  uint32_t x958;
  uint32_t x959;
  uint32_t x960;
  uint32_t x961;
  uint32_t x962;
  uint32_t x963;
  uint32_t x964;
  uint32_t x965;
  uint32_t x966;
  uint32_t x967;
  uint32_t x968;
  uint32_t x969;
  fiat_p384_uint1 x970;
  uint32_t x971;
  fiat_p384_uint1 x972;
  uint32_t x973;
  fiat_p384_uint1 x974;
  uint32_t x975;
  fiat_p384_uint1 x976;
  uint32_t x977;
  fiat_p384_uint1 x978;
  uint32_t x979;
  fiat_p384_uint1 x980;
  uint32_t x981;
  fiat_p384_uint1 x982;
  uint32_t x983;
  fiat_p384_uint1 x984;
  uint32_t x985;
  fiat_p384_uint1 x986;
  uint32_t x987;
  fiat_p384_uint1 x988;
  uint32_t x989;
  fiat_p384_uint1 x990;
  uint32_t x991;
  uint32_t x992;
  fiat_p384_uint1 x993;
  uint32_t x994;
  fiat_p384_uint1 x995;
  uint32_t x996;
  fiat_p384_uint1 x997;
  uint32_t x998;
  fiat_p384_uint1 x999;
  uint32_t x1000;
  fiat_p384_uint1 x1001;
  uint32_t x1002;
  fiat_p384_uint1 x1003;
  uint32_t x1004;
  fiat_p384_uint1 x1005;
  uint32_t x1006;
  fiat_p384_uint1 x1007;
  uint32_t x1008;
  fiat_p384_uint1 x1009;
  uint32_t x1010;
  fiat_p384_uint1 x1011;
  uint32_t x1012;
  fiat_p384_uint1 x1013;
  uint32_t x1014;
  fiat_p384_uint1 x1015;
  uint32_t x1016;
  fiat_p384_uint1 x1017;
  uint32_t x1018;
  uint32_t x1019;
  uint32_t x1020;
  uint32_t x1021;
  uint32_t x1022;
  uint32_t x1023;
  uint32_t x1024;
  uint32_t x1025;
  uint32_t x1026;
  uint32_t x1027;
  uint32_t x1028;
  uint32_t x1029;
  uint32_t x1030;
  uint32_t x1031;
  uint32_t x1032;
  uint32_t x1033;
  uint32_t x1034;
  uint32_t x1035;
  uint32_t x1036;
  uint32_t x1037;
  uint32_t x1038;
  fiat_p384_uint1 x1039;
  uint32_t x1040;
  fiat_p384_uint1 x1041;
  uint32_t x1042;
  fiat_p384_uint1 x1043;
  uint32_t x1044;
  fiat_p384_uint1 x1045;
  uint32_t x1046;
  fiat_p384_uint1 x1047;
  uint32_t x1048;
  fiat_p384_uint1 x1049;
  uint32_t x1050;
  fiat_p384_uint1 x1051;
  uint32_t x1052;
  fiat_p384_uint1 x1053;
  uint32_t x1054;
  uint32_t x1055;
  fiat_p384_uint1 x1056;
  uint32_t x1057;
  fiat_p384_uint1 x1058;
  uint32_t x1059;
  fiat_p384_uint1 x1060;
  uint32_t x1061;
  fiat_p384_uint1 x1062;
  uint32_t x1063;
  fiat_p384_uint1 x1064;
  uint32_t x1065;
  fiat_p384_uint1 x1066;
  uint32_t x1067;
  fiat_p384_uint1 x1068;
  uint32_t x1069;
  fiat_p384_uint1 x1070;
  uint32_t x1071;
  fiat_p384_uint1 x1072;
  uint32_t x1073;
  fiat_p384_uint1 x1074;
  uint32_t x1075;
  fiat_p384_uint1 x1076;
  uint32_t x1077;
  fiat_p384_uint1 x1078;
  uint32_t x1079;
  fiat_p384_uint1 x1080;
  uint32_t x1081;
  uint32_t x1082;
  uint32_t x1083;
  uint32_t x1084;
  uint32_t x1085;
  uint32_t x1086;
  uint32_t x1087;
  uint32_t x1088;
  uint32_t x1089;
  uint32_t x1090;
  uint32_t x1091;
  uint32_t x1092;
  uint32_t x1093;
  uint32_t x1094;
  uint32_t x1095;
  uint32_t x1096;
  uint32_t x1097;
  uint32_t x1098;
  uint32_t x1099;
  uint32_t x1100;
  uint32_t x1101;
  uint32_t x1102;
  uint32_t x1103;
  uint32_t x1104;
  uint32_t x1105;
  uint32_t x1106;
  fiat_p384_uint1 x1107;
  uint32_t x1108;
  fiat_p384_uint1 x1109;
  uint32_t x1110;
  fiat_p384_uint1 x1111;
  uint32_t x1112;
  fiat_p384_uint1 x1113;
  uint32_t x1114;
  fiat_p384_uint1 x1115;
  uint32_t x1116;
  fiat_p384_uint1 x1117;
  uint32_t x1118;
  fiat_p384_uint1 x1119;
  uint32_t x1120;
  fiat_p384_uint1 x1121;
  uint32_t x1122;
  fiat_p384_uint1 x1123;
  uint32_t x1124;
  fiat_p384_uint1 x1125;
  uint32_t x1126;
  fiat_p384_uint1 x1127;
  uint32_t x1128;
  uint32_t x1129;
  fiat_p384_uint1 x1130;
  uint32_t x1131;
  fiat_p384_uint1 x1132;
  uint32_t x1133;
  fiat_p384_uint1 x1134;
  uint32_t x1135;
  fiat_p384_uint1 x1136;
  uint32_t x1137;
  fiat_p384_uint1 x1138;
  uint32_t x1139;
  fiat_p384_uint1 x1140;
  uint32_t x1141;
  fiat_p384_uint1 x1142;
  uint32_t x1143;
  fiat_p384_uint1 x1144;
  uint32_t x1145;
  fiat_p384_uint1 x1146;
  uint32_t x1147;
  fiat_p384_uint1 x1148;
  uint32_t x1149;
  fiat_p384_uint1 x1150;
  uint32_t x1151;
  fiat_p384_uint1 x1152;
  uint32_t x1153;
  fiat_p384_uint1 x1154;
  uint32_t x1155;
  uint32_t x1156;
  uint32_t x1157;
  uint32_t x1158;
  uint32_t x1159;
  uint32_t x1160;
  uint32_t x1161;
  uint32_t x1162;
  uint32_t x1163;
  uint32_t x1164;
  uint32_t x1165;
  uint32_t x1166;
  uint32_t x1167;
  uint32_t x1168;
  uint32_t x1169;
  uint32_t x1170;
  uint32_t x1171;
  uint32_t x1172;
  uint32_t x1173;
  uint32_t x1174;
  uint32_t x1175;
  fiat_p384_uint1 x1176;
  uint32_t x1177;
  fiat_p384_uint1 x1178;
  uint32_t x1179;
  fiat_p384_uint1 x1180;
  uint32_t x1181;
  fiat_p384_uint1 x1182;
  uint32_t x1183;
  fiat_p384_uint1 x1184;
  uint32_t x1185;
  fiat_p384_uint1 x1186;
  uint32_t x1187;
  fiat_p384_uint1 x1188;
  uint32_t x1189;
  fiat_p384_uint1 x1190;
  uint32_t x1191;
  uint32_t x1192;
  fiat_p384_uint1 x1193;
  uint32_t x1194;
  fiat_p384_uint1 x1195;
  uint32_t x1196;
  fiat_p384_uint1 x1197;
  uint32_t x1198;
  fiat_p384_uint1 x1199;
  uint32_t x1200;
  fiat_p384_uint1 x1201;
  uint32_t x1202;
  fiat_p384_uint1 x1203;
  uint32_t x1204;
  fiat_p384_uint1 x1205;
  uint32_t x1206;
  fiat_p384_uint1 x1207;
  uint32_t x1208;
  fiat_p384_uint1 x1209;
  uint32_t x1210;
  fiat_p384_uint1 x1211;
  uint32_t x1212;
  fiat_p384_uint1 x1213;
  uint32_t x1214;
  fiat_p384_uint1 x1215;
  uint32_t x1216;
  fiat_p384_uint1 x1217;
  uint32_t x1218;
  uint32_t x1219;
  uint32_t x1220;
  uint32_t x1221;
  uint32_t x1222;
  uint32_t x1223;
  uint32_t x1224;
  uint32_t x1225;
  uint32_t x1226;
  uint32_t x1227;
  uint32_t x1228;
  uint32_t x1229;
  uint32_t x1230;
  uint32_t x1231;
  uint32_t x1232;
  uint32_t x1233;
  uint32_t x1234;
  uint32_t x1235;
  uint32_t x1236;
  uint32_t x1237;
  uint32_t x1238;
  uint32_t x1239;
  uint32_t x1240;
  uint32_t x1241;
  uint32_t x1242;
  uint32_t x1243;
  fiat_p384_uint1 x1244;
  uint32_t x1245;
  fiat_p384_uint1 x1246;
  uint32_t x1247;
  fiat_p384_uint1 x1248;
  uint32_t x1249;
  fiat_p384_uint1 x1250;
  uint32_t x1251;
  fiat_p384_uint1 x1252;
  uint32_t x1253;
  fiat_p384_uint1 x1254;
  uint32_t x1255;
  fiat_p384_uint1 x1256;
  uint32_t x1257;
  fiat_p384_uint1 x1258;
  uint32_t x1259;
  fiat_p384_uint1 x1260;
  uint32_t x1261;
  fiat_p384_uint1 x1262;
  uint32_t x1263;
  fiat_p384_uint1 x1264;
  uint32_t x1265;
  uint32_t x1266;
  fiat_p384_uint1 x1267;
  uint32_t x1268;
  fiat_p384_uint1 x1269;
  uint32_t x1270;
  fiat_p384_uint1 x1271;
  uint32_t x1272;
  fiat_p384_uint1 x1273;
  uint32_t x1274;
  fiat_p384_uint1 x1275;
  uint32_t x1276;
  fiat_p384_uint1 x1277;
  uint32_t x1278;
  fiat_p384_uint1 x1279;
  uint32_t x1280;
  fiat_p384_uint1 x1281;
  uint32_t x1282;
  fiat_p384_uint1 x1283;
  uint32_t x1284;
  fiat_p384_uint1 x1285;
  uint32_t x1286;
  fiat_p384_uint1 x1287;
  uint32_t x1288;
  fiat_p384_uint1 x1289;
  uint32_t x1290;
  fiat_p384_uint1 x1291;
  uint32_t x1292;
  uint32_t x1293;
  uint32_t x1294;
  uint32_t x1295;
  uint32_t x1296;
  uint32_t x1297;
  uint32_t x1298;
  uint32_t x1299;
  uint32_t x1300;
  uint32_t x1301;
  uint32_t x1302;
  uint32_t x1303;
  uint32_t x1304;
  uint32_t x1305;
  uint32_t x1306;
  uint32_t x1307;
  uint32_t x1308;
  uint32_t x1309;
  uint32_t x1310;
  uint32_t x1311;
  uint32_t x1312;
  fiat_p384_uint1 x1313;
  uint32_t x1314;
  fiat_p384_uint1 x1315;
  uint32_t x1316;
  fiat_p384_uint1 x1317;
  uint32_t x1318;
  fiat_p384_uint1 x1319;
  uint32_t x1320;
  fiat_p384_uint1 x1321;
  uint32_t x1322;
  fiat_p384_uint1 x1323;
  uint32_t x1324;
  fiat_p384_uint1 x1325;
  uint32_t x1326;
  fiat_p384_uint1 x1327;
  uint32_t x1328;
  uint32_t x1329;
  fiat_p384_uint1 x1330;
  uint32_t x1331;
  fiat_p384_uint1 x1332;
  uint32_t x1333;
  fiat_p384_uint1 x1334;
  uint32_t x1335;
  fiat_p384_uint1 x1336;
  uint32_t x1337;
  fiat_p384_uint1 x1338;
  uint32_t x1339;
  fiat_p384_uint1 x1340;
  uint32_t x1341;
  fiat_p384_uint1 x1342;
  uint32_t x1343;
  fiat_p384_uint1 x1344;
  uint32_t x1345;
  fiat_p384_uint1 x1346;
  uint32_t x1347;
  fiat_p384_uint1 x1348;
  uint32_t x1349;
  fiat_p384_uint1 x1350;
  uint32_t x1351;
  fiat_p384_uint1 x1352;
  uint32_t x1353;
  fiat_p384_uint1 x1354;
  uint32_t x1355;
  uint32_t x1356;
  uint32_t x1357;
  uint32_t x1358;
  uint32_t x1359;
  uint32_t x1360;
  uint32_t x1361;
  uint32_t x1362;
  uint32_t x1363;
  uint32_t x1364;
  uint32_t x1365;
  uint32_t x1366;
  uint32_t x1367;
  uint32_t x1368;
  uint32_t x1369;
  uint32_t x1370;
  uint32_t x1371;
  uint32_t x1372;
  uint32_t x1373;
  uint32_t x1374;
  uint32_t x1375;
  uint32_t x1376;
  uint32_t x1377;
  uint32_t x1378;
  uint32_t x1379;
  uint32_t x1380;
  fiat_p384_uint1 x1381;
  uint32_t x1382;
  fiat_p384_uint1 x1383;
  uint32_t x1384;
  fiat_p384_uint1 x1385;
  uint32_t x1386;
  fiat_p384_uint1 x1387;
  uint32_t x1388;
  fiat_p384_uint1 x1389;
  uint32_t x1390;
  fiat_p384_uint1 x1391;
  uint32_t x1392;
  fiat_p384_uint1 x1393;
  uint32_t x1394;
  fiat_p384_uint1 x1395;
  uint32_t x1396;
  fiat_p384_uint1 x1397;
  uint32_t x1398;
  fiat_p384_uint1 x1399;
  uint32_t x1400;
  fiat_p384_uint1 x1401;
  uint32_t x1402;
  uint32_t x1403;
  fiat_p384_uint1 x1404;
  uint32_t x1405;
  fiat_p384_uint1 x1406;
  uint32_t x1407;
  fiat_p384_uint1 x1408;
  uint32_t x1409;
  fiat_p384_uint1 x1410;
  uint32_t x1411;
  fiat_p384_uint1 x1412;
  uint32_t x1413;
  fiat_p384_uint1 x1414;
  uint32_t x1415;
  fiat_p384_uint1 x1416;
  uint32_t x1417;
  fiat_p384_uint1 x1418;
  uint32_t x1419;
  fiat_p384_uint1 x1420;
  uint32_t x1421;
  fiat_p384_uint1 x1422;
  uint32_t x1423;
  fiat_p384_uint1 x1424;
  uint32_t x1425;
  fiat_p384_uint1 x1426;
  uint32_t x1427;
  fiat_p384_uint1 x1428;
  uint32_t x1429;
  uint32_t x1430;
  uint32_t x1431;
  uint32_t x1432;
  uint32_t x1433;
  uint32_t x1434;
  uint32_t x1435;
  uint32_t x1436;
  uint32_t x1437;
  uint32_t x1438;
  uint32_t x1439;
  uint32_t x1440;
  uint32_t x1441;
  uint32_t x1442;
  uint32_t x1443;
  uint32_t x1444;
  uint32_t x1445;
  uint32_t x1446;
  uint32_t x1447;
  uint32_t x1448;
  uint32_t x1449;
  fiat_p384_uint1 x1450;
  uint32_t x1451;
  fiat_p384_uint1 x1452;
  uint32_t x1453;
  fiat_p384_uint1 x1454;
  uint32_t x1455;
  fiat_p384_uint1 x1456;
  uint32_t x1457;
  fiat_p384_uint1 x1458;
  uint32_t x1459;
  fiat_p384_uint1 x1460;
  uint32_t x1461;
  fiat_p384_uint1 x1462;
  uint32_t x1463;
  fiat_p384_uint1 x1464;
  uint32_t x1465;
  uint32_t x1466;
  fiat_p384_uint1 x1467;
  uint32_t x1468;
  fiat_p384_uint1 x1469;
  uint32_t x1470;
  fiat_p384_uint1 x1471;
  uint32_t x1472;
  fiat_p384_uint1 x1473;
  uint32_t x1474;
  fiat_p384_uint1 x1475;
  uint32_t x1476;
  fiat_p384_uint1 x1477;
  uint32_t x1478;
  fiat_p384_uint1 x1479;
  uint32_t x1480;
  fiat_p384_uint1 x1481;
  uint32_t x1482;
  fiat_p384_uint1 x1483;
  uint32_t x1484;
  fiat_p384_uint1 x1485;
  uint32_t x1486;
  fiat_p384_uint1 x1487;
  uint32_t x1488;
  fiat_p384_uint1 x1489;
  uint32_t x1490;
  fiat_p384_uint1 x1491;
  uint32_t x1492;
  uint32_t x1493;
  uint32_t x1494;
  uint32_t x1495;
  uint32_t x1496;
  uint32_t x1497;
  uint32_t x1498;
  uint32_t x1499;
  uint32_t x1500;
  uint32_t x1501;
  uint32_t x1502;
  uint32_t x1503;
  uint32_t x1504;
  uint32_t x1505;
  uint32_t x1506;
  uint32_t x1507;
  uint32_t x1508;
  uint32_t x1509;
  uint32_t x1510;
  uint32_t x1511;
  uint32_t x1512;
  uint32_t x1513;
  uint32_t x1514;
  uint32_t x1515;
  uint32_t x1516;
  uint32_t x1517;
  fiat_p384_uint1 x1518;
  uint32_t x1519;
  fiat_p384_uint1 x1520;
  uint32_t x1521;
  fiat_p384_uint1 x1522;
  uint32_t x1523;
  fiat_p384_uint1 x1524;
  uint32_t x1525;
  fiat_p384_uint1 x1526;
  uint32_t x1527;
  fiat_p384_uint1 x1528;
  uint32_t x1529;
  fiat_p384_uint1 x1530;
  uint32_t x1531;
  fiat_p384_uint1 x1532;
  uint32_t x1533;
  fiat_p384_uint1 x1534;
  uint32_t x1535;
  fiat_p384_uint1 x1536;
  uint32_t x1537;
  fiat_p384_uint1 x1538;
  uint32_t x1539;
  uint32_t x1540;
  fiat_p384_uint1 x1541;
  uint32_t x1542;
  fiat_p384_uint1 x1543;
  uint32_t x1544;
  fiat_p384_uint1 x1545;
  uint32_t x1546;
  fiat_p384_uint1 x1547;
  uint32_t x1548;
  fiat_p384_uint1 x1549;
  uint32_t x1550;
  fiat_p384_uint1 x1551;
  uint32_t x1552;
  fiat_p384_uint1 x1553;
  uint32_t x1554;
  fiat_p384_uint1 x1555;
  uint32_t x1556;
  fiat_p384_uint1 x1557;
  uint32_t x1558;
  fiat_p384_uint1 x1559;
  uint32_t x1560;
  fiat_p384_uint1 x1561;
  uint32_t x1562;
  fiat_p384_uint1 x1563;
  uint32_t x1564;
  fiat_p384_uint1 x1565;
  uint32_t x1566;
  uint32_t x1567;
  uint32_t x1568;
  uint32_t x1569;
  uint32_t x1570;
  uint32_t x1571;
  uint32_t x1572;
  uint32_t x1573;
  uint32_t x1574;
  uint32_t x1575;
  uint32_t x1576;
  uint32_t x1577;
  uint32_t x1578;
  uint32_t x1579;
  uint32_t x1580;
  uint32_t x1581;
  uint32_t x1582;
  uint32_t x1583;
  uint32_t x1584;
  uint32_t x1585;
  uint32_t x1586;
  fiat_p384_uint1 x1587;
  uint32_t x1588;
  fiat_p384_uint1 x1589;
  uint32_t x1590;
  fiat_p384_uint1 x1591;
  uint32_t x1592;
  fiat_p384_uint1 x1593;
  uint32_t x1594;
  fiat_p384_uint1 x1595;
  uint32_t x1596;
  fiat_p384_uint1 x1597;
  uint32_t x1598;
  fiat_p384_uint1 x1599;
  uint32_t x1600;
  fiat_p384_uint1 x1601;
  uint32_t x1602;
  uint32_t x1603;
  fiat_p384_uint1 x1604;
  uint32_t x1605;
  fiat_p384_uint1 x1606;
  uint32_t x1607;
  fiat_p384_uint1 x1608;
  uint32_t x1609;
  fiat_p384_uint1 x1610;
  uint32_t x1611;
  fiat_p384_uint1 x1612;
  uint32_t x1613;
  fiat_p384_uint1 x1614;
  uint32_t x1615;
  fiat_p384_uint1 x1616;
  uint32_t x1617;
  fiat_p384_uint1 x1618;
  uint32_t x1619;
  fiat_p384_uint1 x1620;
  uint32_t x1621;
  fiat_p384_uint1 x1622;
  uint32_t x1623;
  fiat_p384_uint1 x1624;
  uint32_t x1625;
  fiat_p384_uint1 x1626;
  uint32_t x1627;
  fiat_p384_uint1 x1628;
  uint32_t x1629;
  uint32_t x1630;
  fiat_p384_uint1 x1631;
  uint32_t x1632;
  fiat_p384_uint1 x1633;
  uint32_t x1634;
  fiat_p384_uint1 x1635;
  uint32_t x1636;
  fiat_p384_uint1 x1637;
  uint32_t x1638;
  fiat_p384_uint1 x1639;
  uint32_t x1640;
  fiat_p384_uint1 x1641;
  uint32_t x1642;
  fiat_p384_uint1 x1643;
  uint32_t x1644;
  fiat_p384_uint1 x1645;
  uint32_t x1646;
  fiat_p384_uint1 x1647;
  uint32_t x1648;
  fiat_p384_uint1 x1649;
  uint32_t x1650;
  fiat_p384_uint1 x1651;
  uint32_t x1652;
  fiat_p384_uint1 x1653;
  uint32_t x1654;
  fiat_p384_uint1 x1655;
  uint32_t x1656;
  uint32_t x1657;
  uint32_t x1658;
  uint32_t x1659;
  uint32_t x1660;
  uint32_t x1661;
  uint32_t x1662;
  uint32_t x1663;
  uint32_t x1664;
  uint32_t x1665;
  uint32_t x1666;
  uint32_t x1667;
  x1 = (arg1[1]);
  x2 = (arg1[2]);
  x3 = (arg1[3]);
  x4 = (arg1[4]);
  x5 = (arg1[5]);
  x6 = (arg1[6]);
  x7 = (arg1[7]);
  x8 = (arg1[8]);
  x9 = (arg1[9]);
  x10 = (arg1[10]);
  x11 = (arg1[11]);
  x12 = (arg1[0]);
  fiat_p384_mulx_u32(&x13, &x14, x12, (arg2[11]));
  fiat_p384_mulx_u32(&x15, &x16, x12, (arg2[10]));
  fiat_p384_mulx_u32(&x17, &x18, x12, (arg2[9]));
  fiat_p384_mulx_u32(&x19, &x20, x12, (arg2[8]));
  fiat_p384_mulx_u32(&x21, &x22, x12, (arg2[7]));
  fiat_p384_mulx_u32(&x23, &x24, x12, (arg2[6]));
  fiat_p384_mulx_u32(&x25, &x26, x12, (arg2[5]));
  fiat_p384_mulx_u32(&x27, &x28, x12, (arg2[4]));
  fiat_p384_mulx_u32(&x29, &x30, x12, (arg2[3]));
  fiat_p384_mulx_u32(&x31, &x32, x12, (arg2[2]));
  fiat_p384_mulx_u32(&x33, &x34, x12, (arg2[1]));
  fiat_p384_mulx_u32(&x35, &x36, x12, (arg2[0]));
  fiat_p384_addcarryx_u32(&x37, &x38, 0x0, x36, x33);
  fiat_p384_addcarryx_u32(&x39, &x40, x38, x34, x31);
  fiat_p384_addcarryx_u32(&x41, &x42, x40, x32, x29);
  fiat_p384_addcarryx_u32(&x43, &x44, x42, x30, x27);
  fiat_p384_addcarryx_u32(&x45, &x46, x44, x28, x25);
  fiat_p384_addcarryx_u32(&x47, &x48, x46, x26, x23);
  fiat_p384_addcarryx_u32(&x49, &x50, x48, x24, x21);
  fiat_p384_addcarryx_u32(&x51, &x52, x50, x22, x19);
  fiat_p384_addcarryx_u32(&x53, &x54, x52, x20, x17);
  fiat_p384_addcarryx_u32(&x55, &x56, x54, x18, x15);
  fiat_p384_addcarryx_u32(&x57, &x58, x56, x16, x13);
  x59 = (x58 + x14);
  fiat_p384_mulx_u32(&x60, &x61, x35, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x62, &x63, x35, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x64, &x65, x35, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x66, &x67, x35, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x68, &x69, x35, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x70, &x71, x35, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x72, &x73, x35, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x74, &x75, x35, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x76, &x77, x35, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x78, &x79, x35, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x80, &x81, 0x0, x77, x74);
  fiat_p384_addcarryx_u32(&x82, &x83, x81, x75, x72);
  fiat_p384_addcarryx_u32(&x84, &x85, x83, x73, x70);
  fiat_p384_addcarryx_u32(&x86, &x87, x85, x71, x68);
  fiat_p384_addcarryx_u32(&x88, &x89, x87, x69, x66);
  fiat_p384_addcarryx_u32(&x90, &x91, x89, x67, x64);
  fiat_p384_addcarryx_u32(&x92, &x93, x91, x65, x62);
  fiat_p384_addcarryx_u32(&x94, &x95, x93, x63, x60);
  x96 = (x95 + x61);
  fiat_p384_addcarryx_u32(&x97, &x98, 0x0, x35, x78);
  fiat_p384_addcarryx_u32(&x99, &x100, x98, x37, x79);
  fiat_p384_addcarryx_u32(&x101, &x102, x100, x39, 0x0);
  fiat_p384_addcarryx_u32(&x103, &x104, x102, x41, x76);
  fiat_p384_addcarryx_u32(&x105, &x106, x104, x43, x80);
  fiat_p384_addcarryx_u32(&x107, &x108, x106, x45, x82);
  fiat_p384_addcarryx_u32(&x109, &x110, x108, x47, x84);
  fiat_p384_addcarryx_u32(&x111, &x112, x110, x49, x86);
  fiat_p384_addcarryx_u32(&x113, &x114, x112, x51, x88);
  fiat_p384_addcarryx_u32(&x115, &x116, x114, x53, x90);
  fiat_p384_addcarryx_u32(&x117, &x118, x116, x55, x92);
  fiat_p384_addcarryx_u32(&x119, &x120, x118, x57, x94);
  fiat_p384_addcarryx_u32(&x121, &x122, x120, x59, x96);
  fiat_p384_mulx_u32(&x123, &x124, x1, (arg2[11]));
  fiat_p384_mulx_u32(&x125, &x126, x1, (arg2[10]));
  fiat_p384_mulx_u32(&x127, &x128, x1, (arg2[9]));
  fiat_p384_mulx_u32(&x129, &x130, x1, (arg2[8]));
  fiat_p384_mulx_u32(&x131, &x132, x1, (arg2[7]));
  fiat_p384_mulx_u32(&x133, &x134, x1, (arg2[6]));
  fiat_p384_mulx_u32(&x135, &x136, x1, (arg2[5]));
  fiat_p384_mulx_u32(&x137, &x138, x1, (arg2[4]));
  fiat_p384_mulx_u32(&x139, &x140, x1, (arg2[3]));
  fiat_p384_mulx_u32(&x141, &x142, x1, (arg2[2]));
  fiat_p384_mulx_u32(&x143, &x144, x1, (arg2[1]));
  fiat_p384_mulx_u32(&x145, &x146, x1, (arg2[0]));
  fiat_p384_addcarryx_u32(&x147, &x148, 0x0, x146, x143);
  fiat_p384_addcarryx_u32(&x149, &x150, x148, x144, x141);
  fiat_p384_addcarryx_u32(&x151, &x152, x150, x142, x139);
  fiat_p384_addcarryx_u32(&x153, &x154, x152, x140, x137);
  fiat_p384_addcarryx_u32(&x155, &x156, x154, x138, x135);
  fiat_p384_addcarryx_u32(&x157, &x158, x156, x136, x133);
  fiat_p384_addcarryx_u32(&x159, &x160, x158, x134, x131);
  fiat_p384_addcarryx_u32(&x161, &x162, x160, x132, x129);
  fiat_p384_addcarryx_u32(&x163, &x164, x162, x130, x127);
  fiat_p384_addcarryx_u32(&x165, &x166, x164, x128, x125);
  fiat_p384_addcarryx_u32(&x167, &x168, x166, x126, x123);
  x169 = (x168 + x124);
  fiat_p384_addcarryx_u32(&x170, &x171, 0x0, x99, x145);
  fiat_p384_addcarryx_u32(&x172, &x173, x171, x101, x147);
  fiat_p384_addcarryx_u32(&x174, &x175, x173, x103, x149);
  fiat_p384_addcarryx_u32(&x176, &x177, x175, x105, x151);
  fiat_p384_addcarryx_u32(&x178, &x179, x177, x107, x153);
  fiat_p384_addcarryx_u32(&x180, &x181, x179, x109, x155);
  fiat_p384_addcarryx_u32(&x182, &x183, x181, x111, x157);
  fiat_p384_addcarryx_u32(&x184, &x185, x183, x113, x159);
  fiat_p384_addcarryx_u32(&x186, &x187, x185, x115, x161);
  fiat_p384_addcarryx_u32(&x188, &x189, x187, x117, x163);
  fiat_p384_addcarryx_u32(&x190, &x191, x189, x119, x165);
  fiat_p384_addcarryx_u32(&x192, &x193, x191, x121, x167);
  fiat_p384_addcarryx_u32(&x194, &x195, x193, x122, x169);
  fiat_p384_mulx_u32(&x196, &x197, x170, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x198, &x199, x170, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x200, &x201, x170, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x202, &x203, x170, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x204, &x205, x170, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x206, &x207, x170, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x208, &x209, x170, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x210, &x211, x170, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x212, &x213, x170, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x214, &x215, x170, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x216, &x217, 0x0, x213, x210);
  fiat_p384_addcarryx_u32(&x218, &x219, x217, x211, x208);
  fiat_p384_addcarryx_u32(&x220, &x221, x219, x209, x206);
  fiat_p384_addcarryx_u32(&x222, &x223, x221, x207, x204);
  fiat_p384_addcarryx_u32(&x224, &x225, x223, x205, x202);
  fiat_p384_addcarryx_u32(&x226, &x227, x225, x203, x200);
  fiat_p384_addcarryx_u32(&x228, &x229, x227, x201, x198);
  fiat_p384_addcarryx_u32(&x230, &x231, x229, x199, x196);
  x232 = (x231 + x197);
  fiat_p384_addcarryx_u32(&x233, &x234, 0x0, x170, x214);
  fiat_p384_addcarryx_u32(&x235, &x236, x234, x172, x215);
  fiat_p384_addcarryx_u32(&x237, &x238, x236, x174, 0x0);
  fiat_p384_addcarryx_u32(&x239, &x240, x238, x176, x212);
  fiat_p384_addcarryx_u32(&x241, &x242, x240, x178, x216);
  fiat_p384_addcarryx_u32(&x243, &x244, x242, x180, x218);
  fiat_p384_addcarryx_u32(&x245, &x246, x244, x182, x220);
  fiat_p384_addcarryx_u32(&x247, &x248, x246, x184, x222);
  fiat_p384_addcarryx_u32(&x249, &x250, x248, x186, x224);
  fiat_p384_addcarryx_u32(&x251, &x252, x250, x188, x226);
  fiat_p384_addcarryx_u32(&x253, &x254, x252, x190, x228);
  fiat_p384_addcarryx_u32(&x255, &x256, x254, x192, x230);
  fiat_p384_addcarryx_u32(&x257, &x258, x256, x194, x232);
  x259 = ((uint32_t)x258 + x195);
  fiat_p384_mulx_u32(&x260, &x261, x2, (arg2[11]));
  fiat_p384_mulx_u32(&x262, &x263, x2, (arg2[10]));
  fiat_p384_mulx_u32(&x264, &x265, x2, (arg2[9]));
  fiat_p384_mulx_u32(&x266, &x267, x2, (arg2[8]));
  fiat_p384_mulx_u32(&x268, &x269, x2, (arg2[7]));
  fiat_p384_mulx_u32(&x270, &x271, x2, (arg2[6]));
  fiat_p384_mulx_u32(&x272, &x273, x2, (arg2[5]));
  fiat_p384_mulx_u32(&x274, &x275, x2, (arg2[4]));
  fiat_p384_mulx_u32(&x276, &x277, x2, (arg2[3]));
  fiat_p384_mulx_u32(&x278, &x279, x2, (arg2[2]));
  fiat_p384_mulx_u32(&x280, &x281, x2, (arg2[1]));
  fiat_p384_mulx_u32(&x282, &x283, x2, (arg2[0]));
  fiat_p384_addcarryx_u32(&x284, &x285, 0x0, x283, x280);
  fiat_p384_addcarryx_u32(&x286, &x287, x285, x281, x278);
  fiat_p384_addcarryx_u32(&x288, &x289, x287, x279, x276);
  fiat_p384_addcarryx_u32(&x290, &x291, x289, x277, x274);
  fiat_p384_addcarryx_u32(&x292, &x293, x291, x275, x272);
  fiat_p384_addcarryx_u32(&x294, &x295, x293, x273, x270);
  fiat_p384_addcarryx_u32(&x296, &x297, x295, x271, x268);
  fiat_p384_addcarryx_u32(&x298, &x299, x297, x269, x266);
  fiat_p384_addcarryx_u32(&x300, &x301, x299, x267, x264);
  fiat_p384_addcarryx_u32(&x302, &x303, x301, x265, x262);
  fiat_p384_addcarryx_u32(&x304, &x305, x303, x263, x260);
  x306 = (x305 + x261);
  fiat_p384_addcarryx_u32(&x307, &x308, 0x0, x235, x282);
  fiat_p384_addcarryx_u32(&x309, &x310, x308, x237, x284);
  fiat_p384_addcarryx_u32(&x311, &x312, x310, x239, x286);
  fiat_p384_addcarryx_u32(&x313, &x314, x312, x241, x288);
  fiat_p384_addcarryx_u32(&x315, &x316, x314, x243, x290);
  fiat_p384_addcarryx_u32(&x317, &x318, x316, x245, x292);
  fiat_p384_addcarryx_u32(&x319, &x320, x318, x247, x294);
  fiat_p384_addcarryx_u32(&x321, &x322, x320, x249, x296);
  fiat_p384_addcarryx_u32(&x323, &x324, x322, x251, x298);
  fiat_p384_addcarryx_u32(&x325, &x326, x324, x253, x300);
  fiat_p384_addcarryx_u32(&x327, &x328, x326, x255, x302);
  fiat_p384_addcarryx_u32(&x329, &x330, x328, x257, x304);
  fiat_p384_addcarryx_u32(&x331, &x332, x330, x259, x306);
  fiat_p384_mulx_u32(&x333, &x334, x307, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x335, &x336, x307, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x337, &x338, x307, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x339, &x340, x307, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x341, &x342, x307, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x343, &x344, x307, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x345, &x346, x307, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x347, &x348, x307, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x349, &x350, x307, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x351, &x352, x307, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x353, &x354, 0x0, x350, x347);
  fiat_p384_addcarryx_u32(&x355, &x356, x354, x348, x345);
  fiat_p384_addcarryx_u32(&x357, &x358, x356, x346, x343);
  fiat_p384_addcarryx_u32(&x359, &x360, x358, x344, x341);
  fiat_p384_addcarryx_u32(&x361, &x362, x360, x342, x339);
  fiat_p384_addcarryx_u32(&x363, &x364, x362, x340, x337);
  fiat_p384_addcarryx_u32(&x365, &x366, x364, x338, x335);
  fiat_p384_addcarryx_u32(&x367, &x368, x366, x336, x333);
  x369 = (x368 + x334);
  fiat_p384_addcarryx_u32(&x370, &x371, 0x0, x307, x351);
  fiat_p384_addcarryx_u32(&x372, &x373, x371, x309, x352);
  fiat_p384_addcarryx_u32(&x374, &x375, x373, x311, 0x0);
  fiat_p384_addcarryx_u32(&x376, &x377, x375, x313, x349);
  fiat_p384_addcarryx_u32(&x378, &x379, x377, x315, x353);
  fiat_p384_addcarryx_u32(&x380, &x381, x379, x317, x355);
  fiat_p384_addcarryx_u32(&x382, &x383, x381, x319, x357);
  fiat_p384_addcarryx_u32(&x384, &x385, x383, x321, x359);
  fiat_p384_addcarryx_u32(&x386, &x387, x385, x323, x361);
  fiat_p384_addcarryx_u32(&x388, &x389, x387, x325, x363);
  fiat_p384_addcarryx_u32(&x390, &x391, x389, x327, x365);
  fiat_p384_addcarryx_u32(&x392, &x393, x391, x329, x367);
  fiat_p384_addcarryx_u32(&x394, &x395, x393, x331, x369);
  x396 = ((uint32_t)x395 + x332);
  fiat_p384_mulx_u32(&x397, &x398, x3, (arg2[11]));
  fiat_p384_mulx_u32(&x399, &x400, x3, (arg2[10]));
  fiat_p384_mulx_u32(&x401, &x402, x3, (arg2[9]));
  fiat_p384_mulx_u32(&x403, &x404, x3, (arg2[8]));
  fiat_p384_mulx_u32(&x405, &x406, x3, (arg2[7]));
  fiat_p384_mulx_u32(&x407, &x408, x3, (arg2[6]));
  fiat_p384_mulx_u32(&x409, &x410, x3, (arg2[5]));
  fiat_p384_mulx_u32(&x411, &x412, x3, (arg2[4]));
  fiat_p384_mulx_u32(&x413, &x414, x3, (arg2[3]));
  fiat_p384_mulx_u32(&x415, &x416, x3, (arg2[2]));
  fiat_p384_mulx_u32(&x417, &x418, x3, (arg2[1]));
  fiat_p384_mulx_u32(&x419, &x420, x3, (arg2[0]));
  fiat_p384_addcarryx_u32(&x421, &x422, 0x0, x420, x417);
  fiat_p384_addcarryx_u32(&x423, &x424, x422, x418, x415);
  fiat_p384_addcarryx_u32(&x425, &x426, x424, x416, x413);
  fiat_p384_addcarryx_u32(&x427, &x428, x426, x414, x411);
  fiat_p384_addcarryx_u32(&x429, &x430, x428, x412, x409);
  fiat_p384_addcarryx_u32(&x431, &x432, x430, x410, x407);
  fiat_p384_addcarryx_u32(&x433, &x434, x432, x408, x405);
  fiat_p384_addcarryx_u32(&x435, &x436, x434, x406, x403);
  fiat_p384_addcarryx_u32(&x437, &x438, x436, x404, x401);
  fiat_p384_addcarryx_u32(&x439, &x440, x438, x402, x399);
  fiat_p384_addcarryx_u32(&x441, &x442, x440, x400, x397);
  x443 = (x442 + x398);
  fiat_p384_addcarryx_u32(&x444, &x445, 0x0, x372, x419);
  fiat_p384_addcarryx_u32(&x446, &x447, x445, x374, x421);
  fiat_p384_addcarryx_u32(&x448, &x449, x447, x376, x423);
  fiat_p384_addcarryx_u32(&x450, &x451, x449, x378, x425);
  fiat_p384_addcarryx_u32(&x452, &x453, x451, x380, x427);
  fiat_p384_addcarryx_u32(&x454, &x455, x453, x382, x429);
  fiat_p384_addcarryx_u32(&x456, &x457, x455, x384, x431);
  fiat_p384_addcarryx_u32(&x458, &x459, x457, x386, x433);
  fiat_p384_addcarryx_u32(&x460, &x461, x459, x388, x435);
  fiat_p384_addcarryx_u32(&x462, &x463, x461, x390, x437);
  fiat_p384_addcarryx_u32(&x464, &x465, x463, x392, x439);
  fiat_p384_addcarryx_u32(&x466, &x467, x465, x394, x441);
  fiat_p384_addcarryx_u32(&x468, &x469, x467, x396, x443);
  fiat_p384_mulx_u32(&x470, &x471, x444, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x472, &x473, x444, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x474, &x475, x444, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x476, &x477, x444, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x478, &x479, x444, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x480, &x481, x444, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x482, &x483, x444, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x484, &x485, x444, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x486, &x487, x444, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x488, &x489, x444, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x490, &x491, 0x0, x487, x484);
  fiat_p384_addcarryx_u32(&x492, &x493, x491, x485, x482);
  fiat_p384_addcarryx_u32(&x494, &x495, x493, x483, x480);
  fiat_p384_addcarryx_u32(&x496, &x497, x495, x481, x478);
  fiat_p384_addcarryx_u32(&x498, &x499, x497, x479, x476);
  fiat_p384_addcarryx_u32(&x500, &x501, x499, x477, x474);
  fiat_p384_addcarryx_u32(&x502, &x503, x501, x475, x472);
  fiat_p384_addcarryx_u32(&x504, &x505, x503, x473, x470);
  x506 = (x505 + x471);
  fiat_p384_addcarryx_u32(&x507, &x508, 0x0, x444, x488);
  fiat_p384_addcarryx_u32(&x509, &x510, x508, x446, x489);
  fiat_p384_addcarryx_u32(&x511, &x512, x510, x448, 0x0);
  fiat_p384_addcarryx_u32(&x513, &x514, x512, x450, x486);
  fiat_p384_addcarryx_u32(&x515, &x516, x514, x452, x490);
  fiat_p384_addcarryx_u32(&x517, &x518, x516, x454, x492);
  fiat_p384_addcarryx_u32(&x519, &x520, x518, x456, x494);
  fiat_p384_addcarryx_u32(&x521, &x522, x520, x458, x496);
  fiat_p384_addcarryx_u32(&x523, &x524, x522, x460, x498);
  fiat_p384_addcarryx_u32(&x525, &x526, x524, x462, x500);
  fiat_p384_addcarryx_u32(&x527, &x528, x526, x464, x502);
  fiat_p384_addcarryx_u32(&x529, &x530, x528, x466, x504);
  fiat_p384_addcarryx_u32(&x531, &x532, x530, x468, x506);
  x533 = ((uint32_t)x532 + x469);
  fiat_p384_mulx_u32(&x534, &x535, x4, (arg2[11]));
  fiat_p384_mulx_u32(&x536, &x537, x4, (arg2[10]));
  fiat_p384_mulx_u32(&x538, &x539, x4, (arg2[9]));
  fiat_p384_mulx_u32(&x540, &x541, x4, (arg2[8]));
  fiat_p384_mulx_u32(&x542, &x543, x4, (arg2[7]));
  fiat_p384_mulx_u32(&x544, &x545, x4, (arg2[6]));
  fiat_p384_mulx_u32(&x546, &x547, x4, (arg2[5]));
  fiat_p384_mulx_u32(&x548, &x549, x4, (arg2[4]));
  fiat_p384_mulx_u32(&x550, &x551, x4, (arg2[3]));
  fiat_p384_mulx_u32(&x552, &x553, x4, (arg2[2]));
  fiat_p384_mulx_u32(&x554, &x555, x4, (arg2[1]));
  fiat_p384_mulx_u32(&x556, &x557, x4, (arg2[0]));
  fiat_p384_addcarryx_u32(&x558, &x559, 0x0, x557, x554);
  fiat_p384_addcarryx_u32(&x560, &x561, x559, x555, x552);
  fiat_p384_addcarryx_u32(&x562, &x563, x561, x553, x550);
  fiat_p384_addcarryx_u32(&x564, &x565, x563, x551, x548);
  fiat_p384_addcarryx_u32(&x566, &x567, x565, x549, x546);
  fiat_p384_addcarryx_u32(&x568, &x569, x567, x547, x544);
  fiat_p384_addcarryx_u32(&x570, &x571, x569, x545, x542);
  fiat_p384_addcarryx_u32(&x572, &x573, x571, x543, x540);
  fiat_p384_addcarryx_u32(&x574, &x575, x573, x541, x538);
  fiat_p384_addcarryx_u32(&x576, &x577, x575, x539, x536);
  fiat_p384_addcarryx_u32(&x578, &x579, x577, x537, x534);
  x580 = (x579 + x535);
  fiat_p384_addcarryx_u32(&x581, &x582, 0x0, x509, x556);
  fiat_p384_addcarryx_u32(&x583, &x584, x582, x511, x558);
  fiat_p384_addcarryx_u32(&x585, &x586, x584, x513, x560);
  fiat_p384_addcarryx_u32(&x587, &x588, x586, x515, x562);
  fiat_p384_addcarryx_u32(&x589, &x590, x588, x517, x564);
  fiat_p384_addcarryx_u32(&x591, &x592, x590, x519, x566);
  fiat_p384_addcarryx_u32(&x593, &x594, x592, x521, x568);
  fiat_p384_addcarryx_u32(&x595, &x596, x594, x523, x570);
  fiat_p384_addcarryx_u32(&x597, &x598, x596, x525, x572);
  fiat_p384_addcarryx_u32(&x599, &x600, x598, x527, x574);
  fiat_p384_addcarryx_u32(&x601, &x602, x600, x529, x576);
  fiat_p384_addcarryx_u32(&x603, &x604, x602, x531, x578);
  fiat_p384_addcarryx_u32(&x605, &x606, x604, x533, x580);
  fiat_p384_mulx_u32(&x607, &x608, x581, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x609, &x610, x581, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x611, &x612, x581, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x613, &x614, x581, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x615, &x616, x581, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x617, &x618, x581, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x619, &x620, x581, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x621, &x622, x581, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x623, &x624, x581, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x625, &x626, x581, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x627, &x628, 0x0, x624, x621);
  fiat_p384_addcarryx_u32(&x629, &x630, x628, x622, x619);
  fiat_p384_addcarryx_u32(&x631, &x632, x630, x620, x617);
  fiat_p384_addcarryx_u32(&x633, &x634, x632, x618, x615);
  fiat_p384_addcarryx_u32(&x635, &x636, x634, x616, x613);
  fiat_p384_addcarryx_u32(&x637, &x638, x636, x614, x611);
  fiat_p384_addcarryx_u32(&x639, &x640, x638, x612, x609);
  fiat_p384_addcarryx_u32(&x641, &x642, x640, x610, x607);
  x643 = (x642 + x608);
  fiat_p384_addcarryx_u32(&x644, &x645, 0x0, x581, x625);
  fiat_p384_addcarryx_u32(&x646, &x647, x645, x583, x626);
  fiat_p384_addcarryx_u32(&x648, &x649, x647, x585, 0x0);
  fiat_p384_addcarryx_u32(&x650, &x651, x649, x587, x623);
  fiat_p384_addcarryx_u32(&x652, &x653, x651, x589, x627);
  fiat_p384_addcarryx_u32(&x654, &x655, x653, x591, x629);
  fiat_p384_addcarryx_u32(&x656, &x657, x655, x593, x631);
  fiat_p384_addcarryx_u32(&x658, &x659, x657, x595, x633);
  fiat_p384_addcarryx_u32(&x660, &x661, x659, x597, x635);
  fiat_p384_addcarryx_u32(&x662, &x663, x661, x599, x637);
  fiat_p384_addcarryx_u32(&x664, &x665, x663, x601, x639);
  fiat_p384_addcarryx_u32(&x666, &x667, x665, x603, x641);
  fiat_p384_addcarryx_u32(&x668, &x669, x667, x605, x643);
  x670 = ((uint32_t)x669 + x606);
  fiat_p384_mulx_u32(&x671, &x672, x5, (arg2[11]));
  fiat_p384_mulx_u32(&x673, &x674, x5, (arg2[10]));
  fiat_p384_mulx_u32(&x675, &x676, x5, (arg2[9]));
  fiat_p384_mulx_u32(&x677, &x678, x5, (arg2[8]));
  fiat_p384_mulx_u32(&x679, &x680, x5, (arg2[7]));
  fiat_p384_mulx_u32(&x681, &x682, x5, (arg2[6]));
  fiat_p384_mulx_u32(&x683, &x684, x5, (arg2[5]));
  fiat_p384_mulx_u32(&x685, &x686, x5, (arg2[4]));
  fiat_p384_mulx_u32(&x687, &x688, x5, (arg2[3]));
  fiat_p384_mulx_u32(&x689, &x690, x5, (arg2[2]));
  fiat_p384_mulx_u32(&x691, &x692, x5, (arg2[1]));
  fiat_p384_mulx_u32(&x693, &x694, x5, (arg2[0]));
  fiat_p384_addcarryx_u32(&x695, &x696, 0x0, x694, x691);
  fiat_p384_addcarryx_u32(&x697, &x698, x696, x692, x689);
  fiat_p384_addcarryx_u32(&x699, &x700, x698, x690, x687);
  fiat_p384_addcarryx_u32(&x701, &x702, x700, x688, x685);
  fiat_p384_addcarryx_u32(&x703, &x704, x702, x686, x683);
  fiat_p384_addcarryx_u32(&x705, &x706, x704, x684, x681);
  fiat_p384_addcarryx_u32(&x707, &x708, x706, x682, x679);
  fiat_p384_addcarryx_u32(&x709, &x710, x708, x680, x677);
  fiat_p384_addcarryx_u32(&x711, &x712, x710, x678, x675);
  fiat_p384_addcarryx_u32(&x713, &x714, x712, x676, x673);
  fiat_p384_addcarryx_u32(&x715, &x716, x714, x674, x671);
  x717 = (x716 + x672);
  fiat_p384_addcarryx_u32(&x718, &x719, 0x0, x646, x693);
  fiat_p384_addcarryx_u32(&x720, &x721, x719, x648, x695);
  fiat_p384_addcarryx_u32(&x722, &x723, x721, x650, x697);
  fiat_p384_addcarryx_u32(&x724, &x725, x723, x652, x699);
  fiat_p384_addcarryx_u32(&x726, &x727, x725, x654, x701);
  fiat_p384_addcarryx_u32(&x728, &x729, x727, x656, x703);
  fiat_p384_addcarryx_u32(&x730, &x731, x729, x658, x705);
  fiat_p384_addcarryx_u32(&x732, &x733, x731, x660, x707);
  fiat_p384_addcarryx_u32(&x734, &x735, x733, x662, x709);
  fiat_p384_addcarryx_u32(&x736, &x737, x735, x664, x711);
  fiat_p384_addcarryx_u32(&x738, &x739, x737, x666, x713);
  fiat_p384_addcarryx_u32(&x740, &x741, x739, x668, x715);
  fiat_p384_addcarryx_u32(&x742, &x743, x741, x670, x717);
  fiat_p384_mulx_u32(&x744, &x745, x718, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x746, &x747, x718, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x748, &x749, x718, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x750, &x751, x718, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x752, &x753, x718, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x754, &x755, x718, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x756, &x757, x718, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x758, &x759, x718, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x760, &x761, x718, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x762, &x763, x718, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x764, &x765, 0x0, x761, x758);
  fiat_p384_addcarryx_u32(&x766, &x767, x765, x759, x756);
  fiat_p384_addcarryx_u32(&x768, &x769, x767, x757, x754);
  fiat_p384_addcarryx_u32(&x770, &x771, x769, x755, x752);
  fiat_p384_addcarryx_u32(&x772, &x773, x771, x753, x750);
  fiat_p384_addcarryx_u32(&x774, &x775, x773, x751, x748);
  fiat_p384_addcarryx_u32(&x776, &x777, x775, x749, x746);
  fiat_p384_addcarryx_u32(&x778, &x779, x777, x747, x744);
  x780 = (x779 + x745);
  fiat_p384_addcarryx_u32(&x781, &x782, 0x0, x718, x762);
  fiat_p384_addcarryx_u32(&x783, &x784, x782, x720, x763);
  fiat_p384_addcarryx_u32(&x785, &x786, x784, x722, 0x0);
  fiat_p384_addcarryx_u32(&x787, &x788, x786, x724, x760);
  fiat_p384_addcarryx_u32(&x789, &x790, x788, x726, x764);
  fiat_p384_addcarryx_u32(&x791, &x792, x790, x728, x766);
  fiat_p384_addcarryx_u32(&x793, &x794, x792, x730, x768);
  fiat_p384_addcarryx_u32(&x795, &x796, x794, x732, x770);
  fiat_p384_addcarryx_u32(&x797, &x798, x796, x734, x772);
  fiat_p384_addcarryx_u32(&x799, &x800, x798, x736, x774);
  fiat_p384_addcarryx_u32(&x801, &x802, x800, x738, x776);
  fiat_p384_addcarryx_u32(&x803, &x804, x802, x740, x778);
  fiat_p384_addcarryx_u32(&x805, &x806, x804, x742, x780);
  x807 = ((uint32_t)x806 + x743);
  fiat_p384_mulx_u32(&x808, &x809, x6, (arg2[11]));
  fiat_p384_mulx_u32(&x810, &x811, x6, (arg2[10]));
  fiat_p384_mulx_u32(&x812, &x813, x6, (arg2[9]));
  fiat_p384_mulx_u32(&x814, &x815, x6, (arg2[8]));
  fiat_p384_mulx_u32(&x816, &x817, x6, (arg2[7]));
  fiat_p384_mulx_u32(&x818, &x819, x6, (arg2[6]));
  fiat_p384_mulx_u32(&x820, &x821, x6, (arg2[5]));
  fiat_p384_mulx_u32(&x822, &x823, x6, (arg2[4]));
  fiat_p384_mulx_u32(&x824, &x825, x6, (arg2[3]));
  fiat_p384_mulx_u32(&x826, &x827, x6, (arg2[2]));
  fiat_p384_mulx_u32(&x828, &x829, x6, (arg2[1]));
  fiat_p384_mulx_u32(&x830, &x831, x6, (arg2[0]));
  fiat_p384_addcarryx_u32(&x832, &x833, 0x0, x831, x828);
  fiat_p384_addcarryx_u32(&x834, &x835, x833, x829, x826);
  fiat_p384_addcarryx_u32(&x836, &x837, x835, x827, x824);
  fiat_p384_addcarryx_u32(&x838, &x839, x837, x825, x822);
  fiat_p384_addcarryx_u32(&x840, &x841, x839, x823, x820);
  fiat_p384_addcarryx_u32(&x842, &x843, x841, x821, x818);
  fiat_p384_addcarryx_u32(&x844, &x845, x843, x819, x816);
  fiat_p384_addcarryx_u32(&x846, &x847, x845, x817, x814);
  fiat_p384_addcarryx_u32(&x848, &x849, x847, x815, x812);
  fiat_p384_addcarryx_u32(&x850, &x851, x849, x813, x810);
  fiat_p384_addcarryx_u32(&x852, &x853, x851, x811, x808);
  x854 = (x853 + x809);
  fiat_p384_addcarryx_u32(&x855, &x856, 0x0, x783, x830);
  fiat_p384_addcarryx_u32(&x857, &x858, x856, x785, x832);
  fiat_p384_addcarryx_u32(&x859, &x860, x858, x787, x834);
  fiat_p384_addcarryx_u32(&x861, &x862, x860, x789, x836);
  fiat_p384_addcarryx_u32(&x863, &x864, x862, x791, x838);
  fiat_p384_addcarryx_u32(&x865, &x866, x864, x793, x840);
  fiat_p384_addcarryx_u32(&x867, &x868, x866, x795, x842);
  fiat_p384_addcarryx_u32(&x869, &x870, x868, x797, x844);
  fiat_p384_addcarryx_u32(&x871, &x872, x870, x799, x846);
  fiat_p384_addcarryx_u32(&x873, &x874, x872, x801, x848);
  fiat_p384_addcarryx_u32(&x875, &x876, x874, x803, x850);
  fiat_p384_addcarryx_u32(&x877, &x878, x876, x805, x852);
  fiat_p384_addcarryx_u32(&x879, &x880, x878, x807, x854);
  fiat_p384_mulx_u32(&x881, &x882, x855, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x883, &x884, x855, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x885, &x886, x855, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x887, &x888, x855, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x889, &x890, x855, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x891, &x892, x855, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x893, &x894, x855, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x895, &x896, x855, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x897, &x898, x855, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x899, &x900, x855, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x901, &x902, 0x0, x898, x895);
  fiat_p384_addcarryx_u32(&x903, &x904, x902, x896, x893);
  fiat_p384_addcarryx_u32(&x905, &x906, x904, x894, x891);
  fiat_p384_addcarryx_u32(&x907, &x908, x906, x892, x889);
  fiat_p384_addcarryx_u32(&x909, &x910, x908, x890, x887);
  fiat_p384_addcarryx_u32(&x911, &x912, x910, x888, x885);
  fiat_p384_addcarryx_u32(&x913, &x914, x912, x886, x883);
  fiat_p384_addcarryx_u32(&x915, &x916, x914, x884, x881);
  x917 = (x916 + x882);
  fiat_p384_addcarryx_u32(&x918, &x919, 0x0, x855, x899);
  fiat_p384_addcarryx_u32(&x920, &x921, x919, x857, x900);
  fiat_p384_addcarryx_u32(&x922, &x923, x921, x859, 0x0);
  fiat_p384_addcarryx_u32(&x924, &x925, x923, x861, x897);
  fiat_p384_addcarryx_u32(&x926, &x927, x925, x863, x901);
  fiat_p384_addcarryx_u32(&x928, &x929, x927, x865, x903);
  fiat_p384_addcarryx_u32(&x930, &x931, x929, x867, x905);
  fiat_p384_addcarryx_u32(&x932, &x933, x931, x869, x907);
  fiat_p384_addcarryx_u32(&x934, &x935, x933, x871, x909);
  fiat_p384_addcarryx_u32(&x936, &x937, x935, x873, x911);
  fiat_p384_addcarryx_u32(&x938, &x939, x937, x875, x913);
  fiat_p384_addcarryx_u32(&x940, &x941, x939, x877, x915);
  fiat_p384_addcarryx_u32(&x942, &x943, x941, x879, x917);
  x944 = ((uint32_t)x943 + x880);
  fiat_p384_mulx_u32(&x945, &x946, x7, (arg2[11]));
  fiat_p384_mulx_u32(&x947, &x948, x7, (arg2[10]));
  fiat_p384_mulx_u32(&x949, &x950, x7, (arg2[9]));
  fiat_p384_mulx_u32(&x951, &x952, x7, (arg2[8]));
  fiat_p384_mulx_u32(&x953, &x954, x7, (arg2[7]));
  fiat_p384_mulx_u32(&x955, &x956, x7, (arg2[6]));
  fiat_p384_mulx_u32(&x957, &x958, x7, (arg2[5]));
  fiat_p384_mulx_u32(&x959, &x960, x7, (arg2[4]));
  fiat_p384_mulx_u32(&x961, &x962, x7, (arg2[3]));
  fiat_p384_mulx_u32(&x963, &x964, x7, (arg2[2]));
  fiat_p384_mulx_u32(&x965, &x966, x7, (arg2[1]));
  fiat_p384_mulx_u32(&x967, &x968, x7, (arg2[0]));
  fiat_p384_addcarryx_u32(&x969, &x970, 0x0, x968, x965);
  fiat_p384_addcarryx_u32(&x971, &x972, x970, x966, x963);
  fiat_p384_addcarryx_u32(&x973, &x974, x972, x964, x961);
  fiat_p384_addcarryx_u32(&x975, &x976, x974, x962, x959);
  fiat_p384_addcarryx_u32(&x977, &x978, x976, x960, x957);
  fiat_p384_addcarryx_u32(&x979, &x980, x978, x958, x955);
  fiat_p384_addcarryx_u32(&x981, &x982, x980, x956, x953);
  fiat_p384_addcarryx_u32(&x983, &x984, x982, x954, x951);
  fiat_p384_addcarryx_u32(&x985, &x986, x984, x952, x949);
  fiat_p384_addcarryx_u32(&x987, &x988, x986, x950, x947);
  fiat_p384_addcarryx_u32(&x989, &x990, x988, x948, x945);
  x991 = (x990 + x946);
  fiat_p384_addcarryx_u32(&x992, &x993, 0x0, x920, x967);
  fiat_p384_addcarryx_u32(&x994, &x995, x993, x922, x969);
  fiat_p384_addcarryx_u32(&x996, &x997, x995, x924, x971);
  fiat_p384_addcarryx_u32(&x998, &x999, x997, x926, x973);
  fiat_p384_addcarryx_u32(&x1000, &x1001, x999, x928, x975);
  fiat_p384_addcarryx_u32(&x1002, &x1003, x1001, x930, x977);
  fiat_p384_addcarryx_u32(&x1004, &x1005, x1003, x932, x979);
  fiat_p384_addcarryx_u32(&x1006, &x1007, x1005, x934, x981);
  fiat_p384_addcarryx_u32(&x1008, &x1009, x1007, x936, x983);
  fiat_p384_addcarryx_u32(&x1010, &x1011, x1009, x938, x985);
  fiat_p384_addcarryx_u32(&x1012, &x1013, x1011, x940, x987);
  fiat_p384_addcarryx_u32(&x1014, &x1015, x1013, x942, x989);
  fiat_p384_addcarryx_u32(&x1016, &x1017, x1015, x944, x991);
  fiat_p384_mulx_u32(&x1018, &x1019, x992, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1020, &x1021, x992, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1022, &x1023, x992, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1024, &x1025, x992, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1026, &x1027, x992, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1028, &x1029, x992, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1030, &x1031, x992, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1032, &x1033, x992, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x1034, &x1035, x992, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1036, &x1037, x992, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x1038, &x1039, 0x0, x1035, x1032);
  fiat_p384_addcarryx_u32(&x1040, &x1041, x1039, x1033, x1030);
  fiat_p384_addcarryx_u32(&x1042, &x1043, x1041, x1031, x1028);
  fiat_p384_addcarryx_u32(&x1044, &x1045, x1043, x1029, x1026);
  fiat_p384_addcarryx_u32(&x1046, &x1047, x1045, x1027, x1024);
  fiat_p384_addcarryx_u32(&x1048, &x1049, x1047, x1025, x1022);
  fiat_p384_addcarryx_u32(&x1050, &x1051, x1049, x1023, x1020);
  fiat_p384_addcarryx_u32(&x1052, &x1053, x1051, x1021, x1018);
  x1054 = (x1053 + x1019);
  fiat_p384_addcarryx_u32(&x1055, &x1056, 0x0, x992, x1036);
  fiat_p384_addcarryx_u32(&x1057, &x1058, x1056, x994, x1037);
  fiat_p384_addcarryx_u32(&x1059, &x1060, x1058, x996, 0x0);
  fiat_p384_addcarryx_u32(&x1061, &x1062, x1060, x998, x1034);
  fiat_p384_addcarryx_u32(&x1063, &x1064, x1062, x1000, x1038);
  fiat_p384_addcarryx_u32(&x1065, &x1066, x1064, x1002, x1040);
  fiat_p384_addcarryx_u32(&x1067, &x1068, x1066, x1004, x1042);
  fiat_p384_addcarryx_u32(&x1069, &x1070, x1068, x1006, x1044);
  fiat_p384_addcarryx_u32(&x1071, &x1072, x1070, x1008, x1046);
  fiat_p384_addcarryx_u32(&x1073, &x1074, x1072, x1010, x1048);
  fiat_p384_addcarryx_u32(&x1075, &x1076, x1074, x1012, x1050);
  fiat_p384_addcarryx_u32(&x1077, &x1078, x1076, x1014, x1052);
  fiat_p384_addcarryx_u32(&x1079, &x1080, x1078, x1016, x1054);
  x1081 = ((uint32_t)x1080 + x1017);
  fiat_p384_mulx_u32(&x1082, &x1083, x8, (arg2[11]));
  fiat_p384_mulx_u32(&x1084, &x1085, x8, (arg2[10]));
  fiat_p384_mulx_u32(&x1086, &x1087, x8, (arg2[9]));
  fiat_p384_mulx_u32(&x1088, &x1089, x8, (arg2[8]));
  fiat_p384_mulx_u32(&x1090, &x1091, x8, (arg2[7]));
  fiat_p384_mulx_u32(&x1092, &x1093, x8, (arg2[6]));
  fiat_p384_mulx_u32(&x1094, &x1095, x8, (arg2[5]));
  fiat_p384_mulx_u32(&x1096, &x1097, x8, (arg2[4]));
  fiat_p384_mulx_u32(&x1098, &x1099, x8, (arg2[3]));
  fiat_p384_mulx_u32(&x1100, &x1101, x8, (arg2[2]));
  fiat_p384_mulx_u32(&x1102, &x1103, x8, (arg2[1]));
  fiat_p384_mulx_u32(&x1104, &x1105, x8, (arg2[0]));
  fiat_p384_addcarryx_u32(&x1106, &x1107, 0x0, x1105, x1102);
  fiat_p384_addcarryx_u32(&x1108, &x1109, x1107, x1103, x1100);
  fiat_p384_addcarryx_u32(&x1110, &x1111, x1109, x1101, x1098);
  fiat_p384_addcarryx_u32(&x1112, &x1113, x1111, x1099, x1096);
  fiat_p384_addcarryx_u32(&x1114, &x1115, x1113, x1097, x1094);
  fiat_p384_addcarryx_u32(&x1116, &x1117, x1115, x1095, x1092);
  fiat_p384_addcarryx_u32(&x1118, &x1119, x1117, x1093, x1090);
  fiat_p384_addcarryx_u32(&x1120, &x1121, x1119, x1091, x1088);
  fiat_p384_addcarryx_u32(&x1122, &x1123, x1121, x1089, x1086);
  fiat_p384_addcarryx_u32(&x1124, &x1125, x1123, x1087, x1084);
  fiat_p384_addcarryx_u32(&x1126, &x1127, x1125, x1085, x1082);
  x1128 = (x1127 + x1083);
  fiat_p384_addcarryx_u32(&x1129, &x1130, 0x0, x1057, x1104);
  fiat_p384_addcarryx_u32(&x1131, &x1132, x1130, x1059, x1106);
  fiat_p384_addcarryx_u32(&x1133, &x1134, x1132, x1061, x1108);
  fiat_p384_addcarryx_u32(&x1135, &x1136, x1134, x1063, x1110);
  fiat_p384_addcarryx_u32(&x1137, &x1138, x1136, x1065, x1112);
  fiat_p384_addcarryx_u32(&x1139, &x1140, x1138, x1067, x1114);
  fiat_p384_addcarryx_u32(&x1141, &x1142, x1140, x1069, x1116);
  fiat_p384_addcarryx_u32(&x1143, &x1144, x1142, x1071, x1118);
  fiat_p384_addcarryx_u32(&x1145, &x1146, x1144, x1073, x1120);
  fiat_p384_addcarryx_u32(&x1147, &x1148, x1146, x1075, x1122);
  fiat_p384_addcarryx_u32(&x1149, &x1150, x1148, x1077, x1124);
  fiat_p384_addcarryx_u32(&x1151, &x1152, x1150, x1079, x1126);
  fiat_p384_addcarryx_u32(&x1153, &x1154, x1152, x1081, x1128);
  fiat_p384_mulx_u32(&x1155, &x1156, x1129, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1157, &x1158, x1129, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1159, &x1160, x1129, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1161, &x1162, x1129, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1163, &x1164, x1129, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1165, &x1166, x1129, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1167, &x1168, x1129, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1169, &x1170, x1129, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x1171, &x1172, x1129, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1173, &x1174, x1129, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x1175, &x1176, 0x0, x1172, x1169);
  fiat_p384_addcarryx_u32(&x1177, &x1178, x1176, x1170, x1167);
  fiat_p384_addcarryx_u32(&x1179, &x1180, x1178, x1168, x1165);
  fiat_p384_addcarryx_u32(&x1181, &x1182, x1180, x1166, x1163);
  fiat_p384_addcarryx_u32(&x1183, &x1184, x1182, x1164, x1161);
  fiat_p384_addcarryx_u32(&x1185, &x1186, x1184, x1162, x1159);
  fiat_p384_addcarryx_u32(&x1187, &x1188, x1186, x1160, x1157);
  fiat_p384_addcarryx_u32(&x1189, &x1190, x1188, x1158, x1155);
  x1191 = (x1190 + x1156);
  fiat_p384_addcarryx_u32(&x1192, &x1193, 0x0, x1129, x1173);
  fiat_p384_addcarryx_u32(&x1194, &x1195, x1193, x1131, x1174);
  fiat_p384_addcarryx_u32(&x1196, &x1197, x1195, x1133, 0x0);
  fiat_p384_addcarryx_u32(&x1198, &x1199, x1197, x1135, x1171);
  fiat_p384_addcarryx_u32(&x1200, &x1201, x1199, x1137, x1175);
  fiat_p384_addcarryx_u32(&x1202, &x1203, x1201, x1139, x1177);
  fiat_p384_addcarryx_u32(&x1204, &x1205, x1203, x1141, x1179);
  fiat_p384_addcarryx_u32(&x1206, &x1207, x1205, x1143, x1181);
  fiat_p384_addcarryx_u32(&x1208, &x1209, x1207, x1145, x1183);
  fiat_p384_addcarryx_u32(&x1210, &x1211, x1209, x1147, x1185);
  fiat_p384_addcarryx_u32(&x1212, &x1213, x1211, x1149, x1187);
  fiat_p384_addcarryx_u32(&x1214, &x1215, x1213, x1151, x1189);
  fiat_p384_addcarryx_u32(&x1216, &x1217, x1215, x1153, x1191);
  x1218 = ((uint32_t)x1217 + x1154);
  fiat_p384_mulx_u32(&x1219, &x1220, x9, (arg2[11]));
  fiat_p384_mulx_u32(&x1221, &x1222, x9, (arg2[10]));
  fiat_p384_mulx_u32(&x1223, &x1224, x9, (arg2[9]));
  fiat_p384_mulx_u32(&x1225, &x1226, x9, (arg2[8]));
  fiat_p384_mulx_u32(&x1227, &x1228, x9, (arg2[7]));
  fiat_p384_mulx_u32(&x1229, &x1230, x9, (arg2[6]));
  fiat_p384_mulx_u32(&x1231, &x1232, x9, (arg2[5]));
  fiat_p384_mulx_u32(&x1233, &x1234, x9, (arg2[4]));
  fiat_p384_mulx_u32(&x1235, &x1236, x9, (arg2[3]));
  fiat_p384_mulx_u32(&x1237, &x1238, x9, (arg2[2]));
  fiat_p384_mulx_u32(&x1239, &x1240, x9, (arg2[1]));
  fiat_p384_mulx_u32(&x1241, &x1242, x9, (arg2[0]));
  fiat_p384_addcarryx_u32(&x1243, &x1244, 0x0, x1242, x1239);
  fiat_p384_addcarryx_u32(&x1245, &x1246, x1244, x1240, x1237);
  fiat_p384_addcarryx_u32(&x1247, &x1248, x1246, x1238, x1235);
  fiat_p384_addcarryx_u32(&x1249, &x1250, x1248, x1236, x1233);
  fiat_p384_addcarryx_u32(&x1251, &x1252, x1250, x1234, x1231);
  fiat_p384_addcarryx_u32(&x1253, &x1254, x1252, x1232, x1229);
  fiat_p384_addcarryx_u32(&x1255, &x1256, x1254, x1230, x1227);
  fiat_p384_addcarryx_u32(&x1257, &x1258, x1256, x1228, x1225);
  fiat_p384_addcarryx_u32(&x1259, &x1260, x1258, x1226, x1223);
  fiat_p384_addcarryx_u32(&x1261, &x1262, x1260, x1224, x1221);
  fiat_p384_addcarryx_u32(&x1263, &x1264, x1262, x1222, x1219);
  x1265 = (x1264 + x1220);
  fiat_p384_addcarryx_u32(&x1266, &x1267, 0x0, x1194, x1241);
  fiat_p384_addcarryx_u32(&x1268, &x1269, x1267, x1196, x1243);
  fiat_p384_addcarryx_u32(&x1270, &x1271, x1269, x1198, x1245);
  fiat_p384_addcarryx_u32(&x1272, &x1273, x1271, x1200, x1247);
  fiat_p384_addcarryx_u32(&x1274, &x1275, x1273, x1202, x1249);
  fiat_p384_addcarryx_u32(&x1276, &x1277, x1275, x1204, x1251);
  fiat_p384_addcarryx_u32(&x1278, &x1279, x1277, x1206, x1253);
  fiat_p384_addcarryx_u32(&x1280, &x1281, x1279, x1208, x1255);
  fiat_p384_addcarryx_u32(&x1282, &x1283, x1281, x1210, x1257);
  fiat_p384_addcarryx_u32(&x1284, &x1285, x1283, x1212, x1259);
  fiat_p384_addcarryx_u32(&x1286, &x1287, x1285, x1214, x1261);
  fiat_p384_addcarryx_u32(&x1288, &x1289, x1287, x1216, x1263);
  fiat_p384_addcarryx_u32(&x1290, &x1291, x1289, x1218, x1265);
  fiat_p384_mulx_u32(&x1292, &x1293, x1266, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1294, &x1295, x1266, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1296, &x1297, x1266, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1298, &x1299, x1266, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1300, &x1301, x1266, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1302, &x1303, x1266, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1304, &x1305, x1266, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1306, &x1307, x1266, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x1308, &x1309, x1266, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1310, &x1311, x1266, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x1312, &x1313, 0x0, x1309, x1306);
  fiat_p384_addcarryx_u32(&x1314, &x1315, x1313, x1307, x1304);
  fiat_p384_addcarryx_u32(&x1316, &x1317, x1315, x1305, x1302);
  fiat_p384_addcarryx_u32(&x1318, &x1319, x1317, x1303, x1300);
  fiat_p384_addcarryx_u32(&x1320, &x1321, x1319, x1301, x1298);
  fiat_p384_addcarryx_u32(&x1322, &x1323, x1321, x1299, x1296);
  fiat_p384_addcarryx_u32(&x1324, &x1325, x1323, x1297, x1294);
  fiat_p384_addcarryx_u32(&x1326, &x1327, x1325, x1295, x1292);
  x1328 = (x1327 + x1293);
  fiat_p384_addcarryx_u32(&x1329, &x1330, 0x0, x1266, x1310);
  fiat_p384_addcarryx_u32(&x1331, &x1332, x1330, x1268, x1311);
  fiat_p384_addcarryx_u32(&x1333, &x1334, x1332, x1270, 0x0);
  fiat_p384_addcarryx_u32(&x1335, &x1336, x1334, x1272, x1308);
  fiat_p384_addcarryx_u32(&x1337, &x1338, x1336, x1274, x1312);
  fiat_p384_addcarryx_u32(&x1339, &x1340, x1338, x1276, x1314);
  fiat_p384_addcarryx_u32(&x1341, &x1342, x1340, x1278, x1316);
  fiat_p384_addcarryx_u32(&x1343, &x1344, x1342, x1280, x1318);
  fiat_p384_addcarryx_u32(&x1345, &x1346, x1344, x1282, x1320);
  fiat_p384_addcarryx_u32(&x1347, &x1348, x1346, x1284, x1322);
  fiat_p384_addcarryx_u32(&x1349, &x1350, x1348, x1286, x1324);
  fiat_p384_addcarryx_u32(&x1351, &x1352, x1350, x1288, x1326);
  fiat_p384_addcarryx_u32(&x1353, &x1354, x1352, x1290, x1328);
  x1355 = ((uint32_t)x1354 + x1291);
  fiat_p384_mulx_u32(&x1356, &x1357, x10, (arg2[11]));
  fiat_p384_mulx_u32(&x1358, &x1359, x10, (arg2[10]));
  fiat_p384_mulx_u32(&x1360, &x1361, x10, (arg2[9]));
  fiat_p384_mulx_u32(&x1362, &x1363, x10, (arg2[8]));
  fiat_p384_mulx_u32(&x1364, &x1365, x10, (arg2[7]));
  fiat_p384_mulx_u32(&x1366, &x1367, x10, (arg2[6]));
  fiat_p384_mulx_u32(&x1368, &x1369, x10, (arg2[5]));
  fiat_p384_mulx_u32(&x1370, &x1371, x10, (arg2[4]));
  fiat_p384_mulx_u32(&x1372, &x1373, x10, (arg2[3]));
  fiat_p384_mulx_u32(&x1374, &x1375, x10, (arg2[2]));
  fiat_p384_mulx_u32(&x1376, &x1377, x10, (arg2[1]));
  fiat_p384_mulx_u32(&x1378, &x1379, x10, (arg2[0]));
  fiat_p384_addcarryx_u32(&x1380, &x1381, 0x0, x1379, x1376);
  fiat_p384_addcarryx_u32(&x1382, &x1383, x1381, x1377, x1374);
  fiat_p384_addcarryx_u32(&x1384, &x1385, x1383, x1375, x1372);
  fiat_p384_addcarryx_u32(&x1386, &x1387, x1385, x1373, x1370);
  fiat_p384_addcarryx_u32(&x1388, &x1389, x1387, x1371, x1368);
  fiat_p384_addcarryx_u32(&x1390, &x1391, x1389, x1369, x1366);
  fiat_p384_addcarryx_u32(&x1392, &x1393, x1391, x1367, x1364);
  fiat_p384_addcarryx_u32(&x1394, &x1395, x1393, x1365, x1362);
  fiat_p384_addcarryx_u32(&x1396, &x1397, x1395, x1363, x1360);
  fiat_p384_addcarryx_u32(&x1398, &x1399, x1397, x1361, x1358);
  fiat_p384_addcarryx_u32(&x1400, &x1401, x1399, x1359, x1356);
  x1402 = (x1401 + x1357);
  fiat_p384_addcarryx_u32(&x1403, &x1404, 0x0, x1331, x1378);
  fiat_p384_addcarryx_u32(&x1405, &x1406, x1404, x1333, x1380);
  fiat_p384_addcarryx_u32(&x1407, &x1408, x1406, x1335, x1382);
  fiat_p384_addcarryx_u32(&x1409, &x1410, x1408, x1337, x1384);
  fiat_p384_addcarryx_u32(&x1411, &x1412, x1410, x1339, x1386);
  fiat_p384_addcarryx_u32(&x1413, &x1414, x1412, x1341, x1388);
  fiat_p384_addcarryx_u32(&x1415, &x1416, x1414, x1343, x1390);
  fiat_p384_addcarryx_u32(&x1417, &x1418, x1416, x1345, x1392);
  fiat_p384_addcarryx_u32(&x1419, &x1420, x1418, x1347, x1394);
  fiat_p384_addcarryx_u32(&x1421, &x1422, x1420, x1349, x1396);
  fiat_p384_addcarryx_u32(&x1423, &x1424, x1422, x1351, x1398);
  fiat_p384_addcarryx_u32(&x1425, &x1426, x1424, x1353, x1400);
  fiat_p384_addcarryx_u32(&x1427, &x1428, x1426, x1355, x1402);
  fiat_p384_mulx_u32(&x1429, &x1430, x1403, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1431, &x1432, x1403, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1433, &x1434, x1403, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1435, &x1436, x1403, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1437, &x1438, x1403, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1439, &x1440, x1403, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1441, &x1442, x1403, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1443, &x1444, x1403, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x1445, &x1446, x1403, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1447, &x1448, x1403, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x1449, &x1450, 0x0, x1446, x1443);
  fiat_p384_addcarryx_u32(&x1451, &x1452, x1450, x1444, x1441);
  fiat_p384_addcarryx_u32(&x1453, &x1454, x1452, x1442, x1439);
  fiat_p384_addcarryx_u32(&x1455, &x1456, x1454, x1440, x1437);
  fiat_p384_addcarryx_u32(&x1457, &x1458, x1456, x1438, x1435);
  fiat_p384_addcarryx_u32(&x1459, &x1460, x1458, x1436, x1433);
  fiat_p384_addcarryx_u32(&x1461, &x1462, x1460, x1434, x1431);
  fiat_p384_addcarryx_u32(&x1463, &x1464, x1462, x1432, x1429);
  x1465 = (x1464 + x1430);
  fiat_p384_addcarryx_u32(&x1466, &x1467, 0x0, x1403, x1447);
  fiat_p384_addcarryx_u32(&x1468, &x1469, x1467, x1405, x1448);
  fiat_p384_addcarryx_u32(&x1470, &x1471, x1469, x1407, 0x0);
  fiat_p384_addcarryx_u32(&x1472, &x1473, x1471, x1409, x1445);
  fiat_p384_addcarryx_u32(&x1474, &x1475, x1473, x1411, x1449);
  fiat_p384_addcarryx_u32(&x1476, &x1477, x1475, x1413, x1451);
  fiat_p384_addcarryx_u32(&x1478, &x1479, x1477, x1415, x1453);
  fiat_p384_addcarryx_u32(&x1480, &x1481, x1479, x1417, x1455);
  fiat_p384_addcarryx_u32(&x1482, &x1483, x1481, x1419, x1457);
  fiat_p384_addcarryx_u32(&x1484, &x1485, x1483, x1421, x1459);
  fiat_p384_addcarryx_u32(&x1486, &x1487, x1485, x1423, x1461);
  fiat_p384_addcarryx_u32(&x1488, &x1489, x1487, x1425, x1463);
  fiat_p384_addcarryx_u32(&x1490, &x1491, x1489, x1427, x1465);
  x1492 = ((uint32_t)x1491 + x1428);
  fiat_p384_mulx_u32(&x1493, &x1494, x11, (arg2[11]));
  fiat_p384_mulx_u32(&x1495, &x1496, x11, (arg2[10]));
  fiat_p384_mulx_u32(&x1497, &x1498, x11, (arg2[9]));
  fiat_p384_mulx_u32(&x1499, &x1500, x11, (arg2[8]));
  fiat_p384_mulx_u32(&x1501, &x1502, x11, (arg2[7]));
  fiat_p384_mulx_u32(&x1503, &x1504, x11, (arg2[6]));
  fiat_p384_mulx_u32(&x1505, &x1506, x11, (arg2[5]));
  fiat_p384_mulx_u32(&x1507, &x1508, x11, (arg2[4]));
  fiat_p384_mulx_u32(&x1509, &x1510, x11, (arg2[3]));
  fiat_p384_mulx_u32(&x1511, &x1512, x11, (arg2[2]));
  fiat_p384_mulx_u32(&x1513, &x1514, x11, (arg2[1]));
  fiat_p384_mulx_u32(&x1515, &x1516, x11, (arg2[0]));
  fiat_p384_addcarryx_u32(&x1517, &x1518, 0x0, x1516, x1513);
  fiat_p384_addcarryx_u32(&x1519, &x1520, x1518, x1514, x1511);
  fiat_p384_addcarryx_u32(&x1521, &x1522, x1520, x1512, x1509);
  fiat_p384_addcarryx_u32(&x1523, &x1524, x1522, x1510, x1507);
  fiat_p384_addcarryx_u32(&x1525, &x1526, x1524, x1508, x1505);
  fiat_p384_addcarryx_u32(&x1527, &x1528, x1526, x1506, x1503);
  fiat_p384_addcarryx_u32(&x1529, &x1530, x1528, x1504, x1501);
  fiat_p384_addcarryx_u32(&x1531, &x1532, x1530, x1502, x1499);
  fiat_p384_addcarryx_u32(&x1533, &x1534, x1532, x1500, x1497);
  fiat_p384_addcarryx_u32(&x1535, &x1536, x1534, x1498, x1495);
  fiat_p384_addcarryx_u32(&x1537, &x1538, x1536, x1496, x1493);
  x1539 = (x1538 + x1494);
  fiat_p384_addcarryx_u32(&x1540, &x1541, 0x0, x1468, x1515);
  fiat_p384_addcarryx_u32(&x1542, &x1543, x1541, x1470, x1517);
  fiat_p384_addcarryx_u32(&x1544, &x1545, x1543, x1472, x1519);
  fiat_p384_addcarryx_u32(&x1546, &x1547, x1545, x1474, x1521);
  fiat_p384_addcarryx_u32(&x1548, &x1549, x1547, x1476, x1523);
  fiat_p384_addcarryx_u32(&x1550, &x1551, x1549, x1478, x1525);
  fiat_p384_addcarryx_u32(&x1552, &x1553, x1551, x1480, x1527);
  fiat_p384_addcarryx_u32(&x1554, &x1555, x1553, x1482, x1529);
  fiat_p384_addcarryx_u32(&x1556, &x1557, x1555, x1484, x1531);
  fiat_p384_addcarryx_u32(&x1558, &x1559, x1557, x1486, x1533);
  fiat_p384_addcarryx_u32(&x1560, &x1561, x1559, x1488, x1535);
  fiat_p384_addcarryx_u32(&x1562, &x1563, x1561, x1490, x1537);
  fiat_p384_addcarryx_u32(&x1564, &x1565, x1563, x1492, x1539);
  fiat_p384_mulx_u32(&x1566, &x1567, x1540, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1568, &x1569, x1540, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1570, &x1571, x1540, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1572, &x1573, x1540, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1574, &x1575, x1540, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1576, &x1577, x1540, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1578, &x1579, x1540, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1580, &x1581, x1540, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x1582, &x1583, x1540, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1584, &x1585, x1540, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x1586, &x1587, 0x0, x1583, x1580);
  fiat_p384_addcarryx_u32(&x1588, &x1589, x1587, x1581, x1578);
  fiat_p384_addcarryx_u32(&x1590, &x1591, x1589, x1579, x1576);
  fiat_p384_addcarryx_u32(&x1592, &x1593, x1591, x1577, x1574);
  fiat_p384_addcarryx_u32(&x1594, &x1595, x1593, x1575, x1572);
  fiat_p384_addcarryx_u32(&x1596, &x1597, x1595, x1573, x1570);
  fiat_p384_addcarryx_u32(&x1598, &x1599, x1597, x1571, x1568);
  fiat_p384_addcarryx_u32(&x1600, &x1601, x1599, x1569, x1566);
  x1602 = (x1601 + x1567);
  fiat_p384_addcarryx_u32(&x1603, &x1604, 0x0, x1540, x1584);
  fiat_p384_addcarryx_u32(&x1605, &x1606, x1604, x1542, x1585);
  fiat_p384_addcarryx_u32(&x1607, &x1608, x1606, x1544, 0x0);
  fiat_p384_addcarryx_u32(&x1609, &x1610, x1608, x1546, x1582);
  fiat_p384_addcarryx_u32(&x1611, &x1612, x1610, x1548, x1586);
  fiat_p384_addcarryx_u32(&x1613, &x1614, x1612, x1550, x1588);
  fiat_p384_addcarryx_u32(&x1615, &x1616, x1614, x1552, x1590);
  fiat_p384_addcarryx_u32(&x1617, &x1618, x1616, x1554, x1592);
  fiat_p384_addcarryx_u32(&x1619, &x1620, x1618, x1556, x1594);
  fiat_p384_addcarryx_u32(&x1621, &x1622, x1620, x1558, x1596);
  fiat_p384_addcarryx_u32(&x1623, &x1624, x1622, x1560, x1598);
  fiat_p384_addcarryx_u32(&x1625, &x1626, x1624, x1562, x1600);
  fiat_p384_addcarryx_u32(&x1627, &x1628, x1626, x1564, x1602);
  x1629 = ((uint32_t)x1628 + x1565);
  fiat_p384_subborrowx_u32(&x1630, &x1631, 0x0, x1605, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1632, &x1633, x1631, x1607, 0x0);
  fiat_p384_subborrowx_u32(&x1634, &x1635, x1633, x1609, 0x0);
  fiat_p384_subborrowx_u32(&x1636, &x1637, x1635, x1611, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1638, &x1639, x1637, x1613, UINT32_C(0xfffffffe));
  fiat_p384_subborrowx_u32(&x1640, &x1641, x1639, x1615, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1642, &x1643, x1641, x1617, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1644, &x1645, x1643, x1619, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1646, &x1647, x1645, x1621, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1648, &x1649, x1647, x1623, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1650, &x1651, x1649, x1625, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1652, &x1653, x1651, x1627, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1654, &x1655, x1653, x1629, 0x0);
  fiat_p384_cmovznz_u32(&x1656, x1655, x1630, x1605);
  fiat_p384_cmovznz_u32(&x1657, x1655, x1632, x1607);
  fiat_p384_cmovznz_u32(&x1658, x1655, x1634, x1609);
  fiat_p384_cmovznz_u32(&x1659, x1655, x1636, x1611);
  fiat_p384_cmovznz_u32(&x1660, x1655, x1638, x1613);
  fiat_p384_cmovznz_u32(&x1661, x1655, x1640, x1615);
  fiat_p384_cmovznz_u32(&x1662, x1655, x1642, x1617);
  fiat_p384_cmovznz_u32(&x1663, x1655, x1644, x1619);
  fiat_p384_cmovznz_u32(&x1664, x1655, x1646, x1621);
  fiat_p384_cmovznz_u32(&x1665, x1655, x1648, x1623);
  fiat_p384_cmovznz_u32(&x1666, x1655, x1650, x1625);
  fiat_p384_cmovznz_u32(&x1667, x1655, x1652, x1627);
  out1[0] = x1656;
  out1[1] = x1657;
  out1[2] = x1658;
  out1[3] = x1659;
  out1[4] = x1660;
  out1[5] = x1661;
  out1[6] = x1662;
  out1[7] = x1663;
  out1[8] = x1664;
  out1[9] = x1665;
  out1[10] = x1666;
  out1[11] = x1667;
}

/*
 * The function fiat_p384_square squares a field element in the Montgomery domain.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_p384_square(fiat_p384_montgomery_domain_field_element out1, const fiat_p384_montgomery_domain_field_element arg1) {
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  uint32_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint32_t x12;
  uint32_t x13;
  uint32_t x14;
  uint32_t x15;
  uint32_t x16;
  uint32_t x17;
  uint32_t x18;
  uint32_t x19;
  uint32_t x20;
  uint32_t x21;
  uint32_t x22;
  uint32_t x23;
  uint32_t x24;
  uint32_t x25;
  uint32_t x26;
  uint32_t x27;
  uint32_t x28;
  uint32_t x29;
  uint32_t x30;
  uint32_t x31;
  uint32_t x32;
  uint32_t x33;
  uint32_t x34;
  uint32_t x35;
  uint32_t x36;
  uint32_t x37;
  fiat_p384_uint1 x38;
  uint32_t x39;
  fiat_p384_uint1 x40;
  uint32_t x41;
  fiat_p384_uint1 x42;
  uint32_t x43;
  fiat_p384_uint1 x44;
  uint32_t x45;
  fiat_p384_uint1 x46;
  uint32_t x47;
  fiat_p384_uint1 x48;
  uint32_t x49;
  fiat_p384_uint1 x50;
  uint32_t x51;
  fiat_p384_uint1 x52;
  uint32_t x53;
  fiat_p384_uint1 x54;
  uint32_t x55;
  fiat_p384_uint1 x56;
  uint32_t x57;
  fiat_p384_uint1 x58;
  uint32_t x59;
  uint32_t x60;
  uint32_t x61;
  uint32_t x62;
  uint32_t x63;
  uint32_t x64;
  uint32_t x65;
  uint32_t x66;
  uint32_t x67;
  uint32_t x68;
  uint32_t x69;
  uint32_t x70;
  uint32_t x71;
  uint32_t x72;
  uint32_t x73;
  uint32_t x74;
  uint32_t x75;
  uint32_t x76;
  uint32_t x77;
  uint32_t x78;
  uint32_t x79;
  uint32_t x80;
  fiat_p384_uint1 x81;
  uint32_t x82;
  fiat_p384_uint1 x83;
  uint32_t x84;
  fiat_p384_uint1 x85;
  uint32_t x86;
  fiat_p384_uint1 x87;
  uint32_t x88;
  fiat_p384_uint1 x89;
  uint32_t x90;
  fiat_p384_uint1 x91;
  uint32_t x92;
  fiat_p384_uint1 x93;
  uint32_t x94;
  fiat_p384_uint1 x95;
  uint32_t x96;
  uint32_t x97;
  fiat_p384_uint1 x98;
  uint32_t x99;
  fiat_p384_uint1 x100;
  uint32_t x101;
  fiat_p384_uint1 x102;
  uint32_t x103;
  fiat_p384_uint1 x104;
  uint32_t x105;
  fiat_p384_uint1 x106;
  uint32_t x107;
  fiat_p384_uint1 x108;
  uint32_t x109;
  fiat_p384_uint1 x110;
  uint32_t x111;
  fiat_p384_uint1 x112;
  uint32_t x113;
  fiat_p384_uint1 x114;
  uint32_t x115;
  fiat_p384_uint1 x116;
  uint32_t x117;
  fiat_p384_uint1 x118;
  uint32_t x119;
  fiat_p384_uint1 x120;
  uint32_t x121;
  fiat_p384_uint1 x122;
  uint32_t x123;
  uint32_t x124;
  uint32_t x125;
  uint32_t x126;
  uint32_t x127;
  uint32_t x128;
  uint32_t x129;
  uint32_t x130;
  uint32_t x131;
  uint32_t x132;
  uint32_t x133;
  uint32_t x134;
  uint32_t x135;
  uint32_t x136;
  uint32_t x137;
  uint32_t x138;
  uint32_t x139;
  uint32_t x140;
  uint32_t x141;
  uint32_t x142;
  uint32_t x143;
  uint32_t x144;
  uint32_t x145;
  uint32_t x146;
  uint32_t x147;
  fiat_p384_uint1 x148;
  uint32_t x149;
  fiat_p384_uint1 x150;
  uint32_t x151;
  fiat_p384_uint1 x152;
  uint32_t x153;
  fiat_p384_uint1 x154;
  uint32_t x155;
  fiat_p384_uint1 x156;
  uint32_t x157;
  fiat_p384_uint1 x158;
  uint32_t x159;
  fiat_p384_uint1 x160;
  uint32_t x161;
  fiat_p384_uint1 x162;
  uint32_t x163;
  fiat_p384_uint1 x164;
  uint32_t x165;
  fiat_p384_uint1 x166;
  uint32_t x167;
  fiat_p384_uint1 x168;
  uint32_t x169;
  uint32_t x170;
  fiat_p384_uint1 x171;
  uint32_t x172;
  fiat_p384_uint1 x173;
  uint32_t x174;
  fiat_p384_uint1 x175;
  uint32_t x176;
  fiat_p384_uint1 x177;
  uint32_t x178;
  fiat_p384_uint1 x179;
  uint32_t x180;
  fiat_p384_uint1 x181;
  uint32_t x182;
  fiat_p384_uint1 x183;
  uint32_t x184;
  fiat_p384_uint1 x185;
  uint32_t x186;
  fiat_p384_uint1 x187;
  uint32_t x188;
  fiat_p384_uint1 x189;
  uint32_t x190;
  fiat_p384_uint1 x191;
  uint32_t x192;
  fiat_p384_uint1 x193;
  uint32_t x194;
  fiat_p384_uint1 x195;
  uint32_t x196;
  uint32_t x197;
  uint32_t x198;
  uint32_t x199;
  uint32_t x200;
  uint32_t x201;
  uint32_t x202;
  uint32_t x203;
  uint32_t x204;
  uint32_t x205;
  uint32_t x206;
  uint32_t x207;
  uint32_t x208;
  uint32_t x209;
  uint32_t x210;
  uint32_t x211;
  uint32_t x212;
  uint32_t x213;
  uint32_t x214;
  uint32_t x215;
  uint32_t x216;
  fiat_p384_uint1 x217;
  uint32_t x218;
  fiat_p384_uint1 x219;
  uint32_t x220;
  fiat_p384_uint1 x221;
  uint32_t x222;
  fiat_p384_uint1 x223;
  uint32_t x224;
  fiat_p384_uint1 x225;
  uint32_t x226;
  fiat_p384_uint1 x227;
  uint32_t x228;
  fiat_p384_uint1 x229;
  uint32_t x230;
  fiat_p384_uint1 x231;
  uint32_t x232;
  uint32_t x233;
  fiat_p384_uint1 x234;
  uint32_t x235;
  fiat_p384_uint1 x236;
  uint32_t x237;
  fiat_p384_uint1 x238;
  uint32_t x239;
  fiat_p384_uint1 x240;
  uint32_t x241;
  fiat_p384_uint1 x242;
  uint32_t x243;
  fiat_p384_uint1 x244;
  uint32_t x245;
  fiat_p384_uint1 x246;
  uint32_t x247;
  fiat_p384_uint1 x248;
  uint32_t x249;
  fiat_p384_uint1 x250;
  uint32_t x251;
  fiat_p384_uint1 x252;
  uint32_t x253;
  fiat_p384_uint1 x254;
  uint32_t x255;
  fiat_p384_uint1 x256;
  uint32_t x257;
  fiat_p384_uint1 x258;
  uint32_t x259;
  uint32_t x260;
  uint32_t x261;
  uint32_t x262;
  uint32_t x263;
  uint32_t x264;
  uint32_t x265;
  uint32_t x266;
  uint32_t x267;
  uint32_t x268;
  uint32_t x269;
  uint32_t x270;
  uint32_t x271;
  uint32_t x272;
  uint32_t x273;
  uint32_t x274;
  uint32_t x275;
  uint32_t x276;
  uint32_t x277;
  uint32_t x278;
  uint32_t x279;
  uint32_t x280;
  uint32_t x281;
  uint32_t x282;
  uint32_t x283;
  uint32_t x284;
  fiat_p384_uint1 x285;
  uint32_t x286;
  fiat_p384_uint1 x287;
  uint32_t x288;
  fiat_p384_uint1 x289;
  uint32_t x290;
  fiat_p384_uint1 x291;
  uint32_t x292;
  fiat_p384_uint1 x293;
  uint32_t x294;
  fiat_p384_uint1 x295;
  uint32_t x296;
  fiat_p384_uint1 x297;
  uint32_t x298;
  fiat_p384_uint1 x299;
  uint32_t x300;
  fiat_p384_uint1 x301;
  uint32_t x302;
  fiat_p384_uint1 x303;
  uint32_t x304;
  fiat_p384_uint1 x305;
  uint32_t x306;
  uint32_t x307;
  fiat_p384_uint1 x308;
  uint32_t x309;
  fiat_p384_uint1 x310;
  uint32_t x311;
  fiat_p384_uint1 x312;
  uint32_t x313;
  fiat_p384_uint1 x314;
  uint32_t x315;
  fiat_p384_uint1 x316;
  uint32_t x317;
  fiat_p384_uint1 x318;
  uint32_t x319;
  fiat_p384_uint1 x320;
  uint32_t x321;
  fiat_p384_uint1 x322;
  uint32_t x323;
  fiat_p384_uint1 x324;
  uint32_t x325;
  fiat_p384_uint1 x326;
  uint32_t x327;
  fiat_p384_uint1 x328;
  uint32_t x329;
  fiat_p384_uint1 x330;
  uint32_t x331;
  fiat_p384_uint1 x332;
  uint32_t x333;
  uint32_t x334;
  uint32_t x335;
  uint32_t x336;
  uint32_t x337;
  uint32_t x338;
  uint32_t x339;
  uint32_t x340;
  uint32_t x341;
  uint32_t x342;
  uint32_t x343;
  uint32_t x344;
  uint32_t x345;
  uint32_t x346;
  uint32_t x347;
  uint32_t x348;
  uint32_t x349;
  uint32_t x350;
  uint32_t x351;
  uint32_t x352;
  uint32_t x353;
  fiat_p384_uint1 x354;
  uint32_t x355;
  fiat_p384_uint1 x356;
  uint32_t x357;
  fiat_p384_uint1 x358;
  uint32_t x359;
  fiat_p384_uint1 x360;
  uint32_t x361;
  fiat_p384_uint1 x362;
  uint32_t x363;
  fiat_p384_uint1 x364;
  uint32_t x365;
  fiat_p384_uint1 x366;
  uint32_t x367;
  fiat_p384_uint1 x368;
  uint32_t x369;
  uint32_t x370;
  fiat_p384_uint1 x371;
  uint32_t x372;
  fiat_p384_uint1 x373;
  uint32_t x374;
  fiat_p384_uint1 x375;
  uint32_t x376;
  fiat_p384_uint1 x377;
  uint32_t x378;
  fiat_p384_uint1 x379;
  uint32_t x380;
  fiat_p384_uint1 x381;
  uint32_t x382;
  fiat_p384_uint1 x383;
  uint32_t x384;
  fiat_p384_uint1 x385;
  uint32_t x386;
  fiat_p384_uint1 x387;
  uint32_t x388;
  fiat_p384_uint1 x389;
  uint32_t x390;
  fiat_p384_uint1 x391;
  uint32_t x392;
  fiat_p384_uint1 x393;
  uint32_t x394;
  fiat_p384_uint1 x395;
  uint32_t x396;
  uint32_t x397;
  uint32_t x398;
  uint32_t x399;
  uint32_t x400;
  uint32_t x401;
  uint32_t x402;
  uint32_t x403;
  uint32_t x404;
  uint32_t x405;
  uint32_t x406;
  uint32_t x407;
  uint32_t x408;
  uint32_t x409;
  uint32_t x410;
  uint32_t x411;
  uint32_t x412;
  uint32_t x413;
  uint32_t x414;
  uint32_t x415;
  uint32_t x416;
  uint32_t x417;
  uint32_t x418;
  uint32_t x419;
  uint32_t x420;
  uint32_t x421;
  fiat_p384_uint1 x422;
  uint32_t x423;
  fiat_p384_uint1 x424;
  uint32_t x425;
  fiat_p384_uint1 x426;
  uint32_t x427;
  fiat_p384_uint1 x428;
  uint32_t x429;
  fiat_p384_uint1 x430;
  uint32_t x431;
  fiat_p384_uint1 x432;
  uint32_t x433;
  fiat_p384_uint1 x434;
  uint32_t x435;
  fiat_p384_uint1 x436;
  uint32_t x437;
  fiat_p384_uint1 x438;
  uint32_t x439;
  fiat_p384_uint1 x440;
  uint32_t x441;
  fiat_p384_uint1 x442;
  uint32_t x443;
  uint32_t x444;
  fiat_p384_uint1 x445;
  uint32_t x446;
  fiat_p384_uint1 x447;
  uint32_t x448;
  fiat_p384_uint1 x449;
  uint32_t x450;
  fiat_p384_uint1 x451;
  uint32_t x452;
  fiat_p384_uint1 x453;
  uint32_t x454;
  fiat_p384_uint1 x455;
  uint32_t x456;
  fiat_p384_uint1 x457;
  uint32_t x458;
  fiat_p384_uint1 x459;
  uint32_t x460;
  fiat_p384_uint1 x461;
  uint32_t x462;
  fiat_p384_uint1 x463;
  uint32_t x464;
  fiat_p384_uint1 x465;
  uint32_t x466;
  fiat_p384_uint1 x467;
  uint32_t x468;
  fiat_p384_uint1 x469;
  uint32_t x470;
  uint32_t x471;
  uint32_t x472;
  uint32_t x473;
  uint32_t x474;
  uint32_t x475;
  uint32_t x476;
  uint32_t x477;
  uint32_t x478;
  uint32_t x479;
  uint32_t x480;
  uint32_t x481;
  uint32_t x482;
  uint32_t x483;
  uint32_t x484;
  uint32_t x485;
  uint32_t x486;
  uint32_t x487;
  uint32_t x488;
  uint32_t x489;
  uint32_t x490;
  fiat_p384_uint1 x491;
  uint32_t x492;
  fiat_p384_uint1 x493;
  uint32_t x494;
  fiat_p384_uint1 x495;
  uint32_t x496;
  fiat_p384_uint1 x497;
  uint32_t x498;
  fiat_p384_uint1 x499;
  uint32_t x500;
  fiat_p384_uint1 x501;
  uint32_t x502;
  fiat_p384_uint1 x503;
  uint32_t x504;
  fiat_p384_uint1 x505;
  uint32_t x506;
  uint32_t x507;
  fiat_p384_uint1 x508;
  uint32_t x509;
  fiat_p384_uint1 x510;
  uint32_t x511;
  fiat_p384_uint1 x512;
  uint32_t x513;
  fiat_p384_uint1 x514;
  uint32_t x515;
  fiat_p384_uint1 x516;
  uint32_t x517;
  fiat_p384_uint1 x518;
  uint32_t x519;
  fiat_p384_uint1 x520;
  uint32_t x521;
  fiat_p384_uint1 x522;
  uint32_t x523;
  fiat_p384_uint1 x524;
  uint32_t x525;
  fiat_p384_uint1 x526;
  uint32_t x527;
  fiat_p384_uint1 x528;
  uint32_t x529;
  fiat_p384_uint1 x530;
  uint32_t x531;
  fiat_p384_uint1 x532;
  uint32_t x533;
  uint32_t x534;
  uint32_t x535;
  uint32_t x536;
  uint32_t x537;
  uint32_t x538;
  uint32_t x539;
  uint32_t x540;
  uint32_t x541;
  uint32_t x542;
  uint32_t x543;
  uint32_t x544;
  uint32_t x545;
  uint32_t x546;
  uint32_t x547;
  uint32_t x548;
  uint32_t x549;
  uint32_t x550;
  uint32_t x551;
  uint32_t x552;
  uint32_t x553;
  uint32_t x554;
  uint32_t x555;
  uint32_t x556;
  uint32_t x557;
  uint32_t x558;
  fiat_p384_uint1 x559;
  uint32_t x560;
  fiat_p384_uint1 x561;
  uint32_t x562;
  fiat_p384_uint1 x563;
  uint32_t x564;
  fiat_p384_uint1 x565;
  uint32_t x566;
  fiat_p384_uint1 x567;
  uint32_t x568;
  fiat_p384_uint1 x569;
  uint32_t x570;
  fiat_p384_uint1 x571;
  uint32_t x572;
  fiat_p384_uint1 x573;
  uint32_t x574;
  fiat_p384_uint1 x575;
  uint32_t x576;
  fiat_p384_uint1 x577;
  uint32_t x578;
  fiat_p384_uint1 x579;
  uint32_t x580;
  uint32_t x581;
  fiat_p384_uint1 x582;
  uint32_t x583;
  fiat_p384_uint1 x584;
  uint32_t x585;
  fiat_p384_uint1 x586;
  uint32_t x587;
  fiat_p384_uint1 x588;
  uint32_t x589;
  fiat_p384_uint1 x590;
  uint32_t x591;
  fiat_p384_uint1 x592;
  uint32_t x593;
  fiat_p384_uint1 x594;
  uint32_t x595;
  fiat_p384_uint1 x596;
  uint32_t x597;
  fiat_p384_uint1 x598;
  uint32_t x599;
  fiat_p384_uint1 x600;
  uint32_t x601;
  fiat_p384_uint1 x602;
  uint32_t x603;
  fiat_p384_uint1 x604;
  uint32_t x605;
  fiat_p384_uint1 x606;
  uint32_t x607;
  uint32_t x608;
  uint32_t x609;
  uint32_t x610;
  uint32_t x611;
  uint32_t x612;
  uint32_t x613;
  uint32_t x614;
  uint32_t x615;
  uint32_t x616;
  uint32_t x617;
  uint32_t x618;
  uint32_t x619;
  uint32_t x620;
  uint32_t x621;
  uint32_t x622;
  uint32_t x623;
  uint32_t x624;
  uint32_t x625;
  uint32_t x626;
  uint32_t x627;
  fiat_p384_uint1 x628;
  uint32_t x629;
  fiat_p384_uint1 x630;
  uint32_t x631;
  fiat_p384_uint1 x632;
  uint32_t x633;
  fiat_p384_uint1 x634;
  uint32_t x635;
  fiat_p384_uint1 x636;
  uint32_t x637;
  fiat_p384_uint1 x638;
  uint32_t x639;
  fiat_p384_uint1 x640;
  uint32_t x641;
  fiat_p384_uint1 x642;
  uint32_t x643;
  uint32_t x644;
  fiat_p384_uint1 x645;
  uint32_t x646;
  fiat_p384_uint1 x647;
  uint32_t x648;
  fiat_p384_uint1 x649;
  uint32_t x650;
  fiat_p384_uint1 x651;
  uint32_t x652;
  fiat_p384_uint1 x653;
  uint32_t x654;
  fiat_p384_uint1 x655;
  uint32_t x656;
  fiat_p384_uint1 x657;
  uint32_t x658;
  fiat_p384_uint1 x659;
  uint32_t x660;
  fiat_p384_uint1 x661;
  uint32_t x662;
  fiat_p384_uint1 x663;
  uint32_t x664;
  fiat_p384_uint1 x665;
  uint32_t x666;
  fiat_p384_uint1 x667;
  uint32_t x668;
  fiat_p384_uint1 x669;
  uint32_t x670;
  uint32_t x671;
  uint32_t x672;
  uint32_t x673;
  uint32_t x674;
  uint32_t x675;
  uint32_t x676;
  uint32_t x677;
  uint32_t x678;
  uint32_t x679;
  uint32_t x680;
  uint32_t x681;
  uint32_t x682;
  uint32_t x683;
  uint32_t x684;
  uint32_t x685;
  uint32_t x686;
  uint32_t x687;
  uint32_t x688;
  uint32_t x689;
  uint32_t x690;
  uint32_t x691;
  uint32_t x692;
  uint32_t x693;
  uint32_t x694;
  uint32_t x695;
  fiat_p384_uint1 x696;
  uint32_t x697;
  fiat_p384_uint1 x698;
  uint32_t x699;
  fiat_p384_uint1 x700;
  uint32_t x701;
  fiat_p384_uint1 x702;
  uint32_t x703;
  fiat_p384_uint1 x704;
  uint32_t x705;
  fiat_p384_uint1 x706;
  uint32_t x707;
  fiat_p384_uint1 x708;
  uint32_t x709;
  fiat_p384_uint1 x710;
  uint32_t x711;
  fiat_p384_uint1 x712;
  uint32_t x713;
  fiat_p384_uint1 x714;
  uint32_t x715;
  fiat_p384_uint1 x716;
  uint32_t x717;
  uint32_t x718;
  fiat_p384_uint1 x719;
  uint32_t x720;
  fiat_p384_uint1 x721;
  uint32_t x722;
  fiat_p384_uint1 x723;
  uint32_t x724;
  fiat_p384_uint1 x725;
  uint32_t x726;
  fiat_p384_uint1 x727;
  uint32_t x728;
  fiat_p384_uint1 x729;
  uint32_t x730;
  fiat_p384_uint1 x731;
  uint32_t x732;
  fiat_p384_uint1 x733;
  uint32_t x734;
  fiat_p384_uint1 x735;
  uint32_t x736;
  fiat_p384_uint1 x737;
  uint32_t x738;
  fiat_p384_uint1 x739;
  uint32_t x740;
  fiat_p384_uint1 x741;
  uint32_t x742;
  fiat_p384_uint1 x743;
  uint32_t x744;
  uint32_t x745;
  uint32_t x746;
  uint32_t x747;
  uint32_t x748;
  uint32_t x749;
  uint32_t x750;
  uint32_t x751;
  uint32_t x752;
  uint32_t x753;
  uint32_t x754;
  uint32_t x755;
  uint32_t x756;
  uint32_t x757;
  uint32_t x758;
  uint32_t x759;
  uint32_t x760;
  uint32_t x761;
  uint32_t x762;
  uint32_t x763;
  uint32_t x764;
  fiat_p384_uint1 x765;
  uint32_t x766;
  fiat_p384_uint1 x767;
  uint32_t x768;
  fiat_p384_uint1 x769;
  uint32_t x770;
  fiat_p384_uint1 x771;
  uint32_t x772;
  fiat_p384_uint1 x773;
  uint32_t x774;
  fiat_p384_uint1 x775;
  uint32_t x776;
  fiat_p384_uint1 x777;
  uint32_t x778;
  fiat_p384_uint1 x779;
  uint32_t x780;
  uint32_t x781;
  fiat_p384_uint1 x782;
  uint32_t x783;
  fiat_p384_uint1 x784;
  uint32_t x785;
  fiat_p384_uint1 x786;
  uint32_t x787;
  fiat_p384_uint1 x788;
  uint32_t x789;
  fiat_p384_uint1 x790;
  uint32_t x791;
  fiat_p384_uint1 x792;
  uint32_t x793;
  fiat_p384_uint1 x794;
  uint32_t x795;
  fiat_p384_uint1 x796;
  uint32_t x797;
  fiat_p384_uint1 x798;
  uint32_t x799;
  fiat_p384_uint1 x800;
  uint32_t x801;
  fiat_p384_uint1 x802;
  uint32_t x803;
  fiat_p384_uint1 x804;
  uint32_t x805;
  fiat_p384_uint1 x806;
  uint32_t x807;
  uint32_t x808;
  uint32_t x809;
  uint32_t x810;
  uint32_t x811;
  uint32_t x812;
  uint32_t x813;
  uint32_t x814;
  uint32_t x815;
  uint32_t x816;
  uint32_t x817;
  uint32_t x818;
  uint32_t x819;
  uint32_t x820;
  uint32_t x821;
  uint32_t x822;
  uint32_t x823;
  uint32_t x824;
  uint32_t x825;
  uint32_t x826;
  uint32_t x827;
  uint32_t x828;
  uint32_t x829;
  uint32_t x830;
  uint32_t x831;
  uint32_t x832;
  fiat_p384_uint1 x833;
  uint32_t x834;
  fiat_p384_uint1 x835;
  uint32_t x836;
  fiat_p384_uint1 x837;
  uint32_t x838;
  fiat_p384_uint1 x839;
  uint32_t x840;
  fiat_p384_uint1 x841;
  uint32_t x842;
  fiat_p384_uint1 x843;
  uint32_t x844;
  fiat_p384_uint1 x845;
  uint32_t x846;
  fiat_p384_uint1 x847;
  uint32_t x848;
  fiat_p384_uint1 x849;
  uint32_t x850;
  fiat_p384_uint1 x851;
  uint32_t x852;
  fiat_p384_uint1 x853;
  uint32_t x854;
  uint32_t x855;
  fiat_p384_uint1 x856;
  uint32_t x857;
  fiat_p384_uint1 x858;
  uint32_t x859;
  fiat_p384_uint1 x860;
  uint32_t x861;
  fiat_p384_uint1 x862;
  uint32_t x863;
  fiat_p384_uint1 x864;
  uint32_t x865;
  fiat_p384_uint1 x866;
  uint32_t x867;
  fiat_p384_uint1 x868;
  uint32_t x869;
  fiat_p384_uint1 x870;
  uint32_t x871;
  fiat_p384_uint1 x872;
  uint32_t x873;
  fiat_p384_uint1 x874;
  uint32_t x875;
  fiat_p384_uint1 x876;
  uint32_t x877;
  fiat_p384_uint1 x878;
  uint32_t x879;
  fiat_p384_uint1 x880;
  uint32_t x881;
  uint32_t x882;
  uint32_t x883;
  uint32_t x884;
  uint32_t x885;
  uint32_t x886;
  uint32_t x887;
  uint32_t x888;
  uint32_t x889;
  uint32_t x890;
  uint32_t x891;
  uint32_t x892;
  uint32_t x893;
  uint32_t x894;
  uint32_t x895;
  uint32_t x896;
  uint32_t x897;
  uint32_t x898;
  uint32_t x899;
  uint32_t x900;
  uint32_t x901;
  fiat_p384_uint1 x902;
  uint32_t x903;
  fiat_p384_uint1 x904;
  uint32_t x905;
  fiat_p384_uint1 x906;
  uint32_t x907;
  fiat_p384_uint1 x908;
  uint32_t x909;
  fiat_p384_uint1 x910;
  uint32_t x911;
  fiat_p384_uint1 x912;
  uint32_t x913;
  fiat_p384_uint1 x914;
  uint32_t x915;
  fiat_p384_uint1 x916;
  uint32_t x917;
  uint32_t x918;
  fiat_p384_uint1 x919;
  uint32_t x920;
  fiat_p384_uint1 x921;
  uint32_t x922;
  fiat_p384_uint1 x923;
  uint32_t x924;
  fiat_p384_uint1 x925;
  uint32_t x926;
  fiat_p384_uint1 x927;
  uint32_t x928;
  fiat_p384_uint1 x929;
  uint32_t x930;
  fiat_p384_uint1 x931;
  uint32_t x932;
  fiat_p384_uint1 x933;
  uint32_t x934;
  fiat_p384_uint1 x935;
  uint32_t x936;
  fiat_p384_uint1 x937;
  uint32_t x938;
  fiat_p384_uint1 x939;
  uint32_t x940;
  fiat_p384_uint1 x941;
  uint32_t x942;
  fiat_p384_uint1 x943;
  uint32_t x944;
  uint32_t x945;
  uint32_t x946;
  uint32_t x947;
  uint32_t x948;
  uint32_t x949;
  uint32_t x950;
  uint32_t x951;
  uint32_t x952;
  uint32_t x953;
  uint32_t x954;
  uint32_t x955;
  uint32_t x956;
  uint32_t x957;
  uint32_t x958;
  uint32_t x959;
  uint32_t x960;
  uint32_t x961;
  uint32_t x962;
  uint32_t x963;
  uint32_t x964;
  uint32_t x965;
  uint32_t x966;
  uint32_t x967;
  uint32_t x968;
  uint32_t x969;
  fiat_p384_uint1 x970;
  uint32_t x971;
  fiat_p384_uint1 x972;
  uint32_t x973;
  fiat_p384_uint1 x974;
  uint32_t x975;
  fiat_p384_uint1 x976;
  uint32_t x977;
  fiat_p384_uint1 x978;
  uint32_t x979;
  fiat_p384_uint1 x980;
  uint32_t x981;
  fiat_p384_uint1 x982;
  uint32_t x983;
  fiat_p384_uint1 x984;
  uint32_t x985;
  fiat_p384_uint1 x986;
  uint32_t x987;
  fiat_p384_uint1 x988;
  uint32_t x989;
  fiat_p384_uint1 x990;
  uint32_t x991;
  uint32_t x992;
  fiat_p384_uint1 x993;
  uint32_t x994;
  fiat_p384_uint1 x995;
  uint32_t x996;
  fiat_p384_uint1 x997;
  uint32_t x998;
  fiat_p384_uint1 x999;
  uint32_t x1000;
  fiat_p384_uint1 x1001;
  uint32_t x1002;
  fiat_p384_uint1 x1003;
  uint32_t x1004;
  fiat_p384_uint1 x1005;
  uint32_t x1006;
  fiat_p384_uint1 x1007;
  uint32_t x1008;
  fiat_p384_uint1 x1009;
  uint32_t x1010;
  fiat_p384_uint1 x1011;
  uint32_t x1012;
  fiat_p384_uint1 x1013;
  uint32_t x1014;
  fiat_p384_uint1 x1015;
  uint32_t x1016;
  fiat_p384_uint1 x1017;
  uint32_t x1018;
  uint32_t x1019;
  uint32_t x1020;
  uint32_t x1021;
  uint32_t x1022;
  uint32_t x1023;
  uint32_t x1024;
  uint32_t x1025;
  uint32_t x1026;
  uint32_t x1027;
  uint32_t x1028;
  uint32_t x1029;
  uint32_t x1030;
  uint32_t x1031;
  uint32_t x1032;
  uint32_t x1033;
  uint32_t x1034;
  uint32_t x1035;
  uint32_t x1036;
  uint32_t x1037;
  uint32_t x1038;
  fiat_p384_uint1 x1039;
  uint32_t x1040;
  fiat_p384_uint1 x1041;
  uint32_t x1042;
  fiat_p384_uint1 x1043;
  uint32_t x1044;
  fiat_p384_uint1 x1045;
  uint32_t x1046;
  fiat_p384_uint1 x1047;
  uint32_t x1048;
  fiat_p384_uint1 x1049;
  uint32_t x1050;
  fiat_p384_uint1 x1051;
  uint32_t x1052;
  fiat_p384_uint1 x1053;
  uint32_t x1054;
  uint32_t x1055;
  fiat_p384_uint1 x1056;
  uint32_t x1057;
  fiat_p384_uint1 x1058;
  uint32_t x1059;
  fiat_p384_uint1 x1060;
  uint32_t x1061;
  fiat_p384_uint1 x1062;
  uint32_t x1063;
  fiat_p384_uint1 x1064;
  uint32_t x1065;
  fiat_p384_uint1 x1066;
  uint32_t x1067;
  fiat_p384_uint1 x1068;
  uint32_t x1069;
  fiat_p384_uint1 x1070;
  uint32_t x1071;
  fiat_p384_uint1 x1072;
  uint32_t x1073;
  fiat_p384_uint1 x1074;
  uint32_t x1075;
  fiat_p384_uint1 x1076;
  uint32_t x1077;
  fiat_p384_uint1 x1078;
  uint32_t x1079;
  fiat_p384_uint1 x1080;
  uint32_t x1081;
  uint32_t x1082;
  uint32_t x1083;
  uint32_t x1084;
  uint32_t x1085;
  uint32_t x1086;
  uint32_t x1087;
  uint32_t x1088;
  uint32_t x1089;
  uint32_t x1090;
  uint32_t x1091;
  uint32_t x1092;
  uint32_t x1093;
  uint32_t x1094;
  uint32_t x1095;
  uint32_t x1096;
  uint32_t x1097;
  uint32_t x1098;
  uint32_t x1099;
  uint32_t x1100;
  uint32_t x1101;
  uint32_t x1102;
  uint32_t x1103;
  uint32_t x1104;
  uint32_t x1105;
  uint32_t x1106;
  fiat_p384_uint1 x1107;
  uint32_t x1108;
  fiat_p384_uint1 x1109;
  uint32_t x1110;
  fiat_p384_uint1 x1111;
  uint32_t x1112;
  fiat_p384_uint1 x1113;
  uint32_t x1114;
  fiat_p384_uint1 x1115;
  uint32_t x1116;
  fiat_p384_uint1 x1117;
  uint32_t x1118;
  fiat_p384_uint1 x1119;
  uint32_t x1120;
  fiat_p384_uint1 x1121;
  uint32_t x1122;
  fiat_p384_uint1 x1123;
  uint32_t x1124;
  fiat_p384_uint1 x1125;
  uint32_t x1126;
  fiat_p384_uint1 x1127;
  uint32_t x1128;
  uint32_t x1129;
  fiat_p384_uint1 x1130;
  uint32_t x1131;
  fiat_p384_uint1 x1132;
  uint32_t x1133;
  fiat_p384_uint1 x1134;
  uint32_t x1135;
  fiat_p384_uint1 x1136;
  uint32_t x1137;
  fiat_p384_uint1 x1138;
  uint32_t x1139;
  fiat_p384_uint1 x1140;
  uint32_t x1141;
  fiat_p384_uint1 x1142;
  uint32_t x1143;
  fiat_p384_uint1 x1144;
  uint32_t x1145;
  fiat_p384_uint1 x1146;
  uint32_t x1147;
  fiat_p384_uint1 x1148;
  uint32_t x1149;
  fiat_p384_uint1 x1150;
  uint32_t x1151;
  fiat_p384_uint1 x1152;
  uint32_t x1153;
  fiat_p384_uint1 x1154;
  uint32_t x1155;
  uint32_t x1156;
  uint32_t x1157;
  uint32_t x1158;
  uint32_t x1159;
  uint32_t x1160;
  uint32_t x1161;
  uint32_t x1162;
  uint32_t x1163;
  uint32_t x1164;
  uint32_t x1165;
  uint32_t x1166;
  uint32_t x1167;
  uint32_t x1168;
  uint32_t x1169;
  uint32_t x1170;
  uint32_t x1171;
  uint32_t x1172;
  uint32_t x1173;
  uint32_t x1174;
  uint32_t x1175;
  fiat_p384_uint1 x1176;
  uint32_t x1177;
  fiat_p384_uint1 x1178;
  uint32_t x1179;
  fiat_p384_uint1 x1180;
  uint32_t x1181;
  fiat_p384_uint1 x1182;
  uint32_t x1183;
  fiat_p384_uint1 x1184;
  uint32_t x1185;
  fiat_p384_uint1 x1186;
  uint32_t x1187;
  fiat_p384_uint1 x1188;
  uint32_t x1189;
  fiat_p384_uint1 x1190;
  uint32_t x1191;
  uint32_t x1192;
  fiat_p384_uint1 x1193;
  uint32_t x1194;
  fiat_p384_uint1 x1195;
  uint32_t x1196;
  fiat_p384_uint1 x1197;
  uint32_t x1198;
  fiat_p384_uint1 x1199;
  uint32_t x1200;
  fiat_p384_uint1 x1201;
  uint32_t x1202;
  fiat_p384_uint1 x1203;
  uint32_t x1204;
  fiat_p384_uint1 x1205;
  uint32_t x1206;
  fiat_p384_uint1 x1207;
  uint32_t x1208;
  fiat_p384_uint1 x1209;
  uint32_t x1210;
  fiat_p384_uint1 x1211;
  uint32_t x1212;
  fiat_p384_uint1 x1213;
  uint32_t x1214;
  fiat_p384_uint1 x1215;
  uint32_t x1216;
  fiat_p384_uint1 x1217;
  uint32_t x1218;
  uint32_t x1219;
  uint32_t x1220;
  uint32_t x1221;
  uint32_t x1222;
  uint32_t x1223;
  uint32_t x1224;
  uint32_t x1225;
  uint32_t x1226;
  uint32_t x1227;
  uint32_t x1228;
  uint32_t x1229;
  uint32_t x1230;
  uint32_t x1231;
  uint32_t x1232;
  uint32_t x1233;
  uint32_t x1234;
  uint32_t x1235;
  uint32_t x1236;
  uint32_t x1237;
  uint32_t x1238;
  uint32_t x1239;
  uint32_t x1240;
  uint32_t x1241;
  uint32_t x1242;
  uint32_t x1243;
  fiat_p384_uint1 x1244;
  uint32_t x1245;
  fiat_p384_uint1 x1246;
  uint32_t x1247;
  fiat_p384_uint1 x1248;
  uint32_t x1249;
  fiat_p384_uint1 x1250;
  uint32_t x1251;
  fiat_p384_uint1 x1252;
  uint32_t x1253;
  fiat_p384_uint1 x1254;
  uint32_t x1255;
  fiat_p384_uint1 x1256;
  uint32_t x1257;
  fiat_p384_uint1 x1258;
  uint32_t x1259;
  fiat_p384_uint1 x1260;
  uint32_t x1261;
  fiat_p384_uint1 x1262;
  uint32_t x1263;
  fiat_p384_uint1 x1264;
  uint32_t x1265;
  uint32_t x1266;
  fiat_p384_uint1 x1267;
  uint32_t x1268;
  fiat_p384_uint1 x1269;
  uint32_t x1270;
  fiat_p384_uint1 x1271;
  uint32_t x1272;
  fiat_p384_uint1 x1273;
  uint32_t x1274;
  fiat_p384_uint1 x1275;
  uint32_t x1276;
  fiat_p384_uint1 x1277;
  uint32_t x1278;
  fiat_p384_uint1 x1279;
  uint32_t x1280;
  fiat_p384_uint1 x1281;
  uint32_t x1282;
  fiat_p384_uint1 x1283;
  uint32_t x1284;
  fiat_p384_uint1 x1285;
  uint32_t x1286;
  fiat_p384_uint1 x1287;
  uint32_t x1288;
  fiat_p384_uint1 x1289;
  uint32_t x1290;
  fiat_p384_uint1 x1291;
  uint32_t x1292;
  uint32_t x1293;
  uint32_t x1294;
  uint32_t x1295;
  uint32_t x1296;
  uint32_t x1297;
  uint32_t x1298;
  uint32_t x1299;
  uint32_t x1300;
  uint32_t x1301;
  uint32_t x1302;
  uint32_t x1303;
  uint32_t x1304;
  uint32_t x1305;
  uint32_t x1306;
  uint32_t x1307;
  uint32_t x1308;
  uint32_t x1309;
  uint32_t x1310;
  uint32_t x1311;
  uint32_t x1312;
  fiat_p384_uint1 x1313;
  uint32_t x1314;
  fiat_p384_uint1 x1315;
  uint32_t x1316;
  fiat_p384_uint1 x1317;
  uint32_t x1318;
  fiat_p384_uint1 x1319;
  uint32_t x1320;
  fiat_p384_uint1 x1321;
  uint32_t x1322;
  fiat_p384_uint1 x1323;
  uint32_t x1324;
  fiat_p384_uint1 x1325;
  uint32_t x1326;
  fiat_p384_uint1 x1327;
  uint32_t x1328;
  uint32_t x1329;
  fiat_p384_uint1 x1330;
  uint32_t x1331;
  fiat_p384_uint1 x1332;
  uint32_t x1333;
  fiat_p384_uint1 x1334;
  uint32_t x1335;
  fiat_p384_uint1 x1336;
  uint32_t x1337;
  fiat_p384_uint1 x1338;
  uint32_t x1339;
  fiat_p384_uint1 x1340;
  uint32_t x1341;
  fiat_p384_uint1 x1342;
  uint32_t x1343;
  fiat_p384_uint1 x1344;
  uint32_t x1345;
  fiat_p384_uint1 x1346;
  uint32_t x1347;
  fiat_p384_uint1 x1348;
  uint32_t x1349;
  fiat_p384_uint1 x1350;
  uint32_t x1351;
  fiat_p384_uint1 x1352;
  uint32_t x1353;
  fiat_p384_uint1 x1354;
  uint32_t x1355;
  uint32_t x1356;
  uint32_t x1357;
  uint32_t x1358;
  uint32_t x1359;
  uint32_t x1360;
  uint32_t x1361;
  uint32_t x1362;
  uint32_t x1363;
  uint32_t x1364;
  uint32_t x1365;
  uint32_t x1366;
  uint32_t x1367;
  uint32_t x1368;
  uint32_t x1369;
  uint32_t x1370;
  uint32_t x1371;
  uint32_t x1372;
  uint32_t x1373;
  uint32_t x1374;
  uint32_t x1375;
  uint32_t x1376;
  uint32_t x1377;
  uint32_t x1378;
  uint32_t x1379;
  uint32_t x1380;
  fiat_p384_uint1 x1381;
  uint32_t x1382;
  fiat_p384_uint1 x1383;
  uint32_t x1384;
  fiat_p384_uint1 x1385;
  uint32_t x1386;
  fiat_p384_uint1 x1387;
  uint32_t x1388;
  fiat_p384_uint1 x1389;
  uint32_t x1390;
  fiat_p384_uint1 x1391;
  uint32_t x1392;
  fiat_p384_uint1 x1393;
  uint32_t x1394;
  fiat_p384_uint1 x1395;
  uint32_t x1396;
  fiat_p384_uint1 x1397;
  uint32_t x1398;
  fiat_p384_uint1 x1399;
  uint32_t x1400;
  fiat_p384_uint1 x1401;
  uint32_t x1402;
  uint32_t x1403;
  fiat_p384_uint1 x1404;
  uint32_t x1405;
  fiat_p384_uint1 x1406;
  uint32_t x1407;
  fiat_p384_uint1 x1408;
  uint32_t x1409;
  fiat_p384_uint1 x1410;
  uint32_t x1411;
  fiat_p384_uint1 x1412;
  uint32_t x1413;
  fiat_p384_uint1 x1414;
  uint32_t x1415;
  fiat_p384_uint1 x1416;
  uint32_t x1417;
  fiat_p384_uint1 x1418;
  uint32_t x1419;
  fiat_p384_uint1 x1420;
  uint32_t x1421;
  fiat_p384_uint1 x1422;
  uint32_t x1423;
  fiat_p384_uint1 x1424;
  uint32_t x1425;
  fiat_p384_uint1 x1426;
  uint32_t x1427;
  fiat_p384_uint1 x1428;
  uint32_t x1429;
  uint32_t x1430;
  uint32_t x1431;
  uint32_t x1432;
  uint32_t x1433;
  uint32_t x1434;
  uint32_t x1435;
  uint32_t x1436;
  uint32_t x1437;
  uint32_t x1438;
  uint32_t x1439;
  uint32_t x1440;
  uint32_t x1441;
  uint32_t x1442;
  uint32_t x1443;
  uint32_t x1444;
  uint32_t x1445;
  uint32_t x1446;
  uint32_t x1447;
  uint32_t x1448;
  uint32_t x1449;
  fiat_p384_uint1 x1450;
  uint32_t x1451;
  fiat_p384_uint1 x1452;
  uint32_t x1453;
  fiat_p384_uint1 x1454;
  uint32_t x1455;
  fiat_p384_uint1 x1456;
  uint32_t x1457;
  fiat_p384_uint1 x1458;
  uint32_t x1459;
  fiat_p384_uint1 x1460;
  uint32_t x1461;
  fiat_p384_uint1 x1462;
  uint32_t x1463;
  fiat_p384_uint1 x1464;
  uint32_t x1465;
  uint32_t x1466;
  fiat_p384_uint1 x1467;
  uint32_t x1468;
  fiat_p384_uint1 x1469;
  uint32_t x1470;
  fiat_p384_uint1 x1471;
  uint32_t x1472;
  fiat_p384_uint1 x1473;
  uint32_t x1474;
  fiat_p384_uint1 x1475;
  uint32_t x1476;
  fiat_p384_uint1 x1477;
  uint32_t x1478;
  fiat_p384_uint1 x1479;
  uint32_t x1480;
  fiat_p384_uint1 x1481;
  uint32_t x1482;
  fiat_p384_uint1 x1483;
  uint32_t x1484;
  fiat_p384_uint1 x1485;
  uint32_t x1486;
  fiat_p384_uint1 x1487;
  uint32_t x1488;
  fiat_p384_uint1 x1489;
  uint32_t x1490;
  fiat_p384_uint1 x1491;
  uint32_t x1492;
  uint32_t x1493;
  uint32_t x1494;
  uint32_t x1495;
  uint32_t x1496;
  uint32_t x1497;
  uint32_t x1498;
  uint32_t x1499;
  uint32_t x1500;
  uint32_t x1501;
  uint32_t x1502;
  uint32_t x1503;
  uint32_t x1504;
  uint32_t x1505;
  uint32_t x1506;
  uint32_t x1507;
  uint32_t x1508;
  uint32_t x1509;
  uint32_t x1510;
  uint32_t x1511;
  uint32_t x1512;
  uint32_t x1513;
  uint32_t x1514;
  uint32_t x1515;
  uint32_t x1516;
  uint32_t x1517;
  fiat_p384_uint1 x1518;
  uint32_t x1519;
  fiat_p384_uint1 x1520;
  uint32_t x1521;
  fiat_p384_uint1 x1522;
  uint32_t x1523;
  fiat_p384_uint1 x1524;
  uint32_t x1525;
  fiat_p384_uint1 x1526;
  uint32_t x1527;
  fiat_p384_uint1 x1528;
  uint32_t x1529;
  fiat_p384_uint1 x1530;
  uint32_t x1531;
  fiat_p384_uint1 x1532;
  uint32_t x1533;
  fiat_p384_uint1 x1534;
  uint32_t x1535;
  fiat_p384_uint1 x1536;
  uint32_t x1537;
  fiat_p384_uint1 x1538;
  uint32_t x1539;
  uint32_t x1540;
  fiat_p384_uint1 x1541;
  uint32_t x1542;
  fiat_p384_uint1 x1543;
  uint32_t x1544;
  fiat_p384_uint1 x1545;
  uint32_t x1546;
  fiat_p384_uint1 x1547;
  uint32_t x1548;
  fiat_p384_uint1 x1549;
  uint32_t x1550;
  fiat_p384_uint1 x1551;
  uint32_t x1552;
  fiat_p384_uint1 x1553;
  uint32_t x1554;
  fiat_p384_uint1 x1555;
  uint32_t x1556;
  fiat_p384_uint1 x1557;
  uint32_t x1558;
  fiat_p384_uint1 x1559;
  uint32_t x1560;
  fiat_p384_uint1 x1561;
  uint32_t x1562;
  fiat_p384_uint1 x1563;
  uint32_t x1564;
  fiat_p384_uint1 x1565;
  uint32_t x1566;
  uint32_t x1567;
  uint32_t x1568;
  uint32_t x1569;
  uint32_t x1570;
  uint32_t x1571;
  uint32_t x1572;
  uint32_t x1573;
  uint32_t x1574;
  uint32_t x1575;
  uint32_t x1576;
  uint32_t x1577;
  uint32_t x1578;
  uint32_t x1579;
  uint32_t x1580;
  uint32_t x1581;
  uint32_t x1582;
  uint32_t x1583;
  uint32_t x1584;
  uint32_t x1585;
  uint32_t x1586;
  fiat_p384_uint1 x1587;
  uint32_t x1588;
  fiat_p384_uint1 x1589;
  uint32_t x1590;
  fiat_p384_uint1 x1591;
  uint32_t x1592;
  fiat_p384_uint1 x1593;
  uint32_t x1594;
  fiat_p384_uint1 x1595;
  uint32_t x1596;
  fiat_p384_uint1 x1597;
  uint32_t x1598;
  fiat_p384_uint1 x1599;
  uint32_t x1600;
  fiat_p384_uint1 x1601;
  uint32_t x1602;
  uint32_t x1603;
  fiat_p384_uint1 x1604;
  uint32_t x1605;
  fiat_p384_uint1 x1606;
  uint32_t x1607;
  fiat_p384_uint1 x1608;
  uint32_t x1609;
  fiat_p384_uint1 x1610;
  uint32_t x1611;
  fiat_p384_uint1 x1612;
  uint32_t x1613;
  fiat_p384_uint1 x1614;
  uint32_t x1615;
  fiat_p384_uint1 x1616;
  uint32_t x1617;
  fiat_p384_uint1 x1618;
  uint32_t x1619;
  fiat_p384_uint1 x1620;
  uint32_t x1621;
  fiat_p384_uint1 x1622;
  uint32_t x1623;
  fiat_p384_uint1 x1624;
  uint32_t x1625;
  fiat_p384_uint1 x1626;
  uint32_t x1627;
  fiat_p384_uint1 x1628;
  uint32_t x1629;
  uint32_t x1630;
  fiat_p384_uint1 x1631;
  uint32_t x1632;
  fiat_p384_uint1 x1633;
  uint32_t x1634;
  fiat_p384_uint1 x1635;
  uint32_t x1636;
  fiat_p384_uint1 x1637;
  uint32_t x1638;
  fiat_p384_uint1 x1639;
  uint32_t x1640;
  fiat_p384_uint1 x1641;
  uint32_t x1642;
  fiat_p384_uint1 x1643;
  uint32_t x1644;
  fiat_p384_uint1 x1645;
  uint32_t x1646;
  fiat_p384_uint1 x1647;
  uint32_t x1648;
  fiat_p384_uint1 x1649;
  uint32_t x1650;
  fiat_p384_uint1 x1651;
  uint32_t x1652;
  fiat_p384_uint1 x1653;
  uint32_t x1654;
  fiat_p384_uint1 x1655;
  uint32_t x1656;
  uint32_t x1657;
  uint32_t x1658;
  uint32_t x1659;
  uint32_t x1660;
  uint32_t x1661;
  uint32_t x1662;
  uint32_t x1663;
  uint32_t x1664;
  uint32_t x1665;
  uint32_t x1666;
  uint32_t x1667;
  x1 = (arg1[1]);
  x2 = (arg1[2]);
  x3 = (arg1[3]);
  x4 = (arg1[4]);
  x5 = (arg1[5]);
  x6 = (arg1[6]);
  x7 = (arg1[7]);
  x8 = (arg1[8]);
  x9 = (arg1[9]);
  x10 = (arg1[10]);
  x11 = (arg1[11]);
  x12 = (arg1[0]);
  fiat_p384_mulx_u32(&x13, &x14, x12, (arg1[11]));
  fiat_p384_mulx_u32(&x15, &x16, x12, (arg1[10]));
  fiat_p384_mulx_u32(&x17, &x18, x12, (arg1[9]));
  fiat_p384_mulx_u32(&x19, &x20, x12, (arg1[8]));
  fiat_p384_mulx_u32(&x21, &x22, x12, (arg1[7]));
  fiat_p384_mulx_u32(&x23, &x24, x12, (arg1[6]));
  fiat_p384_mulx_u32(&x25, &x26, x12, (arg1[5]));
  fiat_p384_mulx_u32(&x27, &x28, x12, (arg1[4]));
  fiat_p384_mulx_u32(&x29, &x30, x12, (arg1[3]));
  fiat_p384_mulx_u32(&x31, &x32, x12, (arg1[2]));
  fiat_p384_mulx_u32(&x33, &x34, x12, (arg1[1]));
  fiat_p384_mulx_u32(&x35, &x36, x12, (arg1[0]));
  fiat_p384_addcarryx_u32(&x37, &x38, 0x0, x36, x33);
  fiat_p384_addcarryx_u32(&x39, &x40, x38, x34, x31);
  fiat_p384_addcarryx_u32(&x41, &x42, x40, x32, x29);
  fiat_p384_addcarryx_u32(&x43, &x44, x42, x30, x27);
  fiat_p384_addcarryx_u32(&x45, &x46, x44, x28, x25);
  fiat_p384_addcarryx_u32(&x47, &x48, x46, x26, x23);
  fiat_p384_addcarryx_u32(&x49, &x50, x48, x24, x21);
  fiat_p384_addcarryx_u32(&x51, &x52, x50, x22, x19);
  fiat_p384_addcarryx_u32(&x53, &x54, x52, x20, x17);
  fiat_p384_addcarryx_u32(&x55, &x56, x54, x18, x15);
  fiat_p384_addcarryx_u32(&x57, &x58, x56, x16, x13);
  x59 = (x58 + x14);
  fiat_p384_mulx_u32(&x60, &x61, x35, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x62, &x63, x35, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x64, &x65, x35, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x66, &x67, x35, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x68, &x69, x35, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x70, &x71, x35, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x72, &x73, x35, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x74, &x75, x35, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x76, &x77, x35, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x78, &x79, x35, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x80, &x81, 0x0, x77, x74);
  fiat_p384_addcarryx_u32(&x82, &x83, x81, x75, x72);
  fiat_p384_addcarryx_u32(&x84, &x85, x83, x73, x70);
  fiat_p384_addcarryx_u32(&x86, &x87, x85, x71, x68);
  fiat_p384_addcarryx_u32(&x88, &x89, x87, x69, x66);
  fiat_p384_addcarryx_u32(&x90, &x91, x89, x67, x64);
  fiat_p384_addcarryx_u32(&x92, &x93, x91, x65, x62);
  fiat_p384_addcarryx_u32(&x94, &x95, x93, x63, x60);
  x96 = (x95 + x61);
  fiat_p384_addcarryx_u32(&x97, &x98, 0x0, x35, x78);
  fiat_p384_addcarryx_u32(&x99, &x100, x98, x37, x79);
  fiat_p384_addcarryx_u32(&x101, &x102, x100, x39, 0x0);
  fiat_p384_addcarryx_u32(&x103, &x104, x102, x41, x76);
  fiat_p384_addcarryx_u32(&x105, &x106, x104, x43, x80);
  fiat_p384_addcarryx_u32(&x107, &x108, x106, x45, x82);
  fiat_p384_addcarryx_u32(&x109, &x110, x108, x47, x84);
  fiat_p384_addcarryx_u32(&x111, &x112, x110, x49, x86);
  fiat_p384_addcarryx_u32(&x113, &x114, x112, x51, x88);
  fiat_p384_addcarryx_u32(&x115, &x116, x114, x53, x90);
  fiat_p384_addcarryx_u32(&x117, &x118, x116, x55, x92);
  fiat_p384_addcarryx_u32(&x119, &x120, x118, x57, x94);
  fiat_p384_addcarryx_u32(&x121, &x122, x120, x59, x96);
  fiat_p384_mulx_u32(&x123, &x124, x1, (arg1[11]));
  fiat_p384_mulx_u32(&x125, &x126, x1, (arg1[10]));
  fiat_p384_mulx_u32(&x127, &x128, x1, (arg1[9]));
  fiat_p384_mulx_u32(&x129, &x130, x1, (arg1[8]));
  fiat_p384_mulx_u32(&x131, &x132, x1, (arg1[7]));
  fiat_p384_mulx_u32(&x133, &x134, x1, (arg1[6]));
  fiat_p384_mulx_u32(&x135, &x136, x1, (arg1[5]));
  fiat_p384_mulx_u32(&x137, &x138, x1, (arg1[4]));
  fiat_p384_mulx_u32(&x139, &x140, x1, (arg1[3]));
  fiat_p384_mulx_u32(&x141, &x142, x1, (arg1[2]));
  fiat_p384_mulx_u32(&x143, &x144, x1, (arg1[1]));
  fiat_p384_mulx_u32(&x145, &x146, x1, (arg1[0]));
  fiat_p384_addcarryx_u32(&x147, &x148, 0x0, x146, x143);
  fiat_p384_addcarryx_u32(&x149, &x150, x148, x144, x141);
  fiat_p384_addcarryx_u32(&x151, &x152, x150, x142, x139);
  fiat_p384_addcarryx_u32(&x153, &x154, x152, x140, x137);
  fiat_p384_addcarryx_u32(&x155, &x156, x154, x138, x135);
  fiat_p384_addcarryx_u32(&x157, &x158, x156, x136, x133);
  fiat_p384_addcarryx_u32(&x159, &x160, x158, x134, x131);
  fiat_p384_addcarryx_u32(&x161, &x162, x160, x132, x129);
  fiat_p384_addcarryx_u32(&x163, &x164, x162, x130, x127);
  fiat_p384_addcarryx_u32(&x165, &x166, x164, x128, x125);
  fiat_p384_addcarryx_u32(&x167, &x168, x166, x126, x123);
  x169 = (x168 + x124);
  fiat_p384_addcarryx_u32(&x170, &x171, 0x0, x99, x145);
  fiat_p384_addcarryx_u32(&x172, &x173, x171, x101, x147);
  fiat_p384_addcarryx_u32(&x174, &x175, x173, x103, x149);
  fiat_p384_addcarryx_u32(&x176, &x177, x175, x105, x151);
  fiat_p384_addcarryx_u32(&x178, &x179, x177, x107, x153);
  fiat_p384_addcarryx_u32(&x180, &x181, x179, x109, x155);
  fiat_p384_addcarryx_u32(&x182, &x183, x181, x111, x157);
  fiat_p384_addcarryx_u32(&x184, &x185, x183, x113, x159);
  fiat_p384_addcarryx_u32(&x186, &x187, x185, x115, x161);
  fiat_p384_addcarryx_u32(&x188, &x189, x187, x117, x163);
  fiat_p384_addcarryx_u32(&x190, &x191, x189, x119, x165);
  fiat_p384_addcarryx_u32(&x192, &x193, x191, x121, x167);
  fiat_p384_addcarryx_u32(&x194, &x195, x193, x122, x169);
  fiat_p384_mulx_u32(&x196, &x197, x170, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x198, &x199, x170, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x200, &x201, x170, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x202, &x203, x170, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x204, &x205, x170, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x206, &x207, x170, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x208, &x209, x170, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x210, &x211, x170, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x212, &x213, x170, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x214, &x215, x170, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x216, &x217, 0x0, x213, x210);
  fiat_p384_addcarryx_u32(&x218, &x219, x217, x211, x208);
  fiat_p384_addcarryx_u32(&x220, &x221, x219, x209, x206);
  fiat_p384_addcarryx_u32(&x222, &x223, x221, x207, x204);
  fiat_p384_addcarryx_u32(&x224, &x225, x223, x205, x202);
  fiat_p384_addcarryx_u32(&x226, &x227, x225, x203, x200);
  fiat_p384_addcarryx_u32(&x228, &x229, x227, x201, x198);
  fiat_p384_addcarryx_u32(&x230, &x231, x229, x199, x196);
  x232 = (x231 + x197);
  fiat_p384_addcarryx_u32(&x233, &x234, 0x0, x170, x214);
  fiat_p384_addcarryx_u32(&x235, &x236, x234, x172, x215);
  fiat_p384_addcarryx_u32(&x237, &x238, x236, x174, 0x0);
  fiat_p384_addcarryx_u32(&x239, &x240, x238, x176, x212);
  fiat_p384_addcarryx_u32(&x241, &x242, x240, x178, x216);
  fiat_p384_addcarryx_u32(&x243, &x244, x242, x180, x218);
  fiat_p384_addcarryx_u32(&x245, &x246, x244, x182, x220);
  fiat_p384_addcarryx_u32(&x247, &x248, x246, x184, x222);
  fiat_p384_addcarryx_u32(&x249, &x250, x248, x186, x224);
  fiat_p384_addcarryx_u32(&x251, &x252, x250, x188, x226);
  fiat_p384_addcarryx_u32(&x253, &x254, x252, x190, x228);
  fiat_p384_addcarryx_u32(&x255, &x256, x254, x192, x230);
  fiat_p384_addcarryx_u32(&x257, &x258, x256, x194, x232);
  x259 = ((uint32_t)x258 + x195);
  fiat_p384_mulx_u32(&x260, &x261, x2, (arg1[11]));
  fiat_p384_mulx_u32(&x262, &x263, x2, (arg1[10]));
  fiat_p384_mulx_u32(&x264, &x265, x2, (arg1[9]));
  fiat_p384_mulx_u32(&x266, &x267, x2, (arg1[8]));
  fiat_p384_mulx_u32(&x268, &x269, x2, (arg1[7]));
  fiat_p384_mulx_u32(&x270, &x271, x2, (arg1[6]));
  fiat_p384_mulx_u32(&x272, &x273, x2, (arg1[5]));
  fiat_p384_mulx_u32(&x274, &x275, x2, (arg1[4]));
  fiat_p384_mulx_u32(&x276, &x277, x2, (arg1[3]));
  fiat_p384_mulx_u32(&x278, &x279, x2, (arg1[2]));
  fiat_p384_mulx_u32(&x280, &x281, x2, (arg1[1]));
  fiat_p384_mulx_u32(&x282, &x283, x2, (arg1[0]));
  fiat_p384_addcarryx_u32(&x284, &x285, 0x0, x283, x280);
  fiat_p384_addcarryx_u32(&x286, &x287, x285, x281, x278);
  fiat_p384_addcarryx_u32(&x288, &x289, x287, x279, x276);
  fiat_p384_addcarryx_u32(&x290, &x291, x289, x277, x274);
  fiat_p384_addcarryx_u32(&x292, &x293, x291, x275, x272);
  fiat_p384_addcarryx_u32(&x294, &x295, x293, x273, x270);
  fiat_p384_addcarryx_u32(&x296, &x297, x295, x271, x268);
  fiat_p384_addcarryx_u32(&x298, &x299, x297, x269, x266);
  fiat_p384_addcarryx_u32(&x300, &x301, x299, x267, x264);
  fiat_p384_addcarryx_u32(&x302, &x303, x301, x265, x262);
  fiat_p384_addcarryx_u32(&x304, &x305, x303, x263, x260);
  x306 = (x305 + x261);
  fiat_p384_addcarryx_u32(&x307, &x308, 0x0, x235, x282);
  fiat_p384_addcarryx_u32(&x309, &x310, x308, x237, x284);
  fiat_p384_addcarryx_u32(&x311, &x312, x310, x239, x286);
  fiat_p384_addcarryx_u32(&x313, &x314, x312, x241, x288);
  fiat_p384_addcarryx_u32(&x315, &x316, x314, x243, x290);
  fiat_p384_addcarryx_u32(&x317, &x318, x316, x245, x292);
  fiat_p384_addcarryx_u32(&x319, &x320, x318, x247, x294);
  fiat_p384_addcarryx_u32(&x321, &x322, x320, x249, x296);
  fiat_p384_addcarryx_u32(&x323, &x324, x322, x251, x298);
  fiat_p384_addcarryx_u32(&x325, &x326, x324, x253, x300);
  fiat_p384_addcarryx_u32(&x327, &x328, x326, x255, x302);
  fiat_p384_addcarryx_u32(&x329, &x330, x328, x257, x304);
  fiat_p384_addcarryx_u32(&x331, &x332, x330, x259, x306);
  fiat_p384_mulx_u32(&x333, &x334, x307, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x335, &x336, x307, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x337, &x338, x307, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x339, &x340, x307, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x341, &x342, x307, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x343, &x344, x307, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x345, &x346, x307, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x347, &x348, x307, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x349, &x350, x307, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x351, &x352, x307, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x353, &x354, 0x0, x350, x347);
  fiat_p384_addcarryx_u32(&x355, &x356, x354, x348, x345);
  fiat_p384_addcarryx_u32(&x357, &x358, x356, x346, x343);
  fiat_p384_addcarryx_u32(&x359, &x360, x358, x344, x341);
  fiat_p384_addcarryx_u32(&x361, &x362, x360, x342, x339);
  fiat_p384_addcarryx_u32(&x363, &x364, x362, x340, x337);
  fiat_p384_addcarryx_u32(&x365, &x366, x364, x338, x335);
  fiat_p384_addcarryx_u32(&x367, &x368, x366, x336, x333);
  x369 = (x368 + x334);
  fiat_p384_addcarryx_u32(&x370, &x371, 0x0, x307, x351);
  fiat_p384_addcarryx_u32(&x372, &x373, x371, x309, x352);
  fiat_p384_addcarryx_u32(&x374, &x375, x373, x311, 0x0);
  fiat_p384_addcarryx_u32(&x376, &x377, x375, x313, x349);
  fiat_p384_addcarryx_u32(&x378, &x379, x377, x315, x353);
  fiat_p384_addcarryx_u32(&x380, &x381, x379, x317, x355);
  fiat_p384_addcarryx_u32(&x382, &x383, x381, x319, x357);
  fiat_p384_addcarryx_u32(&x384, &x385, x383, x321, x359);
  fiat_p384_addcarryx_u32(&x386, &x387, x385, x323, x361);
  fiat_p384_addcarryx_u32(&x388, &x389, x387, x325, x363);
  fiat_p384_addcarryx_u32(&x390, &x391, x389, x327, x365);
  fiat_p384_addcarryx_u32(&x392, &x393, x391, x329, x367);
  fiat_p384_addcarryx_u32(&x394, &x395, x393, x331, x369);
  x396 = ((uint32_t)x395 + x332);
  fiat_p384_mulx_u32(&x397, &x398, x3, (arg1[11]));
  fiat_p384_mulx_u32(&x399, &x400, x3, (arg1[10]));
  fiat_p384_mulx_u32(&x401, &x402, x3, (arg1[9]));
  fiat_p384_mulx_u32(&x403, &x404, x3, (arg1[8]));
  fiat_p384_mulx_u32(&x405, &x406, x3, (arg1[7]));
  fiat_p384_mulx_u32(&x407, &x408, x3, (arg1[6]));
  fiat_p384_mulx_u32(&x409, &x410, x3, (arg1[5]));
  fiat_p384_mulx_u32(&x411, &x412, x3, (arg1[4]));
  fiat_p384_mulx_u32(&x413, &x414, x3, (arg1[3]));
  fiat_p384_mulx_u32(&x415, &x416, x3, (arg1[2]));
  fiat_p384_mulx_u32(&x417, &x418, x3, (arg1[1]));
  fiat_p384_mulx_u32(&x419, &x420, x3, (arg1[0]));
  fiat_p384_addcarryx_u32(&x421, &x422, 0x0, x420, x417);
  fiat_p384_addcarryx_u32(&x423, &x424, x422, x418, x415);
  fiat_p384_addcarryx_u32(&x425, &x426, x424, x416, x413);
  fiat_p384_addcarryx_u32(&x427, &x428, x426, x414, x411);
  fiat_p384_addcarryx_u32(&x429, &x430, x428, x412, x409);
  fiat_p384_addcarryx_u32(&x431, &x432, x430, x410, x407);
  fiat_p384_addcarryx_u32(&x433, &x434, x432, x408, x405);
  fiat_p384_addcarryx_u32(&x435, &x436, x434, x406, x403);
  fiat_p384_addcarryx_u32(&x437, &x438, x436, x404, x401);
  fiat_p384_addcarryx_u32(&x439, &x440, x438, x402, x399);
  fiat_p384_addcarryx_u32(&x441, &x442, x440, x400, x397);
  x443 = (x442 + x398);
  fiat_p384_addcarryx_u32(&x444, &x445, 0x0, x372, x419);
  fiat_p384_addcarryx_u32(&x446, &x447, x445, x374, x421);
  fiat_p384_addcarryx_u32(&x448, &x449, x447, x376, x423);
  fiat_p384_addcarryx_u32(&x450, &x451, x449, x378, x425);
  fiat_p384_addcarryx_u32(&x452, &x453, x451, x380, x427);
  fiat_p384_addcarryx_u32(&x454, &x455, x453, x382, x429);
  fiat_p384_addcarryx_u32(&x456, &x457, x455, x384, x431);
  fiat_p384_addcarryx_u32(&x458, &x459, x457, x386, x433);
  fiat_p384_addcarryx_u32(&x460, &x461, x459, x388, x435);
  fiat_p384_addcarryx_u32(&x462, &x463, x461, x390, x437);
  fiat_p384_addcarryx_u32(&x464, &x465, x463, x392, x439);
  fiat_p384_addcarryx_u32(&x466, &x467, x465, x394, x441);
  fiat_p384_addcarryx_u32(&x468, &x469, x467, x396, x443);
  fiat_p384_mulx_u32(&x470, &x471, x444, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x472, &x473, x444, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x474, &x475, x444, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x476, &x477, x444, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x478, &x479, x444, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x480, &x481, x444, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x482, &x483, x444, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x484, &x485, x444, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x486, &x487, x444, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x488, &x489, x444, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x490, &x491, 0x0, x487, x484);
  fiat_p384_addcarryx_u32(&x492, &x493, x491, x485, x482);
  fiat_p384_addcarryx_u32(&x494, &x495, x493, x483, x480);
  fiat_p384_addcarryx_u32(&x496, &x497, x495, x481, x478);
  fiat_p384_addcarryx_u32(&x498, &x499, x497, x479, x476);
  fiat_p384_addcarryx_u32(&x500, &x501, x499, x477, x474);
  fiat_p384_addcarryx_u32(&x502, &x503, x501, x475, x472);
  fiat_p384_addcarryx_u32(&x504, &x505, x503, x473, x470);
  x506 = (x505 + x471);
  fiat_p384_addcarryx_u32(&x507, &x508, 0x0, x444, x488);
  fiat_p384_addcarryx_u32(&x509, &x510, x508, x446, x489);
  fiat_p384_addcarryx_u32(&x511, &x512, x510, x448, 0x0);
  fiat_p384_addcarryx_u32(&x513, &x514, x512, x450, x486);
  fiat_p384_addcarryx_u32(&x515, &x516, x514, x452, x490);
  fiat_p384_addcarryx_u32(&x517, &x518, x516, x454, x492);
  fiat_p384_addcarryx_u32(&x519, &x520, x518, x456, x494);
  fiat_p384_addcarryx_u32(&x521, &x522, x520, x458, x496);
  fiat_p384_addcarryx_u32(&x523, &x524, x522, x460, x498);
  fiat_p384_addcarryx_u32(&x525, &x526, x524, x462, x500);
  fiat_p384_addcarryx_u32(&x527, &x528, x526, x464, x502);
  fiat_p384_addcarryx_u32(&x529, &x530, x528, x466, x504);
  fiat_p384_addcarryx_u32(&x531, &x532, x530, x468, x506);
  x533 = ((uint32_t)x532 + x469);
  fiat_p384_mulx_u32(&x534, &x535, x4, (arg1[11]));
  fiat_p384_mulx_u32(&x536, &x537, x4, (arg1[10]));
  fiat_p384_mulx_u32(&x538, &x539, x4, (arg1[9]));
  fiat_p384_mulx_u32(&x540, &x541, x4, (arg1[8]));
  fiat_p384_mulx_u32(&x542, &x543, x4, (arg1[7]));
  fiat_p384_mulx_u32(&x544, &x545, x4, (arg1[6]));
  fiat_p384_mulx_u32(&x546, &x547, x4, (arg1[5]));
  fiat_p384_mulx_u32(&x548, &x549, x4, (arg1[4]));
  fiat_p384_mulx_u32(&x550, &x551, x4, (arg1[3]));
  fiat_p384_mulx_u32(&x552, &x553, x4, (arg1[2]));
  fiat_p384_mulx_u32(&x554, &x555, x4, (arg1[1]));
  fiat_p384_mulx_u32(&x556, &x557, x4, (arg1[0]));
  fiat_p384_addcarryx_u32(&x558, &x559, 0x0, x557, x554);
  fiat_p384_addcarryx_u32(&x560, &x561, x559, x555, x552);
  fiat_p384_addcarryx_u32(&x562, &x563, x561, x553, x550);
  fiat_p384_addcarryx_u32(&x564, &x565, x563, x551, x548);
  fiat_p384_addcarryx_u32(&x566, &x567, x565, x549, x546);
  fiat_p384_addcarryx_u32(&x568, &x569, x567, x547, x544);
  fiat_p384_addcarryx_u32(&x570, &x571, x569, x545, x542);
  fiat_p384_addcarryx_u32(&x572, &x573, x571, x543, x540);
  fiat_p384_addcarryx_u32(&x574, &x575, x573, x541, x538);
  fiat_p384_addcarryx_u32(&x576, &x577, x575, x539, x536);
  fiat_p384_addcarryx_u32(&x578, &x579, x577, x537, x534);
  x580 = (x579 + x535);
  fiat_p384_addcarryx_u32(&x581, &x582, 0x0, x509, x556);
  fiat_p384_addcarryx_u32(&x583, &x584, x582, x511, x558);
  fiat_p384_addcarryx_u32(&x585, &x586, x584, x513, x560);
  fiat_p384_addcarryx_u32(&x587, &x588, x586, x515, x562);
  fiat_p384_addcarryx_u32(&x589, &x590, x588, x517, x564);
  fiat_p384_addcarryx_u32(&x591, &x592, x590, x519, x566);
  fiat_p384_addcarryx_u32(&x593, &x594, x592, x521, x568);
  fiat_p384_addcarryx_u32(&x595, &x596, x594, x523, x570);
  fiat_p384_addcarryx_u32(&x597, &x598, x596, x525, x572);
  fiat_p384_addcarryx_u32(&x599, &x600, x598, x527, x574);
  fiat_p384_addcarryx_u32(&x601, &x602, x600, x529, x576);
  fiat_p384_addcarryx_u32(&x603, &x604, x602, x531, x578);
  fiat_p384_addcarryx_u32(&x605, &x606, x604, x533, x580);
  fiat_p384_mulx_u32(&x607, &x608, x581, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x609, &x610, x581, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x611, &x612, x581, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x613, &x614, x581, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x615, &x616, x581, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x617, &x618, x581, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x619, &x620, x581, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x621, &x622, x581, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x623, &x624, x581, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x625, &x626, x581, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x627, &x628, 0x0, x624, x621);
  fiat_p384_addcarryx_u32(&x629, &x630, x628, x622, x619);
  fiat_p384_addcarryx_u32(&x631, &x632, x630, x620, x617);
  fiat_p384_addcarryx_u32(&x633, &x634, x632, x618, x615);
  fiat_p384_addcarryx_u32(&x635, &x636, x634, x616, x613);
  fiat_p384_addcarryx_u32(&x637, &x638, x636, x614, x611);
  fiat_p384_addcarryx_u32(&x639, &x640, x638, x612, x609);
  fiat_p384_addcarryx_u32(&x641, &x642, x640, x610, x607);
  x643 = (x642 + x608);
  fiat_p384_addcarryx_u32(&x644, &x645, 0x0, x581, x625);
  fiat_p384_addcarryx_u32(&x646, &x647, x645, x583, x626);
  fiat_p384_addcarryx_u32(&x648, &x649, x647, x585, 0x0);
  fiat_p384_addcarryx_u32(&x650, &x651, x649, x587, x623);
  fiat_p384_addcarryx_u32(&x652, &x653, x651, x589, x627);
  fiat_p384_addcarryx_u32(&x654, &x655, x653, x591, x629);
  fiat_p384_addcarryx_u32(&x656, &x657, x655, x593, x631);
  fiat_p384_addcarryx_u32(&x658, &x659, x657, x595, x633);
  fiat_p384_addcarryx_u32(&x660, &x661, x659, x597, x635);
  fiat_p384_addcarryx_u32(&x662, &x663, x661, x599, x637);
  fiat_p384_addcarryx_u32(&x664, &x665, x663, x601, x639);
  fiat_p384_addcarryx_u32(&x666, &x667, x665, x603, x641);
  fiat_p384_addcarryx_u32(&x668, &x669, x667, x605, x643);
  x670 = ((uint32_t)x669 + x606);
  fiat_p384_mulx_u32(&x671, &x672, x5, (arg1[11]));
  fiat_p384_mulx_u32(&x673, &x674, x5, (arg1[10]));
  fiat_p384_mulx_u32(&x675, &x676, x5, (arg1[9]));
  fiat_p384_mulx_u32(&x677, &x678, x5, (arg1[8]));
  fiat_p384_mulx_u32(&x679, &x680, x5, (arg1[7]));
  fiat_p384_mulx_u32(&x681, &x682, x5, (arg1[6]));
  fiat_p384_mulx_u32(&x683, &x684, x5, (arg1[5]));
  fiat_p384_mulx_u32(&x685, &x686, x5, (arg1[4]));
  fiat_p384_mulx_u32(&x687, &x688, x5, (arg1[3]));
  fiat_p384_mulx_u32(&x689, &x690, x5, (arg1[2]));
  fiat_p384_mulx_u32(&x691, &x692, x5, (arg1[1]));
  fiat_p384_mulx_u32(&x693, &x694, x5, (arg1[0]));
  fiat_p384_addcarryx_u32(&x695, &x696, 0x0, x694, x691);
  fiat_p384_addcarryx_u32(&x697, &x698, x696, x692, x689);
  fiat_p384_addcarryx_u32(&x699, &x700, x698, x690, x687);
  fiat_p384_addcarryx_u32(&x701, &x702, x700, x688, x685);
  fiat_p384_addcarryx_u32(&x703, &x704, x702, x686, x683);
  fiat_p384_addcarryx_u32(&x705, &x706, x704, x684, x681);
  fiat_p384_addcarryx_u32(&x707, &x708, x706, x682, x679);
  fiat_p384_addcarryx_u32(&x709, &x710, x708, x680, x677);
  fiat_p384_addcarryx_u32(&x711, &x712, x710, x678, x675);
  fiat_p384_addcarryx_u32(&x713, &x714, x712, x676, x673);
  fiat_p384_addcarryx_u32(&x715, &x716, x714, x674, x671);
  x717 = (x716 + x672);
  fiat_p384_addcarryx_u32(&x718, &x719, 0x0, x646, x693);
  fiat_p384_addcarryx_u32(&x720, &x721, x719, x648, x695);
  fiat_p384_addcarryx_u32(&x722, &x723, x721, x650, x697);
  fiat_p384_addcarryx_u32(&x724, &x725, x723, x652, x699);
  fiat_p384_addcarryx_u32(&x726, &x727, x725, x654, x701);
  fiat_p384_addcarryx_u32(&x728, &x729, x727, x656, x703);
  fiat_p384_addcarryx_u32(&x730, &x731, x729, x658, x705);
  fiat_p384_addcarryx_u32(&x732, &x733, x731, x660, x707);
  fiat_p384_addcarryx_u32(&x734, &x735, x733, x662, x709);
  fiat_p384_addcarryx_u32(&x736, &x737, x735, x664, x711);
  fiat_p384_addcarryx_u32(&x738, &x739, x737, x666, x713);
  fiat_p384_addcarryx_u32(&x740, &x741, x739, x668, x715);
  fiat_p384_addcarryx_u32(&x742, &x743, x741, x670, x717);
  fiat_p384_mulx_u32(&x744, &x745, x718, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x746, &x747, x718, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x748, &x749, x718, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x750, &x751, x718, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x752, &x753, x718, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x754, &x755, x718, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x756, &x757, x718, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x758, &x759, x718, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x760, &x761, x718, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x762, &x763, x718, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x764, &x765, 0x0, x761, x758);
  fiat_p384_addcarryx_u32(&x766, &x767, x765, x759, x756);
  fiat_p384_addcarryx_u32(&x768, &x769, x767, x757, x754);
  fiat_p384_addcarryx_u32(&x770, &x771, x769, x755, x752);
  fiat_p384_addcarryx_u32(&x772, &x773, x771, x753, x750);
  fiat_p384_addcarryx_u32(&x774, &x775, x773, x751, x748);
  fiat_p384_addcarryx_u32(&x776, &x777, x775, x749, x746);
  fiat_p384_addcarryx_u32(&x778, &x779, x777, x747, x744);
  x780 = (x779 + x745);
  fiat_p384_addcarryx_u32(&x781, &x782, 0x0, x718, x762);
  fiat_p384_addcarryx_u32(&x783, &x784, x782, x720, x763);
  fiat_p384_addcarryx_u32(&x785, &x786, x784, x722, 0x0);
  fiat_p384_addcarryx_u32(&x787, &x788, x786, x724, x760);
  fiat_p384_addcarryx_u32(&x789, &x790, x788, x726, x764);
  fiat_p384_addcarryx_u32(&x791, &x792, x790, x728, x766);
  fiat_p384_addcarryx_u32(&x793, &x794, x792, x730, x768);
  fiat_p384_addcarryx_u32(&x795, &x796, x794, x732, x770);
  fiat_p384_addcarryx_u32(&x797, &x798, x796, x734, x772);
  fiat_p384_addcarryx_u32(&x799, &x800, x798, x736, x774);
  fiat_p384_addcarryx_u32(&x801, &x802, x800, x738, x776);
  fiat_p384_addcarryx_u32(&x803, &x804, x802, x740, x778);
  fiat_p384_addcarryx_u32(&x805, &x806, x804, x742, x780);
  x807 = ((uint32_t)x806 + x743);
  fiat_p384_mulx_u32(&x808, &x809, x6, (arg1[11]));
  fiat_p384_mulx_u32(&x810, &x811, x6, (arg1[10]));
  fiat_p384_mulx_u32(&x812, &x813, x6, (arg1[9]));
  fiat_p384_mulx_u32(&x814, &x815, x6, (arg1[8]));
  fiat_p384_mulx_u32(&x816, &x817, x6, (arg1[7]));
  fiat_p384_mulx_u32(&x818, &x819, x6, (arg1[6]));
  fiat_p384_mulx_u32(&x820, &x821, x6, (arg1[5]));
  fiat_p384_mulx_u32(&x822, &x823, x6, (arg1[4]));
  fiat_p384_mulx_u32(&x824, &x825, x6, (arg1[3]));
  fiat_p384_mulx_u32(&x826, &x827, x6, (arg1[2]));
  fiat_p384_mulx_u32(&x828, &x829, x6, (arg1[1]));
  fiat_p384_mulx_u32(&x830, &x831, x6, (arg1[0]));
  fiat_p384_addcarryx_u32(&x832, &x833, 0x0, x831, x828);
  fiat_p384_addcarryx_u32(&x834, &x835, x833, x829, x826);
  fiat_p384_addcarryx_u32(&x836, &x837, x835, x827, x824);
  fiat_p384_addcarryx_u32(&x838, &x839, x837, x825, x822);
  fiat_p384_addcarryx_u32(&x840, &x841, x839, x823, x820);
  fiat_p384_addcarryx_u32(&x842, &x843, x841, x821, x818);
  fiat_p384_addcarryx_u32(&x844, &x845, x843, x819, x816);
  fiat_p384_addcarryx_u32(&x846, &x847, x845, x817, x814);
  fiat_p384_addcarryx_u32(&x848, &x849, x847, x815, x812);
  fiat_p384_addcarryx_u32(&x850, &x851, x849, x813, x810);
  fiat_p384_addcarryx_u32(&x852, &x853, x851, x811, x808);
  x854 = (x853 + x809);
  fiat_p384_addcarryx_u32(&x855, &x856, 0x0, x783, x830);
  fiat_p384_addcarryx_u32(&x857, &x858, x856, x785, x832);
  fiat_p384_addcarryx_u32(&x859, &x860, x858, x787, x834);
  fiat_p384_addcarryx_u32(&x861, &x862, x860, x789, x836);
  fiat_p384_addcarryx_u32(&x863, &x864, x862, x791, x838);
  fiat_p384_addcarryx_u32(&x865, &x866, x864, x793, x840);
  fiat_p384_addcarryx_u32(&x867, &x868, x866, x795, x842);
  fiat_p384_addcarryx_u32(&x869, &x870, x868, x797, x844);
  fiat_p384_addcarryx_u32(&x871, &x872, x870, x799, x846);
  fiat_p384_addcarryx_u32(&x873, &x874, x872, x801, x848);
  fiat_p384_addcarryx_u32(&x875, &x876, x874, x803, x850);
  fiat_p384_addcarryx_u32(&x877, &x878, x876, x805, x852);
  fiat_p384_addcarryx_u32(&x879, &x880, x878, x807, x854);
  fiat_p384_mulx_u32(&x881, &x882, x855, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x883, &x884, x855, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x885, &x886, x855, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x887, &x888, x855, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x889, &x890, x855, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x891, &x892, x855, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x893, &x894, x855, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x895, &x896, x855, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x897, &x898, x855, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x899, &x900, x855, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x901, &x902, 0x0, x898, x895);
  fiat_p384_addcarryx_u32(&x903, &x904, x902, x896, x893);
  fiat_p384_addcarryx_u32(&x905, &x906, x904, x894, x891);
  fiat_p384_addcarryx_u32(&x907, &x908, x906, x892, x889);
  fiat_p384_addcarryx_u32(&x909, &x910, x908, x890, x887);
  fiat_p384_addcarryx_u32(&x911, &x912, x910, x888, x885);
  fiat_p384_addcarryx_u32(&x913, &x914, x912, x886, x883);
  fiat_p384_addcarryx_u32(&x915, &x916, x914, x884, x881);
  x917 = (x916 + x882);
  fiat_p384_addcarryx_u32(&x918, &x919, 0x0, x855, x899);
  fiat_p384_addcarryx_u32(&x920, &x921, x919, x857, x900);
  fiat_p384_addcarryx_u32(&x922, &x923, x921, x859, 0x0);
  fiat_p384_addcarryx_u32(&x924, &x925, x923, x861, x897);
  fiat_p384_addcarryx_u32(&x926, &x927, x925, x863, x901);
  fiat_p384_addcarryx_u32(&x928, &x929, x927, x865, x903);
  fiat_p384_addcarryx_u32(&x930, &x931, x929, x867, x905);
  fiat_p384_addcarryx_u32(&x932, &x933, x931, x869, x907);
  fiat_p384_addcarryx_u32(&x934, &x935, x933, x871, x909);
  fiat_p384_addcarryx_u32(&x936, &x937, x935, x873, x911);
  fiat_p384_addcarryx_u32(&x938, &x939, x937, x875, x913);
  fiat_p384_addcarryx_u32(&x940, &x941, x939, x877, x915);
  fiat_p384_addcarryx_u32(&x942, &x943, x941, x879, x917);
  x944 = ((uint32_t)x943 + x880);
  fiat_p384_mulx_u32(&x945, &x946, x7, (arg1[11]));
  fiat_p384_mulx_u32(&x947, &x948, x7, (arg1[10]));
  fiat_p384_mulx_u32(&x949, &x950, x7, (arg1[9]));
  fiat_p384_mulx_u32(&x951, &x952, x7, (arg1[8]));
  fiat_p384_mulx_u32(&x953, &x954, x7, (arg1[7]));
  fiat_p384_mulx_u32(&x955, &x956, x7, (arg1[6]));
  fiat_p384_mulx_u32(&x957, &x958, x7, (arg1[5]));
  fiat_p384_mulx_u32(&x959, &x960, x7, (arg1[4]));
  fiat_p384_mulx_u32(&x961, &x962, x7, (arg1[3]));
  fiat_p384_mulx_u32(&x963, &x964, x7, (arg1[2]));
  fiat_p384_mulx_u32(&x965, &x966, x7, (arg1[1]));
  fiat_p384_mulx_u32(&x967, &x968, x7, (arg1[0]));
  fiat_p384_addcarryx_u32(&x969, &x970, 0x0, x968, x965);
  fiat_p384_addcarryx_u32(&x971, &x972, x970, x966, x963);
  fiat_p384_addcarryx_u32(&x973, &x974, x972, x964, x961);
  fiat_p384_addcarryx_u32(&x975, &x976, x974, x962, x959);
  fiat_p384_addcarryx_u32(&x977, &x978, x976, x960, x957);
  fiat_p384_addcarryx_u32(&x979, &x980, x978, x958, x955);
  fiat_p384_addcarryx_u32(&x981, &x982, x980, x956, x953);
  fiat_p384_addcarryx_u32(&x983, &x984, x982, x954, x951);
  fiat_p384_addcarryx_u32(&x985, &x986, x984, x952, x949);
  fiat_p384_addcarryx_u32(&x987, &x988, x986, x950, x947);
  fiat_p384_addcarryx_u32(&x989, &x990, x988, x948, x945);
  x991 = (x990 + x946);
  fiat_p384_addcarryx_u32(&x992, &x993, 0x0, x920, x967);
  fiat_p384_addcarryx_u32(&x994, &x995, x993, x922, x969);
  fiat_p384_addcarryx_u32(&x996, &x997, x995, x924, x971);
  fiat_p384_addcarryx_u32(&x998, &x999, x997, x926, x973);
  fiat_p384_addcarryx_u32(&x1000, &x1001, x999, x928, x975);
  fiat_p384_addcarryx_u32(&x1002, &x1003, x1001, x930, x977);
  fiat_p384_addcarryx_u32(&x1004, &x1005, x1003, x932, x979);
  fiat_p384_addcarryx_u32(&x1006, &x1007, x1005, x934, x981);
  fiat_p384_addcarryx_u32(&x1008, &x1009, x1007, x936, x983);
  fiat_p384_addcarryx_u32(&x1010, &x1011, x1009, x938, x985);
  fiat_p384_addcarryx_u32(&x1012, &x1013, x1011, x940, x987);
  fiat_p384_addcarryx_u32(&x1014, &x1015, x1013, x942, x989);
  fiat_p384_addcarryx_u32(&x1016, &x1017, x1015, x944, x991);
  fiat_p384_mulx_u32(&x1018, &x1019, x992, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1020, &x1021, x992, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1022, &x1023, x992, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1024, &x1025, x992, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1026, &x1027, x992, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1028, &x1029, x992, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1030, &x1031, x992, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1032, &x1033, x992, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x1034, &x1035, x992, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1036, &x1037, x992, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x1038, &x1039, 0x0, x1035, x1032);
  fiat_p384_addcarryx_u32(&x1040, &x1041, x1039, x1033, x1030);
  fiat_p384_addcarryx_u32(&x1042, &x1043, x1041, x1031, x1028);
  fiat_p384_addcarryx_u32(&x1044, &x1045, x1043, x1029, x1026);
  fiat_p384_addcarryx_u32(&x1046, &x1047, x1045, x1027, x1024);
  fiat_p384_addcarryx_u32(&x1048, &x1049, x1047, x1025, x1022);
  fiat_p384_addcarryx_u32(&x1050, &x1051, x1049, x1023, x1020);
  fiat_p384_addcarryx_u32(&x1052, &x1053, x1051, x1021, x1018);
  x1054 = (x1053 + x1019);
  fiat_p384_addcarryx_u32(&x1055, &x1056, 0x0, x992, x1036);
  fiat_p384_addcarryx_u32(&x1057, &x1058, x1056, x994, x1037);
  fiat_p384_addcarryx_u32(&x1059, &x1060, x1058, x996, 0x0);
  fiat_p384_addcarryx_u32(&x1061, &x1062, x1060, x998, x1034);
  fiat_p384_addcarryx_u32(&x1063, &x1064, x1062, x1000, x1038);
  fiat_p384_addcarryx_u32(&x1065, &x1066, x1064, x1002, x1040);
  fiat_p384_addcarryx_u32(&x1067, &x1068, x1066, x1004, x1042);
  fiat_p384_addcarryx_u32(&x1069, &x1070, x1068, x1006, x1044);
  fiat_p384_addcarryx_u32(&x1071, &x1072, x1070, x1008, x1046);
  fiat_p384_addcarryx_u32(&x1073, &x1074, x1072, x1010, x1048);
  fiat_p384_addcarryx_u32(&x1075, &x1076, x1074, x1012, x1050);
  fiat_p384_addcarryx_u32(&x1077, &x1078, x1076, x1014, x1052);
  fiat_p384_addcarryx_u32(&x1079, &x1080, x1078, x1016, x1054);
  x1081 = ((uint32_t)x1080 + x1017);
  fiat_p384_mulx_u32(&x1082, &x1083, x8, (arg1[11]));
  fiat_p384_mulx_u32(&x1084, &x1085, x8, (arg1[10]));
  fiat_p384_mulx_u32(&x1086, &x1087, x8, (arg1[9]));
  fiat_p384_mulx_u32(&x1088, &x1089, x8, (arg1[8]));
  fiat_p384_mulx_u32(&x1090, &x1091, x8, (arg1[7]));
  fiat_p384_mulx_u32(&x1092, &x1093, x8, (arg1[6]));
  fiat_p384_mulx_u32(&x1094, &x1095, x8, (arg1[5]));
  fiat_p384_mulx_u32(&x1096, &x1097, x8, (arg1[4]));
  fiat_p384_mulx_u32(&x1098, &x1099, x8, (arg1[3]));
  fiat_p384_mulx_u32(&x1100, &x1101, x8, (arg1[2]));
  fiat_p384_mulx_u32(&x1102, &x1103, x8, (arg1[1]));
  fiat_p384_mulx_u32(&x1104, &x1105, x8, (arg1[0]));
  fiat_p384_addcarryx_u32(&x1106, &x1107, 0x0, x1105, x1102);
  fiat_p384_addcarryx_u32(&x1108, &x1109, x1107, x1103, x1100);
  fiat_p384_addcarryx_u32(&x1110, &x1111, x1109, x1101, x1098);
  fiat_p384_addcarryx_u32(&x1112, &x1113, x1111, x1099, x1096);
  fiat_p384_addcarryx_u32(&x1114, &x1115, x1113, x1097, x1094);
  fiat_p384_addcarryx_u32(&x1116, &x1117, x1115, x1095, x1092);
  fiat_p384_addcarryx_u32(&x1118, &x1119, x1117, x1093, x1090);
  fiat_p384_addcarryx_u32(&x1120, &x1121, x1119, x1091, x1088);
  fiat_p384_addcarryx_u32(&x1122, &x1123, x1121, x1089, x1086);
  fiat_p384_addcarryx_u32(&x1124, &x1125, x1123, x1087, x1084);
  fiat_p384_addcarryx_u32(&x1126, &x1127, x1125, x1085, x1082);
  x1128 = (x1127 + x1083);
  fiat_p384_addcarryx_u32(&x1129, &x1130, 0x0, x1057, x1104);
  fiat_p384_addcarryx_u32(&x1131, &x1132, x1130, x1059, x1106);
  fiat_p384_addcarryx_u32(&x1133, &x1134, x1132, x1061, x1108);
  fiat_p384_addcarryx_u32(&x1135, &x1136, x1134, x1063, x1110);
  fiat_p384_addcarryx_u32(&x1137, &x1138, x1136, x1065, x1112);
  fiat_p384_addcarryx_u32(&x1139, &x1140, x1138, x1067, x1114);
  fiat_p384_addcarryx_u32(&x1141, &x1142, x1140, x1069, x1116);
  fiat_p384_addcarryx_u32(&x1143, &x1144, x1142, x1071, x1118);
  fiat_p384_addcarryx_u32(&x1145, &x1146, x1144, x1073, x1120);
  fiat_p384_addcarryx_u32(&x1147, &x1148, x1146, x1075, x1122);
  fiat_p384_addcarryx_u32(&x1149, &x1150, x1148, x1077, x1124);
  fiat_p384_addcarryx_u32(&x1151, &x1152, x1150, x1079, x1126);
  fiat_p384_addcarryx_u32(&x1153, &x1154, x1152, x1081, x1128);
  fiat_p384_mulx_u32(&x1155, &x1156, x1129, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1157, &x1158, x1129, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1159, &x1160, x1129, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1161, &x1162, x1129, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1163, &x1164, x1129, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1165, &x1166, x1129, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1167, &x1168, x1129, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1169, &x1170, x1129, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x1171, &x1172, x1129, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1173, &x1174, x1129, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x1175, &x1176, 0x0, x1172, x1169);
  fiat_p384_addcarryx_u32(&x1177, &x1178, x1176, x1170, x1167);
  fiat_p384_addcarryx_u32(&x1179, &x1180, x1178, x1168, x1165);
  fiat_p384_addcarryx_u32(&x1181, &x1182, x1180, x1166, x1163);
  fiat_p384_addcarryx_u32(&x1183, &x1184, x1182, x1164, x1161);
  fiat_p384_addcarryx_u32(&x1185, &x1186, x1184, x1162, x1159);
  fiat_p384_addcarryx_u32(&x1187, &x1188, x1186, x1160, x1157);
  fiat_p384_addcarryx_u32(&x1189, &x1190, x1188, x1158, x1155);
  x1191 = (x1190 + x1156);
  fiat_p384_addcarryx_u32(&x1192, &x1193, 0x0, x1129, x1173);
  fiat_p384_addcarryx_u32(&x1194, &x1195, x1193, x1131, x1174);
  fiat_p384_addcarryx_u32(&x1196, &x1197, x1195, x1133, 0x0);
  fiat_p384_addcarryx_u32(&x1198, &x1199, x1197, x1135, x1171);
  fiat_p384_addcarryx_u32(&x1200, &x1201, x1199, x1137, x1175);
  fiat_p384_addcarryx_u32(&x1202, &x1203, x1201, x1139, x1177);
  fiat_p384_addcarryx_u32(&x1204, &x1205, x1203, x1141, x1179);
  fiat_p384_addcarryx_u32(&x1206, &x1207, x1205, x1143, x1181);
  fiat_p384_addcarryx_u32(&x1208, &x1209, x1207, x1145, x1183);
  fiat_p384_addcarryx_u32(&x1210, &x1211, x1209, x1147, x1185);
  fiat_p384_addcarryx_u32(&x1212, &x1213, x1211, x1149, x1187);
  fiat_p384_addcarryx_u32(&x1214, &x1215, x1213, x1151, x1189);
  fiat_p384_addcarryx_u32(&x1216, &x1217, x1215, x1153, x1191);
  x1218 = ((uint32_t)x1217 + x1154);
  fiat_p384_mulx_u32(&x1219, &x1220, x9, (arg1[11]));
  fiat_p384_mulx_u32(&x1221, &x1222, x9, (arg1[10]));
  fiat_p384_mulx_u32(&x1223, &x1224, x9, (arg1[9]));
  fiat_p384_mulx_u32(&x1225, &x1226, x9, (arg1[8]));
  fiat_p384_mulx_u32(&x1227, &x1228, x9, (arg1[7]));
  fiat_p384_mulx_u32(&x1229, &x1230, x9, (arg1[6]));
  fiat_p384_mulx_u32(&x1231, &x1232, x9, (arg1[5]));
  fiat_p384_mulx_u32(&x1233, &x1234, x9, (arg1[4]));
  fiat_p384_mulx_u32(&x1235, &x1236, x9, (arg1[3]));
  fiat_p384_mulx_u32(&x1237, &x1238, x9, (arg1[2]));
  fiat_p384_mulx_u32(&x1239, &x1240, x9, (arg1[1]));
  fiat_p384_mulx_u32(&x1241, &x1242, x9, (arg1[0]));
  fiat_p384_addcarryx_u32(&x1243, &x1244, 0x0, x1242, x1239);
  fiat_p384_addcarryx_u32(&x1245, &x1246, x1244, x1240, x1237);
  fiat_p384_addcarryx_u32(&x1247, &x1248, x1246, x1238, x1235);
  fiat_p384_addcarryx_u32(&x1249, &x1250, x1248, x1236, x1233);
  fiat_p384_addcarryx_u32(&x1251, &x1252, x1250, x1234, x1231);
  fiat_p384_addcarryx_u32(&x1253, &x1254, x1252, x1232, x1229);
  fiat_p384_addcarryx_u32(&x1255, &x1256, x1254, x1230, x1227);
  fiat_p384_addcarryx_u32(&x1257, &x1258, x1256, x1228, x1225);
  fiat_p384_addcarryx_u32(&x1259, &x1260, x1258, x1226, x1223);
  fiat_p384_addcarryx_u32(&x1261, &x1262, x1260, x1224, x1221);
  fiat_p384_addcarryx_u32(&x1263, &x1264, x1262, x1222, x1219);
  x1265 = (x1264 + x1220);
  fiat_p384_addcarryx_u32(&x1266, &x1267, 0x0, x1194, x1241);
  fiat_p384_addcarryx_u32(&x1268, &x1269, x1267, x1196, x1243);
  fiat_p384_addcarryx_u32(&x1270, &x1271, x1269, x1198, x1245);
  fiat_p384_addcarryx_u32(&x1272, &x1273, x1271, x1200, x1247);
  fiat_p384_addcarryx_u32(&x1274, &x1275, x1273, x1202, x1249);
  fiat_p384_addcarryx_u32(&x1276, &x1277, x1275, x1204, x1251);
  fiat_p384_addcarryx_u32(&x1278, &x1279, x1277, x1206, x1253);
  fiat_p384_addcarryx_u32(&x1280, &x1281, x1279, x1208, x1255);
  fiat_p384_addcarryx_u32(&x1282, &x1283, x1281, x1210, x1257);
  fiat_p384_addcarryx_u32(&x1284, &x1285, x1283, x1212, x1259);
  fiat_p384_addcarryx_u32(&x1286, &x1287, x1285, x1214, x1261);
  fiat_p384_addcarryx_u32(&x1288, &x1289, x1287, x1216, x1263);
  fiat_p384_addcarryx_u32(&x1290, &x1291, x1289, x1218, x1265);
  fiat_p384_mulx_u32(&x1292, &x1293, x1266, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1294, &x1295, x1266, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1296, &x1297, x1266, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1298, &x1299, x1266, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1300, &x1301, x1266, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1302, &x1303, x1266, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1304, &x1305, x1266, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1306, &x1307, x1266, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x1308, &x1309, x1266, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1310, &x1311, x1266, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x1312, &x1313, 0x0, x1309, x1306);
  fiat_p384_addcarryx_u32(&x1314, &x1315, x1313, x1307, x1304);
  fiat_p384_addcarryx_u32(&x1316, &x1317, x1315, x1305, x1302);
  fiat_p384_addcarryx_u32(&x1318, &x1319, x1317, x1303, x1300);
  fiat_p384_addcarryx_u32(&x1320, &x1321, x1319, x1301, x1298);
  fiat_p384_addcarryx_u32(&x1322, &x1323, x1321, x1299, x1296);
  fiat_p384_addcarryx_u32(&x1324, &x1325, x1323, x1297, x1294);
  fiat_p384_addcarryx_u32(&x1326, &x1327, x1325, x1295, x1292);
  x1328 = (x1327 + x1293);
  fiat_p384_addcarryx_u32(&x1329, &x1330, 0x0, x1266, x1310);
  fiat_p384_addcarryx_u32(&x1331, &x1332, x1330, x1268, x1311);
  fiat_p384_addcarryx_u32(&x1333, &x1334, x1332, x1270, 0x0);
  fiat_p384_addcarryx_u32(&x1335, &x1336, x1334, x1272, x1308);
  fiat_p384_addcarryx_u32(&x1337, &x1338, x1336, x1274, x1312);
  fiat_p384_addcarryx_u32(&x1339, &x1340, x1338, x1276, x1314);
  fiat_p384_addcarryx_u32(&x1341, &x1342, x1340, x1278, x1316);
  fiat_p384_addcarryx_u32(&x1343, &x1344, x1342, x1280, x1318);
  fiat_p384_addcarryx_u32(&x1345, &x1346, x1344, x1282, x1320);
  fiat_p384_addcarryx_u32(&x1347, &x1348, x1346, x1284, x1322);
  fiat_p384_addcarryx_u32(&x1349, &x1350, x1348, x1286, x1324);
  fiat_p384_addcarryx_u32(&x1351, &x1352, x1350, x1288, x1326);
  fiat_p384_addcarryx_u32(&x1353, &x1354, x1352, x1290, x1328);
  x1355 = ((uint32_t)x1354 + x1291);
  fiat_p384_mulx_u32(&x1356, &x1357, x10, (arg1[11]));
  fiat_p384_mulx_u32(&x1358, &x1359, x10, (arg1[10]));
  fiat_p384_mulx_u32(&x1360, &x1361, x10, (arg1[9]));
  fiat_p384_mulx_u32(&x1362, &x1363, x10, (arg1[8]));
  fiat_p384_mulx_u32(&x1364, &x1365, x10, (arg1[7]));
  fiat_p384_mulx_u32(&x1366, &x1367, x10, (arg1[6]));
  fiat_p384_mulx_u32(&x1368, &x1369, x10, (arg1[5]));
  fiat_p384_mulx_u32(&x1370, &x1371, x10, (arg1[4]));
  fiat_p384_mulx_u32(&x1372, &x1373, x10, (arg1[3]));
  fiat_p384_mulx_u32(&x1374, &x1375, x10, (arg1[2]));
  fiat_p384_mulx_u32(&x1376, &x1377, x10, (arg1[1]));
  fiat_p384_mulx_u32(&x1378, &x1379, x10, (arg1[0]));
  fiat_p384_addcarryx_u32(&x1380, &x1381, 0x0, x1379, x1376);
  fiat_p384_addcarryx_u32(&x1382, &x1383, x1381, x1377, x1374);
  fiat_p384_addcarryx_u32(&x1384, &x1385, x1383, x1375, x1372);
  fiat_p384_addcarryx_u32(&x1386, &x1387, x1385, x1373, x1370);
  fiat_p384_addcarryx_u32(&x1388, &x1389, x1387, x1371, x1368);
  fiat_p384_addcarryx_u32(&x1390, &x1391, x1389, x1369, x1366);
  fiat_p384_addcarryx_u32(&x1392, &x1393, x1391, x1367, x1364);
  fiat_p384_addcarryx_u32(&x1394, &x1395, x1393, x1365, x1362);
  fiat_p384_addcarryx_u32(&x1396, &x1397, x1395, x1363, x1360);
  fiat_p384_addcarryx_u32(&x1398, &x1399, x1397, x1361, x1358);
  fiat_p384_addcarryx_u32(&x1400, &x1401, x1399, x1359, x1356);
  x1402 = (x1401 + x1357);
  fiat_p384_addcarryx_u32(&x1403, &x1404, 0x0, x1331, x1378);
  fiat_p384_addcarryx_u32(&x1405, &x1406, x1404, x1333, x1380);
  fiat_p384_addcarryx_u32(&x1407, &x1408, x1406, x1335, x1382);
  fiat_p384_addcarryx_u32(&x1409, &x1410, x1408, x1337, x1384);
  fiat_p384_addcarryx_u32(&x1411, &x1412, x1410, x1339, x1386);
  fiat_p384_addcarryx_u32(&x1413, &x1414, x1412, x1341, x1388);
  fiat_p384_addcarryx_u32(&x1415, &x1416, x1414, x1343, x1390);
  fiat_p384_addcarryx_u32(&x1417, &x1418, x1416, x1345, x1392);
  fiat_p384_addcarryx_u32(&x1419, &x1420, x1418, x1347, x1394);
  fiat_p384_addcarryx_u32(&x1421, &x1422, x1420, x1349, x1396);
  fiat_p384_addcarryx_u32(&x1423, &x1424, x1422, x1351, x1398);
  fiat_p384_addcarryx_u32(&x1425, &x1426, x1424, x1353, x1400);
  fiat_p384_addcarryx_u32(&x1427, &x1428, x1426, x1355, x1402);
  fiat_p384_mulx_u32(&x1429, &x1430, x1403, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1431, &x1432, x1403, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1433, &x1434, x1403, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1435, &x1436, x1403, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1437, &x1438, x1403, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1439, &x1440, x1403, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1441, &x1442, x1403, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1443, &x1444, x1403, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x1445, &x1446, x1403, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1447, &x1448, x1403, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x1449, &x1450, 0x0, x1446, x1443);
  fiat_p384_addcarryx_u32(&x1451, &x1452, x1450, x1444, x1441);
  fiat_p384_addcarryx_u32(&x1453, &x1454, x1452, x1442, x1439);
  fiat_p384_addcarryx_u32(&x1455, &x1456, x1454, x1440, x1437);
  fiat_p384_addcarryx_u32(&x1457, &x1458, x1456, x1438, x1435);
  fiat_p384_addcarryx_u32(&x1459, &x1460, x1458, x1436, x1433);
  fiat_p384_addcarryx_u32(&x1461, &x1462, x1460, x1434, x1431);
  fiat_p384_addcarryx_u32(&x1463, &x1464, x1462, x1432, x1429);
  x1465 = (x1464 + x1430);
  fiat_p384_addcarryx_u32(&x1466, &x1467, 0x0, x1403, x1447);
  fiat_p384_addcarryx_u32(&x1468, &x1469, x1467, x1405, x1448);
  fiat_p384_addcarryx_u32(&x1470, &x1471, x1469, x1407, 0x0);
  fiat_p384_addcarryx_u32(&x1472, &x1473, x1471, x1409, x1445);
  fiat_p384_addcarryx_u32(&x1474, &x1475, x1473, x1411, x1449);
  fiat_p384_addcarryx_u32(&x1476, &x1477, x1475, x1413, x1451);
  fiat_p384_addcarryx_u32(&x1478, &x1479, x1477, x1415, x1453);
  fiat_p384_addcarryx_u32(&x1480, &x1481, x1479, x1417, x1455);
  fiat_p384_addcarryx_u32(&x1482, &x1483, x1481, x1419, x1457);
  fiat_p384_addcarryx_u32(&x1484, &x1485, x1483, x1421, x1459);
  fiat_p384_addcarryx_u32(&x1486, &x1487, x1485, x1423, x1461);
  fiat_p384_addcarryx_u32(&x1488, &x1489, x1487, x1425, x1463);
  fiat_p384_addcarryx_u32(&x1490, &x1491, x1489, x1427, x1465);
  x1492 = ((uint32_t)x1491 + x1428);
  fiat_p384_mulx_u32(&x1493, &x1494, x11, (arg1[11]));
  fiat_p384_mulx_u32(&x1495, &x1496, x11, (arg1[10]));
  fiat_p384_mulx_u32(&x1497, &x1498, x11, (arg1[9]));
  fiat_p384_mulx_u32(&x1499, &x1500, x11, (arg1[8]));
  fiat_p384_mulx_u32(&x1501, &x1502, x11, (arg1[7]));
  fiat_p384_mulx_u32(&x1503, &x1504, x11, (arg1[6]));
  fiat_p384_mulx_u32(&x1505, &x1506, x11, (arg1[5]));
  fiat_p384_mulx_u32(&x1507, &x1508, x11, (arg1[4]));
  fiat_p384_mulx_u32(&x1509, &x1510, x11, (arg1[3]));
  fiat_p384_mulx_u32(&x1511, &x1512, x11, (arg1[2]));
  fiat_p384_mulx_u32(&x1513, &x1514, x11, (arg1[1]));
  fiat_p384_mulx_u32(&x1515, &x1516, x11, (arg1[0]));
  fiat_p384_addcarryx_u32(&x1517, &x1518, 0x0, x1516, x1513);
  fiat_p384_addcarryx_u32(&x1519, &x1520, x1518, x1514, x1511);
  fiat_p384_addcarryx_u32(&x1521, &x1522, x1520, x1512, x1509);
  fiat_p384_addcarryx_u32(&x1523, &x1524, x1522, x1510, x1507);
  fiat_p384_addcarryx_u32(&x1525, &x1526, x1524, x1508, x1505);
  fiat_p384_addcarryx_u32(&x1527, &x1528, x1526, x1506, x1503);
  fiat_p384_addcarryx_u32(&x1529, &x1530, x1528, x1504, x1501);
  fiat_p384_addcarryx_u32(&x1531, &x1532, x1530, x1502, x1499);
  fiat_p384_addcarryx_u32(&x1533, &x1534, x1532, x1500, x1497);
  fiat_p384_addcarryx_u32(&x1535, &x1536, x1534, x1498, x1495);
  fiat_p384_addcarryx_u32(&x1537, &x1538, x1536, x1496, x1493);
  x1539 = (x1538 + x1494);
  fiat_p384_addcarryx_u32(&x1540, &x1541, 0x0, x1468, x1515);
  fiat_p384_addcarryx_u32(&x1542, &x1543, x1541, x1470, x1517);
  fiat_p384_addcarryx_u32(&x1544, &x1545, x1543, x1472, x1519);
  fiat_p384_addcarryx_u32(&x1546, &x1547, x1545, x1474, x1521);
  fiat_p384_addcarryx_u32(&x1548, &x1549, x1547, x1476, x1523);
  fiat_p384_addcarryx_u32(&x1550, &x1551, x1549, x1478, x1525);
  fiat_p384_addcarryx_u32(&x1552, &x1553, x1551, x1480, x1527);
  fiat_p384_addcarryx_u32(&x1554, &x1555, x1553, x1482, x1529);
  fiat_p384_addcarryx_u32(&x1556, &x1557, x1555, x1484, x1531);
  fiat_p384_addcarryx_u32(&x1558, &x1559, x1557, x1486, x1533);
  fiat_p384_addcarryx_u32(&x1560, &x1561, x1559, x1488, x1535);
  fiat_p384_addcarryx_u32(&x1562, &x1563, x1561, x1490, x1537);
  fiat_p384_addcarryx_u32(&x1564, &x1565, x1563, x1492, x1539);
  fiat_p384_mulx_u32(&x1566, &x1567, x1540, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1568, &x1569, x1540, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1570, &x1571, x1540, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1572, &x1573, x1540, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1574, &x1575, x1540, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1576, &x1577, x1540, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1578, &x1579, x1540, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1580, &x1581, x1540, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x1582, &x1583, x1540, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1584, &x1585, x1540, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x1586, &x1587, 0x0, x1583, x1580);
  fiat_p384_addcarryx_u32(&x1588, &x1589, x1587, x1581, x1578);
  fiat_p384_addcarryx_u32(&x1590, &x1591, x1589, x1579, x1576);
  fiat_p384_addcarryx_u32(&x1592, &x1593, x1591, x1577, x1574);
  fiat_p384_addcarryx_u32(&x1594, &x1595, x1593, x1575, x1572);
  fiat_p384_addcarryx_u32(&x1596, &x1597, x1595, x1573, x1570);
  fiat_p384_addcarryx_u32(&x1598, &x1599, x1597, x1571, x1568);
  fiat_p384_addcarryx_u32(&x1600, &x1601, x1599, x1569, x1566);
  x1602 = (x1601 + x1567);
  fiat_p384_addcarryx_u32(&x1603, &x1604, 0x0, x1540, x1584);
  fiat_p384_addcarryx_u32(&x1605, &x1606, x1604, x1542, x1585);
  fiat_p384_addcarryx_u32(&x1607, &x1608, x1606, x1544, 0x0);
  fiat_p384_addcarryx_u32(&x1609, &x1610, x1608, x1546, x1582);
  fiat_p384_addcarryx_u32(&x1611, &x1612, x1610, x1548, x1586);
  fiat_p384_addcarryx_u32(&x1613, &x1614, x1612, x1550, x1588);
  fiat_p384_addcarryx_u32(&x1615, &x1616, x1614, x1552, x1590);
  fiat_p384_addcarryx_u32(&x1617, &x1618, x1616, x1554, x1592);
  fiat_p384_addcarryx_u32(&x1619, &x1620, x1618, x1556, x1594);
  fiat_p384_addcarryx_u32(&x1621, &x1622, x1620, x1558, x1596);
  fiat_p384_addcarryx_u32(&x1623, &x1624, x1622, x1560, x1598);
  fiat_p384_addcarryx_u32(&x1625, &x1626, x1624, x1562, x1600);
  fiat_p384_addcarryx_u32(&x1627, &x1628, x1626, x1564, x1602);
  x1629 = ((uint32_t)x1628 + x1565);
  fiat_p384_subborrowx_u32(&x1630, &x1631, 0x0, x1605, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1632, &x1633, x1631, x1607, 0x0);
  fiat_p384_subborrowx_u32(&x1634, &x1635, x1633, x1609, 0x0);
  fiat_p384_subborrowx_u32(&x1636, &x1637, x1635, x1611, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1638, &x1639, x1637, x1613, UINT32_C(0xfffffffe));
  fiat_p384_subborrowx_u32(&x1640, &x1641, x1639, x1615, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1642, &x1643, x1641, x1617, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1644, &x1645, x1643, x1619, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1646, &x1647, x1645, x1621, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1648, &x1649, x1647, x1623, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1650, &x1651, x1649, x1625, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1652, &x1653, x1651, x1627, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1654, &x1655, x1653, x1629, 0x0);
  fiat_p384_cmovznz_u32(&x1656, x1655, x1630, x1605);
  fiat_p384_cmovznz_u32(&x1657, x1655, x1632, x1607);
  fiat_p384_cmovznz_u32(&x1658, x1655, x1634, x1609);
  fiat_p384_cmovznz_u32(&x1659, x1655, x1636, x1611);
  fiat_p384_cmovznz_u32(&x1660, x1655, x1638, x1613);
  fiat_p384_cmovznz_u32(&x1661, x1655, x1640, x1615);
  fiat_p384_cmovznz_u32(&x1662, x1655, x1642, x1617);
  fiat_p384_cmovznz_u32(&x1663, x1655, x1644, x1619);
  fiat_p384_cmovznz_u32(&x1664, x1655, x1646, x1621);
  fiat_p384_cmovznz_u32(&x1665, x1655, x1648, x1623);
  fiat_p384_cmovznz_u32(&x1666, x1655, x1650, x1625);
  fiat_p384_cmovznz_u32(&x1667, x1655, x1652, x1627);
  out1[0] = x1656;
  out1[1] = x1657;
  out1[2] = x1658;
  out1[3] = x1659;
  out1[4] = x1660;
  out1[5] = x1661;
  out1[6] = x1662;
  out1[7] = x1663;
  out1[8] = x1664;
  out1[9] = x1665;
  out1[10] = x1666;
  out1[11] = x1667;
}

/*
 * The function fiat_p384_add adds two field elements in the Montgomery domain.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_p384_add(fiat_p384_montgomery_domain_field_element out1, const fiat_p384_montgomery_domain_field_element arg1, const fiat_p384_montgomery_domain_field_element arg2) {
  uint32_t x1;
  fiat_p384_uint1 x2;
  uint32_t x3;
  fiat_p384_uint1 x4;
  uint32_t x5;
  fiat_p384_uint1 x6;
  uint32_t x7;
  fiat_p384_uint1 x8;
  uint32_t x9;
  fiat_p384_uint1 x10;
  uint32_t x11;
  fiat_p384_uint1 x12;
  uint32_t x13;
  fiat_p384_uint1 x14;
  uint32_t x15;
  fiat_p384_uint1 x16;
  uint32_t x17;
  fiat_p384_uint1 x18;
  uint32_t x19;
  fiat_p384_uint1 x20;
  uint32_t x21;
  fiat_p384_uint1 x22;
  uint32_t x23;
  fiat_p384_uint1 x24;
  uint32_t x25;
  fiat_p384_uint1 x26;
  uint32_t x27;
  fiat_p384_uint1 x28;
  uint32_t x29;
  fiat_p384_uint1 x30;
  uint32_t x31;
  fiat_p384_uint1 x32;
  uint32_t x33;
  fiat_p384_uint1 x34;
  uint32_t x35;
  fiat_p384_uint1 x36;
  uint32_t x37;
  fiat_p384_uint1 x38;
  uint32_t x39;
  fiat_p384_uint1 x40;
  uint32_t x41;
  fiat_p384_uint1 x42;
  uint32_t x43;
  fiat_p384_uint1 x44;
  uint32_t x45;
  fiat_p384_uint1 x46;
  uint32_t x47;
  fiat_p384_uint1 x48;
  uint32_t x49;
  fiat_p384_uint1 x50;
  uint32_t x51;
  uint32_t x52;
  uint32_t x53;
  uint32_t x54;
  uint32_t x55;
  uint32_t x56;
  uint32_t x57;
  uint32_t x58;
  uint32_t x59;
  uint32_t x60;
  uint32_t x61;
  uint32_t x62;
  fiat_p384_addcarryx_u32(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
  fiat_p384_addcarryx_u32(&x3, &x4, x2, (arg1[1]), (arg2[1]));
  fiat_p384_addcarryx_u32(&x5, &x6, x4, (arg1[2]), (arg2[2]));
  fiat_p384_addcarryx_u32(&x7, &x8, x6, (arg1[3]), (arg2[3]));
  fiat_p384_addcarryx_u32(&x9, &x10, x8, (arg1[4]), (arg2[4]));
  fiat_p384_addcarryx_u32(&x11, &x12, x10, (arg1[5]), (arg2[5]));
  fiat_p384_addcarryx_u32(&x13, &x14, x12, (arg1[6]), (arg2[6]));
  fiat_p384_addcarryx_u32(&x15, &x16, x14, (arg1[7]), (arg2[7]));
  fiat_p384_addcarryx_u32(&x17, &x18, x16, (arg1[8]), (arg2[8]));
  fiat_p384_addcarryx_u32(&x19, &x20, x18, (arg1[9]), (arg2[9]));
  fiat_p384_addcarryx_u32(&x21, &x22, x20, (arg1[10]), (arg2[10]));
  fiat_p384_addcarryx_u32(&x23, &x24, x22, (arg1[11]), (arg2[11]));
  fiat_p384_subborrowx_u32(&x25, &x26, 0x0, x1, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x27, &x28, x26, x3, 0x0);
  fiat_p384_subborrowx_u32(&x29, &x30, x28, x5, 0x0);
  fiat_p384_subborrowx_u32(&x31, &x32, x30, x7, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x33, &x34, x32, x9, UINT32_C(0xfffffffe));
  fiat_p384_subborrowx_u32(&x35, &x36, x34, x11, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x37, &x38, x36, x13, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x39, &x40, x38, x15, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x41, &x42, x40, x17, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x43, &x44, x42, x19, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x45, &x46, x44, x21, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x47, &x48, x46, x23, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x49, &x50, x48, x24, 0x0);
  fiat_p384_cmovznz_u32(&x51, x50, x25, x1);
  fiat_p384_cmovznz_u32(&x52, x50, x27, x3);
  fiat_p384_cmovznz_u32(&x53, x50, x29, x5);
  fiat_p384_cmovznz_u32(&x54, x50, x31, x7);
  fiat_p384_cmovznz_u32(&x55, x50, x33, x9);
  fiat_p384_cmovznz_u32(&x56, x50, x35, x11);
  fiat_p384_cmovznz_u32(&x57, x50, x37, x13);
  fiat_p384_cmovznz_u32(&x58, x50, x39, x15);
  fiat_p384_cmovznz_u32(&x59, x50, x41, x17);
  fiat_p384_cmovznz_u32(&x60, x50, x43, x19);
  fiat_p384_cmovznz_u32(&x61, x50, x45, x21);
  fiat_p384_cmovznz_u32(&x62, x50, x47, x23);
  out1[0] = x51;
  out1[1] = x52;
  out1[2] = x53;
  out1[3] = x54;
  out1[4] = x55;
  out1[5] = x56;
  out1[6] = x57;
  out1[7] = x58;
  out1[8] = x59;
  out1[9] = x60;
  out1[10] = x61;
  out1[11] = x62;
}

/*
 * The function fiat_p384_sub subtracts two field elements in the Montgomery domain.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_p384_sub(fiat_p384_montgomery_domain_field_element out1, const fiat_p384_montgomery_domain_field_element arg1, const fiat_p384_montgomery_domain_field_element arg2) {
  uint32_t x1;
  fiat_p384_uint1 x2;
  uint32_t x3;
  fiat_p384_uint1 x4;
  uint32_t x5;
  fiat_p384_uint1 x6;
  uint32_t x7;
  fiat_p384_uint1 x8;
  uint32_t x9;
  fiat_p384_uint1 x10;
  uint32_t x11;
  fiat_p384_uint1 x12;
  uint32_t x13;
  fiat_p384_uint1 x14;
  uint32_t x15;
  fiat_p384_uint1 x16;
  uint32_t x17;
  fiat_p384_uint1 x18;
  uint32_t x19;
  fiat_p384_uint1 x20;
  uint32_t x21;
  fiat_p384_uint1 x22;
  uint32_t x23;
  fiat_p384_uint1 x24;
  uint32_t x25;
  uint32_t x26;
  fiat_p384_uint1 x27;
  uint32_t x28;
  fiat_p384_uint1 x29;
  uint32_t x30;
  fiat_p384_uint1 x31;
  uint32_t x32;
  fiat_p384_uint1 x33;
  uint32_t x34;
  fiat_p384_uint1 x35;
  uint32_t x36;
  fiat_p384_uint1 x37;
  uint32_t x38;
  fiat_p384_uint1 x39;
  uint32_t x40;
  fiat_p384_uint1 x41;
  uint32_t x42;
  fiat_p384_uint1 x43;
  uint32_t x44;
  fiat_p384_uint1 x45;
  uint32_t x46;
  fiat_p384_uint1 x47;
  uint32_t x48;
  fiat_p384_uint1 x49;
  fiat_p384_subborrowx_u32(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
  fiat_p384_subborrowx_u32(&x3, &x4, x2, (arg1[1]), (arg2[1]));
  fiat_p384_subborrowx_u32(&x5, &x6, x4, (arg1[2]), (arg2[2]));
  fiat_p384_subborrowx_u32(&x7, &x8, x6, (arg1[3]), (arg2[3]));
  fiat_p384_subborrowx_u32(&x9, &x10, x8, (arg1[4]), (arg2[4]));
  fiat_p384_subborrowx_u32(&x11, &x12, x10, (arg1[5]), (arg2[5]));
  fiat_p384_subborrowx_u32(&x13, &x14, x12, (arg1[6]), (arg2[6]));
  fiat_p384_subborrowx_u32(&x15, &x16, x14, (arg1[7]), (arg2[7]));
  fiat_p384_subborrowx_u32(&x17, &x18, x16, (arg1[8]), (arg2[8]));
  fiat_p384_subborrowx_u32(&x19, &x20, x18, (arg1[9]), (arg2[9]));
  fiat_p384_subborrowx_u32(&x21, &x22, x20, (arg1[10]), (arg2[10]));
  fiat_p384_subborrowx_u32(&x23, &x24, x22, (arg1[11]), (arg2[11]));
  fiat_p384_cmovznz_u32(&x25, x24, 0x0, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x26, &x27, 0x0, x1, x25);
  fiat_p384_addcarryx_u32(&x28, &x29, x27, x3, 0x0);
  fiat_p384_addcarryx_u32(&x30, &x31, x29, x5, 0x0);
  fiat_p384_addcarryx_u32(&x32, &x33, x31, x7, x25);
  fiat_p384_addcarryx_u32(&x34, &x35, x33, x9, (x25 & UINT32_C(0xfffffffe)));
  fiat_p384_addcarryx_u32(&x36, &x37, x35, x11, x25);
  fiat_p384_addcarryx_u32(&x38, &x39, x37, x13, x25);
  fiat_p384_addcarryx_u32(&x40, &x41, x39, x15, x25);
  fiat_p384_addcarryx_u32(&x42, &x43, x41, x17, x25);
  fiat_p384_addcarryx_u32(&x44, &x45, x43, x19, x25);
  fiat_p384_addcarryx_u32(&x46, &x47, x45, x21, x25);
  fiat_p384_addcarryx_u32(&x48, &x49, x47, x23, x25);
  out1[0] = x26;
  out1[1] = x28;
  out1[2] = x30;
  out1[3] = x32;
  out1[4] = x34;
  out1[5] = x36;
  out1[6] = x38;
  out1[7] = x40;
  out1[8] = x42;
  out1[9] = x44;
  out1[10] = x46;
  out1[11] = x48;
}

/*
 * The function fiat_p384_opp negates a field element in the Montgomery domain.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_p384_opp(fiat_p384_montgomery_domain_field_element out1, const fiat_p384_montgomery_domain_field_element arg1) {
  uint32_t x1;
  fiat_p384_uint1 x2;
  uint32_t x3;
  fiat_p384_uint1 x4;
  uint32_t x5;
  fiat_p384_uint1 x6;
  uint32_t x7;
  fiat_p384_uint1 x8;
  uint32_t x9;
  fiat_p384_uint1 x10;
  uint32_t x11;
  fiat_p384_uint1 x12;
  uint32_t x13;
  fiat_p384_uint1 x14;
  uint32_t x15;
  fiat_p384_uint1 x16;
  uint32_t x17;
  fiat_p384_uint1 x18;
  uint32_t x19;
  fiat_p384_uint1 x20;
  uint32_t x21;
  fiat_p384_uint1 x22;
  uint32_t x23;
  fiat_p384_uint1 x24;
  uint32_t x25;
  uint32_t x26;
  fiat_p384_uint1 x27;
  uint32_t x28;
  fiat_p384_uint1 x29;
  uint32_t x30;
  fiat_p384_uint1 x31;
  uint32_t x32;
  fiat_p384_uint1 x33;
  uint32_t x34;
  fiat_p384_uint1 x35;
  uint32_t x36;
  fiat_p384_uint1 x37;
  uint32_t x38;
  fiat_p384_uint1 x39;
  uint32_t x40;
  fiat_p384_uint1 x41;
  uint32_t x42;
  fiat_p384_uint1 x43;
  uint32_t x44;
  fiat_p384_uint1 x45;
  uint32_t x46;
  fiat_p384_uint1 x47;
  uint32_t x48;
  fiat_p384_uint1 x49;
  fiat_p384_subborrowx_u32(&x1, &x2, 0x0, 0x0, (arg1[0]));
  fiat_p384_subborrowx_u32(&x3, &x4, x2, 0x0, (arg1[1]));
  fiat_p384_subborrowx_u32(&x5, &x6, x4, 0x0, (arg1[2]));
  fiat_p384_subborrowx_u32(&x7, &x8, x6, 0x0, (arg1[3]));
  fiat_p384_subborrowx_u32(&x9, &x10, x8, 0x0, (arg1[4]));
  fiat_p384_subborrowx_u32(&x11, &x12, x10, 0x0, (arg1[5]));
  fiat_p384_subborrowx_u32(&x13, &x14, x12, 0x0, (arg1[6]));
  fiat_p384_subborrowx_u32(&x15, &x16, x14, 0x0, (arg1[7]));
  fiat_p384_subborrowx_u32(&x17, &x18, x16, 0x0, (arg1[8]));
  fiat_p384_subborrowx_u32(&x19, &x20, x18, 0x0, (arg1[9]));
  fiat_p384_subborrowx_u32(&x21, &x22, x20, 0x0, (arg1[10]));
  fiat_p384_subborrowx_u32(&x23, &x24, x22, 0x0, (arg1[11]));
  fiat_p384_cmovznz_u32(&x25, x24, 0x0, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x26, &x27, 0x0, x1, x25);
  fiat_p384_addcarryx_u32(&x28, &x29, x27, x3, 0x0);
  fiat_p384_addcarryx_u32(&x30, &x31, x29, x5, 0x0);
  fiat_p384_addcarryx_u32(&x32, &x33, x31, x7, x25);
  fiat_p384_addcarryx_u32(&x34, &x35, x33, x9, (x25 & UINT32_C(0xfffffffe)));
  fiat_p384_addcarryx_u32(&x36, &x37, x35, x11, x25);
  fiat_p384_addcarryx_u32(&x38, &x39, x37, x13, x25);
  fiat_p384_addcarryx_u32(&x40, &x41, x39, x15, x25);
  fiat_p384_addcarryx_u32(&x42, &x43, x41, x17, x25);
  fiat_p384_addcarryx_u32(&x44, &x45, x43, x19, x25);
  fiat_p384_addcarryx_u32(&x46, &x47, x45, x21, x25);
  fiat_p384_addcarryx_u32(&x48, &x49, x47, x23, x25);
  out1[0] = x26;
  out1[1] = x28;
  out1[2] = x30;
  out1[3] = x32;
  out1[4] = x34;
  out1[5] = x36;
  out1[6] = x38;
  out1[7] = x40;
  out1[8] = x42;
  out1[9] = x44;
  out1[10] = x46;
  out1[11] = x48;
}

/*
 * The function fiat_p384_from_montgomery translates a field element out of the Montgomery domain.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^12) mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_p384_from_montgomery(fiat_p384_non_montgomery_domain_field_element out1, const fiat_p384_montgomery_domain_field_element arg1) {
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  uint32_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint32_t x12;
  uint32_t x13;
  uint32_t x14;
  uint32_t x15;
  uint32_t x16;
  uint32_t x17;
  uint32_t x18;
  uint32_t x19;
  uint32_t x20;
  uint32_t x21;
  uint32_t x22;
  fiat_p384_uint1 x23;
  uint32_t x24;
  fiat_p384_uint1 x25;
  uint32_t x26;
  fiat_p384_uint1 x27;
  uint32_t x28;
  fiat_p384_uint1 x29;
  uint32_t x30;
  fiat_p384_uint1 x31;
  uint32_t x32;
  fiat_p384_uint1 x33;
  uint32_t x34;
  fiat_p384_uint1 x35;
  uint32_t x36;
  fiat_p384_uint1 x37;
  uint32_t x38;
  fiat_p384_uint1 x39;
  uint32_t x40;
  fiat_p384_uint1 x41;
  uint32_t x42;
  uint32_t x43;
  uint32_t x44;
  uint32_t x45;
  uint32_t x46;
  uint32_t x47;
  uint32_t x48;
  uint32_t x49;
  uint32_t x50;
  uint32_t x51;
  uint32_t x52;
  uint32_t x53;
  uint32_t x54;
  uint32_t x55;
  uint32_t x56;
  uint32_t x57;
  uint32_t x58;
  uint32_t x59;
  uint32_t x60;
  uint32_t x61;
  uint32_t x62;
  fiat_p384_uint1 x63;
  uint32_t x64;
  fiat_p384_uint1 x65;
  uint32_t x66;
  fiat_p384_uint1 x67;
  uint32_t x68;
  fiat_p384_uint1 x69;
  uint32_t x70;
  fiat_p384_uint1 x71;
  uint32_t x72;
  fiat_p384_uint1 x73;
  uint32_t x74;
  fiat_p384_uint1 x75;
  uint32_t x76;
  fiat_p384_uint1 x77;
  uint32_t x78;
  fiat_p384_uint1 x79;
  uint32_t x80;
  fiat_p384_uint1 x81;
  uint32_t x82;
  fiat_p384_uint1 x83;
  uint32_t x84;
  fiat_p384_uint1 x85;
  uint32_t x86;
  fiat_p384_uint1 x87;
  uint32_t x88;
  fiat_p384_uint1 x89;
  uint32_t x90;
  fiat_p384_uint1 x91;
  uint32_t x92;
  fiat_p384_uint1 x93;
  uint32_t x94;
  fiat_p384_uint1 x95;
  uint32_t x96;
  fiat_p384_uint1 x97;
  uint32_t x98;
  fiat_p384_uint1 x99;
  uint32_t x100;
  fiat_p384_uint1 x101;
  uint32_t x102;
  fiat_p384_uint1 x103;
  uint32_t x104;
  fiat_p384_uint1 x105;
  uint32_t x106;
  fiat_p384_uint1 x107;
  uint32_t x108;
  fiat_p384_uint1 x109;
  uint32_t x110;
  fiat_p384_uint1 x111;
  uint32_t x112;
  fiat_p384_uint1 x113;
  uint32_t x114;
  fiat_p384_uint1 x115;
  uint32_t x116;
  fiat_p384_uint1 x117;
  uint32_t x118;
  fiat_p384_uint1 x119;
  uint32_t x120;
  fiat_p384_uint1 x121;
  uint32_t x122;
  fiat_p384_uint1 x123;
  uint32_t x124;
  fiat_p384_uint1 x125;
  uint32_t x126;
  fiat_p384_uint1 x127;
  uint32_t x128;
  uint32_t x129;
  uint32_t x130;
  uint32_t x131;
  uint32_t x132;
  uint32_t x133;
  uint32_t x134;
  uint32_t x135;
  uint32_t x136;
  uint32_t x137;
  uint32_t x138;
  uint32_t x139;
  uint32_t x140;
  uint32_t x141;
  uint32_t x142;
  uint32_t x143;
  uint32_t x144;
  uint32_t x145;
  uint32_t x146;
  uint32_t x147;
  uint32_t x148;
  fiat_p384_uint1 x149;
  uint32_t x150;
  fiat_p384_uint1 x151;
  uint32_t x152;
  fiat_p384_uint1 x153;
  uint32_t x154;
  fiat_p384_uint1 x155;
  uint32_t x156;
  fiat_p384_uint1 x157;
  uint32_t x158;
  fiat_p384_uint1 x159;
  uint32_t x160;
  fiat_p384_uint1 x161;
  uint32_t x162;
  fiat_p384_uint1 x163;
  uint32_t x164;
  fiat_p384_uint1 x165;
  uint32_t x166;
  fiat_p384_uint1 x167;
  uint32_t x168;
  fiat_p384_uint1 x169;
  uint32_t x170;
  fiat_p384_uint1 x171;
  uint32_t x172;
  fiat_p384_uint1 x173;
  uint32_t x174;
  fiat_p384_uint1 x175;
  uint32_t x176;
  fiat_p384_uint1 x177;
  uint32_t x178;
  fiat_p384_uint1 x179;
  uint32_t x180;
  fiat_p384_uint1 x181;
  uint32_t x182;
  fiat_p384_uint1 x183;
  uint32_t x184;
  fiat_p384_uint1 x185;
  uint32_t x186;
  fiat_p384_uint1 x187;
  uint32_t x188;
  fiat_p384_uint1 x189;
  uint32_t x190;
  fiat_p384_uint1 x191;
  uint32_t x192;
  fiat_p384_uint1 x193;
  uint32_t x194;
  fiat_p384_uint1 x195;
  uint32_t x196;
  fiat_p384_uint1 x197;
  uint32_t x198;
  fiat_p384_uint1 x199;
  uint32_t x200;
  fiat_p384_uint1 x201;
  uint32_t x202;
  fiat_p384_uint1 x203;
  uint32_t x204;
  fiat_p384_uint1 x205;
  uint32_t x206;
  fiat_p384_uint1 x207;
  uint32_t x208;
  fiat_p384_uint1 x209;
  uint32_t x210;
  fiat_p384_uint1 x211;
  uint32_t x212;
  fiat_p384_uint1 x213;
  uint32_t x214;
  uint32_t x215;
  uint32_t x216;
  uint32_t x217;
  uint32_t x218;
  uint32_t x219;
  uint32_t x220;
  uint32_t x221;
  uint32_t x222;
  uint32_t x223;
  uint32_t x224;
  uint32_t x225;
  uint32_t x226;
  uint32_t x227;
  uint32_t x228;
  uint32_t x229;
  uint32_t x230;
  uint32_t x231;
  uint32_t x232;
  uint32_t x233;
  uint32_t x234;
  fiat_p384_uint1 x235;
  uint32_t x236;
  fiat_p384_uint1 x237;
  uint32_t x238;
  fiat_p384_uint1 x239;
  uint32_t x240;
  fiat_p384_uint1 x241;
  uint32_t x242;
  fiat_p384_uint1 x243;
  uint32_t x244;
  fiat_p384_uint1 x245;
  uint32_t x246;
  fiat_p384_uint1 x247;
  uint32_t x248;
  fiat_p384_uint1 x249;
  uint32_t x250;
  fiat_p384_uint1 x251;
  uint32_t x252;
  fiat_p384_uint1 x253;
  uint32_t x254;
  fiat_p384_uint1 x255;
  uint32_t x256;
  fiat_p384_uint1 x257;
  uint32_t x258;
  fiat_p384_uint1 x259;
  uint32_t x260;
  fiat_p384_uint1 x261;
  uint32_t x262;
  fiat_p384_uint1 x263;
  uint32_t x264;
  fiat_p384_uint1 x265;
  uint32_t x266;
  fiat_p384_uint1 x267;
  uint32_t x268;
  fiat_p384_uint1 x269;
  uint32_t x270;
  fiat_p384_uint1 x271;
  uint32_t x272;
  fiat_p384_uint1 x273;
  uint32_t x274;
  fiat_p384_uint1 x275;
  uint32_t x276;
  fiat_p384_uint1 x277;
  uint32_t x278;
  fiat_p384_uint1 x279;
  uint32_t x280;
  fiat_p384_uint1 x281;
  uint32_t x282;
  fiat_p384_uint1 x283;
  uint32_t x284;
  fiat_p384_uint1 x285;
  uint32_t x286;
  fiat_p384_uint1 x287;
  uint32_t x288;
  fiat_p384_uint1 x289;
  uint32_t x290;
  fiat_p384_uint1 x291;
  uint32_t x292;
  fiat_p384_uint1 x293;
  uint32_t x294;
  fiat_p384_uint1 x295;
  uint32_t x296;
  fiat_p384_uint1 x297;
  uint32_t x298;
  fiat_p384_uint1 x299;
  uint32_t x300;
  uint32_t x301;
  uint32_t x302;
  uint32_t x303;
  uint32_t x304;
  uint32_t x305;
  uint32_t x306;
  uint32_t x307;
  uint32_t x308;
  uint32_t x309;
  uint32_t x310;
  uint32_t x311;
  uint32_t x312;
  uint32_t x313;
  uint32_t x314;
  uint32_t x315;
  uint32_t x316;
  uint32_t x317;
  uint32_t x318;
  uint32_t x319;
  uint32_t x320;
  fiat_p384_uint1 x321;
  uint32_t x322;
  fiat_p384_uint1 x323;
  uint32_t x324;
  fiat_p384_uint1 x325;
  uint32_t x326;
  fiat_p384_uint1 x327;
  uint32_t x328;
  fiat_p384_uint1 x329;
  uint32_t x330;
  fiat_p384_uint1 x331;
  uint32_t x332;
  fiat_p384_uint1 x333;
  uint32_t x334;
  fiat_p384_uint1 x335;
  uint32_t x336;
  fiat_p384_uint1 x337;
  uint32_t x338;
  fiat_p384_uint1 x339;
  uint32_t x340;
  fiat_p384_uint1 x341;
  uint32_t x342;
  fiat_p384_uint1 x343;
  uint32_t x344;
  fiat_p384_uint1 x345;
  uint32_t x346;
  fiat_p384_uint1 x347;
  uint32_t x348;
  fiat_p384_uint1 x349;
  uint32_t x350;
  fiat_p384_uint1 x351;
  uint32_t x352;
  fiat_p384_uint1 x353;
  uint32_t x354;
  fiat_p384_uint1 x355;
  uint32_t x356;
  fiat_p384_uint1 x357;
  uint32_t x358;
  fiat_p384_uint1 x359;
  uint32_t x360;
  fiat_p384_uint1 x361;
  uint32_t x362;
  fiat_p384_uint1 x363;
  uint32_t x364;
  fiat_p384_uint1 x365;
  uint32_t x366;
  fiat_p384_uint1 x367;
  uint32_t x368;
  fiat_p384_uint1 x369;
  uint32_t x370;
  fiat_p384_uint1 x371;
  uint32_t x372;
  fiat_p384_uint1 x373;
  uint32_t x374;
  fiat_p384_uint1 x375;
  uint32_t x376;
  fiat_p384_uint1 x377;
  uint32_t x378;
  fiat_p384_uint1 x379;
  uint32_t x380;
  fiat_p384_uint1 x381;
  uint32_t x382;
  fiat_p384_uint1 x383;
  uint32_t x384;
  fiat_p384_uint1 x385;
  uint32_t x386;
  uint32_t x387;
  uint32_t x388;
  uint32_t x389;
  uint32_t x390;
  uint32_t x391;
  uint32_t x392;
  uint32_t x393;
  uint32_t x394;
  uint32_t x395;
  uint32_t x396;
  uint32_t x397;
  uint32_t x398;
  uint32_t x399;
  uint32_t x400;
  uint32_t x401;
  uint32_t x402;
  uint32_t x403;
  uint32_t x404;
  uint32_t x405;
  uint32_t x406;
  fiat_p384_uint1 x407;
  uint32_t x408;
  fiat_p384_uint1 x409;
  uint32_t x410;
  fiat_p384_uint1 x411;
  uint32_t x412;
  fiat_p384_uint1 x413;
  uint32_t x414;
  fiat_p384_uint1 x415;
  uint32_t x416;
  fiat_p384_uint1 x417;
  uint32_t x418;
  fiat_p384_uint1 x419;
  uint32_t x420;
  fiat_p384_uint1 x421;
  uint32_t x422;
  fiat_p384_uint1 x423;
  uint32_t x424;
  fiat_p384_uint1 x425;
  uint32_t x426;
  fiat_p384_uint1 x427;
  uint32_t x428;
  fiat_p384_uint1 x429;
  uint32_t x430;
  fiat_p384_uint1 x431;
  uint32_t x432;
  fiat_p384_uint1 x433;
  uint32_t x434;
  fiat_p384_uint1 x435;
  uint32_t x436;
  fiat_p384_uint1 x437;
  uint32_t x438;
  fiat_p384_uint1 x439;
  uint32_t x440;
  fiat_p384_uint1 x441;
  uint32_t x442;
  fiat_p384_uint1 x443;
  uint32_t x444;
  fiat_p384_uint1 x445;
  uint32_t x446;
  fiat_p384_uint1 x447;
  uint32_t x448;
  fiat_p384_uint1 x449;
  uint32_t x450;
  fiat_p384_uint1 x451;
  uint32_t x452;
  fiat_p384_uint1 x453;
  uint32_t x454;
  fiat_p384_uint1 x455;
  uint32_t x456;
  fiat_p384_uint1 x457;
  uint32_t x458;
  fiat_p384_uint1 x459;
  uint32_t x460;
  fiat_p384_uint1 x461;
  uint32_t x462;
  fiat_p384_uint1 x463;
  uint32_t x464;
  fiat_p384_uint1 x465;
  uint32_t x466;
  fiat_p384_uint1 x467;
  uint32_t x468;
  fiat_p384_uint1 x469;
  uint32_t x470;
  fiat_p384_uint1 x471;
  uint32_t x472;
  uint32_t x473;
  uint32_t x474;
  uint32_t x475;
  uint32_t x476;
  uint32_t x477;
  uint32_t x478;
  uint32_t x479;
  uint32_t x480;
  uint32_t x481;
  uint32_t x482;
  uint32_t x483;
  uint32_t x484;
  uint32_t x485;
  uint32_t x486;
  uint32_t x487;
  uint32_t x488;
  uint32_t x489;
  uint32_t x490;
  uint32_t x491;
  uint32_t x492;
  fiat_p384_uint1 x493;
  uint32_t x494;
  fiat_p384_uint1 x495;
  uint32_t x496;
  fiat_p384_uint1 x497;
  uint32_t x498;
  fiat_p384_uint1 x499;
  uint32_t x500;
  fiat_p384_uint1 x501;
  uint32_t x502;
  fiat_p384_uint1 x503;
  uint32_t x504;
  fiat_p384_uint1 x505;
  uint32_t x506;
  fiat_p384_uint1 x507;
  uint32_t x508;
  fiat_p384_uint1 x509;
  uint32_t x510;
  fiat_p384_uint1 x511;
  uint32_t x512;
  fiat_p384_uint1 x513;
  uint32_t x514;
  fiat_p384_uint1 x515;
  uint32_t x516;
  fiat_p384_uint1 x517;
  uint32_t x518;
  fiat_p384_uint1 x519;
  uint32_t x520;
  fiat_p384_uint1 x521;
  uint32_t x522;
  fiat_p384_uint1 x523;
  uint32_t x524;
  fiat_p384_uint1 x525;
  uint32_t x526;
  fiat_p384_uint1 x527;
  uint32_t x528;
  fiat_p384_uint1 x529;
  uint32_t x530;
  fiat_p384_uint1 x531;
  uint32_t x532;
  fiat_p384_uint1 x533;
  uint32_t x534;
  fiat_p384_uint1 x535;
  uint32_t x536;
  fiat_p384_uint1 x537;
  uint32_t x538;
  fiat_p384_uint1 x539;
  uint32_t x540;
  fiat_p384_uint1 x541;
  uint32_t x542;
  fiat_p384_uint1 x543;
  uint32_t x544;
  fiat_p384_uint1 x545;
  uint32_t x546;
  fiat_p384_uint1 x547;
  uint32_t x548;
  fiat_p384_uint1 x549;
  uint32_t x550;
  fiat_p384_uint1 x551;
  uint32_t x552;
  fiat_p384_uint1 x553;
  uint32_t x554;
  fiat_p384_uint1 x555;
  uint32_t x556;
  fiat_p384_uint1 x557;
  uint32_t x558;
  uint32_t x559;
  uint32_t x560;
  uint32_t x561;
  uint32_t x562;
  uint32_t x563;
  uint32_t x564;
  uint32_t x565;
  uint32_t x566;
  uint32_t x567;
  uint32_t x568;
  uint32_t x569;
  uint32_t x570;
  uint32_t x571;
  uint32_t x572;
  uint32_t x573;
  uint32_t x574;
  uint32_t x575;
  uint32_t x576;
  uint32_t x577;
  uint32_t x578;
  fiat_p384_uint1 x579;
  uint32_t x580;
  fiat_p384_uint1 x581;
  uint32_t x582;
  fiat_p384_uint1 x583;
  uint32_t x584;
  fiat_p384_uint1 x585;
  uint32_t x586;
  fiat_p384_uint1 x587;
  uint32_t x588;
  fiat_p384_uint1 x589;
  uint32_t x590;
  fiat_p384_uint1 x591;
  uint32_t x592;
  fiat_p384_uint1 x593;
  uint32_t x594;
  fiat_p384_uint1 x595;
  uint32_t x596;
  fiat_p384_uint1 x597;
  uint32_t x598;
  fiat_p384_uint1 x599;
  uint32_t x600;
  fiat_p384_uint1 x601;
  uint32_t x602;
  fiat_p384_uint1 x603;
  uint32_t x604;
  fiat_p384_uint1 x605;
  uint32_t x606;
  fiat_p384_uint1 x607;
  uint32_t x608;
  fiat_p384_uint1 x609;
  uint32_t x610;
  fiat_p384_uint1 x611;
  uint32_t x612;
  fiat_p384_uint1 x613;
  uint32_t x614;
  fiat_p384_uint1 x615;
  uint32_t x616;
  fiat_p384_uint1 x617;
  uint32_t x618;
  fiat_p384_uint1 x619;
  uint32_t x620;
  fiat_p384_uint1 x621;
  uint32_t x622;
  fiat_p384_uint1 x623;
  uint32_t x624;
  fiat_p384_uint1 x625;
  uint32_t x626;
  fiat_p384_uint1 x627;
  uint32_t x628;
  fiat_p384_uint1 x629;
  uint32_t x630;
  fiat_p384_uint1 x631;
  uint32_t x632;
  fiat_p384_uint1 x633;
  uint32_t x634;
  fiat_p384_uint1 x635;
  uint32_t x636;
  fiat_p384_uint1 x637;
  uint32_t x638;
  fiat_p384_uint1 x639;
  uint32_t x640;
  fiat_p384_uint1 x641;
  uint32_t x642;
  fiat_p384_uint1 x643;
  uint32_t x644;
  uint32_t x645;
  uint32_t x646;
  uint32_t x647;
  uint32_t x648;
  uint32_t x649;
  uint32_t x650;
  uint32_t x651;
  uint32_t x652;
  uint32_t x653;
  uint32_t x654;
  uint32_t x655;
  uint32_t x656;
  uint32_t x657;
  uint32_t x658;
  uint32_t x659;
  uint32_t x660;
  uint32_t x661;
  uint32_t x662;
  uint32_t x663;
  uint32_t x664;
  fiat_p384_uint1 x665;
  uint32_t x666;
  fiat_p384_uint1 x667;
  uint32_t x668;
  fiat_p384_uint1 x669;
  uint32_t x670;
  fiat_p384_uint1 x671;
  uint32_t x672;
  fiat_p384_uint1 x673;
  uint32_t x674;
  fiat_p384_uint1 x675;
  uint32_t x676;
  fiat_p384_uint1 x677;
  uint32_t x678;
  fiat_p384_uint1 x679;
  uint32_t x680;
  fiat_p384_uint1 x681;
  uint32_t x682;
  fiat_p384_uint1 x683;
  uint32_t x684;
  fiat_p384_uint1 x685;
  uint32_t x686;
  fiat_p384_uint1 x687;
  uint32_t x688;
  fiat_p384_uint1 x689;
  uint32_t x690;
  fiat_p384_uint1 x691;
  uint32_t x692;
  fiat_p384_uint1 x693;
  uint32_t x694;
  fiat_p384_uint1 x695;
  uint32_t x696;
  fiat_p384_uint1 x697;
  uint32_t x698;
  fiat_p384_uint1 x699;
  uint32_t x700;
  fiat_p384_uint1 x701;
  uint32_t x702;
  fiat_p384_uint1 x703;
  uint32_t x704;
  fiat_p384_uint1 x705;
  uint32_t x706;
  fiat_p384_uint1 x707;
  uint32_t x708;
  fiat_p384_uint1 x709;
  uint32_t x710;
  fiat_p384_uint1 x711;
  uint32_t x712;
  fiat_p384_uint1 x713;
  uint32_t x714;
  fiat_p384_uint1 x715;
  uint32_t x716;
  fiat_p384_uint1 x717;
  uint32_t x718;
  fiat_p384_uint1 x719;
  uint32_t x720;
  fiat_p384_uint1 x721;
  uint32_t x722;
  fiat_p384_uint1 x723;
  uint32_t x724;
  fiat_p384_uint1 x725;
  uint32_t x726;
  fiat_p384_uint1 x727;
  uint32_t x728;
  fiat_p384_uint1 x729;
  uint32_t x730;
  uint32_t x731;
  uint32_t x732;
  uint32_t x733;
  uint32_t x734;
  uint32_t x735;
  uint32_t x736;
  uint32_t x737;
  uint32_t x738;
  uint32_t x739;
  uint32_t x740;
  uint32_t x741;
  uint32_t x742;
  uint32_t x743;
  uint32_t x744;
  uint32_t x745;
  uint32_t x746;
  uint32_t x747;
  uint32_t x748;
  uint32_t x749;
  uint32_t x750;
  fiat_p384_uint1 x751;
  uint32_t x752;
  fiat_p384_uint1 x753;
  uint32_t x754;
  fiat_p384_uint1 x755;
  uint32_t x756;
  fiat_p384_uint1 x757;
  uint32_t x758;
  fiat_p384_uint1 x759;
  uint32_t x760;
  fiat_p384_uint1 x761;
  uint32_t x762;
  fiat_p384_uint1 x763;
  uint32_t x764;
  fiat_p384_uint1 x765;
  uint32_t x766;
  fiat_p384_uint1 x767;
  uint32_t x768;
  fiat_p384_uint1 x769;
  uint32_t x770;
  fiat_p384_uint1 x771;
  uint32_t x772;
  fiat_p384_uint1 x773;
  uint32_t x774;
  fiat_p384_uint1 x775;
  uint32_t x776;
  fiat_p384_uint1 x777;
  uint32_t x778;
  fiat_p384_uint1 x779;
  uint32_t x780;
  fiat_p384_uint1 x781;
  uint32_t x782;
  fiat_p384_uint1 x783;
  uint32_t x784;
  fiat_p384_uint1 x785;
  uint32_t x786;
  fiat_p384_uint1 x787;
  uint32_t x788;
  fiat_p384_uint1 x789;
  uint32_t x790;
  fiat_p384_uint1 x791;
  uint32_t x792;
  fiat_p384_uint1 x793;
  uint32_t x794;
  fiat_p384_uint1 x795;
  uint32_t x796;
  fiat_p384_uint1 x797;
  uint32_t x798;
  fiat_p384_uint1 x799;
  uint32_t x800;
  fiat_p384_uint1 x801;
  uint32_t x802;
  fiat_p384_uint1 x803;
  uint32_t x804;
  fiat_p384_uint1 x805;
  uint32_t x806;
  fiat_p384_uint1 x807;
  uint32_t x808;
  fiat_p384_uint1 x809;
  uint32_t x810;
  fiat_p384_uint1 x811;
  uint32_t x812;
  fiat_p384_uint1 x813;
  uint32_t x814;
  fiat_p384_uint1 x815;
  uint32_t x816;
  uint32_t x817;
  uint32_t x818;
  uint32_t x819;
  uint32_t x820;
  uint32_t x821;
  uint32_t x822;
  uint32_t x823;
  uint32_t x824;
  uint32_t x825;
  uint32_t x826;
  uint32_t x827;
  uint32_t x828;
  uint32_t x829;
  uint32_t x830;
  uint32_t x831;
  uint32_t x832;
  uint32_t x833;
  uint32_t x834;
  uint32_t x835;
  uint32_t x836;
  fiat_p384_uint1 x837;
  uint32_t x838;
  fiat_p384_uint1 x839;
  uint32_t x840;
  fiat_p384_uint1 x841;
  uint32_t x842;
  fiat_p384_uint1 x843;
  uint32_t x844;
  fiat_p384_uint1 x845;
  uint32_t x846;
  fiat_p384_uint1 x847;
  uint32_t x848;
  fiat_p384_uint1 x849;
  uint32_t x850;
  fiat_p384_uint1 x851;
  uint32_t x852;
  fiat_p384_uint1 x853;
  uint32_t x854;
  fiat_p384_uint1 x855;
  uint32_t x856;
  fiat_p384_uint1 x857;
  uint32_t x858;
  fiat_p384_uint1 x859;
  uint32_t x860;
  fiat_p384_uint1 x861;
  uint32_t x862;
  fiat_p384_uint1 x863;
  uint32_t x864;
  fiat_p384_uint1 x865;
  uint32_t x866;
  fiat_p384_uint1 x867;
  uint32_t x868;
  fiat_p384_uint1 x869;
  uint32_t x870;
  fiat_p384_uint1 x871;
  uint32_t x872;
  fiat_p384_uint1 x873;
  uint32_t x874;
  fiat_p384_uint1 x875;
  uint32_t x876;
  fiat_p384_uint1 x877;
  uint32_t x878;
  fiat_p384_uint1 x879;
  uint32_t x880;
  fiat_p384_uint1 x881;
  uint32_t x882;
  fiat_p384_uint1 x883;
  uint32_t x884;
  fiat_p384_uint1 x885;
  uint32_t x886;
  fiat_p384_uint1 x887;
  uint32_t x888;
  fiat_p384_uint1 x889;
  uint32_t x890;
  fiat_p384_uint1 x891;
  uint32_t x892;
  fiat_p384_uint1 x893;
  uint32_t x894;
  fiat_p384_uint1 x895;
  uint32_t x896;
  fiat_p384_uint1 x897;
  uint32_t x898;
  fiat_p384_uint1 x899;
  uint32_t x900;
  fiat_p384_uint1 x901;
  uint32_t x902;
  uint32_t x903;
  uint32_t x904;
  uint32_t x905;
  uint32_t x906;
  uint32_t x907;
  uint32_t x908;
  uint32_t x909;
  uint32_t x910;
  uint32_t x911;
  uint32_t x912;
  uint32_t x913;
  uint32_t x914;
  uint32_t x915;
  uint32_t x916;
  uint32_t x917;
  uint32_t x918;
  uint32_t x919;
  uint32_t x920;
  uint32_t x921;
  uint32_t x922;
  fiat_p384_uint1 x923;
  uint32_t x924;
  fiat_p384_uint1 x925;
  uint32_t x926;
  fiat_p384_uint1 x927;
  uint32_t x928;
  fiat_p384_uint1 x929;
  uint32_t x930;
  fiat_p384_uint1 x931;
  uint32_t x932;
  fiat_p384_uint1 x933;
  uint32_t x934;
  fiat_p384_uint1 x935;
  uint32_t x936;
  fiat_p384_uint1 x937;
  uint32_t x938;
  fiat_p384_uint1 x939;
  uint32_t x940;
  fiat_p384_uint1 x941;
  uint32_t x942;
  fiat_p384_uint1 x943;
  uint32_t x944;
  fiat_p384_uint1 x945;
  uint32_t x946;
  fiat_p384_uint1 x947;
  uint32_t x948;
  fiat_p384_uint1 x949;
  uint32_t x950;
  fiat_p384_uint1 x951;
  uint32_t x952;
  fiat_p384_uint1 x953;
  uint32_t x954;
  fiat_p384_uint1 x955;
  uint32_t x956;
  fiat_p384_uint1 x957;
  uint32_t x958;
  fiat_p384_uint1 x959;
  uint32_t x960;
  fiat_p384_uint1 x961;
  uint32_t x962;
  fiat_p384_uint1 x963;
  uint32_t x964;
  fiat_p384_uint1 x965;
  uint32_t x966;
  fiat_p384_uint1 x967;
  uint32_t x968;
  fiat_p384_uint1 x969;
  uint32_t x970;
  fiat_p384_uint1 x971;
  uint32_t x972;
  fiat_p384_uint1 x973;
  uint32_t x974;
  fiat_p384_uint1 x975;
  uint32_t x976;
  fiat_p384_uint1 x977;
  uint32_t x978;
  fiat_p384_uint1 x979;
  uint32_t x980;
  fiat_p384_uint1 x981;
  uint32_t x982;
  fiat_p384_uint1 x983;
  uint32_t x984;
  fiat_p384_uint1 x985;
  uint32_t x986;
  fiat_p384_uint1 x987;
  uint32_t x988;
  fiat_p384_uint1 x989;
  uint32_t x990;
  uint32_t x991;
  uint32_t x992;
  uint32_t x993;
  uint32_t x994;
  uint32_t x995;
  uint32_t x996;
  uint32_t x997;
  uint32_t x998;
  uint32_t x999;
  uint32_t x1000;
  uint32_t x1001;
  x1 = (arg1[0]);
  fiat_p384_mulx_u32(&x2, &x3, x1, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x4, &x5, x1, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x6, &x7, x1, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x8, &x9, x1, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x10, &x11, x1, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x12, &x13, x1, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x14, &x15, x1, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x16, &x17, x1, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x18, &x19, x1, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x20, &x21, x1, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x22, &x23, 0x0, x19, x16);
  fiat_p384_addcarryx_u32(&x24, &x25, x23, x17, x14);
  fiat_p384_addcarryx_u32(&x26, &x27, x25, x15, x12);
  fiat_p384_addcarryx_u32(&x28, &x29, x27, x13, x10);
  fiat_p384_addcarryx_u32(&x30, &x31, x29, x11, x8);
  fiat_p384_addcarryx_u32(&x32, &x33, x31, x9, x6);
  fiat_p384_addcarryx_u32(&x34, &x35, x33, x7, x4);
  fiat_p384_addcarryx_u32(&x36, &x37, x35, x5, x2);
  fiat_p384_addcarryx_u32(&x38, &x39, 0x0, x1, x20);
  fiat_p384_addcarryx_u32(&x40, &x41, 0x0, (x39 + x21), (arg1[1]));
  fiat_p384_mulx_u32(&x42, &x43, x40, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x44, &x45, x40, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x46, &x47, x40, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x48, &x49, x40, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x50, &x51, x40, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x52, &x53, x40, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x54, &x55, x40, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x56, &x57, x40, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x58, &x59, x40, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x60, &x61, x40, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x62, &x63, 0x0, x59, x56);
  fiat_p384_addcarryx_u32(&x64, &x65, x63, x57, x54);
  fiat_p384_addcarryx_u32(&x66, &x67, x65, x55, x52);
  fiat_p384_addcarryx_u32(&x68, &x69, x67, x53, x50);
  fiat_p384_addcarryx_u32(&x70, &x71, x69, x51, x48);
  fiat_p384_addcarryx_u32(&x72, &x73, x71, x49, x46);
  fiat_p384_addcarryx_u32(&x74, &x75, x73, x47, x44);
  fiat_p384_addcarryx_u32(&x76, &x77, x75, x45, x42);
  fiat_p384_addcarryx_u32(&x78, &x79, 0x0, x40, x60);
  fiat_p384_addcarryx_u32(&x80, &x81, x79, x41, x61);
  fiat_p384_addcarryx_u32(&x82, &x83, x81, x18, 0x0);
  fiat_p384_addcarryx_u32(&x84, &x85, x83, x22, x58);
  fiat_p384_addcarryx_u32(&x86, &x87, x85, x24, x62);
  fiat_p384_addcarryx_u32(&x88, &x89, x87, x26, x64);
  fiat_p384_addcarryx_u32(&x90, &x91, x89, x28, x66);
  fiat_p384_addcarryx_u32(&x92, &x93, x91, x30, x68);
  fiat_p384_addcarryx_u32(&x94, &x95, x93, x32, x70);
  fiat_p384_addcarryx_u32(&x96, &x97, x95, x34, x72);
  fiat_p384_addcarryx_u32(&x98, &x99, x97, x36, x74);
  fiat_p384_addcarryx_u32(&x100, &x101, x99, (x37 + x3), x76);
  fiat_p384_addcarryx_u32(&x102, &x103, x101, 0x0, (x77 + x43));
  fiat_p384_addcarryx_u32(&x104, &x105, 0x0, x80, (arg1[2]));
  fiat_p384_addcarryx_u32(&x106, &x107, x105, x82, 0x0);
  fiat_p384_addcarryx_u32(&x108, &x109, x107, x84, 0x0);
  fiat_p384_addcarryx_u32(&x110, &x111, x109, x86, 0x0);
  fiat_p384_addcarryx_u32(&x112, &x113, x111, x88, 0x0);
  fiat_p384_addcarryx_u32(&x114, &x115, x113, x90, 0x0);
  fiat_p384_addcarryx_u32(&x116, &x117, x115, x92, 0x0);
  fiat_p384_addcarryx_u32(&x118, &x119, x117, x94, 0x0);
  fiat_p384_addcarryx_u32(&x120, &x121, x119, x96, 0x0);
  fiat_p384_addcarryx_u32(&x122, &x123, x121, x98, 0x0);
  fiat_p384_addcarryx_u32(&x124, &x125, x123, x100, 0x0);
  fiat_p384_addcarryx_u32(&x126, &x127, x125, x102, 0x0);
  fiat_p384_mulx_u32(&x128, &x129, x104, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x130, &x131, x104, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x132, &x133, x104, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x134, &x135, x104, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x136, &x137, x104, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x138, &x139, x104, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x140, &x141, x104, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x142, &x143, x104, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x144, &x145, x104, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x146, &x147, x104, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x148, &x149, 0x0, x145, x142);
  fiat_p384_addcarryx_u32(&x150, &x151, x149, x143, x140);
  fiat_p384_addcarryx_u32(&x152, &x153, x151, x141, x138);
  fiat_p384_addcarryx_u32(&x154, &x155, x153, x139, x136);
  fiat_p384_addcarryx_u32(&x156, &x157, x155, x137, x134);
  fiat_p384_addcarryx_u32(&x158, &x159, x157, x135, x132);
  fiat_p384_addcarryx_u32(&x160, &x161, x159, x133, x130);
  fiat_p384_addcarryx_u32(&x162, &x163, x161, x131, x128);
  fiat_p384_addcarryx_u32(&x164, &x165, 0x0, x104, x146);
  fiat_p384_addcarryx_u32(&x166, &x167, x165, x106, x147);
  fiat_p384_addcarryx_u32(&x168, &x169, x167, x108, 0x0);
  fiat_p384_addcarryx_u32(&x170, &x171, x169, x110, x144);
  fiat_p384_addcarryx_u32(&x172, &x173, x171, x112, x148);
  fiat_p384_addcarryx_u32(&x174, &x175, x173, x114, x150);
  fiat_p384_addcarryx_u32(&x176, &x177, x175, x116, x152);
  fiat_p384_addcarryx_u32(&x178, &x179, x177, x118, x154);
  fiat_p384_addcarryx_u32(&x180, &x181, x179, x120, x156);
  fiat_p384_addcarryx_u32(&x182, &x183, x181, x122, x158);
  fiat_p384_addcarryx_u32(&x184, &x185, x183, x124, x160);
  fiat_p384_addcarryx_u32(&x186, &x187, x185, x126, x162);
  fiat_p384_addcarryx_u32(&x188, &x189, x187, ((uint32_t)x127 + x103), (x163 + x129));
  fiat_p384_addcarryx_u32(&x190, &x191, 0x0, x166, (arg1[3]));
  fiat_p384_addcarryx_u32(&x192, &x193, x191, x168, 0x0);
  fiat_p384_addcarryx_u32(&x194, &x195, x193, x170, 0x0);
  fiat_p384_addcarryx_u32(&x196, &x197, x195, x172, 0x0);
  fiat_p384_addcarryx_u32(&x198, &x199, x197, x174, 0x0);
  fiat_p384_addcarryx_u32(&x200, &x201, x199, x176, 0x0);
  fiat_p384_addcarryx_u32(&x202, &x203, x201, x178, 0x0);
  fiat_p384_addcarryx_u32(&x204, &x205, x203, x180, 0x0);
  fiat_p384_addcarryx_u32(&x206, &x207, x205, x182, 0x0);
  fiat_p384_addcarryx_u32(&x208, &x209, x207, x184, 0x0);
  fiat_p384_addcarryx_u32(&x210, &x211, x209, x186, 0x0);
  fiat_p384_addcarryx_u32(&x212, &x213, x211, x188, 0x0);
  fiat_p384_mulx_u32(&x214, &x215, x190, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x216, &x217, x190, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x218, &x219, x190, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x220, &x221, x190, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x222, &x223, x190, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x224, &x225, x190, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x226, &x227, x190, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x228, &x229, x190, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x230, &x231, x190, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x232, &x233, x190, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x234, &x235, 0x0, x231, x228);
  fiat_p384_addcarryx_u32(&x236, &x237, x235, x229, x226);
  fiat_p384_addcarryx_u32(&x238, &x239, x237, x227, x224);
  fiat_p384_addcarryx_u32(&x240, &x241, x239, x225, x222);
  fiat_p384_addcarryx_u32(&x242, &x243, x241, x223, x220);
  fiat_p384_addcarryx_u32(&x244, &x245, x243, x221, x218);
  fiat_p384_addcarryx_u32(&x246, &x247, x245, x219, x216);
  fiat_p384_addcarryx_u32(&x248, &x249, x247, x217, x214);
  fiat_p384_addcarryx_u32(&x250, &x251, 0x0, x190, x232);
  fiat_p384_addcarryx_u32(&x252, &x253, x251, x192, x233);
  fiat_p384_addcarryx_u32(&x254, &x255, x253, x194, 0x0);
  fiat_p384_addcarryx_u32(&x256, &x257, x255, x196, x230);
  fiat_p384_addcarryx_u32(&x258, &x259, x257, x198, x234);
  fiat_p384_addcarryx_u32(&x260, &x261, x259, x200, x236);
  fiat_p384_addcarryx_u32(&x262, &x263, x261, x202, x238);
  fiat_p384_addcarryx_u32(&x264, &x265, x263, x204, x240);
  fiat_p384_addcarryx_u32(&x266, &x267, x265, x206, x242);
  fiat_p384_addcarryx_u32(&x268, &x269, x267, x208, x244);
  fiat_p384_addcarryx_u32(&x270, &x271, x269, x210, x246);
  fiat_p384_addcarryx_u32(&x272, &x273, x271, x212, x248);
  fiat_p384_addcarryx_u32(&x274, &x275, x273, ((uint32_t)x213 + x189), (x249 + x215));
  fiat_p384_addcarryx_u32(&x276, &x277, 0x0, x252, (arg1[4]));
  fiat_p384_addcarryx_u32(&x278, &x279, x277, x254, 0x0);
  fiat_p384_addcarryx_u32(&x280, &x281, x279, x256, 0x0);
  fiat_p384_addcarryx_u32(&x282, &x283, x281, x258, 0x0);
  fiat_p384_addcarryx_u32(&x284, &x285, x283, x260, 0x0);
  fiat_p384_addcarryx_u32(&x286, &x287, x285, x262, 0x0);
  fiat_p384_addcarryx_u32(&x288, &x289, x287, x264, 0x0);
  fiat_p384_addcarryx_u32(&x290, &x291, x289, x266, 0x0);
  fiat_p384_addcarryx_u32(&x292, &x293, x291, x268, 0x0);
  fiat_p384_addcarryx_u32(&x294, &x295, x293, x270, 0x0);
  fiat_p384_addcarryx_u32(&x296, &x297, x295, x272, 0x0);
  fiat_p384_addcarryx_u32(&x298, &x299, x297, x274, 0x0);
  fiat_p384_mulx_u32(&x300, &x301, x276, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x302, &x303, x276, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x304, &x305, x276, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x306, &x307, x276, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x308, &x309, x276, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x310, &x311, x276, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x312, &x313, x276, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x314, &x315, x276, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x316, &x317, x276, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x318, &x319, x276, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x320, &x321, 0x0, x317, x314);
  fiat_p384_addcarryx_u32(&x322, &x323, x321, x315, x312);
  fiat_p384_addcarryx_u32(&x324, &x325, x323, x313, x310);
  fiat_p384_addcarryx_u32(&x326, &x327, x325, x311, x308);
  fiat_p384_addcarryx_u32(&x328, &x329, x327, x309, x306);
  fiat_p384_addcarryx_u32(&x330, &x331, x329, x307, x304);
  fiat_p384_addcarryx_u32(&x332, &x333, x331, x305, x302);
  fiat_p384_addcarryx_u32(&x334, &x335, x333, x303, x300);
  fiat_p384_addcarryx_u32(&x336, &x337, 0x0, x276, x318);
  fiat_p384_addcarryx_u32(&x338, &x339, x337, x278, x319);
  fiat_p384_addcarryx_u32(&x340, &x341, x339, x280, 0x0);
  fiat_p384_addcarryx_u32(&x342, &x343, x341, x282, x316);
  fiat_p384_addcarryx_u32(&x344, &x345, x343, x284, x320);
  fiat_p384_addcarryx_u32(&x346, &x347, x345, x286, x322);
  fiat_p384_addcarryx_u32(&x348, &x349, x347, x288, x324);
  fiat_p384_addcarryx_u32(&x350, &x351, x349, x290, x326);
  fiat_p384_addcarryx_u32(&x352, &x353, x351, x292, x328);
  fiat_p384_addcarryx_u32(&x354, &x355, x353, x294, x330);
  fiat_p384_addcarryx_u32(&x356, &x357, x355, x296, x332);
  fiat_p384_addcarryx_u32(&x358, &x359, x357, x298, x334);
  fiat_p384_addcarryx_u32(&x360, &x361, x359, ((uint32_t)x299 + x275), (x335 + x301));
  fiat_p384_addcarryx_u32(&x362, &x363, 0x0, x338, (arg1[5]));
  fiat_p384_addcarryx_u32(&x364, &x365, x363, x340, 0x0);
  fiat_p384_addcarryx_u32(&x366, &x367, x365, x342, 0x0);
  fiat_p384_addcarryx_u32(&x368, &x369, x367, x344, 0x0);
  fiat_p384_addcarryx_u32(&x370, &x371, x369, x346, 0x0);
  fiat_p384_addcarryx_u32(&x372, &x373, x371, x348, 0x0);
  fiat_p384_addcarryx_u32(&x374, &x375, x373, x350, 0x0);
  fiat_p384_addcarryx_u32(&x376, &x377, x375, x352, 0x0);
  fiat_p384_addcarryx_u32(&x378, &x379, x377, x354, 0x0);
  fiat_p384_addcarryx_u32(&x380, &x381, x379, x356, 0x0);
  fiat_p384_addcarryx_u32(&x382, &x383, x381, x358, 0x0);
  fiat_p384_addcarryx_u32(&x384, &x385, x383, x360, 0x0);
  fiat_p384_mulx_u32(&x386, &x387, x362, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x388, &x389, x362, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x390, &x391, x362, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x392, &x393, x362, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x394, &x395, x362, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x396, &x397, x362, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x398, &x399, x362, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x400, &x401, x362, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x402, &x403, x362, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x404, &x405, x362, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x406, &x407, 0x0, x403, x400);
  fiat_p384_addcarryx_u32(&x408, &x409, x407, x401, x398);
  fiat_p384_addcarryx_u32(&x410, &x411, x409, x399, x396);
  fiat_p384_addcarryx_u32(&x412, &x413, x411, x397, x394);
  fiat_p384_addcarryx_u32(&x414, &x415, x413, x395, x392);
  fiat_p384_addcarryx_u32(&x416, &x417, x415, x393, x390);
  fiat_p384_addcarryx_u32(&x418, &x419, x417, x391, x388);
  fiat_p384_addcarryx_u32(&x420, &x421, x419, x389, x386);
  fiat_p384_addcarryx_u32(&x422, &x423, 0x0, x362, x404);
  fiat_p384_addcarryx_u32(&x424, &x425, x423, x364, x405);
  fiat_p384_addcarryx_u32(&x426, &x427, x425, x366, 0x0);
  fiat_p384_addcarryx_u32(&x428, &x429, x427, x368, x402);
  fiat_p384_addcarryx_u32(&x430, &x431, x429, x370, x406);
  fiat_p384_addcarryx_u32(&x432, &x433, x431, x372, x408);
  fiat_p384_addcarryx_u32(&x434, &x435, x433, x374, x410);
  fiat_p384_addcarryx_u32(&x436, &x437, x435, x376, x412);
  fiat_p384_addcarryx_u32(&x438, &x439, x437, x378, x414);
  fiat_p384_addcarryx_u32(&x440, &x441, x439, x380, x416);
  fiat_p384_addcarryx_u32(&x442, &x443, x441, x382, x418);
  fiat_p384_addcarryx_u32(&x444, &x445, x443, x384, x420);
  fiat_p384_addcarryx_u32(&x446, &x447, x445, ((uint32_t)x385 + x361), (x421 + x387));
  fiat_p384_addcarryx_u32(&x448, &x449, 0x0, x424, (arg1[6]));
  fiat_p384_addcarryx_u32(&x450, &x451, x449, x426, 0x0);
  fiat_p384_addcarryx_u32(&x452, &x453, x451, x428, 0x0);
  fiat_p384_addcarryx_u32(&x454, &x455, x453, x430, 0x0);
  fiat_p384_addcarryx_u32(&x456, &x457, x455, x432, 0x0);
  fiat_p384_addcarryx_u32(&x458, &x459, x457, x434, 0x0);
  fiat_p384_addcarryx_u32(&x460, &x461, x459, x436, 0x0);
  fiat_p384_addcarryx_u32(&x462, &x463, x461, x438, 0x0);
  fiat_p384_addcarryx_u32(&x464, &x465, x463, x440, 0x0);
  fiat_p384_addcarryx_u32(&x466, &x467, x465, x442, 0x0);
  fiat_p384_addcarryx_u32(&x468, &x469, x467, x444, 0x0);
  fiat_p384_addcarryx_u32(&x470, &x471, x469, x446, 0x0);
  fiat_p384_mulx_u32(&x472, &x473, x448, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x474, &x475, x448, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x476, &x477, x448, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x478, &x479, x448, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x480, &x481, x448, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x482, &x483, x448, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x484, &x485, x448, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x486, &x487, x448, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x488, &x489, x448, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x490, &x491, x448, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x492, &x493, 0x0, x489, x486);
  fiat_p384_addcarryx_u32(&x494, &x495, x493, x487, x484);
  fiat_p384_addcarryx_u32(&x496, &x497, x495, x485, x482);
  fiat_p384_addcarryx_u32(&x498, &x499, x497, x483, x480);
  fiat_p384_addcarryx_u32(&x500, &x501, x499, x481, x478);
  fiat_p384_addcarryx_u32(&x502, &x503, x501, x479, x476);
  fiat_p384_addcarryx_u32(&x504, &x505, x503, x477, x474);
  fiat_p384_addcarryx_u32(&x506, &x507, x505, x475, x472);
  fiat_p384_addcarryx_u32(&x508, &x509, 0x0, x448, x490);
  fiat_p384_addcarryx_u32(&x510, &x511, x509, x450, x491);
  fiat_p384_addcarryx_u32(&x512, &x513, x511, x452, 0x0);
  fiat_p384_addcarryx_u32(&x514, &x515, x513, x454, x488);
  fiat_p384_addcarryx_u32(&x516, &x517, x515, x456, x492);
  fiat_p384_addcarryx_u32(&x518, &x519, x517, x458, x494);
  fiat_p384_addcarryx_u32(&x520, &x521, x519, x460, x496);
  fiat_p384_addcarryx_u32(&x522, &x523, x521, x462, x498);
  fiat_p384_addcarryx_u32(&x524, &x525, x523, x464, x500);
  fiat_p384_addcarryx_u32(&x526, &x527, x525, x466, x502);
  fiat_p384_addcarryx_u32(&x528, &x529, x527, x468, x504);
  fiat_p384_addcarryx_u32(&x530, &x531, x529, x470, x506);
  fiat_p384_addcarryx_u32(&x532, &x533, x531, ((uint32_t)x471 + x447), (x507 + x473));
  fiat_p384_addcarryx_u32(&x534, &x535, 0x0, x510, (arg1[7]));
  fiat_p384_addcarryx_u32(&x536, &x537, x535, x512, 0x0);
  fiat_p384_addcarryx_u32(&x538, &x539, x537, x514, 0x0);
  fiat_p384_addcarryx_u32(&x540, &x541, x539, x516, 0x0);
  fiat_p384_addcarryx_u32(&x542, &x543, x541, x518, 0x0);
  fiat_p384_addcarryx_u32(&x544, &x545, x543, x520, 0x0);
  fiat_p384_addcarryx_u32(&x546, &x547, x545, x522, 0x0);
  fiat_p384_addcarryx_u32(&x548, &x549, x547, x524, 0x0);
  fiat_p384_addcarryx_u32(&x550, &x551, x549, x526, 0x0);
  fiat_p384_addcarryx_u32(&x552, &x553, x551, x528, 0x0);
  fiat_p384_addcarryx_u32(&x554, &x555, x553, x530, 0x0);
  fiat_p384_addcarryx_u32(&x556, &x557, x555, x532, 0x0);
  fiat_p384_mulx_u32(&x558, &x559, x534, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x560, &x561, x534, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x562, &x563, x534, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x564, &x565, x534, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x566, &x567, x534, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x568, &x569, x534, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x570, &x571, x534, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x572, &x573, x534, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x574, &x575, x534, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x576, &x577, x534, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x578, &x579, 0x0, x575, x572);
  fiat_p384_addcarryx_u32(&x580, &x581, x579, x573, x570);
  fiat_p384_addcarryx_u32(&x582, &x583, x581, x571, x568);
  fiat_p384_addcarryx_u32(&x584, &x585, x583, x569, x566);
  fiat_p384_addcarryx_u32(&x586, &x587, x585, x567, x564);
  fiat_p384_addcarryx_u32(&x588, &x589, x587, x565, x562);
  fiat_p384_addcarryx_u32(&x590, &x591, x589, x563, x560);
  fiat_p384_addcarryx_u32(&x592, &x593, x591, x561, x558);
  fiat_p384_addcarryx_u32(&x594, &x595, 0x0, x534, x576);
  fiat_p384_addcarryx_u32(&x596, &x597, x595, x536, x577);
  fiat_p384_addcarryx_u32(&x598, &x599, x597, x538, 0x0);
  fiat_p384_addcarryx_u32(&x600, &x601, x599, x540, x574);
  fiat_p384_addcarryx_u32(&x602, &x603, x601, x542, x578);
  fiat_p384_addcarryx_u32(&x604, &x605, x603, x544, x580);
  fiat_p384_addcarryx_u32(&x606, &x607, x605, x546, x582);
  fiat_p384_addcarryx_u32(&x608, &x609, x607, x548, x584);
  fiat_p384_addcarryx_u32(&x610, &x611, x609, x550, x586);
  fiat_p384_addcarryx_u32(&x612, &x613, x611, x552, x588);
  fiat_p384_addcarryx_u32(&x614, &x615, x613, x554, x590);
  fiat_p384_addcarryx_u32(&x616, &x617, x615, x556, x592);
  fiat_p384_addcarryx_u32(&x618, &x619, x617, ((uint32_t)x557 + x533), (x593 + x559));
  fiat_p384_addcarryx_u32(&x620, &x621, 0x0, x596, (arg1[8]));
  fiat_p384_addcarryx_u32(&x622, &x623, x621, x598, 0x0);
  fiat_p384_addcarryx_u32(&x624, &x625, x623, x600, 0x0);
  fiat_p384_addcarryx_u32(&x626, &x627, x625, x602, 0x0);
  fiat_p384_addcarryx_u32(&x628, &x629, x627, x604, 0x0);
  fiat_p384_addcarryx_u32(&x630, &x631, x629, x606, 0x0);
  fiat_p384_addcarryx_u32(&x632, &x633, x631, x608, 0x0);
  fiat_p384_addcarryx_u32(&x634, &x635, x633, x610, 0x0);
  fiat_p384_addcarryx_u32(&x636, &x637, x635, x612, 0x0);
  fiat_p384_addcarryx_u32(&x638, &x639, x637, x614, 0x0);
  fiat_p384_addcarryx_u32(&x640, &x641, x639, x616, 0x0);
  fiat_p384_addcarryx_u32(&x642, &x643, x641, x618, 0x0);
  fiat_p384_mulx_u32(&x644, &x645, x620, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x646, &x647, x620, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x648, &x649, x620, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x650, &x651, x620, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x652, &x653, x620, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x654, &x655, x620, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x656, &x657, x620, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x658, &x659, x620, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x660, &x661, x620, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x662, &x663, x620, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x664, &x665, 0x0, x661, x658);
  fiat_p384_addcarryx_u32(&x666, &x667, x665, x659, x656);
  fiat_p384_addcarryx_u32(&x668, &x669, x667, x657, x654);
  fiat_p384_addcarryx_u32(&x670, &x671, x669, x655, x652);
  fiat_p384_addcarryx_u32(&x672, &x673, x671, x653, x650);
  fiat_p384_addcarryx_u32(&x674, &x675, x673, x651, x648);
  fiat_p384_addcarryx_u32(&x676, &x677, x675, x649, x646);
  fiat_p384_addcarryx_u32(&x678, &x679, x677, x647, x644);
  fiat_p384_addcarryx_u32(&x680, &x681, 0x0, x620, x662);
  fiat_p384_addcarryx_u32(&x682, &x683, x681, x622, x663);
  fiat_p384_addcarryx_u32(&x684, &x685, x683, x624, 0x0);
  fiat_p384_addcarryx_u32(&x686, &x687, x685, x626, x660);
  fiat_p384_addcarryx_u32(&x688, &x689, x687, x628, x664);
  fiat_p384_addcarryx_u32(&x690, &x691, x689, x630, x666);
  fiat_p384_addcarryx_u32(&x692, &x693, x691, x632, x668);
  fiat_p384_addcarryx_u32(&x694, &x695, x693, x634, x670);
  fiat_p384_addcarryx_u32(&x696, &x697, x695, x636, x672);
  fiat_p384_addcarryx_u32(&x698, &x699, x697, x638, x674);
  fiat_p384_addcarryx_u32(&x700, &x701, x699, x640, x676);
  fiat_p384_addcarryx_u32(&x702, &x703, x701, x642, x678);
  fiat_p384_addcarryx_u32(&x704, &x705, x703, ((uint32_t)x643 + x619), (x679 + x645));
  fiat_p384_addcarryx_u32(&x706, &x707, 0x0, x682, (arg1[9]));
  fiat_p384_addcarryx_u32(&x708, &x709, x707, x684, 0x0);
  fiat_p384_addcarryx_u32(&x710, &x711, x709, x686, 0x0);
  fiat_p384_addcarryx_u32(&x712, &x713, x711, x688, 0x0);
  fiat_p384_addcarryx_u32(&x714, &x715, x713, x690, 0x0);
  fiat_p384_addcarryx_u32(&x716, &x717, x715, x692, 0x0);
  fiat_p384_addcarryx_u32(&x718, &x719, x717, x694, 0x0);
  fiat_p384_addcarryx_u32(&x720, &x721, x719, x696, 0x0);
  fiat_p384_addcarryx_u32(&x722, &x723, x721, x698, 0x0);
  fiat_p384_addcarryx_u32(&x724, &x725, x723, x700, 0x0);
  fiat_p384_addcarryx_u32(&x726, &x727, x725, x702, 0x0);
  fiat_p384_addcarryx_u32(&x728, &x729, x727, x704, 0x0);
  fiat_p384_mulx_u32(&x730, &x731, x706, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x732, &x733, x706, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x734, &x735, x706, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x736, &x737, x706, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x738, &x739, x706, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x740, &x741, x706, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x742, &x743, x706, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x744, &x745, x706, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x746, &x747, x706, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x748, &x749, x706, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x750, &x751, 0x0, x747, x744);
  fiat_p384_addcarryx_u32(&x752, &x753, x751, x745, x742);
  fiat_p384_addcarryx_u32(&x754, &x755, x753, x743, x740);
  fiat_p384_addcarryx_u32(&x756, &x757, x755, x741, x738);
  fiat_p384_addcarryx_u32(&x758, &x759, x757, x739, x736);
  fiat_p384_addcarryx_u32(&x760, &x761, x759, x737, x734);
  fiat_p384_addcarryx_u32(&x762, &x763, x761, x735, x732);
  fiat_p384_addcarryx_u32(&x764, &x765, x763, x733, x730);
  fiat_p384_addcarryx_u32(&x766, &x767, 0x0, x706, x748);
  fiat_p384_addcarryx_u32(&x768, &x769, x767, x708, x749);
  fiat_p384_addcarryx_u32(&x770, &x771, x769, x710, 0x0);
  fiat_p384_addcarryx_u32(&x772, &x773, x771, x712, x746);
  fiat_p384_addcarryx_u32(&x774, &x775, x773, x714, x750);
  fiat_p384_addcarryx_u32(&x776, &x777, x775, x716, x752);
  fiat_p384_addcarryx_u32(&x778, &x779, x777, x718, x754);
  fiat_p384_addcarryx_u32(&x780, &x781, x779, x720, x756);
  fiat_p384_addcarryx_u32(&x782, &x783, x781, x722, x758);
  fiat_p384_addcarryx_u32(&x784, &x785, x783, x724, x760);
  fiat_p384_addcarryx_u32(&x786, &x787, x785, x726, x762);
  fiat_p384_addcarryx_u32(&x788, &x789, x787, x728, x764);
  fiat_p384_addcarryx_u32(&x790, &x791, x789, ((uint32_t)x729 + x705), (x765 + x731));
  fiat_p384_addcarryx_u32(&x792, &x793, 0x0, x768, (arg1[10]));
  fiat_p384_addcarryx_u32(&x794, &x795, x793, x770, 0x0);
  fiat_p384_addcarryx_u32(&x796, &x797, x795, x772, 0x0);
  fiat_p384_addcarryx_u32(&x798, &x799, x797, x774, 0x0);
  fiat_p384_addcarryx_u32(&x800, &x801, x799, x776, 0x0);
  fiat_p384_addcarryx_u32(&x802, &x803, x801, x778, 0x0);
  fiat_p384_addcarryx_u32(&x804, &x805, x803, x780, 0x0);
  fiat_p384_addcarryx_u32(&x806, &x807, x805, x782, 0x0);
  fiat_p384_addcarryx_u32(&x808, &x809, x807, x784, 0x0);
  fiat_p384_addcarryx_u32(&x810, &x811, x809, x786, 0x0);
  fiat_p384_addcarryx_u32(&x812, &x813, x811, x788, 0x0);
  fiat_p384_addcarryx_u32(&x814, &x815, x813, x790, 0x0);
  fiat_p384_mulx_u32(&x816, &x817, x792, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x818, &x819, x792, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x820, &x821, x792, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x822, &x823, x792, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x824, &x825, x792, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x826, &x827, x792, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x828, &x829, x792, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x830, &x831, x792, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x832, &x833, x792, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x834, &x835, x792, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x836, &x837, 0x0, x833, x830);
  fiat_p384_addcarryx_u32(&x838, &x839, x837, x831, x828);
  fiat_p384_addcarryx_u32(&x840, &x841, x839, x829, x826);
  fiat_p384_addcarryx_u32(&x842, &x843, x841, x827, x824);
  fiat_p384_addcarryx_u32(&x844, &x845, x843, x825, x822);
  fiat_p384_addcarryx_u32(&x846, &x847, x845, x823, x820);
  fiat_p384_addcarryx_u32(&x848, &x849, x847, x821, x818);
  fiat_p384_addcarryx_u32(&x850, &x851, x849, x819, x816);
  fiat_p384_addcarryx_u32(&x852, &x853, 0x0, x792, x834);
  fiat_p384_addcarryx_u32(&x854, &x855, x853, x794, x835);
  fiat_p384_addcarryx_u32(&x856, &x857, x855, x796, 0x0);
  fiat_p384_addcarryx_u32(&x858, &x859, x857, x798, x832);
  fiat_p384_addcarryx_u32(&x860, &x861, x859, x800, x836);
  fiat_p384_addcarryx_u32(&x862, &x863, x861, x802, x838);
  fiat_p384_addcarryx_u32(&x864, &x865, x863, x804, x840);
  fiat_p384_addcarryx_u32(&x866, &x867, x865, x806, x842);
  fiat_p384_addcarryx_u32(&x868, &x869, x867, x808, x844);
  fiat_p384_addcarryx_u32(&x870, &x871, x869, x810, x846);
  fiat_p384_addcarryx_u32(&x872, &x873, x871, x812, x848);
  fiat_p384_addcarryx_u32(&x874, &x875, x873, x814, x850);
  fiat_p384_addcarryx_u32(&x876, &x877, x875, ((uint32_t)x815 + x791), (x851 + x817));
  fiat_p384_addcarryx_u32(&x878, &x879, 0x0, x854, (arg1[11]));
  fiat_p384_addcarryx_u32(&x880, &x881, x879, x856, 0x0);
  fiat_p384_addcarryx_u32(&x882, &x883, x881, x858, 0x0);
  fiat_p384_addcarryx_u32(&x884, &x885, x883, x860, 0x0);
  fiat_p384_addcarryx_u32(&x886, &x887, x885, x862, 0x0);
  fiat_p384_addcarryx_u32(&x888, &x889, x887, x864, 0x0);
  fiat_p384_addcarryx_u32(&x890, &x891, x889, x866, 0x0);
  fiat_p384_addcarryx_u32(&x892, &x893, x891, x868, 0x0);
  fiat_p384_addcarryx_u32(&x894, &x895, x893, x870, 0x0);
  fiat_p384_addcarryx_u32(&x896, &x897, x895, x872, 0x0);
  fiat_p384_addcarryx_u32(&x898, &x899, x897, x874, 0x0);
  fiat_p384_addcarryx_u32(&x900, &x901, x899, x876, 0x0);
  fiat_p384_mulx_u32(&x902, &x903, x878, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x904, &x905, x878, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x906, &x907, x878, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x908, &x909, x878, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x910, &x911, x878, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x912, &x913, x878, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x914, &x915, x878, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x916, &x917, x878, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x918, &x919, x878, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x920, &x921, x878, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x922, &x923, 0x0, x919, x916);
  fiat_p384_addcarryx_u32(&x924, &x925, x923, x917, x914);
  fiat_p384_addcarryx_u32(&x926, &x927, x925, x915, x912);
  fiat_p384_addcarryx_u32(&x928, &x929, x927, x913, x910);
  fiat_p384_addcarryx_u32(&x930, &x931, x929, x911, x908);
  fiat_p384_addcarryx_u32(&x932, &x933, x931, x909, x906);
  fiat_p384_addcarryx_u32(&x934, &x935, x933, x907, x904);
  fiat_p384_addcarryx_u32(&x936, &x937, x935, x905, x902);
  fiat_p384_addcarryx_u32(&x938, &x939, 0x0, x878, x920);
  fiat_p384_addcarryx_u32(&x940, &x941, x939, x880, x921);
  fiat_p384_addcarryx_u32(&x942, &x943, x941, x882, 0x0);
  fiat_p384_addcarryx_u32(&x944, &x945, x943, x884, x918);
  fiat_p384_addcarryx_u32(&x946, &x947, x945, x886, x922);
  fiat_p384_addcarryx_u32(&x948, &x949, x947, x888, x924);
  fiat_p384_addcarryx_u32(&x950, &x951, x949, x890, x926);
  fiat_p384_addcarryx_u32(&x952, &x953, x951, x892, x928);
  fiat_p384_addcarryx_u32(&x954, &x955, x953, x894, x930);
  fiat_p384_addcarryx_u32(&x956, &x957, x955, x896, x932);
  fiat_p384_addcarryx_u32(&x958, &x959, x957, x898, x934);
  fiat_p384_addcarryx_u32(&x960, &x961, x959, x900, x936);
  fiat_p384_addcarryx_u32(&x962, &x963, x961, ((uint32_t)x901 + x877), (x937 + x903));
  fiat_p384_subborrowx_u32(&x964, &x965, 0x0, x940, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x966, &x967, x965, x942, 0x0);
  fiat_p384_subborrowx_u32(&x968, &x969, x967, x944, 0x0);
  fiat_p384_subborrowx_u32(&x970, &x971, x969, x946, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x972, &x973, x971, x948, UINT32_C(0xfffffffe));
  fiat_p384_subborrowx_u32(&x974, &x975, x973, x950, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x976, &x977, x975, x952, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x978, &x979, x977, x954, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x980, &x981, x979, x956, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x982, &x983, x981, x958, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x984, &x985, x983, x960, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x986, &x987, x985, x962, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x988, &x989, x987, x963, 0x0);
  fiat_p384_cmovznz_u32(&x990, x989, x964, x940);
  fiat_p384_cmovznz_u32(&x991, x989, x966, x942);
  fiat_p384_cmovznz_u32(&x992, x989, x968, x944);
  fiat_p384_cmovznz_u32(&x993, x989, x970, x946);
  fiat_p384_cmovznz_u32(&x994, x989, x972, x948);
  fiat_p384_cmovznz_u32(&x995, x989, x974, x950);
  fiat_p384_cmovznz_u32(&x996, x989, x976, x952);
  fiat_p384_cmovznz_u32(&x997, x989, x978, x954);
  fiat_p384_cmovznz_u32(&x998, x989, x980, x956);
  fiat_p384_cmovznz_u32(&x999, x989, x982, x958);
  fiat_p384_cmovznz_u32(&x1000, x989, x984, x960);
  fiat_p384_cmovznz_u32(&x1001, x989, x986, x962);
  out1[0] = x990;
  out1[1] = x991;
  out1[2] = x992;
  out1[3] = x993;
  out1[4] = x994;
  out1[5] = x995;
  out1[6] = x996;
  out1[7] = x997;
  out1[8] = x998;
  out1[9] = x999;
  out1[10] = x1000;
  out1[11] = x1001;
}

/*
 * The function fiat_p384_to_montgomery translates a field element into the Montgomery domain.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_p384_to_montgomery(fiat_p384_montgomery_domain_field_element out1, const fiat_p384_non_montgomery_domain_field_element arg1) {
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  uint32_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint32_t x12;
  uint32_t x13;
  uint32_t x14;
  uint32_t x15;
  uint32_t x16;
  uint32_t x17;
  uint32_t x18;
  uint32_t x19;
  uint32_t x20;
  uint32_t x21;
  fiat_p384_uint1 x22;
  uint32_t x23;
  uint32_t x24;
  uint32_t x25;
  uint32_t x26;
  uint32_t x27;
  uint32_t x28;
  uint32_t x29;
  uint32_t x30;
  uint32_t x31;
  uint32_t x32;
  uint32_t x33;
  uint32_t x34;
  uint32_t x35;
  uint32_t x36;
  uint32_t x37;
  uint32_t x38;
  uint32_t x39;
  uint32_t x40;
  uint32_t x41;
  uint32_t x42;
  uint32_t x43;
  fiat_p384_uint1 x44;
  uint32_t x45;
  fiat_p384_uint1 x46;
  uint32_t x47;
  fiat_p384_uint1 x48;
  uint32_t x49;
  fiat_p384_uint1 x50;
  uint32_t x51;
  fiat_p384_uint1 x52;
  uint32_t x53;
  fiat_p384_uint1 x54;
  uint32_t x55;
  fiat_p384_uint1 x56;
  uint32_t x57;
  fiat_p384_uint1 x58;
  uint32_t x59;
  fiat_p384_uint1 x60;
  uint32_t x61;
  fiat_p384_uint1 x62;
  uint32_t x63;
  fiat_p384_uint1 x64;
  uint32_t x65;
  fiat_p384_uint1 x66;
  uint32_t x67;
  fiat_p384_uint1 x68;
  uint32_t x69;
  fiat_p384_uint1 x70;
  uint32_t x71;
  fiat_p384_uint1 x72;
  uint32_t x73;
  fiat_p384_uint1 x74;
  uint32_t x75;
  fiat_p384_uint1 x76;
  uint32_t x77;
  fiat_p384_uint1 x78;
  uint32_t x79;
  fiat_p384_uint1 x80;
  uint32_t x81;
  fiat_p384_uint1 x82;
  uint32_t x83;
  uint32_t x84;
  uint32_t x85;
  uint32_t x86;
  uint32_t x87;
  uint32_t x88;
  uint32_t x89;
  uint32_t x90;
  uint32_t x91;
  fiat_p384_uint1 x92;
  uint32_t x93;
  fiat_p384_uint1 x94;
  uint32_t x95;
  fiat_p384_uint1 x96;
  uint32_t x97;
  fiat_p384_uint1 x98;
  uint32_t x99;
  fiat_p384_uint1 x100;
  uint32_t x101;
  fiat_p384_uint1 x102;
  uint32_t x103;
  fiat_p384_uint1 x104;
  uint32_t x105;
  fiat_p384_uint1 x106;
  uint32_t x107;
  fiat_p384_uint1 x108;
  uint32_t x109;
  fiat_p384_uint1 x110;
  uint32_t x111;
  fiat_p384_uint1 x112;
  uint32_t x113;
  fiat_p384_uint1 x114;
  uint32_t x115;
  fiat_p384_uint1 x116;
  uint32_t x117;
  uint32_t x118;
  uint32_t x119;
  uint32_t x120;
  uint32_t x121;
  uint32_t x122;
  uint32_t x123;
  uint32_t x124;
  uint32_t x125;
  uint32_t x126;
  uint32_t x127;
  uint32_t x128;
  uint32_t x129;
  uint32_t x130;
  uint32_t x131;
  uint32_t x132;
  uint32_t x133;
  uint32_t x134;
  uint32_t x135;
  uint32_t x136;
  uint32_t x137;
  fiat_p384_uint1 x138;
  uint32_t x139;
  fiat_p384_uint1 x140;
  uint32_t x141;
  fiat_p384_uint1 x142;
  uint32_t x143;
  fiat_p384_uint1 x144;
  uint32_t x145;
  fiat_p384_uint1 x146;
  uint32_t x147;
  fiat_p384_uint1 x148;
  uint32_t x149;
  fiat_p384_uint1 x150;
  uint32_t x151;
  fiat_p384_uint1 x152;
  uint32_t x153;
  fiat_p384_uint1 x154;
  uint32_t x155;
  fiat_p384_uint1 x156;
  uint32_t x157;
  fiat_p384_uint1 x158;
  uint32_t x159;
  fiat_p384_uint1 x160;
  uint32_t x161;
  fiat_p384_uint1 x162;
  uint32_t x163;
  fiat_p384_uint1 x164;
  uint32_t x165;
  fiat_p384_uint1 x166;
  uint32_t x167;
  fiat_p384_uint1 x168;
  uint32_t x169;
  fiat_p384_uint1 x170;
  uint32_t x171;
  fiat_p384_uint1 x172;
  uint32_t x173;
  fiat_p384_uint1 x174;
  uint32_t x175;
  fiat_p384_uint1 x176;
  uint32_t x177;
  fiat_p384_uint1 x178;
  uint32_t x179;
  uint32_t x180;
  uint32_t x181;
  uint32_t x182;
  uint32_t x183;
  uint32_t x184;
  uint32_t x185;
  uint32_t x186;
  uint32_t x187;
  fiat_p384_uint1 x188;
  uint32_t x189;
  fiat_p384_uint1 x190;
  uint32_t x191;
  fiat_p384_uint1 x192;
  uint32_t x193;
  fiat_p384_uint1 x194;
  uint32_t x195;
  fiat_p384_uint1 x196;
  uint32_t x197;
  fiat_p384_uint1 x198;
  uint32_t x199;
  fiat_p384_uint1 x200;
  uint32_t x201;
  fiat_p384_uint1 x202;
  uint32_t x203;
  fiat_p384_uint1 x204;
  uint32_t x205;
  fiat_p384_uint1 x206;
  uint32_t x207;
  fiat_p384_uint1 x208;
  uint32_t x209;
  fiat_p384_uint1 x210;
  uint32_t x211;
  fiat_p384_uint1 x212;
  uint32_t x213;
  uint32_t x214;
  uint32_t x215;
  uint32_t x216;
  uint32_t x217;
  uint32_t x218;
  uint32_t x219;
  uint32_t x220;
  uint32_t x221;
  uint32_t x222;
  uint32_t x223;
  uint32_t x224;
  uint32_t x225;
  uint32_t x226;
  uint32_t x227;
  uint32_t x228;
  uint32_t x229;
  uint32_t x230;
  uint32_t x231;
  uint32_t x232;
  uint32_t x233;
  fiat_p384_uint1 x234;
  uint32_t x235;
  fiat_p384_uint1 x236;
  uint32_t x237;
  fiat_p384_uint1 x238;
  uint32_t x239;
  fiat_p384_uint1 x240;
  uint32_t x241;
  fiat_p384_uint1 x242;
  uint32_t x243;
  fiat_p384_uint1 x244;
  uint32_t x245;
  fiat_p384_uint1 x246;
  uint32_t x247;
  fiat_p384_uint1 x248;
  uint32_t x249;
  fiat_p384_uint1 x250;
  uint32_t x251;
  fiat_p384_uint1 x252;
  uint32_t x253;
  fiat_p384_uint1 x254;
  uint32_t x255;
  fiat_p384_uint1 x256;
  uint32_t x257;
  fiat_p384_uint1 x258;
  uint32_t x259;
  fiat_p384_uint1 x260;
  uint32_t x261;
  fiat_p384_uint1 x262;
  uint32_t x263;
  fiat_p384_uint1 x264;
  uint32_t x265;
  fiat_p384_uint1 x266;
  uint32_t x267;
  fiat_p384_uint1 x268;
  uint32_t x269;
  fiat_p384_uint1 x270;
  uint32_t x271;
  fiat_p384_uint1 x272;
  uint32_t x273;
  fiat_p384_uint1 x274;
  uint32_t x275;
  uint32_t x276;
  uint32_t x277;
  uint32_t x278;
  uint32_t x279;
  uint32_t x280;
  uint32_t x281;
  uint32_t x282;
  uint32_t x283;
  fiat_p384_uint1 x284;
  uint32_t x285;
  fiat_p384_uint1 x286;
  uint32_t x287;
  fiat_p384_uint1 x288;
  uint32_t x289;
  fiat_p384_uint1 x290;
  uint32_t x291;
  fiat_p384_uint1 x292;
  uint32_t x293;
  fiat_p384_uint1 x294;
  uint32_t x295;
  fiat_p384_uint1 x296;
  uint32_t x297;
  fiat_p384_uint1 x298;
  uint32_t x299;
  fiat_p384_uint1 x300;
  uint32_t x301;
  fiat_p384_uint1 x302;
  uint32_t x303;
  fiat_p384_uint1 x304;
  uint32_t x305;
  fiat_p384_uint1 x306;
  uint32_t x307;
  fiat_p384_uint1 x308;
  uint32_t x309;
  uint32_t x310;
  uint32_t x311;
  uint32_t x312;
  uint32_t x313;
  uint32_t x314;
  uint32_t x315;
  uint32_t x316;
  uint32_t x317;
  uint32_t x318;
  uint32_t x319;
  uint32_t x320;
  uint32_t x321;
  uint32_t x322;
  uint32_t x323;
  uint32_t x324;
  uint32_t x325;
  uint32_t x326;
  uint32_t x327;
  uint32_t x328;
  uint32_t x329;
  fiat_p384_uint1 x330;
  uint32_t x331;
  fiat_p384_uint1 x332;
  uint32_t x333;
  fiat_p384_uint1 x334;
  uint32_t x335;
  fiat_p384_uint1 x336;
  uint32_t x337;
  fiat_p384_uint1 x338;
  uint32_t x339;
  fiat_p384_uint1 x340;
  uint32_t x341;
  fiat_p384_uint1 x342;
  uint32_t x343;
  fiat_p384_uint1 x344;
  uint32_t x345;
  fiat_p384_uint1 x346;
  uint32_t x347;
  fiat_p384_uint1 x348;
  uint32_t x349;
  fiat_p384_uint1 x350;
  uint32_t x351;
  fiat_p384_uint1 x352;
  uint32_t x353;
  fiat_p384_uint1 x354;
  uint32_t x355;
  fiat_p384_uint1 x356;
  uint32_t x357;
  fiat_p384_uint1 x358;
  uint32_t x359;
  fiat_p384_uint1 x360;
  uint32_t x361;
  fiat_p384_uint1 x362;
  uint32_t x363;
  fiat_p384_uint1 x364;
  uint32_t x365;
  fiat_p384_uint1 x366;
  uint32_t x367;
  fiat_p384_uint1 x368;
  uint32_t x369;
  fiat_p384_uint1 x370;
  uint32_t x371;
  uint32_t x372;
  uint32_t x373;
  uint32_t x374;
  uint32_t x375;
  uint32_t x376;
  uint32_t x377;
  uint32_t x378;
  uint32_t x379;
  fiat_p384_uint1 x380;
  uint32_t x381;
  fiat_p384_uint1 x382;
  uint32_t x383;
  fiat_p384_uint1 x384;
  uint32_t x385;
  fiat_p384_uint1 x386;
  uint32_t x387;
  fiat_p384_uint1 x388;
  uint32_t x389;
  fiat_p384_uint1 x390;
  uint32_t x391;
  fiat_p384_uint1 x392;
  uint32_t x393;
  fiat_p384_uint1 x394;
  uint32_t x395;
  fiat_p384_uint1 x396;
  uint32_t x397;
  fiat_p384_uint1 x398;
  uint32_t x399;
  fiat_p384_uint1 x400;
  uint32_t x401;
  fiat_p384_uint1 x402;
  uint32_t x403;
  fiat_p384_uint1 x404;
  uint32_t x405;
  uint32_t x406;
  uint32_t x407;
  uint32_t x408;
  uint32_t x409;
  uint32_t x410;
  uint32_t x411;
  uint32_t x412;
  uint32_t x413;
  uint32_t x414;
  uint32_t x415;
  uint32_t x416;
  uint32_t x417;
  uint32_t x418;
  uint32_t x419;
  uint32_t x420;
  uint32_t x421;
  uint32_t x422;
  uint32_t x423;
  uint32_t x424;
  uint32_t x425;
  fiat_p384_uint1 x426;
  uint32_t x427;
  fiat_p384_uint1 x428;
  uint32_t x429;
  fiat_p384_uint1 x430;
  uint32_t x431;
  fiat_p384_uint1 x432;
  uint32_t x433;
  fiat_p384_uint1 x434;
  uint32_t x435;
  fiat_p384_uint1 x436;
  uint32_t x437;
  fiat_p384_uint1 x438;
  uint32_t x439;
  fiat_p384_uint1 x440;
  uint32_t x441;
  fiat_p384_uint1 x442;
  uint32_t x443;
  fiat_p384_uint1 x444;
  uint32_t x445;
  fiat_p384_uint1 x446;
  uint32_t x447;
  fiat_p384_uint1 x448;
  uint32_t x449;
  fiat_p384_uint1 x450;
  uint32_t x451;
  fiat_p384_uint1 x452;
  uint32_t x453;
  fiat_p384_uint1 x454;
  uint32_t x455;
  fiat_p384_uint1 x456;
  uint32_t x457;
  fiat_p384_uint1 x458;
  uint32_t x459;
  fiat_p384_uint1 x460;
  uint32_t x461;
  fiat_p384_uint1 x462;
  uint32_t x463;
  fiat_p384_uint1 x464;
  uint32_t x465;
  fiat_p384_uint1 x466;
  uint32_t x467;
  uint32_t x468;
  uint32_t x469;
  uint32_t x470;
  uint32_t x471;
  uint32_t x472;
  uint32_t x473;
  uint32_t x474;
  uint32_t x475;
  fiat_p384_uint1 x476;
  uint32_t x477;
  fiat_p384_uint1 x478;
  uint32_t x479;
  fiat_p384_uint1 x480;
  uint32_t x481;
  fiat_p384_uint1 x482;
  uint32_t x483;
  fiat_p384_uint1 x484;
  uint32_t x485;
  fiat_p384_uint1 x486;
  uint32_t x487;
  fiat_p384_uint1 x488;
  uint32_t x489;
  fiat_p384_uint1 x490;
  uint32_t x491;
  fiat_p384_uint1 x492;
  uint32_t x493;
  fiat_p384_uint1 x494;
  uint32_t x495;
  fiat_p384_uint1 x496;
  uint32_t x497;
  fiat_p384_uint1 x498;
  uint32_t x499;
  fiat_p384_uint1 x500;
  uint32_t x501;
  uint32_t x502;
  uint32_t x503;
  uint32_t x504;
  uint32_t x505;
  uint32_t x506;
  uint32_t x507;
  uint32_t x508;
  uint32_t x509;
  uint32_t x510;
  uint32_t x511;
  uint32_t x512;
  uint32_t x513;
  uint32_t x514;
  uint32_t x515;
  uint32_t x516;
  uint32_t x517;
  uint32_t x518;
  uint32_t x519;
  uint32_t x520;
  uint32_t x521;
  fiat_p384_uint1 x522;
  uint32_t x523;
  fiat_p384_uint1 x524;
  uint32_t x525;
  fiat_p384_uint1 x526;
  uint32_t x527;
  fiat_p384_uint1 x528;
  uint32_t x529;
  fiat_p384_uint1 x530;
  uint32_t x531;
  fiat_p384_uint1 x532;
  uint32_t x533;
  fiat_p384_uint1 x534;
  uint32_t x535;
  fiat_p384_uint1 x536;
  uint32_t x537;
  fiat_p384_uint1 x538;
  uint32_t x539;
  fiat_p384_uint1 x540;
  uint32_t x541;
  fiat_p384_uint1 x542;
  uint32_t x543;
  fiat_p384_uint1 x544;
  uint32_t x545;
  fiat_p384_uint1 x546;
  uint32_t x547;
  fiat_p384_uint1 x548;
  uint32_t x549;
  fiat_p384_uint1 x550;
  uint32_t x551;
  fiat_p384_uint1 x552;
  uint32_t x553;
  fiat_p384_uint1 x554;
  uint32_t x555;
  fiat_p384_uint1 x556;
  uint32_t x557;
  fiat_p384_uint1 x558;
  uint32_t x559;
  fiat_p384_uint1 x560;
  uint32_t x561;
  fiat_p384_uint1 x562;
  uint32_t x563;
  uint32_t x564;
  uint32_t x565;
  uint32_t x566;
  uint32_t x567;
  uint32_t x568;
  uint32_t x569;
  uint32_t x570;
  uint32_t x571;
  fiat_p384_uint1 x572;
  uint32_t x573;
  fiat_p384_uint1 x574;
  uint32_t x575;
  fiat_p384_uint1 x576;
  uint32_t x577;
  fiat_p384_uint1 x578;
  uint32_t x579;
  fiat_p384_uint1 x580;
  uint32_t x581;
  fiat_p384_uint1 x582;
  uint32_t x583;
  fiat_p384_uint1 x584;
  uint32_t x585;
  fiat_p384_uint1 x586;
  uint32_t x587;
  fiat_p384_uint1 x588;
  uint32_t x589;
  fiat_p384_uint1 x590;
  uint32_t x591;
  fiat_p384_uint1 x592;
  uint32_t x593;
  fiat_p384_uint1 x594;
  uint32_t x595;
  fiat_p384_uint1 x596;
  uint32_t x597;
  uint32_t x598;
  uint32_t x599;
  uint32_t x600;
  uint32_t x601;
  uint32_t x602;
  uint32_t x603;
  uint32_t x604;
  uint32_t x605;
  uint32_t x606;
  uint32_t x607;
  uint32_t x608;
  uint32_t x609;
  uint32_t x610;
  uint32_t x611;
  uint32_t x612;
  uint32_t x613;
  uint32_t x614;
  uint32_t x615;
  uint32_t x616;
  uint32_t x617;
  fiat_p384_uint1 x618;
  uint32_t x619;
  fiat_p384_uint1 x620;
  uint32_t x621;
  fiat_p384_uint1 x622;
  uint32_t x623;
  fiat_p384_uint1 x624;
  uint32_t x625;
  fiat_p384_uint1 x626;
  uint32_t x627;
  fiat_p384_uint1 x628;
  uint32_t x629;
  fiat_p384_uint1 x630;
  uint32_t x631;
  fiat_p384_uint1 x632;
  uint32_t x633;
  fiat_p384_uint1 x634;
  uint32_t x635;
  fiat_p384_uint1 x636;
  uint32_t x637;
  fiat_p384_uint1 x638;
  uint32_t x639;
  fiat_p384_uint1 x640;
  uint32_t x641;
  fiat_p384_uint1 x642;
  uint32_t x643;
  fiat_p384_uint1 x644;
  uint32_t x645;
  fiat_p384_uint1 x646;
  uint32_t x647;
  fiat_p384_uint1 x648;
  uint32_t x649;
  fiat_p384_uint1 x650;
  uint32_t x651;
  fiat_p384_uint1 x652;
  uint32_t x653;
  fiat_p384_uint1 x654;
  uint32_t x655;
  fiat_p384_uint1 x656;
  uint32_t x657;
  fiat_p384_uint1 x658;
  uint32_t x659;
  uint32_t x660;
  uint32_t x661;
  uint32_t x662;
  uint32_t x663;
  uint32_t x664;
  uint32_t x665;
  uint32_t x666;
  uint32_t x667;
  fiat_p384_uint1 x668;
  uint32_t x669;
  fiat_p384_uint1 x670;
  uint32_t x671;
  fiat_p384_uint1 x672;
  uint32_t x673;
  fiat_p384_uint1 x674;
  uint32_t x675;
  fiat_p384_uint1 x676;
  uint32_t x677;
  fiat_p384_uint1 x678;
  uint32_t x679;
  fiat_p384_uint1 x680;
  uint32_t x681;
  fiat_p384_uint1 x682;
  uint32_t x683;
  fiat_p384_uint1 x684;
  uint32_t x685;
  fiat_p384_uint1 x686;
  uint32_t x687;
  fiat_p384_uint1 x688;
  uint32_t x689;
  fiat_p384_uint1 x690;
  uint32_t x691;
  fiat_p384_uint1 x692;
  uint32_t x693;
  uint32_t x694;
  uint32_t x695;
  uint32_t x696;
  uint32_t x697;
  uint32_t x698;
  uint32_t x699;
  uint32_t x700;
  uint32_t x701;
  uint32_t x702;
  uint32_t x703;
  uint32_t x704;
  uint32_t x705;
  uint32_t x706;
  uint32_t x707;
  uint32_t x708;
  uint32_t x709;
  uint32_t x710;
  uint32_t x711;
  uint32_t x712;
  uint32_t x713;
  fiat_p384_uint1 x714;
  uint32_t x715;
  fiat_p384_uint1 x716;
  uint32_t x717;
  fiat_p384_uint1 x718;
  uint32_t x719;
  fiat_p384_uint1 x720;
  uint32_t x721;
  fiat_p384_uint1 x722;
  uint32_t x723;
  fiat_p384_uint1 x724;
  uint32_t x725;
  fiat_p384_uint1 x726;
  uint32_t x727;
  fiat_p384_uint1 x728;
  uint32_t x729;
  fiat_p384_uint1 x730;
  uint32_t x731;
  fiat_p384_uint1 x732;
  uint32_t x733;
  fiat_p384_uint1 x734;
  uint32_t x735;
  fiat_p384_uint1 x736;
  uint32_t x737;
  fiat_p384_uint1 x738;
  uint32_t x739;
  fiat_p384_uint1 x740;
  uint32_t x741;
  fiat_p384_uint1 x742;
  uint32_t x743;
  fiat_p384_uint1 x744;
  uint32_t x745;
  fiat_p384_uint1 x746;
  uint32_t x747;
  fiat_p384_uint1 x748;
  uint32_t x749;
  fiat_p384_uint1 x750;
  uint32_t x751;
  fiat_p384_uint1 x752;
  uint32_t x753;
  fiat_p384_uint1 x754;
  uint32_t x755;
  uint32_t x756;
  uint32_t x757;
  uint32_t x758;
  uint32_t x759;
  uint32_t x760;
  uint32_t x761;
  uint32_t x762;
  uint32_t x763;
  fiat_p384_uint1 x764;
  uint32_t x765;
  fiat_p384_uint1 x766;
  uint32_t x767;
  fiat_p384_uint1 x768;
  uint32_t x769;
  fiat_p384_uint1 x770;
  uint32_t x771;
  fiat_p384_uint1 x772;
  uint32_t x773;
  fiat_p384_uint1 x774;
  uint32_t x775;
  fiat_p384_uint1 x776;
  uint32_t x777;
  fiat_p384_uint1 x778;
  uint32_t x779;
  fiat_p384_uint1 x780;
  uint32_t x781;
  fiat_p384_uint1 x782;
  uint32_t x783;
  fiat_p384_uint1 x784;
  uint32_t x785;
  fiat_p384_uint1 x786;
  uint32_t x787;
  fiat_p384_uint1 x788;
  uint32_t x789;
  uint32_t x790;
  uint32_t x791;
  uint32_t x792;
  uint32_t x793;
  uint32_t x794;
  uint32_t x795;
  uint32_t x796;
  uint32_t x797;
  uint32_t x798;
  uint32_t x799;
  uint32_t x800;
  uint32_t x801;
  uint32_t x802;
  uint32_t x803;
  uint32_t x804;
  uint32_t x805;
  uint32_t x806;
  uint32_t x807;
  uint32_t x808;
  uint32_t x809;
  fiat_p384_uint1 x810;
  uint32_t x811;
  fiat_p384_uint1 x812;
  uint32_t x813;
  fiat_p384_uint1 x814;
  uint32_t x815;
  fiat_p384_uint1 x816;
  uint32_t x817;
  fiat_p384_uint1 x818;
  uint32_t x819;
  fiat_p384_uint1 x820;
  uint32_t x821;
  fiat_p384_uint1 x822;
  uint32_t x823;
  fiat_p384_uint1 x824;
  uint32_t x825;
  fiat_p384_uint1 x826;
  uint32_t x827;
  fiat_p384_uint1 x828;
  uint32_t x829;
  fiat_p384_uint1 x830;
  uint32_t x831;
  fiat_p384_uint1 x832;
  uint32_t x833;
  fiat_p384_uint1 x834;
  uint32_t x835;
  fiat_p384_uint1 x836;
  uint32_t x837;
  fiat_p384_uint1 x838;
  uint32_t x839;
  fiat_p384_uint1 x840;
  uint32_t x841;
  fiat_p384_uint1 x842;
  uint32_t x843;
  fiat_p384_uint1 x844;
  uint32_t x845;
  fiat_p384_uint1 x846;
  uint32_t x847;
  fiat_p384_uint1 x848;
  uint32_t x849;
  fiat_p384_uint1 x850;
  uint32_t x851;
  uint32_t x852;
  uint32_t x853;
  uint32_t x854;
  uint32_t x855;
  uint32_t x856;
  uint32_t x857;
  uint32_t x858;
  uint32_t x859;
  fiat_p384_uint1 x860;
  uint32_t x861;
  fiat_p384_uint1 x862;
  uint32_t x863;
  fiat_p384_uint1 x864;
  uint32_t x865;
  fiat_p384_uint1 x866;
  uint32_t x867;
  fiat_p384_uint1 x868;
  uint32_t x869;
  fiat_p384_uint1 x870;
  uint32_t x871;
  fiat_p384_uint1 x872;
  uint32_t x873;
  fiat_p384_uint1 x874;
  uint32_t x875;
  fiat_p384_uint1 x876;
  uint32_t x877;
  fiat_p384_uint1 x878;
  uint32_t x879;
  fiat_p384_uint1 x880;
  uint32_t x881;
  fiat_p384_uint1 x882;
  uint32_t x883;
  fiat_p384_uint1 x884;
  uint32_t x885;
  uint32_t x886;
  uint32_t x887;
  uint32_t x888;
  uint32_t x889;
  uint32_t x890;
  uint32_t x891;
  uint32_t x892;
  uint32_t x893;
  uint32_t x894;
  uint32_t x895;
  uint32_t x896;
  uint32_t x897;
  uint32_t x898;
  uint32_t x899;
  uint32_t x900;
  uint32_t x901;
  uint32_t x902;
  uint32_t x903;
  uint32_t x904;
  uint32_t x905;
  fiat_p384_uint1 x906;
  uint32_t x907;
  fiat_p384_uint1 x908;
  uint32_t x909;
  fiat_p384_uint1 x910;
  uint32_t x911;
  fiat_p384_uint1 x912;
  uint32_t x913;
  fiat_p384_uint1 x914;
  uint32_t x915;
  fiat_p384_uint1 x916;
  uint32_t x917;
  fiat_p384_uint1 x918;
  uint32_t x919;
  fiat_p384_uint1 x920;
  uint32_t x921;
  fiat_p384_uint1 x922;
  uint32_t x923;
  fiat_p384_uint1 x924;
  uint32_t x925;
  fiat_p384_uint1 x926;
  uint32_t x927;
  fiat_p384_uint1 x928;
  uint32_t x929;
  fiat_p384_uint1 x930;
  uint32_t x931;
  fiat_p384_uint1 x932;
  uint32_t x933;
  fiat_p384_uint1 x934;
  uint32_t x935;
  fiat_p384_uint1 x936;
  uint32_t x937;
  fiat_p384_uint1 x938;
  uint32_t x939;
  fiat_p384_uint1 x940;
  uint32_t x941;
  fiat_p384_uint1 x942;
  uint32_t x943;
  fiat_p384_uint1 x944;
  uint32_t x945;
  fiat_p384_uint1 x946;
  uint32_t x947;
  uint32_t x948;
  uint32_t x949;
  uint32_t x950;
  uint32_t x951;
  uint32_t x952;
  uint32_t x953;
  uint32_t x954;
  uint32_t x955;
  fiat_p384_uint1 x956;
  uint32_t x957;
  fiat_p384_uint1 x958;
  uint32_t x959;
  fiat_p384_uint1 x960;
  uint32_t x961;
  fiat_p384_uint1 x962;
  uint32_t x963;
  fiat_p384_uint1 x964;
  uint32_t x965;
  fiat_p384_uint1 x966;
  uint32_t x967;
  fiat_p384_uint1 x968;
  uint32_t x969;
  fiat_p384_uint1 x970;
  uint32_t x971;
  fiat_p384_uint1 x972;
  uint32_t x973;
  fiat_p384_uint1 x974;
  uint32_t x975;
  fiat_p384_uint1 x976;
  uint32_t x977;
  fiat_p384_uint1 x978;
  uint32_t x979;
  fiat_p384_uint1 x980;
  uint32_t x981;
  uint32_t x982;
  uint32_t x983;
  uint32_t x984;
  uint32_t x985;
  uint32_t x986;
  uint32_t x987;
  uint32_t x988;
  uint32_t x989;
  uint32_t x990;
  uint32_t x991;
  uint32_t x992;
  uint32_t x993;
  uint32_t x994;
  uint32_t x995;
  uint32_t x996;
  uint32_t x997;
  uint32_t x998;
  uint32_t x999;
  uint32_t x1000;
  uint32_t x1001;
  fiat_p384_uint1 x1002;
  uint32_t x1003;
  fiat_p384_uint1 x1004;
  uint32_t x1005;
  fiat_p384_uint1 x1006;
  uint32_t x1007;
  fiat_p384_uint1 x1008;
  uint32_t x1009;
  fiat_p384_uint1 x1010;
  uint32_t x1011;
  fiat_p384_uint1 x1012;
  uint32_t x1013;
  fiat_p384_uint1 x1014;
  uint32_t x1015;
  fiat_p384_uint1 x1016;
  uint32_t x1017;
  fiat_p384_uint1 x1018;
  uint32_t x1019;
  fiat_p384_uint1 x1020;
  uint32_t x1021;
  fiat_p384_uint1 x1022;
  uint32_t x1023;
  fiat_p384_uint1 x1024;
  uint32_t x1025;
  fiat_p384_uint1 x1026;
  uint32_t x1027;
  fiat_p384_uint1 x1028;
  uint32_t x1029;
  fiat_p384_uint1 x1030;
  uint32_t x1031;
  fiat_p384_uint1 x1032;
  uint32_t x1033;
  fiat_p384_uint1 x1034;
  uint32_t x1035;
  fiat_p384_uint1 x1036;
  uint32_t x1037;
  fiat_p384_uint1 x1038;
  uint32_t x1039;
  fiat_p384_uint1 x1040;
  uint32_t x1041;
  fiat_p384_uint1 x1042;
  uint32_t x1043;
  uint32_t x1044;
  uint32_t x1045;
  uint32_t x1046;
  uint32_t x1047;
  uint32_t x1048;
  uint32_t x1049;
  uint32_t x1050;
  uint32_t x1051;
  fiat_p384_uint1 x1052;
  uint32_t x1053;
  fiat_p384_uint1 x1054;
  uint32_t x1055;
  fiat_p384_uint1 x1056;
  uint32_t x1057;
  fiat_p384_uint1 x1058;
  uint32_t x1059;
  fiat_p384_uint1 x1060;
  uint32_t x1061;
  fiat_p384_uint1 x1062;
  uint32_t x1063;
  fiat_p384_uint1 x1064;
  uint32_t x1065;
  fiat_p384_uint1 x1066;
  uint32_t x1067;
  fiat_p384_uint1 x1068;
  uint32_t x1069;
  fiat_p384_uint1 x1070;
  uint32_t x1071;
  fiat_p384_uint1 x1072;
  uint32_t x1073;
  fiat_p384_uint1 x1074;
  uint32_t x1075;
  fiat_p384_uint1 x1076;
  uint32_t x1077;
  uint32_t x1078;
  uint32_t x1079;
  uint32_t x1080;
  uint32_t x1081;
  uint32_t x1082;
  uint32_t x1083;
  uint32_t x1084;
  uint32_t x1085;
  uint32_t x1086;
  uint32_t x1087;
  uint32_t x1088;
  uint32_t x1089;
  uint32_t x1090;
  uint32_t x1091;
  uint32_t x1092;
  uint32_t x1093;
  uint32_t x1094;
  uint32_t x1095;
  uint32_t x1096;
  uint32_t x1097;
  fiat_p384_uint1 x1098;
  uint32_t x1099;
  fiat_p384_uint1 x1100;
  uint32_t x1101;
  fiat_p384_uint1 x1102;
  uint32_t x1103;
  fiat_p384_uint1 x1104;
  uint32_t x1105;
  fiat_p384_uint1 x1106;
  uint32_t x1107;
  fiat_p384_uint1 x1108;
  uint32_t x1109;
  fiat_p384_uint1 x1110;
  uint32_t x1111;
  fiat_p384_uint1 x1112;
  uint32_t x1113;
  fiat_p384_uint1 x1114;
  uint32_t x1115;
  fiat_p384_uint1 x1116;
  uint32_t x1117;
  fiat_p384_uint1 x1118;
  uint32_t x1119;
  fiat_p384_uint1 x1120;
  uint32_t x1121;
  fiat_p384_uint1 x1122;
  uint32_t x1123;
  fiat_p384_uint1 x1124;
  uint32_t x1125;
  fiat_p384_uint1 x1126;
  uint32_t x1127;
  fiat_p384_uint1 x1128;
  uint32_t x1129;
  fiat_p384_uint1 x1130;
  uint32_t x1131;
  fiat_p384_uint1 x1132;
  uint32_t x1133;
  fiat_p384_uint1 x1134;
  uint32_t x1135;
  fiat_p384_uint1 x1136;
  uint32_t x1137;
  fiat_p384_uint1 x1138;
  uint32_t x1139;
  fiat_p384_uint1 x1140;
  uint32_t x1141;
  fiat_p384_uint1 x1142;
  uint32_t x1143;
  fiat_p384_uint1 x1144;
  uint32_t x1145;
  fiat_p384_uint1 x1146;
  uint32_t x1147;
  fiat_p384_uint1 x1148;
  uint32_t x1149;
  fiat_p384_uint1 x1150;
  uint32_t x1151;
  fiat_p384_uint1 x1152;
  uint32_t x1153;
  fiat_p384_uint1 x1154;
  uint32_t x1155;
  fiat_p384_uint1 x1156;
  uint32_t x1157;
  fiat_p384_uint1 x1158;
  uint32_t x1159;
  fiat_p384_uint1 x1160;
  uint32_t x1161;
  fiat_p384_uint1 x1162;
  uint32_t x1163;
  fiat_p384_uint1 x1164;
  uint32_t x1165;
  uint32_t x1166;
  uint32_t x1167;
  uint32_t x1168;
  uint32_t x1169;
  uint32_t x1170;
  uint32_t x1171;
  uint32_t x1172;
  uint32_t x1173;
  uint32_t x1174;
  uint32_t x1175;
  uint32_t x1176;
  x1 = (arg1[1]);
  x2 = (arg1[2]);
  x3 = (arg1[3]);
  x4 = (arg1[4]);
  x5 = (arg1[5]);
  x6 = (arg1[6]);
  x7 = (arg1[7]);
  x8 = (arg1[8]);
  x9 = (arg1[9]);
  x10 = (arg1[10]);
  x11 = (arg1[11]);
  x12 = (arg1[0]);
  fiat_p384_mulx_u32(&x13, &x14, x12, 0x2);
  fiat_p384_mulx_u32(&x15, &x16, x12, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x17, &x18, x12, 0x2);
  fiat_p384_mulx_u32(&x19, &x20, x12, UINT32_C(0xfffffffe));
  fiat_p384_addcarryx_u32(&x21, &x22, 0x0, (fiat_p384_uint1)x14, x12);
  fiat_p384_mulx_u32(&x23, &x24, x12, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x25, &x26, x12, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x27, &x28, x12, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x29, &x30, x12, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x31, &x32, x12, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x33, &x34, x12, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x35, &x36, x12, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x37, &x38, x12, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x39, &x40, x12, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x41, &x42, x12, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x43, &x44, 0x0, x40, x37);
  fiat_p384_addcarryx_u32(&x45, &x46, x44, x38, x35);
  fiat_p384_addcarryx_u32(&x47, &x48, x46, x36, x33);
  fiat_p384_addcarryx_u32(&x49, &x50, x48, x34, x31);
  fiat_p384_addcarryx_u32(&x51, &x52, x50, x32, x29);
  fiat_p384_addcarryx_u32(&x53, &x54, x52, x30, x27);
  fiat_p384_addcarryx_u32(&x55, &x56, x54, x28, x25);
  fiat_p384_addcarryx_u32(&x57, &x58, x56, x26, x23);
  fiat_p384_addcarryx_u32(&x59, &x60, 0x0, x12, x41);
  fiat_p384_addcarryx_u32(&x61, &x62, x60, x19, x42);
  fiat_p384_addcarryx_u32(&x63, &x64, 0x0, x17, x39);
  fiat_p384_addcarryx_u32(&x65, &x66, x64, (fiat_p384_uint1)x18, x43);
  fiat_p384_addcarryx_u32(&x67, &x68, x66, x15, x45);
  fiat_p384_addcarryx_u32(&x69, &x70, x68, x16, x47);
  fiat_p384_addcarryx_u32(&x71, &x72, x70, x13, x49);
  fiat_p384_addcarryx_u32(&x73, &x74, x72, x21, x51);
  fiat_p384_addcarryx_u32(&x75, &x76, x74, x22, x53);
  fiat_p384_addcarryx_u32(&x77, &x78, x76, 0x0, x55);
  fiat_p384_addcarryx_u32(&x79, &x80, x78, 0x0, x57);
  fiat_p384_addcarryx_u32(&x81, &x82, x80, 0x0, (x58 + x24));
  fiat_p384_mulx_u32(&x83, &x84, x1, 0x2);
  fiat_p384_mulx_u32(&x85, &x86, x1, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x87, &x88, x1, 0x2);
  fiat_p384_mulx_u32(&x89, &x90, x1, UINT32_C(0xfffffffe));
  fiat_p384_addcarryx_u32(&x91, &x92, 0x0, (fiat_p384_uint1)x84, x1);
  fiat_p384_addcarryx_u32(&x93, &x94, 0x0, x61, x1);
  fiat_p384_addcarryx_u32(&x95, &x96, x94, (x62 + x20), x89);
  fiat_p384_addcarryx_u32(&x97, &x98, x96, x63, x90);
  fiat_p384_addcarryx_u32(&x99, &x100, x98, x65, x87);
  fiat_p384_addcarryx_u32(&x101, &x102, x100, x67, (fiat_p384_uint1)x88);
  fiat_p384_addcarryx_u32(&x103, &x104, x102, x69, x85);
  fiat_p384_addcarryx_u32(&x105, &x106, x104, x71, x86);
  fiat_p384_addcarryx_u32(&x107, &x108, x106, x73, x83);
  fiat_p384_addcarryx_u32(&x109, &x110, x108, x75, x91);
  fiat_p384_addcarryx_u32(&x111, &x112, x110, x77, x92);
  fiat_p384_addcarryx_u32(&x113, &x114, x112, x79, 0x0);
  fiat_p384_addcarryx_u32(&x115, &x116, x114, x81, 0x0);
  fiat_p384_mulx_u32(&x117, &x118, x93, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x119, &x120, x93, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x121, &x122, x93, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x123, &x124, x93, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x125, &x126, x93, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x127, &x128, x93, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x129, &x130, x93, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x131, &x132, x93, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x133, &x134, x93, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x135, &x136, x93, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x137, &x138, 0x0, x134, x131);
  fiat_p384_addcarryx_u32(&x139, &x140, x138, x132, x129);
  fiat_p384_addcarryx_u32(&x141, &x142, x140, x130, x127);
  fiat_p384_addcarryx_u32(&x143, &x144, x142, x128, x125);
  fiat_p384_addcarryx_u32(&x145, &x146, x144, x126, x123);
  fiat_p384_addcarryx_u32(&x147, &x148, x146, x124, x121);
  fiat_p384_addcarryx_u32(&x149, &x150, x148, x122, x119);
  fiat_p384_addcarryx_u32(&x151, &x152, x150, x120, x117);
  fiat_p384_addcarryx_u32(&x153, &x154, 0x0, x93, x135);
  fiat_p384_addcarryx_u32(&x155, &x156, x154, x95, x136);
  fiat_p384_addcarryx_u32(&x157, &x158, x156, x97, 0x0);
  fiat_p384_addcarryx_u32(&x159, &x160, x158, x99, x133);
  fiat_p384_addcarryx_u32(&x161, &x162, x160, x101, x137);
  fiat_p384_addcarryx_u32(&x163, &x164, x162, x103, x139);
  fiat_p384_addcarryx_u32(&x165, &x166, x164, x105, x141);
  fiat_p384_addcarryx_u32(&x167, &x168, x166, x107, x143);
  fiat_p384_addcarryx_u32(&x169, &x170, x168, x109, x145);
  fiat_p384_addcarryx_u32(&x171, &x172, x170, x111, x147);
  fiat_p384_addcarryx_u32(&x173, &x174, x172, x113, x149);
  fiat_p384_addcarryx_u32(&x175, &x176, x174, x115, x151);
  fiat_p384_addcarryx_u32(&x177, &x178, x176, ((uint32_t)x116 + x82), (x152 + x118));
  fiat_p384_mulx_u32(&x179, &x180, x2, 0x2);
  fiat_p384_mulx_u32(&x181, &x182, x2, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x183, &x184, x2, 0x2);
  fiat_p384_mulx_u32(&x185, &x186, x2, UINT32_C(0xfffffffe));
  fiat_p384_addcarryx_u32(&x187, &x188, 0x0, (fiat_p384_uint1)x180, x2);
  fiat_p384_addcarryx_u32(&x189, &x190, 0x0, x155, x2);
  fiat_p384_addcarryx_u32(&x191, &x192, x190, x157, x185);
  fiat_p384_addcarryx_u32(&x193, &x194, x192, x159, x186);
  fiat_p384_addcarryx_u32(&x195, &x196, x194, x161, x183);
  fiat_p384_addcarryx_u32(&x197, &x198, x196, x163, (fiat_p384_uint1)x184);
  fiat_p384_addcarryx_u32(&x199, &x200, x198, x165, x181);
  fiat_p384_addcarryx_u32(&x201, &x202, x200, x167, x182);
  fiat_p384_addcarryx_u32(&x203, &x204, x202, x169, x179);
  fiat_p384_addcarryx_u32(&x205, &x206, x204, x171, x187);
  fiat_p384_addcarryx_u32(&x207, &x208, x206, x173, x188);
  fiat_p384_addcarryx_u32(&x209, &x210, x208, x175, 0x0);
  fiat_p384_addcarryx_u32(&x211, &x212, x210, x177, 0x0);
  fiat_p384_mulx_u32(&x213, &x214, x189, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x215, &x216, x189, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x217, &x218, x189, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x219, &x220, x189, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x221, &x222, x189, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x223, &x224, x189, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x225, &x226, x189, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x227, &x228, x189, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x229, &x230, x189, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x231, &x232, x189, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x233, &x234, 0x0, x230, x227);
  fiat_p384_addcarryx_u32(&x235, &x236, x234, x228, x225);
  fiat_p384_addcarryx_u32(&x237, &x238, x236, x226, x223);
  fiat_p384_addcarryx_u32(&x239, &x240, x238, x224, x221);
  fiat_p384_addcarryx_u32(&x241, &x242, x240, x222, x219);
  fiat_p384_addcarryx_u32(&x243, &x244, x242, x220, x217);
  fiat_p384_addcarryx_u32(&x245, &x246, x244, x218, x215);
  fiat_p384_addcarryx_u32(&x247, &x248, x246, x216, x213);
  fiat_p384_addcarryx_u32(&x249, &x250, 0x0, x189, x231);
  fiat_p384_addcarryx_u32(&x251, &x252, x250, x191, x232);
  fiat_p384_addcarryx_u32(&x253, &x254, x252, x193, 0x0);
  fiat_p384_addcarryx_u32(&x255, &x256, x254, x195, x229);
  fiat_p384_addcarryx_u32(&x257, &x258, x256, x197, x233);
  fiat_p384_addcarryx_u32(&x259, &x260, x258, x199, x235);
  fiat_p384_addcarryx_u32(&x261, &x262, x260, x201, x237);
  fiat_p384_addcarryx_u32(&x263, &x264, x262, x203, x239);
  fiat_p384_addcarryx_u32(&x265, &x266, x264, x205, x241);
  fiat_p384_addcarryx_u32(&x267, &x268, x266, x207, x243);
  fiat_p384_addcarryx_u32(&x269, &x270, x268, x209, x245);
  fiat_p384_addcarryx_u32(&x271, &x272, x270, x211, x247);
  fiat_p384_addcarryx_u32(&x273, &x274, x272, ((uint32_t)x212 + x178), (x248 + x214));
  fiat_p384_mulx_u32(&x275, &x276, x3, 0x2);
  fiat_p384_mulx_u32(&x277, &x278, x3, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x279, &x280, x3, 0x2);
  fiat_p384_mulx_u32(&x281, &x282, x3, UINT32_C(0xfffffffe));
  fiat_p384_addcarryx_u32(&x283, &x284, 0x0, (fiat_p384_uint1)x276, x3);
  fiat_p384_addcarryx_u32(&x285, &x286, 0x0, x251, x3);
  fiat_p384_addcarryx_u32(&x287, &x288, x286, x253, x281);
  fiat_p384_addcarryx_u32(&x289, &x290, x288, x255, x282);
  fiat_p384_addcarryx_u32(&x291, &x292, x290, x257, x279);
  fiat_p384_addcarryx_u32(&x293, &x294, x292, x259, (fiat_p384_uint1)x280);
  fiat_p384_addcarryx_u32(&x295, &x296, x294, x261, x277);
  fiat_p384_addcarryx_u32(&x297, &x298, x296, x263, x278);
  fiat_p384_addcarryx_u32(&x299, &x300, x298, x265, x275);
  fiat_p384_addcarryx_u32(&x301, &x302, x300, x267, x283);
  fiat_p384_addcarryx_u32(&x303, &x304, x302, x269, x284);
  fiat_p384_addcarryx_u32(&x305, &x306, x304, x271, 0x0);
  fiat_p384_addcarryx_u32(&x307, &x308, x306, x273, 0x0);
  fiat_p384_mulx_u32(&x309, &x310, x285, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x311, &x312, x285, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x313, &x314, x285, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x315, &x316, x285, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x317, &x318, x285, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x319, &x320, x285, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x321, &x322, x285, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x323, &x324, x285, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x325, &x326, x285, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x327, &x328, x285, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x329, &x330, 0x0, x326, x323);
  fiat_p384_addcarryx_u32(&x331, &x332, x330, x324, x321);
  fiat_p384_addcarryx_u32(&x333, &x334, x332, x322, x319);
  fiat_p384_addcarryx_u32(&x335, &x336, x334, x320, x317);
  fiat_p384_addcarryx_u32(&x337, &x338, x336, x318, x315);
  fiat_p384_addcarryx_u32(&x339, &x340, x338, x316, x313);
  fiat_p384_addcarryx_u32(&x341, &x342, x340, x314, x311);
  fiat_p384_addcarryx_u32(&x343, &x344, x342, x312, x309);
  fiat_p384_addcarryx_u32(&x345, &x346, 0x0, x285, x327);
  fiat_p384_addcarryx_u32(&x347, &x348, x346, x287, x328);
  fiat_p384_addcarryx_u32(&x349, &x350, x348, x289, 0x0);
  fiat_p384_addcarryx_u32(&x351, &x352, x350, x291, x325);
  fiat_p384_addcarryx_u32(&x353, &x354, x352, x293, x329);
  fiat_p384_addcarryx_u32(&x355, &x356, x354, x295, x331);
  fiat_p384_addcarryx_u32(&x357, &x358, x356, x297, x333);
  fiat_p384_addcarryx_u32(&x359, &x360, x358, x299, x335);
  fiat_p384_addcarryx_u32(&x361, &x362, x360, x301, x337);
  fiat_p384_addcarryx_u32(&x363, &x364, x362, x303, x339);
  fiat_p384_addcarryx_u32(&x365, &x366, x364, x305, x341);
  fiat_p384_addcarryx_u32(&x367, &x368, x366, x307, x343);
  fiat_p384_addcarryx_u32(&x369, &x370, x368, ((uint32_t)x308 + x274), (x344 + x310));
  fiat_p384_mulx_u32(&x371, &x372, x4, 0x2);
  fiat_p384_mulx_u32(&x373, &x374, x4, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x375, &x376, x4, 0x2);
  fiat_p384_mulx_u32(&x377, &x378, x4, UINT32_C(0xfffffffe));
  fiat_p384_addcarryx_u32(&x379, &x380, 0x0, (fiat_p384_uint1)x372, x4);
  fiat_p384_addcarryx_u32(&x381, &x382, 0x0, x347, x4);
  fiat_p384_addcarryx_u32(&x383, &x384, x382, x349, x377);
  fiat_p384_addcarryx_u32(&x385, &x386, x384, x351, x378);
  fiat_p384_addcarryx_u32(&x387, &x388, x386, x353, x375);
  fiat_p384_addcarryx_u32(&x389, &x390, x388, x355, (fiat_p384_uint1)x376);
  fiat_p384_addcarryx_u32(&x391, &x392, x390, x357, x373);
  fiat_p384_addcarryx_u32(&x393, &x394, x392, x359, x374);
  fiat_p384_addcarryx_u32(&x395, &x396, x394, x361, x371);
  fiat_p384_addcarryx_u32(&x397, &x398, x396, x363, x379);
  fiat_p384_addcarryx_u32(&x399, &x400, x398, x365, x380);
  fiat_p384_addcarryx_u32(&x401, &x402, x400, x367, 0x0);
  fiat_p384_addcarryx_u32(&x403, &x404, x402, x369, 0x0);
  fiat_p384_mulx_u32(&x405, &x406, x381, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x407, &x408, x381, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x409, &x410, x381, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x411, &x412, x381, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x413, &x414, x381, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x415, &x416, x381, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x417, &x418, x381, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x419, &x420, x381, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x421, &x422, x381, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x423, &x424, x381, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x425, &x426, 0x0, x422, x419);
  fiat_p384_addcarryx_u32(&x427, &x428, x426, x420, x417);
  fiat_p384_addcarryx_u32(&x429, &x430, x428, x418, x415);
  fiat_p384_addcarryx_u32(&x431, &x432, x430, x416, x413);
  fiat_p384_addcarryx_u32(&x433, &x434, x432, x414, x411);
  fiat_p384_addcarryx_u32(&x435, &x436, x434, x412, x409);
  fiat_p384_addcarryx_u32(&x437, &x438, x436, x410, x407);
  fiat_p384_addcarryx_u32(&x439, &x440, x438, x408, x405);
  fiat_p384_addcarryx_u32(&x441, &x442, 0x0, x381, x423);
  fiat_p384_addcarryx_u32(&x443, &x444, x442, x383, x424);
  fiat_p384_addcarryx_u32(&x445, &x446, x444, x385, 0x0);
  fiat_p384_addcarryx_u32(&x447, &x448, x446, x387, x421);
  fiat_p384_addcarryx_u32(&x449, &x450, x448, x389, x425);
  fiat_p384_addcarryx_u32(&x451, &x452, x450, x391, x427);
  fiat_p384_addcarryx_u32(&x453, &x454, x452, x393, x429);
  fiat_p384_addcarryx_u32(&x455, &x456, x454, x395, x431);
  fiat_p384_addcarryx_u32(&x457, &x458, x456, x397, x433);
  fiat_p384_addcarryx_u32(&x459, &x460, x458, x399, x435);
  fiat_p384_addcarryx_u32(&x461, &x462, x460, x401, x437);
  fiat_p384_addcarryx_u32(&x463, &x464, x462, x403, x439);
  fiat_p384_addcarryx_u32(&x465, &x466, x464, ((uint32_t)x404 + x370), (x440 + x406));
  fiat_p384_mulx_u32(&x467, &x468, x5, 0x2);
  fiat_p384_mulx_u32(&x469, &x470, x5, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x471, &x472, x5, 0x2);
  fiat_p384_mulx_u32(&x473, &x474, x5, UINT32_C(0xfffffffe));
  fiat_p384_addcarryx_u32(&x475, &x476, 0x0, (fiat_p384_uint1)x468, x5);
  fiat_p384_addcarryx_u32(&x477, &x478, 0x0, x443, x5);
  fiat_p384_addcarryx_u32(&x479, &x480, x478, x445, x473);
  fiat_p384_addcarryx_u32(&x481, &x482, x480, x447, x474);
  fiat_p384_addcarryx_u32(&x483, &x484, x482, x449, x471);
  fiat_p384_addcarryx_u32(&x485, &x486, x484, x451, (fiat_p384_uint1)x472);
  fiat_p384_addcarryx_u32(&x487, &x488, x486, x453, x469);
  fiat_p384_addcarryx_u32(&x489, &x490, x488, x455, x470);
  fiat_p384_addcarryx_u32(&x491, &x492, x490, x457, x467);
  fiat_p384_addcarryx_u32(&x493, &x494, x492, x459, x475);
  fiat_p384_addcarryx_u32(&x495, &x496, x494, x461, x476);
  fiat_p384_addcarryx_u32(&x497, &x498, x496, x463, 0x0);
  fiat_p384_addcarryx_u32(&x499, &x500, x498, x465, 0x0);
  fiat_p384_mulx_u32(&x501, &x502, x477, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x503, &x504, x477, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x505, &x506, x477, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x507, &x508, x477, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x509, &x510, x477, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x511, &x512, x477, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x513, &x514, x477, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x515, &x516, x477, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x517, &x518, x477, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x519, &x520, x477, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x521, &x522, 0x0, x518, x515);
  fiat_p384_addcarryx_u32(&x523, &x524, x522, x516, x513);
  fiat_p384_addcarryx_u32(&x525, &x526, x524, x514, x511);
  fiat_p384_addcarryx_u32(&x527, &x528, x526, x512, x509);
  fiat_p384_addcarryx_u32(&x529, &x530, x528, x510, x507);
  fiat_p384_addcarryx_u32(&x531, &x532, x530, x508, x505);
  fiat_p384_addcarryx_u32(&x533, &x534, x532, x506, x503);
  fiat_p384_addcarryx_u32(&x535, &x536, x534, x504, x501);
  fiat_p384_addcarryx_u32(&x537, &x538, 0x0, x477, x519);
  fiat_p384_addcarryx_u32(&x539, &x540, x538, x479, x520);
  fiat_p384_addcarryx_u32(&x541, &x542, x540, x481, 0x0);
  fiat_p384_addcarryx_u32(&x543, &x544, x542, x483, x517);
  fiat_p384_addcarryx_u32(&x545, &x546, x544, x485, x521);
  fiat_p384_addcarryx_u32(&x547, &x548, x546, x487, x523);
  fiat_p384_addcarryx_u32(&x549, &x550, x548, x489, x525);
  fiat_p384_addcarryx_u32(&x551, &x552, x550, x491, x527);
  fiat_p384_addcarryx_u32(&x553, &x554, x552, x493, x529);
  fiat_p384_addcarryx_u32(&x555, &x556, x554, x495, x531);
  fiat_p384_addcarryx_u32(&x557, &x558, x556, x497, x533);
  fiat_p384_addcarryx_u32(&x559, &x560, x558, x499, x535);
  fiat_p384_addcarryx_u32(&x561, &x562, x560, ((uint32_t)x500 + x466), (x536 + x502));
  fiat_p384_mulx_u32(&x563, &x564, x6, 0x2);
  fiat_p384_mulx_u32(&x565, &x566, x6, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x567, &x568, x6, 0x2);
  fiat_p384_mulx_u32(&x569, &x570, x6, UINT32_C(0xfffffffe));
  fiat_p384_addcarryx_u32(&x571, &x572, 0x0, (fiat_p384_uint1)x564, x6);
  fiat_p384_addcarryx_u32(&x573, &x574, 0x0, x539, x6);
  fiat_p384_addcarryx_u32(&x575, &x576, x574, x541, x569);
  fiat_p384_addcarryx_u32(&x577, &x578, x576, x543, x570);
  fiat_p384_addcarryx_u32(&x579, &x580, x578, x545, x567);
  fiat_p384_addcarryx_u32(&x581, &x582, x580, x547, (fiat_p384_uint1)x568);
  fiat_p384_addcarryx_u32(&x583, &x584, x582, x549, x565);
  fiat_p384_addcarryx_u32(&x585, &x586, x584, x551, x566);
  fiat_p384_addcarryx_u32(&x587, &x588, x586, x553, x563);
  fiat_p384_addcarryx_u32(&x589, &x590, x588, x555, x571);
  fiat_p384_addcarryx_u32(&x591, &x592, x590, x557, x572);
  fiat_p384_addcarryx_u32(&x593, &x594, x592, x559, 0x0);
  fiat_p384_addcarryx_u32(&x595, &x596, x594, x561, 0x0);
  fiat_p384_mulx_u32(&x597, &x598, x573, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x599, &x600, x573, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x601, &x602, x573, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x603, &x604, x573, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x605, &x606, x573, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x607, &x608, x573, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x609, &x610, x573, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x611, &x612, x573, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x613, &x614, x573, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x615, &x616, x573, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x617, &x618, 0x0, x614, x611);
  fiat_p384_addcarryx_u32(&x619, &x620, x618, x612, x609);
  fiat_p384_addcarryx_u32(&x621, &x622, x620, x610, x607);
  fiat_p384_addcarryx_u32(&x623, &x624, x622, x608, x605);
  fiat_p384_addcarryx_u32(&x625, &x626, x624, x606, x603);
  fiat_p384_addcarryx_u32(&x627, &x628, x626, x604, x601);
  fiat_p384_addcarryx_u32(&x629, &x630, x628, x602, x599);
  fiat_p384_addcarryx_u32(&x631, &x632, x630, x600, x597);
  fiat_p384_addcarryx_u32(&x633, &x634, 0x0, x573, x615);
  fiat_p384_addcarryx_u32(&x635, &x636, x634, x575, x616);
  fiat_p384_addcarryx_u32(&x637, &x638, x636, x577, 0x0);
  fiat_p384_addcarryx_u32(&x639, &x640, x638, x579, x613);
  fiat_p384_addcarryx_u32(&x641, &x642, x640, x581, x617);
  fiat_p384_addcarryx_u32(&x643, &x644, x642, x583, x619);
  fiat_p384_addcarryx_u32(&x645, &x646, x644, x585, x621);
  fiat_p384_addcarryx_u32(&x647, &x648, x646, x587, x623);
  fiat_p384_addcarryx_u32(&x649, &x650, x648, x589, x625);
  fiat_p384_addcarryx_u32(&x651, &x652, x650, x591, x627);
  fiat_p384_addcarryx_u32(&x653, &x654, x652, x593, x629);
  fiat_p384_addcarryx_u32(&x655, &x656, x654, x595, x631);
  fiat_p384_addcarryx_u32(&x657, &x658, x656, ((uint32_t)x596 + x562), (x632 + x598));
  fiat_p384_mulx_u32(&x659, &x660, x7, 0x2);
  fiat_p384_mulx_u32(&x661, &x662, x7, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x663, &x664, x7, 0x2);
  fiat_p384_mulx_u32(&x665, &x666, x7, UINT32_C(0xfffffffe));
  fiat_p384_addcarryx_u32(&x667, &x668, 0x0, (fiat_p384_uint1)x660, x7);
  fiat_p384_addcarryx_u32(&x669, &x670, 0x0, x635, x7);
  fiat_p384_addcarryx_u32(&x671, &x672, x670, x637, x665);
  fiat_p384_addcarryx_u32(&x673, &x674, x672, x639, x666);
  fiat_p384_addcarryx_u32(&x675, &x676, x674, x641, x663);
  fiat_p384_addcarryx_u32(&x677, &x678, x676, x643, (fiat_p384_uint1)x664);
  fiat_p384_addcarryx_u32(&x679, &x680, x678, x645, x661);
  fiat_p384_addcarryx_u32(&x681, &x682, x680, x647, x662);
  fiat_p384_addcarryx_u32(&x683, &x684, x682, x649, x659);
  fiat_p384_addcarryx_u32(&x685, &x686, x684, x651, x667);
  fiat_p384_addcarryx_u32(&x687, &x688, x686, x653, x668);
  fiat_p384_addcarryx_u32(&x689, &x690, x688, x655, 0x0);
  fiat_p384_addcarryx_u32(&x691, &x692, x690, x657, 0x0);
  fiat_p384_mulx_u32(&x693, &x694, x669, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x695, &x696, x669, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x697, &x698, x669, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x699, &x700, x669, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x701, &x702, x669, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x703, &x704, x669, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x705, &x706, x669, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x707, &x708, x669, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x709, &x710, x669, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x711, &x712, x669, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x713, &x714, 0x0, x710, x707);
  fiat_p384_addcarryx_u32(&x715, &x716, x714, x708, x705);
  fiat_p384_addcarryx_u32(&x717, &x718, x716, x706, x703);
  fiat_p384_addcarryx_u32(&x719, &x720, x718, x704, x701);
  fiat_p384_addcarryx_u32(&x721, &x722, x720, x702, x699);
  fiat_p384_addcarryx_u32(&x723, &x724, x722, x700, x697);
  fiat_p384_addcarryx_u32(&x725, &x726, x724, x698, x695);
  fiat_p384_addcarryx_u32(&x727, &x728, x726, x696, x693);
  fiat_p384_addcarryx_u32(&x729, &x730, 0x0, x669, x711);
  fiat_p384_addcarryx_u32(&x731, &x732, x730, x671, x712);
  fiat_p384_addcarryx_u32(&x733, &x734, x732, x673, 0x0);
  fiat_p384_addcarryx_u32(&x735, &x736, x734, x675, x709);
  fiat_p384_addcarryx_u32(&x737, &x738, x736, x677, x713);
  fiat_p384_addcarryx_u32(&x739, &x740, x738, x679, x715);
  fiat_p384_addcarryx_u32(&x741, &x742, x740, x681, x717);
  fiat_p384_addcarryx_u32(&x743, &x744, x742, x683, x719);
  fiat_p384_addcarryx_u32(&x745, &x746, x744, x685, x721);
  fiat_p384_addcarryx_u32(&x747, &x748, x746, x687, x723);
  fiat_p384_addcarryx_u32(&x749, &x750, x748, x689, x725);
  fiat_p384_addcarryx_u32(&x751, &x752, x750, x691, x727);
  fiat_p384_addcarryx_u32(&x753, &x754, x752, ((uint32_t)x692 + x658), (x728 + x694));
  fiat_p384_mulx_u32(&x755, &x756, x8, 0x2);
  fiat_p384_mulx_u32(&x757, &x758, x8, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x759, &x760, x8, 0x2);
  fiat_p384_mulx_u32(&x761, &x762, x8, UINT32_C(0xfffffffe));
  fiat_p384_addcarryx_u32(&x763, &x764, 0x0, (fiat_p384_uint1)x756, x8);
  fiat_p384_addcarryx_u32(&x765, &x766, 0x0, x731, x8);
  fiat_p384_addcarryx_u32(&x767, &x768, x766, x733, x761);
  fiat_p384_addcarryx_u32(&x769, &x770, x768, x735, x762);
  fiat_p384_addcarryx_u32(&x771, &x772, x770, x737, x759);
  fiat_p384_addcarryx_u32(&x773, &x774, x772, x739, (fiat_p384_uint1)x760);
  fiat_p384_addcarryx_u32(&x775, &x776, x774, x741, x757);
  fiat_p384_addcarryx_u32(&x777, &x778, x776, x743, x758);
  fiat_p384_addcarryx_u32(&x779, &x780, x778, x745, x755);
  fiat_p384_addcarryx_u32(&x781, &x782, x780, x747, x763);
  fiat_p384_addcarryx_u32(&x783, &x784, x782, x749, x764);
  fiat_p384_addcarryx_u32(&x785, &x786, x784, x751, 0x0);
  fiat_p384_addcarryx_u32(&x787, &x788, x786, x753, 0x0);
  fiat_p384_mulx_u32(&x789, &x790, x765, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x791, &x792, x765, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x793, &x794, x765, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x795, &x796, x765, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x797, &x798, x765, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x799, &x800, x765, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x801, &x802, x765, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x803, &x804, x765, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x805, &x806, x765, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x807, &x808, x765, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x809, &x810, 0x0, x806, x803);
  fiat_p384_addcarryx_u32(&x811, &x812, x810, x804, x801);
  fiat_p384_addcarryx_u32(&x813, &x814, x812, x802, x799);
  fiat_p384_addcarryx_u32(&x815, &x816, x814, x800, x797);
  fiat_p384_addcarryx_u32(&x817, &x818, x816, x798, x795);
  fiat_p384_addcarryx_u32(&x819, &x820, x818, x796, x793);
  fiat_p384_addcarryx_u32(&x821, &x822, x820, x794, x791);
  fiat_p384_addcarryx_u32(&x823, &x824, x822, x792, x789);
  fiat_p384_addcarryx_u32(&x825, &x826, 0x0, x765, x807);
  fiat_p384_addcarryx_u32(&x827, &x828, x826, x767, x808);
  fiat_p384_addcarryx_u32(&x829, &x830, x828, x769, 0x0);
  fiat_p384_addcarryx_u32(&x831, &x832, x830, x771, x805);
  fiat_p384_addcarryx_u32(&x833, &x834, x832, x773, x809);
  fiat_p384_addcarryx_u32(&x835, &x836, x834, x775, x811);
  fiat_p384_addcarryx_u32(&x837, &x838, x836, x777, x813);
  fiat_p384_addcarryx_u32(&x839, &x840, x838, x779, x815);
  fiat_p384_addcarryx_u32(&x841, &x842, x840, x781, x817);
  fiat_p384_addcarryx_u32(&x843, &x844, x842, x783, x819);
  fiat_p384_addcarryx_u32(&x845, &x846, x844, x785, x821);
  fiat_p384_addcarryx_u32(&x847, &x848, x846, x787, x823);
  fiat_p384_addcarryx_u32(&x849, &x850, x848, ((uint32_t)x788 + x754), (x824 + x790));
  fiat_p384_mulx_u32(&x851, &x852, x9, 0x2);
  fiat_p384_mulx_u32(&x853, &x854, x9, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x855, &x856, x9, 0x2);
  fiat_p384_mulx_u32(&x857, &x858, x9, UINT32_C(0xfffffffe));
  fiat_p384_addcarryx_u32(&x859, &x860, 0x0, (fiat_p384_uint1)x852, x9);
  fiat_p384_addcarryx_u32(&x861, &x862, 0x0, x827, x9);
  fiat_p384_addcarryx_u32(&x863, &x864, x862, x829, x857);
  fiat_p384_addcarryx_u32(&x865, &x866, x864, x831, x858);
  fiat_p384_addcarryx_u32(&x867, &x868, x866, x833, x855);
  fiat_p384_addcarryx_u32(&x869, &x870, x868, x835, (fiat_p384_uint1)x856);
  fiat_p384_addcarryx_u32(&x871, &x872, x870, x837, x853);
  fiat_p384_addcarryx_u32(&x873, &x874, x872, x839, x854);
  fiat_p384_addcarryx_u32(&x875, &x876, x874, x841, x851);
  fiat_p384_addcarryx_u32(&x877, &x878, x876, x843, x859);
  fiat_p384_addcarryx_u32(&x879, &x880, x878, x845, x860);
  fiat_p384_addcarryx_u32(&x881, &x882, x880, x847, 0x0);
  fiat_p384_addcarryx_u32(&x883, &x884, x882, x849, 0x0);
  fiat_p384_mulx_u32(&x885, &x886, x861, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x887, &x888, x861, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x889, &x890, x861, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x891, &x892, x861, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x893, &x894, x861, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x895, &x896, x861, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x897, &x898, x861, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x899, &x900, x861, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x901, &x902, x861, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x903, &x904, x861, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x905, &x906, 0x0, x902, x899);
  fiat_p384_addcarryx_u32(&x907, &x908, x906, x900, x897);
  fiat_p384_addcarryx_u32(&x909, &x910, x908, x898, x895);
  fiat_p384_addcarryx_u32(&x911, &x912, x910, x896, x893);
  fiat_p384_addcarryx_u32(&x913, &x914, x912, x894, x891);
  fiat_p384_addcarryx_u32(&x915, &x916, x914, x892, x889);
  fiat_p384_addcarryx_u32(&x917, &x918, x916, x890, x887);
  fiat_p384_addcarryx_u32(&x919, &x920, x918, x888, x885);
  fiat_p384_addcarryx_u32(&x921, &x922, 0x0, x861, x903);
  fiat_p384_addcarryx_u32(&x923, &x924, x922, x863, x904);
  fiat_p384_addcarryx_u32(&x925, &x926, x924, x865, 0x0);
  fiat_p384_addcarryx_u32(&x927, &x928, x926, x867, x901);
  fiat_p384_addcarryx_u32(&x929, &x930, x928, x869, x905);
  fiat_p384_addcarryx_u32(&x931, &x932, x930, x871, x907);
  fiat_p384_addcarryx_u32(&x933, &x934, x932, x873, x909);
  fiat_p384_addcarryx_u32(&x935, &x936, x934, x875, x911);
  fiat_p384_addcarryx_u32(&x937, &x938, x936, x877, x913);
  fiat_p384_addcarryx_u32(&x939, &x940, x938, x879, x915);
  fiat_p384_addcarryx_u32(&x941, &x942, x940, x881, x917);
  fiat_p384_addcarryx_u32(&x943, &x944, x942, x883, x919);
  fiat_p384_addcarryx_u32(&x945, &x946, x944, ((uint32_t)x884 + x850), (x920 + x886));
  fiat_p384_mulx_u32(&x947, &x948, x10, 0x2);
  fiat_p384_mulx_u32(&x949, &x950, x10, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x951, &x952, x10, 0x2);
  fiat_p384_mulx_u32(&x953, &x954, x10, UINT32_C(0xfffffffe));
  fiat_p384_addcarryx_u32(&x955, &x956, 0x0, (fiat_p384_uint1)x948, x10);
  fiat_p384_addcarryx_u32(&x957, &x958, 0x0, x923, x10);
  fiat_p384_addcarryx_u32(&x959, &x960, x958, x925, x953);
  fiat_p384_addcarryx_u32(&x961, &x962, x960, x927, x954);
  fiat_p384_addcarryx_u32(&x963, &x964, x962, x929, x951);
  fiat_p384_addcarryx_u32(&x965, &x966, x964, x931, (fiat_p384_uint1)x952);
  fiat_p384_addcarryx_u32(&x967, &x968, x966, x933, x949);
  fiat_p384_addcarryx_u32(&x969, &x970, x968, x935, x950);
  fiat_p384_addcarryx_u32(&x971, &x972, x970, x937, x947);
  fiat_p384_addcarryx_u32(&x973, &x974, x972, x939, x955);
  fiat_p384_addcarryx_u32(&x975, &x976, x974, x941, x956);
  fiat_p384_addcarryx_u32(&x977, &x978, x976, x943, 0x0);
  fiat_p384_addcarryx_u32(&x979, &x980, x978, x945, 0x0);
  fiat_p384_mulx_u32(&x981, &x982, x957, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x983, &x984, x957, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x985, &x986, x957, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x987, &x988, x957, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x989, &x990, x957, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x991, &x992, x957, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x993, &x994, x957, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x995, &x996, x957, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x997, &x998, x957, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x999, &x1000, x957, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x1001, &x1002, 0x0, x998, x995);
  fiat_p384_addcarryx_u32(&x1003, &x1004, x1002, x996, x993);
  fiat_p384_addcarryx_u32(&x1005, &x1006, x1004, x994, x991);
  fiat_p384_addcarryx_u32(&x1007, &x1008, x1006, x992, x989);
  fiat_p384_addcarryx_u32(&x1009, &x1010, x1008, x990, x987);
  fiat_p384_addcarryx_u32(&x1011, &x1012, x1010, x988, x985);
  fiat_p384_addcarryx_u32(&x1013, &x1014, x1012, x986, x983);
  fiat_p384_addcarryx_u32(&x1015, &x1016, x1014, x984, x981);
  fiat_p384_addcarryx_u32(&x1017, &x1018, 0x0, x957, x999);
  fiat_p384_addcarryx_u32(&x1019, &x1020, x1018, x959, x1000);
  fiat_p384_addcarryx_u32(&x1021, &x1022, x1020, x961, 0x0);
  fiat_p384_addcarryx_u32(&x1023, &x1024, x1022, x963, x997);
  fiat_p384_addcarryx_u32(&x1025, &x1026, x1024, x965, x1001);
  fiat_p384_addcarryx_u32(&x1027, &x1028, x1026, x967, x1003);
  fiat_p384_addcarryx_u32(&x1029, &x1030, x1028, x969, x1005);
  fiat_p384_addcarryx_u32(&x1031, &x1032, x1030, x971, x1007);
  fiat_p384_addcarryx_u32(&x1033, &x1034, x1032, x973, x1009);
  fiat_p384_addcarryx_u32(&x1035, &x1036, x1034, x975, x1011);
  fiat_p384_addcarryx_u32(&x1037, &x1038, x1036, x977, x1013);
  fiat_p384_addcarryx_u32(&x1039, &x1040, x1038, x979, x1015);
  fiat_p384_addcarryx_u32(&x1041, &x1042, x1040, ((uint32_t)x980 + x946), (x1016 + x982));
  fiat_p384_mulx_u32(&x1043, &x1044, x11, 0x2);
  fiat_p384_mulx_u32(&x1045, &x1046, x11, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x1047, &x1048, x11, 0x2);
  fiat_p384_mulx_u32(&x1049, &x1050, x11, UINT32_C(0xfffffffe));
  fiat_p384_addcarryx_u32(&x1051, &x1052, 0x0, (fiat_p384_uint1)x1044, x11);
  fiat_p384_addcarryx_u32(&x1053, &x1054, 0x0, x1019, x11);
  fiat_p384_addcarryx_u32(&x1055, &x1056, x1054, x1021, x1049);
  fiat_p384_addcarryx_u32(&x1057, &x1058, x1056, x1023, x1050);
  fiat_p384_addcarryx_u32(&x1059, &x1060, x1058, x1025, x1047);
  fiat_p384_addcarryx_u32(&x1061, &x1062, x1060, x1027, (fiat_p384_uint1)x1048);
  fiat_p384_addcarryx_u32(&x1063, &x1064, x1062, x1029, x1045);
  fiat_p384_addcarryx_u32(&x1065, &x1066, x1064, x1031, x1046);
  fiat_p384_addcarryx_u32(&x1067, &x1068, x1066, x1033, x1043);
  fiat_p384_addcarryx_u32(&x1069, &x1070, x1068, x1035, x1051);
  fiat_p384_addcarryx_u32(&x1071, &x1072, x1070, x1037, x1052);
  fiat_p384_addcarryx_u32(&x1073, &x1074, x1072, x1039, 0x0);
  fiat_p384_addcarryx_u32(&x1075, &x1076, x1074, x1041, 0x0);
  fiat_p384_mulx_u32(&x1077, &x1078, x1053, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1079, &x1080, x1053, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1081, &x1082, x1053, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1083, &x1084, x1053, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1085, &x1086, x1053, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1087, &x1088, x1053, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1089, &x1090, x1053, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1091, &x1092, x1053, UINT32_C(0xfffffffe));
  fiat_p384_mulx_u32(&x1093, &x1094, x1053, UINT32_C(0xffffffff));
  fiat_p384_mulx_u32(&x1095, &x1096, x1053, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x1097, &x1098, 0x0, x1094, x1091);
  fiat_p384_addcarryx_u32(&x1099, &x1100, x1098, x1092, x1089);
  fiat_p384_addcarryx_u32(&x1101, &x1102, x1100, x1090, x1087);
  fiat_p384_addcarryx_u32(&x1103, &x1104, x1102, x1088, x1085);
  fiat_p384_addcarryx_u32(&x1105, &x1106, x1104, x1086, x1083);
  fiat_p384_addcarryx_u32(&x1107, &x1108, x1106, x1084, x1081);
  fiat_p384_addcarryx_u32(&x1109, &x1110, x1108, x1082, x1079);
  fiat_p384_addcarryx_u32(&x1111, &x1112, x1110, x1080, x1077);
  fiat_p384_addcarryx_u32(&x1113, &x1114, 0x0, x1053, x1095);
  fiat_p384_addcarryx_u32(&x1115, &x1116, x1114, x1055, x1096);
  fiat_p384_addcarryx_u32(&x1117, &x1118, x1116, x1057, 0x0);
  fiat_p384_addcarryx_u32(&x1119, &x1120, x1118, x1059, x1093);
  fiat_p384_addcarryx_u32(&x1121, &x1122, x1120, x1061, x1097);
  fiat_p384_addcarryx_u32(&x1123, &x1124, x1122, x1063, x1099);
  fiat_p384_addcarryx_u32(&x1125, &x1126, x1124, x1065, x1101);
  fiat_p384_addcarryx_u32(&x1127, &x1128, x1126, x1067, x1103);
  fiat_p384_addcarryx_u32(&x1129, &x1130, x1128, x1069, x1105);
  fiat_p384_addcarryx_u32(&x1131, &x1132, x1130, x1071, x1107);
  fiat_p384_addcarryx_u32(&x1133, &x1134, x1132, x1073, x1109);
  fiat_p384_addcarryx_u32(&x1135, &x1136, x1134, x1075, x1111);
  fiat_p384_addcarryx_u32(&x1137, &x1138, x1136, ((uint32_t)x1076 + x1042), (x1112 + x1078));
  fiat_p384_subborrowx_u32(&x1139, &x1140, 0x0, x1115, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1141, &x1142, x1140, x1117, 0x0);
  fiat_p384_subborrowx_u32(&x1143, &x1144, x1142, x1119, 0x0);
  fiat_p384_subborrowx_u32(&x1145, &x1146, x1144, x1121, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1147, &x1148, x1146, x1123, UINT32_C(0xfffffffe));
  fiat_p384_subborrowx_u32(&x1149, &x1150, x1148, x1125, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1151, &x1152, x1150, x1127, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1153, &x1154, x1152, x1129, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1155, &x1156, x1154, x1131, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1157, &x1158, x1156, x1133, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1159, &x1160, x1158, x1135, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1161, &x1162, x1160, x1137, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x1163, &x1164, x1162, x1138, 0x0);
  fiat_p384_cmovznz_u32(&x1165, x1164, x1139, x1115);
  fiat_p384_cmovznz_u32(&x1166, x1164, x1141, x1117);
  fiat_p384_cmovznz_u32(&x1167, x1164, x1143, x1119);
  fiat_p384_cmovznz_u32(&x1168, x1164, x1145, x1121);
  fiat_p384_cmovznz_u32(&x1169, x1164, x1147, x1123);
  fiat_p384_cmovznz_u32(&x1170, x1164, x1149, x1125);
  fiat_p384_cmovznz_u32(&x1171, x1164, x1151, x1127);
  fiat_p384_cmovznz_u32(&x1172, x1164, x1153, x1129);
  fiat_p384_cmovznz_u32(&x1173, x1164, x1155, x1131);
  fiat_p384_cmovznz_u32(&x1174, x1164, x1157, x1133);
  fiat_p384_cmovznz_u32(&x1175, x1164, x1159, x1135);
  fiat_p384_cmovznz_u32(&x1176, x1164, x1161, x1137);
  out1[0] = x1165;
  out1[1] = x1166;
  out1[2] = x1167;
  out1[3] = x1168;
  out1[4] = x1169;
  out1[5] = x1170;
  out1[6] = x1171;
  out1[7] = x1172;
  out1[8] = x1173;
  out1[9] = x1174;
  out1[10] = x1175;
  out1[11] = x1176;
}

/*
 * The function fiat_p384_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static void fiat_p384_nonzero(uint32_t* out1, const uint32_t arg1[12]) {
  uint32_t x1;
  x1 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | ((arg1[3]) | ((arg1[4]) | ((arg1[5]) | ((arg1[6]) | ((arg1[7]) | ((arg1[8]) | ((arg1[9]) | ((arg1[10]) | (arg1[11]))))))))))));
  *out1 = x1;
}

/*
 * The function fiat_p384_selectznz is a multi-limb conditional select.
 *
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p384_selectznz(uint32_t out1[12], fiat_p384_uint1 arg1, const uint32_t arg2[12], const uint32_t arg3[12]) {
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  uint32_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint32_t x12;
  fiat_p384_cmovznz_u32(&x1, arg1, (arg2[0]), (arg3[0]));
  fiat_p384_cmovznz_u32(&x2, arg1, (arg2[1]), (arg3[1]));
  fiat_p384_cmovznz_u32(&x3, arg1, (arg2[2]), (arg3[2]));
  fiat_p384_cmovznz_u32(&x4, arg1, (arg2[3]), (arg3[3]));
  fiat_p384_cmovznz_u32(&x5, arg1, (arg2[4]), (arg3[4]));
  fiat_p384_cmovznz_u32(&x6, arg1, (arg2[5]), (arg3[5]));
  fiat_p384_cmovznz_u32(&x7, arg1, (arg2[6]), (arg3[6]));
  fiat_p384_cmovznz_u32(&x8, arg1, (arg2[7]), (arg3[7]));
  fiat_p384_cmovznz_u32(&x9, arg1, (arg2[8]), (arg3[8]));
  fiat_p384_cmovznz_u32(&x10, arg1, (arg2[9]), (arg3[9]));
  fiat_p384_cmovznz_u32(&x11, arg1, (arg2[10]), (arg3[10]));
  fiat_p384_cmovznz_u32(&x12, arg1, (arg2[11]), (arg3[11]));
  out1[0] = x1;
  out1[1] = x2;
  out1[2] = x3;
  out1[3] = x4;
  out1[4] = x5;
  out1[5] = x6;
  out1[6] = x7;
  out1[7] = x8;
  out1[8] = x9;
  out1[9] = x10;
  out1[10] = x11;
  out1[11] = x12;
}

/*
 * The function fiat_p384_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
 *
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..47]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 */
static void fiat_p384_to_bytes(uint8_t out1[48], const uint32_t arg1[12]) {
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint32_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  uint32_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint32_t x12;
  uint8_t x13;
  uint32_t x14;
  uint8_t x15;
  uint32_t x16;
  uint8_t x17;
  uint8_t x18;
  uint8_t x19;
  uint32_t x20;
  uint8_t x21;
  uint32_t x22;
  uint8_t x23;
  uint8_t x24;
  uint8_t x25;
  uint32_t x26;
  uint8_t x27;
  uint32_t x28;
  uint8_t x29;
  uint8_t x30;
  uint8_t x31;
  uint32_t x32;
  uint8_t x33;
  uint32_t x34;
  uint8_t x35;
  uint8_t x36;
  uint8_t x37;
  uint32_t x38;
  uint8_t x39;
  uint32_t x40;
  uint8_t x41;
  uint8_t x42;
  uint8_t x43;
  uint32_t x44;
  uint8_t x45;
  uint32_t x46;
  uint8_t x47;
  uint8_t x48;
  uint8_t x49;
  uint32_t x50;
  uint8_t x51;
  uint32_t x52;
  uint8_t x53;
  uint8_t x54;
  uint8_t x55;
  uint32_t x56;
  uint8_t x57;
  uint32_t x58;
  uint8_t x59;
  uint8_t x60;
  uint8_t x61;
  uint32_t x62;
  uint8_t x63;
  uint32_t x64;
  uint8_t x65;
  uint8_t x66;
  uint8_t x67;
  uint32_t x68;
  uint8_t x69;
  uint32_t x70;
  uint8_t x71;
  uint8_t x72;
  uint8_t x73;
  uint32_t x74;
  uint8_t x75;
  uint32_t x76;
  uint8_t x77;
  uint8_t x78;
  uint8_t x79;
  uint32_t x80;
  uint8_t x81;
  uint32_t x82;
  uint8_t x83;
  uint8_t x84;
  x1 = (arg1[11]);
  x2 = (arg1[10]);
  x3 = (arg1[9]);
  x4 = (arg1[8]);
  x5 = (arg1[7]);
  x6 = (arg1[6]);
  x7 = (arg1[5]);
  x8 = (arg1[4]);
  x9 = (arg1[3]);
  x10 = (arg1[2]);
  x11 = (arg1[1]);
  x12 = (arg1[0]);
  x13 = (uint8_t)(x12 & UINT8_C(0xff));
  x14 = (x12 >> 8);
  x15 = (uint8_t)(x14 & UINT8_C(0xff));
  x16 = (x14 >> 8);
  x17 = (uint8_t)(x16 & UINT8_C(0xff));
  x18 = (uint8_t)(x16 >> 8);
  x19 = (uint8_t)(x11 & UINT8_C(0xff));
  x20 = (x11 >> 8);
  x21 = (uint8_t)(x20 & UINT8_C(0xff));
  x22 = (x20 >> 8);
  x23 = (uint8_t)(x22 & UINT8_C(0xff));
  x24 = (uint8_t)(x22 >> 8);
  x25 = (uint8_t)(x10 & UINT8_C(0xff));
  x26 = (x10 >> 8);
  x27 = (uint8_t)(x26 & UINT8_C(0xff));
  x28 = (x26 >> 8);
  x29 = (uint8_t)(x28 & UINT8_C(0xff));
  x30 = (uint8_t)(x28 >> 8);
  x31 = (uint8_t)(x9 & UINT8_C(0xff));
  x32 = (x9 >> 8);
  x33 = (uint8_t)(x32 & UINT8_C(0xff));
  x34 = (x32 >> 8);
  x35 = (uint8_t)(x34 & UINT8_C(0xff));
  x36 = (uint8_t)(x34 >> 8);
  x37 = (uint8_t)(x8 & UINT8_C(0xff));
  x38 = (x8 >> 8);
  x39 = (uint8_t)(x38 & UINT8_C(0xff));
  x40 = (x38 >> 8);
  x41 = (uint8_t)(x40 & UINT8_C(0xff));
  x42 = (uint8_t)(x40 >> 8);
  x43 = (uint8_t)(x7 & UINT8_C(0xff));
  x44 = (x7 >> 8);
  x45 = (uint8_t)(x44 & UINT8_C(0xff));
  x46 = (x44 >> 8);
  x47 = (uint8_t)(x46 & UINT8_C(0xff));
  x48 = (uint8_t)(x46 >> 8);
  x49 = (uint8_t)(x6 & UINT8_C(0xff));
  x50 = (x6 >> 8);
  x51 = (uint8_t)(x50 & UINT8_C(0xff));
  x52 = (x50 >> 8);
  x53 = (uint8_t)(x52 & UINT8_C(0xff));
  x54 = (uint8_t)(x52 >> 8);
  x55 = (uint8_t)(x5 & UINT8_C(0xff));
  x56 = (x5 >> 8);
  x57 = (uint8_t)(x56 & UINT8_C(0xff));
  x58 = (x56 >> 8);
  x59 = (uint8_t)(x58 & UINT8_C(0xff));
  x60 = (uint8_t)(x58 >> 8);
  x61 = (uint8_t)(x4 & UINT8_C(0xff));
  x62 = (x4 >> 8);
  x63 = (uint8_t)(x62 & UINT8_C(0xff));
  x64 = (x62 >> 8);
  x65 = (uint8_t)(x64 & UINT8_C(0xff));
  x66 = (uint8_t)(x64 >> 8);
  x67 = (uint8_t)(x3 & UINT8_C(0xff));
  x68 = (x3 >> 8);
  x69 = (uint8_t)(x68 & UINT8_C(0xff));
  x70 = (x68 >> 8);
  x71 = (uint8_t)(x70 & UINT8_C(0xff));
  x72 = (uint8_t)(x70 >> 8);
  x73 = (uint8_t)(x2 & UINT8_C(0xff));
  x74 = (x2 >> 8);
  x75 = (uint8_t)(x74 & UINT8_C(0xff));
  x76 = (x74 >> 8);
  x77 = (uint8_t)(x76 & UINT8_C(0xff));
  x78 = (uint8_t)(x76 >> 8);
  x79 = (uint8_t)(x1 & UINT8_C(0xff));
  x80 = (x1 >> 8);
  x81 = (uint8_t)(x80 & UINT8_C(0xff));
  x82 = (x80 >> 8);
  x83 = (uint8_t)(x82 & UINT8_C(0xff));
  x84 = (uint8_t)(x82 >> 8);
  out1[0] = x13;
  out1[1] = x15;
  out1[2] = x17;
  out1[3] = x18;
  out1[4] = x19;
  out1[5] = x21;
  out1[6] = x23;
  out1[7] = x24;
  out1[8] = x25;
  out1[9] = x27;
  out1[10] = x29;
  out1[11] = x30;
  out1[12] = x31;
  out1[13] = x33;
  out1[14] = x35;
  out1[15] = x36;
  out1[16] = x37;
  out1[17] = x39;
  out1[18] = x41;
  out1[19] = x42;
  out1[20] = x43;
  out1[21] = x45;
  out1[22] = x47;
  out1[23] = x48;
  out1[24] = x49;
  out1[25] = x51;
  out1[26] = x53;
  out1[27] = x54;
  out1[28] = x55;
  out1[29] = x57;
  out1[30] = x59;
  out1[31] = x60;
  out1[32] = x61;
  out1[33] = x63;
  out1[34] = x65;
  out1[35] = x66;
  out1[36] = x67;
  out1[37] = x69;
  out1[38] = x71;
  out1[39] = x72;
  out1[40] = x73;
  out1[41] = x75;
  out1[42] = x77;
  out1[43] = x78;
  out1[44] = x79;
  out1[45] = x81;
  out1[46] = x83;
  out1[47] = x84;
}

/*
 * The function fiat_p384_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
 *
 * Preconditions:
 *   0 ≤ bytes_eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p384_from_bytes(uint32_t out1[12], const uint8_t arg1[48]) {
  uint32_t x1;
  uint32_t x2;
  uint32_t x3;
  uint8_t x4;
  uint32_t x5;
  uint32_t x6;
  uint32_t x7;
  uint8_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint8_t x12;
  uint32_t x13;
  uint32_t x14;
  uint32_t x15;
  uint8_t x16;
  uint32_t x17;
  uint32_t x18;
  uint32_t x19;
  uint8_t x20;
  uint32_t x21;
  uint32_t x22;
  uint32_t x23;
  uint8_t x24;
  uint32_t x25;
  uint32_t x26;
  uint32_t x27;
  uint8_t x28;
  uint32_t x29;
  uint32_t x30;
  uint32_t x31;
  uint8_t x32;
  uint32_t x33;
  uint32_t x34;
  uint32_t x35;
  uint8_t x36;
  uint32_t x37;
  uint32_t x38;
  uint32_t x39;
  uint8_t x40;
  uint32_t x41;
  uint32_t x42;
  uint32_t x43;
  uint8_t x44;
  uint32_t x45;
  uint32_t x46;
  uint32_t x47;
  uint8_t x48;
  uint32_t x49;
  uint32_t x50;
  uint32_t x51;
  uint32_t x52;
  uint32_t x53;
  uint32_t x54;
  uint32_t x55;
  uint32_t x56;
  uint32_t x57;
  uint32_t x58;
  uint32_t x59;
  uint32_t x60;
  uint32_t x61;
  uint32_t x62;
  uint32_t x63;
  uint32_t x64;
  uint32_t x65;
  uint32_t x66;
  uint32_t x67;
  uint32_t x68;
  uint32_t x69;
  uint32_t x70;
  uint32_t x71;
  uint32_t x72;
  uint32_t x73;
  uint32_t x74;
  uint32_t x75;
  uint32_t x76;
  uint32_t x77;
  uint32_t x78;
  uint32_t x79;
  uint32_t x80;
  uint32_t x81;
  uint32_t x82;
  uint32_t x83;
  uint32_t x84;
  x1 = ((uint32_t)(arg1[47]) << 24);
  x2 = ((uint32_t)(arg1[46]) << 16);
  x3 = ((uint32_t)(arg1[45]) << 8);
  x4 = (arg1[44]);
  x5 = ((uint32_t)(arg1[43]) << 24);
  x6 = ((uint32_t)(arg1[42]) << 16);
  x7 = ((uint32_t)(arg1[41]) << 8);
  x8 = (arg1[40]);
  x9 = ((uint32_t)(arg1[39]) << 24);
  x10 = ((uint32_t)(arg1[38]) << 16);
  x11 = ((uint32_t)(arg1[37]) << 8);
  x12 = (arg1[36]);
  x13 = ((uint32_t)(arg1[35]) << 24);
  x14 = ((uint32_t)(arg1[34]) << 16);
  x15 = ((uint32_t)(arg1[33]) << 8);
  x16 = (arg1[32]);
  x17 = ((uint32_t)(arg1[31]) << 24);
  x18 = ((uint32_t)(arg1[30]) << 16);
  x19 = ((uint32_t)(arg1[29]) << 8);
  x20 = (arg1[28]);
  x21 = ((uint32_t)(arg1[27]) << 24);
  x22 = ((uint32_t)(arg1[26]) << 16);
  x23 = ((uint32_t)(arg1[25]) << 8);
  x24 = (arg1[24]);
  x25 = ((uint32_t)(arg1[23]) << 24);
  x26 = ((uint32_t)(arg1[22]) << 16);
  x27 = ((uint32_t)(arg1[21]) << 8);
  x28 = (arg1[20]);
  x29 = ((uint32_t)(arg1[19]) << 24);
  x30 = ((uint32_t)(arg1[18]) << 16);
  x31 = ((uint32_t)(arg1[17]) << 8);
  x32 = (arg1[16]);
  x33 = ((uint32_t)(arg1[15]) << 24);
  x34 = ((uint32_t)(arg1[14]) << 16);
  x35 = ((uint32_t)(arg1[13]) << 8);
  x36 = (arg1[12]);
  x37 = ((uint32_t)(arg1[11]) << 24);
  x38 = ((uint32_t)(arg1[10]) << 16);
  x39 = ((uint32_t)(arg1[9]) << 8);
  x40 = (arg1[8]);
  x41 = ((uint32_t)(arg1[7]) << 24);
  x42 = ((uint32_t)(arg1[6]) << 16);
  x43 = ((uint32_t)(arg1[5]) << 8);
  x44 = (arg1[4]);
  x45 = ((uint32_t)(arg1[3]) << 24);
  x46 = ((uint32_t)(arg1[2]) << 16);
  x47 = ((uint32_t)(arg1[1]) << 8);
  x48 = (arg1[0]);
  x49 = (x47 + (uint32_t)x48);
  x50 = (x46 + x49);
  x51 = (x45 + x50);
  x52 = (x43 + (uint32_t)x44);
  x53 = (x42 + x52);
  x54 = (x41 + x53);
  x55 = (x39 + (uint32_t)x40);
  x56 = (x38 + x55);
  x57 = (x37 + x56);
  x58 = (x35 + (uint32_t)x36);
  x59 = (x34 + x58);
  x60 = (x33 + x59);
  x61 = (x31 + (uint32_t)x32);
  x62 = (x30 + x61);
  x63 = (x29 + x62);
  x64 = (x27 + (uint32_t)x28);
  x65 = (x26 + x64);
  x66 = (x25 + x65);
  x67 = (x23 + (uint32_t)x24);
  x68 = (x22 + x67);
  x69 = (x21 + x68);
  x70 = (x19 + (uint32_t)x20);
  x71 = (x18 + x70);
  x72 = (x17 + x71);
  x73 = (x15 + (uint32_t)x16);
  x74 = (x14 + x73);
  x75 = (x13 + x74);
  x76 = (x11 + (uint32_t)x12);
  x77 = (x10 + x76);
  x78 = (x9 + x77);
  x79 = (x7 + (uint32_t)x8);
  x80 = (x6 + x79);
  x81 = (x5 + x80);
  x82 = (x3 + (uint32_t)x4);
  x83 = (x2 + x82);
  x84 = (x1 + x83);
  out1[0] = x51;
  out1[1] = x54;
  out1[2] = x57;
  out1[3] = x60;
  out1[4] = x63;
  out1[5] = x66;
  out1[6] = x69;
  out1[7] = x72;
  out1[8] = x75;
  out1[9] = x78;
  out1[10] = x81;
  out1[11] = x84;
}

/*
 * The function fiat_p384_set_one returns the field element one in the Montgomery domain.
 *
 * Postconditions:
 *   eval (from_montgomery out1) mod m = 1 mod m
 *   0 ≤ eval out1 < m
 *
 */
static void fiat_p384_set_one(fiat_p384_montgomery_domain_field_element out1) {
  out1[0] = 0x1;
  out1[1] = UINT32_C(0xffffffff);
  out1[2] = UINT32_C(0xffffffff);
  out1[3] = 0x0;
  out1[4] = 0x1;
  out1[5] = 0x0;
  out1[6] = 0x0;
  out1[7] = 0x0;
  out1[8] = 0x0;
  out1[9] = 0x0;
  out1[10] = 0x0;
  out1[11] = 0x0;
}

/*
 * The function fiat_p384_msat returns the saturated representation of the prime modulus.
 *
 * Postconditions:
 *   twos_complement_eval out1 = m
 *   0 ≤ eval out1 < m
 *
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p384_msat(uint32_t out1[13]) {
  out1[0] = UINT32_C(0xffffffff);
  out1[1] = 0x0;
  out1[2] = 0x0;
  out1[3] = UINT32_C(0xffffffff);
  out1[4] = UINT32_C(0xfffffffe);
  out1[5] = UINT32_C(0xffffffff);
  out1[6] = UINT32_C(0xffffffff);
  out1[7] = UINT32_C(0xffffffff);
  out1[8] = UINT32_C(0xffffffff);
  out1[9] = UINT32_C(0xffffffff);
  out1[10] = UINT32_C(0xffffffff);
  out1[11] = UINT32_C(0xffffffff);
  out1[12] = 0x0;
}

/*
 * The function fiat_p384_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).
 *
 * Postconditions:
 *   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)
 *   0 ≤ eval out1 < m
 *
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p384_divstep_precomp(uint32_t out1[12]) {
  out1[0] = UINT32_C(0xfff18fff);
  out1[1] = UINT32_C(0xfff69400);
  out1[2] = UINT32_C(0xffffd3ff);
  out1[3] = UINT32_C(0x2b7fe);
  out1[4] = UINT32_C(0xfffe97ff);
  out1[5] = UINT32_C(0xfffedbff);
  out1[6] = UINT16_C(0x2fff);
  out1[7] = UINT32_C(0x28400);
  out1[8] = UINT32_C(0x50400);
  out1[9] = UINT32_C(0x60400);
  out1[10] = UINT32_C(0x38000);
  out1[11] = UINT32_C(0xfffc4800);
}

/*
 * The function fiat_p384_divstep computes a divstep.
 *
 * Preconditions:
 *   0 ≤ eval arg4 < m
 *   0 ≤ eval arg5 < m
 * Postconditions:
 *   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)
 *   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)
 *   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)
 *   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)
 *   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)
 *   0 ≤ eval out5 < m
 *   0 ≤ eval out5 < m
 *   0 ≤ eval out2 < m
 *   0 ≤ eval out3 < m
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffff]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   out3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   out4: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   out5: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_p384_divstep(uint32_t* out1, uint32_t out2[13], uint32_t out3[13], uint32_t out4[12], uint32_t out5[12], uint32_t arg1, const uint32_t arg2[13], const uint32_t arg3[13], const uint32_t arg4[12], const uint32_t arg5[12]) {
  uint32_t x1;
  fiat_p384_uint1 x2;
  fiat_p384_uint1 x3;
  uint32_t x4;
  fiat_p384_uint1 x5;
  uint32_t x6;
  uint32_t x7;
  uint32_t x8;
  uint32_t x9;
  uint32_t x10;
  uint32_t x11;
  uint32_t x12;
  uint32_t x13;
  uint32_t x14;
  uint32_t x15;
  uint32_t x16;
  uint32_t x17;
  uint32_t x18;
  uint32_t x19;
  uint32_t x20;
  fiat_p384_uint1 x21;
  uint32_t x22;
  fiat_p384_uint1 x23;
  uint32_t x24;
  fiat_p384_uint1 x25;
  uint32_t x26;
  fiat_p384_uint1 x27;
  uint32_t x28;
  fiat_p384_uint1 x29;
  uint32_t x30;
  fiat_p384_uint1 x31;
  uint32_t x32;
  fiat_p384_uint1 x33;
  uint32_t x34;
  fiat_p384_uint1 x35;
  uint32_t x36;
  fiat_p384_uint1 x37;
  uint32_t x38;
  fiat_p384_uint1 x39;
  uint32_t x40;
  fiat_p384_uint1 x41;
  uint32_t x42;
  fiat_p384_uint1 x43;
  uint32_t x44;
  fiat_p384_uint1 x45;
  uint32_t x46;
  uint32_t x47;
  uint32_t x48;
  uint32_t x49;
  uint32_t x50;
  uint32_t x51;
  uint32_t x52;
  uint32_t x53;
  uint32_t x54;
  uint32_t x55;
  uint32_t x56;
  uint32_t x57;
  uint32_t x58;
  uint32_t x59;
  uint32_t x60;
  uint32_t x61;
  uint32_t x62;
  uint32_t x63;
  uint32_t x64;
  uint32_t x65;
  uint32_t x66;
  uint32_t x67;
  uint32_t x68;
  uint32_t x69;
  uint32_t x70;
  uint32_t x71;
  fiat_p384_uint1 x72;
  uint32_t x73;
  fiat_p384_uint1 x74;
  uint32_t x75;
  fiat_p384_uint1 x76;
  uint32_t x77;
  fiat_p384_uint1 x78;
  uint32_t x79;
  fiat_p384_uint1 x80;
  uint32_t x81;
  fiat_p384_uint1 x82;
  uint32_t x83;
  fiat_p384_uint1 x84;
  uint32_t x85;
  fiat_p384_uint1 x86;
  uint32_t x87;
  fiat_p384_uint1 x88;
  uint32_t x89;
  fiat_p384_uint1 x90;
  uint32_t x91;
  fiat_p384_uint1 x92;
  uint32_t x93;
  fiat_p384_uint1 x94;
  uint32_t x95;
  fiat_p384_uint1 x96;
  uint32_t x97;
  fiat_p384_uint1 x98;
  uint32_t x99;
  fiat_p384_uint1 x100;
  uint32_t x101;
  fiat_p384_uint1 x102;
  uint32_t x103;
  fiat_p384_uint1 x104;
  uint32_t x105;
  fiat_p384_uint1 x106;
  uint32_t x107;
  fiat_p384_uint1 x108;
  uint32_t x109;
  fiat_p384_uint1 x110;
  uint32_t x111;
  fiat_p384_uint1 x112;
  uint32_t x113;
  fiat_p384_uint1 x114;
  uint32_t x115;
  fiat_p384_uint1 x116;
  uint32_t x117;
  fiat_p384_uint1 x118;
  uint32_t x119;
  fiat_p384_uint1 x120;
  uint32_t x121;
  uint32_t x122;
  uint32_t x123;
  uint32_t x124;
  uint32_t x125;
  uint32_t x126;
  uint32_t x127;
  uint32_t x128;
  uint32_t x129;
  uint32_t x130;
  uint32_t x131;
  uint32_t x132;
  uint32_t x133;
  fiat_p384_uint1 x134;
  uint32_t x135;
  fiat_p384_uint1 x136;
  uint32_t x137;
  fiat_p384_uint1 x138;
  uint32_t x139;
  fiat_p384_uint1 x140;
  uint32_t x141;
  fiat_p384_uint1 x142;
  uint32_t x143;
  fiat_p384_uint1 x144;
  uint32_t x145;
  fiat_p384_uint1 x146;
  uint32_t x147;
  fiat_p384_uint1 x148;
  uint32_t x149;
  fiat_p384_uint1 x150;
  uint32_t x151;
  fiat_p384_uint1 x152;
  uint32_t x153;
  fiat_p384_uint1 x154;
  uint32_t x155;
  fiat_p384_uint1 x156;
  uint32_t x157;
  uint32_t x158;
  fiat_p384_uint1 x159;
  uint32_t x160;
  fiat_p384_uint1 x161;
  uint32_t x162;
  fiat_p384_uint1 x163;
  uint32_t x164;
  fiat_p384_uint1 x165;
  uint32_t x166;
  fiat_p384_uint1 x167;
  uint32_t x168;
  fiat_p384_uint1 x169;
  uint32_t x170;
  fiat_p384_uint1 x171;
  uint32_t x172;
  fiat_p384_uint1 x173;
  uint32_t x174;
  fiat_p384_uint1 x175;
  uint32_t x176;
  fiat_p384_uint1 x177;
  uint32_t x178;
  fiat_p384_uint1 x179;
  uint32_t x180;
  fiat_p384_uint1 x181;
  uint32_t x182;
  uint32_t x183;
  uint32_t x184;
  uint32_t x185;
  uint32_t x186;
  uint32_t x187;
  uint32_t x188;
  uint32_t x189;
  uint32_t x190;
  uint32_t x191;
  uint32_t x192;
  uint32_t x193;
  fiat_p384_uint1 x194;
  uint32_t x195;
  uint32_t x196;
  uint32_t x197;
  uint32_t x198;
  uint32_t x199;
  uint32_t x200;
  uint32_t x201;
  uint32_t x202;
  uint32_t x203;
  uint32_t x204;
  uint32_t x205;
  uint32_t x206;
  uint32_t x207;
  uint32_t x208;
  fiat_p384_uint1 x209;
  uint32_t x210;
  fiat_p384_uint1 x211;
  uint32_t x212;
  fiat_p384_uint1 x213;
  uint32_t x214;
  fiat_p384_uint1 x215;
  uint32_t x216;
  fiat_p384_uint1 x217;
  uint32_t x218;
  fiat_p384_uint1 x219;
  uint32_t x220;
  fiat_p384_uint1 x221;
  uint32_t x222;
  fiat_p384_uint1 x223;
  uint32_t x224;
  fiat_p384_uint1 x225;
  uint32_t x226;
  fiat_p384_uint1 x227;
  uint32_t x228;
  fiat_p384_uint1 x229;
  uint32_t x230;
  fiat_p384_uint1 x231;
  uint32_t x232;
  fiat_p384_uint1 x233;
  uint32_t x234;
  uint32_t x235;
  uint32_t x236;
  uint32_t x237;
  uint32_t x238;
  uint32_t x239;
  uint32_t x240;
  uint32_t x241;
  uint32_t x242;
  uint32_t x243;
  uint32_t x244;
  uint32_t x245;
  uint32_t x246;
  fiat_p384_uint1 x247;
  uint32_t x248;
  fiat_p384_uint1 x249;
  uint32_t x250;
  fiat_p384_uint1 x251;
  uint32_t x252;
  fiat_p384_uint1 x253;
  uint32_t x254;
  fiat_p384_uint1 x255;
  uint32_t x256;
  fiat_p384_uint1 x257;
  uint32_t x258;
  fiat_p384_uint1 x259;
  uint32_t x260;
  fiat_p384_uint1 x261;
  uint32_t x262;
  fiat_p384_uint1 x263;
  uint32_t x264;
  fiat_p384_uint1 x265;
  uint32_t x266;
  fiat_p384_uint1 x267;
  uint32_t x268;
  fiat_p384_uint1 x269;
  uint32_t x270;
  fiat_p384_uint1 x271;
  uint32_t x272;
  fiat_p384_uint1 x273;
  uint32_t x274;
  fiat_p384_uint1 x275;
  uint32_t x276;
  fiat_p384_uint1 x277;
  uint32_t x278;
  fiat_p384_uint1 x279;
  uint32_t x280;
  fiat_p384_uint1 x281;
  uint32_t x282;
  fiat_p384_uint1 x283;
  uint32_t x284;
  fiat_p384_uint1 x285;
  uint32_t x286;
  fiat_p384_uint1 x287;
  uint32_t x288;
  fiat_p384_uint1 x289;
  uint32_t x290;
  fiat_p384_uint1 x291;
  uint32_t x292;
  fiat_p384_uint1 x293;
  uint32_t x294;
  fiat_p384_uint1 x295;
  uint32_t x296;
  fiat_p384_uint1 x297;
  uint32_t x298;
  uint32_t x299;
  uint32_t x300;
  uint32_t x301;
  uint32_t x302;
  uint32_t x303;
  uint32_t x304;
  uint32_t x305;
  uint32_t x306;
  uint32_t x307;
  uint32_t x308;
  uint32_t x309;
  uint32_t x310;
  uint32_t x311;
  uint32_t x312;
  uint32_t x313;
  uint32_t x314;
  uint32_t x315;
  uint32_t x316;
  uint32_t x317;
  uint32_t x318;
  uint32_t x319;
  uint32_t x320;
  uint32_t x321;
  uint32_t x322;
  uint32_t x323;
  uint32_t x324;
  uint32_t x325;
  uint32_t x326;
  uint32_t x327;
  uint32_t x328;
  uint32_t x329;
  uint32_t x330;
  uint32_t x331;
  uint32_t x332;
  uint32_t x333;
  uint32_t x334;
  fiat_p384_addcarryx_u32(&x1, &x2, 0x0, (~arg1), 0x1);
  x3 = (fiat_p384_uint1)((fiat_p384_uint1)(x1 >> 31) & (fiat_p384_uint1)((arg3[0]) & 0x1));
  fiat_p384_addcarryx_u32(&x4, &x5, 0x0, (~arg1), 0x1);
  fiat_p384_cmovznz_u32(&x6, x3, arg1, x4);
  fiat_p384_cmovznz_u32(&x7, x3, (arg2[0]), (arg3[0]));
  fiat_p384_cmovznz_u32(&x8, x3, (arg2[1]), (arg3[1]));
  fiat_p384_cmovznz_u32(&x9, x3, (arg2[2]), (arg3[2]));
  fiat_p384_cmovznz_u32(&x10, x3, (arg2[3]), (arg3[3]));
  fiat_p384_cmovznz_u32(&x11, x3, (arg2[4]), (arg3[4]));
  fiat_p384_cmovznz_u32(&x12, x3, (arg2[5]), (arg3[5]));
  fiat_p384_cmovznz_u32(&x13, x3, (arg2[6]), (arg3[6]));
  fiat_p384_cmovznz_u32(&x14, x3, (arg2[7]), (arg3[7]));
  fiat_p384_cmovznz_u32(&x15, x3, (arg2[8]), (arg3[8]));
  fiat_p384_cmovznz_u32(&x16, x3, (arg2[9]), (arg3[9]));
  fiat_p384_cmovznz_u32(&x17, x3, (arg2[10]), (arg3[10]));
  fiat_p384_cmovznz_u32(&x18, x3, (arg2[11]), (arg3[11]));
  fiat_p384_cmovznz_u32(&x19, x3, (arg2[12]), (arg3[12]));
  fiat_p384_addcarryx_u32(&x20, &x21, 0x0, 0x1, (~(arg2[0])));
  fiat_p384_addcarryx_u32(&x22, &x23, x21, 0x0, (~(arg2[1])));
  fiat_p384_addcarryx_u32(&x24, &x25, x23, 0x0, (~(arg2[2])));
  fiat_p384_addcarryx_u32(&x26, &x27, x25, 0x0, (~(arg2[3])));
  fiat_p384_addcarryx_u32(&x28, &x29, x27, 0x0, (~(arg2[4])));
  fiat_p384_addcarryx_u32(&x30, &x31, x29, 0x0, (~(arg2[5])));
  fiat_p384_addcarryx_u32(&x32, &x33, x31, 0x0, (~(arg2[6])));
  fiat_p384_addcarryx_u32(&x34, &x35, x33, 0x0, (~(arg2[7])));
  fiat_p384_addcarryx_u32(&x36, &x37, x35, 0x0, (~(arg2[8])));
  fiat_p384_addcarryx_u32(&x38, &x39, x37, 0x0, (~(arg2[9])));
  fiat_p384_addcarryx_u32(&x40, &x41, x39, 0x0, (~(arg2[10])));
  fiat_p384_addcarryx_u32(&x42, &x43, x41, 0x0, (~(arg2[11])));
  fiat_p384_addcarryx_u32(&x44, &x45, x43, 0x0, (~(arg2[12])));
  fiat_p384_cmovznz_u32(&x46, x3, (arg3[0]), x20);
  fiat_p384_cmovznz_u32(&x47, x3, (arg3[1]), x22);
  fiat_p384_cmovznz_u32(&x48, x3, (arg3[2]), x24);
  fiat_p384_cmovznz_u32(&x49, x3, (arg3[3]), x26);
  fiat_p384_cmovznz_u32(&x50, x3, (arg3[4]), x28);
  fiat_p384_cmovznz_u32(&x51, x3, (arg3[5]), x30);
  fiat_p384_cmovznz_u32(&x52, x3, (arg3[6]), x32);
  fiat_p384_cmovznz_u32(&x53, x3, (arg3[7]), x34);
  fiat_p384_cmovznz_u32(&x54, x3, (arg3[8]), x36);
  fiat_p384_cmovznz_u32(&x55, x3, (arg3[9]), x38);
  fiat_p384_cmovznz_u32(&x56, x3, (arg3[10]), x40);
  fiat_p384_cmovznz_u32(&x57, x3, (arg3[11]), x42);
  fiat_p384_cmovznz_u32(&x58, x3, (arg3[12]), x44);
  fiat_p384_cmovznz_u32(&x59, x3, (arg4[0]), (arg5[0]));
  fiat_p384_cmovznz_u32(&x60, x3, (arg4[1]), (arg5[1]));
  fiat_p384_cmovznz_u32(&x61, x3, (arg4[2]), (arg5[2]));
  fiat_p384_cmovznz_u32(&x62, x3, (arg4[3]), (arg5[3]));
  fiat_p384_cmovznz_u32(&x63, x3, (arg4[4]), (arg5[4]));
  fiat_p384_cmovznz_u32(&x64, x3, (arg4[5]), (arg5[5]));
  fiat_p384_cmovznz_u32(&x65, x3, (arg4[6]), (arg5[6]));
  fiat_p384_cmovznz_u32(&x66, x3, (arg4[7]), (arg5[7]));
  fiat_p384_cmovznz_u32(&x67, x3, (arg4[8]), (arg5[8]));
  fiat_p384_cmovznz_u32(&x68, x3, (arg4[9]), (arg5[9]));
  fiat_p384_cmovznz_u32(&x69, x3, (arg4[10]), (arg5[10]));
  fiat_p384_cmovznz_u32(&x70, x3, (arg4[11]), (arg5[11]));
  fiat_p384_addcarryx_u32(&x71, &x72, 0x0, x59, x59);
  fiat_p384_addcarryx_u32(&x73, &x74, x72, x60, x60);
  fiat_p384_addcarryx_u32(&x75, &x76, x74, x61, x61);
  fiat_p384_addcarryx_u32(&x77, &x78, x76, x62, x62);
  fiat_p384_addcarryx_u32(&x79, &x80, x78, x63, x63);
  fiat_p384_addcarryx_u32(&x81, &x82, x80, x64, x64);
  fiat_p384_addcarryx_u32(&x83, &x84, x82, x65, x65);
  fiat_p384_addcarryx_u32(&x85, &x86, x84, x66, x66);
  fiat_p384_addcarryx_u32(&x87, &x88, x86, x67, x67);
  fiat_p384_addcarryx_u32(&x89, &x90, x88, x68, x68);
  fiat_p384_addcarryx_u32(&x91, &x92, x90, x69, x69);
  fiat_p384_addcarryx_u32(&x93, &x94, x92, x70, x70);
  fiat_p384_subborrowx_u32(&x95, &x96, 0x0, x71, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x97, &x98, x96, x73, 0x0);
  fiat_p384_subborrowx_u32(&x99, &x100, x98, x75, 0x0);
  fiat_p384_subborrowx_u32(&x101, &x102, x100, x77, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x103, &x104, x102, x79, UINT32_C(0xfffffffe));
  fiat_p384_subborrowx_u32(&x105, &x106, x104, x81, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x107, &x108, x106, x83, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x109, &x110, x108, x85, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x111, &x112, x110, x87, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x113, &x114, x112, x89, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x115, &x116, x114, x91, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x117, &x118, x116, x93, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x119, &x120, x118, x94, 0x0);
  x121 = (arg4[11]);
  x122 = (arg4[10]);
  x123 = (arg4[9]);
  x124 = (arg4[8]);
  x125 = (arg4[7]);
  x126 = (arg4[6]);
  x127 = (arg4[5]);
  x128 = (arg4[4]);
  x129 = (arg4[3]);
  x130 = (arg4[2]);
  x131 = (arg4[1]);
  x132 = (arg4[0]);
  fiat_p384_subborrowx_u32(&x133, &x134, 0x0, 0x0, x132);
  fiat_p384_subborrowx_u32(&x135, &x136, x134, 0x0, x131);
  fiat_p384_subborrowx_u32(&x137, &x138, x136, 0x0, x130);
  fiat_p384_subborrowx_u32(&x139, &x140, x138, 0x0, x129);
  fiat_p384_subborrowx_u32(&x141, &x142, x140, 0x0, x128);
  fiat_p384_subborrowx_u32(&x143, &x144, x142, 0x0, x127);
  fiat_p384_subborrowx_u32(&x145, &x146, x144, 0x0, x126);
  fiat_p384_subborrowx_u32(&x147, &x148, x146, 0x0, x125);
  fiat_p384_subborrowx_u32(&x149, &x150, x148, 0x0, x124);
  fiat_p384_subborrowx_u32(&x151, &x152, x150, 0x0, x123);
  fiat_p384_subborrowx_u32(&x153, &x154, x152, 0x0, x122);
  fiat_p384_subborrowx_u32(&x155, &x156, x154, 0x0, x121);
  fiat_p384_cmovznz_u32(&x157, x156, 0x0, UINT32_C(0xffffffff));
  fiat_p384_addcarryx_u32(&x158, &x159, 0x0, x133, x157);
  fiat_p384_addcarryx_u32(&x160, &x161, x159, x135, 0x0);
  fiat_p384_addcarryx_u32(&x162, &x163, x161, x137, 0x0);
  fiat_p384_addcarryx_u32(&x164, &x165, x163, x139, x157);
  fiat_p384_addcarryx_u32(&x166, &x167, x165, x141, (x157 & UINT32_C(0xfffffffe)));
  fiat_p384_addcarryx_u32(&x168, &x169, x167, x143, x157);
  fiat_p384_addcarryx_u32(&x170, &x171, x169, x145, x157);
  fiat_p384_addcarryx_u32(&x172, &x173, x171, x147, x157);
  fiat_p384_addcarryx_u32(&x174, &x175, x173, x149, x157);
  fiat_p384_addcarryx_u32(&x176, &x177, x175, x151, x157);
  fiat_p384_addcarryx_u32(&x178, &x179, x177, x153, x157);
  fiat_p384_addcarryx_u32(&x180, &x181, x179, x155, x157);
  fiat_p384_cmovznz_u32(&x182, x3, (arg5[0]), x158);
  fiat_p384_cmovznz_u32(&x183, x3, (arg5[1]), x160);
  fiat_p384_cmovznz_u32(&x184, x3, (arg5[2]), x162);
  fiat_p384_cmovznz_u32(&x185, x3, (arg5[3]), x164);
  fiat_p384_cmovznz_u32(&x186, x3, (arg5[4]), x166);
  fiat_p384_cmovznz_u32(&x187, x3, (arg5[5]), x168);
  fiat_p384_cmovznz_u32(&x188, x3, (arg5[6]), x170);
  fiat_p384_cmovznz_u32(&x189, x3, (arg5[7]), x172);
  fiat_p384_cmovznz_u32(&x190, x3, (arg5[8]), x174);
  fiat_p384_cmovznz_u32(&x191, x3, (arg5[9]), x176);
  fiat_p384_cmovznz_u32(&x192, x3, (arg5[10]), x178);
  fiat_p384_cmovznz_u32(&x193, x3, (arg5[11]), x180);
  x194 = (fiat_p384_uint1)(x46 & 0x1);
  fiat_p384_cmovznz_u32(&x195, x194, 0x0, x7);
  fiat_p384_cmovznz_u32(&x196, x194, 0x0, x8);
  fiat_p384_cmovznz_u32(&x197, x194, 0x0, x9);
  fiat_p384_cmovznz_u32(&x198, x194, 0x0, x10);
  fiat_p384_cmovznz_u32(&x199, x194, 0x0, x11);
  fiat_p384_cmovznz_u32(&x200, x194, 0x0, x12);
  fiat_p384_cmovznz_u32(&x201, x194, 0x0, x13);
  fiat_p384_cmovznz_u32(&x202, x194, 0x0, x14);
  fiat_p384_cmovznz_u32(&x203, x194, 0x0, x15);
  fiat_p384_cmovznz_u32(&x204, x194, 0x0, x16);
  fiat_p384_cmovznz_u32(&x205, x194, 0x0, x17);
  fiat_p384_cmovznz_u32(&x206, x194, 0x0, x18);
  fiat_p384_cmovznz_u32(&x207, x194, 0x0, x19);
  fiat_p384_addcarryx_u32(&x208, &x209, 0x0, x46, x195);
  fiat_p384_addcarryx_u32(&x210, &x211, x209, x47, x196);
  fiat_p384_addcarryx_u32(&x212, &x213, x211, x48, x197);
  fiat_p384_addcarryx_u32(&x214, &x215, x213, x49, x198);
  fiat_p384_addcarryx_u32(&x216, &x217, x215, x50, x199);
  fiat_p384_addcarryx_u32(&x218, &x219, x217, x51, x200);
  fiat_p384_addcarryx_u32(&x220, &x221, x219, x52, x201);
  fiat_p384_addcarryx_u32(&x222, &x223, x221, x53, x202);
  fiat_p384_addcarryx_u32(&x224, &x225, x223, x54, x203);
  fiat_p384_addcarryx_u32(&x226, &x227, x225, x55, x204);
  fiat_p384_addcarryx_u32(&x228, &x229, x227, x56, x205);
  fiat_p384_addcarryx_u32(&x230, &x231, x229, x57, x206);
  fiat_p384_addcarryx_u32(&x232, &x233, x231, x58, x207);
  fiat_p384_cmovznz_u32(&x234, x194, 0x0, x59);
  fiat_p384_cmovznz_u32(&x235, x194, 0x0, x60);
  fiat_p384_cmovznz_u32(&x236, x194, 0x0, x61);
  fiat_p384_cmovznz_u32(&x237, x194, 0x0, x62);
  fiat_p384_cmovznz_u32(&x238, x194, 0x0, x63);
  fiat_p384_cmovznz_u32(&x239, x194, 0x0, x64);
  fiat_p384_cmovznz_u32(&x240, x194, 0x0, x65);
  fiat_p384_cmovznz_u32(&x241, x194, 0x0, x66);
  fiat_p384_cmovznz_u32(&x242, x194, 0x0, x67);
  fiat_p384_cmovznz_u32(&x243, x194, 0x0, x68);
  fiat_p384_cmovznz_u32(&x244, x194, 0x0, x69);
  fiat_p384_cmovznz_u32(&x245, x194, 0x0, x70);
  fiat_p384_addcarryx_u32(&x246, &x247, 0x0, x182, x234);
  fiat_p384_addcarryx_u32(&x248, &x249, x247, x183, x235);
  fiat_p384_addcarryx_u32(&x250, &x251, x249, x184, x236);
  fiat_p384_addcarryx_u32(&x252, &x253, x251, x185, x237);
  fiat_p384_addcarryx_u32(&x254, &x255, x253, x186, x238);
  fiat_p384_addcarryx_u32(&x256, &x257, x255, x187, x239);
  fiat_p384_addcarryx_u32(&x258, &x259, x257, x188, x240);
  fiat_p384_addcarryx_u32(&x260, &x261, x259, x189, x241);
  fiat_p384_addcarryx_u32(&x262, &x263, x261, x190, x242);
  fiat_p384_addcarryx_u32(&x264, &x265, x263, x191, x243);
  fiat_p384_addcarryx_u32(&x266, &x267, x265, x192, x244);
  fiat_p384_addcarryx_u32(&x268, &x269, x267, x193, x245);
  fiat_p384_subborrowx_u32(&x270, &x271, 0x0, x246, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x272, &x273, x271, x248, 0x0);
  fiat_p384_subborrowx_u32(&x274, &x275, x273, x250, 0x0);
  fiat_p384_subborrowx_u32(&x276, &x277, x275, x252, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x278, &x279, x277, x254, UINT32_C(0xfffffffe));
  fiat_p384_subborrowx_u32(&x280, &x281, x279, x256, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x282, &x283, x281, x258, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x284, &x285, x283, x260, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x286, &x287, x285, x262, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x288, &x289, x287, x264, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x290, &x291, x289, x266, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x292, &x293, x291, x268, UINT32_C(0xffffffff));
  fiat_p384_subborrowx_u32(&x294, &x295, x293, x269, 0x0);
  fiat_p384_addcarryx_u32(&x296, &x297, 0x0, x6, 0x1);
  x298 = ((x208 >> 1) | ((x210 << 31) & UINT32_C(0xffffffff)));
  x299 = ((x210 >> 1) | ((x212 << 31) & UINT32_C(0xffffffff)));
  x300 = ((x212 >> 1) | ((x214 << 31) & UINT32_C(0xffffffff)));
  x301 = ((x214 >> 1) | ((x216 << 31) & UINT32_C(0xffffffff)));
  x302 = ((x216 >> 1) | ((x218 << 31) & UINT32_C(0xffffffff)));
  x303 = ((x218 >> 1) | ((x220 << 31) & UINT32_C(0xffffffff)));
  x304 = ((x220 >> 1) | ((x222 << 31) & UINT32_C(0xffffffff)));
  x305 = ((x222 >> 1) | ((x224 << 31) & UINT32_C(0xffffffff)));
  x306 = ((x224 >> 1) | ((x226 << 31) & UINT32_C(0xffffffff)));
  x307 = ((x226 >> 1) | ((x228 << 31) & UINT32_C(0xffffffff)));
  x308 = ((x228 >> 1) | ((x230 << 31) & UINT32_C(0xffffffff)));
  x309 = ((x230 >> 1) | ((x232 << 31) & UINT32_C(0xffffffff)));
  x310 = ((x232 & UINT32_C(0x80000000)) | (x232 >> 1));
  fiat_p384_cmovznz_u32(&x311, x120, x95, x71);
  fiat_p384_cmovznz_u32(&x312, x120, x97, x73);
  fiat_p384_cmovznz_u32(&x313, x120, x99, x75);
  fiat_p384_cmovznz_u32(&x314, x120, x101, x77);
  fiat_p384_cmovznz_u32(&x315, x120, x103, x79);
  fiat_p384_cmovznz_u32(&x316, x120, x105, x81);
  fiat_p384_cmovznz_u32(&x317, x120, x107, x83);
  fiat_p384_cmovznz_u32(&x318, x120, x109, x85);
  fiat_p384_cmovznz_u32(&x319, x120, x111, x87);
  fiat_p384_cmovznz_u32(&x320, x120, x113, x89);
  fiat_p384_cmovznz_u32(&x321, x120, x115, x91);
  fiat_p384_cmovznz_u32(&x322, x120, x117, x93);
  fiat_p384_cmovznz_u32(&x323, x295, x270, x246);
  fiat_p384_cmovznz_u32(&x324, x295, x272, x248);
  fiat_p384_cmovznz_u32(&x325, x295, x274, x250);
  fiat_p384_cmovznz_u32(&x326, x295, x276, x252);
  fiat_p384_cmovznz_u32(&x327, x295, x278, x254);
  fiat_p384_cmovznz_u32(&x328, x295, x280, x256);
  fiat_p384_cmovznz_u32(&x329, x295, x282, x258);
  fiat_p384_cmovznz_u32(&x330, x295, x284, x260);
  fiat_p384_cmovznz_u32(&x331, x295, x286, x262);
  fiat_p384_cmovznz_u32(&x332, x295, x288, x264);
  fiat_p384_cmovznz_u32(&x333, x295, x290, x266);
  fiat_p384_cmovznz_u32(&x334, x295, x292, x268);
  *out1 = x296;
  out2[0] = x7;
  out2[1] = x8;
  out2[2] = x9;
  out2[3] = x10;
  out2[4] = x11;
  out2[5] = x12;
  out2[6] = x13;
  out2[7] = x14;
  out2[8] = x15;
  out2[9] = x16;
  out2[10] = x17;
  out2[11] = x18;
  out2[12] = x19;
  out3[0] = x298;
  out3[1] = x299;
  out3[2] = x300;
  out3[3] = x301;
  out3[4] = x302;
  out3[5] = x303;
  out3[6] = x304;
  out3[7] = x305;
  out3[8] = x306;
  out3[9] = x307;
  out3[10] = x308;
  out3[11] = x309;
  out3[12] = x310;
  out4[0] = x311;
  out4[1] = x312;
  out4[2] = x313;
  out4[3] = x314;
  out4[4] = x315;
  out4[5] = x316;
  out4[6] = x317;
  out4[7] = x318;
  out4[8] = x319;
  out4[9] = x320;
  out4[10] = x321;
  out4[11] = x322;
  out5[0] = x323;
  out5[1] = x324;
  out5[2] = x325;
  out5[3] = x326;
  out5[4] = x327;
  out5[5] = x328;
  out5[6] = x329;
  out5[7] = x330;
  out5[8] = x331;
  out5[9] = x332;
  out5[10] = x333;
  out5[11] = x334;
}
