/* SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only */
/* Copyright (c) 2025 Brett A C Sheffield <bacs@librecast.net> */

/* call lc_channel_recv() without channel bound to socket */

#include "test.h"
#include <librecast/net.h>
#include <unistd.h>

static int test_channel_bound(void)
{
	char buf[BUFSIZ];
	lc_ctx_t *lctx;
	lc_socket_t *sock;
	lc_channel_t *chan;
	ssize_t byt;

	lctx = lc_ctx_new();
	if (!(test_assert(lctx != NULL, "lc_ctx_new()"))) _exit(EXIT_FAILURE);
	sock = lc_socket_new(lctx);
	if (!(test_assert(sock != NULL, "lc_socket_new()"))) goto free_lctx;
	chan = lc_channel_new(lctx, "0000-0090");
	if (!(test_assert(chan != NULL, "lc_channel_new()"))) goto free_lctx;

	byt = lc_channel_recv(chan, buf, sizeof buf, 0);
	test_assert(errno == ENOTSOCK, "ENOTSOCK");
	test_assert(byt == -1, "lc_channel_recv() returned %zi", byt);

	struct msghdr msg = {0};
	byt = lc_channel_recvmsg(chan, &msg, 0);
	test_assert(errno == ENOTSOCK, "ENOTSOCK");
	test_assert(byt == -1, "lc_channel_recvmsg() returned %zi", byt);

free_lctx:
	lc_ctx_free(lctx);
	return test_status;
}

int main(void)
{
	char name[] = "lc_channel_recv(): channel MUST be bound";

	test_name(name);

	test_channel_bound();

	return test_status;
}
