/*
 * Contributed by Stephane Eranian <eranian@gmail.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * This file is part of libpfm, a performance monitoring support library for
 * applications on Linux.
 *
 * PMU: icx_unc_m2pcie (IcelakeX Uncore M2PCIE)
 * Based on Intel JSON event table version   : 1.21
 * Based on Intel JSON event table published : 06/06/2023
 */
static const intel_x86_umask_t icx_unc_m2p_ag0_ad_crd_occupancy0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_ag0_ad_crd_occupancy1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_ag0_bl_crd_occupancy0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_ag0_bl_crd_occupancy1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_ag1_ad_crd_occupancy0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_ag1_ad_crd_occupancy1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_ag1_bl_crd_acquired0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_ag1_bl_crd_occupancy1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_distress_asserted[]={
  { .uname   = "DPT_LOCAL",
    .udesc   = "DPT Local (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DPT_NONLOCAL",
    .udesc   = "DPT Remote (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DPT_STALL_IV",
    .udesc   = "DPT Stalled - IV (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DPT_STALL_NOCRD",
    .udesc   = "DPT Stalled -  No Credit (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "HORZ",
    .udesc   = "Horizontal (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PMM_LOCAL",
    .udesc   = "PMM Local (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PMM_NONLOCAL",
    .udesc   = "PMM Remote (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "VERT",
    .udesc   = "Vertical (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_egress_ordering[]={
  { .uname   = "IV_SNOOPGO_DN",
    .udesc   = "Down (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_SNOOPGO_UP",
    .udesc   = "Up (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_horz_ring_akc_in_use[]={
  { .uname   = "LEFT_EVEN",
    .udesc   = "Left and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LEFT_ODD",
    .udesc   = "Left and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT_EVEN",
    .udesc   = "Right and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT_ODD",
    .udesc   = "Right and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_horz_ring_bl_in_use[]={
  { .uname   = "LEFT_EVEN",
    .udesc   = "Left and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LEFT_ODD",
    .udesc   = "Left and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT_EVEN",
    .udesc   = "Right and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT_ODD",
    .udesc   = "Right and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_horz_ring_iv_in_use[]={
  { .uname   = "LEFT",
    .udesc   = "Left (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "RIGHT",
    .udesc   = "Right (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_iio_credits_acquired[]={
  { .uname   = "DRS_0",
    .udesc   = "DRS (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DRS_1",
    .udesc   = "DRS (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NCB_0",
    .udesc   = "NCB (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NCB_1",
    .udesc   = "NCB (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NCS_0",
    .udesc   = "NCS (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NCS_1",
    .udesc   = "NCS (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_iio_credits_reject[]={
  { .uname   = "DRS",
    .udesc   = "DRS (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NCB",
    .udesc   = "NCB (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NCS",
    .udesc   = "NCS (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_iio_credits_used[]={
  { .uname   = "DRS_0",
    .udesc   = "DRS to CMS Port 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DRS_1",
    .udesc   = "DRS to CMS Port 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NCB_0",
    .udesc   = "NCB to CMS Port 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NCB_1",
    .udesc   = "NCB to CMS Port 1 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NCS_0",
    .udesc   = "NCS to CMS Port 0 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "NCS_1",
    .udesc   = "NCS to CMS Port 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_local_p2p_ded_returned_0[]={
  { .uname   = "MS2IOSF0_NCB",
    .udesc   = "M2IOSF0 - NCB (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MS2IOSF0_NCS",
    .udesc   = "M2IOSF0 - NCS (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MS2IOSF1_NCB",
    .udesc   = "M2IOSF1 - NCB (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MS2IOSF1_NCS",
    .udesc   = "M2IOSF1 - NCS (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MS2IOSF2_NCB",
    .udesc   = "M2IOSF2 - NCB (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MS2IOSF2_NCS",
    .udesc   = "M2IOSF2 - NCS (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MS2IOSF3_NCB",
    .udesc   = "M2IOSF3 - NCB (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MS2IOSF3_NCS",
    .udesc   = "M2IOSF3 - NCS (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_local_p2p_ded_returned_1[]={
  { .uname   = "MS2IOSF4_NCB",
    .udesc   = "M2IOSF4 - NCB (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MS2IOSF4_NCS",
    .udesc   = "M2IOSF4 - NCS (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MS2IOSF5_NCB",
    .udesc   = "M2IOSF5 - NCB (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MS2IOSF5_NCS",
    .udesc   = "M2IOSF5 - NCS (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_local_shar_p2p_crd_returned[]={
  { .uname   = "AGENT_0",
    .udesc   = "Agent0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AGENT_1",
    .udesc   = "Agent1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AGENT_2",
    .udesc   = "Agent2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AGENT_3",
    .udesc   = "Agent3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AGENT_4",
    .udesc   = "Agent4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AGENT_5",
    .udesc   = "Agent5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_local_shar_p2p_crd_taken_0[]={
  { .uname   = "M2IOSF0_NCB",
    .udesc   = "M2IOSF0 - NCB (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF0_NCS",
    .udesc   = "M2IOSF0 - NCS (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF1_NCB",
    .udesc   = "M2IOSF1 - NCB (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF1_NCS",
    .udesc   = "M2IOSF1 - NCS (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF2_NCB",
    .udesc   = "M2IOSF2 - NCB (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF2_NCS",
    .udesc   = "M2IOSF2 - NCS (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF3_NCB",
    .udesc   = "M2IOSF3 - NCB (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF3_NCS",
    .udesc   = "M2IOSF3 - NCS (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_local_shar_p2p_crd_taken_1[]={
  { .uname   = "M2IOSF4_NCB",
    .udesc   = "M2IOSF4 - NCB (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF4_NCS",
    .udesc   = "M2IOSF4 - NCS (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF5_NCB",
    .udesc   = "M2IOSF5 - NCB (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF5_NCS",
    .udesc   = "M2IOSF5 - NCS (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_local_shar_p2p_crd_wait_0[]={
  { .uname   = "M2IOSF0_NCB",
    .udesc   = "M2IOSF0 - NCB (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF0_NCS",
    .udesc   = "M2IOSF0 - NCS (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF1_NCB",
    .udesc   = "M2IOSF1 - NCB (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF1_NCS",
    .udesc   = "M2IOSF1 - NCS (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF2_NCB",
    .udesc   = "M2IOSF2 - NCB (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF2_NCS",
    .udesc   = "M2IOSF2 - NCS (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF3_NCB",
    .udesc   = "M2IOSF3 - NCB (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF3_NCS",
    .udesc   = "M2IOSF3 - NCS (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_local_shar_p2p_crd_wait_1[]={
  { .uname   = "M2IOSF4_NCB",
    .udesc   = "M2IOSF4 - NCB (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF4_NCS",
    .udesc   = "M2IOSF4 - NCS (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF5_NCB",
    .udesc   = "M2IOSF5 - NCB (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "M2IOSF5_NCS",
    .udesc   = "M2IOSF5 - NCS (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_misc_external[]={
  { .uname   = "MBE_INST0",
    .udesc   = "Number of cycles MBE is high for MS2IDI0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "MBE_INST1",
    .udesc   = "Number of cycles MBE is high for MS2IDI1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_p2p_crd_occupancy[]={
  { .uname   = "ALL",
    .udesc   = "All (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "LOCAL_NCB",
    .udesc   = "Local NCB (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_NCS",
    .udesc   = "Local NCS (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_NCB",
    .udesc   = "Remote NCB (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_NCS",
    .udesc   = "Remote NCS (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_p2p_shar_received[]={
  { .uname   = "ALL",
    .udesc   = "All (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "LOCAL_NCB",
    .udesc   = "Local NCB (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "LOCAL_NCS",
    .udesc   = "Local NCS (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_NCB",
    .udesc   = "Remote NCB (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "REMOTE_NCS",
    .udesc   = "Remote NCS (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_remote_p2p_ded_returned[]={
  { .uname   = "UPI0_NCB",
    .udesc   = "UPI0 - NCB (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI0_NCS",
    .udesc   = "UPI0 - NCS (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI1_NCB",
    .udesc   = "UPI1 - NCB (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI1_NCS",
    .udesc   = "UPI1 - NCS (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI2_NCB",
    .udesc   = "UPI2 - NCB (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI2_NCS",
    .udesc   = "UPI2 - NCS (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_remote_p2p_shar_returned[]={
  { .uname   = "AGENT_0",
    .udesc   = "Agent0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AGENT_1",
    .udesc   = "Agent1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AGENT_2",
    .udesc   = "Agent2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_remote_shar_p2p_crd_returned[]={
  { .uname   = "AGENT_0",
    .udesc   = "Agent0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AGENT_1",
    .udesc   = "Agent1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AGENT_2",
    .udesc   = "Agent2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_remote_shar_p2p_crd_taken_0[]={
  { .uname   = "UPI0_DRS",
    .udesc   = "UPI0 - DRS (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI0_NCB",
    .udesc   = "UPI0 - NCB (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI0_NCS",
    .udesc   = "UPI0 - NCS (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI1_DRS",
    .udesc   = "UPI1 - DRS (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI1_NCB",
    .udesc   = "UPI1 - NCB (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI1_NCS",
    .udesc   = "UPI1 - NCS (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_remote_shar_p2p_crd_taken_1[]={
  { .uname   = "UPI2_DRS",
    .udesc   = "UPI2 - DRS (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI2_NCB",
    .udesc   = "UPI2 - NCB (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI2_NCS",
    .udesc   = "UPI2 - NCS (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_remote_shar_p2p_crd_wait_0[]={
  { .uname   = "UPI0_DRS",
    .udesc   = "UPI0 - DRS (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI0_NCB",
    .udesc   = "UPI0 - NCB (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI0_NCS",
    .udesc   = "UPI0 - NCS (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI1_DRS",
    .udesc   = "UPI1 - DRS (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI1_NCB",
    .udesc   = "UPI1 - NCB (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI1_NCS",
    .udesc   = "UPI1 - NCS (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_remote_shar_p2p_crd_wait_1[]={
  { .uname   = "UPI2_DRS",
    .udesc   = "UPI2 - DRS (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI2_NCB",
    .udesc   = "UPI2 - NCB (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI2_NCS",
    .udesc   = "UPI2 - NCS (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_ring_bounces_horz[]={
  { .uname   = "AD",
    .udesc   = "AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL",
    .udesc   = "BL (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_ring_sink_starved_horz[]={
  { .uname   = "AD",
    .udesc   = "AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "Acknowledgements to Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL",
    .udesc   = "BL (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_ring_sink_starved_vert[]={
  { .uname   = "AD",
    .udesc   = "AD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "Acknowledgements to core (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL",
    .udesc   = "Data Responses to core (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "Snoops of processor's cache. (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_rxc_inserts[]={
  { .uname   = "ALL",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO | INTEL_X86_DFL,
  },
  { .uname   = "CHA_IDI",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CHA_NCB",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "CHA_NCS",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IIO_NCB",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IIO_NCS",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI_NCB",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UPI_NCS",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_rxr_crd_starved[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IFV",
    .udesc   = "IFV - Credited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_rxr_inserts[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_rxr_occupancy[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_stall0_no_txr_horz_crd_ad_ag0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_stall0_no_txr_horz_crd_bl_ag0[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_stall0_no_txr_horz_crd_bl_ag1[]={
  { .uname   = "TGR0",
    .udesc   = "For Transgress 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR1",
    .udesc   = "For Transgress 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR2",
    .udesc   = "For Transgress 2 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR3",
    .udesc   = "For Transgress 3 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR4",
    .udesc   = "For Transgress 4 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR5",
    .udesc   = "For Transgress 5 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR6",
    .udesc   = "For Transgress 6 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR7",
    .udesc   = "For Transgress 7 (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_stall1_no_txr_horz_crd_ad_ag1_1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_stall1_no_txr_horz_crd_bl_ag1_1[]={
  { .uname   = "TGR10",
    .udesc   = "For Transgress 10 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR8",
    .udesc   = "For Transgress 8 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGR9",
    .udesc   = "For Transgress 9 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_txc_credits[]={
  { .uname   = "PMM",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PRQ",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_txc_cycles_full[]={
  { .uname   = "AD_0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PMM_BLOCK_0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PMM_BLOCK_1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_txc_cycles_ne[]={
  { .uname   = "AD_0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PMM_DISTRESS_0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "PMM_DISTRESS_1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_txc_inserts[]={
  { .uname   = "AD_0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_CRD_0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_CRD_1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_0",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_1",
    .udesc   = "TBD (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_txr_horz_ads_used[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_txr_horz_cycles_full[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_txr_horz_inserts[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_txr_horz_occupancy[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x1100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_CRD",
    .udesc   = "AD - Credited (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x4400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_CRD",
    .udesc   = "BL - Credited (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_txr_horz_starved[]={
  { .uname   = "AD_ALL",
    .udesc   = "AD - All (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_UNCRD",
    .udesc   = "AD - Uncredited (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK",
    .udesc   = "AK (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_UNCRD",
    .udesc   = "AKC - Uncredited (experimental)",
    .ucode   = 0x8000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_ALL",
    .udesc   = "BL - All (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_UNCRD",
    .udesc   = "BL - Uncredited (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_txr_vert_ads_used[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_txr_vert_bypass[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG0",
    .udesc   = "AK - Agent 0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "AK - Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_AG1",
    .udesc   = "IV - Agent 1 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_txr_vert_cycles_full1[]={
  { .uname   = "AKC_AG0",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_AG1",
    .udesc   = "AKC - Agent 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_txr_vert_cycles_ne0[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG0",
    .udesc   = "AK - Agent 0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "AK - Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_AG0",
    .udesc   = "IV - Agent 0 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_txr_vert_inserts1[]={
  { .uname   = "AKC_AG0",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_AG1",
    .udesc   = "AKC - Agent 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_txr_vert_occupancy0[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG0",
    .udesc   = "AK - Agent 0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "AK - Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_AG0",
    .udesc   = "IV - Agent 0 (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_txr_vert_occupancy1[]={
  { .uname   = "AKC_AG0",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_AG1",
    .udesc   = "AKC - Agent 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_txr_vert_starved0[]={
  { .uname   = "AD_AG0",
    .udesc   = "AD - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AD_AG1",
    .udesc   = "AD - Agent 1 (experimental)",
    .ucode   = 0x1000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG0",
    .udesc   = "AK - Agent 0 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AK_AG1",
    .udesc   = "AK - Agent 1 (experimental)",
    .ucode   = 0x2000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG0",
    .udesc   = "BL - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "BL_AG1",
    .udesc   = "BL - Agent 1 (experimental)",
    .ucode   = 0x4000ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "IV_AG0",
    .udesc   = "IV (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_txr_vert_starved1[]={
  { .uname   = "AKC_AG0",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "AKC_AG1",
    .udesc   = "AKC - Agent 1 (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "TGC",
    .udesc   = "AKC - Agent 0 (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_vert_ring_akc_in_use[]={
  { .uname   = "DN_EVEN",
    .udesc   = "Down and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DN_ODD",
    .udesc   = "Down and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_EVEN",
    .udesc   = "Up and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_ODD",
    .udesc   = "Up and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_vert_ring_bl_in_use[]={
  { .uname   = "DN_EVEN",
    .udesc   = "Down and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DN_ODD",
    .udesc   = "Down and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_EVEN",
    .udesc   = "Up and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_ODD",
    .udesc   = "Up and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_vert_ring_iv_in_use[]={
  { .uname   = "DN",
    .udesc   = "Down (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP",
    .udesc   = "Up (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_umask_t icx_unc_m2p_vert_ring_tgc_in_use[]={
  { .uname   = "DN_EVEN",
    .udesc   = "Down and Even (experimental)",
    .ucode   = 0x0400ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "DN_ODD",
    .udesc   = "Down and Odd (experimental)",
    .ucode   = 0x0800ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_EVEN",
    .udesc   = "Up and Even (experimental)",
    .ucode   = 0x0100ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
  { .uname   = "UP_ODD",
    .udesc   = "Up and Odd (experimental)",
    .ucode   = 0x0200ull,
    .uflags  = INTEL_X86_NCOMBO,
  },
};

static const intel_x86_entry_t intel_icx_unc_m2pcie_pe[]={
  { .name   = "UNC_M2P_AG0_AD_CRD_ACQUIRED0",
    .desc   = "CMS Agent0 AD Credits Acquired",
    .code   = 0x0080,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_ag0_ad_crd_occupancy0), /* shared */
    .umasks = icx_unc_m2p_ag0_ad_crd_occupancy0,
  },
  { .name   = "UNC_M2P_AG0_AD_CRD_ACQUIRED1",
    .desc   = "CMS Agent0 AD Credits Acquired",
    .code   = 0x0081,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_ag0_ad_crd_occupancy1), /* shared */
    .umasks = icx_unc_m2p_ag0_ad_crd_occupancy1,
  },
  { .name   = "UNC_M2P_AG0_AD_CRD_OCCUPANCY0",
    .desc   = "CMS Agent0 AD Credits Occupancy",
    .code   = 0x0082,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_ag0_ad_crd_occupancy0),
    .umasks = icx_unc_m2p_ag0_ad_crd_occupancy0,
  },
  { .name   = "UNC_M2P_AG0_AD_CRD_OCCUPANCY1",
    .desc   = "CMS Agent0 AD Credits Occupancy",
    .code   = 0x0083,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_ag0_ad_crd_occupancy1),
    .umasks = icx_unc_m2p_ag0_ad_crd_occupancy1,
  },
  { .name   = "UNC_M2P_AG0_BL_CRD_ACQUIRED0",
    .desc   = "CMS Agent0 BL Credits Acquired",
    .code   = 0x0088,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_ag0_bl_crd_occupancy0), /* shared */
    .umasks = icx_unc_m2p_ag0_bl_crd_occupancy0,
  },
  { .name   = "UNC_M2P_AG0_BL_CRD_ACQUIRED1",
    .desc   = "CMS Agent0 BL Credits Acquired",
    .code   = 0x0089,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_ag0_bl_crd_occupancy1), /* shared */
    .umasks = icx_unc_m2p_ag0_bl_crd_occupancy1,
  },
  { .name   = "UNC_M2P_AG0_BL_CRD_OCCUPANCY0",
    .desc   = "CMS Agent0 BL Credits Occupancy",
    .code   = 0x008a,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_ag0_bl_crd_occupancy0),
    .umasks = icx_unc_m2p_ag0_bl_crd_occupancy0,
  },
  { .name   = "UNC_M2P_AG0_BL_CRD_OCCUPANCY1",
    .desc   = "CMS Agent0 BL Credits Occupancy",
    .code   = 0x008b,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_ag0_bl_crd_occupancy1),
    .umasks = icx_unc_m2p_ag0_bl_crd_occupancy1,
  },
  { .name   = "UNC_M2P_AG1_AD_CRD_ACQUIRED0",
    .desc   = "CMS Agent1 AD Credits Acquired",
    .code   = 0x0084,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_ag1_ad_crd_occupancy0), /* shared */
    .umasks = icx_unc_m2p_ag1_ad_crd_occupancy0,
  },
  { .name   = "UNC_M2P_AG1_AD_CRD_ACQUIRED1",
    .desc   = "CMS Agent1 AD Credits Acquired",
    .code   = 0x0085,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_ag1_ad_crd_occupancy1), /* shared */
    .umasks = icx_unc_m2p_ag1_ad_crd_occupancy1,
  },
  { .name   = "UNC_M2P_AG1_AD_CRD_OCCUPANCY0",
    .desc   = "CMS Agent1 AD Credits Occupancy",
    .code   = 0x0086,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_ag1_ad_crd_occupancy0),
    .umasks = icx_unc_m2p_ag1_ad_crd_occupancy0,
  },
  { .name   = "UNC_M2P_AG1_AD_CRD_OCCUPANCY1",
    .desc   = "CMS Agent1 AD Credits Occupancy",
    .code   = 0x0087,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_ag1_ad_crd_occupancy1),
    .umasks = icx_unc_m2p_ag1_ad_crd_occupancy1,
  },
  { .name   = "UNC_M2P_AG1_BL_CRD_ACQUIRED0",
    .desc   = "CMS Agent1 BL Credits Acquired",
    .code   = 0x008c,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_ag1_bl_crd_acquired0),
    .umasks = icx_unc_m2p_ag1_bl_crd_acquired0,
  },
  { .name   = "UNC_M2P_AG1_BL_CRD_ACQUIRED1",
    .desc   = "CMS Agent1 BL Credits Acquired",
    .code   = 0x008d,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_ag1_bl_crd_occupancy1), /* shared */
    .umasks = icx_unc_m2p_ag1_bl_crd_occupancy1,
  },
  { .name   = "UNC_M2P_AG1_BL_CRD_OCCUPANCY0",
    .desc   = "CMS Agent1 BL Credits Occupancy",
    .code   = 0x008e,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_stall0_no_txr_horz_crd_ad_ag0), /* shared */
    .umasks = icx_unc_m2p_stall0_no_txr_horz_crd_ad_ag0,
  },
  { .name   = "UNC_M2P_AG1_BL_CRD_OCCUPANCY1",
    .desc   = "CMS Agent1 BL Credits Occupancy",
    .code   = 0x008f,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_ag1_bl_crd_occupancy1),
    .umasks = icx_unc_m2p_ag1_bl_crd_occupancy1,
  },
  { .name   = "UNC_M2P_CLOCKTICKS",
    .desc   = "Clockticks of the mesh to PCI (M2P)",
    .code   = 0x0001,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2P_CMS_CLOCKTICKS",
    .desc   = "CMS Clockticks",
    .code   = 0x00c0,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2P_DISTRESS_ASSERTED",
    .desc   = "Distress signal asserted",
    .code   = 0x00af,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_distress_asserted),
    .umasks = icx_unc_m2p_distress_asserted,
  },
  { .name   = "UNC_M2P_EGRESS_ORDERING",
    .desc   = "Egress Blocking due to Ordering requirements",
    .code   = 0x00ba,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_egress_ordering),
    .umasks = icx_unc_m2p_egress_ordering,
  },
  { .name   = "UNC_M2P_HORZ_RING_AD_IN_USE",
    .desc   = "Horizontal AD Ring In Use",
    .code   = 0x00b6,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_horz_ring_akc_in_use), /* shared */
    .umasks = icx_unc_m2p_horz_ring_akc_in_use,
  },
  { .name   = "UNC_M2P_HORZ_RING_AKC_IN_USE",
    .desc   = "Horizontal AK Ring In Use",
    .code   = 0x00bb,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_horz_ring_akc_in_use),
    .umasks = icx_unc_m2p_horz_ring_akc_in_use,
  },
  { .name   = "UNC_M2P_HORZ_RING_AK_IN_USE",
    .desc   = "Horizontal AK Ring In Use",
    .code   = 0x00b7,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_horz_ring_bl_in_use), /* shared */
    .umasks = icx_unc_m2p_horz_ring_bl_in_use,
  },
  { .name   = "UNC_M2P_HORZ_RING_BL_IN_USE",
    .desc   = "Horizontal BL Ring in Use",
    .code   = 0x00b8,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_horz_ring_bl_in_use),
    .umasks = icx_unc_m2p_horz_ring_bl_in_use,
  },
  { .name   = "UNC_M2P_HORZ_RING_IV_IN_USE",
    .desc   = "Horizontal IV Ring in Use",
    .code   = 0x00b9,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_horz_ring_iv_in_use),
    .umasks = icx_unc_m2p_horz_ring_iv_in_use,
  },
  { .name   = "UNC_M2P_IIO_CREDITS_ACQUIRED",
    .desc   = "M2PCIe IIO Credit Acquired",
    .code   = 0x0033,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_iio_credits_acquired),
    .umasks = icx_unc_m2p_iio_credits_acquired,
  },
  { .name   = "UNC_M2P_IIO_CREDITS_REJECT",
    .desc   = "M2PCIe IIO Failed to Acquire a Credit",
    .code   = 0x0034,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_iio_credits_reject),
    .umasks = icx_unc_m2p_iio_credits_reject,
  },
  { .name   = "UNC_M2P_IIO_CREDITS_USED",
    .desc   = "M2PCIe IIO Credits in Use",
    .code   = 0x0032,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_iio_credits_used),
    .umasks = icx_unc_m2p_iio_credits_used,
  },
  { .name   = "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_0",
    .desc   = "Local Dedicated P2P Credit Taken - 0",
    .code   = 0x0046,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_local_shar_p2p_crd_taken_0), /* shared */
    .umasks = icx_unc_m2p_local_shar_p2p_crd_taken_0,
  },
  { .name   = "UNC_M2P_LOCAL_DED_P2P_CRD_TAKEN_1",
    .desc   = "Local Dedicated P2P Credit Taken - 1",
    .code   = 0x0047,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_local_shar_p2p_crd_taken_1), /* shared */
    .umasks = icx_unc_m2p_local_shar_p2p_crd_taken_1,
  },
  { .name   = "UNC_M2P_LOCAL_P2P_DED_RETURNED_0",
    .desc   = "Local P2P Dedicated Credits Returned - 0",
    .code   = 0x0019,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_local_p2p_ded_returned_0),
    .umasks = icx_unc_m2p_local_p2p_ded_returned_0,
  },
  { .name   = "UNC_M2P_LOCAL_P2P_DED_RETURNED_1",
    .desc   = "Local P2P Dedicated Credits Returned - 1",
    .code   = 0x001a,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_local_p2p_ded_returned_1),
    .umasks = icx_unc_m2p_local_p2p_ded_returned_1,
  },
  { .name   = "UNC_M2P_LOCAL_P2P_SHAR_RETURNED",
    .desc   = "Local P2P Shared Credits Returned",
    .code   = 0x0017,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_remote_p2p_shar_returned), /* shared */
    .umasks = icx_unc_m2p_remote_p2p_shar_returned,
  },
  { .name   = "UNC_M2P_LOCAL_SHAR_P2P_CRD_RETURNED",
    .desc   = "Local Shared P2P Credit Returned to credit ring",
    .code   = 0x0044,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_local_shar_p2p_crd_returned),
    .umasks = icx_unc_m2p_local_shar_p2p_crd_returned,
  },
  { .name   = "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_0",
    .desc   = "Local Shared P2P Credit Taken - 0",
    .code   = 0x0040,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_local_shar_p2p_crd_taken_0),
    .umasks = icx_unc_m2p_local_shar_p2p_crd_taken_0,
  },
  { .name   = "UNC_M2P_LOCAL_SHAR_P2P_CRD_TAKEN_1",
    .desc   = "Local Shared P2P Credit Taken - 1",
    .code   = 0x0041,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_local_shar_p2p_crd_taken_1),
    .umasks = icx_unc_m2p_local_shar_p2p_crd_taken_1,
  },
  { .name   = "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_0",
    .desc   = "Waiting on Local Shared P2P Credit - 0",
    .code   = 0x004a,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_local_shar_p2p_crd_wait_0),
    .umasks = icx_unc_m2p_local_shar_p2p_crd_wait_0,
  },
  { .name   = "UNC_M2P_LOCAL_SHAR_P2P_CRD_WAIT_1",
    .desc   = "Waiting on Local Shared P2P Credit - 1",
    .code   = 0x004b,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_local_shar_p2p_crd_wait_1),
    .umasks = icx_unc_m2p_local_shar_p2p_crd_wait_1,
  },
  { .name   = "UNC_M2P_MISC_EXTERNAL",
    .desc   = "Miscellaneous Events (mostly from MS2IDI)",
    .code   = 0x00e6,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_misc_external),
    .umasks = icx_unc_m2p_misc_external,
  },
  { .name   = "UNC_M2P_P2P_CRD_OCCUPANCY",
    .desc   = "P2P Credit Occupancy",
    .code   = 0x0014,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0x3ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_p2p_crd_occupancy),
    .umasks = icx_unc_m2p_p2p_crd_occupancy,
  },
  { .name   = "UNC_M2P_P2P_DED_RECEIVED",
    .desc   = "Dedicated Credits Received",
    .code   = 0x0016,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_p2p_shar_received), /* shared */
    .umasks = icx_unc_m2p_p2p_shar_received,
  },
  { .name   = "UNC_M2P_P2P_SHAR_RECEIVED",
    .desc   = "Shared Credits  Received",
    .code   = 0x0015,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_p2p_shar_received),
    .umasks = icx_unc_m2p_p2p_shar_received,
  },
  { .name   = "UNC_M2P_REMOTE_DED_P2P_CRD_TAKEN_0",
    .desc   = "Remote Dedicated P2P Credit Taken - 0",
    .code   = 0x0048,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_remote_shar_p2p_crd_taken_0), /* shared */
    .umasks = icx_unc_m2p_remote_shar_p2p_crd_taken_0,
  },
  { .name   = "UNC_M2P_REMOTE_DED_P2P_CRD_TAKEN_1",
    .desc   = "Remote Dedicated P2P Credit Taken - 1",
    .code   = 0x0049,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_remote_shar_p2p_crd_taken_1), /* shared */
    .umasks = icx_unc_m2p_remote_shar_p2p_crd_taken_1,
  },
  { .name   = "UNC_M2P_REMOTE_P2P_DED_RETURNED",
    .desc   = "Remote P2P Dedicated Credits Returned",
    .code   = 0x001b,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_remote_p2p_ded_returned),
    .umasks = icx_unc_m2p_remote_p2p_ded_returned,
  },
  { .name   = "UNC_M2P_REMOTE_P2P_SHAR_RETURNED",
    .desc   = "Remote P2P Shared Credits Returned",
    .code   = 0x0018,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_remote_p2p_shar_returned),
    .umasks = icx_unc_m2p_remote_p2p_shar_returned,
  },
  { .name   = "UNC_M2P_REMOTE_SHAR_P2P_CRD_RETURNED",
    .desc   = "Remote Shared P2P Credit Returned to credit ring",
    .code   = 0x0045,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_remote_shar_p2p_crd_returned),
    .umasks = icx_unc_m2p_remote_shar_p2p_crd_returned,
  },
  { .name   = "UNC_M2P_REMOTE_SHAR_P2P_CRD_TAKEN_0",
    .desc   = "Remote Shared P2P Credit Taken - 0",
    .code   = 0x0042,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_remote_shar_p2p_crd_taken_0),
    .umasks = icx_unc_m2p_remote_shar_p2p_crd_taken_0,
  },
  { .name   = "UNC_M2P_REMOTE_SHAR_P2P_CRD_TAKEN_1",
    .desc   = "Remote Shared P2P Credit Taken - 1",
    .code   = 0x0043,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_remote_shar_p2p_crd_taken_1),
    .umasks = icx_unc_m2p_remote_shar_p2p_crd_taken_1,
  },
  { .name   = "UNC_M2P_REMOTE_SHAR_P2P_CRD_WAIT_0",
    .desc   = "Waiting on Remote Shared P2P Credit - 0",
    .code   = 0x004c,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_remote_shar_p2p_crd_wait_0),
    .umasks = icx_unc_m2p_remote_shar_p2p_crd_wait_0,
  },
  { .name   = "UNC_M2P_REMOTE_SHAR_P2P_CRD_WAIT_1",
    .desc   = "Waiting on Remote Shared P2P Credit - 1",
    .code   = 0x004d,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_remote_shar_p2p_crd_wait_1),
    .umasks = icx_unc_m2p_remote_shar_p2p_crd_wait_1,
  },
  { .name   = "UNC_M2P_RING_BOUNCES_HORZ",
    .desc   = "Messages that bounced on the Horizontal Ring.",
    .code   = 0x00ac,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_ring_bounces_horz),
    .umasks = icx_unc_m2p_ring_bounces_horz,
  },
  { .name   = "UNC_M2P_RING_BOUNCES_VERT",
    .desc   = "Messages that bounced on the Vertical Ring.",
    .code   = 0x00aa,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_ring_sink_starved_vert), /* shared */
    .umasks = icx_unc_m2p_ring_sink_starved_vert,
  },
  { .name   = "UNC_M2P_RING_SINK_STARVED_HORZ",
    .desc   = "Sink Starvation on Horizontal Ring",
    .code   = 0x00ad,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_ring_sink_starved_horz),
    .umasks = icx_unc_m2p_ring_sink_starved_horz,
  },
  { .name   = "UNC_M2P_RING_SINK_STARVED_VERT",
    .desc   = "Sink Starvation on Vertical Ring",
    .code   = 0x00ab,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_ring_sink_starved_vert),
    .umasks = icx_unc_m2p_ring_sink_starved_vert,
  },
  { .name   = "UNC_M2P_RING_SRC_THRTL",
    .desc   = "Source Throttle (experimental)",
    .code   = 0x00ae,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2P_RxC_CYCLES_NE",
    .desc   = "Ingress (from CMS) Queue Cycles Not Empty",
    .code   = 0x0010,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_rxc_inserts), /* shared */
    .umasks = icx_unc_m2p_rxc_inserts,
  },
  { .name   = "UNC_M2P_RxC_INSERTS",
    .desc   = "Ingress (from CMS) Queue Inserts",
    .code   = 0x0011,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_rxc_inserts),
    .umasks = icx_unc_m2p_rxc_inserts,
  },
  { .name   = "UNC_M2P_RxR_BUSY_STARVED",
    .desc   = "Transgress Injection Starvation",
    .code   = 0x00e5,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_horz_ads_used), /* shared */
    .umasks = icx_unc_m2p_txr_horz_ads_used,
  },
  { .name   = "UNC_M2P_RxR_BYPASS",
    .desc   = "Transgress Ingress Bypass",
    .code   = 0x00e2,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_rxr_inserts), /* shared */
    .umasks = icx_unc_m2p_rxr_inserts,
  },
  { .name   = "UNC_M2P_RxR_CRD_STARVED",
    .desc   = "Transgress Injection Starvation",
    .code   = 0x00e3,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_rxr_crd_starved),
    .umasks = icx_unc_m2p_rxr_crd_starved,
  },
  { .name   = "UNC_M2P_RxR_CRD_STARVED_1",
    .desc   = "Transgress Injection Starvation (experimental)",
    .code   = 0x00e4,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
  },
  { .name   = "UNC_M2P_RxR_INSERTS",
    .desc   = "Transgress Ingress Allocations",
    .code   = 0x00e1,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_rxr_inserts),
    .umasks = icx_unc_m2p_rxr_inserts,
  },
  { .name   = "UNC_M2P_RxR_OCCUPANCY",
    .desc   = "Transgress Ingress Occupancy",
    .code   = 0x00e0,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_rxr_occupancy),
    .umasks = icx_unc_m2p_rxr_occupancy,
  },
  { .name   = "UNC_M2P_STALL0_NO_TxR_HORZ_CRD_AD_AG0",
    .desc   = "Stall on No AD Agent0 Transgress Credits",
    .code   = 0x00d0,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_stall0_no_txr_horz_crd_ad_ag0),
    .umasks = icx_unc_m2p_stall0_no_txr_horz_crd_ad_ag0,
  },
  { .name   = "UNC_M2P_STALL0_NO_TxR_HORZ_CRD_AD_AG1",
    .desc   = "Stall on No AD Agent1 Transgress Credits",
    .code   = 0x00d2,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_stall0_no_txr_horz_crd_bl_ag0), /* shared */
    .umasks = icx_unc_m2p_stall0_no_txr_horz_crd_bl_ag0,
  },
  { .name   = "UNC_M2P_STALL0_NO_TxR_HORZ_CRD_BL_AG0",
    .desc   = "Stall on No BL Agent0 Transgress Credits",
    .code   = 0x00d4,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_stall0_no_txr_horz_crd_bl_ag0),
    .umasks = icx_unc_m2p_stall0_no_txr_horz_crd_bl_ag0,
  },
  { .name   = "UNC_M2P_STALL0_NO_TxR_HORZ_CRD_BL_AG1",
    .desc   = "Stall on No BL Agent1 Transgress Credits",
    .code   = 0x00d6,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_stall0_no_txr_horz_crd_bl_ag1),
    .umasks = icx_unc_m2p_stall0_no_txr_horz_crd_bl_ag1,
  },
  { .name   = "UNC_M2P_STALL1_NO_TxR_HORZ_CRD_AD_AG0",
    .desc   = "Stall on No AD Agent0 Transgress Credits",
    .code   = 0x00d1,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_stall1_no_txr_horz_crd_ad_ag1_1), /* shared */
    .umasks = icx_unc_m2p_stall1_no_txr_horz_crd_ad_ag1_1,
  },
  { .name   = "UNC_M2P_STALL1_NO_TxR_HORZ_CRD_AD_AG1_1",
    .desc   = "Stall on No AD Agent1 Transgress Credits",
    .code   = 0x00d3,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_stall1_no_txr_horz_crd_ad_ag1_1),
    .umasks = icx_unc_m2p_stall1_no_txr_horz_crd_ad_ag1_1,
  },
  { .name   = "UNC_M2P_STALL1_NO_TxR_HORZ_CRD_BL_AG0_1",
    .desc   = "Stall on No BL Agent0 Transgress Credits",
    .code   = 0x00d5,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_stall1_no_txr_horz_crd_bl_ag1_1), /* shared */
    .umasks = icx_unc_m2p_stall1_no_txr_horz_crd_bl_ag1_1,
  },
  { .name   = "UNC_M2P_STALL1_NO_TxR_HORZ_CRD_BL_AG1_1",
    .desc   = "Stall on No BL Agent1 Transgress Credits",
    .code   = 0x00d7,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_stall1_no_txr_horz_crd_bl_ag1_1),
    .umasks = icx_unc_m2p_stall1_no_txr_horz_crd_bl_ag1_1,
  },
  { .name   = "UNC_M2P_TxC_CREDITS",
    .desc   = "UNC_M2P_TxC_CREDITS.PRQ",
    .code   = 0x002d,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0x3ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txc_credits),
    .umasks = icx_unc_m2p_txc_credits,
  },
  { .name   = "UNC_M2P_TxC_CYCLES_FULL",
    .desc   = "Egress (to CMS) Cycles Full",
    .code   = 0x0025,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txc_cycles_full),
    .umasks = icx_unc_m2p_txc_cycles_full,
  },
  { .name   = "UNC_M2P_TxC_CYCLES_NE",
    .desc   = "Egress (to CMS) Cycles Not Empty",
    .code   = 0x0023,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0x3ull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txc_cycles_ne),
    .umasks = icx_unc_m2p_txc_cycles_ne,
  },
  { .name   = "UNC_M2P_TxC_INSERTS",
    .desc   = "Egress (to CMS) Ingress",
    .code   = 0x0024,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txc_inserts),
    .umasks = icx_unc_m2p_txc_inserts,
  },
  { .name   = "UNC_M2P_TxR_HORZ_ADS_USED",
    .desc   = "CMS Horizontal ADS Used",
    .code   = 0x00a6,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_horz_ads_used),
    .umasks = icx_unc_m2p_txr_horz_ads_used,
  },
  { .name   = "UNC_M2P_TxR_HORZ_BYPASS",
    .desc   = "CMS Horizontal Bypass Used",
    .code   = 0x00a7,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_horz_cycles_full), /* shared */
    .umasks = icx_unc_m2p_txr_horz_cycles_full,
  },
  { .name   = "UNC_M2P_TxR_HORZ_CYCLES_FULL",
    .desc   = "Cycles CMS Horizontal Egress Queue is Full",
    .code   = 0x00a2,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_horz_cycles_full),
    .umasks = icx_unc_m2p_txr_horz_cycles_full,
  },
  { .name   = "UNC_M2P_TxR_HORZ_CYCLES_NE",
    .desc   = "Cycles CMS Horizontal Egress Queue is Not Empty",
    .code   = 0x00a3,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_horz_inserts), /* shared */
    .umasks = icx_unc_m2p_txr_horz_inserts,
  },
  { .name   = "UNC_M2P_TxR_HORZ_INSERTS",
    .desc   = "CMS Horizontal Egress Inserts",
    .code   = 0x00a1,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_horz_inserts),
    .umasks = icx_unc_m2p_txr_horz_inserts,
  },
  { .name   = "UNC_M2P_TxR_HORZ_NACK",
    .desc   = "CMS Horizontal Egress NACKs",
    .code   = 0x00a4,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_horz_occupancy), /* shared */
    .umasks = icx_unc_m2p_txr_horz_occupancy,
  },
  { .name   = "UNC_M2P_TxR_HORZ_OCCUPANCY",
    .desc   = "CMS Horizontal Egress Occupancy",
    .code   = 0x00a0,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_horz_occupancy),
    .umasks = icx_unc_m2p_txr_horz_occupancy,
  },
  { .name   = "UNC_M2P_TxR_HORZ_STARVED",
    .desc   = "CMS Horizontal Egress Injection Starvation",
    .code   = 0x00a5,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_horz_starved),
    .umasks = icx_unc_m2p_txr_horz_starved,
  },
  { .name   = "UNC_M2P_TxR_VERT_ADS_USED",
    .desc   = "CMS Vertical ADS Used",
    .code   = 0x009c,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_vert_ads_used),
    .umasks = icx_unc_m2p_txr_vert_ads_used,
  },
  { .name   = "UNC_M2P_TxR_VERT_BYPASS",
    .desc   = "CMS Vertical ADS Used",
    .code   = 0x009d,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_vert_bypass),
    .umasks = icx_unc_m2p_txr_vert_bypass,
  },
  { .name   = "UNC_M2P_TxR_VERT_BYPASS_1",
    .desc   = "CMS Vertical ADS Used",
    .code   = 0x009e,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_vert_cycles_full1), /* shared */
    .umasks = icx_unc_m2p_txr_vert_cycles_full1,
  },
  { .name   = "UNC_M2P_TxR_VERT_CYCLES_FULL0",
    .desc   = "Cycles CMS Vertical Egress Queue Is Full",
    .code   = 0x0094,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_vert_cycles_ne0), /* shared */
    .umasks = icx_unc_m2p_txr_vert_cycles_ne0,
  },
  { .name   = "UNC_M2P_TxR_VERT_CYCLES_FULL1",
    .desc   = "Cycles CMS Vertical Egress Queue Is Full",
    .code   = 0x0095,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_vert_cycles_full1),
    .umasks = icx_unc_m2p_txr_vert_cycles_full1,
  },
  { .name   = "UNC_M2P_TxR_VERT_CYCLES_NE0",
    .desc   = "Cycles CMS Vertical Egress Queue Is Not Empty",
    .code   = 0x0096,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_vert_cycles_ne0),
    .umasks = icx_unc_m2p_txr_vert_cycles_ne0,
  },
  { .name   = "UNC_M2P_TxR_VERT_CYCLES_NE1",
    .desc   = "Cycles CMS Vertical Egress Queue Is Not Empty",
    .code   = 0x0097,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_vert_inserts1), /* shared */
    .umasks = icx_unc_m2p_txr_vert_inserts1,
  },
  { .name   = "UNC_M2P_TxR_VERT_INSERTS0",
    .desc   = "CMS Vert Egress Allocations",
    .code   = 0x0092,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_vert_occupancy0), /* shared */
    .umasks = icx_unc_m2p_txr_vert_occupancy0,
  },
  { .name   = "UNC_M2P_TxR_VERT_INSERTS1",
    .desc   = "CMS Vert Egress Allocations",
    .code   = 0x0093,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_vert_inserts1),
    .umasks = icx_unc_m2p_txr_vert_inserts1,
  },
  { .name   = "UNC_M2P_TxR_VERT_NACK0",
    .desc   = "CMS Vertical Egress NACKs",
    .code   = 0x0098,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_vert_starved0), /* shared */
    .umasks = icx_unc_m2p_txr_vert_starved0,
  },
  { .name   = "UNC_M2P_TxR_VERT_NACK1",
    .desc   = "CMS Vertical Egress NACKs",
    .code   = 0x0099,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_vert_occupancy1), /* shared */
    .umasks = icx_unc_m2p_txr_vert_occupancy1,
  },
  { .name   = "UNC_M2P_TxR_VERT_OCCUPANCY0",
    .desc   = "CMS Vert Egress Occupancy",
    .code   = 0x0090,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_vert_occupancy0),
    .umasks = icx_unc_m2p_txr_vert_occupancy0,
  },
  { .name   = "UNC_M2P_TxR_VERT_OCCUPANCY1",
    .desc   = "CMS Vert Egress Occupancy",
    .code   = 0x0091,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_vert_occupancy1),
    .umasks = icx_unc_m2p_txr_vert_occupancy1,
  },
  { .name   = "UNC_M2P_TxR_VERT_STARVED0",
    .desc   = "CMS Vertical Egress Injection Starvation",
    .code   = 0x009a,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_vert_starved0),
    .umasks = icx_unc_m2p_txr_vert_starved0,
  },
  { .name   = "UNC_M2P_TxR_VERT_STARVED1",
    .desc   = "CMS Vertical Egress Injection Starvation",
    .code   = 0x009b,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_txr_vert_starved1),
    .umasks = icx_unc_m2p_txr_vert_starved1,
  },
  { .name   = "UNC_M2P_VERT_RING_AD_IN_USE",
    .desc   = "Vertical AD Ring In Use",
    .code   = 0x00b0,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_vert_ring_akc_in_use), /* shared */
    .umasks = icx_unc_m2p_vert_ring_akc_in_use,
  },
  { .name   = "UNC_M2P_VERT_RING_AKC_IN_USE",
    .desc   = "Vertical AKC Ring In Use",
    .code   = 0x00b4,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_vert_ring_akc_in_use),
    .umasks = icx_unc_m2p_vert_ring_akc_in_use,
  },
  { .name   = "UNC_M2P_VERT_RING_AK_IN_USE",
    .desc   = "Vertical AK Ring In Use",
    .code   = 0x00b1,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_vert_ring_bl_in_use), /* shared */
    .umasks = icx_unc_m2p_vert_ring_bl_in_use,
  },
  { .name   = "UNC_M2P_VERT_RING_BL_IN_USE",
    .desc   = "Vertical BL Ring in Use",
    .code   = 0x00b2,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_vert_ring_bl_in_use),
    .umasks = icx_unc_m2p_vert_ring_bl_in_use,
  },
  { .name   = "UNC_M2P_VERT_RING_IV_IN_USE",
    .desc   = "Vertical IV Ring in Use",
    .code   = 0x00b3,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_vert_ring_iv_in_use),
    .umasks = icx_unc_m2p_vert_ring_iv_in_use,
  },
  { .name   = "UNC_M2P_VERT_RING_TGC_IN_USE",
    .desc   = "Vertical TGC Ring In Use",
    .code   = 0x00b5,
    .modmsk = ICX_UNC_M2PCIE_ATTRS,
    .cntmsk = 0xfull,
    .ngrp   = 1,
    .numasks= LIBPFM_ARRAY_SIZE(icx_unc_m2p_vert_ring_tgc_in_use),
    .umasks = icx_unc_m2p_vert_ring_tgc_in_use,
  },
};
/* 105 events available */
