/*
 * Copyright (c) 2025 Aurélien Berthier
 * <aurelien.berthier@ls2n.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "spomsprotein.h"


namespace pappso
{
namespace specpeptidoms
{
SpOMSProtein::SpOMSProtein(const QString &description,
                           const QString &sequence,
                           const AaCode &aa_code)
  : m_description(description), m_sequence(sequence)
{
  clear();

  SpOMSAa aa;

  for(const QChar &aa_str : m_sequence)
    {
      aa.aa   = (pappso::Enums::AminoAcidChar)aa_str.toLatin1();
      aa.code = aa_code.getAaCode(aa.aa);
      aa.mass = aa_code.getMass(aa.code);
      push_back(aa);
    }

  // by default the sequence is reversed
  std::reverse(begin(), end());
}

SpOMSProtein::~SpOMSProtein()
{
}

const QString
SpOMSProtein::getAccession() const
{
  return m_description.split(" ").at(0);
}

const QString &
SpOMSProtein::getSequence() const
{
  return m_sequence;
}


const QString &
SpOMSProtein::getCompleteDescription() const
{
  return m_description;
}

std::vector<SpOMSAa>
SpOMSProtein::sliced(std::size_t position, std::size_t length) const
{

  std::vector<SpOMSAa> aa_vec;

  for(std::size_t i = 0; i < length; i++)
    {
      aa_vec.push_back(at(i + position));
    }

  return aa_vec;
}
} // namespace specpeptidoms
} // namespace pappso
