program intrinsics_215
    use, intrinsic :: iso_fortran_env, only: dp => real64, sp => real32
    real(sp) :: a, b, c
    real(dp) :: d, e, f
    integer :: i

    real(dp) :: w(19)
    real(sp) :: x(19)
    real(dp) :: expected_w(19)
    real(sp) :: expected_x(19)
         
    real(dp), parameter :: res(19) = cosd([18.7234114226922479_dp, 31.7355871858161613_dp, 46.7189879975828859_dp, &
    -18.7234114226922479_dp, -31.7355871858161613_dp, -46.7189879975828859_dp, -90.0000000000000000_dp, &
    -88.1889782219856926_dp, -87.4387217993888584_dp, -86.8629570229495442_dp, -86.3775039053440139_dp, &
    -85.9497575149846398_dp, -85.5629967823348778_dp, -85.2072890476047604_dp, -84.8761629060389708_dp, &
    -84.5651234927047142_dp, -84.2708982602068915_dp, -83.9910168022338581_dp, -83.7235599383380418_dp])

    real(sp), parameter :: res_sp(19) = cosd([17.7966309_sp, 27.7443714_sp, 36.0546188_sp, &
        -17.7966309_sp, -27.7443714_sp, -36.0546188_sp, -45.0000000_sp, -44.9713364_sp, -44.9713364_sp, &
        -44.9426460_sp, -44.9426460_sp, -44.9139252_sp, -44.9139252_sp, -44.8851776_sp, &
        -44.8851776_sp, -44.8564034_sp, -44.8564034_sp, -44.8275948_sp, -44.8275948_sp])

    expected_w = [0.94707919415432207_dp, 0.85048456776122638_dp, 0.68557712914011359_dp, &
    0.94707919415432207_dp, 0.85048456776122638_dp, 0.68557712914011359_dp, 0.0000000000000000_dp, &
    3.1603029890377138E-002_dp, 4.4687850642047139E-002_dp, 5.4724377477153467E-002_dp, &
    6.3182370832535792E-002_dp, 7.0631207523869075E-002_dp, 7.7362936649548061E-002_dp, &
    8.3551070946493652E-002_dp, 8.9308677876631062E-002_dp, 9.4714304254108886E-002_dp, &
    9.9825146707179999E-002_dp, 0.10468438946844835_dp, 0.10932558657585983_dp]

    w = [18.7234114226922479_dp, 31.7355871858161613_dp, 46.7189879975828859_dp, -18.7234114226922479_dp, &
    -31.7355871858161613_dp, -46.7189879975828859_dp, -90.0000000000000000_dp, -88.1889782219856926_dp, -87.4387217993888584_dp, &
    -86.8629570229495442_dp, -86.3775039053440139_dp, -85.9497575149846398_dp, -85.5629967823348778_dp, -85.2072890476047604_dp, &
    -84.8761629060389708_dp, -84.5651234927047142_dp, -84.2708982602068915_dp, -83.9910168022338581_dp, &
    -83.7235599383380418_dp]

    x = [17.7966309_sp, 27.7443714_sp, 36.0546188_sp, -17.7966309_sp, &
        -27.7443714_sp, -36.0546188_sp, -45.0000000_sp, -44.9713364_sp, -44.9713364_sp, &
        -44.9426460_sp, -44.9426460_sp, -44.9139252_sp, -44.9139252_sp, -44.8851776_sp, &
        -44.8851776_sp, -44.8564034_sp, -44.8564034_sp, -44.8275948_sp, -44.8275948_sp]

    expected_x = [0.952147365_sp, 0.885033369_sp, 0.808456302_sp, &
        0.952147365_sp, 0.885033369_sp, 0.808456302_sp, 0.707106769_sp, 0.707460463_sp, 0.707460463_sp, &
        0.707814276_sp, 0.707814276_sp, 0.708168268_sp, 0.708168268_sp, 0.708522379_sp, &
        0.708522379_sp, 0.708876729_sp, 0.708876729_sp, 0.709231317_sp, 0.709231317_sp]

    do i = 1, size(res)
        print *, res(i)
        if (abs(res(i) - expected_w(i)) > 1e-12_dp) error stop
    end do

    do i = 1, size(w)
        print *, cosd(w(i))
        if (abs(cosd(w(i)) - expected_w(i)) > 1e-12_dp) error stop
    end do

    do i = 1, size(res_sp)
        print *, res_sp(i)
        if (abs(res_sp(i) - expected_x(i)) > 1e-5) error stop
    end do

    do i = 1, size(x)
        print *, cosd(x(i))
        if (abs(cosd(x(i)) - expected_x(i)) > 1e-5) error stop
    end do

    a = 18.928_sp
    b = 32.627_sp
    c = 47.123_sp

    d = 18.829262783_dp
    e = 32.727262783_dp
    f = 47.223262783_dp

    print *, cosd(a)
    if (abs(cosd(a) - 0.945926964) > 1e-3) error stop

    print *, cosd(b)
    if (abs(cosd(b) - 0.842198431) > 1e-3) error stop

    print *, cosd(c)
    if (abs(cosd(c) - 0.680426717) > 1e-3) error stop

    print *, cosd(18.928_sp)
    if (abs(cosd(18.928_sp) - 0.945926964) > 1e-3) error stop

    print *, cosd(32.627_sp)
    if (abs(cosd(32.627_sp) - 0.842198431) > 1e-3) error stop

    print *, cosd(47.123_sp)
    if (abs(cosd(47.123_sp) - 0.680426717) > 1e-3) error stop

    print *, cosd(d)
    if (abs(cosd(d) - 0.94648454528292103) > 1e-3) error stop

    print *, cosd(e)
    if (abs(cosd(e) - 0.84125362666495140) > 1e-3) error stop

    print *, cosd(f)
    if (abs(cosd(f) - 0.67914334502356000) > 1e-3) error stop

    print *, cosd(18.829262783_dp)
    if (abs(cosd(18.829262783_dp) - 0.94648454528292103) > 1e-3) error stop

    print *, cosd(32.727262783_dp)
    if (abs(cosd(32.727262783_dp) - 0.84125362666495140) > 1e-3) error stop

    print *, cosd(47.223262783_dp)
    if (abs(cosd(47.223262783_dp) - 0.67914334502356000) > 1e-3) error stop

end program