import { defineConfig, globalIgnores } from "eslint/config";
import globals from "globals";
import path from "node:path";
import { fileURLToPath } from "node:url";
import js from "@eslint/js";
import { FlatCompat } from "@eslint/eslintrc";

const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);
const compat = new FlatCompat({
    baseDirectory: __dirname,
    recommendedConfig: js.configs.recommended,
    allConfig: js.configs.all
});

export default defineConfig([globalIgnores(["**/*.min.js"]), {
    extends: compat.extends("eslint:recommended"),
    languageOptions: {
        globals: {
            ...globals.browser,
            ...globals.jquery,
            ...globals.webextensions,
            _called: "readonly",
            acceptedOTPFields: "readonly",
            assertInputFields: "readonly",
            assertPasswordChangeFields: "readonly",
            assertRegex: "readonly",
            assertSearchField: "readonly",
            assertSearchForm: "readonly",
            assertTOTPField: "readonly",
            AssociatedAction: "readonly",
            AuthenticatorAssertionResponse: "readonly",
            AuthenticatorAttestationResponse: "readonly",
            Autocomplete: "readonly",
            BannerPosition: "readonly",
            BLUE_BUTTON: "readonly",
            bootstrap: "readonly",
            browser: "readonly",
            browserAction: "readonly",
            CHECK_UPDATE_NEVER: "readonly",
            CHECK_UPDATE_ONE_MONTH: "readonly",
            CHECK_UPDATE_ONE_WEEK: "readonly",
            CHECK_UPDATE_THREE_DAYS: "readonly",
            cloneInto: "readonly",
            compareVersion: "readonly",
            createResult: "readonly",
            createStylesheet: "readonly",
            DatabaseState: "readonly",
            debugLogMessage: "readonly",
            DEFINED_CUSTOM_FIELDS: "readonly",
            elementsOverlap: "readonly",
            EXTENSION_NAME: "readonly",
            getCurrentTab: "readonly",
            getLoginData: "readonly",
            getTopLevelDomainFromUrl: "readonly",
            GRAY_BUTTON_CLASS: "readonly",
            GREEN_BUTTON: "readonly",
            httpAuth: "readonly",
            Icon: "readonly",
            IGNORE_AUTOSUBMIT: "readonly",
            IGNORE_FULL: "readonly",
            IGNORE_NORMAL: "readonly",
            IGNORE_NOTHING: "readonly",
            IGNORE_PASSKEYS: "readonly",
            importScripts: "readonly",
            IMPROVED_DETECTION_PREDEFINED_SITELIST: "readonly",
            initColorTheme: "readonly",
            isEdge: "readonly",
            isElementInside: "readonly",
            isFirefox: "readonly",
            isIframeAllowed: "readonly",
            keepass: "readonly",
            keepassClient: "readonly",
            kpActions: "readonly",
            kpErrors: "readonly",
            kpxc: "readonly",
            kpxcAssert: "readonly",
            kpxcBanner: "readonly",
            kpxcCustomLoginFieldsBanner: "readonly",
            kpxcEvent: "readonly",
            kpxcFields: "readonly",
            kpxcFill: "readonly",
            kpxcForm: "readonly",
            kpxcIcons: "readonly",
            kpxcObserverHelper: "readonly",
            kpxcPasswordGenerator: "readonly",
            kpxcPasswordIcons: "readonly",
            kpxcSites: "readonly",
            kpxcTOTPAutocomplete: "readonly",
            kpxcTOTPIcons: "readonly",
            kpxcUI: "readonly",
            kpxcUserAutocomplete: "readonly",
            kpxcUsernameIcons: "readonly",
            logDebug: "readonly",
            logError: "readonly",
            kpxcPasskeysUtils: "readonly",
            ManualFill: "readonly",
            matchesWithNodeName: "readonly",
            MAX_AUTOCOMPLETE_NAME_LEN: "readonly",
            MAX_OPACITY: "readonly",
            MAX_TOTP_INPUT_LENGTH: "readonly",
            menuContexts: "readonly",
            MIN_INPUT_FIELD_OFFSET_WIDTH: "readonly",
            MIN_INPUT_FIELD_WIDTH_PX: "readonly",
            MIN_OPACITY: "readonly",
            MIN_TOTP_INPUT_LENGTH: "readonly",
            module: "readonly",
            nacl: "readonly",
            OBSERVER_OPTIONS: "readonly",
            ORANGE_BUTTON: "readonly",
            page: "readonly",
            Pixels: "readonly",
            PublicKeyCredential: "readonly",
            PREDEFINED_SITELIST: "readonly",
            RED_BUTTON: "readonly",
            retrieveColorScheme: "readonly",
            sendMessage: "readonly",
            showNotification: "readonly",
            siteMatch: "readonly",
            SitePreferences: "readonly",
            slashNeededForUrl: "readonly",
            SORT_BY_GROUP_AND_TITLE: "readonly",
            SORT_BY_GROUP_AND_USERNAME: "readonly",
            SORT_BY_MATCHING_CREDENTIALS_SETTING: "readonly",
            SORT_BY_RELEVANT_ENTRY: "readonly",
            SORT_BY_TITLE: "readonly",
            SORT_BY_USERNAME: "readonly",
            statusResponse: "readonly",
            Tests: "readonly",
            tr: "readonly",
            trimURL: "readonly",
            updateDefaultPasswordManager: "readonly",
        },
        ecmaVersion: 13,
        sourceType: "script",
    },
    rules: {
        "array-bracket-spacing": ["error", "always"],
        "arrow-body-style": "warn",
        "arrow-parens": "off",
        "arrow-spacing": "warn",
        "block-scoped-var": "off",
        "brace-style": ["warn", "1tbs"],
        "camelcase": "warn",
        "class-methods-use-this": "off",
        "comma-dangle": "off",
        "computed-property-spacing": ["error", "never"],
        "consistent-return": "off",
        "dot-notation": "off",
        "eqeqeq": "error",
        "func-names": "off",
        "function-paren-newline": "off",
        "guard-for-in": "off",
        "implicit-arrow-linebreak": "off",
        "indent": ["error", 4],
        "linebreak-style": ["error", "unix"],
        "lines-around-comment": "off",
        "max-len": "off",
        "no-alert": "error",
        "no-await-in-loop": "off",
        "no-bitwise": "off",
        "no-console": "off",
        "no-continue": "off",
        "no-control-regex": "off",
        "no-else-return": "off",
        "no-empty-function": ["error", {
            "allow": ["arrowFunctions", "methods", "asyncMethods"],
        }],
        "no-extend-native": "off",
        "no-global-assign": "off",
        "no-lonely-if": "off",
        "no-loop-func": "off",
        "no-mixed-operators": "off",
        "no-mixed-spaces-and-tabs": ["error", "smart-tabs"],
        "no-multi-spaces": "warn",
        "no-param-reassign": "off",
        "no-plusplus": "off",
        "no-prototype-builtins": "off",
        "no-redeclare": "off",
        "no-restricted-globals": "off",
        "no-restricted-syntax": "off",
        "no-return-await": "off",
        "no-tabs": "warn",
        "no-underscore-dangle": "off",
        "no-unused-vars": ["warn", {
            "args": "none",
            "caughtErrorsIgnorePattern": "^_",
            "varsIgnorePattern": "[A-Z_]+|tr|[$]",
        }],
        "no-use-before-define": "off",
        "no-useless-escape": "off",
        "no-useless-return": "off",
        "no-var": "error",
        "object-curly-spacing": ["warn", "always"],
        "object-shorthand": "off",
        "operator-linebreak": "off",
        "prefer-arrow-callback": "off",
        "prefer-const": "warn",
        "prefer-destructuring": "off",
        "prefer-template": "off",
        "quote-props": "off",
        "quotes": ["error", "single", {
            "avoidEscape": true,
        }],
        "semi": ["error", "always"],
        "space-before-blocks": "warn",
        "space-before-function-paren": "off",
        "space-in-parens": ["error", "never"],
        "space-unary-ops": "off",
        "spaced-comment": "off",
        "strict": "off",
        "vars-on-top": "off",
    },
}]);
