// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: backup.proto

package backup

import (
	"fmt"
	"io"
	"math"

	proto "github.com/golang/protobuf/proto"

	_ "github.com/gogo/protobuf/gogoproto"

	errorpb "github.com/pingcap/kvproto/pkg/errorpb"

	kvrpcpb "github.com/pingcap/kvproto/pkg/kvrpcpb"

	context "golang.org/x/net/context"

	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// sst files compression algorithm
type CompressionType int32

const (
	CompressionType_UNKNOWN CompressionType = 0
	CompressionType_LZ4     CompressionType = 1
	CompressionType_SNAPPY  CompressionType = 2
	CompressionType_ZSTD    CompressionType = 3
)

var CompressionType_name = map[int32]string{
	0: "UNKNOWN",
	1: "LZ4",
	2: "SNAPPY",
	3: "ZSTD",
}
var CompressionType_value = map[string]int32{
	"UNKNOWN": 0,
	"LZ4":     1,
	"SNAPPY":  2,
	"ZSTD":    3,
}

func (x CompressionType) String() string {
	return proto.EnumName(CompressionType_name, int32(x))
}
func (CompressionType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{0}
}

// The message save the metadata of a backup.
type BackupMeta struct {
	// ID and version of backuped cluster.
	ClusterId      uint64 `protobuf:"varint,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	ClusterVersion string `protobuf:"bytes,2,opt,name=cluster_version,json=clusterVersion,proto3" json:"cluster_version,omitempty"`
	// Save the version of BR running backup jobs.
	BrVersion string `protobuf:"bytes,11,opt,name=br_version,json=brVersion,proto3" json:"br_version,omitempty"`
	// The backupmeta scheme version.
	Version int32 `protobuf:"varint,12,opt,name=version,proto3" json:"version,omitempty"`
	// A set of files that compose a backup.
	// Note: `files` is deprecated, as it bloats backupmeta. It is kept for
	//       compatibility, so new BR can restore older backups.
	Files []*File `protobuf:"bytes,4,rep,name=files" json:"files,omitempty"`
	// An index to files contains data files.
	FileIndex *MetaFile `protobuf:"bytes,13,opt,name=file_index,json=fileIndex" json:"file_index,omitempty"`
	// A pair of timestamp specifies a time range of a backup.
	// For full backup, the start_version equals to the end_version,
	// it means point in time.
	// For incremental backup, the time range is specified as
	// (start_version, end_version].
	StartVersion uint64 `protobuf:"varint,5,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	EndVersion   uint64 `protobuf:"varint,6,opt,name=end_version,json=endVersion,proto3" json:"end_version,omitempty"`
	// Table metadata describes database and table info.
	// Note: `schemas` is deprecated, as it bloats backupmeta. It is kept for
	//       compatibility, so new BR can restore older backups.
	Schemas []*Schema `protobuf:"bytes,7,rep,name=schemas" json:"schemas,omitempty"`
	// An index to files contains Schemas.
	SchemaIndex *MetaFile `protobuf:"bytes,14,opt,name=schema_index,json=schemaIndex" json:"schema_index,omitempty"`
	// If in raw kv mode, `start_versions`, `end_versions` and `schemas` will be
	// ignored, and the backup data's range is represented by raw_ranges.
	IsRawKv bool `protobuf:"varint,8,opt,name=is_raw_kv,json=isRawKv,proto3" json:"is_raw_kv,omitempty"`
	// Note: `raw_ranges` is deprecated, as it bloats backupmeta. It is kept for
	//       compatibility, so new BR can restore older backups.
	RawRanges []*RawRange `protobuf:"bytes,9,rep,name=raw_ranges,json=rawRanges" json:"raw_ranges,omitempty"`
	// An index to files contains RawRanges.
	RawRangeIndex *MetaFile `protobuf:"bytes,15,opt,name=raw_range_index,json=rawRangeIndex" json:"raw_range_index,omitempty"`
	// In incremental backup, DDLs which are completed in
	// (lastBackupTS, backupTS] will be stored here.
	// Note: `raw_ranges` is deprecated, as it bloats backupmeta. It is kept for
	//       compatibility, so new BR can restore older backups.
	Ddls []byte `protobuf:"bytes,10,opt,name=ddls,proto3" json:"ddls,omitempty"`
	// An index to files contains DDLs.
	DdlIndexes           *MetaFile `protobuf:"bytes,16,opt,name=ddl_indexes,json=ddlIndexes" json:"ddl_indexes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *BackupMeta) Reset()         { *m = BackupMeta{} }
func (m *BackupMeta) String() string { return proto.CompactTextString(m) }
func (*BackupMeta) ProtoMessage()    {}
func (*BackupMeta) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{0}
}
func (m *BackupMeta) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BackupMeta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BackupMeta.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *BackupMeta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupMeta.Merge(dst, src)
}
func (m *BackupMeta) XXX_Size() int {
	return m.Size()
}
func (m *BackupMeta) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupMeta.DiscardUnknown(m)
}

var xxx_messageInfo_BackupMeta proto.InternalMessageInfo

func (m *BackupMeta) GetClusterId() uint64 {
	if m != nil {
		return m.ClusterId
	}
	return 0
}

func (m *BackupMeta) GetClusterVersion() string {
	if m != nil {
		return m.ClusterVersion
	}
	return ""
}

func (m *BackupMeta) GetBrVersion() string {
	if m != nil {
		return m.BrVersion
	}
	return ""
}

func (m *BackupMeta) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *BackupMeta) GetFiles() []*File {
	if m != nil {
		return m.Files
	}
	return nil
}

func (m *BackupMeta) GetFileIndex() *MetaFile {
	if m != nil {
		return m.FileIndex
	}
	return nil
}

func (m *BackupMeta) GetStartVersion() uint64 {
	if m != nil {
		return m.StartVersion
	}
	return 0
}

func (m *BackupMeta) GetEndVersion() uint64 {
	if m != nil {
		return m.EndVersion
	}
	return 0
}

func (m *BackupMeta) GetSchemas() []*Schema {
	if m != nil {
		return m.Schemas
	}
	return nil
}

func (m *BackupMeta) GetSchemaIndex() *MetaFile {
	if m != nil {
		return m.SchemaIndex
	}
	return nil
}

func (m *BackupMeta) GetIsRawKv() bool {
	if m != nil {
		return m.IsRawKv
	}
	return false
}

func (m *BackupMeta) GetRawRanges() []*RawRange {
	if m != nil {
		return m.RawRanges
	}
	return nil
}

func (m *BackupMeta) GetRawRangeIndex() *MetaFile {
	if m != nil {
		return m.RawRangeIndex
	}
	return nil
}

func (m *BackupMeta) GetDdls() []byte {
	if m != nil {
		return m.Ddls
	}
	return nil
}

func (m *BackupMeta) GetDdlIndexes() *MetaFile {
	if m != nil {
		return m.DdlIndexes
	}
	return nil
}

type File struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Sha256               []byte   `protobuf:"bytes,2,opt,name=sha256,proto3" json:"sha256,omitempty"`
	StartKey             []byte   `protobuf:"bytes,3,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey               []byte   `protobuf:"bytes,4,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	StartVersion         uint64   `protobuf:"varint,5,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	EndVersion           uint64   `protobuf:"varint,6,opt,name=end_version,json=endVersion,proto3" json:"end_version,omitempty"`
	Crc64Xor             uint64   `protobuf:"varint,7,opt,name=crc64xor,proto3" json:"crc64xor,omitempty"`
	TotalKvs             uint64   `protobuf:"varint,8,opt,name=total_kvs,json=totalKvs,proto3" json:"total_kvs,omitempty"`
	TotalBytes           uint64   `protobuf:"varint,9,opt,name=total_bytes,json=totalBytes,proto3" json:"total_bytes,omitempty"`
	Cf                   string   `protobuf:"bytes,10,opt,name=cf,proto3" json:"cf,omitempty"`
	Size_                uint64   `protobuf:"varint,11,opt,name=size,proto3" json:"size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *File) Reset()         { *m = File{} }
func (m *File) String() string { return proto.CompactTextString(m) }
func (*File) ProtoMessage()    {}
func (*File) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{1}
}
func (m *File) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *File) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_File.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *File) XXX_Merge(src proto.Message) {
	xxx_messageInfo_File.Merge(dst, src)
}
func (m *File) XXX_Size() int {
	return m.Size()
}
func (m *File) XXX_DiscardUnknown() {
	xxx_messageInfo_File.DiscardUnknown(m)
}

var xxx_messageInfo_File proto.InternalMessageInfo

func (m *File) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *File) GetSha256() []byte {
	if m != nil {
		return m.Sha256
	}
	return nil
}

func (m *File) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *File) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

func (m *File) GetStartVersion() uint64 {
	if m != nil {
		return m.StartVersion
	}
	return 0
}

func (m *File) GetEndVersion() uint64 {
	if m != nil {
		return m.EndVersion
	}
	return 0
}

func (m *File) GetCrc64Xor() uint64 {
	if m != nil {
		return m.Crc64Xor
	}
	return 0
}

func (m *File) GetTotalKvs() uint64 {
	if m != nil {
		return m.TotalKvs
	}
	return 0
}

func (m *File) GetTotalBytes() uint64 {
	if m != nil {
		return m.TotalBytes
	}
	return 0
}

func (m *File) GetCf() string {
	if m != nil {
		return m.Cf
	}
	return ""
}

func (m *File) GetSize_() uint64 {
	if m != nil {
		return m.Size_
	}
	return 0
}

// MetaFile describes a multi-level index of data used in backup.
type MetaFile struct {
	// A set of files that contains a MetaFile.
	// It is used as a multi-level index.
	MetaFiles []*File `protobuf:"bytes,1,rep,name=meta_files,json=metaFiles" json:"meta_files,omitempty"`
	// A set of files that contains user data.
	DataFiles []*File `protobuf:"bytes,2,rep,name=data_files,json=dataFiles" json:"data_files,omitempty"`
	// A set of files that contains Schemas.
	Schemas []*Schema `protobuf:"bytes,3,rep,name=schemas" json:"schemas,omitempty"`
	// A set of files that contains RawRanges.
	RawRanges []*RawRange `protobuf:"bytes,4,rep,name=raw_ranges,json=rawRanges" json:"raw_ranges,omitempty"`
	// A set of files that contains DDLs.
	Ddls                 [][]byte `protobuf:"bytes,5,rep,name=ddls" json:"ddls,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MetaFile) Reset()         { *m = MetaFile{} }
func (m *MetaFile) String() string { return proto.CompactTextString(m) }
func (*MetaFile) ProtoMessage()    {}
func (*MetaFile) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{2}
}
func (m *MetaFile) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MetaFile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MetaFile.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *MetaFile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetaFile.Merge(dst, src)
}
func (m *MetaFile) XXX_Size() int {
	return m.Size()
}
func (m *MetaFile) XXX_DiscardUnknown() {
	xxx_messageInfo_MetaFile.DiscardUnknown(m)
}

var xxx_messageInfo_MetaFile proto.InternalMessageInfo

func (m *MetaFile) GetMetaFiles() []*File {
	if m != nil {
		return m.MetaFiles
	}
	return nil
}

func (m *MetaFile) GetDataFiles() []*File {
	if m != nil {
		return m.DataFiles
	}
	return nil
}

func (m *MetaFile) GetSchemas() []*Schema {
	if m != nil {
		return m.Schemas
	}
	return nil
}

func (m *MetaFile) GetRawRanges() []*RawRange {
	if m != nil {
		return m.RawRanges
	}
	return nil
}

func (m *MetaFile) GetDdls() [][]byte {
	if m != nil {
		return m.Ddls
	}
	return nil
}

type Schema struct {
	Db              []byte `protobuf:"bytes,1,opt,name=db,proto3" json:"db,omitempty"`
	Table           []byte `protobuf:"bytes,2,opt,name=table,proto3" json:"table,omitempty"`
	Crc64Xor        uint64 `protobuf:"varint,3,opt,name=crc64xor,proto3" json:"crc64xor,omitempty"`
	TotalKvs        uint64 `protobuf:"varint,4,opt,name=total_kvs,json=totalKvs,proto3" json:"total_kvs,omitempty"`
	TotalBytes      uint64 `protobuf:"varint,5,opt,name=total_bytes,json=totalBytes,proto3" json:"total_bytes,omitempty"`
	TiflashReplicas uint32 `protobuf:"varint,6,opt,name=tiflash_replicas,json=tiflashReplicas,proto3" json:"tiflash_replicas,omitempty"`
	// stats represents the dump stats for a analyzed table, which generate by DumpStatsToJSON
	// https://github.com/pingcap/tidb/blob/e136429d8dc5d70f43cd3f94179b0b9f47595097/statistics/handle/dump.go#L116
	Stats                []byte   `protobuf:"bytes,7,opt,name=stats,proto3" json:"stats,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Schema) Reset()         { *m = Schema{} }
func (m *Schema) String() string { return proto.CompactTextString(m) }
func (*Schema) ProtoMessage()    {}
func (*Schema) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{3}
}
func (m *Schema) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Schema) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Schema.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Schema) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Schema.Merge(dst, src)
}
func (m *Schema) XXX_Size() int {
	return m.Size()
}
func (m *Schema) XXX_DiscardUnknown() {
	xxx_messageInfo_Schema.DiscardUnknown(m)
}

var xxx_messageInfo_Schema proto.InternalMessageInfo

func (m *Schema) GetDb() []byte {
	if m != nil {
		return m.Db
	}
	return nil
}

func (m *Schema) GetTable() []byte {
	if m != nil {
		return m.Table
	}
	return nil
}

func (m *Schema) GetCrc64Xor() uint64 {
	if m != nil {
		return m.Crc64Xor
	}
	return 0
}

func (m *Schema) GetTotalKvs() uint64 {
	if m != nil {
		return m.TotalKvs
	}
	return 0
}

func (m *Schema) GetTotalBytes() uint64 {
	if m != nil {
		return m.TotalBytes
	}
	return 0
}

func (m *Schema) GetTiflashReplicas() uint32 {
	if m != nil {
		return m.TiflashReplicas
	}
	return 0
}

func (m *Schema) GetStats() []byte {
	if m != nil {
		return m.Stats
	}
	return nil
}

type RawRange struct {
	StartKey             []byte   `protobuf:"bytes,1,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey               []byte   `protobuf:"bytes,2,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	Cf                   string   `protobuf:"bytes,3,opt,name=cf,proto3" json:"cf,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawRange) Reset()         { *m = RawRange{} }
func (m *RawRange) String() string { return proto.CompactTextString(m) }
func (*RawRange) ProtoMessage()    {}
func (*RawRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{4}
}
func (m *RawRange) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RawRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RawRange.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *RawRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawRange.Merge(dst, src)
}
func (m *RawRange) XXX_Size() int {
	return m.Size()
}
func (m *RawRange) XXX_DiscardUnknown() {
	xxx_messageInfo_RawRange.DiscardUnknown(m)
}

var xxx_messageInfo_RawRange proto.InternalMessageInfo

func (m *RawRange) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *RawRange) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

func (m *RawRange) GetCf() string {
	if m != nil {
		return m.Cf
	}
	return ""
}

type ClusterIDError struct {
	Current              uint64   `protobuf:"varint,1,opt,name=current,proto3" json:"current,omitempty"`
	Request              uint64   `protobuf:"varint,2,opt,name=request,proto3" json:"request,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterIDError) Reset()         { *m = ClusterIDError{} }
func (m *ClusterIDError) String() string { return proto.CompactTextString(m) }
func (*ClusterIDError) ProtoMessage()    {}
func (*ClusterIDError) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{5}
}
func (m *ClusterIDError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterIDError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterIDError.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ClusterIDError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterIDError.Merge(dst, src)
}
func (m *ClusterIDError) XXX_Size() int {
	return m.Size()
}
func (m *ClusterIDError) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterIDError.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterIDError proto.InternalMessageInfo

func (m *ClusterIDError) GetCurrent() uint64 {
	if m != nil {
		return m.Current
	}
	return 0
}

func (m *ClusterIDError) GetRequest() uint64 {
	if m != nil {
		return m.Request
	}
	return 0
}

type Error struct {
	Msg string `protobuf:"bytes,1,opt,name=msg,proto3" json:"msg,omitempty"`
	// Types that are valid to be assigned to Detail:
	//	*Error_ClusterIdError
	//	*Error_KvError
	//	*Error_RegionError
	Detail               isError_Detail `protobuf_oneof:"detail"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Error) Reset()         { *m = Error{} }
func (m *Error) String() string { return proto.CompactTextString(m) }
func (*Error) ProtoMessage()    {}
func (*Error) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{6}
}
func (m *Error) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Error) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Error.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Error) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Error.Merge(dst, src)
}
func (m *Error) XXX_Size() int {
	return m.Size()
}
func (m *Error) XXX_DiscardUnknown() {
	xxx_messageInfo_Error.DiscardUnknown(m)
}

var xxx_messageInfo_Error proto.InternalMessageInfo

type isError_Detail interface {
	isError_Detail()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Error_ClusterIdError struct {
	ClusterIdError *ClusterIDError `protobuf:"bytes,3,opt,name=cluster_id_error,json=clusterIdError,oneof"`
}
type Error_KvError struct {
	KvError *kvrpcpb.KeyError `protobuf:"bytes,4,opt,name=kv_error,json=kvError,oneof"`
}
type Error_RegionError struct {
	RegionError *errorpb.Error `protobuf:"bytes,5,opt,name=region_error,json=regionError,oneof"`
}

func (*Error_ClusterIdError) isError_Detail() {}
func (*Error_KvError) isError_Detail()        {}
func (*Error_RegionError) isError_Detail()    {}

func (m *Error) GetDetail() isError_Detail {
	if m != nil {
		return m.Detail
	}
	return nil
}

func (m *Error) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

func (m *Error) GetClusterIdError() *ClusterIDError {
	if x, ok := m.GetDetail().(*Error_ClusterIdError); ok {
		return x.ClusterIdError
	}
	return nil
}

func (m *Error) GetKvError() *kvrpcpb.KeyError {
	if x, ok := m.GetDetail().(*Error_KvError); ok {
		return x.KvError
	}
	return nil
}

func (m *Error) GetRegionError() *errorpb.Error {
	if x, ok := m.GetDetail().(*Error_RegionError); ok {
		return x.RegionError
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Error) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Error_OneofMarshaler, _Error_OneofUnmarshaler, _Error_OneofSizer, []interface{}{
		(*Error_ClusterIdError)(nil),
		(*Error_KvError)(nil),
		(*Error_RegionError)(nil),
	}
}

func _Error_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Error)
	// detail
	switch x := m.Detail.(type) {
	case *Error_ClusterIdError:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClusterIdError); err != nil {
			return err
		}
	case *Error_KvError:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.KvError); err != nil {
			return err
		}
	case *Error_RegionError:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RegionError); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Error.Detail has unexpected type %T", x)
	}
	return nil
}

func _Error_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Error)
	switch tag {
	case 3: // detail.cluster_id_error
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ClusterIDError)
		err := b.DecodeMessage(msg)
		m.Detail = &Error_ClusterIdError{msg}
		return true, err
	case 4: // detail.kv_error
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(kvrpcpb.KeyError)
		err := b.DecodeMessage(msg)
		m.Detail = &Error_KvError{msg}
		return true, err
	case 5: // detail.region_error
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(errorpb.Error)
		err := b.DecodeMessage(msg)
		m.Detail = &Error_RegionError{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Error_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Error)
	// detail
	switch x := m.Detail.(type) {
	case *Error_ClusterIdError:
		s := proto.Size(x.ClusterIdError)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Error_KvError:
		s := proto.Size(x.KvError)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Error_RegionError:
		s := proto.Size(x.RegionError)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type BackupRequest struct {
	ClusterId    uint64 `protobuf:"varint,1,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	StartKey     []byte `protobuf:"bytes,2,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey       []byte `protobuf:"bytes,3,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	StartVersion uint64 `protobuf:"varint,4,opt,name=start_version,json=startVersion,proto3" json:"start_version,omitempty"`
	EndVersion   uint64 `protobuf:"varint,5,opt,name=end_version,json=endVersion,proto3" json:"end_version,omitempty"`
	// The I/O rate limit for backup request.
	RateLimit uint64 `protobuf:"varint,7,opt,name=rate_limit,json=rateLimit,proto3" json:"rate_limit,omitempty"`
	// The concurrency for executing the backup request in every tikv node.
	Concurrency    uint32          `protobuf:"varint,8,opt,name=concurrency,proto3" json:"concurrency,omitempty"`
	StorageBackend *StorageBackend `protobuf:"bytes,9,opt,name=storage_backend,json=storageBackend" json:"storage_backend,omitempty"`
	// If raw kv mode is enabled, `start_version` and `end_version` will be ignored, and `cf`
	// specifies which cf to backup.
	IsRawKv bool   `protobuf:"varint,10,opt,name=is_raw_kv,json=isRawKv,proto3" json:"is_raw_kv,omitempty"`
	Cf      string `protobuf:"bytes,11,opt,name=cf,proto3" json:"cf,omitempty"`
	// algorithm used for compress sst files
	CompressionType CompressionType `protobuf:"varint,12,opt,name=compression_type,json=compressionType,proto3,enum=backup.CompressionType" json:"compression_type,omitempty"`
	// sst compression level, some algorithms support negative compression levels
	CompressionLevel     int32    `protobuf:"varint,13,opt,name=compression_level,json=compressionLevel,proto3" json:"compression_level,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BackupRequest) Reset()         { *m = BackupRequest{} }
func (m *BackupRequest) String() string { return proto.CompactTextString(m) }
func (*BackupRequest) ProtoMessage()    {}
func (*BackupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{7}
}
func (m *BackupRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BackupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BackupRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *BackupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupRequest.Merge(dst, src)
}
func (m *BackupRequest) XXX_Size() int {
	return m.Size()
}
func (m *BackupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BackupRequest proto.InternalMessageInfo

func (m *BackupRequest) GetClusterId() uint64 {
	if m != nil {
		return m.ClusterId
	}
	return 0
}

func (m *BackupRequest) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *BackupRequest) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

func (m *BackupRequest) GetStartVersion() uint64 {
	if m != nil {
		return m.StartVersion
	}
	return 0
}

func (m *BackupRequest) GetEndVersion() uint64 {
	if m != nil {
		return m.EndVersion
	}
	return 0
}

func (m *BackupRequest) GetRateLimit() uint64 {
	if m != nil {
		return m.RateLimit
	}
	return 0
}

func (m *BackupRequest) GetConcurrency() uint32 {
	if m != nil {
		return m.Concurrency
	}
	return 0
}

func (m *BackupRequest) GetStorageBackend() *StorageBackend {
	if m != nil {
		return m.StorageBackend
	}
	return nil
}

func (m *BackupRequest) GetIsRawKv() bool {
	if m != nil {
		return m.IsRawKv
	}
	return false
}

func (m *BackupRequest) GetCf() string {
	if m != nil {
		return m.Cf
	}
	return ""
}

func (m *BackupRequest) GetCompressionType() CompressionType {
	if m != nil {
		return m.CompressionType
	}
	return CompressionType_UNKNOWN
}

func (m *BackupRequest) GetCompressionLevel() int32 {
	if m != nil {
		return m.CompressionLevel
	}
	return 0
}

type StorageBackend struct {
	// Types that are valid to be assigned to Backend:
	//	*StorageBackend_Noop
	//	*StorageBackend_Local
	//	*StorageBackend_S3
	//	*StorageBackend_Gcs
	//	*StorageBackend_CloudDynamic
	Backend              isStorageBackend_Backend `protobuf_oneof:"backend"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *StorageBackend) Reset()         { *m = StorageBackend{} }
func (m *StorageBackend) String() string { return proto.CompactTextString(m) }
func (*StorageBackend) ProtoMessage()    {}
func (*StorageBackend) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{8}
}
func (m *StorageBackend) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StorageBackend) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StorageBackend.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *StorageBackend) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageBackend.Merge(dst, src)
}
func (m *StorageBackend) XXX_Size() int {
	return m.Size()
}
func (m *StorageBackend) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageBackend.DiscardUnknown(m)
}

var xxx_messageInfo_StorageBackend proto.InternalMessageInfo

type isStorageBackend_Backend interface {
	isStorageBackend_Backend()
	MarshalTo([]byte) (int, error)
	Size() int
}

type StorageBackend_Noop struct {
	Noop *Noop `protobuf:"bytes,1,opt,name=noop,oneof"`
}
type StorageBackend_Local struct {
	Local *Local `protobuf:"bytes,2,opt,name=local,oneof"`
}
type StorageBackend_S3 struct {
	S3 *S3 `protobuf:"bytes,3,opt,name=s3,oneof"`
}
type StorageBackend_Gcs struct {
	Gcs *GCS `protobuf:"bytes,4,opt,name=gcs,oneof"`
}
type StorageBackend_CloudDynamic struct {
	CloudDynamic *CloudDynamic `protobuf:"bytes,5,opt,name=cloud_dynamic,json=cloudDynamic,oneof"`
}

func (*StorageBackend_Noop) isStorageBackend_Backend()         {}
func (*StorageBackend_Local) isStorageBackend_Backend()        {}
func (*StorageBackend_S3) isStorageBackend_Backend()           {}
func (*StorageBackend_Gcs) isStorageBackend_Backend()          {}
func (*StorageBackend_CloudDynamic) isStorageBackend_Backend() {}

func (m *StorageBackend) GetBackend() isStorageBackend_Backend {
	if m != nil {
		return m.Backend
	}
	return nil
}

func (m *StorageBackend) GetNoop() *Noop {
	if x, ok := m.GetBackend().(*StorageBackend_Noop); ok {
		return x.Noop
	}
	return nil
}

func (m *StorageBackend) GetLocal() *Local {
	if x, ok := m.GetBackend().(*StorageBackend_Local); ok {
		return x.Local
	}
	return nil
}

func (m *StorageBackend) GetS3() *S3 {
	if x, ok := m.GetBackend().(*StorageBackend_S3); ok {
		return x.S3
	}
	return nil
}

func (m *StorageBackend) GetGcs() *GCS {
	if x, ok := m.GetBackend().(*StorageBackend_Gcs); ok {
		return x.Gcs
	}
	return nil
}

func (m *StorageBackend) GetCloudDynamic() *CloudDynamic {
	if x, ok := m.GetBackend().(*StorageBackend_CloudDynamic); ok {
		return x.CloudDynamic
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StorageBackend) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StorageBackend_OneofMarshaler, _StorageBackend_OneofUnmarshaler, _StorageBackend_OneofSizer, []interface{}{
		(*StorageBackend_Noop)(nil),
		(*StorageBackend_Local)(nil),
		(*StorageBackend_S3)(nil),
		(*StorageBackend_Gcs)(nil),
		(*StorageBackend_CloudDynamic)(nil),
	}
}

func _StorageBackend_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StorageBackend)
	// backend
	switch x := m.Backend.(type) {
	case *StorageBackend_Noop:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Noop); err != nil {
			return err
		}
	case *StorageBackend_Local:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Local); err != nil {
			return err
		}
	case *StorageBackend_S3:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.S3); err != nil {
			return err
		}
	case *StorageBackend_Gcs:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Gcs); err != nil {
			return err
		}
	case *StorageBackend_CloudDynamic:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CloudDynamic); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StorageBackend.Backend has unexpected type %T", x)
	}
	return nil
}

func _StorageBackend_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StorageBackend)
	switch tag {
	case 1: // backend.noop
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Noop)
		err := b.DecodeMessage(msg)
		m.Backend = &StorageBackend_Noop{msg}
		return true, err
	case 2: // backend.local
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Local)
		err := b.DecodeMessage(msg)
		m.Backend = &StorageBackend_Local{msg}
		return true, err
	case 3: // backend.s3
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(S3)
		err := b.DecodeMessage(msg)
		m.Backend = &StorageBackend_S3{msg}
		return true, err
	case 4: // backend.gcs
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GCS)
		err := b.DecodeMessage(msg)
		m.Backend = &StorageBackend_Gcs{msg}
		return true, err
	case 5: // backend.cloud_dynamic
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CloudDynamic)
		err := b.DecodeMessage(msg)
		m.Backend = &StorageBackend_CloudDynamic{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StorageBackend_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StorageBackend)
	// backend
	switch x := m.Backend.(type) {
	case *StorageBackend_Noop:
		s := proto.Size(x.Noop)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StorageBackend_Local:
		s := proto.Size(x.Local)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StorageBackend_S3:
		s := proto.Size(x.S3)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StorageBackend_Gcs:
		s := proto.Size(x.Gcs)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StorageBackend_CloudDynamic:
		s := proto.Size(x.CloudDynamic)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Noop storage backend saves files into void.
type Noop struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Noop) Reset()         { *m = Noop{} }
func (m *Noop) String() string { return proto.CompactTextString(m) }
func (*Noop) ProtoMessage()    {}
func (*Noop) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{9}
}
func (m *Noop) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Noop) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Noop.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Noop) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Noop.Merge(dst, src)
}
func (m *Noop) XXX_Size() int {
	return m.Size()
}
func (m *Noop) XXX_DiscardUnknown() {
	xxx_messageInfo_Noop.DiscardUnknown(m)
}

var xxx_messageInfo_Noop proto.InternalMessageInfo

// Local storage backend saves files into local disk
type Local struct {
	Path                 string   `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Local) Reset()         { *m = Local{} }
func (m *Local) String() string { return proto.CompactTextString(m) }
func (*Local) ProtoMessage()    {}
func (*Local) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{10}
}
func (m *Local) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Local) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Local.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Local) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Local.Merge(dst, src)
}
func (m *Local) XXX_Size() int {
	return m.Size()
}
func (m *Local) XXX_DiscardUnknown() {
	xxx_messageInfo_Local.DiscardUnknown(m)
}

var xxx_messageInfo_Local proto.InternalMessageInfo

func (m *Local) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// S3 storage backend saves files into S3 compatible storages
// For non-aws providers, endpoint must be provided
type S3 struct {
	Endpoint     string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	Region       string `protobuf:"bytes,2,opt,name=region,proto3" json:"region,omitempty"`
	Bucket       string `protobuf:"bytes,3,opt,name=bucket,proto3" json:"bucket,omitempty"`
	Prefix       string `protobuf:"bytes,4,opt,name=prefix,proto3" json:"prefix,omitempty"`
	StorageClass string `protobuf:"bytes,5,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	// server side encryption
	Sse                  string   `protobuf:"bytes,6,opt,name=sse,proto3" json:"sse,omitempty"`
	Acl                  string   `protobuf:"bytes,7,opt,name=acl,proto3" json:"acl,omitempty"`
	AccessKey            string   `protobuf:"bytes,8,opt,name=access_key,json=accessKey,proto3" json:"access_key,omitempty"`
	SecretAccessKey      string   `protobuf:"bytes,9,opt,name=secret_access_key,json=secretAccessKey,proto3" json:"secret_access_key,omitempty"`
	ForcePathStyle       bool     `protobuf:"varint,10,opt,name=force_path_style,json=forcePathStyle,proto3" json:"force_path_style,omitempty"`
	SseKmsKeyId          string   `protobuf:"bytes,11,opt,name=sse_kms_key_id,json=sseKmsKeyId,proto3" json:"sse_kms_key_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *S3) Reset()         { *m = S3{} }
func (m *S3) String() string { return proto.CompactTextString(m) }
func (*S3) ProtoMessage()    {}
func (*S3) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{11}
}
func (m *S3) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *S3) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_S3.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *S3) XXX_Merge(src proto.Message) {
	xxx_messageInfo_S3.Merge(dst, src)
}
func (m *S3) XXX_Size() int {
	return m.Size()
}
func (m *S3) XXX_DiscardUnknown() {
	xxx_messageInfo_S3.DiscardUnknown(m)
}

var xxx_messageInfo_S3 proto.InternalMessageInfo

func (m *S3) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *S3) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *S3) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *S3) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *S3) GetStorageClass() string {
	if m != nil {
		return m.StorageClass
	}
	return ""
}

func (m *S3) GetSse() string {
	if m != nil {
		return m.Sse
	}
	return ""
}

func (m *S3) GetAcl() string {
	if m != nil {
		return m.Acl
	}
	return ""
}

func (m *S3) GetAccessKey() string {
	if m != nil {
		return m.AccessKey
	}
	return ""
}

func (m *S3) GetSecretAccessKey() string {
	if m != nil {
		return m.SecretAccessKey
	}
	return ""
}

func (m *S3) GetForcePathStyle() bool {
	if m != nil {
		return m.ForcePathStyle
	}
	return false
}

func (m *S3) GetSseKmsKeyId() string {
	if m != nil {
		return m.SseKmsKeyId
	}
	return ""
}

// GCS storage backend saves files into google cloud storage.
type GCS struct {
	Endpoint     string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	Bucket       string `protobuf:"bytes,2,opt,name=bucket,proto3" json:"bucket,omitempty"`
	Prefix       string `protobuf:"bytes,3,opt,name=prefix,proto3" json:"prefix,omitempty"`
	StorageClass string `protobuf:"bytes,4,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	// If not empty, applies a predefined set of access controls.
	// See https://cloud.google.com/storage/docs/access-control/lists#predefined-acl
	// for valid values.
	PredefinedAcl string `protobuf:"bytes,5,opt,name=predefined_acl,json=predefinedAcl,proto3" json:"predefined_acl,omitempty"`
	// Service Account Credentials JSON blob
	// You can get one from https://console.cloud.google.com/apis/credentials, and
	// copy the content, set it as string here.
	CredentialsBlob      string   `protobuf:"bytes,6,opt,name=credentials_blob,json=credentialsBlob,proto3" json:"credentials_blob,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GCS) Reset()         { *m = GCS{} }
func (m *GCS) String() string { return proto.CompactTextString(m) }
func (*GCS) ProtoMessage()    {}
func (*GCS) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{12}
}
func (m *GCS) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GCS) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GCS.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *GCS) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GCS.Merge(dst, src)
}
func (m *GCS) XXX_Size() int {
	return m.Size()
}
func (m *GCS) XXX_DiscardUnknown() {
	xxx_messageInfo_GCS.DiscardUnknown(m)
}

var xxx_messageInfo_GCS proto.InternalMessageInfo

func (m *GCS) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *GCS) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *GCS) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *GCS) GetStorageClass() string {
	if m != nil {
		return m.StorageClass
	}
	return ""
}

func (m *GCS) GetPredefinedAcl() string {
	if m != nil {
		return m.PredefinedAcl
	}
	return ""
}

func (m *GCS) GetCredentialsBlob() string {
	if m != nil {
		return m.CredentialsBlob
	}
	return ""
}

type Bucket struct {
	Endpoint             string   `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	Region               string   `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	Bucket               string   `protobuf:"bytes,4,opt,name=bucket,proto3" json:"bucket,omitempty"`
	Prefix               string   `protobuf:"bytes,5,opt,name=prefix,proto3" json:"prefix,omitempty"`
	StorageClass         string   `protobuf:"bytes,6,opt,name=storage_class,json=storageClass,proto3" json:"storage_class,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Bucket) Reset()         { *m = Bucket{} }
func (m *Bucket) String() string { return proto.CompactTextString(m) }
func (*Bucket) ProtoMessage()    {}
func (*Bucket) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{13}
}
func (m *Bucket) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Bucket) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Bucket.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Bucket) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bucket.Merge(dst, src)
}
func (m *Bucket) XXX_Size() int {
	return m.Size()
}
func (m *Bucket) XXX_DiscardUnknown() {
	xxx_messageInfo_Bucket.DiscardUnknown(m)
}

var xxx_messageInfo_Bucket proto.InternalMessageInfo

func (m *Bucket) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *Bucket) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *Bucket) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *Bucket) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *Bucket) GetStorageClass() string {
	if m != nil {
		return m.StorageClass
	}
	return ""
}

// CloudDynamic allows testing new cloud providers and new fields without changing protobuf definitions
type CloudDynamic struct {
	Bucket               *Bucket           `protobuf:"bytes,1,opt,name=bucket" json:"bucket,omitempty"`
	ProviderName         string            `protobuf:"bytes,2,opt,name=provider_name,json=providerName,proto3" json:"provider_name,omitempty"`
	Attrs                map[string]string `protobuf:"bytes,3,rep,name=attrs" json:"attrs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CloudDynamic) Reset()         { *m = CloudDynamic{} }
func (m *CloudDynamic) String() string { return proto.CompactTextString(m) }
func (*CloudDynamic) ProtoMessage()    {}
func (*CloudDynamic) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{14}
}
func (m *CloudDynamic) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CloudDynamic) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CloudDynamic.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *CloudDynamic) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudDynamic.Merge(dst, src)
}
func (m *CloudDynamic) XXX_Size() int {
	return m.Size()
}
func (m *CloudDynamic) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudDynamic.DiscardUnknown(m)
}

var xxx_messageInfo_CloudDynamic proto.InternalMessageInfo

func (m *CloudDynamic) GetBucket() *Bucket {
	if m != nil {
		return m.Bucket
	}
	return nil
}

func (m *CloudDynamic) GetProviderName() string {
	if m != nil {
		return m.ProviderName
	}
	return ""
}

func (m *CloudDynamic) GetAttrs() map[string]string {
	if m != nil {
		return m.Attrs
	}
	return nil
}

type BackupResponse struct {
	Error                *Error   `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	StartKey             []byte   `protobuf:"bytes,2,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	EndKey               []byte   `protobuf:"bytes,3,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
	Files                []*File  `protobuf:"bytes,4,rep,name=files" json:"files,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BackupResponse) Reset()         { *m = BackupResponse{} }
func (m *BackupResponse) String() string { return proto.CompactTextString(m) }
func (*BackupResponse) ProtoMessage()    {}
func (*BackupResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{15}
}
func (m *BackupResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BackupResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BackupResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *BackupResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BackupResponse.Merge(dst, src)
}
func (m *BackupResponse) XXX_Size() int {
	return m.Size()
}
func (m *BackupResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BackupResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BackupResponse proto.InternalMessageInfo

func (m *BackupResponse) GetError() *Error {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *BackupResponse) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *BackupResponse) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

func (m *BackupResponse) GetFiles() []*File {
	if m != nil {
		return m.Files
	}
	return nil
}

type ExternalStorageRestoreRequest struct {
	StorageBackend       *StorageBackend `protobuf:"bytes,1,opt,name=storage_backend,json=storageBackend" json:"storage_backend,omitempty"`
	ObjectName           string          `protobuf:"bytes,2,opt,name=object_name,json=objectName,proto3" json:"object_name,omitempty"`
	RestoreName          string          `protobuf:"bytes,3,opt,name=restore_name,json=restoreName,proto3" json:"restore_name,omitempty"`
	ContentLength        uint64          `protobuf:"varint,4,opt,name=content_length,json=contentLength,proto3" json:"content_length,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ExternalStorageRestoreRequest) Reset()         { *m = ExternalStorageRestoreRequest{} }
func (m *ExternalStorageRestoreRequest) String() string { return proto.CompactTextString(m) }
func (*ExternalStorageRestoreRequest) ProtoMessage()    {}
func (*ExternalStorageRestoreRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{16}
}
func (m *ExternalStorageRestoreRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExternalStorageRestoreRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExternalStorageRestoreRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ExternalStorageRestoreRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalStorageRestoreRequest.Merge(dst, src)
}
func (m *ExternalStorageRestoreRequest) XXX_Size() int {
	return m.Size()
}
func (m *ExternalStorageRestoreRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalStorageRestoreRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalStorageRestoreRequest proto.InternalMessageInfo

func (m *ExternalStorageRestoreRequest) GetStorageBackend() *StorageBackend {
	if m != nil {
		return m.StorageBackend
	}
	return nil
}

func (m *ExternalStorageRestoreRequest) GetObjectName() string {
	if m != nil {
		return m.ObjectName
	}
	return ""
}

func (m *ExternalStorageRestoreRequest) GetRestoreName() string {
	if m != nil {
		return m.RestoreName
	}
	return ""
}

func (m *ExternalStorageRestoreRequest) GetContentLength() uint64 {
	if m != nil {
		return m.ContentLength
	}
	return 0
}

type ExternalStorageRestoreResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExternalStorageRestoreResponse) Reset()         { *m = ExternalStorageRestoreResponse{} }
func (m *ExternalStorageRestoreResponse) String() string { return proto.CompactTextString(m) }
func (*ExternalStorageRestoreResponse) ProtoMessage()    {}
func (*ExternalStorageRestoreResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{17}
}
func (m *ExternalStorageRestoreResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExternalStorageRestoreResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExternalStorageRestoreResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ExternalStorageRestoreResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalStorageRestoreResponse.Merge(dst, src)
}
func (m *ExternalStorageRestoreResponse) XXX_Size() int {
	return m.Size()
}
func (m *ExternalStorageRestoreResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalStorageRestoreResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalStorageRestoreResponse proto.InternalMessageInfo

type ExternalStorageSaveRequest struct {
	StorageBackend       *StorageBackend `protobuf:"bytes,1,opt,name=storage_backend,json=storageBackend" json:"storage_backend,omitempty"`
	ObjectName           string          `protobuf:"bytes,2,opt,name=object_name,json=objectName,proto3" json:"object_name,omitempty"`
	ContentLength        uint64          `protobuf:"varint,3,opt,name=content_length,json=contentLength,proto3" json:"content_length,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ExternalStorageSaveRequest) Reset()         { *m = ExternalStorageSaveRequest{} }
func (m *ExternalStorageSaveRequest) String() string { return proto.CompactTextString(m) }
func (*ExternalStorageSaveRequest) ProtoMessage()    {}
func (*ExternalStorageSaveRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{18}
}
func (m *ExternalStorageSaveRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExternalStorageSaveRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExternalStorageSaveRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ExternalStorageSaveRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalStorageSaveRequest.Merge(dst, src)
}
func (m *ExternalStorageSaveRequest) XXX_Size() int {
	return m.Size()
}
func (m *ExternalStorageSaveRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalStorageSaveRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalStorageSaveRequest proto.InternalMessageInfo

func (m *ExternalStorageSaveRequest) GetStorageBackend() *StorageBackend {
	if m != nil {
		return m.StorageBackend
	}
	return nil
}

func (m *ExternalStorageSaveRequest) GetObjectName() string {
	if m != nil {
		return m.ObjectName
	}
	return ""
}

func (m *ExternalStorageSaveRequest) GetContentLength() uint64 {
	if m != nil {
		return m.ContentLength
	}
	return 0
}

type ExternalStorageSaveResponse struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExternalStorageSaveResponse) Reset()         { *m = ExternalStorageSaveResponse{} }
func (m *ExternalStorageSaveResponse) String() string { return proto.CompactTextString(m) }
func (*ExternalStorageSaveResponse) ProtoMessage()    {}
func (*ExternalStorageSaveResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_backup_c0317208fdb49464, []int{19}
}
func (m *ExternalStorageSaveResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExternalStorageSaveResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExternalStorageSaveResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ExternalStorageSaveResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalStorageSaveResponse.Merge(dst, src)
}
func (m *ExternalStorageSaveResponse) XXX_Size() int {
	return m.Size()
}
func (m *ExternalStorageSaveResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalStorageSaveResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalStorageSaveResponse proto.InternalMessageInfo

func init() {
	proto.RegisterType((*BackupMeta)(nil), "backup.BackupMeta")
	proto.RegisterType((*File)(nil), "backup.File")
	proto.RegisterType((*MetaFile)(nil), "backup.MetaFile")
	proto.RegisterType((*Schema)(nil), "backup.Schema")
	proto.RegisterType((*RawRange)(nil), "backup.RawRange")
	proto.RegisterType((*ClusterIDError)(nil), "backup.ClusterIDError")
	proto.RegisterType((*Error)(nil), "backup.Error")
	proto.RegisterType((*BackupRequest)(nil), "backup.BackupRequest")
	proto.RegisterType((*StorageBackend)(nil), "backup.StorageBackend")
	proto.RegisterType((*Noop)(nil), "backup.Noop")
	proto.RegisterType((*Local)(nil), "backup.Local")
	proto.RegisterType((*S3)(nil), "backup.S3")
	proto.RegisterType((*GCS)(nil), "backup.GCS")
	proto.RegisterType((*Bucket)(nil), "backup.Bucket")
	proto.RegisterType((*CloudDynamic)(nil), "backup.CloudDynamic")
	proto.RegisterMapType((map[string]string)(nil), "backup.CloudDynamic.AttrsEntry")
	proto.RegisterType((*BackupResponse)(nil), "backup.BackupResponse")
	proto.RegisterType((*ExternalStorageRestoreRequest)(nil), "backup.ExternalStorageRestoreRequest")
	proto.RegisterType((*ExternalStorageRestoreResponse)(nil), "backup.ExternalStorageRestoreResponse")
	proto.RegisterType((*ExternalStorageSaveRequest)(nil), "backup.ExternalStorageSaveRequest")
	proto.RegisterType((*ExternalStorageSaveResponse)(nil), "backup.ExternalStorageSaveResponse")
	proto.RegisterEnum("backup.CompressionType", CompressionType_name, CompressionType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Backup service

type BackupClient interface {
	Backup(ctx context.Context, in *BackupRequest, opts ...grpc.CallOption) (Backup_BackupClient, error)
}

type backupClient struct {
	cc *grpc.ClientConn
}

func NewBackupClient(cc *grpc.ClientConn) BackupClient {
	return &backupClient{cc}
}

func (c *backupClient) Backup(ctx context.Context, in *BackupRequest, opts ...grpc.CallOption) (Backup_BackupClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Backup_serviceDesc.Streams[0], "/backup.Backup/backup", opts...)
	if err != nil {
		return nil, err
	}
	x := &backupBackupClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Backup_BackupClient interface {
	Recv() (*BackupResponse, error)
	grpc.ClientStream
}

type backupBackupClient struct {
	grpc.ClientStream
}

func (x *backupBackupClient) Recv() (*BackupResponse, error) {
	m := new(BackupResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for Backup service

type BackupServer interface {
	Backup(*BackupRequest, Backup_BackupServer) error
}

func RegisterBackupServer(s *grpc.Server, srv BackupServer) {
	s.RegisterService(&_Backup_serviceDesc, srv)
}

func _Backup_Backup_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(BackupRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BackupServer).Backup(m, &backupBackupServer{stream})
}

type Backup_BackupServer interface {
	Send(*BackupResponse) error
	grpc.ServerStream
}

type backupBackupServer struct {
	grpc.ServerStream
}

func (x *backupBackupServer) Send(m *BackupResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _Backup_serviceDesc = grpc.ServiceDesc{
	ServiceName: "backup.Backup",
	HandlerType: (*BackupServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "backup",
			Handler:       _Backup_Backup_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "backup.proto",
}

// Client API for ExternalStorage service

type ExternalStorageClient interface {
	// Restore to a file
	Restore(ctx context.Context, in *ExternalStorageRestoreRequest, opts ...grpc.CallOption) (*ExternalStorageRestoreResponse, error)
	// Save a file to storage
	Save(ctx context.Context, in *ExternalStorageSaveRequest, opts ...grpc.CallOption) (*ExternalStorageSaveResponse, error)
}

type externalStorageClient struct {
	cc *grpc.ClientConn
}

func NewExternalStorageClient(cc *grpc.ClientConn) ExternalStorageClient {
	return &externalStorageClient{cc}
}

func (c *externalStorageClient) Restore(ctx context.Context, in *ExternalStorageRestoreRequest, opts ...grpc.CallOption) (*ExternalStorageRestoreResponse, error) {
	out := new(ExternalStorageRestoreResponse)
	err := c.cc.Invoke(ctx, "/backup.ExternalStorage/restore", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *externalStorageClient) Save(ctx context.Context, in *ExternalStorageSaveRequest, opts ...grpc.CallOption) (*ExternalStorageSaveResponse, error) {
	out := new(ExternalStorageSaveResponse)
	err := c.cc.Invoke(ctx, "/backup.ExternalStorage/save", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ExternalStorage service

type ExternalStorageServer interface {
	// Restore to a file
	Restore(context.Context, *ExternalStorageRestoreRequest) (*ExternalStorageRestoreResponse, error)
	// Save a file to storage
	Save(context.Context, *ExternalStorageSaveRequest) (*ExternalStorageSaveResponse, error)
}

func RegisterExternalStorageServer(s *grpc.Server, srv ExternalStorageServer) {
	s.RegisterService(&_ExternalStorage_serviceDesc, srv)
}

func _ExternalStorage_Restore_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExternalStorageRestoreRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalStorageServer).Restore(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/backup.ExternalStorage/Restore",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalStorageServer).Restore(ctx, req.(*ExternalStorageRestoreRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExternalStorage_Save_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExternalStorageSaveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalStorageServer).Save(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/backup.ExternalStorage/Save",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalStorageServer).Save(ctx, req.(*ExternalStorageSaveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ExternalStorage_serviceDesc = grpc.ServiceDesc{
	ServiceName: "backup.ExternalStorage",
	HandlerType: (*ExternalStorageServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "restore",
			Handler:    _ExternalStorage_Restore_Handler,
		},
		{
			MethodName: "save",
			Handler:    _ExternalStorage_Save_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "backup.proto",
}

func (m *BackupMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupMeta) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ClusterId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.ClusterId))
	}
	if len(m.ClusterVersion) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.ClusterVersion)))
		i += copy(dAtA[i:], m.ClusterVersion)
	}
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			dAtA[i] = 0x22
			i++
			i = encodeVarintBackup(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.StartVersion != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.StartVersion))
	}
	if m.EndVersion != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.EndVersion))
	}
	if len(m.Schemas) > 0 {
		for _, msg := range m.Schemas {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintBackup(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.IsRawKv {
		dAtA[i] = 0x40
		i++
		if m.IsRawKv {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.RawRanges) > 0 {
		for _, msg := range m.RawRanges {
			dAtA[i] = 0x4a
			i++
			i = encodeVarintBackup(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Ddls) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Ddls)))
		i += copy(dAtA[i:], m.Ddls)
	}
	if len(m.BrVersion) > 0 {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.BrVersion)))
		i += copy(dAtA[i:], m.BrVersion)
	}
	if m.Version != 0 {
		dAtA[i] = 0x60
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Version))
	}
	if m.FileIndex != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.FileIndex.Size()))
		n1, err := m.FileIndex.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.SchemaIndex != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.SchemaIndex.Size()))
		n2, err := m.SchemaIndex.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.RawRangeIndex != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.RawRangeIndex.Size()))
		n3, err := m.RawRangeIndex.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.DdlIndexes != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.DdlIndexes.Size()))
		n4, err := m.DdlIndexes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *File) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *File) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Sha256) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Sha256)))
		i += copy(dAtA[i:], m.Sha256)
	}
	if len(m.StartKey) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	if m.StartVersion != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.StartVersion))
	}
	if m.EndVersion != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.EndVersion))
	}
	if m.Crc64Xor != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Crc64Xor))
	}
	if m.TotalKvs != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.TotalKvs))
	}
	if m.TotalBytes != 0 {
		dAtA[i] = 0x48
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.TotalBytes))
	}
	if len(m.Cf) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Cf)))
		i += copy(dAtA[i:], m.Cf)
	}
	if m.Size_ != 0 {
		dAtA[i] = 0x58
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Size_))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *MetaFile) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetaFile) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.MetaFiles) > 0 {
		for _, msg := range m.MetaFiles {
			dAtA[i] = 0xa
			i++
			i = encodeVarintBackup(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.DataFiles) > 0 {
		for _, msg := range m.DataFiles {
			dAtA[i] = 0x12
			i++
			i = encodeVarintBackup(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Schemas) > 0 {
		for _, msg := range m.Schemas {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintBackup(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RawRanges) > 0 {
		for _, msg := range m.RawRanges {
			dAtA[i] = 0x22
			i++
			i = encodeVarintBackup(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Ddls) > 0 {
		for _, b := range m.Ddls {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintBackup(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Schema) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Schema) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Db) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Db)))
		i += copy(dAtA[i:], m.Db)
	}
	if len(m.Table) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Table)))
		i += copy(dAtA[i:], m.Table)
	}
	if m.Crc64Xor != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Crc64Xor))
	}
	if m.TotalKvs != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.TotalKvs))
	}
	if m.TotalBytes != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.TotalBytes))
	}
	if m.TiflashReplicas != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.TiflashReplicas))
	}
	if len(m.Stats) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Stats)))
		i += copy(dAtA[i:], m.Stats)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RawRange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RawRange) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.StartKey) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	if len(m.Cf) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Cf)))
		i += copy(dAtA[i:], m.Cf)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ClusterIDError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterIDError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Current != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Current))
	}
	if m.Request != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Request))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Error) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Error) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Msg) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Msg)))
		i += copy(dAtA[i:], m.Msg)
	}
	if m.Detail != nil {
		nn5, err := m.Detail.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn5
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Error_ClusterIdError) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ClusterIdError != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.ClusterIdError.Size()))
		n6, err := m.ClusterIdError.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}
func (m *Error_KvError) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.KvError != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.KvError.Size()))
		n7, err := m.KvError.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}
func (m *Error_RegionError) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RegionError != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.RegionError.Size()))
		n8, err := m.RegionError.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}
func (m *BackupRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ClusterId != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.ClusterId))
	}
	if len(m.StartKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	if m.StartVersion != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.StartVersion))
	}
	if m.EndVersion != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.EndVersion))
	}
	if m.RateLimit != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.RateLimit))
	}
	if m.Concurrency != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Concurrency))
	}
	if m.StorageBackend != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.StorageBackend.Size()))
		n9, err := m.StorageBackend.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.IsRawKv {
		dAtA[i] = 0x50
		i++
		if m.IsRawKv {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Cf) > 0 {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Cf)))
		i += copy(dAtA[i:], m.Cf)
	}
	if m.CompressionType != 0 {
		dAtA[i] = 0x60
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.CompressionType))
	}
	if m.CompressionLevel != 0 {
		dAtA[i] = 0x68
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.CompressionLevel))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *StorageBackend) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StorageBackend) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Backend != nil {
		nn10, err := m.Backend.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn10
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *StorageBackend_Noop) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Noop != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Noop.Size()))
		n11, err := m.Noop.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}
func (m *StorageBackend_Local) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Local != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Local.Size()))
		n12, err := m.Local.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}
func (m *StorageBackend_S3) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.S3 != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.S3.Size()))
		n13, err := m.S3.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}
func (m *StorageBackend_Gcs) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Gcs != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Gcs.Size()))
		n14, err := m.Gcs.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	return i, nil
}
func (m *StorageBackend_CloudDynamic) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.CloudDynamic != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.CloudDynamic.Size()))
		n15, err := m.CloudDynamic.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}
func (m *Noop) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Noop) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Local) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Local) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Path) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *S3) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *S3) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Endpoint) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Endpoint)))
		i += copy(dAtA[i:], m.Endpoint)
	}
	if len(m.Region) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Region)))
		i += copy(dAtA[i:], m.Region)
	}
	if len(m.Bucket) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Bucket)))
		i += copy(dAtA[i:], m.Bucket)
	}
	if len(m.Prefix) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Prefix)))
		i += copy(dAtA[i:], m.Prefix)
	}
	if len(m.StorageClass) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.StorageClass)))
		i += copy(dAtA[i:], m.StorageClass)
	}
	if len(m.Sse) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Sse)))
		i += copy(dAtA[i:], m.Sse)
	}
	if len(m.Acl) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Acl)))
		i += copy(dAtA[i:], m.Acl)
	}
	if len(m.AccessKey) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.AccessKey)))
		i += copy(dAtA[i:], m.AccessKey)
	}
	if len(m.SecretAccessKey) > 0 {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.SecretAccessKey)))
		i += copy(dAtA[i:], m.SecretAccessKey)
	}
	if m.ForcePathStyle {
		dAtA[i] = 0x50
		i++
		if m.ForcePathStyle {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.SseKmsKeyId) > 0 {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.SseKmsKeyId)))
		i += copy(dAtA[i:], m.SseKmsKeyId)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *GCS) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCS) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Endpoint) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Endpoint)))
		i += copy(dAtA[i:], m.Endpoint)
	}
	if len(m.Bucket) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Bucket)))
		i += copy(dAtA[i:], m.Bucket)
	}
	if len(m.Prefix) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Prefix)))
		i += copy(dAtA[i:], m.Prefix)
	}
	if len(m.StorageClass) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.StorageClass)))
		i += copy(dAtA[i:], m.StorageClass)
	}
	if len(m.PredefinedAcl) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.PredefinedAcl)))
		i += copy(dAtA[i:], m.PredefinedAcl)
	}
	if len(m.CredentialsBlob) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.CredentialsBlob)))
		i += copy(dAtA[i:], m.CredentialsBlob)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Bucket) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Bucket) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Endpoint) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Endpoint)))
		i += copy(dAtA[i:], m.Endpoint)
	}
	if len(m.Region) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Region)))
		i += copy(dAtA[i:], m.Region)
	}
	if len(m.Bucket) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Bucket)))
		i += copy(dAtA[i:], m.Bucket)
	}
	if len(m.Prefix) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Prefix)))
		i += copy(dAtA[i:], m.Prefix)
	}
	if len(m.StorageClass) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.StorageClass)))
		i += copy(dAtA[i:], m.StorageClass)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CloudDynamic) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CloudDynamic) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Bucket != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Bucket.Size()))
		n16, err := m.Bucket.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if len(m.ProviderName) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.ProviderName)))
		i += copy(dAtA[i:], m.ProviderName)
	}
	if len(m.Attrs) > 0 {
		for k, _ := range m.Attrs {
			dAtA[i] = 0x1a
			i++
			v := m.Attrs[k]
			mapSize := 1 + len(k) + sovBackup(uint64(len(k))) + 1 + len(v) + sovBackup(uint64(len(v)))
			i = encodeVarintBackup(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintBackup(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintBackup(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *BackupResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Error != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.Error.Size()))
		n17, err := m.Error.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if len(m.StartKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			dAtA[i] = 0x22
			i++
			i = encodeVarintBackup(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ExternalStorageRestoreRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExternalStorageRestoreRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.StorageBackend != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.StorageBackend.Size()))
		n18, err := m.StorageBackend.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if len(m.ObjectName) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.ObjectName)))
		i += copy(dAtA[i:], m.ObjectName)
	}
	if len(m.RestoreName) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.RestoreName)))
		i += copy(dAtA[i:], m.RestoreName)
	}
	if m.ContentLength != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.ContentLength))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ExternalStorageRestoreResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExternalStorageRestoreResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ExternalStorageSaveRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExternalStorageSaveRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.StorageBackend != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.StorageBackend.Size()))
		n19, err := m.StorageBackend.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if len(m.ObjectName) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.ObjectName)))
		i += copy(dAtA[i:], m.ObjectName)
	}
	if m.ContentLength != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.ContentLength))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ExternalStorageSaveResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExternalStorageSaveResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintBackup(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *BackupMeta) Size() (n int) {
	var l int
	_ = l
	if m.ClusterId != 0 {
		n += 1 + sovBackup(uint64(m.ClusterId))
	}
	l = len(m.ClusterVersion)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovBackup(uint64(l))
		}
	}
	if m.StartVersion != 0 {
		n += 1 + sovBackup(uint64(m.StartVersion))
	}
	if m.EndVersion != 0 {
		n += 1 + sovBackup(uint64(m.EndVersion))
	}
	if len(m.Schemas) > 0 {
		for _, e := range m.Schemas {
			l = e.Size()
			n += 1 + l + sovBackup(uint64(l))
		}
	}
	if m.IsRawKv {
		n += 2
	}
	if len(m.RawRanges) > 0 {
		for _, e := range m.RawRanges {
			l = e.Size()
			n += 1 + l + sovBackup(uint64(l))
		}
	}
	l = len(m.Ddls)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.BrVersion)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.Version != 0 {
		n += 1 + sovBackup(uint64(m.Version))
	}
	if m.FileIndex != nil {
		l = m.FileIndex.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.SchemaIndex != nil {
		l = m.SchemaIndex.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.RawRangeIndex != nil {
		l = m.RawRangeIndex.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.DdlIndexes != nil {
		l = m.DdlIndexes.Size()
		n += 2 + l + sovBackup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *File) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Sha256)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.StartVersion != 0 {
		n += 1 + sovBackup(uint64(m.StartVersion))
	}
	if m.EndVersion != 0 {
		n += 1 + sovBackup(uint64(m.EndVersion))
	}
	if m.Crc64Xor != 0 {
		n += 1 + sovBackup(uint64(m.Crc64Xor))
	}
	if m.TotalKvs != 0 {
		n += 1 + sovBackup(uint64(m.TotalKvs))
	}
	if m.TotalBytes != 0 {
		n += 1 + sovBackup(uint64(m.TotalBytes))
	}
	l = len(m.Cf)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.Size_ != 0 {
		n += 1 + sovBackup(uint64(m.Size_))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MetaFile) Size() (n int) {
	var l int
	_ = l
	if len(m.MetaFiles) > 0 {
		for _, e := range m.MetaFiles {
			l = e.Size()
			n += 1 + l + sovBackup(uint64(l))
		}
	}
	if len(m.DataFiles) > 0 {
		for _, e := range m.DataFiles {
			l = e.Size()
			n += 1 + l + sovBackup(uint64(l))
		}
	}
	if len(m.Schemas) > 0 {
		for _, e := range m.Schemas {
			l = e.Size()
			n += 1 + l + sovBackup(uint64(l))
		}
	}
	if len(m.RawRanges) > 0 {
		for _, e := range m.RawRanges {
			l = e.Size()
			n += 1 + l + sovBackup(uint64(l))
		}
	}
	if len(m.Ddls) > 0 {
		for _, b := range m.Ddls {
			l = len(b)
			n += 1 + l + sovBackup(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Schema) Size() (n int) {
	var l int
	_ = l
	l = len(m.Db)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Table)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.Crc64Xor != 0 {
		n += 1 + sovBackup(uint64(m.Crc64Xor))
	}
	if m.TotalKvs != 0 {
		n += 1 + sovBackup(uint64(m.TotalKvs))
	}
	if m.TotalBytes != 0 {
		n += 1 + sovBackup(uint64(m.TotalBytes))
	}
	if m.TiflashReplicas != 0 {
		n += 1 + sovBackup(uint64(m.TiflashReplicas))
	}
	l = len(m.Stats)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RawRange) Size() (n int) {
	var l int
	_ = l
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Cf)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ClusterIDError) Size() (n int) {
	var l int
	_ = l
	if m.Current != 0 {
		n += 1 + sovBackup(uint64(m.Current))
	}
	if m.Request != 0 {
		n += 1 + sovBackup(uint64(m.Request))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Error) Size() (n int) {
	var l int
	_ = l
	l = len(m.Msg)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.Detail != nil {
		n += m.Detail.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Error_ClusterIdError) Size() (n int) {
	var l int
	_ = l
	if m.ClusterIdError != nil {
		l = m.ClusterIdError.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	return n
}
func (m *Error_KvError) Size() (n int) {
	var l int
	_ = l
	if m.KvError != nil {
		l = m.KvError.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	return n
}
func (m *Error_RegionError) Size() (n int) {
	var l int
	_ = l
	if m.RegionError != nil {
		l = m.RegionError.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	return n
}
func (m *BackupRequest) Size() (n int) {
	var l int
	_ = l
	if m.ClusterId != 0 {
		n += 1 + sovBackup(uint64(m.ClusterId))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.StartVersion != 0 {
		n += 1 + sovBackup(uint64(m.StartVersion))
	}
	if m.EndVersion != 0 {
		n += 1 + sovBackup(uint64(m.EndVersion))
	}
	if m.RateLimit != 0 {
		n += 1 + sovBackup(uint64(m.RateLimit))
	}
	if m.Concurrency != 0 {
		n += 1 + sovBackup(uint64(m.Concurrency))
	}
	if m.StorageBackend != nil {
		l = m.StorageBackend.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.IsRawKv {
		n += 2
	}
	l = len(m.Cf)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.CompressionType != 0 {
		n += 1 + sovBackup(uint64(m.CompressionType))
	}
	if m.CompressionLevel != 0 {
		n += 1 + sovBackup(uint64(m.CompressionLevel))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StorageBackend) Size() (n int) {
	var l int
	_ = l
	if m.Backend != nil {
		n += m.Backend.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StorageBackend_Noop) Size() (n int) {
	var l int
	_ = l
	if m.Noop != nil {
		l = m.Noop.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	return n
}
func (m *StorageBackend_Local) Size() (n int) {
	var l int
	_ = l
	if m.Local != nil {
		l = m.Local.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	return n
}
func (m *StorageBackend_S3) Size() (n int) {
	var l int
	_ = l
	if m.S3 != nil {
		l = m.S3.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	return n
}
func (m *StorageBackend_Gcs) Size() (n int) {
	var l int
	_ = l
	if m.Gcs != nil {
		l = m.Gcs.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	return n
}
func (m *StorageBackend_CloudDynamic) Size() (n int) {
	var l int
	_ = l
	if m.CloudDynamic != nil {
		l = m.CloudDynamic.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	return n
}
func (m *Noop) Size() (n int) {
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Local) Size() (n int) {
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *S3) Size() (n int) {
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Region)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Bucket)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Prefix)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.StorageClass)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Sse)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Acl)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.AccessKey)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.SecretAccessKey)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.ForcePathStyle {
		n += 2
	}
	l = len(m.SseKmsKeyId)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GCS) Size() (n int) {
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Bucket)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Prefix)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.StorageClass)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.PredefinedAcl)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.CredentialsBlob)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Bucket) Size() (n int) {
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Region)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Bucket)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Prefix)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.StorageClass)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CloudDynamic) Size() (n int) {
	var l int
	_ = l
	if m.Bucket != nil {
		l = m.Bucket.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.ProviderName)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if len(m.Attrs) > 0 {
		for k, v := range m.Attrs {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovBackup(uint64(len(k))) + 1 + len(v) + sovBackup(uint64(len(v)))
			n += mapEntrySize + 1 + sovBackup(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BackupResponse) Size() (n int) {
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.StartKey)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovBackup(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExternalStorageRestoreRequest) Size() (n int) {
	var l int
	_ = l
	if m.StorageBackend != nil {
		l = m.StorageBackend.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.ObjectName)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.RestoreName)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.ContentLength != 0 {
		n += 1 + sovBackup(uint64(m.ContentLength))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExternalStorageRestoreResponse) Size() (n int) {
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExternalStorageSaveRequest) Size() (n int) {
	var l int
	_ = l
	if m.StorageBackend != nil {
		l = m.StorageBackend.Size()
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.ObjectName)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	if m.ContentLength != 0 {
		n += 1 + sovBackup(uint64(m.ContentLength))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExternalStorageSaveResponse) Size() (n int) {
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovBackup(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozBackup(x uint64) (n int) {
	return sovBackup(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *BackupMeta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackupMeta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackupMeta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			m.ClusterId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ClusterId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, &File{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			m.StartVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartVersion |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndVersion", wireType)
			}
			m.EndVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndVersion |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schemas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Schemas = append(m.Schemas, &Schema{})
			if err := m.Schemas[len(m.Schemas)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsRawKv", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsRawKv = bool(v != 0)
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawRanges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RawRanges = append(m.RawRanges, &RawRange{})
			if err := m.RawRanges[len(m.RawRanges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ddls", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ddls = append(m.Ddls[:0], dAtA[iNdEx:postIndex]...)
			if m.Ddls == nil {
				m.Ddls = []byte{}
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BrVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BrVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FileIndex", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FileIndex == nil {
				m.FileIndex = &MetaFile{}
			}
			if err := m.FileIndex.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaIndex", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SchemaIndex == nil {
				m.SchemaIndex = &MetaFile{}
			}
			if err := m.SchemaIndex.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawRangeIndex", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RawRangeIndex == nil {
				m.RawRangeIndex = &MetaFile{}
			}
			if err := m.RawRangeIndex.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DdlIndexes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DdlIndexes == nil {
				m.DdlIndexes = &MetaFile{}
			}
			if err := m.DdlIndexes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *File) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: File: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: File: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sha256", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sha256 = append(m.Sha256[:0], dAtA[iNdEx:postIndex]...)
			if m.Sha256 == nil {
				m.Sha256 = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			m.StartVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartVersion |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndVersion", wireType)
			}
			m.EndVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndVersion |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Crc64Xor", wireType)
			}
			m.Crc64Xor = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Crc64Xor |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalKvs", wireType)
			}
			m.TotalKvs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalKvs |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalBytes", wireType)
			}
			m.TotalBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalBytes |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cf", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cf = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Size_", wireType)
			}
			m.Size_ = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Size_ |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MetaFile) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetaFile: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetaFile: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetaFiles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MetaFiles = append(m.MetaFiles, &File{})
			if err := m.MetaFiles[len(m.MetaFiles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataFiles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DataFiles = append(m.DataFiles, &File{})
			if err := m.DataFiles[len(m.DataFiles)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schemas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Schemas = append(m.Schemas, &Schema{})
			if err := m.Schemas[len(m.Schemas)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawRanges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RawRanges = append(m.RawRanges, &RawRange{})
			if err := m.RawRanges[len(m.RawRanges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ddls", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ddls = append(m.Ddls, make([]byte, postIndex-iNdEx))
			copy(m.Ddls[len(m.Ddls)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Schema) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Schema: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Schema: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Db", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Db = append(m.Db[:0], dAtA[iNdEx:postIndex]...)
			if m.Db == nil {
				m.Db = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Table", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Table = append(m.Table[:0], dAtA[iNdEx:postIndex]...)
			if m.Table == nil {
				m.Table = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Crc64Xor", wireType)
			}
			m.Crc64Xor = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Crc64Xor |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalKvs", wireType)
			}
			m.TotalKvs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalKvs |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalBytes", wireType)
			}
			m.TotalBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalBytes |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TiflashReplicas", wireType)
			}
			m.TiflashReplicas = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TiflashReplicas |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Stats = append(m.Stats[:0], dAtA[iNdEx:postIndex]...)
			if m.Stats == nil {
				m.Stats = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RawRange) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RawRange: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RawRange: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cf", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cf = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterIDError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterIDError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterIDError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Current", wireType)
			}
			m.Current = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Current |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Request", wireType)
			}
			m.Request = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Request |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Error) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Error: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Error: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterIdError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ClusterIDError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Detail = &Error_ClusterIdError{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KvError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &kvrpcpb.KeyError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Detail = &Error_KvError{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &errorpb.Error{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Detail = &Error_RegionError{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BackupRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackupRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackupRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterId", wireType)
			}
			m.ClusterId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ClusterId |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartVersion", wireType)
			}
			m.StartVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StartVersion |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndVersion", wireType)
			}
			m.EndVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EndVersion |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RateLimit", wireType)
			}
			m.RateLimit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RateLimit |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Concurrency", wireType)
			}
			m.Concurrency = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Concurrency |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StorageBackend", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StorageBackend == nil {
				m.StorageBackend = &StorageBackend{}
			}
			if err := m.StorageBackend.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsRawKv", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsRawKv = bool(v != 0)
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cf", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cf = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompressionType", wireType)
			}
			m.CompressionType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CompressionType |= (CompressionType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompressionLevel", wireType)
			}
			m.CompressionLevel = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CompressionLevel |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StorageBackend) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StorageBackend: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StorageBackend: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Noop", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Noop{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Backend = &StorageBackend_Noop{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Local", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Local{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Backend = &StorageBackend_Local{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field S3", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &S3{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Backend = &StorageBackend_S3{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gcs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GCS{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Backend = &StorageBackend_Gcs{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CloudDynamic", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CloudDynamic{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Backend = &StorageBackend_CloudDynamic{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Noop) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Noop: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Noop: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Local) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Local: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Local: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *S3) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: S3: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: S3: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Region", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Region = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bucket", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bucket = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StorageClass", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StorageClass = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sse", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sse = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Acl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Acl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecretAccessKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SecretAccessKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForcePathStyle", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ForcePathStyle = bool(v != 0)
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SseKmsKeyId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SseKmsKeyId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GCS) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCS: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCS: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bucket", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bucket = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StorageClass", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StorageClass = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PredefinedAcl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PredefinedAcl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CredentialsBlob", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CredentialsBlob = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Bucket) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Bucket: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Bucket: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Region", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Region = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bucket", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bucket = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StorageClass", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StorageClass = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CloudDynamic) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CloudDynamic: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CloudDynamic: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bucket", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Bucket == nil {
				m.Bucket = &Bucket{}
			}
			if err := m.Bucket.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProviderName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProviderName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attrs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Attrs == nil {
				m.Attrs = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowBackup
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowBackup
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthBackup
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowBackup
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthBackup
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipBackup(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthBackup
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Attrs[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BackupResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackupResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackupResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &Error{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, &File{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExternalStorageRestoreRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExternalStorageRestoreRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExternalStorageRestoreRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StorageBackend", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StorageBackend == nil {
				m.StorageBackend = &StorageBackend{}
			}
			if err := m.StorageBackend.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ObjectName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RestoreName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RestoreName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContentLength", wireType)
			}
			m.ContentLength = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ContentLength |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExternalStorageRestoreResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExternalStorageRestoreResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExternalStorageRestoreResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExternalStorageSaveRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExternalStorageSaveRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExternalStorageSaveRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StorageBackend", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StorageBackend == nil {
				m.StorageBackend = &StorageBackend{}
			}
			if err := m.StorageBackend.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ObjectName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContentLength", wireType)
			}
			m.ContentLength = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ContentLength |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExternalStorageSaveResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExternalStorageSaveResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExternalStorageSaveResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipBackup(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthBackup
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowBackup
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipBackup(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthBackup = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowBackup   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("backup.proto", fileDescriptor_backup_c0317208fdb49464) }

var fileDescriptor_backup_c0317208fdb49464 = []byte{
	// 1729 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0x5f, 0x8f, 0x1b, 0x49,
	0x11, 0xf7, 0x78, 0xc6, 0x7f, 0xa6, 0xfc, 0x37, 0xad, 0x90, 0xb3, 0x1c, 0xb2, 0x31, 0x13, 0x25,
	0x2c, 0x77, 0xd2, 0x1e, 0xec, 0xde, 0x9d, 0x22, 0x4e, 0x08, 0xc5, 0x49, 0xb8, 0xdd, 0xdb, 0x65,
	0x09, 0xed, 0x03, 0x44, 0x5e, 0x46, 0xed, 0x99, 0x5e, 0xef, 0xe0, 0xf1, 0x8c, 0x99, 0x6e, 0x3b,
	0x31, 0x5f, 0x02, 0xf1, 0xc6, 0x17, 0x40, 0xe2, 0x81, 0x0f, 0xc1, 0xe3, 0xa1, 0xe3, 0x01, 0x09,
	0x21, 0xf1, 0x08, 0xe1, 0x8b, 0xa0, 0xea, 0xee, 0x99, 0xb5, 0x93, 0xb5, 0x13, 0x10, 0xe2, 0x69,
	0xbb, 0x7f, 0x55, 0xd5, 0xdd, 0x55, 0xf5, 0xab, 0xaa, 0xf1, 0x42, 0x73, 0xcc, 0x82, 0xe9, 0x62,
	0x7e, 0x30, 0xcf, 0x52, 0x99, 0x92, 0xaa, 0xde, 0xf5, 0x5b, 0xd3, 0x65, 0x36, 0x0f, 0xe6, 0x63,
	0x0d, 0xf7, 0x5b, 0x3c, 0xcb, 0xd2, 0xac, 0xd8, 0xde, 0x9c, 0xa4, 0x93, 0x54, 0x2d, 0x3f, 0xc4,
	0x95, 0x41, 0x3b, 0xd9, 0x42, 0x48, 0xb5, 0xd4, 0x80, 0xf7, 0x4f, 0x07, 0x60, 0xa8, 0xce, 0xfb,
	0x21, 0x97, 0x8c, 0xdc, 0x01, 0x08, 0xe2, 0x85, 0x90, 0x3c, 0xf3, 0xa3, 0xb0, 0x67, 0x0d, 0xac,
	0x7d, 0x87, 0xba, 0x06, 0x39, 0x09, 0xc9, 0x37, 0xa1, 0x93, 0x8b, 0x97, 0x3c, 0x13, 0x51, 0x9a,
	0xf4, 0xca, 0x03, 0x6b, 0xdf, 0xa5, 0x6d, 0x03, 0xff, 0x54, 0xa3, 0xc4, 0x83, 0xca, 0x45, 0x14,
	0x73, 0xd1, 0x73, 0x06, 0xf6, 0x7e, 0xe3, 0xb0, 0x79, 0x60, 0x3c, 0xf8, 0x41, 0x14, 0x73, 0xaa,
	0x45, 0xe4, 0x1e, 0xb4, 0x84, 0x64, 0x99, 0x2c, 0x8e, 0xaa, 0xa8, 0xeb, 0x9a, 0x0a, 0xcc, 0x0f,
	0xba, 0x0b, 0x0d, 0x9e, 0x84, 0x85, 0x4a, 0x55, 0xa9, 0x00, 0x4f, 0xc2, 0x5c, 0x61, 0x1f, 0x6a,
	0x22, 0xb8, 0xe4, 0x33, 0x26, 0x7a, 0x35, 0x75, 0x57, 0x3b, 0xbf, 0x6b, 0xa4, 0x60, 0x9a, 0x8b,
	0x49, 0x1f, 0xdc, 0x48, 0xf8, 0x19, 0x7b, 0xe1, 0x4f, 0x97, 0xbd, 0xfa, 0xc0, 0xda, 0xaf, 0xd3,
	0x5a, 0x24, 0x28, 0x7b, 0x71, 0xba, 0x24, 0x1f, 0x02, 0xa0, 0x20, 0x63, 0xc9, 0x84, 0x8b, 0x9e,
	0xab, 0x0e, 0xea, 0xe6, 0x07, 0x51, 0xf6, 0x82, 0xa2, 0x80, 0xba, 0x99, 0x59, 0x09, 0x42, 0xc0,
	0x09, 0xc3, 0x58, 0xf4, 0x60, 0x60, 0xed, 0x37, 0xa9, 0x5a, 0x63, 0xf0, 0xc6, 0x57, 0x81, 0x69,
	0xa8, 0xc0, 0xb8, 0xe3, 0x22, 0x26, 0x3d, 0xa8, 0xe5, 0xb2, 0xe6, 0xc0, 0xda, 0xaf, 0xd0, 0x7c,
	0x8b, 0xb7, 0x63, 0x48, 0xfc, 0x28, 0x09, 0xf9, 0xcb, 0x5e, 0x6b, 0x60, 0xad, 0xdf, 0x8e, 0x79,
	0x51, 0x61, 0x73, 0x51, 0xe7, 0x04, 0x55, 0xc8, 0x11, 0x34, 0xb5, 0x57, 0xc6, 0xa4, 0xbd, 0xc5,
	0xa4, 0xa1, 0xb5, 0xb4, 0xd1, 0x43, 0xe8, 0x14, 0x3e, 0x1a, 0xbb, 0xce, 0x16, 0xbb, 0x56, 0xee,
	0xa8, 0xb6, 0xfc, 0x0e, 0x34, 0xc2, 0x30, 0xd6, 0x36, 0x5c, 0xf4, 0xba, 0x5b, 0xac, 0x20, 0x0c,
	0xe3, 0x13, 0xad, 0xf3, 0xb9, 0x53, 0xb7, 0xbb, 0x0e, 0x75, 0xe6, 0x4c, 0x5e, 0x7a, 0x7f, 0x28,
	0x83, 0x83, 0x0a, 0x18, 0xb4, 0x84, 0xcd, 0xb8, 0xe2, 0x95, 0x4b, 0xd5, 0x9a, 0xdc, 0x82, 0xaa,
	0xb8, 0x64, 0x87, 0x1f, 0x7f, 0xa2, 0x98, 0xd4, 0xa4, 0x66, 0x47, 0x6e, 0x83, 0xab, 0xd9, 0x31,
	0xe5, 0xab, 0x9e, 0xad, 0x44, 0x75, 0x05, 0x9c, 0xf2, 0x15, 0x79, 0x0f, 0x6a, 0xc8, 0x0a, 0x14,
	0x39, 0xda, 0x8a, 0x27, 0x21, 0x0a, 0xfe, 0x37, 0x9c, 0xea, 0x43, 0x3d, 0xc8, 0x82, 0x4f, 0x3e,
	0x7a, 0x99, 0x66, 0xbd, 0x9a, 0x92, 0x16, 0x7b, 0x7c, 0x97, 0x4c, 0x25, 0x8b, 0xfd, 0xe9, 0x52,
	0x28, 0x16, 0x39, 0xb4, 0xae, 0x80, 0xd3, 0xa5, 0xc0, 0x93, 0xb5, 0x70, 0xbc, 0x92, 0x8a, 0x47,
	0xea, 0x64, 0x05, 0x0d, 0x11, 0x21, 0x6d, 0x28, 0x07, 0x17, 0x8a, 0x34, 0x2e, 0x2d, 0x07, 0x17,
	0x18, 0x11, 0x11, 0xfd, 0x8a, 0x2b, 0xb2, 0x38, 0x54, 0xad, 0xbd, 0xbf, 0x5a, 0x50, 0xcf, 0x63,
	0x4a, 0x3e, 0x00, 0x98, 0x71, 0xc9, 0x7c, 0x5d, 0x4d, 0xd6, 0x35, 0xd5, 0xe4, 0xce, 0x8c, 0xae,
	0x40, 0xe5, 0x90, 0x15, 0xca, 0xe5, 0xeb, 0x94, 0x51, 0xae, 0x95, 0xd7, 0x0a, 0xc7, 0xde, 0x5d,
	0x38, 0x9b, 0xc5, 0xe1, 0xbc, 0x7b, 0x71, 0x54, 0x06, 0x76, 0x5e, 0x1c, 0xde, 0x9f, 0x2c, 0xa8,
	0xea, 0x83, 0x31, 0x08, 0xe1, 0x58, 0x91, 0xa0, 0x49, 0xcb, 0xe1, 0x98, 0xdc, 0x84, 0x8a, 0x64,
	0xe3, 0x98, 0x1b, 0x06, 0xe8, 0xcd, 0x46, 0x12, 0xec, 0x5d, 0x49, 0x70, 0x76, 0x27, 0xa1, 0xf2,
	0x46, 0x12, 0xbe, 0x05, 0x5d, 0x19, 0x5d, 0xc4, 0x4c, 0x5c, 0xfa, 0x19, 0x9f, 0xc7, 0x51, 0xc0,
	0x84, 0x22, 0x41, 0x8b, 0x76, 0x0c, 0x4e, 0x0d, 0x8c, 0x4f, 0x13, 0x92, 0x49, 0xa1, 0x68, 0xd0,
	0xa4, 0x7a, 0xe3, 0x3d, 0x83, 0x7a, 0xee, 0xf6, 0x26, 0x4f, 0xad, 0xed, 0x3c, 0x2d, 0x6f, 0xf0,
	0x54, 0xf3, 0xc0, 0xce, 0x79, 0xe0, 0x3d, 0x81, 0xf6, 0x63, 0xd3, 0x65, 0x9f, 0x3c, 0xc5, 0x3e,
	0x8e, 0xdd, 0x22, 0x58, 0x64, 0x19, 0x4f, 0xa4, 0x69, 0xc3, 0xf9, 0x16, 0x25, 0x19, 0xff, 0xe5,
	0x82, 0x0b, 0xa9, 0x0e, 0x75, 0x68, 0xbe, 0xf5, 0xfe, 0x6c, 0x41, 0x45, 0x5b, 0x77, 0xc1, 0x9e,
	0x89, 0x89, 0x29, 0x34, 0x5c, 0x92, 0x21, 0x74, 0xaf, 0x3a, 0xbb, 0xaf, 0x66, 0x85, 0xba, 0xbf,
	0x71, 0x78, 0x2b, 0x4f, 0xe5, 0xe6, 0x0b, 0x8e, 0x4b, 0x45, 0x57, 0x3f, 0x09, 0xf5, 0xa9, 0x07,
	0x50, 0x9f, 0x2e, 0x8d, 0xad, 0xa3, 0x6c, 0x6f, 0x1c, 0xe4, 0x43, 0xe8, 0x94, 0xaf, 0x72, 0xb3,
	0xda, 0x74, 0xa9, 0xf5, 0x8f, 0xa0, 0x99, 0xf1, 0x49, 0x94, 0x26, 0xc6, 0xa6, 0xa2, 0x6c, 0xda,
	0x07, 0xf9, 0xa4, 0xca, 0x0d, 0x1a, 0x5a, 0x4b, 0x6d, 0x87, 0x75, 0xa8, 0x86, 0x5c, 0xb2, 0x28,
	0xf6, 0xfe, 0x66, 0x43, 0x4b, 0xcf, 0x26, 0xaa, 0x1d, 0x7c, 0xdb, 0x78, 0xda, 0xc8, 0x45, 0x79,
	0x7b, 0x2e, 0xec, 0xdd, 0x3d, 0xc3, 0x79, 0x7b, 0xcf, 0xa8, 0xbc, 0xd1, 0x33, 0xee, 0x60, 0x91,
	0x48, 0xee, 0xc7, 0xd1, 0x2c, 0x92, 0xa6, 0x6b, 0xb8, 0x88, 0x9c, 0x21, 0x40, 0x06, 0xd0, 0x08,
	0xd2, 0x44, 0xa7, 0x30, 0x58, 0xa9, 0xc6, 0xd1, 0xa2, 0xeb, 0x10, 0xf9, 0x3e, 0x74, 0x84, 0x4c,
	0x33, 0x36, 0xe1, 0x3e, 0xe6, 0x83, 0x27, 0xa1, 0xea, 0x1f, 0x6b, 0xf9, 0x19, 0x69, 0xf1, 0x50,
	0x4b, 0x69, 0x5b, 0x6c, 0xec, 0x37, 0xe7, 0x1b, 0x6c, 0xce, 0x37, 0xcd, 0xb7, 0x46, 0xd1, 0x77,
	0x90, 0x0d, 0xe9, 0x6c, 0x9e, 0x71, 0x81, 0x8f, 0xf7, 0xe5, 0x6a, 0xce, 0xd5, 0x50, 0x6a, 0x1f,
	0xbe, 0x57, 0xb0, 0xe1, 0x4a, 0xfe, 0xc5, 0x6a, 0xce, 0x69, 0x27, 0xd8, 0x04, 0xc8, 0x07, 0x70,
	0x63, 0xfd, 0x8c, 0x98, 0x2f, 0x79, 0xac, 0x86, 0x57, 0x85, 0xae, 0x1f, 0x7e, 0x86, 0xf8, 0xe7,
	0x4e, 0xbd, 0xda, 0xad, 0x99, 0x79, 0xf0, 0xca, 0x82, 0xf6, 0xa6, 0x2f, 0xc4, 0x03, 0x27, 0x49,
	0xd3, 0xb9, 0x4a, 0xe9, 0x5a, 0xcf, 0x3a, 0x4f, 0xd3, 0xf9, 0x71, 0x89, 0x2a, 0x19, 0xb9, 0x0f,
	0x95, 0x38, 0x0d, 0x58, 0xac, 0x32, 0xdb, 0x38, 0x6c, 0xe5, 0x4a, 0x67, 0x08, 0x1e, 0x97, 0xa8,
	0x96, 0x92, 0xaf, 0x43, 0x59, 0x1c, 0x19, 0x6a, 0x43, 0x11, 0xba, 0xa3, 0xe3, 0x12, 0x2d, 0x8b,
	0x23, 0x72, 0x17, 0xec, 0x49, 0x20, 0x0c, 0x7b, 0x1b, 0xb9, 0xf8, 0xb3, 0xc7, 0xa3, 0xe3, 0x12,
	0x45, 0x09, 0xf9, 0x14, 0x5a, 0x41, 0x9c, 0x2e, 0x42, 0x3f, 0x5c, 0x25, 0x6c, 0x16, 0x05, 0x86,
	0xb4, 0x37, 0xaf, 0x8a, 0x24, 0x5d, 0x84, 0x4f, 0xb4, 0xec, 0xb8, 0x44, 0x9b, 0xc1, 0xda, 0x7e,
	0xe8, 0x42, 0xcd, 0xe4, 0xce, 0xab, 0x82, 0x83, 0xaf, 0xf7, 0x6e, 0x43, 0x45, 0x3d, 0x10, 0x9b,
	0x22, 0x7a, 0x9f, 0x0f, 0x3f, 0x15, 0x89, 0xaf, 0xca, 0x50, 0x1e, 0x1d, 0x61, 0xab, 0xe3, 0x49,
	0x38, 0x4f, 0x23, 0x53, 0xec, 0x2e, 0x2d, 0xf6, 0x38, 0x1f, 0x75, 0x75, 0x98, 0x2f, 0x2d, 0xb3,
	0x43, 0x7c, 0xbc, 0x08, 0xa6, 0x5c, 0x9a, 0x2e, 0x62, 0x76, 0x88, 0xcf, 0x33, 0x7e, 0x11, 0xbd,
	0x54, 0x3e, 0xba, 0xd4, 0xec, 0x34, 0xcb, 0x35, 0xbd, 0x82, 0x98, 0x09, 0xdd, 0x17, 0x5d, 0x64,
	0xb9, 0x02, 0x1f, 0x23, 0x86, 0x6d, 0x43, 0x08, 0xae, 0x9a, 0xa1, 0x4b, 0x71, 0x89, 0x08, 0x0b,
	0x62, 0xc5, 0x67, 0x97, 0xe2, 0x12, 0x89, 0xce, 0x82, 0x80, 0x0b, 0xa1, 0x4a, 0xa9, 0xae, 0xbf,
	0x72, 0x34, 0x82, 0xd5, 0xf4, 0x3e, 0xdc, 0x10, 0x3c, 0xc8, 0xb8, 0xf4, 0xd7, 0xb4, 0x5c, 0xa5,
	0xd5, 0xd1, 0x82, 0x47, 0x85, 0xee, 0x3e, 0x74, 0x2f, 0xd2, 0x2c, 0xe0, 0x3e, 0x06, 0xc3, 0x17,
	0x72, 0x15, 0x73, 0x43, 0xdc, 0xb6, 0xc2, 0x9f, 0x31, 0x79, 0x39, 0x42, 0x94, 0xdc, 0x83, 0xb6,
	0x10, 0xdc, 0x9f, 0xce, 0xd4, 0x79, 0x58, 0xfc, 0x9a, 0xcb, 0x0d, 0x21, 0xf8, 0xe9, 0x0c, 0x0f,
	0x3b, 0x09, 0xbd, 0x2f, 0x2d, 0xb0, 0x3f, 0x7b, 0x3c, 0x7a, 0x5b, 0x38, 0x4d, 0xd8, 0xca, 0x5b,
	0xc2, 0x66, 0xef, 0x0e, 0x9b, 0x73, 0x4d, 0xd8, 0xee, 0x43, 0x7b, 0x9e, 0xf1, 0x90, 0x5f, 0x44,
	0x09, 0x0f, 0x7d, 0x8c, 0x97, 0x0e, 0x6e, 0xeb, 0x0a, 0x7d, 0x14, 0xc4, 0x38, 0x77, 0x02, 0x04,
	0x12, 0x19, 0xb1, 0x58, 0xf8, 0xe3, 0x38, 0x1d, 0x9b, 0x50, 0x77, 0xd6, 0xf0, 0x61, 0x9c, 0x8e,
	0xbd, 0xdf, 0x58, 0x50, 0x1d, 0xea, 0x97, 0xbd, 0x1b, 0x39, 0xec, 0x2d, 0xe4, 0x70, 0xb6, 0x78,
	0x59, 0xd9, 0xed, 0x65, 0xf5, 0x4d, 0x2f, 0x71, 0xba, 0x34, 0xd7, 0xd9, 0x4f, 0x1e, 0x14, 0xb7,
	0x58, 0xa6, 0xb1, 0x9b, 0x1a, 0xd1, 0x2f, 0x2f, 0x6e, 0xbd, 0x07, 0xad, 0x79, 0x96, 0x2e, 0xa3,
	0x90, 0x67, 0xbe, 0xfa, 0xfe, 0xd3, 0xa1, 0x6f, 0xe6, 0xe0, 0x39, 0x7e, 0x07, 0x7e, 0x0c, 0x15,
	0x26, 0x65, 0x96, 0x7f, 0x8c, 0xdc, 0xbd, 0xae, 0xde, 0x0e, 0x1e, 0xa1, 0xc6, 0xd3, 0x44, 0x66,
	0x2b, 0xaa, 0xb5, 0xfb, 0x0f, 0x01, 0xae, 0x40, 0x64, 0x6b, 0x3e, 0x86, 0x5d, 0x8a, 0x4b, 0x1c,
	0xe0, 0x4b, 0x16, 0x2f, 0xf2, 0x3b, 0xf5, 0xe6, 0xbb, 0xe5, 0x87, 0x96, 0xf7, 0x6b, 0x0b, 0xda,
	0xf9, 0x74, 0x11, 0xf3, 0x34, 0x11, 0xc8, 0xb2, 0x8a, 0x1e, 0x54, 0xd6, 0x66, 0x87, 0x51, 0x83,
	0x89, 0x6a, 0xd9, 0x7f, 0x39, 0x64, 0xde, 0xe1, 0x07, 0x91, 0xf7, 0x95, 0x05, 0x77, 0x9e, 0xbe,
	0x94, 0x3c, 0x4b, 0x58, 0x6c, 0xfa, 0x23, 0xe5, 0x98, 0x02, 0x9e, 0xcf, 0xbf, 0x6b, 0x66, 0x84,
	0xf5, 0x1f, 0xcd, 0x88, 0xbb, 0xd0, 0x48, 0xc7, 0xbf, 0xe0, 0x81, 0x5c, 0x4f, 0x04, 0x68, 0x48,
	0xa5, 0xe1, 0x1b, 0x38, 0xb2, 0xd5, 0x9d, 0x5a, 0x43, 0xf3, 0xaa, 0x61, 0x30, 0xa5, 0x72, 0x1f,
	0xda, 0x41, 0x9a, 0x48, 0x9e, 0x48, 0x3f, 0xe6, 0xc9, 0x44, 0x5e, 0x9a, 0x81, 0xd9, 0x32, 0xe8,
	0x99, 0x02, 0xbd, 0x01, 0xec, 0x6d, 0x73, 0x46, 0x87, 0xdb, 0xfb, 0x9d, 0x05, 0xfd, 0xd7, 0x54,
	0x46, 0x6c, 0xf9, 0x7f, 0x74, 0xf6, 0x4d, 0x4f, 0xec, 0xeb, 0x3c, 0xb9, 0x03, 0xb7, 0xaf, 0x7d,
	0xa6, 0x76, 0xe3, 0xfd, 0xef, 0x41, 0xe7, 0xb5, 0x59, 0x49, 0x1a, 0x50, 0xfb, 0xc9, 0xf9, 0xe9,
	0xf9, 0x8f, 0x7e, 0x76, 0xde, 0x2d, 0x91, 0x1a, 0xd8, 0x67, 0xcf, 0x3f, 0xea, 0x5a, 0x04, 0xa0,
	0x3a, 0x3a, 0x7f, 0xf4, 0xec, 0xd9, 0xcf, 0xbb, 0x65, 0x52, 0x07, 0xe7, 0xf9, 0xe8, 0x8b, 0x27,
	0x5d, 0xfb, 0xf0, 0x29, 0x54, 0x35, 0x0d, 0xc9, 0xa7, 0x60, 0x7e, 0xda, 0x93, 0xaf, 0x15, 0x95,
	0xb4, 0xfe, 0xf9, 0xd3, 0xbf, 0xf5, 0x3a, 0x6c, 0x02, 0x59, 0xfa, 0xb6, 0x75, 0xf8, 0x47, 0x0b,
	0x3a, 0xaf, 0xbd, 0x92, 0x3c, 0xc7, 0x2f, 0x45, 0x15, 0x73, 0x72, 0xbf, 0xe0, 0xf2, 0x2e, 0x82,
	0xf5, 0x1f, 0xbc, 0x4d, 0x2d, 0xbf, 0x91, 0xfc, 0x18, 0x1c, 0xc1, 0x96, 0x9c, 0x78, 0x5b, 0x2c,
	0xd6, 0x32, 0xd9, 0xbf, 0xb7, 0x53, 0x27, 0x3f, 0x72, 0xf8, 0xe0, 0xef, 0xbf, 0xaf, 0x5b, 0x5f,
	0xbe, 0xda, 0xb3, 0xfe, 0xf2, 0x6a, 0xcf, 0xfa, 0xc7, 0xab, 0x3d, 0xeb, 0xb7, 0xff, 0xda, 0x2b,
	0x41, 0x37, 0xcd, 0x26, 0x07, 0x32, 0x9a, 0x2e, 0x0f, 0xa6, 0x4b, 0xf5, 0x3f, 0x8b, 0x71, 0x55,
	0xfd, 0x39, 0xfa, 0x77, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd5, 0xfc, 0xdd, 0x1f, 0x17, 0x11, 0x00,
	0x00,
}
