import importlib


class RunPager:
    def __init__(self, path: str, config, pager: str = "less"):
        self.path = path
        self.pager = pager
        self.impl = self._load_pager()
        self.impl.run(self.path, config)

    def _load_pager(self):
        try:
            module_path = f"console_log.pagers.{self.pager}"
            class_name = f"{self.pager.capitalize()}Pager"
            module = importlib.import_module(module_path)
            cls = getattr(module, class_name)
            return cls()
        except (ModuleNotFoundError, AttributeError) as e:
            raise ValueError(f"Unknown pager '{self.pager}': {e}")
