{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetCollider: TCollisionCollectionNode;
    procedure SetCollider(const Value: TCollisionCollectionNode);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdCollider: TSFNode;
    { Internal wrapper for property @code(Collider). This wrapper API may change, we advise to access simpler @code(Collider) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCollider: TSFNode read FFdCollider;
    {  }
    property Collider: TCollisionCollectionNode read GetCollider write SetCollider;

    strict private FEventIntersections: TMFNodeEvent;
    {  }
    public property EventIntersections: TMFNodeEvent read FEventIntersections;

    strict private FEventContacts: TMFNodeEvent;
    {  }
    public property EventContacts: TMFNodeEvent read FEventContacts;

{$endif read_interface}

{$ifdef read_implementation}

{ TCollisionSensorNode ----------------------------------------------- }

function TCollisionSensorNode.GetCollider: TCollisionCollectionNode;
begin
  if FdCollider.Value is TCollisionCollectionNode then
    Result := TCollisionCollectionNode(FdCollider.Value)
  else
    Result := nil;
end;

procedure TCollisionSensorNode.SetCollider(const Value: TCollisionCollectionNode);
begin
  FdCollider.Send(Value);
end;

class function TCollisionSensorNode.ClassX3DType: String;
begin
  Result := 'CollisionSensor';
end;

procedure TCollisionSensorNode.CreateNode;
begin
  inherited;

  FFdCollider := TSFNode.Create(Self, True, 'collider', [TCollisionCollectionNode]);
   FdCollider.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCollider);

  FEventIntersections := TMFNodeEvent.Create(Self, 'intersections', false);
  AddEvent(FEventIntersections);

  FEventContacts := TMFNodeEvent.Create(Self, 'contacts', false);
  AddEvent(FEventContacts);
end;

{$endif read_implementation}
