;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; NOTE: This test was ported using port_passes_tests_to_lit.py and could be cleaned up.

;; RUN: foreach %s %t wasm-opt --flatten --simplify-locals-nonesting --souperify-single-use --enable-threads -S -o - | filecheck %s

(module
  ;; CHECK:      (type $0 (func (param i32 i32) (result i32)))

  ;; CHECK:      (type $1 (func (param i32) (result i32)))

  ;; CHECK:      (type $2 (func (param i32)))

  ;; CHECK:      (type $3 (func (param i32 i32 i32) (result i32)))

  ;; CHECK:      (type $4 (func (result i32)))

  ;; CHECK:      (type $5 (func (param i32 i32)))

  ;; CHECK:      (type $6 (func (result f64)))

  ;; CHECK:      (type $7 (func (param i64 i64 i64) (result i32)))

  ;; CHECK:      (type $8 (func))

  ;; CHECK:      (type $9 (func (param i32 i32 i32 i32)))

  ;; CHECK:      (type $10 (func (param i64 i64 i64) (result i64)))

  ;; CHECK:      (type $11 (func (param i64 i64 i32 f32)))

  ;; CHECK:      (type $12 (func (param i32 i32 i32 i32 i32) (result i32)))

  ;; CHECK:      (memory $0 1 1 shared)
  (memory $0 1 1 shared)
  ;; Figure 1a from the Souper paper https://arxiv.org/pdf/1711.04422.pdf
  ;; CHECK:      (export "replaced-print-internal" (func $replaced-print-internal))

  ;; CHECK:      (func $figure-1a (param $a i64) (param $x i64) (param $y i64) (result i32)
  ;; CHECK-NEXT:  (local $i i32)
  ;; CHECK-NEXT:  (local $j i32)
  ;; CHECK-NEXT:  (local $r i32)
  ;; CHECK-NEXT:  (local $6 i64)
  ;; CHECK-NEXT:  (local $7 i64)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i64)
  ;; CHECK-NEXT:  (local $10 i64)
  ;; CHECK-NEXT:  (local $11 i32)
  ;; CHECK-NEXT:  (local $12 i32)
  ;; CHECK-NEXT:  (local $13 i32)
  ;; CHECK-NEXT:  (local $14 i32)
  ;; CHECK-NEXT:  (local $15 i32)
  ;; CHECK-NEXT:  (local $16 i32)
  ;; CHECK-NEXT:  (local $17 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $12
  ;; CHECK-NEXT:    (i64.eq
  ;; CHECK-NEXT:     (local.get $a)
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $13
  ;; CHECK-NEXT:    (i64.ne
  ;; CHECK-NEXT:     (local.get $a)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $15
  ;; CHECK-NEXT:    (i32.and
  ;; CHECK-NEXT:     (local.get $12)
  ;; CHECK-NEXT:     (local.get $13)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $15)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $16)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $figure-1a (param $a i64) (param $x i64) (param $y i64) (result i32)
    (local $i i32)
    (local $j i32)
    (local $r i32)
    (local.set $i
      (i64.eq
        (local.get $a)
        (local.get $x)
      )
    )
    (local.set $j
      (i64.ne
        (local.get $a)
        (local.get $y)
      )
    )
    (local.set $r
      (i32.and
        (local.get $i)
        (local.get $j)
      )
    )
    (return (local.get $r))
  )
  ;; Figure 1b, with a potential path condition
  ;; CHECK:      (func $figure-1b (param $a i64) (param $x i64) (param $y i64) (result i32)
  ;; CHECK-NEXT:  (local $i i32)
  ;; CHECK-NEXT:  (local $j i32)
  ;; CHECK-NEXT:  (local $r i32)
  ;; CHECK-NEXT:  (local $6 i64)
  ;; CHECK-NEXT:  (local $7 i64)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i64)
  ;; CHECK-NEXT:  (local $10 i64)
  ;; CHECK-NEXT:  (local $11 i32)
  ;; CHECK-NEXT:  (local $12 i64)
  ;; CHECK-NEXT:  (local $13 i64)
  ;; CHECK-NEXT:  (local $14 i32)
  ;; CHECK-NEXT:  (local $15 i32)
  ;; CHECK-NEXT:  (local $16 i32)
  ;; CHECK-NEXT:  (local $17 i32)
  ;; CHECK-NEXT:  (local $18 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $8
  ;; CHECK-NEXT:    (i64.lt_s
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (local.get $8)
  ;; CHECK-NEXT:    (then
  ;; CHECK-NEXT:     (block
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (local.set $15
  ;; CHECK-NEXT:       (i64.eq
  ;; CHECK-NEXT:        (local.get $a)
  ;; CHECK-NEXT:        (local.get $x)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (local.set $16
  ;; CHECK-NEXT:       (i64.ne
  ;; CHECK-NEXT:        (local.get $a)
  ;; CHECK-NEXT:        (local.get $y)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (local.set $18
  ;; CHECK-NEXT:       (i32.and
  ;; CHECK-NEXT:        (local.get $15)
  ;; CHECK-NEXT:        (local.get $16)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (return
  ;; CHECK-NEXT:       (local.get $18)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (unreachable)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (unreachable)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (else
  ;; CHECK-NEXT:     (unreachable)
  ;; CHECK-NEXT:     (unreachable)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  (func $figure-1b (param $a i64) (param $x i64) (param $y i64) (result i32)
    (local $i i32)
    (local $j i32)
    (local $r i32)
    (if
      (i64.lt_s
        (local.get $x)
        (local.get $y)
      )
      (then
        (block
          (local.set $i
            (i64.eq
              (local.get $a)
              (local.get $x)
            )
          )
          (local.set $j
            (i64.ne
              (local.get $a)
              (local.get $y)
            )
          )
          (local.set $r
            (i32.and
              (local.get $i)
              (local.get $j)
            )
          )
          (return (local.get $r))
        )
      )
      (else
        (unreachable)
      )
    )
  )
  ;; Figure 3, simplified to an if
  ;; CHECK:      (func $figure-3-if (param $x i32) (result i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (block
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $2
  ;; CHECK-NEXT:     (i32.and
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (i32.const 1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (if
  ;; CHECK-NEXT:     (local.get $2)
  ;; CHECK-NEXT:     (then
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (local.set $x
  ;; CHECK-NEXT:       (i32.add
  ;; CHECK-NEXT:        (local.get $x)
  ;; CHECK-NEXT:        (i32.const 1)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (else
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (local.set $x
  ;; CHECK-NEXT:       (i32.add
  ;; CHECK-NEXT:        (local.get $x)
  ;; CHECK-NEXT:        (i32.const 2)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $8
  ;; CHECK-NEXT:    (i32.and
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $8)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $9)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $figure-3-if (param $x i32) (result i32)
    (if
      (i32.and
        (local.get $x)
        (i32.const 1)
      )
      (then
        (local.set $x
          (i32.add
            (local.get $x)
            (i32.const 1)
          )
        )
      )
      (else
        (local.set $x
          (i32.add
            (local.get $x)
            (i32.const 2)
          )
        )
      )
    )
    (return
      (i32.and
        (local.get $x)
        (i32.const 1)
      )
    )
  )
  ;; flipping of greater than/or equals ops, which are not in Souper IR
  ;; CHECK:      (func $flips
  ;; CHECK-NEXT:  (local $x i32)
  ;; CHECK-NEXT:  (local $y i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (local $11 i32)
  ;; CHECK-NEXT:  (local $12 i32)
  ;; CHECK-NEXT:  (local $13 i32)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (local.set $x
  ;; CHECK-NEXT:   (i32.ge_s
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:    (local.get $y)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (local.set $x
  ;; CHECK-NEXT:   (i32.ge_u
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:    (local.get $y)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (local.set $x
  ;; CHECK-NEXT:   (i32.gt_s
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:    (local.get $y)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (local.set $x
  ;; CHECK-NEXT:   (i32.gt_u
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:    (local.get $y)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $flips
    (local $x i32)
    (local $y i32)
    (local.set $x (i32.ge_s (local.get $x) (local.get $y)))
    (local.set $x (i32.ge_u (local.get $x) (local.get $y)))
    (local.set $x (i32.gt_s (local.get $x) (local.get $y)))
    (local.set $x (i32.gt_u (local.get $x) (local.get $y)))
  )
  ;; CHECK:      (func $various-conditions-1 (param $x i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (local.get $x)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (i32.add
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (i32.const 1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $various-conditions-1 (param $x i32)
    (if
      (local.get $x)
      (then
        (local.set $x
          (i32.add
            (local.get $x)
            (i32.const 1)
          )
        )
      )
    )
  )
  ;; CHECK:      (func $various-conditions-2 (param $x i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i32.lt_s
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (local.get $2)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (i32.sub
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (i32.const 2)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $various-conditions-2 (param $x i32)
    (if
      (i32.lt_s
        (local.get $x)
        (i32.const 0)
      )
      (then
        (local.set $x
          (i32.sub
            (local.get $x)
            (i32.const 2)
          )
        )
      )
    )
  )
  ;; CHECK:      (func $various-conditions-3 (param $x i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (i32.reinterpret_f32
  ;; CHECK-NEXT:    (f32.const 0)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (i32.sub
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (i32.const 4)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $various-conditions-3 (param $x i32)
    (if
      (i32.reinterpret_f32 (f32.const 0))
      (then
        (local.set $x
          (i32.sub
            (local.get $x)
            (i32.const 4)
          )
        )
      )
    )
  )
  ;; CHECK:      (func $various-conditions-4 (param $x i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:    (then
  ;; CHECK-NEXT:     (nop)
  ;; CHECK-NEXT:     (nop)
  ;; CHECK-NEXT:     (local.set $x
  ;; CHECK-NEXT:      (i32.add
  ;; CHECK-NEXT:       (local.get $x)
  ;; CHECK-NEXT:       (i32.const 3)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  (func $various-conditions-4 (param $x i32)
    (if
      (unreachable)
      (then
        (local.set $x
          (i32.add
            (local.get $x)
            (i32.const 3)
          )
        )
      )
    )
  )
  ;; CHECK:      (func $unaries (param $x i32) (param $y i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (local $11 i32)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (i32.eqz
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (local.get $3)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $5
  ;; CHECK-NEXT:     (i32.ctz
  ;; CHECK-NEXT:      (local.get $y)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $7
  ;; CHECK-NEXT:     (i32.clz
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $9
  ;; CHECK-NEXT:     (i32.popcnt
  ;; CHECK-NEXT:      (local.get $y)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $10
  ;; CHECK-NEXT:     (i32.sub
  ;; CHECK-NEXT:      (local.get $7)
  ;; CHECK-NEXT:      (local.get $9)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (i32.add
  ;; CHECK-NEXT:      (local.get $5)
  ;; CHECK-NEXT:      (local.get $10)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $unaries (param $x i32) (param $y i32)
    (if
      (i32.eqz
        (local.get $x)
      )
      (then
        (local.set $x
          (i32.add
            (i32.ctz
              (local.get $y)
            )
            (i32.sub
              (i32.clz
                (local.get $x)
              )
              (i32.popcnt
                (local.get $y)
              )
            )
          )
        )
      )
    )
  )
  ;; CHECK:      (func $unary-condition (param $x i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i32.gt_u
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (i32.ctz
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (local.get $3)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (i32.add
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (i32.const 2)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $unary-condition (param $x i32)
    (if
      (i32.ctz
        (i32.gt_u
          (local.get $x)
          (i32.const 1)
        )
      )
      (then
        (local.set $x
          (i32.add
            (local.get $x)
            (i32.const 2)
          )
        )
      )
    )
  )
  ;; CHECK:      (func $unary-condition-2 (param $x i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i32.gt_u
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (i32.eqz
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (local.get $3)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (i32.add
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (i32.const 2)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $unary-condition-2 (param $x i32)
    (if
      (i32.eqz
        (i32.gt_u
          (local.get $x)
          (i32.const 1)
        )
      )
      (then
        (local.set $x
          (i32.add
            (local.get $x)
            (i32.const 2)
          )
        )
      )
    )
  )
  ;; CHECK:      (func $if-else-cond (param $x i32) (result i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (block
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $2
  ;; CHECK-NEXT:     (i32.lt_s
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (i32.const 1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (if
  ;; CHECK-NEXT:     (local.get $2)
  ;; CHECK-NEXT:     (then
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (local.set $x
  ;; CHECK-NEXT:       (i32.add
  ;; CHECK-NEXT:        (local.get $x)
  ;; CHECK-NEXT:        (i32.const 1)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (else
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (local.set $x
  ;; CHECK-NEXT:       (i32.add
  ;; CHECK-NEXT:        (local.get $x)
  ;; CHECK-NEXT:        (i32.const 2)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $8
  ;; CHECK-NEXT:    (i32.and
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $8)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $9)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $if-else-cond (param $x i32) (result i32)
    (if
      (i32.lt_s
        (local.get $x)
        (i32.const 1)
      )
      (then
        (local.set $x
          (i32.add
            (local.get $x)
            (i32.const 1)
          )
        )
      )
      (else
        (local.set $x
          (i32.add
            (local.get $x)
            (i32.const 2)
          )
        )
      )
    )
    (return
      (i32.and
        (local.get $x)
        (i32.const 1)
      )
    )
  )
  ;; CHECK:      (func $trivial-ret (result i32)
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local.set $0
  ;; CHECK-NEXT:   (i32.add
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $trivial-ret (result i32)
    (i32.add
      (i32.const 0)
      (i32.const 1)
    )
  )
  ;; CHECK:      (func $trivial-const (result i32)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $trivial-const (result i32)
    (i32.const 0)
  )
  ;; CHECK:      (func $trivial-const-block (result i32)
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $trivial-const-block (result i32)
    (nop)
    (i32.const 0)
  )
  ;; CHECK:      (func $bad-phi-value (result i32)
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:    (then
  ;; CHECK-NEXT:     (nop)
  ;; CHECK-NEXT:     (local.set $1
  ;; CHECK-NEXT:      (i32.load
  ;; CHECK-NEXT:       (i32.const 0)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (else
  ;; CHECK-NEXT:     (local.set $1
  ;; CHECK-NEXT:      (i32.const 0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:    (then
  ;; CHECK-NEXT:     (local.set $3
  ;; CHECK-NEXT:      (i32.const 0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (else
  ;; CHECK-NEXT:     (local.set $3
  ;; CHECK-NEXT:      (i32.const 1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $3)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $bad-phi-value (result i32)
    (if (result i32)
      (if (result i32)
        (i32.const 1)
        (then
          (i32.load
            (i32.const 0)
          )
        )
        (else
          (i32.const 0)
        )
      )
      (then
        (i32.const 0)
      )
      (else
        (i32.const 1)
      )
    )
  )
  ;; CHECK:      (func $bad-phi-value-2 (param $x i32) (result i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (block
  ;; CHECK-NEXT:    (if
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:     (then
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (local.set $2
  ;; CHECK-NEXT:       (i32.load
  ;; CHECK-NEXT:        (i32.const 0)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (else
  ;; CHECK-NEXT:      (local.set $2
  ;; CHECK-NEXT:       (i32.const 0)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (if
  ;; CHECK-NEXT:     (local.get $2)
  ;; CHECK-NEXT:     (then
  ;; CHECK-NEXT:      (local.set $x
  ;; CHECK-NEXT:       (i32.const 1)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (else
  ;; CHECK-NEXT:      (local.set $x
  ;; CHECK-NEXT:       (i32.const 2)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $x)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $bad-phi-value-2 (param $x i32) (result i32)
    (if
      (if (result i32)
        (i32.const 1)
        (then
          (i32.load
            (i32.const 0)
          )
        )
        (else
          (i32.const 0)
        )
      )
      (then
        (local.set $x (i32.const 1))
      )
      (else
        (local.set $x (i32.const 2))
      )
    )
    (local.get $x)
  )
  ;; CHECK:      (func $select (param $x i32) (result i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (select
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:    (i32.const 3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  (func $select (param $x i32) (result i32)
    (return
      (select
        (i32.const 1)
        (i32.const 2)
        (i32.const 3)
      )
    )
  )
  ;; CHECK:      (func $select-2 (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (local.set $4
  ;; CHECK-NEXT:   (i32.add
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:    (local.get $y)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (local.set $6
  ;; CHECK-NEXT:   (i32.add
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (local.set $8
  ;; CHECK-NEXT:   (i32.add
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:    (local.get $y)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $9
  ;; CHECK-NEXT:   (select
  ;; CHECK-NEXT:    (local.get $4)
  ;; CHECK-NEXT:    (local.get $6)
  ;; CHECK-NEXT:    (local.get $8)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $9)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  (func $select-2 (param $x i32) (param $y i32) (result i32)
    (return
      (select
        (i32.add
          (local.get $x)
          (local.get $y)
        )
        (i32.add
          (local.get $x)
          (i32.const 1)
        )
        (i32.add
          (i32.const 2)
          (local.get $y)
        )
      )
    )
  )
  ;; CHECK:      (func $block-phi-1 (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (block $out
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (i32.add
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (i32.const 1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (br_if $out
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (i32.add
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (i32.const 2)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $10
  ;; CHECK-NEXT:   (i32.add
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:    (i32.const 3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $10)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $block-phi-1 (param $x i32) (param $y i32) (result i32)
    (block $out
      (local.set $x
        (i32.add
          (local.get $x)
          (i32.const 1)
        )
      )
      (br_if $out (local.get $y))
      (local.set $x
        (i32.add
          (local.get $x)
          (i32.const 2)
        )
      )
    )
    (i32.add
      (local.get $x)
      (i32.const 3)
    )
  )
  ;; CHECK:      (func $block-phi-2 (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (block $out
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (br_if $out
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (i32.const 2)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $6
  ;; CHECK-NEXT:   (i32.add
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:    (i32.const 3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $6)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $block-phi-2 (param $x i32) (param $y i32) (result i32)
    (block $out
      (local.set $x
        (i32.const 1)
      )
      (br_if $out (local.get $y))
      (local.set $x
        (i32.const 2)
      )
    )
    (i32.add
      (local.get $x)
      (i32.const 3)
    )
  )
  ;; CHECK:      (func $zero_init-phi-bad_type (result f64)
  ;; CHECK-NEXT:  (local $x f64)
  ;; CHECK-NEXT:  (local $1 f64)
  ;; CHECK-NEXT:  (local $2 f64)
  ;; CHECK-NEXT:  (local $3 f64)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (then
  ;; CHECK-NEXT:     (local.set $x
  ;; CHECK-NEXT:      (f64.const 1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $x)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $zero_init-phi-bad_type (result f64)
    (local $x f64)
    (if
      (i32.const 0)
      (then
        (local.set $x
          (f64.const 1)
        )
      )
    )
    (local.get $x)
  )
  ;; CHECK:      (func $phi-bad-type (result f64)
  ;; CHECK-NEXT:  (local $0 f64)
  ;; CHECK-NEXT:  (local $1 f64)
  ;; CHECK-NEXT:  (local $2 f64)
  ;; CHECK-NEXT:  (local $3 f64)
  ;; CHECK-NEXT:  (block $label$1
  ;; CHECK-NEXT:   (if
  ;; CHECK-NEXT:    (i32.const 0)
  ;; CHECK-NEXT:    (then
  ;; CHECK-NEXT:     (local.set $0
  ;; CHECK-NEXT:      (f64.const 0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (else
  ;; CHECK-NEXT:     (local.set $0
  ;; CHECK-NEXT:      (f64.const 1)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $0)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $phi-bad-type  (result f64)
    (block $label$1 (result f64)
      (if (result f64)
        (i32.const 0)
        (then
          (f64.const 0)
        )
        (else
          (f64.const 1)
        )
      )
    )
  )
  ;; CHECK:      (func $phi-one-side-i1 (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $i i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (local $11 i32)
  ;; CHECK-NEXT:  (local $12 i32)
  ;; CHECK-NEXT:  (local $13 i32)
  ;; CHECK-NEXT:  (local $14 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (block
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $5
  ;; CHECK-NEXT:     (i32.le_s
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (local.get $y)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (if
  ;; CHECK-NEXT:     (local.get $5)
  ;; CHECK-NEXT:     (then
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (local.set $i
  ;; CHECK-NEXT:       (i32.eq
  ;; CHECK-NEXT:        (local.get $x)
  ;; CHECK-NEXT:        (local.get $y)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (else
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (local.set $i
  ;; CHECK-NEXT:       (i32.add
  ;; CHECK-NEXT:        (local.get $x)
  ;; CHECK-NEXT:        (local.get $y)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $i)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $phi-one-side-i1 (param $x i32) (param $y i32) (result i32)
    (local $i i32)
    (if
      (i32.le_s
        (local.get $x)
        (local.get $y)
      )
      (then
        (local.set $i
          (i32.eq
            (local.get $x)
            (local.get $y)
          )
        )
      )
      (else
        (local.set $i
          (i32.add
            (local.get $x)
            (local.get $y)
          )
        )
      )
    )
    (local.get $i)
  )
  ;; CHECK:      (func $call (result i32)
  ;; CHECK-NEXT:  (local $0 i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local.set $0
  ;; CHECK-NEXT:   (call $call)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $1
  ;; CHECK-NEXT:   (call $call)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i32.add
  ;; CHECK-NEXT:    (local.get $0)
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $3
  ;; CHECK-NEXT:   (call $call)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $4
  ;; CHECK-NEXT:   (i32.add
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (local.get $3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $5
  ;; CHECK-NEXT:   (i32.mul
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:    (local.get $4)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $5)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  (func $call (result i32)
    (return
      (i32.mul
        (i32.add
          (call $call)
          (call $call)
        )
        (i32.add
          (i32.const 10)
          (call $call)
        )
      )
    )
  )
  ;; CHECK:      (func $in-unreachable-1 (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (block
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (if
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (then
  ;; CHECK-NEXT:      (block
  ;; CHECK-NEXT:       (local.set $x
  ;; CHECK-NEXT:        (i32.const 1)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (nop)
  ;; CHECK-NEXT:       (return
  ;; CHECK-NEXT:        (local.get $x)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (unreachable)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (unreachable)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (else
  ;; CHECK-NEXT:      (local.set $x
  ;; CHECK-NEXT:       (i32.const 2)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $5)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $in-unreachable-1 (param $x i32) (param $y i32) (result i32)
    (if
      (local.get $x)
      (then
        (block
          (local.set $x
            (i32.const 1)
          )
          (return (local.get $x))
        )
      )
      (else
        (local.set $x
          (i32.const 2)
        )
      )
    )
    ;; no phi here!
    (return
      (local.get $x)
    )
  )
  ;; CHECK:      (func $in-unreachable-2 (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (block
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (if
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (then
  ;; CHECK-NEXT:      (block
  ;; CHECK-NEXT:       (local.set $x
  ;; CHECK-NEXT:        (i32.const 1)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (unreachable)
  ;; CHECK-NEXT:       (unreachable)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (unreachable)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (else
  ;; CHECK-NEXT:      (local.set $x
  ;; CHECK-NEXT:       (i32.const 2)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $4)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $in-unreachable-2 (param $x i32) (param $y i32) (result i32)
    (if
      (local.get $x)
      (then
        (block
          (local.set $x
            (i32.const 1)
          )
          (unreachable)
        )
      )
      (else
        (local.set $x
          (i32.const 2)
        )
      )
    )
    ;; no phi here!
    (return
      (local.get $x)
    )
  )
  ;; CHECK:      (func $in-unreachable-3 (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (block $out
  ;; CHECK-NEXT:    (block
  ;; CHECK-NEXT:     (nop)
  ;; CHECK-NEXT:     (if
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (then
  ;; CHECK-NEXT:       (block
  ;; CHECK-NEXT:        (local.set $x
  ;; CHECK-NEXT:         (i32.const 1)
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (br $out)
  ;; CHECK-NEXT:        (unreachable)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (unreachable)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (else
  ;; CHECK-NEXT:       (local.set $x
  ;; CHECK-NEXT:        (i32.const 2)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (return
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $5)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $in-unreachable-3 (param $x i32) (param $y i32) (result i32)
    (block $out
      (if
        (local.get $x)
        (then
          (block
            (local.set $x
              (i32.const 1)
            )
            (br $out)
          )
        )
        (else
          (local.set $x
            (i32.const 2)
          )
        )
      )
      ;; no phi here!
      (return
        (local.get $x)
      )
    )
    (return
      (local.get $x)
    )
  )
  ;; CHECK:      (func $in-unreachable-4 (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (block $out
  ;; CHECK-NEXT:    (block
  ;; CHECK-NEXT:     (nop)
  ;; CHECK-NEXT:     (if
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (then
  ;; CHECK-NEXT:       (block
  ;; CHECK-NEXT:        (local.set $x
  ;; CHECK-NEXT:         (i32.const 1)
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (br_table $out $out $out
  ;; CHECK-NEXT:         (i32.const 1)
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (unreachable)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (unreachable)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (else
  ;; CHECK-NEXT:       (local.set $x
  ;; CHECK-NEXT:        (i32.const 2)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (return
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $5)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $in-unreachable-4 (param $x i32) (param $y i32) (result i32)
    (block $out
      (if
        (local.get $x)
        (then
          (block
            (local.set $x
              (i32.const 1)
            )
            (br_table $out $out $out (i32.const 1))
          )
        )
        (else
          (local.set $x
            (i32.const 2)
          )
        )
      )
      ;; no phi here!
      (return
        (local.get $x)
      )
    )
    (return
      (local.get $x)
    )
  )
  ;; CHECK:      (func $in-unreachable-br_if (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (block $out
  ;; CHECK-NEXT:    (block
  ;; CHECK-NEXT:     (nop)
  ;; CHECK-NEXT:     (if
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (then
  ;; CHECK-NEXT:       (local.set $x
  ;; CHECK-NEXT:        (i32.const 1)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (nop)
  ;; CHECK-NEXT:       (br_if $out
  ;; CHECK-NEXT:        (local.get $x)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (else
  ;; CHECK-NEXT:       (local.set $x
  ;; CHECK-NEXT:        (i32.const 2)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (return
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $6)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $in-unreachable-br_if (param $x i32) (param $y i32) (result i32)
    (block $out
      (if
        (local.get $x)
        (then
          (block
            (local.set $x
              (i32.const 1)
            )
            (br_if $out
              (local.get $x)
            )
          )
        )
        (else
          (local.set $x
            (i32.const 2)
          )
        )
      )
      ;; there *IS* a phi here since it was a br_if
      (return
        (local.get $x)
      )
    )
    (return
      (local.get $x)
    )
  )
  ;; CHECK:      (func $in-unreachable-big (param $0 i32) (param $1 i32) (param $2 i32) (param $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (block $label$1
  ;; CHECK-NEXT:   (block $label$2
  ;; CHECK-NEXT:    (block $label$3
  ;; CHECK-NEXT:     (block
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (if
  ;; CHECK-NEXT:       (local.get $2)
  ;; CHECK-NEXT:       (then
  ;; CHECK-NEXT:        (block
  ;; CHECK-NEXT:         (nop)
  ;; CHECK-NEXT:         (if
  ;; CHECK-NEXT:          (local.get $0)
  ;; CHECK-NEXT:          (then
  ;; CHECK-NEXT:           (block
  ;; CHECK-NEXT:            (local.set $1
  ;; CHECK-NEXT:             (i32.const -8531)
  ;; CHECK-NEXT:            )
  ;; CHECK-NEXT:            (br $label$3)
  ;; CHECK-NEXT:            (unreachable)
  ;; CHECK-NEXT:           )
  ;; CHECK-NEXT:           (unreachable)
  ;; CHECK-NEXT:          )
  ;; CHECK-NEXT:          (else
  ;; CHECK-NEXT:           (block
  ;; CHECK-NEXT:            (local.set $1
  ;; CHECK-NEXT:             (i32.const -8531)
  ;; CHECK-NEXT:            )
  ;; CHECK-NEXT:            (br $label$1)
  ;; CHECK-NEXT:            (unreachable)
  ;; CHECK-NEXT:           )
  ;; CHECK-NEXT:           (unreachable)
  ;; CHECK-NEXT:          )
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (unreachable)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (br $label$2)
  ;; CHECK-NEXT:     (unreachable)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $6
  ;; CHECK-NEXT:     (i32.load
  ;; CHECK-NEXT:      (i32.const 0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (local.get $6)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (br $label$1)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (i32.store16
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:    (local.get $1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (i32.store16
  ;; CHECK-NEXT:   (i32.const 0)
  ;; CHECK-NEXT:   (i32.const -8531)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $in-unreachable-big (param $0 i32) (param $1 i32) (param $2 i32) (param $3 i32)
   (block $label$1
    (block $label$2
     (block $label$3
      (if
       (local.get $2)
       (then
        (if
         (local.get $0)
         (then
          (block
           (local.set $1
            (i32.const -8531)
           )
           (br $label$3)
          )
         )
         (else
          (block
           (local.set $1
            (i32.const -8531)
           )
           (br $label$1)
          )
         )
        )
       )
      )
      (br $label$2)
     )
     (drop
      (i32.load
       (i32.const 0)
      )
     )
     (br $label$1)
    )
    (i32.store16
     (i32.const 1)
     (local.get $1)
    )
    (unreachable)
   )
   (i32.store16
    (i32.const 0)
    (i32.const -8531)
   )
  )
  ;; CHECK:      (func $in-unreachable-operations (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (block
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (if
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (then
  ;; CHECK-NEXT:      (local.set $x
  ;; CHECK-NEXT:       (i32.const 1)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (else
  ;; CHECK-NEXT:      (local.set $x
  ;; CHECK-NEXT:       (i32.const 2)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  (func $in-unreachable-operations (param $x i32) (param $y i32) (result i32)
    (block
      (unreachable)
      (if
        (local.get $x)
        (then
          (local.set $x
            (i32.const 1)
          )
        )
        (else
          (local.set $x
            (i32.const 2)
          )
        )
      )
      (return
        (local.get $x)
      )
    )
  )
  ;; CHECK:      (func $merge-with-one-less (param $var$0 i32) (result i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (block $label$1
  ;; CHECK-NEXT:    (block $label$2
  ;; CHECK-NEXT:     (block $label$3
  ;; CHECK-NEXT:      (block $label$4
  ;; CHECK-NEXT:       (block $label$5
  ;; CHECK-NEXT:        (local.set $1
  ;; CHECK-NEXT:         (i32.load
  ;; CHECK-NEXT:          (i32.const 1)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (br_table $label$5 $label$4 $label$3 $label$2
  ;; CHECK-NEXT:         (local.get $1)
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (unreachable)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (unreachable)
  ;; CHECK-NEXT:       (unreachable)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (br $label$1)
  ;; CHECK-NEXT:      (unreachable)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (local.set $var$0
  ;; CHECK-NEXT:      (i32.const 8)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (nop)
  ;; CHECK-NEXT:     (local.set $3
  ;; CHECK-NEXT:      (i32.load
  ;; CHECK-NEXT:       (local.get $var$0)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (f64.store
  ;; CHECK-NEXT:      (local.get $3)
  ;; CHECK-NEXT:      (f64.const 0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (br $label$1)
  ;; CHECK-NEXT:     (unreachable)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (i32.store
  ;; CHECK-NEXT:    (local.get $var$0)
  ;; CHECK-NEXT:    (i32.const 16)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $6
  ;; CHECK-NEXT:   (i32.const 1)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $6)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $merge-with-one-less (param $var$0 i32) (result i32)
   (block $label$1
    (block $label$2
     (block $label$3
      (block $label$4
       (block $label$5
        (br_table $label$5 $label$4 $label$3 $label$2
         (i32.load
          (i32.const 1)
         )
        )
       )
       (unreachable)
      )
      (br $label$1)
     )
     (f64.store
      (i32.load
       (local.tee $var$0
        (i32.const 8)
       )
      )
      (f64.const 0)
     )
     (br $label$1)
    )
    (unreachable)
   )
   (i32.store
    (local.get $var$0)
    (i32.const 16)
   )
   (i32.const 1)
  )
  ;; CHECK:      (func $deep (param $x i32) (result i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (local $11 i32)
  ;; CHECK-NEXT:  (local $12 i32)
  ;; CHECK-NEXT:  (local $13 i32)
  ;; CHECK-NEXT:  (local $14 i32)
  ;; CHECK-NEXT:  (local $15 i32)
  ;; CHECK-NEXT:  (local $16 i32)
  ;; CHECK-NEXT:  (local $17 i32)
  ;; CHECK-NEXT:  (local $18 i32)
  ;; CHECK-NEXT:  (local $19 i32)
  ;; CHECK-NEXT:  (local $20 i32)
  ;; CHECK-NEXT:  (local $21 i32)
  ;; CHECK-NEXT:  (local $22 i32)
  ;; CHECK-NEXT:  (local $23 i32)
  ;; CHECK-NEXT:  (local $24 i32)
  ;; CHECK-NEXT:  (local $25 i32)
  ;; CHECK-NEXT:  (local $26 i32)
  ;; CHECK-NEXT:  (local $27 i32)
  ;; CHECK-NEXT:  (local $28 i32)
  ;; CHECK-NEXT:  (local $29 i32)
  ;; CHECK-NEXT:  (local $30 i32)
  ;; CHECK-NEXT:  (local $31 i32)
  ;; CHECK-NEXT:  (local $32 i32)
  ;; CHECK-NEXT:  (local $33 i32)
  ;; CHECK-NEXT:  (local $34 i32)
  ;; CHECK-NEXT:  (local $35 i32)
  ;; CHECK-NEXT:  (local $36 i32)
  ;; CHECK-NEXT:  (local $37 i32)
  ;; CHECK-NEXT:  (local $38 i32)
  ;; CHECK-NEXT:  (local $39 i32)
  ;; CHECK-NEXT:  (local $40 i32)
  ;; CHECK-NEXT:  (local $41 i32)
  ;; CHECK-NEXT:  (local $42 i32)
  ;; CHECK-NEXT:  (local $43 i32)
  ;; CHECK-NEXT:  (local $44 i32)
  ;; CHECK-NEXT:  (local $45 i32)
  ;; CHECK-NEXT:  (local $46 i32)
  ;; CHECK-NEXT:  (local $47 i32)
  ;; CHECK-NEXT:  (local $48 i32)
  ;; CHECK-NEXT:  (local $49 i32)
  ;; CHECK-NEXT:  (local $50 i32)
  ;; CHECK-NEXT:  (local $51 i32)
  ;; CHECK-NEXT:  (local $52 i32)
  ;; CHECK-NEXT:  (local $53 i32)
  ;; CHECK-NEXT:  (local $54 i32)
  ;; CHECK-NEXT:  (local $55 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.xor
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.mul
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.xor
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.mul
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.xor
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.mul
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.xor
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.mul
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.xor
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.mul
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.xor
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.mul
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.xor
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.mul
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.xor
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.mul
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.xor
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.mul
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.xor
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.mul
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.xor
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.mul
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.xor
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.mul
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.xor
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.mul
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1234)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $x)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $deep (param $x i32) (result i32)
    (local.set $x (i32.xor (local.get $x) (i32.const 1234)))
    (local.set $x (i32.mul (local.get $x) (i32.const 1234)))
    (local.set $x (i32.xor (local.get $x) (i32.const 1234)))
    (local.set $x (i32.mul (local.get $x) (i32.const 1234)))
    (local.set $x (i32.xor (local.get $x) (i32.const 1234)))
    (local.set $x (i32.mul (local.get $x) (i32.const 1234)))
    (local.set $x (i32.xor (local.get $x) (i32.const 1234)))
    (local.set $x (i32.mul (local.get $x) (i32.const 1234)))
    (local.set $x (i32.xor (local.get $x) (i32.const 1234)))
    (local.set $x (i32.mul (local.get $x) (i32.const 1234)))
    (local.set $x (i32.xor (local.get $x) (i32.const 1234)))
    (local.set $x (i32.mul (local.get $x) (i32.const 1234)))
    (local.set $x (i32.xor (local.get $x) (i32.const 1234)))
    (local.set $x (i32.mul (local.get $x) (i32.const 1234)))
    (local.set $x (i32.xor (local.get $x) (i32.const 1234)))
    (local.set $x (i32.mul (local.get $x) (i32.const 1234)))
    (local.set $x (i32.xor (local.get $x) (i32.const 1234)))
    (local.set $x (i32.mul (local.get $x) (i32.const 1234)))
    (local.set $x (i32.xor (local.get $x) (i32.const 1234)))
    (local.set $x (i32.mul (local.get $x) (i32.const 1234)))
    (local.set $x (i32.xor (local.get $x) (i32.const 1234)))
    (local.set $x (i32.mul (local.get $x) (i32.const 1234)))
    (local.set $x (i32.xor (local.get $x) (i32.const 1234)))
    (local.set $x (i32.mul (local.get $x) (i32.const 1234)))
    (local.set $x (i32.xor (local.get $x) (i32.const 1234)))
    (local.set $x (i32.mul (local.get $x) (i32.const 1234)))
    (local.get $x)
  )
  ;; CHECK:      (func $two-pcs (param $x i64) (param $y i64) (param $t i64) (result i64)
  ;; CHECK-NEXT:  (local $3 i64)
  ;; CHECK-NEXT:  (local $4 i64)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i64)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i64)
  ;; CHECK-NEXT:  (local $9 i64)
  ;; CHECK-NEXT:  (local $10 i64)
  ;; CHECK-NEXT:  (local $11 i64)
  ;; CHECK-NEXT:  (local $12 i64)
  ;; CHECK-NEXT:  (local $13 i64)
  ;; CHECK-NEXT:  (local $14 i64)
  ;; CHECK-NEXT:  (local $15 i32)
  ;; CHECK-NEXT:  (local $16 i64)
  ;; CHECK-NEXT:  (local $17 i64)
  ;; CHECK-NEXT:  (local $18 i64)
  ;; CHECK-NEXT:  (local $19 i64)
  ;; CHECK-NEXT:  (local $20 i64)
  ;; CHECK-NEXT:  (local $21 i64)
  ;; CHECK-NEXT:  (local $22 i64)
  ;; CHECK-NEXT:  (local $23 i64)
  ;; CHECK-NEXT:  (local $24 i64)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (block
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $5
  ;; CHECK-NEXT:     (i64.lt_s
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (local.get $y)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (if
  ;; CHECK-NEXT:     (local.get $5)
  ;; CHECK-NEXT:     (then
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (local.set $7
  ;; CHECK-NEXT:       (i64.eqz
  ;; CHECK-NEXT:        (local.get $x)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (if
  ;; CHECK-NEXT:       (local.get $7)
  ;; CHECK-NEXT:       (then
  ;; CHECK-NEXT:        (nop)
  ;; CHECK-NEXT:        (nop)
  ;; CHECK-NEXT:        (nop)
  ;; CHECK-NEXT:        (local.set $t
  ;; CHECK-NEXT:         (i64.add
  ;; CHECK-NEXT:          (local.get $x)
  ;; CHECK-NEXT:          (local.get $y)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (else
  ;; CHECK-NEXT:        (nop)
  ;; CHECK-NEXT:        (nop)
  ;; CHECK-NEXT:        (nop)
  ;; CHECK-NEXT:        (local.set $t
  ;; CHECK-NEXT:         (i64.sub
  ;; CHECK-NEXT:          (local.get $x)
  ;; CHECK-NEXT:          (local.get $y)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (else
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (local.set $15
  ;; CHECK-NEXT:       (i64.eqz
  ;; CHECK-NEXT:        (local.get $y)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (if
  ;; CHECK-NEXT:       (local.get $15)
  ;; CHECK-NEXT:       (then
  ;; CHECK-NEXT:        (nop)
  ;; CHECK-NEXT:        (nop)
  ;; CHECK-NEXT:        (nop)
  ;; CHECK-NEXT:        (local.set $t
  ;; CHECK-NEXT:         (i64.mul
  ;; CHECK-NEXT:          (local.get $x)
  ;; CHECK-NEXT:          (local.get $y)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (else
  ;; CHECK-NEXT:        (nop)
  ;; CHECK-NEXT:        (nop)
  ;; CHECK-NEXT:        (nop)
  ;; CHECK-NEXT:        (local.set $t
  ;; CHECK-NEXT:         (i64.div_s
  ;; CHECK-NEXT:          (local.get $x)
  ;; CHECK-NEXT:          (local.get $y)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $t)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $23)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $two-pcs (param $x i64) (param $y i64) (param $t i64) (result i64)
    (if
      (i64.lt_s
        (local.get $x)
        (local.get $y)
      )
      (then
        (if
          (i64.eqz
            (local.get $x)
          )
          (then
            (local.set $t
              (i64.add
                (local.get $x)
                (local.get $y)
              )
            )
          )
          (else
            (local.set $t
              (i64.sub
                (local.get $x)
                (local.get $y)
              )
            )
          )
        )
      )
      (else
        (if
          (i64.eqz
            (local.get $y)
          )
          (then
            (local.set $t
              (i64.mul
                (local.get $x)
                (local.get $y)
              )
            )
          )
          (else
            (local.set $t
              (i64.div_s
                (local.get $x)
                (local.get $y)
              )
            )
          )
        )
      )
    )
    (return (local.get $t))
  )
  ;; CHECK:      (func $loop-1 (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $y
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (loop $loopy
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $4
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $4)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $5)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $loop-1 (param $x i32) (param $y i32) (result i32)
    (local.set $x (i32.const 1))
    (local.set $y (i32.const 2))
    (loop $loopy
    )
    ;; neither needed a phi
    (return (i32.add (local.get $x) (local.get $y)))
  )
  ;; CHECK:      (func $loop-2 (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $y
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (loop $loopy
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (i32.add
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (i32.const 3)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $y
  ;; CHECK-NEXT:     (i32.add
  ;; CHECK-NEXT:      (local.get $y)
  ;; CHECK-NEXT:      (i32.const 4)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $8
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $8)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $9)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $loop-2 (param $x i32) (param $y i32) (result i32)
    (local.set $x (i32.const 1))
    (local.set $y (i32.const 2))
    (loop $loopy
      (local.set $x (i32.add (local.get $x) (i32.const 3)))
      (local.set $y (i32.add (local.get $y) (i32.const 4)))
    )
    ;; neither needed a phi
    (return (i32.add (local.get $x) (local.get $y)))
  )
  ;; CHECK:      (func $loop-3 (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (local $11 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $y
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (loop $loopy
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (i32.add
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (i32.const 3)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $y
  ;; CHECK-NEXT:     (i32.add
  ;; CHECK-NEXT:      (local.get $y)
  ;; CHECK-NEXT:      (i32.const 4)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (br_if $loopy
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $9
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $9)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $10)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $loop-3 (param $x i32) (param $y i32) (result i32)
    (local.set $x (i32.const 1))
    (local.set $y (i32.const 2))
    (loop $loopy
      (local.set $x (i32.add (local.get $x) (i32.const 3)))
      (local.set $y (i32.add (local.get $y) (i32.const 4)))
      (br_if $loopy (local.get $y))
    )
    ;; both needed
    (return (i32.add (local.get $x) (local.get $y)))
  )
  ;; CHECK:      (func $loop-4 (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $y
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (loop $loopy
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (i32.add
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (i32.const 3)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (br_if $loopy
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $7
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $7)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $8)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $loop-4 (param $x i32) (param $y i32) (result i32)
    (local.set $x (i32.const 1))
    (local.set $y (i32.const 2))
    (loop $loopy
      (local.set $x (i32.add (local.get $x) (i32.const 3)))
      (br_if $loopy (local.get $y))
    )
    ;; only x needed a phi
    (return (i32.add (local.get $x) (local.get $y)))
  )
  ;; CHECK:      (func $loop-5 (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $y
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (loop $loopy
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (i32.add
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (i32.const 3)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $y
  ;; CHECK-NEXT:     (i32.const 2)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (br_if $loopy
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $7
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $7)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $8)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $loop-5 (param $x i32) (param $y i32) (result i32)
    (local.set $x (i32.const 1))
    (local.set $y (i32.const 2))
    (loop $loopy
      (local.set $x (i32.add (local.get $x) (i32.const 3)))
      (local.set $y (i32.const 2)) ;; same value
      (br_if $loopy (local.get $y))
    )
    ;; only x needed a phi
    (return (i32.add (local.get $x) (local.get $y)))
  )
  ;; CHECK:      (func $loop-6 (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $y
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (loop $loopy
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (i32.add
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (i32.const 3)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (br_if $loopy
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $8
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $8)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $9)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $loop-6 (param $x i32) (param $y i32) (result i32)
    (local.set $x (i32.const 1))
    (local.set $y (i32.const 2))
    (loop $loopy
      (local.set $x (i32.add (local.get $x) (i32.const 3)))
      (local.set $y (local.get $y)) ;; same value
      (br_if $loopy (local.get $y))
    )
    ;; only x needed a phi
    (return (i32.add (local.get $x) (local.get $y)))
  )
  ;; CHECK:      (func $loop-7 (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $y
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (loop $loopy
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (i32.add
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (i32.const 3)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $y
  ;; CHECK-NEXT:     (i32.const 5)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (br_if $loopy
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $7
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $7)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $8)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $loop-7 (param $x i32) (param $y i32) (result i32)
    (local.set $x (i32.const 1))
    (local.set $y (i32.const 2))
    (loop $loopy
      (local.set $x (i32.add (local.get $x) (i32.const 3)))
      (local.set $y (i32.const 5)) ;; different!
      (br_if $loopy (local.get $y))
    )
    ;; y changed but we don't need a phi for it
    (return (i32.add (local.get $x) (local.get $y)))
  )
  ;; CHECK:      (func $loop-8 (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $z i32)
  ;; CHECK-NEXT:  (local $w i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (local $11 i32)
  ;; CHECK-NEXT:  (local $12 i32)
  ;; CHECK-NEXT:  (local $13 i32)
  ;; CHECK-NEXT:  (local $14 i32)
  ;; CHECK-NEXT:  (local $15 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $y
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (loop $loopy
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $z
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $w
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $y
  ;; CHECK-NEXT:     (i32.const 4)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (br_if $loopy
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $9
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $12
  ;; CHECK-NEXT:    (i32.sub
  ;; CHECK-NEXT:     (local.get $z)
  ;; CHECK-NEXT:     (local.get $w)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $13
  ;; CHECK-NEXT:    (i32.mul
  ;; CHECK-NEXT:     (local.get $9)
  ;; CHECK-NEXT:     (local.get $12)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $13)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $14)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $loop-8 (param $x i32) (param $y i32) (result i32)
    (local $z i32)
    (local $w i32)
    (local.set $x (i32.const 1))
    (local.set $y (i32.const 2))
    (loop $loopy
      (local.set $z (local.get $x))
      (local.set $w (local.get $y))
      (local.set $x (i32.const 1)) ;; same!
      (local.set $y (i32.const 4)) ;; different!
      (br_if $loopy (local.get $y))
    )
    ;; x is always 3, and y needs a phi.
    ;; each is also copied to another local, which we need
    ;; to handle properly
    (return
      (i32.mul
        (i32.add
          (local.get $x)
          (local.get $y)
        )
        (i32.sub
          (local.get $z)
          (local.get $w)
        )
      )
    )
  )
  ;; CHECK:      (func $loop-9 (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $t i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (local $11 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $y
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (loop $loopy
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $t
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $y
  ;; CHECK-NEXT:     (local.get $t)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (br_if $loopy
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $9
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $9)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $10)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $loop-9 (param $x i32) (param $y i32) (result i32)
    (local $t i32)
    (local.set $x (i32.const 1))
    (local.set $y (i32.const 2))
    (loop $loopy
      (local.set $t (local.get $x))
      (local.set $x (local.get $y))
      (local.set $y (local.get $t))
      (br_if $loopy (local.get $t))
    )
    ;; x and y swapped, so both need phis
    (return (i32.add (local.get $x) (local.get $y)))
  )
  ;; CHECK:      (func $loop-10 (param $x i32) (param $y i32) (result i32)
  ;; CHECK-NEXT:  (local $t i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (local $11 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $y
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (loop $loopy
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $t
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $y
  ;; CHECK-NEXT:     (local.get $t)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (br_if $loopy
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $9
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $9)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $10)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $loop-10 (param $x i32) (param $y i32) (result i32)
    (local $t i32)
    (local.set $x (i32.const 1))
    (local.set $y (i32.const 1))
    (loop $loopy ;; we swap the values. but we need a deeper analysis to figure that out...
      (local.set $t (local.get $x))
      (local.set $x (local.get $y))
      (local.set $y (local.get $t))
      (br_if $loopy (local.get $t))
    )
    ;; x and y swapped, but the same constant was swapped
    (return (i32.add (local.get $x) (local.get $y)))
  )
  ;; CHECK:      (func $loop-multicond-1 (param $x i32) (param $y i32) (param $z i32) (result i32)
  ;; CHECK-NEXT:  (local $t i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (local $11 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $y
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $z
  ;; CHECK-NEXT:    (i32.const 3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (loop $loopy
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (i32.const 4)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (br_if $loopy
  ;; CHECK-NEXT:     (local.get $t)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $y
  ;; CHECK-NEXT:     (i32.const 5)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (br_if $loopy
  ;; CHECK-NEXT:     (local.get $t)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (local.set $z
  ;; CHECK-NEXT:     (i32.const 6)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $9
  ;; CHECK-NEXT:    (select
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:     (local.get $z)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $9)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $10)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $loop-multicond-1 (param $x i32) (param $y i32) (param $z i32) (result i32)
    (local $t i32)
    (local.set $x (i32.const 1))
    (local.set $y (i32.const 2))
    (local.set $z (i32.const 3))
    (loop $loopy
      (local.set $x (i32.const 4))
      (br_if $loopy (local.get $t))
      (local.set $y (i32.const 5))
      (br_if $loopy (local.get $t))
      (local.set $z (i32.const 6))
    )
    (return (select (local.get $x) (local.get $y) (local.get $z)))
  )
  ;; CHECK:      (func $loop-multicond-2 (param $x i32) (param $y i32) (param $z i32) (result i32)
  ;; CHECK-NEXT:  (local $t i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (local $11 i32)
  ;; CHECK-NEXT:  (local $12 i32)
  ;; CHECK-NEXT:  (local $13 i32)
  ;; CHECK-NEXT:  (local $14 i32)
  ;; CHECK-NEXT:  (local $15 i32)
  ;; CHECK-NEXT:  (local $16 i32)
  ;; CHECK-NEXT:  (local $17 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $y
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $z
  ;; CHECK-NEXT:    (i32.const 3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (loop $loopy
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $x
  ;; CHECK-NEXT:     (i32.add
  ;; CHECK-NEXT:      (local.get $x)
  ;; CHECK-NEXT:      (i32.const 4)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (br_if $loopy
  ;; CHECK-NEXT:     (local.get $t)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $y
  ;; CHECK-NEXT:     (i32.add
  ;; CHECK-NEXT:      (local.get $y)
  ;; CHECK-NEXT:      (i32.const 5)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (br_if $loopy
  ;; CHECK-NEXT:     (local.get $t)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $z
  ;; CHECK-NEXT:     (i32.add
  ;; CHECK-NEXT:      (local.get $z)
  ;; CHECK-NEXT:      (i32.const 6)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $15
  ;; CHECK-NEXT:    (select
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:     (local.get $z)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $15)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $16)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $loop-multicond-2 (param $x i32) (param $y i32) (param $z i32) (result i32)
    (local $t i32)
    (local.set $x (i32.const 1))
    (local.set $y (i32.const 2))
    (local.set $z (i32.const 3))
    (loop $loopy
      (local.set $x (i32.add (local.get $x) (i32.const 4)))
      (br_if $loopy (local.get $t))
      (local.set $y (i32.add (local.get $y) (i32.const 5)))
      (br_if $loopy (local.get $t))
      (local.set $z (i32.add (local.get $z) (i32.const 6)))
    )
    (return (select (local.get $x) (local.get $y) (local.get $z)))
  )
  ;; CHECK:      (func $loop-block-1 (param $x i32) (param $y i32) (param $z i32) (result i32)
  ;; CHECK-NEXT:  (local $t i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (local $11 i32)
  ;; CHECK-NEXT:  (local $12 i32)
  ;; CHECK-NEXT:  (local $13 i32)
  ;; CHECK-NEXT:  (local $14 i32)
  ;; CHECK-NEXT:  (local $15 i32)
  ;; CHECK-NEXT:  (local $16 i32)
  ;; CHECK-NEXT:  (local $17 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $y
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $z
  ;; CHECK-NEXT:    (i32.const 3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (loop $loopy
  ;; CHECK-NEXT:    (block $out
  ;; CHECK-NEXT:     (nop)
  ;; CHECK-NEXT:     (nop)
  ;; CHECK-NEXT:     (local.set $x
  ;; CHECK-NEXT:      (i32.add
  ;; CHECK-NEXT:       (local.get $x)
  ;; CHECK-NEXT:       (i32.const 4)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (nop)
  ;; CHECK-NEXT:     (br_if $out
  ;; CHECK-NEXT:      (local.get $t)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (nop)
  ;; CHECK-NEXT:     (nop)
  ;; CHECK-NEXT:     (local.set $y
  ;; CHECK-NEXT:      (i32.add
  ;; CHECK-NEXT:       (local.get $y)
  ;; CHECK-NEXT:       (i32.const 5)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (nop)
  ;; CHECK-NEXT:     (br_if $out
  ;; CHECK-NEXT:      (local.get $t)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (nop)
  ;; CHECK-NEXT:     (nop)
  ;; CHECK-NEXT:     (local.set $z
  ;; CHECK-NEXT:      (i32.add
  ;; CHECK-NEXT:       (local.get $z)
  ;; CHECK-NEXT:       (i32.const 6)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (br $loopy)
  ;; CHECK-NEXT:     (unreachable)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $15
  ;; CHECK-NEXT:    (select
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:     (local.get $z)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $15)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $16)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $loop-block-1 (param $x i32) (param $y i32) (param $z i32) (result i32)
    (local $t i32)
    (local.set $x (i32.const 1))
    (local.set $y (i32.const 2))
    (local.set $z (i32.const 3))
    (loop $loopy
      (block $out
        (local.set $x (i32.add (local.get $x) (i32.const 4)))
        (br_if $out (local.get $t))
        (local.set $y (i32.add (local.get $y) (i32.const 5)))
        (br_if $out (local.get $t))
        (local.set $z (i32.add (local.get $z) (i32.const 6)))
        (br $loopy)
      )
    )
    (return (select (local.get $x) (local.get $y) (local.get $z)))
  )
  ;; CHECK:      (func $loop-block-2 (param $x i32) (param $y i32) (param $z i32) (result i32)
  ;; CHECK-NEXT:  (local $t i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (local $11 i32)
  ;; CHECK-NEXT:  (local $12 i32)
  ;; CHECK-NEXT:  (local $13 i32)
  ;; CHECK-NEXT:  (local $14 i32)
  ;; CHECK-NEXT:  (local $15 i32)
  ;; CHECK-NEXT:  (local $16 i32)
  ;; CHECK-NEXT:  (local $17 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.const 1)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $y
  ;; CHECK-NEXT:    (i32.const 2)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (local.set $z
  ;; CHECK-NEXT:    (i32.const 3)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (block $out
  ;; CHECK-NEXT:    (loop $loopy
  ;; CHECK-NEXT:     (block
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (local.set $x
  ;; CHECK-NEXT:       (i32.add
  ;; CHECK-NEXT:        (local.get $x)
  ;; CHECK-NEXT:        (i32.const 4)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (br_if $out
  ;; CHECK-NEXT:       (local.get $t)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (local.set $y
  ;; CHECK-NEXT:       (i32.add
  ;; CHECK-NEXT:        (local.get $y)
  ;; CHECK-NEXT:        (i32.const 5)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (br_if $out
  ;; CHECK-NEXT:       (local.get $t)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (local.set $z
  ;; CHECK-NEXT:       (i32.add
  ;; CHECK-NEXT:        (local.get $z)
  ;; CHECK-NEXT:        (i32.const 6)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (br $loopy)
  ;; CHECK-NEXT:      (unreachable)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (unreachable)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $15
  ;; CHECK-NEXT:    (select
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (local.get $y)
  ;; CHECK-NEXT:     (local.get $z)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (return
  ;; CHECK-NEXT:    (local.get $15)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $16)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $loop-block-2 (param $x i32) (param $y i32) (param $z i32) (result i32)
    (local $t i32)
    (local.set $x (i32.const 1))
    (local.set $y (i32.const 2))
    (local.set $z (i32.const 3))
    (block $out
      (loop $loopy
        (local.set $x (i32.add (local.get $x) (i32.const 4)))
        (br_if $out (local.get $t))
        (local.set $y (i32.add (local.get $y) (i32.const 5)))
        (br_if $out (local.get $t))
        (local.set $z (i32.add (local.get $z) (i32.const 6)))
        (br $loopy)
      )
    )
    (return (select (local.get $x) (local.get $y) (local.get $z)))
  )
  ;; CHECK:      (func $bad-phi-type (param $var$0 i64) (param $var$1 i64) (param $var$2 i32) (param $var$3 f32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 f64)
  ;; CHECK-NEXT:  (local $9 f64)
  ;; CHECK-NEXT:  (local $10 f64)
  ;; CHECK-NEXT:  (local $11 f64)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (if
  ;; CHECK-NEXT:   (local.get $var$2)
  ;; CHECK-NEXT:   (then
  ;; CHECK-NEXT:    (loop $label$2
  ;; CHECK-NEXT:     (block
  ;; CHECK-NEXT:      (block
  ;; CHECK-NEXT:       (block $label$3
  ;; CHECK-NEXT:        (if
  ;; CHECK-NEXT:         (i32.const 0)
  ;; CHECK-NEXT:         (then
  ;; CHECK-NEXT:          (unreachable)
  ;; CHECK-NEXT:          (unreachable)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (nop)
  ;; CHECK-NEXT:        (nop)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (local.set $6
  ;; CHECK-NEXT:        (i32.const 0)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (if
  ;; CHECK-NEXT:        (local.get $6)
  ;; CHECK-NEXT:        (then
  ;; CHECK-NEXT:         (unreachable)
  ;; CHECK-NEXT:         (unreachable)
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (br_if $label$2
  ;; CHECK-NEXT:       (local.get $var$2)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (nop)
  ;; CHECK-NEXT:     (local.set $10
  ;; CHECK-NEXT:      (f64.const 0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (drop
  ;; CHECK-NEXT:     (local.get $10)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $bad-phi-type (param $var$0 i64) (param $var$1 i64) (param $var$2 i32) (param $var$3 f32)
   (if
    (local.get $var$2)
    (then
     (drop
      (loop $label$2 (result f64)
       (if
        (block $label$3 (result i32)
         (if
          (i32.const 0)
          (then
           (unreachable)
          )
         )
         (nop)
         (i32.const 0)
        )
        (then
         (unreachable)
        )
       )
       (br_if $label$2
        (local.get $var$2)
       )
       (f64.const 0)
      )
     )
    )
   )
  )
  ;; CHECK:      (func $loop-unreachable
  ;; CHECK-NEXT:  (local $var$0 i32)
  ;; CHECK-NEXT:  (local $var$1 f64)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (local $11 f64)
  ;; CHECK-NEXT:  (local $12 f64)
  ;; CHECK-NEXT:  (local $13 f64)
  ;; CHECK-NEXT:  (loop $label$1
  ;; CHECK-NEXT:   (block
  ;; CHECK-NEXT:    (block $label$2
  ;; CHECK-NEXT:     (block $label$3
  ;; CHECK-NEXT:      (block $label$4
  ;; CHECK-NEXT:       (if
  ;; CHECK-NEXT:        (i32.const 1337)
  ;; CHECK-NEXT:        (then
  ;; CHECK-NEXT:         (unreachable)
  ;; CHECK-NEXT:         (unreachable)
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (nop)
  ;; CHECK-NEXT:       (nop)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (loop $label$6
  ;; CHECK-NEXT:       (block $label$7
  ;; CHECK-NEXT:        (nop)
  ;; CHECK-NEXT:        (local.set $6
  ;; CHECK-NEXT:         (local.get $var$0)
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (br_if $label$7
  ;; CHECK-NEXT:         (i32.const 65535)
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (nop)
  ;; CHECK-NEXT:        (drop
  ;; CHECK-NEXT:         (local.get $var$0)
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (nop)
  ;; CHECK-NEXT:        (local.set $6
  ;; CHECK-NEXT:         (local.get $var$0)
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (br_if $label$7
  ;; CHECK-NEXT:         (i32.const 0)
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (nop)
  ;; CHECK-NEXT:        (drop
  ;; CHECK-NEXT:         (local.get $var$0)
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (unreachable)
  ;; CHECK-NEXT:        (unreachable)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (nop)
  ;; CHECK-NEXT:       (br_if $label$6
  ;; CHECK-NEXT:        (local.get $6)
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (nop)
  ;; CHECK-NEXT:     (nop)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (br $label$1)
  ;; CHECK-NEXT:    (unreachable)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  (func $loop-unreachable
   (local $var$0 i32)
   (local $var$1 f64)
   (loop $label$1
    (local.set $var$1
     (block $label$2 (result f64)
      (block $label$3
       (local.set $var$0
        (block $label$4 (result i32)
         (if
          (i32.const 1337)
          (then
           (unreachable)
          )
         )
         (local.get $var$0)
        )
       )
       (loop $label$6
        (br_if $label$6
         (block $label$7 (result i32)
          (drop
           (br_if $label$7
            (local.get $var$0)
            (i32.const 65535)
           )
          )
          (drop
           (br_if $label$7
            (local.get $var$0)
            (i32.const 0)
           )
          )
          (unreachable)
         )
        )
       )
      )
      (local.get $var$1)
     )
    )
    (br $label$1)
   )
  )
  ;; CHECK:      (func $phi-value-turns-bad (result f64)
  ;; CHECK-NEXT:  (local $var$0 i32)
  ;; CHECK-NEXT:  (local $var$1 i32)
  ;; CHECK-NEXT:  (local $var$2 f32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (local $11 i32)
  ;; CHECK-NEXT:  (local $12 f32)
  ;; CHECK-NEXT:  (local $13 f32)
  ;; CHECK-NEXT:  (local $14 f32)
  ;; CHECK-NEXT:  (local $15 f32)
  ;; CHECK-NEXT:  (local $16 f64)
  ;; CHECK-NEXT:  (local $17 f64)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (block
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (local.set $var$0
  ;; CHECK-NEXT:     (i32.atomic.rmw16.sub_u offset=22
  ;; CHECK-NEXT:      (i32.const 0)
  ;; CHECK-NEXT:      (i32.const 0)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (nop)
  ;; CHECK-NEXT:    (if
  ;; CHECK-NEXT:     (local.get $var$0)
  ;; CHECK-NEXT:     (then
  ;; CHECK-NEXT:      (unreachable)
  ;; CHECK-NEXT:      (unreachable)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:     (else
  ;; CHECK-NEXT:      (block
  ;; CHECK-NEXT:       (block
  ;; CHECK-NEXT:        (loop $label$3
  ;; CHECK-NEXT:         (block $label$4
  ;; CHECK-NEXT:          (nop)
  ;; CHECK-NEXT:          (local.set $6
  ;; CHECK-NEXT:           (local.get $var$0)
  ;; CHECK-NEXT:          )
  ;; CHECK-NEXT:          (br_if $label$4
  ;; CHECK-NEXT:           (i32.const 1)
  ;; CHECK-NEXT:          )
  ;; CHECK-NEXT:          (nop)
  ;; CHECK-NEXT:          (nop)
  ;; CHECK-NEXT:          (local.set $6
  ;; CHECK-NEXT:           (i32.clz
  ;; CHECK-NEXT:            (local.get $var$0)
  ;; CHECK-NEXT:           )
  ;; CHECK-NEXT:          )
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:         (nop)
  ;; CHECK-NEXT:         (nop)
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:        (nop)
  ;; CHECK-NEXT:        (if
  ;; CHECK-NEXT:         (local.get $6)
  ;; CHECK-NEXT:         (then
  ;; CHECK-NEXT:          (nop)
  ;; CHECK-NEXT:         )
  ;; CHECK-NEXT:        )
  ;; CHECK-NEXT:       )
  ;; CHECK-NEXT:       (nop)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (nop)
  ;; CHECK-NEXT:      (local.set $14
  ;; CHECK-NEXT:       (f32.const 1)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $16)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $phi-value-turns-bad (result f64)
   (local $var$0 i32)
   (local $var$1 i32)
   (local $var$2 f32)
   (local.set $var$2
    (if (result f32)
     (local.tee $var$0
      (i32.atomic.rmw16.sub_u offset=22
       (i32.const 0)
       (i32.const 0)
      )
     )
     (then
      (unreachable)
     )
     (else
      (block (result f32)
       (if
        (loop $label$3 (result i32)
         (block $label$4 (result i32)
          (i32.clz
           (br_if $label$4
            (local.get $var$0)
            (i32.const 1)
           )
          )
         )
        )
        (then
         (nop)
        )
       )
       (f32.const 1)
      )
     )
    )
   )
   (unreachable)
  )
  ;; CHECK:      (func $multi-use (param $x i32) (result i32)
  ;; CHECK-NEXT:  (local $temp i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $temp
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $8
  ;; CHECK-NEXT:   (i32.add
  ;; CHECK-NEXT:    (local.get $temp)
  ;; CHECK-NEXT:    (local.get $temp)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $8)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $multi-use (param $x i32) (result i32)
    (local $temp i32)
    (local.set $temp (i32.add (local.get $x) (i32.const 1)))
    (i32.add (local.get $temp) (local.get $temp))
  )
  ;; CHECK:      (func $multi-use-2 (param $x i32) (result i32)
  ;; CHECK-NEXT:  (local $temp i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (local $8 i32)
  ;; CHECK-NEXT:  (local $9 i32)
  ;; CHECK-NEXT:  (local $10 i32)
  ;; CHECK-NEXT:  (block
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $temp
  ;; CHECK-NEXT:    (i32.add
  ;; CHECK-NEXT:     (local.get $x)
  ;; CHECK-NEXT:     (i32.const 1)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (local.set $x
  ;; CHECK-NEXT:    (i32.mul
  ;; CHECK-NEXT:     (local.get $temp)
  ;; CHECK-NEXT:     (i32.const 2)
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:   (nop)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $10
  ;; CHECK-NEXT:   (i32.sub
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:    (local.get $temp)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $10)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $multi-use-2 (param $x i32) (result i32)
    (local $temp i32)
    (local.set $temp (i32.add (local.get $x) (i32.const 1)))
    (local.set $x (i32.mul (local.get $temp) (i32.const 2)))
    (i32.sub (local.get $x) (local.get $temp))
  )
  ;; CHECK:      (func $many-single-uses-with-param (param $x i32) (result i32)
  ;; CHECK-NEXT:  (local $1 i32)
  ;; CHECK-NEXT:  (local $2 i32)
  ;; CHECK-NEXT:  (local $3 i32)
  ;; CHECK-NEXT:  (local $4 i32)
  ;; CHECK-NEXT:  (local $5 i32)
  ;; CHECK-NEXT:  (local $6 i32)
  ;; CHECK-NEXT:  (local $7 i32)
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (local.set $2
  ;; CHECK-NEXT:   (i32.mul
  ;; CHECK-NEXT:    (i32.const 10)
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (nop)
  ;; CHECK-NEXT:  (local.set $4
  ;; CHECK-NEXT:   (i32.ctz
  ;; CHECK-NEXT:    (local.get $x)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $5
  ;; CHECK-NEXT:   (i32.sub
  ;; CHECK-NEXT:    (local.get $4)
  ;; CHECK-NEXT:    (i32.const 20)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $6
  ;; CHECK-NEXT:   (i32.add
  ;; CHECK-NEXT:    (local.get $2)
  ;; CHECK-NEXT:    (local.get $5)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.set $7
  ;; CHECK-NEXT:   (i32.eqz
  ;; CHECK-NEXT:    (local.get $6)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (return
  ;; CHECK-NEXT:   (local.get $7)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  (func $many-single-uses-with-param (param $x i32) (result i32)
    (return
      (i32.eqz
        (i32.add
          (i32.mul
            (i32.const 10)
            (local.get $x)
          )
          (i32.sub
            (i32.ctz
              (local.get $x)
            )
            (i32.const 20)
          )
        )
      )
    )
  )
 ;; CHECK:      (func $replaced-print-internal (param $var$0 i32)
 ;; CHECK-NEXT:  (local $var$1 i32)
 ;; CHECK-NEXT:  (local $var$2 i32)
 ;; CHECK-NEXT:  (local $var$3 i32)
 ;; CHECK-NEXT:  (local $4 i32)
 ;; CHECK-NEXT:  (local $5 i32)
 ;; CHECK-NEXT:  (local $6 i32)
 ;; CHECK-NEXT:  (local $7 i32)
 ;; CHECK-NEXT:  (local $8 i32)
 ;; CHECK-NEXT:  (local $9 i32)
 ;; CHECK-NEXT:  (local $10 i32)
 ;; CHECK-NEXT:  (local $11 i32)
 ;; CHECK-NEXT:  (local $12 i32)
 ;; CHECK-NEXT:  (local $13 i32)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (local.set $var$0
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (local.get $var$0)
 ;; CHECK-NEXT:    (i32.const -7)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (local.get $var$0)
 ;; CHECK-NEXT:   (then
 ;; CHECK-NEXT:    (block $label$2
 ;; CHECK-NEXT:     (block $label$3
 ;; CHECK-NEXT:      (nop)
 ;; CHECK-NEXT:      (local.set $var$1
 ;; CHECK-NEXT:       (local.get $var$0)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (nop)
 ;; CHECK-NEXT:      (local.set $8
 ;; CHECK-NEXT:       (i32.const 12)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (br_if $label$3
 ;; CHECK-NEXT:       (local.get $8)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (unreachable)
 ;; CHECK-NEXT:      (unreachable)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (nop)
 ;; CHECK-NEXT:     (local.set $10
 ;; CHECK-NEXT:      (i32.eqz
 ;; CHECK-NEXT:       (local.get $var$1)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (br_if $label$2
 ;; CHECK-NEXT:      (local.get $10)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (block
 ;; CHECK-NEXT:      (local.set $11
 ;; CHECK-NEXT:       (i32.load
 ;; CHECK-NEXT:        (i32.const 0)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (nop)
 ;; CHECK-NEXT:      (local.set $13
 ;; CHECK-NEXT:       (i32.ne
 ;; CHECK-NEXT:        (local.get $11)
 ;; CHECK-NEXT:        (local.get $var$0)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (if
 ;; CHECK-NEXT:       (local.get $13)
 ;; CHECK-NEXT:       (then
 ;; CHECK-NEXT:        (unreachable)
 ;; CHECK-NEXT:        (unreachable)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:     (unreachable)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $replaced-print-internal (export "replaced-print-internal") (param $var$0 i32)
  (local $var$1 i32)
  (local $var$2 i32)
  (local $var$3 i32)
  (if
   (local.tee $var$0
    (i32.add
     (local.get $var$0)
     (i32.const -7)
    )
   )
   (then
    (block $label$2
     (block $label$3
      (local.set $var$1
       (local.get $var$0)
      )
      (br_if $label$3
       (local.tee $var$3
        (i32.const 12)
       )
      )
      (unreachable)
     )
     (br_if $label$2
      (i32.eqz
       (local.get $var$1)
      )
     )
     (if
      (i32.ne
       (i32.load
        (i32.const 0)
       )
       (local.get $var$0)
      )
      (then
       (unreachable)
      )
     )
     (unreachable)
    )
   )
  )
 )
 ;; CHECK:      (func $multiple-uses-to-non-expression (param $x i32)
 ;; CHECK-NEXT:  (local $temp i32)
 ;; CHECK-NEXT:  (local $2 i32)
 ;; CHECK-NEXT:  (local $3 i32)
 ;; CHECK-NEXT:  (local $4 i32)
 ;; CHECK-NEXT:  (local $5 i32)
 ;; CHECK-NEXT:  (local $6 i32)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (local.set $x
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (local.get $x)
 ;; CHECK-NEXT:    (i32.const 10)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (i32.store
 ;; CHECK-NEXT:   (i32.const 1)
 ;; CHECK-NEXT:   (local.get $x)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (local.set $6
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (local.get $x)
 ;; CHECK-NEXT:    (i32.const 20)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (i32.store
 ;; CHECK-NEXT:   (i32.const 2)
 ;; CHECK-NEXT:   (local.get $6)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $multiple-uses-to-non-expression (param $x i32)
  (local $temp i32)
  (local.set $x
   (i32.add
    (local.get $x)
    (i32.const 10)
   )
  )
  (i32.store
   (i32.const 1)
   (local.get $x) ;; x+10 has two uses!
  )
  (i32.store
   (i32.const 2)
   (i32.add
    (local.get $x)
    (i32.const 20)
   )
  )
 )
 ;; CHECK:      (func $nested-phi-forwarding (param $var$0 i32) (result i32)
 ;; CHECK-NEXT:  (local $var$1 i32)
 ;; CHECK-NEXT:  (local $var$2 i32)
 ;; CHECK-NEXT:  (local $3 i32)
 ;; CHECK-NEXT:  (local $4 i32)
 ;; CHECK-NEXT:  (local $5 i32)
 ;; CHECK-NEXT:  (local $6 i32)
 ;; CHECK-NEXT:  (local $7 i32)
 ;; CHECK-NEXT:  (local $8 i32)
 ;; CHECK-NEXT:  (local $9 i32)
 ;; CHECK-NEXT:  (block
 ;; CHECK-NEXT:   (block $label$1
 ;; CHECK-NEXT:    (block $label$2
 ;; CHECK-NEXT:     (loop $label$3
 ;; CHECK-NEXT:      (block $label$4
 ;; CHECK-NEXT:       (block $label$5
 ;; CHECK-NEXT:        (block $label$6
 ;; CHECK-NEXT:         (block $label$7
 ;; CHECK-NEXT:          (block $label$8
 ;; CHECK-NEXT:           (nop)
 ;; CHECK-NEXT:           (br_table $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$8 $label$2 $label$2 $label$2 $label$6 $label$2 $label$2 $label$7 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$5 $label$4
 ;; CHECK-NEXT:            (local.get $var$0)
 ;; CHECK-NEXT:           )
 ;; CHECK-NEXT:           (unreachable)
 ;; CHECK-NEXT:          )
 ;; CHECK-NEXT:          (local.set $var$1
 ;; CHECK-NEXT:           (i32.const 1)
 ;; CHECK-NEXT:          )
 ;; CHECK-NEXT:         )
 ;; CHECK-NEXT:         (br $label$4)
 ;; CHECK-NEXT:         (unreachable)
 ;; CHECK-NEXT:        )
 ;; CHECK-NEXT:        (unreachable)
 ;; CHECK-NEXT:        (unreachable)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:       (br $label$1)
 ;; CHECK-NEXT:       (unreachable)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (local.set $var$2
 ;; CHECK-NEXT:       (i32.const 1)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (nop)
 ;; CHECK-NEXT:      (br_if $label$3
 ;; CHECK-NEXT:       (local.get $var$2)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (block $label$9
 ;; CHECK-NEXT:     (nop)
 ;; CHECK-NEXT:     (local.set $6
 ;; CHECK-NEXT:      (i32.or
 ;; CHECK-NEXT:       (i32.const 1)
 ;; CHECK-NEXT:       (local.get $var$1)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:     (br_if $label$9
 ;; CHECK-NEXT:      (local.get $6)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:   (i32.store offset=176
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:    (local.get $var$2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $9
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $9)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $nested-phi-forwarding (param $var$0 i32) (result i32)
  (local $var$1 i32)
  (local $var$2 i32)
  (block $label$1
   (block $label$2
    (loop $label$3
     (block $label$4
      (block $label$5
       (block $label$6
        (block $label$7
         (block $label$8
          (br_table $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$8 $label$2 $label$2 $label$2 $label$6 $label$2 $label$2 $label$7 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$2 $label$5 $label$4
           (local.get $var$0)
          )
         )
         (local.set $var$1
          (i32.const 1)
         )
        )
        (br $label$4)
       )
       (unreachable)
      )
      (br $label$1)
     )
     (br_if $label$3
      (local.tee $var$2
       (i32.const 1)
      )
     )
    )
   )
   (block $label$9
    (br_if $label$9
     (i32.or
      (i32.const 1)
      (local.get $var$1)
     )
    )
   )
   (unreachable)
  )
  (i32.store offset=176
   (i32.const 0)
   (local.get $var$2)
  )
  (i32.const 0)
 )
 ;; CHECK:      (func $zext-numGets (param $var$0 i32) (param $var$1 i32)
 ;; CHECK-NEXT:  (local $2 i32)
 ;; CHECK-NEXT:  (local $3 i32)
 ;; CHECK-NEXT:  (local $4 i32)
 ;; CHECK-NEXT:  (local $5 i32)
 ;; CHECK-NEXT:  (local $6 i32)
 ;; CHECK-NEXT:  (local $7 i32)
 ;; CHECK-NEXT:  (local $8 i32)
 ;; CHECK-NEXT:  (block $label$1
 ;; CHECK-NEXT:   (local.set $2
 ;; CHECK-NEXT:    (i32.load
 ;; CHECK-NEXT:     (i32.const -8)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $3
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br_if $label$1
 ;; CHECK-NEXT:    (local.get $2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (local.get $3)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $5
 ;; CHECK-NEXT:    (i32.load
 ;; CHECK-NEXT:     (i32.const -16)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:   (local.set $3
 ;; CHECK-NEXT:    (i32.eqz
 ;; CHECK-NEXT:     (local.get $5)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (local.set $8
 ;; CHECK-NEXT:   (i32.ctz
 ;; CHECK-NEXT:    (local.get $3)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (local.get $8)
 ;; CHECK-NEXT:   (then
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $zext-numGets (param $var$0 i32) (param $var$1 i32)
  (if
   (i32.ctz
    (block $label$1 (result i32)
     (drop
      (br_if $label$1
       (i32.const 1)
       (i32.load
        (i32.const -8)
       )
      )
     )
     (i32.eqz
      (i32.load
       (i32.const -16)
      )
     )
    )
   )
   (then
    (unreachable)
   )
  )
 )
 ;; CHECK:      (func $zext-numGets-hasAnotherUse (param $var$0 i32) (param $var$1 i32)
 ;; CHECK-NEXT:  (local $temp i32)
 ;; CHECK-NEXT:  (local $3 i32)
 ;; CHECK-NEXT:  (local $4 i32)
 ;; CHECK-NEXT:  (local $5 i32)
 ;; CHECK-NEXT:  (local $6 i32)
 ;; CHECK-NEXT:  (local $7 i32)
 ;; CHECK-NEXT:  (local $8 i32)
 ;; CHECK-NEXT:  (local $9 i32)
 ;; CHECK-NEXT:  (local $10 i32)
 ;; CHECK-NEXT:  (local $11 i32)
 ;; CHECK-NEXT:  (block $label$1
 ;; CHECK-NEXT:   (local.set $3
 ;; CHECK-NEXT:    (i32.load
 ;; CHECK-NEXT:     (i32.const -8)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $4
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (br_if $label$1
 ;; CHECK-NEXT:    (local.get $3)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (local.get $4)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (local.set $6
 ;; CHECK-NEXT:    (i32.load
 ;; CHECK-NEXT:     (i32.const -16)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:   (local.set $temp
 ;; CHECK-NEXT:    (i32.eqz
 ;; CHECK-NEXT:     (local.get $6)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:   (drop
 ;; CHECK-NEXT:    (local.get $temp)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:   (local.set $4
 ;; CHECK-NEXT:    (local.get $temp)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (local.set $11
 ;; CHECK-NEXT:   (i32.ctz
 ;; CHECK-NEXT:    (local.get $4)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (if
 ;; CHECK-NEXT:   (local.get $11)
 ;; CHECK-NEXT:   (then
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $zext-numGets-hasAnotherUse (param $var$0 i32) (param $var$1 i32)
  (local $temp i32)
  (if
   (i32.ctz
    (block $label$1 (result i32)
     (drop
      (br_if $label$1
       (i32.const 1)
       (i32.load
        (i32.const -8)
       )
      )
     )
     (local.set $temp
      (i32.eqz
       (i32.load
        (i32.const -16)
       )
      )
     )
     (drop
      (local.get $temp)
     )
     (local.get $temp)
    )
   )
   (then
    (unreachable)
   )
  )
 )
 ;; CHECK:      (func $flipped-needs-right-origin (param $var$0 i32) (result i32)
 ;; CHECK-NEXT:  (local $var$1 i32)
 ;; CHECK-NEXT:  (local $2 i32)
 ;; CHECK-NEXT:  (local $3 i32)
 ;; CHECK-NEXT:  (local $4 i32)
 ;; CHECK-NEXT:  (local $5 i32)
 ;; CHECK-NEXT:  (local $6 i32)
 ;; CHECK-NEXT:  (local $7 i32)
 ;; CHECK-NEXT:  (block
 ;; CHECK-NEXT:   (block $label$1
 ;; CHECK-NEXT:    (local.set $2
 ;; CHECK-NEXT:     (i32.load
 ;; CHECK-NEXT:      (i32.const 1)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (br_if $label$1
 ;; CHECK-NEXT:     (local.get $2)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.set $var$1
 ;; CHECK-NEXT:     (i32.const 2)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (local.set $4
 ;; CHECK-NEXT:     (i32.add
 ;; CHECK-NEXT:      (local.get $var$1)
 ;; CHECK-NEXT:      (i32.const 4)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (local.set $5
 ;; CHECK-NEXT:     (i32.gt_s
 ;; CHECK-NEXT:      (i32.const 3)
 ;; CHECK-NEXT:      (local.get $4)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (if
 ;; CHECK-NEXT:     (local.get $5)
 ;; CHECK-NEXT:     (then
 ;; CHECK-NEXT:      (unreachable)
 ;; CHECK-NEXT:      (unreachable)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $7
 ;; CHECK-NEXT:   (i32.const 5)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $7)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $flipped-needs-right-origin (param $var$0 i32) (result i32)
  (local $var$1 i32)
  (block $label$1
   (br_if $label$1
    (i32.load
     (i32.const 1)
    )
   )
   (local.set $var$1
    (i32.const 2)
   )
  )
  (if
   (i32.gt_s
    (i32.const 3)
    (i32.add
     (local.get $var$1)
     (i32.const 4)
    )
   )
   (then
    (unreachable)
   )
  )
  (i32.const 5)
 )
 ;; CHECK:      (func $non-expr-nodes-may-have-multiple-uses-too-its-the-ORIGIN (param $var$0 i32) (param $var$1 i32) (param $var$2 i32) (result i32)
 ;; CHECK-NEXT:  (local $3 i32)
 ;; CHECK-NEXT:  (local $4 i32)
 ;; CHECK-NEXT:  (local $5 i32)
 ;; CHECK-NEXT:  (local $6 i32)
 ;; CHECK-NEXT:  (local $7 i32)
 ;; CHECK-NEXT:  (local $8 i32)
 ;; CHECK-NEXT:  (local $9 i32)
 ;; CHECK-NEXT:  (block
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:   (local.set $var$1
 ;; CHECK-NEXT:    (i32.gt_u
 ;; CHECK-NEXT:     (local.get $var$1)
 ;; CHECK-NEXT:     (i32.const 1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:   (i32.store
 ;; CHECK-NEXT:    (local.get $var$1)
 ;; CHECK-NEXT:    (i32.const 2)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:   (local.set $7
 ;; CHECK-NEXT:    (i32.sub
 ;; CHECK-NEXT:     (i32.const 4)
 ;; CHECK-NEXT:     (local.get $var$1)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (i32.store offset=8
 ;; CHECK-NEXT:    (i32.const 3)
 ;; CHECK-NEXT:    (local.get $7)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $8)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $non-expr-nodes-may-have-multiple-uses-too-its-the-ORIGIN (param $var$0 i32) (param $var$1 i32) (param $var$2 i32) (result i32)
  (i32.store
   (local.tee $var$1
    (i32.gt_u
     (local.get $var$1)
     (i32.const 1)
    )
   )
   (i32.const 2)
  )
  (i32.store offset=8
   (i32.const 3)
   (i32.sub
    (i32.const 4)
    (local.get $var$1)
   )
  )
  (unreachable)
 )
 ;; CHECK:      (func $loop-of-set-connections (param $var$0 i32) (param $var$1 i32) (param $var$2 i32) (param $var$3 i32) (param $var$4 i32) (result i32)
 ;; CHECK-NEXT:  (local $5 i32)
 ;; CHECK-NEXT:  (local $6 i32)
 ;; CHECK-NEXT:  (local $7 i32)
 ;; CHECK-NEXT:  (loop $label$1
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (if
 ;; CHECK-NEXT:     (i32.const 0)
 ;; CHECK-NEXT:     (then
 ;; CHECK-NEXT:      (block
 ;; CHECK-NEXT:       (nop)
 ;; CHECK-NEXT:       (local.set $var$2
 ;; CHECK-NEXT:        (i32.add
 ;; CHECK-NEXT:         (i32.const 0)
 ;; CHECK-NEXT:         (i32.const 1)
 ;; CHECK-NEXT:        )
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:       (br $label$1)
 ;; CHECK-NEXT:       (unreachable)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (unreachable)
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (br $label$1)
 ;; CHECK-NEXT:    (unreachable)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (unreachable)
 ;; CHECK-NEXT: )
 (func $loop-of-set-connections (param $var$0 i32) (param $var$1 i32) (param $var$2 i32) (param $var$3 i32) (param $var$4 i32) (result i32)
  (loop $label$1
   (if
    (i32.const 0)
    (then
     (block
      (local.set $var$2
       (i32.add
        (i32.const 0)
        (i32.const 1)
       )
      )
      (br $label$1)
     )
    )
   )
   (local.set $var$3
    (local.get $var$2)
   )
   (local.set $var$2
    (local.get $var$3)
   )
   (br $label$1)
  )
 )
 ;; CHECK:      (func $conditions-in-conditions (param $var$0 i32) (param $var$1 i32) (param $var$2 i32) (result i32)
 ;; CHECK-NEXT:  (local $var$3 i32)
 ;; CHECK-NEXT:  (local $var$4 i32)
 ;; CHECK-NEXT:  (local $var$5 i32)
 ;; CHECK-NEXT:  (local $var$6 i32)
 ;; CHECK-NEXT:  (local $var$7 i32)
 ;; CHECK-NEXT:  (local $var$8 i32)
 ;; CHECK-NEXT:  (local $9 i32)
 ;; CHECK-NEXT:  (local $10 i32)
 ;; CHECK-NEXT:  (local $11 i32)
 ;; CHECK-NEXT:  (local $12 i32)
 ;; CHECK-NEXT:  (local $13 i32)
 ;; CHECK-NEXT:  (local $14 i32)
 ;; CHECK-NEXT:  (local $15 i32)
 ;; CHECK-NEXT:  (local $16 i32)
 ;; CHECK-NEXT:  (block
 ;; CHECK-NEXT:   (local.set $var$1
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (if
 ;; CHECK-NEXT:    (i32.const 0)
 ;; CHECK-NEXT:    (then
 ;; CHECK-NEXT:     (loop $label$2
 ;; CHECK-NEXT:      (block
 ;; CHECK-NEXT:       (nop)
 ;; CHECK-NEXT:       (if
 ;; CHECK-NEXT:        (local.get $var$1)
 ;; CHECK-NEXT:        (then
 ;; CHECK-NEXT:         (nop)
 ;; CHECK-NEXT:        )
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (local.set $var$3
 ;; CHECK-NEXT:       (i32.const 1)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (nop)
 ;; CHECK-NEXT:      (nop)
 ;; CHECK-NEXT:      (local.set $var$1
 ;; CHECK-NEXT:       (i32.sub
 ;; CHECK-NEXT:        (i32.const 0)
 ;; CHECK-NEXT:        (local.get $var$3)
 ;; CHECK-NEXT:       )
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:      (br_if $label$2
 ;; CHECK-NEXT:       (i32.const 0)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (block
 ;; CHECK-NEXT:    (nop)
 ;; CHECK-NEXT:    (if
 ;; CHECK-NEXT:     (local.get $var$1)
 ;; CHECK-NEXT:     (then
 ;; CHECK-NEXT:      (local.set $var$3
 ;; CHECK-NEXT:       (i32.const 1)
 ;; CHECK-NEXT:      )
 ;; CHECK-NEXT:     )
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (nop)
 ;; CHECK-NEXT:   (local.set $14
 ;; CHECK-NEXT:    (i32.add
 ;; CHECK-NEXT:     (local.get $var$3)
 ;; CHECK-NEXT:     (i32.const 16)
 ;; CHECK-NEXT:    )
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (i32.store
 ;; CHECK-NEXT:    (i32.const 8)
 ;; CHECK-NEXT:    (local.get $14)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (i32.store
 ;; CHECK-NEXT:    (i32.const 8)
 ;; CHECK-NEXT:    (i32.const 64)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:   (unreachable)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (nop)
 ;; CHECK-NEXT:  (return
 ;; CHECK-NEXT:   (local.get $15)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $conditions-in-conditions (param $var$0 i32) (param $var$1 i32) (param $var$2 i32) (result i32)
  (local $var$3 i32)
  (local $var$4 i32)
  (local $var$5 i32)
  (local $var$6 i32)
  (local $var$7 i32)
  (local $var$8 i32)
  (local.set $var$1
   (i32.const 1)
  )
  (if
   (i32.const 0)
   (then
    (loop $label$2
     (if
      (local.get $var$1)
      (then
       (nop)
      )
     )
     (local.set $var$1
      (i32.sub
       (i32.const 0)
       (local.tee $var$3
        (i32.const 1)
       )
      )
     )
     (br_if $label$2
      (i32.const 0)
     )
    )
   )
  )
  (if
   (local.get $var$1)
   (then
    (local.set $var$3
     (i32.const 1)
    )
   )
  )
  (i32.store
   (i32.const 8)
   (i32.add
    (local.get $var$3)
    (i32.const 16)
   )
  )
  (i32.store
   (i32.const 8)
   (i32.const 64)
  )
  (unreachable)
 )
)
