// Don't edit directly - see python script in cmd_help directory.
"See project and wiki at: https://github.com/BinomialLLC/basis_universal\n"
"\n"
"The default processing mode is compression of one or more .PNG/.TGA/.JPG/.QOI/\n"
".DDS/.EXR/.HDR files to a LDR or HDR .KTX2 file. Alternate modes:\n"
"\n"
" -unpack: Use transcoder to unpack a .basis/.KTX2 file to one or more .KTX, \n"
"  .DDS, .PNG, .ASTC, etc. files.\n"
"\n"
" -info: Display high-level information about a .basis/.KTX2 file\n"
" \n"
" -validate: Validate and display information about a .basis/.KTX2 file\n"
"  \n"
" -compare: Compare two LDR PNG/BMP/TGA/JPG/QOI images specified with -file,\n"
"  output PSNR and SSIM statistics and RGB/A delta images\n"
"\n"
" -compare_hdr: Compare two HDR .EXR/.HDR images specified with -file, output\n"
"  PSNR statistics and RGB delta images\n"
"\n"
" -tonemap: Tonemap an HDR or EXR image to PNG at multiple exposures, use -file\n"
"  to specify filename\n"
"\n"
" -peek_astc: Read an .astc file and calculate statistics (for testing/dev)\n"
"\n"
" -version or --version: Print version and exit\n"
"\n"
"--- Intro:\n"
"\n"
"This tool compresses LDR/SDR and HDR images and textures to a Basis Universal\n"
"supercompressed GPU texture, which can be written to supercompressed .basis or\n"
"standard .KTX2 files. It supports a number of SDR and HDR codecs, each with\n"
"different quality, transcoding performance, and bitrate tradeoffs. A SDR/HDR\n"
"mipmap generator is also included. This tool can also examine and\n"
"unpack .KTX2/.basis files to .PNG, .KTX (v1), .ASTC, or .DDS files using its\n"
"single source file transcoder library.\n"
"\n"
"The list of supported texture/supercompressed texture codecs:\n"
" -LDR: ETC1S (SDR default), RDO UASTC LDR 4x4, ASTC or XUASTC LDR 4x4-12x12\n"
" -HDR: UASTC HDR 4x4 (HDR default), RDO ASTC HDR 6x6, UASTC HDR 6x6\n"
" \n"
"RDO=Rate-Distortion Optimization. Two key parameters (quality and effort) have\n"
"been unified across all the codecs:\n"
"\n"
"- The -quality X parameter, where X ranges from [0, 100], controls the\n"
"compression quality vs. bitrate (output file size) tradeoff for those codecs\n"
"supporting supercompression or RDO (Rate-distortion optimization). 100=max\n"
"quality, and lower levels produce smaller files with more distortion.\n"
"\n"
"- The -effort X parameter, where X ranges from [0, 10], controls the\n"
"compression speed (and max CPU usage) vs. max achievable quality tradeoff.\n"
"Low efforts result in more distortion/artifacts, but faster compression. Lower\n"
"efforts result in less utilization of the underlying GPU block format's\n"
"capabilities.\n"
"\n"
"Key Definitions: \n"
"\"Quality\" controls the explicit tradeoff between output distortion and output\n"
"file bitrate (in bits per pixel or target). At max quality (100) each\n"
"compressor will output the lowest distortion it's capable of at its currently\n"
"configured effort level.\n"
"\n"
"\"Effort\" controls how intensely a compressor uses the CPU to focus on each\n"
"block format's encoding capabilities. Low effort levels only target a set of\n"
"core or basic capabilities (specific to each output target format), while\n"
"higher effort levels allow each compressor to explore more of each target's\n"
"features (at the cost of higher CPU time). Lower effort levels result in more\n"
"brittle compression (higher distortion on tough image/texture features).\n"
"Effort=0 fastest compression, effort=10=extremely slow.\n"
"\n"
"Unless an explicit mode is specified, if one or more files have the .basis\n"
"or .KTX2 extension this tool defaults to unpack mode.\n"
"\n"
"By default, the compressor assumes the input is in the sRGB colorspace (like\n"
"typical photos/albedo textures). If the input is NOT sRGB (like a normal map),\n"
"be sure to specify -linear for less artifacts. Depending on the content type,\n"
"some experimentation may be needed.\n"
"\n"
"The TinyEXR library is used to read .EXR images. Crucially, this small library\n"
"does not support all .EXR compression methods. For unsupported images, you can\n"
"use a tool like ImageMagick to convert them to uncompressed .EXR.\n"
"\n"
"For .DDS source files: Mipmapped or plain 2D textures (but not cubemaps) are\n"
"supported. Only uncompressed 32-bit RGBA/BGRA, half float RGBA, or float\n"
"RGBA .DDS files are supported. In -tex_array mode, if a .DDS file is specified,\n"
"all source files must be in .DDS format.\n"
"\n"
"Filenames prefixed with a @ symbol are read as filename listing files. Listing\n"
"text files specify which actual filenames to process (one filename per line).\n"
"\n"
"--- High-Level Texture Mode (Codec) Selection:\n"
"\n"
" 1. -etc1s: Encode to supercompressed ETC1S LDR (the default for SDR/LDR\n"
"    inputs). Roughly .8-2.5 bpp. Supports temporal texture supercompression\n"
"    (texture video) with skip blocks (Conditional Replenishment), with global\n"
"    codebooks shared across all frames.\n"
"\n"
" 2. -uastc/-uastc_ldr: UASTC LDR 4x4. Encode to UASTC LDR 4x4, a custom high\n"
"    quality virtual texture format designed for fast transcoding to numerous\n"
"    GPU texture formats. Roughly 5-8 bpp. Supports RDO encoding using -lambda X\n"
"    option - see options below. In this mode the multi-target compressor\n"
"    optimizes for a balance of transcoded ASTC 4x4 LDR and BC7 quality.\n"
"\n"
" 3. -hdr/-hdr_4x4: UASTC HDR 4x4. Encode input as UASTC HDR 4x4 (the default if\n"
"    any input file has the .EXR or .HDR extension, or if any .DDS file is HDR).\n"
"    Output is standard, but constrained, ASTC HDR 4x4. Roughly 5-8 bpp. In this\n"
"    mode the dual-target compressor optimizes for a balance of transcoded ASTC\n"
"    4x4 HDR and BC6H quality.\n"
"\n"
" 4. -hdr_6x6: ASTC HDR 6x6. Encode input as RDO or highest quality standard\n"
"    ASTC HDR 6x6. Use -quality (preferred) or -lambda X (low-level, try\n"
"    100-20000 or higher) option to enable RDO ASTC HDR 6x6, where x controls\n"
"    the quality vs. size tradeoff. Roughly 1.2-3.2 bpp.\n"
"\n"
" 5. -hdr_6x6i: UASTC HDR 6x6. Encode input as supercompressed UASTC HDR 6x6\n"
"    intermediate. Use -quality (preferred) or -lambda X (low-level, try\n"
"    100-20000 or higher) option to enable RDO UASTC HDR 6x6, where x controls\n"
"    the quality vs. size tradeoff. Roughly 1-3.2 bpp.\n"
"\n"
" 6. XUASTC LDR 4x4-12x12: -ldr_4x4i, -ldr_5x4i, -ldr_5x5i, -ldr_6x5i,\n"
"    -ldr_6x6i, -ldr_8x5i, -ldr_8x6i, -ldr_10x5i, -ldr_10x6i, -ldr_8x8i,\n"
"    -ldr_10x8i, -ldr_10x10i, -ldr_12x10i, -ldr_12x12i:\n"
"    Compress to supercompressed XUASTC LDR/SDR using the specific\n"
"    ASTC block size. See additional ASTC/XUASTC LDR specific options\n"
"    (-effort, -quality, -xy, -ts, -tl, etc.) below. Roughly .3-5.7 bpp\n"
"\n"
" 7. ASTC LDR 4x4-12x12: -ldr_4x4, -ldr_5x4, -ldr_5x5, -ldr_6x5, -ldr_6x6,\n"
"    -ldr_8x5, -ldr_8x6, -ldr_10x5, -ldr_10x6, -ldr_8x8, -ldr_10x8,\n"
"    -ldr_10x10, -ldr_12x10, -ldr_12x12:\n"
"    Compress to standard or ZStd supercompressed ASTC LDR/SDR using\n"
"    the specific ASTC block size. See additional ASTC LDR specific\n"
"    options (-effort, -quality, -xy, -ts, -tl, etc.) below. .89-8 bpp before\n"
"    ZStd compression.\n"
"\n"
"--- Tool Options:\n"
"\n"
" -ktx2: Write .KTX2 files (the default). By default, UASTC LDR/HDR 4x4 and ASTC\n"
"  6x6 files will be compressed using Zstandard unless -ktx2_no_zstandard is\n"
"  specified.\n"
"\n"
" -basis: Write .basis files instead of .KTX2 files.\n"
"\n"
" -file filename.png/tga/jpg/qoi/exr/hdr: Input image filename, multiple images\n"
"  are OK, use -file X for each input filename (prefixing input filenames\n"
"  with -file is optional)\n"
"\n"
" -alpha_file filename.png/tga/jpg/qoi: Input alpha image filename, multiple\n"
"  images are OK, use -file X for each input filename (must be paired\n"
"  with -file), images converted to REC709 grayscale and used as input alpha\n"
"\n"
" -quiet or -no_status_output: Disable compressor's status output to stdout\n"
"\n"
" -output_file filename: Output .basis/.KTX2 filename\n"
"\n"
" -output_path: Output .basis/.KTX2 files to specified directory.\n"
"\n"
" -debug or -verbose: Enable codec debug print to stdout (slightly slower).\n"
"\n"
" -debug_images: Enable codec debug images (much slower).\n"
"\n"
" -stats: Compute and display image quality metrics (slightly to much slower).\n"
"\n"
" -individual: Process input images individually and output\n"
"  multiple .basis/.KTX2 files (not as a texture array - this is now the default\n"
"  as of v1.16)\n"
"\n"
" -parallel: Compress multiple textures simultaneously (one per thread), instead\n"
"  of one at a time. Compatible with OpenCL mode. This is much faster, but in\n"
"  OpenCL mode the driver is pushed harder, and the CLI output will be jumbled.\n"
"\n"
" -linear: Use linear colorspace metrics (instead of the default sRGB or scaled\n"
"  RGB for HDR), write linear transfer function setting to KTX2/basis file, and\n"
"  by default linear (not sRGB) mipmap filtering (unless overridden). Same\n"
"  as -tl.\n"
"\n"
" -srgb: Use sRGB colorspace metrics, write sRGB transfer function setting to\n"
"  KTX2/basis file, and by default use sRGB mipmap filtering (unless\n"
"  overridden). Same as -ts.\n"
"\n"
" -tex_type <2d, 2darray, 3d, video, cubemap>: Set Basis file header's texture\n"
"  type field. Cubemap arrays require multiples of 6 images, in X+, X-, Y+, Y-,\n"
"  Z+, Z- order, each image must be the same resolutions. 2d=arbitrary 2D\n"
"  images, 2darray=2D array, 3D=volume texture slices, video=video frames,\n"
"  cubemap=array of faces. For 2darray/3d/cubemaps/video, each source image's\n"
"  dimensions and # of mipmap levels must be the same. For video, the .basis\n"
"  file will be written with the first frame being an I-Frame, and subsequent\n"
"  frames being P-Frames (using conditional replenishment). Playback must always\n"
"  occur in order from first to last image.\n"
"\n"
" -cubemap: same as -tex_type cubemap\n"
"\n"
" -tex_array: Process input images as a single texture array and write a\n"
"  single .basis/.KTX2 file (the former default before v1.16)\n"
"\n"
" -fuzz_testing: Use with -validate: Disables CRC16 validation of file contents\n"
"  before transcoding\n"
"\n"
" -multifile_printf: printf() format string to use to compose multiple filenames\n"
"\n"
" -multifile_first: The index of the first file to process, default is 0 (must\n"
"  specify -multifile_printf and -multifile_num)\n"
"\n"
" -multifile_num: The total number of files to process.\n"
"\n"
" -opencl: Enable OpenCL usage (currently only accelerates ETC1S encoding)\n"
"\n"
" -opencl_serialize: Serialize all calls to the OpenCL driver (to work around\n"
"  buggy drivers, only useful with -parallel)\n"
"\n"
"--- ETC1S specific options (-etc1s - the LDR/SDR default):\n"
"\n"
" -quality X and -effort X: Set quality (1-100) and effort (0-10) levels\n"
"\n"
" -q X: Low-level ETC1S quality level, 1-255, default is 128, lower=better\n"
"  compression/lower quality/faster, higher=less compression/higher\n"
"  quality/slower, default is 128. For even higher quality,\n"
"  use -max_endpoints/-max_selectors. (-quality is preferred.)\n"
"\n"
" -comp_level X: Low-level ETC1S speed vs. quality tradeoff. Range is 0-6,\n"
"  default is 1. Higher values=MUCH slower, but slightly higher quality. Higher\n"
"  levels intended for videos. (-effort is preferred.)\n"
"\n"
" -max_endpoints X: ETC1S: Manually set the max number of color endpoint\n"
"  clusters from 1-16128, use instead of -q\n"
"\n"
" -max_selectors X: ETC1S: Manually set the max number of color selector\n"
"  clusters from 1-16128, use instead of -q\n"
"\n"
"--- UASTC LDR/HDR 4x4 specific options (-uastc or -uastc_ldr):\n"
"\n"
" -quality X and -effort X: Set quality (1-100) and effort (0-10) levels\n"
"\n"
" -uastc, -uastc_ldr or -uastc_ldr_4x4: Enable UASTC LDR 4x4 texture mode,\n"
"  instead of the default ETC1S mode. Significantly higher texture quality, but\n"
"  much larger (~8bpp) files. (Note that UASTC LDR 4x4 .basis files must be\n"
"  losslessly compressed by the user.)\n"
"\n"
" -uastc_level: Set low-level UASTC LDR/HDR 4x4 encoding effort level. LDR Range\n"
"  is [0,4], default is 2, higher=slower but higher quality. 0=fastest/lowest\n"
"  quality, 3=slowest practical option, 4=impractically slow/highest achievable\n"
"  quality. UASTC HDR 4x4 range is [0,4]: higher=slower, but higher quality. HDR\n"
"  4x4 default level=1.\n"
"\n"
" -uastc_rdo_l X: Enable UASTC LDR 4x4 RDO post-processing and set the low-level\n"
"  UASTC LDR 4x4 RDO quality scalar (lambda) to X. Lower values=higher\n"
"  quality/larger LZ compressed files, higher values=lower quality/smaller LZ\n"
"  compressed files. Good range to try is [.25-10]. Note: Previous versons used\n"
"  the -uastc_rdo_q option, which was removed because the RDO algorithm was\n"
"  changed.\n"
"\n"
" -uastc_rdo_d X: Set UASTC LDR 4x4 RDO dictionary size in bytes. Default is\n"
"  4096, max is 65536. Lower values=faster, but less compression.\n"
"\n"
" -uastc_rdo_b X: Set UASTC LDR 4x4 RDO max smooth block error scale. Range is\n"
"  [1,300]. Default is 10.0, 1.0=disabled. Larger values suppress more artifacts\n"
"  (and allocate more bits) on smooth blocks.\n"
"\n"
" -uastc_rdo_s X: Set UASTC LDR 4x4 RDO max smooth block standard deviation.\n"
"  Range is [.01,65536]. Default is 18.0. Larger values expand the range of\n"
"  blocks considered smooth.\n"
"\n"
" -uastc_rdo_f: Don't favor simpler UASTC LDR 4x4 modes in RDO mode.\n"
"\n"
" -uastc_rdo_m: Disable RDO multithreading (slightly higher compression,\n"
"  deterministic).\n"
"\n"
"--- UASTC HDR 4x4 specific options (-hdr or -hdr_4x4 - the HDR default):\n"
"\n"
" -hdr, -hdr_4x4, or -uastc_hdr_4x4: Enable UASTC HDR 4x4 mode\n"
"\n"
" -quality X and -effort X: Set quality (1-100) and effort (0-10) levels\n"
"\n"
" -uastc_level X: Sets the low-level UASTC HDR 4x4 compressor's effort level.\n"
"                 Valid range is [0,4]: higher=slower but higher quality. HDR\n"
"                 default=1. Level 0=fastest/lowest quality, 3=highest practical\n"
"                 setting, 4=exhaustive\n"
"\n"
" -hdr_uber_mode: Allow the UASTC HDR 4x4 encoder to try varying the CEM 11\n"
"  selectors more for slightly higher quality (slower). This may negatively\n"
"  impact BC6H quality, however.\n"
"\n"
" -hdr_ultra_quant: UASTC HDR 4x4: Try to find better quantized CEM 7/11\n"
"  endpoint values (slower).\n"
"\n"
" -hdr_favor_astc: UASTC HDR 4x4: By default the dual-target UASTC HDR 4x4\n"
"  encoder tries to strike a balance or even slightly favor BC6H quality. If\n"
"  this option is specified, ASTC HDR 4x4 quality is favored instead.\n"
"\n"
"--- ASTC/UASTC HDR 6x6 specific options (-hdr_6x6 or -hdr_6x6i):\n"
"\n"
"Internally both modes use the same compressor which can generate either\n"
"standard ASTC HDR 6x6 (with optional RDO) or UASTC HDR 6x6 (supercompressed\n"
"with a custom format).\n"
"\n"
" -hdr_6x6 or -astc_hdr_6x6: Enable RDO ASTC HDR 6x6 mode\n"
"\n"
" -hdr_6x6i or -uastc_hdr_6x6: Enable UASTC HDR 6x6 mode\n"
"\n"
" -quality X and -effort X: Set quality (1-100) and effort (0-10) levels\n"
"\n"
" -lambda X: Low-level option to enable rate distortion optimization (RDO) and\n"
"            directly control the HDR 6x6 compressor's lambda setting. The\n"
"            higher this value, the lower the quality, but the smaller the file\n"
"            size. Try 100-20000, or higher values on some images. Upconverted\n"
"            SDR images can generally tolerate much higher lambda settings vs.\n"
"            true HDR images.\n"
"\n"
" -hdr_6x6_level X: Low-level option to set the codec to 6x6 HDR mode (same\n"
"            as -hdr_6x6) and controls encoder performance vs. max quality\n"
"            tradeoff. X may range from [0,12]. Default level is 2. Higher\n"
"            values result in better quality but slower encoding. Values above\n"
"            10 are extremely slow.\n"
"\n"
" -hdr_6x6i_level X: Low-level option to set the codec to 6x6 HDR intermediate\n"
"            mode (same as -hdr_6x6i) and controls encoder performance vs. max\n"
"            quality tradeoff. X may range from [0,12]. Default level is 2.\n"
"\n"
" -rec_2020: The input image's gamut is Rec. 2020 vs. the default Rec. 709 - for\n"
"            accurate colorspace error calculations. This value will also be\n"
"            written to the KTX2 file's header in the DFD.\n"
"\n"
" -hdr_6x6_jnd\n"
"            X, -hdr_6x6_extra_pats, -hdr_6x6_brute_force_pats,\n"
"            -hdr_6x6_comp_levels X Y, or -hdr_6x6i_comp_levels X Y: Low-level\n"
"            control over the encoder's configuration.\n"
"\n"
"--- SDR/LDR->HDR upconversion options (only used when encoding to HDR formats\n"
"from an LDR/SDR source image):\n"
"\n"
" -hdr_ldr_no_srgb_to_linear: If specified, LDR images will NOT be converted to\n"
"        normalized linear light (via a sRGB->Linear conversion) during SDR->HDR\n"
"        upconversion before compressing as HDR.\n"
"\n"
" -hdr_ldr_upconversion_nit_multiplier X: Specify how many nits (candelas per\n"
"        sq. meter) LDR/SDR images are converted to after converting to linear\n"
"        light. Default is 100 nits. Note: Previous builds used 1 nit. Common\n"
"        values are 80-100 nits.\n"
"\n"
"--- ASTC LDR/XUASTC LDR specific options (-ldr_4x4 or -ldr_4x4i, up to 12x12):\n"
"\n"
"Internally both modes (ASTC 4x4-12x12 and XUASTC 4x4-12x12) use the same\n"
"core compressor but with different outputs. All 14 standard ASTC block \n"
"sizes are supported (see the list below).\n"
"\n"
" -ldr_4x4-12x12 or -astc_ldr_4x4-12x12: Enable ASTC LDR 4x4-12x12 mode\n"
"\n"
" -ldr_4x4i-12x12 or -xuastc_ldr_4x4-12x12: Enable XUASTC LDR 4x4-12x12 mode\n"
"\n"
" -quality X: Enables lossy weight grid DCT and sets DCT quality level [1,100]\n"
"  (defaults to no DCT). Higher=better quality, but higher bitrate. Good values\n"
"  to try are 30-90. Default is no weight grid DCT.\n"
"\n"
" -effort X: Set encoder effort level [1,10]: Encoding speed tradeoff,        \n"
"  higher=slower but potentially higher overall quality. Default=3, 10=Insane.\n"
"  \n"
" -xuastc_arith, -xuastc_hybrid, -xuastc_zstd: Set transcoding speed vs.\n"
"  compression ratio tradeoff by selecting the output profile/syntax. Default\n"
"  is -xuastc_zstd (fastest, lowest ratio). ZStd is fastest/lowest ratio, arith\n"
"  is slowest/highest ratio (3-15% better vs. ZStd).\n"
"\n"
" -xy: Enables lossy supercompression using windowed/bounded RDO for extra\n"
"  compression (default is lossless supercompression of the XUASTC texture data\n"
"  unless DCT is enabled)\n"
"\n"
" -xyd: Disables lossy supercompression (default, but automatically enabled\n"
"  if -quality less than 100 is specified )\n"
"\n"
" -xs: Force disable 2-3 subset usage in all effort levels (lower quality but\n"
"  faster compression and faster transcoding to BC7 at certain block sizes)\n"
"\n"
" -xp: Force disable RGB dual plane usage in all effort levels (lower quality\n"
"  but faster compression and faster transcoding to BC7 at certain block sizes)\n"
"\n"
" -ts: Use LDR sRGB ASTC decoding profile - the default. This parameter should\n"
"  match how the developer will decode or sample the ASTC texture data. Inverse\n"
"  of -tl. Same as -srgb.\n"
"\n"
" -tl: Use LDR Linear ASTC decoding profile (same as -linear). Inverse of -ts.\n"
"  Same as -linear.\n"
"\n"
" -weights X Y Z W: Set unsigned integer channel error weights. Defaults are\n"
"  1,1,1,1. Useful to favor certain channels during compression.\n"
"\n"
" -ls_min_psnr X, -ls_min_alpha_psnr X, -ls_thresh_psnr X, -ls_thresh_alpha_psnr\n"
"  X, -ls_thresh_edge_psnr X, -ls_thresh_edge_alpha_psnr X: Windowed/bounded RDO\n"
"  settings (Lossy supercompression must be enabled, or -xy.)\n"
"\n"
" -xuastc_blurring: Experimental - enable blurred block candidates (MUCH slower\n"
"  compression, higher quality).\n"
"\n"
"These modes support all the standard ASTC block sizes. The larger the block\n"
"size, the lower the bitrate on disk and in memory, but the more noticeable the\n"
"artifacts. Some block sizes (4x4, 6x6, and 8x6) have specially optimized direct\n"
"transcoding paths to BC7. For faster direct BC7 transcoding at these block\n"
"sizes, disable RGB dual plane (-xp) and subset usage (-xs).\n"
"\n"
"  Block Size 	Base/Memory Size\n"
"  1. 4x4    	8.00 bpp\n"
"  2. 5x4    	6.40 bpp\n"
"  3. 5x5    	5.12 bpp\n"
"  4. 6x5    	4.27 bpp\n"
"  5. 6x6    	3.56 bpp\n"
"  6. 8x5    	3.20 bpp\n"
"  7. 8x6    	2.67 bpp\n"
"  8. 10x5   	2.56 bpp\n"
"  9. 10x6   	2.13 bpp\n"
" 10. 8x8    	2.00 bpp\n"
" 11. 10x8   	1.60 bpp\n"
" 12. 10x10  	1.28 bpp\n"
" 13. 12x10  	1.07 bpp\n"
" 14. 12x12  	0.89 bpp\n"
"\n"
"--- More options:\n"
"\n"
" -test: Run an automated LDR ETC1S/UASTC LDR 4x4 encoding and transcoding test.\n"
"  Returns EXIT_FAILURE on any failures.\n"
"\n"
" -test_hdr_4x4/-test_hdr_6x6/-test_hdr_6x6i: Run automated UASTC HDR encoding\n"
"  and transcoding tests. Returns EXIT_FAILURE on any failures.\n"
"\n"
" -test_xuastc: Run an automated XUASTC LDR encoding and transcoding test.\n"
"  Returns EXIT_FAILURE on any failures.\n"
"\n"
" -test_dir: Optional directory of test files. Defaults to \"../test_files\".\n"
"\n"
" -y_flip: Flip input images vertically before compression\n"
"\n"
" -normal_map: Tunes codec parameters for better quality on normal maps (linear\n"
"  colorspace metrics, linear mipmap filtering, no selector RDO, no sRGB)\n"
"\n"
" -no_alpha: Always output non-alpha basis files, even if one or more inputs has\n"
"  alpha\n"
"\n"
" -force_alpha: Always output alpha basis files, even if no inputs has alpha\n"
"\n"
" -separate_rg_to_color_alpha: Separate input R and G channels to RGB and A (for\n"
"  tangent space XY normal maps)\n"
"\n"
" -swizzle rgba: Specify swizzle for the 4 input color channels using r, g, b\n"
"  and a (the -separate_rg_to_color_alpha flag is equivalent to rrrg)\n"
"\n"
" -renorm: Renormalize each input image before any further\n"
"  processing/compression\n"
"\n"
" -no_multithreading: Disable multithreading\n"
"\n"
" -max_threads X: Use at most X threads total when multithreading is enabled\n"
"  (this includes the main thread)\n"
"\n"
" -wasi_threads: Set number of threads to use in WASI threading builds\n"
"  (default=8, only used in WASI threading builds)\n"
"\n"
" -no_ktx: Disable KTX writing when unpacking (faster, less output files)\n"
"\n"
" -ktx_only: Only write KTX files when unpacking (faster, less output files)\n"
"\n"
" -write_out: Write 3dfx OUT files when unpacking FXT1 textures\n"
"\n"
" -format_only: Only unpack the specified format, by its numeric code.\n"
"\n"
" -etc1_only: Only unpack to ETC1, skipping the other texture formats\n"
"  during -unpack\n"
"\n"
" -disable_hierarchical_endpoint_codebooks: Disable hierarchical endpoint\n"
"  codebook usage, slower but higher quality on some compression levels\n"
"\n"
" -compare_ssim: Compute and display SSIM of image comparison (slow)\n"
"\n"
" -compare_plot: Display histogram plots in -compare mode\n"
"\n"
" -bench: UASTC benchmark mode, for development only\n"
"\n"
" -resample X Y: Resample all input textures to XxY pixels using a box filter\n"
"\n"
" -resample_factor X: Resample all input textures by scale factor X using a box\n"
"  filter\n"
"\n"
" -no_sse: Forbid all SSE instruction set usage\n"
"\n"
" -validate_etc1s: Validate internal ETC1S compressor's data structures during\n"
"  compression (slower, intended for development).\n"
"\n"
" -ktx2_animdata_duration X: Set KTX2animData duration field to integer value X\n"
"  (only valid/useful for -tex_type video, default is 1)\n"
"\n"
" -ktx2_animdata_timescale X: Set KTX2animData timescale field to integer value\n"
"  X (only valid/useful for -tex_type video, default is 15)\n"
"\n"
" -ktx2_animdata_loopcount X: Set KTX2animData loopcount field to integer value\n"
"  X (only valid/useful for -tex_type video, default is 0)\n"
"\n"
" -framerate X: Set framerate in .basis header to X/frames sec.\n"
"\n"
" -ktx2_no_zstandard: Don't compress UASTC texture data using Zstandard -- store\n"
"  it uncompressed instead.\n"
"\n"
" -ktx2_zstandard_level X: Set ZStandard compression level to X (see Zstandard\n"
"  documentation, default level is 6)\n"
"\n"
" -tonemap_dither: Dither tonemapper's 8-bit/component output by adding a small\n"
"  amount of white noise, only used with -tonemap mode\n"
"\n"
"--- Mipmap Generator Options:\n"
"\n"
"By default, SDR textures will be converted from sRGB to linear light before\n"
"mipmap filtering, then back to sRGB (for the RGB color channels) unless -linear\n"
"is specified. You can override this behavior with -mip_srgb/-mip_linear.\n"
"\n"
" -mipmap: Generate mipmaps for each source image\n"
"\n"
" -mip_srgb: Convert image to linear before filtering, then back to sRGB.\n"
"  (This is set automatically by default, unless you override it.)\n"
"\n"
" -mip_linear: Keep image in linear light during mipmap filtering (i.e. do not\n"
"  convert to/from sRGB for filtering purposes). (This is set automatically by\n"
"  default, unless you override it.)\n"
"\n"
" -mip_scale X: Set mipmap filter kernel's scale, lower=sharper, higher=more\n"
"  blurry, default is 1.0 (quite conservative).\n"
"\n"
" -mip_filter X: Set mipmap filter kernel, default is kaiser. Supported filters:\n"
"  box, tent, bell, b-spline, mitchell, blackman, lanczos3, lanczos4, lanczos6,\n"
"  lanczos12, kaiser, gaussian, catmullrom, quadratic_interp, quadratic_approx,\n"
"  quadratic_mix\n"
"\n"
" -mip_renorm: Renormalize normal map to unit length vectors after filtering\n"
"\n"
" -mip_clamp: Use clamp addressing on borders, instead of wrapping\n"
"\n"
" -mip_fast: Use faster mipmap generation (resample from previous mip, not\n"
"  always first/largest mip level). The default.\n"
"\n"
" -mip_slow: Always resample each mipmap level starting from the largest mipmap.\n"
"  Higher quality, but slower. Opposite of -mip_fast. \n"
"\n"
" -mip_smallest X: Set smallest pixel dimension for generated mipmaps, default\n"
"  is 1 pixel \n"
"\n"
"--- Transcoding Options (used while unpacking, validating after compression):\n"
"\n"
"These settings control the \"decode flags\" used while transcoding:\n"
"\n"
" -higher_quality_transcoding: Enable higher quality, but slower, transcoding\n"
"\n"
" -no_deblocking: Always disable adaptive deblocking filter on all block sizes\n"
"  (XUASTC/ASTC LDR 4x4-12x12 only). By default only block sizes >8x6 are\n"
"  deblocked while transcoding. (No deblocking ever occurs when transcoding to\n"
"  ASTC: only when re-encoding ASTC to another format, to lower artifacts.)\n"
"\n"
" -force_deblocking: Always use adaptive deblocking filter, even for block sizes\n"
"  <= 8x6 (XUASTC/ASTC LDR 4x4-12x12 only)\n"
"\n"
" -stronger_deblocking: Use stronger adaptive deblocking filtering (XUASTC/ASTC\n"
"  LDR 4x4-12x12 only)\n"
"\n"
" -no_etc1s_chroma_filtering: Disable adaptive ETC1S transcode chroma filter,\n"
"  for faster transcoding to BC7.\n"
"\n"
" -fast_xuastc_ldr_bc7_transcoding: Use much faster, but lower quality, XUASTC\n"
"  LDR 4x4/6x6/8x6 direct BC7 transcoders (the default)\n"
"\n"
" -no_fast_xuastc_ldr_bc7_transcoding: Disable much faster, but slightly lower\n"
"  quality, XUASTC LDR 4x4/6x6/8x6 direct BC7 transcoders\n"
"\n"
"--- Low-Level ETC1S backend endpoint/selector RDO codec options:\n"
"\n"
" -no_selector_rdo: Disable backend's selector rate distortion optimizations\n"
"  (slightly faster, less noisy output, but lower quality per output bit)\n"
"\n"
" -selector_rdo_thresh X: Set selector RDO quality threshold, default is 1.25,\n"
"  lower is higher quality but less quality per output bit (try 1.0-3.0)\n"
"\n"
" -no_endpoint_rdo: Disable backend's endpoint rate distortion optimizations\n"
"  (slightly faster, less noisy output, but lower quality per output bit)\n"
"\n"
" -endpoint_rdo_thresh X: Set endpoint RDO quality threshold, default is 1.5,\n"
"  lower is higher quality but less quality per output bit (try 1.0-3.0)\n"
"\n"
"--- Set various low-level fields in the Basis file header:\n"
"\n"
" -userdata0 X: Set 32-bit userdata0 field in Basis file header to X (X is a\n"
"  signed 32-bit int)\n"
"\n"
" -userdata1 X: Set 32-bit userdata1 field in Basis file header to X (X is a\n"
"  signed 32-bit int)\n"
"\n"
"--- Example LDR ETC1S/UASTC LDR 4x4 command lines:\n"
"\n"
" - basisu x.png : Compress sRGB image x.png to x.ktx2 using default settings\n"
"   (multiple filenames OK, use -tex_array if you want a tex array vs. multiple\n"
"   output files)\n"
"\n"
" - basisu -basis x.qoi : Compress sRGB image x.qoi to x.basis (supports 24-bit\n"
"   or 32-bit .QOI files)\n"
"\n"
" - basisu x.ktx2 : Unpack x.basis to PNG/KTX files (multiple filenames OK)\n"
"\n"
" - basisu x.basis : Unpack x.basis to PNG/KTX files (multiple filenames OK)\n"
"\n"
" - basisu -uastc x.png -uastc_rdo_l 2.0 -ktx2 -stats : Compress to a\n"
"   UASTC .KTX2 file with RDO (rate distortion optimization) to reduce .KTX2\n"
"   compressed file size\n"
"\n"
" - basisu -file x.png -mipmap -y_flip : Compress a mipmapped x.ktx2 file from\n"
"   an sRGB image named x.png, Y flip each source image\n"
"\n"
" - basisu -validate -file x.basis : Validate x.basis (check header, check file\n"
"   CRC's, attempt to transcode all slices)\n"
"\n"
" - basisu -unpack -file x.basis : Validates, transcodes and unpacks x.basis to\n"
"   mipmapped .KTX and RGB/A .PNG files (transcodes to all supported GPU texture\n"
"   formats)\n"
"\n"
" - basisu -q 255 -file x.png -mipmap -debug -stats : Compress sRGB x.png to\n"
"   x.ktx2 at quality level 255 with compressor debug output/statistics\n"
"\n"
" - basisu -linear -max_endpoints 16128 -max_selectors 16128 -file x.png :\n"
"   Compress non-sRGB x.png to x.ktx2 using the largest supported manually\n"
"   specified codebook sizes\n"
"\n"
" - basisu -basis -comp_level 2 -max_selectors 8192 -max_endpoints\n"
"   8192 -tex_type video -framerate 20 -multifile_printf\n"
"   \"x%02u.png\" -multifile_first 1 -multifile_num 20 : Compress a 20 sRGB source\n"
"   image video sequence (x01.png, x02.png, x03.png, etc.) to x01.basis\n"
"\n"
"--- Example UASTC HDR 4x4 command lines:\n"
"\n"
" - basisu x.exr : Compress a HDR .EXR (or .HDR) image to a UASTC HDR 4x4 .KTX2\n"
"  file. LDR/SDR images will be upconverted to linear light HDR before\n"
"  compression. See HDR upconversion options, above.\n"
"\n"
" - basisu -hdr_4x4 x.exr : Compress a HDR .EXR image to a UASTC HDR 4x4 .KTX2\n"
"  file.\n"
"\n"
" - basisu x.hdr -uastc_level 0 : Compress a HDR .hdr image to a UASTC HDR\n"
"  4x4 .KTX2 file, fastest encoding but lowest quality\n"
"\n"
" - basisu -hdr x.png : Compress a LDR .PNG image to UASTC HDR 4x4 (image is\n"
"  converted from sRGB to linear light first, use -hdr_ldr_no_srgb_to_linear to\n"
"  disable)\n"
"\n"
" - basisu x.hdr -uastc_level 3 : Compress a HDR .hdr image to UASTC HDR 4x4 at\n"
"  higher quality (-uastc_level 4 is highest quality, but very slow encoding)\n"
"\n"
" - basisu x.hdr -uastc_level 3 -mipmap -basis -stats -debug -debug_images :\n"
"  Compress a HDR .hdr image to UASTC HDR 4x4, .basis output file, at higher\n"
"  quality, generate mipmaps, output statistics and debug information, and write\n"
"  tone mapped debug images\n"
"\n"
" - basisu x.hdr -stats -hdr_favor_astc -hdr_uber_mode -uastc_level 4 : Highest\n"
"  achievable ASTC HDR 4x4 quality (very slow encoding, BC6H quality is traded\n"
"  off)\n"
"\n"
"--- Example RDO ASTC/UASTC HDR 6x6 command lines:\n"
"\n"
" - basisu -hdr_6x6 x.exr : Compress a HDR .EXR (or .HDR) image to a UASTC HDR\n"
"  6x6 .KTX2 file. LDR/SDR images will be upconverted to linear light HDR before\n"
"  compression. See HDR upconversion options, above.\n"
"\n"
" - basisu -lambda 1000 -hdr_6x6 x.exr : Compress a HDR .EXR (or .HDR) image to\n"
"  a UASTC HDR 6x6 .KTX2 file with rate-distortion optimization (RDO), at lambda\n"
"  level 1000.\n"
"\n"
" - basisu -hdr_6x6i x.exr : Compress a HDR .EXR image to a compressed\n"
"  intermediate format UASTC HDR 6x6 .KTX2 file.\n"
"\n"
" - basisu -lambda 1000 -hdr_6x6i x.exr : Compress a HDR .EXR image to a\n"
"  compressed intermediate format UASTC HDR 6x6 .KTX2 file with rate-distortion\n"
"  optimization (RDO), at lambda level 1000.\n"
"\n"
"--- Example ASTC/XUASTC LDR 4x4-12x12 command lines:\n"
"\n"
" - basisu -ldr_6x6i -q 75 -xuastc_arith test.png : Compress test.png to XUASTC\n"
"  LDR 6x6 using weight grid DCT with setting 75 and the arith profile for\n"
"  higher compression.\n"
"\n"
" - basisu -ldr_4x4 test.png : Compress test.png to ASTC LDR 4x4\n"
"\n"
" - basisu -mipmap -ldr_10x5i test.png : Compress test.png to XUASTC LDR 10x5,\n"
"  using lossless ZStd supercompression, with mipmaps\n"
"\n"
"--- ETC1S Texture Video Notes: Use -comp_level 2 or higher for better codebook\n"
"generation, specify very large codebooks using -max_endpoints\n"
"and -max_selectors, and reduce the default endpoint RDO threshold\n"
"(-endpoint_rdo_thresh) to around 1.25. Videos may have mipmaps and alpha\n"
"channels. Videos must always be played back by the transcoder in first to last\n"
"image order. Video files currently use I-Frames on the first image, and\n"
"P-Frames using conditional replenishment on subsequent frames.\n"
"\n"
"--- Low-level ETC1S compression (Effort) Level (-comp_level X) Details \n"
"\n"
"This setting controls the ETC1S speed vs. quality tradeoff. (Use -q to control\n"
"the quality vs. compressed size tradeoff.):\n"
"\n"
" - Level 0: Fastest, but has marginal quality and can be brittle on complex\n"
"images. Avg. Y dB: 35.45\n"
"\n"
" - Level 1: Hierarchical codebook searching, faster ETC1S encoding. 36.87 dB,\n"
"~1.4x slower vs. level 0. (This is the default setting.)\n"
"\n"
" - Level 2: Use this or higher for video. Hierarchical codebook searching.\n"
"36.87 dB, ~1.4x slower vs. level 0. (This is the v1.12's default setting.)\n"
"\n"
" - Level 3: Full codebook searching. 37.13 dB, ~1.8x slower vs. level 0.\n"
"(Equivalent to the initial release's default settings.)\n"
"\n"
" - Level 4: Hierarchical codebook searching, codebook k-means iterations. 37.15\n"
"dB, ~4x slower vs. level 0\n"
"\n"
" - Level 5: Full codebook searching, codebook k-means iterations. 37.41 dB,\n"
"~5.5x slower vs. level 0.\n"
"\n"
" - Level 6: Full codebook searching, twice as many codebook k-means iterations,\n"
"best ETC1 endpoint opt. 37.43 dB, ~12x slower vs. level 0"
