/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSEvent.h"

#include "Event.h"
#include "EventTarget.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDictionary.h"
#include "JSEventTarget.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSEventTableValues[] =
{
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventType), (intptr_t)0, NoIntrinsic },
    { "target", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventTarget), (intptr_t)0, NoIntrinsic },
    { "currentTarget", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventCurrentTarget), (intptr_t)0, NoIntrinsic },
    { "eventPhase", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventEventPhase), (intptr_t)0, NoIntrinsic },
    { "bubbles", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventBubbles), (intptr_t)0, NoIntrinsic },
    { "cancelable", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventCancelable), (intptr_t)0, NoIntrinsic },
    { "timeStamp", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventTimeStamp), (intptr_t)0, NoIntrinsic },
    { "defaultPrevented", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventDefaultPrevented), (intptr_t)0, NoIntrinsic },
    { "srcElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSrcElement), (intptr_t)0, NoIntrinsic },
    { "returnValue", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventReturnValue), (intptr_t)setJSEventReturnValue, NoIntrinsic },
    { "cancelBubble", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventCancelBubble), (intptr_t)setJSEventCancelBubble, NoIntrinsic },
    { "clipboardData", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventClipboardData), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSEventTable = { 35, 31, JSEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSEventConstructorTableValues[] =
{
    { "NONE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventNONE), (intptr_t)0, NoIntrinsic },
    { "CAPTURING_PHASE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventCAPTURING_PHASE), (intptr_t)0, NoIntrinsic },
    { "AT_TARGET", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventAT_TARGET), (intptr_t)0, NoIntrinsic },
    { "BUBBLING_PHASE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventBUBBLING_PHASE), (intptr_t)0, NoIntrinsic },
    { "MOUSEDOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventMOUSEDOWN), (intptr_t)0, NoIntrinsic },
    { "MOUSEUP", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventMOUSEUP), (intptr_t)0, NoIntrinsic },
    { "MOUSEOVER", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventMOUSEOVER), (intptr_t)0, NoIntrinsic },
    { "MOUSEOUT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventMOUSEOUT), (intptr_t)0, NoIntrinsic },
    { "MOUSEMOVE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventMOUSEMOVE), (intptr_t)0, NoIntrinsic },
    { "MOUSEDRAG", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventMOUSEDRAG), (intptr_t)0, NoIntrinsic },
    { "CLICK", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventCLICK), (intptr_t)0, NoIntrinsic },
    { "DBLCLICK", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventDBLCLICK), (intptr_t)0, NoIntrinsic },
    { "KEYDOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventKEYDOWN), (intptr_t)0, NoIntrinsic },
    { "KEYUP", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventKEYUP), (intptr_t)0, NoIntrinsic },
    { "KEYPRESS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventKEYPRESS), (intptr_t)0, NoIntrinsic },
    { "DRAGDROP", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventDRAGDROP), (intptr_t)0, NoIntrinsic },
    { "FOCUS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventFOCUS), (intptr_t)0, NoIntrinsic },
    { "BLUR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventBLUR), (intptr_t)0, NoIntrinsic },
    { "SELECT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSELECT), (intptr_t)0, NoIntrinsic },
    { "CHANGE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventCHANGE), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSEventConstructorTable = { 69, 63, JSEventConstructorTableValues, 0 };

COMPILE_ASSERT(0 == Event::NONE, EventEnumNONEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == Event::CAPTURING_PHASE, EventEnumCAPTURING_PHASEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == Event::AT_TARGET, EventEnumAT_TARGETIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == Event::BUBBLING_PHASE, EventEnumBUBBLING_PHASEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == Event::MOUSEDOWN, EventEnumMOUSEDOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == Event::MOUSEUP, EventEnumMOUSEUPIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == Event::MOUSEOVER, EventEnumMOUSEOVERIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(8 == Event::MOUSEOUT, EventEnumMOUSEOUTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(16 == Event::MOUSEMOVE, EventEnumMOUSEMOVEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(32 == Event::MOUSEDRAG, EventEnumMOUSEDRAGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(64 == Event::CLICK, EventEnumCLICKIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(128 == Event::DBLCLICK, EventEnumDBLCLICKIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(256 == Event::KEYDOWN, EventEnumKEYDOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(512 == Event::KEYUP, EventEnumKEYUPIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1024 == Event::KEYPRESS, EventEnumKEYPRESSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2048 == Event::DRAGDROP, EventEnumDRAGDROPIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4096 == Event::FOCUS, EventEnumFOCUSIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(8192 == Event::BLUR, EventEnumBLURIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(16384 == Event::SELECT, EventEnumSELECTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(32768 == Event::CHANGE, EventEnumCHANGEIsWrongUseDoNotCheckConstants);

EncodedJSValue JSC_HOST_CALL JSEventConstructor::constructJSEvent(ExecState* exec)
{
    JSEventConstructor* jsConstructor = jsCast<JSEventConstructor*>(exec->callee());

    ScriptExecutionContext* executionContext = jsConstructor->scriptExecutionContext();
    if (!executionContext)
        return throwVMError(exec, createReferenceError(exec, "Constructor associated execution context is unavailable"));

    AtomicString eventType = exec->argument(0).toString(exec)->value(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    EventInit eventInit;

    JSValue initializerValue = exec->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(exec);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(exec, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<Event> event = Event::create(eventType, eventInit);
    return JSValue::encode(toJS(exec, jsConstructor->globalObject(), event.get()));
}

bool fillEventInit(EventInit& eventInit, JSDictionary& dictionary)
{
    if (!dictionary.tryGetProperty("bubbles", eventInit.bubbles))
        return false;
    if (!dictionary.tryGetProperty("cancelable", eventInit.cancelable))
        return false;
    return true;
}

static const HashTable* getJSEventConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSEventConstructorTable);
}

const ClassInfo JSEventConstructor::s_info = { "EventConstructor", &Base::s_info, 0, getJSEventConstructorTable, CREATE_METHOD_TABLE(JSEventConstructor) };

JSEventConstructor::JSEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(2), ReadOnly | DontDelete | DontEnum);
}

bool JSEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEventConstructor, JSDOMWrapper>(exec, getJSEventConstructorTable(exec), jsCast<JSEventConstructor*>(cell), propertyName, slot);
}

bool JSEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSEventConstructor, JSDOMWrapper>(exec, getJSEventConstructorTable(exec), jsCast<JSEventConstructor*>(object), propertyName, descriptor);
}

ConstructType JSEventConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSEvent;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSEventPrototypeTableValues[] =
{
    { "NONE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventNONE), (intptr_t)0, NoIntrinsic },
    { "CAPTURING_PHASE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventCAPTURING_PHASE), (intptr_t)0, NoIntrinsic },
    { "AT_TARGET", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventAT_TARGET), (intptr_t)0, NoIntrinsic },
    { "BUBBLING_PHASE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventBUBBLING_PHASE), (intptr_t)0, NoIntrinsic },
    { "MOUSEDOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventMOUSEDOWN), (intptr_t)0, NoIntrinsic },
    { "MOUSEUP", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventMOUSEUP), (intptr_t)0, NoIntrinsic },
    { "MOUSEOVER", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventMOUSEOVER), (intptr_t)0, NoIntrinsic },
    { "MOUSEOUT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventMOUSEOUT), (intptr_t)0, NoIntrinsic },
    { "MOUSEMOVE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventMOUSEMOVE), (intptr_t)0, NoIntrinsic },
    { "MOUSEDRAG", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventMOUSEDRAG), (intptr_t)0, NoIntrinsic },
    { "CLICK", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventCLICK), (intptr_t)0, NoIntrinsic },
    { "DBLCLICK", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventDBLCLICK), (intptr_t)0, NoIntrinsic },
    { "KEYDOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventKEYDOWN), (intptr_t)0, NoIntrinsic },
    { "KEYUP", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventKEYUP), (intptr_t)0, NoIntrinsic },
    { "KEYPRESS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventKEYPRESS), (intptr_t)0, NoIntrinsic },
    { "DRAGDROP", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventDRAGDROP), (intptr_t)0, NoIntrinsic },
    { "FOCUS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventFOCUS), (intptr_t)0, NoIntrinsic },
    { "BLUR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventBLUR), (intptr_t)0, NoIntrinsic },
    { "SELECT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventSELECT), (intptr_t)0, NoIntrinsic },
    { "CHANGE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEventCHANGE), (intptr_t)0, NoIntrinsic },
    { "stopPropagation", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsEventPrototypeFunctionStopPropagation), (intptr_t)0, NoIntrinsic },
    { "preventDefault", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsEventPrototypeFunctionPreventDefault), (intptr_t)0, NoIntrinsic },
    { "initEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsEventPrototypeFunctionInitEvent), (intptr_t)3, NoIntrinsic },
    { "stopImmediatePropagation", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsEventPrototypeFunctionStopImmediatePropagation), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSEventPrototypeTable = { 70, 63, JSEventPrototypeTableValues, 0 };
static const HashTable* getJSEventPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSEventPrototypeTable);
}

const ClassInfo JSEventPrototype::s_info = { "EventPrototype", &Base::s_info, 0, getJSEventPrototypeTable, CREATE_METHOD_TABLE(JSEventPrototype) };

JSObject* JSEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSEvent>(exec, globalObject);
}

bool JSEventPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSEventPrototype* thisObject = jsCast<JSEventPrototype*>(cell);
    return getStaticPropertySlot<JSEventPrototype, JSObject>(exec, getJSEventPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSEventPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSEventPrototype* thisObject = jsCast<JSEventPrototype*>(object);
    return getStaticPropertyDescriptor<JSEventPrototype, JSObject>(exec, getJSEventPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSEventTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSEventTable);
}

const ClassInfo JSEvent::s_info = { "Event", &Base::s_info, 0, getJSEventTable , CREATE_METHOD_TABLE(JSEvent) };

JSEvent::JSEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Event> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSEvent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSEventPrototype::create(exec->globalData(), globalObject, JSEventPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSEvent::destroy(JSC::JSCell* cell)
{
    JSEvent* thisObject = static_cast<JSEvent*>(cell);
    thisObject->JSEvent::~JSEvent();
}

JSEvent::~JSEvent()
{
    releaseImplIfNotNull();
}

bool JSEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSEvent* thisObject = jsCast<JSEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSEvent, Base>(exec, getJSEventTable(exec), thisObject, propertyName, slot);
}

bool JSEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSEvent* thisObject = jsCast<JSEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSEvent, Base>(exec, getJSEventTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsEventType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEvent* castedThis = jsCast<JSEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Event* impl = static_cast<Event*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->type());
    return result;
}


JSValue jsEventTarget(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEvent* castedThis = jsCast<JSEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Event* impl = static_cast<Event*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->target()));
    return result;
}


JSValue jsEventCurrentTarget(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEvent* castedThis = jsCast<JSEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Event* impl = static_cast<Event*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->currentTarget()));
    return result;
}


JSValue jsEventEventPhase(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEvent* castedThis = jsCast<JSEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Event* impl = static_cast<Event*>(castedThis->impl());
    JSValue result = jsNumber(impl->eventPhase());
    return result;
}


JSValue jsEventBubbles(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEvent* castedThis = jsCast<JSEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Event* impl = static_cast<Event*>(castedThis->impl());
    JSValue result = jsBoolean(impl->bubbles());
    return result;
}


JSValue jsEventCancelable(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEvent* castedThis = jsCast<JSEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Event* impl = static_cast<Event*>(castedThis->impl());
    JSValue result = jsBoolean(impl->cancelable());
    return result;
}


JSValue jsEventTimeStamp(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEvent* castedThis = jsCast<JSEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Event* impl = static_cast<Event*>(castedThis->impl());
    JSValue result = jsNumber(impl->timeStamp());
    return result;
}


JSValue jsEventDefaultPrevented(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEvent* castedThis = jsCast<JSEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Event* impl = static_cast<Event*>(castedThis->impl());
    JSValue result = jsBoolean(impl->defaultPrevented());
    return result;
}


JSValue jsEventSrcElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEvent* castedThis = jsCast<JSEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Event* impl = static_cast<Event*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->srcElement()));
    return result;
}


JSValue jsEventReturnValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEvent* castedThis = jsCast<JSEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Event* impl = static_cast<Event*>(castedThis->impl());
    JSValue result = jsBoolean(impl->returnValue());
    return result;
}


JSValue jsEventCancelBubble(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEvent* castedThis = jsCast<JSEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Event* impl = static_cast<Event*>(castedThis->impl());
    JSValue result = jsBoolean(impl->cancelBubble());
    return result;
}


JSValue jsEventClipboardData(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEvent* castedThis = jsCast<JSEvent*>(asObject(slotBase));
    return castedThis->clipboardData(exec);
}


JSValue jsEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEvent* domObject = jsCast<JSEvent*>(asObject(slotBase));
    return JSEvent::getConstructor(exec, domObject->globalObject());
}

void JSEvent::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSEvent* thisObject = jsCast<JSEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSEvent, Base>(exec, propertyName, value, getJSEventTable(exec), thisObject, slot);
}

void setJSEventReturnValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSEvent* castedThis = jsCast<JSEvent*>(thisObject);
    Event* impl = static_cast<Event*>(castedThis->impl());
    impl->setReturnValue(value.toBoolean(exec));
}


void setJSEventCancelBubble(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSEvent* castedThis = jsCast<JSEvent*>(thisObject);
    Event* impl = static_cast<Event*>(castedThis->impl());
    impl->setCancelBubble(value.toBoolean(exec));
}


JSValue JSEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsEventPrototypeFunctionStopPropagation(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEvent::s_info))
        return throwVMTypeError(exec);
    JSEvent* castedThis = jsCast<JSEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEvent::s_info);
    Event* impl = static_cast<Event*>(castedThis->impl());
    impl->stopPropagation();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsEventPrototypeFunctionPreventDefault(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEvent::s_info))
        return throwVMTypeError(exec);
    JSEvent* castedThis = jsCast<JSEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEvent::s_info);
    Event* impl = static_cast<Event*>(castedThis->impl());
    impl->preventDefault();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsEventPrototypeFunctionInitEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEvent::s_info))
        return throwVMTypeError(exec);
    JSEvent* castedThis = jsCast<JSEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEvent::s_info);
    Event* impl = static_cast<Event*>(castedThis->impl());
    const String& eventTypeArg(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool canBubbleArg(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool cancelableArg(exec->argument(2).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->initEvent(eventTypeArg, canBubbleArg, cancelableArg);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsEventPrototypeFunctionStopImmediatePropagation(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSEvent::s_info))
        return throwVMTypeError(exec);
    JSEvent* castedThis = jsCast<JSEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSEvent::s_info);
    Event* impl = static_cast<Event*>(castedThis->impl());
    impl->stopImmediatePropagation();
    return JSValue::encode(jsUndefined());
}

// Constant getters

JSValue jsEventNONE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsEventCAPTURING_PHASE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsEventAT_TARGET(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsEventBUBBLING_PHASE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsEventMOUSEDOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsEventMOUSEUP(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsEventMOUSEOVER(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}

JSValue jsEventMOUSEOUT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(8));
}

JSValue jsEventMOUSEMOVE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(16));
}

JSValue jsEventMOUSEDRAG(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(32));
}

JSValue jsEventCLICK(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(64));
}

JSValue jsEventDBLCLICK(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(128));
}

JSValue jsEventKEYDOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(256));
}

JSValue jsEventKEYUP(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(512));
}

JSValue jsEventKEYPRESS(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1024));
}

JSValue jsEventDRAGDROP(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2048));
}

JSValue jsEventFOCUS(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4096));
}

JSValue jsEventBLUR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(8192));
}

JSValue jsEventSELECT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(16384));
}

JSValue jsEventCHANGE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(32768));
}

static inline bool isObservable(JSEvent* jsEvent)
{
    if (jsEvent->hasCustomProperties())
        return true;
    return false;
}

bool JSEventOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSEvent* jsEvent = jsCast<JSEvent*>(handle.get().asCell());
    if (!isObservable(jsEvent))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSEventOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSEvent* jsEvent = jsCast<JSEvent*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEvent->impl(), jsEvent);
    jsEvent->releaseImpl();
}

Event* toEvent(JSC::JSValue value)
{
    return value.inherits(&JSEvent::s_info) ? jsCast<JSEvent*>(asObject(value))->impl() : 0;
}

}
