/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLAppletElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLAppletElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLAppletElement* kit(WebCore::HTMLAppletElement* obj)
{
    return WEBKIT_DOM_HTML_APPLET_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLAppletElement* core(WebKitDOMHTMLAppletElement* request)
{
    return request ? static_cast<WebCore::HTMLAppletElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLAppletElement* wrapHTMLAppletElement(WebCore::HTMLAppletElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_APPLET_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_APPLET_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLAppletElement, webkit_dom_html_applet_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_ALIGN,
    PROP_ALT,
    PROP_ARCHIVE,
    PROP_CODE,
    PROP_CODE_BASE,
    PROP_HEIGHT,
    PROP_HSPACE,
    PROP_NAME,
    PROP_OBJECT,
    PROP_VSPACE,
    PROP_WIDTH,
};

static void webkit_dom_html_applet_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLAppletElement* self = WEBKIT_DOM_HTML_APPLET_ELEMENT(object);
    WebCore::HTMLAppletElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ALIGN: {
        coreSelf->setAttribute(WebCore::HTMLNames::alignAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_ALT: {
        coreSelf->setAttribute(WebCore::HTMLNames::altAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_ARCHIVE: {
        coreSelf->setAttribute(WebCore::HTMLNames::archiveAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_CODE: {
        coreSelf->setAttribute(WebCore::HTMLNames::codeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_CODE_BASE: {
        coreSelf->setAttribute(WebCore::HTMLNames::codebaseAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HEIGHT: {
        coreSelf->setAttribute(WebCore::HTMLNames::heightAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HSPACE: {
        coreSelf->setIntegralAttribute(WebCore::HTMLNames::hspaceAttr, (g_value_get_long(value)));
        break;
    }
    case PROP_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::nameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_OBJECT: {
        coreSelf->setAttribute(WebCore::HTMLNames::objectAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_VSPACE: {
        coreSelf->setIntegralAttribute(WebCore::HTMLNames::vspaceAttr, (g_value_get_long(value)));
        break;
    }
    case PROP_WIDTH: {
        coreSelf->setAttribute(WebCore::HTMLNames::widthAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_applet_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLAppletElement* self = WEBKIT_DOM_HTML_APPLET_ELEMENT(object);
    WebCore::HTMLAppletElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ALIGN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::alignAttr)));
        break;
    }
    case PROP_ALT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::altAttr)));
        break;
    }
    case PROP_ARCHIVE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::archiveAttr)));
        break;
    }
    case PROP_CODE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::codeAttr)));
        break;
    }
    case PROP_CODE_BASE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::codebaseAttr)));
        break;
    }
    case PROP_HEIGHT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::heightAttr)));
        break;
    }
    case PROP_HSPACE: {
        g_value_set_long(value, coreSelf->getIntegralAttribute(WebCore::HTMLNames::hspaceAttr));
        break;
    }
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getNameAttribute()));
        break;
    }
    case PROP_OBJECT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::objectAttr)));
        break;
    }
    case PROP_VSPACE: {
        g_value_set_long(value, coreSelf->getIntegralAttribute(WebCore::HTMLNames::vspaceAttr));
        break;
    }
    case PROP_WIDTH: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::widthAttr)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_applet_element_class_init(WebKitDOMHTMLAppletElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_applet_element_set_property;
    gobjectClass->get_property = webkit_dom_html_applet_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_ALIGN,
                                    g_param_spec_string("align", /* name */
                                                           "html_applet_element_align", /* short description */
                                                           "read-write  gchar* HTMLAppletElement.align", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ALT,
                                    g_param_spec_string("alt", /* name */
                                                           "html_applet_element_alt", /* short description */
                                                           "read-write  gchar* HTMLAppletElement.alt", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ARCHIVE,
                                    g_param_spec_string("archive", /* name */
                                                           "html_applet_element_archive", /* short description */
                                                           "read-write  gchar* HTMLAppletElement.archive", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CODE,
                                    g_param_spec_string("code", /* name */
                                                           "html_applet_element_code", /* short description */
                                                           "read-write  gchar* HTMLAppletElement.code", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CODE_BASE,
                                    g_param_spec_string("code-base", /* name */
                                                           "html_applet_element_code-base", /* short description */
                                                           "read-write  gchar* HTMLAppletElement.code-base", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HEIGHT,
                                    g_param_spec_string("height", /* name */
                                                           "html_applet_element_height", /* short description */
                                                           "read-write  gchar* HTMLAppletElement.height", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HSPACE,
                                    g_param_spec_long("hspace", /* name */
                                                           "html_applet_element_hspace", /* short description */
                                                           "read-write  glong HTMLAppletElement.hspace", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "html_applet_element_name", /* short description */
                                                           "read-write  gchar* HTMLAppletElement.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_OBJECT,
                                    g_param_spec_string("object", /* name */
                                                           "html_applet_element_object", /* short description */
                                                           "read-write  gchar* HTMLAppletElement.object", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VSPACE,
                                    g_param_spec_long("vspace", /* name */
                                                           "html_applet_element_vspace", /* short description */
                                                           "read-write  glong HTMLAppletElement.vspace", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WIDTH,
                                    g_param_spec_string("width", /* name */
                                                           "html_applet_element_width", /* short description */
                                                           "read-write  gchar* HTMLAppletElement.width", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_applet_element_init(WebKitDOMHTMLAppletElement* request)
{
}

gchar*
webkit_dom_html_applet_element_get_align(WebKitDOMHTMLAppletElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self), 0);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}

void
webkit_dom_html_applet_element_set_align(WebKitDOMHTMLAppletElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::alignAttr, convertedValue);
}

gchar*
webkit_dom_html_applet_element_get_alt(WebKitDOMHTMLAppletElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self), 0);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::altAttr));
    return result;
}

void
webkit_dom_html_applet_element_set_alt(WebKitDOMHTMLAppletElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::altAttr, convertedValue);
}

gchar*
webkit_dom_html_applet_element_get_archive(WebKitDOMHTMLAppletElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self), 0);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::archiveAttr));
    return result;
}

void
webkit_dom_html_applet_element_set_archive(WebKitDOMHTMLAppletElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::archiveAttr, convertedValue);
}

gchar*
webkit_dom_html_applet_element_get_code(WebKitDOMHTMLAppletElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self), 0);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::codeAttr));
    return result;
}

void
webkit_dom_html_applet_element_set_code(WebKitDOMHTMLAppletElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::codeAttr, convertedValue);
}

gchar*
webkit_dom_html_applet_element_get_code_base(WebKitDOMHTMLAppletElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self), 0);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::codebaseAttr));
    return result;
}

void
webkit_dom_html_applet_element_set_code_base(WebKitDOMHTMLAppletElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::codebaseAttr, convertedValue);
}

gchar*
webkit_dom_html_applet_element_get_height(WebKitDOMHTMLAppletElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self), 0);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::heightAttr));
    return result;
}

void
webkit_dom_html_applet_element_set_height(WebKitDOMHTMLAppletElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::heightAttr, convertedValue);
}

glong
webkit_dom_html_applet_element_get_hspace(WebKitDOMHTMLAppletElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self), 0);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    glong result = item->getIntegralAttribute(WebCore::HTMLNames::hspaceAttr);
    return result;
}

void
webkit_dom_html_applet_element_set_hspace(WebKitDOMHTMLAppletElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self));
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    item->setIntegralAttribute(WebCore::HTMLNames::hspaceAttr, value);
}

gchar*
webkit_dom_html_applet_element_get_name(WebKitDOMHTMLAppletElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self), 0);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getNameAttribute());
    return result;
}

void
webkit_dom_html_applet_element_set_name(WebKitDOMHTMLAppletElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::nameAttr, convertedValue);
}

gchar*
webkit_dom_html_applet_element_get_object(WebKitDOMHTMLAppletElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self), 0);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::objectAttr));
    return result;
}

void
webkit_dom_html_applet_element_set_object(WebKitDOMHTMLAppletElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::objectAttr, convertedValue);
}

glong
webkit_dom_html_applet_element_get_vspace(WebKitDOMHTMLAppletElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self), 0);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    glong result = item->getIntegralAttribute(WebCore::HTMLNames::vspaceAttr);
    return result;
}

void
webkit_dom_html_applet_element_set_vspace(WebKitDOMHTMLAppletElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self));
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    item->setIntegralAttribute(WebCore::HTMLNames::vspaceAttr, value);
}

gchar*
webkit_dom_html_applet_element_get_width(WebKitDOMHTMLAppletElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self), 0);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::widthAttr));
    return result;
}

void
webkit_dom_html_applet_element_set_width(WebKitDOMHTMLAppletElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_APPLET_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLAppletElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::widthAttr, convertedValue);
}

