/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFileList.h"

#include "ExceptionCode.h"
#include "File.h"
#include "FileList.h"
#include "JSDOMBinding.h"
#include "JSFile.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSFileListTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileListLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFileListTable = { 5, 3, JSFileListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSFileListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFileListConstructorTable = { 1, 0, JSFileListConstructorTableValues, 0 };
static const HashTable* getJSFileListConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSFileListConstructorTable);
}

const ClassInfo JSFileListConstructor::s_info = { "FileListConstructor", &Base::s_info, 0, getJSFileListConstructorTable, CREATE_METHOD_TABLE(JSFileListConstructor) };

JSFileListConstructor::JSFileListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSFileListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSFileListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSFileListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSFileListConstructor, JSDOMWrapper>(exec, getJSFileListConstructorTable(exec), jsCast<JSFileListConstructor*>(cell), propertyName, slot);
}

bool JSFileListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSFileListConstructor, JSDOMWrapper>(exec, getJSFileListConstructorTable(exec), jsCast<JSFileListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSFileListPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileListPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFileListPrototypeTable = { 2, 1, JSFileListPrototypeTableValues, 0 };
static const HashTable* getJSFileListPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSFileListPrototypeTable);
}

const ClassInfo JSFileListPrototype::s_info = { "FileListPrototype", &Base::s_info, 0, getJSFileListPrototypeTable, CREATE_METHOD_TABLE(JSFileListPrototype) };

JSObject* JSFileListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFileList>(exec, globalObject);
}

bool JSFileListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSFileListPrototype* thisObject = jsCast<JSFileListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSFileListPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSFileListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSFileListPrototype* thisObject = jsCast<JSFileListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSFileListPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSFileListTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSFileListTable);
}

const ClassInfo JSFileList::s_info = { "FileList", &Base::s_info, 0, getJSFileListTable , CREATE_METHOD_TABLE(JSFileList) };

JSFileList::JSFileList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<FileList> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSFileList::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSFileList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSFileListPrototype::create(exec->globalData(), globalObject, JSFileListPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSFileList::destroy(JSC::JSCell* cell)
{
    JSFileList* thisObject = static_cast<JSFileList*>(cell);
    thisObject->JSFileList::~JSFileList();
}

JSFileList::~JSFileList()
{
    releaseImplIfNotNull();
}

bool JSFileList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSFileList* thisObject = jsCast<JSFileList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSFileList>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<FileList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSFileList, Base>(exec, getJSFileListTable(exec), thisObject, propertyName, slot);
}

bool JSFileList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSFileList* thisObject = jsCast<JSFileList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSFileListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<FileList*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSFileList, Base>(exec, getJSFileListTable(exec), thisObject, propertyName, descriptor);
}

bool JSFileList::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSFileList* thisObject = jsCast<JSFileList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<FileList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsFileListLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileList* castedThis = jsCast<JSFileList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileList* impl = static_cast<FileList*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsFileListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileList* domObject = jsCast<JSFileList*>(asObject(slotBase));
    return JSFileList::getConstructor(exec, domObject->globalObject());
}

void JSFileList::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSFileList* thisObject = jsCast<JSFileList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<FileList*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSFileList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsFileListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileList::s_info))
        return throwVMTypeError(exec);
    JSFileList* castedThis = jsCast<JSFileList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileList::s_info);
    FileList* impl = static_cast<FileList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    unsigned index(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}


JSValue JSFileList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSFileList* thisObj = jsCast<JSFileList*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<FileList*>(thisObj->impl())->item(index));
}

static inline bool isObservable(JSFileList* jsFileList)
{
    if (jsFileList->hasCustomProperties())
        return true;
    return false;
}

bool JSFileListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSFileList* jsFileList = jsCast<JSFileList*>(handle.get().asCell());
    if (!isObservable(jsFileList))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSFileListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSFileList* jsFileList = jsCast<JSFileList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsFileList->impl(), jsFileList);
    jsFileList->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, FileList* impl)
{
    return wrap<JSFileList>(exec, globalObject, impl);
}

FileList* toFileList(JSC::JSValue value)
{
    return value.inherits(&JSFileList::s_info) ? jsCast<JSFileList*>(asObject(value))->impl() : 0;
}

}
