/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSUint8ClampedArray.h"

#include "ExceptionCode.h"
#include "JSArrayBufferViewHelper.h"
#include "JSDOMBinding.h"
#include "JSUint8ClampedArray.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>
#include <wtf/Uint8ClampedArray.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSUint8ClampedArrayTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUint8ClampedArrayLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUint8ClampedArrayConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSUint8ClampedArrayTable = { 5, 3, JSUint8ClampedArrayTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSUint8ClampedArrayConstructorTableValues[] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUint8ClampedArrayBYTES_PER_ELEMENT), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSUint8ClampedArrayConstructorTable = { 2, 1, JSUint8ClampedArrayConstructorTableValues, 0 };
static const HashTable* getJSUint8ClampedArrayConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSUint8ClampedArrayConstructorTable);
}

const ClassInfo JSUint8ClampedArrayConstructor::s_info = { "Uint8ClampedArrayConstructor", &Base::s_info, 0, getJSUint8ClampedArrayConstructorTable, CREATE_METHOD_TABLE(JSUint8ClampedArrayConstructor) };

JSUint8ClampedArrayConstructor::JSUint8ClampedArrayConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSUint8ClampedArrayConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSUint8ClampedArrayPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(1), ReadOnly | DontDelete | DontEnum);
}

bool JSUint8ClampedArrayConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSUint8ClampedArrayConstructor, JSDOMWrapper>(exec, getJSUint8ClampedArrayConstructorTable(exec), jsCast<JSUint8ClampedArrayConstructor*>(cell), propertyName, slot);
}

bool JSUint8ClampedArrayConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSUint8ClampedArrayConstructor, JSDOMWrapper>(exec, getJSUint8ClampedArrayConstructorTable(exec), jsCast<JSUint8ClampedArrayConstructor*>(object), propertyName, descriptor);
}

EncodedJSValue JSC_HOST_CALL JSUint8ClampedArrayConstructor::constructJSUint8ClampedArray(ExecState* exec)
{
    JSUint8ClampedArrayConstructor* jsConstructor = jsCast<JSUint8ClampedArrayConstructor*>(exec->callee());
    RefPtr<Uint8ClampedArray> array = constructArrayBufferView<Uint8ClampedArray, unsigned char>(exec);
    if (!array.get())
        // Exception has already been thrown.
        return JSValue::encode(JSValue());
    return JSValue::encode(asObject(toJS(exec, jsConstructor->globalObject(), array.get())));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Uint8ClampedArray* object)
{
    return toJSArrayBufferView<JSUint8ClampedArray>(exec, globalObject, object);
}

void JSUint8ClampedArray::indexSetter(JSC::ExecState* exec, unsigned index, JSC::JSValue value)
{
    impl()->set(index, value.toNumber(exec));
}

ConstructType JSUint8ClampedArrayConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSUint8ClampedArray;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSUint8ClampedArrayPrototypeTableValues[] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUint8ClampedArrayBYTES_PER_ELEMENT), (intptr_t)0, NoIntrinsic },
    { "subarray", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsUint8ClampedArrayPrototypeFunctionSubarray), (intptr_t)2, NoIntrinsic },
    { "set", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsUint8ClampedArrayPrototypeFunctionSet), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSUint8ClampedArrayPrototypeTable = { 8, 7, JSUint8ClampedArrayPrototypeTableValues, 0 };
static const HashTable* getJSUint8ClampedArrayPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSUint8ClampedArrayPrototypeTable);
}

const ClassInfo JSUint8ClampedArrayPrototype::s_info = { "Uint8ClampedArrayPrototype", &Base::s_info, 0, getJSUint8ClampedArrayPrototypeTable, CREATE_METHOD_TABLE(JSUint8ClampedArrayPrototype) };

JSObject* JSUint8ClampedArrayPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSUint8ClampedArray>(exec, globalObject);
}

bool JSUint8ClampedArrayPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSUint8ClampedArrayPrototype* thisObject = jsCast<JSUint8ClampedArrayPrototype*>(cell);
    return getStaticPropertySlot<JSUint8ClampedArrayPrototype, JSObject>(exec, getJSUint8ClampedArrayPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSUint8ClampedArrayPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSUint8ClampedArrayPrototype* thisObject = jsCast<JSUint8ClampedArrayPrototype*>(object);
    return getStaticPropertyDescriptor<JSUint8ClampedArrayPrototype, JSObject>(exec, getJSUint8ClampedArrayPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSUint8ClampedArrayTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSUint8ClampedArrayTable);
}

const ClassInfo JSUint8ClampedArray::s_info = { "Uint8ClampedArray", &Base::s_info, 0, getJSUint8ClampedArrayTable , CREATE_METHOD_TABLE(JSUint8ClampedArray) };

JSUint8ClampedArray::JSUint8ClampedArray(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Uint8ClampedArray> impl)
    : JSUint8Array(structure, globalObject, impl)
{
}

void JSUint8ClampedArray::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    TypedArrayDescriptor descriptor(&JSUint8ClampedArray::s_info, OBJECT_OFFSETOF(JSUint8ClampedArray, m_storage), OBJECT_OFFSETOF(JSUint8ClampedArray, m_storageLength));
    globalData.registerTypedArrayDescriptor(impl(), descriptor);
    m_storage = impl()->data();
    m_storageLength = impl()->length();
    ASSERT(inherits(&s_info));
}

JSObject* JSUint8ClampedArray::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSUint8ClampedArrayPrototype::create(exec->globalData(), globalObject, JSUint8ClampedArrayPrototype::createStructure(exec->globalData(), globalObject, JSUint8ArrayPrototype::self(exec, globalObject)));
}

bool JSUint8ClampedArray::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSUint8ClampedArray* thisObject = jsCast<JSUint8ClampedArray*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<Uint8ClampedArray*>(thisObject->impl())->length()) {
        slot.setValue(thisObject->getByIndex(exec, index));
        return true;
    }
    return getStaticValueSlot<JSUint8ClampedArray, Base>(exec, getJSUint8ClampedArrayTable(exec), thisObject, propertyName, slot);
}

bool JSUint8ClampedArray::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSUint8ClampedArray* thisObject = jsCast<JSUint8ClampedArray*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<Uint8ClampedArray*>(thisObject->impl())->length()) {
        descriptor.setDescriptor(thisObject->getByIndex(exec, index), DontDelete);
        return true;
    }
    return getStaticValueDescriptor<JSUint8ClampedArray, Base>(exec, getJSUint8ClampedArrayTable(exec), thisObject, propertyName, descriptor);
}

bool JSUint8ClampedArray::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSUint8ClampedArray* thisObject = jsCast<JSUint8ClampedArray*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<Uint8ClampedArray*>(thisObject->impl())->length()) {
        slot.setValue(thisObject->getByIndex(exec, index));
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsUint8ClampedArrayLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSUint8ClampedArray* castedThis = jsCast<JSUint8ClampedArray*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Uint8ClampedArray* impl = static_cast<Uint8ClampedArray*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsUint8ClampedArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSUint8ClampedArray* domObject = jsCast<JSUint8ClampedArray*>(asObject(slotBase));
    return JSUint8ClampedArray::getConstructor(exec, domObject->globalObject());
}

void JSUint8ClampedArray::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSUint8ClampedArray* thisObject = jsCast<JSUint8ClampedArray*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex) {
        thisObject->indexSetter(exec, index, value);
        return;
    }
    Base::put(thisObject, exec, propertyName, value, slot);
}

void JSUint8ClampedArray::putByIndex(JSCell* cell, ExecState* exec, unsigned index, JSValue value, bool shouldThrow)
{
    JSUint8ClampedArray* thisObject = jsCast<JSUint8ClampedArray*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index <= MAX_ARRAY_INDEX) {
        UNUSED_PARAM(shouldThrow);
        thisObject->indexSetter(exec, index, value);
        return;
    }
    Base::putByIndex(cell, exec, index, value, shouldThrow);
}

void JSUint8ClampedArray::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSUint8ClampedArray* thisObject = jsCast<JSUint8ClampedArray*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<Uint8ClampedArray*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSUint8ClampedArray::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSUint8ClampedArrayConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsUint8ClampedArrayPrototypeFunctionSubarray(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSUint8ClampedArray::s_info))
        return throwVMTypeError(exec);
    JSUint8ClampedArray* castedThis = jsCast<JSUint8ClampedArray*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSUint8ClampedArray::s_info);
    Uint8ClampedArray* impl = static_cast<Uint8ClampedArray*>(castedThis->impl());
    int start(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->subarray(start)));
        return JSValue::encode(result);
    }

    int end(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->subarray(start, end)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsUint8ClampedArrayPrototypeFunctionSet(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSUint8ClampedArray::s_info))
        return throwVMTypeError(exec);
    JSUint8ClampedArray* castedThis = jsCast<JSUint8ClampedArray*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSUint8ClampedArray::s_info);
    return JSValue::encode(setWebGLArrayHelper<Uint8ClampedArray, unsigned char>(exec, castedThis->impl()));
}

// Constant getters

JSValue jsUint8ClampedArrayBYTES_PER_ELEMENT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}


JSValue JSUint8ClampedArray::getByIndex(ExecState*, unsigned index)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    double result = static_cast<Uint8ClampedArray*>(impl())->item(index);
    if (isnan(result))
        return jsNaN();
    return JSValue(result);
}

Uint8ClampedArray* toUint8ClampedArray(JSC::JSValue value)
{
    return value.inherits(&JSUint8ClampedArray::s_info) ? jsCast<JSUint8ClampedArray*>(asObject(value))->impl() : 0;
}

}
