; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -ppc-vsr-nums-as-vr -ppc-asm-full-reg-names < %s -mtriple=powerpc64-linux-gnu -mcpu=pwr8 -mattr=+vsx | FileCheck %s -check-prefix=CHECK-VSX
; RUN: llc -verify-machineinstrs -ppc-vsr-nums-as-vr -ppc-asm-full-reg-names < %s -mtriple=powerpc64-linux-gnu -mcpu=pwr8 -mattr=-vsx | FileCheck %s -check-prefixes=CHECK-NOVSX,CHECK-NOVSX-BE
; RUN: llc -verify-machineinstrs -ppc-vsr-nums-as-vr -ppc-asm-full-reg-names < %s -mtriple=powerpc64le-linux-gnu -mcpu=pwr8 -mattr=+vsx | FileCheck %s -check-prefix=CHECK-VSX
; RUN: llc -verify-machineinstrs -ppc-vsr-nums-as-vr -ppc-asm-full-reg-names < %s -mtriple=powerpc64le-linux-gnu -mcpu=pwr8 -mattr=-vsx | FileCheck %s -check-prefixes=CHECK-NOVSX,CHECK-NOVSX-LE

define <4 x float> @test1(<4 x float> %a, <4 x float> %b, <4 x float> %c, <4 x float> %d) {
; CHECK-VSX-LABEL: test1:
; CHECK-VSX:       # %bb.0: # %entry
; CHECK-VSX-NEXT:    xvcmpeqsp vs0, v4, v5
; CHECK-VSX-NEXT:    xxsel v2, v3, v2, vs0
; CHECK-VSX-NEXT:    blr
;
; CHECK-NOVSX-LABEL: test1:
; CHECK-NOVSX:       # %bb.0: # %entry
; CHECK-NOVSX-NEXT:    vcmpeqfp v4, v4, v5
; CHECK-NOVSX-NEXT:    vsel v2, v3, v2, v4
; CHECK-NOVSX-NEXT:    blr
entry:
  %m = fcmp oeq <4 x float> %c, %d
  %v = select <4 x i1> %m, <4 x float> %a, <4 x float> %b
  ret <4 x float> %v
}

define <2 x double> @test2(<2 x double> %a, <2 x double> %b, <2 x double> %c, <2 x double> %d) {
; CHECK-VSX-LABEL: test2:
; CHECK-VSX:       # %bb.0: # %entry
; CHECK-VSX-NEXT:    xvcmpeqdp v4, v4, v5
; CHECK-VSX-NEXT:    xxsel v2, v3, v2, v4
; CHECK-VSX-NEXT:    blr
;
; CHECK-NOVSX-LABEL: test2:
; CHECK-NOVSX:       # %bb.0: # %entry
; CHECK-NOVSX-NEXT:    fcmpu cr0, f5, f7
; CHECK-NOVSX-NEXT:    beq cr0, .LBB1_2
; CHECK-NOVSX-NEXT:  # %bb.1: # %entry
; CHECK-NOVSX-NEXT:    fmr f1, f3
; CHECK-NOVSX-NEXT:  .LBB1_2: # %entry
; CHECK-NOVSX-NEXT:    fcmpu cr0, f6, f8
; CHECK-NOVSX-NEXT:    beqlr cr0
; CHECK-NOVSX-NEXT:  # %bb.3: # %entry
; CHECK-NOVSX-NEXT:    fmr f2, f4
; CHECK-NOVSX-NEXT:    blr
entry:
  %m = fcmp oeq <2 x double> %c, %d
  %v = select <2 x i1> %m, <2 x double> %a, <2 x double> %b
  ret <2 x double> %v
}

define <16 x i8> @test3(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c, <16 x i8> %d) {
; CHECK-VSX-LABEL: test3:
; CHECK-VSX:       # %bb.0: # %entry
; CHECK-VSX-NEXT:    vcmpequb v4, v4, v5
; CHECK-VSX-NEXT:    xxsel v2, v3, v2, v4
; CHECK-VSX-NEXT:    blr
;
; CHECK-NOVSX-LABEL: test3:
; CHECK-NOVSX:       # %bb.0: # %entry
; CHECK-NOVSX-NEXT:    vcmpequb v4, v4, v5
; CHECK-NOVSX-NEXT:    vsel v2, v3, v2, v4
; CHECK-NOVSX-NEXT:    blr
entry:
  %m = icmp eq <16 x i8> %c, %d
  %v = select <16 x i1> %m, <16 x i8> %a, <16 x i8> %b
  ret <16 x i8> %v
}

define <8 x i16> @test4(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c, <8 x i16> %d) {
; CHECK-VSX-LABEL: test4:
; CHECK-VSX:       # %bb.0: # %entry
; CHECK-VSX-NEXT:    vcmpequh v4, v4, v5
; CHECK-VSX-NEXT:    xxsel v2, v3, v2, v4
; CHECK-VSX-NEXT:    blr
;
; CHECK-NOVSX-LABEL: test4:
; CHECK-NOVSX:       # %bb.0: # %entry
; CHECK-NOVSX-NEXT:    vcmpequh v4, v4, v5
; CHECK-NOVSX-NEXT:    vsel v2, v3, v2, v4
; CHECK-NOVSX-NEXT:    blr
entry:
  %m = icmp eq <8 x i16> %c, %d
  %v = select <8 x i1> %m, <8 x i16> %a, <8 x i16> %b
  ret <8 x i16> %v
}

define <4 x i32> @test5(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c, <4 x i32> %d) {
; CHECK-VSX-LABEL: test5:
; CHECK-VSX:       # %bb.0: # %entry
; CHECK-VSX-NEXT:    vcmpequw v4, v4, v5
; CHECK-VSX-NEXT:    xxsel v2, v3, v2, v4
; CHECK-VSX-NEXT:    blr
;
; CHECK-NOVSX-LABEL: test5:
; CHECK-NOVSX:       # %bb.0: # %entry
; CHECK-NOVSX-NEXT:    vcmpequw v4, v4, v5
; CHECK-NOVSX-NEXT:    vsel v2, v3, v2, v4
; CHECK-NOVSX-NEXT:    blr
entry:
  %m = icmp eq <4 x i32> %c, %d
  %v = select <4 x i1> %m, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %v
}

define <2 x i64> @test6(<2 x i64> %a, <2 x i64> %b, <2 x i64> %c, <2 x i64> %d) {
; CHECK-VSX-LABEL: test6:
; CHECK-VSX:       # %bb.0: # %entry
; CHECK-VSX-NEXT:    vcmpequd v4, v4, v5
; CHECK-VSX-NEXT:    xxsel v2, v3, v2, v4
; CHECK-VSX-NEXT:    blr
;
; CHECK-NOVSX-LABEL: test6:
; CHECK-NOVSX:       # %bb.0: # %entry
; CHECK-NOVSX-NEXT:    vcmpequd v4, v4, v5
; CHECK-NOVSX-NEXT:    vsel v2, v3, v2, v4
; CHECK-NOVSX-NEXT:    blr
entry:
  %m = icmp eq <2 x i64> %c, %d
  %v = select <2 x i1> %m, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %v
}

define <1 x i128> @test7(<1 x i128> %a, <1 x i128> %b, <1 x i128> %c, <1 x i128> %d) {
; CHECK-VSX-LABEL: test7:
; CHECK-VSX:       # %bb.0: # %entry
; CHECK-VSX-NEXT:    mfvsrd r3, v5
; CHECK-VSX-NEXT:    mfvsrd r4, v4
; CHECK-VSX-NEXT:    xor r3, r4, r3
; CHECK-VSX-NEXT:    xxswapd vs0, v5
; CHECK-VSX-NEXT:    xxswapd vs1, v4
; CHECK-VSX-NEXT:    mffprd r4, f0
; CHECK-VSX-NEXT:    mffprd r5, f1
; CHECK-VSX-NEXT:    xor r4, r5, r4
; CHECK-VSX-NEXT:    or. r3, r4, r3
; CHECK-VSX-NEXT:    bclr 12, eq, 0
; CHECK-VSX-NEXT:  # %bb.1: # %entry
; CHECK-VSX-NEXT:    vmr v2, v3
; CHECK-VSX-NEXT:    blr
;
; CHECK-NOVSX-BE-LABEL: test7:
; CHECK-NOVSX-BE:       # %bb.0: # %entry
; CHECK-NOVSX-BE-NEXT:    addi r3, r1, -16
; CHECK-NOVSX-BE-NEXT:    stvx v5, 0, r3
; CHECK-NOVSX-BE-NEXT:    addi r3, r1, -32
; CHECK-NOVSX-BE-NEXT:    stvx v4, 0, r3
; CHECK-NOVSX-BE-NEXT:    ld r3, -16(r1)
; CHECK-NOVSX-BE-NEXT:    ld r4, -32(r1)
; CHECK-NOVSX-BE-NEXT:    ld r5, -24(r1)
; CHECK-NOVSX-BE-NEXT:    xor r3, r4, r3
; CHECK-NOVSX-BE-NEXT:    ld r4, -8(r1)
; CHECK-NOVSX-BE-NEXT:    xor r4, r5, r4
; CHECK-NOVSX-BE-NEXT:    or. r3, r4, r3
; CHECK-NOVSX-BE-NEXT:    bclr 12, eq, 0
; CHECK-NOVSX-BE-NEXT:  # %bb.1: # %entry
; CHECK-NOVSX-BE-NEXT:    vmr v2, v3
; CHECK-NOVSX-BE-NEXT:    blr
;
; CHECK-NOVSX-LE-LABEL: test7:
; CHECK-NOVSX-LE:       # %bb.0: # %entry
; CHECK-NOVSX-LE-NEXT:    addi r3, r1, -16
; CHECK-NOVSX-LE-NEXT:    stvx v5, 0, r3
; CHECK-NOVSX-LE-NEXT:    addi r3, r1, -32
; CHECK-NOVSX-LE-NEXT:    stvx v4, 0, r3
; CHECK-NOVSX-LE-NEXT:    ld r3, -8(r1)
; CHECK-NOVSX-LE-NEXT:    ld r4, -24(r1)
; CHECK-NOVSX-LE-NEXT:    ld r5, -32(r1)
; CHECK-NOVSX-LE-NEXT:    xor r3, r4, r3
; CHECK-NOVSX-LE-NEXT:    ld r4, -16(r1)
; CHECK-NOVSX-LE-NEXT:    xor r4, r5, r4
; CHECK-NOVSX-LE-NEXT:    or. r3, r4, r3
; CHECK-NOVSX-LE-NEXT:    bclr 12, eq, 0
; CHECK-NOVSX-LE-NEXT:  # %bb.1: # %entry
; CHECK-NOVSX-LE-NEXT:    vmr v2, v3
; CHECK-NOVSX-LE-NEXT:    blr
entry:
  %m = icmp eq <1 x i128> %c, %d
  %v = select <1 x i1> %m, <1 x i128> %a, <1 x i128> %b
  ret <1 x i128> %v
}
