; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=aarch64-linux-gnu -passes="print<cost-model>" -cost-kind=all 2>&1 -disable-output | FileCheck %s --check-prefixes=CHECK,CHECK-NOF16
; RUN: opt < %s -mtriple=aarch64-linux-gnu -mattr=+fullfp16 -passes="print<cost-model>" -cost-kind=all 2>&1 -disable-output | FileCheck %s --check-prefixes=CHECK,CHECK-F16

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"

define void @reduce_umin() {
; CHECK-LABEL: 'reduce_umin'
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V1i8 = call i8 @llvm.vector.reduce.umin.v1i8(<1 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V3i8 = call i8 @llvm.vector.reduce.umin.v3i8(<3 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V4i8 = call i8 @llvm.vector.reduce.umin.v4i8(<4 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V8i8 = call i8 @llvm.vector.reduce.umin.v8i8(<8 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V16i8 = call i8 @llvm.vector.reduce.umin.v16i8(<16 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V32i8 = call i8 @llvm.vector.reduce.umin.v32i8(<32 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 5 for: %V64i8 = call i8 @llvm.vector.reduce.umin.v64i8(<64 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2i16 = call i16 @llvm.vector.reduce.umin.v2i16(<2 x i16> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V4i16 = call i16 @llvm.vector.reduce.umin.v4i16(<4 x i16> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V8i16 = call i16 @llvm.vector.reduce.umin.v8i16(<8 x i16> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V16i16 = call i16 @llvm.vector.reduce.umin.v16i16(<16 x i16> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2i32 = call i32 @llvm.vector.reduce.umin.v2i32(<2 x i32> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V4i32 = call i32 @llvm.vector.reduce.umin.v4i32(<4 x i32> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V8i32 = call i32 @llvm.vector.reduce.umin.v8i32(<8 x i32> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2i64 = call i64 @llvm.vector.reduce.umin.v2i64(<2 x i64> undef)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V4i64 = call i64 @llvm.vector.reduce.umin.v4i64(<4 x i64> undef)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V1i8 = call i8 @llvm.vector.reduce.umin.v1i8(<1 x i8> undef)
  %V3i8 = call i8 @llvm.vector.reduce.umin.v3i8(<3 x i8> undef)
  %V4i8 = call i8 @llvm.vector.reduce.umin.v4i8(<4 x i8> undef)
  %V8i8 = call i8 @llvm.vector.reduce.umin.v8i8(<8 x i8> undef)
  %V16i8 = call i8 @llvm.vector.reduce.umin.v16i8(<16 x i8> undef)
  %V32i8 = call i8 @llvm.vector.reduce.umin.v32i8(<32 x i8> undef)
  %V64i8 = call i8 @llvm.vector.reduce.umin.v64i8(<64 x i8> undef)
  %V2i16 = call i16 @llvm.vector.reduce.umin.v2i16(<2 x i16> undef)
  %V4i16 = call i16 @llvm.vector.reduce.umin.v4i16(<4 x i16> undef)
  %V8i16 = call i16 @llvm.vector.reduce.umin.v8i16(<8 x i16> undef)
  %V16i16 = call i16 @llvm.vector.reduce.umin.v16i16(<16 x i16> undef)
  %V2i32 = call i32 @llvm.vector.reduce.umin.v2i32(<2 x i32> undef)
  %V4i32 = call i32 @llvm.vector.reduce.umin.v4i32(<4 x i32> undef)
  %V8i32 = call i32 @llvm.vector.reduce.umin.v8i32(<8 x i32> undef)
  %V2i64 = call i64 @llvm.vector.reduce.umin.v2i64(<2 x i64> undef)
  %V4i64 = call i64 @llvm.vector.reduce.umin.v4i64(<4 x i64> undef)
  ret void
}

define void @reduce_umax() {
; CHECK-LABEL: 'reduce_umax'
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V1i8 = call i8 @llvm.vector.reduce.umax.v1i8(<1 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V3i8 = call i8 @llvm.vector.reduce.umax.v3i8(<3 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V4i8 = call i8 @llvm.vector.reduce.umax.v4i8(<4 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V8i8 = call i8 @llvm.vector.reduce.umax.v8i8(<8 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V16i8 = call i8 @llvm.vector.reduce.umax.v16i8(<16 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V32i8 = call i8 @llvm.vector.reduce.umax.v32i8(<32 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 5 for: %V64i8 = call i8 @llvm.vector.reduce.umax.v64i8(<64 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2i16 = call i16 @llvm.vector.reduce.umax.v2i16(<2 x i16> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V4i16 = call i16 @llvm.vector.reduce.umax.v4i16(<4 x i16> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V8i16 = call i16 @llvm.vector.reduce.umax.v8i16(<8 x i16> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V16i16 = call i16 @llvm.vector.reduce.umax.v16i16(<16 x i16> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2i32 = call i32 @llvm.vector.reduce.umax.v2i32(<2 x i32> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V4i32 = call i32 @llvm.vector.reduce.umax.v4i32(<4 x i32> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V8i32 = call i32 @llvm.vector.reduce.umax.v8i32(<8 x i32> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2i64 = call i64 @llvm.vector.reduce.umax.v2i64(<2 x i64> undef)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V4i64 = call i64 @llvm.vector.reduce.umax.v4i64(<4 x i64> undef)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V1i8 = call i8 @llvm.vector.reduce.umax.v1i8(<1 x i8> undef)
  %V3i8 = call i8 @llvm.vector.reduce.umax.v3i8(<3 x i8> undef)
  %V4i8 = call i8 @llvm.vector.reduce.umax.v4i8(<4 x i8> undef)
  %V8i8 = call i8 @llvm.vector.reduce.umax.v8i8(<8 x i8> undef)
  %V16i8 = call i8 @llvm.vector.reduce.umax.v16i8(<16 x i8> undef)
  %V32i8 = call i8 @llvm.vector.reduce.umax.v32i8(<32 x i8> undef)
  %V64i8 = call i8 @llvm.vector.reduce.umax.v64i8(<64 x i8> undef)
  %V2i16 = call i16 @llvm.vector.reduce.umax.v2i16(<2 x i16> undef)
  %V4i16 = call i16 @llvm.vector.reduce.umax.v4i16(<4 x i16> undef)
  %V8i16 = call i16 @llvm.vector.reduce.umax.v8i16(<8 x i16> undef)
  %V16i16 = call i16 @llvm.vector.reduce.umax.v16i16(<16 x i16> undef)
  %V2i32 = call i32 @llvm.vector.reduce.umax.v2i32(<2 x i32> undef)
  %V4i32 = call i32 @llvm.vector.reduce.umax.v4i32(<4 x i32> undef)
  %V8i32 = call i32 @llvm.vector.reduce.umax.v8i32(<8 x i32> undef)
  %V2i64 = call i64 @llvm.vector.reduce.umax.v2i64(<2 x i64> undef)
  %V4i64 = call i64 @llvm.vector.reduce.umax.v4i64(<4 x i64> undef)
  ret void
}

define void @reduce_smin() {
; CHECK-LABEL: 'reduce_smin'
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V1i8 = call i8 @llvm.vector.reduce.smin.v1i8(<1 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V3i8 = call i8 @llvm.vector.reduce.smin.v3i8(<3 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V4i8 = call i8 @llvm.vector.reduce.smin.v4i8(<4 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V8i8 = call i8 @llvm.vector.reduce.smin.v8i8(<8 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V16i8 = call i8 @llvm.vector.reduce.smin.v16i8(<16 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V32i8 = call i8 @llvm.vector.reduce.smin.v32i8(<32 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 5 for: %V64i8 = call i8 @llvm.vector.reduce.smin.v64i8(<64 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2i16 = call i16 @llvm.vector.reduce.smin.v2i16(<2 x i16> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V4i16 = call i16 @llvm.vector.reduce.smin.v4i16(<4 x i16> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V8i16 = call i16 @llvm.vector.reduce.smin.v8i16(<8 x i16> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V16i16 = call i16 @llvm.vector.reduce.smin.v16i16(<16 x i16> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2i32 = call i32 @llvm.vector.reduce.smin.v2i32(<2 x i32> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V4i32 = call i32 @llvm.vector.reduce.smin.v4i32(<4 x i32> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V8i32 = call i32 @llvm.vector.reduce.smin.v8i32(<8 x i32> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2i64 = call i64 @llvm.vector.reduce.smin.v2i64(<2 x i64> undef)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V4i64 = call i64 @llvm.vector.reduce.smin.v4i64(<4 x i64> undef)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V1i8 = call i8 @llvm.vector.reduce.smin.v1i8(<1 x i8> undef)
  %V3i8 = call i8 @llvm.vector.reduce.smin.v3i8(<3 x i8> undef)
  %V4i8 = call i8 @llvm.vector.reduce.smin.v4i8(<4 x i8> undef)
  %V8i8 = call i8 @llvm.vector.reduce.smin.v8i8(<8 x i8> undef)
  %V16i8 = call i8 @llvm.vector.reduce.smin.v16i8(<16 x i8> undef)
  %V32i8 = call i8 @llvm.vector.reduce.smin.v32i8(<32 x i8> undef)
  %V64i8 = call i8 @llvm.vector.reduce.smin.v64i8(<64 x i8> undef)
  %V2i16 = call i16 @llvm.vector.reduce.smin.v2i16(<2 x i16> undef)
  %V4i16 = call i16 @llvm.vector.reduce.smin.v4i16(<4 x i16> undef)
  %V8i16 = call i16 @llvm.vector.reduce.smin.v8i16(<8 x i16> undef)
  %V16i16 = call i16 @llvm.vector.reduce.smin.v16i16(<16 x i16> undef)
  %V2i32 = call i32 @llvm.vector.reduce.smin.v2i32(<2 x i32> undef)
  %V4i32 = call i32 @llvm.vector.reduce.smin.v4i32(<4 x i32> undef)
  %V8i32 = call i32 @llvm.vector.reduce.smin.v8i32(<8 x i32> undef)
  %V2i64 = call i64 @llvm.vector.reduce.smin.v2i64(<2 x i64> undef)
  %V4i64 = call i64 @llvm.vector.reduce.smin.v4i64(<4 x i64> undef)
  ret void
}

define void @reduce_smax() {
; CHECK-LABEL: 'reduce_smax'
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V1i8 = call i8 @llvm.vector.reduce.smax.v1i8(<1 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V3i8 = call i8 @llvm.vector.reduce.smax.v3i8(<3 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V4i8 = call i8 @llvm.vector.reduce.smax.v4i8(<4 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V8i8 = call i8 @llvm.vector.reduce.smax.v8i8(<8 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V16i8 = call i8 @llvm.vector.reduce.smax.v16i8(<16 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V32i8 = call i8 @llvm.vector.reduce.smax.v32i8(<32 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 5 for: %V64i8 = call i8 @llvm.vector.reduce.smax.v64i8(<64 x i8> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2i16 = call i16 @llvm.vector.reduce.smax.v2i16(<2 x i16> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V4i16 = call i16 @llvm.vector.reduce.smax.v4i16(<4 x i16> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V8i16 = call i16 @llvm.vector.reduce.smax.v8i16(<8 x i16> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V16i16 = call i16 @llvm.vector.reduce.smax.v16i16(<16 x i16> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2i32 = call i32 @llvm.vector.reduce.smax.v2i32(<2 x i32> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V4i32 = call i32 @llvm.vector.reduce.smax.v4i32(<4 x i32> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V8i32 = call i32 @llvm.vector.reduce.smax.v8i32(<8 x i32> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2i64 = call i64 @llvm.vector.reduce.smax.v2i64(<2 x i64> undef)
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %V4i64 = call i64 @llvm.vector.reduce.smax.v4i64(<4 x i64> undef)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V1i8 = call i8 @llvm.vector.reduce.smax.v1i8(<1 x i8> undef)
  %V3i8 = call i8 @llvm.vector.reduce.smax.v3i8(<3 x i8> undef)
  %V4i8 = call i8 @llvm.vector.reduce.smax.v4i8(<4 x i8> undef)
  %V8i8 = call i8 @llvm.vector.reduce.smax.v8i8(<8 x i8> undef)
  %V16i8 = call i8 @llvm.vector.reduce.smax.v16i8(<16 x i8> undef)
  %V32i8 = call i8 @llvm.vector.reduce.smax.v32i8(<32 x i8> undef)
  %V64i8 = call i8 @llvm.vector.reduce.smax.v64i8(<64 x i8> undef)
  %V2i16 = call i16 @llvm.vector.reduce.smax.v2i16(<2 x i16> undef)
  %V4i16 = call i16 @llvm.vector.reduce.smax.v4i16(<4 x i16> undef)
  %V8i16 = call i16 @llvm.vector.reduce.smax.v8i16(<8 x i16> undef)
  %V16i16 = call i16 @llvm.vector.reduce.smax.v16i16(<16 x i16> undef)
  %V2i32 = call i32 @llvm.vector.reduce.smax.v2i32(<2 x i32> undef)
  %V4i32 = call i32 @llvm.vector.reduce.smax.v4i32(<4 x i32> undef)
  %V8i32 = call i32 @llvm.vector.reduce.smax.v8i32(<8 x i32> undef)
  %V2i64 = call i64 @llvm.vector.reduce.smax.v2i64(<2 x i64> undef)
  %V4i64 = call i64 @llvm.vector.reduce.smax.v4i64(<4 x i64> undef)
  ret void
}

define void @reduce_fmin16() {
; CHECK-NOF16-LABEL: 'reduce_fmin16'
; CHECK-NOF16-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:8 Lat:11 SizeLat:11 for: %V2f16 = call half @llvm.vector.reduce.fmin.v2f16(<2 x half> undef)
; CHECK-NOF16-NEXT:  Cost Model: Found costs of RThru:50 CodeSize:32 Lat:50 SizeLat:50 for: %V4f16 = call half @llvm.vector.reduce.fmin.v4f16(<4 x half> undef)
; CHECK-NOF16-NEXT:  Cost Model: Found costs of RThru:174 CodeSize:111 Lat:174 SizeLat:174 for: %V8f16 = call half @llvm.vector.reduce.fmin.v8f16(<8 x half> undef)
; CHECK-NOF16-NEXT:  Cost Model: Found costs of RThru:240 CodeSize:156 Lat:240 SizeLat:240 for: %V16f16 = call half @llvm.vector.reduce.fmin.v16f16(<16 x half> undef)
; CHECK-NOF16-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:8 Lat:11 SizeLat:11 for: %V2f16m = call half @llvm.vector.reduce.fminimum.v2f16(<2 x half> undef)
; CHECK-NOF16-NEXT:  Cost Model: Found costs of RThru:50 CodeSize:32 Lat:50 SizeLat:50 for: %V4f16m = call half @llvm.vector.reduce.fminimum.v4f16(<4 x half> undef)
; CHECK-NOF16-NEXT:  Cost Model: Found costs of RThru:174 CodeSize:111 Lat:174 SizeLat:174 for: %V8f16m = call half @llvm.vector.reduce.fminimum.v8f16(<8 x half> undef)
; CHECK-NOF16-NEXT:  Cost Model: Found costs of RThru:240 CodeSize:156 Lat:240 SizeLat:240 for: %V16f16m = call half @llvm.vector.reduce.fminimum.v16f16(<16 x half> undef)
; CHECK-NOF16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-F16-LABEL: 'reduce_fmin16'
; CHECK-F16-NEXT:  Cost Model: Found costs of 2 for: %V2f16 = call half @llvm.vector.reduce.fmin.v2f16(<2 x half> undef)
; CHECK-F16-NEXT:  Cost Model: Found costs of 2 for: %V4f16 = call half @llvm.vector.reduce.fmin.v4f16(<4 x half> undef)
; CHECK-F16-NEXT:  Cost Model: Found costs of 2 for: %V8f16 = call half @llvm.vector.reduce.fmin.v8f16(<8 x half> undef)
; CHECK-F16-NEXT:  Cost Model: Found costs of 3 for: %V16f16 = call half @llvm.vector.reduce.fmin.v16f16(<16 x half> undef)
; CHECK-F16-NEXT:  Cost Model: Found costs of 2 for: %V2f16m = call half @llvm.vector.reduce.fminimum.v2f16(<2 x half> undef)
; CHECK-F16-NEXT:  Cost Model: Found costs of 2 for: %V4f16m = call half @llvm.vector.reduce.fminimum.v4f16(<4 x half> undef)
; CHECK-F16-NEXT:  Cost Model: Found costs of 2 for: %V8f16m = call half @llvm.vector.reduce.fminimum.v8f16(<8 x half> undef)
; CHECK-F16-NEXT:  Cost Model: Found costs of 3 for: %V16f16m = call half @llvm.vector.reduce.fminimum.v16f16(<16 x half> undef)
; CHECK-F16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V2f16 = call half @llvm.vector.reduce.fmin.v2f16(<2 x half> undef)
  %V4f16 = call half @llvm.vector.reduce.fmin.v4f16(<4 x half> undef)
  %V8f16 = call half @llvm.vector.reduce.fmin.v8f16(<8 x half> undef)
  %V16f16 = call half @llvm.vector.reduce.fmin.v16f16(<16 x half> undef)
  %V2f16m = call half @llvm.vector.reduce.fminimum.v2f16(<2 x half> undef)
  %V4f16m = call half @llvm.vector.reduce.fminimum.v4f16(<4 x half> undef)
  %V8f16m = call half @llvm.vector.reduce.fminimum.v8f16(<8 x half> undef)
  %V16f16m = call half @llvm.vector.reduce.fminimum.v16f16(<16 x half> undef)
  ret void
}

define void @reduce_fmax16() {
; CHECK-NOF16-LABEL: 'reduce_fmax16'
; CHECK-NOF16-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:8 Lat:11 SizeLat:11 for: %V2f16 = call half @llvm.vector.reduce.fmax.v2f16(<2 x half> undef)
; CHECK-NOF16-NEXT:  Cost Model: Found costs of RThru:50 CodeSize:32 Lat:50 SizeLat:50 for: %V4f16 = call half @llvm.vector.reduce.fmax.v4f16(<4 x half> undef)
; CHECK-NOF16-NEXT:  Cost Model: Found costs of RThru:174 CodeSize:111 Lat:174 SizeLat:174 for: %V8f16 = call half @llvm.vector.reduce.fmax.v8f16(<8 x half> undef)
; CHECK-NOF16-NEXT:  Cost Model: Found costs of RThru:240 CodeSize:156 Lat:240 SizeLat:240 for: %V16f16 = call half @llvm.vector.reduce.fmax.v16f16(<16 x half> undef)
; CHECK-NOF16-NEXT:  Cost Model: Found costs of RThru:11 CodeSize:8 Lat:11 SizeLat:11 for: %V2f16m = call half @llvm.vector.reduce.fmaximum.v2f16(<2 x half> undef)
; CHECK-NOF16-NEXT:  Cost Model: Found costs of RThru:50 CodeSize:32 Lat:50 SizeLat:50 for: %V4f16m = call half @llvm.vector.reduce.fmaximum.v4f16(<4 x half> undef)
; CHECK-NOF16-NEXT:  Cost Model: Found costs of RThru:174 CodeSize:111 Lat:174 SizeLat:174 for: %V8f16m = call half @llvm.vector.reduce.fmaximum.v8f16(<8 x half> undef)
; CHECK-NOF16-NEXT:  Cost Model: Found costs of RThru:240 CodeSize:156 Lat:240 SizeLat:240 for: %V16f16m = call half @llvm.vector.reduce.fmaximum.v16f16(<16 x half> undef)
; CHECK-NOF16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-F16-LABEL: 'reduce_fmax16'
; CHECK-F16-NEXT:  Cost Model: Found costs of 2 for: %V2f16 = call half @llvm.vector.reduce.fmax.v2f16(<2 x half> undef)
; CHECK-F16-NEXT:  Cost Model: Found costs of 2 for: %V4f16 = call half @llvm.vector.reduce.fmax.v4f16(<4 x half> undef)
; CHECK-F16-NEXT:  Cost Model: Found costs of 2 for: %V8f16 = call half @llvm.vector.reduce.fmax.v8f16(<8 x half> undef)
; CHECK-F16-NEXT:  Cost Model: Found costs of 3 for: %V16f16 = call half @llvm.vector.reduce.fmax.v16f16(<16 x half> undef)
; CHECK-F16-NEXT:  Cost Model: Found costs of 2 for: %V2f16m = call half @llvm.vector.reduce.fmaximum.v2f16(<2 x half> undef)
; CHECK-F16-NEXT:  Cost Model: Found costs of 2 for: %V4f16m = call half @llvm.vector.reduce.fmaximum.v4f16(<4 x half> undef)
; CHECK-F16-NEXT:  Cost Model: Found costs of 2 for: %V8f16m = call half @llvm.vector.reduce.fmaximum.v8f16(<8 x half> undef)
; CHECK-F16-NEXT:  Cost Model: Found costs of 3 for: %V16f16m = call half @llvm.vector.reduce.fmaximum.v16f16(<16 x half> undef)
; CHECK-F16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V2f16 = call half @llvm.vector.reduce.fmax.v2f16(<2 x half> undef)
  %V4f16 = call half @llvm.vector.reduce.fmax.v4f16(<4 x half> undef)
  %V8f16 = call half @llvm.vector.reduce.fmax.v8f16(<8 x half> undef)
  %V16f16 = call half @llvm.vector.reduce.fmax.v16f16(<16 x half> undef)
  %V2f16m = call half @llvm.vector.reduce.fmaximum.v2f16(<2 x half> undef)
  %V4f16m = call half @llvm.vector.reduce.fmaximum.v4f16(<4 x half> undef)
  %V8f16m = call half @llvm.vector.reduce.fmaximum.v8f16(<8 x half> undef)
  %V16f16m = call half @llvm.vector.reduce.fmaximum.v16f16(<16 x half> undef)
  ret void
}

define void @reduce_fmin() {
; CHECK-LABEL: 'reduce_fmin'
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2f32 = call float @llvm.vector.reduce.fmin.v2f32(<2 x float> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V4f32 = call float @llvm.vector.reduce.fmin.v4f32(<4 x float> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V8f32 = call float @llvm.vector.reduce.fmin.v8f32(<8 x float> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2f64 = call double @llvm.vector.reduce.fmin.v2f64(<2 x double> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V4f64 = call double @llvm.vector.reduce.fmin.v4f64(<4 x double> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2f32m = call float @llvm.vector.reduce.fminimum.v2f32(<2 x float> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V4f32m = call float @llvm.vector.reduce.fminimum.v4f32(<4 x float> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V8f32m = call float @llvm.vector.reduce.fminimum.v8f32(<8 x float> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2f64m = call double @llvm.vector.reduce.fminimum.v2f64(<2 x double> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V4f64m = call double @llvm.vector.reduce.fminimum.v4f64(<4 x double> undef)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V2f32 = call float @llvm.vector.reduce.fmin.v2f32(<2 x float> undef)
  %V4f32 = call float @llvm.vector.reduce.fmin.v4f32(<4 x float> undef)
  %V8f32 = call float @llvm.vector.reduce.fmin.v8f32(<8 x float> undef)
  %V2f64 = call double @llvm.vector.reduce.fmin.v2f64(<2 x double> undef)
  %V4f64 = call double @llvm.vector.reduce.fmin.v4f64(<4 x double> undef)
  %V2f32m = call float @llvm.vector.reduce.fminimum.v2f32(<2 x float> undef)
  %V4f32m = call float @llvm.vector.reduce.fminimum.v4f32(<4 x float> undef)
  %V8f32m = call float @llvm.vector.reduce.fminimum.v8f32(<8 x float> undef)
  %V2f64m = call double @llvm.vector.reduce.fminimum.v2f64(<2 x double> undef)
  %V4f64m = call double @llvm.vector.reduce.fminimum.v4f64(<4 x double> undef)
  ret void
}

define void @reduce_fmax() {
; CHECK-LABEL: 'reduce_fmax'
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2f32 = call float @llvm.vector.reduce.fmax.v2f32(<2 x float> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V4f32 = call float @llvm.vector.reduce.fmax.v4f32(<4 x float> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V8f32 = call float @llvm.vector.reduce.fmax.v8f32(<8 x float> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2f64 = call double @llvm.vector.reduce.fmax.v2f64(<2 x double> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V4f64 = call double @llvm.vector.reduce.fmax.v4f64(<4 x double> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2f32m = call float @llvm.vector.reduce.fmaximum.v2f32(<2 x float> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V4f32m = call float @llvm.vector.reduce.fmaximum.v4f32(<4 x float> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V8f32m = call float @llvm.vector.reduce.fmaximum.v8f32(<8 x float> undef)
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %V2f64m = call double @llvm.vector.reduce.fmaximum.v2f64(<2 x double> undef)
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %V4f64m = call double @llvm.vector.reduce.fmaximum.v4f64(<4 x double> undef)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %V2f32 = call float @llvm.vector.reduce.fmax.v2f32(<2 x float> undef)
  %V4f32 = call float @llvm.vector.reduce.fmax.v4f32(<4 x float> undef)
  %V8f32 = call float @llvm.vector.reduce.fmax.v8f32(<8 x float> undef)
  %V2f64 = call double @llvm.vector.reduce.fmax.v2f64(<2 x double> undef)
  %V4f64 = call double @llvm.vector.reduce.fmax.v4f64(<4 x double> undef)
  %V2f32m = call float @llvm.vector.reduce.fmaximum.v2f32(<2 x float> undef)
  %V4f32m = call float @llvm.vector.reduce.fmaximum.v4f32(<4 x float> undef)
  %V8f32m = call float @llvm.vector.reduce.fmaximum.v8f32(<8 x float> undef)
  %V2f64m = call double @llvm.vector.reduce.fmaximum.v2f64(<2 x double> undef)
  %V4f64m = call double @llvm.vector.reduce.fmaximum.v4f64(<4 x double> undef)
  ret void
}

declare i8 @llvm.vector.reduce.umin.v1i8(<1 x i8>)
declare i8 @llvm.vector.reduce.umin.v3i8(<3 x i8>)
declare i8 @llvm.vector.reduce.umin.v4i8(<4 x i8>)
declare i8 @llvm.vector.reduce.umin.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.umin.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.umin.v32i8(<32 x i8>)
declare i8 @llvm.vector.reduce.umin.v64i8(<64 x i8>)
declare i16 @llvm.vector.reduce.umin.v2i16(<2 x i16>)
declare i16 @llvm.vector.reduce.umin.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.umin.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.umin.v16i16(<16 x i16>)
declare i32 @llvm.vector.reduce.umin.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.umin.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.umin.v8i32(<8 x i32>)
declare i64 @llvm.vector.reduce.umin.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.umin.v4i64(<4 x i64>)

declare i8 @llvm.vector.reduce.umax.v1i8(<1 x i8>)
declare i8 @llvm.vector.reduce.umax.v3i8(<3 x i8>)
declare i8 @llvm.vector.reduce.umax.v4i8(<4 x i8>)
declare i8 @llvm.vector.reduce.umax.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.umax.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.umax.v32i8(<32 x i8>)
declare i8 @llvm.vector.reduce.umax.v64i8(<64 x i8>)
declare i16 @llvm.vector.reduce.umax.v2i16(<2 x i16>)
declare i16 @llvm.vector.reduce.umax.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.umax.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.umax.v16i16(<16 x i16>)
declare i32 @llvm.vector.reduce.umax.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.umax.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.umax.v8i32(<8 x i32>)
declare i64 @llvm.vector.reduce.umax.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.umax.v4i64(<4 x i64>)

declare i8 @llvm.vector.reduce.smin.v1i8(<1 x i8>)
declare i8 @llvm.vector.reduce.smin.v3i8(<3 x i8>)
declare i8 @llvm.vector.reduce.smin.v4i8(<4 x i8>)
declare i8 @llvm.vector.reduce.smin.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.smin.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.smin.v32i8(<32 x i8>)
declare i8 @llvm.vector.reduce.smin.v64i8(<64 x i8>)
declare i16 @llvm.vector.reduce.smin.v2i16(<2 x i16>)
declare i16 @llvm.vector.reduce.smin.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.smin.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.smin.v16i16(<16 x i16>)
declare i32 @llvm.vector.reduce.smin.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.smin.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.smin.v8i32(<8 x i32>)
declare i64 @llvm.vector.reduce.smin.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.smin.v4i64(<4 x i64>)

declare i8 @llvm.vector.reduce.smax.v1i8(<1 x i8>)
declare i8 @llvm.vector.reduce.smax.v3i8(<3 x i8>)
declare i8 @llvm.vector.reduce.smax.v4i8(<4 x i8>)
declare i8 @llvm.vector.reduce.smax.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.smax.v16i8(<16 x i8>)
declare i8 @llvm.vector.reduce.smax.v32i8(<32 x i8>)
declare i8 @llvm.vector.reduce.smax.v64i8(<64 x i8>)
declare i16 @llvm.vector.reduce.smax.v2i16(<2 x i16>)
declare i16 @llvm.vector.reduce.smax.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.smax.v8i16(<8 x i16>)
declare i16 @llvm.vector.reduce.smax.v16i16(<16 x i16>)
declare i32 @llvm.vector.reduce.smax.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.smax.v4i32(<4 x i32>)
declare i32 @llvm.vector.reduce.smax.v8i32(<8 x i32>)
declare i64 @llvm.vector.reduce.smax.v2i64(<2 x i64>)
declare i64 @llvm.vector.reduce.smax.v4i64(<4 x i64>)

declare half @llvm.vector.reduce.fmin.v2f16(<2 x half>)
declare half @llvm.vector.reduce.fmin.v4f16(<4 x half>)
declare half @llvm.vector.reduce.fmin.v8f16(<8 x half>)
declare half @llvm.vector.reduce.fmin.v16f16(<16 x half>)
declare float @llvm.vector.reduce.fmin.v2f32(<2 x float>)
declare float @llvm.vector.reduce.fmin.v4f32(<4 x float>)
declare float @llvm.vector.reduce.fmin.v8f32(<8 x float>)
declare double @llvm.vector.reduce.fmin.v2f64(<2 x double>)
declare double @llvm.vector.reduce.fmin.v4f64(<4 x double>)

declare half @llvm.vector.reduce.fmax.v2f16(<2 x half>)
declare half @llvm.vector.reduce.fmax.v4f16(<4 x half>)
declare half @llvm.vector.reduce.fmax.v8f16(<8 x half>)
declare half @llvm.vector.reduce.fmax.v16f16(<16 x half>)
declare float @llvm.vector.reduce.fmax.v2f32(<2 x float>)
declare float @llvm.vector.reduce.fmax.v4f32(<4 x float>)
declare float @llvm.vector.reduce.fmax.v8f32(<8 x float>)
declare double @llvm.vector.reduce.fmax.v2f64(<2 x double>)
declare double @llvm.vector.reduce.fmax.v4f64(<4 x double>)

declare half @llvm.vector.reduce.fminimum.v2f16(<2 x half>)
declare half @llvm.vector.reduce.fminimum.v4f16(<4 x half>)
declare half @llvm.vector.reduce.fminimum.v8f16(<8 x half>)
declare half @llvm.vector.reduce.fminimum.v16f16(<16 x half>)
declare float @llvm.vector.reduce.fminimum.v2f32(<2 x float>)
declare float @llvm.vector.reduce.fminimum.v4f32(<4 x float>)
declare float @llvm.vector.reduce.fminimum.v8f32(<8 x float>)
declare double @llvm.vector.reduce.fminimum.v2f64(<2 x double>)
declare double @llvm.vector.reduce.fminimum.v4f64(<4 x double>)

declare half @llvm.vector.reduce.fmaximum.v2f16(<2 x half>)
declare half @llvm.vector.reduce.fmaximum.v4f16(<4 x half>)
declare half @llvm.vector.reduce.fmaximum.v8f16(<8 x half>)
declare half @llvm.vector.reduce.fmaximum.v16f16(<16 x half>)
declare float @llvm.vector.reduce.fmaximum.v2f32(<2 x float>)
declare float @llvm.vector.reduce.fmaximum.v4f32(<4 x float>)
declare float @llvm.vector.reduce.fmaximum.v8f32(<8 x float>)
declare double @llvm.vector.reduce.fmaximum.v2f64(<2 x double>)
declare double @llvm.vector.reduce.fmaximum.v4f64(<4 x double>)
