; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 --mattr=+d --fp-contract=fast < %s \
; RUN:   | FileCheck %s --check-prefix=LA32-CONTRACT-FAST
; RUN: llc --mtriple=loongarch32 --mattr=+d --fp-contract=on < %s \
; RUN:   | FileCheck %s --check-prefix=LA32-CONTRACT-ON
; RUN: llc --mtriple=loongarch32 --mattr=+d --fp-contract=off < %s \
; RUN:   | FileCheck %s --check-prefix=LA32-CONTRACT-OFF
; RUN: llc --mtriple=loongarch64 --mattr=+d --fp-contract=fast < %s \
; RUN:   | FileCheck %s --check-prefix=LA64-CONTRACT-FAST
; RUN: llc --mtriple=loongarch64 --mattr=+d --fp-contract=on < %s \
; RUN:   | FileCheck %s --check-prefix=LA64-CONTRACT-ON
; RUN: llc --mtriple=loongarch64 --mattr=+d --fp-contract=off < %s \
; RUN:   | FileCheck %s --check-prefix=LA64-CONTRACT-OFF

define double @fmadd_d(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: fmadd_d:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: fmadd_d:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA32-CONTRACT-ON-NEXT:    fadd.d $fa0, $fa0, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: fmadd_d:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA32-CONTRACT-OFF-NEXT:    fadd.d $fa0, $fa0, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: fmadd_d:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: fmadd_d:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA64-CONTRACT-ON-NEXT:    fadd.d $fa0, $fa0, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: fmadd_d:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA64-CONTRACT-OFF-NEXT:    fadd.d $fa0, $fa0, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %mul = fmul double %a, %b
  %add = fadd double %mul, %c
  ret double %add
}

define double @fmsub_d(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: fmsub_d:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: fmsub_d:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA32-CONTRACT-ON-NEXT:    fsub.d $fa0, $fa0, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: fmsub_d:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA32-CONTRACT-OFF-NEXT:    fsub.d $fa0, $fa0, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: fmsub_d:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: fmsub_d:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA64-CONTRACT-ON-NEXT:    fsub.d $fa0, $fa0, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: fmsub_d:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA64-CONTRACT-OFF-NEXT:    fsub.d $fa0, $fa0, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %mul = fmul double %a, %b
  %sub = fsub double %mul, %c
  ret double %sub
}

define double @fnmadd_d(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: fnmadd_d:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: fnmadd_d:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA32-CONTRACT-ON-NEXT:    fadd.d $fa0, $fa0, $fa2
; LA32-CONTRACT-ON-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: fnmadd_d:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA32-CONTRACT-OFF-NEXT:    fadd.d $fa0, $fa0, $fa2
; LA32-CONTRACT-OFF-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: fnmadd_d:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: fnmadd_d:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA64-CONTRACT-ON-NEXT:    fadd.d $fa0, $fa0, $fa2
; LA64-CONTRACT-ON-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: fnmadd_d:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA64-CONTRACT-OFF-NEXT:    fadd.d $fa0, $fa0, $fa2
; LA64-CONTRACT-OFF-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-OFF-NEXT:    ret
  %mul = fmul double %a, %b
  %add = fadd double %mul, %c
  %negadd = fneg double %add
  ret double %negadd
}

define double @fnmadd_d_nsz(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: fnmadd_d_nsz:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: fnmadd_d_nsz:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-ON-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA32-CONTRACT-ON-NEXT:    fsub.d $fa0, $fa0, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: fnmadd_d_nsz:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-OFF-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA32-CONTRACT-OFF-NEXT:    fsub.d $fa0, $fa0, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: fnmadd_d_nsz:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: fnmadd_d_nsz:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-ON-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA64-CONTRACT-ON-NEXT:    fsub.d $fa0, $fa0, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: fnmadd_d_nsz:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-OFF-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA64-CONTRACT-OFF-NEXT:    fsub.d $fa0, $fa0, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %nega = fneg nsz double %a
  %negc = fneg nsz double %c
  %mul = fmul nsz double %nega, %b
  %add = fadd nsz double %mul, %negc
  ret double %add
}

;; Check that fnmadd.d is not emitted.
define double @not_fnmadd_d(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: not_fnmadd_d:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-FAST-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: not_fnmadd_d:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-ON-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA32-CONTRACT-ON-NEXT:    fsub.d $fa0, $fa0, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: not_fnmadd_d:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-OFF-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA32-CONTRACT-OFF-NEXT:    fsub.d $fa0, $fa0, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: not_fnmadd_d:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-FAST-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: not_fnmadd_d:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-ON-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA64-CONTRACT-ON-NEXT:    fsub.d $fa0, $fa0, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: not_fnmadd_d:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-OFF-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA64-CONTRACT-OFF-NEXT:    fsub.d $fa0, $fa0, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %nega = fneg double %a
  %negc = fneg double %c
  %mul = fmul double %nega, %b
  %add = fadd double %mul, %negc
  ret double %add
}

define double @fnmsub_d(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: fnmsub_d:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: fnmsub_d:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA32-CONTRACT-ON-NEXT:    fsub.d $fa0, $fa0, $fa2
; LA32-CONTRACT-ON-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: fnmsub_d:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA32-CONTRACT-OFF-NEXT:    fsub.d $fa0, $fa0, $fa2
; LA32-CONTRACT-OFF-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: fnmsub_d:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: fnmsub_d:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA64-CONTRACT-ON-NEXT:    fsub.d $fa0, $fa0, $fa2
; LA64-CONTRACT-ON-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: fnmsub_d:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA64-CONTRACT-OFF-NEXT:    fsub.d $fa0, $fa0, $fa2
; LA64-CONTRACT-OFF-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-OFF-NEXT:    ret
  %negc = fneg double %c
  %mul = fmul double %a, %b
  %add = fadd double %mul, %negc
  %neg = fneg double %add
  ret double %neg
}

define double @fnmsub_d_nsz(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: fnmsub_d_nsz:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: fnmsub_d_nsz:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA32-CONTRACT-ON-NEXT:    fsub.d $fa0, $fa2, $fa0
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: fnmsub_d_nsz:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA32-CONTRACT-OFF-NEXT:    fsub.d $fa0, $fa2, $fa0
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: fnmsub_d_nsz:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: fnmsub_d_nsz:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA64-CONTRACT-ON-NEXT:    fsub.d $fa0, $fa2, $fa0
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: fnmsub_d_nsz:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA64-CONTRACT-OFF-NEXT:    fsub.d $fa0, $fa2, $fa0
; LA64-CONTRACT-OFF-NEXT:    ret
  %nega = fneg nsz double %a
  %mul = fmul nsz double %nega, %b
  %add = fadd nsz double %mul, %c
  ret double %add
}

;; Check that fnmsub.d is not emitted.
define double @not_fnmsub_d(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: not_fnmsub_d:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-FAST-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: not_fnmsub_d:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA32-CONTRACT-ON-NEXT:    fsub.d $fa0, $fa2, $fa0
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: not_fnmsub_d:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA32-CONTRACT-OFF-NEXT:    fsub.d $fa0, $fa2, $fa0
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: not_fnmsub_d:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-FAST-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: not_fnmsub_d:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA64-CONTRACT-ON-NEXT:    fsub.d $fa0, $fa2, $fa0
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: not_fnmsub_d:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fmul.d $fa0, $fa0, $fa1
; LA64-CONTRACT-OFF-NEXT:    fsub.d $fa0, $fa2, $fa0
; LA64-CONTRACT-OFF-NEXT:    ret
  %nega = fneg double %a
  %mul = fmul double %nega, %b
  %add = fadd double %mul, %c
  ret double %add
}

define double @contract_fmadd_d(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: contract_fmadd_d:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: contract_fmadd_d:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: contract_fmadd_d:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: contract_fmadd_d:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: contract_fmadd_d:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: contract_fmadd_d:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %mul = fmul contract double %a, %b
  %add = fadd contract double %mul, %c
  ret double %add
}

define double @contract_fmsub_d(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: contract_fmsub_d:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: contract_fmsub_d:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: contract_fmsub_d:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: contract_fmsub_d:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: contract_fmsub_d:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: contract_fmsub_d:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %mul = fmul contract double %a, %b
  %sub = fsub contract double %mul, %c
  ret double %sub
}

define double @contract_fnmadd_d(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: contract_fnmadd_d:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: contract_fnmadd_d:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: contract_fnmadd_d:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: contract_fnmadd_d:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: contract_fnmadd_d:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: contract_fnmadd_d:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %mul = fmul contract double %a, %b
  %add = fadd contract double %mul, %c
  %negadd = fneg contract double %add
  ret double %negadd
}

define double @contract_fnmadd_d_nsz(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: contract_fnmadd_d_nsz:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: contract_fnmadd_d_nsz:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: contract_fnmadd_d_nsz:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: contract_fnmadd_d_nsz:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: contract_fnmadd_d_nsz:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: contract_fnmadd_d_nsz:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %nega = fneg contract nsz double %a
  %negc = fneg contract nsz double %c
  %mul = fmul contract nsz double %nega, %b
  %add = fadd contract nsz double %mul, %negc
  ret double %add
}

;; Check that fnmadd.d is not emitted.
define double @not_contract_fnmadd_d(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: not_contract_fnmadd_d:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-FAST-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: not_contract_fnmadd_d:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-ON-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: not_contract_fnmadd_d:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-OFF-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: not_contract_fnmadd_d:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-FAST-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: not_contract_fnmadd_d:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-ON-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: not_contract_fnmadd_d:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-OFF-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %nega = fneg contract double %a
  %negc = fneg contract double %c
  %mul = fmul contract double %nega, %b
  %add = fadd contract double %mul, %negc
  ret double %add
}

define double @contract_fnmsub_d(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: contract_fnmsub_d:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: contract_fnmsub_d:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: contract_fnmsub_d:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: contract_fnmsub_d:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: contract_fnmsub_d:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: contract_fnmsub_d:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %negc = fneg contract double %c
  %mul = fmul contract double %a, %b
  %add = fadd contract double %mul, %negc
  %neg = fneg contract double %add
  ret double %neg
}

define double @contract_fnmsub_d_nsz(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: contract_fnmsub_d_nsz:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: contract_fnmsub_d_nsz:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: contract_fnmsub_d_nsz:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: contract_fnmsub_d_nsz:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: contract_fnmsub_d_nsz:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: contract_fnmsub_d_nsz:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %nega = fneg contract nsz double %a
  %mul = fmul contract nsz double %nega, %b
  %add = fadd contract nsz double %mul, %c
  ret double %add
}

;; Check that fnmsub.d is not emitted.
define double @not_contract_fnmsub_d(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: not_contract_fnmsub_d:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-FAST-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: not_contract_fnmsub_d:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-ON-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: not_contract_fnmsub_d:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-OFF-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: not_contract_fnmsub_d:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-FAST-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: not_contract_fnmsub_d:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-ON-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: not_contract_fnmsub_d:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-OFF-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %nega = fneg contract double %a
  %mul = fmul contract double %nega, %b
  %add = fadd contract double %mul, %c
  ret double %add
}

declare double @llvm.fma.f64(double, double, double)

define double @fmadd_d_intrinsics(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: fmadd_d_intrinsics:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: fmadd_d_intrinsics:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: fmadd_d_intrinsics:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: fmadd_d_intrinsics:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: fmadd_d_intrinsics:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: fmadd_d_intrinsics:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %fma = call double @llvm.fma.f64(double %a, double %b, double %c)
  ret double %fma
}

define double @fmsub_d_intrinsics(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: fmsub_d_intrinsics:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: fmsub_d_intrinsics:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: fmsub_d_intrinsics:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: fmsub_d_intrinsics:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: fmsub_d_intrinsics:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: fmsub_d_intrinsics:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %negc = fneg double %c
  %fma = call double @llvm.fma.f64(double %a, double %b, double %negc)
  ret double %fma
}

define double @fnmadd_d_intrinsics(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: fnmadd_d_intrinsics:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: fnmadd_d_intrinsics:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: fnmadd_d_intrinsics:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: fnmadd_d_intrinsics:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: fnmadd_d_intrinsics:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: fnmadd_d_intrinsics:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %fma = call double @llvm.fma.f64(double %a, double %b, double %c)
  %negfma = fneg double %fma
  ret double %negfma
}

define double @fnmadd_d_nsz_intrinsics(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: fnmadd_d_nsz_intrinsics:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: fnmadd_d_nsz_intrinsics:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: fnmadd_d_nsz_intrinsics:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: fnmadd_d_nsz_intrinsics:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: fnmadd_d_nsz_intrinsics:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: fnmadd_d_nsz_intrinsics:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %nega = fneg double %a
  %negc = fneg double %c
  %fma = call nsz double @llvm.fma.f64(double %nega, double %b, double %negc)
  ret double %fma
}

;; Check that fnmadd.d is not emitted.
define double @not_fnmadd_d_intrinsics(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: not_fnmadd_d_intrinsics:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-FAST-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: not_fnmadd_d_intrinsics:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-ON-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: not_fnmadd_d_intrinsics:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-OFF-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: not_fnmadd_d_intrinsics:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-FAST-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: not_fnmadd_d_intrinsics:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-ON-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: not_fnmadd_d_intrinsics:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-OFF-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %nega = fneg double %a
  %negc = fneg double %c
  %fma = call double @llvm.fma.f64(double %nega, double %b, double %negc)
  ret double %fma
}

define double @fnmsub_d_intrinsics(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: fnmsub_d_intrinsics:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: fnmsub_d_intrinsics:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: fnmsub_d_intrinsics:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: fnmsub_d_intrinsics:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: fnmsub_d_intrinsics:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: fnmsub_d_intrinsics:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %negc = fneg double %c
  %fma = call double @llvm.fma.f64(double %a, double %b, double %negc)
  %negfma = fneg double %fma
  ret double %negfma
}

define double @fnmsub_d_nsz_intrinsics(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: fnmsub_d_nsz_intrinsics:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: fnmsub_d_nsz_intrinsics:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: fnmsub_d_nsz_intrinsics:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: fnmsub_d_nsz_intrinsics:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: fnmsub_d_nsz_intrinsics:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: fnmsub_d_nsz_intrinsics:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %nega = fneg double %a
  %fma = call nsz double @llvm.fma.f64(double %nega, double %b, double %c)
  ret double %fma
}

;; Check that fnmsub.d is not emitted.
define double @not_fnmsub_d_intrinsics(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: not_fnmsub_d_intrinsics:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-FAST-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: not_fnmsub_d_intrinsics:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-ON-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: not_fnmsub_d_intrinsics:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fneg.d $fa0, $fa0
; LA32-CONTRACT-OFF-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: not_fnmsub_d_intrinsics:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-FAST-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: not_fnmsub_d_intrinsics:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-ON-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: not_fnmsub_d_intrinsics:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fneg.d $fa0, $fa0
; LA64-CONTRACT-OFF-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %nega = fneg double %a
  %fma = call double @llvm.fma.f64(double %nega, double %b, double %c)
  ret double %fma
}

define double @fmadd_d_contract(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: fmadd_d_contract:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: fmadd_d_contract:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: fmadd_d_contract:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: fmadd_d_contract:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: fmadd_d_contract:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: fmadd_d_contract:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %mul = fmul contract double %a, %b
  %add = fadd contract double %mul, %c
  ret double %add
}

define double @fmsub_d_contract(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: fmsub_d_contract:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: fmsub_d_contract:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: fmsub_d_contract:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: fmsub_d_contract:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: fmsub_d_contract:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: fmsub_d_contract:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %mul = fmul contract double %a, %b
  %sub = fsub contract double %mul, %c
  ret double %sub
}

define double @fnmadd_d_contract(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: fnmadd_d_contract:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: fnmadd_d_contract:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: fnmadd_d_contract:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: fnmadd_d_contract:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: fnmadd_d_contract:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: fnmadd_d_contract:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fnmadd.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %mul = fmul contract double %a, %b
  %add = fadd contract double %mul, %c
  %negadd = fneg contract double %add
  ret double %negadd
}

define double @fnmsub_d_contract(double %a, double %b, double %c) nounwind {
; LA32-CONTRACT-FAST-LABEL: fnmsub_d_contract:
; LA32-CONTRACT-FAST:       # %bb.0:
; LA32-CONTRACT-FAST-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-FAST-NEXT:    ret
;
; LA32-CONTRACT-ON-LABEL: fnmsub_d_contract:
; LA32-CONTRACT-ON:       # %bb.0:
; LA32-CONTRACT-ON-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-ON-NEXT:    ret
;
; LA32-CONTRACT-OFF-LABEL: fnmsub_d_contract:
; LA32-CONTRACT-OFF:       # %bb.0:
; LA32-CONTRACT-OFF-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA32-CONTRACT-OFF-NEXT:    ret
;
; LA64-CONTRACT-FAST-LABEL: fnmsub_d_contract:
; LA64-CONTRACT-FAST:       # %bb.0:
; LA64-CONTRACT-FAST-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-FAST-NEXT:    ret
;
; LA64-CONTRACT-ON-LABEL: fnmsub_d_contract:
; LA64-CONTRACT-ON:       # %bb.0:
; LA64-CONTRACT-ON-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-ON-NEXT:    ret
;
; LA64-CONTRACT-OFF-LABEL: fnmsub_d_contract:
; LA64-CONTRACT-OFF:       # %bb.0:
; LA64-CONTRACT-OFF-NEXT:    fnmsub.d $fa0, $fa0, $fa1, $fa2
; LA64-CONTRACT-OFF-NEXT:    ret
  %mul = fmul contract double %a, %b
  %negc = fneg contract double %c
  %add = fadd contract double %negc, %mul
  %negadd = fneg contract double %add
  ret double %negadd
}
