; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=csky -csky-no-aliases --code-model=small -mattr=+2e3 < %s \
; RUN:     | FileCheck -check-prefixes=SMALL,CHECK %s
; RUN: llc -mtriple=csky -csky-no-aliases --code-model=medium -mattr=+2e3 < %s \
; RUN:     | FileCheck -check-prefixes=MEDIUM,CHECK %s
; RUN: llc -mtriple=csky -csky-no-aliases --code-model=small  -relocation-model=pic -mattr=+2e3 < %s \
; RUN:     | FileCheck -check-prefixes=SMALL-PIC,CHECK %s
; RUN: llc -mtriple=csky -csky-no-aliases --code-model=medium -relocation-model=pic -mattr=+2e3 < %s \
; RUN:     | FileCheck -check-prefixes=MEDIUM-PIC,CHECK %s

declare void @throw_exception()

declare i32 @__gxx_personality_v0(...)

declare ptr @__cxa_begin_catch(ptr)

declare void @__cxa_end_catch()

; CHECK: .cfi_startproc
; PersonalityEncoding = DW_EH_PE_indirect | DW_EH_PE_pcrel | DW_EH_PE_sdata4
; CHECK-NEXT:	.cfi_personality 155, DW.ref.__gxx_personality_v0
; LSDAEncoding = DW_EH_PE_pcrel | DW_EH_PE_sdata4
; CHECK-NEXT:	.cfi_lsda 27, .Lexception0

define void @test1() personality ptr @__gxx_personality_v0 {
; SMALL:       # %bb.0: # %entry
; SMALL-NEXT:    subi16 sp, sp, 4
; SMALL-NEXT:    .cfi_def_cfa_offset 4
; SMALL-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; SMALL-NEXT:    .cfi_offset lr, -4
; SMALL-NEXT:    .cfi_def_cfa_offset 4
; SMALL-NEXT:  .Ltmp0:
; SMALL-NEXT:    jsri32 [.LCPI0_0]
; SMALL-NEXT:  .Ltmp1:
; SMALL-NEXT:  .LBB0_1: # %try.cont
; SMALL-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; SMALL-NEXT:    addi16 sp, sp, 4
; SMALL-NEXT:    rts16
; SMALL-NEXT:  .LBB0_2: # %lpad
; SMALL-NEXT:  .Ltmp2:
; SMALL-NEXT:    jsri32 [.LCPI0_1]
; SMALL-NEXT:    jsri32 [.LCPI0_2]
; SMALL-NEXT:    br32 .LBB0_1
; SMALL-NEXT:    .p2align 1
; SMALL-NEXT:  # %bb.3:
; SMALL-NEXT:    .p2align 2
; SMALL-NEXT:  .LCPI0_0:
; SMALL-NEXT:    .long throw_exception
; SMALL-NEXT:  .LCPI0_1:
; SMALL-NEXT:    .long __cxa_begin_catch
; SMALL-NEXT:  .LCPI0_2:
; SMALL-NEXT:    .long __cxa_end_catch
;
; MEDIUM:       # %bb.0: # %entry
; MEDIUM-NEXT:    subi16 sp, sp, 4
; MEDIUM-NEXT:    .cfi_def_cfa_offset 4
; MEDIUM-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; MEDIUM-NEXT:    .cfi_offset lr, -4
; MEDIUM-NEXT:    .cfi_def_cfa_offset 4
; MEDIUM-NEXT:  .Ltmp0:
; MEDIUM-NEXT:    jsri32 [.LCPI0_0]
; MEDIUM-NEXT:  .Ltmp1:
; MEDIUM-NEXT:  .LBB0_1: # %try.cont
; MEDIUM-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; MEDIUM-NEXT:    addi16 sp, sp, 4
; MEDIUM-NEXT:    rts16
; MEDIUM-NEXT:  .LBB0_2: # %lpad
; MEDIUM-NEXT:  .Ltmp2:
; MEDIUM-NEXT:    jsri32 [.LCPI0_1]
; MEDIUM-NEXT:    jsri32 [.LCPI0_2]
; MEDIUM-NEXT:    br32 .LBB0_1
; MEDIUM-NEXT:    .p2align 1
; MEDIUM-NEXT:  # %bb.3:
; MEDIUM-NEXT:    .p2align 2
; MEDIUM-NEXT:  .LCPI0_0:
; MEDIUM-NEXT:    .long throw_exception
; MEDIUM-NEXT:  .LCPI0_1:
; MEDIUM-NEXT:    .long __cxa_begin_catch
; MEDIUM-NEXT:  .LCPI0_2:
; MEDIUM-NEXT:    .long __cxa_end_catch
;
; SMALL-PIC:       # %bb.0: # %entry
; SMALL-PIC-NEXT:    subi16 sp, sp, 8
; SMALL-PIC-NEXT:    .cfi_def_cfa_offset 8
; SMALL-PIC-NEXT:    st32.w rgb, (sp, 4) # 4-byte Folded Spill
; SMALL-PIC-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; SMALL-PIC-NEXT:    .cfi_offset rgb, -4
; SMALL-PIC-NEXT:    .cfi_offset lr, -8
; SMALL-PIC-NEXT:    .cfi_def_cfa_offset 8
; SMALL-PIC-NEXT:    lrw32 rgb, [.LCPI0_0]
; SMALL-PIC-NEXT:  .Ltmp0:
; SMALL-PIC-NEXT:    lrw32 a0, [.LCPI0_1]
; SMALL-PIC-NEXT:    ldr32.w a0, (rgb, a0 << 0)
; SMALL-PIC-NEXT:    jsr16 a0
; SMALL-PIC-NEXT:  .Ltmp1:
; SMALL-PIC-NEXT:  .LBB0_1: # %try.cont
; SMALL-PIC-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; SMALL-PIC-NEXT:    ld32.w rgb, (sp, 4) # 4-byte Folded Reload
; SMALL-PIC-NEXT:    addi16 sp, sp, 8
; SMALL-PIC-NEXT:    rts16
; SMALL-PIC-NEXT:  .LBB0_2: # %lpad
; SMALL-PIC-NEXT:  .Ltmp2:
; SMALL-PIC-NEXT:    lrw32 a1, [.LCPI0_2]
; SMALL-PIC-NEXT:    ldr32.w a1, (rgb, a1 << 0)
; SMALL-PIC-NEXT:    jsr16 a1
; SMALL-PIC-NEXT:    lrw32 a0, [.LCPI0_3]
; SMALL-PIC-NEXT:    ldr32.w a0, (rgb, a0 << 0)
; SMALL-PIC-NEXT:    jsr16 a0
; SMALL-PIC-NEXT:    br32 .LBB0_1
; SMALL-PIC-NEXT:    .p2align 1
; SMALL-PIC-NEXT:  # %bb.3:
; SMALL-PIC-NEXT:    .p2align 2
; SMALL-PIC-NEXT:  .LCPI0_0:
; SMALL-PIC-NEXT:    .long _GLOBAL_OFFSET_TABLE_
; SMALL-PIC-NEXT:  .LCPI0_1:
; SMALL-PIC-NEXT:    .long throw_exception@PLT
; SMALL-PIC-NEXT:  .LCPI0_2:
; SMALL-PIC-NEXT:    .long __cxa_begin_catch@PLT
; SMALL-PIC-NEXT:  .LCPI0_3:
; SMALL-PIC-NEXT:    .long __cxa_end_catch@PLT
;
; MEDIUM-PIC:       # %bb.0: # %entry
; MEDIUM-PIC-NEXT:    subi16 sp, sp, 8
; MEDIUM-PIC-NEXT:    .cfi_def_cfa_offset 8
; MEDIUM-PIC-NEXT:    st32.w rgb, (sp, 4) # 4-byte Folded Spill
; MEDIUM-PIC-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; MEDIUM-PIC-NEXT:    .cfi_offset rgb, -4
; MEDIUM-PIC-NEXT:    .cfi_offset lr, -8
; MEDIUM-PIC-NEXT:    .cfi_def_cfa_offset 8
; MEDIUM-PIC-NEXT:    lrw32 rgb, [.LCPI0_0]
; MEDIUM-PIC-NEXT:  .Ltmp0:
; MEDIUM-PIC-NEXT:    lrw32 a0, [.LCPI0_1]
; MEDIUM-PIC-NEXT:    ldr32.w a0, (rgb, a0 << 0)
; MEDIUM-PIC-NEXT:    jsr16 a0
; MEDIUM-PIC-NEXT:  .Ltmp1:
; MEDIUM-PIC-NEXT:  .LBB0_1: # %try.cont
; MEDIUM-PIC-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; MEDIUM-PIC-NEXT:    ld32.w rgb, (sp, 4) # 4-byte Folded Reload
; MEDIUM-PIC-NEXT:    addi16 sp, sp, 8
; MEDIUM-PIC-NEXT:    rts16
; MEDIUM-PIC-NEXT:  .LBB0_2: # %lpad
; MEDIUM-PIC-NEXT:  .Ltmp2:
; MEDIUM-PIC-NEXT:    lrw32 a1, [.LCPI0_2]
; MEDIUM-PIC-NEXT:    ldr32.w a1, (rgb, a1 << 0)
; MEDIUM-PIC-NEXT:    jsr16 a1
; MEDIUM-PIC-NEXT:    lrw32 a0, [.LCPI0_3]
; MEDIUM-PIC-NEXT:    ldr32.w a0, (rgb, a0 << 0)
; MEDIUM-PIC-NEXT:    jsr16 a0
; MEDIUM-PIC-NEXT:    br32 .LBB0_1
; MEDIUM-PIC-NEXT:    .p2align 1
; MEDIUM-PIC-NEXT:  # %bb.3:
; MEDIUM-PIC-NEXT:    .p2align 2
; MEDIUM-PIC-NEXT:  .LCPI0_0:
; MEDIUM-PIC-NEXT:    .long _GLOBAL_OFFSET_TABLE_
; MEDIUM-PIC-NEXT:  .LCPI0_1:
; MEDIUM-PIC-NEXT:    .long throw_exception@PLT
; MEDIUM-PIC-NEXT:  .LCPI0_2:
; MEDIUM-PIC-NEXT:    .long __cxa_begin_catch@PLT
; MEDIUM-PIC-NEXT:  .LCPI0_3:
; MEDIUM-PIC-NEXT:    .long __cxa_end_catch@PLT
entry:
  invoke void @throw_exception() to label %try.cont unwind label %lpad

lpad:
  %0 = landingpad { ptr, i32 }
          catch ptr null
  %1 = extractvalue { ptr, i32 } %0, 0
  %2 = tail call ptr @__cxa_begin_catch(ptr %1)
  tail call void @__cxa_end_catch()
  br label %try.cont

try.cont:
  ret void
}

; CHECK-LABEL: GCC_except_table0:
; CHECK-NEXT: .Lexception0:
; CHECK-NEXT: .byte	255 # @LPStart Encoding = omit
; TTypeEncoding = DW_EH_PE_indirect | DW_EH_PE_pcrel | DW_EH_PE_sdata4
; CHECK-NEXT: .byte 155 # @TType Encoding = indirect pcrel sdata4
; CHECK: .Lttbaseref0:
; CallSiteEncoding = dwarf::DW_EH_PE_udata4
; CHECK-NEXT: .byte	1                       # Call site Encoding = uleb128
; CHECK-NEXT: .uleb128 .Lcst_end0-.Lcst_begin0
; CHECK-NEXT: .Lcst_begin0:
; CHECK-NEXT: .uleb128 .Ltmp0-.Lfunc_begin0   # >> Call Site 1 <<
; CHECK-NEXT: .uleb128 .Ltmp1-.Ltmp0          #   Call between .Ltmp0 and .Ltmp1
; CHECK-NEXT: .uleb128 .Ltmp2-.Lfunc_begin0   #     jumps to .Ltmp2
; CHECK-NEXT: .byte	1                       #   On action: 1
; CHECK-NEXT: .uleb128 .Ltmp1-.Lfunc_begin0   # >> Call Site 2 <<
; CHECK-NEXT: .uleb128 .Lfunc_end0-.Ltmp1     #   Call between .Ltmp1 and .Lfunc_end0
; CHECK-NEXT: .byte	0                       #     has no landing pad
; CHECK-NEXT: .byte	0                       #   On action: cleanup
