% neoschool.cls
%
% Copyright (C) 2025 Razik Ikhlef
% razik.ikhlef@csilyon.fr
%
% The newest version of this documentclass should always be available
% from the following web page: https://apps.edulatex.xyz/neoschool/
%

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{neoschool}[2025/12/07 v1.2.0]

%% ==============================================================================
%% Packages required before option processing
%% ==============================================================================

\RequirePackage[table,svgnames,dvipsnames,x11names]{xcolor}
\RequirePackage{kvoptions}
\RequirePackage{etoolbox}
\RequirePackage{xstring}
\RequirePackage{pgffor}
\RequirePackage{siunitx}

\SetupKeyvalOptions{family=neoschool, prefix=neoschool@}

%% ==============================================================================
%% Booleans, dimensions, and internal macros
%% ==============================================================================

% Structure booleans
\newif\ifneo@thmnoframe   \neo@thmnoframefalse
\newif\ifneo@thmnoback    \neo@thmnobackfalse
\newif\ifneo@exnoback     \neo@exnobackfalse
\newif\ifneo@codenoframe  \neo@codenoframefalse
\newif\ifneo@codenoback   \neo@codenobackfalse
\newif\ifneo@codenonum    \neo@codenonumfalse
\newif\ifneo@adnoback     \neo@adnobacktrue
\newif\ifneo@adnoframe    \neo@adnoframetrue
\newif\ifneo@darktheme    \neo@darkthemefalse
\newif\ifneo@print        \neo@printfalse
\newif\ifneo@unicolor     \neo@unicolorfalse
\newif\ifneo@palettechosen \neo@palettechosenfalse

% Language booleans
\newif\ifneo@english
\newif\ifneo@french
\newif\ifneo@german

% Font booleans
\newif\ifneo@sfbody
\newif\ifneo@sfall
\newif\ifneo@mathastext
\newif\ifneo@scale

% Feature booleans
\newif\ifneo@shuffle
\newif\ifneo@blocksol
\newif\ifneo@fullheader
\newif\ifneo@firstpagestyleoverride
\neo@firstpagestyleoverridefalse
\newif\ifneo@exerciseicons
\newif\ifmarginnotesactive
\marginnotesactivefalse

% Package booleans
\newif\ifneo@apmep
\newif\ifneo@loadbasearithmetic
\newif\ifneo@mathics
\newif\ifneo@listings
\newif\ifneo@minted
\newif\ifneo@frenchmath

% TOC booleans
\newif\ifneo@compacttoc
\newif\ifneo@monotoc
\newif\ifneo@twocolumntoc

% Output mode booleans
\newif\ifneo@twoupafourmode
\newif\ifneo@twoupathreemode
\newif\ifneo@fourupathreemode
\newif\ifneo@simpletwoupmode
\newif\ifneo@bookletafourmode
\newif\ifneo@bookletathreemode

% Default Dimensions and Spacing
\newcommand{\neo@thinrule}{0.5pt}
\newcommand{\neo@normalrule}{0.8pt}
\newcommand{\neo@thickrule}{1.5pt}
\newcommand{\neo@decorativerule}{0.4pt}
\newcommand{\neo@thmborder}{\neo@normalrule}
\newcommand{\neo@codeborder}{\neo@normalrule}

\newcommand{\neo@leftpadding}{1ex}
\newcommand{\neo@rightpadding}{1ex}
\newcommand{\neo@toppadding}{1ex}
\newcommand{\neo@bottompadding}{1ex}

\newcommand{\neo@ad@left@padding}{20pt}
\newcommand{\neo@ad@right@padding}{5pt}
\newcommand{\neo@ad@top@padding}{4pt}
\newcommand{\neo@ad@bottom@padding}{6pt}

\newcommand{\neo@titleleftpadding}{0.5em}
\newcommand{\neo@titlerightpadding}{0.5em}
\newcommand{\neo@titletoppadding}{3pt}
\newcommand{\neo@titlebottompadding}{3pt}

\newcommand{\neo@beforeskip}{\baselineskip}
\newcommand{\neo@afterskip}{\baselineskip}
\newcommand{\neo@box@beforeskip}{\baselineskip}
\newcommand{\neo@box@afterskip}{\baselineskip}
\newcommand{\neo@code@box@beforeskip}{\baselineskip}
\newcommand{\neo@code@box@afterskip}{\baselineskip}
\newcommand{\neo@ad@beforeskip}{\baselineskip}
\newcommand{\neo@ad@afterskip}{\baselineskip}
\newcommand{\neo@ex@beforeafterskip}{\baselineskip}

\newcommand{\neo@code@box@top@padding}{1mm}
\newcommand{\neo@code@box@bottom@padding}{1mm}
\newcommand{\neo@code@box@left@padding}{2mm}
\newcommand{\neo@code@box@right@padding}{2mm}

% Effective dimensions (computed after vspacing factor)
\newdimen\neo@effective@beforeskip
\newdimen\neo@effective@afterskip
\newdimen\neo@effective@baseskip
\newdimen\neo@effective@code@beforeskip
\newdimen\neo@effective@code@afterskip
\newdimen\neo@effective@ad@beforeskip
\newdimen\neo@effective@ad@afterskip
\newdimen\neo@effective@ex@beforeafterskip

% Internal Macros
\newcommand{\neo@framehidden}{}
\newcommand{\neo@adframehidden}{}
\newcommand{\neo@thm@box@mainback}{white}
\newcommand{\neo@box@lowerback}{white}
\newcommand{\neo@box@uppertext}{black}
\newcommand{\neo@codebox@titlecolor}{white}
\def\neo@default@globalcolor{black}
\def\neo@lang{english}

%% ==============================================================================
%% Default colors
%% ==============================================================================

% Base Colors (overwritten by theme)
\definecolor{primaryColor}{HTML}{000000}
\definecolor{secondaryColor}{HTML}{000000}
\definecolor{tertiaryColor}{HTML}{000000}
\definecolor{backgroundColor}{HTML}{FFFFFF}

% Semantic Colors
\colorlet{titleColor}{black}
\colorlet{sectionColor}{black}
\colorlet{subsectionColor}{black}
\colorlet{subsubsectionColor}{black}
\colorlet{subjectColor}{black!50}
\colorlet{subtitleColor}{black!75}
\colorlet{structuralColor}{black}

% Block Colors
\colorlet{theoremColor}{black}
\colorlet{theoremBgColor}{white}
\colorlet{definitionColor}{black}
\colorlet{definitionBgColor}{white}
\colorlet{exampleColor}{black}
\colorlet{exampleBgColor}{white}
\colorlet{exerciseColor}{black}
\colorlet{exerciseBgColor}{white}

% Code Colors
\colorlet{codeFrame}{black}
\colorlet{codeTitle}{black}
\colorlet{verbColor}{black}
\colorlet{codeBackground}{backgroundColor}
\colorlet{codeComment}{gray!60!black}
\colorlet{codeNumber}{gray!50}

% Hyperlink Colors
\colorlet{neo@urlcolor}{black}
\colorlet{neo@linkcolor}{black}
\colorlet{neo@citecolor}{black}
\colorlet{neo@filecolor}{black}

\colorlet{markerColor}{black}

% Admonition Boxes
\definecolor{infoColor}{HTML}{1558A8}
\definecolor{warningColor}{HTML}{C06100}
\definecolor{importantColor}{HTML}{A62626}
\definecolor{tipColor}{HTML}{2C6F2F}
\definecolor{toolboxColor}{HTML}{611884}
\definecolor{reminderColor}{HTML}{9A154A}
\definecolor{summaryColor}{HTML}{344752}

% Structural colors
\colorlet{structuralColor}{black!75}

% Feedback colors
\definecolor{neoCorrectColor}{HTML}{10B981}
\definecolor{neoIncorrectColor}{HTML}{EF4444}

%% ==============================================================================
%% Structure Options (Frames and Backgrounds)
%% ==============================================================================

% Theorem boxes
\DeclareOption{thmnoback}{\neo@thmnobacktrue}
\DeclareOption{thmback}{\neo@thmnobackfalse}
\DeclareOption{thmnoframe}{\neo@thmnoframetrue}
\DeclareOption{thmframe}{\neo@thmnoframefalse}

% Code boxes
\DeclareOption{codenoback}{\neo@codenobacktrue}
\DeclareOption{codeback}{\neo@codenobackfalse}
\DeclareOption{codenoframe}{\neo@codenoframetrue}
\DeclareOption{codeframe}{\neo@codenoframefalse}
\DeclareOption{codenonum}{\neo@codenonumtrue}
\DeclareOption{codenum}{\neo@codenonumfalse}

% Admonition boxes
\DeclareOption{adnoback}{\neo@adnobacktrue}
\DeclareOption{adback}{\neo@adnobackfalse}
\DeclareOption{adnoframe}{\neo@adnoframetrue}
\DeclareOption{adframe}{\neo@adnoframefalse}

% Exercise boxes
\DeclareOption{exnoback}{\neo@exnobacktrue}
\DeclareOption{exback}{\neo@exnobackfalse}

% All boxes
\DeclareOption{noback}{%
  \neo@thmnobacktrue
  \neo@exnobacktrue
  \neo@codenobacktrue
  \neo@adnobacktrue
}

\DeclareOption{noframe}{%
  \neo@thmnoframetrue
  \neo@codenoframetrue
  \neo@adnoframetrue
}

\DeclareOption{back}{%
  \neo@thmnobackfalse
  \neo@exnobackfalse
  \neo@codenobackfalse
  \neo@adnobackfalse
}

\DeclareOption{frame}{%
  \neo@thmnoframefalse
  \neo@codenoframefalse
  \neo@adnoframefalse
}

\DeclareOption{clean}{%
  \neo@thmnobacktrue
  \neo@exnobacktrue
  \neo@codenobacktrue
  \neo@adnobacktrue
  \neo@thmnoframetrue
  \neo@codenoframetrue
  \neo@adnoframetrue
}

\DeclareOption{styled}{%
  \neo@thmnobackfalse
  \neo@exnobackfalse
  \neo@codenobackfalse
  \neo@adnobackfalse
  \neo@thmnoframefalse
  \neo@codenoframefalse
  \neo@adnoframefalse
}

% Box opacity
\DeclareStringOption[7]{boxopacity}

\DeclareStringOption[0]{adboxopacity}
\DeclareStringOption[7]{codeboxopacity}
\DeclareStringOption[0]{exboxopacity}
\DeclareStringOption[0]{thmboxopacity}

\DeclareStringOption[15]{mathboxopacity}

% Theorem and exercise separator
\DeclareStringOption[.\!]{thmterminator}
\DeclareStringOption{thmseparator}
\DeclareStringOption[.\!]{adterminator}
\DeclareStringOption[.]{exterminator}

%% ==============================================================================
%% Theme, style, colors
%% ==============================================================================

\DeclareStringOption[midnight]{theme}
\DeclareStringOption[light]{accent}
\DeclareStringOption[mathbook]{colorprofile}

\DeclareOption{unicolor}{\neo@unicolortrue}
\DeclareBoolOption{bicolor}

\DeclareStringOption[amslike]{thmstyle}
\DeclareStringOption[boxed]{exstyle}
\DeclareStringOption[box-leftrule]{codestyle}

%% ==============================================================================
%% Color options
%% ==============================================================================

\DeclareStringOption[black]{globalcolor}
\DeclareStringOption[sectionColor]{headcolor}
\DeclareStringOption[subsectionColor]{subcolor}
\DeclareStringOption[subsubsectionColor]{subsubcolor}
\DeclareStringOption[titleColor]{titlecolor}
\DeclareStringOption{titlehexcolor}
\DeclareStringOption[structuralColor]{headfootcolor}

%% ==============================================================================
%% Typography options
%% ==============================================================================

% Title formatting
\DeclareStringOption[hugeminus]{titlesize}
\DeclareStringOption[default]{titlelayout}
\DeclareStringOption[none]{titledecor}
\DeclareStringOption[center]{titlealign}

% Heading styles
\DeclareStringOption[sffamily]{headstyle}
\DeclareStringOption[bfseries]{headweight}
\DeclareStringOption[upshape]{headshape}

% Title-specific styles
\DeclareStringOption[\neoschool@headstyle]{titlestyle}
\DeclareStringOption[\neoschool@headweight]{titleweight}
\DeclareStringOption[upshape]{titleshape}

% Header and Footer styles
\DeclareStringOption[\neoschool@titlestyle]{headfootstyle}
\DeclareStringOption[none]{headerules}

% Section styles
\DeclareStringOption[circle]{sectionnumstyle}
\DeclareStringOption[sc]{sectiontextstyle}
\DeclareStringOption[normal]{sectionstyle}
\DeclareStringOption[center]{sectionalign}

%% ==============================================================================
%% Font options
%% ==============================================================================

\DeclareStringOption{mainface}
\DeclareStringOption{mainfaceoptions}
\DeclareStringOption{sansface}
\DeclareStringOption{sansfaceoptions}
\DeclareStringOption{monoface}
\DeclareStringOption{monofaceoptions}
\DeclareStringOption{mathface}
\DeclareStringOption{mathfaceoptions}
\DeclareStringOption[1.0]{mainfacescale}
\DeclareStringOption[1.0]{sansfacescale}
\DeclareStringOption[1.0]{monofacescale}
\DeclareStringOption[1.0]{mathfacescale}
\DeclareStringOption{facefamily}
\DeclareStringOption{facefamilyoptions}

\DeclareOption{sfbody}{\neo@sfbodytrue}
\DeclareOption{sfall}{\neo@sfalltrue\neo@sfbodytrue}
\DeclareOption{mathastext}{\neo@mathastexttrue}
\DeclareBoolOption{scale}

%% ==============================================================================
%% Language options
%% ==============================================================================

% Language setup command
\newcommand{\neo@setupLanguage}[1]{%
  \neo@englishfalse
  \neo@frenchfalse
  \neo@germanfalse
  \@nameuse{neo@#1true}
  \renewcommand{\neo@lang}{#1}
}

% Name definition commands
\newcommand{\neo@definenames@one}[9]{%
  \expandafter\def\csname neo@theoremname\endcsname{#1}
  \expandafter\def\csname neo@propositionname\endcsname{#2}
  \expandafter\def\csname neo@propertyname\endcsname{#3}
  \expandafter\def\csname neo@lemmaname\endcsname{#4}
  \expandafter\def\csname neo@corollaryname\endcsname{#5}
  \expandafter\def\csname neo@definitionname\endcsname{#6}
  \expandafter\def\csname neo@examplename\endcsname{#7}
  \expandafter\def\csname neo@exercisename\endcsname{#8}
  \expandafter\def\csname neo@remarkname\endcsname{#9}
}

\newcommand{\neo@definenames@two}[9]{%
  \expandafter\def\csname neo@problemname\endcsname{#1}
  \expandafter\def\csname neo@conjecturename\endcsname{#2}
  \expandafter\def\csname neo@activityname\endcsname{#3}
  \expandafter\def\csname neo@methodname\endcsname{#4}
  \expandafter\def\csname neo@applicationname\endcsname{#5}
  \expandafter\def\csname neo@competencies\endcsname{#6}
  \expandafter\def\csname neo@codename\endcsname{#7}
  \expandafter\def\csname neo@algorithmname\endcsname{#8}
  \expandafter\def\csname neo@pagename\endcsname{#9}
}

\newcommand{\neo@definenames@three}[1]{%
  \expandafter\def\csname neo@solutionname\endcsname{#1}
}

\newcommand{\neo@definenames@four}[2]{%
  \expandafter\def\csname neo@examplesname\endcsname{#1}
  \expandafter\def\csname neo@remarksname\endcsname{#2}
}

\newcommand{\neo@definepath}[1]{%
  \expandafter\def\csname neo@pathname\endcsname{#1}
}

\newcommand{\neo@defineextra}[2]{%
  \expandafter\def\csname neo@examplesname\endcsname{#1}
  \expandafter\def\csname neo@solutiongaptext\endcsname{#2}
}

\newcommand{\neo@defineproofnames}[1]{%
  \expandafter\def\csname neo@proofname\endcsname{#1}
}

\newcommand{\neo@definenames@ai}[2]{%
  \expandafter\def\csname neo@ainame\endcsname{#1}
  \expandafter\def\csname neo@noainame\endcsname{#2}
}

\newcommand{\neo@definenames@calculator}[5]{%
  \expandafter\def\csname neo@calcintro\endcsname{#1}
  \expandafter\def\csname neo@calcallowed\endcsname{#2}
  \expandafter\def\csname neo@calcnotallowed\endcsname{#3}
  \expandafter\def\csname neo@calcexammode\endcsname{#4}
  \expandafter\def\csname neo@calcexammodeonly\endcsname{#5}
}

\newcommand{\neo@definenames@mockexam}[5]{%
  \expandafter\def\csname neo@academytxt\endcsname{#1}
  \expandafter\def\csname neo@examoftxt\endcsname{#2}
  \expandafter\def\csname neo@sessiontxt\endcsname{#3}
  \expandafter\def\csname neo@durationtxt\endcsname{#4}
  \expandafter\def\csname neo@nametxt\endcsname{#5}
}

\newcommand{\neo@definenames@mockexam@two}[5]{%
  \expandafter\def\csname neo@pagestxt\endcsname{#1}
  \expandafter\def\csname neo@pagesfromtxt\endcsname{#2}
  \expandafter\def\csname neo@pagestotxt\endcsname{#3}
  \expandafter\def\csname neo@examqualitytxt\endcsname{#4}
  \expandafter\def\csname neo@examattempttxt\endcsname{#5}
}

\newcommand{\neo@defineadmonitionnames}[8]{%
  \def\neo@admonition@note{#1}%
  \def\neo@admonition@info{#2}%
  \def\neo@admonition@warning{#3}%
  \def\neo@admonition@important{#4}%
  \def\neo@admonition@tip{#5}%
  \def\neo@admonition@reminder{#6}%
  \def\neo@admonition@summary{#7}%
  \def\neo@admonition@toolbox{#8}%
}

% English
\DeclareOption{english}{%
  \neo@setupLanguage{english}
  \AtEndOfClass{\sisetup{locale = US,detect-all}}
  \neo@definenames@one{Theorem}{Proposition}{Property}{Lemma}{Corollary}{Definition}{Example}{Exercise}{Remark}
  \neo@definenames@two{Problem}{Conjecture}{Activity}{Method}{Application}{Competencies}{Listing}{Algorithm}{Page}
  \neo@definenames@three{Solution }
  \neo@definenames@four{Examples}{Remarks}
  \neo@defineextra{Examples}{of exercise }
  \neo@definepath{Path}
  \neo@defineproofnames{Proof}
  \neo@definenames@ai{AI}{No AI}
  \neo@definenames@calculator{Calculator use}{is allowed}{is not allowed}{exam mode}{only in}
  \neo@definenames@mockexam{Academy of}{EXAM IN}{Session}{Duration:}{Name:}
  \neo@definenames@mockexam@two{This document has}{pages numbered from}{to}{The quality of writing and rigor of reasoning will be taken into account.}{Any attempt, even partial, will be valued.}
  \neo@defineadmonitionnames{Note}{Information}{Warning}{Important}{Tip}{Remember}{Summary}{Toolbox}
}

% French
\DeclareOption{french}{%
  \neo@setupLanguage{french}
  \AtEndOfClass{%
    \sisetup{locale = FR,detect-all}%
    \renewcommand*{\today}{\number\day\space\ifcase\month\or
        janvier\or février\or mars\or avril\or mai\or juin\or
        juillet\or août\or septembre\or octobre\or novembre\or
        décembre\fi\space\number\year}%
  }
  \neo@definenames@one{Théorème}{Proposition}{Propriété}{Lemme}{Corollaire}{Définition}{Exemple}{Exercice}{Remarque}
  \neo@definenames@two{Problème}{Conjecture}{Activité}{Méthode}{Application}{Compétences}{Programme}{Algorithme}{Page}
  \neo@definenames@three{Corrigé }
  \neo@definenames@four{Exemples}{Remarques}
  \neo@defineextra{Exemples}{de l'exercice }
  \neo@definepath{Parcours}
  \neo@defineproofnames{Démonstration}
  \neo@definenames@ai{IA}{Sans IA}
  \neo@definenames@calculator{L'usage de la calculatrice}{est autorisé}{n'est pas autorisé}{mode examen}{uniquement en}
  \neo@definenames@mockexam{Académie de}{ÉPREUVE DE}{Session}{Durée~:}{Nom~:}
  \neo@definenames@mockexam@two{Ce document comporte}{pages numérotées de}{à}{La qualité de la rédaction et la rigueur des raisonnements seront prises en compte dans l'évaluation des copies.}{Toute tentative, même partielle ou inachevée, sera valorisée.}
  \neo@defineadmonitionnames{Note}{Information}{Attention}{Important}{Conseil}{À retenir}{Résumé}{Boîte à outils}
}

% German
\DeclareOption{german}{%
  \neo@setupLanguage{german}
  \AtEndOfClass{\sisetup{locale = DE,detect-all}}
  \neo@definenames@one{Theorem}{Proposition}{Eigenschaft}{Lemma}{Korollar}{Definition}{Beispiel}{Übung}{Bemerkung}
  \neo@definenames@two{Problem}{Vermutung}{Aktivität}{Methode}{Anwendung}{Fähigkeiten}{Auflistung}{Algorithmus}{Seite}
  \neo@definenames@three{Lösung }
  \neo@definenames@four{Übungen}{Bemerkungen}
  \neo@defineextra{Beispiele}{von Übung }
  \neo@definepath{Stufe}
  \neo@defineproofnames{Beweis}
  \neo@definenames@ai{AI}{Keine KI}
  \neo@definenames@calculator{Rechnernutzung}{ist erlaubt}{ist nicht erlaubt}{Prüfungsmodus}{nur im}
  \neo@definenames@mockexam{Akademie von}{PRÜFUNG IN}{Sitzung}{Dauer:}{Name:}
  \neo@definenames@mockexam@two{Dieses Dokument enthält}{Seiten, nummeriert von}{bis}{Die Qualität des Schreibens und die Strenge der Argumentation werden bei der Bewertung berücksichtigt.}{Jeder Versuch, auch nur teilweise, wird gewertet.}
  \neo@defineadmonitionnames{Notiz}{Information}{Achtung}{Wichtig}{Tipp}{Merken}{Zusammenfassung}{Werkzeugkasten}
}

\DeclareOption{nofrenchlist}{\AtEndOfClass{\frenchsetup{StandardItemLabels=true}}}
\DeclareOption{frenchlistaspar}{\AtEndOfClass{\frenchsetup{ListItemsAsPar=true}}}

%% ==============================================================================
%% Layout options
%% ==============================================================================

\DeclareStringOption[1em]{indent}
\DeclareBoolOption{noindent}

\DeclareStringOption[1.5cm]{margin}
\DeclareStringOption{noteswidth}
\DeclareStringOption{notesposition}

\DeclareStringOption{notes}
\DeclareStringOption{leftnotes}
\DeclareStringOption{rightnotes}

%% ==============================================================================
%% Header/Footer options
%% ==============================================================================

\DeclareOption{fullheader}{\neo@fullheadertrue}
\DeclareOption{nofooter}{\def\neo@pagestyle{empty}\neo@firstpagestyleoverridetrue}
\DeclareOption{pageonlyfooter}{\def\neo@pagestyle{pagenum}\neo@firstpagestyleoverridetrue}

%% ==============================================================================
%% Box options
%% ==============================================================================

\DeclareStringOption{boxtitle}
\DeclareStringOption[0pt]{adboxarc}
\DeclareStringOption[0pt]{boxarc}
\DeclareStringOption[0pt]{codeboxarc}
\DeclareStringOption[0pt]{sideboxarc}
\DeclareStringOption[0pt]{thmboxarc}
\DeclareStringOption[2pt]{exboxarc}
\DeclareStringOption[0pt]{pseudoboxarc}

\DeclareBoolOption{inlinecodebox}

%% ==============================================================================
%% Theorem/Counter options
%% ==============================================================================

\DeclareBoolOption{sectionthmcounter}
\DeclareBoolOption{sharedthmcounter}
\DeclareBoolOption{thmgroupcounter}

\newif\ifneoschool@sharedexcounter
\DeclareOption{sharedexcounter}{%
  \neoschool@sharedexcountertrue
  \neoschool@sharedthmcountertrue
}

%% ==============================================================================
%% Exercise options
%% ==============================================================================

\DeclareOption{exerciseicons}{\neo@exerciseiconstrue}
\DeclareOption{blocksol}{\neo@blocksoltrue}
\DeclareOption{shuffle}{\neo@shuffletrue}

\DeclareBoolOption{answers}
\DeclareBoolOption{answersonly}

\DeclareStringOption[20]{totalpoints}

%% ==============================================================================
%% Package-Specific options
%% ==============================================================================

\DeclareBoolOption{math}
\DeclareOption{apmep}{\neo@apmeptrue}
\DeclareOption{mathics}{\neo@mathicstrue}
\DeclareOption{listings}{\neo@listingstrue}
\DeclareOption{minted}{\neo@mintedtrue}
\DeclareOption{frenchmath}{\neo@frenchmathtrue}

\DeclareStringOption[1]{codewidth}
\DeclareBoolOption{centeredcode}

\DeclareBoolOption{faketext}

%% ==============================================================================
%% Vertical spacing options
%% ==============================================================================

\DeclareStringOption[1.0]{vspacing}

%% ==============================================================================
%% TOC options
%% ==============================================================================

\DeclareOption{compacttoc}{\neo@compacttoctrue}
\DeclareOption{monotoc}{\neo@monotoctrue}
\DeclareOption{twocolumntoc}{\neo@twocolumntoctrue}

%% ==============================================================================
%% Admonition options
%% ==============================================================================

\DeclareBoolOption[true]{inlineadmonition}
\DeclareVoidOption{blockadmonition}{\neoschool@inlineadmonitionfalse}

%% ==============================================================================
%% Output mode options
%% ==============================================================================

\DeclareOption{2a5toa4}{\neo@twoupafourmodetrue}
\DeclareOption{2a4toa3}{\neo@twoupathreemodetrue}
\DeclareOption{4a5toa3}{\neo@fourupathreemodetrue}
\DeclareOption{2toa3}{\neo@simpletwoupmodetrue}
\DeclareOption{bookleta5}{\neo@bookletafourmodetrue}
\DeclareOption{bookleta4}{\neo@bookletathreemodetrue}

%% ==============================================================================
%% Miscellaneous options
%% ==============================================================================

\DeclareStringOption[DEFAULT]{abstracttitle}
\DeclareBoolOption{boldlistlabels}

%% ==============================================================================
%% Unknown options handler
%% ==============================================================================

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{scrartcl}}

%% ==============================================================================
%% Option processing
%% ==============================================================================

% Process keyval options first
\ProcessKeyvalOptions*\relax

% Default language
\ExecuteOptions{english}

% Process remaining options
\ProcessOptions\relax

%% ==============================================================================
%% Post-Processing validation
%% ==============================================================================

% Vertical space compression factor validation
\edef\neo@vspace@factor{\neoschool@vspacing}

\ifdim\neo@vspace@factor pt<0.25pt
  \ClassWarning{neoschool}{vspacing value too small, setting to 0.25}
  \def\neo@vspace@factor{0.25}
\fi
\ifdim\neo@vspace@factor pt>2.0pt
  \ClassWarning{neoschool}{vspacing value too large, setting to 2.0}
  \def\neo@vspace@factor{2.0}
\fi

% Default to listings if neither minted nor listings specified
\ifneo@minted\else
  \ifneo@listings\else
    \neo@listingstrue
  \fi
\fi

% exstyle defaults to thmstyle if not set
\ifx\neoschool@exstyle\@empty
  \let\neoschool@exstyle\neoschool@thmstyle
\fi

%% ==============================================================================
%% Margin Notes
%% ==============================================================================

\ifdefempty{\neoschool@notes}{}{%
  \def\neoschool@noteswidth{\neoschool@notes}%
  \def\neoschool@notesposition{alternate}%
}

\ifdefempty{\neoschool@leftnotes}{}{%
  \def\neoschool@noteswidth{\neoschool@leftnotes}%
  \def\neoschool@notesposition{left}%
}

\ifdefempty{\neoschool@rightnotes}{}{%
  \def\neoschool@noteswidth{\neoschool@rightnotes}%
  \def\neoschool@notesposition{right}%
}

%% ==============================================================================
%% Box opacity
%% ==============================================================================

\ifdefempty{\neoschool@thmboxopacity}{\edef\neoschool@thmboxopacity{\neoschool@boxopacity}}{}
\ifdefempty{\neoschool@codeboxopacity}{\edef\neoschool@codeboxopacity{\neoschool@boxopacity}}{}
\ifdefempty{\neoschool@exboxopacity}{\edef\neoschool@exboxopacity{\neoschool@boxopacity}}{}
\ifdefempty{\neoschool@adboxopacity}{\edef\neoschool@adboxopacity{\neoschool@boxopacity}}{}

\newcommand{\neo@thmopacity}{\neoschool@thmboxopacity}
\newcommand{\neo@codeopacity}{\neoschool@codeboxopacity}
\newcommand{\neo@exopacity}{\neoschool@exboxopacity}
\newcommand{\neo@adopacity}{\neoschool@adboxopacity}

%% ==============================================================================
%% Color system
%% ==============================================================================

\ExplSyntaxOn

%% Internal variables

\tl_new:N \l__neo_theme_tl
\tl_new:N \l__neo_accent_tl

\tl_set:Nx \l__neo_theme_tl { \neoschool@theme }
\tl_trim_spaces:N \l__neo_theme_tl
\tl_set:Nx \l__neo_accent_tl { \neoschool@accent }
\tl_trim_spaces:N \l__neo_accent_tl

%% Helper functions

\newcommand{\defSmartComplement}[2]{%
  \def\tempColor{}
  \colorlet{\tempColor}{-#2}%
  \colorlet{#1}{\tempColor!50!black}%
}

% Set Palette Triad
\cs_new_protected:Npn \__neo_set_palette:nnn #1 #2 #3 {
  \definecolor{neoPrimaryColor}{HTML}{#1}
  \colorlet{primaryColor}{neoPrimaryColor}
  \ifneo@unicolor
    \colorlet{secondaryColor}{primaryColor}
    \colorlet{tertiaryColor}{primaryColor}
  \else\ifneoschool@bicolor
      \defSmartComplement{secondaryColor}{neoPrimaryColor}
      \colorlet{tertiaryColor}{secondaryColor}
    \else
      \definecolor{neoSecondaryColor}{HTML}{#2}
      \colorlet{secondaryColor}{neoSecondaryColor}
      \definecolor{neoTertiaryColor}{HTML}{#3}
      \colorlet{tertiaryColor}{neoTertiaryColor}
    \fi
  \fi
}

% Dispatch Harmonic vs Classic
\cs_new_protected:Npn \__neo_theme_dispatch:nnnnn #1 #2 #3 #4 #5 {
  \str_if_eq:VnTF \l__neo_accent_tl {gradient}
  { \__neo_set_palette:nnn {#1}{#3}{#2} }
  { \__neo_set_palette:nnn {#1}{#4}{#5} }
}

% Helper: Set Header Colors
\cs_new:Nn \__neo_set_headers:nnnnn {
  \colorlet{titleColor}{#1} \colorlet{subtitleColor}{#2}
  \colorlet{sectionColor}{#3} \colorlet{subsectionColor}{#4} \colorlet{subsubsectionColor}{#5}
}

% Helper: Set Block Semantic Colors
\cs_new:Nn \__neo_set_blocks_colors:nnnn {
  \colorlet{theoremColor}{#1} \colorlet{definitionColor}{#2}
  \colorlet{exampleColor}{#3} \colorlet{exerciseColor}{#4}
}

% Helper: Set UI Colors
\cs_new:Nn \__neo_set_ui_colors:nn {
  \colorlet{codeFrame}{#1} \colorlet{codeTitle}{#1} \colorlet{verbColor}{#1}
  \colorlet{neo@linkcolor}{#2} \colorlet{markerColor}{#2} \colorlet{neo@urlcolor}{#2}
}

% Helper: Set Source Mapping
\cs_new:Nn \__neo_setup_palette_sources: {
  \str_case:VnF \neoschool@colorprofile {
    {mathbook} {%
      \colorlet{neo@source@foundations}{primaryColor}
      \colorlet{neo@source@theory}{secondaryColor}
      \colorlet{neo@source@exercises}{tertiaryColor}
      \colorlet{neo@source@examples}{tertiaryColor} }
    {exam} {%
      \colorlet{neo@source@foundations}{secondaryColor}
      \colorlet{neo@source@theory}{secondaryColor}
      \colorlet{neo@source@exercises}{primaryColor}
      \colorlet{neo@source@examples}{tertiaryColor} }
    {core} {%
      \colorlet{neo@source@foundations}{primaryColor}
      \colorlet{neo@source@theory}{primaryColor}
      \colorlet{neo@source@exercises}{secondaryColor}
      \colorlet{neo@source@examples}{tertiaryColor} }
    {school} {%
      \colorlet{neo@source@foundations}{tertiaryColor}
      \colorlet{neo@source@theory}{secondaryColor}
      \colorlet{neo@source@exercises}{primaryColor}
      \colorlet{neo@source@examples}{primaryColor} }
  } {%
    \colorlet{neo@source@foundations}{primaryColor}
    \colorlet{neo@source@theory}{secondaryColor}
    \colorlet{neo@source@exercises}{tertiaryColor}
    \colorlet{neo@source@examples}{tertiaryColor} }
}

%% Theme definitions (palettes)

\str_case:VnF \l__neo_theme_tl {
  % Light Themes
  %% --- Modern ---
  {cambridge}     { \__neo_theme_dispatch:nnnnn {222823}{34495E}{5D6D7E}{8B3A3A}{4A7C8C} }
  {fjord}         { \__neo_theme_dispatch:nnnnn {1A3A4A}{2A4A5A}{0A2A3A}{4A3A2A}{3A2A4A} }
  {granite}       { \__neo_theme_dispatch:nnnnn {3A3A3A}{4A4A4A}{2A2A2A}{5A3A2A}{2A3A5A} }
  {graphite}      { \__neo_theme_dispatch:nnnnn {2C3E50}{34495E}{5D6D7E}{A04035}{2980B9} }
  {midnight}      { \__neo_theme_dispatch:nnnnn {154360}{1A5276}{21618C}{D35400}{117A65} }
  {nocturne}      { \__neo_theme_dispatch:nnnnn {1A1A2E}{16213E}{0F3460}{4A0E1A}{1A4A2E} }
  {nordic}        { \__neo_theme_dispatch:nnnnn {2E3440}{3B4252}{434C5E}{5480AB}{B54A55} }
  {oceanic}       { \__neo_theme_dispatch:nnnnn {006064}{005F5F}{004F5F}{8B5A3A}{3A5A6A} }
  {oxford}        { \__neo_theme_dispatch:nnnnn {1D3558}{2D6268}{332D68}{6B2D45}{456B2D} }
  {petrol}        { \__neo_theme_dispatch:nnnnn {2A3A4A}{3A4A5A}{4A5A6A}{9A7030}{2A7A68} }
  {slate}         { \__neo_theme_dispatch:nnnnn {2C3E50}{455A64}{607D8B}{8B4035}{2471A3} }
  %% --- Blue ---
  {academic}      { \__neo_theme_dispatch:nnnnn {1A4A6A}{2A6A6A}{1A2A5A}{5A2A3A}{3A5A2A} }
  {azure}         { \__neo_theme_dispatch:nnnnn {42618F}{3A7080}{4A5A8F}{7A5A6A}{5A7A50} }
  {book}          { \__neo_theme_dispatch:nnnnn {22575C}{347A80}{237F7C}{9A4A3A}{3A7A4A} }
  {klein}         { \__neo_theme_dispatch:nnnnn {1A4A8A}{2A5AAA}{5A7ABB}{8A3A5A}{3A6A4A} }
  {pacific}       { \__neo_theme_dispatch:nnnnn {0E7C9C}{1A8A8A}{2A6A7A}{7A5A3A}{4A6A5A} }
  {prussian}      { \__neo_theme_dispatch:nnnnn {003153}{1A6A5A}{1A2A6A}{6A2A5A}{2A6A1A} }
  {royalblue}     { \__neo_theme_dispatch:nnnnn {1E4D97}{2A6A7A}{3D3A8A}{8A4A5A}{4A7A3A} }
  {scholar}       { \__neo_theme_dispatch:nnnnn {003366}{006666}{000066}{8B5A3A}{2F4F4F} }
  {skyblue}       { \__neo_theme_dispatch:nnnnn {21618C}{2E86C1}{0A78C1}{8A6A2A}{2A7A4A} }
  %% --- Green ---
  {classic}       { \__neo_theme_dispatch:nnnnn {4F7C5B}{5F8C6B}{3F6C4B}{B85C3A}{2A4C7F} }
  {dartmouth}     { \__neo_theme_dispatch:nnnnn {2A6A4A}{2A6A2A}{2A5A6A}{1A3A5A}{6A5A2A} }
  {emerald}       { \__neo_theme_dispatch:nnnnn {2E8B57}{3A7A50}{2A6A5A}{7A5A4A}{4A5A6A} }
  {forest}        { \__neo_theme_dispatch:nnnnn {097969}{2A7A5A}{1A6A5A}{6A4A4A}{4A5A6A} }
  {hunter}        { \__neo_theme_dispatch:nnnnn {145A32}{2A6A4A}{3A7A5A}{8A6A3A}{5A5A6A} }
  {jungle}        { \__neo_theme_dispatch:nnnnn {1B4F72}{2A5A4A}{2A6A5A}{8A4A3A}{8A7A4A} }
  {olive}         { \__neo_theme_dispatch:nnnnn {556B2F}{6B8E23}{8FBC8F}{8B5A3A}{5A6A4A} }
  {reef}          { \__neo_theme_dispatch:nnnnn {2A6A6A}{3A5A5A}{2A4A5A}{6A5A3A}{4A5A5A} }
  {science}       { \__neo_theme_dispatch:nnnnn {228B22}{3A6A5A}{4A5A6A}{5A6A7A}{7A5A4A} }
  {teal}          { \__neo_theme_dispatch:nnnnn {008B8B}{1A7A7A}{2A6A7A}{7A3A3A}{4A7A3A} }
  %% --- Red ---
  {burgundy}      { \__neo_theme_dispatch:nnnnn {5A2A3A}{5A3A5A}{5A2A2A}{5A5A3A}{2A3A5A} }
  {cherry}        { \__neo_theme_dispatch:nnnnn {922B21}{A04040}{C08080}{5A6A5A}{5A5A6A} }
  {crimson}       { \__neo_theme_dispatch:nnnnn {8A3A4A}{8A3A6A}{8A4A3A}{4A7A4A}{3A4A7A} }
  {deeporange}    { \__neo_theme_dispatch:nnnnn {9A5A3A}{8A4A4A}{7A6A3A}{5A6A5A}{5A5A6A} }
  {firebrick}     { \__neo_theme_dispatch:nnnnn {8A4030}{8A3040}{8A6A30}{5A6A4A}{4A4A6A} }
  {pepper}        { \__neo_theme_dispatch:nnnnn {8A3040}{8A4060}{8A5040}{4A6A5A}{5A5A6A} }
  %% --- Brown ---
  {coffee}        { \__neo_theme_dispatch:nnnnn {6E2C00}{7A4020}{8A5030}{4A5A4A}{4A4A5A} }
  {goldenrod}     { \__neo_theme_dispatch:nnnnn {B8860B}{AD5F14}{996F04}{8B4513}{2F4F4F} }
  {monastery}     { \__neo_theme_dispatch:nnnnn {4A3A2A}{5A4A3A}{6A5A4A}{3A4A5A}{4A5A4A} }
  {rosewood}      { \__neo_theme_dispatch:nnnnn {7A2A2A}{7A2A3A}{7A3A4A}{3A5A5A}{4A5A3A} }
  {sahara}        { \__neo_theme_dispatch:nnnnn {8B4513}{704214}{5C3A11}{2E5A4A}{4A2E3A} }
  {scarlet}       { \__neo_theme_dispatch:nnnnn {A04035}{C05045}{B04535}{2C3E50}{2A6A4A} }
  {sienna}        { \__neo_theme_dispatch:nnnnn {A0522D}{8A4A40}{9A5A30}{5A6A7A}{4A6A5A} }
  {terra}         { \__neo_theme_dispatch:nnnnn {A04000}{9A5020}{B06030}{5A6A6A}{5A7A5A} }
  {titian}        { \__neo_theme_dispatch:nnnnn {A05A3A}{9A4040}{7A6A3A}{5A6A4A}{5A4A5A} }
  {tuscany}       { \__neo_theme_dispatch:nnnnn {6B4A30}{7A5A3A}{5A4020}{4A5A5A}{5A6A4A} }
  {vandyke}       { \__neo_theme_dispatch:nnnnn {5A4030}{5A3040}{5A5030}{4A5A30}{3A3A5A} }
  {vintage}       { \__neo_theme_dispatch:nnnnn {3E2723}{5D4037}{795548}{2A4A5A}{8A4A3A} }
  %% --- Purple ---
  {amethyst}      { \__neo_theme_dispatch:nnnnn {6C3483}{7D4A8A}{8A5A9A}{7A6A3A}{3A5A6A} }
  {dusk}          { \__neo_theme_dispatch:nnnnn {4A3A5A}{5A4A6A}{3A2A4A}{6A4A3A}{3A5A4A} }
  {indigo}        { \__neo_theme_dispatch:nnnnn {4A3A6A}{5A3A6A}{3A2A5A}{6A7A4A}{3A6A5A} }
  {iris}          { \__neo_theme_dispatch:nnnnn {4A4A8A}{5A6A9A}{8A5A9A}{8A5040}{4A7A5A} }
  {lavender}      { \__neo_theme_dispatch:nnnnn {483D8B}{5A5A9A}{6A6AAA}{6A4A6A}{4A6A5A} }
  {marrs}         { \__neo_theme_dispatch:nnnnn {2A7A7A}{2A7A4A}{2A5A7A}{2A3A6A}{6A6A3A} }
  {modern}        { \__neo_theme_dispatch:nnnnn {5A4A9A}{6A5A9A}{4A4A7A}{9A5A4A}{4A7A7A} }
  {mulberry}      { \__neo_theme_dispatch:nnnnn {8A4060}{9A4050}{A05060}{3A5A5A}{3A4A6A} }
  {violetrose}    { \__neo_theme_dispatch:nnnnn {8A5080}{8A5A6A}{8A5090}{5A7A6A}{5A6A7A} }  % Dark Themes
  {dracula} {
    \neo@darkthemetrue
    \definecolor{backgroundColor}{HTML}{282A36} \pagecolor{backgroundColor}
    \definecolor{neo@textcolor}{HTML}{F8F8F2}
    \colorlet{subjectColor}{neo@textcolor!75!black}
    \def\neoschool@globalcolor{neo@textcolor}
    \def\neoschool@headfootcolor{neo@textcolor!75!black}
    \colorlet{codeComment}{neo@textcolor!65!black}
    \colorlet{codeNumber}{neo@textcolor!65!black}
    \__neo_set_palette:nnn {FF79C6}{BD93F9}{50FA7B}
  }
  {night} {
    \neo@darkthemetrue
    \definecolor{backgroundColor}{HTML}{0F172A} \pagecolor{backgroundColor}
    \definecolor{neo@textcolor}{HTML}{E2E8F0}
    \colorlet{subjectColor}{neo@textcolor!75!black}
    \def\neoschool@globalcolor{neo@textcolor}
    \def\neoschool@headfootcolor{neo@textcolor!75!black}
    \colorlet{codeComment}{neo@textcolor!65!black}
    \colorlet{codeNumber}{neo@textcolor!65!black}
    \__neo_set_palette:nnn {60A5FA}{F472B6}{34D399}
  }
  {mocha} {
    \neo@darkthemetrue
    \definecolor{backgroundColor}{HTML}{1E1E2E} \pagecolor{backgroundColor}
    \definecolor{neo@textcolor}{HTML}{CDD6F4}
    \colorlet{subjectColor}{neo@textcolor!75!black}
    \def\neoschool@globalcolor{neo@textcolor}
    \def\neoschool@headfootcolor{neo@textcolor!75!black}
    \colorlet{codeComment}{neo@textcolor!65!black}
    \colorlet{codeNumber}{neo@textcolor!65!black}
    \__neo_set_palette:nnn {89B4FA}{F5C2E7}{A6E3A1}
  }
  {nord} {
    \neo@darkthemetrue
    \definecolor{backgroundColor}{HTML}{2E3440} \pagecolor{backgroundColor}
    \definecolor{neo@textcolor}{HTML}{ECEFF4}
    \colorlet{subjectColor}{neo@textcolor!75!black}
    \def\neoschool@globalcolor{neo@textcolor}
    \def\neoschool@headfootcolor{neo@textcolor!75!black}
    \colorlet{codeComment}{neo@textcolor!65!black}
    \colorlet{codeNumber}{neo@textcolor!65!black}
    \__neo_set_palette:nnn {88C0D0}{B48EAD}{A3BE8C}
  }
}
{
  % Fallback to classic
  \PackageWarning{neoschool}{Theme~'\neoschool@theme'~unknown,~using~midnight}
  \__neo_theme_dispatch:nnnnn {154360}{1A5276}{21618C}{D35400}{117A65}
}

%% Style definitions (color & structure application)

\__neo_setup_palette_sources:

\str_case:VnF \l__neo_accent_tl
{
  {strong} {
    \ifneo@darktheme
      \__neo_set_headers:nnnnn {white!95!black} {primaryColor!90!white} {white!90!black} {primaryColor!80!white} {white!70!black}
    \else
      \__neo_set_headers:nnnnn {black!90} {primaryColor} {black!85} {primaryColor!85!black} {black!70}
      \colorlet{subjectColor}{black!75}
    \fi
    \__neo_set_blocks_colors:nnnn {neo@source@theory} {neo@source@foundations} {neo@source@examples} {neo@source@exercises}
    \__neo_set_ui_colors:nn {primaryColor} {primaryColor}
  }
  {emphasized} {
    \ifneo@darktheme
      \__neo_set_headers:nnnnn {primaryColor} {white!70!black} {secondaryColor} {white!80!black} {tertiaryColor}
    \else
      \__neo_set_headers:nnnnn {primaryColor} {black!60} {secondaryColor} {black!70} {tertiaryColor}
      \colorlet{subjectColor}{black!75}
    \fi
    \__neo_set_blocks_colors:nnnn {neo@source@theory} {neo@source@foundations} {neo@source@examples} {neo@source@exercises}
    \__neo_set_ui_colors:nn {primaryColor} {primaryColor}
  }
  {gradient} {
    \ifneo@darktheme
      \__neo_set_headers:nnnnn {primaryColor!95!white} {primaryColor!75!white} {primaryColor!90!white} {secondaryColor!90!white} {secondaryColor!85!white}
    \else
      \__neo_set_headers:nnnnn {primaryColor!90!black} {primaryColor!65!black} {primaryColor!85!black} {secondaryColor!85!black} {tertiaryColor!80!black}
      \colorlet{subjectColor}{black!75}
    \fi
    \__neo_set_blocks_colors:nnnn {neo@source@theory} {neo@source@foundations} {neo@source@examples} {neo@source@exercises}
    \__neo_set_ui_colors:nn {primaryColor} {primaryColor}
  }
  {soft} {
    \ifneo@darktheme
      \__neo_set_headers:nnnnn {white!95!black} {white!80!black} {primaryColor!90!white} {secondaryColor!85!white} {tertiaryColor!80!white}
    \else
      \__neo_set_headers:nnnnn {black!90} {black!60} {primaryColor!85!black} {black!80} {black!70}
      \colorlet{subjectColor}{black!75}
    \fi
    \__neo_set_blocks_colors:nnnn {neo@source@theory} {neo@source@foundations} {neo@source@examples} {neo@source@exercises}
    \__neo_set_ui_colors:nn {primaryColor} {primaryColor}
  }
  {flat} {
    \ifneo@darktheme
      \__neo_set_headers:nnnnn {primaryColor} {primaryColor!75!white} {primaryColor!90!white} {primaryColor!70!white} {primaryColor!60!white}
    \else
      \__neo_set_headers:nnnnn {primaryColor!90!black} {primaryColor!70!black} {primaryColor!85!black} {primaryColor!70!black} {primaryColor!55!black}
      \colorlet{subjectColor}{black!75}
    \fi
    \__neo_set_blocks_colors:nnnn {secondaryColor} {secondaryColor} {tertiaryColor} {tertiaryColor}
    \__neo_set_ui_colors:nn {primaryColor} {primaryColor}
  }
  {light} {
    \ifneo@darktheme
      \__neo_set_headers:nnnnn {primaryColor!90!white} {primaryColor!75!white} {primaryColor!85!white} {secondaryColor!80!white} {secondaryColor!70!white}
    \else
      \__neo_set_headers:nnnnn {primaryColor!80!black} {primaryColor!70!black} {primaryColor!75!black} {secondaryColor!75!black} {secondaryColor!65!black}
      \colorlet{subjectColor}{black!75}
    \fi
    \__neo_set_blocks_colors:nnnn {neo@source@theory} {neo@source@foundations} {neo@source@examples} {neo@source@exercises}
    \__neo_set_ui_colors:nn {primaryColor} {secondaryColor}
  }
  {stuctured} {
    \ifneo@darktheme
      \__neo_set_headers:nnnnn {primaryColor!95!white} {primaryColor!80!white} {primaryColor!90!white} {secondaryColor!85!white} {tertiaryColor!80!white}
    \else
      \__neo_set_headers:nnnnn {primaryColor!85!black} {primaryColor!70!black} {primaryColor!80!black} {secondaryColor!75!black} {tertiaryColor!70!black}
      \colorlet{subjectColor}{black!75}
    \fi
    \__neo_set_blocks_colors:nnnn {neo@source@theory} {neo@source@foundations} {neo@source@examples} {neo@source@exercises}
    \__neo_set_ui_colors:nn {structuralColor!50} {primaryColor}
      \colorlet{verbColor}{black!85}
      \colorlet{codeTitle}{black!85}
  }
  {minimal} {
    \ifneo@darktheme
      \__neo_set_headers:nnnnn {white!95!black} {white!80!black} {white!90!black} {secondaryColor!85!white} {tertiaryColor!80!white}
    \else
      \__neo_set_headers:nnnnn {black!90} {black!60} {black!85} {black!75} {black!65}
      \colorlet{subjectColor}{black!75}
    \fi
    \__neo_set_blocks_colors:nnnn {neo@source@theory} {neo@source@foundations} {neo@source@examples} {neo@source@exercises}
    \__neo_set_ui_colors:nn {primaryColor} {primaryColor}
  }
  {mono} {
    \neo@unicolortrue
    \__neo_set_headers:nnnnn {primaryColor} {primaryColor} {primaryColor} {primaryColor} {primaryColor}
    \colorlet{subjectColor}{black!75}
    \__neo_set_blocks_colors:nnnn {neo@source@theory} {neo@source@foundations} {neo@source@examples} {neo@source@exercises}
    \colorlet{mathColor}{primaryColor}
    \__neo_set_ui_colors:nn {primaryColor} {primaryColor}
  }
  {technical} {
    \ifneo@darktheme
      \__neo_set_headers:nnnnn {white!95!black} {white!80!black} {white!90!black} {white!85!black} {white!75!black}
      \__neo_set_blocks_colors:nnnn {neo@source@theory} {neo@source@foundations} {neo@source@examples} {neo@source@exercises}
      \colorlet{neo@urlcolor}{white!80!black}
    \else
      \definecolor{backgroundColor}{HTML}{FFFFFF} \pagecolor{backgroundColor}
      \__neo_set_headers:nnnnn {black!95} {black!80} {black!90} {black!80} {black!70}
      \colorlet{subjectColor}{black!75}
      \__neo_set_blocks_colors:nnnn {black!85} {black!85} {black!85} {black!85}
      \__neo_set_ui_colors:nn {structuralColor!50} {structuralColor}
      \colorlet{verbColor}{black!85}
      \colorlet{codeTitle}{black!85}
    \fi
    \neo@darkthemefalse
  }
  {print} {
    \neo@darkthemefalse \neo@printtrue \neo@palettechosentrue
    \definecolor{backgroundColor}{HTML}{FFFFFF} \pagecolor{backgroundColor}
    \colorlet{primaryColor}{black}
    \colorlet{secondaryColor}{black}
    \colorlet{tertiaryColor}{black}
    \colorlet{subjectColor}{black!75}
  }
  {accessible} {
    \neo@darkthemefalse
    \definecolor{backgroundColor}{HTML}{FDFDF0}
    \pagecolor{backgroundColor}
    \definecolor{neo@offblack}{HTML}{1A1A1A}
    \__neo_set_headers:nnnnn {primaryColor!80!black} {primaryColor!70!black} {neo@offblack} {neo@offblack} {neo@offblack}
    \colorlet{subjectColor}{neo@offblack}
    \__neo_set_blocks_colors:nnnn {neo@source@theory} {neo@source@foundations} {neo@source@examples} {neo@source@exercises}
    \__neo_set_ui_colors:nn {primaryColor} {primaryColor}
    \colorlet{verbColor}{black}
    \colorlet{neoCorrectColor}{green!60!black}
    \colorlet{neoIncorrectColor}{red!80!black}
    \colorlet{mathColor}{primaryColor!80!black}
  }
}
{
  % Default fallback
  \__neo_set_headers:nnnnn {black!90} {primaryColor} {black!85} {primaryColor!85!black} {black!70}
}

\ExplSyntaxOff

%% Structure enforcement

\newcommand{\neo@enforce@structure}{%
  % A. Frames
  \ifneo@thmnoframe
    \renewcommand{\neo@framehidden}{frame hidden}
    \renewcommand{\neo@thmborder}{0pt}
    \renewcommand{\neo@box@titletext}{tcbcolframe}
    \ifneo@thmnoback
      \renewcommand{\neoschool@thmstyle}{amslike}
    \fi
  \else
    \renewcommand{\neo@framehidden}{}
    \renewcommand{\neo@thmborder}{0.8pt}
  \fi

  % B. Backgrounds
  \ifneo@thmnoback
    \renewcommand{\neo@thm@box@mainback}{backgroundColor}
    \ifneo@darktheme
      \definecolor{nobacklowercolor}{gray}{0.15}
      \renewcommand{\neo@box@lowerback}{nobacklowercolor}
    \else
      \renewcommand{\neo@box@lowerback}{tcbcolframe!\neoschool@thmboxopacity}
    \fi
    \colorlet{theoremBgColor}{backgroundColor}
    \colorlet{definitionBgColor}{backgroundColor}
    \colorlet{exampleBgColor}{backgroundColor}
  \else
    \renewcommand{\neo@thm@box@mainback}{tcbcolframe!\neo@thmopacity!white}
    \colorlet{theoremBgColor}{theoremColor!\neo@thmopacity!white}
    \colorlet{definitionBgColor}{definitionColor!\neo@thmopacity!white}
    \colorlet{activityBgColor}{exerciseColor!\neo@thmopacity!white}
    \colorlet{methodBgColor}{exerciseColor!\neo@thmopacity!white}
    \colorlet{applicationBgColor}{exerciseColor!\neo@thmopacity!white}
    \colorlet{solutionBgColor}{exerciseColor!\neo@exopacity!white}
    \colorlet{exampleBgColor}{exampleColor!\neo@thmopacity!white}
  \fi

  % C. Code
  \ifneo@codenoback
    \colorlet{codeBackground}{backgroundColor}
    \colorlet{pseudocodeBackground}{backgroundColor}
  \else
    \colorlet{codeBackground}{codeFrame!\neo@codeopacity!white}
  \fi
  \ifneo@codenoframe
    \renewcommand{\neo@codebox@titlecolor}{titleColor}
    \renewcommand{\neo@codeborder}{0pt}
    \ifneo@codenoback
      \renewcommand{\neoschool@codestyle}{box-elegant}
    \fi
  \fi

  % D. Admonitions
  \ifneo@adnoframe
    \renewcommand{\neo@adframehidden}{frame hidden}
    \ifneo@adnoback
      \neo@effective@ad@beforeskip=\dimexpr0.5\neo@effective@ad@beforeskip\relax
      \neo@effective@ad@afterskip=\dimexpr0.5\neo@effective@ad@afterskip\relax
      \renewcommand{\neo@ad@left@padding}{13pt}
      \renewcommand{\neo@ad@right@padding}{0pt}
      \renewcommand{\neo@ad@top@padding}{-5pt}
      \renewcommand{\neo@ad@bottom@padding}{-3pt}
    \fi
  \fi
  \ifneo@adnoback
    \renewcommand{\neoschool@adboxopacity}{0}
  \fi
  \ifneo@darktheme
    \definecolor{infoColor}{HTML}{7FB4FF}
    \definecolor{warningColor}{HTML}{FFB84D}
    \definecolor{importantColor}{HTML}{FF6B6B}
    \definecolor{tipColor}{HTML}{94D36C}
    \definecolor{toolboxColor}{HTML}{D8A8FF}
    \definecolor{reminderColor}{HTML}{FF99CC}
    \definecolor{summaryColor}{HTML}{A0D8EF}
  \fi

  % E. Exercises
  \ifneo@exnoback
    \colorlet{exerciseBgColor}{backgroundColor}
  \else
    \colorlet{exerciseBgColor}{exerciseColor!\neo@exopacity!white}
  \fi
}

\neo@enforce@structure

%% Derived colors

% Admonition Boxes
\colorlet{noteColor}{primaryColor}

% Code Colors
\colorlet{codeKeyword}{primaryColor}
\colorlet{codeString}{tertiaryColor}
\colorlet{codeEmph}{secondaryColor}

% Math colors
\colorlet{mathColor}{primaryColor}
\colorlet{mathHighlightColor}{tertiaryColor!\neoschool@mathboxopacity!white}

\colorlet{markerColor}{primaryColor}

% Title hex color override
\ifx\neoschool@titlehexcolor\@empty
\else
  \definecolor{titleColor}{HTML}{\neoschool@titlehexcolor}
\fi

% Theorem variant colors
\colorlet{lemmaColor}{theoremColor}
\colorlet{lemmaBgColor}{theoremBgColor}
\colorlet{corollaryColor}{theoremColor}
\colorlet{corollaryBgColor}{theoremBgColor}
\colorlet{propositionColor}{theoremColor}
\colorlet{propositionBgColor}{theoremBgColor}
\colorlet{propertyColor}{theoremColor}
\colorlet{propertyBgColor}{theoremBgColor}

% Exercise variant colors
\colorlet{activityColor}{structuralColor}
\colorlet{applicationColor}{structuralColor}
\colorlet{methodColor}{structuralColor}
\colorlet{solutionColor}{exerciseColor}
\colorlet{activityBgColor}{structuralColor!\neo@thmopacity!white}
\colorlet{methodBgColor}{structuralColor!\neo@thmopacity!white}
\colorlet{applicationBgColor}{structuralColor!\neo@thmopacity!white}
\colorlet{solutionBgColor}{exerciseColor!\neo@exopacity!white}

\colorlet{answerframeFrameColor}{exerciseColor}
\colorlet{answerfieldBgColor}{exerciseColor!8!white}
\colorlet{emptyboxBgColor}{exerciseBgColor}

% Example variant colors
\colorlet{conjectureColor}{structuralColor}
\colorlet{conjectureBgColor}{structuralColor!\neo@thmopacity!white}
\colorlet{remarkColor}{exampleColor}
\colorlet{remarkBgColor}{exampleBgColor}
\colorlet{comprehensionColor}{exampleColor}
\colorlet{comprehensionBgColor}{exampleBgColor}

% Pseudocode colors
\colorlet{pseudocodeTitle}{primaryColor}
\colorlet{pseudocodeFrame}{codeFrame}
\colorlet{pseudocodeBackground}{codeBackground}

% Reset unicolor flag
\neo@unicolorfalse

\AtBeginDocument{%
  \ifneo@print
    \colorlet{codeKeyword}{black}
    \colorlet{codeString}{black}
    \colorlet{codeComment}{black!60}
    \colorlet{codeNumber}{black!50}
    \colorlet{codeEmph}{black}
    \colorlet{verbColor}{black}
    \colorlet{markerColor}{black}
    \colorlet{neo@urlcolor}{black}
    \colorlet{neo@linkcolor}{black}
    \colorlet{neo@citecolor}{black}
    \colorlet{neo@filecolor}{black}
    \colorlet{infoColor}{black}
    \colorlet{warningColor}{black}
    \colorlet{importantColor}{black}
    \colorlet{tipColor}{black}
    \colorlet{toolboxColor}{black}
    \colorlet{reminderColor}{black}
    \colorlet{summaryColor}{black}
    \colorlet{neoCorrectColor}{black}
    \colorlet{neoIncorrectColor}{black}
  \fi
  \ifneo@unicolor
    \colorlet{neo@urlcolor}{primaryColor}
    \colorlet{neo@linkcolor}{primaryColor}
    \colorlet{neo@citecolor}{primaryColor}
    \colorlet{neo@filecolor}{primaryColor}
    \colorlet{infoColor}{primaryColor}
    \colorlet{warningColor}{primaryColor}
    \colorlet{importantColor}{primaryColor}
    \colorlet{tipColor}{primaryColor}
    \colorlet{toolboxColor}{primaryColor}
    \colorlet{reminderColor}{primaryColor}
    \colorlet{summaryColor}{primaryColor}
    \colorlet{neoCorrectColor}{primaryColor}
    \colorlet{neoIncorrectColor}{primaryColor}
  \fi
}

%% ==============================================================================
%% Base class loading
%% ==============================================================================

%% Output mode pre-configuration

\ifneo@twoupafourmode
	\PassOptionsToClass{a5paper}{scrartcl}
	\AtEndPreamble{
		\KOMAoptions{paper=a5}
		\neo@setupmargins{last}
		\areaset{12cm}{19cm}
	}
\fi

\ifneo@twoupathreemode
	\PassOptionsToClass{a4paper}{scrartcl}
\fi

\ifneo@fourupathreemode
	\PassOptionsToClass{a5paper}{scrartcl}
	\AtEndPreamble{
		\KOMAoptions{paper=a5}
		\neo@setupmargins{last}
		\areaset{12cm}{19cm}
	}
\fi

\ifneo@simpletwoupmode
	\PassOptionsToClass{a4paper}{scrartcl}
	\AtEndPreamble{
		\KOMAoptions{paper=a4}
		\neo@setupmargins{30}
		\areaset{19cm}{29cm}
	}
\fi

\ifneo@bookletafourmode
	\PassOptionsToClass{a5paper}{scrartcl}
	\AtEndPreamble{
		\KOMAoptions{paper=a5}
		\neo@setupmargins{last}
		\areaset{12cm}{19cm}
	}
\fi

\ifneo@bookletathreemode
	\PassOptionsToClass{a4paper}{scrartcl}
\fi

%% Load base class

\LoadClass{scrartcl}

\KOMAoptions{%
  DIV=last,
  parskip=half
}

\let\@unusedoptionlist\@empty

%% Page layout configuration

\newcommand{\neo@setupmargins}[1]{%
  \ifdim\paperwidth>\paperheight
    \KOMAoptions{%
      DIV=calc,
      DIV=14,
      BCOR=0pt,
      headinclude=true,
      footinclude=true
    }%
    \areaset{27cm}{20.5cm}
  \else
    \KOMAoptions{%
      DIV=calc,
      DIV=#1,
      BCOR=0pt,
      headinclude=true,
      footinclude=true
    }%
    \areaset{19cm}{29.25cm}
  \fi
}

% Intentionally small margins for teaching materials
\neo@setupmargins{last}
\setlength{\headheight}{27pt}
\setlength{\footskip}{27pt}

\widowpenalty=9999
\clubpenalty=9999
\displaywidowpenalty=9999

\raggedbottom

%% ==============================================================================
%% Output Options
%% ==============================================================================

\AtEndPreamble{
	\ifneo@twoupafourmode
		\usepackage{pgfmorepages}
		\pgfmorepagesloadextralayouts
		\pgfpagesuselayout{repeated 2-up}[a4paper,landscape]
		\pgfpagesphysicalpage{2}{}
		\pgfpageslogicalpageoptions{1}{
			resized width=.9\pgfphysicalwidth,
			resized height=\pgfphysicalheight,
			center=\pgfpoint{.25\pgfphysicalwidth}{.5\pgfphysicalheight}
		}
		\pgfpageslogicalpageoptions{2}{
			resized width=.9\pgfphysicalwidth,
			resized height=\pgfphysicalheight,
			center=\pgfpoint{.75\pgfphysicalwidth}{.5\pgfphysicalheight}
		}
	\fi

	\ifneo@twoupathreemode
		\usepackage{pgfmorepages}
		\pgfmorepagesloadextralayouts
		\pgfpagesuselayout{repeated 2-up}[a3paper,landscape]
		\areaset{19cm}{29cm}
		\pgfpagesphysicalpage{2}{}
		\pgfpageslogicalpageoptions{1}{
			resized width=.9\pgfphysicalwidth,
			resized height=\pgfphysicalheight,
			center=\pgfpoint{.25\pgfphysicalwidth}{.5\pgfphysicalheight}
		}
		\pgfpageslogicalpageoptions{1}{
			resized width=.9\pgfphysicalwidth,
			resized height=\pgfphysicalheight,
			center=\pgfpoint{.75\pgfphysicalwidth}{.5\pgfphysicalheight}
		}
	\fi

	\ifneo@fourupathreemode
		\usepackage{pgfmorepages}
		\pgfmorepagesloadextralayouts
		\pgfpagesuselayout{repeated 4-up}[a3paper]
		\pgfpagesphysicalpage{4}{}
		\pgfpageslogicalpageoptions{1}{
			resized width=.9\pgfphysicalwidth,
			resized height=\pgfphysicalheight,
			center=\pgfpoint{.25\pgfphysicalwidth}{.25\pgfphysicalheight}
		}
		\pgfpageslogicalpageoptions{1}{
			resized width=.9\pgfphysicalwidth,
			resized height=\pgfphysicalheight,
			center=\pgfpoint{.25\pgfphysicalwidth}{.75\pgfphysicalheight}
		}
		\pgfpageslogicalpageoptions{1}{
			resized width=.9\pgfphysicalwidth,
			resized height=\pgfphysicalheight,
			center=\pgfpoint{.75\pgfphysicalwidth}{.25\pgfphysicalheight}
		}
		\pgfpageslogicalpageoptions{1}{
			resized width=.9\pgfphysicalwidth,
			resized height=\pgfphysicalheight,
			center=\pgfpoint{.75\pgfphysicalwidth}{.75\pgfphysicalheight}
		}
	\fi

	\ifneo@simpletwoupmode
		\usepackage{pgfmorepages}
		\pgfmorepagesloadextralayouts
		\pgfpagesuselayout{2 on 1}[a3paper,landscape]
		\pgfpagesphysicalpage{2}{}
		\pgfpageslogicalpageoptions{1}{
			resized width=.9\pgfphysicalwidth,
			resized height=\pgfphysicalheight,
			center=\pgfpoint{.25\pgfphysicalwidth}{.5\pgfphysicalheight}
		}
		\pgfpageslogicalpageoptions{2}{
			resized width=.9\pgfphysicalwidth,
			resized height=\pgfphysicalheight,
			center=\pgfpoint{.75\pgfphysicalwidth}{.5\pgfphysicalheight}
		}
	\fi

	\ifneo@bookletafourmode
		\usepackage{pgfmorepages}
		\pgfmorepagesloadextralayouts
		\pgfpagesuselayout{4 on 2, book format}[a4paper,landscape]
		\pgfpagesphysicalpage{4}{}
		\pgfpageslogicalpageoptions{4}{
			resized width=.9\pgfphysicalwidth,
			resized height=\pgfphysicalheight,
			center=\pgfpoint{.25\pgfphysicalwidth}{.25\pgfphysicalheight}
		}
		\pgfpageslogicalpageoptions{1}{
			resized width=.9\pgfphysicalwidth,
			resized height=\pgfphysicalheight,
			center=\pgfpoint{.25\pgfphysicalwidth}{.75\pgfphysicalheight}
		}
		\pgfpageslogicalpageoptions{2}{
			resized width=.9\pgfphysicalwidth,
			resized height=\pgfphysicalheight,
			center=\pgfpoint{.75\pgfphysicalwidth}{.25\pgfphysicalheight}
		}
		\pgfpageslogicalpageoptions{3}{
			resized width=.9\pgfphysicalwidth,
			resized height=\pgfphysicalheight,
			center=\pgfpoint{.75\pgfphysicalwidth}{.75\pgfphysicalheight}
		}    \fi

	\ifneo@bookletathreemode
		\usepackage{pgfmorepages}
		\pgfmorepagesloadextralayouts
		\pgfpagesuselayout{4 on 2, book format}[a3paper,landscape]
		\areaset{19cm}{29.25cm}
		\setlength{\headheight}{27pt}
		\setlength{\footskip}{27pt}
		\pgfpagesphysicalpage{4}{}
		\pgfpageslogicalpageoptions{4}{
			resized width=.9\pgfphysicalwidth,
			resized height=\pgfphysicalheight,
			center=\pgfpoint{.25\pgfphysicalwidth}{.25\pgfphysicalheight}
		}
		\pgfpageslogicalpageoptions{1}{
			resized width=.9\pgfphysicalwidth,
			resized height=\pgfphysicalheight,
			center=\pgfpoint{.25\pgfphysicalwidth}{.75\pgfphysicalheight}
		}
		\pgfpageslogicalpageoptions{2}{
			resized width=.9\pgfphysicalwidth,
			resized height=\pgfphysicalheight,
			center=\pgfpoint{.75\pgfphysicalwidth}{.25\pgfphysicalheight}
		}
		\pgfpageslogicalpageoptions{3}{
			resized width=.9\pgfphysicalwidth,
			resized height=\pgfphysicalheight,
			center=\pgfpoint{.75\pgfphysicalwidth}{.75\pgfphysicalheight}
		}
	\fi
}


%% ==============================================================================
%% Vertical spacing configuration
%% ==============================================================================

\ifdim\neo@vspace@factor pt=1.0pt
  \neo@effective@beforeskip=\neo@beforeskip
  \neo@effective@afterskip=\neo@afterskip
  \neo@effective@baseskip=0.75\baselineskip
  \neo@effective@code@beforeskip=\neo@code@box@beforeskip
  \neo@effective@code@afterskip=\neo@code@box@afterskip
  \neo@effective@ad@beforeskip=\neo@ad@beforeskip
  \neo@effective@ad@afterskip=\neo@ad@afterskip
  \neo@effective@ex@beforeafterskip=0.85\neo@ex@beforeafterskip
\else
  \pgfmathsetmacro{\neo@temp@factor}{\neo@vspace@factor * 0.75}
  \neo@effective@beforeskip=\dimexpr\neo@vspace@factor\neo@beforeskip\relax
  \neo@effective@afterskip=\dimexpr\neo@vspace@factor\neo@afterskip\relax
  \neo@effective@baseskip=\dimexpr\neo@temp@factor\baselineskip\relax
  \neo@effective@code@beforeskip=\dimexpr\neo@vspace@factor\neo@code@box@beforeskip\relax
  \neo@effective@code@afterskip=\dimexpr\neo@vspace@factor\neo@code@box@afterskip\relax
  \neo@effective@ad@beforeskip=\dimexpr\neo@vspace@factor\neo@ad@beforeskip\relax
  \neo@effective@ad@afterskip=\dimexpr\neo@vspace@factor\neo@ad@afterskip\relax
  \neo@effective@ex@beforeafterskip=\dimexpr\neo@temp@factor\neo@ex@beforeafterskip\relax
\fi

%% ==============================================================================
%% Two-column mode adjustment
%% ==============================================================================

\if@twocolumn
  \setlength{\columnsep}{2em}
\fi

%% ==============================================================================
%% Indentation configuration
%% ==============================================================================

\AtEndOfPackage{%
  \ifneoschool@noindent
    \AtBeginDocument{\setlength{\parindent}{0pt}}%
  \else
    \AtBeginDocument{\setlength{\parindent}{\neoschool@indent}}%
  \fi
}

%% ==============================================================================
%% Package loading
%% ==============================================================================

%% Core packages

\RequirePackage{iftex}
\RequirePackage{xkeyval}
\RequirePackage{calc}
\RequirePackage{pdftexcmds}
\RequirePackage{environ}

% Warning suppression
\RequirePackage{silence}
\WarningFilter{latexfont}{Font shape}
\renewcommand{\@font@warning}[1]{}
\WarningFilter{multicol}{}

%% Language support

\ifLuaTeX
  \RequirePackage{fontspec}
\fi

\ifneo@french
  \RequirePackage[main=french,shorthands=off]{babel}
\else\ifneo@german
    \RequirePackage[main=german]{babel}
  \else
    \RequirePackage[main=english]{babel}
  \fi
\fi

%% Page layout packages

\RequirePackage{scrlayer-scrpage}
\expandafter\let\expandafter\innerfoot\csname ifoot\endcsname
\RequirePackage{setspace}
\RequirePackage{enumitem}
\RequirePackage{multicol}
\RequirePackage{changepage}
\RequirePackage{needspace}

%% Graphics and colors

\RequirePackage[most]{tcolorbox}
\RequirePackage{tikz}
\RequirePackage{pgfplots}
\pgfplotsset{compat=1.8}

% TikZ libraries
\usetikzlibrary{%
  backgrounds,
  calc,
  decorations.shapes,
  positioning,
  shadows,
  shapes.arrows,
  shapes.geometric,
  shapes.misc,
}

\ifneoschool@faketext
  \RequirePackage{blindtext}
  \RequirePackage{lipsum}
\fi

\RequirePackage{wrapfig}

% Additional TikZ-related packages
\RequirePackage{tikzsymbols}
\RequirePackage{tikzpagenodes}
\RequirePackage{forest}
\useforestlibrary{linguistics}

% LuaTeX specific packages
\ifLuaTeX
  \usetikzlibrary{graphs,graphdrawing,quotes,shadings}
  \usegdlibrary{circular,force,layered,routing,trees}
  \RequirePackage{luacolor}
  \RequirePackage{lua-ul}
  \RequirePackage{luacas}
\fi

%% Tables and arrays

\RequirePackage{colortbl}
\RequirePackage{tabularray}
\UseTblrLibrary{%
  amsmath,
  booktabs,
  diagbox,
  functional,
  varwidth,
  siunitx
}
\RequirePackage{adjustbox}

%% Mathematics

\RequirePackage{nccmath}

\ifneoschool@math
  \neo@loadbasearithmetictrue
\fi
\ifneo@apmep
  \neo@loadbasearithmetictrue
\fi

\ifneo@loadbasearithmetic
  \RequirePackage{mathrsfs}
  \let\mathscr\relax%
  \RequirePackage[np]{numprint}
  \RequirePackage{esvect}
  \RequirePackage{cancel}
  \ifneoschool@math
    \RequirePackage{ncccomma}
  \fi
\fi

\ifneoschool@math
  \AtEndPreamble{
    \let\Bbbk\relax
    \let\mfrac\relax
    \RequirePackage[suite,taupe]{tdsfrmath}
  }
  \let\mathscr\relax
  \RequirePackage{annotate-equations}
  \RequirePackage{witharrows}
  \RequirePackage{xlop}
  \RequirePackage{tkz-euclide}
  \RequirePackage{bm}
  \@ifpackageloaded{tkz-tab}{}{\RequirePackage{tkz-tab}}
\fi

\AtBeginDocument{
  \mathcode`\;="303B
}

%% APMEP compatibility mode

\ifneo@apmep
  \RequirePackage{textcomp}
  \RequirePackage{fourier-orns}
  \RequirePackage{tabularx}
  \RequirePackage{fancyvrb}
  \let\cfoot\relax%
  \let\chead\relax%
  \let\rfoot\relax%
  \let\rhead\relax%
  \let\lhead\relax%
  \let\lfoot\relax%
  \RequirePackage{fancyhdr}
  \RequirePackage{fancybox}
  \RequirePackage[normalem]{ulem}
  \RequirePackage{pifont}
  \RequirePackage{lscape}
  \RequirePackage{multirow}
  \RequirePackage{eucal}
  \RequirePackage{variations}
  \RequirePackage{amssymb}

  \ifPDFTeX
    \RequirePackage{auto-pst-pdf}
  \fi

  \RequirePackage{pstricks}
  \RequirePackage{pst-plot}
  \RequirePackage{pst-tree}
  \RequirePackage{pst-node}
  \RequirePackage{pst-text}
  \RequirePackage{pst-eucl}
  \RequirePackage{pst-3dplot}
  \let\pscalculate\undefined
  \RequirePackage{pst-bezier}
  \RequirePackage{pstricks-add}

  \@ifpackageloaded{tkz-tab}{}{\RequirePackage{tkz-tab}}

  \AtBeginDocument{%
    \providecommand{\euro}{\eurologo{}}
    \providecommand{\cg}{\texttt{]}}
    \providecommand{\cd}{\texttt{[}}
    \providecommand{\pg}{\geqslant}
    \providecommand{\pp}{\leqslant}
    \def\R{\ensuremath{\mathbb{R}}}
    \def\N{\ensuremath{\mathbb{N}}}
    \def\D{\ensuremath{\mathbb{D}}}
    \def\Z{\ensuremath{\mathbb{Z}}}
    \def\Q{\ensuremath{\mathbb{Q}}}
    \def\C{\ensuremath{\mathbb{C}}}
    \def\e{\ensuremath{\mathrm{e}}}
    \providecommand{\Ci}{\ensuremath{\mathrm{i}}}
    \providecommand{\i}{\ensuremath{\mathrm{i}}}
    \providecommand{\d}{\,\text{d}}
    \providecommand{\dd}{\,\text{d}}
    \providecommand{\dx}{\,\text{d}x}
    \providecommand{\I}{\ensuremath{\mathit{I}}}
    \providecommand{\transformation}{\ensuremath{\mathit{S}}}
    \def\vect#1{\overrightarrow{\,\mathstrut#1\,}}
    \DeclareRobustCommand{\vectt}[1]{\overrightarrow{\,\mathstrut\text{#1}\,}}
    \DeclareRobustCommand{\barre}[1]{\overline{\,\mathstrut#1\,}}
    \providecommand{\ps}[2]{\vect{#1}\cdot \vect{#2}}
    \def\Oij{$\left(\text{O}~;~\vect{\imath},~\vect{\jmath}\right)$}
    \def\Oijk{$\left(\text{O}~;~\vect{\imath},~\vect{\jmath},~\vect{k}\right)$}
    \def\Ouv{$\left(\text{O}~;~\vect{u},~\vect{v}\right)$}
    \providecommand{\vectco}[2]{$\left(\begin{array}{c} #1\\ #2 \end{array}\right)$}
    \providecommand{\vectcol}[3]{$\left(\begin{array}{c} #1\\ #2\\ #3 \end{array}\right)$}
    \def\V#1{\overrightarrow{\textrm{#1}}}
    \providecommand{\ei}[1]{\e^{\i #1}}
    \providecommand{\ein}[1]{\e^{-\i #1}}
    \providecommand{\IM}{\mathrm{i}}
    \providecommand{\cf}{$\mathcal{C}_f$ }
    \providecommand{\cg}{$\mathcal{C}_g$ }
    \providecommand{\dr}{$\mathcal{D}\;$}
    \providecommand{\deprim}{$\mathcal{D'}\;$}
    \providecommand{\ex}{\e^x}
    \providecommand{\defi}{\textbf{Définition : }}
    \providecommand{\prop}{\textbf{Propriété : }}
    \providecommand{\teo}{\textbf{Théorème : }}
    \providecommand{\demo}{\textbf{Démonstration : }}
    \providecommand{\exemp}{\textbf{Exemple : }}
    \newcolumntype{Y}{>{\centering\arraybackslash}X}
    \newcounter{exoBac} \setcounter{exoBac}{1}
    \providecommand{\titreExe}[2][]{%
      \vspace{0.5cm}\par
      \textbf{\textsc{Exercice} \theexoBac{} #1 \hfill #2 points} \par
      \medskip
      \stepcounter{exoBac}%
    }
    \newcounter{partieBac}[exoBac]
    \providecommand{\partieBac}[1]{%
      \stepcounter{partieBac}%
      \vspace{0.25cm}\par
      \textbf{PARTIE \Alph{partieBac} \quad #1}\par
      \medskip
    }
    \DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
    \DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
    \DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
    \DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
    \DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
  }
\fi

%% French math mode

\ifneo@frenchmath
  \DeclareMathSymbol{A}{\mathalpha}{operators}{65}
  \DeclareMathSymbol{B}{\mathalpha}{operators}{66}
  \DeclareMathSymbol{C}{\mathalpha}{operators}{67}
  \DeclareMathSymbol{D}{\mathalpha}{operators}{68}
  \DeclareMathSymbol{E}{\mathalpha}{operators}{69}
  \DeclareMathSymbol{F}{\mathalpha}{operators}{70}
  \DeclareMathSymbol{G}{\mathalpha}{operators}{71}
  \DeclareMathSymbol{H}{\mathalpha}{operators}{72}
  \DeclareMathSymbol{I}{\mathalpha}{operators}{73}
  \DeclareMathSymbol{J}{\mathalpha}{operators}{74}
  \DeclareMathSymbol{K}{\mathalpha}{operators}{75}
  \DeclareMathSymbol{L}{\mathalpha}{operators}{76}
  \DeclareMathSymbol{M}{\mathalpha}{operators}{77}
  \DeclareMathSymbol{N}{\mathalpha}{operators}{78}
  \DeclareMathSymbol{O}{\mathalpha}{operators}{79}
  \DeclareMathSymbol{P}{\mathalpha}{operators}{80}
  \DeclareMathSymbol{Q}{\mathalpha}{operators}{81}
  \DeclareMathSymbol{R}{\mathalpha}{operators}{82}
  \DeclareMathSymbol{S}{\mathalpha}{operators}{83}
  \DeclareMathSymbol{T}{\mathalpha}{operators}{84}
  \DeclareMathSymbol{U}{\mathalpha}{operators}{85}
  \DeclareMathSymbol{V}{\mathalpha}{operators}{86}
  \DeclareMathSymbol{W}{\mathalpha}{operators}{87}
  \DeclareMathSymbol{X}{\mathalpha}{operators}{88}
  \DeclareMathSymbol{Y}{\mathalpha}{operators}{89}
  \DeclareMathSymbol{Z}{\mathalpha}{operators}{90}
  \let\alpha\alphaup
  \let\beta\betaup
  \let\gamma\gammaup
  \let\delta\deltaup
  \let\epsilon\epsilonup
  \let\zeta\zetaup
  \let\eta\etaup
  \let\theta\thetaup
  \let\iota\iotaup
  \let\kappa\kappaup
  \let\lambda\lambdaup
  \let\mu\muup
  \let\nu\nuup
  \let\xi\xiup
  \let\pi\piup
  \let\rho\rhoup
  \let\sigma\sigmaup
  \let\tau\tauup
  \let\upsilon\upsilonup
  \let\phi\phiup
  \let\chi\chiup
  \let\psi\psiup
  \let\omega\omegaup
\fi

%% Computer algebra system support

\ifneo@mathics
  \RequirePackage[mathics]{latexalpha2}
  \RequirePackage{asymptote}
\fi

%% Lists and utilities

\RequirePackage{tasks}
\RequirePackage{cuted}
\RequirePackage{qrcode}
\RequirePackage{xhfill}
\RequirePackage{fontawesome5}
\RequirePackage{pifont}
\RequirePackage{adforn}

\RequirePackage[%
  \neo@lang,
  textsize=small
]{todonotes}

\RequirePackage{marginnote}
\RequirePackage{algpseudocode}
\RequirePackage[use-files,clear-aux]{xsim}
\RequirePackage[normalem]{ulem}

%% Microtype and hyperref

\AtEndOfClass{
  \let\CheckCommand\providecommand
  \RequirePackage{microtype}
}

\RequirePackage{bookmark}
\RequirePackage{lastpage}

\hypersetup{%
  colorlinks=true,
  linkcolor=neo@linkcolor,
  urlcolor=neo@urlcolor,
  citecolor=neo@citecolor,
  filecolor=neo@filecolor,
  menucolor=neo@linkcolor,
  runcolor=neo@filecolor,
  bookmarksnumbered=true,
  bookmarksopen=true,
  bookmarksopenlevel=2,
  pdfstartview={FitH},
  pdfdisplaydoctitle=true,
  pdfpagemode=UseOutlines,
  pdfpagelayout=OneColumn,
  pdfborder={0 0 0},
  breaklinks=true,
  hypertexnames=false,
}

%% ==============================================================================
%% Font configuration
%% ==============================================================================

% Font variable definitions
\edef\mainface{\expandonce{\neoschool@mainface}}
\edef\sansface{\expandonce{\neoschool@sansface}}
\edef\monoface{\expandonce{\neoschool@monoface}}
\edef\mathface{\expandonce{\neoschool@mathface}}
\edef\facefamily{\expandonce{\neoschool@facefamily}}

\ifPDFTeX
  \RequirePackage[utf8]{inputenc}
  \RequirePackage[T1]{fontenc}

  \IfStrEq{\facefamily}{}{%
    \IfStrEq{\mathface}{}{%
      \ifneo@mathastext
        \RequirePackage[italic,eulergreek]{mathastext}%
      \else
        \RequirePackage{newpxmath}%
      \fi
    }{%
      \RequirePackage[\neoschool@mathfaceoptions]{\neoschool@mathface}%
    }%

    \IfStrEq{\mainface}{}{%
      \RequirePackage{newpxtext}%
    }{%
      \RequirePackage[\neoschool@mainfaceoptions]{\neoschool@mainface}%
    }%

    \IfStrEq{\sansface}{}{}{%
      \RequirePackage[\neoschool@sansfaceoptions]{\neoschool@sansface}%
    }%
    \IfStrEq{\monoface}{}{}{%
      \RequirePackage[\neoschool@monofaceoptions]{\neoschool@monoface}%
    }%
  }{%
    \RequirePackage[\neoschool@facefamilyoptions]{\neoschool@facefamily}%
  }

\else
  \ifXeTeX
    \RequirePackage{fontspec}

    \ifneo@scale
      \defaultfontfeatures[\rmfamily]{Scale=1}
      \defaultfontfeatures{Scale=MatchLowercase}
    \fi

    \defaultfontfeatures{Ligatures=TeX}

    \IfStrEq{\mathface}{}{%
      \ifneo@mathastext
        \RequirePackage[italic,eulergreek]{mathastext}%
      \else
        \IfFileExists{texgyrepagella-math.otf}{%
          \setmathfont{texgyrepagella-math.otf}%
        }{%
          \RequirePackage{newpxmath}%
        }%
      \fi
    }{%
      \RequirePackage{unicode-math}
      \IfStrEq{\neoschool@mathfaceoptions}{}{%
        \setmathfont{\mathface}%
      }{%
        \setmathfont[\neoschool@mathfaceoptions]{\mathface}%
      }%
    }

    \IfStrEq{\mainface}{}{%
      \IfFileExists{texgyrepagella-regular.otf}{%
        \setmainfont{texgyrepagella-regular.otf}[
        BoldFont=texgyrepagella-bold.otf,
        ItalicFont=texgyrepagella-italic.otf,
        BoldItalicFont=texgyrepagella-bolditalic.otf
        ]%
      }{%
        \RequirePackage{newpxtext}%
      }%
    }{%
      \setmainfont[\neoschool@mainfaceoptions, Scale=\neoschool@mainfacescale]{\neoschool@mainface}%
    }

    \IfStrEq{\sansface}{}{%
      \IfFileExists{texgyreheros-regular.otf}{%
        \setsansfont{texgyreheros-regular.otf}[
        BoldFont=texgyreheros-bold.otf,
        ItalicFont=texgyreheros-italic.otf,
        BoldItalicFont=texgyreheros-bolditalic.otf
        ]%
      }{%
        \setsansfont[Scale=0.92]{Helvetica}%
      }%
    }{%
      \setsansfont[\neoschool@sansfaceoptions, Scale=\neoschool@sansfacescale]{\neoschool@sansface}%
    }

    \IfStrEq{\monoface}{}{%
      \IfFileExists{texgyrecursor-regular.otf}{%
        \setmonofont{texgyrecursor-regular.otf}[
        BoldFont=texgyrecursor-bold.otf,
        ItalicFont=texgyrecursor-italic.otf,
        BoldItalicFont=texgyrecursor-bolditalic.otf
        ]%
      }{%
        \RequirePackage{newpxtext}%
      }%
    }{%
      \setmonofont[\neoschool@monofaceoptions, Scale=\neoschool@monofacescale]{\neoschool@monoface}%
    }

  \else
    \ifLuaTeX
      \RequirePackage{fontspec}

      \ifneo@scale
        \defaultfontfeatures[\rmfamily]{Scale=1}
        \defaultfontfeatures{Scale=MatchLowercase}
      \fi

      \defaultfontfeatures{Ligatures=TeX,Renderer=HarfBuzz}

      \IfStrEq{\mathface}{}{%
        \ifneo@mathastext
          \RequirePackage[italic,eulergreeks]{mathastext}%
        \else
          \RequirePackage{newpxmath}%
        \fi
      }{%
        \RequirePackage{unicode-math}
        \IfStrEq{\neoschool@mathfaceoptions}{}{%
          \setmathfont{\mathface}%
        }{%
          \setmathfont[\neoschool@mathfaceoptions]{\mathface}%
        }%
      }

      \IfStrEq{\mainface}{}{%
        \setmainfont{TeX Gyre Pagella}%
      }{%
        \setmainfont[\neoschool@mainfaceoptions, Scale=\neoschool@mainfacescale]{\neoschool@mainface}%
      }

      \IfStrEq{\sansface}{}{%
        \setsansfont[Scale=0.94]{TeX Gyre Heros}%
      }{%
        \setsansfont[\neoschool@sansfaceoptions, Scale=\neoschool@sansfacescale]{\neoschool@sansface}%
      }

      \IfStrEq{\monoface}{}{%
        \setmonofont[Scale=1.05]{Latin Modern Mono}%
      }{%
        \setmonofont[\neoschool@monofaceoptions, Scale=\neoschool@monofacescale]{\neoschool@monoface}%
      }

    \fi
  \fi
\fi

% SemiBold Weight
\ifPDFTeX
  \providecommand{\sbseries}{\bfseries}
  \providecommand{\textsb}[1]{\textbf{#1}}
\else
  \AtEndPreamble{%
    \newcommand{\neo@configure@semibold}[2]{%
      \ifx#1\@empty\else
        \def\neo@temp@extra{}%
        \IfFontExistsTF{#1 SemiBold}{%
          \edef\neo@temp@extra{FontFace={sb}{n}{* SemiBold}}%
        }{}%
        \IfFontExistsTF{#1 SemiBold Italic}{%
          \ifx\neo@temp@extra\@empty\else\appto\neo@temp@extra{,}\fi
          \appto\neo@temp@extra{FontFace={sb}{it}{* SemiBold Italic}}%
        }{}%
        \ifx\neo@temp@extra\@empty\else
          \csname set#2font\endcsname{#1}[\csname neoschool@#2faceoptions\endcsname,\neo@temp@extra]%
        \fi
      \fi
    }

    \neo@configure@semibold{\neoschool@mainface}{main}
    \neo@configure@semibold{\neoschool@sansface}{sans}
    \neo@configure@semibold{\neoschool@monoface}{mono}
  }

  \def\sb@code{sb}

  \DeclareRobustCommand\sbseries{%
    \not@math@alphabet\sbseries\relax
    \begingroup
    \def\@font@warning##1{}%
    \fontseries{sb}\selectfont
    \xdef\temp{\f@series}%
    \endgroup
    \ifx\temp\sb@code
      \fontseries{sb}\selectfont
    \fi
  }

  \DeclareTextFontCommand{\textsb}{\sbseries}
\fi

% Common configuration
\ifneo@sfbody
  \renewcommand{\familydefault}{\sfdefault}
\fi

%% ==============================================================================
%% Monospace Text
%% ==============================================================================

\newcommand{\neo@ifmathmode}[2]{%
  \relax\ifmmode #1\else #2\fi
}

\AtEndOfClass{%
  \let\neo@originaltexttt\texttt
  \ifneoschool@inlinecodebox
    \ifneo@darktheme
      \colorlet{inlineCodeBg}{verbColor!20!white!10!black}
      \colorlet{inlineCodeFrame}{verbColor!50!white}
    \else
      \colorlet{inlineCodeBg}{verbColor!6!white}
      \colorlet{inlineCodeFrame}{verbColor!30!white}
    \fi
    \tcbset{
      neoinlinecodestyle/.style={
        enhanced,
        arc=2pt,
        boxsep=0pt,
        top=2pt,
        bottom=2.5pt,
        left=3pt,
        right=3pt,
        colback=inlineCodeBg,
        colframe=inlineCodeFrame,
        boxrule=\neo@thinrule,
        nobeforeafter,
        tcbox raise base,
      }
    }
    \renewrobustcmd{\texttt}[1]{%
      \neo@ifmathmode{%
        \mathtt{#1}%
      }{%
        \tcbox[neoinlinecodestyle]{%
          \ttfamily
          \hyphenchar\font=`\-%
          \color{verbColor}\scalebox{0.92}{#1}%
        }%
      }%
    }%
  \else
    \renewrobustcmd{\texttt}[1]{%
      \neo@ifmathmode{%
        \mathtt{#1}%
      }{%
        \begingroup
        \ttfamily
        \hyphenchar\font=`\-%
        \color{verbColor}#1%
        \endgroup
      }%
    }%
  \fi
}

%% ==============================================================================
%% KOMA-Script Typography
%% ==============================================================================

% Title Content Formatter
\newcommand{\neo@title@style}{%
  \csname\neoschool@headweight\endcsname\csname\neoschool@headstyle\endcsname\csname\neoschool@headshape\endcsname%
}
\newcommand{\neo@title@other@style}{%
  \csname\neoschool@headweight\endcsname\csname\neoschool@headstyle\endcsname%
}

\newcommand{\LARGEminus}{\fontsize{14.5}{17.1}\selectfont}
\newcommand{\LARGEplus}{\fontsize{15.5}{18.6}\selectfont}
\newcommand{\LARGEhuge}{\fontsize{16.74}{20.09}\selectfont}
\newcommand{\hugeminus}{\fontsize{18.5}{22.2}\selectfont}

\setkomafont{disposition}{\mdseries}

% Header style configuration
\setkomafont{title}{\csname\neoschool@titlestyle\endcsname\csname\neoschool@titleweight\endcsname\color{titleColor}\csname\neoschool@titlesize\endcsname}

\def\neo@subtitle@weight{\ifneo@print\else\csname\neoschool@titleweight\endcsname\fi}

\setkomafont{subtitle}{\csname\neoschool@headstyle\endcsname\csname\neoschool@headshape\endcsname\neo@subtitle@weight\color{subtitleColor}\large}
\setkomafont{subject}{\color{subjectColor}}
\setkomafont{author}{\color{subjectColor}}
\setkomafont{date}{\large}
\setkomafont{subsection}{\neo@title@other@style\color{subsectionColor}\large}
\setkomafont{subsubsection}{\neo@title@other@style\color{subsubsectionColor}}
\setkomafont{pagenumber}{\csname\neoschool@headstyle\endcsname\color{\neoschool@headfootcolor}}
\setkomafont{descriptionlabel}{\neo@title@style}

% Page number format
\renewcommand*\pagemark{%
  {\usekomafont{pagenumber}
    \color{\neoschool@headfootcolor}
    \csname neo@pagename\endcsname\nobreakspace\thepage\nobreakspace/\nobreakspace
    {\hypersetup{linkcolor=\neoschool@headfootcolor}\pageref{LastPage}}
  }
}

\newpairofpagestyles{firstpage}{%
  \ihead{}\chead{}\ohead{}%
  \innerfoot{\@date}\cfoot{}\ofoot{\pagemark}%
  \KOMAoptions{headsepline=0pt}%
}

% Short title support
\newcommand{\shorttitle}[1]{\gdef\@shorttitle{#1}}
\let\@shorttitle\@empty

\newcommand{\neo@displaytitle}{%
  \ifx\@shorttitle\@empty
    \StrLen{\@title}[\titlelength]%
    \ifnum\titlelength>85
      \StrMid{\@title}{1}{85}[\truncatedtitle]%
      \truncatedtitle\ldots
    \else
      \@title
    \fi
  \else
    \@shorttitle
  \fi
}

\newpairofpagestyles{followingpages}{%
  \ihead{}\chead{}\ohead{}%
  \innerfoot{\neo@displaytitle}\cfoot{}\ofoot{\pagemark}%
}

\newpairofpagestyles{pagenum}{%
  \ihead{}\chead{}\ohead{}%
  \innerfoot{}\cfoot{\pagemark}\ofoot{}%
  \KOMAoptions{headsepline=0pt,footsepline=0pt}%
}

% Header font configuration
\renewcommand*{\headfont}{%
  \small
  \csname\neoschool@headfootstyle\endcsname
  \color{\neoschool@headfootcolor}
}

%% ==============================================================================
%% Title Styles and Setting
%% ==============================================================================

\newcommand{\neo@checktitlelayout}{%
  \let\neo@layoutexec\createfulltitle
  \IfStrEq{\neoschool@titlelayout}{exam}{\let\neo@layoutexec\neo@examcontent}{}%
  \IfStrEq{\neoschool@titlelayout}{eval}{\let\neo@layoutexec\neo@evaltitlecontent}{}%
  \IfStrEq{\neoschool@titlelayout}{evalicons}{\let\neo@layoutexec\neo@evaliconscontent}{}%
  \IfStrEq{\neoschool@titlelayout}{evalgrade}{\let\neo@layoutexec\neo@evalgradecontent}{}%
  \IfStrEq{\neoschool@titlelayout}{evaliconsgrade}{\let\neo@layoutexec\neo@evaliconsgradecontent}{}%
  \IfStrEq{\neoschool@titlelayout}{titlebox}{\let\neo@layoutexec\neo@titleboxcontent}{}%
  \IfStrEq{\neoschool@titlelayout}{tighttitle}{\let\neo@layoutexec\neo@tighttitlecontent}{}%
  \IfStrEq{\neoschool@titlelayout}{onlytitle}{\let\neo@layoutexec\neo@onlytitle@content}{}%
  \IfStrEq{\neoschool@titlelayout}{bubbles}{\let\neo@layoutexec\neo@bubblescontent}{}%
  \IfStrEq{\neoschool@titlelayout}{geometric}{\let\neo@layoutexec\neo@geometriccontent}{}%
  \IfStrEq{\neoschool@titlelayout}{banner}{\let\neo@layoutexec\neo@bannercontent}{}%
  \IfStrEq{\neoschool@titlelayout}{topbubbles}{\let\neo@layoutexec\neo@topbubblescontent}{}%
  \IfStrEq{\neoschool@titlelayout}{bottombubbles}{\let\neo@layoutexec\neo@bottombubblescontent}{}%
  \IfStrEq{\neoschool@titlelayout}{mockexam}{\let\neo@layoutexec\neo@mockexamcontent}{}%
  \IfStrEq{\neoschool@titlelayout}{shortexam}{\let\neo@layoutexec\neo@shortexamcontent}{}%
  \IfStrEq{\neoschool@titlelayout}{shorteval}{\let\neo@layoutexec\neo@shortevalcontent}{}%
  \IfStrEq{\neoschool@titlelayout}{shorttitle}{\let\neo@layoutexec\neo@shorttitlecontent}{}%
  \IfStrEq{\neoschool@titlelayout}{shortlesson}{\let\neo@layoutexec\neo@shortlessoncontent}{}%
  \neo@layoutexec
}

% Core definitions and lengths
\def\neo@left{left}
\def\neo@right{right}
\def\neo@center{center}

\newlength{\varspace}
\newlength{\titlespacing}
\setlength{\titlespacing}{\baselineskip}
\newcommand\myscaleratio{0.5}

% Define tight spacing commands
\newcommand{\neo@tightspacing}{%
  \setlength{\topsep}{0pt}
  \setlength{\parskip}{0pt}
}

% Redefine center, flushright, and flushleft environments with tight spacing
\let\oldcenter\center
\let\oldendcenter\endcenter

\newenvironment{neo@titlecenter}{%
  \neo@tightspacing
  \oldcenter
}{%
  \oldendcenter
}

\let\oldflushright\flushright
\let\oldendflushright\endflushright
\newenvironment{neo@flushright}{%
  \neo@tightspacing
  \oldflushright
}{%
  \oldendflushright
}

\let\oldflushleft\flushleft
\let\oldendflushleft\endflushleft
\newenvironment{neo@flushleft}{%
  \neo@tightspacing
  \oldflushleft
}{%
  \oldendflushleft
}

% Title decoration handler
\ExplSyntaxOn
\newcommand{\neo@titledecoration}{%
  \str_case:VnF \neoschool@titledecor
  {
    {rule} { \vspace{2\titlespacing}%
      {\color{titleColor}\rule{0.33\linewidth}{\neo@decorativerule}}}
    {midrule} { \vspace{2\titlespacing}%
      {\color{titleColor}\rule{0.5\linewidth}{\neo@decorativerule}}}
    {fullrule} { \vspace{2\titlespacing}%
      {\color{titleColor}\rule{0.66\linewidth}{\neo@decorativerule}}}
    {ornament} { \vspace{2\titlespacing}%
      {\color{titleColor}\scalebox{2}[1.5]{\adforn{21}\,\adforn{11}\,\adforn{49}}}}
    {none} { }
  }
  { \PackageWarning{neoschool}{Unknown titledecor style '\neoschool@titledecor'. Using none.} }
}
\ExplSyntaxOff

\let\@subject\@empty
\let\@title\@empty
\let\@subtitle\@empty
\let\@author\@empty

% Full title creation with all elements
\newcommand{\createfulltitle}{%
  % Subject
  \ifx\@subject\@empty\else
    {\usekomafont{subject}{\@subject\par}}
    \vspace{\titlespacing}
  \fi

  % Main title
  {\noindent\usekomafont{title}{\@title\par}}

  % Subtitle
  \ifx\@subtitle\@empty\else
    \vspace{\titlespacing}
    {\noindent\usekomafont{subtitle}{\@subtitle\par}}
  \fi

  % Author
  \ifx\@author\@empty
  \else
    \ifx\@subtitle\@empty
      \vspace{1.25\titlespacing}
    \else
      \vspace{1.5\titlespacing}
    \fi
    {\noindent\usekomafont{author}{\@author\par}}%
  \fi

  % Decorative elements
  \neo@titledecoration
  \if@twocolumn\vspace{2.5\titlespacing}\else\vspace{1.5\titlespacing}\fi
}

% Only title creation (no author, subject, etc.)
\newcommand{\createonlytitle}{%
  {\usekomafont{title}{\csname\neoschool@titlesize\endcsname\@title\par}}
  \neo@titledecoration%
}

\renewcommand\maketitle{%
  \thispagestyle{firstpage}
  \IfStrEq{\neoschool@titlelayout}{onlytitle}{%
    \neo@handleonlytitle
    {\neo@onlytitle@content}
    {\neo@onlytitle@content}
  }{%
    \begingroup
    \setlength{\varspace}{\dimexpr\titlespacing+\myscaleratio\oddsidemargin}
    \if@twocolumn
      \twocolumn[{%
        \begingroup
        \ifx\neoschool@titlealign\neo@left
          \begin{neo@titleflushleft}
            \neo@checktitlelayout
          \end{neo@titleflushleft}
        \else
          \ifx\neoschool@titlealign\neo@right
            \noindent\raggedleft
            \neo@checktitlelayout
            \par
          \else
            \begin{neo@titlecenter}
              \neo@checktitlelayout
            \end{neo@titlecenter}
          \fi
        \fi
        \endgroup
      }]
    \else
      \begingroup
      \ifx\neoschool@titlealign\neo@left
        \begin{neo@titleflushleft}
          \noindent\neo@checktitlelayout
        \end{neo@titleflushleft}
      \else
        \ifx\neoschool@titlealign\neo@right
          \noindent\raggedleft
          \neo@checktitlelayout
          \par
        \else
          \begin{neo@titlecenter}
            \neo@checktitlelayout
          \end{neo@titlecenter}
        \fi
      \fi
      \endgroup
    \fi
    \endgroup
  }%
}

% Title box
\newcommand{\neo@titleboxcontent}{%
  \newcommand{\neo@fancycolor}{exerciseColor!10!white}
  \begin{tikzpicture}[remember picture,overlay]
    \def\titleanchor{west}
    \def\titlebasepos{current page text area.north west}
    \def\titlexshift{1ex}
    \def\subtitlepos{title.south west}
    \def\subjectpos{title.north west}

    \ifx\neoschool@titlealign\neo@center
      \def\titleanchor{center}
      \def\titlebasepos{current page text area.north}
      \def\titlexshift{0ex}
      \def\subtitlepos{title.south}
      \def\subjectpos{title.north}
    \fi
    \ifx\neoschool@titlealign\neo@right
      \def\titleanchor{east}
      \def\titlebasepos{current page text area.north east}
      \def\titlexshift{-1ex}
      \def\subtitlepos{title.south east}
      \def\subjectpos{title.north east}
    \fi
    \ifx\@subject\@empty
      \def\startYshift{\dimexpr-2ex+0.25cm\relax}
    \else
      \def\startYshift{\dimexpr-5.5ex+0.25cm\relax}
    \fi

    \node[anchor=\titleanchor, opacity=0] (title) at
    ($([xshift=\titlexshift,yshift=\startYshift]\titlebasepos)$)
    {\LARGE\csname\neoschool@titlestyle\endcsname
      \csname\neoschool@titleweight\endcsname
      \csname\neoschool@titleshape\endcsname
      \@title};
    \ifx\@subtitle\@empty\else
      \node[below=5mm of \subtitlepos, anchor=\titleanchor, opacity=0] (subtitle)
      {\usekomafont{subtitle}\large\@subtitle};
    \fi
    \ifx\@subject\@empty\else
      \node[above=5mm of \subjectpos, anchor=\titleanchor, opacity=0] (subject)
      {\usekomafont{subject}\large\@subject};
    \fi

    \coordinate (boxtop) at (title.north);
    \coordinate (boxbottom) at (title.south);
    \ifx\@subject\@empty\else
      \coordinate (boxtop) at (subject.north);
    \fi
    \ifx\@subtitle\@empty\else
      \coordinate (boxbottom) at (subtitle.south);
    \fi

    \def\boxpaddingH{0cm}
    \def\boxpaddingTop{0.5cm}
    \def\boxpaddingBottom{0.5cm}
    \fill[\neo@fancycolor]
    ($(current page text area.north west)!(boxtop)!(current page text area.south west) + (-\boxpaddingH, \boxpaddingTop)$) -|
    ($(current page text area.north east)!(boxtop)!(current page text area.south east) + (\boxpaddingH, \boxpaddingTop)$) |-
    ($(current page text area.north east)!(boxbottom)!(current page text area.south east) + (\boxpaddingH, -\boxpaddingBottom)$) -|
    ($(current page text area.north west)!(boxbottom)!(current page text area.south west) + (-\boxpaddingH, -\boxpaddingBottom)$) |- cycle;

    \node[anchor=\titleanchor] at
    ($([xshift=\titlexshift,yshift=\startYshift]\titlebasepos)$)
    {\LARGE\csname\neoschool@titlestyle\endcsname
      \csname\neoschool@titleweight\endcsname
      \csname\neoschool@titleshape\endcsname
      \color{titleColor}\@title};
    \ifx\@subtitle\@empty\else
      \node[below=5mm of \subtitlepos, anchor=\titleanchor]
      {\usekomafont{subtitle}\large\@subtitle};
    \fi
    \ifx\@subject\@empty\else
      \node[above=5mm of \subjectpos, anchor=\titleanchor]
      {\usekomafont{subject}\large\@subject};
    \fi
  \end{tikzpicture}
  \ifx\@subject\@empty
    \ifx\@subtitle\@empty
      \def\vspaceadjust{-1cm}
    \else
      \def\vspaceadjust{-0.15cm}
    \fi
  \else
    \ifx\@subtitle\@empty
      \def\vspaceadjust{-0.25cm}
    \else
      \def\vspaceadjust{0.5cm}
    \fi
  \fi
  \neo@top@compensate%
  \if@twocolumn\vspace*{\dimexpr1.5in+\oddsidemargin+\vspaceadjust\relax}\par%
  \else\vspace*{\dimexpr1.25in+\oddsidemargin+\vspaceadjust\relax}\par\fi
}


% Tight Title
\def\stringleft{left}
\def\stringcenter{center}
\def\stringright{right}

% Tight Title
\newlength{\neoTitleHeight}
\newcommand{\neo@tighttitlecontent}{%
  \begin{tikzpicture}[remember picture, overlay]
    \def\titleanchor{west}
    \def\titlebasepos{current page text area.north west}
    \def\titlexshift{-1ex}
    \def\subtitlepos{title.south west}
    \def\subjectpos{title.north west}

    \ifx\neoschool@titlealign\neo@center
      \def\titleanchor{center}
      \def\titlebasepos{current page text area.north}
      \def\titlexshift{0ex}
      \def\subtitlepos{title.south}
      \def\subjectpos{title.north}
    \fi
    \ifx\neoschool@titlealign\neo@right
      \def\titleanchor{east}
      \def\titlebasepos{current page text area.north east}
      \def\titlexshift{1ex}
      \def\subtitlepos{title.south east}
      \def\subjectpos{title.north east}
    \fi

    \ifx\@subject\@empty
      \def\startYshift{0cm}
    \else
      \def\startYshift{-0.5cm}
    \fi

    \node[anchor=\titleanchor] (title) at
    ($([xshift=\titlexshift,yshift=\startYshift]\titlebasepos)$)
    {%
      \csname\neoschool@titlesize\endcsname
      \csname\neoschool@titlestyle\endcsname
      \csname\neoschool@titleweight\endcsname
      \csname\neoschool@titleshape\endcsname
      \color{titleColor}\@title%
    };

    \ifx\@subject\@empty\else
      \node[above=4.5mm of \subjectpos, anchor=\titleanchor] (subject)
      {\usekomafont{subject}\@subject};
    \fi

    \ifx\@subtitle\@empty
      \coordinate (lowestPoint) at (title.south);
    \else
      \node[below=5mm of \subtitlepos, anchor=\titleanchor] (subtitle)
      {\usekomafont{subtitle}\@subtitle};
      \coordinate (lowestPoint) at (subtitle.south);
    \fi

    \path let \p1 = (current page text area.north),
    \p2 = (lowestPoint)
    in \pgfextra{
      \global\neoTitleHeight=\dimexpr\y1-\y2\relax
    };
  \end{tikzpicture}

  \neo@top@compensate%

  \def\neo@geo@offset{1in + \topmargin + \headheight + \headsep}

  \if@twocolumn
    \vspace*{\dimexpr\neoTitleHeight - 2.25\baselineskip + \neo@geo@offset\relax}
  \else
    \vspace*{\dimexpr\neoTitleHeight - 4\baselineskip + \neo@geo@offset\relax}
  \fi

  \par
}

\newcommand{\neo@handleonlytitle}[2]{%
  \if@twocolumn
    \AfterEndPreamble{%
      \twocolumn[{#1\vspace*{.5in}\par}]
    }
  \else
    \AtBeginDocument{%
      #2\vspace*{0.25in}\par
    }
  \fi
  \let\maketitle\relax
  \thispagestyle{firstpage}
}

\newcommand{\neo@onlytitle@content}{%
  \IfStrEq{\neoschool@titlealign}{center}{%
    \begin{neo@titlecenter}\createonlytitle\end{neo@titlecenter}%
  }{%
    \IfStrEq{\neoschool@titlealign}{right}{%
      \begin{neo@flushright}\createonlytitle\end{neo@flushright}%
    }{%
      \begin{neo@flushleft}\createonlytitle\end{neo@flushleft}%
    }%
  }%
}

%%   ==============================================================================
%%   Table of Contents
%%   ==============================================================================

\addto\captionsfrench{\renewcommand{\contentsname}{Sommaire}}

\ifneo@monotoc
  \colorlet{tocTitleColor}{titleColor}
  \colorlet{tocSectionColor}{titleColor}
  \colorlet{tocSubsectionColor}{titleColor}
  \colorlet{tocSubsubsectionColor}{titleColor}
\else
  \colorlet{tocTitleColor}{titleColor}
  \colorlet{tocSectionColor}{sectionColor}
  \colorlet{tocSubsectionColor}{subsectionColor}
  \colorlet{tocSubsubsectionColor}{subsubsectionColor}
\fi

\AtBeginDocument{
  \addtocontents{toc}{%
    \protect\hypersetup{%
      linktoc=all,%
      hidelinks%
    }%
    \ifneo@compacttoc
      \protect\setlength{\protect\itemsep}{0pt}%
      \protect\setlength{\protect\parskip}{0pt}%
    \fi
  }
}

\DeclareTOCStyleEntry[
entryformat={\sffamily\bfseries\color{tocSectionColor}},
pagenumberformat={\sffamily\bfseries\color{tocSectionColor}},
indent=0em,
numwidth=2em
]{tocline}{section}

\DeclareTOCStyleEntry[
entryformat={\sffamily\color{tocSubsectionColor}},
pagenumberformat={\sffamily\color{tocSubsectionColor}},
indent=2em,
numwidth=2.5em
]{tocline}{subsection}

\DeclareTOCStyleEntry[
entryformat={\sffamily\small\color{tocSubsubsectionColor}},
pagenumberformat={\sffamily\small\color{tocSubsubsectionColor}},
indent=4em,
numwidth=3em
]{tocline}{subsubsection}

\RedeclareSectionCommand[
tocindent=0em,
tocnumwidth=2em
]{section}

\RedeclareSectionCommand[
tocindent=2em,
tocnumwidth=2.5em
]{subsection}

\RedeclareSectionCommand[
tocindent=4em,
tocnumwidth=3em
]{subsubsection}

\ifx\neoschool@titlealign\neo@left
  \renewcommand*\tableofcontents{%
    \section*{\raggedright\contentsname}
    \@starttoc{toc}%
  }
\else\ifx\neoschool@titlealign\neo@right
    \renewcommand*\tableofcontents{%
      \section*{\raggedleft\contentsname}
      \@starttoc{toc}%
    }
  \else
    \renewcommand*\tableofcontents{%
      \section*{\centering\contentsname}
      \@starttoc{toc}%
    }
  \fi
\fi

\ifneo@twocolumntoc
  \renewcommand*\tableofcontents{%
    \ifx\neoschool@titlealign\neo@left
      \section*{\raggedright\contentsname}
    \else\ifx\neoschool@titlealign\neo@right
        \section*{\raggedleft\contentsname}
      \else
        \section*{\centering\contentsname}
      \fi\fi

    \begin{multicols}{2}
      \@starttoc{toc}%
    \end{multicols}
  }
\fi

%% ==============================================================================
%% Abstract formatting
%% ==============================================================================

\if@twocolumn
  \renewenvironment{abstract}{%
    \begin{strip}
      \def\@tempabstract{DEFAULT}%
      \ifx\neoschool@abstracttitle\@tempabstract
        \vspace{-3.25\baselineskip}
        \section*{\abstractname}%
        \quotation
      \else
        \ifx\neoschool@abstracttitle\@empty
          \vspace{-2.25\baselineskip}
          \quotation
        \else
          \vspace{-3.25\baselineskip}
          \section*{\neoschool@abstracttitle}%
          \quotation
        \fi
      \fi}
    {\endquotation\end{strip}}
\else
  \renewenvironment{abstract}{%
    \def\@tempabstract{DEFAULT}%
    \ifx\neoschool@abstracttitle\@tempabstract
      \vspace{-1.25\baselineskip}
      \section*{\abstractname}%
      \quotation
    \else
      \ifx\neoschool@abstracttitle\@empty
        \vspace{-0.25\baselineskip}
        \quotation
      \else
        \vspace{-1.25\baselineskip}
        \section*{\neoschool@abstracttitle}%
        \quotation
      \fi
    \fi
  }{\endquotation}

\fi

%% ==============================================================================
%% Section formatting utilities
%% ==============================================================================

% Style definitions
\def\neo@align@right{right}
\def\neo@align@left{left}
\def\neo@align@center{center}

\def\neo@numstyle@circle{circle}
\def\neo@numstyle@box{box}
\def\neo@numstyle@dash{dash}
\def\neo@numstyle@plain{plain}

\def\neo@textstyle@sc{sc}
\def\neo@textstyle@upper{upper}
\def\neo@textstyle@lower{lower}

\def\neo@style@ornaments{ornaments}
\def\neo@style@underline{underline}
\def\neo@style@normal{normal}
\def\neo@style@highlighted{highlighted}
\def\neo@style@shaded{shaded}
\def\neo@style@shadedline{shadedline}

% Utility command for circular number style
\newcommand*\circled[1]{\tikz[baseline=(char.base)]{%
    \node[shape=circle,draw,inner sep=2pt,line width=1.5pt,baseline=-1.25mm] (char) {#1};}
  \vspace{-2pt}
}

% Check for small caps availability
\newcommand*{\IfSCAvailableTF}{%
  \ifcsname\f@encoding/\f@family/\f@series/sc\endcsname
    \expandafter\@firstoftwo
  \else
    \expandafter\@secondoftwo
  \fi
}

% Apply text style based on options
\newcommand{\applytextstyle}[1]{%
  \ifx\neoschool@sectiontextstyle\neo@textstyle@sc
    \IfSCAvailableTF{\scshape\Large\neo@title@other@style #1}{\MakeUppercase{\large \neo@title@style #1}}%
  \else
    \ifx\neoschool@sectiontextstyle\neo@textstyle@upper
      \MakeUppercase{\large \neo@title@other@style #1}%
    \else
      \neo@title@other@style\Large #1%
    \fi
  \fi
}

% Section number formatting based on style option
\renewcommand{\sectionformat}{%
  \ifx\neoschool@sectionnumstyle\neo@numstyle@circle
    \circled{{\large\neo@title@other@style\thesection}}\enskip%
  \else
    \ifx\neoschool@sectionnumstyle\neo@numstyle@box
      \raisebox{0ex}{%
        \setlength{\fboxrule}{1.5pt}%
        \fcolorbox{sectionColor}{white}{%
          \color{sectionColor}%
          \csname\neoschool@headstyle\endcsname
          \csname\neoschool@headweight\endcsname
          \large\thesection%
        }%
      }\enskip%
    \else
      \ifx\neoschool@sectionnumstyle\neo@numstyle@dash
        \neo@title@style\thesection\enskip\textendash\enskip
      \else
        \neo@title@style\thesection\autodot\enskip
      \fi
    \fi
  \fi
}

% Set section alignment
\newcommand{\setsectionraggedstyle}{%
  \ifx\neoschool@sectionalign\neo@align@right
    \renewcommand*{\raggedsection}{\raggedleft}%
  \else
    \ifx\neoschool@sectionalign\neo@align@left
      \renewcommand*{\raggedsection}{\raggedright}%
    \else
      \renewcommand*{\raggedsection}{\centering}%
    \fi
  \fi
}

% Main section format handler
\renewcommand{\sectionlinesformat}[4]{%
  \Ifstr{#1}{section}{%
    \ifx\neoschool@sectionstyle\neo@style@ornaments
      \sectionformat@ornaments{#3}{#4}%
    \else
      \ifx\neoschool@sectionstyle\neo@style@highlighted
        \sectionformat@highlighted{#3}{#4}%
      \else
        \ifx\neoschool@sectionstyle\neo@style@shaded
          \sectionformat@shaded{#3}{#4}%
        \else
          \ifx\neoschool@sectionstyle\neo@style@shadedline
            \sectionformat@shadedline{#3}{#4}%
          \else
            \ifx\neoschool@sectionstyle\neo@style@normal
              \sectionformat@normal{#2}{#3}{#4}%
            \else
              \sectionformat@other{#3}{#4}%
            \fi
          \fi
        \fi
      \fi
    \fi
  }{%
    \@hangfrom{\hskip #2#3}{#4}%
  }%
}

% Individual style implementations
\newcommand{\sectionformat@normal}[3]{%
  \setsectionraggedstyle
  \parbox[t]{\linewidth}{%
    \raggedsection
    \@hangfrom{\color{sectionColor}#2}{%
      \color{sectionColor}%
      \applytextstyle{#3}%
    }%
  }%
  \par\nobreak
}

\newcommand{\sectionformat@ornaments}[2]{%
  \renewcommand*{\raggedsection}{\centering}%
  \raggedsection
  \vspace*{0.5em}%
  \adforn{36}\enskip
  {\color{sectionColor}\applytextstyle{#1#2}}%
  \enskip\adforn{36}%
  \par\nobreak
  \vspace*{0.2em}%
}

% Helper commands for TikZ styles
\newcommand{\setsectiontikzalign}{%
  \ifx\neoschool@sectionalign\neo@align@left
    left%
  \else
    \ifx\neoschool@sectionalign\neo@align@right
      right%
    \else
      center%
    \fi
  \fi
}

\newcommand{\setsectiontikzcolor}[1]{%
  \ifx\neoschool@sectionalign\neo@align@left
    \ifnum\pdf@strcmp{#1}{left}=0
      sectionColor!120
    \else
      sectionColor!20
    \fi
  \else
    \ifx\neoschool@sectionalign\neo@align@right
      \ifnum\pdf@strcmp{#1}{right}=0
        sectionColor!120
      \else
        sectionColor!20
      \fi
    \else
      sectionColor!25
    \fi
  \fi
}

\newcommand{\setsectiontikzmiddle}{%
  \ifx\neoschool@sectionalign\neo@align@left
    sectionColor!90
  \else
    \ifx\neoschool@sectionalign\neo@align@right
      sectionColor!90
    \else
      sectionColor!120
    \fi
  \fi
}

\newcommand{\sectionformat@highlighted}[2]{%
  \noindent\begin{tikzpicture}[baseline]
    \node[
    anchor=base,
    inner ysep=5pt,
    inner xsep=0.3em,
    align=\setsectiontikzalign,
    text width=.985\linewidth,
    text=titleColor,
    line width=0.5pt,
    fill=titleColor!15,
    rounded corners=0pt,
    ] (title) {%
      \applytextstyle{#1#2}%
    };
  \end{tikzpicture}%
  \par%
}

\newcommand{\sectionformat@shaded}[2]{%
  \noindent\begin{tikzpicture}[baseline]
    \node[
    anchor=base,
    inner ysep=5pt,
    inner xsep=0.3em,
    align=\setsectiontikzalign,
    text width=.985\linewidth,
    text=white,
    line width=0.5pt,
    left color={\setsectiontikzcolor{left}},
    right color={\setsectiontikzcolor{right}},
    middle color={\setsectiontikzmiddle},
    rounded corners=0pt,
    ] (title) {%
      \applytextstyle{#1#2}%
    };
  \end{tikzpicture}%
  \par%
}

\newcommand{\sectionformat@shadedline}[2]{%
  \noindent
  \begin{tikzpicture}[baseline]
    \node[
    text=sectionColor,
    anchor=base,
    inner sep=0pt,
    outer sep=0pt,
    align=\setsectiontikzalign,
    text width=\linewidth
    ] (title) {%
      \color{sectionColor}%
      \applytextstyle{#1#2}%
    };

    \ifx\neoschool@sectionalign\neo@align@center
      \fill[
      left color=sectionColor!20,
      right color=sectionColor
      ] ([yshift=-0.5em]title.south west) rectangle ++(.33\linewidth,-0.1em);
      \fill[
      left color=sectionColor,
      middle color=sectionColor!120,
      right color=sectionColor
      ] ([yshift=-0.5em]title.south west) ++(.33\linewidth,0) rectangle ([yshift=-0.6em]title.south east) ++(-0.33\linewidth,0);
      \fill[
      left color=sectionColor,
      right color=sectionColor!20
      ] ([yshift=-0.5em]title.south east) ++(-0.33\linewidth,0) rectangle ([yshift=-0.6em]title.south east);%
    \else
      \ifx\neoschool@sectionalign\neo@align@left
        \fill[%
        left color=sectionColor,
        right color=sectionColor!20
        ] ([yshift=-0.5em]title.south west) rectangle ([yshift=-0.6em]title.south east);%
      \else
        \fill[%
        left color=sectionColor!20,
        right color=sectionColor
        ] ([yshift=-0.5em]title.south west) rectangle ([yshift=-0.6em]title.south east);%
      \fi
    \fi
  \end{tikzpicture}%
  \par\vspace{0.7em}%
}

\newcommand{\sectionformat@other}[2]{%
  \setsectionraggedstyle
  \ifx\neoschool@sectionstyle\neo@style@underline
    \sectionformat@underline{#1}{#2}%
  \else
    \sectionformat@default{#1}{#2}%
  \fi
}

\newcommand{\sectionformat@underline}[2]{%
  \parbox[t]{\linewidth}{%
    \raggedsection
    {\color{sectionColor}\applytextstyle{#1#2}}%
    \par\nobreak
    \kern-.75\ht\strutbox\color{sectionColor!30}\rule{\linewidth}{1pt}%
  }%
}

\newcommand{\sectionformat@default}[2]{%
  \raggedsection
  {\color{sectionColor}\applytextstyle{#1#2}}%
  \par\nobreak
}

%% ==============================================================================
%% Header and Footer Styles and Setting
%% ==============================================================================

\def\neo@header@type{}
\def\neo@header@school{}
\def\neo@header@academy{}
\def\neo@header@level{}
\def\neo@header@duration{}
\def\neo@header@calculator{}
\def\neo@header@leftcontent{}
\def\neo@header@rightcontent{}
\def\neo@header@leftcontentfill{}
\def\neo@header@rightcontentfill{}

\define@key[neo]{header}{type}{\def\neo@header@type{#1}}
\define@key[neo]{header}{school}{\def\neo@header@school{#1}}
\define@key[neo]{header}{academy}{\def\neo@header@academy{#1}}
\define@key[neo]{header}{level}{\def\neo@header@level{#1}}
\define@key[neo]{header}{duration}{\def\neo@header@duration{#1}}
\define@key[neo]{header}{calculator}{%
  \IfStrEqCase{#1}{%
    {true}{\def\neo@header@calculator{true}}%
    {false}{\def\neo@header@calculator{false}}%
    {exam}{\def\neo@header@calculator{exam}}%
  }[%
  \PackageError{neoschool}{Invalid calculator value: #1}%
  {Use 'true', 'false' or 'exam'}%
  ]%
}
\define@key[neo]{header}{leftcontent}{\def\neo@header@leftcontent{#1}}
\define@key[neo]{header}{rightcontent}{\def\neo@header@rightcontent{#1}}
\define@key[neo]{header}{leftcontentfill}{\def\neo@header@leftcontentfill{#1}}
\define@key[neo]{header}{rightcontentfill}{\def\neo@header@rightcontentfill{#1}}

\presetkeys[neo]{header}{%
  type={Évaluation},%
  school={CSI Lyon},%
  academy={Lyon},%
  level={Terminale},%
  duration={1 heure},%
  calculator=true,%
  leftcontent={\faBookOpen},%
  rightcontent={\faSchool},%
  leftcontentfill=true,%
  rightcontentfill=true%
}{}

\newcommand{\neoheader}[1]{%
  \setkeys[neo]{header}{#1}%
}

\newif\ifneoheaderused
\neoheaderusedfalse

\let\neo@original@header\neoheader
\renewcommand{\neoheader}[1]{%
  \neoheaderusedtrue
  \neo@original@header{#1}%
}

\AtEndPreamble{%
  \ifneoheaderused\else
    \setkeys[neo]{header}{}%
  \fi
}

% Header configurations
\ifx\neo@pagestyle\@undefined
  \def\neo@pagestyle{followingpages}
\fi

\ifneo@fullheader
  \ihead{\neo@header@type}
  \chead{\@title}
  \ohead{\neo@header@level}
  \innerfoot{\@date}
  \cfoot{\neo@header@school}
  \ofoot{\pagemark}
  \def\neo@pagestyle{scrheadings}
  \neo@firstpagestyleoverridefalse
\fi

\pagestyle{\neo@pagestyle}

\ifneo@firstpagestyleoverride
  \def\neo@tempstyle{empty}
  \ifx\neo@pagestyle\neo@tempstyle
    \let\ps@firstpage\ps@empty
    \let\ps@pagenum\ps@empty
  \else
    \let\ps@firstpage\ps@pagenum
  \fi
\fi

\thispagestyle{firstpage}

\ExplSyntaxOn
\str_case:VnF \neoschool@headerules
{
  {headrule} { \KOMAoptions{headsepline=.4pt} }
  {footrule} { \KOMAoptions{footsepline=.4pt} }
  {headfootrule} { \KOMAoptions{headsepline=.4pt, footsepline=.4pt} }
  {none} { }
}
{ }
\ExplSyntaxOff

%% ==============================================================================
%% Evaluation Headers and Special Styles
%% ==============================================================================

%% Dimensions and Basic Configuration
%% ----------------------------------
\newlength{\neo@headerheight}
\setlength{\neo@headerheight}{35mm}

\newlength{\neo@iconsize}
\setlength{\neo@iconsize}{1.5cm}

\newlength{\neo@default@top@ref}
\if@twocolumn
  \setlength{\neo@default@top@ref}{1.5cm}\else\setlength{\neo@default@top@ref}{1.65cm}\fi

\newcommand{\neo@top@compensate}{%
  \newlength{\neo@current@total@topspace}
  \setlength{\neo@current@total@topspace}{\dimexpr 1in + \voffset + \topmargin + \headheight + \headsep \relax}
  \newlength{\neo@compensation@value}
  \setlength{\neo@compensation@value}{\dimexpr \neo@default@top@ref - \neo@current@total@topspace \relax}
  \vspace*{\neo@compensation@value}%
}

\newcommand{\neo@vspace@short}{%
  \neo@top@compensate%
  \if@twocolumn
    \vspace{3\baselineskip}%
  \else
    \vspace{\baselineskip}%
  \fi
}

\newcommand{\neo@vspace@eval}{%
  \neo@top@compensate%
  \ifx\@subject\empty
    \ifx\@subtitle\empty
      \if@twocolumn \vspace{5\baselineskip}\else \vspace{3\baselineskip}\fi
    \else
      \if@twocolumn \vspace{6.25\baselineskip}\else \vspace{3.75\baselineskip}\fi
    \fi
  \else
    \ifx\@subtitle\empty
      \if@twocolumn \vspace{6.5\baselineskip}\else \vspace{4.5\baselineskip}\fi
    \else
      \if@twocolumn \vspace{7.25\baselineskip}\else \vspace{5.25\baselineskip}\fi
    \fi
  \fi
}

\newcommand{\neo@vspace@evalicons}{%
  \neo@top@compensate%
  \if@twocolumn
    \vspace{7.5\baselineskip}%
  \else
    \vspace{5.5\baselineskip}%
  \fi
}

\newcommand{\neo@title@final@gap}{%
  \if@twocolumn
    \vspace{1.5\baselineskip}%
  \else
    \vspace{0.75\baselineskip}%
  \fi
}

\newcommand{\neo@short@exam@gap}{%
  \if@twocolumn
    \vspace{2.5\baselineskip}%
  \else
    \vspace{1.5\baselineskip}%
  \fi
}

\newcommand{\neo@vspace@bubbles}{%
  \neo@top@compensate%
  \if@twocolumn
    \vspace{5.25cm}%
  \else
    \vspace{4.5cm}%
  \fi
}

%% Colors Setup
%% ----------------------------------
\newcommand{\neo@setupevalcolors}{%
  \def\neo@evalrulecolor{\neoschool@headfootcolor!25!white}%
}

%% Basic Title Components
%% ----------------------------------

\def\neo@titleblock@yshift{-20mm}

\newcommand{\neo@completetitle}[1][]{%
  % Main title
  \node[
  align=center,
  anchor=center,
  text width=0.75\textwidth,
  #1
  ] (title) at ([yshift=\neo@titleblock@yshift]current page.north) {%
    \baselineskip=30pt
    \csname\neoschool@titlesize\endcsname
    \csname\neoschool@titlestyle\endcsname
    \csname\neoschool@titleweight\endcsname
    \csname\neoschool@titleshape\endcsname
    \color{titleColor}\@title
  };

  % Subject (if provided)
  \ifx\@subject\empty\else
    \node[
    above=1.5mm of title.north,
    anchor=south,
    text width=0.85\textwidth,
    align=center,
    ] {%
      \usekomafont{subject}{\normalsize\@subject}
    };
  \fi

  % Subtitle (if provided)
  \ifx\@subtitle\empty\else
    \node[
    below=1.5mm of title.south,
    anchor=north,
    text width=0.85\textwidth,
    align=center,
    ] {%
      \usekomafont{subtitle}{\large\@subtitle}
    };
  \fi
}

\newcommand{\neo@completegradetitle}[1][]{%
  \ifx\@subject\empty
    \ifx\@subtitle\empty
      \def\neo@grade@title@yshift{-4.25\baselineskip}
      \def\neo@grade@duration@yshift{-6.25\baselineskip}
      \def\neo@grade@name@yshift{-7.75\baselineskip}
      \if@twocolumn \gdef\neo@vspace@grade@before{\vspace{6.5\baselineskip}}
      \else \gdef\neo@vspace@grade@before{\vspace{5.5\baselineskip}}\fi
    \else
      \def\neo@grade@title@yshift{-4.25\baselineskip}
      \def\neo@grade@duration@yshift{-7.75\baselineskip}
      \def\neo@grade@name@yshift{-9.25\baselineskip}
      \if@twocolumn \gdef\neo@vspace@grade@before{\vspace{8\baselineskip}}
      \else \gdef\neo@vspace@grade@before{\vspace{7\baselineskip}}\fi
    \fi
  \else
    \ifx\@subtitle\empty
      \def\neo@grade@title@yshift{-5.25\baselineskip}
      \def\neo@grade@duration@yshift{-7.25\baselineskip}
      \def\neo@grade@name@yshift{-8.75\baselineskip}
      \if@twocolumn \gdef\neo@vspace@grade@before{\vspace{7.5\baselineskip}}
      \else \gdef\neo@vspace@grade@before{\vspace{6.5\baselineskip}}\fi
    \else
      \def\neo@grade@title@yshift{-5.25\baselineskip}
      \def\neo@grade@duration@yshift{-8.85\baselineskip}
      \def\neo@grade@name@yshift{-10.35\baselineskip}
      \if@twocolumn \gdef\neo@vspace@grade@before{\vspace{9\baselineskip}}
      \else \gdef\neo@vspace@grade@before{\vspace{8\baselineskip}}\fi
    \fi
  \fi

  \node[
  align=center,
  anchor=center,
  text width=0.85\textwidth,
  #1
  ] (title) at ([yshift=\neo@grade@title@yshift]current page.north) {%
    \baselineskip=30pt
    \csname\neoschool@titlesize\endcsname
    \csname\neoschool@titlestyle\endcsname
    \csname\neoschool@titleweight\endcsname
    \csname\neoschool@titleshape\endcsname
    \color{titleColor}\@title
  };

  \ifx\@subject\empty\else
    \node[
    above=1.5mm of title.north,
    anchor=south,
    text width=0.85\textwidth,
    align=center,
    ] {%
      \usekomafont{subject}{\normalsize\@subject}
    };
  \fi

  \ifx\@subtitle\empty
  \else
    \node[
    below=1.5mm of title.south,
    anchor=north,
    text width=0.85\textwidth,
    align=center,
    ] {%
      \usekomafont{subtitle}{\large\@subtitle}
    };
  \fi

  \node[
  anchor=north,
  align=center,
  font=\small\sffamily,
  yshift=\neo@grade@duration@yshift
  ] at (current page.north) {%
    \neo@durationtxt{} \neo@header@duration\quad\textbullet\quad\neo@calculator
  };

  \node[
  anchor=north,
  align=center,
  font=\small\sffamily,
  yshift=\neo@grade@name@yshift
  ] at (current page.north) {%
    \color{\neoschool@globalcolor}\neo@nametxt{} \vardots[4cm]
  };
}

%% ==============================================================================
%% Enhanced Header without Icons
%% ==============================================================================

%% Configuration for Simple Header
%% ----------------------------------
\newcommand{\neo@setupheaderconfig}{%
  \edef\neo@leftcornershift{\dimexpr(\paperwidth - \textwidth)/4-5pt\relax}%
  \edef\neo@rightcornershift{\dimexpr(\paperwidth - \textwidth)/4\relax}%
  \def\neo@topyshift{8mm}%
  \def\neo@topyshiftgrade{8mm}%
  \def\neo@bottomyshift{40mm}
}

%% Corner Text Nodes
%% ----------------------------------
\newcommand{\neo@cornernode}[4]{%
  \node[
  anchor=#1,
  font={\color{\neoschool@headfootcolor}\small\sffamily}
  ] at ([xshift=#2,yshift=-#3]current page.north #1) {%
    \begingroup
    #4%
    \endgroup
  };
}

%% ==============================================================================
%% Header with Icons
%% ==============================================================================

%% Icon Node Definition
%% ----------------------------------
\newcommand{\neo@iconnode}[5]{%
  % Icon node with color inversion
  \node[
  rectangle,
  minimum height=\neo@iconsize,
  minimum width=\neo@iconsize,
  fill=white,
  text=titleColor,
  draw=titleColor,
  line width=0.5pt,
  anchor=center,
  font=\Large,
  rounded corners=2pt
  ] (#1) at #2 {#3};

  % Top text
  \node[
  above=2mm of #1,
  anchor=south,
  font={\color{\neoschool@headfootcolor}\small\sffamily}
  ] (#1-top) {%
    \begingroup
    #4%
    \endgroup
  };

  % Bottom text
  \node[
  below=2mm of #1,
  anchor=north,
  font={\color{\neoschool@headfootcolor}\small\sffamily}
  ] (#1-bottom) {%
    \begingroup
    #5%
    \endgroup
  };
}

%% ==============================================================================
%% Header Type Selection and Setup
%% ==============================================================================

\newcommand{\neo@basetitlecontent}{%
  \begin{tikzpicture}[remember picture,overlay]
    \neo@completetitle
  \end{tikzpicture}%
}

%% Header without Icons
\newcommand{\neo@evaltitlecontent}{%
  \neo@setupevalcolors
  \neo@setupheaderconfig

  \ifx\@subject\empty
    \ifx\@subtitle\empty
      \def\neo@titleblock@yshift{-16mm}
      \def\neo@adjustedbottomyshift{24mm}
      \def\neo@adjustedruleposition{-0.85\neo@headerheight}
    \else
      \def\neo@titleblock@yshift{-16mm}
      \def\neo@adjustedbottomyshift{29mm}
      \def\neo@adjustedruleposition{-\neo@headerheight}
    \fi
  \else
    \ifx\@subtitle\empty
      \def\neo@titleblock@yshift{-22mm}
      \def\neo@adjustedbottomyshift{29mm}
      \def\neo@adjustedruleposition{-\neo@headerheight}
    \else
      \def\neo@titleblock@yshift{-20mm}
      \def\neo@adjustedbottomyshift{34mm}
      \def\neo@adjustedruleposition{-1.1\neo@headerheight}
    \fi
  \fi

  \begin{tikzpicture}[remember picture,overlay]
    \draw[\neo@evalrulecolor,line width=\neo@decorativerule]
    ([yshift=\neo@adjustedruleposition]current page.north west) --
    ([yshift=\neo@adjustedruleposition]current page.north east);
    \neo@completetitle
    \neo@cornernode{west}{\neo@leftcornershift}{\neo@topyshift}{\neo@header@type}
    \neo@cornernode{east}{-\neo@rightcornershift}{\neo@topyshift}{\neo@header@school}
    \neo@cornernode{west}{\neo@leftcornershift}{\neo@adjustedbottomyshift}{\neo@header@level}
    \neo@cornernode{east}{-\neo@rightcornershift}{\neo@adjustedbottomyshift}{\@date}
  \end{tikzpicture}%
  \neo@vspace@eval
}

%% Header with Icons
\newcommand{\neo@evaliconscontent}{%
  \neo@setupevalcolors
  \begin{tikzpicture}[remember picture,overlay]
    \draw[\neo@evalrulecolor,line width=\neo@decorativerule]
    ([yshift=-1.125\neo@headerheight]current page.north west) --
    ([yshift=-1.125\neo@headerheight]current page.north east);
    \neo@completetitle
    \neo@iconnode{typeicon}
    {([xshift=30mm,yshift=-0.575\neo@headerheight]current page.north west)}
    {\neo@header@leftcontent}
    {\neo@header@type}
    {\neo@header@level}
    \neo@iconnode{schoolicon}
    {([xshift=-30mm,yshift=-0.575\neo@headerheight]current page.north east)}
    {\neo@header@rightcontent}
    {\neo@header@school}
    {\@date}
  \end{tikzpicture}%
  \neo@vspace@evalicons
}

%% Header with grading strip without Icons
\newcommand{\neo@evalgradecontent}{%
  \thispagestyle{empty}
  \neo@setupevalcolors
  \neo@setupheaderconfig
  \begin{tikzpicture}[remember picture,overlay]
    \neo@completegradetitle
    % Top elements
    \neo@cornernode{west}{\neo@leftcornershift}{\neo@topyshiftgrade}{\neo@header@type}
    \neo@cornernode{east}{-\neo@rightcornershift}{\neo@topyshiftgrade}{\neo@header@level}

    % Bottom elements
    \node[
    anchor=west,
    font={\small\sffamily}
    ] at ([xshift=\neo@leftcornershift,yshift=9mm]current page.south west) {%
      \color{\neoschool@headfootcolor}\@date%
    };

    \node[
    anchor=east,
    font={\small\sffamily}
    ] at ([xshift=-\neo@rightcornershift,yshift=9mm]current page.south east) {%
      \color{\neoschool@headfootcolor}\neo@header@school%
    };

    % Page number in the center bottom
    \node[
    font=\small\sffamily,
    inner sep=3mm
    ] at ([yshift=9mm]current page.south) {%
      \color{\neoschool@headfootcolor}\thepage
    };
  \end{tikzpicture}%
  \neo@vspace@grade@before

  \ifx\neoschool@totalpoints\@empty\gradingstrip\else\gradingstrip[\neoschool@totalpoints]\fi
  \neo@title@final@gap
}

%% Header with grading strip with Icons
\newcommand{\neo@evaliconsgradecontent}{%
  \thispagestyle{empty}
  \begin{tikzpicture}[remember picture,overlay]
    \neo@completegradetitle
    \neo@iconnode{typeicon}
    {([xshift=30mm,yshift=-0.675\neo@headerheight]current page.north west)}
    {\neo@header@leftcontent}
    {\neo@header@type}
    {\neo@header@level}
    \neo@iconnode{schoolicon}
    {([xshift=-30mm,yshift=-0.675\neo@headerheight]current page.north east)}
    {\neo@header@rightcontent}
    {\neo@header@school}
    {\@date}
  \end{tikzpicture}%
  \neo@vspace@grade@before

  \ifx\neoschool@totalpoints\@empty\gradingstrip\else\gradingstrip[\neoschool@totalpoints]\fi
  \neo@title@final@gap
}

%% Calculator Notice
%% ----------------------------------
\newcommand{\neo@calculator}{%
  \small \neo@calcintro{}%
  \def\@tempa{true}%
  \def\@tempb{exam}%
  \ifx\neo@header@calculator\@tempa
    ~\neo@calcallowed.%
  \else
    \ifx\neo@header@calculator\@tempb
      ~\neo@calcallowed{} \neo@calcexammodeonly{} \neo@calcexammode.%
    \else
      ~\neo@calcnotallowed.%
    \fi
  \fi
  \par
}

%% Exam Header
%% ----------------------------------
%% Exam style helper commands and setup
\newcommand{\neo@gettext}[1]{%
  \ifneo@french
    \ifcase#1\or Établissement\or Nom\or Classe\or Durée\or Date\or Note\or Appréciation\fi
  \else\ifneo@german
      \ifcase#1\or Einrichtung\or Name\or Klasse\or Dauer\or Datum\or Note\or Bewertung\fi
    \else
      \ifcase#1\or Institution\or Name\or Class\or Duration\or Date\or Mark\or Appreciation\fi
    \fi\fi
}

\newcommand{\examfield}[2]{%
  \textbf{#1}\hspace{0.5em}#2%
}

%% Exam title style
\newcommand{\neo@examcontent}{%
  \vspace*{-2cm}%
  \begin{tcolorbox}[%
    enhanced,
    frame hidden,
    colback=white,
    top=\baselineskip,
    bottom=\baselineskip,
    left=0pt,
    right=0pt,
    width=\textwidth,
    after skip=0pt,
    ]
    {\renewcommand\arraystretch{1.25}%
      \begin{tblr}{X[4,l]X[2,c]X[3,r]}
        \examfield{\neo@gettext{1} :}{\neo@header@school} &  &
                                                               \examfield{\neo@gettext{5} :}{\@date}                  \\
        \examfield{\neo@gettext{2} :}{\vardots[4cm]}      &  &
                                                               \examfield{\neo@gettext{3} :}{\neo@header@level}
      \end{tblr}
    }

    \vspace{\baselineskip}
    \centering

    \begin{minipage}[c]{\linewidth}
      \centering
      \neo@header@type
    \end{minipage}\vspace{.75\baselineskip}

    \LARGEhuge\csname\neoschool@titlestyle\endcsname
    \csname\neoschool@titleweight\endcsname
    \csname\neoschool@titleshape\endcsname
    \color{titleColor}
    \@title\vspace{.65\baselineskip}

    \normalsize\normalfont\color{black}
    \begin{minipage}[c]{\linewidth}
      \centering
      \examfield{\neo@gettext{4} :}{\neo@header@duration}\vspace{\baselineskip}

      \neo@calculator
    \end{minipage}
  \end{tcolorbox}

  \medskip

  \ifx\neoschool@totalpoints\@empty\gradingstrip\else\gradingstrip[\neoschool@totalpoints]\fi

  \neo@title@final@gap
}

%% French Exam Headers
%% ----------------------------------
% Common exam title commands
\NewDocumentCommand{\neo@examtitle}{m}{%
  {\color{titleColor}
    \csname\neoschool@titlestyle\endcsname
    \csname\neoschool@titleweight\endcsname
    \csname\neoschool@titleshape\endcsname
    \LARGE\MakeUppercase{#1}\par}
}

\NewDocumentCommand{\neo@examsubtitle}{m}{%
  {\color{titleColor!85!black}
    \csname\neoschool@titlestyle\endcsname
    \Large #1\par}
}

\NewDocumentCommand{\neo@examinfo}{m}{%
  {\color{titleColor!75!black}
    \csname\neoschool@titlestyle\endcsname
    \large #1\par}
}

%% Mock exam style
\newcounter{mockexampages}
\AtEndDocument{%
  \immediate\write\@auxout{%
    \string\setcounter{mockexampages}{\thepage}%
  }%
}
\newcommand{\neo@mockexamcontent}{%
  \vspace*{1cm}%
  \begin{center}
    % Institution info
    {\textsc{\neo@examinfo{\neo@header@school}}}
    \vspace*{1cm}%
    {\textsc{\neo@examinfo{\neo@academytxt{} \neo@header@academy}}}
    \vspace*{\stretch{2.5}}%

    % Title and session
    {\LARGE\bfseries\csname\neoschool@headstyle\endcsname
      \csname\neoschool@headweight\endcsname
      \csname\neoschool@headshape\endcsname
      \neo@examtitle{\neo@header@type}}
    \vspace*{0.8cm}%
    {\color{titleColor!75!black}\itshape \neo@sessiontxt{} \@date}
    \vspace*{1.5cm}%

    % Subject and level
    {\Large\csname\neoschool@headstyle\endcsname
      \csname\neoschool@headweight\endcsname
      \csname\neoschool@headshape\endcsname
      \neo@examsubtitle{\neo@examoftxt{} \MakeUppercase{\@subject}}}
    \vspace*{1cm}%
    {\neo@examinfo{\neo@header@level}}
    \vspace*{\stretch{2}}%

    % Duration
    {\textit{\neo@durationtxt{} \neo@header@duration}}
    \vspace*{1.2cm}%

    % Instructions
    \begin{minipage}{0.8\textwidth}
      \begin{center}
        \setlength{\baselineskip}{1.6\baselineskip}%
        \neo@calculator
        \vspace*{0.8cm}%
        \neo@examqualitytxt{}
        \vspace*{0.8cm}
        \neo@examattempttxt{}
      \end{center}
    \end{minipage}
    \vspace*{\stretch{1.5}}%

    % Page count
    {\color{titleColor!65!black}%
      \neo@pagestxt{} \arabic{mockexampages}~\neo@pagesfromtxt{} 1/\arabic{mockexampages} \neo@pagestotxt{} \arabic{mockexampages}/\arabic{mockexampages}.}
    \vspace*{1.5cm}%
  \end{center}
  \thispagestyle{pagenum}%
  \clearpage\newpage
}

\newcommand{\neo@shortexamcontent}{%
  \vspace*{-1cm}
  \begin{center}

    {\neo@header@school}

    \vspace{3mm}
    {\Large \csname\neoschool@headstyle\endcsname
      \csname\neoschool@headweight\endcsname
      \csname\neoschool@headshape\endcsname
      \neo@examtitle{\neo@header@type}}

    \vspace{3mm}
    {\small \textit{\neo@sessiontxt{} \@date}}

    \vspace{5mm}
    {\large \csname\neoschool@headstyle\endcsname
      \csname\neoschool@headweight\endcsname
      \csname\neoschool@headshape\endcsname
      \neo@examsubtitle{\neo@examoftxt{} \MakeUppercase{\@subject}}}

    \vspace{3mm}
    {\small \neo@examinfo{\neo@header@level}}

    \vspace{5mm}
    {\small \textit{\neo@durationtxt{} \neo@header@duration}}

    \vspace{5mm}
    \neo@calculator

    \vspace{8mm}
    {\color{\neoschool@headfootcolor}%
      \rule{0.5\linewidth}{0.5pt}}

  \end{center}
  \neo@short@exam@gap
}

%% Short Eval Header Style
%% ----------------------------------
\newlength{\sideWidth}
\setlength{\sideWidth}{4.5cm}

\newcommand{\neo@shortevalcontent}{%
  \begin{tikzpicture}[remember picture,overlay]
    \draw[line width=\neo@decorativerule, \neoschool@headfootcolor!50!white]
    ([yshift=-21mm]current page.north west) --
    ([yshift=-21mm]current page.north east);
    \path let \p1=(current page.east) in node[
    anchor=west,
    align=left,
    text width=\sideWidth,
    font=\small\sffamily,
    text=\neoschool@headfootcolor
    ] at ([xshift=0.75cm,yshift=-11mm]current page.north west)
    {\neo@nametxt{} \\[1mm]
      \neo@header@type};
    \path let \p1=(current page.east) in node[
    anchor=center,
    align=center,
    text width={\dimexpr\paperwidth-2\sideWidth-0.25cm},
    font=\Large
    ] at ([yshift=-11mm]current page.north)
    {\color{titleColor}%
      \csname\neoschool@titlestyle\endcsname%
      \csname\neoschool@titleweight\endcsname%
      \csname\neoschool@titleshape\endcsname%
      \@title};
    \path let \p1=(current page.east) in node[
    anchor=east,
    align=right,
    text width=\sideWidth,
    font=\small\sffamily,
    text=\neoschool@headfootcolor
    ] at ([xshift=-0.75cm,yshift=-11mm]current page.north east)
    {\neo@header@school\\[1mm]
      \neo@header@level};
  \end{tikzpicture}%
  \neo@vspace@short
}

%% Short Title Header Style
%% ----------------------------------
\newcommand{\neo@shorttitlecontent}{%
  \begin{tikzpicture}[remember picture,overlay]
    \draw[line width=\neo@decorativerule, \neoschool@headfootcolor!50!white]
    ([yshift=-21mm]current page.north west) --
    ([yshift=-21mm]current page.north east);

    \def\neo@node@anchor{center}
    \def\neo@node@align{center}
    \def\neo@node@pos{current page.north}
    \def\neo@node@xshift{0cm}

    \ifx\neoschool@titlealign\neo@left
      \def\neo@node@anchor{west}
      \def\neo@node@align{left}
      \def\neo@node@pos{current page.north west}
      \def\neo@node@xshift{1cm}
    \fi

    \ifx\neoschool@titlealign\neo@right
      \def\neo@node@anchor{east}
      \def\neo@node@align{right}
      \def\neo@node@pos{current page.north east}
      \def\neo@node@xshift{-1cm}
    \fi

    \node[
    anchor=\neo@node@anchor,
    align=\neo@node@align,
    text width={\dimexpr\paperwidth-2cm},
    font=\csname\neoschool@titlesize\endcsname
    ] at ([xshift=\neo@node@xshift, yshift=-11mm]\neo@node@pos)
    {%
      \color{titleColor}%
      \csname\neoschool@titlestyle\endcsname%
      \csname\neoschool@titleweight\endcsname%
      \csname\neoschool@titleshape\endcsname%
      \@title%
    };
  \end{tikzpicture}%
  \neo@vspace@short
}

%% Short Lesson Header Style
%% ----------------------------------
\newcommand{\neo@shortlessoncontent}{%
  \begin{tikzpicture}[remember picture,overlay]
    % Line under the header
    \draw[line width=\neo@decorativerule, \neoschool@headfootcolor!50!white]
    ([yshift=-21mm]current page.north west) --
    ([yshift=-21mm]current page.north east);

    % Left side - Type
    \path let \p1=(current page.east) in node[
    anchor=west,
    align=left,
    text width=\sideWidth,
    font=\small\sffamily,
    text=\neoschool@headfootcolor
    ] at ([xshift=0.75cm,yshift=-11mm]current page.north west)
    {\neo@header@type};

    % Center - Title with dynamic width
    \path let \p1=(current page.east) in node[
    anchor=center,
    align=center,
    text width={\dimexpr\paperwidth-2\sideWidth-0.25cm},
    font=\Large
    ] at ([yshift=-11mm]current page.north)
    {\color{titleColor}%
      \csname\neoschool@titlestyle\endcsname%
      \csname\neoschool@titleweight\endcsname%
      \csname\neoschool@titleshape\endcsname%
      \@title};

    % Right side - Level
    \path let \p1=(current page.east) in node[
    anchor=east,
    align=right,
    text width=\sideWidth,
    font=\small\sffamily,
    text=\neoschool@headfootcolor
    ] at ([xshift=-0.75cm,yshift=-11mm]current page.north east)
    {\neo@header@level};
  \end{tikzpicture}%
  \neo@vspace@short
}

%% Bubbles Header
%% ----------------------------------
\def\neo@bubbles@colbubbles{titleColor}
\define@key[neo]{bubbles}{colbubbles}{\def\neo@bubbles@colbubbles{#1}}
\newcommand{\neo@bubbles@setkeys}{\setkeys[neo]{bubbles}}

\neo@bubbles@setkeys{%
  colbubbles=titleColor,
}

\newcommand{\neo@drawbubble}[5]{%
  \pgfmathsetmacro{\opacityValue}{#1}
  \ifneo@unicolor
    \colorlet{currentcolor}{\neo@bubbles@colbubbles}
  \else
    \ifcase#2
      \colorlet{currentcolor}{titleColor}
    \or
      \colorlet{currentcolor}{sectionColor}
    \or
      \colorlet{currentcolor}{exerciseColor}
    \or
      \colorlet{currentcolor}{definitionColor}
    \or
      \colorlet{currentcolor}{methodColor}
    \or
      \colorlet{currentcolor}{comprehensionColor}
    \fi
  \fi
  \fill[
  color=currentcolor!#3!white,
  draw=currentcolor!#3!white,
  line width=0pt,
  opacity=#4
  ] #5;
}

\newcommand{\neo@geometriccontent}{%
  \begin{tikzpicture}[remember picture,overlay]
    \fill[primaryColor, opacity=0.1]
      (current page.north west) -- ++(0, -5cm) -- ++(5cm, 5cm) -- cycle;

    \fill[secondaryColor, opacity=0.1]
      ([xshift=-3cm, yshift=2cm]current page.north east) circle (5cm);

    \draw[primaryColor, line width=2pt]
      ([xshift=1cm, yshift=-4.5cm]current page.north west) --
      ([xshift=-1cm, yshift=-4.5cm]current page.north east);

    \fill[tertiaryColor]
      ([xshift=1cm, yshift=-4.65cm]current page.north west) rectangle ++(0.3, 0.3);

    \node[
      anchor=north west,
      align=left,
      text width={\dimexpr\paperwidth-3cm},
      font=\sffamily
    ] at ([xshift=1.5cm, yshift=-1.5cm]current page.north west)
    {%
      \ifx\@subject\empty\else
        {\color{secondaryColor}\usekomafont{subject}{\@subject}}\\[0.5em]
      \fi

      {\hugeminus\bfseries\color{titleColor}\@title}\\[0.5em]

      \ifx\@subtitle\empty\else
        {\Large\color{black!60}\usekomafont{subtitle}\@subtitle}
      \fi
    };
  \end{tikzpicture}
  \vspace{3.25cm}
}

\newcommand{\neo@bannercontent}{%
  \thispagestyle{empty}
  \begin{tikzpicture}[remember picture,overlay]
    \fill[primaryColor]
      (current page.north west) rectangle ([yshift=-4cm]current page.north east);

    \fill[secondaryColor]
      ([yshift=-4cm]current page.north west) rectangle ([yshift=-4.15cm]current page.north east);

    \ifx\@subject\empty\else
      \node[
        anchor=north east,
        fill=white,
        text=primaryColor,
        font=\bfseries\sffamily\small,
        rounded corners=2pt,
        inner sep=5pt
      ] at ([xshift=-1cm, yshift=-1cm]current page.north east)
      {\MakeUppercase{\@subject}};
    \fi

    \node[
      anchor=west,
      text width={\dimexpr\paperwidth-4cm},
      align=left,
      font=\sffamily,
      text=white
    ] at ([xshift=2cm, yshift=-2.25cm]current page.north west)
    {%
      {\hugeminus\bfseries\MakeUppercase{\@title}}\\[0.5em]
      \ifx\@subtitle\empty\else
        {\Large \@subtitle}
      \fi
    };

    \node[
      anchor=north west,
      align=left,
      font=\sffamily\color{gray}
    ] at ([xshift=2cm, yshift=-4.5cm]current page.north west)
    {%
      \ifx\@author\empty\else \textsc{\@author} \quad\textbullet\quad \fi
      \@date
    };
  \end{tikzpicture}
  \vspace{3.25cm}
}

\newcommand{\neo@bubblescontent}{%
  \tikzfading[name=fading box, inner color=transparent!25, outer color=transparent!100]
  \begin{tikzpicture}[remember picture,overlay]
    \def\ellipseWidth{18cm}
    \def\ellipseHeight{4cm}
    \def\numBubbles{800}
    \coordinate (ellipseCenter) at ([yshift=-3.5cm]current page.north);

    \foreach \i in {1,...,\numBubbles} {%
      \pgfmathsetmacro{\angle}{rnd*360}
      \pgfmathsetmacro{\rawradius}{abs(rnd)}
      \pgfmathsetmacro{\radius}{pow(\rawradius, 0.75)}
      \pgfmathsetmacro{\x}{\radius*\ellipseWidth/2*cos(\angle)}
      \pgfmathsetmacro{\y}{\radius*\ellipseHeight/2*sin(\angle)}

      \pgfmathrandominteger{\sizeGroup}{1}{4}
      \ifnum\sizeGroup=1
        \pgfmathsetmacro{\bubbleRadius}{rand*12 + 3.5}
      \else\ifnum\sizeGroup=2
          \pgfmathsetmacro{\bubbleRadius}{rand*9 + 2}
        \else\ifnum\sizeGroup=3
            \pgfmathsetmacro{\bubbleRadius}{rand*7 + 1.2}
          \else
            \pgfmathsetmacro{\bubbleRadius}{rand*5 + 0.6}
          \fi\fi\fi

      \pgfmathsetmacro{\op}{0.15 + 0.15*rand}

      \pgfmathrandominteger{\col}{0}{4}
      \pgfmathrandominteger{\p}{50}{90}
      \neo@drawbubble{\op}{\col}{\p}{\op}
      {([xshift=\x, yshift=\y]ellipseCenter) circle (\bubbleRadius pt)}
    }

    \node[
    anchor=center,
    inner xsep=12cm,
    inner ysep=4cm,
    fill=white,
    fill opacity=1,
    text opacity=1,
    path fading=fading box,
    ] at ([yshift=-1mm]ellipseCenter) (backgroundNode) {};

    \node[
    anchor=center,
    align=center,
    text width=0.95\linewidth,
    ] at ([yshift=-1mm]ellipseCenter) (titleNode)
    {%
      \csname\neoschool@titlestyle\endcsname%
      \csname\neoschool@titleweight\endcsname%
      \csname\neoschool@titleshape\endcsname%
      \color{\neo@bubbles@colbubbles!95!black}\huge\@title%
    };

    \ifx\@subject\empty\else
      \node[
      above=1mm of titleNode,
      align=center,
      text width=0.95\linewidth,
      ] (subjectNode)
      {%
        \usekomafont{subject}{\large\@subject}%
      };
    \fi

    \ifx\@subtitle\empty\else
      \node[
      below=1mm of titleNode,
      align=center,
      text width=0.95\linewidth,
      ] (subtitleNode)
      {%
        \usekomafont{subtitle}{\Large\@subtitle}%
      };
    \fi

  \end{tikzpicture}%
  \neo@vspace@bubbles
}

%% Top Bubbles Header
%% ----------------------------------
\newcommand{\neo@topbubblescontent}{%
  \def\neo@topbubbles@ellipse@yshift{-2.75cm}%
  \if@twocolumn
    \ifx\@subject\empty
      \ifx\@subtitle\empty
        \def\neo@topbubbles@title@yshift{-5.25cm}%
        \def\neo@topbubbles@final@vspace{\vspace{5cm}}%
      \else
        \def\neo@topbubbles@title@yshift{-5.25cm}%
        \def\neo@topbubbles@final@vspace{\vspace{5.75cm}}%
      \fi
    \else
      \ifx\@subtitle\empty
        \def\neo@topbubbles@title@yshift{-6cm}%
        \def\neo@topbubbles@final@vspace{\vspace{5.75cm}}%
      \else
        \def\neo@topbubbles@title@yshift{-6cm}%
        \def\neo@topbubbles@final@vspace{\vspace{6.5cm}}%
      \fi
    \fi
  \else
    \ifx\@subject\empty
      \ifx\@subtitle\empty
        \def\neo@topbubbles@title@yshift{-5.5cm}%
        \def\neo@topbubbles@final@vspace{\vspace{4.25cm}}%
      \else
        \def\neo@topbubbles@title@yshift{-5.5cm}%
        \def\neo@topbubbles@final@vspace{\vspace{5.25cm}}%
      \fi
    \else
      \ifx\@subtitle\empty
        \def\neo@topbubbles@title@yshift{-6cm}%
        \def\neo@topbubbles@final@vspace{\vspace{5cm}}%
      \else
        \def\neo@topbubbles@title@yshift{-6cm}%
        \def\neo@topbubbles@final@vspace{\vspace{5.75cm}}%
      \fi
    \fi
  \fi

  \begin{tikzpicture}[remember picture,overlay]
    \def\ellipseWidth{16cm}
    \def\ellipseHeight{3cm}
    \def\numBubbles{500}

    \coordinate (ellipseCenter) at ([yshift=\neo@topbubbles@ellipse@yshift]current page.north);

    \foreach \i in {1,...,\numBubbles} {%
      \pgfmathsetmacro{\angle}{rnd*360}
      \pgfmathsetmacro{\rawradius}{abs(rnd)}
      \pgfmathsetmacro{\radius}{pow(\rawradius, 1.25)}
      \pgfmathsetmacro{\x}{\radius*\ellipseWidth/2.15*cos(\angle)}
      \pgfmathsetmacro{\y}{\radius*\ellipseHeight/2.15*sin(\angle)}

      \pgfmathrandominteger{\sizeGroup}{1}{4}
      \ifnum\sizeGroup=1
        \pgfmathsetmacro{\bubbleRadius}{rand*12 + 3.5}
      \else\ifnum\sizeGroup=2
          \pgfmathsetmacro{\bubbleRadius}{rand*9 + 2}
        \else\ifnum\sizeGroup=3
            \pgfmathsetmacro{\bubbleRadius}{rand*6 + 1.2}
          \else
            \pgfmathsetmacro{\bubbleRadius}{rand*3 + 0.6}
          \fi\fi\fi

      \pgfmathsetmacro{\op}{0.3 + 0.3*rand}

      \pgfmathrandominteger{\col}{0}{4}
      \pgfmathrandominteger{\p}{48}{92}
      \neo@drawbubble{\op}{\col}{\p}{\op}
      {([xshift=\x, yshift=\y]ellipseCenter) circle (\bubbleRadius pt)}
    }

    \node[
    anchor=center,
    align=center,
    text width=0.95\linewidth,
    ] at ([yshift=\neo@topbubbles@title@yshift]current page.north) (titleNode)
    {\csname\neoschool@titlestyle\endcsname\csname\neoschool@titleweight\endcsname\csname\neoschool@titleshape\endcsname
      \color{\neo@bubbles@colbubbles}\hugeminus \bfseries \@title};

    \ifx\@subject\empty\else
      \node[
      above=1mm of titleNode,
      align=center,
      text width=0.95\linewidth,
      ]
      {\usekomafont{subject}{\@subject}};
    \fi

    \ifx\@subtitle\empty\else
      \node[
      below=1mm of titleNode,
      align=center,
      text width=0.95\linewidth,
      ]
      {\usekomafont{subtitle}{\@subtitle}};
    \fi
  \end{tikzpicture}%
  \neo@compensate%
  \neo@topbubbles@final@vspace
}

%% Bottom Bubbles Header
%% ----------------------------------
\newcommand{\neo@bottombubblescontent}{%
  \ifx\@subject\empty\def\neo@bottombubbles@title@yshift{0cm}\else\def\neo@bottombubbles@title@yshift{-0.5cm}\fi
  \ifx\@subtitle\empty\def\neo@bottombubbles@ellipse@offset{3cm}\else\def\neo@bottombubbles@ellipse@offset{3.75cm}\fi
  \if@twocolumn
    \ifx\@subject\empty
      \ifx\@subtitle\empty\def\neo@bottombubbles@final@vspace{\vspace{5.75cm}}\else\def\neo@bottombubbles@final@vspace{\vspace{6.25cm}}\fi
    \else
      \ifx\@subtitle\empty\def\neo@bottombubbles@final@vspace{\vspace{6.25cm}}\else\def\neo@bottombubbles@final@vspace{\vspace{7cm}}\fi
    \fi
  \else
    \ifx\@subject\empty
      \ifx\@subtitle\empty\def\neo@bottombubbles@final@vspace{\vspace{5cm}}\else\def\neo@bottombubbles@final@vspace{\vspace{5.5cm}}\fi
    \else
      \ifx\@subtitle\empty\def\neo@bottombubbles@final@vspace{\vspace{5.5cm}}\else\def\neo@bottombubbles@final@vspace{\vspace{6cm}}\fi
    \fi
  \fi

  \begin{tikzpicture}[remember picture,overlay]
    \def\myheight{4em}
    \def\ellipseWidth{16cm}
    \def\ellipseHeight{3cm}
    \def\numBubbles{500}
    \coordinate (ellipseCenter) at ([yshift=\dimexpr \neo@bottombubbles@title@yshift - \neo@bottombubbles@ellipse@offset \relax]current page text area.north);
    \foreach \i in {1,...,\numBubbles} {%
      \pgfmathsetmacro{\angle}{rnd*360}
      \pgfmathsetmacro{\rawradius}{abs(rand)}
      \pgfmathsetmacro{\radius}{pow(\rawradius, 1.5)}
      \pgfmathsetmacro{\x}{\radius * \ellipseWidth/2 * cos(\angle)}
      \pgfmathsetmacro{\y}{\radius * \ellipseHeight/2 * sin(\angle)}
      \pgfmathrandominteger{\sizeGroup}{1}{4}
      \ifnum\sizeGroup=1
        \pgfmathsetmacro{\bubbleRadius}{rand*12 + 3.5}
      \else\ifnum\sizeGroup=2
          \pgfmathsetmacro{\bubbleRadius}{rand*9 + 2}
        \else\ifnum\sizeGroup=3
            \pgfmathsetmacro{\bubbleRadius}{rand*6 + 1.2}
          \else
            \pgfmathsetmacro{\bubbleRadius}{rand*3 + 0.6}
          \fi\fi\fi
      \pgfmathsetmacro{\op}{0.3 + 0.3*rand}
      \pgfmathrandominteger{\col}{0}{5}
      \pgfmathrandominteger{\p}{48}{92}
      \neo@drawbubble{\op}{\col}{\p}{\op}
      {([xshift=\x, yshift=\y]ellipseCenter) circle (\bubbleRadius pt)}
    }
    \node[titleColor,
    text width=0.95\textwidth,
    align=center,
    inner sep=0pt] at
    ([yshift=\neo@bottombubbles@title@yshift]current page text area.north) (title) {%
      \hugeminus\csname\neoschool@titlestyle\endcsname
      \csname\neoschool@titleweight\endcsname
      \csname\neoschool@titleshape\endcsname
      \@title
    };
    \ifx\@subject\empty\else
      \node[subjectColor,
      above=3mm of title,
      text width=0.8\textwidth,
      align=center,
      inner sep=0pt] {%
        {\usekomafont{subject}{\@subject}}
      };
    \fi
    \ifx\@subtitle\empty\else
      \node[subtitleColor,
      below=3mm of title,
      text width=0.8\textwidth,
      align=center,
      inner sep=0pt] {%
        {\usekomafont{subtitle}{\@subtitle}}
      };
    \fi
  \end{tikzpicture}%
  \neo@compensate%
  \neo@bottombubbles@final@vspace
}

%% ==============================================================================
%% Box Styles and Environment
%% ==============================================================================

%% Common Style Parameters
%% ----------------------------------

%% Mathematical Boxes
%% ----------------------------------
% Standard math box with configurable colors%
\NewDocumentCommand\mathbox{D<>{white}O{definitionColor}}{%
  \tcboxmath[%
  colback=#1,
  colframe=#2,
  size=fbox,
  arc=3pt,
  boxrule=\neo@normalrule
  ]
}

% Math highlighting with size adaptation
\newcommand{\mhl}[2][mathHighlightColor]{%
  \mathchoice
  {\colorbox{#1}{$\displaystyle#2$}}
  {\colorbox{#1}{$\textstyle#2$}}
  {\colorbox{#1}{$\scriptstyle#2$}}
  {\colorbox{#1}{$\scriptscriptstyle#2$}}
}

%% Answer Fields
%% ----------------------------------
% Empty box for answers
\newcommand{\emptybox}[2]{%
  \begin{tcolorbox}[%
    enhanced,
    boxrule=\neo@normalrule,
    arc=5pt,
    boxsep=0pt,
    width=#1,
    height=#2,
    colback=emptyboxBgColor,
    frame hidden,
    sharp corners,
    before skip=.5\baselineskip,
    after skip=.5\baselineskip
    ]
    \null
  \end{tcolorbox}
}

\newlength{\neo@common@vsep}
\setlength{\neo@common@vsep}{0.75\baselineskip}
\newlength{\neo@effective@common@vsep}
\setlength{\neo@effective@common@vsep}{\neo@vspace@factor\neo@common@vsep}

% Answer field
\newlength{\neo@answerbaselineskip}
\setlength{\neo@answerbaselineskip}{1.35\baselineskip}

\NewDocumentCommand{\answerfield}{O{\linewidth} m}{%
  \begin{tcolorbox}[
    enhanced,
    colback=answerfieldBgColor,
    frame hidden,
    arc=\neoschool@boxarc,
    width=#1,
    height=#2\neo@answerbaselineskip,
    boxsep=0pt,
    left=0pt,
    right=0pt,
    top=0pt,
    bottom=0pt,
    before skip=\neo@effective@common@vsep,
    after skip=\neo@effective@common@vsep,
    ]
    \phantom{\rule{1pt}{#2\neo@answerbaselineskip}}
  \end{tcolorbox}
  \par
}

% Answer field with frame and white background
\NewDocumentCommand{\answerframe}{O{\linewidth} m O{}}{%
  \begin{tcolorbox}[%
    enhanced,
    boxrule=\neo@normalrule,
    colframe=answerframeFrameColor,
    colback=backgroundColor,
    arc=\neoschool@boxarc,
    width=#1,
    height=#2\neo@answerbaselineskip,
    boxsep=0pt,
    left=2pt,
    right=2pt,
    top=2pt,
    bottom=2pt,
    before skip=\neo@effective@common@vsep,
    after skip=\neo@effective@common@vsep,
    #3,
    ]
    \phantom{\rule{1pt}{#2\neo@answerbaselineskip}}
  \end{tcolorbox}
  \par
}

% Colored box
\newcommand{\neocolorbox}[2][applicationColor]{%
  \begin{tcolorbox}[%
    enhanced,
    fontupper=\color{\neoschool@globalcolor},
    arc=\neoschool@boxarc,
    boxrule=\neo@normalrule,
    width=\linewidth,
    colback=#1!5!white,
    frame hidden,
    before skip=12pt plus 2pt,
    after skip=18pt plus 2pt
    ]
    #2
  \end{tcolorbox}
}

%% Inline Boxes
%% ----------------------------------
\NewDocumentCommand{\inlinebox}{ O{definitionColor} O{white} O{definitionColor} m }{%
  \tcbox[%
  enhanced,
  nobeforeafter,
  tcbox raise base,
  boxrule=\neo@thinrule,
  top=0mm,
  bottom=0mm,
  right=0mm,
  left=0mm,
  arc=1pt,
  boxsep=2pt,
  colback=#1,
  colupper=#2,
  colframe=#3
  ]{#4}%
}

%% General Purpose Box Environment
%% ----------------------------------

\newlength{\neo@neobox@vsep}
\setlength{\neo@neobox@vsep}{0.75\baselineskip}
\newlength{\neo@effective@neobox@vsep}
\setlength{\neo@effective@neobox@vsep}{\neo@vspace@factor\neo@neobox@vsep}

\NewDocumentEnvironment{neobox}{ s O{} }{%
  \begin{tcolorbox}[%
    \IfBooleanTF{#1}{frame hidden}{},
    colframe=primaryColor,
    colback=primaryColor!\neoschool@boxopacity,
    arc=\neoschool@boxarc,
    enhanced,
    breakable,
    boxrule=\neo@normalrule,
    left=0.5ex,
    right=0.5ex,
    fonttitle=\sffamily\bfseries,
    before skip=\neo@effective@neobox@vsep,
    after skip=\neo@effective@neobox@vsep,
    #2
    ]
  }{%
  \end{tcolorbox}
}

% Define starred version
\ExplSyntaxOn
\cs_new:cpn {neobox*} {\neobox*}
\cs_new_eq:cN {endneobox*} \endneobox
\ExplSyntaxOff

%% Side-by-Side Box Environment
%% ----------------------------------
% Base colors for example boxes

\ifneo@darktheme
  \newcommand{\neo@sidebysidetop}[1]{#1!20!backgroundColor}
\else
  \newcommand{\neo@sidebysidetop}[1]{#1!10}
\fi

% Environment definition
\newtcolorbox{sidebyside}[1][]{%
  sidebyside,
  enhanced,
  bicolor,
  sharp corners,
  arc=\neoschool@sideboxarc,
  colback=\neo@sidebysidetop{exampleColor},
  colbacklower=backgroundColor,
  colframe=exampleColor,
  colupper=\neoschool@globalcolor,
  collower=\neoschool@globalcolor,
  boxsep=10pt,
  left=0pt,
  right=0pt,
  top=0pt,
  bottom=0pt,
  boxrule=\neo@normalrule,
  fonttitle=\sffamily\bfseries,
  lefttitle=-6pt,
  toptitle=-7pt,
  bottomtitle=-7pt,
  before skip=\neo@effective@beforeskip,
  after skip=\neo@effective@afterskip,
  #1
}

%% ==============================================================================
%% Listings Styles and Setting
%% ==============================================================================

\ifneoschool@centeredcode
  \def\neo@codecenter{center}
\else
  \def\neo@codecenter{}
\fi

%% tcolorbox Styles
%% ----------------------------------

%% Base Box Parameters
%% ----------------------------------
\tcbset{%
  neo@commonbox/.style={%
    enhanced,
    breakable,
    arc=\neoschool@codeboxarc,
    boxrule=\neo@codeborder,
    left=\neo@code@box@left@padding,
    right=\neo@code@box@right@padding,
    top=\neo@code@box@top@padding,
    bottom=\neo@code@box@bottom@padding,
    toptitle=3pt,
    bottomtitle=3pt,
    fonttitle=\small\neo@title@style,
    coltitle=\neo@codebox@titlecolor,
    before skip=\neo@effective@code@beforeskip,
    after skip=\neo@effective@code@afterskip,
  }
}

%% Box Styles
%% ----------------------------------
\tcbset{%
  box-toptitle/.style={%
    neo@commonbox,
    \neo@getcodeframestyle,
    colframe=codeFrame,
    colback=codeBackground,
    colbacktitle=backgroundColor,
    coltitle=codeTitle,
    attach boxed title to top right,
    boxed title style={%
      opacityback=0,
      frame hidden,
      colframe=codeFrame,
      sharp corners
    },
  },
  box-bottomtitle/.style={
    neo@commonbox,
    \neo@getcodeframestyle,
    colframe=codeFrame,
    colback=codeBackground,
    colbacktitle=backgroundColor,
    coltitle=codeTitle,
    attach boxed title to bottom center,
    boxed title style={%
      opacityback=0,
      frame hidden,
      colframe=codeFrame,
      sharp corners
    },
  },
  box-fancy/.style={%
    neo@commonbox,
    \neo@getcodeframestyle,
    colback=codeBackground,
    colframe=codeFrame,
    \neo@getcodeshadowstyle,
  },
  box-minimal/.style={%
    neo@commonbox,
    sharp corners,
    \neo@getcodeframestyle,
    colframe=codeFrame,
    colback=codeBackground,
    borderline west={3pt}{0pt}{codeFrame},
    coltitle=codeTitle,
    detach title,
    fonttitle=\sffamily\bfseries\small,
    before upper={\ifx\tcbtitletext\empty\else\vspace*{0.25em}\par\hspace*{-2pt}{\color{codeTitle}\tcbtitle}\par\smallskip\fi},
    left=0.85em,
  },
  box-leftrule/.style={%
    neo@commonbox,
    sharp corners,
    frame hidden,
    boxrule=0pt,
    colframe=codeFrame,
    colback=codeBackground,
    borderline west={3pt}{0pt}{codeFrame},
    coltitle=codeTitle,
    detach title,
    fonttitle=\sffamily\bfseries\small,
    before upper={\ifx\tcbtitletext\empty\else\vspace*{0.25em}\par\hspace*{-2pt}{\color{codeTitle}\tcbtitle}\par\smallskip\fi},
    left=0.85em,
  },
  box-subtle/.style={%
    neo@commonbox,
    \neo@getcodeframestyle,
    sharp corners,
    colback=codeBackground,
    colframe=backgroundColor,
    colbacktitle=codeFrame,
    coltitle=backgroundColor,
    boxrule=0pt,
    overlay unbroken={%
      \draw[codeFrame, line width=1.5pt] (frame.north west) -- (frame.north east);
    },
    overlay first={%
      \draw[codeFrame, line width=1.5pt] (frame.north west) -- (frame.north east);
    },
    overlay last={%
    }
  },
  box-elegant/.style={%
    neo@commonbox,
    frame hidden,
    boxrule=0pt,
    colback=backgroundColor,
    opacityback=0,
    colframe=backgroundColor,
    colbacktitle=backgroundColor,
    coltitle=codeTitle,
    attach boxed title to top left,
    left=0pt,
    right=0pt,
    top=-5pt,
    bottom=0pt,
    boxed title style={
      top=0pt,
      bottom=6pt,
      left=-3pt,
    },
  },
  box-sober/.style={%
    neo@commonbox,
    frame hidden,
    boxrule=0pt,
    colback=codeBackground,
    colframe=backgroundColor,
    colbacktitle=backgroundColor,
    coltitle=codeTitle,
    attach boxed title to top left,
    left=0pt,
    right=0pt,
    top=0pt,
    bottom=5pt,
    boxed title style={
    },
  },
  box-shaded/.style={%
    neo@commonbox,
    boxrule=0pt,
    colback=codeBackground,
    colframe=codeBackground,
    colbacktitle=codeBackground,
    coltitle=codeTitle,
    attach boxed title to top left,
    left=5pt,
    right=5pt,
    top=2pt,
    bottom=5pt,
    boxed title style={
      boxrule=0pt,
      top=3pt,
      bottom=3pt,
      left=3pt,
      arc=0pt,
    },
  },
  box-academic/.style={%
    neo@commonbox,
    \neo@getcodeframestyle,
    boxrule=0pt,
    colback=backgroundColor,
    opacityback=0,
    colframe=backgroundColor,
    colbacktitle=backgroundColor,
    coltitle=codeTitle,
    attach boxed title to top left,
    boxed title style={
      left=-3pt,
    },
  },
  box-diagonal/.style={%
    neo@commonbox,
    \neo@getcodeframestyle,
    arc=7pt,
    colback=codeBackground,
    colframe=codeFrame,
    sharp corners=southwest,
    sharp corners=northeast,
  },
  box-bevel/.style={%
    neo@commonbox,
    \neo@getcodeframestyle,
    arc=7pt,
    colback=codeBackground,
    colframe=codeFrame,
    sharp corners=southeast,
    sharp corners=northwest,
  },
  box-corner/.style={%
    neo@commonbox,
    \neo@getcodeframestyle,
    arc=7pt,
    colback=codeBackground,
    colframe=codeFrame,
    sharp corners=downhill,
    rounded corners=northeast,
  },
  box-rounded/.style={%
    neo@commonbox,
    \neo@getcodeframestyle,
    arc=3pt,
    colback=codeBackground,
    colframe=codeFrame,
    rounded corners,
  },
  box-downhill/.style={%
    neo@commonbox,
    \neo@getcodeframestyle,
    arc=7pt,
    colback=codeBackground,
    colframe=codeFrame,
    coltitle=codeFrame,
    sharp corners=downhill,
    fontupper=\color{\neoschool@globalcolor},
    attach boxed title to top right={yshift=-\tcboxedtitleheight},
    boxed title style={%
      colback=codeBackground,
      colframe=codeFrame,
      sharp corners=downhill,
      boxrule=\neo@normalrule,
      arc=7pt,
      top=1pt,
      bottom=1pt,
      left=2pt,
      right=2pt
    },
  }
}

\def\neo@keywordstyle{\color{codeKeyword}\bfseries}
\def\neo@commentstyle{\color{codeComment}}
\def\neo@stringstyle{\color{codeString}}
\def\neo@emphstyle{\color{codeEmph}\bfseries}

\newcommand{\neo@setcodenumbership}[1]{%
  \def\neo@testval{#1}%
  %
  \ifnum\pdf@strcmp{\neo@testval}{box-minimal}=0
    \ifneo@listings\lstset{numbersep=18pt}\fi
    \ifneo@minted\setminted{numbersep=18pt}\fi
  \else\ifnum\pdf@strcmp{\neo@testval}{box-elegant}=0
      \ifneo@listings\lstset{numbersep=10pt}\fi
      \ifneo@minted\setminted{numbersep=10pt}\fi
    \else
      \ifneo@codenoframe
        \ifneo@codenoback
          \ifneo@listings\lstset{numbersep=10pt}\fi
          \ifneo@minted\setminted{numbersep=10pt}\fi
        \else
          \ifneo@listings\lstset{numbersep=18pt}\fi
          \ifneo@minted\setminted{numbersep=18pt}\fi
        \fi
      \else
        \ifneo@listings\lstset{numbersep=18pt}\fi
        \ifneo@minted\setminted{numbersep=18pt}\fi
      \fi
    \fi
  \fi
}

\neo@setcodenumbership{\neoschool@codestyle}

\ifneo@listings

  %% Base Listing Style
  %% ----------------------------------
  \lstdefinestyle{neo@lst@base}{%
    basicstyle=\ttfamily\small\color{\neoschool@globalcolor},
    columns=fullflexible,
    breaklines=true,
    keepspaces=true,
    showstringspaces=false,
    tabsize=4,
    inputencoding=utf8,
    extendedchars=true,
    escapeinside={(*@}{@*)},
    aboveskip=.25\baselineskip,
    belowskip=.25\baselineskip,
    frame=none,
    literate={%
      á}{{\'a}}1 {é}{{\'e}}1 {í}{{\'i}}1 {ó}{{\'o}}1 {ú}{{\'u}}1
    {Á}{{\'A}}1 {É}{{\'E}}1 {Í}{{\'I}}1 {Ó}{{\'O}}1 {Ú}{{\'U}}1
    {à}{{\`a}}1 {è}{{\`e}}1 {ì}{{\`i}}1 {ò}{{\`o}}1 {ù}{{\`u}}1
    {À}{{\`A}}1 {È}{{\`E}}1 {Ì}{{\`I}}1 {Ò}{{\`O}}1 {Ù}{{\`U}}1
    {ä}{{\"a}}1 {ë}{{\"e}}1 {ï}{{\"i}}1 {ö}{{\"o}}1 {ü}{{\"u}}1
    {Ä}{{\"A}}1 {Ë}{{\"E}}1 {Ï}{{\"I}}1 {Ö}{{\"O}}1 {Ü}{{\"U}}1
    {â}{{\^a}}1 {ê}{{\^e}}1 {î}{{\^i}}1 {ô}{{\^o}}1 {û}{{\^u}}1
    {Â}{{\^A}}1 {Ê}{{\^E}}1 {Î}{{\^I}}1 {Ô}{{\^O}}1 {Û}{{\^U}}1
    {œ}{{\oe}}1 {Œ}{{\OE}}1 {æ}{{\ae}}1 {Æ}{{\AE}}1 {ß}{{\ss}}1
    {ẞ}{{\SS}}1 {ç}{{\c{c}}}1 {Ç}{{\c{C}}}1 {ø}{{\o}}1 {Ø}{{\O}}1
    {å}{{\aa}}1 {Å}{{\AA}}1 {ã}{{\~a}}1 {õ}{{\~o}}1 {Ã}{{\~A}}1
    {Õ}{{\~O}}1 {ñ}{{\~n}}1 {Ñ}{{\~N}}1 {¿}{{?`}}1 {¡}{{!`}}1
    {°}{{\textdegree}}1 {º}{{\textordmasculine}}1 {ª}{{\textordfeminine}}1
    {€}{{\euro}}1 {£}{{\pounds}}1 {©}{{\copyright}}1 {®}{{\textregistered}}1
    {«}{{\guillemotleft}}1 {»}{{\guillemotright}}1 {Ð}{{\DH}}1 {ð}{{\dh}}1
    {Ý}{{\'Y}}1 {ý}{{\'y}}1 {Þ}{{\TH}}1 {þ}{{\th}}1 {Ă}{{\u{A}}}1
    {ă}{{\u{a}}}1 {Ą}{{\k{A}}}1 {ą}{{\k{a}}}1 {Ć}{{\'C}}1 {ć}{{\'c}}1
    {Č}{{\v{C}}}1 {č}{{\v{c}}}1 {Ď}{{\v{D}}}1 {ď}{{\v{d}}}1 {Đ}{{\DJ}}1
    {đ}{{\dj}}1 {Ė}{{\.{E}}}1 {ė}{{\.{e}}}1 {Ę}{{\k{E}}}1 {ę}{{\k{e}}}1
    {Ě}{{\v{E}}}1 {ě}{{\v{e}}}1 {Ğ}{{\u{G}}}1 {ğ}{{\u{g}}}1 {Ĩ}{{\~I}}1
    {ĩ}{{\~\i}}1 {Į}{{\k{I}}}1 {į}{{\k{i}}}1 {İ}{{\.{I}}}1 {ı}{{\i}}1
    {Ĺ}{{\'L}}1 {ĺ}{{\'l}}1 {Ľ}{{\v{L}}}1 {ľ}{{\v{l}}}1 {Ł}{{\L{}}}1
    {ł}{{\l{}}}1 {Ń}{{\'N}}1 {ń}{{\'n}}1 {Ň}{{\v{N}}}1 {ň}{{\v{n}}}1
    {Ő}{{\H{O}}}1 {ő}{{\H{o}}}1 {Ŕ}{{\'{R}}}1 {ŕ}{{\'{r}}}1 {Ř}{{\v{R}}}1
    {ř}{{\v{r}}}1 {Ś}{{\'S}}1 {ś}{{\'s}}1 {Ş}{{\c{S}}}1 {ş}{{\c{s}}}1
    {Š}{{\v{S}}}1 {š}{{\v{s}}}1 {Ť}{{\v{T}}}1 {ť}{{\v{t}}}1 {Ũ}{{\~U}}1
  }

  \renewcommand*{\lstlistingname}{\neo@codename}

  %% Specific Listing Styles
  %% -----------------------------------------------------------------------

  \lstdefinestyle{neo@lst@syntax}{%
    style=neo@lst@base,
    keywordstyle=\neo@keywordstyle,
    commentstyle=\neo@commentstyle,
    stringstyle=\neo@stringstyle,
    emphstyle=\neo@emphstyle,
    numberstyle=\tiny\sffamily\color{gray},
    aboveskip=0pt,
    belowskip=0pt,
    frame=none,
    numbers=none,
    backgroundcolor={},
    xleftmargin=-2pt,
    framesep=3pt
  }

  \ifneo@codenonum
    \lstdefinestyle{neo@lst@default}{
      style=neo@lst@syntax,
      numbersep=\neo@codenumbersep
    }
  \else
    \lstdefinestyle{neo@lst@default}{
      style=neo@lst@syntax,
      numbers=left,
      numbersep=\neo@codenumbersep
    }
  \fi

  \lstset{style=neo@lst@default}

  %% Language-Specific Definitions
  %% ----------------------------------

  % JSON
  \lstdefinelanguage{json}{%
    keywords={true,false,null},
    sensitive=false,
    morestring=[b]",
    morecomment=[l]{//},
    morecomment=[s]{/*}{*/},
    literate=
    *{0}{{{\color{codeComment}0}}}{1}
    {1}{{{\color{codeComment}1}}}{1}
    {2}{{{\color{codeComment}2}}}{1}
    {3}{{{\color{codeComment}3}}}{1}
    {4}{{{\color{codeComment}4}}}{1}
    {5}{{{\color{codeComment}5}}}{1}
    {6}{{{\color{codeComment}6}}}{1}
    {7}{{{\color{codeComment}7}}}{1}
    {8}{{{\color{codeComment}8}}}{1}
    {9}{{{\color{codeComment}9}}}{1}
    {:}{{{\color{codeKeyword}{:}}}}{1}
    {,}{{{\color{codeKeyword}{,}}}}{1}
    {\{}{{{\color{codeKeyword}{\{}}}}{1}
    {\}}{{{\color{codeKeyword}{\}}}}}{1}
    {[}{{{\color{codeKeyword}{[}}}}{1}
    {]}{{{\color{codeKeyword}{]}}}}{1},
  }

  % YAML
  \lstdefinelanguage{yaml}{%
    keywords={true,false,null,yes,no,on,off},
    sensitive=false,
    morestring=[b]",
    morestring=[b]',
    morecomment=[l]{\#},
    literate=
    *{:}{{{\color{codeKeyword}{:}}}}{1}
    {-}{{{\color{codeKeyword}{-}}}}{1}
    {>}{{{\color{codeKeyword}{>}}}}{1}
    {|}{{{\color{codeKeyword}{|}}}}{1},
  }

  % TOML
  \lstdefinelanguage{toml}{%
    keywords={true,false},
    sensitive=false,
    morestring=[b]",
    morestring=[b]',
    morecomment=[l]{\#},
    literate=
    *{=}{{{\color{codeKeyword}{=}}}}{1}
    {[}{{{\color{codeKeyword}{[}}}}{1}
    {]}{{{\color{codeKeyword}{]}}}}{1}
    {.}{{{\color{codeKeyword}{.}}}}{1},
  }

  % CSV
  \lstdefinelanguage{csv}{%
    sensitive=false,
    morestring=[b]",
    morecomment=[l]{\#},
    literate=
    *{,}{{{\color{codeKeyword}{,}}}}{1}
    {;}{{{\color{codeKeyword}{;}}}}{1},
  }

  % Markdown
  \lstdefinelanguage{markdown}{%
    sensitive=false,
    morecomment=[l]{\%},
    literate=
    *{\#}{{{\color{codeKeyword}{\#}}}}{1}
    {-}{{{\color{codeKeyword}{-}}}}{1}
    {*}{{{\color{codeKeyword}{*}}}}{1}
    {>}{{{\color{codeKeyword}{>}}}}{1}
    {`}{{{\color{codeKeyword}{`}}}}{1}
    {|}{{{\color{codeKeyword}{|}}}}{1}
    {[}{{{\color{codeKeyword}{[}}}}{1}
    {]}{{{\color{codeKeyword}{]}}}}{1}
    {(}{{{\color{codeKeyword}{(}}}}{1}
    {)}{{{\color{codeKeyword}{)}}}}{1},
  }

  %% Language-Specific Styles
  %% ----------------------------------
  \lstdefinestyle{python}{%
    language=Python,
    morekeywords={%
      @property,@classmethod,@staticmethod,
    },
    emph={%
      range,int,str,list,dict,set,bool,float,
      tuple,super,type,print,len,sum,min,max,
      enumerate,zip,map,filter,any,all,as,assert,
      nonlocal,with,yield,self,True,False,None,
      lambda,raise,await,async,
    },
    morestring=[b]""",
  }

  \lstdefinestyle{java}{%
    language=Java,
    morekeywords={%
      @Override,@Deprecated,@SuppressWarnings,
      @FunctionalInterface,@SafeVarargs,
      var,record,sealed,permits,
      public,private,protected,static,final,
      abstract,interface,extends,implements
    },
    morecomment=[s]{/*}{*/},
    morecomment=[l]//,
    morestring=[b]",
  }

  \lstdefinestyle{cpp}{%
    language=C++,
    morekeywords={%
      nullptr,constexpr,override,final,
      template,typename,concept,requires,
      auto,decltype,noexcept,static_assert,
      thread_local,alignas,alignof
    },
    morecomment=[s]{/*}{*/},
    morecomment=[l]//,
    morestring=[b]",
  }

  \lstdefinestyle{js}{%
    language=JavaScript,
    style,
    morekeywords={%
      let,const,var,function,class,extends,
      static,get,set,new,this,super,
      import,export,default,from,as,
      async,await,yield,return,
      undefined,null,true,false
    },
    morecomment=[s]{/*}{*/},
    morecomment=[l]//,
    morestring=[b]",
    morestring=[b]',
    morestring=[b]`,
  }

  \lstdefinestyle{sql}{%
    language=SQL,
    morekeywords={%
      CREATE,TABLE,INSERT,INTO,VALUES,
      SELECT,FROM,WHERE,GROUP,BY,HAVING,
      ORDER,LIMIT,JOIN,LEFT,RIGHT,INNER,
      UPDATE,SET,DELETE,ALTER,DROP,
      CONSTRAINT,PRIMARY,KEY,FOREIGN,
      REFERENCES,CASCADE,INDEX,
      TEXT, REAL, OFFSET, WITH
    },
    sensitive=false,
  }

  \lstdefinestyle{latex}{%
    language=[latex]TeX,
    texcsstyle=*\bfseries\color{codeKeyword},
    moretexcs = {tableofcontents,index,footnote,sout,part,chapter,subsection,subsubsection,paragraph,maketitle,leqslant,geqslant,varnothing,includegraphics,draw,node,theoremstyle,newtcolorbox,tcbuselibrary,newtcbtheorem,SI,ang,ce,chemfig,norm,abs,deriv,R,N,Z,ProvidesPackage,color,ps,montitre,lstset,lstinline,lstinputlisting,definecolor,textcolor,colorlet,setlength,colorbox,fcolorbox,addplot,pgfplotsset,opadd,opsub,opmul,opdiv,opgcd,metre,second,squared,kelvin,coulomb,volt,per,opprint,legend,tkzDefPoint,tkzInterLL,tkzGetPoint,tkzDrawPolygon,tkzDrawSegments,tkzMarkRightAngles,tkzMarkSegments,tkzLabelPoints,boxed,boldsymbol,boldmath,multirow,addbibresource,printbibliography,bm,dfrac,meter,thead,makecell,euro,cellcolor,rowcolor,columncolor,base,repere,rog,ron,rond,derpart,drv,integrer,nuplet,anuplet,ensemble,E,V,suite,suitar,suitgeo,vect,norme,tr,rank,adj,sgn,im,di,intabfx,integrale,e,moinsinf,plusinf,sisetup,restoregeometry,newgeometry,lefttitle,righttitle,colbacklower,neoheader,neograph,textwithimage,withqrcode,positionobject,splitcontent,grid,customgrid,frenchgrid,notebook,nbminorgrid,nbmajorgrid,xsimsetup,correct,choice,checkbox,tcblower,usetheme,usecolortheme,institute,frame,alert,twocolumntoc,codeinline,codeinput,tdnote,tdmark,boxnote,barre,cg,pp,pg,cd,ds,Oij,Oijk,Ouv,neoline,neocol,vectt,mhl,competencies,vardots,answerframe,answerfield,mrk,mrks,gradingstrip},
    morecomment=[l]{\%},
    morestring=[b]",
    sensitive=true
  }

  \lstdefinestyle{bash}{%
    language=bash,
    morekeywords={%
      source, alias, bg, bind, break, builtin, cd, command, compgen,
      complete, continue, declare, dirs, disown, echo, enable, eval,
      exec, exit, export, fc, fg, getopts, hash, help, history, jobs,
      kill, let, local, logout, mapfile, popd, printf, pushd, pwd,
      read, readarray, readonly, return, set, shift, shopt, suspend,
      test, times, trap, type, typeset, ulimit, umask, unalias,
      unset, wait
    },
    morestring=[b]",
    morestring=[b]',
    morestring=[b]\`,
    morecomment=[l]{\#},
    literate=
    *{\$}{{{\color{codeKeyword}{\$}}}}{1}
    {|}{{{\color{codeKeyword}{|}}}}{1}
    {>}{{{\color{codeKeyword}{>}}}}{1}
    {<}{{{\color{codeKeyword}{<}}}}{1}
    {&}{{{\color{codeKeyword}{\&}}}}{1},
  }

  \lstdefinestyle{assembly}{%
    language=[x86]Assembler,
    morekeywords={%
      section, global, extern
    },
    morecomment=[l]{;},
    morecomment=[l]{\#},
    literate=
    *{,}{{{\color{codeKeyword}{,}}}}{1}
    {:}{{{\color{codeKeyword}{:}}}}{1}
    {[}{{{\color{codeKeyword}{[}}}}{1}
    {]}{{{\color{codeKeyword}{]}}}}{1}
    {\$}{{{\color{codeKeyword}{\$}}}}{1}
    {\%}{{{\color{codeKeyword}{\%}}}}{1},
  }

  \lstdefinestyle{lisp}{%
    language=Lisp,
    morekeywords={%
      setq, setf, loop, do, progn, when, unless
    },
    literate=
    *{(}{{{\color{codeKeyword}{(}}}}{1}
    {)}{{{\color{codeKeyword}{)}}}}{1}
    {'}{{{\color{codeKeyword}{'}}}}{1}
    {`}{{{\color{codeKeyword}{`}}}}{1}
    {,}{{{\color{codeKeyword}{,}}}}{1},
  }

  \lstdefinestyle{json}{%
    language=json,
  }

  \lstdefinestyle{yaml}{%
    language=yaml,
  }

  \lstdefinestyle{toml}{%
    language=toml,
  }

  \lstdefinestyle{csv}{%
    language=csv,
  }

  \lstdefinestyle{markdown}{%
    language=markdown,
  }

  %% Environment Definitions
  %% ----------------------------------

  % Counter for code listings
  \newcounter{lstcode}

  % Code listing environment
  \NewTCBListing[use counter=lstcode]{code}{ O{} m !O{} !O{\neoschool@codestyle} !O{\neoschool@codewidth} }{%
    listing only,
    enhanced,
    breakable,
    fontupper=\color{\neoschool@globalcolor},
    width=#5\linewidth,
    listing options={%
      style=#2,
      #1
    },
    code={%
      \neo@setcodenumbership{#4}
      \IfEqCase{#4}{%
        {}{\tcbset{%
            standard jigsaw,
            opacityback=0,
            opacityframe=0,
            colback=backgroundColor,
            colframe=backgroundColor,
            frame hidden,
            boxrule=0pt,
            left=0pt,
            right=0pt,
            top=0pt,
            bottom=0pt,
            coltitle=titleColor,
            fonttitle=\small\neo@title@style
          }}
        {box-academic}{\tcbset{box-academic}}
        {box-bevel}{\tcbset{box-bevel}}
        {box-bottomtitle}{\tcbset{box-bottomtitle}}
        {box-corner}{\tcbset{box-corner}}
        {box-diagonal}{\tcbset{box-diagonal}}
        {box-downhill}{\tcbset{box-downhill}}
        {box-elegant}{\tcbset{box-elegant}}
        {box-fancy}{\tcbset{box-fancy}}
        {box-leftrule}{\tcbset{box-leftrule}}
        {box-minimal}{\tcbset{box-minimal}}
        {box-rounded}{\tcbset{box-rounded}}
        {box-shaded}{\tcbset{box-shaded}}
        {box-sober}{\tcbset{box-sober}}
        {box-subtle}{\tcbset{box-subtle}}
        {box-toptitle}{\tcbset{box-toptitle}}
      }[\PackageError{code}{Style not found: #4}{}]
      \ifx\relax#3\relax
        \tcbset{title={}}
      \else
        \tcbset{title={\lstlistingname~\thelstcode~~\textemdash{}~~#3},\neoschool@boxtitle}
      \fi
    },
    \neo@codecenter
  }

  \NewTCBListing{codenonum}{ O{} m !O{} !O{\neoschool@codestyle} !O{\neoschool@codewidth} }{%
    listing only,
    enhanced,
    breakable,
    fontupper=\color{\neoschool@globalcolor},
    width=#5\linewidth,
    listing options={
      style=#2,
      #1
    },
    code={
      \neo@setcodenumbership{#4}
      \IfEqCase{#4}{
        {}{\tcbset{%
            standard jigsaw,
            opacityback=0,
            opacityframe=0,
            colback=backgroundColor,
            colframe=backgroundColor,
            frame hidden,
            boxrule=0pt,
            left=0pt,
            right=0pt,
            top=0pt,
            bottom=0pt,
            coltitle=titleColor,
            fonttitle=\small\neo@title@style
          }}
        {box-academic}{\tcbset{box-academic}}
        {box-bevel}{\tcbset{box-bevel}}
        {box-bottomtitle}{\tcbset{box-bottomtitle}}
        {box-corner}{\tcbset{box-corner}}
        {box-diagonal}{\tcbset{box-diagonal}}
        {box-downhill}{\tcbset{box-downhill}}
        {box-elegant}{\tcbset{box-elegant}}
        {box-fancy}{\tcbset{box-fancy}}
        {box-leftrule}{\tcbset{box-leftrule}}
        {box-minimal}{\tcbset{box-minimal}}
        {box-rounded}{\tcbset{box-rounded}}
        {box-shaded}{\tcbset{box-shaded}}
        {box-sober}{\tcbset{box-sober}}
        {box-subtle}{\tcbset{box-subtle}}
        {box-toptitle}{\tcbset{box-toptitle}}
      }[\PackageError{code}{Style not found: #4}{}]
      \ifx\relax#3\relax
        \tcbset{title={}}
      \else
        \tcbset{title={#3},\neoschool@boxtitle}
      \fi
    },
    \neo@codecenter
  }

  \expandafter\let\csname code*\endcsname\codenonum
  \expandafter\let\csname endcode*\endcsname\endcodenonum

  % Inline code
  \newcommand{\codeinline}[2][]{%
    \lstinline[style=#1]{#2}
  }

  % Language detection
  \newcommand{\DetectLanguage}[1]{%
    \filename@parse{#1}%
    \IfStrEqCase{\filename@ext}{%
      {py}{python}%
      {java}{java}%
      {tex}{latex}%
    }[text]%
  }

  % Code input
  \NewTCBInputListing{\codeinputnum}{ O{} m m !O{} !O{\neoschool@codestyle} !O{\neoschool@codewidth} }{%
    listing only,
    boxrule=0pt,
    enhanced,
    breakable,
    fontupper=\color{\neoschool@globalcolor},
    width=#6\linewidth,
    listing file={#3},
    listing options={%
      style={#2},
      #1
    },
    frame hidden,
    colback=codeBackground,
    boxrule=0pt,
    left=0pt,
    right=0pt,
    top=0pt,
    bottom=0pt,
    code={%
      \neo@setcodenumbership{#5}
      \IfEqCase{#5}{%
        {}{\tcbset{%
            standard jigsaw,
            opacityback=0,
            opacityframe=0,
            colback=backgroundColor,
            colframe=backgroundColor,
            frame hidden,
            boxrule=0pt,
            left=0pt,
            right=0pt,
            top=0pt,
            bottom=0pt,
            coltitle=titleColor,
            fonttitle=\small\neo@title@style
          }}
        {box-academic}{\tcbset{box-academic}}
        {box-bevel}{\tcbset{box-bevel}}
        {box-bottomtitle}{\tcbset{box-bottomtitle}}
        {box-corner}{\tcbset{box-corner}}
        {box-diagonal}{\tcbset{box-diagonal}}
        {box-downhill}{\tcbset{box-downhill}}
        {box-elegant}{\tcbset{box-elegant}}
        {box-fancy}{\tcbset{box-fancy}}
        {box-leftrule}{\tcbset{box-leftrule}}
        {box-minimal}{\tcbset{box-minimal}}
        {box-rounded}{\tcbset{box-rounded}}
        {box-shaded}{\tcbset{box-shaded}}
        {box-sober}{\tcbset{box-sober}}
        {box-subtle}{\tcbset{box-subtle}}
        {box-toptitle}{\tcbset{box-toptitle}}
      }[\PackageError{code}{Style not found: #5}{}]
      \ifx\relax#4\relax
        \tcbset{title={}}
      \else
        \tcbset{title={\neo@codename~\thelstcode~~\textemdash{}~~#4},\neoschool@boxtitle}
      \fi
    },
    \neo@codecenter
  }

  \NewTCBInputListing{\codeinputnonum}{ O{} m m !O{} !O{\neoschool@codestyle} !O{\neoschool@codewidth} }{
    listing only,
    boxrule=0pt,
    enhanced,
    breakable,
    fontupper=\color{\neoschool@globalcolor},
    width=#6\linewidth,
    listing file={#3},
    listing options={
      style={#2},
      #1
    },
    frame hidden,
    colback=codeBackground,
    code={
      \neo@setcodenumbership{#5}
      \IfEqCase{#5}{
        {}{\tcbset{%
            standard jigsaw,
            opacityback=0,
            opacityframe=0,
            colback=backgroundColor,
            colframe=backgroundColor,
            frame hidden,
            boxrule=0pt,
            left=0pt,
            right=0pt,
            top=0pt,
            bottom=0pt,
            coltitle=titleColor,
            fonttitle=\small\neo@title@style}}
        {box-academic}{\tcbset{box-academic}}
        {box-bevel}{\tcbset{box-bevel}}
        {box-bottomtitle}{\tcbset{box-bottomtitle}}
        {box-corner}{\tcbset{box-corner}}
        {box-diagonal}{\tcbset{box-diagonal}}
        {box-downhill}{\tcbset{box-downhill}}
        {box-elegant}{\tcbset{box-elegant}}
        {box-fancy}{\tcbset{box-fancy}}
        {box-leftrule}{\tcbset{box-leftrule}}
        {box-minimal}{\tcbset{box-minimal}}
        {box-rounded}{\tcbset{box-rounded}}
        {box-shaded}{\tcbset{box-shaded}}
        {box-sober}{\tcbset{box-sober}}
        {box-subtle}{\tcbset{box-subtle}}
        {box-toptitle}{\tcbset{box-toptitle}}
      }[\PackageError{code}{Style not found: #5}{}]
      \ifx\relax#4\relax
        \tcbset{title={}}
      \else
        \tcbset{title={#4},\neoschool@boxtitle}
      \fi
    },
    \neo@codecenter
  }

  \DeclareRobustCommand{\codeinput}{%
    \@ifstar
    {\codeinputnonum}%
    {\codeinputnum}%
  }

  %% Side-by-Side Code Environment
  %% ----------------------------------

  \newtcblisting{codeside}[2][]{%
    standard jigsaw,
    listing only,
    enhanced,
    breakable,
    fontupper=\color{\neoschool@globalcolor},
    opacityback=0,
    opacityframe=0,
    fonttitle=\sffamily\bfseries,
    arc=1pt,
    colback=codeBackground,
    colframe=codeFrame,
    boxsep=0pt,
    left=10pt,
    right=0pt,
    top=0pt,
    bottom=0pt,
    lefttitle=1.7mm,
    width=\linewidth,
    listing options={%
      style=#2,
      #1
    }
  }

\else\ifneo@minted

    %% Environment Definitions
    %% ----------------------------------
    \newcounter{mintcode}

    \ifneo@print
      \ifneo@codenonum
        \setminted{
          style=bw,
          fontsize=\small,
          breaklines=true,
          autogobble,
          frame=none,
          numbersep=\neo@mintednumbersep,
          tabsize=4,
        }
      \else
        \setminted{
          style=bw,
          fontsize=\small,
          breaklines=true,
          autogobble,
          frame=none,
          linenos=true,
          numbersep=\neo@mintednumbersep,
          tabsize=4,
        }
      \fi
    \else
      \ifneo@darktheme
        \ifneo@codenonum
          \setminted{
            style=github-dark,
            backgroundcolor=backgroundColor!85,
            fontsize=\small,
            breaklines=true,
            autogobble,
            frame=none,
            numbersep=\neo@mintednumbersep,
            tabsize=4,
          }
        \else
          \setminted{
            style=github-dark,
            backgroundcolor=backgroundColor!85,
            fontsize=\small,
            breaklines=true,
            autogobble,
            frame=none,
            linenos=true,
            numbersep=\neo@mintednumbersep,
            tabsize=4,
          }
        \fi
      \else
        \ifneo@codenonum
          \setminted{
            style=sas,
            fontsize=\small,
            breaklines=true,
            autogobble,
            frame=none,
            numbersep=\neo@mintednumbersep,
            tabsize=4,
          }
        \else
          \setminted{
            style=sas,
            fontsize=\small,
            breaklines=true,
            autogobble,
            frame=none,
            linenos=true,
            numbersep=\neo@mintednumbersep,
            tabsize=4,
          }
        \fi
      \fi
    \fi

    % Code listing environment
    \NewTCBListing[use counter=mintcode]{code}{ O{} m !O{} !O{\neoschool@codestyle} !O{\neoschool@codewidth} }{%
      listing engine=minted,
      minted language=#2,
      listing only,
      enhanced,
      breakable,
      fontupper=\color{\neoschool@globalcolor},
      width=#5\linewidth,
      minted options={#1},
      code={%
        \neo@setcodenumbership{#4}
        \IfEqCase{#4}{%
          {}{\tcbset{%
              standard jigsaw,
              opacityback=0,
              opacityframe=0,
              colback=backgroundColor,
              colframe=backgroundColor,
              frame hidden,
              boxrule=0pt,
              left=0pt,
              right=0pt,
              top=0pt,
              bottom=0pt,
              coltitle=titleColor,
              fonttitle=\small\neo@title@style
            }}
          {box-academic}{\tcbset{box-academic}}
          {box-bevel}{\tcbset{box-bevel}}
          {box-bottomtitle}{\tcbset{box-bottomtitle}}
          {box-corner}{\tcbset{box-corner}}
          {box-diagonal}{\tcbset{box-diagonal}}
          {box-downhill}{\tcbset{box-downhill}}
          {box-elegant}{\tcbset{box-elegant}}
          {box-fancy}{\tcbset{box-fancy}}
          {box-leftrule}{\tcbset{box-leftrule}}
          {box-minimal}{\tcbset{box-minimal}}
          {box-rounded}{\tcbset{box-rounded}}
          {box-shaded}{\tcbset{box-shaded}}
          {box-sober}{\tcbset{box-sober}}
          {box-subtle}{\tcbset{box-subtle}}
          {box-toptitle}{\tcbset{box-toptitle}}
        }[\PackageError{code}{Style not found: #4}{}]
        \ifx\relax#3\relax
          \tcbset{title={}}
        \else
          \tcbset{title={\neo@codename~\themintcode~~\textemdash{}~~#3},\neoschool@boxtitle}
        \fi
      },
      \neo@codecenter
    }

    \NewTCBListing{codenonum}{ O{} m !O{} !O{\neoschool@codestyle} !O{\neoschool@codewidth} }{
      listing engine=minted,
      minted language=#2,
      listing only,
      enhanced,
      breakable,
      fontupper=\color{\neoschool@globalcolor},
      width=#5\linewidth,
      minted options={#1},
      code={%
        \neo@setcodenumbership{#4}
        \IfEqCase{#4}{
          {}{\tcbset{%
              standard jigsaw,
              opacityback=0,
              opacityframe=0,
              colback=backgroundColor,
              colframe=backgroundColor,
              frame hidden,
              boxrule=0pt,
              left=0pt,
              right=0pt,
              top=0pt,
              bottom=0pt,
              coltitle=titleColor,
              fonttitle=\small\neo@title@style}}
          {box-academic}{\tcbset{box-academic}}
          {box-bevel}{\tcbset{box-bevel}}
          {box-bottomtitle}{\tcbset{box-bottomtitle}}
          {box-corner}{\tcbset{box-corner}}
          {box-diagonal}{\tcbset{box-diagonal}}
          {box-downhill}{\tcbset{box-downhill}}
          {box-elegant}{\tcbset{box-elegant}}
          {box-fancy}{\tcbset{box-fancy}}
          {box-leftrule}{\tcbset{box-leftrule}}
          {box-minimal}{\tcbset{box-minimal}}
          {box-rounded}{\tcbset{box-rounded}}
          {box-shaded}{\tcbset{box-shaded}}
          {box-sober}{\tcbset{box-sober}}
          {box-subtle}{\tcbset{box-subtle}}
          {box-toptitle}{\tcbset{box-toptitle}}
        }[\PackageError{code}{Style not found: #4}{}]
        \ifx\relax#3\relax
          \tcbset{title={}}
        \else
          \tcbset{title={#3}, \neoschool@boxtitle}
        \fi
      },
      \neo@codecenter
    }

    \expandafter\let\csname code*\endcsname\codenonum
    \expandafter\let\csname endcode*\endcsname\endcodenonum

    % Inline code command
    \newcommand{\codeinline}[2][text]{%
      \mintinline[style=vs,fontsize=\small,breaklines,autogobble]{#1}{#2}
    }

    % Code input from file
    \NewTCBInputListing{\codeinputnum}{ O{} m m !O{} !O{\neoschool@codestyle} !O{\neoschool@codewidth} }{%
      listing engine=minted,
      minted language={#2},
      enhanced,
      breakable,
      fontupper=\color{\neoschool@globalcolor},
      width=#6\linewidth,
      listing file={#3},
      listing only,
      minted options={#1},
      frame hidden,
      colback=codeBackground,
      boxrule=0pt,
      code={%
        \neo@setcodenumbership{#5}
        \IfEqCase{#5}{%
          {}{\tcbset{%
              standard jigsaw,
              opacityback=0,
              opacityframe=0,
              colback=backgroundColor,
              colframe=backgroundColor,
              frame hidden,
              boxrule=0pt,
              left=0pt,
              right=0pt,
              top=0pt,
              bottom=0pt,
              coltitle=titleColor,
              fonttitle=\small\neo@title@style
            }}
          {box-academic}{\tcbset{box-academic}}
          {box-bevel}{\tcbset{box-bevel}}
          {box-bottomtitle}{\tcbset{box-bottomtitle}}
          {box-corner}{\tcbset{box-corner}}
          {box-diagonal}{\tcbset{box-diagonal}}
          {box-downhill}{\tcbset{box-downhill}}
          {box-elegant}{\tcbset{box-elegant}}
          {box-fancy}{\tcbset{box-fancy}}
          {box-leftrule}{\tcbset{box-leftrule}}
          {box-minimal}{\tcbset{box-minimal}}
          {box-rounded}{\tcbset{box-rounded}}
          {box-shaded}{\tcbset{box-shaded}}
          {box-sober}{\tcbset{box-sober}}
          {box-subtle}{\tcbset{box-subtle}}
          {box-toptitle}{\tcbset{box-toptitle}}
        }[\PackageError{code}{Style not found: #5}{}]
        \ifx\relax#4\relax
          \tcbset{title={}}
        \else
          \tcbset{title={\neo@codename~\themintcode~~\textemdash{}~~#4},\neoschool@boxtitle}
        \fi
      },
      \neo@codecenter
    }

    \NewTCBInputListing{\codeinputnonum}{ O{} m m !O{} !O{\neoschool@codestyle} !O{\neoschool@codewidth} }{
      listing engine=minted,
      minted language={#2},
      enhanced,
      breakable,
      fontupper=\color{\neoschool@globalcolor},
      width=#5\linewidth,
      listing file={#3},
      listing only,
      minted options={#1},
      frame hidden,
      colback=codeBackground,
      boxrule=0pt,
      code={%
        \neo@setcodenumbership{#5}
        \IfEqCase{#5}{
          {}{\tcbset{%
              standard jigsaw,
              opacityback=0,
              opacityframe=0,
              colback=backgroundColor,
              colframe=backgroundColor,
              frame hidden,
              boxrule=0pt,
              left=0pt,
              right=0pt,
              top=0pt,
              bottom=0pt,
              coltitle=titleColor,
              fonttitle=\small\neo@title@style}}
          {box-academic}{\tcbset{box-academic}}
          {box-bevel}{\tcbset{box-bevel}}
          {box-bottomtitle}{\tcbset{box-bottomtitle}}
          {box-corner}{\tcbset{box-corner}}
          {box-diagonal}{\tcbset{box-diagonal}}
          {box-downhill}{\tcbset{box-downhill}}
          {box-elegant}{\tcbset{box-elegant}}
          {box-fancy}{\tcbset{box-fancy}}
          {box-leftrule}{\tcbset{box-leftrule}}
          {box-minimal}{\tcbset{box-minimal}}
          {box-rounded}{\tcbset{box-rounded}}
          {box-shaded}{\tcbset{box-shaded}}
          {box-sober}{\tcbset{box-sober}}
          {box-subtle}{\tcbset{box-subtle}}
          {box-toptitle}{\tcbset{box-toptitle}}
        }[\PackageError{code}{Style not found: #5}{}]
        \ifx\relax#4\relax
          \tcbset{title={}}
        \else
          \tcbset{title={#4}, \neoschool@boxtitle}
        \fi
      },
      \neo@codecenter
    }

    \DeclareRobustCommand{\codeinput}{%
      \@ifstar
      {\codeinputnonum}%
      {\codeinputnum}%
    }

    % Side-by-Side Code Environment

    \newtcblisting{codeside}[2][]{%
      standard jigsaw,
      listing engine=minted,
      listing only,
      enhanced,
      breakable,
      fontupper=\color{\neoschool@globalcolor},
      opacityback=0,
      opacityframe=0,
      fonttitle=\sffamily\bfseries,
      minted language=#2,
      arc=1pt,
      colback=codeBackground,
      colframe=codeFrame,
      boxsep=0pt,
      left=10pt,
      right=0pt,
      top=0pt,
      bottom=0pt,
      lefttitle=1.7mm,
      width=\linewidth,
      minted options={#1}
    }

  \fi

\fi

%% ==============================================================================
%% Algorithm and Pseudocode Environments
%% ==============================================================================

\algrenewcommand\algorithmicwhile{\textbf{tant que}}
\algrenewcommand\algorithmicdo{\textbf{faire}}
\algrenewcommand\algorithmicfor{\textbf{pour}}
\algrenewcommand\algorithmicif{\textbf{si}}
\algrenewcommand\algorithmicthen{\textbf{alors}}
\algrenewcommand\algorithmicelse{\textbf{sinon}}
\algrenewcommand\algorithmicend{\textbf{fin}}
\algrenewcommand\algorithmicreturn{\textbf{retourner}}
\algrenewcommand\algorithmicfunction{\textbf{fonction}}
\algrenewcommand\algorithmicrequire{\textbf{entrée}}
\algrenewcommand\algorithmicensure{\textbf{sortie}}
\algrenewcommand\algorithmicprocedure{\textbf{procédure}}

\newcommand{\To}{\textbf{ à }}
\newcommand{\Gets}{\ensuremath{\leftarrow}}

\tcbset{%
  pseudocode/.style={%
    \neoschool@codestyle,
    enhanced,
    breakable,
    before upper={\begin{algorithmic}},
      after upper={\end{algorithmic}},
    fonttitle=\sffamily\small\bfseries,
    before skip=\neo@effective@beforeskip,
    after skip=\neo@effective@afterskip,
  }
}

\newcounter{pseudocode}
\newtcolorbox[use counter=pseudocode]{pseudocode}[2][]{%
  pseudocode,
  title={\csname neo@algorithmname\endcsname~\thepseudocode~~\textemdash{}~~#2},
  #1
}

%% ==============================================================================
%% Base Definitions and Styles for Theorems and Exercises
%% ==============================================================================

% Common Styles
\tcbset{
  common@base/.style={
    enhanced,
    breakable,
    before skip=\baselineskip,
    after skip=\baselineskip,
    colupper=\neo@box@uppertext,
    colframe=primaryColor,
    colbacklower=\neo@box@lowerback,
    separator sign={},
  },
  common@title@base/.style={
    fonttitle={\normalshape\neo@title@style},
  },
}

%% ==============================================================================
%% Shared Box Styles for Theorems and Exercises
%% ==============================================================================
\ExplSyntaxOn
\tl_new:N \l__custom_tcb_title_tl
\tl_new:N \l__custom_tcb_label_tl
\tl_new:N \l__custom_tcb_options_tl

\newcommand{\getCustomSlantedTitle}{%
  \tl_if_empty:NTF \l__custom_tcb_title_tl
  {}
  {\tl_use:N \hspace{0.4em}(\l__custom_tcb_title_tl)\!}
}

\newcommand{\getCustomBoxedTitle}{%
  \tl_if_empty:NTF \l__custom_tcb_title_tl
  {}
  {\tl_use:N \hspace{0.4em}(\l__custom_tcb_title_tl)}
}
\ExplSyntaxOff

\def\neo@getcodeframestyle{%
  \ifneo@codenoframe
    frame hidden%
  \else\fi
}

\def\neo@getcodeshadowstyle{%
  \ifneo@codenoframe
  \else
    drop fuzzy shadow%
  \fi
}

\def\neo@getframestyle{%
  \ifneo@thmnoframe
    frame hidden%
  \else\fi
}

\ifneo@exnoback
  \tcbset{neo@exbackstyle/.style={colback=backgroundColor}}
\else
  \tcbset{neo@exbackstyle/.style={colback=exerciseColor!\neo@exopacity}}
\fi

\ExplSyntaxOn

\cs_new_protected:Nn \neoschool_apply_arcs_ex:
  {
    \dim_set:Nn \l_tmpa_dim { \neoschool@exboxarc }

    \dim_compare:nNnTF { \l_tmpa_dim } = { 0pt }
      {
        \tcbset{
            sharp~corners,
            arc = 0pt,
            outer~arc = 0pt
        }
      }
      {
        \tcbset{
            arc = \l_tmpa_dim,
            outer~arc = \dim_eval:n { \l_tmpa_dim + 0.75pt }
        }
      }
  }

\cs_new_protected:Nn \neoschool_apply_arcs_thm:
  {
    \dim_set:Nn \l_tmpa_dim { \neoschool@thmboxarc }

    \dim_compare:nNnTF { \l_tmpa_dim } = { 0pt }
      {
        \tcbset{ sharp~corners, arc=0pt, outer~arc=0pt }
      }
      {
        \tcbset{
            arc = \l_tmpa_dim,
            outer~arc = \dim_eval:n { \l_tmpa_dim + 0.75pt }
        }
      }
    }

\NewDocumentCommand{\ApplyNeoArcsThm}{}{ \neoschool_apply_arcs_thm: }
\NewDocumentCommand{\ApplyNeoArcsEx}{}{ \neoschool_apply_arcs_ex: }

\ExplSyntaxOff

\tcbset{
  neo thm arcs/.code={ \ApplyNeoArcsThm },
  neo ex arcs/.code={ \ApplyNeoArcsEx }
}

\tcbset{%
  neo@shared@base/.style args={#1}{%
    common@base,
    colframe=#1,
    /utils/exec={\StrSubstitute{#1}{Color}{BgColor}[\correctedBgColor]},
    colback=\correctedBgColor,
    colupper=\neoschool@globalcolor,
    boxrule=\neo@thmborder,
    neo thm arcs,
    \neo@getframestyle,
    parbox=false,
  },
  neo@shared@elegant/.style args={#1}{%
    neo@shared@base={#1},
    common@title@base,
    sharp corners,
    skin=bicolor,
    detach title,
    left=0.75em,
    right=0.75em,
    after skip=\neo@effective@afterskip,
    before skip=\neo@effective@beforeskip,
    top=\neo@toppadding,
    bottom=\neo@bottompadding,
    borderline west={4pt}{0pt}{#1},
    before upper={\tcbtitle\enskip},
    terminator sign={\neoschool@thmterminator},
    separator sign={\neoschool@thmseparator},
  },
  neo@shared@leftrule/.style args={#1}{%
    neo@shared@base={#1},
    common@title@base,
    sharp corners,
    skin=bicolor,
    detach title,
    left=0.75em,
    right=0.75em,
    boxrule=0pt,
    after skip=\neo@effective@afterskip,
    before skip=\neo@effective@beforeskip,
    top=\neo@toppadding,
    bottom=\neo@bottompadding,
    borderline west={3pt}{0pt}{#1},
    before upper={\tcbtitle\enskip},
    terminator sign={\neoschool@thmterminator},
    separator sign={\neoschool@thmseparator},
  },
  neo@shared@shaded/.style 2 args={%
    neo@shared@base={#1},
    common@title@base,
    rounded corners,
    arc=3pt,
    outer arc=3.75pt,
    left=\neo@leftpadding,
    right=\neo@rightpadding,
    after skip=\neo@effective@afterskip,
    before skip=\baselineskip,
    attach boxed title to top left,
    boxed title style={
      empty,
      left=\neo@titleleftpadding,
      right=\neo@titlerightpadding,
      top=4pt,
      bottom=-5pt,
    },
    detach title,
    underlay boxed title={%
      \path[draw=#1, line width=\neo@thmborder,
      rounded corners, fill=\neo@thm@box@mainback]
      ([xshift=.15mm]frame.west) |- ([xshift=-2.5mm]title.north east)
      to[out=0, in=185] ([xshift=5mm, yshift=-.135mm]title.south east);
    },
  },
  neo@shared@slanted/.style args={#1}{%
    neo@shared@base={#1},
    common@title@base,
    skin=bicolor,
    coltitle=backgroundColor,
    left=\neo@leftpadding,
    right=\neo@rightpadding,
    after skip=\neo@effective@afterskip,
    before skip=\neo@effective@beforeskip,
    detach title
  },
  neo@shared@sober/.style args={#1}{%
    neo@shared@base={#1},
    common@title@base,
    skin=bicolor,
    detach title,
    left=\neo@leftpadding,
    right=\neo@rightpadding,
    after skip=\neo@effective@afterskip,
    before skip=\neo@effective@beforeskip,
    terminator sign={\neoschool@thmterminator},
    separator sign={\neoschool@thmseparator},
  },
  neo@shared@classic/.style args={#1}{%
    neo@shared@base={#1},
    common@title@base,
    skin=bicolor,
    coltitle=backgroundColor,
    colbacktitle=tcbcolframe,
    boxrule=\neo@thmborder,
    left=1ex,
    right=1ex,
    toptitle=2pt,
    bottomtitle=1pt,
    after skip=\neo@effective@afterskip,
    before skip=\neo@effective@beforeskip,
  },
  neo@shared@classy/.style args={#1}{%
    neo@shared@base={#1},
    common@title@base,
    skin=bicolor,
    left=1ex,
    right=1ex,
    after skip=\neo@effective@afterskip,
    before skip=\neo@effective@beforeskip,
    attach boxed title to top left={
      yshift*=-\tcboxedtitleheight
    },
    boxed title style={
      sharp corners,
      rounded corners=northwest,
      colback=tcbcolframe,
      boxrule=0pt
    },
    underlay boxed title={
      \path[fill=tcbcolframe]
      (title.south west)--(title.south east)
      to[out=0, in=180] ([xshift=5mm]title.east)--
      (title.center-|frame.east)
      [rounded corners=\kvtcb@arc] |-
      (frame.north) -| cycle;
    }
  },
  neo@shared@boxed/.style 2 args={%
    neo@shared@base={#1},
    common@title@base,
    arc=\neoschool@thmboxarc,
    neo thm arcs,
    \neo@framehidden,
    coltitle=backgroundColor,
    left=\neo@leftpadding,
    right=\neo@rightpadding,
    detach title,
    before upper*={%
      \hspace{-2pt}\tcbox[enhanced,
      colupper=backgroundColor,
      colback=#1,
      fontupper=\normalshape\neo@title@style,
      size=small,
      baseline=3pt,
      top=-3pt,
      bottom=-1pt,
      left=1pt,
      right=1pt,
      nobeforeafter,
      frame code={%
        \path[fill=tcbcolback]
        ([yshift=2pt]frame.north west) --
        ([yshift=2pt]frame.north east) --
        ([yshift=-1pt]frame.south east) --
        ([yshift=-1pt]frame.south west) --
        cycle;
      }]%
      {#2~\thetcbcounter}%
    }
    {\normalshape\neo@title@style\color{#1}\getCustomBoxedTitle}%
    \space%
  }
}

%% ==============================================================================
%% Custom Newtcbtheorem Implementation
%% ==============================================================================

\ExplSyntaxOn
\NewDocumentCommand{\mynewtcbtheorem}{O{}mmmm}{%
  \newtcbtheorem[#1]{#2inner}{#3}{#4}{#5}
  \NewDocumentEnvironment{#2}{O{}}{%
    \keys_set:nn { custom/tcb } { ##1 }
    \tl_if_empty:NTF \l__custom_tcb_options_tl {%
      \use:x {
        \exp_not:N \begin{#2inner}
          {\tl_if_empty:NTF \l__custom_tcb_title_tl
            { }
            { (\exp_not:V \l__custom_tcb_title_tl) }
          }
          {\exp_not:V \l__custom_tcb_label_tl}
        }
      }{%
        \use:x {
          \exp_not:N \begin{#2inner}
            [\exp_not:V \l__custom_tcb_options_tl]
            {\tl_if_empty:NTF \l__custom_tcb_title_tl
              { }
              { (\exp_not:V \l__custom_tcb_title_tl) }
            }
            {\exp_not:V \l__custom_tcb_label_tl}
          }
        }
      }{%
      \end{#2inner}
    }

    \NewDocumentEnvironment{#2*}{O{}}{%
      \keys_set:nn { custom/tcb } { ##1 }
      \tl_if_empty:NTF \l__custom_tcb_options_tl {%
        \use:x {
          \exp_not:N \begin{#2inner*}
            {\tl_if_empty:NTF \l__custom_tcb_title_tl
              { }
              { (\exp_not:V \l__custom_tcb_title_tl) }
            }
            {}
          }
        }{%
          \use:x {
            \exp_not:N \begin{#2inner*}
              [\exp_not:V \l__custom_tcb_options_tl]
              {\tl_if_empty:NTF \l__custom_tcb_title_tl
                { }
                { (\exp_not:V \l__custom_tcb_title_tl) }
              }
              {}
            }
          }
        }{%
        \end{#2inner*}
      }
      \cs_if_exist:cF { c@#5} { \newcounter{#5} }
    }

    \keys_define:nn { custom/tcb } {
      title .tl_set:N = \l__custom_tcb_title_tl,
      label .tl_set:N = \l__custom_tcb_label_tl,
      colback .code:n = \tl_put_right:Nx \l__custom_tcb_options_tl { colback=#1, },
      colframe .code:n = \tl_put_right:Nx \l__custom_tcb_options_tl { colframe=#1, },
      coltitle .code:n = \tl_put_right:Nx \l__custom_tcb_options_tl { coltitle=#1, },
      fonttitle .code:n = \tl_put_right:Nx \l__custom_tcb_options_tl { fonttitle=#1, },
      line~width .code:n = \tl_put_right:Nx \l__custom_tcb_options_tl { line~width=#1, },
      frame~style .code:n = \tl_put_right:Nx \l__custom_tcb_options_tl { frame~style=#1, },
      arc .code:n = \tl_put_right:Nx \l__custom_tcb_options_tl { arc=#1, },
      frame~hidden .code:n = \tl_put_right:Nn \l__custom_tcb_options_tl { frame~hidden, },
      sharp~corners .code:n = \tl_put_right:Nn \l__custom_tcb_options_tl { sharp~corners, },
      rounded~corners .code:n = \tl_put_right:Nn \l__custom_tcb_options_tl { rounded~corners, },
      unknown .code:n = \tl_put_right:Nx \l__custom_tcb_options_tl { #1, },
    }
    \ExplSyntaxOff

    %% ==============================================================================
    %% Theorem Types Implementation
    %% ==============================================================================

    \NewDocumentCommand{\neweleganttheorem}{O{}mmmmmmO{}}{%
      \mynewtcbtheorem[#1]{#2}{#3}{%
        neo@shared@elegant={#4},
        coltitle=#4,
        fontupper={#7},
        before lower={#6},
        #8
      }{#5}
    }

    \NewDocumentCommand{\newleftruletheorem}{O{}mmmmmmO{}}{%
      \mynewtcbtheorem[#1]{#2}{#3}{%
        neo@shared@leftrule={#4},
        boxrule=0pt,
        frame hidden,
        coltitle=#4,
        fontupper={#7},
        before lower={#6},
        #8
      }{#5}
    }

    \NewDocumentCommand{\newslantedtheorem}{O{}mmmmmmO{}}{%
      \mynewtcbtheorem[#1]{#2}{#3}{%
        neo@shared@slanted={#4},
        before upper*={%
          \hspace*{-1.5mm}
          \tcbox[enhanced,
          colupper=backgroundColor,
          colback=#4,
          fontupper=\normalshape\neo@title@style,
          size=small,
          baseline=3pt,
          left=0pt,
          right=0pt,
          bottom=0pt,
          nobeforeafter,
          frame code={%
            \path[fill=tcbcolback] (frame.north west)
            -- ([xshift=2mm]frame.north east)
            -- (frame.south east)
            -- (frame.south west)
            -- (frame.north west)
            [sharp corners]-- cycle;
          }]
          {#3~\thetcbcounter}
          {\normalshape\neo@title@style\color{#4}\getCustomSlantedTitle}%
          \hspace{0.4em}%
        },
        fontupper={#7},
        before lower={#6},
        #8,
      }{#5}
    }

    \NewDocumentCommand{\newshadedtheorem}{O{}mmmmmmO{}}{%
      \expandafter\def\csname neo@titledrawcolor@#2\endcsname{#4}
      \ifneo@thmnoframe\expandafter\def\csname neo@titledrawcolor@#2\endcsname{backgroundColor}\fi
      \mynewtcbtheorem[#1]{#2}{\vspace*{0.35em}#3}{%
        neo@shared@shaded={#4}{#2},
        coltitle=#4,
        fontupper={#7},
        before lower={#6},
        #8
      }{#5}
    }

    \NewDocumentCommand{\newsobertheorem}{O{}mmmmmmO{}}{%
      \mynewtcbtheorem[#1]{#2}{#3}{%
        neo@shared@sober={#4},
        before upper={\tcbtitle\enskip},
        coltitle=#4,
        fontupper={#7},
        before lower={#6},
        #8
      }{#5}
    }

    \NewDocumentCommand{\newclassictheorem}{O{}mmmmmmO{}}{%
      \mynewtcbtheorem[#1]{#2}{#3}{%
        neo@shared@classic={#4},
        title={#3},
        fontupper={#7},
        before lower={#6},
        #8
      }{#5}
    }

    \NewDocumentCommand{\newclassytheorem}{O{}mmmmmmO{}}{%
      \mynewtcbtheorem[#1]{#2}{#3}{%
        neo@shared@classy={#4},
        title={#3},
        fontupper={#7},
        before lower={#6},
        #8
      }{#5}
    }

    \NewDocumentCommand{\newboxedtheorem}{O{}mmmmmmO{}}{%
      \mynewtcbtheorem[#1]{#2}{#3}{%
        neo@shared@boxed={#4}{#3},
        fontupper={#7},
        before lower={#6},
        #8
      }{#5}
    }

    \NewDocumentCommand{\newamstheorem}{O{}mmmmmmO{}}{%
      \mynewtcbtheorem[#1]{#2}{#3}{%
        enhanced,
        breakable,
        frame hidden,
        opacityback=0,
        colback=backgroundColor,
        coltitle={#4},
        left=0pt,
        right=0pt,
        top=0pt,
        bottom=0pt,
        boxsep=0pt,
        detach title,
        before upper={\tcbtitle\enskip},
        before skip=\neo@effective@baseskip,
        after skip=\neo@effective@baseskip,
        terminator sign={\neoschool@thmterminator},
        separator sign={\neoschool@thmseparator},
        fontupper={#7},
        fonttitle={\normalshape\neo@title@style},
        before lower={#6},
        #8
      }{#5}
    }

    \NewDocumentCommand{\newamsremarktheorem}{O{}mmmmmmO{}}{%
      \mynewtcbtheorem[#1]{#2}{#3}{%
        enhanced,
        breakable,
        frame hidden,
        opacityback=0,
        colback=backgroundColor,
        colupper=\neoschool@globalcolor,
        coltitle={#4},
        left=0pt,
        right=0pt,
        top=0pt,
        bottom=0pt,
        boxsep=0pt,
        detach title,
        before upper={\tcbtitle\enskip},
        before skip=\neo@effective@baseskip,
        after skip=\neo@effective@baseskip,
        terminator sign={\neoschool@thmterminator},
        separator sign={\neoschool@thmseparator},
        fontupper={#7},
        fonttitle={\normalshape\neo@title@style},
        #8
      }{#5}
    }

    \NewDocumentCommand{\newamsremarkstheorem}{O{}mmmmmmO{}}{%
      \mynewtcbtheorem[#1]{#2}{#3}{%
        enhanced,
        breakable,
        frame hidden,
        opacityback=0,
        colback=backgroundColor,
        colupper=\neoschool@globalcolor,
        coltitle={#4},
        left=0pt,
        right=0pt,
        top=0pt,
        bottom=0pt,
        boxsep=0pt,
        detach title,
        before upper={\tcbtitle\enskip},
        before skip=\neo@effective@baseskip,
        after skip=\neo@effective@baseskip,
        terminator sign={\neoschool@thmterminator},
        separator sign={\neoschool@thmseparator},
        fontupper={#7},
        fonttitle={\normalshape\neo@title@style},
        #8
      }{#5}
    }

    \NewDocumentCommand{\newamsexampletheorem}{O{}mmmmmmO{}}{%
      \mynewtcbtheorem[#1]{#2}{#3}{%
        enhanced,
        breakable,
        frame hidden,
        opacityback=0,
        colback=backgroundColor,
        colupper=\neoschool@globalcolor,
        coltitle={#4},
        left=0pt,
        right=0pt,
        top=0pt,
        bottom=0pt,
        boxsep=0pt,
        detach title,
        before upper={\tcbtitle\enskip},
        before skip=\neo@effective@baseskip,
        after skip=\neo@effective@baseskip,
        terminator sign={\neoschool@thmterminator},
        separator sign={\neoschool@thmseparator},
        fontupper={#7},
        fonttitle={\normalshape\neo@title@style},
        before lower={#6},
        #8
      }{#5}
    }

    \NewDocumentCommand{\newamsexamplestheorem}{O{}mmmmmmO{}}{%
      \mynewtcbtheorem[#1]{#2}{#3}{%
        enhanced,
        breakable,
        frame hidden,
        opacityback=0,
        colback=backgroundColor,
        colupper=\neoschool@globalcolor,
        coltitle={#4},
        left=0pt,
        right=0pt,
        top=0pt,
        bottom=0pt,
        boxsep=0pt,
        detach title,
        before upper={{\color{exampleColor}\neo@title@style #3}\enskip},
        before skip=\neo@effective@baseskip,
        after skip=\neo@effective@baseskip,
        terminator sign={\neoschool@thmterminator},
        separator sign={\neoschool@thmseparator},
        fontupper={#7},
        #8
      }{#5}
    }

    \NewDocumentCommand{\neo@declarespecialtheorem}{m m}{%
      \ifstrequal{#1}{remark}{%
          \newamsremarktheorem{#1}{\csname neo@#1name\endcsname}{#2}{#1}{}{\normalfont}
        }{%
          \ifstrequal{#1}{remarks}{%
              \newamsremarkstheorem{#1}{\csname neo@#1name\endcsname}{#2}{#1}{}{\normalfont}
            }{%
              \ifstrequal{#1}{examples}{%
                  \newamsexamplestheorem{#1}{\csname neo@#1name\endcsname}{#2}{#1}{}{\normalfont}
                }{%
                  \ifneoschool@sectionthmcounter
                    \ifneoschool@sharedthmcounter
                      \newamsexampletheorem[number within=section, use counter = thmcounter]{#1}{\csname neo@#1name\endcsname}{#2}{#1}{}{\normalfont}
                    \else
                      \newamsexampletheorem[number within=section]{#1}{\csname neo@#1name\endcsname}{#2}{#1}{}{\normalfont}
                    \fi
                  \else
                    \ifneoschool@sharedthmcounter
                      \newamsexampletheorem[use counter = thmcounter]{#1}{\csname neo@#1name\endcsname}{#2}{#1}{}{\normalfont}
                    \else
                      \newamsexampletheorem{#1}{\csname neo@#1name\endcsname}{#2}{#1}{}{\normalfont}
                    \fi
                  \fi
                }%
              }%
            }%
          }

          \neo@declarespecialtheorem{remark}{remarkColor}
          \neo@declarespecialtheorem{remarks}{remarkColor}
          \neo@declarespecialtheorem{example}{exampleColor}
          \neo@declarespecialtheorem{examples}{exampleColor}

          %% ==============================================================================
          %% Theorem Declaration Command
          %% ==============================================================================

          \NewDocumentCommand{\neo@declaretheorem}{O{}mmmmmmO{}}{%
            % #1 = additional options
            % #2 = environment name (theorem, definition, etc.)
            % #3 = title (\neo@theoremname, etc.)
            % #4 = color
            % #5 = reference name (thm, def, etc.)
            % #6 = text before proof
            % #7 = text style (\itshape or not)
            % #8 = additional options

            % Handle options
            \def\neo@thmoptions{#1}

            % Section numbering
            \ifneoschool@sectionthmcounter
              \edef\neo@thmoptions{number within=section,\neo@thmoptions}
            \fi

            % Counter handling
            \ifneoschool@sharedthmcounter
              \edef\neo@thmoptions{use counter=thmcounter,\neo@thmoptions}
            \else
              \ifneoschool@thmgroupcounter
                \ifboolexpr{
                    test {\ifstrequal{#2}{theorem}} or
                      test {\ifstrequal{#2}{lemma}} or
                        test {\ifstrequal{#2}{proposition}} or
                          test {\ifstrequal{#2}{corollary}} or
                            test {\ifstrequal{#2}{property}}
                            }{%
                              \edef\neo@thmoptions{use counter=thmcounter,\neo@thmoptions}
                            }{%
                              \edef\neo@thmoptions{\neo@thmoptions}
                            }
                          \else
                            \edef\neo@thmoptions{\neo@thmoptions}
                          \fi
                        \fi

                        \StrSubstitute{\neoschool@thmstyle}{thm}{}[\neo@cleanstyle]

                        \IfStrEq{\neo@cleanstyle}{amslike}{\def\neo@cleanstyle{ams}}{}

                        \def\neo@constructorname{new\neo@cleanstyle theorem}

                        \ifcsname \neo@constructorname \endcsname
                          \csname \neo@constructorname \endcsname[\neo@thmoptions]{#2}{#3}{#4}{#5}{#6}{#7}[#8]%
                        \else
                          \newsobertheorem[\neo@thmoptions]{#2}{#3}{#4}{#5}{#6}{#7}[#8]%
                          \PackageWarning{neoschool}{Style '\neo@cleanstyle' unknown, using sober style.}%
                        \fi
                      }

                      %% ==============================================================================
                      %% Theorem Environment Declarations
                      %% ==============================================================================

                      \newcounter{thmcounter}

                      \def\neo@thmupper@style{
                        \IfStrEq{\neoschool@thmstyle}{amslike}{%
                          \itshape\color{\neoschool@globalcolor}
                        }{%
                          \color{\neoschool@globalcolor}
                        }
                      }

                      % Standard theorems
                      \neo@declaretheorem{theorem}{\neo@theoremname}{theoremColor}{thm}{}{\neo@thmupper@style}
                      \neo@declaretheorem{definition}{\neo@definitionname}{definitionColor}{def}{}{\color{\neoschool@globalcolor}}
                      \neo@declaretheorem{lemma}{\neo@lemmaname}{lemmaColor}{lem}{}{\neo@thmupper@style}
                      \neo@declaretheorem{proposition}{\neo@propositionname}{propositionColor}{propo}{}{\neo@thmupper@style}
                      \neo@declaretheorem{corollary}{\neo@corollaryname}{corollaryColor}{cor}{}{\neo@thmupper@style}
                      \neo@declaretheorem{conjecture}{\neo@conjecturename}{remarkColor}{conj}{}{\neo@thmupper@style}
                      \neo@declaretheorem{property}{\neo@propertyname}{propertyColor}{prop}{}{\neo@thmupper@style}

                      % Activity-related theorems
                      \neo@declaretheorem{activity}{\neo@activityname}{activityColor}{act}{}{\color{\neoschool@globalcolor}}
                      \neo@declaretheorem{method}{\neo@methodname}{methodColor}{meth}{}{\color{\neoschool@globalcolor}}
                      \neo@declaretheorem{application}{\neo@applicationname}{applicationColor}{appl}{}{\color{\neoschool@globalcolor}}

                      % Proof Environment
                      \newenvironment{proof}[1][\neo@proofname]{%
                        \par\noindent{\color{theoremColor}\itshape\bfseries #1.}\enskip%
                      }{%
                        \unskip\nobreak\hfill\makebox[0pt][l]{{\hspace{0.5em}\color{theoremColor}$\blacksquare$}}\par\vspace{0.5\baselineskip}%
                      }

                      %% ==============================================================================
                      %% Exercise Common Elements
                      %% ==============================================================================

                      % QCM Environment Setup
                      \DeclareExerciseEnvironmentTemplate{item}
                      {\trivlist\item[\GetExerciseProperty{counter}.]}
                      {\endtrivlist}

                      % Multiple Choice Elements
                      \DeclareRobustCommand{\neocolorcirc}[1]{%
                        \begin{tikzpicture}[baseline=-1.25mm]
                          \draw[#1] (0.5,0) circle (.75ex);
                        \end{tikzpicture}
                      }

                      \DeclareRobustCommand{\neocolordisk}[2]{%
                        \begin{tikzpicture}[baseline=-1.25mm]
                          \draw[#1, fill=#2] (0.5,0) circle (.75ex);
                        \end{tikzpicture}
                      }

                      \newcommand{\neocheckbox}{\color{\neoschool@globalcolor}$\square$}
                      \newcommand{\neochecksol}{\color{\neoschool@globalcolor}$\blacksquare$}
                      \newcommand{\neocheckcirc}{\neocolorcirc{\neoschool@globalcolor}}
                      \newcommand{\neocheckdisk}{\neocolordisk{\neoschool@globalcolor}{\neoschool@globalcolor}}

                      % Task Environments
                      \NewTasksEnvironment[%
                      label = \neocheckcirc,
                      label-width = 12pt,
                      item-indent = 3.5em,
                      after-skip = 0pt,
                      item-format = {\color{\neoschool@globalcolor}}
                      ]{choices}[\choice]

                      \NewTasksEnvironment[%
                      label = \neocheckbox,
                      label-width = 12pt,
                      item-indent = 3.5em,
                      after-skip = 0pt,
                      item-format = {\color{\neoschool@globalcolor}}
                      ]{checkboxes}[\checkbox]

                      % Shuffle Implementation for Tasks
                      \ifneo@shuffle
                        \ExplSyntaxOn
                        \cs_set_protected:Npn \tasks_environment:nnnn #1#2#3#4
                        {
                          \bool_if:NT \l__tasks_debug_bool { \dim_set:Nn \fboxsep {0pt} }
                          \seq_set_split:Nnn \l__tasks_seq {#3} {#4}
                          \seq_pop_left:NN \l__tasks_seq \l__tasks_tmpa_tl
                          \seq_shuffle:N \l__tasks_seq
                          \tl_if_blank:VF \l__tasks_tmpa_tl
                          { \msg_warning:nnVn {tasks}{no-item} \l__tasks_tmpa_tl {#3} }
                          \int_gset:Nn \g__tasks_total_items_int
                          { \seq_count:N \l__tasks_seq }
                          \UseInstance {tasks} {#1}
                          { \g__tasks_total_items_int }
                          {#2}
                          { }
                          \seq_clear:N \l__tasks_seq
                        }
                        \ExplSyntaxOff
                      \fi

                      % Correct Answer Command
                      \NewDocumentCommand{\correct}{s}{%
                        \IfBooleanTF#1
                        {% \correct*
                          \ifneoschool@answers
                            \neochecksol
                          \else
                            \ifneoschool@answersonly
                              \neochecksol
                            \else
                              \neocheckbox
                            \fi
                          \fi
                        }
                        {% \correct
                          \ifneoschool@answers
                            \neocheckdisk
                          \else
                            \ifneoschool@answersonly
                              \neocheckdisk
                            \else
                              \neocheckcirc
                            \fi
                          \fi
                        }%
                      }

                      %% ==============================================================================
                      %% Exercise Base Box Styles
                      %% ==============================================================================

                      \newcommand{\neo@tmp@scale}{}

                      \ExplSyntaxOn
                      \newcommand{\neoexerciserating}{%
                        [\raisebox{0.5pt}{%
                          \tl_set:Nx \neo@tmp@scale { \fp_eval:n { 1 / \neoschool@mathfacescale } }
                          \expandafter\scalebox\expandafter{\neo@tmp@scale}{%
                            \normalsize$\neo@replicate{\GetExerciseProperty{level}}{{\star}}$%
                          }%
                        }]%
                      }
                      \ExplSyntaxOff

                      \AtBeginDocument{%
                        \ifneo@french
                          \DeclareExerciseTranslation{french}{point}{point}
                          \DeclareExerciseTranslation{french}{points}{points}
                          \DeclareExerciseTranslation{french}{point-short}{pt}
                          \DeclareExerciseTranslation{french}{points-short}{pts}
                        \else\ifneo@german
                            \DeclareExerciseTranslation{german}{point}{Punkt}
                            \DeclareExerciseTranslation{german}{points}{Punkte}
                            \DeclareExerciseTranslation{german}{point-short}{Pkt}
                            \DeclareExerciseTranslation{german}{points-short}{Pkt}
                          \else
                            \DeclareExerciseTranslation{english}{point}{point}
                            \DeclareExerciseTranslation{english}{points}{points}
                            \DeclareExerciseTranslation{english}{point-short}{pt}
                            \DeclareExerciseTranslation{english}{points-short}{pts}
                          \fi
                        \fi
                      }

                      % Base box style
                      \tcbset{%
                        neo@base/.style={%
                          enhanced,
                          breakable,
                          fontupper=\color{\neoschool@globalcolor},
                          before skip=\baselineskip,
                          after skip=\baselineskip,
                          colupper=\neo@box@uppertext,
                          colframe=exerciseColor,
                          colbacklower=\neo@box@lowerback
                        },
                      }

                      %% Box Appearance Styles
                      \tcbset{%
                        % Basic box style
                        neo@box@base/.style={%
                          enhanced,
                          breakable,
                          fontupper=\color{\neoschool@globalcolor},
                          colupper=\neo@box@uppertext,
                          colframe=exerciseColor,
                          colbacklower=\neo@box@lowerback,
                          after skip=\neo@effective@afterskip,
                          before skip=\neo@effective@beforeskip,
                          left=1mm,
                          right=1mm
                        },
                        % Basic title style
                        neo@title@basic/.style={%
                          title={\neo@boxtitle@content},
                          fonttitle=\bfseries\sffamily
                        },
                        % Colored title style
                        neo@title@colored/.style={%
                          neo@title@basic,
                          coltitle=backgroundColor,
                          colbacktitle=tcbcolframe
                        },
                        % Basic frame style
                        neo@frame@basic/.style={%
                          colframe=exerciseColor,
                          neo@exbackstyle
                        },
                        % Hidden frame style
                        neo@frame@hidden/.style={%
                          frame hidden,
                          colframe=exerciseColor!12,
                          colback=white
                        }
                      }

                      %% Corner Styles
                      \tcbset{%
                        % Sharp corners
                        neo@corners@sharp/.style={%
                          sharp corners
                        },
                        % Rounded corners
                        neo@corners@rounded/.style={%
                          rounded corners,
                          arc=\neoschool@exboxarc
                        }
                      }

                      %% Background Styles
                      \tcbset{%
                        % Light background
                        neo@bg@light/.style={%
                          colback=white,
                          colbacktitle=exerciseColor!12
                        },
                        % Shaded background
                        neo@bg@shaded/.style={%
                          colback=exerciseColor!5!white,
                          colbacktitle=exerciseColor!12
                        },
                        % Gradient background
                        neo@bg@gradient/.style={%
                          interior style={%
                            top color=white,
                            bottom color=exerciseColor!5!white
                          }
                        }
                      }

                      %% Title Position Styles
                      \tcbset{%
                        % Attached title
                        neo@title@attached/.style={%
                          attach boxed title to top left={
                            yshift*=-\tcboxedtitleheight
                          },
                          boxed title style={%
                            sharp corners,
                            rounded corners=northwest,
                            colback=tcbcolframe,
                            boxrule=0pt
                          }
                        },
                        % Detached title
                        neo@title@detached/.style={%
                          detach title,
                          before upper={\tcbtitle\enskip}
                        }
                      }

                      %% Special Elements
                      \tcbset{%
                        % Left rule
                        neo@rule@left/.style={%
                          leftrule=3mm
                        },
                        % Basic border
                        neo@border@basic/.style={%
                          boxrule=\neo@thinrule
                        },
                        % Colored border
                        neo@border@colored/.style 2 args={%
                          borderline west={#1}{#2}{tcbcolframe}
                        },
                        % Shadow effect
                        neo@effect@shadow/.style={%
                          drop fuzzy shadow
                        }
                      }

                      %% Color Schemes
                      \tcbset{%
                        % Standard color scheme
                        neo@colors@standard/.style={%
                          colframe=exerciseColor,
                          colback=white,
                          colbacktitle=exerciseColor
                        }
                      }

                      %% Solution Style Setup
                      \NewDocumentCommand\neo@box@solution{}{%
                        {\csname\neoschool@headstyle\endcsname
                          \csname\neoschool@headweight\endcsname
                          \color{tcbcolframe}\neo@solutionname~\neo@solutiongaptext}\enskip
                      }

                      \tcbset{%
                        neo@solution@basic/.style={%
                          before lower={\neo@box@solution}
                        }
                      }

                      %% Box Title Content
                      \newcommand{\neo@boxtitle@content}{%
                        \sffamily\GetExerciseName~\GetExerciseProperty{counter}
                        \IfExercisePropertySetT{level}{%
                          \enskip\neoexerciserating
                        }
                        \IfExercisePropertySetT{subtitle}{ \GetExerciseProperty{subtitle}}\enskip
                        \IfExercisePropertySetT{points}{%
                          (\GetExerciseProperty{points}~
                          \IfExerciseGoalSingularTF{points}
                          {~\XSIMtranslate{point}}
                          {~\XSIMtranslate{points}})
                        }
                      }

                      %% Exercise Properties and Tagging
                      \ExplSyntaxOn
                      \newcommand*\neo@replicate{\prg_replicate:nn}
                      \ExplSyntaxOff

                      \DeclareExerciseTagging{level}
                      \DeclareExerciseTagging{grade}
                      \DeclareExerciseTagging{topic}
                      \DeclareExerciseTagging{subject}

                      %% ==============================================================================
                      %% Basic Exercise Box Templates
                      %% ==============================================================================

                      \DeclareExerciseProperty{icon}

                      \newcommand{\neo@exerciseicon}{%
                        \ifneo@exerciseicons
                          \IfExercisePropertySetTF{icon}{%
                            \faIcon{\GetExerciseProperty{icon}}\hspace{5pt}%
                          }{%
                            \faIcon{book}\hspace{5pt}%
                          }%
                        \fi
                      }

                      % Elegant Box Template
                      \DeclareExerciseEnvironmentTemplate{elegant-box}{%
                        \begin{tcolorbox}[%
                          neo@shared@elegant={exerciseColor},
                          title={%
                            \csname\neoschool@headstyle\endcsname
                            \csname\neoschool@headweight\endcsname
                            \color{exerciseColor}
                            {\small\neo@exerciseicon}%
                            \XSIMmixedcase{\GetExerciseName}~\GetExerciseProperty{counter}%
                            \IfExercisePropertySetT{level}{%
                              \enskip\neoexerciserating%
                            }%
                            \IfExercisePropertySetT{subtitle}{{\enskip\itshape\rmfamily\GetExerciseProperty{subtitle}}}%
                            \IfExercisePropertySetT{points}{\enskip(%
                              \GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}{\XSIMtranslate{point})}{\XSIMtranslate{points})}%
                            }\neoschool@exterminator\enskip%
                          }%
                          ]
                        }{\end{tcolorbox}}

                      % Leftrule Box Template
                      \DeclareExerciseEnvironmentTemplate{leftrule-box}{%
                        \begin{tcolorbox}[
                          neo@shared@elegant={exerciseColor},
                          frame hidden,
                          title={%
                            \csname\neoschool@headstyle\endcsname
                            \csname\neoschool@headweight\endcsname
                            \color{exerciseColor}
                            {\small\neo@exerciseicon}%
                            \XSIMmixedcase{\GetExerciseName}~\GetExerciseProperty{counter}%
                            \IfExercisePropertySetT{level}{%
                              \enskip\neoexerciserating%
                            }%
                            \IfExercisePropertySetT{subtitle}{{\enskip\itshape\rmfamily\GetExerciseProperty{subtitle}}}%
                            \IfExercisePropertySetT{points}{\enskip(%
                              \GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}{\XSIMtranslate{point})}{\XSIMtranslate{points})}%
                            }\neoschool@exterminator\enskip%
                          }%
                          ]
                        }{\end{tcolorbox}}

                      % Shaded Box Template
                      \DeclareExerciseEnvironmentTemplate{shaded-box}{%
                        \expandafter\def\csname neo@titledrawcolor@exercise\endcsname{exerciseColor}
                        \ifneo@thmnoframe
                          \expandafter\def\csname neo@titledrawcolor@exercise\endcsname{backgroundColor}
                        \fi
                        \begin{tcolorbox}[
                          neo@shared@shaded={exerciseColor}{exercise},
                          left=0.65em,
                          right=0.65em,
                          coltitle=exerciseColor,
                          title={%
                            \vspace*{0.35em}%
                            \csname\neoschool@headstyle\endcsname
                            \csname\neoschool@headweight\endcsname
                            \color{exerciseColor}
                            {\small\neo@exerciseicon}%
                            \XSIMmixedcase{\GetExerciseName}~\GetExerciseProperty{counter}%
                            \IfExercisePropertySetT{level}{%
                              \enskip\neoexerciserating%
                            }%
                            \IfExercisePropertySetT{subtitle}{{\enskip\itshape\rmfamily\GetExerciseProperty{subtitle}}}%
                            \IfExercisePropertySetT{points}{\enskip(%
                              \GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}{\XSIMtranslate{point})}{\XSIMtranslate{points})}%
                            }%
                          }%
                          ]
                        }{\end{tcolorbox}}

                      % Slanted Box Template
                      \DeclareExerciseEnvironmentTemplate{slanted-box}{%
                        \begin{tcolorbox}[
                          neo@shared@slanted={exerciseColor},
                          before upper*={%
                            \hspace*{-1.5mm}
                            \tcbox[enhanced,
                            colupper=white,
                            colback=exerciseColor,
                            fontupper=\upshape\bfseries,
                            size=small,
                            baseline=3pt,
                            after skip=1em,
                            top=0pt,
                            left=0pt,
                            right=0pt,
                            bottom=0pt,
                            nobeforeafter,
                            frame code={%
                              \path[fill=tcbcolback] (frame.north west)
                              -- ([xshift=2mm]frame.north east)
                              -- (frame.south east)
                              -- (frame.south west)
                              -- (frame.north west)
                              [sharp corners]-- cycle;
                            }
                            ]{\neo@title@other@style\csname\neoschool@headshape\endcsname
                              {\small\neo@exerciseicon}%
                              \XSIMmixedcase{\GetExerciseName}~\GetExerciseProperty{counter}%
                            }
                          }
                          ]%
                          {\neo@title@other@style\csname\neoschool@headshape\endcsname
                            \color{exerciseColor}%
                            \IfExercisePropertySetT{level}{%
                              \enskip\neoexerciserating%
                            }%
                            \IfExercisePropertySetT{subtitle}{{\enskip\itshape\rmfamily\csname\neoschool@headweight\endcsname\GetExerciseProperty{subtitle}}}%
                            \IfExercisePropertySetT{points}{%
                              \enskip(\GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}{\XSIMtranslate{point}}{\XSIMtranslate{points}})%
                            }%
                          }\enskip%
                        }{\end{tcolorbox}}

                      % Sober Box Template
                      \DeclareExerciseEnvironmentTemplate{sober-box}{%
                        \begin{tcolorbox}[
                          neo@shared@sober={exerciseColor},
                          before upper={\tcbtitle\enskip},
                          coltitle=exerciseColor,
                          title={%
                            \csname\neoschool@headstyle\endcsname
                            \csname\neoschool@headweight\endcsname
                            \color{exerciseColor}
                            {\small\neo@exerciseicon}%
                            \XSIMmixedcase{\GetExerciseName}~\GetExerciseProperty{counter}%
                            \IfExercisePropertySetT{level}{%
                              \enskip\neoexerciserating%
                            }%
                            \IfExercisePropertySetT{subtitle}{{\enskip\itshape\rmfamily\dmseries\GetExerciseProperty{subtitle}}}%
                            \IfExercisePropertySetT{points}{\enskip(%
                              \GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}{\XSIMtranslate{point})}{\XSIMtranslate{points})}%
                            }\neoschool@exterminator\enskip%
                          }%
                          ]
                        }{\end{tcolorbox}}

                      % Classic Box Template
                      \DeclareExerciseEnvironmentTemplate{classic-box}{%
                        \begin{tcolorbox}[
                          neo@shared@classic={exerciseColor},
                          righttitle=-5pt,
                          title={%
                            \csname\neoschool@headstyle\endcsname
                            \csname\neoschool@headweight\endcsname
                            \color{white}
                            {\small\neo@exerciseicon}%
                            \XSIMmixedcase{\GetExerciseName}~\GetExerciseProperty{counter}%
                            \IfExercisePropertySetT{level}{%
                              \enskip\neoexerciserating%
                            }%
                            \IfExercisePropertySetT{subtitle}{{\enskip\itshape\rmfamily\GetExerciseProperty{subtitle}}}%
                            \IfExercisePropertySetT{points}{\hfill(%
                              \GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}{\XSIMtranslate{point})}{\XSIMtranslate{points})}%
                            }%
                          }%
                          ]
                        }{\end{tcolorbox}}

                      % Classy Box Template
                      \DeclareExerciseEnvironmentTemplate{classy-box}{%
                        \begin{tcolorbox}[
                          neo@shared@classy={exerciseColor},
                          title={%
                            \csname\neoschool@headstyle\endcsname
                            \csname\neoschool@headweight\endcsname
                            \color{white}
                            {\small\neo@exerciseicon}%
                            \XSIMmixedcase{\GetExerciseName}~\GetExerciseProperty{counter}%
                            \IfExercisePropertySetT{level}{%
                              \enskip\neoexerciserating%
                            }%
                            \IfExercisePropertySetT{subtitle}{{\enskip\itshape\rmfamily\GetExerciseProperty{subtitle}}}%
                            \IfExercisePropertySetT{points}{\enskip(%
                              \GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}{\XSIMtranslate{point})}{\XSIMtranslate{points})}%
                            }%
                          }%
                          ]
                        }{\end{tcolorbox}}

                      % Rect and Num box Templates
                      \DeclareExerciseEnvironmentTemplate{rect-box}{%
                        \begin{tcolorbox}[
                          enhanced,
                          breakable,
                          parbox=false,
                          skin=bicolor,
                          neo ex arcs,
                          \neo@framehidden,
                          boxrule=\neo@normalrule,
                          colframe=exerciseColor,
                          neo@exbackstyle,
                          colupper=\neoschool@globalcolor,
                          coltitle=backgroundColor,
                          fonttitle=\csname\neoschool@headweight\endcsname,
                          left=\neo@leftpadding,
                          right=\neo@rightpadding,
                          after skip=\neo@effective@afterskip,
                          before skip=\neo@effective@beforeskip,
                          top=4pt,
                          bottom=4pt,
                          before upper*={%
                            \hspace*{-5pt}
                            \tcbox[enhanced,
                            colupper=backgroundColor,
                            fontupper=\csname\neoschool@headweight\endcsname,
                            colback=exerciseColor,
                            colframe=exerciseColor,
                            boxrule=\neo@thickrule,
                            size=small,
                            baseline=5.5pt,
                            arc=\neoschool@exboxarc,
                            neo ex arcs,
                            top=-1pt,
                            bottom=-0.5pt,
                            left=0pt,
                            right=0pt,
                            nobeforeafter,
                            ]%
                            {%
                              \csname\neoschool@headstyle\endcsname
                              \csname\neoschool@headweight\endcsname
                              \csname\neoschool@headshape\endcsname
                              {\small\neo@exerciseicon}%
                              \XSIMmixedcase{\GetExerciseName}\nobreakspace\GetExerciseProperty{counter}%
                            }%
                          }%
                          ]%
                          {%
                            \neo@title@other@style\csname\neoschool@headshape\endcsname
                            \color{exerciseColor}%
                            \IfExercisePropertySetT{level}%
                            {\enskip\neoexerciserating}%
                            \IfExercisePropertySetT{subtitle}{{\enskip\itshape\rmfamily\csname\neoschool@headweight\endcsname\GetExerciseProperty{subtitle}}}%
                            \IfExercisePropertySetT{points}{%
                              \enskip(\GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}{point}{points})%
                            }%
                            \enskip%
                          }%
                        }{\end{tcolorbox}}

                      \DeclareExerciseEnvironmentTemplate{rect-box-out}{%
                        \begin{tcolorbox}[
                          enhanced,
                          breakable,
                          parbox=false,
                          skin=bicolor,
                          arc=\neoschool@exboxarc,
                          neo ex arcs,
                          \neo@framehidden,
                          boxrule=\neo@normalrule,
                          colframe=exerciseColor,
                          neo@exbackstyle,
                          colupper=\neoschool@globalcolor,
                          left=\neo@leftpadding,
                          right=\neo@rightpadding,
                          after skip=\neo@effective@afterskip,
                          before skip=\neo@effective@beforeskip,
                          top=4pt,
                          bottom=4pt,
                          before upper*={%
                            \hspace*{-5pt}
                            \tcbox[enhanced,
                            colupper=exerciseColor,
                            fontupper=\csname\neoschool@headweight\endcsname,
                            colback=backgroundColor,
                            colframe=exerciseColor,
                            boxrule=\neo@thickrule,
                            size=small,
                            baseline=5.5pt,
                            arc=\neoschool@exboxarc,
                            neo ex arcs,
                            top=-1pt,
                            bottom=-0.5pt,
                            left=0pt,
                            right=0pt,
                            nobeforeafter,
                            ]%
                            {%
                              \csname\neoschool@headstyle\endcsname
                              \csname\neoschool@headweight\endcsname
                              \csname\neoschool@headshape\endcsname
                              {\small\neo@exerciseicon}%
                              \XSIMmixedcase{\GetExerciseName}\nobreakspace\GetExerciseProperty{counter}%
                            }%
                          }
                          ]%
                          {
                            \neo@title@other@style\csname\neoschool@headshape\endcsname
                            \color{exerciseColor}%
                            \IfExercisePropertySetT{level}
                            {\enskip\neoexerciserating}%
                            \IfExercisePropertySetT{subtitle}{\enskip\itshape\rmfamily\csname\neoschool@headweight\endcsname\GetExerciseProperty{subtitle}}%
                            \IfExercisePropertySetT{points}{%
                              \enskip(\GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}{point}{points})%
                            }%
                            \enskip%
                          }
                        }{\end{tcolorbox}}

                      \DeclareExerciseEnvironmentTemplate{num-box}{%
                        \begin{tcolorbox}[
                          enhanced,
                          breakable,
                          parbox=false,
                          skin=bicolor,
                          before skip=\neo@effective@ex@beforeafterskip,
                          after skip=\neo@effective@ex@beforeafterskip,
                          frame hidden,
                          top=-2pt,
                          bottom=-2pt,
                          colframe=exerciseColor,
                          colback=backgroundColor,
                          colupper=\neoschool@globalcolor,
                          fontupper=\color{\neoschool@globalcolor},
                          enlarge left by=-.5\leftmargin,
                          enlarge right by=-.5\rightmargin,
                          width=\textwidth+\leftmargin+\rightmargin,
                          before upper*={%
                            \hspace*{-4pt}
                            \tcbox[enhanced,
                            colupper=backgroundColor,
                            colback=exerciseColor,
                            colframe=exerciseColor,
                            fontupper=\csname\neoschool@headweight\endcsname,
                            size=small,
                            neo ex arcs,
                            baseline=5.5pt,
                            top=0pt,
                            bottom=0pt,
                            left=0pt,
                            right=0pt,
                            nobeforeafter,
                            ]%
                            {%
                              \csname\neoschool@headstyle\endcsname
                              \csname\neoschool@headweight\endcsname
                              {\small\neo@exerciseicon}%
                              \GetExerciseProperty{counter}%
                            }%
                          }
                          ]%
                          {\neo@title@other@style
                            \color{exerciseColor}
                            \IfExercisePropertySetT{level}
                            {\enskip\neoexerciserating}%
                            \IfExercisePropertySetT{subtitle}{\enskip\itshape\rmfamily\csname\neoschool@headweight\endcsname\GetExerciseProperty{subtitle}}%
                            \IfExercisePropertySetT{points}{%
                              \enskip(\GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}{\XSIMtranslate{point-short}}{\XSIMtranslate{points-short}})%
                            }%
                          }%
                          \enskip
                        }{\end{tcolorbox}}

                      \DeclareExerciseEnvironmentTemplate{num-box-out}{%
                        \begin{tcolorbox}[
                          enhanced,
                          breakable,
                          parbox=false,
                          skin=bicolor,
                          before skip=\neo@effective@ex@beforeafterskip,
                          after skip=\neo@effective@ex@beforeafterskip,
                          frame hidden,
                          top=-2pt,
                          bottom=-2pt,
                          colback=backgroundColor,
                          colupper=\neoschool@globalcolor,
                          fontupper=\color{\neoschool@globalcolor},
                          enlarge left by=-.5\leftmargin,
                          enlarge right by=-.5\rightmargin,
                          width=\textwidth+\leftmargin+\rightmargin,
                          before upper*={%
                            \hspace*{-3.5pt}
                            \tcbox[enhanced,
                            colupper=exerciseColor,
                            colback=backgroundColor,
                            colframe=exerciseColor,
                            fontupper=\csname\neoschool@headweight\endcsname,
                            neo ex arcs,
                            size=small,
                            baseline=5.5pt,
                            top=0pt,
                            bottom=0pt,
                            left=0pt,
                            right=0pt,
                            nobeforeafter,
                            ]%
                            {%
                              \csname\neoschool@headstyle\endcsname
                              \csname\neoschool@headweight\endcsname
                              {\small\neo@exerciseicon}%
                              \GetExerciseProperty{counter}%
                            }%
                          }
                          ]%
                          {\neo@title@other@style
                            \color{exerciseColor}
                            \IfExercisePropertySetT{level}
                            {\enskip\neoexerciserating}%
                            \IfExercisePropertySetT{subtitle}{\enskip\itshape\rmfamily\csname\neoschool@headweight\endcsname\GetExerciseProperty{subtitle}}%
                            \IfExercisePropertySetT{points}{%
                              \enskip(\GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}{\XSIMtranslate{point-short}}{\XSIMtranslate{points-short}})%
                            }%
                          }%
                          \enskip%
                        }{\end{tcolorbox}}

                      \DeclareExerciseEnvironmentTemplate{ex-num-box}{%
                        \begin{tcolorbox}[
                          enhanced,
                          breakable,
                          parbox=false,
                          before skip=\neo@effective@ex@beforeafterskip,
                          after skip=\neo@effective@ex@beforeafterskip,
                          frame hidden,
                          top=-2pt,
                          bottom=-2pt,
                          colframe=exerciseColor,
                          colback=backgroundColor,
                          colupper=\neoschool@globalcolor,
                          fontupper=\color{\neoschool@globalcolor},
                          enlarge left by=-.5\leftmargin,
                          enlarge right by=-.5\rightmargin,
                          width=\textwidth+\leftmargin+\rightmargin,
                          before upper*={%
                            \tcbox[enhanced,
                            colupper=backgroundColor,
                            colback=exerciseColor,
                            colframe=exerciseColor,
                            fontupper=\csname\neoschool@headweight\endcsname,
                            size=small,
                            neo ex arcs,
                            baseline=5.5pt,
                            top=0pt,
                            bottom=0pt,
                            left=0pt,
                            right=0pt,
                            nobeforeafter,
                            ]%
                            {%
                              \neo@title@other@style
                              {\small\neo@exerciseicon}%
                              Ex.~\GetExerciseProperty{counter}%
                            }%
                          }
                          ]%
                          {\neo@title@other@style
                            \color{exerciseColor}
                            \enskip%
                            \IfExercisePropertySetT{level}
                            {\neoexerciserating\enskip}%
                            \IfExercisePropertySetT{subtitle}{\itshape\rmfamily\csname\neoschool@headweight\endcsname\GetExerciseProperty{subtitle}\enskip}%
                            \IfExercisePropertySetT{points}{%
                              (\GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}{\XSIMtranslate{point-short}}{\XSIMtranslate{points-short}})%
                            }%
                          }%
                          \enskip
                        }{\end{tcolorbox}}

                      \DeclareExerciseEnvironmentTemplate{ex-num-box-out}{%
                        \begin{tcolorbox}[
                          enhanced,
                          breakable,
                          parbox=false,
                          before skip=\neo@effective@ex@beforeafterskip,
                          after skip=\neo@effective@ex@beforeafterskip,
                          frame hidden,
                          top=-2pt,
                          bottom=-2pt,
                          colframe=exerciseColor,
                          colback=backgroundColor,
                          colupper=\neoschool@globalcolor,
                          fontupper=\color{\neoschool@globalcolor},
                          enlarge left by=-.5\leftmargin,
                          enlarge right by=-.5\rightmargin,
                          width=\textwidth+\leftmargin+\rightmargin,
                          before upper*={%
                            \hspace*{-4pt}
                            \tcbox[enhanced,
                            colupper=exerciseColor,
                            colback=backgroundColor,
                            colframe=exerciseColor,
                            fontupper=\csname\neoschool@headweight\endcsname,
                            size=small,
                            neo ex arcs,
                            boxrule=\neo@thickrule,
                            baseline=5.5pt,
                            top=0pt,
                            bottom=0pt,
                            left=0pt,
                            right=0pt,
                            nobeforeafter,
                            ]%
                            {%
                              \neo@title@other@style
                              {\small\neo@exerciseicon}%
                              Ex.~\GetExerciseProperty{counter}%
                            }%
                          }
                          ]%
                          {\csname\neoschool@headstyle\endcsname
                            \csname\neoschool@headweight\endcsname
                            \color{exerciseColor}
                            \enskip%
                            \IfExercisePropertySetT{level}
                            {\neoexerciserating\enskip}%
                            \IfExercisePropertySetT{subtitle}{\itshape\rmfamily\csname\neoschool@headweight\endcsname\GetExerciseProperty{subtitle}\enskip}%
                            \IfExercisePropertySetT{points}{%
                              (\GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}{\XSIMtranslate{point-short}}{\XSIMtranslate{points-short}})%
                            }%
                          }%
                          \enskip
                        }{\end{tcolorbox}}

                      %%% Chevrons for Rules

                      \newcommand{\lchevrons}{%
                        \begin{tikzpicture}[scale=0.1, baseline=0.2mm, line width=1.2pt]
                          \draw (0,0) -- (-1,1.25) -- (0,2.5);
                          \draw (2,0) -- (1,1.25) -- (2,2.5);
                          \draw (4,0) -- (3,1.25) -- (4,2.5);
                        \end{tikzpicture}%
                      }

                      \newcommand{\lcircle}{%
                        \begin{tikzpicture}[scale=1, baseline=-1mm, line width=1.2pt]
                          \draw (0,0) circle (3pt);
                        \end{tikzpicture}%
                      }

                      %%% Horizontal Rule with Boxed Title

                      \DeclareExerciseEnvironmentTemplate{box-hrule}{%
                        \par\vspace{\neo@effective@ex@beforeafterskip}
                        \noindent
                        {\neo@title@style
                          \tcbox[on line,boxsep=-2pt,boxrule=\neo@thinrule,left=7pt,right=7pt,bottom=6pt,colframe=exerciseColor,colback=exerciseColor,sharp corners, rounded corners = southeast]{\color{white}{\small\neo@exerciseicon}\XSIMmixedcase{\GetExerciseName}\nobreakspace\GetExerciseProperty{counter}}%
                          \color{exerciseColor}
                          \IfExercisePropertySetT{level}
                          {\enskip\neoexerciserating}%
                          \IfInsideSolutionF{%
                            \GetExercisePropertyT{subtitle}{{\enskip\itshape\rmfamily\csname\neoschool@headweight\endcsname{\PropertyValue}\enskip}}%
                          }%
                          \hspace*{-1pt}\xrfill[.085cm]{1.2pt}[exerciseColor]\hspace*{-1pt}%
                          {\color{exerciseColor}\footnotesize\lchevrons}%
                          {%
                            \IfExercisePropertySetT{points}{\bfseries\color{exerciseColor}\enskip%
                              \GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}
                              {\XSIMtranslate{point}}
                              {\XSIMtranslate{points}}%
                            }%
                          }%
                        }%
                        {\parfillskip0pt\par}
                        \@afterindentfalse\@afterheading
                      }{\par\vspace{\neo@effective@ex@beforeafterskip}}

                      %%% Horizontal Rule with Boxed Title - Outlined

                      \DeclareExerciseEnvironmentTemplate{box-hrule-out}{%
                        \par\vspace{\neo@effective@ex@beforeafterskip}
                        \noindent
                        {\neo@title@style\tcbox[on line,boxsep=-2pt,boxrule=\neo@thickrule,left=7pt,right=7pt,colframe=exerciseColor,colback=backgroundColor,sharp corners,
                          rounded corners = east,arc=5pt
                          ]{\color{exerciseColor}{\small\neo@exerciseicon}\XSIMmixedcase{\GetExerciseName}\nobreakspace\GetExerciseProperty{counter}}%
                          \color{exerciseColor}%
                          \IfExercisePropertySetT{level}
                          {\enskip\neoexerciserating}%
                          \IfInsideSolutionF{%
                            \GetExercisePropertyT{subtitle}{{\enskip\itshape\rmfamily\csname\neoschool@headweight\endcsname{\PropertyValue}\enskip}}%
                          }%
                          \hspace*{-1pt}\xrfill[.085cm]{1.2pt}[exerciseColor]\hspace*{-1pt}%
                          {\color{exerciseColor}\footnotesize\lchevrons}%
                          {\bfseries\color{exerciseColor}%
                            \IfExercisePropertySetT{points}{\enskip%
                              \GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}
                              {\XSIMtranslate{point}}
                              {\XSIMtranslate{points}}%
                            }%
                          }%
                        }%
                        {\parfillskip0pt\par}
                        \@afterindentfalse\@afterheading
                      }{\par\vspace{-\parskip}\vspace{\neo@effective@ex@beforeafterskip}}

                      \DeclareExerciseEnvironmentTemplate{box-hrule-in}{%
                        \par\vspace{\neo@effective@ex@beforeafterskip}
                        \noindent
                        {\neo@title@style\color{exerciseColor}%
                          \tcbox[on line,boxsep=-2pt,boxrule=\neo@thickrule,left=7pt,right=7pt,colframe=exerciseColor,colback=backgroundColor,sharp corners,
                          rounded corners = west,arc=5pt
                          ]{\color{exerciseColor}{\small\neo@exerciseicon}\XSIMmixedcase{\GetExerciseName}\nobreakspace\GetExerciseProperty{counter}}%
                          \color{exerciseColor}
                          \IfExercisePropertySetT{level}
                          {\enskip\neoexerciserating}%
                          \IfInsideSolutionF{%
                            \GetExercisePropertyT{subtitle}{{\enskip\itshape\rmfamily\csname\neoschool@headweight\endcsname{\PropertyValue}\enskip}}%
                          }%
                          \hspace{-1pt}\xrfill[.085cm]{1.2pt}[exerciseColor]\hspace{-1pt}%
                          {\color{exerciseColor}\small\lcircle}%
                          {\bfseries\color{exerciseColor}%
                            \IfExercisePropertySetT{points}{\enskip%
                              \GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}
                              {\XSIMtranslate{point}}
                              {\XSIMtranslate{points}}%
                            }}}%
                        {\parfillskip0pt\par}
                        \@afterindentfalse\@afterheading
                      }{\par\vspace{-\parskip}\vspace{\neo@effective@ex@beforeafterskip}}

                      %%% Boxed Title

                      \DeclareExerciseEnvironmentTemplate{boxed}{%
                        \par\vspace{-\parskip}\vspace{\neo@effective@ex@beforeafterskip}
                        \noindent
                        {\neo@title@other@style\csname\neoschool@headshape\endcsname
                          \tcbox[
                          on line,
                          top=-1pt,
                          bottom=-0.5pt,
                          left=0pt,
                          right=0pt,
                          before skip=0pt,
                          colframe=exerciseColor,
                          colback=exerciseColor,
                          neo ex arcs,
                          ]{%
                            \color{backgroundColor}{\small\neo@exerciseicon}%
                            \XSIMmixedcase{\GetExerciseName}\nobreakspace\GetExerciseProperty{counter}%
                          }%
                        }%
                        {%
                          \neo@title@other@style\csname\neoschool@headshape\endcsname
                          \color{exerciseColor}
                          \enskip%
                          \IfExercisePropertySetT{level}
                          {\neoexerciserating\enskip}%
                          \IfExercisePropertySetT{subtitle}{{\itshape\rmfamily\csname\neoschool@headweight\endcsname\GetExerciseProperty{subtitle}\enskip}}%
                          \IfExercisePropertySetT{points}{%
                            (\GetExerciseProperty{points}~%
                            \IfExerciseGoalSingularTF{points}{point}{points})\enskip%
                          }%
                        }%
                      }{\par\vspace{-\parskip}\vspace{\neo@effective@ex@beforeafterskip}}

                      %%% Boxed Title - Outlined

                      \DeclareExerciseEnvironmentTemplate{boxed-out}{%
                        \par\vspace{-\parskip}\vspace{\neo@effective@ex@beforeafterskip}
                        \noindent
                        {\csname\neoschool@headstyle\endcsname
                          \csname\neoschool@headweight\endcsname
                          \csname\neoschool@headshape\endcsname
                          \tcbox[
                          on line,
                          boxrule=\neo@normalrule,
                          top=-1pt,
                          bottom=-0.5pt,
                          left=0pt,
                          right=0pt,
                          before skip=0pt,
                          colframe=exerciseColor,
                          colback=backgroundColor,
                          neo ex arcs,
                          ]{%
                            \color{exerciseColor}{\small\neo@exerciseicon}%
                            \XSIMmixedcase{\GetExerciseName}\nobreakspace\GetExerciseProperty{counter}%
                          }%
                        }%
                        {%
                          \neo@title@other@style\csname\neoschool@headshape\endcsname
                          \color{exerciseColor}
                          \enskip%
                          \IfExercisePropertySetT{level}
                          {\neoexerciserating\enskip}%
                          \IfExercisePropertySetT{subtitle}{{\itshape\rmfamily\csname\neoschool@headweight\endcsname\GetExerciseProperty{subtitle}\enskip}}%
                          \IfExercisePropertySetT{points}{%
                            (\GetExerciseProperty{points}~%
                            \IfExerciseGoalSingularTF{points}{point}{points})%
                          }%
                        }%
                        \hspace{2pt}
                      }{\par\vspace{-\parskip}\vspace{\neo@effective@ex@beforeafterskip}}


                      %% ==============================================================================
                      %% Simple Style Templates
                      %% ==============================================================================

                      %% Common Style Settings
                      \newcommand{\neo@startsection}[1]{%
                        \@startsection{paragraph}{4}{\z@}{0.25\baselineskip}{-1em}
                        {\neo@title@style\color{#1}}
                      }

                      %% Inline Style
                      %% ----------------------------------
                      \DeclareExerciseEnvironmentTemplate{inline}{%
                        \neo@startsection{exerciseColor}
                        {%
                          {\small\neo@exerciseicon}%
                          \XSIMmixedcase{\GetExerciseName}\nobreakspace\GetExerciseProperty{counter}%
                          \IfExercisePropertySetT{level}{%
                            \enskip\neoexerciserating
                          }%
                          \GetExercisePropertyT{subtitle}{{\enskip\itshape\rmfamily\csname\neoschool@headweight\endcsname\PropertyValue}}%
                          {\IfExercisePropertySetT{points}{%
                              \enskip(\GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}
                              {\XSIMtranslate{point})}
                              {\XSIMtranslate{points})}}%
                          }\neoschool@exterminator\enskip%
                        }
                        \color{\neoschool@globalcolor}\nobreak\hspace{-1.15em}
                      }{\par\vspace{-\parskip}\vspace{\neo@effective@afterskip}}


                      %% Section Style
                      %% ----------------------------------
                      \DeclareExerciseEnvironmentTemplate{section}{%
                        \par\vspace{-4\parskip}\vspace{\neo@effective@afterskip}
                        \section*{%
                          {\small\neo@exerciseicon}%
                          \XSIMmixedcase{\GetExerciseName}\nobreakspace\GetExerciseProperty{counter}%
                          \IfExercisePropertySetT{level}{%
                            \enskip\neoexerciserating
                          }%
                          \IfExercisePropertySetT{subtitle}{{\enskip\itshape\rmfamily\csname\neoschool@headweight\endcsname\GetExerciseProperty{subtitle}}}%
                          \IfExercisePropertySetT{points}{\enskip(%
                            \GetExerciseProperty{points}~%
                            \IfExerciseGoalSingularTF{points}
                            {\XSIMtranslate{point})}
                            {\XSIMtranslate{points})}
                          }%
                        }%
                        \vspace*{-3\parskip}\vspace{\neo@effective@ex@beforeafterskip}%
                        \color{\neoschool@globalcolor}%
                      }{\par\vspace{\neo@effective@ex@beforeafterskip}}

                      %% Terminal Style
                      \DeclareExerciseEnvironmentTemplate{terminal}{%
                        \neo@startsection{exerciseColor}
                        {%
                          {\small\neo@exerciseicon}%
                          \XSIMmixedcase{\GetExerciseName}\nobreakspace\GetExerciseProperty{counter}\enskip%
                          \IfExercisePropertySetT{level}{%
                            \neoexerciserating\enskip}%
                          \GetExercisePropertyT{subtitle}{{\itshape\rmfamily\csname\neoschool@headweight\endcsname\PropertyValue}\enskip}%
                          \IfExercisePropertySetT{points}{(%
                            \GetExerciseProperty{points}~%
                            \IfExerciseGoalSingularTF{points}
                            {\XSIMtranslate{point})}%
                            {\XSIMtranslate{points})}%
                            \enskip%
                          }%
                          {\small\faTerminal}%
                        }%
                        \color{\neoschool@globalcolor}\!%
                      }{\par\vspace{-\parskip}\vspace{\neo@effective@ex@beforeafterskip}}

                      \DeclareExerciseEnvironmentTemplate{subsection}{%
                        \par\vspace{-4\parskip}\vspace{\neo@effective@afterskip}
                        \subsection*{%
                          \begingroup
                          \color{exerciseColor}
                          {\small\neo@exerciseicon}%
                          \XSIMmixedcase{\GetExerciseName}\nobreakspace
                          \GetExerciseProperty{counter}%
                          \IfExercisePropertySetT{level}{%
                            \enskip\neoexerciserating}%
                          \IfInsideSolutionF{%
                            \GetExercisePropertyT{subtitle}
                            {{\enskip\itshape\rmfamily\normalsize\csname\neoschool@headweight\endcsname\PropertyValue}}
                            \IfExercisePropertySetT{points}{%
                              \normalsize%
                              \hfill
                              (\GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}
                              {\XSIMtranslate{point}}%
                              {\XSIMtranslate{points}}%
                              )%
                            }%
                          }%
                          \endgroup
                        }%
                        \vspace{-\neo@effective@ex@beforeafterskip}
                      }{\par\vspace{-\parskip}\vspace{\neo@effective@ex@beforeafterskip}}

                      %% ==============================================================================
                      %% Horizontal Rule Style
                      %% ==============================================================================

                      \DeclareExerciseEnvironmentTemplate{hrule}{%
                        \par\vspace{-\parskip}\vspace{\neo@effective@ex@beforeafterskip}
                        \Needspace*{3\baselineskip}
                        \noindent
                        \begingroup
                        \color{exerciseColor}
                        \neo@title@style
                        {\small\neo@exerciseicon}%
                        \XSIMmixedcase{\GetExerciseName}\nobreakspace\GetExerciseProperty{counter}%
                        \IfExercisePropertySetT{level}{%
                          \enskip\neoexerciserating%
                        }
                        \IfInsideSolutionF{%
                          \GetExercisePropertyT{subtitle}{{{\enskip\itshape\rmfamily\csname\neoschool@headweight\endcsname\PropertyValue}\enskip}}%
                        }%
                        \xrfill[.075cm]{\neo@normalrule}[exerciseColor]
                        {\color{exerciseColor}
                          \IfExercisePropertySetT{points}{\enskip%
                            \GetExerciseProperty{points}~%
                            \IfExerciseGoalSingularTF{points}
                            {\XSIMtranslate{point}}%
                            {\XSIMtranslate{points}}%
                          }%
                        }%
                        \endgroup%
                        {\parfillskip0pt\par}\vspace{-0.5\parskip}
                        \@afterindentfalse\@afterheading
                      }{\par\vspace{-\parskip}\vspace{\neo@effective@ex@beforeafterskip}}

                      %% ==============================================================================
                      %% Solution Configuration
                      %% ==============================================================================

                      % Solution templates
                      \DeclareExerciseEnvironmentTemplate{sol-dotted}{%
                        \needspace{3\baselineskip}%
                        \par\vspace{-\parskip}\vspace{\neo@effective@ex@beforeafterskip}
                        \noindent%
                        {\color{solutionColor}
                          \neo@title@style
                          \XSIMmixedcase{\GetExerciseName}%
                          \csname neo@solutiongaptext\endcsname%
                          \GetExerciseProperty{counter}%
                        }%
                        \enskip{\color{solutionColor}{\dotfill}}%
                        \par\vspace{-\parskip}\vspace{0.25\baselineskip}%
                      }{\nopagebreak%
                        \par\vspace{-\parskip}%
                        \noindent{\color{solutionColor}\dotfill}%
                        \par\vspace{-\parskip}\vspace{\neo@effective@ex@beforeafterskip}}

                      \DeclareExerciseEnvironmentTemplate{sol-block}{%
                        \needspace{3\baselineskip}%
                        \par\vspace{-\parskip}\vspace{\neo@effective@ex@beforeafterskip}%
                        \noindent%
                        \makebox[\linewidth]{%
                          \color{solutionColor}%
                          \neo@title@style
                          \neo@solutionname~\csname neo@solutiongaptext\endcsname\GetExerciseProperty{counter}%
                          \hspace{.75em}%
                          \xrfill[0ex]{\neo@decorativerule}[solutionColor]%
                        }%
                        \par%
                      }{%
                        \nopagebreak%
                        \par%
                        \vspace{-\parskip}%
                        \ifneoschool@answersonly\else
                          \noindent\color{solutionColor}\rule{\linewidth}{\neo@decorativerule}%
                        \fi
                        \par\vspace{-\parskip}\vspace{\neo@effective@ex@beforeafterskip}%
                      }

                      \DeclareExerciseEnvironmentTemplate{sol-inline}{%
                        \par\vspace{-\parskip}\vspace{\neo@effective@ex@beforeafterskip}
                        \noindent
                        {\color{solutionColor}
                          \neo@title@style
                          \XSIMmixedcase{\GetExerciseName}
                          \csname neo@solutiongaptext\endcsname
                          \GetExerciseProperty{counter}\neoschool@exterminator\hspace{0.55em}%
                        }%
                      }{\par\vspace{-\parskip}\vspace{\neo@effective@ex@beforeafterskip}}

                      %% ==============================================================================
                      %% Smart Boxes
                      %% ==============================================================================
                      \DeclareExerciseProperty{answer-type}

                      \DeclareExerciseEnvironmentTemplate{smart-box}{%
                        \begin{tcolorbox}[%
                          neo@box@base,
                          neo@frame@basic,
                          neo@title@colored,
                          title={%
                            \raisebox{0pt}{\textcolor{white}{\small\neo@exerciseicon}}%
                            \neo@title@style
                            \XSIMmixedcase{\GetExerciseName}~\GetExerciseProperty{counter}%
                            \IfExercisePropertySetT{level}{%
                              \enskip\neoexerciserating%
                            }%
                            \IfExercisePropertySetT{subtitle}{\enskip\itshape\rmfamily\csname\neoschool@headweight\endcsname\GetExerciseProperty{subtitle}}%
                            \hfill
                            \IfExercisePropertySetT{points}{%
                              \GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}{point}{points}%
                            }%
                          }%
                          ]%
                        }{\end{tcolorbox}}

                      \DeclareExerciseEnvironmentTemplate{rule-ams}{%
                        \par\vspace{-\parskip}\vspace{\neo@effective@ex@beforeafterskip}
                        \Needspace*{3\baselineskip}
                        \noindent
                        \makebox[\linewidth][l]{%
                          {\color{exerciseColor}%
                            {\small\neo@exerciseicon}%
                            \neo@title@style
                            \XSIMmixedcase{\GetExerciseName}\nobreakspace\GetExerciseProperty{counter}%
                            \IfExercisePropertySetT{level}{%
                              \enskip\neoexerciserating%
                            }%
                            \IfExercisePropertySetT{subtitle}{%
                              {\enskip\itshape\rmfamily\csname\neoschool@headweight\endcsname\GetExerciseProperty{subtitle}}%
                            }%
                            \hfill%
                            \IfExercisePropertySetT{points}{%
                              \enskip%
                              \GetExerciseProperty{points}~%
                              \IfExerciseGoalSingularTF{points}{point}{points}%
                            }%
                          }%
                        }\\[-1ex]%
                        \noindent%
                        \tikz[baseline]{\draw[line width=\neo@thinrule, exerciseColor!65, line cap=round] (0,0) -- (\linewidth,0);}%
                        \par
                        \@afterindentfalse\@afterheading
                      }{\par\vspace{-\parskip}\vspace{\neo@effective@ex@beforeafterskip}}

                      %% ==============================================================================
                      %% Exercise Configuration
                      %% ==============================================================================

                      % Enable solutions if answers option is active
                      \ifneoschool@answers
                        \xsimsetup{%
                          solution/print=true
                        }
                      \fi

                      \ifneoschool@answersonly
                        \xsimsetup{%
                          exercise/print=false,
                          solution/print=true
                        }
                      \fi

                      % Base exercise setup
                      \ifneoschool@sectionthmcounter
                        \ifneoschool@sharedexcounter
                          \xsimsetup{%
                            exercise/within = section,
                            exercise/name = {\neo@exercisename},
                            solution/name = {\neo@solutionname},
                            solution/template = sol-inline
                          }
                          \renewcommand*{\theexercise}{\thesection.\arabic{thmcounter}}
                          \AtBeginEnvironment{exercise}{\stepcounter{thmcounter}\addtocounter{exercise}{-1}}
                        \else
                          \xsimsetup{%
                            exercise/within = section,
                            exercise/name = {\neo@exercisename},
                            solution/name = {\neo@solutionname},
                            solution/template = sol-inline
                          }
                        \fi
                      \else
                        \ifneoschool@sharedexcounter
                          \xsimsetup{%
                            exercise/name = {\neo@exercisename},
                            solution/name = {\neo@solutionname},
                            solution/template = sol-inline
                          }
                          \renewcommand*{\theexercise}{\arabic{thmcounter}}
                          \AtBeginEnvironment{exercise}{\stepcounter{thmcounter}\addtocounter{exercise}{-1}}
                        \else
                          \xsimsetup{%
                            exercise/name = {\neo@exercisename},
                            solution/name = {\neo@solutionname},
                            solution/template = sol-inline
                          }
                        \fi
                      \fi

                      % Style selection based on class options
                      \IfStrEqCase{\neoschool@exstyle}{%
                        {amslike}{\xsimsetup{exercise/template=inline}}%
                        {classy}{\xsimsetup{exercise/template=classy-box}}%
                        {classic}{\xsimsetup{exercise/template=classic-box}}%
                        {sober}{\xsimsetup{exercise/template=sober-box}}%
                        {elegant}{\xsimsetup{exercise/template=elegant-box}}%
                        {shaded}{\xsimsetup{exercise/template=shaded-box}}%
                        {slanted}{\xsimsetup{exercise/template=slanted-box}}%
                        {leftrule}{\xsimsetup{exercise/template=leftrule-box}}%
                        {classy-box}{\xsimsetup{exercise/template=classy-box}}%
                        {classic-box}{\xsimsetup{exercise/template=classic-box}}%
                        {sober-box}{\xsimsetup{exercise/template=sober-box}}%
                        {elegant-box}{\xsimsetup{exercise/template=elegant-box}}%
                        {shaded-box}{\xsimsetup{exercise/template=shaded-box}}%
                        {slanted-box}{\xsimsetup{exercise/template=slanted-box}}%
                        {rect-box}{\xsimsetup{exercise/template=rect-box}}%
                        {rect-box-out}{\xsimsetup{exercise/template=rect-box-out}}%
                        {num-box}{\xsimsetup{exercise/template=num-box}}%
                        {num-box-out}{\xsimsetup{exercise/template=num-box-out}}%
                        {ex-num-box}{\xsimsetup{exercise/template=ex-num-box}}%
                        {ex-num-box-out}{\xsimsetup{exercise/template=ex-num-box-out}}%
                        {box-hrule}{\xsimsetup{exercise/template=box-hrule}}%
                        {box-hrule-out}{\xsimsetup{exercise/template=box-hrule-out}}%
                        {box-hrule-in}{\xsimsetup{exercise/template=box-hrule-in}}%
                        {boxed}{\xsimsetup{exercise/template=boxed}}%
                        {boxed-out}{\xsimsetup{exercise/template=boxed-out}}%
                        {inline}{\xsimsetup{exercise/template=inline}}%
                        {section}{\xsimsetup{exercise/template=section}}%
                        {subsection}{\xsimsetup{exercise/template=subsection}}%
                        {terminal}{\xsimsetup{exercise/template=terminal}}%
                        {hrule}{\xsimsetup{exercise/template=hrule}}%
                        {rule-ams}{\xsimsetup{exercise/template=rule-ams}}%
                        {smart-box}{\xsimsetup{exercise/template=smart-box}}%
                      }[\xsimsetup{exercise/template=inline}]

                      \ifneo@blocksol
                        \xsimsetup{solution/template=sol-block}
                      \fi

                      %% ==============================================================================
                      %% Referencing an exercise
                      %% ==============================================================================

                      \ExplSyntaxOn
                      \NewDocumentCommand \exercisenumber {m}
                      {
                        \xsim_get_property:nxn
                        {exercise}
                        { \xsim_get_id_for_property:nn {ID} {#1} }
                        {counter}
                      }
                      \cs_generate_variant:Nn \xsim_get_property:nnn {nx}
                      \ExplSyntaxOff

                      %% ==============================================================================
                      %% Utility Commands for Exercises
                      %% ==============================================================================

                      % Print exercises by level
                      \NewDocumentCommand\printlevelexid{m}{%
                        \noindent {\bfseries \csname neo@pathname\endcsname\space#1 :}
                        \ForEachUsedExerciseByType{%
                          \def\ExerciseType{##1}
                          \def\ExerciseID{##2}
                          \IfExercisePropertySetT{level}{%
                            \ifnum\GetExerciseProperty{level}=#1
                              \fbox{\GetExerciseProperty{id}}\hspace*{2mm}
                            \else
                              \hspace*{5mm}
                            \fi
                          }
                        }
                      }

                      %% ==============================================================================
                      %% Final Configuration Commands
                      %% ==============================================================================

                      % Dynamic grid fill command
                      \newlength{\neo@gridwidth}
                      \NewDocumentCommand\gridfill{s O{titleColor} O{5mm} O{5mm}}{%
                        \pgfmathsetmacro{\neo@gridwidth}{floor(\linewidth/1cm)}
                        \edef\neo@gridwidth{\neo@gridwidth cm}
                        \dimen0=\dimexpr\textheight-\pagetotal-2\baselineskip\relax
                        \pgfmathsetmacro{\neo@heightcm}{floor((\the\dimen0/28.453)/0.5)*0.5}%
                        \vspace*{\fill}%
                        \IfBooleanTF{#1}
                        {{\noindent\centering
                            \frenchgrid[#2]{\neo@gridwidth}{\neo@heightcm cm}}}
                        {{\noindent\centering
                            \customgrid[#2][#3][#4]{\neo@gridwidth}{\neo@heightcm cm}}}%
                      }

                      % Solution text formatting
                      \NewDocumentCommand\neo@solution@text{}{%
                        {\neo@title@other@style
                          \color{tcbcolframe}
                          \ifx\neo@solutiongaptext\empty
                            \neo@solutionname
                          \else
                            \neo@solutionname~\neo@solutiongaptext
                          \fi
                        }
                      }

                      %% ==============================================================================
                      %% Utilities
                      %% ==============================================================================

                      %% Core Document Settings
                      %% ----------------------------------
                      % Table styling
                      \setlength{\arrayrulewidth}{0.5pt}
                      % \arrayrulecolor{titleColor}
                      \renewcommand{\arraystretch}{1.15}

                      % Document color management
                      \newcommand{\documentcolor}[1]{%
                        \color{#1}\global\let\default@color\current@color
                      }

                      % Initialize document settings
                      \AtBeginDocument{%
                        \documentcolor{\neoschool@globalcolor}
                        \DeclareGraphicsExtensions{.pdf,.PDF,.eps,.EPS,.png,.PNG,.tif,.TIF,.jpg,.JPG,.jpeg,.JPEG}
                      }

                      %% Font Settings
                      %% ----------------------------------
                      \ifneo@sfall
                        \renewcommand{\neoschool@headstyle}{sffamily}
                        \renewcommand{\neoschool@titlestyle}{sffamily}
                        \renewcommand{\familydefault}{\sfdefault}
                      \fi

                      \ifneo@sfbody
                        \renewcommand{\familydefault}{\sfdefault}
                      \fi

                      %% Graphics Rules
                      %% ----------------------------------
                      \ifpdf
                        \DeclareGraphicsRule{*}{mps}{*}{}
                      \fi

                      %% Layout and Drawing Tools
                      %% ----------------------------------
                      % Absolute positioning on page
                      \newcommand{\positionobject}[4]{%
                        \begin{tikzpicture}[remember picture, overlay]
                          \node[inner sep=0pt, outer sep=0pt] at ($([xshift=#1,yshift=-#2]current page.north west)$) {%
                            \adjustbox{scale=#3}{#4}
                          };
                        \end{tikzpicture}
                      }

                      % Advanced customizable grid
                      \NewDocumentCommand{\customgrid}{ O{titleColor} O{5mm} O{5mm} m m }{%
                        \tikzset{%
                          gridlines/.style={%
                            draw=#1,
                            opacity=0.5
                          },
                          majorgrid/.style={%
                            gridlines,
                            line width=0.35pt
                          },
                          minorgrid/.style={%
                            gridlines,
                            line width=0.35pt
                          }
                        }
                        \medskip\noindent\begin{tikzpicture}[inner sep=0, outer sep=0]
                          % Calculate dimensions
                          \pgfmathsetmacro\mywidth{#4}
                          \pgfmathsetmacro\myheight{#5}
                          \pgfmathsetmacro\incx{#2}
                          \pgfmathsetmacro\incy{#3}

                          % Vertical grid lines
                          \pgfmathsetmacro\numx{int(\mywidth/\incx)}
                          \foreach \x in {0,...,\numx}{%
                            \pgfmathparse{mod(\x,5)==0 ? "majorgrid" : "minorgrid"}
                            \edef\gridstyle{\pgfmathresult}
                            \draw[\gridstyle]
                            (\x * \incx pt, 0) -- (\x * \incx pt, \myheight pt);
                          }

                          % Horizontal grid lines
                          \pgfmathsetmacro\numy{int(\myheight/\incy)}
                          \foreach \y in {0,...,\numy}{%
                            \pgfmathparse{mod(\y,5)==0 ? "majorgrid" : "minorgrid"}
                            \edef\gridstyle{\pgfmathresult}
                            \draw[\gridstyle]
                            (0, \y * \incy pt) -- (\mywidth pt, \y * \incy pt);
                          }
                        \end{tikzpicture}
                        \ignorespaces
                        \par\vspace{7pt}
                      }

                      % Legacy grid command for backwards compatibility
                      \NewDocumentCommand{\grid}{ O{titleColor} m m }{%
                        \customgrid[#1][5mm][5mm]{#2}{#3}
                      }

                      \NewDocumentCommand{\frenchgrid}{ s O{titleColor!75} O{titleColor!50} m m }{%
                        \tikzset{%
                          fine lines/.style={draw={#3},very thin},
                          thick lines/.style={draw={#2}},
                        }
                        \IfBooleanTF{#1}{%
                          \noindent\centering
                        }{%
                          \noindent
                        }%
                        \begin{tikzpicture}[inner sep=0,outer sep=0]
                          \pgfmathsetmacro\mywidth{#4}
                          \pgfmathsetmacro\myheight{#5}
                          \pgfmathsetmacro\incx{8mm}
                          \pgfmathsetmacro\incypetits{2mm}
                          \pgfmathsetmacro\incygrands{8mm}

                          \pgfmathsetmacro\numx{floor(\mywidth/\incx)}
                          \pgfmathsetmacro\adjwidth{\numx * \incx}

                          \pgfmathsetmacro\numypetits{floor(\myheight/\incypetits)}
                          \pgfmathsetmacro\numygrands{floor(\myheight/\incygrands)}
                          \pgfmathsetmacro\adjheight{\numypetits * \incypetits}

                          \foreach \x in {0,...,\numx}{%
                            \draw[fine lines] (\x * \incx pt,0) -- (\x * \incx pt,\adjheight pt);
                          }
                          \foreach \y in {0,...,\numypetits}{%
                            \draw[fine lines] (0,\y * \incypetits pt) -- (\adjwidth pt,\y * \incypetits pt);
                          }
                          \foreach \y in {0,...,\numygrands}{%
                            \draw[thick lines] (0,\y * \incygrands pt) -- (\adjwidth pt,\y * \incygrands pt);
                          }
                        \end{tikzpicture}%
                      }

                      %% Notebook-Style Pages
                      %% ----------------------------------
                      % Simple lined notebook page
                      \newcommand{\notebook}{%
                        \begin{tikzpicture}[remember picture,overlay]
                          \foreach \i in {3,...,27}{%
                            \draw[teal] ($(current page.north west)+(0,-\i)$) --
                            ($(current page.north east)+(0,-\i)$);
                          }
                          \draw [thick,red] ($(current page.north west)+(4,0)$) --
                          ($(current page.south west)+(4,0)$);
                        \end{tikzpicture}
                      }

                      % Minor grid notebook page
                      \newcommand{\nbminorgrid}{%
                        \begin{tikzpicture}[remember picture,overlay]
                          \foreach \i in {0.5,1,...,30}{%
                            \draw[teal!50] ($(current page.north west)+(0,-\i)$) --
                            ($(current page.north east)+(0,-\i)$);
                          }
                          \foreach \i in {0.5,1,...,21}{%
                            \draw [thick,teal!50] ($(current page.north west)+(\i,0)$) --
                            ($(current page.south west)+(\i,0)$);
                          }
                        \end{tikzpicture}
                      }

                      % Major grid notebook page
                      \newcommand{\nbmajorgrid}{%
                        \begin{tikzpicture}[remember picture,overlay]
                          \foreach \i in {2,2.8,...,30}{%
                            \draw[teal!50] ($(current page.north west)+(0,-\i)$) --
                            ($(current page.north east)+(0,-\i)$);
                          }
                          \foreach \i in {2,2.2,...,30}{%
                            \draw[teal!25] ($(current page.north west)+(0,-\i)$) --
                            ($(current page.north east)+(0,-\i)$);
                          }
                          \foreach \i in {4.0,4.8,...,21}{%
                            \draw [thick,teal!50] ($(current page.north west)+(\i,0)$) --
                            ($(current page.south west)+(\i,0)$);
                          }
                          \draw [thick,red] ($(current page.north west)+(4,0)$) --
                          ($(current page.south west)+(4,0)$);
                        \end{tikzpicture}
                      }

                      %% Horizontally Split Content
                      %% ----------------------------------
                      \NewDocumentCommand{\splitcontent}{ O{0.5} O{0.02} m m }{%
                        % #1 : Width of the first section (default: 50%)
                        % #2 : Horizontal gap between sections (default: 2%)
                        % #3 : Content of the first section
                        % #4 : Content of the second section
                        \noindent
                        \begin{minipage}{#1\linewidth}
                          #3
                        \end{minipage}%
                        \hspace*{#2\linewidth}
                        \begin{minipage}{\dimexpr\linewidth-#1\linewidth-#2\linewidth\relax}
                          #4
                        \end{minipage}%
                      }

                      %% Text With Image Layout
                      %% ----------------------------------
                      \NewDocumentCommand{\textwithimage}{s m m m m}{%
                        \noindent
                        \IfBooleanTF{#1}{%
                          \par\begin{minipage}{#2\linewidth}
                            \centering\includegraphics[width=#3\linewidth]{#5}
                          \end{minipage}
                          \hfill
                          \begin{minipage}{\dimexpr\linewidth-#2\linewidth-1em\relax}
                            #4
                          \end{minipage}
                        }{%
                          \par\begin{minipage}{\dimexpr\linewidth-#2\linewidth-1em\relax}
                            #4
                          \end{minipage}%
                          \hfill%
                          \begin{minipage}{#2\linewidth}
                            \begin{center}
                              \centering\includegraphics[width=#3\linewidth]{#5}
                            \end{center}
                          \end{minipage}
                        }
                      }

                      %% QR Code Integration
                      %% ----------------------------------
                      \NewDocumentCommand{\withqrcode}{ s O{2cm} m m }{%
                        \qrset{hyperlink,height=#2}%
                        \noindent%
                        \IfBooleanTF{#1}{%
                          \par\begin{tblr}{%
                            width={\linewidth},
                            colspec={X[j,m]Q[c,m]Q[c,m]}
                            }
                            {{{#4}}} &  & \centering\qrcode{#3}
                          \end{tblr}%
                        }{%
                          \par\begin{tblr}{%
                            width={\linewidth},
                            colspec={Q[c,m]Q[c,m]X[j,m]}
                            }
                            \centering\qrcode{#3} &  & {{{#4}}}
                          \end{tblr}%
                        }%
                      }

                      %% Assessment Tools
                      %% ----------------------------------
                      % Point markers

                      \NewDocumentCommand{\mrk}{s O{} m}{%
                        \ifmarginnotesactive
                          \IfBooleanTF{#1}
                          {\reversemarginpar}
                          {\normalmarginpar}%
                          \ifx\empty#2\empty
                            \marginnote{\footnotesize #3~\ifdim#3pt<2pt pt\else pts\fi}[0em]%
                          \else
                            \marginnote{%
                              \small
                              \parbox[c]{\marginparwidth}{%
                                \begin{spacing}{0.8}
                                  \IfBooleanTF{#1}
                                  {\raggedleft}
                                  {\raggedright}
                                  (#3~\ifdim#3pt<2pt pt\else pts\fi) \tiny #2%
                                \end{spacing}
                              }%
                            }[0em]%
                          \fi
                          \ignorespaces
                        \fi
                      }

                      % Answer lines
                      \NewDocumentCommand{\lines}{ O{.} O{1.65em} m }{%
                        \par
                        \vspace*{0.5\baselineskip}
                        \foreach \n in {1,...,#3}{%
                          \noindent\parbox[t][#2][t]{\linewidth}{%
                            \ifstrequal{#1}{.}{%
                                \dotfill
                              }{%
                                \ifstrequal{#1}{-}{%
                                    \hrulefill
                                  }{%
                                    \leaders\hbox{#1}\hfill\kern0pt
                                  }
                                }
                              }
                              \par
                            }
                          }

                          % Dotted line with variable length
                          \newcommand\vardots[1][\linewidth]{%
                            \noindent\begin{tikzpicture}
                              \draw[densely dotted, semithick, line cap=round] (0,0) -- ({#1},0);
                            \end{tikzpicture}
                          }

                          %% Task Lists
                          %% ----------------------------------
                          \newcommand{\cmark}{%
                            \ifneo@print
                              \ding{51}%
                            \else
                              {\color{neoCorrectColor}\ding{51}}%
                            \fi
                          }

                          \newcommand{\xmark}{%
                            \ifneo@print
                              \ding{55}%
                            \else
                              {\color{neoIncorrectColor}\ding{55}}%
                            \fi
                          }

                          \newcommand{\unchecked}{%
                            \item[\rlap{$\square$}\hspace{.7em}]%
                          }

                          \newcommand{\done}{%
                            \item[\rlap{$\square$}{%
                              \raisebox{1pt}{\large\hspace{1pt}\cmark}\hspace{-2.5pt}}]%
                          }

                          \newcommand{\wontfix}{%
                            \item[\rlap{$\square$}{\large\hspace{1pt}\xmark}]%
                          }

                          %% Bold List Labels
                          %% ----------------------------------

                          \ifneoschool@boldlistlabels
                            \AtEndPreamble{%
                              \renewcommand{\labelenumi}{\textbf{\arabic{enumi}}.}
                              \renewcommand{\labelenumii}{\textbf{\alph{enumii}}.}
                              \renewcommand{\labelenumiii}{\textbf{\roman{enumiii}}.}
                              \renewcommand{\labelenumiv}{\textbf{\Alph{enumiv}}.}
                            }%
                          \fi

                          %% ==============================================================================
                          %% Margin and Notes Management
                          %% ==============================================================================

                          \newlength{\neo@usernotes}
                          \setlength{\neo@usernotes}{0pt}

                          \ifdefempty{\neoschool@noteswidth}{}{%
                            \setlength{\neo@usernotes}{\neoschool@noteswidth}
                          }

                          \ifdefempty{\neoschool@notesposition}{}{%
                            \IfStrEq{\neoschool@notesposition}{none}{}{%
                              \marginnotesactivetrue
                            }
                          }

                          \AtEndPreamble{%
                            \ifdefempty{\neoschool@margin}{}{%
                              \setlength{\marginparsep}{0.5cm}

                              \newlength{\neo@targetwidth}
                              \setlength{\neo@targetwidth}{\paperwidth}
                              \addtolength{\neo@targetwidth}{-2\dimexpr\neoschool@margin\relax}

                              \newlength{\neo@targetheight}
                              \setlength{\neo@targetheight}{\paperheight}
                              \addtolength{\neo@targetheight}{-.75\dimexpr\neoschool@margin\relax}

                              \areaset{\neo@targetwidth}{\neo@targetheight}
                            }%
                            \ifdefempty{\neoschool@noteswidth}{\def\neoschool@noteswidth{3cm}}{}%
                            \ifdefempty{\neoschool@notesposition}{\def\neoschool@notesposition{none}}{}%
                            %
                            \IfStrEq{\neoschool@notesposition}{none}{%
                            }{%
                              % Calcul de la largeur réelle de la note (largeur totale - 0.5cm de marge de sécurité)
                              \setlength{\marginparwidth}{\dimexpr\neoschool@noteswidth-0.5cm\relax}

                              \IfStrEq{\neoschool@notesposition}{left}{%
                                % Padding interne (entre texte et note)
                                \setlength{\marginparsep}{0.5cm}
                                % On décale tout le texte vers la droite de la valeur TOTALE (noteswidth)
                                \addtolength{\oddsidemargin}{\neoschool@noteswidth}
                                \addtolength{\evensidemargin}{\neoschool@noteswidth}
                                \addtolength{\textwidth}{-\neoschool@noteswidth}
                                \reversemarginpar
                              }{%
                                \IfStrEq{\neoschool@notesposition}{right}{%
                                  \setlength{\marginparsep}{0.5cm}
                                  % Calcul de la largeur du texte restant
                                  % On réserve bien toute la largeur noteswidth pour la marge, même si marginparwidth est plus petit
                                  \setlength{\textwidth}{\dimexpr\paperwidth-\oddsidemargin-1in-\marginparsep-\neoschool@noteswidth-0.25cm\relax}
                                  \normalmarginpar
                                }{%
                                  \IfStrEq{\neoschool@notesposition}{alternate}{%
                                    \setlength{\marginparwidth}{\dimexpr\neo@usernotes-0.5cm\relax}
                                    \setlength{\marginparsep}{0.5cm}
                                    \addtolength{\oddsidemargin}{\neo@usernotes}
                                    \addtolength{\evensidemargin}{\neo@usernotes}
                                    \areaset{\dimexpr 19cm-2\neo@usernotes\relax}{29cm}
                                  }{}%
                                }%
                              }%
                            }%
                          }

                          %% Margin Notes Commands
                          %% ----------------------------------

                          \newtoggle{lmargin}

                          \newcommand{\alternatingtodo}[2][]{%
                            \IfStrEqCase{\neoschool@notesposition}{%
                              {left}      {\reversemarginpar \todo[#1]{#2}}%
                              {right}     {\normalmarginpar \todo[#1]{#2}}%
                              {alternate} {%
                                \iftoggle{lmargin}
                                {\normalmarginpar \todo[#1]{#2} \togglefalse{lmargin}}
                                {\reversemarginpar \todo[#1]{#2} \toggletrue{lmargin}}%
                              }%
                              {none} {}%
                            }%
                          }

                          \newcommand{\tdnote}[2][]{%
                            \ifmarginnotesactive
                              \alternatingtodo[%
                              bordercolor=backgroundColor,
                              linecolor=solutionColor,
                              textcolor=solutionColor,
                              backgroundcolor=backgroundColor,
                              #1%
                              ]{#2}%
                            \fi
                          }

                          \newsavebox{\todobox}
                          \newcounter{tdnotecounter}

                          \newcommand{\neo@ifnodedefined}[3]{%
                            \ifcsname pgf@sh@ns@#1\endcsname #2\else #3\fi
                          }

                          % Command: \tdmark[label]
                          % MUST be placed AFTER \boxnote
                          \newcommand{\tdmark}[1][inNote]{%
                            \ifmarginnotesactive
                              \IfStrEq{#1}{inNote}%
                              {\def\neo@currlabel{neo-note-\thetdnotecounter}}%
                              {\def\neo@currlabel{neo-note-#1}}%
                              %
                              \tikz[remember picture, overlay, baseline=(M.base)]{%
                                \node[inner sep=0, outer sep=0, anchor=base] (M) {};

                                \neo@ifnodedefined{\neo@currlabel}{%
                                  \coordinate (Start) at ([yshift=-3pt]M.center);

                                  \path let \p1 = (\neo@currlabel) in coordinate (NoteX) at (\x1, 0);

                                  \iftoggle{lmargin}%
                                  { \coordinate (VertX) at ([xshift=0.15cm]NoteX); }
                                  { \coordinate (VertX) at ([xshift=-0.15cm]NoteX); }

                                  \draw[thick, markerColor]
                                  (Start) -- (Start -| VertX) -- (VertX |- \neo@currlabel) -- (\neo@currlabel);
                                }{}%
                              }%
                            \fi
                          }

                          % Command: \boxnote[label][options]{Content}
                          % New syntax: [label] for linking, [options] for visual (color, etc.)
                          \NewDocumentCommand{\boxnote}{ O{inNote} O{} m }{%
                            \IfStrEq{#1}{inNote}%
                            {\stepcounter{tdnotecounter}\def\neo@currlabel{neo-note-\thetdnotecounter}}%
                            {\def\neo@currlabel{neo-note-#1}}%
                            %
                            \ifmarginnotesactive
                              \IfStrEq{\neoschool@notesposition}{left}{%
                                \reversemarginpar\toggletrue{lmargin}%
                              }{%
                                \IfStrEq{\neoschool@notesposition}{right}{%
                                  \normalmarginpar\togglefalse{lmargin}%
                                }{%
                                  \IfStrEq{\neoschool@notesposition}{alternate}{%
                                    \checkoddpage\ifoddpage\normalmarginpar\togglefalse{lmargin}\else\reversemarginpar\toggletrue{lmargin}\fi
                                  }{}%
                                }%
                              }%
                              %
                              \savebox\todobox{%
                                \begin{minipage}{\marginparwidth}%
                                  \tdnote[inline, #2]{#3}%
                                \end{minipage}%
                              }%
                              %
                              \marginpar{%
                                \usebox\todobox%
                                \begin{tikzpicture}[remember picture, overlay]
                                  \pgfmathsetmacro{\neo@midY}{\ht\todobox/2}
                                  \iftoggle{lmargin}%
                                  {%
                                    \coordinate (\neo@currlabel) at (0pt, \neo@midY pt);
                                  }%
                                  {%
                                    \coordinate (\neo@currlabel) at (-\wd\todobox, \neo@midY pt);
                                  }%
                                \end{tikzpicture}%
                              }%
                            \fi
                          }

                          %% Exam-style grading strip
                          %% ----------------------------------
                          \newcommand{\neo@mark@text}{%
                            \ifneo@french
                              Note%
                            \else\ifneo@german
                                Note%
                              \else
                                Mark%
                              \fi\fi
                          }

                          \newcommand{\neo@appreciation@text}{%
                            \ifneo@french
                              Appréciation%
                            \else\ifneo@german
                                Bewertung%
                              \else
                                Comments%
                              \fi\fi
                          }

                          \newcommand{\smallstrut}{\rule[-0.5ex]{0pt}{1.8ex}}

                          \NewDocumentCommand{\gradingstrip}{ O{} }{%
                            \noindent
                            \begin{minipage}[t]{0.2\textwidth}
                              \begin{tcolorbox}[%
                                enhanced,
                                colback=white,
                                colbacktitle=white,
                                colframe=\neoschool@globalcolor,
                                sharp corners,
                                boxrule=\neo@thinrule,
                                height=2.5cm,
                                title={\smallstrut\textmd{\color{\neoschool@globalcolor}\neo@mark@text}},
                                center title,
                                overlay={%
                                  \IfStrEq{#1}{}{}{%
                                    \coordinate (start) at ([xshift=-0.1mm,yshift=-0.575cm]frame.north east);
                                    \coordinate (end) at ([xshift=0.1mm,yshift=0.1mm]frame.south west);
                                    \draw[line width=\neo@decorativerule] (start) -- (end);
                                    \node[anchor=south east]
                                    at ([xshift=-0.4cm,yshift=0.4cm]end -| start) {#1};
                                  }%
                                }
                                ]
                                \IfStrEq{#1}{}{%
                                  \vspace{2\baselineskip}
                                }{}
                              \end{tcolorbox}
                            \end{minipage}%
                            \hspace{.1cm}%
                            \begin{minipage}[t]{0.79\textwidth}
                              \begin{tcolorbox}[%
                                enhanced,
                                colback=white,
                                colbacktitle=white,
                                colframe=\neoschool@globalcolor,
                                sharp corners,
                                boxrule=\neo@thinrule,
                                height=2.5cm,
                                title={\smallstrut\textmd{\color{\neoschool@globalcolor}\neo@appreciation@text}},
                                center title
                                ]
                                \vspace{2\baselineskip}
                              \end{tcolorbox}
                            \end{minipage}%
                            \par
                          }

                          %% Skill Assessment Table
                          %% ----------------------------------
                          \newcommand{\competencies}[1]{%
                            \colorlet{tempcolor}{\neoschool@globalcolor}

                            \ifneo@print
                              \def\iconcolorA{black!15}
                              \def\iconcolorB{black!15}
                              \def\iconcolorC{black!15}
                              \def\iconcolorD{black!15}
                            \else\ifneo@unicolor
                                \ifneo@darktheme
                                  \def\iconcolorA{titleColor!30!white}
                                  \def\iconcolorB{titleColor!30!white}
                                  \def\iconcolorC{titleColor!30!white}
                                  \def\iconcolorD{titleColor!30!white}
                                \else
                                  \def\iconcolorA{titleColor!25!white}
                                  \def\iconcolorB{titleColor!25!white}
                                  \def\iconcolorC{titleColor!25!white}
                                  \def\iconcolorD{titleColor!25!white}
                                \fi
                              \else
                                \def\iconcolorA{Tomato}
                                \def\iconcolorB{orange}
                                \def\iconcolorC{yellow}
                                \def\iconcolorD{green}
                              \fi\fi

                            \begin{center}
                              \begin{tblr}{%
                                colspec={|[0.5pt,tempcolor]t{.5\linewidth}|[0.5pt,tempcolor]
                                Q[c,b]|[0.5pt,tempcolor]Q[c,b]|[0.5pt,tempcolor]
                                Q[c,b]|[0.5pt,tempcolor]Q[c,b]|[0.5pt,tempcolor]},
                                hlines = {0.5pt, tempcolor},
                                row{1} = {abovesep=5pt},
                                }
                                \SetCell{cmd=\bfseries} \raisebox{0.25em}{\neo@competencies} &
                                                                                               \dSadey[1.5][\iconcolorA]                                    & \dNeutrey[1.5][\iconcolorB]    &
                                                                                                                                                                                               \dSmiley[1.5][\iconcolorC]                                   & \dChangey[1.5][\iconcolorD]{2}   \\
                                #1                                                                                              \\
                              \end{tblr}
                            \end{center}
                          }

                          %% Tree and Graph Structure Support
                          %% ----------------------------------
                          % Forest settings for trees
                          \forestset{
                            w/.style = {
                              edge label={
                                node[midway, fill=white, text=black] {$#1$}
                              }
                            }
                          }

                                          \environbodyname\neotreebody
                                          \bracketset{action character=@}
                                          \NewEnviron{neotree}[1][]{%
                                            \forest
                                            for tree={%
                                              grow'=0,
                                              l=2.5cm,
                                              s sep=1.5cm,
                                              anchor=parent,
                                              math content,
                                              #1
                                            },
                                            [@\neotreebody]
                                            \endforest
                                          }

                                          % Graph settings (LuaTeX only)
                                          \ifLuaTeX
                                            \tikzset{%
                                              graphs/simpleer/.style={%
                                                nodes={%
                                                  draw,
                                                  circle,
                                                  fill=white,
                                                  text=black,
                                                  inner sep=1pt,
                                                  minimum size=2em
                                                },
                                                node distance=2.5cm
                                              }
                                            }

                                            \newcommand{\neograph}[2][]{%
                                              \tikz \graph[%
                                              simpleer,
                                              simple necklace layout,
                                              edge quotes mid,
                                              edges={%
                                                rounded corners,
                                                nodes={%
                                                  font=\scriptsize,
                                                  fill=white,
                                                  #1,
                                                  inner sep=1pt,
                                                  align=center
                                                }
                                              },
                                              nodes={circle,draw}
                                              ]{#2};
                                            }
                                          \fi

                                          % Math Grid Environment
                                          \newcounter{neomathline}
                                          \newcounter{neomathcol}[neomathline]

                                          \newenvironment{mathgrid}[1]
                                          {%
                                            \def\mcols{#1}%
                                            \setcounter{neomathline}{0}%
                                            \par\noindent%
                                          }
                                          {\bigskip}

                                          \newcommand{\neoline}{%
                                            \ifnum\value{neomathcol}>0\\\fi%
                                            \stepcounter{neomathline}%
                                            \setcounter{neomathcol}{0}%
                                          }

                                          \newcommand{\neocol}[2][1]{%
                                            \stepcounter{neomathcol}%
                                            \ifnum\value{neomathcol}>1\quad\fi%
                                            \begin{minipage}[t]{\dimexpr\linewidth * #1 / \mcols - 2\columnsep}
                                              \setlength{\abovedisplayskip}{5pt}%
                                              \setlength{\belowdisplayskip}{5pt}%
                                              \begin{align*}
                                                #2
                                              \end{align*}
                                            \end{minipage}%
                                            \ignorespaces%
                                          }

                                          % Math color

                                          \newcommand*{\mc}[2][mathColor]{{\color{#1}#2}}

                                          %% ==============================================================================
                                          %% AI / NoAI Logos
                                          %% ==============================================================================

                                          \newcommand{\drawAIChipBase}{
                                            \shade[top color=titleColor!70!black, bottom color=titleColor!90!black, rounded corners=3pt] (0,0) rectangle (2,2);
                                            \draw[line width=1.5pt, titleColor!40!white, rounded corners=3pt] (0,0) rectangle (2,2);

                                            \foreach \y in {0.2, 0.6, 1.0, 1.4, 1.8} {
                                              \draw[line width=2.5pt, titleColor!80!black] (-0.2,\y) -- (0,\y);
                                              \draw[line width=2.5pt, titleColor!80!black] (2,\y) -- (2.2,\y);
                                            }
                                            \foreach \x in {0.2, 0.6, 1.0, 1.4, 1.8} {
                                              \draw[line width=2.5pt, titleColor!80!black] (\x,-0.2) -- (\x,0);
                                              \draw[line width=2.5pt, titleColor!80!black] (\x,2) -- (\x,2.2);
                                            }
                                          }

                                          \newcommand{\drawAINeuralNet}{
                                            \begin{scope}[shift={(1,1)}, scale=0.85, opacity=0.6, color=titleColor!70!white]
                                              \draw[line width=0.8pt] (0,0) circle (0.2);
                                              \draw[line width=0.8pt] (0.5, 0.6) circle (0.1);
                                              \draw[line width=0.8pt] (-0.5, 0.6) circle (0.1);
                                              \draw[line width=0.6pt] (0.6, -0.3) circle (0.1);
                                              \draw[line width=0.6pt] (-0.6, -0.3) circle (0.1);
                                              \draw[line width=0.8pt] (0, -0.7) circle (0.1);
                                              \draw[line width=0.8pt] (0, 0.8) circle (0.1);

                                              \draw[line width=0.5pt] (0,0) -- (0.5, 0.6);
                                              \draw[line width=0.5pt] (0,0) -- (-0.5, 0.6);
                                              \draw[line width=0.5pt] (0,0) -- (0.6, -0.3);
                                              \draw[line width=0.5pt] (0,0) -- (-0.6, -0.3);
                                              \draw[line width=0.5pt] (0,0) -- (0, -0.7);
                                              \draw[line width=0.5pt] (0, 0.8) -- (0.5, 0.6);
                                              \draw[line width=0.5pt] (0, 0.8) -- (-0.5, 0.6);
                                              \draw[line width=0.5pt] (-0.5, 0.6) -- (-0.6, -0.3);
                                              \draw[line width=0.5pt] (0.5, 0.6) -- (0.6, -0.3);
                                            \end{scope}
                                          }

                                          \newcommand{\drawAIText}{
                                            \node[font=\bfseries\sffamily\Large, white] at (1,1) {\neo@ainame};
                                          }

                                          \newcommand{\AILogo}[1][scale=0.4]{%
                                            \begin{tikzpicture}[#1]
                                              \drawAIChipBase
                                              \drawAINeuralNet
                                              \drawAIText
                                            \end{tikzpicture}
                                          }
                                          \newcommand{\NoAILogo}[1][scale=0.4]{%
                                            \begin{tikzpicture}[#1]

                                              \drawAIChipBase
                                              \drawAIText

                                              \draw[line width=2pt, red!80!black, opacity=1] (1,1) circle (0.8);
                                              \draw[line width=2pt, red!80!black, opacity=1] (1-0.57, 1+0.57) -- (1+0.57, 1-0.57);

                                            \end{tikzpicture}
                                          }

                                          %% Base Style Configuration
                                          \tcbset{
                                            neoschool-admonition-layout/.style={
                                              code={
                                                \ifneoschool@inlineadmonition
                                                  \tcbset{
                                                    after title={~\;},
                                                  }
                                                \else
                                                  \tcbset{
                                                    after title={\par\vspace{0.5em}},
                                                  }
                                                \fi
                                              }
                                            }
                                          }

                                          \newtcolorbox{admonitionbase}[4][]{%
                                            enhanced,
                                            before skip=\neo@effective@ad@beforeskip,
                                            after skip=\neo@effective@ad@afterskip,
                                            colframe=#2,
                                            colback=#2!\neo@adopacity,
                                            colupper=\neoschool@globalcolor,
                                            boxrule=\neo@normalrule,
                                            frame style={opacity=0.5},
                                            \neo@adframehidden,
                                            arc=\neoschool@adboxarc,
                                            left=\neo@ad@left@padding,
                                            right=\neo@ad@right@padding,
                                            top=\neo@ad@top@padding,
                                            bottom=\neo@ad@bottom@padding,
                                            breakable,
                                            lines before break=3,
                                            fonttitle=\neo@title@style,
                                            title={%
                                              \hspace*{-5.35mm}%
                                              \raisebox{-2pt}{\textcolor{#2}{\Large#3}}%
                                              \hspace{5pt}%
                                              \textcolor{#2}{\textbf{#4}}%
                                            },
                                            attach title to upper,
                                            neoschool-admonition-layout,
                                            #1
                                          }

                                          % Admonition Boxes
                                          \newcommand{\neo@declareadmonition}[4]{%
                                            \expandafter\let\csname #1\endcsname\relax
                                            \expandafter\let\csname end#1\endcsname\relax
                                            \NewDocumentEnvironment{#1}{O{#4} O{#3} +b}{%
                                              \begin{admonitionbase}{#2}{##2}{##1}%
                                                ##3%
                                              \end{admonitionbase}%
                                            }{}%
                                          }

                                          \neo@declareadmonition{note}     {noteColor}     {\faEdit}               {\neo@admonition@note\neoschool@adterminator}
                                          \neo@declareadmonition{info}     {infoColor}     {\faInfoCircle}         {\neo@admonition@info\neoschool@adterminator}
                                          \neo@declareadmonition{warning}  {warningColor}  {\faExclamationTriangle}{\neo@admonition@warning\neoschool@adterminator}
                                          \neo@declareadmonition{important}{importantColor}{\faExclamationCircle}  {\neo@admonition@important\neoschool@adterminator}
                                          \neo@declareadmonition{tip}      {tipColor}      {\faLightbulb}          {\neo@admonition@tip\neoschool@adterminator}
                                          \neo@declareadmonition{reminder} {reminderColor} {\faBookmark}           {\neo@admonition@reminder\neoschool@adterminator}
                                          \neo@declareadmonition{summary}  {summaryColor}  {\faClipboardList}      {\neo@admonition@summary\neoschool@adterminator}
                                          \neo@declareadmonition{toolbox}  {toolboxColor}  {\faTools}              {\neo@admonition@toolbox\neoschool@adterminator}

                                          %% ==============================================================================
                                          %% Apply vspace factor
                                          %% ==============================================================================

                                          \newdimen\@tempdima
                                          \newdimen\@tempdimatwo

                                          \AtBeginDocument{%
                                            \ifdim\neo@vspace@factor pt<0.76pt
                                              \setlist{
                                                itemsep=0pt,
                                                parsep=0pt,
                                                topsep=0pt,
                                              }%
                                            \else
                                              \setlength{\parskip}{\dimexpr\neo@vspace@factor\parskip\relax}
                                              \setlength{\abovedisplayskip}{\dimexpr\neo@vspace@factor\abovedisplayskip\relax}
                                              \setlength{\belowdisplayskip}{\dimexpr\neo@vspace@factor\belowdisplayskip\relax}
                                              \setlength{\abovedisplayshortskip}{\dimexpr\neo@vspace@factor\abovedisplayshortskip\relax}
                                              \setlength{\belowdisplayshortskip}{\dimexpr\neo@vspace@factor\belowdisplayshortskip\relax}
                                              \setlength{\floatsep}{\dimexpr\neo@vspace@factor\floatsep\relax}
                                              \setlength{\textfloatsep}{\dimexpr\neo@vspace@factor\textfloatsep\relax}
                                              \setlength{\intextsep}{\dimexpr\neo@vspace@factor\intextsep\relax}

                                              \newdimen\neo@list@sep
                                              \pgfmathsetlength{\neo@list@sep}{0.25 * \neo@vspace@factor * \baselineskip}

                                              \setlist{
                                                itemsep=\neo@list@sep,
                                                parsep=\neo@list@sep,
                                                topsep=\neo@list@sep,
                                              }%
                                            \fi
                                          }


                                          \ifdim\neo@vspace@factor pt=1.0pt\else
                                            \RedeclareSectionCommand[
                                            beforeskip=\dimexpr\neo@vspace@factor\dimexpr 1.5\baselineskip\relax\relax,
                                            afterskip=\dimexpr\neo@vspace@factor\dimexpr 0.75\baselineskip\relax\relax
                                            ]{section}
                                            \RedeclareSectionCommand[
                                            beforeskip=\dimexpr\neo@vspace@factor\dimexpr 1.25\baselineskip\relax\relax,
                                            afterskip=\dimexpr\neo@vspace@factor\dimexpr 0.6\baselineskip\relax\relax
                                            ]{subsection}
                                            \RedeclareSectionCommand[
                                            beforeskip=\dimexpr\neo@vspace@factor\dimexpr 1.0\baselineskip\relax\relax,
                                            afterskip=\dimexpr\neo@vspace@factor\dimexpr 0.5\baselineskip\relax\relax
                                            ]{subsubsection}
                                            \setlength{\titlespacing}{\dimexpr\neo@vspace@factor\baselineskip\relax}
                                            \addtocontents{toc}{%
                                              \protect\setlength{\protect\itemsep}{\dimexpr\neo@vspace@factor\dimexpr 6pt\relax\relax}%
                                              \protect\setlength{\protect\parskip}{\dimexpr\neo@vspace@factor\dimexpr 2pt\relax\relax}%
                                            }
                                          \fi

                                          \AtBeginDocument{%
                                            \ifpdf
                                            \else
                                              \ifx\neoschool@mathfacescale\@empty\else
                                                \setmathfont[Scale=\neoschool@mathfacescale]{\mathface}
                                              \fi
                                            \fi
                                          }

                                          %% ==============================================================================
                                          %% End of Class
                                          %% ==============================================================================
