%%
%% This is file `fhjpaper.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% fhjpaper.dtx  (with options: `class')
%% 
%% Copyright 2025 Michael E. Hammer
%% 
%% This work may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.3
%% of this license or (at your option) any later version.
%% The latest version of this license is in
%%   http://www.latex-project.org/lppl.txt
%% and version 1.3 or later is part of all distributions of LaTeX
%% version 2005/12/01 or later.
%% 
%% This work has the LPPL maintenance status `maintained'.
%% 
%% The Current Maintainer of this work is Michael E. Hammer.
%% 
%% This file is part of the "fhj-script bundle" and all files in that
%% bundle must be distributed together.
%% 
\NeedsTeXFormat{LaTeX2e}[2023-11-01]
\ProvidesClass{fhjpaper}
    [2025-10-03 v4.1c A class for formatting papers in the FHJ style]
\newcommand{\@ClassName}{fhjpaper}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{scrartcl}}
\ProcessOptions\relax
\LoadClass[a4paper,twocolumn,fontsize=9pt,DIV=16]{scrartcl}
\RequirePackage{fhjcommon}
\RequirePackage{etoolbox}
\PassOptionsToPackage{pagestyleset=standard}{scrlayer-scrpage}
\RequirePackage{scrlayer-scrpage}
\PassOptionsToPackage{hidelinks}{hyperref}
\RequirePackage{hyperref}
\renewcommand*{\title}[1]{\renewcommand*{\@title}{{#1}}}
\newcommand{\shorttitle}[1]{\newcommand{\@shorttitle}{{#1}}}
\ofoot{\@shorttitle}
\ifoot{\FHJProgramLong}
\setcounter{secnumdepth}{2}

%%-------------------------------------------------------------------------------------
%% authors handling
%% Taken von apa7 class --> See: https://ctan.org/tex-archive/macros/latex/contrib/apa7

%% German and English!
\newcommand*{\lastauthorseparator}{UNDEF}
\iflanguage{english}{\renewcommand*{\lastauthorseparator}{and}}{}
\iflanguage{ngerman}{\renewcommand*{\lastauthorseparator}{und}}{}

\newcommand*\listauthors{}
\newcommand*\listsuperscripts{}
\newcommand*\listaffiliations{}
\newcounter{NumberOfAuthors}
\newcounter{NumberOfSuperscripts}

\newcommand*{\authorsnames}[2][]{%
  \def\def@multipleauthors{\@multipleauthorsmode} %
  \renewcommand*\listauthors{}
  \renewcommand*\listsuperscripts{}
  \setcounter{NumberOfAuthors}{0}
  \setcounter{NumberOfSuperscripts}{0}
  \forcsvlist{\stepcounter{NumberOfAuthors}\listadd\listauthors}{#2}
  \forcsvlist{\stepcounter{NumberOfSuperscripts}\listadd\listsuperscripts}{#1}
}

\newcounter{NumberOfAffiliations}
\newcommand*{\authorsaffiliations}[1]{%
  \def\def@multipleaffils{\@multipleaffilsmode} %
  \renewcommand*\listaffiliations{}
  \setcounter{NumberOfAffiliations}{0}
  \forcsvlist{\stepcounter{NumberOfAffiliations}\listadd\listaffiliations}{#1}
}

%% \makeatletter
%%   \catcode`\|=3

\def\looptwo#1#2{%
    \edef\tmp{\noexpand\xtwo%
      \unexpanded\expandafter{#1}\relax  % no added delimiter here
      \unexpanded\expandafter{#2}\relax  % no added delimiter here
    } \tmp%
  }%

\def\xtwo#1|#2\relax#3|#4\relax{%
    \dotwo{#1}{#3}%
    \def\tmp{#2}%
    \ifx\empty\tmp%
      \expandafter\@gobble%
    \else%
      \expandafter\@firstofone%
    \fi%
    {\xtwo#2\relax#4\relax}%
  }%

%%  \catcode`\|=12

\newcommand*{\dotwo}[2]{}

\newcommand*{\authorsep}{}%
\newcommand*{\lastauthor}{}%
\newcommand*{\prelastauthor}{}%
\newcommand*{\prelastauthorsep}{}%

\newcommand{\displayauthors}{%
  \renewcommand*{\authorsep}{}%
  \renewcommand*{\lastauthor}{}%
  \renewcommand*{\prelastauthor}{}%
  \renewcommand*{\prelastauthorsep}{}%
  \ifnum\value{NumberOfSuperscripts}=0% If no superscripts are specified, print authors without superscripts.
  \renewcommand*{\do}[1]{%
      \authorsep%
      \lastauthor%
      \renewcommand{\lastauthor}{%
        \renewcommand{\authorsep}{,
          \renewcommand*{\prelastauthorsep}{,}}%
        \renewcommand{\prelastauthor}{\prelastauthorsep\ \lastauthorseparator\ }% Terminated commands with \ to preserve following space
        ##1%
      }%
    }%
    \dolistloop{\listauthors}%
  \else
    \renewcommand*{\dotwo}[2]{%
      \authorsep%
      \lastauthor%
      \renewcommand{\lastauthor}{%
        \renewcommand{\authorsep}{,
          \renewcommand*{\prelastauthorsep}{,}}%
        \renewcommand{\prelastauthor}{\prelastauthorsep\ \lastauthorseparator\ }% Terminated commands with \ to preserve following space
        ##1\textsuperscript{##2}%
      }%
    }%
    \looptwo\listauthors\listsuperscripts%
  \fi
  \prelastauthor \lastauthor%
}

\newcommand{\displayaffiliations}{%
  \ifnum\value{NumberOfSuperscripts}=0% If no superscripts are specified, print affiliations without superscripts.
    \renewcommand*{\do}[1]{%
        ##1\\%
    }%
  \else
    \newcounter{AffiliationNumber}
    \renewcommand*{\do}[1]{%
        \stepcounter{AffiliationNumber}
        \textsuperscript{\arabic{AffiliationNumber}}##1\\%
    }%
  \fi
  \dolistloop{\listaffiliations}%
}

\newcommand{\check@title}{%
  \@ifundefined{@title}{%
    \ClassWarningNoLine{fhjpaper}{Title not defined \title{Title}}}
  \@ifundefined{@shorttitle}{%
    \ClassWarningNoLine{fhjpaper}{Shorttitle not defined \shorttitle{Shorttitle}}}
}

\newcommand{\check@author}{%
  \@ifundefined{def@multipleauthors}{%
    \ClassWarningNoLine{fhjpaper}{Author not defined \authorsnames{Author}}}
  \@ifundefined{def@multipleaffils}{%
    \ClassWarningNoLine{fhjpaper}{Affiliation not defined \authorsaffiliations{Affiliation}}}
  \@ifundefined{def@multipleauthors}{}{%
   \ifnum\value{NumberOfSuperscripts}=0%
    % do nothing. If no superscripts are specified, print authors and affiliations without superscripts.
   \else%
      \ifnum\value{NumberOfAuthors}=\value{NumberOfSuperscripts}%
        % do nothing
      \else
        \ClassError{fhjpaper}{Number of Authors does not match number of Superscripts}%
          {Please provide an equal number of authors and superscripts.}%
  \fi
   \fi
  }%
}

%%-------------------------------------------------------------------------------------
%% Make title
\renewcommand*{\@maketitle}{
  \cleardoublepage
  \check@author
  \check@title
  % title
  \begin{minipage}{\textwidth}\begin{center}
    \fontsize{14}{18}\selectfont
    \textbf{\@title}
    \vspace{1em}
  \end{center}\end{minipage}
  % authors
  \begin{minipage}{\textwidth}\begin{center}
    \displayauthors
    \vspace{1em}
  \end{center}\end{minipage}
  % affiliations
  \begin{minipage}{\textwidth}\begin{center}
    \displayaffiliations
    \vspace{2em}
  \end{center}\end{minipage}
}
\endinput
%%
%% End of file `fhjpaper.cls'.
