---
myst:
  html_meta:
    keywords: LaTeX, composition, document, métadonnées du document,  
              licence libre, creative commons
---

# Comment placer mon document sous une license libre ?

## Document source

Pour placer votre document source (`.tex`) sous une licence libre, vous devriez 
suivre les instructions données sur le site officiel de la license concernée. 
Voici quelques exemples classiques :

- les instructions générales pour la [GPL](https://www.gnu.org/licenses/gpl-howto.fr.html) 
  (notamment la section *L'avis de copyright*) ;
- les instructions complémentaires pour la [Gnu Free Documentation License](https://www.gnu.org/licenses/fdl-howto.fr.html) ;
- les instructions pour les licences [Creative Commons](https://creativecommons.org/share-your-work/cclicenses/).


## Document PDF

Pour les licences *Creative Commons*, vous pouvez insérer manuellement 
les icônes (point détaillé à la question 
"[](/3_composition/texte/symboles/caracteres/creative_commons)") ou utiliser
l'extension <ctanpkg:doclicense>, qui propose différentes mises en forme 
prêtes à l'emploi. Dans l'exemple suivant, ces fonctionnalités sont couplées
à celles de l'extension <ctanpkg:fancyhdr> pour personnaliser 
les [en-têtes et pieds de page](../../texte/pages/entetes/start.md).

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \usepackage{fancyhdr}    % En-têtes personnalisés
  \usepackage{hyperref}    % Liens hypertextes
  \usepackage{hyperxmp}    % Métadonnées XMP
  \usepackage[ type={CC},
    modifier={by-nc-sa},
    version={3.0}
    ]{doclicense}
  
  % Définition d'un en-tête personnalisé
  \fancyhf{}
  \fancyhead[L]{\footnotesize{Ce document est placé sous license
    \doclicenseNameRef — \copyright Georges Dandin}}

\begin{document}
\thispagestyle{fancy}
Voici le document sous license.
\end{document}
```

Notez ici avant l'appel aux extensions <ctanpkg:hyperref> et <ctanpkg:hyperxmp>
(dans cet ordre) avant celui de l'extension <ctanpkg:doclicense>. Sans cela, 
l'extension <ctanpkg:doclicense> génère une erreur de compilation 
"Package hyperxmp Error: hyperref must be loaded before hyperxmp" 
(il s'agit d'une [erreur remontée au développeur](https://github.com/ypid/latex-packages/issues/111)).


:::{sources}
- [Inserting a Creative Commons Licence into a LaTeX document](https://tex.stackexchange.com/q/117597),
  sur [Tex Stack Exchange](https://tex.stackexchange.com/)
:::