#include "cpascal.h"
#include "parser.h"

void
lex_error_0(string fmt)
{
    fprintf(stderr, "line %d (lexing): ", line_number);
    fprintf(stderr, fmt);
    fprintf(stderr, "\n");
}

void
lex_error_1(string fmt, int item)
{
    fprintf(stderr, "line %d (lexing): ", line_number);
    fprintf(stderr, fmt, item);
    fprintf(stderr, "\n");
}

void
lex_error_s(string fmt, string item)
{
    fprintf(stderr, "line %d (lexing): ", line_number);
    fprintf(stderr, fmt, item);
    fprintf(stderr, "\n");
}

void
lex_error_s_1(string fmt, string item, int item1)
{
    fprintf(stderr, "line %d (lexing): ", line_number);
    fprintf(stderr, fmt, item, item1);
    fprintf(stderr, "\n");
}

void
fatal_error_0(string fmt)
{
    fprintf(stderr, "line %d (fatal): ", line_number);
    fprintf(stderr, fmt);
    fprintf(stderr, "\n");
    exit(1);
}

void
fatal_error_1(string fmt, int item)
{
    fprintf(stderr, "line %d (fatal): ", line_number);
    fprintf(stderr, fmt, item);
    fprintf(stderr, "\n");
    exit(1);
}

void
fatal_error_s(string fmt, string  item)
{
    fprintf(stderr, "line %d (fatal): ", line_number);
    fprintf(stderr, fmt, item);
    fprintf(stderr, "\n");
    exit(1);
}

void
yyerror(string fmt)
{
    fprintf(stderr, "line %d (parsing): ", line_number);
    fprintf(stderr, fmt);
    fprintf(stderr, "\n");
}


void
warning_0(string fmt)
{
    fprintf(stderr, "line %d (warning): ", line_number);
    fprintf(stderr, fmt);
    fprintf(stderr, "\n");
}

void
warning_1(string fmt, int item)
{
    fprintf(stderr, "line %d (warning): ", line_number);
    fprintf(stderr, fmt, item);
    fprintf(stderr, "\n");
}

void
warning_2(string fmt, int item, int item2)
{
    fprintf(stderr, "line %d (warning): ", line_number);
    fprintf(stderr, fmt, item, item2);
    fprintf(stderr, "\n");
}

void
warning_s_1(string fmt, string item, int item1)
{
    fprintf(stderr, "line %d (warning): ", line_number);
    fprintf(stderr, fmt, item, item1);
    fprintf(stderr, "\n");
}

void
warning_s_2(string fmt, string item, int item1, int item2)
{
    fprintf(stderr, "line %d (warning): ", line_number);
    fprintf(stderr, fmt, item, item1, item2);
    fprintf(stderr, "\n");
}

void
internal_error_0(string fmt)
{
    fprintf(stderr, "line %d (internal): ", line_number);
    fprintf(stderr, fmt);
    fprintf(stderr, "\n");
    exit(1);
}

void
internal_error_1(string fmt, int item)
{
    fprintf(stderr, "line %d (internal): ", line_number);
    fprintf(stderr, fmt, item);
    fprintf(stderr, "\n");
    exit(1);
}

void
internal_error_s(string fmt, string item)
{
    fprintf(stderr, "line %d (internal): ", line_number);
    fprintf(stderr, fmt, item);
    fprintf(stderr, "\n");
    exit(1);
}
