% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xc_index.R
\name{xc_index}
\alias{xc_index}
\title{xc_index - Category-adjusted Expertise (x-) Index}
\usage{
xc_index(df, kw, cat, id, cit, type = "h", dlm = c(";", ";"), plot = FALSE)
}
\arguments{
\item{df}{Data frame object containing bibliometric data. This data frame
must have at least three columns: one for keywords, one for unique IDs,
and one for citation counts. Each row in the data frame should represent
a document or publication.}

\item{kw}{Character string specifying the name of the column in "df" that
contains keywords. Each cell in this column may contain no keywords (missing),
a single keyword or multiple keywords separated by a specified delimiter.}

\item{cat}{Character string specifying the name of the column in "df" that
contains categories. Each cell in this column may contain no categories
(missing), a single category or multiple categories separated by a specified
delimiter.}

\item{id}{Character string specifying the name of the column in "df" that
contains unique identifiers for each document. Each cell in this column must
contain a single ID (unless missing) and not multiple IDs.}

\item{cit}{Character string specifying the name of the column in "df" that
contains the number of citations each document has received. Citations must
be represented as integers. Each cell in this column should contain a single
integer value (unless missing) representing the citation count for the
corresponding document.}

\item{type}{"h" (default) for Hirsch's h-type index or "g" for Egghe's g-type index.
Default set to "h".}

\item{dlm}{Character vector specifying the delimiter used in the "kw" and
"cat" columns to separate multiple keywords and categories within a single cell.
The delimiter should be consistent across the entirety of the two columns. The
first element in the vector is used as the delimiter for keywords, while the second element
is used for categories. Common delimiters include ";", "/", ":", and ",", and example usage
should be similar to 'c(";", ";")' (default), 'c(";", ",")', or 'c(",", ":")'.}

\item{plot}{Logical value indicating whether to generate and display a plot
of the xc-index calculation. Set to "TRUE" or "T" to generate the plot, and
"FALSE" (default) or "F" to skip plot generation.}
}
\value{
xc-index magnitude, core category specific keywords and optional plot.
}
\description{
Calculate the xc-index for an institution using bibliometric data from an
edge list, with an optional plot visualisation. The function is suitable
for including inside loops when plotting parameter is set to "FALSE" or "F".
}
\examples{
# Load example data
data(WoSdata)

# Calculate xc-index with plot
xc_index(df = WoSdata,
         id = "UT.Unique.WOS.ID",
         kw = "Keywords.Plus",
         cat = "WoS.Categories",
         cit = "Times.Cited.WoS.Core",
         plot = TRUE)

}
