% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{make_plpr_data}
\alias{make_plpr_data}
\title{Simulated Data Frame}
\usage{
make_plpr_data(n_obs = 500, t_per = 10, dim_x = 20, theta = 0.5, rho = 0.8)
}
\arguments{
\item{n_obs}{(\code{integer(1)}) \cr
The number of cross-sectional observations (i) to simulate.}

\item{t_per}{(\code{integer(1)}) \cr
The number of time periods (t) to simulate.}

\item{dim_x}{(\code{integer(1)}) \cr
The number of covariates.}

\item{theta}{(\code{numeric(1)}) \cr
The value of the causal parameter.}

\item{rho}{(\code{numeric(1)}) \cr
Parameter governing the relationship between the covariates and the unobserved
individual heterogeneity. The value is chosen between 0 (pure random effect)
and 1 (pure fixed effects).}
}
\value{
A data object.
}
\description{
Generates data from a partially linear regression model for panel data with fixed effects
similar to DGP3 (highly nonlinear) in Clarke and Polselli (2025).

The data generating process is defined as

\eqn{Y_{it} = \theta D_{it} + g_0(X_{it}) + \alpha_i + U_{it},}
\eqn{D_{it} = m_0(X_{it}) + \gamma_i + V_{it},}

where \eqn{U_{it} \sim \mathcal{N}(0,1)}, \eqn{V_{it}  \sim \mathcal{N}(0,1)},
\eqn{\alpha_i = \rho A_i + \sqrt{1-\rho^2} B_i} with
\eqn{A_i\sim \mathcal{N}(3,3)}, \eqn{B_i\sim \mathcal{N}(0,1)}, and  \eqn{\gamma_i\sim \mathcal{N}(0,5)}.

The covariates are distributed as \eqn{X_{it,p} \sim A_i + \mathcal{N}(0, 5)},
where \eqn{p} is the number of covariates.

The nuisance functions are given by

\eqn{m_0(X_{it}) = a_1 [X_{it,1} \times 1(X_{it,1}>0)] + a_2 [X_{it,1} \times X_{it,3}],}
\eqn{g_0(X_{it}) = b_1 [X_{it,1} \times X_{it,3}] + b_2 [X_{it,3} \times 1(X_{it,3}>0)],}

with \eqn{a_1=b_2=0.25} and \eqn{a_2=b_1=0.5}.
}
\examples{
df = make_plpr_data(n_obs = 500, t_per = 10, dim_x = 20, theta = 0.5, rho=0.8)

}
\references{
Clarke, P. S. and Polselli,  A. (2025). Double Machine Learning
for Static Panel Models with Fixed Effects. Econometrics Journal.
DOI: 10.1093/ectj/utaf011.
}
