% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predxhaz_list.R
\name{plot.predxhaz_list}
\alias{plot.predxhaz_list}
\title{Plot predictions from several xhaz models (two-panel display)}
\usage{
\method{plot}{predxhaz_list}(
  x,
  left = c("hazard", "survival"),
  right = c("survival", "hazard"),
  col = NULL,
  lty_by_group = NULL,
  legend_model_pos = c("top", "none"),
  legend_group_pos = "topright",
  ylim_left = NULL,
  ylim_right = NULL,
  grid = TRUE,
  step = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{predxhaz_list}.}

\item{left, right}{Which metrics to display: "hazard" or "survival".}

\item{col}{Named colors for models (names = model names). Auto if NULL.}

\item{lty_by_group}{Line types for subgroups (recycled). Auto if NULL.}

\item{legend_model_pos}{"top" (outside, shared) or "none".}

\item{legend_group_pos}{Inside-panel legend position (e.g., "topright") or "none".}

\item{ylim_left, ylim_right}{Numeric y-limits (auto if NULL).}

\item{grid}{Logical; add \code{graphics::grid()} in panels.}

\item{step}{NULL = auto (step for hazard when baseline == "constant"),
TRUE/FALSE to force.}

\item{...}{Passed to the initial \code{graphics::plot()} in each panel
(e.g., xlab, ylab, xlim).}
}
\value{
Invisibly returns \code{x}.
}
\description{
This method plots a \code{predxhaz_list} object, i.e. multiple prediction
objects (typically one per model and per subgroup), using two panels
(left/right) for \code{"survival"} and/or \code{"hazard"}.
}
\examples{
\dontrun{
## --- Single-model predictions (predxhaz) ---
data("simuData", package = "xhaz")
library(survival)
fit1 <- xhaz(Surv(time_year, status) ~ agec + race,
             data = simuData,
             ratetable = survexp.us,
             interval = c(0, NA, NA, NA, NA, NA, max(simuData$time_year)),
             rmap = list(age = "age", sex = "sex", year = "date"),
             baseline = "constant", pophaz = "classic")

fit2 <- xhaz(Surv(time_year, status) ~ agec + race,
             data = simuData,
             ratetable = survexp.us,
             interval = c(0, NA, NA, max(simuData$time_year)),
             rmap = list(age = "age", sex = "sex", year = "date"),
             baseline = "bsplines", pophaz = "classic")

tgrid <- seq(0, 4, 0.1)
d1 <- simuData[1,]
px1 <- predict(fit1, new.data = d1, times.pts = tgrid, baseline = FALSE)
px2 <- predict(fit2, new.data = d1, times.pts = tgrid, baseline = FALSE)

pl <- pred_list(constant = px1, bsplines = px2)

# Two-panel plot (left/right)
plot(pl,
     left = "survival", right = "hazard",
     xlab = "Time (years)",
     ylim_left = c(0, 1))
}
}
