% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ljungbox.R
\name{GetResiduals}
\alias{GetResiduals}
\title{Extract Residuals from ARIMA, VAR, or any Simulated Fitted Time Series Model}
\usage{
GetResiduals(obj)
}
\arguments{
\item{obj}{a fitted time-series model with class "ar", "arima0", "Arima",
("ARIMA forecast ARIMA Arima"), "lm", ("glm" "lm"), "varest", or "list".}
}
\value{
List of order of fitted time series model and residuals from this model.
}
\description{
This utility function is useful to use in the portmanteau functions,
BoxPierce, MahdiMcLeod, Hosking, LiMcLeod, LjungBox, and portest.
GetResiduals() function takes a fitted time-series object with class "ar",
"arima0", "Arima", ("ARIMA forecast ARIMA Arima"), "lm", ("glm" "lm"),
"varest", or "list". and returns the residuals and the order from the fitted
object.

This method and the bottom documentation is taken directly from the original
'portes' package.
}
\examples{
fit <- arima(Nile, c(1, 0, 1))
GetResiduals(fit)

}
\author{
Esam Mahdi and A.I. McLeod.
}
