% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worcs_project.R
\name{worcs_project}
\alias{worcs_project}
\title{Create new WORCS project}
\usage{
worcs_project(
  path = "worcs_project",
  manuscript = "APA6",
  preregistration = "cos_prereg",
  add_license = "ccby",
  use_renv = TRUE,
  use_targets = FALSE,
  remote_repo = "https",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{path}{Character, indicating the directory in which to create the
'worcs' project. Default: 'worcs_project'.}

\item{manuscript}{Character, indicating what template to use for the
'R Markdown' manuscript. Default: 'APA6'. Available choices include
\code{APA6} from the \code{papaja} package,
a \code{\link[rmarkdown]{github_document}}, and templates included in the
\code{\link[rticles:rticles]{rticles}} package.
For more information, see \code{\link{add_manuscript}}.}

\item{preregistration}{Character, indicating what template to use for the
preregistration. Default: 'cos_prereg'. Available choices include:
\code{"PSS", "Secondary", "None"}, and all templates from the
\code{\link[prereg:prereg]{prereg}} package. For more information, see
\code{\link{add_preregistration}}.}

\item{add_license}{Character, indicating what license to include.
Default: 'ccby'. Available options include:
\code{c("cc0", "ccby", "gpl", "gpl3", "agpl", "agpl3", "apache", "apl2",
"lgpl", "mit", "proprietary", "None"}. For more information, see
\code{\link[usethis]{use_cc0_license}}.}

\item{use_renv}{Logical, indicating whether or not to use 'renv' to make the
project reproducible. Default: TRUE. See \code{\link[renv]{init}}.}

\item{use_targets}{Logical, indicating whether or not to use 'targets' to
create a Make-like pipeline.
Default: FALSE See \code{\link[targets]{targets-package}}.}

\item{remote_repo}{Character, URL of, or name for, the remote repository for
this project. If a URL of an existing repository is specified, it should have
the form
\code{https://github.com[username][repo].git} (preferred) or
\code{git@[...].git} (if using SSH).
Alternatively, a name for a new repository can be provided. If a 'GitHub'
user is authenticated on your device, this repository will be created on your
account.
Finally, a commit will
be made containing the 'README.md' file, and will be pushed to the remote
repository. Default: 'https', which results in no repository being created.}

\item{verbose}{Logical. Whether or not to print messages to the console
during project creation. Default: TRUE}

\item{...}{Additional arguments passed to and from functions.}
}
\value{
No return value. This function is called for its side effects.
}
\description{
Creates a new 'worcs' project. This function is invoked by
the 'RStudio' project template manager, but can also be called directly to
create a WORCS project through syntax or the console.
}
\examples{
the_test <- "worcs_template"
old_wd <- getwd()
dir.create(file.path(tempdir(), the_test))
do.call(git_user, worcs:::get_user())
worcs_project(file.path(tempdir(), the_test, "worcs_project"),
              manuscript = "github_document",
              preregistration = "None",
              add_license = "None",
              use_renv = FALSE,
              remote_repo = "https")
setwd(old_wd)
unlink(file.path(tempdir(), the_test))
}
