% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibi_analysis_old.R
\name{ibi_analysis_old}
\alias{ibi_analysis_old}
\title{IBI analysis (Old version)}
\usage{
ibi_analysis_old(IBI)
}
\arguments{
\item{IBI}{IBI data, a dataframe with columns including DateTime and seconds since the start
of the recording. This data can be read with read with \code{\link{read_e4}}}
}
\value{
A list containing time analysis, frequency analysis (commented out in this version),
and a summary of the results including time domain measures (SDNN, pNN50, etc.), 
frequency domain measures (HF, LF, LFHF, etc.), and the number of original and accepted beats.
}
\description{
This function is the older version of IBI (interbeat interval) analysis. It has been replaced by 
 \code{\link{ibi_analysis}}. This version remains available for compatibility, but we want to deprecate
 the function in future versions of the package. 
 
 This function analyzes IBI data, focusing on time and frequency domain measures.
 Note that the function imports functions from the RHRV package for HRV (Heart Rate Variability)
 analysis. Also note that measurements on the wrist are now more often referred to as PRV (Pulse
 Rate Variability), see for instance
  https://jphysiolanthropol.biomedcentral.com/articles/10.1186/s40101-020-00233-x.
}
\details{
The function performs several steps in analyzing IBI data:
1. Create an HRV data structure using RHRV.
2. Filter and preprocess the data, including handling of missing values and erroneous readings.
3. Perform time domain and frequency domain analyses.
4. Return a comprehensive list of results, including statistical summaries of the HRV measures.
}
\note{
This function is deprecated and will be removed in future versions. Users should migrate to 
      \code{\link{ibi_analysis}} for ongoing and future analyses.
}
\examples{
\dontrun{
zip_path <- system.file("extdata", "1635148245_A00204.zip", package = "wearables")
Assuming "IBI_data" is your interbeat interval data
result <- read_e4("path to your file") 
print(result$IBI)
}

}
\seealso{
\code{\link{ibi_analysis}} for the current version of IBI analysis.
}
