% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overimp.R
\name{overimp}
\alias{overimp}
\title{Overimpute main function}
\usage{
overimp(
  data,
  m = 5,
  p = 0.2,
  test_ratio = 0,
  method = "mixgb",
  seed = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame with missing values.}

\item{m}{The number of imputation.}

\item{p}{The extra proportion of missing values.}

\item{test_ratio}{The proportion of test set. Default is 0, meaning no test set.}

\item{method}{Can be one of the following: "mixgb","mice", and more in the future.}

\item{seed}{Random seed.}

\item{...}{Other arguments to be passed into the overimp function.}
}
\value{
An \code{overimp} object containing imputed training, test data (if applicable) and essential parameters required for plotting.
}
\description{
Overimp main function to call different imputation methods.
}
\examples{
obj <- overimp(data = nhanes3, m = 3, p = 0.2, test_ratio = 0.2, method = "mixgb")
}
