% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedmatrix.R
\name{compact_ped_for_matrix}
\alias{compact_ped_for_matrix}
\title{Compact pedigree by merging full siblings for matrix calculation}
\usage{
compact_ped_for_matrix(ped)
}
\arguments{
\item{ped}{A tidyped object or pedigree data.}
}
\value{
A list containing:
\itemize{
  \item \code{ped_compact}: The compacted pedigree (tidyped object)
  \item \code{compact_map}: Individual-level mapping table
  \item \code{family_summary}: Family-level summary table
  \item \code{compact_stats}: Compression statistics
}
}
\description{
This internal function identifies full siblings (individuals sharing the same
sire and dam) and selects one representative per family. This can dramatically
reduce memory requirements when calculating relationship matrices for pedigrees
with large full-sibling families.
}
\keyword{internal}
