% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc_outcome.R
\name{desc_outcome}
\alias{desc_outcome}
\title{Outcome descriptive}
\usage{
desc_outcome(.data, drug_s = "drug1", adr_s = "adr1")
}
\arguments{
\item{.data, }{An \code{adr} data.table. See \code{\link{adr_}}}

\item{drug_s}{A character vector, the drug column(s)}

\item{adr_s}{A character vector, the adverse drug reaction column(s).}
}
\value{
A data.table with one row per drug-adr pair.
\itemize{
\item \code{drug_s} and \code{adr_s}, same as input
\item \code{n_cas}, number of cases for each category
\item \code{out_label}, the worst outcome for this drug-adr pair
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Compute
outcome description over a set of adr and drugs.
}
\details{
You need an \code{adr} data.table.
Be careful that you cannot directly filter \code{adr} data.table on drugs!
You first have to add drug columns to \code{adr}, with \code{\link[=add_drug]{add_drug()}}.
The function reports the worst outcome into consideration for a given case,
if many are reported.
Outcomes, from best to worst are:
\itemize{
\item Recovered/resolved
\item Recovering/resolving
\item Recovered/resolved with sequelae
\item Not recovered/not resolved
\item Fatal
\item Died- unrelated to reaction
\item Died- reaction may be contributory
}
See \code{vignette("descriptive")} for more details.
}
\examples{

adr_ <-
  adr_ |>
  add_drug(
    d_code = ex_$d_groups_drecno,
    drug_data = drug_
  ) |>
  add_adr(
    a_code = ex_$a_llt,
    adr_data = adr_
  )

desc_outcome(
  adr_,
  drug_s = "pd1",
  adr_s = "a_colitis"
  )

# you can vectorize over multiple adrs and drugs

desc_outcome(
  adr_,
  drug_s = c("pd1", "pdl1"),
  adr_s = c("a_colitis", "a_pneumonitis")
  )
}
\seealso{
\code{\link{adr_}}, \code{\link[=add_drug]{add_drug()}}, \code{\link[=add_adr]{add_adr()}}
}
\keyword{descriptive}
\keyword{drug-adr-pair}
