% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{troponin_precision}
\alias{troponin_precision}
\title{High-Sensitivity Cardiac Troponin I Precision Dataset}
\format{
A data frame with 120 rows and 6 variables:
\describe{
\item{level}{Concentration level factor (L1-L6)}
\item{day}{Day of measurement (D1-D5)}
\item{run}{Run within day (R1-R2)}
\item{replicate}{Replicate within run (1-2)}
\item{value}{Measured concentration (ng/L)}
\item{target}{Nominal target concentration (ng/L)}
}
}
\source{
Synthetic data generated to mimic realistic precision patterns. See
\code{data-raw/make_troponin_precision.R} for the generation script.
}
\usage{
troponin_precision
}
\description{
Synthetic dataset for evaluating precision of a high-sensitivity cardiac
troponin I (hs-cTnI) assay across multiple concentration levels. The data
is designed for demonstrating precision studies with variance component
analysis and precision profile estimation.
}
\details{
This synthetic dataset simulates a multi-level precision study for a
high-sensitivity cardiac troponin I assay. The data characteristics:

\itemize{
\item \strong{Concentration levels}: 5, 10, 25, 50, 100, 500 ng/L
\item \strong{Design}: 5 days x 2 runs x 2 replicates per level (EP05-style)
\item \strong{Total observations}: 120 (6 levels x 20 measurements each)
\item \strong{Precision pattern}: CV decreases with concentration following
a hyperbolic relationship
}

The precision profile follows the model:
\deqn{CV = \sqrt{a^2 + (b/x)^2}}

where approximately:
\itemize{
\item \eqn{a \approx 3\%} (asymptotic CV at high concentrations)
\item \eqn{b \approx 25} (concentration-dependent component)
}

This gives expected CVs of approximately:
\itemize{
\item 5 ng/L: ~5.5\%
\item 10 ng/L: ~3.5\%
\item 25 ng/L: ~3.0\%
\item 50 ng/L: ~2.0\%
\item 100 ng/L: ~2.0\%
\item 500 ng/L: ~3.5\%
}
}
\section{Clinical Context}{

High-sensitivity cardiac troponin assays are used to diagnose acute
myocardial infarction (AMI). Key clinical decision points include:
\itemize{
\item 99th percentile upper reference limit (URL): typically 14-26 ng/L
\item Functional sensitivity (CV <= 10\%): should be <= 50\% of 99th percentile
\item Precision at low concentrations is critical for early AMI detection
}
}

\examples{
# Load the dataset
data(troponin_precision)
head(troponin_precision)

# Precision study with multiple concentration levels
prec <- precision_study(
  data = troponin_precision,
  value = "value",
  sample = "level",
  day = "day",
  run = "run"
)
print(prec)

# Results for each concentration level
names(prec$by_sample)

# Generate precision profile
profile <- precision_profile(prec, cv_targets = c(10, 20))
print(profile)
plot(profile)

# Functional sensitivity at 10\% CV
profile$functional_sensitivity

}
\seealso{
\code{\link[=precision_study]{precision_study()}} for variance component analysis,
\code{\link[=precision_profile]{precision_profile()}} for CV-concentration modeling,
\link{glucose_methods}, \link{creatinine_serum}, \link{troponin_cardiac}
}
\keyword{datasets}
