#' @keywords internal
#' @importFrom stats pnorm setNames
#' @importFrom utils combn
computeOutput <- function(unified) {
  output = setNames(data.frame(matrix(NA, ncol = 6, nrow = 1)), c("z", "IQ", "T", "SW", "C", "PR"))
  std_M = c(0, 100, 50, 100, 5)
  std_SD = c(1, 15, 10, 10, 2)
  output[1, 1:5] = round(std_M + std_SD * unified, 4)
  output[1, 6] = round(pnorm(unified) * 100, 4)
  return(output)
}
