% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspredbench.R
\docType{data}
\name{stocks}
\alias{stocks}
\title{IBOVESPA's 50 Most Traded Stocks}
\format{
A list of dataframes containing time series.
}
\source{
\href{https://www.b3.com.br}{B3}
}
\usage{
data(stocks)
}
\description{
Historical daily data for the 50 most traded stocks in B3 (IBOVESPA),
including opening, high, low, and closing prices, as well as trading volume.
Data Type: Financial Time Series. Category: Finance. Creation Date: 2025.
}
\details{
Each entry is a data frame with columns \code{date}, \code{open}, \code{high}, \code{low}, \code{close}, and \code{volume}.
}
\examples{
# Load stocks list and plot closing prices for a ticker (if present)
data(stocks)
# stocks <- loadfulldata(stocks)
if ("VALE3" \%in\% names(stocks)) {
  series <- stocks$VALE3$close
  ts.plot(series, ylab = "Close", xlab = "Index", main = "VALE3 close price")
}
}
\references{
B3 - Brasil, Bolsa, Balcão. 2025. Historical stock trading data.
\href{https://www.b3.com.br}{B3 Official Website}
}
\keyword{datasets}
