% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspredbench.R
\docType{data}
\name{EUNITE.Loads}
\alias{EUNITE.Loads}
\title{EUNITE Competition – Half-Hourly Electrical Loads}
\format{
A data frame with 730 rows and 48 numeric columns. Each column corresponds to one half-hour interval, from 00:00 to 24:00.
}
\source{
EUNITE Competition 2001 dataset (original competition website currently unavailable).
}
\usage{
data(EUNITE.Loads)
}
\description{
Half-hourly electrical load time series from the EUNITE forecasting competition.
Data Type: Electrical load measurements. Category: Benchmark. Observations: 730 days, 48 intervals per day.
This dataset contains univariate time series with half-hour resolution covering 1997–1998. It was used to forecast daily maximum loads in January 1999.
Competitors were evaluated using MAPE and MAXIMAL prediction errors. Regressors such as temperature and calendar variables were also provided.
}
\details{
The EUNITE competition focused on forecasting maximum daily electrical loads for January 1999 using
half-hourly load profiles and auxiliary regressors. Series are provided in a wide format with 48
half-hour intervals as columns.
}
\examples{
# Load the dataset
data(EUNITE.Loads)
# EUNITE.Loads <- loadfulldata(EUNITE.Loads)

# Inspect the first few half-hourly columns (00:00 to 24:00 by 30 minutes)
head(names(EUNITE.Loads))

# Plot a single half-hour interval across days
ts.plot(EUNITE.Loads[["X24.00"]], ylab = "Load (MW)", xlab = "Day",
        main = "EUNITE: Half-hour interval 24:00")
}
\references{
Chen, B.-J., Chang, M.-W., & Lin, C.-J. (2004). \emph{Load forecasting using support vector machines: a study on EUNITE competition 2001}. IEEE Transactions on Power Systems, 19(4), 1821-1830.
}
\keyword{benchmark}
\keyword{datasets}
